use v6;
use Semi-xml;
use TMap::TopicName;
use TMap::Occurrence;

package TMap:ver<0.2.0> {

  role Topic {
    has Str @.subject-locators;                 # Fig 1, ...
    has Str @.subject-identifiers;              # Fig 1, ...
    has Str @.instances-of;                     # Fig 1, ...
    
    has Hash $.reified;                         # Fig 1, ...

    has $.tm-parent;                            # Fig 2, ...

    #---------------------------------------------------------------------------
    #
    method initialize (  ) {

      # Set item identifiers
      #
      self.check-item-identifiers;

      # Process name of topic and some locators
      #
      for self.nodes -> $node {
        if $node ~~ XML::Element {

          given $node.name {

            when 'subjectLocator' {
say "Subject locator of {self.attribs<id>}: {$node.attribs<href>}";
              @!subject-locators.push($node.attribs<href>)
                  if ?$node.attribs<href>;
            }

            when 'subjectIdentifier' {
say "Subject identifier of {self.attribs<id>}: {$node.attribs<href>}";
              @!subject-identifiers.push($node.attribs<href>)
                  if ?$node.attribs<href>;
            }

            when 'instanceOf' {
              my @trefs = self.get-topic-references($node);
#              @!instances-of.push(@refs);
              for @trefs -> $tref {
                my $instance-of = self.get-topic-from-id($tref);
                if ?$instance-of {
say "{self.attribs<id>} is instance of {$instance-of.attribs<id>}";
                  @!instances-of.push($tref);
                }
              }
            }

            when 'name' {
              $node does TMap::TopicName;
              my TMap::TopicName $name := $node;
              $name.initialize(self);
            }

            when 'occurrence' {
              $node does TMap::Occurrence;
              my TMap::Occurrence $occurrence := $node;
              $occurrence.initialize(self);
            }
          }
        }
      }
    }

    #---------------------------------------------------------------------------
    #
    method set-parent ( $parent ) {
      $!tm-parent = $parent;
    }

    #---------------------------------------------------------------------------
    #
    method get-topic-from-id ( Str $id --> TMap::Topic ) {
      return $!tm-parent.get( 'topic', $id);
    }

    #---------------------------------------------------------------------------
    # Some getters
    #
    multi method get ( 'topicmap' ) { return $!tm-parent; }
  }
}
