Description
===========

`Async::Command::Multi` starts multiple Async::Command instances
with method `sow()`. It awaits all sown promises and returns a
HASH of `Async::Command::Result` objects with method `reap()`.

Synopsis
========

    use Async::Command::Multi;

    my %command;
    %command<key1> = <command1>;
    %command<key2> = <command2 -c2>;
    ...
    %command<keyN> = <commandN --cN>;

    my $command-manager = Async::Command::Multi.new(:%command, :2timeout);
    $command-manager.sow;                   # start promises
    # do other things...
    my %result = $command-manager.reap;     # await promises

    # examine $*OUT from each successfully kept promise
    for %result.keys -> $key {
        printf("[%s] %s:\n", %result{$key}.is-success ?? '+' !! '-', $key);
        .say for %result{$key}.stdout-results;
    }

Methods
=======

new()
-----

_Named Parameters_

`%command`

    - HASH keys are utilized by `Async::Command` to maintain associations.
    - HASH values are independent commands to execute.

`$timeout`

Global timer for each promise, in seconds. No individual promise should take
longer than this number of seconds to complete its thread.

sow()
-----

Start promises.

reap()
------

Await promises. Return a HASH of `Async::Command::Return` objects.

Example
=======

Given:

    #!/usr/bin/env perl6
    use Async::Command::Multi;
    my %command;
    %command<ctools> = <ssh ctools uname -n>;
    %command<jtools> = <ssh jtools notarealcommand>;
    dd $ = Async::Command::Multi.new(:%command, :1timeout).sow.reap;

Output:

    Hash $ = ${
        :ctools(Async::Command::Result.new(
            command => ["ssh", "ctools", "uname", "-n"],
            exitcode => 0,
            stdout-results => "CTUNIXVMADMINPv\n",
            stderr-results => "",
            timed-out => Bool::False,
            unique-id => "ctools")),
        :jtools(Async::Command::Result.new(
            command => ["ssh", "jtools", "notarealcommand"],
            exitcode => 127,
            stdout-results => "",
            stderr-results => "sh: notarealcommand: command not found\n",
            timed-out => Bool::False,
            unique-id => "jtools"))
    }

See `Async::Command::Result` for accessor methods of the HASH values returned by `reap()`.
