
package ZCS::Admin::Elements::SearchDirectoryRequest;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'urn:zimbraAdmin' }

__PACKAGE__->__set_name('SearchDirectoryRequest');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS = 'ZCS::Admin::Elements::SearchDirectoryRequest::XmlAttr';

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %query_of :ATTR(:get<query>);

__PACKAGE__->_factory(
    [ qw(        query

    ) ],
    {
        'query' => \%query_of,
    },
    {
        'query' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'query' => 'query',
    }
);

} # end BLOCK




package ZCS::Admin::Elements::SearchDirectoryRequest::XmlAttr;
use base qw(SOAP::WSDL::XSD::Typelib::AttributeSet);

{ # BLOCK to scope variables

my %limit_of :ATTR(:get<limit>);
my %offset_of :ATTR(:get<offset>);
my %domain_of :ATTR(:get<domain>);
my %applyCos_of :ATTR(:get<applyCos>);
my %maxResults_of :ATTR(:get<maxResults>);
my %attrs_of :ATTR(:get<attrs>);
my %sortBy_of :ATTR(:get<sortBy>);
my %sortAscending_of :ATTR(:get<sortAscending>);
my %types_of :ATTR(:get<types>);

__PACKAGE__->_factory(
    [ qw(
        limit
        offset
        domain
        applyCos
        maxResults
        attrs
        sortBy
        sortAscending
        types
    ) ],
    {

        limit => \%limit_of,

        offset => \%offset_of,

        domain => \%domain_of,

        applyCos => \%applyCos_of,

        maxResults => \%maxResults_of,

        attrs => \%attrs_of,

        sortBy => \%sortBy_of,

        sortAscending => \%sortAscending_of,

        types => \%types_of,
    },
    {
        limit => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        offset => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        domain => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        applyCos => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        maxResults => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        attrs => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        sortBy => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        sortAscending => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        types => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    }
);

} # end BLOCK


} # end of BLOCK



1;


=pod

=head1 NAME

ZCS::Admin::Elements::SearchDirectoryRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
SearchDirectoryRequest from the namespace urn:zimbraAdmin.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * query

 $element->set_query($data);
 $element->get_query();





=back


=head1 METHODS

=head2 new

 my $element = ZCS::Admin::Elements::SearchDirectoryRequest->new($data);

Constructor. The following data structure may be passed to new():

 {
   query =>  $some_value, # string
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

