use strict;
use warnings FATAL => 'all';
use Test::More tests => 3;
use constant EPS => 1e-3;
use Statistics::Data;
use Array::Compare;

BEGIN {
    use_ok( 'Statistics::Data' ) || print "Bail out!\n";
}

my $dat = Statistics::Data->new();

my $cmp_aref = Array::Compare->new;

$dat->load(morphine => [1, 2, 3], love => [2013, 1984, 1999]);
my $ret = $dat->labels();
ok(scalar @{$ret} == 2, "Error in getting data labels(): expected 2; got " . scalar @{$ret} );
#ok( equal( $val, $sor{$lab} ), "sum-of-ranks for $lab $val != $sor{$lab}" );
ok( 
    $cmp_aref->simple_compare(
        [sort {$a cmp $b} @{$ret}],
        [qw/love morphine/]
    ),
    'Error getting data labels(); expected <love morphine>; got '. join(' ',@{$ret}) 
    );

sub about_equal {
    return 0 if ! defined $_[0] || ! defined $_[1];
    return 1 if $_[0] + EPS > $_[1] and $_[0] - EPS < $_[1];
    return 0;
}

1;
