; Wb-tree File Based Associative String Data Base System.
; Copyright (c) 1991, 1992, 1993 Holland Mark Martin
;
;Permission to use, copy, modify, and distribute this software and its
;documentation for educational, research, and non-profit purposes and
;without fee is hereby granted, provided that the above copyright
;notice appear in all copies and that both that copyright notice and
;this permission notice appear in supporting documentation, and that
;the name of Holland Mark Martin not be used in advertising or
;publicity pertaining to distribution of the software without specific,
;written prior consent in each case.  Permission to incorporate this
;software into commercial products can be obtained from Jonathan
;Finger, Holland Mark Martin, 174 Middlesex Turnpike, Burlington, MA,
;01803-4467, USA.  Holland Mark Martin makes no representations about
;the suitability or correctness of this software for any purpose.  It
;is provided "as is" without express or implied warranty.  Holland Mark
;Martin is under no obligation to provide any services, by way of
;maintenance, update, or otherwise.

(require (in-vicinity (program-vicinity) "sys"))

;;; PERFORMANCE STATISTICS

(define next-ct #f)
(define next-fct #f)
(define prev-ct #f)
(define prev-fct #f)
(define get-ct #f)
(define get-fct #f)
(define put-ct #f)
(define put-fct #f)
(define rem-ct #f)
(define rem-fct #f)
(define ge-ct #f)
(define ge-fct #f)
(define tge-ct #f)
(define tge-fct #f)
(define tce-ct #f)
(define tce-fct #f)

(define chains-to-next #f)		; counters for special-case occurrences
(define deferred-inserts #f)
(define split-index-inserts #f)
(define index-screw-case  #f)
(define block-splits #f)
(define block-deletes #f)
(define deferred-deletes #f)
(define dir-dty-ct #f)

(define read-ct #f)			; buffer i/o counters
(define write-ct #f)
(define read-fl-ct #f)
(define write-fl-ct #f)
(define flush-ct #f)

(define (clear-stats)
  (set! next-ct 0)
  (set! next-fct 0)
  (set! prev-ct 0)
  (set! prev-fct 0)
  (set! get-ct 0)
  (set! get-fct 0)
  (set! put-ct 0)
  (set! put-fct 0)
  (set! rem-ct 0)
  (set! rem-fct 0)
  (set! ge-ct 0)
  (set! ge-fct 0)
  (set! tge-ct 0)
  (set! tge-fct 0)
  (set! tce-ct 0)
  (set! tce-fct 0)

  (set! chains-to-next 0)
  (set! deferred-inserts 0)
  (set! split-index-inserts 0)
  (set! index-screw-case  0)
  (set! block-splits 0)
  (set! block-deletes 0)
  (set! deferred-deletes 0)
  (set! dir-dty-ct 0)

  (set! read-ct 0)
  (set! write-ct 0)
  (set! read-fl-ct 0)
  (set! write-fl-ct 0)
  (set! flush-ct 0)
  SUCCESS)

(define (cstats)
  (stats)
  (clear-stats))

(define (stats)
  (fprintf diagout "\\n" )
  (fprintf diagout "OPERATIONS SUMMARY:\\n" )
  (fprintf diagout
	   "            NEXT     PREV      GET      PUT      REM   GETENT   CACHE    CACHE\\n")
  (fprintf diagout
	   "                                                                AVAIL?   VALID?\\n")
  (fprintf diagout "   succ %8lu %8lu %8lu %8lu %8lu %8lu %8lu %8lu\\n"
	   next-ct prev-ct get-ct put-ct rem-ct ge-ct tge-ct tce-ct)
  (fprintf diagout "   fail %8lu %8lu %8lu %8lu %8lu %8lu %8lu %8lu\\n\\n"
	   next-fct prev-fct get-fct put-fct rem-fct ge-fct tge-fct tce-fct)

  (fprintf diagout "INTERNAL OPERATIONS SUMMARY:\\n" )
  (fprintf diagout "   chains-to-next = %d\\n" chains-to-next)
  (fprintf diagout "   %d block splits, %d deferred parent updates, %d undone\\n"
	   block-splits deferred-inserts  deferred-inserts)
  (fprintf diagout "   %d split index inserts; %d index-insert screw cases \\n"
	   split-index-inserts index-screw-case )
  (fprintf diagout "   %d block deletes; %d deferred block deletes\\n\\n"
	   block-deletes deferred-deletes)
  
  (fprintf diagout "I/O SUMMARY: %lu READS, %lu WRITES, %lu FLUSH (of dirty bufs) calls.\\n"
	   read-ct write-ct flush-ct)
  (fprintf diagout "             %lu FREELIST READS, %lu FREELIST WRITES.\\n"
	   read-fl-ct write-fl-ct)
  (fprintf diagout "             %lu DIRS LEFT DTY.\\n"
	   dir-dty-ct)
  (let ((ops (max (+ next-fct prev-fct get-fct put-fct rem-fct
		 next-ct prev-ct get-ct put-ct rem-ct ) 1)))
    (fprintf diagout "   AVG BLKS REFERENCED PER OPERATION: %7d%%\\n"
	   (quotient (* 100 (+ ge-ct tce-ct)) ops))
    (fprintf diagout "   AVG DISK I/Os PER OPERATION: %7d%%; "
	     (quotient (* 100 (+ read-ct write-ct read-fl-ct write-fl-ct)) ops))
    (fprintf diagout "   WRITE/READ RATIO: %7d%%\\n"
	     (quotient (* 100 (+ write-ct write-fl-ct)) (max 1 (+  read-ct read-fl-ct))))
    (if (> put-ct 0)
	(fprintf diagout "   AVG DISK WRITES PER PUT: %7d%%\\n"
		 (quotient (* 100 write-ct) put-ct)))
    )
  (fprintf diagout "\\n" )
  (fprintf diagout "MODES IN EFFECT:\\n" )
  (fprintf diagout "%d buffers [hashed over %d buckets]; blksize (max)=%d; FLC-LEN=%d\\n"
	   num-ents-ct NUM-BUKS blk-size FLC-LEN)
  (fprintf diagout "defer-insert-updates= %2s; defer-block-deletes=%2s\\n"
	   (if defer-insert-updates "#t" "#f") (if defer-block-deletes "#t" "#f") )
  (fprintf diagout "cache-ent-enable=%2s; clever-cache-enable=%2s\\n"
	   (if cache-ent-enable "#t" "#f") (if clever-cache-enable "#t" "#f") )
  (fprintf diagout "\\n" )
  SUCCESS)

(define (show-buffer! ent)
  (fprintf stderr "SEG = %d ID= %lu ACC= %d REF= %d DTY= %d AGE= %d\\n"
	   (ENT-SEG ent)(ENT-ID ent)(ENT-ACC ent)(ENT-REF ent)(ENT-DTY? ent)(ENT-AGE ent)))

(define buf-verbose #t)

(define (show-buffer-1 ent)
  (cond ((or buf-verbose (> (ENT-SEG ent) -1))
	 (fprintf stderr " %3d:%-6d %6lu %8d %6lu %7d %3d %4d"
		  (ENT-SEG ent) (ENT-ID ent) (HASH2INT (ENT-SEG ent) (ENT-ID ent)) (ENT-ACC ent)
		  (ENT-REF ent) 0 (ENT-DTY? ent) (ENT-AGE ent))
	 (if (> (ENT-SEG ent) -1)
	     (fprintf stderr " %5d %4c\\n"
		      (- (BLK-LEVEL (ENT-BLK ent)) LEAF)
		      (BLK-TYP (ENT-BLK ent)))
	     (fprintf stderr "\\n"))
	 ))
  SUCCESS)

(define (show-buffers)
  (fprintf diagout "\\n" )
  (fprintf diagout
	   " SEG:ID        BUK      ACC    REF READERS DTY  AGE LEVEL TYPE\\n")
  (do-seg-buffers -1 show-buffer-1))

(define (sb) (show-buffers))
