
# Return a version of 's' with all whitespace removed
proc despace {s} {
    set r ""
    foreach x [split $s " \t\r\n"] { append r $x }
    return $r
}

proc makeMenuBar {top desclist} {
    if {[set ilen [llength $desclist]]%2} {
	error "makeMenuBar: odd # of elements in menubuttonlist"
    }
    frame $top.mb -relief flat

    for {set i 0} {$i<$ilen} {} {
	set mbname $top.mb.[despace [lindex $desclist $i]]
	menubutton $mbname \
	    -font lucidasans-bold-12 \
	    -text [lindex $desclist $i] \
	    -menu $mbname.m
	pack append $top.mb $mbname {left}

	incr i 1
	set items [lindex $desclist $i]
	menu $mbname.m -font lucidasans-bold-12
	if {[set jlen [llength $items]]%3} {
	    error "makeMenuBar:wrong # of elements '$jlen' in $mbname menu list"
	}
	for {set j 0} {$j<$jlen} {} {
	    set lbl [lindex $items $j]
	    $mbname.m add [lindex $items [incr j 1]] \
		-label $lbl \
		-command  [lindex $items [incr j 1]]
	    incr j 1
	}

	incr i 1
	bindMenu $mbname.m
	bindMenubutton $mbname
    }
    return $top.mb
}
