/* Release 2.0 */
#include "stdio.h"
#include "ctype.h"
$include sqlca;
$include sqlda;
$include sqltypes;

/*

Functions provided by this interface

    int sql_database(char *dbname)
    int sql_finish()
    char *sql_getdatabase()
    int sql_exists(char *table, char *field, char *value, char *where)
    int sql_open(char *stmt, int argc, char **argv)
    int sql_close(int)
    int sql_fetch(int)
    int sql_run(char *stmt, int argc, char **argv)
        calls sql_open, sql_fetch and then sql_close
    int sql_explain(int)
    int sql_reopen(fd)
    char *sql_geterror()
    char **sql_values(fd, &numvalues, dostrip)
    char **sql_sqlca(&numvalues)
        do not free the char ** returned !
    int sql_sqld(fd, in)
    char **sql_sqlda(fd, in, num, &numvalues)

    int sql_database(char *dbname)
        connects to the database specified by dbname
        or if dbname is "" or cannot be opened uses
        the DATABASE environ variable
    int sql_finish()
        closes the database opened earlier
    char *sql_getdatabase()
        returns the database name opened by sql_database
    int sql_exists(char *table, char *field, char *value, char *where)
        check for existence of field in table optionally with value and
        optionally with a where clause where
    int sql_open(char *stmt, int argc, char **argv)
        open the query specified by statement and substitute all ? with
        parameters specified
        compiles the query and allocates space for return values
    int sql_close(int)
        close the compiled query and release all memory allocated for it
    int sql_fetch(int)
        fetch a single row into the allocated space
        use sql_values to retrieve it
        (there is no need to free the sql_values return value!
        the program manages this space efficiently by reallocating more 
        space if needed and does not do repeated malloc and free.)
    int sql_run(char *stmt, int argc, char **argv)
        calls sql_open, sql_fetch and then sql_close
    int sql_explain(int)
        sets debug on for all queries if int is not 0 else turns off
    int sql_reopen(fd)
        reopen the cursor so that fetches may be done from the 
        start again. uses the old parameters for the open
    char *sql_geterror()
    char **sql_values(fd, &numvalues, dostrip)
        if dostrip is 1, it will strip all trailing blanks
*/
        
#define MAXFD 20
typedef struct {
    char *cmd;
    unsigned int opened:1;
    unsigned int is_select:1;
    struct sqlda *in;
    struct sqlda *out;
} SSQL;
static SSQL ssql[MAXFD+1];
static char *database_name;

#ifndef BUFSIZ
#define BUFSIZ 4096
#endif
#ifdef DEBUG
#define debug(s)    s
#else
#define debug(s)
#endif

static char errmsg[1024+1];
#define chk_status(p1, p2)  if (sqlca.sqlcode < 0) {\
    return print_status(p1, p2);}

/* removes trailing white spaces */
char * strip (s) char *s; {
  int i;
  for (i = strlen(s) - 1; i >=0 ; i--)
    if (!isspace(s[i])) break;
  s[i+1] = 0;
  return s;
} 
    
/* Using the previous sql error code print the informix error message */
print_status(p1, p2) char *p1, *p2; {
    int retcode = sqlca.sqlcode;
    if (retcode < 0) {
        int len;
        struct sqlca_s save;
        errmsg[0] = '\0';
        memcpy(&save, &sqlca, sizeof(sqlca));
        rgetmsg(save.sqlcode, errmsg, 1024);
        len = strlen(errmsg);
        if (save.sqlerrd[1]) {
            errmsg[len++] = '\n';
            errmsg[len] = '\0';
            rgetmsg(save.sqlerrd[1], &errmsg[len], 1024-len);
        }
        sprintf(&errmsg[strlen(errmsg)], 
            "\nSQL error (%d,isam %d,%s,%s) while doing %s on %s\n", 
            save.sqlcode, save.sqlerrd[1], save.sqlerrp, save.sqlerrm, p1, p2);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return retcode;
    }
    return retcode;
}

/* Set explain on or off */
int sql_explain(n) {
    if (n) 
        $set explain on;
    else 
        $set explain off;
    return sqlca.sqlcode;
}

/* Return the error message stored in the buffer */
char *sql_geterror() {
    return errmsg;
}

/* if select is there and into temp not there then is select */
/* returns 1 if select 0 otherwise */
static is_select(stmt) char *stmt;
{
    char s1[12];
    if (sscanf(stmt, "%8s", s1) == 1 && strcmp(s1, "select") == 0 &&
        strstr(stmt, "into temp") == 0L) return 1;
    return 0;
}

/* returns 
    0 if field exists in table, 
    sqlca.sqlcode otherwise
*/
int sql_exists(table, field, value, where)
char *table, *field, *where;
$char *value;
{
    $char stmt[BUFSIZ+1];
    int fetch_code = 0; /* NOTUSED */

    if (value && *value != '\0') {
        sprintf(stmt, "select '1' from %s where %s = ?", 
            table, field);
        if (where && *where != '\0')
            sprintf(&stmt[strlen(stmt)], " and %s", where);
    }
    else {
        sprintf(stmt, "select '1' from %s", 
            table, field);
        if (where && *where != '\0')
            sprintf(&stmt[strlen(stmt)], " where %s", where);
    }
    
    $prepare pexist from $stmt;
    chk_status("PREPARE(EXISTS)", stmt);
    $declare pexist_cur cursor for pexist;
    chk_status("DECLARE(EXISTS)", stmt);
    if (value && *value != '\0')
        $open pexist_cur using $value;
    else
        $open pexist_cur;
    chk_status("OPEN(EXISTS)", stmt);
    $fetch pexist_cur into $stmt;
    fetch_code = sqlca.sqlcode;
    $close pexist_cur;
    return fetch_code;
}

#define toomany(maxfd) {\
        sprintf(errmsg, \
            "Too many open internal fds (> %d) for sql operations\n", maxfd);\
        debug(fprintf(stderr, "%s\n", errmsg);)\
        return -1;\
    }
#define errmalloc(pointer, func, len)   \
    if (!pointer) {\
        sprintf(errmsg, "Cannot malloc for %d in %s errno %d",len,func,errno);\
        debug(fprintf(stderr, "%s\n", errmsg);)\
        return -1;\
    }
extern int errno;

/* Returns 
    0 on successful execution
    sqlca.sqlcode otherwise
*/
int sql_run(stmt, argc, argv)
    char *stmt;
    int argc;
    char **argv;
{
    int fd = sql_open(stmt, argc, argv);
    int ret;
    if (fd < 0) return fd;
    ret = sql_fetch(fd);
    sql_close(fd);
    return ret;
}

int sql_open(stmt, argc, argv) 
    $char *stmt;
    int argc;
    char **argv;
{
    struct sqlvar_struct *col;
    struct sqlda *udesc;
    int i, fd, len, ret;
    char *save;


    for (i = 0; i < MAXFD; i++) 
        if (!ssql[i].cmd) break;
    if (i >= MAXFD) toomany(i);

    fd = i;

    len = strlen(stmt);
    save = (char *)malloc(len+1);
    errmalloc(save, "OPEN", len);
    strcpy(save, stmt);
    memset(&ssql[fd], 0, sizeof(SSQL));
    ssql[fd].cmd = save;

    switch (fd) {
            case 0:
                $prepare p0 from $stmt; 
                break;
            case 1:
                $prepare p1 from $stmt; 
                break;
            case 2:
                $prepare p2 from $stmt; 
                break;
            case 3:
                $prepare p3 from $stmt; 
                break;
            case 4:
                $prepare p4 from $stmt; 
                break;
            case 5:
                $prepare p5 from $stmt; 
                break;
            case 6:
                $prepare p6 from $stmt; 
                break;
            case 7:
                $prepare p7 from $stmt; 
                break;
            case 8:
                $prepare p8 from $stmt; 
                break;
            case 9:
                $prepare p9 from $stmt; 
                break;
            case 10:
                $prepare p10 from $stmt; 
                break;
            case 11:
                $prepare p11 from $stmt; 
                break;
            case 12:
                $prepare p12 from $stmt; 
                break;
            case 13:
                $prepare p13 from $stmt; 
                break;
            case 14:
                $prepare p14 from $stmt; 
                break;
            case 15:
                $prepare p15 from $stmt; 
                break;
            case 16:
                $prepare p16 from $stmt; 
                break;
            case 17:
                $prepare p17 from $stmt; 
                break;
            case 18:
                $prepare p18 from $stmt; 
                break;
            case 19:
                $prepare p19 from $stmt; 
                break;
            case 20:
                $prepare p20 from $stmt; 
                break;
            default: sql_close(fd); toomany(fd);
    }
    if (sqlca.sqlcode < 0) sql_close(fd);
    chk_status("PREPARE(OPEN)", stmt);

    if (argc > 0) {

        ssql[fd].in = (struct sqlda *)malloc(sizeof(struct sqlda));
        if (!ssql[fd].in) sql_close(fd);
        errmalloc(ssql[fd].in, "OPEN", sizeof(struct sqlda));
        memset(ssql[fd].in, 0, sizeof(struct sqlda));
        (ssql[fd].in)->sqld = argc;
        udesc = (ssql[fd].in);
        udesc->sqlvar = (struct sqlvar_struct *)
                        malloc(argc * sizeof(struct sqlvar_struct));
        if (!udesc->sqlvar) 
            sql_close(fd);
        errmalloc(udesc->sqlvar, "OPEN", argc * sizeof(struct sqlvar_struct));
        memset(udesc->sqlvar, 0, argc * sizeof(struct sqlvar_struct));
        for (i = 0, col = udesc->sqlvar; i < argc; i++, col++) {
            col->sqllen = strlen(argv[i]);
            col->sqldata = (char *)malloc(col->sqllen+1);
            if (!col->sqldata)
                sql_close(fd);
            errmalloc(col->sqldata, "OPEN", col->sqllen+1);
            strcpy(col->sqldata, argv[i]);
            col->sqltype = CCHARTYPE; 
            col->sqlname = 0;
            col->sqlind = 0;
        }
    }
        
    if (!is_select(stmt)) {
        ssql[fd].is_select = 0;
        return fd;
    }
    ssql[fd].is_select = 1;

    switch (fd) {
        case 0: 
            $describe p0 into udesc; 
            break;
        case 1: 
            $describe p1 into udesc; 
            break;
        case 2: 
            $describe p2 into udesc; 
            break;
        case 3: 
            $describe p3 into udesc; 
            break;
        case 4: 
            $describe p4 into udesc; 
            break;
        case 5: 
            $describe p5 into udesc; 
            break;
        case 6: 
            $describe p6 into udesc; 
            break;
        case 7: 
            $describe p7 into udesc; 
            break;
        case 8: 
            $describe p8 into udesc; 
            break;
        case 9: 
            $describe p9 into udesc; 
            break;
        case 10:    
            $describe p10 into udesc; 
            break;
        case 11:    
            $describe p11 into udesc; 
            break;
        case 12:    
            $describe p12 into udesc; 
            break;
        case 13:    
            $describe p13 into udesc; 
            break;
        case 14:    
            $describe p14 into udesc; 
            break;
        case 15:    
            $describe p15 into udesc; 
            break;
        case 16:    
            $describe p16 into udesc; 
            break;
        case 17:    
            $describe p17 into udesc; 
            break;
        case 18:    
            $describe p18 into udesc; 
            break;
        case 19:    
            $describe p19 into udesc; 
            break;
        case 20:    
            $describe p20 into udesc; 
            break;
        default: sql_close(fd); toomany(fd);
    }
    if (sqlca.sqlcode < 0) sql_close(fd);
    chk_status("DESCRIBE(OPEN)", stmt);
    ssql[fd].out = udesc;

    udesc = ssql[fd].out;
    for (i = 0, col = udesc->sqlvar; i < udesc->sqld; i++, col++) {
        if ((col->sqltype&SQLTYPE) != SQLCHAR &&
            (col->sqltype&SQLTYPE) != SQLVCHAR) {
            col->sqllen = rtypwidth(col->sqltype, col->sqllen);
			/* Should allocate atleast 12 characters for backward compat. ! */
			if (col->sqllen < 12) col->sqllen = 12;
        }
        col->sqllen++;
        col->sqldata = (char *)malloc(col->sqllen + 1);
        if (!col->sqldata) sql_close(fd);
        errmalloc(col->sqldata, "OPEN", col->sqllen + 1);
        memset(col->sqldata, 0, col->sqllen + 1);
        col->sqltype = CCHARTYPE; 
        col->sqlind = (short *)malloc(sizeof(short));
        if (!col->sqlind) sql_close(fd);
        errmalloc(col->sqlind, "OPEN", sizeof(short));
        *(col->sqlind) = 0;
    }

    switch (fd) {
        case 0:
            $declare c0 cursor for p0; 
            break;
        case 1:
            $declare c1 cursor for p1; 
            break;
        case 2:
            $declare c2 cursor for p2; 
            break;
        case 3:
            $declare c3 cursor for p3; 
            break;
        case 4:
            $declare c4 cursor for p4; 
            break;
        case 5:
            $declare c5 cursor for p5; 
            break;
        case 6:
            $declare c6 cursor for p6; 
            break;
        case 7:
            $declare c7 cursor for p7; 
            break;
        case 8:
            $declare c8 cursor for p8; 
            break;
        case 9:
            $declare c9 cursor for p9; 
            break;
        case 10:
            $declare c10 cursor for p10; 
            break;
        case 11:
            $declare c11 cursor for p11; 
            break;
        case 12:
            $declare c12 cursor for p12; 
            break;
        case 13:
            $declare c13 cursor for p13; 
            break;
        case 14:
            $declare c14 cursor for p14; 
            break;
        case 15:
            $declare c15 cursor for p15; 
            break;
        case 16:
            $declare c16 cursor for p16; 
            break;
        case 17:
            $declare c17 cursor for p17; 
            break;
        case 18:
            $declare c18 cursor for p18; 
            break;
        case 19:
            $declare c19 cursor for p19; 
            break;
        case 20:
            $declare c20 cursor for p20; 
            break;
        default: sql_close(fd); toomany(fd);
    }
    if (sqlca.sqlcode < 0) sql_close(fd);
    chk_status("DECLARE(OPEN)", stmt); 

    ret = sql_reopen(fd);
    chk_status("OPEN(OPEN)", stmt);
    if (ret < 0) sql_close(fd);

    ssql[fd].opened = 1;

    return fd;
}

sql_reopen(fd) {
    struct sqlda *udesc;
    udesc = ssql[fd].in;
    switch (fd) {
        case 0:
            if (udesc->sqld) 
                $open c0 using descriptor udesc;
            else
                $open c0;
            break;
        case 1:
            if (udesc->sqld)
                $open c1 using descriptor udesc;
            else
                $open c1;
            break;
        case 2:
            if (udesc->sqld)
                $open c2 using descriptor udesc;
            else
                $open c2;
            break;
        case 3:
            if (udesc->sqld)
                $open c3 using descriptor udesc;
            else
                $open c3;
            break;
        case 4:
            if (udesc->sqld)
                $open c4 using descriptor udesc;
            else
                $open c4;
            break;
        case 5:
            if (udesc->sqld)
                $open c5 using descriptor udesc;
            else
                $open c5;
            break;
        case 6:
            if (udesc->sqld)
                $open c6 using descriptor udesc;
            else
                $open c6;
            break;
        case 7:
            if (udesc->sqld)
                $open c7 using descriptor udesc;
            else
                $open c7;
            break;
        case 8:
            if (udesc->sqld)
                $open c8 using descriptor udesc;
            else
                $open c8;
            break;
        case 9:
            if (udesc->sqld)
                $open c9 using descriptor udesc;
            else
                $open c9;
            break;
        case 10:
            if (udesc->sqld)
                $open c10 using descriptor udesc;
            else
                $open c10;
            break;
        case 11:
            if (udesc->sqld)
                $open c11 using descriptor udesc;
            else
                $open c11;
            break;
        case 12:
            if (udesc->sqld)
                $open c12 using descriptor udesc;
            else
                $open c12;
            break;
        case 13:
            if (udesc->sqld)
                $open c13 using descriptor udesc;
            else
                $open c13;
            break;
        case 14:
            if (udesc->sqld)
                $open c14 using descriptor udesc;
            else
                $open c14;
            break;
        case 15:
            if (udesc->sqld)
                $open c15 using descriptor udesc;
            else
                $open c15;
            break;
        case 16:
            if (udesc->sqld)
                $open c16 using descriptor udesc;
            else
                $open c16;
            break;
        case 17:
            if (udesc->sqld)
                $open c17 using descriptor udesc;
            else
                $open c17;
            break;
        case 18:
            if (udesc->sqld)
                $open c18 using descriptor udesc;
            else
                $open c18;
            break;
        case 19:
            if (udesc->sqld)
                $open c19 using descriptor udesc;
            else
                $open c19;
            break;
        case 20:
            if (udesc->sqld)
                $open c20 using descriptor udesc;
            else
                $open c20;
            break;
        default: toomany(fd);
    }

    return sqlca.sqlcode;
}

int sql_fetch(fd)
{

    int ret;
    struct sqlda *udesc;
    
    if (fd < 0 || fd >= MAXFD || !ssql[fd].cmd) {
        sprintf(errmsg, "Invalid fd %d passed to sql_fetch", fd);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return -1;
    }
    if (!ssql[fd].is_select) {
        udesc = ssql[fd].in;
        switch (fd) {
            case 0:
                if (udesc)
                    $execute p0 using descriptor udesc;
                else
                    $execute p0;
                break;
            case 1:
                if (udesc)
                    $execute p1 using descriptor udesc;
                else
                    $execute p1;
                break;
            case 2:
                if (udesc)
                    $execute p2 using descriptor udesc;
                else
                    $execute p2;
                break;
            case 3:
                if (udesc)
                    $execute p3 using descriptor udesc;
                else
                    $execute p3;
                break;
            case 4:
                if (udesc)
                    $execute p4 using descriptor udesc;
                else
                    $execute p4;
                break;
            case 5:
                if (udesc)
                    $execute p5 using descriptor udesc;
                else
                    $execute p5;
                break;
            case 6:
                if (udesc)
                    $execute p6 using descriptor udesc;
                else
                    $execute p6;
                break;
            case 7:
                if (udesc)
                    $execute p7 using descriptor udesc;
                else
                    $execute p7;
                break;
            case 8:
                if (udesc)
                    $execute p8 using descriptor udesc;
                else
                    $execute p8;
                break;
            case 9:
                if (udesc)
                    $execute p9 using descriptor udesc;
                else
                    $execute p9;
                break;
            case 10:
                if (udesc)
                    $execute p10 using descriptor udesc;
                else
                    $execute p10;
                break;
            case 11:
                if (udesc)
                    $execute p11 using descriptor udesc;
                else
                    $execute p11;
                break;
            case 12:
                if (udesc)
                    $execute p12 using descriptor udesc;
                else
                    $execute p12;
                break;
            case 13:
                if (udesc)
                    $execute p13 using descriptor udesc;
                else
                    $execute p13;
                break;
            case 14:
                if (udesc)
                    $execute p14 using descriptor udesc;
                else
                    $execute p14;
                break;
            case 15:
                if (udesc)
                    $execute p15 using descriptor udesc;
                else
                    $execute p15;
                break;
            case 16:
                if (udesc)
                    $execute p16 using descriptor udesc;
                else
                    $execute p16;
                break;
            case 17:
                if (udesc)
                    $execute p17 using descriptor udesc;
                else
                    $execute p17;
                break;
            case 18:
                if (udesc)
                    $execute p18 using descriptor udesc;
                else
                    $execute p18;
                break;
            case 19:
                if (udesc)
                    $execute p19 using descriptor udesc;
                else
                    $execute p19;
                break;
            case 20:
                if (udesc)
                    $execute p20 using descriptor udesc;
                else
                    $execute p20;
                break;
            default: toomany(fd);
        }
        ret = sqlca.sqlcode;
        chk_status("EXECUTE(RUN)", ssql[fd].cmd); 
        return ret;
    }
    udesc = ssql[fd].out;
    switch (fd) {
        case 0:
            if (udesc->sqld)
                $fetch c0 using descriptor udesc;
            else
                $fetch c0;
            break;
        case 1:
            if (udesc->sqld)
                $fetch c1 using descriptor udesc;
            else
                $fetch c1;
            break;
        case 2:
            if (udesc->sqld)
                $fetch c2 using descriptor udesc;
            else
                $fetch c2;
            break;
        case 3:
            if (udesc->sqld)
                $fetch c3 using descriptor udesc;
            else
                $fetch c3;
            break;
        case 4:
            if (udesc->sqld)
                $fetch c4 using descriptor udesc;
            else
                $fetch c4;
            break;
        case 5:
            if (udesc->sqld)
                $fetch c5 using descriptor udesc;
            else
                $fetch c5;
            break;
        case 6:
            if (udesc->sqld)
                $fetch c6 using descriptor udesc;
            else
                $fetch c6;
            break;
        case 7:
            if (udesc->sqld)
                $fetch c7 using descriptor udesc;
            else
                $fetch c7;
            break;
        case 8:
            if (udesc->sqld)
                $fetch c8 using descriptor udesc;
            else
                $fetch c8;
            break;
        case 9:
            if (udesc->sqld)
                $fetch c9 using descriptor udesc;
            else
                $fetch c9;
            break;
        case 10:
            if (udesc->sqld)
                $fetch c10 using descriptor udesc;
            else
                $fetch c10;
            break;
        case 11:
            if (udesc->sqld)
                $fetch c11 using descriptor udesc;
            else
                $fetch c11;
            break;
        case 12:
            if (udesc->sqld)
                $fetch c12 using descriptor udesc;
            else
                $fetch c12;
            break;
        case 13:
            if (udesc->sqld)
                $fetch c13 using descriptor udesc;
            else
                $fetch c13;
            break;
        case 14:
            if (udesc->sqld)
                $fetch c14 using descriptor udesc;
            else
                $fetch c14;
            break;
        case 15:
            if (udesc->sqld)
                $fetch c15 using descriptor udesc;
            else
                $fetch c15;
            break;
        case 16:
            if (udesc->sqld)
                $fetch c16 using descriptor udesc;
            else
                $fetch c16;
            break;
        case 17:
            if (udesc->sqld)
                $fetch c17 using descriptor udesc;
            else
                $fetch c17;
            break;
        case 18:
            if (udesc->sqld)
                $fetch c18 using descriptor udesc;
            else
                $fetch c18;
            break;
        case 19:
            if (udesc->sqld)
                $fetch c19 using descriptor udesc;
            else
                $fetch c19;
            break;
        case 20:
            if (udesc->sqld)
                $fetch c20 using descriptor udesc;
            else
                $fetch c20;
            break;
        default: toomany(fd);
    }
    ret = sqlca.sqlcode;
    chk_status("FETCH(OPEN)", ssql[fd].cmd);
    return ret;
}

char **sql_values(fd, num, dostrip) int *num;
{
    static char **argv;
    static int maxnum;
    struct sqlda *udesc;
    struct sqlvar_struct *col;
    int i;

    if (fd < 0 || fd >= MAXFD || !ssql[fd].cmd || !ssql[fd].is_select ||
        !ssql[fd].opened) {
        sprintf(errmsg, 
            "Cannot get values for a non-select/non-opened statement\
            (fd %d) passed to sql_values", fd);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return NULL;
    }
    udesc = ssql[fd].out;
    if (!udesc) return NULL;
    if (udesc->sqld > maxnum) {
        if (argv) { free(argv); argv = NULL; }
        argv = (char **)malloc(udesc->sqld * sizeof(char *));
        if (!argv) {
            sprintf(errmsg, "Cannot malloc for %d in VALUES errno %d", 
                udesc->sqld * sizeof(char *), errno);
            debug(fprintf(stderr, "%s\n", errmsg);)
            return NULL;
        }
        maxnum = udesc->sqld;
        memset(argv, 0, udesc->sqld * sizeof(char *));
    }
    for (i = 0, col = udesc->sqlvar; i < udesc->sqld; i++, col++) {
        argv[i] = (col->sqldata)?col->sqldata:"";
        if (dostrip == 1) strip(argv[i]);
    }
    if (num) *num = udesc->sqld;
    return argv;
}

char **sql_sqlca(num) int *num; {
    static char **argv;
    static char sqlcode[15], sqlerrd[15*6], sqlwarn[25];
    if (!argv) {
        argv = (char **)malloc(6 * sizeof(char *));
        if (!argv) {
            sprintf(errmsg, "Cannot malloc for %d in SQLCA errno %d", 
                6 * sizeof(char *), errno);
            debug(fprintf(stderr, "%s\n", errmsg);)
            return NULL;
        }
    }
    sprintf(argv[0] = sqlcode, "%d", sqlca.sqlcode);
    argv[1] = sqlca.sqlerrm;
    argv[2] = sqlca.sqlerrp;
    sprintf(argv[3] = sqlerrd, "%d %d %d %d %d %d", 
        sqlca.sqlerrd[0], sqlca.sqlerrd[1], sqlca.sqlerrd[2], 
        sqlca.sqlerrd[3], sqlca.sqlerrd[4], sqlca.sqlerrd[5]);
    sprintf(argv[4] = sqlwarn, "%c %c %c %c %c %c %c %c",
        sqlca.sqlwarn.sqlwarn0, sqlca.sqlwarn.sqlwarn1, 
        sqlca.sqlwarn.sqlwarn2, sqlca.sqlwarn.sqlwarn3,
        sqlca.sqlwarn.sqlwarn4, sqlca.sqlwarn.sqlwarn5, 
        sqlca.sqlwarn.sqlwarn6, sqlca.sqlwarn.sqlwarn7);
    if (num) *num = 5;
    return argv;
}

int sql_sqld(fd, in) {
    struct sqlda *udesc;
    if (fd < 0 || fd >= MAXFD || !ssql[fd].cmd) {
        sprintf(errmsg, "Invalid fd %d passed to sql_sqld", fd);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return -2;
    }
    if (in == 1) udesc = ssql[fd].in;
    else udesc = ssql[fd].out;
    if (udesc) return udesc->sqld;
    return -1;
}

char **sql_sqlda(fd, in, num, numvalues) int *numvalues; {
    struct sqlda *udesc;
    struct sqlvar_struct *col;
    static char **argv;
    static char sqltype[15], sqllen[15], *sqldata, *sqlname, *sqlformat,
        sqlitype[15], sqlilen[15];

    if (fd < 0 || fd >= MAXFD || !ssql[fd].cmd) {
        sprintf(errmsg, "Invalid fd %d passed to sql_sqlda", fd);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return NULL;
    }

    if (in == 1) udesc = ssql[fd].in;
    else udesc = ssql[fd].out;

    if (num < 0 || num >= udesc->sqld) {
        sprintf(errmsg, "Invalid num %d passed to sql_sqlda (>= %d)", num,
            udesc->sqld);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return NULL;
    }
    if (!argv) {
        argv = (char **)malloc(8 * sizeof(char *));
        if (!argv) {
            sprintf(errmsg, "Cannot malloc for %d in SQLDA errno %d", 
                8 * sizeof(char *), errno);
            debug(fprintf(stderr, "%s\n", errmsg);)
            return NULL;
        }
    }
    col = udesc->sqlvar + num;
    sprintf(argv[0] = sqltype, "%d", col->sqltype);
    sprintf(argv[1] = sqllen, "%d", col->sqllen);
    argv[2] = col->sqldata;
    if (!argv[2]) argv[2] = "";
    argv[3] = col->sqlname;
    if (!argv[3]) argv[3] = "";
    argv[4] = col->sqlformat;
    if (!argv[4]) argv[4] = "";
    sprintf(argv[5] = sqltype, "%d", col->sqlitype);
    sprintf(argv[6] = sqltype, "%d", col->sqlilen);
    if (numvalues) *numvalues = 7;
    return argv;
}


char *sql_command(fd) {
    if (fd < 0 || fd >= MAXFD || !ssql[fd].cmd) {
        sprintf(errmsg, "Invalid fd %d passed to sql_command", fd);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return NULL;
    }
    return ssql[fd].cmd;
}

int sql_close(fd, argc, argv) 
    int fd;
    int argc;
    char **argv;
{
    struct sqlda *udesc;
    struct sqlvar_struct *col;

    
    if (fd < 0 || fd >= MAXFD || !ssql[fd].cmd) {
        sprintf(errmsg, "Invalid fd %d passed to sql_close", fd);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return -1;
    }
    if (ssql[fd].is_select && ssql[fd].opened) {
        switch (fd) {
            case 0:
                $close c0; 
                break;
            case 1:
                $close c1; 
                break;
            case 2:
                $close c2; 
                break;
            case 3:
                $close c3; 
                break;
            case 4:
                $close c4; 
                break;
            case 5:
                $close c5; 
                break;
            case 6:
                $close c6; 
                break;
            case 7:
                $close c7; 
                break;
            case 8:
                $close c8; 
                break;
            case 9:
                $close c9; 
                break;
            case 10:
                $close c10; 
                break;
            case 11:
                $close c11; 
                break;
            case 12:
                $close c12; 
                break;
            case 13:
                $close c13; 
                break;
            case 14:
                $close c14; 
                break;
            case 15:
                $close c15; 
                break;
            case 16:
                $close c16; 
                break;
            case 17:
                $close c17; 
                break;
            case 18:
                $close c18; 
                break;
            case 19:
                $close c19; 
                break;
            case 20:
                $close c20; 
                break;
            default: toomany(fd);
        }
    }
    free(ssql[fd].cmd); 
    ssql[fd].cmd = NULL;
    udesc = ssql[fd].in;
    if (udesc) {
        int i;
        for (i = 0, col = udesc->sqlvar; i < udesc->sqld; i++, col++) {
            free(col->sqldata);
        }
        free(udesc->sqlvar);
        free(udesc);
    }
    ssql[fd].in = NULL;
    udesc = ssql[fd].out;
    if (udesc) {
        int i;
        for (i = 0, col = udesc->sqlvar; i < udesc->sqld; i++, col++) {
            free(col->sqldata);
            free(col->sqlind);
        }
        free(udesc->sqlvar);
        free(udesc);
    }
    ssql[fd].out = NULL;
    memset(&ssql[fd], 0, sizeof(SSQL));
    return sqlca.sqlcode;
}

int sql_print(fd) {
    struct sqlda *udesc;
    struct sqlvar_struct *col;

    
    if (fd < 0 || fd >= MAXFD) {
        sprintf(errmsg, "Invalid fd %d passed to sql_print", fd);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return -1;
    }
    printf("Command string for fd %d: %s", fd, 
            (ssql[fd].cmd?ssql[fd].cmd:"null"));
    if (!ssql[fd].opened) printf(" not ");
    printf(" opened, ");
    if (!ssql[fd].opened) printf(" not ");
    printf(" selected\n");
    if (ssql[fd].in) {
        int i;
        udesc = ssql[fd].in;
        printf("Input:");
        for (i = 0, col = udesc->sqlvar; i < udesc->sqld; i++, col++) {
            printf("(%s,%d,%s)\n",col->sqlname, col->sqllen, col->sqldata);
        }
    }
    if (ssql[fd].out) {
        int i;
        udesc = ssql[fd].out;
        printf("Output:\n");
        for (i = 0, col = udesc->sqlvar; i < udesc->sqld; i++, col++) {
            printf("(%s,%d,%s)\n",col->sqlname, col->sqllen, col->sqldata);
        }
    }
    return 0;
}

int sql_database(dbname) char *dbname; {
    $char *p;
    int len;
    if (!dbname || *dbname == '\0') {
        p = getenv("DATABASE");
        if (!p) p = "NODATABASE";
    }
    else p = dbname;
    if (database_name) free(database_name);
    database_name = NULL;
    $database $p;
    chk_status("DATABASE", p);
    len = strlen(p) + 1;
    database_name = (char *)malloc(len);
    errmalloc(database_name, "DATABASE", len);
    strcpy(database_name, p);
    return 0;
}

int sql_finish() {
    if (database_name) {
        $close database;
        chk_status("CLOSE DATABASE", database_name);
        free(database_name);
        database_name = NULL;
    }
    return 0;
}

char *sql_getdatabase() {
    return database_name;
}


#ifdef TEST
main() {
    int fd, fd2;
    int ret = 0;
    char *argv[] = {
        "A*"};
    char *argv2[] = {
        "19"};
    char **argv3;
    int num;
    $database ni;
    fd = sql_open("select ne_id from com_ne_defn where ne_id matches ?", 
        1, argv);
    while (ret == 0) {
        ret = sql_fetch(fd);
        if (ret == 0) sql_print(fd);
    }
    printf("1st done\n");
    argv3 = sql_values(fd, &num, 0);
    if (!argv3) printf("No values for fd%d\n", fd);
    else {
        int i;
        for (i = 0; i < num; i++)
            printf("Value %d is %s\n", i, argv3[i]);
    }
    fd2 = sql_open("select ne_id from com_ne_defn where ne_id matches ?", 
        1, argv);
    ret = 0;
    while (ret == 0) {
        ret = sql_fetch(fd2);
        if (ret == 0) sql_print(fd2);
    }
    printf("2nd done\n");


    if (sql_exists("com_ne_defn", "ne_id", 0, 0)==0)
        printf("at least 1 ne exists\n");
    if (sql_exists("com_ne_defn", "ne_id", "AUSTT2", 0)==0)
        printf("ne AUSTT2 exists\n");
    if (sql_exists("com_ne_defn", "ne_id", 0, "ne_id matches 'A*'")==0)
        printf("ne matching A* exists\n");
    if (sql_run("set lock mode to wait", 0, 0) == 0)
        printf("successful lock mode\n");
    if (sql_run("update com_expected set xxxx = ?", 1, argv2) == 0)
        printf("successful update \n");
}
#endif
