proc moogGotoCB {} {
  global i tabList

  set I $i
  incr i

  toplevel .moogGoto$I

  wm title .moogGoto$I "Go to a gopher object..."

  moogBindings .moogGoto$I

  message .moogGoto$I.msg -font -Adobe-times-medium-r-normal--*-180* \
    -aspect 800 \
    -text "Enter a gopher object to fetch:"

  frame .moogGoto$I.typeFrame -borderwidth 1m
  label .moogGoto$I.typeFrame.typeLabel -text "Type:"
  entry .moogGoto$I.typeFrame.type -relief sunken -width 50
  pack append .moogGoto$I.typeFrame \
    .moogGoto$I.typeFrame.typeLabel left \
    .moogGoto$I.typeFrame.type right
  moogBindings .moogGoto$I.typeFrame.type
  bind .moogGoto$I.typeFrame.type <Tab> "moogTabs \$tabList"
  bind .moogGoto$I.typeFrame.type <Return> "moogGotoACT $I"

  frame .moogGoto$I.hostFrame -borderwidth 1m
  label .moogGoto$I.hostFrame.hostLabel -text "Host:"
  entry .moogGoto$I.hostFrame.host -relief sunken -width 50
  pack append .moogGoto$I.hostFrame \
    .moogGoto$I.hostFrame.hostLabel left \
    .moogGoto$I.hostFrame.host right
  moogBindings .moogGoto$I.hostFrame.host
  bind .moogGoto$I.hostFrame.host <Tab> "moogTabs \$tabList"
  bind .moogGoto$I.hostFrame.host <Return> "moogGotoACT $I"

  frame .moogGoto$I.portFrame -borderwidth 1m
  label .moogGoto$I.portFrame.portLabel -text "Port:"
  entry .moogGoto$I.portFrame.port -relief sunken -width 50
  pack append .moogGoto$I.portFrame \
    .moogGoto$I.portFrame.portLabel left \
    .moogGoto$I.portFrame.port right
  moogBindings .moogGoto$I.portFrame.port
  bind .moogGoto$I.portFrame.port <Tab> "moogTabs \$tabList"
  bind .moogGoto$I.portFrame.port <Return> "moogGotoACT $I"

  frame .moogGoto$I.pathFrame -borderwidth 1m
  label .moogGoto$I.pathFrame.pathLabel -text "Path:"
  entry .moogGoto$I.pathFrame.path -relief sunken -width 50
  pack append .moogGoto$I.pathFrame \
    .moogGoto$I.pathFrame.pathLabel left \
    .moogGoto$I.pathFrame.path right
  moogBindings .moogGoto$I.pathFrame.path
  bind .moogGoto$I.pathFrame.path <Tab> "moogTabs \$tabList"
  bind .moogGoto$I.pathFrame.path <Return> "moogGotoACT $I"

  button .moogGoto$I.ok -text {Fetch} \
    -command "moogGotoACT $I"

  button .moogGoto$I.cancel -text {Close} \
    -command "destroy .moogGoto$I"
 
  pack append .moogGoto$I \
    .moogGoto$I.msg {top fill} \
    .moogGoto$I.typeFrame {top expand fill} \
    .moogGoto$I.hostFrame {top expand fill} \
    .moogGoto$I.portFrame {top expand fill} \
    .moogGoto$I.pathFrame {top expand fill} \
    .moogGoto$I.ok {left expand fill} \
    .moogGoto$I.cancel {left expand fill}

  set tabList ".moogGoto$I.typeFrame.type .moogGoto$I.hostFrame.host \
    .moogGoto$I.portFrame.port .moogGoto$I.pathFrame.path"
}

