/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 

/*
 * OT 3.0.2
 */

/*
 * otKwik.c
 */


/*
#include <stdlib.h>
*/
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <tcl.h>
#include <tclInt.h>
#include "ot.h"
#include "otInt.h"

#ifndef LINT
static char RCSid_otKwik[] =
    "$RCSfile: otKwik.c,v $ $Revision: 1.1.6.2 $ $Date: 1993/12/28 20:41:44 $";
#endif

OTErr  otWriteHeaderFieldToKwikString();
OTErr  otWriteNotedataToKwikString();
OTErr  otAppendHeaderFieldToTemplateFromKwikString();
OTErr  otAppendNotedataToTemplateFromKwikString();


#define min(a,b)               ((a)>(b)? (b) : (a))

OTErr
otWriteHeaderFieldToKwikString(tp, key, val)
OTTemplate *tp;
char *key;
char **val;
{
    register OTMetaTemplate *mtp, *tmp_mtp;
    register char *hfv, *tmp_cp;
    register OTHeaderField *hfp;
    int len;
    char *kwd, *cp;
    OTProject *pjp;
    OTErr malErr;

    malErr = OT_SUCCESS;
    pjp = otCB->cb_pcb->pcb_project;
    mtp = tmp_mtp = pjp->otmp;
    len = 0;

#define HEADERFACTOR 50
    /*
     * Count length of data.  I added the factor of 50 for alternative
     * or user-contributed fields.
     */
    for( hfp = tp->tr; hfp->field && *hfp->field ; hfp++ ) { 
        if ( hfp->value )
	    len += strlen(hfp->value) + HEADERFACTOR;
	else
	    len += HEADERFACTOR;
    }

    if ( !(tmp_cp = calloc(len, sizeof(char))) && len ) {
	otPutPostedMessage(OT_MALLOC_LOCATION, "otWriteHeaderFieldToKwikString()");
	return OT_MALLOC_LOCATION;
    }

    *val = tmp_cp;
    for( tmp_mtp=mtp; *tmp_mtp->field; tmp_mtp++ ) {
        if ( *tmp_mtp->field == '!' )
	    continue;
	if ( hfv = otGetHeaderFieldValue( tmp_mtp->field, tp ) ) {
	    (void)strcpy(tmp_cp, hfv);
	    if ( tmp_mtp->type == TYPE_IDNUM )
		(void)strcpy(key, hfv);
	}
	while ( *tmp_cp )
	    tmp_cp++;
	*tmp_cp = OTFIELDHEADERSEP;
	tmp_cp++;
    }
    *tmp_cp++ = OTHEADERSEP;
    *tmp_cp = 0;

    /*
     * Now retrieve all fields which are not part of the metatemplate and
     * write them as strings, separated.
     */
    for(hfp = tp->tr; !malErr && hfp->field && *hfp->field; hfp++)
	if ( !(kwd = otGetFieldNameAbbr(hfp->field, pjp)) ) {
	    if ( !(malErr = otWriteHeaderFieldToString( pjp, hfp, &cp )) ) {
		if ( !(*val = realloc(*val, len + strlen(cp) + 10)) ) {
		    otPutPostedMessage(OT_MALLOC_LOCATION,
			"otWriteHeaderFieldToKwikString");
		    malErr = OT_MALLOC_LOCATION;
		} else {
		    (void)strcat(*val, cp);
	            tmp_cp = *val;
		    while ( *tmp_cp )
		        tmp_cp++;
		    *tmp_cp = OTNEWLINE;
		    tmp_cp++;
		    *tmp_cp = 0;
		    (void)free(cp);
		}
	    }
	}

    for(tmp_cp = *val; *tmp_cp; tmp_cp++)
	if (*tmp_cp == '\n')
	    *tmp_cp = OTNEWLINE;

    if (cp = key) {
	while (*cp && (*cp != ' '))
	    cp++;
	*cp = 0;
    }

    *tmp_cp = OTHEADEREND;
    tmp_cp++;
    *tmp_cp = 0;

    return malErr;

}



OTErr
otWriteNotedataToKwikString(tp, val)
OTTemplate *tp;
char **val;
{
    register OTNotedata *ndp;
    register char *cp;
    int len = 0;


    /*
     * Estimate the mem size for storing the notedata associated
     * w/ this CR and allocate it.
     */
    ndp = tp->ndp;
    if ( !ndp->nd_flags ) {
	*val = 0;
        return OT_SUCCESS;
    }

    for (len = 0, ndp = tp->ndp; ndp->nd_flags; ndp++) {
        len += sizeof(OTNotedata);
	if ( ndp->nd_kwd )
	    len += strlen(ndp->nd_kwd);
	if ( ndp->nd_agent )
	    len += strlen(ndp->nd_agent);
	if ( ndp->nd_field )
	    len += strlen(ndp->nd_field);
	if ( ndp->nd_previous )
	    len += strlen(ndp->nd_previous);
	if ( ndp->nd_current )
	    len += strlen(ndp->nd_current);
    }

    if ( !(*val = calloc(len * 2, sizeof(char))) && len ) {
	otPutPostedMessage(OT_MALLOC_LOCATION,
	    "otWriteNotedataToKwikString()");
	return OT_MALLOC_LOCATION;
    }
        
    cp = *val;
    /*
     * Write the fields in the order in which they will be
     * loaded into OTNotedata.
     */
    for ( ndp = tp->ndp; ndp->nd_flags; ndp++ ) {

	*cp++ = ndp->nd_flags;
	*cp++ = ndp->nd_weekday;
	*cp++ = ( ndp->nd_mon == '\n' ) ? '\040' : ( ndp->nd_mon ) ;
	*cp++ = ( ndp->nd_day == '\n' ) ? '\040' : ( ndp->nd_day ) ;
	*cp++ = ndp->nd_year;
	memcpy(cp, ndp->nd_time, MAXTIME);
	cp += MAXTIME;
	*cp++ = OTFIELDHEADERSEP;

	if ( ndp->nd_kwd ) {
	    strcpy(cp, ndp->nd_kwd);
	    for( ; *cp; cp++) {
		if (*cp == '\n')
		    *cp = OTNEWLINE;
	    }
	}
	*cp++ = OTFIELDHEADERSEP;
	
	if ( ndp->nd_agent ) {
	    strcpy(cp, ndp->nd_agent);
	    for( ; *cp; cp++) {
		if (*cp == '\n')
		    *cp = OTNEWLINE;
	    }
	}
	*cp++ = OTFIELDHEADERSEP;

	if ( ndp->nd_field ) {
	    strcpy(cp, ndp->nd_field);
	    for( ; *cp; cp++) {
		if (*cp == '\n')
		    *cp = OTNEWLINE;
	    }
	}
	*cp++ = OTFIELDHEADERSEP;

	if ( ndp->nd_previous ) {
	    strcpy(cp, ndp->nd_previous);
	    for( ; *cp; cp++) {
		if (*cp == '\n')
		    *cp = OTNEWLINE;
	    }
	}
	*cp++ = OTFIELDHEADERSEP;

	if ( ndp->nd_current ) {
	    strcpy(cp, ndp->nd_current);
	    for( ; *cp; cp++) {
		if (*cp == '\n')
		    *cp = OTNEWLINE;
	    }
	}
	*cp++ = OTHEADERSEP;
    }
    *cp = 0;

    return OT_SUCCESS;

}


OTErr
otAppendHeaderFieldToTemplateFromKwikString(tp, cp)
OTTemplate *tp;
char *cp;
{
    OTErr err;
    register char *s, *t;
    register OTMetaTemplate *mtp;
    register OTHeaderField *hfp;
    OTHeaderField *start;

    err = OT_SUCCESS;
    s = cp;
    start = tp->tr;

    if ( !(hfp = tp->tr) ) {
	otPutPostedMessage(OT_INTERNAL_ERROR,
	    "No header fields (otAppendHeaderFieldToTemplateFromKwikString()");
	return OT_INTERNAL_ERROR;
    }

    for ( hfp = tp->tr; !err && hfp->field && *hfp->field; hfp++)
	if ( hfp >= start + MAXTEMPLATE ) {
	    otPutPostedMessage( OT_TEMPLATE_LONG );
	    err = OT_TEMPLATE_LONG;
	    continue;
	}
    mtp = otCB->cb_pcb->pcb_project->otmp;

    /*
     * Kwik strings always represent entire templates, not fragments, so
     * since information is positional, they always have to begin with the
     * first field (different from otAppendHeaderFieldToTemplateFromString()).
     */
    hfp = tp->tr;
    while ( *mtp->field && !err && *s && (*s != OTHEADERSEP) ) {

	/*
	 * Find next metatemplate field.
	 */
        while ( *mtp->field && *mtp->field == '!' )
	    mtp++;

	while ( hfp->field && *hfp->field && strcmp(hfp->field, mtp->field) )
	    hfp++;

	if (*mtp->field && ( (!hfp->field) || (hfp->field && !*hfp->field) )) {
	    otPutPostedMessage( OT_INTERNAL_ERROR, "otReadTemplateFromString()" );
	    err = OT_INTERNAL_ERROR;
	} else {

	    /*
	     * Copy data.
	     */
	    t = s;
	    while ( *t != OTFIELDHEADERSEP ) {
		if ( *t == OTNEWLINE )
		    *t = '\n';
		t++;
	    }
	    *t = 0;

	    if ( otCopyString( s, &(hfp->value) ) ) {
		otPutPostedMessage(OT_MALLOC_LOCATION, "otReadTemplateFromString()");
		err = OT_MALLOC_LOCATION;
	    } else {
		s = ++t;
		mtp++;
		hfp++;
	    }
	}
    }


    /* 
     * Now add the fields not in the metatemplate.
     */
    if ( !err ) {
	s++;
	t = s;
	while ( *t && *t != OTHEADEREND ) {
	    if ( *t == OTNEWLINE )
		*t = '\n';
	    t++;
	}

	if ( *(t - 1) == '\n' )
	    *(t - 1) = 0;
	*t = 0;

	if ( s && *s )
	    err = otAppendHeaderFieldToTemplateFromString(tp, s);

    }

    return err;

}

OTErr
otAppendNotedataToTemplateFromKwikString(tp, cp)
OTTemplate *tp;
char *cp;
{
    register char *s, *t, *u;
    register OTNotedata *tndp;
    OTErr ndErr;
    bool endOfString;

    endOfString = FALSE;
    ndErr = OT_SUCCESS;
    /*
     * Append after last of the current notedata lines.
     */
    for( tndp = tp->ndp; !ndErr && tndp->nd_flags; tndp++ )
	if ( tndp >= tp->ndp + MAXNDATA )
	    ndErr = OT_NDATA_TOOMANY;

    t = cp;

    while (!endOfString && !ndErr) {

	if ( !*t ) {
	    endOfString = TRUE;
	    continue;
	}

	tndp->nd_flags = *t++;
	tndp->nd_weekday = *t++;

	tndp->nd_mon = (*t == '\040') ? 10 : *t;
	t++;
	tndp->nd_day = (*t == '\040') ? 10 : *t;
	t++;
	tndp->nd_year = *t++;

	memcpy(tndp->nd_time, t, MAXTIME);
	t += MAXTIME;
	if (*t != OTFIELDHEADERSEP) {
	    otPutPostedMessage(OT_INTERNAL_ERROR, 
		"otAppendNotedataToTemplateFromKwikString()");
	    ndErr = OT_INTERNAL_ERROR;
	    continue;
	} else
	    t++;

#define GET_FIELD( target )    						    \
	for(s = t; *s && *s != OTFIELDHEADERSEP && *s != OTHEADERSEP; s++); \
	if ( !*s ) {							    \
	    endOfString = TRUE;						    \
	    continue;							\
	} else {							\
	    *s = 0;							\
	    if ( *t ) {							\
		for (u = t; *u; u++)					\
		    if ( *u == OTNEWLINE )				\
			*u = '\n';					\
		if ( ndErr = otCopyString( t, &( target ) ) ) {		\
		    otPutPostedMessage(OT_MALLOC_LOCATION,		\
			"otAppendNotedataToTemplateFromKwikString()");	\
		    continue;						\
		}							\
	    }								\
	    t = ++s;							\
	}
			      
	GET_FIELD( tndp->nd_kwd );
	GET_FIELD( tndp->nd_agent );
	GET_FIELD( tndp->nd_field );
	GET_FIELD( tndp->nd_previous );
	GET_FIELD( tndp->nd_current );


    DBUG_MED((stderr, "otAppendNotedataToTemplateFromKwikString..."));

    DBUG_MED((stderr, "otApp kwd = %s\tflags = %o\n", tndp->nd_kwd ? tndp->nd_kwd : "null" , tndp->nd_flags));
    DBUG_MED((stderr, "otApp weekday = |%o|\tfield = |%s| \n", tndp->nd_weekday, tndp->nd_field ? tndp->nd_field : ""));
    DBUG_MED((stderr, "otApp month = |%o|\t day = |%o| year = |%o|\n", tndp->nd_mon, tndp->nd_day, tndp->nd_year));

    DBUG_MED((stderr, "otApp agent = %s\n", tndp->nd_agent));
    DBUG_MED((stderr, "otApp time = %s\n", tndp->nd_time));
    DBUG_MED((stderr, "otApp previous: |%s|\tcurrent: |%s|\n", tndp->nd_previous ? tndp->nd_previous : "", tndp->nd_current ? tndp->nd_current : "" ));

	if (++tndp >= tp->ndp + MAXNDATA) {
	    otPutPostedMessage( OT_NDATA_TOOMANY);
	    ndErr = OT_NDATA_TOOMANY;
	}
    }

    return ndErr;

}

