/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 

/*
 * OT 3.0.2
 */

/*
 *	otUtil.c
 *
 */


/*
#include <stdlib.h>
*/
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <pwd.h>
#include <tcl.h>
#include <tclInt.h>
#include "ot.h"
#include "otInt.h"


#ifndef LINT
static char RCSid_otUtil[] =
    "$RCSfile: otUtil.c,v $ $Revision: 1.1.8.4 $ $Date: 1994/03/08 17:49:57 $";

#endif


/*
 *              List of functions defined in the otUtil.c
 *
 *	otGetUserName()
 *	otPreparseInput()
 *	otGetHeaderFieldValue()
 *	otSetHeaderFieldValue()
 *	otSetFilterValue()
 *	otSetCBMember()
 *	otGetValue()
 *	otCleanup()
 *	otEditTemplate()
 *	otCatchSignals()
 *	otCatchInt()
 *	otChkProjectInTemplate()
 *	otReadTopNumber()
 */

OTErr otMakeDirExist();
void    strdelete();

static char *tlaMonths[] = {
    "Jan", "Feb", "Mar", "Apr", "May", "Jun", 
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", ""
    };

static char *tlaDays[] = {
    "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", ""
    };



OTErr
otGetUserName()
{
    OTErr errCode = OT_SUCCESS;
    struct passwd *getpwuid(), *upwd;

    char *t;

    if ( t = otGetValue("OT_USER", otGetValue("USER", getenv("LOGNAME"))) ) {
	errCode = otCopyString(t, &(otCB->cb_pcb->pcb_uName));
    }

    if (!otCB->cb_pcb->pcb_uName) {

	if ( (upwd = getpwuid( getuid() )) == NULL ) {
	    otPutPostedMessage(OT_GETPWUID);
	    errCode = OT_GETPWUID;
	}
	else 
	    errCode = otCopyString(upwd->pw_name, &(otCB->cb_pcb->pcb_uName));
    }

    return(errCode);
}


OTErr
otPreparseInput(argc, argv)
int *argc;
char ** argv;
{
    int  i, len;
    char * cp;


    /* Find project name command line argument */

    for (i=1, cp=0;  i < *argc;  i++)   {
	if ((argv[i][0] == '-') && ((argv[i][1] == 'p')))   {
	    if (cp) {
		otPutPostedMessage(OT_MULTIPLE_PROJECTS);
		return OT_MULTIPLE_PROJECTS;
	    }

	    /* get project name and store it in the OTControlBlock structure */

	    cp = otGetOneArg(&i, argc, argv);

	    len = strlen(cp) + 1;

	    if (otCB->cb_project) {
		if ( !(otCB->cb_project = 
		    (char *)realloc(otCB->cb_project, len) )) {
		    otPutPostedMessage( OT_MALLOC_LOCATION, "otPreparseInput");
		    return OT_MALLOC_LOCATION;
		}
	    }
	    else {
		if ( !(otCB->cb_project = (char *)malloc(len) )) {
		    otPutPostedMessage( OT_MALLOC_LOCATION, "otPreparseInput");
		    return OT_MALLOC_LOCATION;
		}
	    }
	    memset(otCB->cb_project, 0, len);
	    strcpy(otCB->cb_project, cp);
	}
    }

    /* Find an alternative meta template name */

    for (i=1, cp=0;  i < *argc;  i++)   {
	if ((argv[i][0] == '-') && ((argv[i][1] == 'a')))   {
	    if (cp) {
		otPutPostedMessage(OT_MULTIPLE_ALTERNATE);
		return OT_MULTIPLE_ALTERNATE;
	    }

	    /* get an alternative meta template name and store it */

	    cp = otGetOneArg(&i, argc, argv);
	    len = strlen(cp) + 1;

	    if ( !(otCB->cb_altTname = (char *)malloc(len) )) {
		otPutPostedMessage( OT_MALLOC_LOCATION, "otPreparseInput");
		return OT_MALLOC_LOCATION;
	    }

	    memset(otCB->cb_altTname, 0, len);
	    strcpy(otCB->cb_altTname, cp);
	}
    }

    return OT_SUCCESS;
}



/* Turn CR number into filename */
OTErr
otFormName(proj, CRNum, fname)
OTProject * proj;  /* project info */
long CRNum;         /* the CR number */
OTFilen **fname;	   
{
    long j;
    char base[PATHLEN];
    char *prjdir = 0;

    OTErr errCode = OT_SUCCESS;

    /* Directory place */

    if ( !proj || (proj->proj_dir[0] == 0) ) {
	otPutPostedMessage(OT_PROJECT_NOT_FOUND, proj->name);
	return errCode;
    }
    prjdir = proj->proj_dir;

    sprintf(base, "%s/%s", prjdir, proj->name);

    /* Allocate OTFilen structure for the CR file name */
    if ( (*fname = (OTFilen *) malloc(sizeof(OTFilen)) ) == NULL ) {
	otPutPostedMessage(OT_MALLOC_LOCATION, "otFormName()");
	return OT_MALLOC_LOCATION;
    }

    /* Put CRs into directory buckets -- no more than 100 CRs per directory */

    j = CRNum - ((CRNum / 10000) * 10000);

    sprintf((*fname)->name, "c%06ld", CRNum);
    sprintf((*fname)->dir, "%s/d%02d/d%02d/", base, (CRNum / 10000), (j / 100));

    DBUG_MED((stderr, "formName dir %s\n", (*fname)->dir));

    errCode = otMakeDirExist((*fname)->dir);

    return errCode;
}



/* make sure a directory path exists -- create it if not */
OTErr
otMakeDirExist(path)
char * path;        /* make sure it exists */
{
    register int i;
    char bpath[PATHLEN];
    char xpath[PATHLEN];
    char command[NAMELEN];
    struct stat statbuf;

    OTErr errCode = OT_SUCCESS;

    DBUG_MIN((stderr, "makeDirExist %s\n", path));
    strcpy(bpath, path);
    strcat(bpath, "RCS");

    if (stat(bpath, &statbuf) == 0)
	return errCode;            /* exists already */

    /* clear umask */

    umask(0);

    /* create directory */

    for (i=0;  bpath[i];  ) {       /* try bit by bit */

	if (i)
	    xpath[i-1] = '/';

	while (bpath[i]) {      /* get next bit of path */
	    xpath[i] = bpath[i];
	    if (bpath[i++] == '/')
		break;
	}
	DBUG_MIN((stderr, " i = %d, xpath = %s\n", i, xpath));

	if ( (i > 1) && (xpath[i-1] == '/'))
	    xpath[i-1] = 0;
	else
	    xpath[i] = 0;

	/* If it doesn't exist -- try to create */

	if (stat(xpath, &statbuf) == 0)
	    continue;       /* that piece is ok */

	if ( mkdir(xpath, 0777) != 0 )  {
	    otPutPostedMessage(OT_CREATE_DIR, xpath);
	    errCode = OT_CREATE_DIR;
	}
    }

    return errCode;
}



void
otFormFilen(newFile, tname)
OTFilen * newFile;
char    *tname;
{
    register char *cp, *cp1;

    strcpy(newFile->dir, "");
    strcpy(newFile->name, tname);

    if (cp=strrchr(tname, '/')) {
	cp1 = cp;
	*cp = 0;
	strcpy(newFile->dir, tname);
	strcat(newFile->dir, "/");
	strcpy(newFile->name, ++cp);
	*cp1 = '/';
    }
    return;
}



OTErr
otCopyTemplateFileToTmp(fromfile, tmpfile)
char    *fromfile;
char    *tmpfile;
{
    char command[COMMAND];

    OTErr errCode = OT_SUCCESS;

    tmpfile[0] = 0;
    tmpnam(tmpfile);

    sprintf(command, "(cp %s %s; chmod 666 %s) 2> /dev/null", 
	fromfile, tmpfile, tmpfile);
    if (system(command)) {
	otPutPostedMessage(OT_TEMPLATE_COPY_TMP, fromfile, tmpfile);
	return OT_TEMPLATE_COPY_TMP;
    }

    strcpy(rmTfile, tmpfile);

    return errCode;
}



OTErr
otSetFilterValue(label, value, filter)
char * label;	/* header field label */
char * value;	/* header field value */
OTMetaTemplate * filter;	/* filter metatemplate structure */
{
    register int j;
    OTErr errCode = OT_SUCCESS;


    for (j=0;  filter[j].field[0];  j++)
        if (!strcmp(label, filter[j].abbr))
	    break;

    if (!filter[j].field[0]) {
	otPutPostedMessage(OT_UNKNOWN_FIELD, label);
	return (OT_UNKNOWN_FIELD);
    }

    strcpy(filter[j].line, value);    /* save filter value */

    if (!value[0])
        filter[j].unassigned = TRUE;
    else
        filter[j].unassigned = FALSE;

/* Special case for the IDNUM field */
/* this code will go away when -s switch will not be supported */

    if ( (filter[j].type == TYPE_IDNUM) && filter[j].line[0])  {

	otCB->cb_pcb->pcb_filterNum[0] = 0;
	if (errCode = otParseNumFilter(j))
	    return(errCode);
	if (!filter[j].range[0])        {    /* special filter by CR numbers */
	    strcpy(otCB->cb_pcb->pcb_filterNum, filter[j].list);
	    filter[j].list[0] = 0;
	}
	else
	    errCode = otSetRange(filter[j].range, &otCB->cb_qcb->qcb_loRange,
				&otCB->cb_qcb->qcb_hiRange);
    }

    return errCode;
}


OTErr
otSetCBMember(label, value)
char * label;			/* control block structure member label */
char * value;			/* control block structure member value */
{
    int len;
    OTErr stat = OT_SUCCESS;
    
    if ( !strcmp(label, "project") ) {
	if (stat = otCopyString(value, &(otCB->cb_project) )) {
	    otPutPostedMessage( OT_MALLOC_LOCATION, "otSetCBMember()" );
	}
    }
    else if ( !strcmp(label, "altTname") ) {
	if (stat = otCopyString(value, &(otCB->cb_altTname) )) {
	    otPutPostedMessage( OT_MALLOC_LOCATION, "otSetCBMember()" );
	}
    }
    else if ( !strcmp(label, "CRNumber") ) {
	if ((otCB->cb_CRNumber = atol(value)) <= 0)  {
	    stat = OT_CLI_ZERO_NUMBER;
	    otPutPostedMessage(OT_CLI_ZERO_NUMBER, "-n (number)");
	}
    }
    else if ( !strcmp(label, "operation") ) {
	if ( !strcmp("ENTER", value) ) {
	    otCB->cb_operation = ENTER;
	} 
	else if ( !strcmp("UPDATE", value) ) {
	    otCB->cb_operation = UPDATE;
	}
	else if ( !strcmp("VALIDATE", value) ) {
	    otCB->cb_operation = VALIDATE;
	}
	else if ( !strcmp("TEMPLATE", value) ) {
	    otCB->cb_operation = TEMPLATE;
	}
	else if ( !strcmp("DELETE", value) ) {
	    otCB->cb_operation = DELETE;
	}
	else if ( !strcmp("CLOSE", value) ) {
	    otCB->cb_operation = CLOSE;
	} 
	else if ( !strcmp("QUERY", value) ) {
	    otCB->cb_operation = QUERY;
	}
	else {
		/* could not recognize it -- make it "INITIAL" */
	    otCB->cb_operation = INITIAL;
	    otPutPostedMessage( OT_ILLEGAL_OPERATION, value);
	    stat = OT_ILLEGAL_OPERATION; 
	}
	otCB->cb_pcb->pcb_operation = otCB->cb_operation;
    }
    else if ( !strcmp(label, "notify" ) ) {
        if ( !strcmp("on",  value) ) {
	    otCB->cb_notify = TRUE;
	    otCB->cb_pcb->pcb_notify = TRUE;
	}
	else if ( !strcmp("off", value) ) {
	    otCB->cb_notify = FALSE;
	    if (otCB->cb_pcb->pcb_project->block_silence == TRUE )
		otCB->cb_pcb->pcb_notify = TRUE;
	    else
		otCB->cb_pcb->pcb_notify = FALSE;
	}
	else {
	    otPutPostedMessage(OT_ILLEGAL_NOTIFICATION, value);
	    stat = OT_ILLEGAL_NOTIFICATION;
	}
    }
    else if ( !strcmp(label, "append" ) ) {
	if ( !strcmp("on",  value) )
	    otCB->cb_append = TRUE;
	else if ( !strcmp("off", value) )
	    otCB->cb_append = FALSE;
	else {
	    otPutPostedMessage(OT_ILLEGAL_APPEND, value);
	    stat = OT_ILLEGAL_APPEND;
	}
    }
    else if ( !strcmp(label, "templFile") ) {
	if (stat = otCopyString(value, &(otCB->cb_templFile) )) {
	    otPutPostedMessage( OT_MALLOC_LOCATION, "otSetCBMember()" );
	}
    }
    else if ( !strcmp(label, "dbpath") ) {
	if (stat = otCopyString(value, &(otCB->cb_dbpath) )) {
	    otPutPostedMessage( OT_MALLOC_LOCATION, "otSetCBMember()" );
	}
    }
    else if ( !strcmp(label, "layout") ) {
	if (stat = otCopyString(value, &(otCB->cb_layout) )) {
	    otPutPostedMessage( OT_MALLOC_LOCATION, "otSetCBMember()" );
	}
    }
    else if ( !strcmp(label, "prompt") ) {
	if (stat = otCopyString(value, &(otCB->cb_prompt) )) {
	    otPutPostedMessage( OT_MALLOC_LOCATION, "otSetCBMember()" );
	}
    }
    else if ( !strcmp(label, "tclString") ) {
	if (stat = otCopyString(value, &(otCB->cb_tclString) )) {
	    otPutPostedMessage( OT_MALLOC_LOCATION, "otSetCBMember()" );
	}
    }
    else if ( !strcmp(label, "tclFile") ) {
	if (stat = otCopyString(value, &(otCB->cb_tclFile) )) {
	    otPutPostedMessage( OT_MALLOC_LOCATION, "otSetCBMember()" );
	}
    }
    else if ( !strcmp(label, "tclOtrc") ) {
	if (stat = otCopyString(value, &(otCB->cb_tclOtrc) )) {
	    otPutPostedMessage( OT_MALLOC_LOCATION, "otSetCBMember()" );
	}
    }
    else {
        otPutPostedMessage( OT_INTERNAL_ERROR, "otSetCBMember()" );
	stat = OT_INTERNAL_ERROR;
    }
    return stat;

}


OTErr
otSetQCBMember(label, value)
char * label;			/* control block structure member label */
char * value;			/* control block structure member value */
{
    int len;
    OTErr errCode = OT_SUCCESS;
    

    if ( !strcmp(label, "skipHeader") ) {
	if ( !strcmp("TRUE", value) ) 
	    otCB->cb_qcb->qcb_skipHeader = TRUE;
	else if ( !strcmp("FALSE", value) )
	    otCB->cb_qcb->qcb_skipHeader = FALSE;
	else {
	    errCode = OT_INTERNAL_ERROR;
	    otPutPostedMessage(OT_INTERNAL_ERROR,
	        "otSetQCBMember - illegal value for the skipHeader indicator");
	}
    }
    else if ( !strcmp(label, "fullText") ) {
	if ( !strcmp("TRUE", value) )
	    otCB->cb_qcb->qcb_fullText = TRUE;
	else if ( !strcmp("FALSE", value) )
	    otCB->cb_qcb->qcb_fullText = FALSE;
	else {
	    errCode = OT_INTERNAL_ERROR;
	    otPutPostedMessage(OT_INTERNAL_ERROR,
	        "otSetQCBMember - illegal value for the fullText indicator");
	}
    }
    else if ( !strcmp(label, "keyInText") ) {
	if (errCode = otCopyString(value, &(otCB->cb_qcb->qcb_keyInText) )) {
	    otPutPostedMessage(OT_MALLOC_LOCATION, "otSetQCBMember()" );
	}
    }
    else if ( !strcmp(label, "nsens") ) {
	if (errCode = otCopyString(value, &(otCB->cb_qcb->qcb_nsens) )) {
	    otPutPostedMessage(OT_MALLOC_LOCATION, "otSetQCBMember()" );
	}
    }
    else if ( !strcmp(label, "outwidth") ) {
	otCB->cb_qcb->qcb_outwidth = atoi(value);
	if (otCB->cb_qcb->qcb_outwidth <= 0) {
	    errCode = OT_CLI_ZERO_NUMBER;
	    otPutPostedMessage(OT_CLI_ZERO_NUMBER, "-w (width)" );
	}
	else if (otCB->cb_qcb->qcb_outwidth > MAXWIDTH-1)
	    otCB->cb_qcb->qcb_outwidth = MAXWIDTH;
    }
    else if ( !strcmp(label, "count") ) {
	if ( !strcmp("TRUE", value) )
	    otCB->cb_qcb->qcb_count = TRUE;
	else if ( !strcmp("FALSE", value) )
	    otCB->cb_qcb->qcb_count = FALSE;
	else {
	    errCode = OT_INTERNAL_ERROR;
	    otPutPostedMessage(OT_INTERNAL_ERROR,
		"otSetQCBMember - illegal value for the count indicator");
	}
    }
    else if ( !strcmp(label, "summary") ) {
	if ( !strcmp("TRUE", value) )
	    otCB->cb_qcb->qcb_summary = TRUE;
	else if ( !strcmp("FALSE", value) )
	    otCB->cb_qcb->qcb_summary = FALSE;
	else {
	    errCode = OT_INTERNAL_ERROR;
	    otPutPostedMessage(OT_INTERNAL_ERROR,
		"otSetQCBMember - illegal value for the summary indicator");
	}
    }
    else if ( !strcmp(label, "sortField") ) {
	if (errCode = otCopyString(value, &(otCB->cb_qcb->qcb_sortField) )) {
	    otPutPostedMessage(OT_MALLOC_LOCATION, "otSetQCBMember()" );
	}
    }
    else if ( !strcmp(label, "historyLines") ) {
	if ( !strcmp("TRUE", value) )
	    otCB->cb_qcb->qcb_historyLines = TRUE;
	else if ( !strcmp("FALSE", value) )
	    otCB->cb_qcb->qcb_historyLines = FALSE;
	else {
	    errCode = OT_INTERNAL_ERROR;
	    otPutPostedMessage(OT_INTERNAL_ERROR,
	       "otSetQCBMember - illegal value for the historyLines indicator");
	}
    }
    else if ( !strcmp(label, "tabSeparate") ) {
	if ( !strcmp("TRUE", value) )
	    otCB->cb_qcb->qcb_tabSeparate = TRUE;
	else if ( !strcmp("FALSE", value) )
	    otCB->cb_qcb->qcb_tabSeparate = FALSE;
	else {
	    errCode = OT_INTERNAL_ERROR;
	    otPutPostedMessage(OT_INTERNAL_ERROR,
	        "otSetQCBMember - illegal value for the tabSeparate indicator");
	}
    }
    else {
        otPutPostedMessage( OT_INTERNAL_ERROR, "otSetCBMember()" );
	errCode = OT_INTERNAL_ERROR;
    }

    return errCode;

}



/*   otChkProjectInTemplate  -- Check project field in the template */

OTErr
otChkProjectInTemplate(tStruct, project)
OTTemplate * tStruct;   /* template structure */
char * project;		/* project name */	
{
    char * cp, *pname;
    OTErr errCode = OT_SUCCESS;

    if (cp = otGetHeaderFieldValue("Project Name", tStruct))
	pname = cp;
    else
	pname = "";

    if (project && project[0] && pname[0] && strcmp(project, pname)) {
	otPutPostedMessage(OT_DIFFERENT_PROJ, pname, project);
	errCode = OT_DIFFERENT_PROJ;
    }

    return errCode;
}



/* 
 * Read top object number for a project
 */
OTErr
otReadTopNumber(proj, number)
OTProject * proj;
long	* number;
{
    char TheNumber[COMMAND];
    FILE *fp;
    int i = 0;

    OTErr errCode = OT_SUCCESS;

    sprintf(TheNumber, "%s/%s/number", proj->proj_dir, proj->name);

    if ( ((fp = fopen(TheNumber, "r")) == NULL) ||
	 !(i = fread(TheNumber, 1, COMMAND, fp)) ) {
	otPutPostedMessage(OT_NUMBER_FILE_READ, proj->object_name);
	errCode = OT_NUMBER_FILE_READ;
    }
    fclose(fp);

    if (!errCode)
        *number = atol(TheNumber);

    return errCode;
}




/*  parseNumFilter() -- separate a range of values from the list of values
 *                      passed as a search criteria via Filter.line for
 *                      a numeric fields.
 *                      Store the range in the Filter.range, list -- in the
 *                      Filter.list
 */

OTErr
otParseNumFilter(ind)
int ind;                /* field index within the structure */
{
    register int i, j;
    char    *cp, *str;
    char    curr, prev;
    OTMetaTemplate *Filter;

    bool    list = FALSE;
    OTErr errCode = OT_SUCCESS;

    Filter = otCB->cb_qcb->qcb_filter;

    /* Allow digits and NUM_COMP_CHARS (,-<>) only to be passed
	as a numeric field search criteria */

    for (i=0; Filter[ind].line[i]; i++) {
	if ( (!isdigit(Filter[ind].line[i])) &&
		(!strchr(NUM_COMP_CHARS,Filter[ind].line[i])) ) {
	    otPutPostedMessage(OT_ILLEGAL_NUMERIC_SEARCH, Filter[ind].line, 
				Filter[ind].field);
	    return(OT_ILLEGAL_NUMERIC_SEARCH);
	}
    }

    /* Allow only one range per field (check for "-<>" char) */

    if (cp = strpbrk(Filter[ind].line, NUM_RANGE_CHARS)) {
	cp++;
	if (strpbrk(cp, NUM_RANGE_CHARS)) {
	    otPutPostedMessage(OT_MULTIPLE_RANGES, Filter[ind].line, 
			        Filter[ind].field);
	    return(OT_MULTIPLE_RANGES);
	}
    }

    str = (char *) malloc (strlen(Filter[ind].line)+1);
    curr = ',';

    for (i=0, j=0; Filter[ind].line[i]; i++) {

	if (isdigit(Filter[ind].line[i]))   {
	    str[j++] = Filter[ind].line[i];
	    continue;
	}

	prev = curr;
	if ((curr = Filter[ind].line[i]) == ',') {
	    str[j] = EOS;
	    j=0;
	    if (prev == ',')    {   /* add to the list of values */
		if (list)
		    strcat(Filter[ind].list, ",");
		strcat(Filter[ind].list, str);
		list = TRUE;
	    }
	    else                /* move the range */
		strcpy(Filter[ind].range, str);
	}
	else
	    str[j++] = Filter[ind].line[i];
    }

    str[j] = EOS;		/* move the last piece */
    if (curr == ',')    {       /* to the list */
	if (list)
	    strcat(Filter[ind].list, ",");
	strcat(Filter[ind].list, str);
    }
    else                        /* to the range */
	strcpy(Filter[ind].range, str);

    free(str);
    return(errCode);
}



/* set a range of numbers (not_bugs search criteria) */

OTErr
otSetRange(range, lo, hi)
char    *range;
long    *lo, *hi;
{
    register char *cp;
    long    tmp;
    char    *str;

    OTErr errCode = OT_SUCCESS;

    str = strdup(range);
    cp = strpbrk(str, NUM_RANGE_CHARS);

    switch (cp[0]) {
	case '>':
		cp++;
		*lo = atol(cp) +1;
		break;
	case '<':
		cp++;
		*hi = atol(cp) -1;
		break;
	case '-':
		cp[0] = EOS;
		cp++;
		*lo = atol(str);
		*hi = atol(cp);
		if (*lo > *hi) {
		    tmp = *lo;
		    *lo = *hi;
		    *hi = tmp;
		}
		break;
	default:
		errCode = OT_ILLEGAL_RANGE;
		otPutPostedMessage(OT_ILLEGAL_RANGE, str);
		break;
    }
    free(str);
    return(errCode);
}


/*
 *                                s t r d e l e t e
 *
 * Delete any of a set of characters from a target string.
 */
void
strdelete(base, todelete)
char *base;
char *todelete;
{
    int len;
    char *startp, *cp, *tp;

    tp = base;
    startp = cp = strdup(base);
    while ( *cp != 0 ) {
	if ( (len = strcspn(cp, todelete)) != -1 ) {
	    strncpy(tp, cp, len);
	    tp += len;
	    if (!len) 
	        cp++;
	    else
	        cp += len;
	}
    }
    *tp = 0;
    free(startp);
}


OTErr 
otCopyString(value, addr)
char *value;
char **addr;
{
    int len;
    char *cp;

    if (value && value[0]) {

        if ( *addr ) {

	    *addr = realloc(*addr, strlen(value) + 2);
            if ( !*addr ) {
	        return OT_MALLOC;
	    }
	    **addr = 0;
	    strcpy( *addr, value );
        }
        else {
	    cp = malloc(strlen(value) + 3);
	    *addr = cp;

	    if ( !*addr ) {
	        return OT_MALLOC;
	    }

	    strcpy( *addr, value );
        }
    }
    else {	/* remove value */
	if ( *addr ) {
	    free(*addr);
	    *addr = NULL;
	}
    }
    return OT_SUCCESS;  

}


OTErr otAppendString(value, addr)
char *value;
char **addr;
{
    int len;

    if ( *addr ) {
        *addr = realloc(*addr, (strlen(*addr) + strlen(value) + 1));
        if ( !*addr ) {
	    otPutPostedMessage( OT_MALLOC );
	    return OT_MALLOC;
	}
	strcat( *addr, value );
    }
    else {
        *addr = malloc(strlen(value) + 1);
	if ( !*addr ) {
	    otPutPostedMessage( OT_MALLOC );
	    return OT_MALLOC;
	}
	**addr = 0;
	strcpy( *addr, value );
    }
    return OT_SUCCESS;  

}


char *
otGetValue(variable, defvalue)
char * variable;            /* variable to search for */
char * defvalue;            /* default to subs if no env variable */
{
    register char * ch;

    if (ch = getenv(variable))
	return ch;
    else
	return defvalue;
}



char *
otGetOneArg(ind, argc, argv)
int   * ind;		/* index to the argv array */
int   *argc;
char ** argv;
{
    register int i;
    static char string[PATHLEN];
    int  shift = 1;

    string[0] = 0;

    if (argv[*ind][2])
	strcpy(string, &argv[*ind][2]);
    else
	if ((*ind + 1) < *argc) {
	    strcpy(string, argv[*ind + 1]);
	    shift++;
	}
    
    /* shift argv array by "shift" number of positions */
    for (i=(*ind); i < (*argc - shift); i++)
	argv[i] = argv[i+shift];

    for ( ; shift; shift--) {
	(*argc)--;
	(*ind)--;
    }

    return(string);
}

/*
 *                           o t T r i m W s
 *
 * Trim whitespace from the string.
 */
void otTrimWs(cp)
char *cp;
{

    int i;
    char *startp;
    bool spaces;
    
    startp = cp;
    DBUG_MED((stderr, "trim_ws from |%s|\n", cp));
    if (cp && *cp) {

	i = strlen(cp);

	cp = (cp + i - 1);

	spaces = TRUE;
	while ( spaces && (cp >= startp) ) {
	    if ( isspace(*cp) ) {
		*cp = 0;
		cp--;
	    } else
		spaces = FALSE;
	}
    }
    DBUG_MED((stderr, "...to...|%s|\n", startp));
}

/*
 *                        o t T r a c e L e v e l
 *
 */

void
otTraceLevel()
{
    int i;
    char *cp;

    otTracing = 0;
    if ( cp = getenv("OT_DEBUG") ) {
	i = atoi(cp);
	if ( (i >= D_MIN) && (i <= D_MAX) )
	    otTracing = i;
    }
    if ( otTracing > 0 )
	fprintf(stderr,"otTracing = %d\n", otTracing);

}

void
otCleanup()
{
    if (rmTfile[0])
	unlink(rmTfile);        /* temp file to remove */

    strcpy(rmTfile, "");
    return;
}

	
/*
 *  otParseDate()  -- Parse simple date string - mm/dd/yy
 *
 * Fills in the DateComparison to describe the date passed to it.  This
 * includes month, day, year, days-since-1970 (for date comparisons),
 * and any info about whether this was a "period" date like >3/2/91 (which
 * means "match any date since 3/2/91").
 *
 * The routine returns OT_SUCCESS if the date parsed ok.
 *
 * [pnh 12/02/91]
 * Note on parse_date(): it will convert
 *                  1x/02/91
 * to dc->month = 1, etc.
 * Is this OK?
 *
 * [nata 1/20/92]
 * Because parse_date does not check for characters strictly
 *    the input like   "1/1/92:1/20/92"  to ot_bugs will match
 *    "1/1/92" date only.
 *
 * Filed CR #121 -- fixed (1/21/92)
 *
 */
OTErr
otParseDate(s, dc)
char *s;
OTDateComparison *dc;
{
    register char *cp1, *cp2, *t;
    int i, days, offset;
    OTDateComparison d;
    OTErr dateErr;

/*
 * Eventually we should remove the 1987-1999 restriction.
 */

#define MAXDATE (99 * 12 * 31) + (12 * 31) + 31


    dc->s = s;
    /*
     * Make sure passed date contains only digits and special chars ( /.-<> ).
     */
    for (i=0; s[i]; i++)
	if (!isdigit(s[i]) && !strchr(DATE_CHARS, s[i])) {
	    return OT_ILLEGAL_DATE_FORMAT;
	}

    /*
     * Find date comparison char, if any
     */
    if ( *s == '<' || *s == '>' ) {      /* check for <,> */
	dc->comparison = *s;
	s++;
    } else				    /* else -- exact match */
	dc->comparison = '=';

    /*
     * dot (".") means today's date.  We should initialize this.
     */
    if ( (*s == '.') && ( !*(s+1) ) ) {
	dateErr = otParseDate( otGetDate(), &d);
	dc->month = d.month; 
	dc->day = d.day;
	dc->year = d.year;
	dc->days = d.days;
	return dateErr;
    }

    /*
     * Handle offsets (-3 is three days ago).
     */
    if ( (*s == '-') || (*s == '+') ) {
        for (t=s+1; *t; t++)
	   if (!isdigit(*t))
	       break;
	if (*t || (t==s+1) ) {
	    return OT_ILLEGAL_DATE_FORMAT;
	}
	offset = atoi(s+1);
	if ( ! (dateErr = otParseDate( otGetDate(), &d )) ) {
	    dc->month = d.month; 
	    dc->day = d.day;
	    dc->year = d.year;
	    dc->days = d.days;
	    if (*s == '-')
		dc->days -= offset;
	    else
		dc->days += offset;
	    if ( (*s == '-') && ( dc->days - offset > 0 ) ) {
		return OT_SUCCESS;
	    }
	    else if ( (*s == '+') && (offset + dc->days < MAXDATE) ) {
		return OT_SUCCESS;
	    }
	    else {
		return OT_ILLEGAL_DATE_FORMAT;
	    }
	} else {
	    return OT_ILLEGAL_DATE_FORMAT;
	}
    }

    cp1 = (cp1 = strchr(s, '/')) ? cp1 : strchr(s, '.');

    if (!cp1) {
	return OT_ILLEGAL_DATE_FORMAT;
    }

    cp1++;
    cp2 = (cp2 = strchr(cp1, '/')) ? cp2 : strchr(cp1, '.');

    if (!cp2) {
	return OT_ILLEGAL_DATE_FORMAT;
    }
    cp2++;

    dc->month = atoi(s);
    dc->day   = atoi(cp1);
    dc->year  = atoi(cp2);
    dc->year  = (dc->year>1900) ? (dc->year-1900) : dc->year;

    if (dc->month < 1 || dc->month > 12) {
	return OT_ILLEGAL_DATE_FORMAT;
    }
    if (dc->day < 1   || dc->day > 31) {
	return OT_ILLEGAL_DATE_FORMAT;
    }
    if (dc->year < 87 || dc->year > 99) {
	return OT_ILLEGAL_DATE_FORMAT;
    }

    days = (dc->year * (31 * 12)) + (31 * dc->month) + dc->day;
    dc->days = days;

    return OT_SUCCESS;
}

char *otGetEnumtypeList(list, proj) /* match listname to project's enumtypes */
char *list;
OTProject *proj;
{
    int i;

    if (!proj || ! proj->enum_types || !list )
        return NULL;

    for (i=0; proj->enum_types[i].typename != (char *)0 ; i++)
        if ( !strcmp(list, proj->enum_types[i].typename) )
	    return proj->enum_types[i].list;

    return NULL;


}

char *
otGetDate()
{
    register int i, j, k;
    long timer;
    struct tm * timeptr;
    static char retDate[NAMELEN];

    /*
     * Get the date from the date command
     */

    timer = time(0L);
    timeptr = localtime(&timer);
    sprintf(retDate, "%d/%d/%d", timeptr->tm_mon + 1, timeptr->tm_mday,
	timeptr->tm_year);
    return retDate;
}

char *
dayNameForNumber(n)
int n;
{
    return tlaDays[n - 1];
}

int
dayNumberForName(nm)
char *nm;
{
    int i;

    for(i = 0 ; tlaDays[i][0] ; i++)
	if ( nm[0] == tlaDays[i][0] && !strcmp(nm,
	    tlaDays[i]) )
	    break;
    return i + 1;

}

char *
monthNameForNumber(n)
int n;
{
    return tlaMonths[n - 1];
}

int
monthNumberForName(nm)
char *nm;
{
    int i;

    for(i = 0 ; tlaMonths[i][0] ; i++)
	if ( nm[0] == tlaMonths[i][0] && !strcmp(nm,
	    tlaMonths[i]) )
	    break;
    return i + 1;

}




/*  otCatchSignals()  --  handle signals..
 *
 * Different actions that can be taken:
 *
 *  Sig_Default -- default (don't ignore or catch signals)
 *  Sig_Ignore -- ignore signals
 *  Sig_Catch -- ignore SIGHUP, catch SIGINT
 *
 *  When a SIGINT is caught, throw away any outstanding
 *  edit-in-progress..
 */
void
otCatchSignals(action)
sigType action;         /* action to take on interrupt */
{

    switch (action) {

    case Sig_Default:       /* default -- don't catch or ignore */
	    signal(SIGHUP, SIG_DFL);
	    signal(SIGINT, SIG_DFL);
	    break;

    case Sig_Ignore:        /* ignore them-- */
	    signal(SIGHUP, SIG_IGN);
	    signal(SIGINT, SIG_IGN);
	    break;

    case Sig_Catch:         /* catch them-- */
	    signal(SIGHUP, SIG_IGN);    /* ignore SIGHUP */
	    signal(SIGINT, otCatchInt);  /* catch SIGINT */
	    break;
    }
}



void
otCatchInt()
{
    char *cp1;
    OTErr errCode;

    otCleanup();


#ifdef notdef
    if (gotCRfile[0] && (!otUnlockObject()) )
	write(2, 
"\n\n*** Failed to remove RCS lock from a file -- see tools group ***\n\n", 68);
#endif

    /* in OT V3.0 the otUnlockObject() is called from the otServerExit()
       function, invoked by the otBringDownServer() 
    */
    if ( errCode = otBringDownServer() ) {
	cp1 = otGetPostedMessage();
	fprintf(stderr, "\not: %s\n", cp1 ? cp1 : "error in server");
    }
    _exit(1);

}


bool
otConformEdit()
{
    int c;
    bool ret = TRUE;

    if (otCB->cb_prompt && !otCB->cb_templFile) {

	fprintf(stdout, "\nSubmit this %s? (Y/N) [Y]: ", 
				otCB->cb_pcb->pcb_project->object_name);
	c = getchar();
	if ( c != 'y' && c != 'Y' && c != '\n' ) 
	    ret = FALSE;
    }
    return ret;
}



OTErr
otEditTemplate(file)
char * file;        /* a file (template) to go and edit */
{
    char command[NAMELEN];
    char *editor;
    OTErr errCode = OT_SUCCESS;

    command[0] = 0;
    DBUG_MAX((stderr, "editTemplate %s - %s\n", file, command));

    /* Setup command line for editor */
    if ( !(editor = getenv("OT_EDITOR")) ) {
	if ( !(editor = getenv("EDITOR")) ) {
	    editor = "vi";
	}
    }

    sprintf(command, "%s %s", editor, file);

    DBUG_MAX((stderr, "editTemplate %s - %s\n", file, command));

    if (system(command)) {		/* Run it */

	otPutPostedMessage(OT_TEMPLATE_EDIT, editor, file, editor);
	errCode = OT_TEMPLATE_EDIT;
    }

    return errCode;
}

/*
 *                o t R e a d S t r i n g F r o m F i l e H a n d l e 
 *
 * Return values:
 *	OT_SUCCESS	          - String read.
 *	OT_MALLOC_LOCATION        - Error in allocating memory.
 *	OT_TRANSMISSION_CONCLUDED - String read, but xmission is over.
 *	OT_INTERNAL_ERROR	  - ungetc() failure
 */
OTErr
otReadStringFromFileHandle(cpp, fp, termChar, termFirstCol, ungetcFlag)
char **cpp;		/* malloc()'s */
FILE *fp;		/* file pointer */
char *termChar;		/* normally '\n' */
char *termFirstCol;	/* terminates when found in first column - "[" */
bool ungetcFlag;	/* put terminator char back on input queue */
{
#define RSBUFSIZE LONGVALUE
    register int remaining, totallen, ch, slen;
    register char *cp;
    bool endOfString = FALSE;
    bool firstCol;
    OTErr err = OT_SUCCESS;

    firstCol = FALSE;
    if ( termChar && termFirstCol )
        termChar = 0;

    if ( !(*cpp = malloc( RSBUFSIZE )) ) {
	otPutPostedMessage(OT_MALLOC_LOCATION, "otReadStringFromFileHandle()");
	return OT_MALLOC_LOCATION;
    } else
	totallen = remaining = RSBUFSIZE-1;
    
    cp = *cpp;
    ch = getc(fp);

    DBUG_MAX((stderr, "otR1: %c (%o)\n", ch, ch));

    if ( (ch == EOF) || !ch ) {
	endOfString = TRUE;
        if ( !ch && otCB->cb_pcb->pcb_nopened )
	    otCB->cb_pcb->pcb_xmitEnd = TRUE;
	err = OT_TRANSMISSION_CONCLUDED;
    }
    else if ( termChar && *termChar && strchr(termChar, ch) )
	endOfString = TRUE;
    else if ( termFirstCol && *termFirstCol && strchr(termFirstCol, ch) ) {
	endOfString = TRUE;
    }

    if ( endOfString ) {
        if (ungetcFlag && ch && (ch != EOF)) {
	    if (ungetc(ch, fp) != ch) {

		otPutPostedMessage(OT_INTERNAL_ERROR, "ungetc()");
		err = OT_INTERNAL_ERROR;
	    }
	}
	*cp = 0;
	return err;
    } else{
	*cp++ = ch;
	slen = 1;
	remaining--;
    }

    while ( !endOfString ) {
        DBUG_MAX((stderr, "otstr = |%s|\n", *cpp));

        if ( remaining <= 1 ) {
	    if ( !(*cpp = realloc( *cpp, totallen + RSBUFSIZE )) ) {
		otPutPostedMessage(OT_MALLOC_LOCATION,
		    "otReadStringFromFileHandle()");
		(void)free(*cpp);
		return OT_MALLOC_LOCATION;
	    } else {
		remaining = remaining + RSBUFSIZE;
		totallen = totallen + RSBUFSIZE;
		cp = *cpp + slen;
	    }
	}
	ch = getc(fp);
	DBUG_MAX((stderr, "otR2: %c (%o)\n", ch, ch));
	if ( (ch == EOF) || !ch ) {
	    endOfString = TRUE;
	    if ( !ch && otCB->cb_pcb->pcb_nopened )
		otCB->cb_pcb->pcb_xmitEnd = TRUE;
	    err = OT_TRANSMISSION_CONCLUDED;
	} else if ( termChar && strchr(termChar, ch) ) {
	    endOfString = TRUE;
	    if (ungetcFlag && ch && (ch != EOF)) {
		if (ungetc(ch, fp) != ch) {
		    otPutPostedMessage(OT_INTERNAL_ERROR, "ungetc()");
		    err = OT_INTERNAL_ERROR;
		}
	    }
	}
	else if ( firstCol && termFirstCol && strchr(termFirstCol, ch) ) {

	    endOfString = TRUE;
	    if (ungetcFlag && ch && (ch != EOF)) {
		if (ungetc(ch, fp) != ch) {
		    otPutPostedMessage(OT_INTERNAL_ERROR, "ungetc()");
		    err = OT_INTERNAL_ERROR;
		}
	    }
	}
	else {
	    firstCol = (ch == '\n') ? TRUE : FALSE;
	    *cp++ = ch;
	    remaining--;
	    slen++;
	}
    }

    *cp = 0;
    return err;

}

void
otRemoveNewline(cp)
char *cp;
{
    register char *p, *s, *t;

    if (cp) {
	for (p = cp; *p; p++) {
	    if ( *p == '\n' ) {
#ifdef notdef
/* This code deleted the newline.  I now want to make it a space. */
		for( s = p,  t = p + 1; *t; s++, t++ )
		    *s = *t;
		*s = 0;
#endif
		*p = ' ';
	    }
	}
    }
}



OTErr
otGetHeaderFromDB(num, hdr)
long num;
char **hdr;
{
    return(otGetLineFromDBfile(num, hdr, HEADERDB));
}


OTErr
otGetHistoryFromDB(num, hist)
long num;
char **hist;
{
    return(otGetLineFromDBfile(num, hist, HISTORYDB));
}


OTErr
otGetLineFromDBfile(num, cpp, db)
long num;
char ** cpp;
char *db;
{
    long  topNumber;
    char *cp;
    char  dbfile[PATHLEN];
    char  topDBnum[MAXNUMCRDIGITS+5];
    FILE *fp;

    OTProject * proj = otCB->cb_pcb->pcb_project;
    OTErr errCode = OT_SUCCESS;

    DBUG_MIN((stderr, "otGetLineFromDBfile: num=%d, db=%s, line='%s'\n", num, db, cpp));

    /* Make sure that me have a legitimate number for the project */

    if (num <= 0) {
	otPutPostedMessage(OT_ILLEGAL_ID_NUMBER, proj->object_name, num);
	return OT_ILLEGAL_ID_NUMBER;
    }

    if (errCode = otReadTopNumber(proj, &topNumber)) {
	return errCode;
    }

    DBUG_MED((stderr, "otGetLineFromDBfile: topNumber=%d\n", topNumber));

    if (num >= topNumber) {
	otPutPostedMessage(OT_NUMBER_HIGH, proj->object_name, 
		otCB->cb_CRNumber, otCB->cb_project);
	return OT_NUMBER_HIGH;
    }

    /* Get the top number from the DB file */

    sprintf(dbfile, "%s/%s/%s", proj->proj_dir, otCB->cb_project, db);

    if (errCode = otGetTopDBfileNumber(dbfile, topDBnum)) 
	return errCode;

    if (num > atoi(topDBnum)) {
	otPutPostedMessage(OT_NO_CR_IN_DBFILE, proj->object_name, num, dbfile);
	return OT_NO_CR_IN_DBFILE;
    }

    /* Find and return the line for the CR form the DB file */

    if ((fp = fopen(dbfile, "r")) == NULL) {
	otPutPostedMessage(OT_FILE_OPEN, dbfile, "otGetLineFromDBfile");
	return OT_FILE_OPEN;
    }

    *cpp = 0;
    if (errCode = otGetDBlineFromFileHandle(num, dbfile, fp, cpp)) {
	otPutPostedMessage(OT_NO_CR_IN_DBFILE, proj->object_name, num, dbfile);
	if (*cpp)  {
	    free(*cpp);
	    *cpp = 0;
	}
    }

    fclose(fp);
    return errCode;
}



OTErr
otGetDBlineFromFileHandle(num, dbfile, fp, cpp)
long num;
char *dbfile;
FILE *fp;
char ** cpp;
{
    register int i, ch, usedlen;
    register char *cp, *cp1;
    int   totlen;
    char  cur_num[MAXNUMCRDIGITS+5];
    char  num_str[MAXNUMCRDIGITS+5];

    OTProject * proj = otCB->cb_pcb->pcb_project;
    OTErr errCode = OT_SUCCESS;

    sprintf(num_str, "%ld", num);

    while (TRUE) {

        for (i=0, cur_num[0]=0, ch=getc(fp); (ch != ' ') && (ch != '\n') && (ch != EOF) && (i<MAXNUMCRDIGITS+2); i++) {
	    cur_num[i] = ch;
	    ch = getc(fp);
	}
	cur_num[i] = 0;

	DBUG_MED((stderr, "otGetDBlineFromFileHandle: cur_num = |%s| i=%d ch=%d\n", cur_num, i, ch));

	if (i && !(strcmp(num_str, cur_num)) ) {  
	
	    /* this is the line  - allocate memory and copy it */
	    if ( !(cp1 = malloc(LONGVALUE)) ) {
		otPutPostedMessage(OT_MALLOC_LOCATION, "otGetLineFromDBfile");
		errCode = OT_MALLOC_LOCATION;
		break;
	    }
	    totlen = LONGVALUE;

	    strcpy(cp1, cur_num);
	    cp = cp1 + i;
	    *cp++ = ch;
	    usedlen = i + 1;

	    while ( ((ch=fgetc(fp)) != EOF) && (ch != '\n') ) {
		if ( (totlen - usedlen) < 3) {
		    totlen += LONGVALUE;	
		    if (!(cp1 = realloc(cp1, totlen)) ) {
			otPutPostedMessage(OT_MALLOC_LOCATION, 
				"otGetLineFromDBfile");
			errCode = OT_MALLOC_LOCATION;
			break;
		    }
		    cp =  cp1 + usedlen;
		}
		*cp++=ch;
		usedlen++;
	    }
	    *cp = 0;
	    break;
	}

	if (ch == EOF) {	/* CR is not found */
	    otPutPostedMessage(OT_NO_CR_IN_DBFILE, proj->object_name, num,
		dbfile);
	    errCode = OT_NO_CR_IN_DBFILE;
	    break;
	}

	if (ch != '\n') {	/* skip the rest of the line */
	    while ( ((ch=fgetc(fp)) != EOF) && (ch != '\n') ) ;
	    if (ch == EOF) {        /* CR is not found */
		otPutPostedMessage(OT_NO_CR_IN_DBFILE, proj->object_name, num,
			dbfile);
		errCode = OT_NO_CR_IN_DBFILE;
		break;
	    }
	}
    }

    if (!errCode) {
	*cpp = cp1;
       DBUG_MED((stderr, "otGetDBlineFromFileHandle: returned = |%s|\n", *cpp));
    }

    return errCode;
}



OTErr
otGetTopDBfileNumber(dbfile, topDBnum)
char *dbfile;
char *topDBnum;
{
    register int i, ch;
    struct stat stat_buf;
    FILE  *fp;

    if (stat(dbfile, &stat_buf) != 0) {
	otPutPostedMessage(OT_STAT, dbfile);
	return OT_STAT;
    }

    /* Open DB file and extract the top CR number from it */

    if ((fp = fopen(dbfile, "r")) == NULL) {
	otPutPostedMessage(OT_FILE_OPEN, dbfile, "otGetTopDBfileNumber");
	return OT_FILE_OPEN;
    }

    for (i=0, ch=getc(fp); 
     (ch != ' ') && (ch != '\n') && (ch != EOF) && (i<MAXNUMCRDIGITS+2); i++) {
	topDBnum[i] = ch;
	ch = getc(fp);
    }
    topDBnum[i] = 0;
    fclose(fp);

    if ( (i > MAXNUMCRDIGITS) || (atoi(topDBnum) <= 0) ) {
	otPutPostedMessage(OT_DBFILE_TOP_NUM, 
		otCB->cb_pcb->pcb_project->object_name, topDBnum, dbfile);
	return OT_DBFILE_TOP_NUM;
    }
    return OT_SUCCESS;
}



OTErr
otBuildQueueItem(tp)
OTTemplate *tp;		
{

    char   num[SHORTSTR];
    char   wrkbuf[PATHLEN];
    char   tmpname[PATHLEN];
    struct stat stat_buf;
    char  *qitem;
    char  *kwikStr;
    FILE  *fp;
    OTProject *prjp;

    OTErr errCode = OT_SUCCESS;
    qitem = tmpname;
    num[0] = 0;
    kwikStr = 0;

    /* Make sure that the "otdqueue" directory exist under the OT project */

    prjp = otCB->cb_pcb->pcb_project;
    sprintf(wrkbuf, "%s/%s/otdqueue", prjp->proj_dir, otCB->cb_project);

    if (stat(wrkbuf, &stat_buf) != 0) {
	/* clear umask and create the directory */
	umask(0);
	if ( mkdir(wrkbuf, 0777) != 0 )  {
	    otPutPostedMessage(OT_CREATE_DIR, wrkbuf);
	    return OT_CREATE_DIR;
	}
    }

    /* Create qi file under the project's "otdqueue" directory */

    qitem = tempnam(wrkbuf, "qi");

    if ((fp = fopen(qitem, "w")) == NULL) {
	otPutPostedMessage(OT_CREATE_FILE, "queue item", qitem);
	if (qitem)
	    free(qitem);
	return OT_CREATE_FILE;
    }

    /* Put CR number and header line into the qitem */

    if ( errCode = otWriteHeaderFieldToKwikString(otCB->cb_ecb->ecb_tStruct,
    			num, &kwikStr) ) {
	goto errdone;
    }

    if (!num[0]) {
	otPutPostedMessage(OT_ILLEGAL_ID_NUMBER, prjp->object_name, num);
	errCode = OT_ILLEGAL_ID_NUMBER;
	goto errdone;
    }

    fprintf(fp, "%s \n%s ", num, num);

    if (kwikStr) {
        fputs(kwikStr, fp);
        free(kwikStr);
	kwikStr = 0;
    }

    /* Put history line into the qitem */

    if ( errCode = otWriteNotedataToKwikString(otCB->cb_ecb->ecb_tStruct,
    			&kwikStr) ) {
	goto errdone; 
    }

    fprintf(fp, "\n%s ", num);
    if (kwikStr) {
	fputs(kwikStr, fp);
	free(kwikStr);
	kwikStr = 0;
    }
    fputc('\n', fp);
    fclose(fp);

    if (qitem)
	free(qitem);
    return errCode;

errdone:

    if (fp) {
	fclose(fp);
	unlink(qitem);
	if (qitem)
	    free(qitem);
    }
    if (kwikStr)
	free(kwikStr);

    return errCode;
}


#ifdef hpux
char *getwd()
{
   char *getcwd();

   return getcwd();

}
#endif


/*  logWarn()  --  send a warning message to the server's log file
 *
 */
void
logWarn(fmt, va_alist)
char *fmt;
va_dcl
{
    va_list args;
    long timer;
    struct tm * timeptr;
    char times[NAMELEN];

    fprintf(otCB->cb_pcb->pcb_efp, "%s (", otCB->cb_pcb->pcb_logPid);
    timer = time(0L);
    timeptr = localtime(&timer);
    fprintf(otCB->cb_pcb->pcb_efp, 
	    "%d/%d/%d %d:%d): ", timeptr->tm_mon +1, timeptr->tm_mday, 
	    timeptr->tm_year, timeptr->tm_hour, timeptr->tm_min);

    va_start(args);
    vfprintf(otCB->cb_pcb->pcb_efp, fmt, args);
    fprintf(otCB->cb_pcb->pcb_efp, "\n");
    fflush(otCB->cb_pcb->pcb_efp);
}



/*  logError()  --  send an error message to the server's log file
 *                  and terminate this process..
 *
 */

void
logError(msg, arg)
char * msg;     /* message to send */
char * arg;     /* an optional arg */
{
    logWarn(msg, arg);
    exit(1);
}

