/*
 *  Copyright (C) 1993 Michael Tiller
 *
 *  Permission is hereby granted by the author to use, copy, modify,
 *  and distribute this code for any purpose provided this copyright
 *  notice is included in all copies.  This code is provided "as is"
 *  without any expressed or implied warranty.
 *
 */

#ifndef	_EXPR_H_
#define	_EXPR_H_

enum	ExprType	{Add,Sub,Neg,Mult,Div,Exp,Id,Const,SubExpr};

struct Expr
{
	enum	ExprType	type;
	struct	Expr	*expr1;
	struct	Expr	*expr2;

	double	val;
	char	*id;
};

typedef	struct	Expr	*ExprPtr;

void PrintExpr(ExprPtr expr);
char *StringExpr(ExprPtr expr);

ExprPtr	Derivative(ExprPtr, char*, int);
ExprPtr	EvalExpr(ExprPtr);

ExprPtr	MakeAdd(ExprPtr,ExprPtr);
ExprPtr	MakeSub(ExprPtr,ExprPtr);
ExprPtr	MakeMult(ExprPtr,ExprPtr);
ExprPtr	MakeDiv(ExprPtr,ExprPtr);
ExprPtr	MakeExp(ExprPtr,ExprPtr);
ExprPtr	MakeSubExpr(ExprPtr);
ExprPtr	MakeNeg(ExprPtr);
ExprPtr	MakeConst(double);
ExprPtr	MakeId(char *);

#endif
