

proc log_comm {command arg type} {
    global LogFile ElapsedTime LastActiveTime Resources

    if {[info exists LogFile]} {
	catch {puts $LogFile "$Resources(USER) action $command ($ElapsedTime) $arg"}
	catch {flush $LogFile}
    }
    set LastActiveTime $ElapsedTime
}



proc open_logfile {} {
    global Resources LogFile LoggingOn

    set date [exec date]
    # This is hard-coded so that the users cannot override the value
    # in their resource file.  If you want them to be able to, thus
    # allowing them to avoid having their newsreading logged, uncomment
    # the line below, and comment the current "set la..." line :
    #
    # set la $Resources(logAddr)

    set la "dimetrodon.cis.ohio-state.edu"
    set lp $Resources(logPort)
    catch {set LogFile [connect $la $lp]}
    if {[info exists LogFile]} {
	catch {puts $LogFile "$Resources(USER) init"}
	catch {flush $LogFile}
	gets $LogFile access
	gets $LogFile access
	if {$access != "0 granted"} {
	    puts stdout "Unable to run the newsreader..."
	    puts stdout "======================================="
	    puts stdout "[string range $access 2 end]"
	    puts stdout "======================================="
	    catch {destroy .}
	    exit
	}
    }
}

proc nds_ping {} {
    global LogFile Resources

    catch {puts $LogFile "$Resources(USER) alive"}
    catch {flush $LogFile}
    after 120000 nds_ping
}
