proc check_nntp_code {code} {
    
    case $code in {
	{500} {error "Error 500 - command not recognized"}
	{501} {error "Error 501 - command syntax error"}
	{502} {error "Error 502 - access restriction or permission denied"}
	{503} {error "Error 503 - program fault - command not performed"}
    }
}


	
proc server_connect {host port} {
    global Socket 

    set Socket [connect $host $port]
    return	
    set code 0
    while {$code != "200"} {
	gets $Socket line
	scan $line "%d" code
    }
}

proc stat_group {group} {
    global Socket

    puts $Socket "group $group"
    flush $Socket
    set line [gets $Socket]
    set line [string trim $line]
    set list [split $line " "]
    check_nntp_code [lindex $list 0]
    set ret [format "{%s} {%d} {%d} {%d}" [lindex $list 4] [lindex $list 2] \
	    [lindex $list 3] [lindex $list 1]]
    return $ret
}

proc load_article_list {group range field_list} {
    global GroupTable NumGroups GroupIndex
    global ArticleTable NumArticles ArticleList
    global Socket

    puts $Socket "group $group"
    flush $Socket
    gets $Socket line
    set list [split $range ","]
    foreach item $list {
	if {$item == {}} continue
	#puts stdout "LISTING RANGE $range"
	set i [string first "-" $item]
	if {$i != -1} {
	    #puts stdout "- found"
	    set l [split $item "-"]
	    if {[lindex $l 0] > [lindex $l 1]} {
		#puts stdout "switching ranges"
		set item "[lindex $l 1]-[lindex $l 0]"
		#puts stdout "ITEM NOW $item"
	    }
	}
	foreach field $field_list {
	    puts $Socket "xhdr $field $item"
	    #puts stdout "xhdr $field $item"
	    flush $Socket
	    gets $Socket line
	    set line [string trimright $line]
	    #puts stdout "lal line - '$line'"
	    scan $line "%d" code
	    check_nntp_code $code
	    #puts stdout "code = $code"
	    gets $Socket line
	    set line [string trimright $line]
	    while {$line != "."} {
		scan $line "%d" number
		if {$field == "subject"} {
		    if {[lsearch $ArticleList $number] == -1} {
			lappend ArticleList $number
			incr NumArticles
		    }
		    set ArticleTable($number,status) "r"
		    set ArticleTable($number,number) $number
		}
		set i [string first " " $line]
		set line [string range $line [expr $i+1] end]
		if {$line == "(none)"} {
		    set line ""
		}
		set ArticleTable($number,$field) $line
		if {$field == "from"} {
		    set i [string first "(" $line]
		    if {$i == -1} {
			set ArticleTable($number,email) $line
			set ArticleTable($number,name) $line
		    } else {
			set j [string last ")" $line]
			set ArticleTable($number,email) \
			    [string range $line 0 [expr $i-1]]
			set ArticleTable($number,name) \
			    [string range $line [expr $i+1] \
			     [expr $j-1]]
		    }
		}
		gets $Socket line
		set line [string trimright $line]
	    }
	}
    }
    set ArticleList [lisort $ArticleList]
}


proc get_article {group number} {
    global Socket

    set ret ""
    puts $Socket "group $group"
    flush $Socket
    gets $Socket
    puts $Socket "article $number"
    flush $Socket
    gets $Socket line
    scan $line "%d" code
    check_nntp_code $code
    if {$code != 220} {
	# we didn't get the article
	return ""
    }
    gets $Socket line
    return [GetFile $Socket nntp]
}



proc get_active {} {
    global Socket
    global1 ActiveTable NumActive 

    set NumActive 0
    set mess "Loading list of active newsgroups"
    puts $Socket "list"
    flush $Socket
    gets $Socket line
    interface_state busy
    set line [string trimright $line]
    while {$line != "."} {
	set list [split $line " "]
	# ignore any group with an = in its posting field -- it is
	# just a pointer to another group.
	if {[string first "=" [lindex $list 3]] != -1} {
	    gets $Socket line
	    set line [string trimright $line]
	    continue
	}
	set name [lindex $list 0]
	set ActiveTable($name,name) $name
	scan [lindex $list 1] "%d" ActiveTable($name,last)
	scan [lindex $list 2] "%d" ActiveTable($name,first)
	set ActiveTable($name,post) [lindex $list 3]
	incr NumActive
	gets $Socket line
	set line [string trimright $line]
    }
    interface_state normal
}


#
# For right now we just check for newsgroups created that day.
#
proc get_new_groups {time} {
    global Socket Resources
    
    set time [file mtime $Resources(NEWSRCFILE)]
    set date [strftime $time "%y%m%d %H%M%S"]
    puts $Socket "NEWGROUPS $date"
    flush $Socket
    # skip the preamble
    gets $Socket line 
    set list ""
    while {[gets $Socket line] != -1} {
	set line [string trim $line]
	if {$line == "."} {
	    return $list
	}
	lappend list $line
    }
    return $list
}
	
