# use_nodeadd.tcl
# 
# Copyright (c) 1994 R"udiger Franke
# All Rights Reserved.
# 
# Redistribution and use in any form, with or without modification, 
# is permitted, provided that the following conditions are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in other form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#       This product includes software developed by R"udiger Franke.
# 4. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#
# constructor for "use_nodeadd"
#
proc use_nodeadd {w  args} {
  upvar #0 $w this

  # user initializations

  set this(cur,compname) {}
  set this(cur,wcmd) {}
  set this(cur,wname) {}
  set this(cur,args) {}
  # data initializations

  set this(use_nodeadd) $w
  set this(title) $w.title
  set this(label0) $w.title.label0
  set this(entry0) $w.title.entry0
  set this(label1) $w.title.label1
  set this(entry1) $w.title.entry1
  set this(label2) $w.title.label2
  set this(entry2) $w.title.entry2
  set this(label3) $w.title.label3
  set this(entry3) $w.title.entry3
  set this(buttons) $w.buttons
  
  # widget creations

  frame $this(use_nodeadd) -class Use_nodeadd
  frame $this(title) 
  label $this(label0)  \
    -text "Component: "
  entry $this(entry0)  \
    -relief "sunken" \
    -textvariable "$w\(cur,compname)"
  label $this(label1)  \
    -text "Widget Cmd: "
  entry $this(entry1)  \
    -relief "sunken" \
    -textvariable "$w\(cur,wcmd)"
  label $this(label2)  \
    -text "Widget Name: "
  entry $this(entry2)  \
    -relief "sunken" \
    -textvariable "$w\(cur,wname)"
  label $this(label3)  \
    -text "Arguments: "
  entry $this(entry3)  \
    -relief "sunken" \
    -textvariable "$w\(cur,args)"
  use_buttons $this(buttons) $w {Add} {}
  
  # widget layouting

  blt_table $this(title) \
    $this(label0) 0,0 -anchor w \
    $this(entry0) 0,1 -fill x \
    $this(label1) 1,0 -anchor w \
    $this(entry1) 1,1 -fill x \
    $this(label2) 2,0 -anchor w \
    $this(entry2) 2,1 -fill x \
    $this(label3) 3,0 -anchor w -columnspan 2 \
    $this(entry3) 4,0 -fill x -columnspan 2
  blt_table column $this(title) configure 0 -resize none
  
  pack $this(buttons) -side bottom -fill x -pady 2m
  pack $this(title) -fill both -expand true
  
  
  useCreateComponent use_nodeadd $w $args

  # user additions

  blt_drag&drop target $w handler use_component \
    "$w compname \$DragDrop(use_component)"
  
  blt_drag&drop target $w handler wcommand \
    "$w wcmd \$DragDrop(wcommand)"
  
  

  return $w
}

#
# method "add"
#
proc use_nodeadd::add {w } {
  upvar #0 $w this

  if {$this(cur,compname) == {} || $this(cur,wcmd) == {} } {
    return
  }
  
  global use
  set tree $use(tree,$this(cur,compname))
  $tree nodeadd {} "$this(cur,wcmd)" "$this(cur,wname)" "$this(cur,args)"
}

#
# method "compname"
#
proc use_nodeadd::compname {w args} {
  upvar #0 $w this

  if {[llength $args] == 0} {
    return $this(cur,compname)
  } else {
    set this(cur,compname) [lindex $args 0]
  }
}

#
# method "wcmd"
#
proc use_nodeadd::wcmd {w args} {
  upvar #0 $w this

  if {[llength $args] == 0} {
    return $this(cur,wcmd)
  } else {
    set this(cur,wcmd) [lindex $args 0]
  }
}

