/*
 *	mcmodel.h
 *
 *	headerfile for mcmodel.c
 *
 *	HUFFI 29-03-94
 *
 */

#ifndef MCMODEL_H
#define MCMODEL_H

#include<stdio.h>
#include<math.h>
/*	limits.h is needed for UINT_MAX, INT_MIN and INT_MAX	*/
#include<limits.h>

/*	lenr is needed for the randomgenerator	*/
#define lenr 9689

/*	NR is the seed to be used for the randomgenerator 	*/
#define NR 1

/*	ILUL* is used for the number of neighbours in each direction
 *		ILUL1 gives direct neighbours: W and E.
 *		ILUL2 gives direct neighbours: N and S.
 *		ILUL3 gives indirect neighbours: NW and SE.
 *		ILUL4 gives indirect neighbours: NE and SW.
 */
#define ILUL1 2
#define ILUL2 2
#define ILUL3 2
#define ILUL4 2

/*	randtype is a structtype used to hold variables needed by the
 *	randomgenerator.
 */ 
struct randtype{
    unsigned int irs[lenr+1];
    unsigned int inxt[lenr+1];
    unsigned int k;
    unsigned int point;
    unsigned int poinf;};

/*	modeltype is a struct used to hold variables needed by the 
 *	2D-Isingmodel.
 *	prandstruct is a pointer to a struct of the randomgenerator used
 *		by the model.
 *	n1 is the number of points on the lattice in the x-direction.
 *	n2 is the number of points on the lattice in the y-direction.
 *	isp is a pointer to a memory area that holds n1*n2 latticepoints
 *		the value of a latticepoint can be 0 or 1, meaning nospin or
 *		spin.
 *		the memory must be allocated by the user.
 *	nxtx is a pointer to an array which holds the value of the next
 *		x-position. The array has to be made cyclic, i.e. the last
 *		x-value should point to the first.
 *	nxty is a pointer to an array which holds the value of the next 
 *		y-position. The array has to be made cyclic.
 *	nprx is a pointer to an array which holds the value of the previous
 *		x-position. The array has to be made cyclic.
 *	npry is a pointer to an array which holds the value of the previous
 *		y-position. The array has to made cyclic.
 *	beta is an array with the betas to be used in the model.
 *	ippr is an array which holds a distribution to be used by the Monte
 *		Carlo simulation. ippr[0][0][0][0] is the chance for zero spins
 *		in the neighbourhood.
 */
struct modeltype{
    struct randtype *prandstruct;
    int n1;
    int n2;
    int *isp;
    int *nxtx;
    int *nxty;
    int *nprx;
    int *npry;
    double beta[5];  /* index nul wordt niet gebruikt */
    int ippr[ILUL1+1][ILUL2+1][ILUL3+1][ILUL4+1];};


/*	InitRandom is an initialisation function for the randomgenerator */
struct randtype *InitRandom( struct randtype*, int );

/*	Random returns an array of int randomvalues	*/
int *Random( struct randtype*, int );

/*	MonteCarlo calculates a single sweep of the 2D-isingmodel with a 
 *	Monte Carlo simulation.
 */
struct modeltype *MonteCarlo( struct modeltype* );

/*	InitMonteCarlo is an initialisation function for the Monte Carlo
 *	simulation.
 */
struct modeltype *InitMonteCarlo( struct modeltype* );

/*	InitModel is a initialisation function for the model which is called
 *	by the Ising-widget.
 */
int InitModel( struct modeltype*, int, int,
	double, double, double, double, double );

/*	ModelData is the function which is called from the Ising-widget
 *	and it calls MonteCarlo which calculates one sweep.
 */	
int *ModelData( struct modeltype*, int,
	double, double, double, double, double );  

/*	GetSpinData is a function which returns a pointer to an array of spins
*/
int *GetSpinData( struct modeltype *pmodelstruct );

#endif /*MCMODEL_H*/
