# mkStyles w
#
# Create a top-level window with a text widget that demonstrates the
# various display styles that are available in texts.
#
# Arguments:
#    w -	Name to use for new top-level window.
#
# modified by k.furukawa, apr.1993. for 16bit kanji font

proc mkStyles {{w .styles}} {
    catch {destroy $w}
    toplevel $w
    dpos $w
    wm title $w "Text Demonstration - Display Styles"
    wm iconname $w "Text Styles"
    button $w.ok -text OK -command "destroy $w"
    text $w.t -relief raised -bd 2 -yscrollcommand "$w.s set" -setgrid true \
	    -width 70 -height 28 -font k14
    scrollbar $w.s -relief flat -command "$w.t yview"
    pack append $w $w.ok {bottom fillx} $w.s {right filly} $w.t {expand fill}

    # Set up display styles

    $w.t tag configure bold -font -Adobe-Courier-Bold-O-Normal-*-120-*
    $w.t tag configure big -font -Adobe-Courier-Bold-R-Normal-*-140-*
    $w.t tag configure verybig -font -Adobe-Helvetica-Bold-R-Normal-*-240-*
    if {[tk colormodel $w] == "color"} {
	$w.t tag configure color1 -background #eed5b7
	$w.t tag configure color2 -foreground red
	$w.t tag configure raised -background #eed5b7 -relief raised \
		-borderwidth 1
	$w.t tag configure sunken -background #eed5b7 -relief sunken \
		-borderwidth 1
    } else {
	$w.t tag configure color1 -background black -foreground white
	$w.t tag configure color2 -background black -foreground white
	$w.t tag configure raised -background white -relief raised \
		-borderwidth 1
	$w.t tag configure sunken -background white -relief sunken \
		-borderwidth 1
    }
    $w.t tag configure bgstipple -background black -borderwidth 0 \
	    -bgstipple gray25
    $w.t tag configure fgstipple -fgstipple gray50
    $w.t tag configure underline -underline on

    $w.t insert 0.0 {\

˼褦ʥƥȣףѤȡޤޤͼǾ
ɽ뤳Ȥǽˤʤޤɽͼʣˤϡ}
    insertWithTags $w.t tags bold
    insertWithTags $w.t {\

ƤֵѤ椵ޤԣϥƥȣףΤϰ
ʸФƻꤹ뤳ȤΤǤ̾ǤǤԣˤϤޤޤ
ɽꤹ뤳ȤǽǤԣդʸϻꤵ
ɽޤѲǽʣȤƤϰʲΤΤ
ޤ
}
    insertWithTags $w.t {
1. Font.} big
    insertWithTags $w.t {ޤޤʣؤΥեȡ}
    insertWithTags $w.t large verybig
    insertWithTags $w.t {䡡}
    insertWithTags $w.t {}
    insertWithTags $w.t {
ꤹ뤳ȤǤޤ
}
    insertWithTags $w.t {
2. Color.} big
    insertWithTags $w.t {}
    insertWithTags $w.t ط color1
    insertWithTags $w.t {䡡}
    insertWithTags $w.t ɽ color2
    insertWithTags $w.t {οޤϡ}
    insertWithTags $w.t ξ color1 color2
    insertWithTags $w.t {οѤ뤳Ȥ
ޤ
}
    insertWithTags $w.t {
3. Stippling.} big
    insertWithTags $w.t {}
    insertWithTags $w.t ط bgstipple
    insertWithTags $w.t {䡡}
    insertWithTags $w.t ɽ fgstipple
    insertWithTags $w.t {ͤˤʤ褦˻ꤹ뤳
Ǥޤ
}
    insertWithTags $w.t {
4. Underlining.} big
    insertWithTags $w.t {ʸˡ}
    insertWithTags $w.t  underline
    insertWithTags $w.t {Ĥ뤳ȤǤޤ
}
    insertWithTags $w.t {
5. 3-D effects.} big
    insertWithTags $w.t {ʸطʤμϤɽѤơʸ
}
    insertWithTags $w.t raised raised bold
    insertWithTags $w.t {ɽˤꡢ}
    insertWithTags $w.t sunken sunken bold
    insertWithTags $w.t {ɽˤǤޤ
}
    insertWithTags $w.t {
6. Yet to come.} big
    insertWithTags $w.t {ᤤˡ֡ʣʣ
䡢餯Դֳ֤ѹʤɤΤεǽѰդͽǤ
}

    $w.t mark set insert 0.0
    bind $w <Any-Enter> "focus $w.t"
}

# The procedure below inserts text into a given text widget and
# applies one or more tags to that text.  The arguments are:
#
# w		Window in which to insert
# text		Text to insert (it's inserted at the "insert" mark)
# args		One or more tags to apply to text.  If this is empty
#		then all tags are removed from the text.

proc insertWithTags {w text args} {
    set start [$w index insert]
    $w insert insert $text
    foreach tag [$w tag names $start] {
	$w tag remove $tag $start insert
    }
    foreach i $args {
	$w tag add $i $start insert
    }
}
