/*
 * Copyright 1987-1991 Regents of the University of California
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */
/*
 * Copyright 1992 by the National Optical Astronomy Observatories(*)
 *
 * Permission to use, copy, and distribute
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * This software is provided "as is" without any express or implied warranty.
 *
 * (*) Operated by the Association of Universities for Research in
 *     Astronomy, Inc. (AURA) under cooperative agreement with the
 *     National Science Foundation.
 */
/* Program: tclmain.c
 *      This file contains a test program that uses the tclipc library.
 *
 * Created: K. Gillies 26 June 1992
 * SCCS INFO
 *      @(#)tclmain.c	1.1 9/11/92
 *
 */
#include <stdio.h>
#include <assert.h>
#include <string.h>
#include "tcl.h"
#include "tclipc.h"

#define STANDALONE 1

#define FALSE 0
#define TRUE 1

/* Something I use to reduce length of arg lists */
typedef struct _tclInfo {
  Tcl_Interp *interp;
  Tcl_CmdBuf buffer;
} tclinfo, *tclInfo;
tclInfo info;

/* In file function prototypes */
static int cmdEcho _ANSI_ARGS_((ClientData *clientData, Tcl_Interp *interp, 
		int argc, char *argv[]));
static int cmdQuit _ANSI_ARGS_((ClientData *clientData, Tcl_Interp *interp, 
		int argc, char *argv[]));
static tclInfo tclInit _ANSI_ARGS_((void));
static void tclEventLoop _ANSI_ARGS_((tclInfo info));
static evalcmd_res* tclTestCmdReceive _ANSI_ARGS_((Tcl_Interp *interp, 
                  cmdText cmd));
static void Usage _ANSI_ARGS_ ((char *name));

/* Used for setting time for message checks */
#define TIMEOUTSECS      0
#define TIMEOUTUSECS     100000 

#define RECSECS 0
#define RECUSECS 0

#define MYBUFSIZ        64
/* some in file variables */
#if defined(__STDC__)
static volatile int quitFlag = FALSE;
#else
static int quitFlag = FALSE;
#endif
static int foregroundFlag = FALSE;
static char prompt[MYBUFSIZ];
static char *initCmd =
 "if [file exists [info library]/init.tcl] {source [info library]/init.tcl}";

#ifdef STANDALONE
/*
 *--------------------------------------------------------------
 *
 * main
 *
 *      Entry point for the test program.  Argv[1] is the name
 *      that should be used as the program's label.
 *
 * Results:
 *      
 *--------------------------------------------------------------
 */
int main(argc, argv)
int argc;
char *argv[];
{
  char *program;
  char *label;
  char *portmanoption;

  program = argv[0];
  portmanoption = LOCALHOST;
  /* is the label for the receiver */
  if (argc < 2) {
    Usage(program);
  }
  label = argv[1];
  sprintf(prompt, "%s> ", label);
  argc--, argv++;
  while (argc) {
    if (**argv == '-') {
      if (strcmp(*argv, "-f") == 0) {        /* start in foreground */
        foregroundFlag = TRUE;
      } else if (strcmp(*argv, "-p") == 0) {
        argc--, argv++;
        portmanoption = *argv;
      } else {
        Usage(program);
      }
    }
    argc--, argv++;
  } 

  /* Initialize my TCL stuff and the ipc code */
  info = tclInit();
  ipcInterpInit(info->interp);

  /* Use the polling and replace the receive routine */
  if (foregroundFlag) {
    ipcSendInit(TIMEOUTSECS, TIMEOUTUSECS, RECSECS, RECUSECS, 
		tclTestCmdReceive, NULL, NULL, NULL);  
  } else {
    ipcSendInit(0, 0, WAITFOREVER, WAITFOREVER, 
		tclTestCmdReceive, NULL, NULL, NULL);  
  }

  /* Create a new Receiver for this program */
  if (ipcNewReceiver(info->interp, label, portmanoption) == (Receiver)NULL) {
    fprintf(stderr, "The test program could not register its own receiver.\n");
    exit(-1);
  }
  /* Wait for events */
  if (foregroundFlag) {
    tclEventLoop(info);
  } else {
    while (!quitFlag) {
      ipcWaitForMessages();
    }
  }
  ipcDestroyAll(info->interp);

  Tcl_DeleteInterp(info->interp);
  Tcl_DeleteCmdBuf(info->buffer);
  return 0;
}

static void Usage(name)
char *name;
{
  fprintf(stderr, "usage: %s name [-f] [-p portmanhost]\n", name);
  exit(1);
}

#endif

void tclCommand()
{
  static char line[1000], *cmd;
  static int gotPartial = 0;
  int result;

  clearerr(stdin);
  if (fgets(line, 1000, stdin) == NULL) {
    if (!gotPartial) {
      return;
    }
    line[0] = 0;
  }
  cmd = Tcl_AssembleCmd(info->buffer, line);
  if (cmd == NULL) {
    gotPartial = 1;
    return;
  }

  gotPartial = 0;
  result = Tcl_Eval(info->interp, cmd, 0, (char **)NULL);
  if (result == TCL_OK) {
    if (*(info->interp->result) != 0) {
      printf("%s\n", info->interp->result);
    }
    if (quitFlag) {
      return;
    }
  } else {
    if (result == TCL_ERROR) {
      printf("Error");
    } else {
      printf("Error %d", result);
    }
    if (*(info->interp->result) != 0) {
      printf(": %s\n", info->interp->result);
    } else {
      printf("\n");
    }
  }
  fputs(prompt, stdout);
  fflush(stdout);
}



/*
 *--------------------------------------------------------------
 *
 * tclInit
 *
 *      My routine to setup an interpreter and initialize it.
 *
 * Results:
 *      A completed tclInfo structure.
 *--------------------------------------------------------------
 */
static tclInfo tclInit()
{
  int result;
  tclInfo info;

  info = (tclInfo)malloc(sizeof(tclinfo));
  assert(info != NULL);

  info->interp = Tcl_CreateInterp();

  /* Some standard tcl built-ins */
  Tcl_CreateCommand(info->interp, "echo", (Tcl_CmdProc *)cmdEcho,
                    (ClientData) "echo",
                    (Tcl_CmdDeleteProc *) NULL);
  Tcl_CreateCommand(info->interp, "quit", (Tcl_CmdProc *)cmdQuit,
                    (ClientData) 0,
                    (Tcl_CmdDeleteProc *) NULL);

  info->buffer = Tcl_CreateCmdBuf();

  /* Source the tcl library */
  result = Tcl_Eval(info->interp, initCmd, 0, (char **)NULL);
  assert(result == TCL_OK);

  return info;
}

/*
 *--------------------------------------------------------------
 *
 * tclTestCmdReceive
 *
 *      Test command receive/execution function.
 *
 * Results:
 *      Returns the result.  Duplicated here for the fun of it.
 *--------------------------------------------------------------
 */
static evalcmd_res* tclTestCmdReceive(interp, argp)
Tcl_Interp *interp;
cmdText argp;
{
  static evalcmd_res result = { 0, NULL };
#ifdef DEBUG
  static cnt = 0; 
#endif

  /* Only free after the first time */
  if (result.text != NULL) {
    free((char *)result.text);
  }
#ifdef DEBUG 
  printf(">>Test: %s %d\n", prompt, cnt++);
#endif 
  /* Evaluate and set the error */
  result.errno = Tcl_GlobalEval(interp, argp);
  result.text = strdup(interp->result);
  return(&result);
}

/*
 *--------------------------------------------------------------
 *
 * tclEventLoop
 *
 *      Stock routine to gather commands from keyboard.
 *
 * Results:
 *      void
 *--------------------------------------------------------------
 */
static void tclEventLoop(info)
tclInfo info;
{
  char line[1000], *cmd;
  int result, gotPartial;

  gotPartial = 0;
  while (1) {
    clearerr(stdin);
    if (!gotPartial) {
      fputs(prompt, stdout);
      fflush(stdout);
    }
    if (fgets(line, 1000, stdin) == NULL) {
      if (!gotPartial) {
	exit(0);
      }
      line[0] = 0;
    }
    cmd = Tcl_AssembleCmd(info->buffer, line);
    if (cmd == NULL) {
      gotPartial = 1;
      continue;
    }

    gotPartial = 0;
    result = Tcl_RecordAndEval(info->interp, cmd, 0);
    if (result == TCL_OK) {
      if (*(info->interp->result) != 0) {
	printf("%s\n", info->interp->result);
      }
      if (quitFlag) {
	return;
      }
    } else {
      if (result == TCL_ERROR) {
	printf("Error");
      } else {
	printf("Error %d", result);
      }
      if (*(info->interp->result) != 0) {
	printf(": %s\n", info->interp->result);
      } else {
	printf("\n");
      }
    }
  }
}

/*
 *--------------------------------------------------------------
 *
 * cmdEcho
 *
 *      Echo
 *
 * Results:
 *      TCL_OK or TCL_ERROR
 *--------------------------------------------------------------
 */
static int cmdEcho(clientData, interp, argc, argv)
ClientData *clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  int i;

  for (i = 1; ; i++) {
    if (argv[i] == NULL) {
      if (i != argc) {
        echoError:
        sprintf(interp->result,
          "argument list wasn't properly NULL-terminated in \"%s\" command",
          argv[0]);
      }
      break;
    }
    if (i >= argc) {
      goto echoError;
    }
    fputs(argv[i], stdout);
    if (i < (argc-1)) {
      printf(" ");
    }
  }
  printf("\n");
  return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * cmdQuit
 *
 *      A formal TCL quit command
 *
 * Results:
 *      TCL_OK or TCL_ERROR
 *--------------------------------------------------------------
 */
static int cmdQuit(clientData, interp, argc, argv)
ClientData *clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  quitFlag = TRUE;
  return TCL_OK;
}

