/*-
 * Copyright (c) 1993 Michael B. Durian.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Michael B. Durian.
 * 4. The name of the the Author may be used to endorse or promote 
 *    products derived from this software without specific prior written 
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * main.c,v 1.4 1993/05/07 17:45:03 durian Exp
 */

static char cvsid[] = "main.c,v 1.4 1993/05/07 17:45:03 durian Exp";

#include "tclInt.h"
#include "mutil.h"
#include "tclm.h"

/*
 * Declarations for library procedures:
 */

extern int isatty();

Tcl_Interp *interp;
Tcl_CmdBuf buffer;
int tty;

void usage _ANSI_ARGS_(());
extern char *optarg;

    /* ARGSUSED */
int
main(argc, argv)
	int argc;
	char **argv;
{
	static int gotPartial = 0;
	int result;
	FILE *file;
	char *args;
	char *cmd;
	int have_f;
	char buf[20];
	char line[200];
	char opt;

	have_f = 0;
	file = stdin;

	/*
	 * we want to stop parsing args when we get a -f, so the
	 * script can get the args it wants
	 */
	while (!have_f && (opt = getopt(argc, argv, "f:")) != -1) {
		switch (opt) {
		case 'f':
			if ((file = fopen(optarg, "r")) == NULL) {
				fprintf(stderr, "Couldn't open %s\n", optarg);
				exit(1);
			}
			have_f = 1;
			break;
		case '?':
			usage();
			exit(1);
		}
	}

	interp = Tcl_CreateInterp();
	args = Tcl_Merge(argc-1, argv+1);
	Tcl_SetVar(interp, "argv", args, TCL_GLOBAL_ONLY);
	ckfree(args);
	sprintf(buf, "%d", argc - 1);
	Tcl_SetVar(interp, "argc", buf, TCL_GLOBAL_ONLY);
	Tclm_InitMidi(interp);
	buffer = Tcl_CreateCmdBuf();
	tty = isatty(0);

	for (;;) {
		if (file == stdin && tty)
			printf("tclm: ");

		if (fgets(line, 200, file) == NULL)
			break;
		cmd = Tcl_AssembleCmd(buffer, line);
		if (cmd == NULL) {
			gotPartial = 1;
			continue;
		}
		gotPartial = 0;
		result = Tcl_RecordAndEval(interp, cmd, 0);
		if (*interp->result != 0) {
			if (result != TCL_OK) {
				printf("%s\n", Tcl_GetVar(interp, "errorInfo",
				    0));
				if (file !=stdin || !tty)
					break;
			} else if (file == stdin && tty) {
				printf("%s\n", interp->result);
			}
		}
	}

	Tcl_DeleteInterp(interp);
	Tcl_DeleteCmdBuf(buffer);
	exit(0);
}

void
usage()
{

	(void) fprintf(stderr, "Usage: tclm [ -f filename ]\n");
}
