

/* tclsql.h -[Fri Oct  9 18:40:34 1992 by cxh]- */

/*
 * Copyright 1992 Regents of the University of California. Permission to use,
 * copy, modify, and distribute this software and its documentation for any
 * purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies.  The University of California makes
 * no representations about the suitability of this software for any purpose.
 * It is provided 'as is' without express or implied warranty.
 */

#include <stdio.h>
#include <malloc.h>
#include <tcl.h>
#include <tclHash.h>

int             SQLopendbCmd();
int             SQLdbNameCmd();
int             SQLcommitCmd();
int             SQLclosedbCmd();

int             SQLexecCmd();
int             SQLselectCmd();
int             SQLcolNamesSelectCmd();
int             SQLcolTypesSelectCmd();
int             SQLselectRowCmd();
int             SQLimmediateCmd();
int             SQLupdateCmd();
int             SQLinsertCmd();
int             SQLdeleteCmd();

/* The following are cursor commands */;
int             SQLdeclareCursorCmd();
int             SQLprepareCursorCmd();
int             SQLdescribeCursorCmd();
int             SQLopenCursorCmd();
int             SQLfetchCursorCmd();
int             SQLmoreRowsCmd();
int             SQLcloseCursorCmd();
int             SQLcolNamesCursorCmd();
int             SQLcolTypesCursorCmd();
int             SQLlistCursorsCmd();
int             SQLisACursorCmd();
int             SQLdeleteCursorCmd();


extern int      Db_open;	/* 1 if a database is open, 0 otherwise. */
extern char     Db_name[];

/* Use {} around UNIMPLEMENTED() */
#define UNIMPLEMENTED() \
Tcl_AppendResult(interp, argv[0], "Tcl interface not yet implemented.",0); \
return TCL_ERROR

/* Use {} around USAGE() */
#define USAGE(err,usg) \
Tcl_AppendResult(interp, argv[0], ": ", err, \
                       " -- usage: \"", argv[0], " ", usg, "\"", 0); \
return TCL_ERROR

/*
 * Default number of result columns for a dynamic select. If a select
 * statement returns more than DEFAULT_ELEMENTS, then a new SQLDA will be
 * allocated.
 */
#define DEFAULT_ELEMENTS	5

/*
 * Maximum length of the index of an tcl array
 */
#define INDEX_LEN	100

/*
 * These defines control how much data a select command will return. The
 * various SQLselect commands call exec_sql() with the appropiate command op.
 */
#define SELECT_ROW	32
extern int      SelectRow;	/* Row number for SQLselectRow. */
#define SELECT_1D	16
#define SELECT_NOHDR	8
#define SELECT_COLTYPES	4	/* Return only the column types. */
#define SELECT_ALL	2	/* Return all the data in a select. */
#define SELECT_COLNAMES	1	/* Return only the column header. */

#define DBNAME_LEN	64	/* Max length of a database name. */

#define INDICE_LEN	80	/* Maximum length of an array indice. */
