#
# g_screen_scale.t
#
# An example of how to make a paint proc that draw's in units of screen pixels
# with the origin at the lower left of the widget
#
#
set doBuffering false

proc paintme {w} {
g_pushmatrix; g_pushviewport
    set w [expr 2.0/[winfo width .]+1.0]
    set h [expr 2.0/[winfo height .]+1.0]
    puts stdout [g_getfactors w h]
    g_viewport -$w $w -$h $h
    puts stdout ___[g_getviewport]
    g_font small
    g_polyfill true; g_color white
    g_makepoly; g_rect -.5 -.5 .0 .0; g_closepoly
g_popviewport; g_popmatrix
}

proc paintpos {x y} {
g_pushmatrix; g_pushviewport

    puts stdout [g_getfactors w h]
    g_viewport -$w $w -$h $h
    g_polyfill true; g_color white
    g_makepoly; g_rect -.5 -.5 .0 .0; g_closepoly

    g_color black
    g_move 8 8
    g_toworld $x $y wx wy
    g_clipping false; g_drawstr [format "%g %g" $wx $wy]; g_clipping true

g_popviewport; g_popmatrix
}

wm minsize . 64 64 
graphic .top -command {paintme .top} \
    -squareaspect false \
    -font helvetica-bold \
    -geometry 300x300 -bg black -doublebuffered $doBuffering \
    -relief raised
pack append . .top {top fill expand}
bind . <Motion> {paintpos %x %y}
update
