
#include <stdio.h>
#include <vogle.h>

/*
 *	Draws patches of various bases
 */

/*
 * patch basis types
 */

Matrix	bezier = {
	{-1.0,	3.0,	-3.0,	1.0},
	{3.0,	-6.0,	3.0,	0.0},
	{-3.0,	3.0,	0.0,	0.0},
	{1.0,	0.0,	0.0,	0.0} 
};

Matrix	cardinal = { /* Or catmull-rom */
	{-0.5,	1.5,	-1.5,	0.5},
	{1.0,	-2.5,	2.0,	-0.5},
	{-0.5,	0.0,	0.5,	0.0},
	{0.0,	1.0,	0.0,	0.0}
};

Matrix	bspline = {
	{-1.0 / 6.0,	3.0 / 6.0,	-3.0 / 6.0,	1.0 / 6.0},
	{3.0 / 6.0,	-6.0 / 6.0,	3.0 / 6.0,	0.0},
	{-3.0 / 6.0,	0.0,		3.0 / 6.0,	0.0},
	{1.0 / 6.0,	4.0 / 6.0,	1.0 / 6.0,	0.0}    
};

Matrix	power = {
	{1.0, 0.0, 0.0, 0.0},
	{0.0, 1.0, 0.0, 0.0},
	{0.0, 0.0, 1.0, 0.0},
	{0.0, 0.0, 0.0, 1.0}
};

float *basis[] = {	(float *)bezier,
			(float *)cardinal,
			(float *)bspline,
			(float *)power
		};

Matrix	x1 = {
	{0.0,   0.2588,   0.5,   0.7071},
	{0.0,   0.51764,  1.0,   1.4142},
	{0.0,   0.51764,  1.0,   1.4142},
	{0.0,   0.2588,   0.5,   0.7071}
};

Matrix	y1 = {
	{1.0,   0.966,   0.866,  0.7071},
	{2.0,   1.9318,  1.732,  1.4142},
	{2.0,   1.9318,  1.732,  1.4142},
	{1.0,   0.966,   0.866,  0.7071}
};

Matrix	z1 = {
	{1.0,   1.0,     1.0,    1.0},
	{1.0,   1.0,     1.0,    1.0},
	{0.0,   0.0,     0.0,    0.0},
	{0.0,   0.0,     0.0,    0.0}
};

Matrix	x2 = {
	{0.7071, 0.8660, 0.9660, 1.0},
	{1.4142, 1.7320, 1.932,  2.0},
	{1.4142, 1.7320, 1.932,  2.0},
	{0.7071, 0.8660, 0.9660, 1.0}
};

Matrix	y2 = {
	{0.7071, 0.5,    0.2588, 0.0},
	{1.4142, 1.0,    0.5176, 0.0},
	{1.4142, 1.0,    0.5176, 0.0},
	{0.7071, 0.5,    0.2588, 0.0}
};

Matrix	z2 = {
	{1.0,   1.0,     1.0,    1.0},
	{1.0,   1.0,     1.0,    1.0},
	{0.0,   0.0,     0.0,    0.0},
	{0.0,   0.0,     0.0,    0.0}
};

char *labels[] = {
		"Bezier Patch(es)",
		"Cardinal Patch(es)",
		"B-Spline Patch(es)",
		"'Power' Patch(es)"
		};

/*
 * demonstrate patches
 */

main()
{
	int	i, j;

	printf("	procedure init;\n	begin\n");
	for (j = 0; j < 4; j++)
		for (i = 0; i < 4; i++)
			printf("		x1[%d, %d] := %5.2f;\n", i + 1, j + 1, x1[i][j]);

	for (j = 0; j < 4; j++)
		for (i = 0; i < 4; i++)
			printf("		y1[%d, %d] := %5.2f;\n", i + 1, j + 1, y1[i][j]);

	for (j = 0; j < 4; j++)
		for (i = 0; i < 4; i++)
			printf("		z1[%d, %d] := %5.2f;\n", i + 1, j + 1, z1[i][j]);
		
	for (j = 0; j < 4; j++)
		for (i = 0; i < 4; i++)
			printf("		x2[%d, %d] := %5.2f;\n", i + 1, j + 1, x2[i][j]);

	for (j = 0; j < 4; j++)
		for (i = 0; i < 4; i++)
			printf("		y2[%d, %d] := %5.2f;\n", i + 1, j + 1, y2[i][j]);

	for (j = 0; j < 4; j++)
		for (i = 0; i < 4; i++)
			printf("		z2[%d, %d] := %5.2f;\n", i + 1, j + 1, z2[i][j]);
		
	printf("	end;\n");
}
