# cube.t

set Carray(junk) 0
set I 0
foreach i { {-1.0  -1.0  1.0}
	    {1.0  -1.0  1.0}
	    {1.0  1.0  1.0}
	    {-1.0  1.0  1.0}
	    {-1.0  -1.0  -1.0}
	    {1.0  -1.0  -1.0}
	    {1.0  1.0  -1.0}
	    {-1.0  1.0  -1.0} } {
    set J 0
    foreach j $i {
	set Carray($I$J) $j
	incr J 1
    }
    incr I 1
}

 # drawcube
 # 
 # draw the cube setting colours if available

proc drawcube {nplanes} {
	global Carray

	if {$nplanes>1} { g_color red }

	# front
	g_makepoly 
	g_move $Carray(00)  $Carray(01)  $Carray(02)
	g_draw $Carray(10)  $Carray(11)  $Carray(12)
	g_draw $Carray(20)  $Carray(21)  $Carray(22)
	g_draw $Carray(30)  $Carray(31)  $Carray(32)
	g_draw $Carray(00)  $Carray(01)  $Carray(02)
	g_closepoly 
	g_flush

	if {$nplanes > 1} { g_color green }

	# back
	g_makepoly
	g_move $Carray(50)  $Carray(51)  $Carray(52)
	g_draw $Carray(40)  $Carray(41)  $Carray(42)
	g_draw $Carray(70)  $Carray(71)  $Carray(72)
	g_draw $Carray(60)  $Carray(61)  $Carray(62)
	g_draw $Carray(50)  $Carray(51)  $Carray(52)
	g_closepoly 
	g_flush

	if {$nplanes > 1} { g_color yellow }

	# right
	g_makepoly
	g_move $Carray(10)  $Carray(11)  $Carray(12)
	g_draw $Carray(50)  $Carray(51)  $Carray(52)
	g_draw $Carray(60)  $Carray(61)  $Carray(62)
	g_draw $Carray(20)  $Carray(21)  $Carray(22)
	g_draw $Carray(10)  $Carray(11)  $Carray(12)
	g_closepoly 
	g_flush

	if {$nplanes > 1} { g_color blue }

	# left
	g_makepoly
	g_move $Carray(00)  $Carray(01)  $Carray(02)
	g_draw $Carray(30)  $Carray(31)  $Carray(32)
	g_draw $Carray(70)  $Carray(71)  $Carray(72)
	g_draw $Carray(40)  $Carray(41)  $Carray(42)
	g_draw $Carray(00)  $Carray(01)  $Carray(02)
	g_closepoly 
	g_flush

	if {$nplanes > 1} { g_color magenta }

	# top
	g_makepoly
	g_move $Carray(20)  $Carray(21)  $Carray(22)
	g_draw $Carray(60)  $Carray(61)  $Carray(62)
	g_draw $Carray(70)  $Carray(71)  $Carray(72)
	g_draw $Carray(30)  $Carray(31)  $Carray(32)
	g_draw $Carray(20)  $Carray(21)  $Carray(22)
	g_closepoly 
	g_flush

	if {$nplanes > 1} { g_color cyan }

	# bottom
	g_makepoly
	g_move $Carray(00)  $Carray(01)  $Carray(02)
	g_draw $Carray(40)  $Carray(41)  $Carray(42)
	g_draw $Carray(50)  $Carray(51)  $Carray(52)
	g_draw $Carray(10)  $Carray(11)  $Carray(12)
	g_draw $Carray(00)  $Carray(01)  $Carray(02)
	g_closepoly 
	g_flush
}


set dt .2
set t 0.0
proc paintme {{w ".top"}} {
	global argc dt t
	set nplanes [g_getdepth]
	set dr 10

	set dofill [expr $argc>1]
	g_polyfill $dofill

	g_color black
	g_clear 

	g_window -1.5  1.5  -1.5  1.5  9.0  -5.0
	g_lookat 0.0  0.0  12.0  0.0  0.0  0.0  0.0

	g_backface 1
	g_backbuffer

	for {set r 0} {$r< 360} {incr r $dr} {
			g_color black
			g_clear 
			g_pushmatrix 
			g_translate 0.0  0.0  $t
			g_rotate $r  y
			g_rotate $r  z
			g_rotate $r  x
			g_color white
			drawcube $nplanes
			if {$nplanes == 1 && $argc > 1} {
				g_polyfill 0
				g_color 0
				drawcube $nplanes
			}
			g_polyfill $dofill

			g_popmatrix 

			set t [expr $t+$dt]

			if {$t > 3.0 || $t < -18.0} {
				set dt [expr -1*$dt]
			}
			g_swapbuffers 
			g_flush
	}
	after 1 "update; paintme $w"
}

proc die {w} {
    flush stderr
    destroy $w
}

wm protocol . delete "die ."
source main.t
