#---------------------------------------------------------------------------
#
#	Toplevel Creation
#
#---------------------------------------------------------------------------

defwidget Toplevel Frame

#--	[new(toplevel) name]
#	Create a new toplevel named 'name' with generic background color.
#
defmethod Toplevel new {name args} {
  global env system

  args	title buttons stdargs actions aspect resizable \
	info windowtitle icon reuse handler logos

  if { [winfo exists $name] } {
    if { $reuse == "true" } {
      wm withdraw $name
      update
      wm deiconify $name
      update
      focus $name
      return $name
    } {
      $name Dismiss
    }
  }

  toplevel $name -background [Color slot bg] -borderwidth 0 -relief flat
  Toplevel instantiate $name {}

  if { $logos != {} } {
    Logos new *$name \
	-layout {top fillx} \
	-logos $logos
  } elseif { $title != {} } {
    Title new *$name -text $title
  }

  if { $info == "true" } {
    Infoline new *$name
  }

  if { $actions != {} } {
    Buttonpanel new $name.buttons \
	-layout {right filly} \
	-handler $handler \
	-buttons $buttons \
	-actions $actions \
  }

  if { $windowtitle == {} } {
    wm title $name $system(application)
  } {
    wm title $name $windowtitle
  }
  wm iconname $name [wm title $name]

  if { $icon != {} } {
    wm iconbitmap $name @[image $icon]
  }

  if { $aspect != {} } {
    eval [concat wm aspect $name $aspect]
  }

  if { $resizable == "true" } {
    wm minsize $name 200 300
    wm maxsize $name 1200 1000
  }

  return $name
}

