## image.tcl Procedures for displaying images
## ==============
## Copyright (C) 1993 
## Global Network Academy
## Macvicar Institute for Educational Software Development
##
## See the file COPYRIGHT for conditions

proc tkW3ImageDisplayFile {file_name} {
    global tkW3ConfigViewer tkW3ConfigImageDirectView

    if {$tkW3ConfigImageDirectView} {
	tkW3OutputClearBody
	place .f.msg.image -in .f.msg -relx 0.0 \
	    -rely 0.0 -relwidth 0.0 -relheight 0.0
	update idletasks
	set output [open  "| $tkW3ConfigViewer(image) \
-view -windowid [winfo id .f.msg.image] -private -at 1,1 $file_name" "r"]
	while {[gets $output string] != -1} {
	    .f.msg insert insert "$string\n"
	    update idletasks
	} 
	close $output
	place .f.msg.image -in .f.msg -relx 0.0 \
	    -rely 0.0 -relwidth 1.0 -relheight 1.0
	tkW3OutputSetMessage {}
    } {
	tkW3NavigatePreface {Image file
To display press the button below and wait a few seconds
} {Press here to show image} {Displaying image ...} \
"exec $tkW3ConfigImageViewer $file_name &"
    }
}

proc tkW3ImageHideImageWindow {} {
    global tkW3ConfigImageDirectView
    if {$tkW3ConfigImageDirectView} {
        tkW3ImageReleaseColorCells
	place forget .f.msg.image
    }
}

# This procedure frees the color cells that have been allocated so that 
# they can be used by other applications

proc tkW3ImageReleaseColorCells {} {
    set window [winfo id .f.msg.image]
    if {"$window" != "0x0"} {
       global tkW3ConfigViewer    
       set output \
	   [open  "| $tkW3ConfigViewer(image) -windowid $window stdin > /dev/null" "w"]
       puts $output "P1 1 1 0"
       close $output
   }
}

proc tkW3ImageEnableAnchor {anchor ismap} {
    if {$anchor == ""} {
	return
    }
    if {$ismap} {
	bind .f.msg.image <1> "tkW3NavigateRecordAndGoto $anchor?%x,%y
update"
        bind .f.msg.image <2> "tkW3NavigateClone $anchor?%x,%y
update"
	tkW3OutputEntryPrint .titles.title_entry \
	    "Anchor map link - Press on image to show link"
    } {
	bind .f.msg.image <1> "tkW3NavigateRecordAndGoto $anchor
update"
        bind .f.msg.image <2> "tkW3NavigateClone $anchor
update"
	tkW3OutputEntryPrint .titles.title_entry \
	    "Anchor link - Press on image to show link"
    }
}

proc tkW3ImageDisableAnchor {} {
    bind .f.msg.image <1> ""
}
