# File   : Motifopts.tcl
# Purpose: motif look&feel settings
# Usage  : source it and call setup_motif
# Written  by Shimon Schreiber (shimon@emc.co.il)
# Note   : was actually copied from Mark Sterin (msterin@bmc.com)

# Procedure: OptionsSetMotif_Color
#------------------------------------------------------------------
# Purpose: Set some standard values for motif look&feel for color
#         screens
#------------------------------------------------------------------
#

proc OptionsSetMotif_Color {} {
   set gen_bg              lightgray
   set gen_fg              black

   set gen_darker_bg       gray
   set gen_darker_fg       black

   set gen_active_bg       $gen_bg
   set gen_active_fg       $gen_fg

   set gen_font            -*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*
   set gen_bold_font       -*-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*
   set gen_menu_font       -*-helvetica-bold-o-normal-*-14-*-*-*-*-*-*-*
   set gen_italic_font     -*-helvetica-bold-o-normal-*-14-*-*-*-*-*-*-*


   # general stuff, everything gets these defaults unless otherwise specified
   #-------------------------------------------------------------------------

   option add *font                    $gen_font
   option add *background              $gen_bg
   option add *foreground              $gen_fg
   option add *activeBackground        $gen_active_bg
   option add *activeForeground        $gen_active_fg
   option add *disabledForeground      gray45
   option add *anchor                  w

   # buttons
   #--------
   option add  *Button.borderWidth     2
   option add  *Button.anchor          c

   # check buttons
   #--------------
   option add *Checkbutton.selector    yellow
   option add *Checkbutton.borderWidth 2

   # radio buttons
   #--------------
   option add *Radiobutton.selector    yellow
   option add *Radiobutton.borderWidth 2

   # entries
   #--------
   option add *Entry.relief            sunken
   option add *Entry.background        Blue
   option add *Entry.foreground        white
   option add *Entry.insertBackground  white
   option add *Entry.font              -*-courier-medium-r-*-*-14-*-*-*-*-*-*-*

   # labels
   #-------
   option add *Label.anchor            w
   # option add *Label.borderWidth     0
   option add *Label.borderWidth       2

   # labelframe
   #-----------
   option add *Labelframe.borderWidth  2

   # listboxs
   #---------
   option add *Listbox.background      $gen_darker_bg

   # menus
   #------
   option add *Menu*font               $gen_menu_font

   # menus buttons
   #--------------
   option add *Menubutton*font         $gen_menu_font

   # scales
   #-------
   option add *Scale.foreground        $gen_fg
   option add *Scale.activeForeground  $gen_bg
   option add *Scale.background        $gen_bg
   option add *Scale.sliderForeground  $gen_bg
   option add *Scale.sliderBackground  $gen_darker_bg
   option add *Scale.font              $gen_italic_font

   # scrollbars
   #-------
   option add *Scrollbar.foreground        $gen_bg
   option add *Scrollbar.activeForeground  $gen_bg
   option add *Scrollbar.background        $gen_darker_bg
   option add *Scrollbar.relief            sunken
}

# Procedure: setup_motif
#------------------------------------------------------------------
# Purpose: setup motif
#------------------------------------------------------------------
#

proc setup_motif {} {
   if [info exists env(TK_NO_MOTIF_OPTIONS)] {return}
   set tk_strictMotif 1
   if {[tk colormode .] == "color"} {OptionsSetMotif_Color}
}

