/*****************************************************************
 * gmerlin-avdecoder - a general purpose multimedia decoding library
 *
 * Copyright (c) 2001 - 2011 Members of the Gmerlin project
 * gmerlin-general@lists.sourceforge.net
 * http://gmerlin.sourceforge.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * *****************************************************************/

static const struct
  {
  char const * const iso_639_t;
  char const * const iso_639_b;
  char const * const iso_639_2;
  char const * const name;
  char const * const family;
  }
language_codes[] =
  {
    { "aar", "aar", "aa", "Afar", "Hamitic" },
    { "abk", "abk", "ab", "Abkhazian", "Ibero-caucasian" },
    { "ace", "ace", NULL, "Achinese", NULL },
    { "ach", "ach", NULL, "Acoli", NULL },
    { "ada", "ada", NULL, "Adangme", NULL },
    { "afa", "afa", NULL, "Afro-Asiatic (Other)", NULL },
    { "afh", "afh", NULL, "Afrihili", NULL },
    { "afr", "afr", "af", "Afrikaans", "Germanic" },
    { "aka", "aka", NULL, "Akan", NULL },
    { "akk", "akk", NULL, "Akkadian", NULL },
    { "ale", "ale", NULL, "Aleut", NULL },
    { "alg", "alg", NULL, "Algonquian languages", NULL },
    { "amh", "amh", "am", "Amharic", "Semitic" },
    { "ang", "ang", NULL, "English, Old (ca. 450-1100)", NULL },
    { "apa", "apa", NULL, "Apache languages", NULL },
    { "ara", "ara", "ar", "Arabic", "Semitic" },
    { "arc", "arc", NULL, "Aramaic", NULL },
    { "arn", "arn", NULL, "Araucanian", NULL },
    { "arp", "arp", NULL, "Arapaho", NULL },
    { "art", "art", NULL, "Artificial (Other)", NULL },
    { "arw", "arw", NULL, "Arawak", NULL },
    { "asm", "asm", "as", "Assamese", "Indian" },
    { "ath", "ath", NULL, "Athapascan languages", NULL },
    { "aus", "aus", NULL, "Australian languages", NULL },
    { "ava", "ava", NULL, "Avaric", NULL },
    { "ave", "ave", "ae", "Avestan", NULL },
    { "awa", "awa", NULL, "Awadhi", NULL },
    { "aym", "aym", "ay", "Aymara", "Amerindian" },
    { "aze", "aze", "az", "Azerbaijani", "Turkic/altaic" },
    { "bad", "bad", NULL, "Banda", NULL },
    { "bai", "bai", NULL, "Bamileke languages", NULL },
    { "bak", "bak", "ba", "Bashkir", "Turkic/altaic" },
    { "bal", "bal", NULL, "Baluchi", NULL },
    { "bam", "bam", NULL, "Bambara", NULL },
    { "ban", "ban", NULL, "Balinese", NULL },
    { "bas", "bas", NULL, "Basa", NULL },
    { "bat", "bat", NULL, "Baltic (Other)", NULL },
    { "bej", "bej", NULL, "Beja", NULL },
    { "bel", "bel", "be", "Belarusian", "Slavic" },
    { "bem", "bem", NULL, "Bemba", NULL },
    { "ben", "ben", "bn", "Bengali", "Indian" },
    { "ber", "ber", NULL, "Berber (Other)", NULL },
    { "bho", "bho", NULL, "Bhojpuri", NULL },
    { "bih", "bih", "bh", "Bihari", "Indian" },
    { "bik", "bik", NULL, "Bikol", NULL },
    { "bin", "bin", NULL, "Bini", NULL },
    { "bis", "bis", "bi", "Bislama", NULL },
    { "bla", "bla", NULL, "Siksika", NULL },
    { "bnt", "bnt", NULL, "Bantu (Other)", NULL },
    { "bod", "tib", "bo", "Tibetan", "Asian" },
    { "bos", "bos", "bs", "Bosnian", NULL },
    { "bra", "bra", NULL, "Braj", NULL },
    { "bre", "bre", "br", "Breton", "Celtic" },
    { "btk", "btk", NULL, "Batak (Indonesia)", NULL },
    { "bua", "bua", NULL, "Buriat", NULL },
    { "bug", "bug", NULL, "Buginese", NULL },
    { "bul", "bul", "bg", "Bulgarian", "Slavic" },
    { "cad", "cad", NULL, "Caddo", NULL },
    { "cai", "cai", NULL, "Central American Indian (Other)", NULL },
    { "car", "car", NULL, "Carib", NULL },
    { "cat", "cat", "ca", "Catalan", "Romance" },
    { "cau", "cau", NULL, "Caucasian (Other)", NULL },
    { "ceb", "ceb", NULL, "Cebuano", NULL },
    { "cel", "cel", NULL, "Celtic (Other)", NULL },
    { "ces", "cze", "cs", "Czech", "Slavic" },
    { "cha", "cha", "ch", "Chamorro", NULL },
    { "chb", "chb", NULL, "Chibcha", NULL },
    { "che", "che", "ce", "Chechen", NULL },
    { "chg", "chg", NULL, "Chagatai", NULL },
    { "chk", "chk", NULL, "Chuukese", NULL },
    { "chm", "chm", NULL, "Mari", NULL },
    { "chn", "chn", NULL, "Chinook jargon", NULL },
    { "cho", "cho", NULL, "Choctaw", NULL },
    { "chp", "chp", NULL, "Chipewyan", NULL },
    { "chr", "chr", NULL, "Cherokee", NULL },
    { "chu", "chu", "cu", "Church Slavic", NULL },
    { "chv", "chv", "cv", "Chuvash", NULL },
    { "chy", "chy", NULL, "Cheyenne", NULL },
    { "cmc", "cmc", NULL, "Chamic languages", NULL },
    { "cop", "cop", NULL, "Coptic", NULL },
    { "cor", "cor", "kw", "Cornish", NULL },
    { "cos", "cos", "co", "Corsican", "Romance" },
    { "cpe", "cpe", NULL, "Creoles and pidgins, English based (Other)", NULL },
    { "cpf", "cpf", NULL, "Creoles and pidgins, French-based (Other)", NULL },
    { "cpp", "cpp", NULL, "Creoles and pidgins, Portuguese-based (Other)", NULL },
    { "cre", "cre", NULL, "Cree", NULL },
    { "crp", "crp", NULL, "Creoles and pidgins (Other)", NULL },
    { "cus", "cus", NULL, "Cushitic (Other)", NULL },
    { "cym", "wel", "cy", "Welsh", "Celtic" },
    { "dak", "dak", NULL, "Dakota", NULL },
    { "dan", "dan", "da", "Danish", "Germanic" },
    { "day", "day", NULL, "Dayak", NULL },
    { "del", "del", NULL, "Delaware", NULL },
    { "den", "den", NULL, "Slave (Athapascan)", NULL },
    { "deu", "ger", "de", "German", "Germanic" },
    { "dgr", "dgr", NULL, "Dogrib", NULL },
    { "din", "din", NULL, "Dinka", NULL },
    { "div", "div", NULL, "Divehi", NULL },
    { "doi", "doi", NULL, "Dogri", NULL },
    { "dra", "dra", NULL, "Dravidian (Other)", NULL },
    { "dua", "dua", NULL, "Duala", NULL },
    { "dum", "dum", NULL, "Dutch, Middle (ca. 1050-1350)", NULL },
    { "dyu", "dyu", NULL, "Dyula", NULL },
    { "dzo", "dzo", "dz", "Dzongkha", "Asian" },
    { "efi", "efi", NULL, "Efik", NULL },
    { "egy", "egy", NULL, "Egyptian (Ancient)", NULL },
    { "eka", "eka", NULL, "Ekajuk", NULL },
    { "ell", "gre", "el", "Greek, Modern (1453-)", "Latin/greek" },
    { "elx", "elx", NULL, "Elamite", NULL },
    { "eng", "eng", "en", "English", "Germanic" },
    { "enm", "enm", NULL, "English, Middle (1100-1500)", NULL },
    { "epo", "epo", "eo", "Esperanto", "International aux." },
    { "est", "est", "et", "Estonian", "Finno-ugric" },
    { "eus", "baq", "eu", "Basque", "Basque" },
    { "ewe", "ewe", NULL, "Ewe", NULL },
    { "ewo", "ewo", NULL, "Ewondo", NULL },
    { "fan", "fan", NULL, "Fang", NULL },
    { "fao", "fao", "fo", "Faroese", "Germanic" },
    { "fas", "per", "fa", "Persian", NULL },
    { "fat", "fat", NULL, "Fanti", NULL },
    { "fij", "fij", "fj", "Fijian", "Oceanic/indonesian" },
    { "fin", "fin", "fi", "Finnish", "Finno-ugric" },
    { "fiu", "fiu", NULL, "Finno-Ugrian (Other)", NULL },
    { "fon", "fon", NULL, "Fon", NULL },
    { "fra", "fre", "fr", "French", "Romance" },
    { "frm", "frm", NULL, "French, Middle (ca. 1400-1600)", NULL },
    { "fro", "fro", NULL, "French, Old (842-ca. 1400)", NULL },
    { "fry", "fry", "fy", "Frisian", "Germanic" },
    { "ful", "ful", NULL, "Fulah", NULL },
    { "fur", "fur", NULL, "Friulian", NULL },
    { "gaa", "gaa", NULL, "Ga", NULL },
    { "gay", "gay", NULL, "Gayo", NULL },
    { "gba", "gba", NULL, "Gbaya", NULL },
    { "gem", "gem", NULL, "Germanic (Other)", NULL },
    { "gez", "gez", NULL, "Geez", NULL },
    { "gil", "gil", NULL, "Gilbertese", NULL },
    { "gla", "gla", "gd", "Gaelic (Scots)", "Celtic" },
    { "gle", "gle", "ga", "Irish", "Celtic" },
    { "glg", "glg", "gl", "Gallegan", "Romance" },
    { "glv", "glv", "gv", "Manx", NULL },
    { "gmh", "gmh", NULL, "German, Middle High (ca. 1050-1500)", NULL },
    { "goh", "goh", NULL, "German, Old High (ca. 750-1050)", NULL },
    { "gon", "gon", NULL, "Gondi", NULL },
    { "gor", "gor", NULL, "Gorontalo", NULL },
    { "got", "got", NULL, "Gothic", NULL },
    { "grb", "grb", NULL, "Grebo", NULL },
    { "grc", "grc", NULL, "Greek, Ancient (to 1453)", NULL },
    { "grn", "grn", "gn", "Guarani", "Amerindian" },
    { "guj", "guj", "gu", "Gujarati", "Indian" },
    { "gwi", "gwi", NULL, "Gwich´in", NULL },
    { "hai", "hai", NULL, "Haida", NULL },
    { "hau", "hau", "ha", "Hausa", "Negro-african" },
    { "haw", "haw", NULL, "Hawaiian", NULL },
    { "heb", "heb", "he", "Hebrew", NULL },
    { "her", "her", "hz", "Herero", NULL },
    { "hil", "hil", NULL, "Hiligaynon", NULL },
    { "him", "him", NULL, "Himachali", NULL },
    { "hin", "hin", "hi", "Hindi", "Indian" },
    { "hit", "hit", NULL, "Hittite", NULL },
    { "hmn", "hmn", NULL, "Hmong", NULL },
    { "hmo", "hmo", "ho", "Hiri Motu", NULL },
    { "hrv", "scr", "hr", "Croatian", "Slavic" },
    { "hun", "hun", "hu", "Hungarian", "Finno-ugric" },
    { "hup", "hup", NULL, "Hupa", NULL },
    { "hye", "arm", "hy", "Armenian", "Indo-european (other)" },
    { "iba", "iba", NULL, "Iban", NULL },
    { "ibo", "ibo", NULL, "Igbo", NULL },
    { "ijo", "ijo", NULL, "Ijo", NULL },
    { "iku", "iku", "iu", "Inuktitut", NULL },
    { "ile", "ile", "ie", "Interlingue", "International aux." },
    { "ilo", "ilo", NULL, "Iloko", NULL },
    { "ina", "ina", "ia", "Interlingua (International Auxiliary Language Association)", "International aux." },
    { "inc", "inc", NULL, "Indic (Other)", NULL },
    { "ind", "ind", "id", "Indonesian", NULL },
    { "ine", "ine", NULL, "Indo-European (Other)", NULL },
    { "ipk", "ipk", "ik", "Inupiaq", "Eskimo" },
    { "ira", "ira", NULL, "Iranian (Other)", NULL },
    { "iro", "iro", NULL, "Iroquoian languages", NULL },
    { "isl", "ice", "is", "Icelandic", "Germanic" },
    { "ita", "ita", "it", "Italian", "Romance" },
    { "jaw", "jav", "jw", "Javanese", NULL },
    { "jpn", "jpn", "ja", "Japanese", "Asian" },
    { "jpr", "jpr", NULL, "Judeo-Persian", NULL },
    { "kaa", "kaa", NULL, "Kara-Kalpak", NULL },
    { "kab", "kab", NULL, "Kabyle", NULL },
    { "kac", "kac", NULL, "Kachin", NULL },
    { "kal", "kal", "kl", "Kalaallisut", "Eskimo" },
    { "kam", "kam", NULL, "Kamba", NULL },
    { "kan", "kan", "kn", "Kannada", "Dravidian" },
    { "kar", "kar", NULL, "Karen", NULL },
    { "kas", "kas", "ks", "Kashmiri", "Indian" },
    { "kat", "geo", "ka", "Georgian", "Ibero-caucasian" },
    { "kau", "kau", NULL, "Kanuri", NULL },
    { "kaw", "kaw", NULL, "Kawi", NULL },
    { "kaz", "kaz", "kk", "Kazakh", "Turkic/altaic" },
    { "kha", "kha", NULL, "Khasi", NULL },
    { "khi", "khi", NULL, "Khoisan (Other)", NULL },
    { "khm", "khm", "km", "Khmer", "Asian" },
    { "kho", "kho", NULL, "Khotanese", NULL },
    { "kik", "kik", "ki", "Kikuyu", NULL },
    { "kin", "kin", "rw", "Kinyarwanda", "Negro-african" },
    { "kir", "kir", "ky", "Kirghiz", "Turkic/altaic" },
    { "kmb", "kmb", NULL, "Kimbundu", NULL },
    { "kok", "kok", NULL, "Konkani", NULL },
    { "kom", "kom", "kv", "Komi", NULL },
    { "kon", "kon", NULL, "Kongo", NULL },
    { "kor", "kor", "ko", "Korean", "Asian" },
    { "kos", "kos", NULL, "Kosraean", NULL },
    { "kpe", "kpe", NULL, "Kpelle", NULL },
    { "kro", "kro", NULL, "Kru", NULL },
    { "kru", "kru", NULL, "Kurukh", NULL },
    { "kum", "kum", NULL, "Kumyk", NULL },
    { "kur", "kur", "ku", "Kurdish", "Iranian" },
    { "kut", "kut", NULL, "Kutenai", NULL },
    { "lad", "lad", NULL, "Ladino", NULL },
    { "lah", "lah", NULL, "Lahnda", NULL },
    { "lam", "lam", NULL, "Lamba", NULL },
    { "lao", "lao", "lo", "Lao", "Asian" },
    { "lat", "lat", "la", "Latin", "Latin/greek" },
    { "lav", "lav", "lv", "Latvian", "Baltic" },
    { "lez", "lez", NULL, "Lezghian", NULL },
    { "lin", "lin", "ln", "Lingala", "Negro-african" },
    { "lit", "lit", "lt", "Lithuanian", "Baltic" },
    { "lol", "lol", NULL, "Mongo", NULL },
    { "loz", "loz", NULL, "Lozi", NULL },
    { "ltz", "ltz", "lb", "Letzeburgesch", NULL },
    { "lua", "lua", NULL, "Luba-Lulua", NULL },
    { "lub", "lub", NULL, "Luba-Katanga", NULL },
    { "lug", "lug", NULL, "Ganda", NULL },
    { "lui", "lui", NULL, "Luiseno", NULL },
    { "lun", "lun", NULL, "Lunda", NULL },
    { "luo", "luo", NULL, "Luo (Kenya and Tanzania)", NULL },
    { "lus", "lus", NULL, "lushai", NULL },
    { "mad", "mad", NULL, "Madurese", NULL },
    { "mag", "mag", NULL, "Magahi", NULL },
    { "mah", "mah", "mh", "Marshall", NULL },
    { "mai", "mai", NULL, "Maithili", NULL },
    { "mak", "mak", NULL, "Makasar", NULL },
    { "mal", "mal", "ml", "Malayalam", "Dravidian" },
    { "man", "man", NULL, "Mandingo", NULL },
    { "map", "map", NULL, "Austronesian (Other)", NULL },
    { "mar", "mar", "mr", "Marathi", "Indian" },
    { "mas", "mas", NULL, "Masai", NULL },
    { "mdr", "mdr", NULL, "Mandar", NULL },
    { "men", "men", NULL, "Mende", NULL },
    { "mga", "mga", NULL, "Irish, Middle (900-1200)", NULL },
    { "mic", "mic", NULL, "Micmac", NULL },
    { "min", "min", NULL, "Minangkabau", NULL },
    { "mis", "mis", NULL, "Miscellaneous languages", NULL },
    { "mkd", "mac", "mk", "Macedonian", "Slavic" },
    { "mkh", "mkh", NULL, "Mon-Khmer (Other)", NULL },
    { "mlg", "mlg", "mg", "Malagasy", "Oceanic/indonesian" },
    { "mlt", "mlt", "mt", "Maltese", "Semitic" },
    { "mnc", "mnc", NULL, "Manchu", NULL },
    { "mni", "mni", NULL, "Manipuri", NULL },
    { "mno", "mno", NULL, "Manobo languages", NULL },
    { "moh", "moh", NULL, "Mohawk", NULL },
    { "mol", "mol", "mo", "Moldavian", "Romance" },
    { "mon", "mon", "mn", "Mongolian", NULL },
    { "mos", "mos", NULL, "Mossi", NULL },
    { "mri", "mao", "mi", "Maori", "Oceanic/indonesian" },
    { "msa", "may", "ms", "Malay", "Oceanic/indonesian" },
    { "mul", "mul", NULL, "Multiple languages", NULL },
    { "mun", "mun", NULL, "Munda languages", NULL },
    { "mus", "mus", NULL, "Creek", NULL },
    { "mwr", "mwr", NULL, "Marwari", NULL },
    { "mya", "bur", "my", "Burmese", "Asian" },
    { "myn", "myn", NULL, "Mayan languages", NULL },
    { "nah", "nah", NULL, "Nahuatl", NULL },
    { "nai", "nai", NULL, "North American Indian", NULL },
    { "nau", "nau", "na", "Nauru", NULL },
    { "nav", "nav", "nv", "Navajo", NULL },
    { "nbl", "nbl", "nr", "Ndebele, South", NULL },
    { "nde", "nde", "nd", "Ndebele, North", NULL },
    { "ndo", "ndo", "ng", "Ndonga", NULL },
    { "nds", "nds", NULL, "Low German; Low Saxon; German, Low; Saxon, Low", NULL },
    { "nep", "nep", "ne", "Nepali", "Indian" },
    { "new", "new", NULL, "Newari", NULL },
    { "nia", "nia", NULL, "Nias", NULL },
    { "nic", "nic", NULL, "Niger-Kordofanian (Other)", NULL },
    { "niu", "niu", NULL, "Niuean", NULL },
    { "nld", "dut", "nl", "Dutch", "Germanic" },
    { "nno", "nno", "nn", "Norwegian Nynorsk", NULL },
    { "nob", "nob", "nb", "Norwegian Bokmål", NULL },
    { "non", "non", NULL, "Norse, Old", NULL },
    { "nor", "nor", "no", "Norwegian", "Germanic" },
    { "nso", "nso", NULL, "Sotho, Northern", NULL },
    { "nub", "nub", NULL, "Nubian languages", NULL },
    { "nya", "nya", "ny", "Chichewa; Nyanja", NULL },
    { "nym", "nym", NULL, "Nyamwezi", NULL },
    { "nyn", "nyn", NULL, "Nyankole", NULL },
    { "nyo", "nyo", NULL, "Nyoro", NULL },
    { "nzi", "nzi", NULL, "Nzima", NULL },
    { "oci", "oci", "oc", "Occitan (post 1500); Provençal", "Romance" },
    { "oji", "oji", NULL, "Ojibwa", NULL },
    { "ori", "ori", "or", "Oriya", "Indian" },
    { "orm", "orm", "om", "Oromo", "Hamitic" },
    { "osa", "osa", NULL, "Osage", NULL },
    { "oss", "oss", "os", "Ossetian; Ossetic", NULL },
    { "ota", "ota", NULL, "Turkish, Ottoman (1500-1928)", NULL },
    { "oto", "oto", NULL, "Otomian languages", NULL },
    { "paa", "paa", NULL, "Papuan (Other)", NULL },
    { "pag", "pag", NULL, "Pangasinan", NULL },
    { "pal", "pal", NULL, "Pahlavi", NULL },
    { "pam", "pam", NULL, "Pampanga", NULL },
    { "pan", "pan", "pa", "Panjabi", "Indian" },
    { "pap", "pap", NULL, "Papiamento", NULL },
    { "pau", "pau", NULL, "Palauan", NULL },
    { "peo", "peo", NULL, "Persian, Old (ca. 600-400 b.c.)", NULL },
    { "phi", "phi", NULL, "Philippine (Other)", NULL },
    { "pli", "pli", "pi", "Pali", NULL },
    { "pol", "pol", "pl", "Polish", "Slavic" },
    { "pon", "pon", NULL, "Pohnpeian", NULL },
    { "por", "por", "pt", "Portuguese", "Romance" },
    { "pra", "pra", NULL, "Prakrit languages", NULL },
    { "pro", "pro", NULL, "Provençal, Old (to 1500)", NULL },
    { "pus", "pus", "ps", "Pushto", "Iranian" },
    { "que", "que", "qu", "Quechua", "Amerindian" },
    { "raj", "raj", NULL, "Rajasthani", NULL },
    { "rap", "rap", NULL, "Rapanui", NULL },
    { "rar", "rar", NULL, "Rarotongan", NULL },
    { "roa", "roa", NULL, "Romance (Other)", NULL },
    { "rom", "rom", NULL, "Romany", NULL },
    { "ron", "rum", "ro", "Romanian", "Romance" },
    { "run", "run", "rn", "Rundi", "Negro-african" },
    { "rus", "rus", "ru", "Russian", "Slavic" },
    { "sad", "sad", NULL, "Sandawe", NULL },
    { "sag", "sag", "sg", "Sango", "Negro-african" },
    { "sah", "sah", NULL, "Yakut", NULL },
    { "sai", "sai", NULL, "South American Indian (Other)", NULL },
    { "sal", "sal", NULL, "Salishan languages", NULL },
    { "sam", "sam", NULL, "Samaritan Aramaic", NULL },
    { "san", "san", "sa", "Sanskrit", "Indian" },
    { "sas", "sas", NULL, "Sasak", NULL },
    { "sat", "sat", NULL, "Santali", NULL },
    { "sco", "sco", NULL, "Scots", NULL },
    { "sel", "sel", NULL, "Selkup", NULL },
    { "sem", "sem", NULL, "Semitic (Other)", NULL },
    { "sga", "sga", NULL, "Irish, Old (to 900)", NULL },
    { "sgn", "sgn", NULL, "Sign Languages", NULL },
    { "shn", "shn", NULL, "Shan", NULL },
    { "sid", "sid", NULL, "Sidamo", NULL },
    { "sin", "sin", "si", "Sinhalese", "Indian" },
    { "sio", "sio", NULL, "Siouan languages", NULL },
    { "sit", "sit", NULL, "Sino-Tibetan (Other)", NULL },
    { "sla", "sla", NULL, "Slavic (Other)", NULL },
    { "slk", "slo", "sk", "Slovak", "Slavic" },
    { "slv", "slv", "sl", "Slovenian", "Slavic" },
    { "sme", "sme", "se", "Northern Sami", NULL },
    { "smi", "smi", NULL, "Sami languages (Other)", NULL },
    { "smo", "smo", "sm", "Samoan", "Oceanic/indonesian" },
    { "sna", "sna", "sn", "Shona", "Negro-african" },
    { "snd", "snd", "sd", "Sindhi", "Indian" },
    { "snk", "snk", NULL, "Soninke", NULL },
    { "sog", "sog", NULL, "Sogdian", NULL },
    { "som", "som", "so", "Somali", "Hamitic" },
    { "son", "son", NULL, "Songhai", NULL },
    { "sot", "sot", "st", "Sotho, Southern", "Negro-african" },
    { "spa", "spa", "es", "Spanish", "Romance" },
    { "sqi", "alb", "sq", "Albanian", "Indo-european (other)" },
    { "srd", "srd", "sc", "Sardinian", NULL },
    { "srp", "scc", "sr", "Serbian", "Slavic" },
    { "srr", "srr", NULL, "Serer", NULL },
    { "ssa", "ssa", NULL, "Nilo-Saharan (Other)", NULL },
    { "ssw", "ssw", "ss", "Swati", "Negro-african" },
    { "suk", "suk", NULL, "Sukuma", NULL },
    { "sun", "sun", "su", "Sundanese", "Oceanic/indonesian" },
    { "sus", "sus", NULL, "Susu", NULL },
    { "sux", "sux", NULL, "Sumerian", NULL },
    { "swa", "swa", "sw", "Swahili", "Negro-african" },
    { "swe", "swe", "sv", "Swedish", "Germanic" },
    { "syr", "syr", NULL, "Syriac", NULL },
    { "tah", "tah", "ty", "Tahitian", NULL },
    { "tai", "tai", NULL, "Tai (Other)", NULL },
    { "tam", "tam", "ta", "Tamil", "Dravidian" },
    { "tat", "tat", "tt", "Tatar", "Turkic/altaic" },
    { "tel", "tel", "te", "Telugu", "Dravidian" },
    { "tem", "tem", NULL, "Timne", NULL },
    { "ter", "ter", NULL, "Tereno", NULL },
    { "tet", "tet", NULL, "Tetum", NULL },
    { "tgk", "tgk", "tg", "Tajik", "Iranian" },
    { "tgl", "tgl", "tl", "Tagalog", "Oceanic/indonesian" },
    { "tha", "tha", "th", "Thai", "Asian" },
    { "tig", "tig", NULL, "Tigre", NULL },
    { "tir", "tir", "ti", "Tigrinya", "Semitic" },
    { "tiv", "tiv", NULL, "Tiv", NULL },
    { "tkl", "tkl", NULL, "Tokelau", NULL },
    { "tli", "tli", NULL, "Tlingit", NULL },
    { "tmh", "tmh", NULL, "Tamashek", NULL },
    { "tog", "tog", NULL, "Tonga (Nyasa)", NULL },
    { "ton", "ton", "to", "Tonga (Tonga Islands)", "Oceanic/indonesian" },
    { "tpi", "tpi", NULL, "Tok Pisin", NULL },
    { "tsi", "tsi", NULL, "Tsimshian", NULL },
    { "tsn", "tsn", "tn", "Tswana", "Negro-african" },
    { "tso", "tso", "ts", "Tsonga", "Negro-african" },
    { "tuk", "tuk", "tk", "Turkmen", "Turkic/altaic" },
    { "tum", "tum", NULL, "Tumbuka", NULL },
    { "tur", "tur", "tr", "Turkish", "Turkic/altaic" },
    { "tut", "tut", NULL, "Altaic (Other)", NULL },
    { "tvl", "tvl", NULL, "Tuvalu", NULL },
    { "twi", "twi", "tw", "Twi", "Negro-african" },
    { "tyv", "tyv", NULL, "Tuvinian", NULL },
    { "uga", "uga", NULL, "Ugaritic", NULL },
    { "uig", "uig", "ug", "Uighur", NULL },
    { "ukr", "ukr", "uk", "Ukrainian", "Slavic" },
    { "umb", "umb", NULL, "Umbundu", NULL },
    { "und", "und", NULL, "Undetermined", NULL },
    { "urd", "urd", "ur", "Urdu", "Indian" },
    { "uzb", "uzb", "uz", "Uzbek", "Turkic/altaic" },
    { "vai", "vai", NULL, "Vai", NULL },
    { "ven", "ven", NULL, "Venda", NULL },
    { "vie", "vie", "vi", "Vietnamese", "Asian" },
    { "vol", "vol", "vo", "Volapük", "International aux." },
    { "vot", "vot", NULL, "Votic", NULL },
    { "wak", "wak", NULL, "Wakashan languages", NULL },
    { "wal", "wal", NULL, "Walamo", NULL },
    { "war", "war", NULL, "Waray", NULL },
    { "was", "was", NULL, "Washo", NULL },
    { "wen", "wen", NULL, "Sorbian languages", NULL },
    { "wol", "wol", "wo", "Wolof", "Negro-african" },
    { "xho", "xho", "xh", "Xhosa", "Negro-african" },
    { "yao", "yao", NULL, "Yao", NULL },
    { "yap", "yap", NULL, "Yapese", NULL },
    { "yid", "yid", "yi", "Yiddish", NULL },
    { "yor", "yor", "yo", "Yoruba", "Negro-african" },
    { "ypk", "ypk", NULL, "Yupik languages", NULL },
    { "zap", "zap", NULL, "Zapotec", NULL },
    { "zen", "zen", NULL, "Zenaga", NULL },
    { "zha", "zha", "za", "Zhuang", NULL },
    { "zho", "chi", "zh", "Chinese", "Asian" },
    { "znd", "znd", NULL, "Zande", NULL },
    { "zul", "zul", "zu", "Zulu", "Negro-african" },
    { "zun", "zun", NULL, "Zuni", NULL },
  };
