// Copyright 2026 Filippo Rusconi
// Inspired by code in OpenMS, by Lars Nilse

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QList>
#include <QMap>

/////////////////////// pappsomspp includes


/////////////////////// Local includes
#include "pappsomspp/export-import-config.h"

namespace pappso
{


class PMSPP_LIB_DECL CubicSplineModel
{

  public:
  CubicSplineModel();
  explicit CubicSplineModel(const QList<double> &x_values,
                            const QList<double> &y_values);
  explicit CubicSplineModel(const QMap<double, double> &x_y_values_map);

  CubicSplineModel(const CubicSplineModel &other);
  CubicSplineModel *clone(const CubicSplineModel &other);

  virtual ~CubicSplineModel();

  void setup(const QList<double> &x_values, const QList<double> &y_values);

  CubicSplineModel &operator=(const CubicSplineModel &other);

  const QList<double> &getKnots() const;

  double evalSplineAt(double x_value) const;
  double derivative(const double x_value) const;
  double derivatives(const double x_value, unsigned order) const;

  protected:
  QString m_name = "prova";
  QList<double> m_constCoeffs;
  QList<double> m_linearCoeffs;
  QList<double> m_quadraticCoeffs;
  QList<double> m_cubicCoeffs;
  QList<double> m_knots;
};

void spline_bisection(const CubicSplineModel &spline_model,
                      double const mz_at_left,
                      double const mz_at_right,
                      double &center_peak_mz,
                      double &center_peak_intensity,
                      double const threshold = 1e-6);

} // namespace pappso
