import {builtinModules} from 'node:module';
import fs from 'node:fs';
import  commonjs from '@rollup/plugin-commonjs';
import { nodeResolve } from '@rollup/plugin-node-resolve';
const pkg = JSON.parse(fs.readFileSync('package.json').toString());
if(!pkg.dependencies) pkg.dependencies={};
const file = './index.cjs';

const config = {
	input: './index.js',
	output: [{
		format: 'cjs',
		file: file,
		interop: 'esModule',
		freeze: false,
		strict: false,
		exports: 'named',
		footer: `
(function() {
  const __named = module.exports;
  module.exports = __named.default;
  for (const key of Object.keys(__named)) {
      module.exports[key] = __named[key];
  }
})();
`
	}],

	external: id =>
		builtinModules.includes(id) ||
		(!id.startsWith('.') && !id.startsWith('/')),

	plugins: [
		commonjs(),
		nodeResolve({
			modulePaths: ['node_modules', ...process.config.variables.node_relative_path.split(':').map((str) => process.config.variables.node_prefix + '/' + str)],
		}),
	]
}

export default config;
