IF(CMAKE_COMPILER_IS_GNUCC)
  SET (CMAKE_C_FLAGS_INIT "")
  SET (CMAKE_C_FLAGS_DEBUG_INIT "-g")
  SET (CMAKE_C_FLAGS_MINSIZEREL_INIT "-Os -DNDEBUG")
  SET (CMAKE_C_FLAGS_RELEASE_INIT "-O3 -DNDEBUG")
  SET (CMAKE_C_FLAGS_RELWITHDEBINFO_INIT "-O2 -g")
  SET (CMAKE_C_CREATE_PREPROCESSED_SOURCE "<CMAKE_C_COMPILER> <FLAGS> -E <SOURCE> > <PREPROCESSED_SOURCE>")
  SET (CMAKE_C_CREATE_ASSEMBLY_SOURCE "<CMAKE_C_COMPILER> <FLAGS> -S <SOURCE> -o <ASSEMBLY_SOURCE>")
  SET (CMAKE_INCLUDE_SYSTEM_FLAG_C "-isystem ")
  SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -std=c99")
  MESSAGE(STATUS "Add -std=c99 to GNU C compiler options")
#  SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fmessage-length=0")
  MESSAGE(STATUS "Add SSE3 support to GNU C compiler options")
  SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS}")
  MESSAGE(STATUS "Set SSE 4.1 support to GNU C compiler options to -msse4.1")
  SET(CMAKE_C_SSE41_FLAGS "${CMAKE_C_SSE41_FLAGS} -msse4.1")
  MESSAGE(STATUS "Add ms-extensions support to GNU C compiler options")
  SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fms-extensions")
ENDIF(CMAKE_COMPILER_IS_GNUCC)

IF(CMAKE_COMPILER_IS_GNUCXX)
  SET (CMAKE_CXX_FLAGS_INIT "")
  SET (CMAKE_CXX_FLAGS_DEBUG_INIT "-g")
  SET (CMAKE_CXX_FLAGS_MINSIZEREL_INIT "-Os -DNDEBUG")
  SET (CMAKE_CXX_FLAGS_RELEASE_INIT "-O3 -DNDEBUG")
  SET (CMAKE_CXX_FLAGS_RELWITHDEBINFO_INIT "-O2 -g")
  SET (CMAKE_CXX_CREATE_PREPROCESSED_SOURCE "<CMAKE_CXX_COMPILER> <FLAGS> -E <SOURCE> > <PREPROCESSED_SOURCE>")
  SET (CMAKE_CXX_CREATE_ASSEMBLY_SOURCE "<CMAKE_CXX_COMPILER> <FLAGS> -S <SOURCE> -o <ASSEMBLY_SOURCE>")
  SET (CMAKE_INCLUDE_SYSTEM_FLAG_CXX "-isystem ")
  #SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -std=c99")
  #MESSAGE(STATUS "Add -std=c99 to GNU C++ compiler options")
  SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fmessage-length=0")
ENDIF(CMAKE_COMPILER_IS_GNUCXX)
