## TFSA-2021-156: Use of unitialized value in TFLite

### CVE Number
CVE-2021-37682

### Impact
All TFLite operations that use quantization can be made to use unitialized
values. [For
example](https://github.com/tensorflow/tensorflow/blob/460e000de3a83278fb00b61a16d161b1964f15f4/tensorflow/lite/kernels/depthwise_conv.cc#L198-L200):

```cc
    const auto* affine_quantization =
        reinterpret_cast<TfLiteAffineQuantization*>(
            filter->quantization.params);
```

The issue stems from the fact that `quantization.params` is only valid if
`quantization.type` is different that `kTfLiteNoQuantization`. However, these
checks are missing in large parts of the code.

### Patches
We have patched the issue in GitHub commits
[537bc7c723439b9194a358f64d871dd326c18887](https://github.com/tensorflow/tensorflow/commit/537bc7c723439b9194a358f64d871dd326c18887),
[4a91f2069f7145aab6ba2d8cfe41be8a110c18a5](https://github.com/tensorflow/tensorflow/commit/4a91f2069f7145aab6ba2d8cfe41be8a110c18a5)
and
[8933b8a21280696ab119b63263babdb54c298538](https://github.com/tensorflow/tensorflow/commit/8933b8a21280696ab119b63263babdb54c298538).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
