// Copyright (C) 2014-2025 Stichting Mapcode Foundation (http://www.mapcode.com)
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// *** GENERATED FILE (dividemaps.cpp), DO NOT CHANGE OR PRETTIFY ***
// Generated for data version 2.3.0 using dividemaps.cpp
typedef struct {
    double latitude;        //
    double longitude;       //
    int nrLocalMapcodes;  // 0 if no need to test
    int nrGlobalMapcodes; // 0 if no need to test
    const char *mapcode;    // expected mapcode, empty if no need to test
} EncodeTestRecord;

static const EncodeTestRecord ENCODE_TEST[] = {
        {-90.0,       0.0,            2, 3,  "ATA ZZ.ZZ"},
        {-90.0,       0.0,            2, 3,  "ATA  HK3N.ZZLZ"},
        {36.107682,   -5.384925,      0, 0,  ""},
        {39.730401,   -79.9541635,    0, 0,  ""},
        {39.730391,   -79.954152,     0, 0,  ""},
        {5.608728,    -10.179262,     2, 0,  "LBR BZ.ZZZY-42"},
        {1.864962,    9.478995,       2, 0,  "GNQ B0Z.S18-0L"},
        {33.86476,    75.0,           3, 0,  "IN-JK J4Q.SMW-2X"},
        {7.853151,    -82.113956,     2, 3,  "PAN NVQL.1XB"},
        {8.7698,      -82.81499,      2, 5,  "CRI WQZ.VW2"},
        {-24.495,     -127.75,        1, 2,  "PCN HBP.2XK"},
        {52.387404,   4.86511,        4, 5,  "NLD 00.A0"},
        {-60.0,       0.0,            1, 2,  "ATA HGPC.Z0LH"},
        {0.0,         0.0,            1, 1,  "HHHHC.X0KG"},
        {0.0,         179.999999,     2, 3,  "KIR L384.7K5"},
        {0.0,         180.0,          2, 3,  "KIR L384.7K5"},
        {0.0,         -180.0,         2, 3,  "KIR L384.7K5"},
        {0.0,         -179.999999,    2, 3,  "KIR L384.7K5"},
        {90.0,        0.0,            1, 1,  "ZH0H0.H1HG"},
        {26.423556,   -113.610855,    1, 9,  "USA LMX0.80JK"},
        {-10.570302,  56.494384,      2, 3,  "MUS 707W.FXZ"},
        {26.904854,   95.138497,      5, 21, "IN-NL WKS.H6"},
        {35.867,      -3.42600001,    2, 5,  "ESP SH74.H7MG-7"},
        {46.12971,    20.784451,      2, 8,  "ROU GFWB.JNK-WN"},
        {-48.406038,  0.008228,       1, 1,  "4HHRT.3P66-2"},
        {-48.406038,  -179.991772,    2, 3,  "NZL SKT5.3H3F-H"},
        {26.9048545,  95.1384983,     0, 0,  "IN-NL W7Y.9W9B-9R"},
        {52.383984,   4.865401375,    0, 0,  "NLD 00.XX"},
        {52.383984,   4.865401375,    0, 0,  "   NLD 00.XX"},
        {52.383984,   4.865401375,    0, 0,  "NLD    00.XX"},
        {52.383984,   4.865401375,    0, 0,  "NLD 00.XX   "},
        {52.383984,   4.865401375,    0, 0,  "   NLD    00.XX   "},
        {52.383984,   4.865401375,    0, 0,  "nld oo.xx"},
        {52.383984,   4.865401375,    0, 0,  "  nld   oo.xx   "},
        {41.9035,     12.452,         2, 8,  "VAT 5D.2J"},
        {41.9035,     12.452,         2, 8,  "VAT J0PX.VN7"},
        {43.750047,   7.406609,       2, 6,  "MCO 12.XX"},
        {43.738347,   7.424291,       2, 6,  "MCO VSFV.J71"},
        {36.154689,   -5.380998,      3, 7,  "GIB 12.XX"},
        {36.133629,   -5.353212,      3, 7,  "GIB KNP.PT2"},
        {36.133629,   -5.353212,      3, 7,  "GIB 6FCF.4C6"},
        {-8.522836,   -172.5324515,   2, 4,  "TKL 12.XX"},
        {-9.074885,   -171.9962215,   2, 4,  "TKL 000.XX"},
        {-9.295873,   -171.4985805,   2, 4,  "TKL J00.XX"},
        {-8.3297165,  -172.5074215,   1, 3,  "TKL 123.XXX"},
        {-12.146775,  96.815659,      2, 3,  "CCK 00.XX"},
        {-12.174062,  96.889234,      2, 3,  "CCK J0.XX"},
        {-11.818779,  96.65506,       1, 2,  "CCK 12.XXX"},
        {17.9391,     -62.871574,     2, 3,  "BLM 12.XX"},
        {18.0067855,  -62.9383185,    1, 2,  "BLM 12.XXX"},
        {-0.4939295,  166.9033795,    1, 4,  "NRU 12.XX"},
        {-8.523974,   179.165565,     3, 5,  "TUV 12.XX"},
        {-8.661805,   179.009289,     2, 4,  "TUV 0H.S0F"},
        {-9.443935,   179.794045,     2, 4,  "TUV 97.S0X"},
        {-8.086627,   178.286189,     2, 4,  "TUV CC.S14"},
        {-7.530279,   178.634053,     2, 4,  "TUV J6.S14"},
        {-7.270379,   177.115653,     2, 4,  "TUV L6.S14"},
        {-6.336379,   176.273753,     2, 4,  "TUV N6.S14"},
        {-6.165535,   177.270145,     2, 4,  "TUV Q7.S0X"},
        {-5.719791,   176.037937,     2, 4,  "TUV T7.S0Y"},
        {-10.788635,  179.424345,     2, 4,  "TUV X7.S0X"},
        {-5.96918,    176.1713085,    1, 3,  "TUV 1234.XXX"},
        {22.123545,   113.5307645,    1, 6,  "MAC 12.XX"},
        {18.0821,     -63.104574,     2, 5,  "SXM 12.XX"},
        {18.1264355,  -63.1481435,    1, 3,  "SXM 12.XXX"},
        {18.0821,     -63.104574,     2, 5,  "MAF 12.XX"},
        {18.1264355,  -63.1481435,    1, 3,  "MAF 12.XXX"},
        {-28.9989,    167.909058,     2, 3,  "NFK 12.XX"},
        {-28.934931,  167.8272365,    1, 2,  "NFK 12.XXX"},
        {-25.076258,  -130.1340665,   2, 3,  "PCN 00.XX"},
        {-23.906262,  -130.767582375, 2, 3,  "PCN C0.XX"},
        {-24.689801,  -124.8106835,   2, 3,  "PCN P0.XX"},
        {-24.215153,  -128.503824,    2, 3,  "PCN 12.XXX"},
        {-24.1361025, -130.596492,    1, 2,  "PCN 123.XXX"},
        {-54.4008445, 3.2888445,      2, 3,  "BVT 12.XX"},
        {-54.304931,  3.2027115,      1, 2,  "BVT 12.XXX"},
        {32.309545,   -64.817631,     2, 4,  "BMU 00.XX"},
        {32.256495,   -64.88396,      2, 4,  "BMU J0.XX"},
        {32.496592,   -65.010164,     1, 3,  "BMU 12.XXX"},
        {-7.262839,   72.353429,      3, 4,  "IOT 12.XX"},
        {-7.208347,   72.322823,      2, 3,  "IOT 12.XXX"},
        {-5.492458,   71.714223,      2, 3,  "IOT 123.XX"},
        {-5.2080165,  70.6061695,     1, 2,  "IOT 123.XXX"},
        {43.961945,   12.40265,       4, 8,  "SMR 00.XX"},
        {43.942655,   12.466633,      4, 8,  "SMR J0.XX"},
        {43.94285,    12.501602,      4, 8,  "SMR 80.DQFN"},
        {43.94285,    12.45967,       4, 8,  "SMR ZQRQ.TQ"},
        {43.94285,    12.45967,       4, 8,  "SMR 3QK.RQCT"},
        {43.94285,    12.45967,       4, 8,  "SMR HZVZ.YN6"},
        {49.416225,   -2.615847,      3, 6,  "GGY 12.XX"},
        {49.7757405,  -2.668657,      2, 5,  "GGY 12.XXX"},
        {49.595637,   -2.381287,      2, 5,  "GGY NYGR.CSS"},
        {18.211385,   -63.103407,     2, 3,  "AIA 12.XX"},
        {18.5051,     -63.405745,     1, 2,  "AIA 12.XXX"},
        {16.718335,   -62.2386175,    2, 3,  "MSR 12.XX"},
        {16.858537,   -62.3148,       1, 2,  "MSR 12.XXX"},
        {49.2007225,  -2.234798,      3, 6,  "JEY 12.XX"},
        {49.300676,   -2.259926,      2, 5,  "JEY 12.XXX"},
        {49.220288,   -2.134781,      2, 5,  "JEY PZ2Q.YHG"},
        {-10.417171,  105.6367965,    2, 4,  "CXR 12.XX"},
        {-10.366393,  105.505653,     1, 3,  "CXR 12.XXX"},
        {-13.232345,  -176.22369275,  3, 4,  "WLF 00.XX"},
        {-13.269326,  -176.21821825,  3, 4,  "WLF 70.XX"},
        {-13.277395,  -176.22043825,  3, 4,  "WLF F0.XX"},
        {-13.305625,  -176.24507125,  3, 4,  "WLF M0.XX"},
        {-13.343876,  -176.22319125,  3, 4,  "WLF T0.XX"},
        {-14.1760855, -178.2087635,   2, 3,  "WLF 12.XXX"},
        {-13.4277995, -176.3398425,   2, 3,  "WLF 123.XX"},
        {-13.2347255, -176.199782,    3, 4,  "WLF XLG.3GP"},
        {18.446545,   -64.639763125,  3, 5,  "VGB 00.XX"},
        {18.398515,   -64.713921625,  3, 8,  "VGB J0.XX"},
        {18.371455,   -64.85138575,   2, 7,  "VGB 00.XXX"},
        {18.463445,   -64.49379875,   2, 3,  "VGB C0.XXX"},
        {18.797075,   -64.598815625,  2, 4,  "VGB P0.XXX"},
        {18.4357095,  -64.59959,      3, 5,  "VGB D0C.8M0"},
        {47.088162,   9.474175125,    3, 9,  "LIE 00.XX"},
        {47.126681,   9.519525125,    3, 9,  "LIE 70.XX"},
        {47.14369,    9.509687625,    3, 9,  "LIE F0.XX"},
        {47.199309,   9.485981375,    3, 9,  "LIE M0.XX"},
        {47.216318,   9.49989775,     3, 9,  "LIE T0.XX"},
        {47.2527705,  9.478642,       2, 8,  "LIE 12.XXX"},
        {47.159,      9.556,          3, 9,  "LIE 8Y2T.NT7"},
        {12.559837,   -70.057691,     2, 3,  "ABW 12.XX"},
        {12.625701,   -70.0984985,    1, 2,  "ABW 12.XXX"},
        {8.7720275,   167.711622,     3, 4,  "MHL 12.XX"},
        {7.315998,    170.98863,      2, 3,  "MHL 12.XXX"},
        {7.28438,     168.546592,     2, 3,  "MHL 123.XX"},
        {14.860715,   168.75919,      2, 3,  "MHL 012.XXX"},
        {4.964946,    168.506462,     2, 3,  "MHL 112.XXX"},
        {10.022115,   160.6919115,    2, 6,  "MHL 212.XXX"},
        {11.543015,   166.6275115,    2, 3,  "MHL 312.XXX"},
        {19.291615,   166.404555,     2, 3,  "MHL 412.XXX"},
        {6.2982225,   169.3760175,    2, 3,  "MHL 512.XXX"},
        {6.291229,    171.733383,     2, 3,  "MHL 612.XXX"},
        {7.3229,      171.525337,     2, 3,  "MHL 712.XXX"},
        {5.816015,    167.909625,     2, 3,  "MHL 812.XXX"},
        {11.350415,   166.1317115,    2, 3,  "MHL 912.XXX"},
        {10.520415,   169.7227115,    2, 3,  "MHL B12.XXX"},
        {8.414305,    170.871866,     2, 3,  "MHL C12.XXX"},
        {11.695615,   162.0274115,    2, 3,  "MHL D12.XXX"},
        {11.796215,   165.1964115,    2, 3,  "MHL F12.XXX"},
        {5.843415,    168.912125,     2, 3,  "MHL G12.XXX"},
        {9.138315,    166.0284115,    2, 3,  "MHL H12.XXX"},
        {8.513415,    167.172425,     2, 3,  "MHL J12.XXX"},
        {9.514759,    166.8360345,    2, 3,  "MHL K12.XXX"},
        {9.514759,    167.3099625,    2, 3,  "MHL L12.XXX"},
        {9.023719,    167.4047475,    2, 3,  "MHL M12.XXX"},
        {10.114815,   168.9207115,    2, 3,  "MHL N12.XXX"},
        {8.904654,    170.8327955,    2, 3,  "MHL P12.XXX"},
        {10.487915,   170.6620115,    2, 3,  "MHL Q12.XXX"},
        {8.185109,    167.94643,      2, 3,  "MHL R12.XXX"},
        {11.550815,   167.2453115,    2, 3,  "MHL S12.XXX"},
        {9.275015,    165.4380115,    2, 3,  "MHL T12.XXX"},
        {11.424215,   169.5105115,    2, 3,  "MHL V12.XXX"},
        {10.304115,   165.7511115,    2, 3,  "MHL W12.XXX"},
        {9.756731,    169.8102345,    2, 3,  "MHL X12.XXX"},
        {9.26569,     169.8102345,    2, 3,  "MHL Y12.XXX"},
        {12.459611,   169.8902835,    2, 3,  "MHL Z12.XXX"},
        {18.320633,   161.021925,     1, 2,  "MHL 1234.XXX"},
        {-14.268495,  -170.7505955,   4, 5,  "ASM 12.XX"},
        {-11.080345,  -171.102087,    3, 5,  "ASM 03.S16"},
        {-14.377975,  -170.859975,    3, 4,  "ASM 19.S11"},
        {-14.300956,  -169.700979,    3, 4,  "ASM 89.S14"},
        {-14.61885,   -168.235506,    2, 3,  "ASM H9.S0Q"},
        {-13.437751,  -171.092483,    2, 3,  "ASM 123.XXX"},
        {-11.287795,  -170.986984,    2, 4,  "ASM 1234.XXX"},
        {-21.2211075, -159.826193,    3, 4,  "COK 12.XX"},
        {-10.034426,  -161.2457885,   2, 5,  "COK 12.XXX"},
        {-9.305035,   -158.1807665,   2, 5,  "COK 123.XX"},
        {-18.7815815, -159.8534115,   2, 3,  "COK 123.XXX"},
        {-11.130425,  -165.9263885,   2, 4,  "COK R1.XXXX"},
        {-11.769825,  -165.6252885,   2, 3,  "COK N1.XXXX"},
        {-13.546525,  -163.35611,     2, 3,  "COK S1.XXXX"},
        {-21.958425,  -158.16878,     2, 3,  "COK M1.XXXX"},
        {-18.272725,  -163.379945,    2, 3,  "COK P1.XXXX"},
        {-9.541018,   -165.6419065,   1, 3,  "COK 1234.XXX"},
        {46.8211,     -56.2390955,    2, 7,  "SPM 12.XX"},
        {47.1364275,  -56.568465,     1, 4,  "SPM 12.XXX"},
        {-19.038699,  -169.9435145,   2, 3,  "NIU 12.XX"},
        {-18.925931,  -169.9864935,   1, 2,  "NIU 12.XXX"},
        {17.321024,   -62.743705,     2, 3,  "KNA 00.XX"},
        {17.108025,   -62.630767,     2, 3,  "KNA J0.XX"},
        {17.430092,   -62.8862085,    1, 2,  "KNA 12.XXX"},
        {19.306024,   -81.3951095,    3, 5,  "CYM 00.XX"},
        {19.338604,   -81.4175195,    3, 5,  "CYM J0.XX"},
        {19.230025,   -81.484745,     2, 4,  "CYM 0D.S0K"},
        {19.618683,   -80.143865,     2, 4,  "CYM DC.S0P"},
        {19.361237,   -81.444708,     2, 4,  "CYM 123.XXX"},
        {12.19252,    -68.30589,      3, 7,  "BES 12.XX"},
        {12.330369,   -68.427559,     2, 5,  "BES 112.XX"},
        {12.330369,   -68.344913,     2, 5,  "BES 212.XX"},
        {12.249645,   -68.427559,     2, 5,  "BES 312.XX"},
        {12.249645,   -68.344913,     2, 5,  "BES 412.XX"},
        {12.249645,   -68.262267,     2, 5,  "BES 512.XX"},
        {12.168921,   -68.344913,     2, 6,  "BES 612.XX"},
        {12.168921,   -68.262267,     3, 7,  "BES 712.XX"},
        {12.088197,   -68.287061,     2, 6,  "BES 812.XX"},
        {17.52208,    -63.0030945,    2, 3,  "BES T12.XX"},
        {17.65808,    -63.2700945,    2, 3,  "BES S12.XX"},
        {12.1582,     -68.268,        3, 7,  "BES 1Z54.9VM"},
        {4.244073,    73.47611,       3, 4,  "MDV 12.XX"},
        {-0.264365,   73.061913,      3, 4,  "MDV 12.XXX"},
        {6.537892,    72.838205,      3, 4,  "MDV 123.XX"},
        {5.600025,    72.500025,      2, 3,  "MDV 033.S0R"},
        {1.750025,    72.660025,      2, 3,  "MDV 70H.009"},
        {0.160025,    72.900025,      2, 3,  "MDV TVK.S0K"},
        {-0.719975,   73.026153,      2, 3,  "MDV Y11.S17"},
        {4.208973,    73.514,         3, 4,  "MDV HDL0.4N8"},
        {-15.9049,    -5.7556725,     3, 4,  "SHN 12.XX"},
        {-7.99623,    -14.424731,     2, 3,  "SHN 07.S10"},
        {-16.039975,  -5.804975,      2, 3,  "SHN 39.S14"},
        {-37.182975,  -12.371975,     2, 3,  "SHN 78.S0Z"},
        {-37.458975,  -12.746975,     2, 3,  "SHN BC.S0J"},
        {-40.399975,  -10.059975,     2, 3,  "SHN K9.S0R"},
        {-15.94,      -5.7165195,     3, 4,  "SHN Z7DQ.3QGQ"},
        {35.907165,   14.42643,       2, 3,  "MLT 12.XX"},
        {36.110092,   14.19106,       1, 2,  "MLT 12.XXX"},
        {12.065477,   -61.7939475,    2, 4,  "GRD 12.XX"},
        {11.985162,   -61.7922165,    1, 3,  "GRD 12.XXX"},
        {18.3386625,  -64.983435,     4, 6,  "VIR 12.XX"},
        {18.260025,   -65.068821,     3, 5,  "VIR 0B.S11"},
        {17.660025,   -64.939975,     2, 3,  "VIR CB.S10"},
        {18.3295455,  -65.0748155,    2, 4,  "VIR 123.XX"},
        {18.34131,    -64.926438,     4, 6,  "VIR 974.D6C"},
        {-12.734261,  45.203566375,   2, 5,  "MYT 10.XX"},
        {-12.806898,  45.244092625,   2, 5,  "MYT J0.XX"},
        {-12.630925,  44.9253855,     1, 4,  "MYT 12.XXX"},
        {78.242245,   15.486271875,   4, 6,  "SJM 00.XX"},
        {78.047825,   14.0535965,     4, 6,  "SJM J0.XX"},
        {71.200115,   -9.088721,      2, 4,  "SJM 12.XXX"},
        {79.391396,   10.8331085,     3, 5,  "SJM 123.XXX"},
        {79.1460125,  -7.648473,      1, 3,  "SJM 123.XXXX"},
        {80.3881625,  10.8532755,     2, 4,  "SJM 1234.XXX"},
        {13.149955,   -61.2517185,    3, 4,  "VCT 12.XX"},
        {13.100025,   -61.299975,     2, 3,  "VCT 0L.S0Y"},
        {12.770025,   -61.299975,     2, 3,  "VCT 8N.S0B"},
        {12.530025,   -61.499975,     2, 4,  "VCT KH.S0G"},
        {12.7325085,  -61.4972745,    2, 3,  "VCT 123.XXX"},
        {-53.03954,   73.4047005,     2, 3,  "HMD 12.XX"},
        {-53.08653,   72.6117925,     1, 2,  "HMD 123.XX"},
        {13.155374,   -59.636815,     2, 3,  "BRB 12.XX"},
        {13.3348085,  -59.69832,      1, 2,  "BRB 12.XXX"},
        {17.1651,     -61.859574,     3, 4,  "ATG 12.XX"},
        {17.497318,   -61.947817,     2, 3,  "ATG 123.XX"},
        {17.2291335,  -61.941961,     2, 3,  "ATG 12.XXX"},
        {17.7965235,  -62.378232,     1, 2,  "ATG 123.XXX"},
        {12.161451,   -68.968311,     2, 6,  "CUW 12.XX"},
        {12.2883525,  -69.1399715,    1, 4,  "CUW 12.XXX"},
        {-4.5624835,  55.409233,      4, 5,  "SYC 12.XX"},
        {-4.409885,   55.206464,      3, 4,  "SYC 12.XXX"},
        {-4.651343,   55.530517,      4, 5,  "SYC 123.XX"},
        {-4.046885,   53.3085335,     2, 3,  "SYC 123.XXX"},
        {-9.646021,   46.293632,      2, 3,  "SYC 12.XXXX"},
        {-5.8021315,  52.7806405,     2, 3,  "SYC 1234.XX"},
        {-4.1632585,  46.379339,      1, 2,  "SYC 1234.XXX"},
        {7.3781,      134.44111,      4, 5,  "PLW 12.XX"},
        {7.256801,    134.3397795,    4, 5,  "PLW 12.XXX"},
        {6.85719,     134.032451,     3, 4,  "PLW 123.XX"},
        {8.1752995,   132.2315985,    2, 3,  "PLW 123.XXX"},
        {5.186929,    131.12658,      2, 4,  "PLW 12.XXXX"},
        {7.343,       134.479,        4, 5,  "PLW X49Y.3PG"},
        {15.126075,   145.6948505,    3, 4,  "MNP 12.XX"},
        {15.260115,   145.4270765,    2, 3,  "MNP 12.XXX"},
        {18.4128785,  145.6124225,    2, 3,  "MNP 123.XX"},
        {17.7548605,  144.886376,     1, 2,  "MNP 123.XXX"},
        {42.5403,     1.4893815,      3, 7,  "AND 12.XX"},
        {42.6668205,  1.4263515,      2, 6,  "AND 12.XXX"},
        {42.544528,   1.600164,       2, 6,  "AND 0BP2.NSY"},
        {13.562913,   144.82629675,   2, 3,  "GUM 00.XX"},
        {13.451659,   144.73992875,   2, 3,  "GUM J0.XX"},
        {13.661115,   144.56079,      1, 2,  "GUM 12.XXX"},
        {54.209593,   -4.5539325,     3, 5,  "IMN 12.XX"},
        {54.436115,   -4.8773385,     2, 4,  "IMN 12.XXX"},
        {54.236,      -4.527396,      2, 4,  "IMN HK6H.T36"},
        {14.059398,   -61.011049,     2, 3,  "LCA 12.XX"},
        {14.0784525,  -61.085128,     1, 2,  "LCA 12.XXX"},
        {7.394024,    151.560485,     4, 5,  "FSM 12.XX"},
        {6.9148015,   157.7844985,    3, 4,  "FSM 12.XXX"},
        {9.281129,    137.8941875,    3, 4,  "FSM 123.XX"},
        {8.241275,    137.168225,     3, 4,  "FSM 01.XXXX"},
        {9.721075,    139.5702115,    3, 4,  "FSM 11.XXXX"},
        {9.551675,    140.3087115,    3, 4,  "FSM 21.XXXX"},
        {7.150775,    143.662925,     3, 4,  "FSM 31.XXXX"},
        {7.163975,    144.368525,     3, 4,  "FSM 41.XXXX"},
        {8.376075,    144.303725,     3, 4,  "FSM 51.XXXX"},
        {9.016275,    145.1720115,    3, 4,  "FSM 61.XXXX"},
        {7.481875,    145.651525,     3, 4,  "FSM 71.XXXX"},
        {7.276075,    146.019425,     3, 4,  "FSM 81.XXXX"},
        {7.268575,    149.098325,     4, 5,  "FSM 91.XXXX"},
        {8.376175,    149.453225,     3, 4,  "FSM B1.XXXX"},
        {8.562375,    150.0277115,    3, 4,  "FSM C1.XXXX"},
        {5.702475,    152.931225,     3, 4,  "FSM D1.XXXX"},
        {5.244675,    153.433725,     3, 4,  "FSM F1.XXXX"},
        {7.887574,    154.066725,     3, 4,  "FSM G1.XXXX"},
        {7.304775,    155.077425,     3, 4,  "FSM H1.XXXX"},
        {5.599675,    157.047625,     3, 4,  "FSM J1.XXXX"},
        {6.474675,    159.549125,     3, 4,  "FSM K1.XXXX"},
        {5.999875,    160.488425,     3, 4,  "FSM L1.XXXX"},
        {9.588275,    160.6995115,    3, 6,  "FSM M1.XXXX"},
        {5.253075,    162.664525,     3, 5,  "FSM N1.XXXX"},
        {9.068385,    146.776394,     3, 4,  "FSM 1234.XX"},
        {9.2097945,   150.8029475,    3, 4,  "FSM 123.XXX"},
        {5.552433,    137.889819,     2, 4,  "FSM 1234.XXX"},
        {4.83883,     152.184678,     2, 3,  "FSM 123.XXXX"},
        {9.559801,    137.9501525,    3, 4,  "FSM 1234.XXXX"},
        {1.340073,    103.80211,      2, 7,  "SGP 12.XX"},
        {1.308344,    103.592267,     1, 5,  "SGP 12.XXX"},
        {-21.132198,  -175.244416,    5, 6,  "TON 12.XX"},
        {-21.031705,  -175.33748,     4, 5,  "TON 12.XXX"},
        {-19.016968,  -174.255709,    3, 4,  "TON 123.XX"},
        {-20.62029,   -175.726861,    3, 4,  "TON 123.XXX"},
        {-15.76502,   -176.054965,    2, 3,  "TON 12.XXXX"},
        {-19.66786,   -176.113265,    2, 3,  "TON 1234.XX"},
        {-16.0150465, -176.122208,    2, 3,  "TON 1234.XXX"},
        {15.3371,     -61.3900535,    2, 3,  "DMA 12.XX"},
        {15.627756,   -61.5714235,    1, 2,  "DMA 12.XXX"},
        {26.245145,   50.511326375,   3, 6,  "BHR 00.XX"},
        {26.210307,   50.577059875,   3, 6,  "BHR J0.XX"},
        {25.80583,    50.321376,      2, 5,  "BHR 12.XXX"},
        {25.594065,   50.450223,      2, 5,  "BHR 123.XX"},
        {26.226691,   50.543445,      3, 6,  "BHR FNZ.WJY"},
        {1.3542965,   172.925401,     5, 6,  "KIR 12.XX"},
        {1.912935,    172.750585,     4, 5,  "KIR 00.XXX"},
        {1.567965,    172.860585,     4, 5,  "KIR J0.XXX"},
        {1.980242,    -157.502931,    3, 4,  "KIR 000.XX"},
        {3.40296,     172.909137625,  4, 5,  "KIR 300.XX"},
        {3.138545,    172.739225,     4, 5,  "KIR 600.XX"},
        {-0.607455,   174.382425,     4, 5,  "KIR 900.XX"},
        {-1.260605,   175.905345,     4, 5,  "KIR D00.XX"},
        {-1.117455,   174.657225,     4, 5,  "KIR H00.XX"},
        {2.073984,    173.195345,     4, 5,  "KIR L00.XX"},
        {1.020545,    172.967225,     4, 5,  "KIR P00.XX"},
        {-1.793455,   175.500225,     4, 5,  "KIR S00.XX"},
        {-1.313455,   176.393225,     4, 5,  "KIR W00.XX"},
        {4.726545,    -160.454774375, 3, 4,  "KIR Y00.XX"},
        {1.2201055,   172.6026505,    3, 4,  "KIR 123.XXX"},
        {-0.460989,   174.348203,     3, 4,  "KIR 12.XXXX"},
        {-2.193648,   -173.2211,      3, 4,  "KIR 1234.XX"},
        {1.25419,     167.610504,     2, 3,  "KIR 1234.XXX"},
        {-9.8015395,  -162.921108,    2, 4,  "KIR 123.XXXX"},
        {3.618701,    159.7268925,    1, 2,  "KIR 1234.XXXX"},
        {21.435245,   -71.166549,     3, 5,  "TCA 12.XX"},
        {21.610025,   -72.499975,     2, 4,  "TCA 07.S13"},
        {21.275025,   -71.729975,     2, 4,  "TCA 26.S0T"},
        {21.720025,   -72.369975,     2, 4,  "TCA 4C.S0V"},
        {21.172448,   -71.259702,     2, 4,  "TCA DQ.S04"},
        {21.770025,   -72.074975,     3, 5,  "TCA PD.S0Y"},
        {21.855328,   -71.899023,     3, 5,  "TCA 123.XX"},
        {21.754675,   -72.4500155,    1, 3,  "TCA 123.XXX"},
        {0.378101,    6.67211,        3, 4,  "STP 12.XX"},
        {0.410893,    6.403006,       2, 3,  "STP 12.XXX"},
        {1.318174,    7.109977,       2, 3,  "STP 123.XX"},
        {0.343001,    6.71,           3, 4,  "STP FDP.Q8G"},
        {22.341126,   114.1516255,    3, 8,  "HKG 12.XX"},
        {22.4944735,  113.8557945,    2, 7,  "HKG 123.XX"},
        {22.35875,    114.1385,       2, 7,  "HKG RBXQ.TX1F"},
        {14.616955,   -61.094972,     2, 3,  "MTQ 12.XX"},
        {14.833607,   -61.21321,      1, 2,  "MTQ 12.XXX"},
        {62.05236,    -6.881385,      3, 4,  "FRO 12.XX"},
        {62.3155565,  -7.6586235,     2, 3,  "FRO 12.XXX"},
        {62.0072035,  -6.9454685,     2, 3,  "FRO 123.XX"},
        {61.444657,   -7.080092,      2, 3,  "FRO S12.XXX"},
        {62.01726,    -6.801395,      3, 4,  "FRO LBWZ.FKF"},
        {16.258385,   -61.5945905,    3, 4,  "GLP 12.XX"},
        {15.940025,   -61.809975,     2, 3,  "GLP 0V.S0P"},
        {16.194025,   -61.549975,     2, 3,  "GLP HN.S12"},
        {16.230025,   -61.349975,     2, 3,  "GLP S6.S0Y"},
        {15.820025,   -61.665975,     2, 3,  "GLP W4.S10"},
        {16.288025,   -61.101975,     2, 3,  "GLP Y4.S13"},
        {15.715641,   -61.5103175,    2, 3,  "GLP 123.XX"},
        {16.6337795,  -61.845004,     1, 2,  "GLP 123.XXX"},
        {-12.1149,    44.371268,      3, 6,  "COM 12.XX"},
        {-11.860436,  43.206191,      2, 3,  "COM 12.XXX"},
        {-12.073455,  44.19023,       2, 5,  "COM 000.XX"},
        {-12.198455,  43.57523,       2, 5,  "COM J00.XX"},
        {-11.1578645, 43.220429,      1, 2,  "COM 123.XXX"},
        {-20.1166305, 57.461573,      2, 3,  "MUS 12.XX"},
        {-20.121975,  57.496025,      3, 4,  "MUS 08.S18"},
        {-20.489975,  57.300025,      2, 3,  "MUS 55.S0Z"},
        {-20.529975,  57.356025,      2, 3,  "MUS 6T.L10"},
        {-19.900136,  63.228262,      2, 3,  "MUS 123.XX"},
        {-16.405885,  59.3700765,     2, 3,  "MUS C12.XXX"},
        {-10.302931,  56.509855,      2, 3,  "MUS N12.XXX"},
        {-15.732908,  54.351505,      2, 3,  "MUS T12.XXX"},
        {-19.519677,  57.4774415,     2, 3,  "MUS F12.XXX"},
        {-16.079931,  59.47022,       2, 3,  "MUS X12.XXX"},
        {-20.1504065, 57.50085,       3, 4,  "MUS BYK2.M9L"},
        {-20.8773905, 55.4395205,     3, 4,  "REU 12.XX"},
        {-20.883627,  55.2372065,     2, 3,  "REU 12.XXX"},
        {-21.2789625, 55.519337,      3, 4,  "REU 123.XX"},
        {-20.905,     55.4784825,     3, 4,  "REU G4Z.QV4"},
        {49.639859,   6.055902,       3, 6,  "LUX 12.XX"},
        {49.893615,   5.852485,       3, 9,  "LUX 12.XXX"},
        {49.705865,   5.737581,       2, 6,  "LUX 123.XX"},
        {49.81675,    6.13265,        3, 6,  "LUX R9QG.K0X"},
        {-13.848559,  -171.8318265,   3, 4,  "WSM 12.XX"},
        {-14.012537,  -172.1319965,   2, 3,  "WSM 12.XXX"},
        {-13.550303,  -172.7840345,   2, 3,  "WSM 123.XX"},
        {-13.696845,  -172.7911785,   2, 3,  "WSM 123.XXX"},
        {-54.2459,    -36.5729325,    4, 5,  "SGS 12.XX"},
        {-54.101781,  -36.9500685,    3, 4,  "SGS 12.XXX"},
        {-54.851921,  -36.5199875,    3, 4,  "SGS 123.XX"},
        {-53.675073,  -38.2615255,    2, 3,  "SGS 123.XXX"},
        {-58.1891615, -27.6004885,    2, 3,  "SGS 12.XXXX"},
        {-53.9037815, -41.817264,     2, 3,  "SGS P123.XX"},
        {-54.0898235, -39.204725,     2, 3,  "SGS Q123.XX"},
        {-55.1708245, -34.9248785,    2, 3,  "SGS R123.XX"},
        {-54.281,     -36.5085195,    4, 5,  "SGS B3DJ.3T0"},
        {-17.548896,  -149.574611625, 6, 7,  "PYF 00.XX"},
        {-17.544371,  -149.622478375, 5, 6,  "PYF C0.XX"},
        {-17.62681,   -149.624174875, 4, 5,  "PYF P0.XX"},
        {-17.670292,  -149.981264,    4, 5,  "PYF 123.XX"},
        {-17.5093495, -149.5962035,   4, 5,  "PYF 12.XXX"},
        {-16.2570925, -152.2085005,   3, 4,  "PYF 123.XXX"},
        {-8.1831285,  -140.940748,    2, 3,  "PYF 12.XXXX"},
        {-11.652222,  -152.0573265,   2, 3,  "PYF 0123.XX"},
        {-10.296299,  -152.5448465,   2, 5,  "PYF 1123.XX"},
        {-10.14499,   -150.4370165,   2, 5,  "PYF 2123.XX"},
        {-27.839806,  -144.6233615,   2, 3,  "PYF 3123.XX"},
        {-27.948615,  -143.7568115,   2, 3,  "PYF 4123.XX"},
        {-23.4430935, -154.1284435,   2, 3,  "PYF 1234.XXX"},
        {-17.5430005, -149.5486465,   5, 6,  "PYF 7GYY.RYSQ"},
        {16.890125,   -25.01854,      3, 4,  "CPV 12.XX"},
        {15.330625,   -23.8390225,    2, 3,  "CPV 12.XXX"},
        {17.209308,   -25.3460575,    2, 3,  "CPV 123.XX"},
        {17.2752995,  -25.2959275,    1, 2,  "CPV 123.XXX"},
        {10.674445,   -61.54977125,   3, 5,  "TTO 00.XX"},
        {10.673175,   -61.46824625,   3, 5,  "TTO J0.XX"},
        {10.2673295,  -61.6992165,    2, 4,  "TTO 12.XXX"},
        {10.345401,   -61.3710705,    2, 4,  "TTO 123.XX"},
        {11.557735,   -61.9126815,    1, 3,  "TTO 123.XXX"},
        {4.945549,    114.878436,     3, 6,  "BRN 12.XX"},
        {4.8193715,   114.190287,     2, 5,  "BRN 123.XX"},
        {4.933589,    114.706721,     2, 5,  "BRN 12.XXX"},
        {5.064283,    114.1075455,    1, 4,  "BRN 123.XXX"},
        {-49.313903,  70.161233,      3, 4,  "ATF 12.XX"},
        {-37.772442,  77.4765505,     2, 3,  "ATF 12.XXX"},
        {-38.7858095, 77.440484,      2, 3,  "ATF 123.XX"},
        {-49.883975,  68.507946,      2, 3,  "ATF 02X.612"},
        {-46.150535,  50.155905,      2, 3,  "ATF 907.S0X"},
        {-46.467079,  50.336321,      2, 3,  "ATF B06.S14"},
        {-45.993613,  50.375191,      2, 3,  "ATF C04.S16"},
        {-46.519639,  51.622201,      2, 3,  "ATF D0F.S0P"},
        {-46.535183,  52.078617,      2, 3,  "ATF F0D.S14"},
        {-11.631815,  47.254905,      2, 3,  "ATF G0B.S0Y"},
        {-17.116085,  42.662152,      2, 3,  "ATF H07.S16"},
        {-21.542085,  39.626568,      2, 4,  "ATF J07.S16"},
        {-22.423085,  40.297114,      2, 4,  "ATF K07.S16"},
        {-15.912799,  54.501193,      2, 5,  "ATF L03.S16"},
        {-12.414085,  46.373511,      2, 5,  "ATF M07.S16"},
        {-49.349003,  70.219331,      3, 4,  "ATF SZYG.287M"},
        {18.463502,   -66.115932,     4, 6,  "PRI 12.XX"},
        {18.2919415,  -66.2323925,    3, 5,  "PRI 12.XXX"},
        {18.146465,   -67.195879,     3, 5,  "PRI 123.XX"},
        {17.84768,    -67.9055905,    2, 4,  "PRI 123.XXX"},
        {18.19,       -66.5700885,    3, 5,  "PRI ZJP8.KJWV"},
        {35.177024,   33.327882,      3, 4,  "CYP 00.XX"},
        {34.649493,   32.998509375,   3, 4,  "CYP J0.XX"},
        {35.330115,   33.1299965,     2, 3,  "CYP 12.XXX"},
        {34.755313,   32.349022,      2, 3,  "CYP 123.XX"},
        {35.293669,   32.2625385,     1, 2,  "CYP 123.XXX"},
        {33.9021,     35.473532,      4, 5,  "LBN 12.XX"},
        {34.170115,   35.47971,       3, 4,  "LBN 12.XXX"},
        {34.511604,   35.650978875,   3, 6,  "LBN 000.XX"},
        {33.711545,   35.258256125,   3, 4,  "LBN C00.XX"},
        {33.403254,   35.153268125,   3, 6,  "LBN P00.XX"},
        {33.069727,   34.8077025,     2, 5,  "LBN 123.XXX"},
        {33.87,       35.715,         3, 6,  "LBN 3D59.BNR"},
        {18.0411,     -76.833574,     3, 5,  "JAM 12.XX"},
        {18.023704,   -76.92006175,   3, 5,  "JAM 000.XX"},
        {17.969488,   -77.13453375,   2, 4,  "JAM 700.XX"},
        {17.927134,   -77.356596875,  3, 5,  "JAM F00.XX"},
        {18.011842,   -77.57865975,   2, 4,  "JAM M00.XX"},
        {18.228045,   -76.68726375,   2, 4,  "JAM T00.XX"},
        {18.323546,   -78.342535,     2, 4,  "JAM 12.XXX"},
        {18.065751,   -78.3928425,    1, 3,  "JAM 123.XXX"},
        {13.480776,   -16.73651,      2, 5,  "GMB 12.XX"},
        {13.418039,   -14.3939725,    2, 5,  "GMB 12.XXX"},
        {13.463545,   -16.66176875,   3, 6,  "GMB 000.XX"},
        {13.333294,   -16.81511375,   2, 5,  "GMB 300.XX"},
        {13.250795,   -16.790769375,  2, 5,  "GMB 600.XX"},
        {13.275545,   -16.66276875,   3, 6,  "GMB 900.XX"},
        {13.511594,   -16.55391375,   2, 4,  "GMB D00.XX"},
        {13.370114,   -16.50280675,   2, 5,  "GMB H00.XX"},
        {13.513814,   -15.67280675,   2, 4,  "GMB K00.XX"},
        {13.413814,   -15.62160675,   2, 5,  "GMB M00.XX"},
        {13.500214,   -16.24760675,   2, 5,  "GMB P00.XX"},
        {13.500214,   -16.12190075,   2, 5,  "GMB R00.XX"},
        {13.622814,   -14.93630675,   2, 5,  "GMB T00.XX"},
        {13.525014,   -14.83950675,   2, 5,  "GMB W00.XX"},
        {13.410514,   -14.71280675,   2, 5,  "GMB Y00.XX"},
        {13.8322825,  -16.8834905,    1, 4,  "GMB 123.XXX"},
        {25.327315,   51.4735575,     3, 6,  "QAT 12.XX"},
        {25.579459,   51.191459,      2, 5,  "QAT 12.XXX"},
        {24.596345,   51.150152,      2, 5,  "QAT 123.XX"},
        {24.9091815,  50.7055695,     1, 4,  "QAT 123.XXX"},
        {-51.7067975, -57.890839,     3, 4,  "FLK 12.XX"},
        {-51.381045,  -58.357144,     2, 3,  "FLK 12.XXX"},
        {-51.875135,  -59.569272,     2, 3,  "FLK 123.XX"},
        {-51.169171,  -61.3623465,    1, 2,  "FLK 123.XXX"},
        {-17.70018,   168.280243,     4, 5,  "VUT 12.XX"},
        {-17.420781,  168.138722,     3, 4,  "VUT 12.XXX"},
        {-15.745694,  166.8205865,    3, 4,  "VUT 123.XX"},
        {-14.6717795, 166.4823035,    2, 3,  "VUT 123.XXX"},
        {-13.800048,  166.4612125,    2, 3,  "VUT 12.XXXX"},
        {-19.4407425, 168.0811335,    2, 4,  "VUT 1234.XX"},
        {-13.5549855, 166.4734505,    2, 3,  "VUT 1234.XXX"},
        {42.4761,     19.2135395,     4, 7,  "MNE 12.XX"},
        {43.027844,   19.539528,      3, 4,  "MNE 000.XX"},
        {42.789274,   18.839333,      3, 4,  "MNE 600.XX"},
        {43.375974,   19.2279595,     3, 6,  "MNE C00.XX"},
        {42.451604,   18.7452525,     3, 6,  "MNE J00.XX"},
        {42.604371,   18.979233,      3, 4,  "MNE P00.XX"},
        {42.468074,   18.4851065,     3, 6,  "MNE V00.XX"},
        {41.959414,   18.944662,      3, 4,  "MNE 12.XXX"},
        {41.944845,   18.441532,      2, 5,  "MNE 123.XXX"},
        {42.7015,     19.4075,        2, 3,  "MNE DQJL.XJJ"},
        {25.065339,   -77.357887,     3, 5,  "BHS 12.XX"},
        {26.712875,   -78.95215,      3, 5,  "BHS 12.XXX"},
        {26.778717,   -77.986764875,  3, 5,  "BHS 000.XX"},
        {26.692228,   -77.986764875,  3, 5,  "BHS 100.XX"},
        {26.692228,   -77.890425875,  3, 5,  "BHS 200.XX"},
        {26.605739,   -77.897169875,  3, 5,  "BHS 300.XX"},
        {24.352143,   -75.48588675,   3, 5,  "BHS 400.XX"},
        {26.904024,   -77.540238625,  3, 5,  "BHS 500.XX"},
        {25.064424,   -77.5511415,    3, 5,  "BHS 600.XX"},
        {25.099106,   -77.4560035,    3, 5,  "BHS 700.XX"},
        {25.001745,   -77.4585775,    3, 5,  "BHS 800.XX"},
        {26.563845,   -77.129749375,  3, 5,  "BHS 900.XX"},
        {24.788945,   -76.3057525,    3, 5,  "BHS B00.XX"},
        {24.769524,   -77.8458475,    3, 5,  "BHS C00.XX"},
        {23.122145,   -75.071055625,  4, 6,  "BHS D00.XX"},
        {24.653145,   -75.74775375,   3, 5,  "BHS F00.XX"},
        {25.520324,   -76.70847325,   3, 5,  "BHS G00.XX"},
        {23.538724,   -75.830982125,  3, 5,  "BHS H00.XX"},
        {24.932024,   -76.2198475,    3, 5,  "BHS J00.XX"},
        {25.018513,   -76.2198475,    3, 5,  "BHS K00.XX"},
        {25.766945,   -79.30975125,   2, 4,  "BHS L00.XX"},
        {20.993124,   -73.684092,     3, 5,  "BHS M00.XX"},
        {22.609924,   -73.9121435,    3, 5,  "BHS N00.XX"},
        {25.796524,   -77.898986125,  3, 5,  "BHS P00.XX"},
        {24.097824,   -74.536808875,  3, 5,  "BHS Q00.XX"},
        {25.169145,   -78.0997525,    3, 5,  "BHS R00.XX"},
        {22.816324,   -74.26746925,   3, 5,  "BHS S00.XX"},
        {22.456224,   -73.1378435,    3, 5,  "BHS T00.XX"},
        {22.252545,   -75.7586675,    3, 5,  "BHS V00.XX"},
        {23.716524,   -74.878108875,  3, 5,  "BHS W00.XX"},
        {22.623524,   -74.3814435,    3, 5,  "BHS X00.XX"},
        {27.247724,   -78.342138625,  3, 5,  "BHS Y00.XX"},
        {22.422024,   -73.0243435,    3, 5,  "BHS Z00.XX"},
        {25.50206,    -76.76959,      2, 4,  "BHS 12.XXXX"},
        {24.5848115,  -78.9885055,    2, 4,  "BHS 123.XXX"},
        {22.235008,   -75.8011495,    2, 4,  "BHS 1234.XX"},
        {26.826325,   -80.2185215,    1, 6,  "BHS 1234.XXX"},
        {-8.578719,   125.502111,     3, 6,  "TLS 12.XX"},
        {-8.535659,   125.3657115,    2, 5,  "TLS 12.XXX"},
        {-8.888931,   126.1555855,    2, 5,  "TLS 123.XX"},
        {-8.8929725,  124.112773,     1, 4,  "TLS 123.XXX"},
        {-26.283312,  31.072898,      3, 7,  "SWZ 12.XX"},
        {-26.65142,   30.9976295,     2, 6,  "SWZ 123.XX"},
        {-25.965906,  31.211164875,   3, 8,  "SWZ 00.XXX"},
        {-25.957806,  31.088864875,   2, 7,  "SWZ 20.XXX"},
        {-25.982506,  31.665864875,   2, 6,  "SWZ 40.XXX"},
        {-26.042406,  31.782464875,   3, 8,  "SWZ 60.XXX"},
        {-26.005706,  31.914764875,   3, 8,  "SWZ 80.XXX"},
        {-26.436106,  31.881936125,   2, 6,  "SWZ B0.XXX"},
        {-26.973706,  30.948306375,   2, 6,  "SWZ D0.XXX"},
        {-26.680606,  31.641936125,   2, 6,  "SWZ G0.XXX"},
        {-26.737496,  31.055387125,   2, 6,  "SWZ J0.XXX"},
        {-26.992596,  31.261361375,   2, 5,  "SWZ K0.XXX"},
        {-27.146596,  31.150761375,   2, 5,  "SWZ L0.XXX"},
        {-27.311614,  31.821761375,   2, 5,  "SWZ M0.XXX"},
        {-26.267396,  31.902813875,   2, 6,  "SWZ N0.XXX"},
        {-26.180907,  31.902813875,   2, 7,  "SWZ P0.XXX"},
        {-26.824096,  31.920661375,   2, 6,  "SWZ Q0.XXX"},
        {-26.910585,  31.823842375,   2, 5,  "SWZ R0.XXX"},
        {-26.910585,  31.920661375,   2, 5,  "SWZ S0.XXX"},
        {-26.087496,  31.503313875,   2, 6,  "SWZ T0.XXX"},
        {-26.087496,  31.599171875,   2, 6,  "SWZ V0.XXX"},
        {-26.173985,  31.503313875,   2, 6,  "SWZ W0.XXX"},
        {-26.173985,  31.599171875,   2, 6,  "SWZ X0.XXX"},
        {-26.260474,  31.503313875,   3, 7,  "SWZ Y0.XXX"},
        {-26.260474,  31.599171875,   2, 6,  "SWZ Z0.XXX"},
        {-27.142242,  30.797066,      1, 5,  "SWZ 123.XXX"},
        {29.3841,     47.936295,      4, 11, "KWT 12.XX"},
        {29.366459,   47.671117,      3, 10, "KWT 12.XXX"},
        {28.840728,   47.797074,      3, 7,  "KWT 123.XX"},
        {29.8740095,  46.6177,        2, 4,  "KWT 123.XXX"},
        {29.3125,     47.66575,       3, 10, "KWT XXL7.4YB"},
        {-18.105511,  178.42413175,   4, 5,  "FJI 10.XX"},
        {-18.083211,  178.46797825,   4, 5,  "FJI J0.XX"},
        {-18.080533,  178.032459,     3, 4,  "FJI 12.XXX"},
        {-17.556145,  177.373196125,  3, 4,  "FJI 000.XX"},
        {-17.800764,  177.232302125,  3, 4,  "FJI 800.XX"},
        {-17.507221,  177.629366125,  3, 4,  "FJI J00.XX"},
        {-16.436296,  179.260890875,  3, 4,  "FJI S00.XX"},
        {-16.6023885, 176.9363495,    2, 3,  "FJI 123.XXX"},
        {-18.8329745, 179.7895815,    2, 3,  "FJI 12.XXXX"},
        {-18.76092,   177.382903,     2, 3,  "FJI L123.XX"},
        {-18.75722,   177.860503,     3, 4,  "FJI M123.XX"},
        {-18.949179,  177.959155,     2, 3,  "FJI K123.XX"},
        {-18.83442,   178.359403,     2, 3,  "FJI B123.XX"},
        {-20.03602,   -178.6670685,   2, 3,  "FJI V123.XX"},
        {-21.056335,  -179.052148,    2, 3,  "FJI X123.XX"},
        {-12.936235,  176.912454,     2, 3,  "FJI R123.XX"},
        {-15.918635,  179.8091825,    2, 3,  "FJI T123.XX"},
        {-18.121351,  178.443598,     4, 5,  "FJI 9NZC.97N"},
        {-22.23287,   166.4119555,    4, 5,  "NCL 12.XX"},
        {-21.905691,  166.272517,     3, 4,  "NCL 12.XXX"},
        {-21.384455,  167.80032825,   3, 4,  "NCL 000.XX"},
        {-21.428226,  167.97024125,   4, 5,  "NCL 600.XX"},
        {-20.901026,  167.161944,     3, 4,  "NCL C00.XX"},
        {-21.013926,  165.251344,     3, 4,  "NCL J00.XX"},
        {-21.551026,  165.33790725,   3, 4,  "NCL P00.XX"},
        {-21.044026,  164.762944,     3, 4,  "NCL V00.XX"},
        {-20.0759445, 164.27165,      3, 4,  "NCL 123.XXX"},
        {-20.8770155, 166.809927,     3, 4,  "NCL 12.XXXX"},
        {-19.1681375, 162.7757545,    2, 3,  "NCL 1234.XX"},
        {-18.2109435, 158.5375075,    1, 4,  "NCL 1234.XXX"},
        {46.0945,     14.445212,      4, 5,  "SVN 12.XX"},
        {46.333115,   14.15116,       3, 4,  "SVN 12.XXX"},
        {46.576024,   15.58404,       3, 6,  "SVN 000.XX"},
        {46.293324,   15.21744,       3, 4,  "SVN 100.XX"},
        {46.410524,   15.02424,       3, 6,  "SVN 200.XX"},
        {45.581824,   13.68687075,    3, 7,  "SVN 300.XX"},
        {45.545424,   13.56577075,    3, 6,  "SVN 400.XX"},
        {45.844324,   15.106905375,   3, 6,  "SVN 500.XX"},
        {46.435745,   15.782325,      3, 4,  "SVN 600.XX"},
        {46.168645,   14.952721875,   3, 4,  "SVN 700.XX"},
        {46.444724,   13.99954,       3, 6,  "SVN 800.XX"},
        {45.975124,   13.624805375,   3, 7,  "SVN 900.XX"},
        {46.700724,   16.09124,       3, 6,  "SVN B00.XX"},
        {45.690724,   14.80237075,    3, 6,  "SVN C00.XX"},
        {45.842324,   14.188905375,   3, 4,  "SVN D00.XX"},
        {46.563365,   14.842325,      3, 6,  "SVN F00.XX"},
        {46.560724,   15.02124,       3, 6,  "SVN G00.XX"},
        {45.990524,   15.413205375,   4, 7,  "SVN H00.XX"},
        {46.440724,   15.50124,       3, 4,  "SVN J00.XX"},
        {45.929834,   15.518457875,   4, 8,  "SVN K00.XX"},
        {46.105824,   14.775205375,   4, 5,  "SVN L00.XX"},
        {45.930724,   13.841805375,   3, 7,  "SVN M00.XX"},
        {46.046324,   13.964905375,   3, 4,  "SVN N00.XX"},
        {45.610224,   15.11837075,    3, 6,  "SVN P00.XX"},
        {46.323824,   13.87174,       3, 6,  "SVN Q00.XX"},
        {46.012204,   15.276319875,   3, 6,  "SVN R00.XX"},
        {46.280624,   15.09784,       3, 4,  "SVN S00.XX"},
        {45.615224,   14.18537075,    3, 4,  "SVN T00.XX"},
        {45.759524,   13.806305375,   3, 7,  "SVN V00.XX"},
        {46.399724,   15.36154,       3, 4,  "SVN W00.XX"},
        {46.280724,   15.58124,       3, 6,  "SVN X00.XX"},
        {46.260724,   15.34124,       3, 4,  "SVN Y00.XX"},
        {46.580724,   15.46124,       3, 6,  "SVN Z00.XX"},
        {46.465527,   13.4732415,     2, 7,  "SVN 123.XXX"},
        {46.1490785,  14.992992,      3, 4,  "SVN 4FZ8.T8H"},
        {31.810775,   35.1712295,     3, 7,  "ISR 12.XX"},
        {32.197213,   34.780151,      3, 6,  "ISR 000.XX"},
        {32.197213,   34.882016,      3, 6,  "ISR 100.XX"},
        {32.110724,   34.739405,      3, 6,  "ISR 200.XX"},
        {32.110724,   34.84127,       3, 6,  "ISR 300.XX"},
        {32.024235,   34.71925875,    3, 6,  "ISR 400.XX"},
        {32.024235,   34.82064275,    3, 6,  "ISR 500.XX"},
        {31.937746,   34.68884275,    3, 6,  "ISR 600.XX"},
        {31.937746,   34.79022675,    3, 6,  "ISR 700.XX"},
        {31.846724,   34.61411475,    3, 6,  "ISR 800.XX"},
        {32.834777,   34.941749375,   3, 4,  "ISR 900.XX"},
        {32.826128,   35.044334375,   3, 4,  "ISR B00.XX"},
        {32.912617,   35.044334375,   3, 4,  "ISR C00.XX"},
        {32.873748,   35.146949375,   3, 4,  "ISR D00.XX"},
        {31.269545,   34.7538105,     3, 7,  "ISR F00.XX"},
        {32.362824,   34.835888,      3, 6,  "ISR G00.XX"},
        {31.703624,   34.51271475,    3, 6,  "ISR H00.XX"},
        {32.752524,   35.258649375,   3, 4,  "ISR J00.XX"},
        {32.494024,   34.877588,      3, 6,  "ISR K00.XX"},
        {32.475845,   34.976697,      3, 6,  "ISR L00.XX"},
        {31.789324,   34.93371475,    3, 6,  "ISR M00.XX"},
        {33.081545,   35.081266875,   3, 6,  "ISR N00.XX"},
        {31.650724,   34.71231475,    3, 7,  "ISR P00.XX"},
        {32.986424,   35.069349375,   3, 4,  "ISR Q00.XX"},
        {32.986424,   35.171949375,   3, 4,  "ISR R00.XX"},
        {32.982473,   35.274349375,   3, 4,  "ISR S00.XX"},
        {29.612824,   34.903931625,   3, 5,  "ISR T00.XX"},
        {32.848324,   35.454449375,   3, 4,  "ISR V00.XX"},
        {32.555324,   35.074888,      3, 4,  "ISR W00.XX"},
        {32.648945,   35.271266875,   3, 4,  "ISR X00.XX"},
        {32.306399,   34.936994,      3, 6,  "ISR Y00.XX"},
        {31.110524,   34.9732405,     3, 5,  "ISR Z00.XX"},
        {31.560675,   34.41548375,    3, 8,  "ISR 00.XXX"},
        {31.460804,   34.3691405,     3, 8,  "ISR 10.XXX"},
        {31.460804,   34.4700445,     3, 8,  "ISR 20.XXX"},
        {31.374315,   34.2611725,     3, 8,  "ISR 30.XXX"},
        {31.374315,   34.3620765,     3, 8,  "ISR 40.XXX"},
        {31.3252665,  34.227909,      3, 8,  "ISR 5H.HHH"},
        {31.287826,   34.2813535,     3, 8,  "ISR 60.XXX"},
        {31.261255,   34.2288325,     3, 8,  "ISR 70.XXX"},
        {31.824804,   35.16721475,    3, 7,  "ISR 80.XXX"},
        {31.911293,   35.16721475,    3, 7,  "ISR 90.XXX"},
        {31.746904,   35.26861475,    3, 7,  "ISR B0.XXX"},
        {31.542704,   34.94141475,    3, 8,  "ISR C0.XXX"},
        {31.542704,   35.04279875,    3, 8,  "ISR D0.XXX"},
        {31.542704,   35.14418275,    3, 8,  "ISR F0.XXX"},
        {31.456215,   34.9112245,     3, 8,  "ISR G0.XXX"},
        {31.456215,   35.0121285,     3, 8,  "ISR H0.XXX"},
        {31.456215,   35.1130325,     3, 8,  "ISR J0.XXX"},
        {31.369726,   34.9314055,     3, 8,  "ISR K0.XXX"},
        {31.369726,   35.0323095,     3, 8,  "ISR L0.XXX"},
        {31.369726,   35.1332135,     3, 8,  "ISR M0.XXX"},
        {32.179904,   35.210388,      3, 7,  "ISR N0.XXX"},
        {32.279104,   35.013088,      4, 8,  "ISR P0.XXX"},
        {32.129704,   34.959788,      4, 8,  "ISR Q0.XXX"},
        {31.822404,   35.41791475,    3, 7,  "ISR R0.XXX"},
        {32.439004,   35.130788,      3, 7,  "ISR S0.XXX"},
        {32.439004,   35.232653,      3, 7,  "ISR T0.XXX"},
        {31.652904,   35.13251475,    3, 8,  "ISR V0.XXX"},
        {32.093404,   35.197388,      3, 7,  "ISR W0.XXX"},
        {31.866604,   35.00941475,    3, 7,  "ISR X0.XXX"},
        {32.318304,   35.153088,      3, 7,  "ISR Y0.XXX"},
        {32.345504,   35.260588,      3, 7,  "ISR Z0.XXX"},
        {30.9456835,  34.228139,      2, 4,  "ISR 123.XXX"},
        {31.456,      35.075,         3, 8,  "ISR 1NTQ.X0R"},
        {31.810775,   35.1712295,     3, 7,  "PSE 12.XX"},
        {31.560675,   34.41548375,    3, 8,  "PSE 00.XXX"},
        {31.460804,   34.3691405,     3, 8,  "PSE 10.XXX"},
        {31.460804,   34.4700445,     3, 8,  "PSE 20.XXX"},
        {31.374315,   34.2611725,     3, 8,  "PSE 30.XXX"},
        {31.374315,   34.3620765,     3, 8,  "PSE 40.XXX"},
        {31.3252665,  34.227909,      3, 8,  "PSE 5H.HHH"},
        {31.287826,   34.2813535,     3, 8,  "PSE 60.XXX"},
        {31.249,      34.2910445,     3, 8,  "PSE 7H.FWP"},
        {31.824804,   35.16721475,    3, 7,  "PSE 80.XXX"},
        {31.911293,   35.16721475,    3, 7,  "PSE 90.XXX"},
        {31.746904,   35.26861475,    3, 7,  "PSE B0.XXX"},
        {31.542704,   34.94141475,    3, 8,  "PSE C0.XXX"},
        {31.542704,   35.04279875,    3, 8,  "PSE D0.XXX"},
        {31.542704,   35.14418275,    3, 8,  "PSE F0.XXX"},
        {31.456215,   34.9112245,     3, 8,  "PSE G0.XXX"},
        {31.456215,   35.0121285,     3, 8,  "PSE H0.XXX"},
        {31.456215,   35.1130325,     3, 8,  "PSE J0.XXX"},
        {31.369726,   34.9314055,     3, 8,  "PSE K0.XXX"},
        {31.369726,   35.0323095,     3, 8,  "PSE L0.XXX"},
        {31.369726,   35.1332135,     3, 8,  "PSE M0.XXX"},
        {32.179904,   35.210388,      3, 7,  "PSE N0.XXX"},
        {32.279104,   35.013088,      3, 8,  "PSE P0.XXX"},
        {32.129704,   34.959788,      3, 8,  "PSE Q0.XXX"},
        {31.822404,   35.41791475,    3, 7,  "PSE R0.XXX"},
        {32.439004,   35.130788,      3, 7,  "PSE S0.XXX"},
        {32.439004,   35.232653,      3, 7,  "PSE T0.XXX"},
        {31.652904,   35.13251475,    3, 8,  "PSE V0.XXX"},
        {32.093404,   35.197388,      3, 7,  "PSE W0.XXX"},
        {31.866604,   35.00941475,    3, 7,  "PSE X0.XXX"},
        {32.318304,   35.153088,      3, 7,  "PSE Y0.XXX"},
        {32.345504,   35.260588,      3, 7,  "PSE Z0.XXX"},
        {31.88475,    34.89625,       2, 5,  "PSE DLF.T05"},
        {31.88475,    34.89625,       2, 5,  "PSE 1MF7.JP8"},
        {13.7291,     -89.242573,     4, 5,  "SLV 12.XX"},
        {13.890115,   -89.355296,     3, 4,  "SLV 12.XXX"},
        {14.039524,   -89.59660975,   3, 6,  "SLV 000.XX"},
        {13.515324,   -88.22180975,   3, 4,  "SLV 100.XX"},
        {13.757324,   -89.77920975,   4, 5,  "SLV 200.XX"},
        {13.880724,   -88.91900975,   4, 5,  "SLV 300.XX"},
        {13.380724,   -88.48180975,   3, 4,  "SLV 400.XX"},
        {13.546724,   -88.90420975,   4, 5,  "SLV 500.XX"},
        {13.706224,   -88.83990975,   3, 4,  "SLV 600.XX"},
        {13.977124,   -89.89080975,   3, 4,  "SLV 700.XX"},
        {14.019545,   -89.70839875,   3, 6,  "SLV 800.XX"},
        {14.000724,   -89.23180975,   3, 4,  "SLV 900.XX"},
        {13.359024,   -87.89080975,   3, 6,  "SLV B00.XX"},
        {13.639324,   -89.86950975,   3, 4,  "SLV C00.XX"},
        {13.814524,   -88.61180975,   3, 6,  "SLV D00.XX"},
        {14.370724,   -89.491922625,  3, 6,  "SLV F00.XX"},
        {13.445524,   -88.39420975,   3, 4,  "SLV G00.XX"},
        {13.920724,   -88.67180975,   3, 6,  "SLV H00.XX"},
        {14.079524,   -89.01420975,   3, 6,  "SLV J00.XX"},
        {13.344624,   -88.60330975,   3, 4,  "SLV K00.XX"},
        {13.784824,   -89.53370975,   3, 4,  "SLV L00.XX"},
        {13.737524,   -88.12720975,   3, 6,  "SLV M00.XX"},
        {13.516124,   -88.48680975,   4, 5,  "SLV N00.XX"},
        {13.644224,   -87.90420975,   3, 6,  "SLV P00.XX"},
        {13.863724,   -89.46750975,   3, 4,  "SLV Q00.XX"},
        {13.891524,   -89.79120975,   3, 4,  "SLV R00.XX"},
        {13.546524,   -88.56950975,   3, 4,  "SLV S00.XX"},
        {14.009024,   -89.80230975,   3, 6,  "SLV T00.XX"},
        {13.564824,   -88.40770975,   3, 4,  "SLV V00.XX"},
        {13.898624,   -89.59080975,   3, 4,  "SLV W00.XX"},
        {13.920664,   -89.53627325,   3, 4,  "SLV X00.XX"},
        {13.326104,   -88.39187875,   3, 4,  "SLV XK0.00"},
        {14.139464,   -89.32297325,   3, 8,  "SLV Y00.XX"},
        {13.753504,   -88.29837875,   3, 6,  "SLV YK0.00"},
        {13.794864,   -89.77927325,   3, 4,  "SLV Z00.XX"},
        {13.740204,   -89.69047875,   3, 4,  "SLV ZK0.00"},
        {13.9988605,  -90.0585635,    2, 5,  "SLV 123.XXX"},
        {13.72583,    -88.9065,       3, 4,  "SLV 6T11.GM4"},
        {17.516324,   -88.243355625,  4, 5,  "BLZ 00.XX"},
        {17.222404,   -88.805604,     4, 5,  "BLZ J0.XX"},
        {17.412715,   -89.130233,     3, 4,  "BLZ 12.XXX"},
        {17.540444,   -88.399137875,  3, 4,  "BLZ 000.XX"},
        {18.104774,   -88.68484575,   3, 10, "BLZ 600.XX"},
        {16.944074,   -88.414709,     3, 4,  "BLZ C00.XX"},
        {18.417874,   -88.49634575,   3, 10, "BLZ J00.XX"},
        {18.097145,   -88.02826375,   3, 9,  "BLZ P00.XX"},
        {16.130974,   -88.94927225,   3, 4,  "BLZ V00.XX"},
        {16.324722,   -89.2211125,    2, 5,  "BLZ 123.XXX"},
        {17.19,       -88.33,         2, 3,  "BLZ 7X47.HQW"},
        {11.574803,   43.057022375,   3, 6,  "DJI 00.XX"},
        {11.550211,   43.131613875,   3, 6,  "DJI J0.XX"},
        {11.579279,   42.8243185,     2, 5,  "DJI 12.XXX"},
        {11.202404,   42.577131875,   2, 5,  "DJI 000.XX"},
        {11.875844,   42.781802875,   2, 5,  "DJI 700.XX"},
        {12.071544,   43.204402875,   2, 5,  "DJI F00.XX"},
        {11.135244,   42.26239675,    2, 5,  "DJI M00.XX"},
        {12.201544,   42.441208,      2, 5,  "DJI T00.XX"},
        {10.9529415,  41.75411,       1, 4,  "DJI 123.XXX"},
        {42.033913,   21.3978375,     4, 5,  "MKD 12.XX"},
        {42.234667,   21.21814,       3, 6,  "MKD 12.XXX"},
        {41.014114,   21.2645995,     3, 6,  "MKD 000.XX"},
        {41.322914,   21.4520995,     3, 4,  "MKD 200.XX"},
        {41.983014,   20.86322,       3, 8,  "MKD 400.XX"},
        {41.983014,   21.026299,      3, 6,  "MKD 600.XX"},
        {42.105323,   21.0256205,     3, 8,  "MKD 800.XX"},
        {41.697514,   21.70362,       3, 4,  "MKD B00.XX"},
        {41.134414,   20.7176995,     3, 6,  "MKD D00.XX"},
        {41.780514,   20.83852,       3, 6,  "MKD G00.XX"},
        {41.791224,   22.12646,       3, 4,  "MKD J00.XX"},
        {41.470724,   22.6062125,     3, 4,  "MKD K00.XX"},
        {41.480724,   21.9562125,     3, 4,  "MKD L00.XX"},
        {41.220724,   20.6103125,     3, 6,  "MKD M00.XX"},
        {41.936124,   22.33426,       3, 4,  "MKD N00.XX"},
        {41.557124,   20.91556,       3, 6,  "MKD P00.XX"},
        {41.659024,   22.44056,       3, 4,  "MKD Q00.XX"},
        {42.252124,   22.2753085,     3, 4,  "MKD R00.XX"},
        {41.190724,   22.4734125,     3, 6,  "MKD S00.XX"},
        {41.540724,   22.06886,       3, 4,  "MKD T00.XX"},
        {41.905624,   21.85776,       3, 4,  "MKD V00.XX"},
        {41.558424,   20.48476,       3, 6,  "MKD W00.XX"},
        {41.940724,   22.44576,       3, 6,  "MKD X00.XX"},
        {41.134324,   20.9576125,     3, 8,  "MKD Y00.XX"},
        {41.409624,   21.1957125,     3, 4,  "MKD Z00.XX"},
        {42.1284015,  20.5387365,     2, 7,  "MKD 123.XXX"},
        {41.6135945,  21.743759,      2, 3,  "MKD JTJK.4CZ"},
        {-1.9169,     30.03711,       3, 5,  "RWA 12.XX"},
        {-1.739885,   29.851425,      2, 6,  "RWA 12.XXX"},
        {-1.505806,   29.540165,      2, 6,  "RWA 000.XX"},
        {-2.595806,   29.662665,      2, 7,  "RWA 300.XX"},
        {-1.670906,   29.241865,      2, 8,  "RWA 600.XX"},
        {-1.585806,   29.985165,      2, 4,  "RWA 900.XX"},
        {-1.964506,   30.414965,      2, 4,  "RWA D00.XX"},
        {-2.503586,   28.86979,       2, 8,  "RWA H00.XX"},
        {-2.369486,   29.69109,       2, 7,  "RWA K00.XX"},
        {-2.089486,   29.70259,       2, 6,  "RWA M00.XX"},
        {-2.519486,   29.51889,       2, 7,  "RWA P00.XX"},
        {-2.179486,   30.47539,       2, 4,  "RWA R00.XX"},
        {-2.067286,   29.31719,       2, 5,  "RWA T00.XX"},
        {-1.944977,   29.298843,      2, 6,  "RWA W00.XX"},
        {-2.673686,   28.93009,       2, 6,  "RWA Y00.XX"},
        {-1.2169685,  28.9228145,     1, 5,  "RWA 123.XXX"},
        {18.5881,     -72.369674,     3, 5,  "HTI 12.XX"},
        {18.613206,   -72.645158,     2, 4,  "HTI 12.XXX"},
        {19.787624,   -72.25246525,   2, 4,  "HTI 000.XX"},
        {19.490724,   -72.71936525,   2, 4,  "HTI 100.XX"},
        {19.143624,   -72.7251395,    2, 4,  "HTI 200.XX"},
        {18.262924,   -73.80751375,   2, 4,  "HTI 300.XX"},
        {19.096624,   -72.4972395,    3, 5,  "HTI 400.XX"},
        {19.160724,   -72.5503395,    2, 4,  "HTI 500.XX"},
        {19.954824,   -72.86476525,   2, 4,  "HTI 600.XX"},
        {19.947724,   -72.77316525,   2, 4,  "HTI 700.XX"},
        {18.667424,   -74.171226625,  2, 4,  "HTI 800.XX"},
        {18.277224,   -72.57491375,   2, 4,  "HTI 900.XX"},
        {19.758124,   -72.42536525,   2, 4,  "HTI B00.XX"},
        {19.344124,   -72.6679395,    2, 4,  "HTI C00.XX"},
        {19.318177,   -72.5766455,    2, 4,  "HTI D00.XX"},
        {19.198724,   -72.0372395,    2, 4,  "HTI F00.XX"},
        {19.410724,   -72.3729395,    2, 4,  "HTI G00.XX"},
        {19.667424,   -72.03096525,   2, 4,  "HTI H00.XX"},
        {19.587824,   -71.78726525,   2, 6,  "HTI J00.XX"},
        {19.501335,   -71.76432125,   2, 6,  "HTI K00.XX"},
        {18.444824,   -72.902826625,  2, 4,  "HTI L00.XX"},
        {18.870724,   -72.142826625,  2, 4,  "HTI M00.XX"},
        {19.634424,   -72.22466525,   2, 4,  "HTI N00.XX"},
        {18.564224,   -74.460926625,  2, 4,  "HTI P00.XX"},
        {19.672724,   -71.85336525,   2, 6,  "HTI Q00.XX"},
        {19.720724,   -72.72316525,   2, 4,  "HTI R00.XX"},
        {19.360424,   -72.1574395,    2, 4,  "HTI S00.XX"},
        {18.463424,   -73.119126625,  2, 4,  "HTI T00.XX"},
        {18.476924,   -74.458226625,  2, 4,  "HTI V00.XX"},
        {19.470724,   -72.2429395,    2, 4,  "HTI W00.XX"},
        {18.331824,   -73.41281375,   2, 4,  "HTI X00.XX"},
        {18.870724,   -71.982826625,  2, 6,  "HTI Y00.XX"},
        {18.846924,   -72.911126625,  2, 4,  "HTI Z00.XX"},
        {19.772399,   -74.3843435,    1, 3,  "HTI 123.XXX"},
        {-3.419635,   29.339565,      3, 5,  "BDI 12.XX"},
        {-3.047125,   29.235169,      2, 5,  "BDI 12.XXX"},
        {-3.440106,   29.821857125,   2, 4,  "BDI 000.XX"},
        {-2.874606,   30.252165,      2, 4,  "BDI 300.XX"},
        {-2.915206,   29.755565,      2, 4,  "BDI 600.XX"},
        {-3.475806,   30.164957125,   2, 4,  "BDI 900.XX"},
        {-2.925806,   29.545165,      2, 4,  "BDI D00.XX"},
        {-3.967886,   29.582221125,   2, 4,  "BDI H00.XX"},
        {-3.955686,   29.912321125,   2, 4,  "BDI K00.XX"},
        {-4.163086,   29.742521125,   2, 4,  "BDI M00.XX"},
        {-2.919486,   29.05889,       2, 5,  "BDI P00.XX"},
        {-2.981863,   29.162852,      2, 5,  "BDI R00.XX"},
        {-3.102686,   30.11709,       2, 4,  "BDI T00.XX"},
        {-3.229486,   30.478721125,   2, 4,  "BDI W00.XX"},
        {-2.599486,   30.03889,       2, 5,  "BDI Y00.XX"},
        {-4.3485885,  28.9956665,     1, 4,  "BDI 123.XXX"},
        {3.751145,    8.751225625,    4, 6,  "GNQ 00.XX"},
        {1.822605,    9.74356,        4, 7,  "GNQ J0.XX"},
        {3.7765155,   8.5353745,      3, 5,  "GNQ 12.XXX"},
        {1.850195,    9.722189,       3, 6,  "GNQ 000.XX"},
        {2.090694,    11.184865,      3, 8,  "GNQ 300.XX"},
        {1.574195,    9.566141,       3, 5,  "GNQ 600.XX"},
        {1.282294,    10.808965,      3, 5,  "GNQ 900.XX"},
        {1.860194,    10.694165,      4, 7,  "GNQ D00.XX"},
        {1.423994,    10.468865,      4, 6,  "GNQ H00.XX"},
        {1.616994,    11.194065,      3, 7,  "GNQ L00.XX"},
        {1.065794,    10.587065,      3, 5,  "GNQ P00.XX"},
        {2.094294,    10.538565,      3, 6,  "GNQ S00.XX"},
        {1.560214,    10.75749,       3, 5,  "GNQ W00.XX"},
        {1.110514,    11.19889,       3, 7,  "GNQ Y00.XX"},
        {-1.3898255,  5.587801,       2, 3,  "GNQ 012.XXX"},
        {3.7698815,   8.3545265,      2, 4,  "GNQ 112.XXX"},
        {3.7698815,   8.6826305,      3, 5,  "GNQ 212.XXX"},
        {3.4261535,   8.3545265,      2, 4,  "GNQ 312.XXX"},
        {3.4261535,   8.6826305,      3, 5,  "GNQ 412.XXX"},
        {2.310587,    9.50478,        2, 5,  "GNQ B12.XXX"},
        {2.163275,    9.9735,         2, 5,  "GNQ C12.XXX"},
        {2.163275,    10.44222,       2, 5,  "GNQ D12.XXX"},
        {2.163275,    10.91094,       2, 5,  "GNQ F12.XXX"},
        {1.819547,    9.036059,       2, 5,  "GNQ G12.XXX"},
        {1.819547,    9.504779,       2, 5,  "GNQ H12.XXX"},
        {1.819547,    9.973499,       3, 6,  "GNQ J12.XXX"},
        {1.819547,    10.442219,      3, 6,  "GNQ K12.XXX"},
        {1.819547,    10.910939,      3, 6,  "GNQ L12.XXX"},
        {1.328507,    9.036059,       2, 4,  "GNQ P12.XXX"},
        {1.328507,    9.504779,       2, 4,  "GNQ Q12.XXX"},
        {1.328507,    9.973499,       2, 4,  "GNQ R12.XXX"},
        {1.426715,    10.442219,      3, 5,  "GNQ S12.XXX"},
        {1.426715,    10.910939,      3, 5,  "GNQ T12.XXX"},
        {3.7373,      8.785249,       4, 6,  "GNQ K04F.CFG"},
        {41.3737,     19.7635195,     4, 5,  "ALB 12.XX"},
        {41.576015,   19.4167435,     3, 4,  "ALB 12.XXX"},
        {41.146624,   20.0104125,     3, 4,  "ALB 000.XX"},
        {42.125324,   19.4858085,     3, 6,  "ALB 100.XX"},
        {40.521024,   19.443051125,   3, 4,  "ALB 200.XX"},
        {40.664524,   20.732651125,   3, 6,  "ALB 300.XX"},
        {40.762824,   19.522351125,   3, 4,  "ALB 400.XX"},
        {40.762524,   19.906351125,   3, 4,  "ALB 500.XX"},
        {40.951624,   19.658951125,   3, 4,  "ALB 600.XX"},
        {40.911524,   20.642251125,   3, 6,  "ALB 700.XX"},
        {41.688924,   19.63036,       3, 4,  "ALB 800.XX"},
        {40.103124,   20.116503625,   3, 4,  "ALB 900.XX"},
        {40.638124,   19.717351125,   3, 4,  "ALB B00.XX"},
        {40.848524,   19.853351125,   3, 4,  "ALB C00.XX"},
        {42.106724,   20.3448085,     3, 6,  "ALB D00.XX"},
        {41.838324,   19.58206,       3, 4,  "ALB F00.XX"},
        {39.918424,   19.982955125,   3, 4,  "ALB G00.XX"},
        {41.730724,   20.34536,       3, 4,  "ALB H00.XX"},
        {41.649324,   19.98726,       3, 4,  "ALB J00.XX"},
        {41.066524,   19.9502125,     3, 4,  "ALB K00.XX"},
        {40.527224,   20.194051125,   3, 4,  "ALB L00.XX"},
        {41.219324,   20.2754125,     3, 4,  "ALB M00.XX"},
        {40.351724,   19.969803625,   3, 4,  "ALB N00.XX"},
        {40.634024,   20.019251125,   3, 4,  "ALB P00.XX"},
        {40.897624,   20.155051125,   3, 4,  "ALB Q00.XX"},
        {41.540224,   20.20226,       3, 4,  "ALB R00.XX"},
        {40.283324,   20.297103625,   3, 4,  "ALB S00.XX"},
        {41.042024,   19.4953125,     3, 4,  "ALB T00.XX"},
        {41.810724,   19.82576,       3, 4,  "ALB V00.XX"},
        {40.657424,   19.411951125,   3, 4,  "ALB W00.XX"},
        {40.799524,   19.407851125,   3, 4,  "ALB X00.XX"},
        {40.896724,   19.550051125,   3, 4,  "ALB Y00.XX"},
        {42.255024,   19.3897085,     3, 7,  "ALB Z00.XX"},
        {40.5164755,  19.2110205,     2, 3,  "ALB 123.XXX"},
        {41.15,       20.15,          2, 3,  "ALB FVTT.0HM"},
        {-9.446615,   159.919345,     4, 6,  "SLB 12.XX"},
        {-8.485289,   160.669765,     3, 5,  "SLB 12.XXX"},
        {-9.47263,    159.9100445,    3, 5,  "SLB 000.XX"},
        {-9.47263,    160.0849455,    3, 5,  "SLB 400.XX"},
        {-8.076898,   156.745393375,  3, 5,  "SLB 800.XX"},
        {-8.206089,   159.532835375,  3, 5,  "SLB D00.XX"},
        {-8.999668,   160.0627765,    3, 5,  "SLB J00.XX"},
        {-9.037455,   160.2362275,    4, 6,  "SLB N00.XX"},
        {-10.520685,  161.79211475,   3, 5,  "SLB S00.XX"},
        {-12.286772,  168.750406,     2, 3,  "SLB X00.XX"},
        {-7.154384,   156.039099,     2, 4,  "SLB 12.XXXX"},
        {-7.692877,   158.851337,     2, 5,  "SLB 123.XXX"},
        {-7.419155,   155.472565,     2, 4,  "SLB 0123.XX"},
        {-5.479655,   159.113548,     2, 5,  "SLB 1123.XX"},
        {-5.676035,   159.347908,     2, 5,  "SLB 2123.XX"},
        {-11.741957,  159.7508405,    2, 3,  "SLB 3123.XX"},
        {-11.938373,  160.2247685,    2, 3,  "SLB 4123.XX"},
        {-10.607584,  161.1743055,    2, 4,  "SLB 5123.XX"},
        {-10.821312,  161.5913615,    2, 4,  "SLB 6123.XX"},
        {-10.921312,  162.0652895,    2, 4,  "SLB 7123.XX"},
        {-10.100685,  161.7313035,    3, 5,  "SLB 8123.XX"},
        {-10.361195,  161.6582325,    3, 5,  "SLB 9123.XX"},
        {-10.101636,  166.9461145,    2, 4,  "SLB B123.XX"},
        {-10.45038,   165.5271435,    2, 4,  "SLB C123.XX"},
        {-10.45038,   166.0010715,    2, 4,  "SLB D123.XX"},
        {-10.94142,   165.7167155,    2, 4,  "SLB F123.XX"},
        {-11.481564,  166.2854285,    2, 4,  "SLB G123.XX"},
        {-11.878276,  166.6615445,    2, 3,  "SLB H123.XX"},
        {-5.511296,   155.95524,      1, 3,  "SLB 1234.XXX"},
        {40.213794,   44.459392,      3, 5,  "ARM 12.XX"},
        {40.510082,   44.175509,      2, 4,  "ARM 12.XXX"},
        {40.512514,   44.703709125,   3, 5,  "ARM 000.XX"},
        {40.512514,   44.864409125,   2, 3,  "ARM 200.XX"},
        {40.390205,   44.704387625,   3, 5,  "ARM 400.XX"},
        {39.955214,   44.492187625,   2, 4,  "ARM 600.XX"},
        {39.847814,   44.579467125,   2, 4,  "ARM 800.XX"},
        {39.479814,   46.295667125,   2, 5,  "ARM B00.XX"},
        {40.880514,   44.397809125,   2, 4,  "ARM D00.XX"},
        {40.597914,   43.853909125,   2, 4,  "ARM G00.XX"},
        {40.869014,   45.080109125,   2, 3,  "ARM J00.XX"},
        {39.502514,   45.981967125,   2, 5,  "ARM L00.XX"},
        {41.126524,   44.6041125,     2, 7,  "ARM N00.XX"},
        {40.771234,   44.830476625,   2, 3,  "ARM P00.XX"},
        {41.050724,   44.3362125,     2, 4,  "ARM Q00.XX"},
        {40.233824,   45.676503625,   2, 5,  "ARM R00.XX"},
        {40.190724,   43.974903625,   2, 4,  "ARM S00.XX"},
        {40.016545,   44.353293125,   2, 4,  "ARM T00.XX"},
        {39.803024,   45.299655125,   2, 5,  "ARM V00.XX"},
        {40.838024,   43.804951125,   2, 4,  "ARM W00.XX"},
        {40.833745,   44.414595625,   2, 4,  "ARM X00.XX"},
        {39.225245,   46.34928875,    2, 6,  "ARM Y00.XX"},
        {40.374245,   45.097093125,   2, 3,  "ARM Z00.XX"},
        {41.2329995,  43.560834,      1, 6,  "ARM 123.XXX"},
        {-29.3009,    27.461275,      3, 6,  "LSO 12.XX"},
        {-29.109885,  27.412979,      2, 5,  "LSO 12.XXX"},
        {-29.834896,  27.179128625,   2, 5,  "LSO 000.XX"},
        {-28.939196,  27.745209375,   2, 5,  "LSO 400.XX"},
        {-28.890196,  27.990989125,   2, 5,  "LSO 800.XX"},
        {-30.164696,  27.364848875,   2, 5,  "LSO D00.XX"},
        {-29.274896,  28.932609375,   2, 5,  "LSO J00.XX"},
        {-29.522396,  28.518328625,   2, 5,  "LSO N00.XX"},
        {-30.052096,  28.598348875,   2, 5,  "LSO S00.XX"},
        {-30.395606,  27.604031875,   2, 5,  "LSO X00.XX"},
        {-28.6444445, 27.102707,      1, 4,  "LSO 123.XXX"},
        {50.85903,    4.3094515,      4, 6,  "BEL 00.XX"},
        {51.184685,   4.37497075,     4, 7,  "BEL J0.XX"},
        {51.256114,   4.023875,       3, 6,  "BEL 12.XXX"},
        {51.030514,   3.62324325,     4, 6,  "BEL 000.XX"},
        {51.183214,   3.13324325,     3, 4,  "BEL 200.XX"},
        {50.450514,   4.7606615,      3, 5,  "BEL 400.XX"},
        {50.400514,   4.3071615,      3, 5,  "BEL 600.XX"},
        {50.400514,   4.4987795,      3, 5,  "BEL 800.XX"},
        {50.920724,   4.6484635,      3, 5,  "BEL B00.XX"},
        {50.479324,   3.8403685,      3, 5,  "BEL C00.XX"},
        {51.090724,   5.14189025,     3, 5,  "BEL D00.XX"},
        {50.970724,   5.25189025,     4, 6,  "BEL F00.XX"},
        {51.260724,   2.85559025,     3, 4,  "BEL G00.XX"},
        {50.666624,   3.3162685,      3, 6,  "BEL H00.XX"},
        {51.032324,   5.43559025,     4, 6,  "BEL J00.XX"},
        {50.982124,   3.09709025,     3, 5,  "BEL K00.XX"},
        {50.629324,   5.8265685,      4, 6,  "BEL L00.XX"},
        {50.773345,   3.1797025,      3, 5,  "BEL M00.XX"},
        {50.870724,   3.2062685,      3, 5,  "BEL N00.XX"},
        {50.513424,   4.1662685,      3, 5,  "BEL P00.XX"},
        {50.711524,   5.5457685,      4, 6,  "BEL Q00.XX"},
        {50.711524,   5.4102685,      3, 5,  "BEL R00.XX"},
        {50.625035,   5.4102685,      3, 5,  "BEL S00.XX"},
        {50.625035,   5.5457685,      3, 5,  "BEL T00.XX"},
        {51.359124,   4.86779025,     3, 6,  "BEL V00.XX"},
        {51.121524,   4.64676125,     3, 4,  "BEL W00.XX"},
        {50.873024,   5.1026685,      3, 5,  "BEL X00.XX"},
        {51.226124,   5.05929025,     3, 6,  "BEL Y00.XX"},
        {51.318745,   4.39035625,     3, 6,  "BEL Z00.XX"},
        {49.9777105,  4.8789615,      3, 6,  "BEL T12.XXX"},
        {49.8344905,  5.3580975,      3, 5,  "BEL V12.XXX"},
        {50.3050705,  4.1436435,      3, 5,  "BEL P12.XXX"},
        {50.2436905,  4.7529795,      2, 4,  "BEL Q12.XXX"},
        {50.2436905,  5.3623155,      2, 4,  "BEL R12.XXX"},
        {50.2436905,  5.7279175,      3, 5,  "BEL S12.XXX"},
        {50.6528905,  3.2601065,      2, 5,  "BEL F12.XXX"},
        {50.6528905,  3.8694425,      2, 4,  "BEL G12.XXX"},
        {50.6528905,  4.4787785,      2, 4,  "BEL H12.XXX"},
        {50.6528905,  5.0881145,      2, 4,  "BEL J12.XXX"},
        {50.6528905,  5.6974505,      2, 4,  "BEL K12.XXX"},
        {50.6528905,  5.8497845,      3, 5,  "BEL L12.XXX"},
        {51.0620905,  2.554449,       2, 5,  "BEL 712.XXX"},
        {51.0620905,  3.168993,       3, 5,  "BEL 812.XXX"},
        {51.0620905,  3.783537,       4, 6,  "BEL 912.XXX"},
        {51.0620905,  4.398081,       3, 5,  "BEL B12.XXX"},
        {51.0620905,  5.012625,       2, 4,  "BEL C12.XXX"},
        {51.0620905,  5.565714,       4, 6,  "BEL D12.XXX"},
        {51.4712905,  2.5485895,      2, 3,  "BEL 112.XXX"},
        {51.3485305,  3.1683415,      2, 3,  "BEL 212.XXX"},
        {51.3485305,  3.7880935,      2, 5,  "BEL 312.XXX"},
        {51.4712905,  4.4078455,      2, 5,  "BEL 412.XXX"},
        {51.4712905,  5.0275975,      2, 5,  "BEL 512.XXX"},
        {51.2666905,  5.2754985,      3, 6,  "BEL 612.XXX"},
        {50.4861,     4.4607,         2, 4,  "BEL N77S.1MX"},
        {47.0591,     28.7878295,     4, 6,  "MDA 12.XX"},
        {47.224115,   28.5415115,     3, 5,  "MDA 12.XXX"},
        {46.895024,   29.561875625,   3, 5,  "MDA 000.XX"},
        {47.802324,   27.843745875,   3, 5,  "MDA 100.XX"},
        {46.870824,   29.453075625,   3, 5,  "MDA 200.XX"},
        {47.816824,   28.920245875,   3, 5,  "MDA 300.XX"},
        {45.961924,   28.150405375,   3, 7,  "MDA 400.XX"},
        {48.197224,   28.207445875,   3, 5,  "MDA 500.XX"},
        {47.250724,   27.750675625,   3, 7,  "MDA 600.XX"},
        {47.323324,   29.06531025,    3, 5,  "MDA 700.XX"},
        {47.417724,   28.74741025,    3, 5,  "MDA 800.XX"},
        {46.355324,   28.59934,       3, 5,  "MDA 900.XX"},
        {46.123224,   28.760705375,   3, 5,  "MDA B00.XX"},
        {48.102724,   27.791645875,   3, 5,  "MDA C00.XX"},
        {46.680724,   29.32624,       3, 5,  "MDA D00.XX"},
        {48.232324,   27.208145875,   3, 7,  "MDA F00.XX"},
        {47.620724,   27.62831025,    3, 5,  "MDA G00.XX"},
        {47.753724,   28.79101025,    3, 5,  "MDA H00.XX"},
        {46.809524,   29.594975625,   3, 5,  "MDA J00.XX"},
        {47.308124,   28.25771025,    3, 5,  "MDA K00.XX"},
        {47.912924,   28.208445875,   3, 5,  "MDA L00.XX"},
        {45.720724,   28.366605375,   3, 7,  "MDA M00.XX"},
        {48.000524,   27.455345875,   3, 5,  "MDA N00.XX"},
        {46.587024,   28.72074,       3, 5,  "MDA P00.XX"},
        {47.130724,   28.152175625,   3, 5,  "MDA Q00.XX"},
        {45.934024,   28.580205375,   3, 5,  "MDA R00.XX"},
        {46.653124,   29.82164,       3, 5,  "MDA S00.XX"},
        {48.041824,   28.664545875,   3, 5,  "MDA T00.XX"},
        {48.272624,   27.562245875,   3, 5,  "MDA V00.XX"},
        {47.841224,   27.430945875,   3, 7,  "MDA W00.XX"},
        {48.419764,   27.4526275,     3, 5,  "MDA X00.XX"},
        {48.208104,   27.004579875,   3, 8,  "MDA XK0.00"},
        {46.492064,   28.210545,      3, 7,  "MDA Y00.XX"},
        {47.132604,   29.265903625,   3, 5,  "MDA YK0.00"},
        {46.709864,   29.686115875,   3, 5,  "MDA Z00.XX"},
        {47.493804,   28.33584125,    3, 5,  "MDA ZK0.00"},
        {48.454595,   26.6207085,     2, 5,  "MDA 012.XXX"},
        {48.454595,   27.3133725,     2, 4,  "MDA 112.XXX"},
        {48.454595,   28.0060365,     2, 4,  "MDA 212.XXX"},
        {48.454595,   28.6987005,     2, 4,  "MDA 312.XXX"},
        {47.963555,   26.620422,      2, 7,  "MDA 412.XXX"},
        {47.963555,   27.307878,      2, 4,  "MDA 512.XXX"},
        {47.963555,   27.995334,      2, 4,  "MDA 612.XXX"},
        {47.963555,   28.68279,       3, 5,  "MDA 712.XXX"},
        {47.472515,   27.3127995,     2, 6,  "MDA 812.XXX"},
        {47.472515,   27.9950475,     2, 4,  "MDA 912.XXX"},
        {47.472515,   28.6772955,     2, 4,  "MDA B12.XXX"},
        {47.472515,   29.3595435,     2, 4,  "MDA C12.XXX"},
        {46.981475,   27.994761,      2, 6,  "MDA D12.XXX"},
        {46.981475,   28.671801,      3, 5,  "MDA F12.XXX"},
        {46.981475,   29.348841,      2, 4,  "MDA G12.XXX"},
        {46.490435,   27.999396,      2, 6,  "MDA H12.XXX"},
        {46.490435,   28.66602,       2, 4,  "MDA J12.XXX"},
        {46.3279685,  29.324559,      2, 4,  "MDA K12.XXX"},
        {45.536996,   28.0845755,     2, 6,  "MDA L12.XXX"},
        {45.999395,   28.5990705,     2, 4,  "MDA M12.XXX"},
        {46.98,       28.3815,        2, 4,  "MDA WCX1.7MZ"},
        {11.911889,   -15.650387,     4, 5,  "GNB 12.XX"},
        {11.9595645,  -15.9430015,    3, 4,  "GNB 12.XXX"},
        {12.159304,   -14.792666,     3, 5,  "GNB 000.XX"},
        {12.268604,   -14.262466,     3, 5,  "GNB 400.XX"},
        {12.235804,   -15.512966,     3, 4,  "GNB 800.XX"},
        {11.625545,   -15.633770625,  3, 4,  "GNB D00.XX"},
        {12.061194,   -16.109290125,  3, 4,  "GNB J00.XX"},
        {11.255994,   -15.910190125,  3, 4,  "GNB M00.XX"},
        {11.276194,   -15.313790125,  3, 4,  "GNB Q00.XX"},
        {12.067694,   -15.375890125,  4, 5,  "GNB T00.XX"},
        {11.579394,   -15.087990125,  3, 4,  "GNB X00.XX"},
        {12.068668,   -16.7648835,    2, 3,  "GNB 123.XXX"},
        {11.75,       -15.23,         2, 3,  "GNB 2BYY.5B2"},
        {25.085145,   121.4554215,    4, 6,  "TWN 12.XX"},
        {25.0133175,  121.1776655,    3, 5,  "TWN 12.XXX"},
        {24.800514,   120.9127795,    3, 5,  "TWN 000.XX"},
        {22.680724,   120.24933075,   3, 5,  "TWN 200.XX"},
        {22.680724,   120.34302675,   3, 5,  "TWN 300.XX"},
        {22.594235,   120.3713605,    3, 5,  "TWN 400.XX"},
        {22.594235,   120.2781445,    3, 5,  "TWN 500.XX"},
        {24.277224,   120.65437825,   3, 6,  "TWN 600.XX"},
        {24.190735,   120.645025125,  3, 6,  "TWN 700.XX"},
        {24.104246,   120.645025125,  3, 6,  "TWN 800.XX"},
        {24.792324,   121.6544525,    3, 5,  "TWN 900.XX"},
        {24.835568,   121.7400765,    4, 6,  "TWN B00.XX"},
        {24.705835,   121.60710925,   3, 5,  "TWN C00.XX"},
        {24.705835,   121.70176625,   3, 5,  "TWN D00.XX"},
        {24.749079,   121.7488685,    3, 5,  "TWN F00.XX"},
        {24.66259,    121.79666325,   3, 5,  "TWN G00.XX"},
        {23.040724,   120.15533075,   3, 5,  "TWN H00.XX"},
        {23.040724,   120.24902675,   3, 5,  "TWN J00.XX"},
        {23.516024,   120.399317875,  3, 6,  "TWN K00.XX"},
        {24.119924,   120.503991125,  3, 6,  "TWN L00.XX"},
        {22.711624,   120.44553075,   3, 5,  "TWN M00.XX"},
        {22.804924,   121.08963075,   3, 5,  "TWN N00.XX"},
        {23.985924,   120.511791125,  3, 6,  "TWN P00.XX"},
        {23.757249,   120.530199125,  3, 6,  "TWN Q00.XX"},
        {24.274424,   120.50907825,   3, 6,  "TWN R00.XX"},
        {24.034624,   121.557991125,  3, 5,  "TWN S00.XX"},
        {24.019624,   120.637891125,  3, 6,  "TWN T00.XX"},
        {23.933135,   120.637891125,  3, 6,  "TWN V00.XX"},
        {22.826124,   120.23143075,   3, 5,  "TWN W00.XX"},
        {24.731024,   120.8452525,    3, 5,  "TWN X00.XX"},
        {24.607424,   120.77927825,   3, 6,  "TWN Y00.XX"},
        {24.010724,   120.915591125,  3, 5,  "TWN Z00.XX"},
        {25.264595,   120.5465595,    2, 5,  "TWN 012.XXX"},
        {25.264595,   121.0621515,    2, 4,  "TWN 112.XXX"},
        {25.264595,   121.5777435,    2, 4,  "TWN 212.XXX"},
        {24.773555,   120.443154,     2, 5,  "TWN 312.XXX"},
        {24.773555,   120.953538,     3, 5,  "TWN 412.XXX"},
        {24.773555,   121.463922,     2, 4,  "TWN 512.XXX"},
        {24.282515,   119.93277,      2, 7,  "TWN 612.XXX"},
        {24.282515,   120.443154,     2, 5,  "TWN 712.XXX"},
        {24.282515,   120.953538,     2, 4,  "TWN 812.XXX"},
        {24.282515,   121.463922,     2, 4,  "TWN 912.XXX"},
        {23.791475,   120.1163265,    2, 5,  "TWN B12.XXX"},
        {23.791475,   120.6215025,    2, 5,  "TWN C12.XXX"},
        {23.791475,   121.1266785,    2, 4,  "TWN D12.XXX"},
        {23.300435,   120.0405495,    2, 4,  "TWN F12.XXX"},
        {23.300435,   120.5457255,    2, 4,  "TWN G12.XXX"},
        {23.300435,   121.0509015,    2, 4,  "TWN H12.XXX"},
        {22.809395,   120.0405495,    2, 4,  "TWN J12.XXX"},
        {22.809395,   120.5457255,    2, 4,  "TWN K12.XXX"},
        {22.809395,   121.0509015,    2, 4,  "TWN L12.XXX"},
        {22.318355,   120.040263,     2, 4,  "TWN M12.XXX"},
        {22.318355,   120.540231,     2, 4,  "TWN N12.XXX"},
        {22.318355,   121.290183,     2, 4,  "TWN R12.XXX"},
        {23.82451,    119.3090565,    2, 7,  "TWN P12.XXX"},
        {23.33347,    119.3090565,    2, 4,  "TWN Q12.XXX"},
        {24.5216375,  118.1432705,    2, 9,  "TWN S12.XXX"},
        {25.014878,   119.3978965,    2, 7,  "TWN W12.XXX"},
        {26.2712355,  119.8991,       2, 7,  "TWN X12.XXX"},
        {25.637769,   121.8855215,    2, 4,  "TWN Y12.XXX"},
        {26.353562,   120.1277095,    2, 7,  "TWN Z12.XXX"},
        {25.0500445,  121.4971,       4, 6,  "TWN R9W0.411"},
        {27.452513,   89.6058785,     3, 9,  "BTN 12.XX"},
        {27.672815,   89.48593,       2, 8,  "BTN 12.XXX"},
        {26.828314,   89.311591375,   2, 11, "BTN 000.XX"},
        {26.831214,   91.436391375,   2, 11, "BTN 200.XX"},
        {26.850514,   90.181591375,   2, 11, "BTN 400.XX"},
        {27.420514,   89.316851625,   3, 9,  "BTN 600.XX"},
        {27.310514,   91.501251625,   2, 10, "BTN 800.XX"},
        {27.050514,   89.811591375,   2, 7,  "BTN B00.XX"},
        {27.482514,   90.437651625,   2, 6,  "BTN D00.XX"},
        {26.988214,   90.055691375,   2, 7,  "BTN G00.XX"},
        {27.630514,   91.110751625,   2, 6,  "BTN J00.XX"},
        {27.545514,   90.674351625,   2, 6,  "BTN L00.XX"},
        {27.079924,   91.342861375,   2, 6,  "BTN N00.XX"},
        {27.947124,   89.683809875,   2, 10, "BTN P00.XX"},
        {27.436724,   89.227335625,   2, 8,  "BTN Q00.XX"},
        {27.316324,   91.193461375,   2, 6,  "BTN R00.XX"},
        {27.104424,   89.519161375,   2, 11, "BTN S00.XX"},
        {27.184124,   90.645261375,   2, 6,  "BTN T00.XX"},
        {26.916224,   90.445061375,   2, 11, "BTN V00.XX"},
        {26.963424,   89.477761375,   2, 11, "BTN W00.XX"},
        {27.209524,   89.493861375,   2, 11, "BTN X00.XX"},
        {27.090324,   90.390961375,   2, 6,  "BTN Y00.XX"},
        {27.529224,   90.883235625,   2, 6,  "BTN Z00.XX"},
        {27.7249615,  88.8252005,     1, 11, "BTN 123.XXX"},
        {47.364114,   8.50839875,     4, 7,  "CHE 00.XX"},
        {46.184794,   6.111075,       5, 7,  "CHE 80.XX"},
        {47.525674,   7.56563875,     4, 7,  "CHE J0.XX"},
        {46.931954,   7.421296875,    4, 6,  "CHE S0.XX"},
        {47.4652115,  8.190728,       3, 6,  "CHE 12.XXX"},
        {47.503114,   7.51713325,     3, 6,  "CHE 000.XX"},
        {46.930514,   7.350881625,    3, 5,  "CHE 200.XX"},
        {46.194214,   6.10573,        4, 6,  "CHE 400.XX"},
        {46.168514,   5.952279375,    3, 5,  "CHE 600.XX"},
        {46.561545,   6.459425,       3, 5,  "CHE 800.XX"},
        {47.419214,   9.22973325,     3, 6,  "CHE B00.XX"},
        {47.022214,   8.210881625,    3, 5,  "CHE D00.XX"},
        {47.095414,   7.187681625,    3, 5,  "CHE G00.XX"},
        {46.718614,   7.545881625,    3, 5,  "CHE J00.XX"},
        {47.061514,   6.709381625,    3, 5,  "CHE L00.XX"},
        {47.729124,   8.56011025,     3, 6,  "CHE N00.XX"},
        {46.850724,   7.080675625,    3, 5,  "CHE P00.XX"},
        {46.909324,   9.447975625,    3, 5,  "CHE Q00.XX"},
        {47.020424,   6.832975625,    4, 6,  "CHE R00.XX"},
        {46.267924,   7.28324,        3, 7,  "CHE S00.XX"},
        {46.052124,   8.874305375,    3, 7,  "CHE T00.XX"},
        {46.492824,   6.81834,        3, 7,  "CHE V00.XX"},
        {45.910924,   8.924405375,    3, 7,  "CHE W00.XX"},
        {46.825324,   6.606475625,    3, 5,  "CHE X00.XX"},
        {47.398545,   7.97133125,     3, 6,  "CHE Y00.XX"},
        {46.434624,   6.16654,        3, 5,  "CHE Z00.XX"},
        {47.249221,   6.0582295,      2, 6,  "CHE 123.XXX"},
        {46.81,       8.2075,         2, 4,  "CHE 5TL0.HPL"},
        {52.383984,   4.865401375,    4, 5,  "NLD 00.XX"},
        {51.945794,   4.457263375,    4, 5,  "NLD 70.XX"},
        {52.070094,   4.283022875,    4, 5,  "NLD F0.XX"},
        {52.111204,   5.083328125,    4, 5,  "NLD M0.XX"},
        {51.429604,   5.448983375,    4, 7,  "NLD T0.XX"},
        {52.486907,   4.5989435,      3, 4,  "NLD 12.XXX"},
        {52.252124,   6.831021875,    4, 7,  "NLD 000.XX"},
        {52.009124,   5.844121875,    3, 4,  "NLD 100.XX"},
        {51.629324,   4.704799125,    3, 4,  "NLD 200.XX"},
        {51.959824,   4.517699125,    3, 4,  "NLD 300.XX"},
        {52.053024,   4.294121875,    4, 5,  "NLD 400.XX"},
        {52.205024,   5.314121875,    3, 4,  "NLD 500.XX"},
        {53.253424,   6.49392675,     4, 6,  "NLD 600.XX"},
        {52.120724,   4.186421875,    3, 4,  "NLD 700.XX"},
        {51.740724,   5.251699125,    3, 4,  "NLD 800.XX"},
        {51.858024,   4.604799125,    3, 4,  "NLD 900.XX"},
        {53.237724,   5.75072675,     4, 5,  "NLD B00.XX"},
        {50.899324,   5.6397685,      3, 8,  "NLD C00.XX"},
        {51.863424,   5.757099125,    3, 4,  "NLD D00.XX"},
        {52.243424,   5.907921875,    3, 5,  "NLD F00.XX"},
        {51.936545,   4.154280625,    3, 4,  "NLD G00.XX"},
        {51.951224,   4.379399125,    3, 4,  "NLD H00.XX"},
        {51.890724,   4.254799125,    3, 4,  "NLD J00.XX"},
        {51.593424,   4.990999125,    3, 4,  "NLD K00.XX"},
        {51.489324,   5.390999125,    3, 6,  "NLD L00.XX"},
        {52.043545,   5.590032375,    3, 4,  "NLD M00.XX"},
        {52.141545,   4.320364375,    3, 4,  "NLD N00.XX"},
        {52.080424,   4.431021875,    4, 5,  "NLD P00.XX"},
        {52.210724,   4.424121875,    3, 4,  "NLD Q00.XX"},
        {52.543324,   6.02333075,     3, 6,  "NLD R00.XX"},
        {51.031224,   5.78069025,     3, 8,  "NLD S00.XX"},
        {50.950124,   5.90689025,     4, 9,  "NLD T00.XX"},
        {52.693224,   4.71883075,     3, 4,  "NLD V00.XX"},
        {51.422124,   6.10489025,     3, 6,  "NLD W00.XX"},
        {52.290224,   6.094321875,    3, 6,  "NLD X00.XX"},
        {51.497864,   5.607650375,    3, 6,  "NLD Y00.XX"},
        {52.267404,   6.743805875,    3, 6,  "NLD YK0.00"},
        {51.544264,   4.410850375,    3, 4,  "NLD Z00.XX"},
        {52.349004,   6.609205875,    3, 6,  "NLD ZK0.00"},
        {51.1343845,  5.609281,       2, 6,  "NLD Z12.XXX"},
        {51.5654085,  5.6224825,      2, 3,  "NLD Y12.XXX"},
        {51.5654085,  4.9714825,      2, 3,  "NLD X12.XXX"},
        {51.5654085,  4.3204825,      2, 3,  "NLD V12.XXX"},
        {51.5654085,  3.6694825,      2, 3,  "NLD T12.XXX"},
        {51.389752,   3.491835,       2, 3,  "NLD SSH.FGW"},
        {51.9964325,  6.255541,       2, 5,  "NLD R12.XXX"},
        {51.9964325,  5.599333,       3, 4,  "NLD Q12.XXX"},
        {51.9964325,  4.943125,       2, 3,  "NLD P12.XXX"},
        {51.9964325,  4.286917,       2, 3,  "NLD L12.XXX"},
        {51.9964325,  3.630709,       2, 3,  "NLD K12.XXX"},
        {52.4274565,  6.5462,         2, 5,  "NLD H12.XXX"},
        {52.4274565,  5.879576,       2, 4,  "NLD G12.XXX"},
        {52.4274565,  5.212952,       3, 4,  "NLD F12.XXX"},
        {52.4274565,  4.546328,       2, 3,  "NLD D12.XXX"},
        {52.4274565,  3.879704,       2, 3,  "NLD C12.XXX"},
        {52.8584805,  6.5464865,      2, 4,  "NLD B12.XXX"},
        {52.8584805,  5.8746545,      2, 4,  "NLD 912.XXX"},
        {52.8584805,  5.2028225,      2, 3,  "NLD 812.XXX"},
        {52.8584805,  4.5309905,      2, 3,  "NLD 712.XXX"},
        {53.2895045,  6.6136695,      3, 5,  "NLD 612.XXX"},
        {53.2895045,  5.9418375,      3, 5,  "NLD 512.XXX"},
        {53.2895045,  5.2700055,      3, 4,  "NLD 412.XXX"},
        {53.2895045,  4.5981735,      2, 3,  "NLD 312.XXX"},
        {53.5171445,  6.3067105,      2, 4,  "NLD 212.XXX"},
        {53.5171445,  5.6244625,      2, 3,  "NLD 112.XXX"},
        {53.5171445,  4.9422145,      2, 3,  "NLD 012.XXX"},
        {52.152,      5.293,          3, 4,  "NLD P3ZK.7X4"},
        {55.7171,     12.4911415,     4, 7,  "DNK 12.XX"},
        {55.875219,   11.9116085,     3, 6,  "DNK 12.XXX"},
        {56.005524,   12.219919625,   3, 6,  "DNK 000.XX"},
        {56.177324,   10.087619625,   3, 4,  "DNK 100.XX"},
        {56.263824,   10.163115625,   3, 4,  "DNK 200.XX"},
        {55.420824,   10.3239365,     3, 4,  "DNK 300.XX"},
        {57.086324,   9.86399875,     3, 4,  "DNK 400.XX"},
        {55.532924,   8.3692365,      3, 4,  "DNK 500.XX"},
        {56.495724,   9.966715625,    3, 4,  "DNK 600.XX"},
        {55.530724,   9.4213365,      3, 4,  "DNK 700.XX"},
        {55.893524,   9.781919625,    3, 4,  "DNK 800.XX"},
        {55.270424,   11.6860365,     3, 4,  "DNK 900.XX"},
        {56.209324,   9.484715625,    3, 4,  "DNK B00.XX"},
        {55.599124,   9.6562365,      3, 4,  "DNK C00.XX"},
        {56.052224,   12.477619625,   3, 6,  "DNK D00.XX"},
        {56.483424,   9.337115625,    3, 4,  "DNK F00.XX"},
        {56.400724,   8.531815625,    3, 4,  "DNK G00.XX"},
        {56.179324,   8.890419625,    3, 4,  "DNK H00.XX"},
        {57.499324,   10.407868,      3, 4,  "DNK J00.XX"},
        {55.750724,   9.486219625,    3, 4,  "DNK K00.XX"},
        {55.450724,   11.2988365,     4, 7,  "DNK L00.XX"},
        {56.610724,   8.947115625,    3, 4,  "DNK M00.XX"},
        {55.077764,   10.5587575,     3, 5,  "DNK N00.XX"},
        {54.911704,   9.7418275,      3, 5,  "DNK NK0.00"},
        {57.471564,   9.936279,       3, 4,  "DNK P00.XX"},
        {55.712404,   11.663397625,   3, 6,  "DNK PK0.00"},
        {55.265964,   9.4291705,      3, 4,  "DNK Q00.XX"},
        {55.441804,   11.7581485,     3, 6,  "DNK QK0.00"},
        {54.782464,   11.8167575,     4, 6,  "DNK R00.XX"},
        {55.037704,   9.3742275,      3, 5,  "DNK RK0.00"},
        {55.691464,   11.028197875,   3, 5,  "DNK S00.XX"},
        {55.313904,   10.7435485,     3, 4,  "DNK SK0.00"},
        {55.354664,   11.0915705,     3, 5,  "DNK T00.XX"},
        {56.128904,   9.109018625,    3, 4,  "DNK TK0.00"},
        {56.427164,   10.828310875,   3, 4,  "DNK V00.XX"},
        {54.830504,   11.0975275,     3, 5,  "DNK VK0.00"},
        {55.124464,   14.6820705,     3, 4,  "DNK W00.XX"},
        {55.482504,   9.7089485,      3, 4,  "DNK WK0.00"},
        {56.053964,   9.883897875,    3, 4,  "DNK X00.XX"},
        {56.966604,   8.65096675,     3, 4,  "DNK XK0.00"},
        {55.630664,   8.431297875,    3, 4,  "DNK Y00.XX"},
        {55.982904,   11.944797625,   3, 6,  "DNK YK0.00"},
        {57.287264,   9.899879,       3, 4,  "DNK Z00.XX"},
        {56.485104,   8.538418625,    3, 4,  "DNK ZK0.00"},
        {55.245866,   8.1121715,      2, 3,  "DNK 012.XXX"},
        {55.245866,   8.9194115,      2, 3,  "DNK 112.XXX"},
        {55.245866,   9.7266515,      2, 3,  "DNK 212.XXX"},
        {55.736906,   8.1075365,      2, 3,  "DNK 512.XXX"},
        {55.736906,   8.9251925,      2, 3,  "DNK 612.XXX"},
        {55.736906,   9.7428485,      2, 3,  "DNK 712.XXX"},
        {56.227946,   8.1029015,      2, 3,  "DNK C12.XXX"},
        {56.227946,   8.9309735,      2, 3,  "DNK D12.XXX"},
        {56.227946,   9.7590455,      2, 3,  "DNK F12.XXX"},
        {56.718986,   8.0982665,      2, 3,  "DNK K12.XXX"},
        {56.718986,   8.9367545,      2, 3,  "DNK L12.XXX"},
        {56.718986,   9.7752425,      2, 3,  "DNK M12.XXX"},
        {57.210026,   8.0936315,      2, 3,  "DNK P12.XXX"},
        {57.210026,   8.9425355,      2, 3,  "DNK Q12.XXX"},
        {57.210026,   9.7914395,      2, 3,  "DNK R12.XXX"},
        {57.701066,   9.102759,       2, 3,  "DNK S12.XXX"},
        {57.7467555,  9.9657125,      2, 3,  "DNK T12.XXX"},
        {56.532445,   10.5246215,     3, 4,  "DNK N12.XXX"},
        {56.041405,   10.5246215,     3, 4,  "DNK G12.XXX"},
        {55.550365,   10.5292565,     2, 3,  "DNK 812.XXX"},
        {55.059325,   10.5338915,     2, 4,  "DNK 312.XXX"},
        {55.00531,    11.3411315,     2, 4,  "DNK 412.XXX"},
        {55.49635,    11.3364965,     2, 5,  "DNK 912.XXX"},
        {55.98739,    11.3364965,     2, 5,  "DNK H12.XXX"},
        {56.097874,   12.0268685,     2, 5,  "DNK J12.XXX"},
        {55.606834,   12.0315035,     4, 7,  "DNK B12.XXX"},
        {55.115794,   12.0361385,     3, 4,  "DNK V12.XXX"},
        {56.316078,   11.4883745,     2, 5,  "DNK W12.XXX"},
        {57.387204,   10.804189,      2, 3,  "DNK X12.XXX"},
        {56.792546,   11.436366,      2, 5,  "DNK Y12.XXX"},
        {55.300053,   14.663805,      2, 3,  "DNK Z12.XXX"},
        {54.5809845,  11.7165045,     3, 5,  "DNK Z1.XXXX"},
        {56.162,      11.599,         2, 5,  "DNK 8639.ZRY"},
        {59.4299985,  24.64622,       4, 6,  "EST 12.XX"},
        {59.3179625,  24.079558,      3, 6,  "EST 12.XXX"},
        {58.348814,   26.605661375,   3, 5,  "EST 000.XX"},
        {59.368714,   27.980996,      3, 9,  "EST 200.XX"},
        {59.375314,   27.129396,      3, 9,  "EST 400.XX"},
        {58.369114,   24.471661375,   3, 5,  "EST 600.XX"},
        {58.350514,   25.484061375,   3, 5,  "EST 800.XX"},
        {59.328114,   26.250396,      3, 5,  "EST B00.XX"},
        {59.338914,   27.676796,      3, 9,  "EST D00.XX"},
        {58.253614,   22.366261375,   3, 6,  "EST G00.XX"},
        {57.830514,   26.895759125,   3, 5,  "EST J00.XX"},
        {57.760514,   25.935759125,   3, 6,  "EST L00.XX"},
        {58.980424,   23.506891625,   3, 6,  "EST N00.XX"},
        {59.377324,   27.370848,      3, 9,  "EST P00.XX"},
        {58.936024,   25.523791625,   3, 5,  "EST Q00.XX"},
        {59.386024,   26.901248,      3, 7,  "EST R00.XX"},
        {59.303524,   25.886491625,   3, 5,  "EST S00.XX"},
        {58.097424,   26.995351125,   3, 6,  "EST T00.XX"},
        {58.784924,   26.338321375,   3, 5,  "EST V00.XX"},
        {58.860724,   25.351691625,   3, 5,  "EST W00.XX"},
        {58.270724,   26.323951125,   3, 5,  "EST X00.XX"},
        {59.050724,   24.721691625,   3, 5,  "EST Y00.XX"},
        {58.711924,   25.852021375,   3, 5,  "EST Z00.XX"},
        {59.4556735,  23.387437,      2, 5,  "EST 112.XXX"},
        {59.671595,   24.5001695,     2, 4,  "EST 212.XXX"},
        {59.671595,   25.4011535,     2, 4,  "EST 312.XXX"},
        {59.671595,   26.3021375,     2, 4,  "EST 412.XXX"},
        {59.4462415,  27.1995475,     3, 10, "EST 512.XXX"},
        {59.180555,   21.7521685,     2, 5,  "EST 612.XXX"},
        {59.180555,   22.6531515,     2, 5,  "EST 712.XXX"},
        {59.180555,   23.5541355,     2, 5,  "EST 812.XXX"},
        {59.180555,   24.4551195,     2, 4,  "EST 912.XXX"},
        {59.180555,   25.3561035,     2, 4,  "EST B12.XXX"},
        {59.180555,   26.2570875,     2, 4,  "EST C12.XXX"},
        {59.180555,   27.1580715,     2, 8,  "EST D12.XXX"},
        {58.689515,   21.756516,      2, 5,  "EST F12.XXX"},
        {58.689515,   22.641876,      2, 5,  "EST G12.XXX"},
        {58.689515,   23.527236,      2, 5,  "EST H12.XXX"},
        {58.689515,   24.412596,      2, 4,  "EST J12.XXX"},
        {58.689515,   25.297956,      2, 4,  "EST K12.XXX"},
        {58.689515,   26.183316,      2, 4,  "EST L12.XXX"},
        {58.689515,   27.068676,      2, 8,  "EST M12.XXX"},
        {58.198475,   21.761152,      2, 5,  "EST N12.XXX"},
        {58.198475,   22.636096,      2, 5,  "EST P12.XXX"},
        {58.198475,   23.51104,       2, 5,  "EST Q12.XXX"},
        {58.198475,   24.385984,      2, 4,  "EST R12.XXX"},
        {58.198475,   25.260928,      2, 4,  "EST S12.XXX"},
        {58.198475,   26.135872,      2, 4,  "EST T12.XXX"},
        {58.198475,   27.010816,      2, 5,  "EST V12.XXX"},
        {57.5019975,  26.1637555,     2, 5,  "EST W12.XXX"},
        {59.781428,   25.421174,      2, 5,  "EST X12.XXX"},
        {58.661015,   24.975,         2, 4,  "EST L30B.5JQ"},
        {18.495489,   -69.930792,     4, 6,  "DOM 12.XX"},
        {18.4273615,  -70.19294,      3, 5,  "DOM 12.XXX"},
        {19.496724,   -70.75645325,   3, 5,  "DOM 000.XX"},
        {19.505373,   -70.66467925,   3, 5,  "DOM 100.XX"},
        {18.476624,   -69.042426625,  3, 5,  "DOM 200.XX"},
        {18.506024,   -69.338126625,  3, 5,  "DOM 300.XX"},
        {19.832724,   -70.73486525,   3, 5,  "DOM 400.XX"},
        {19.340524,   -70.3075395,    3, 5,  "DOM 500.XX"},
        {19.264324,   -70.5728395,    3, 5,  "DOM 600.XX"},
        {18.975824,   -70.4509395,    3, 5,  "DOM 700.XX"},
        {18.257524,   -71.15291375,   3, 5,  "DOM 800.XX"},
        {18.850724,   -71.272826625,  3, 5,  "DOM 900.XX"},
        {18.657224,   -68.761326625,  3, 5,  "DOM B00.XX"},
        {19.441624,   -70.5686395,    3, 5,  "DOM C00.XX"},
        {18.317524,   -70.38381375,   3, 5,  "DOM D00.XX"},
        {18.494924,   -70.776226625,  3, 5,  "DOM F00.XX"},
        {19.591724,   -71.13176525,   3, 5,  "DOM G00.XX"},
        {19.067564,   -70.1864325,    3, 5,  "DOM H00.XX"},
        {19.582204,   -71.01324725,   3, 5,  "DOM HK0.00"},
        {18.682464,   -70.202545875,  3, 5,  "DOM J00.XX"},
        {19.362204,   -69.8729025,    3, 5,  "DOM JK0.00"},
        {18.766964,   -69.278045875,  3, 5,  "DOM K00.XX"},
        {18.558704,   -70.529529625,  3, 5,  "DOM KK0.00"},
        {19.563964,   -70.89670375,   3, 5,  "DOM L00.XX"},
        {18.864104,   -71.547429625,  3, 5,  "DOM LK0.00"},
        {19.132464,   -70.6726325,    3, 5,  "DOM M00.XX"},
        {18.901104,   -70.7591025,    3, 5,  "DOM MK0.00"},
        {18.572464,   -69.332545875,  3, 5,  "DOM N00.XX"},
        {18.484104,   -71.447429625,  3, 5,  "DOM NK0.00"},
        {18.771964,   -69.061445875,  3, 5,  "DOM P00.XX"},
        {19.475504,   -71.35924725,   3, 5,  "DOM PK0.00"},
        {18.963264,   -69.8061325,    3, 5,  "DOM Q00.XX"},
        {19.369304,   -70.4434025,    3, 5,  "DOM QK0.00"},
        {18.772464,   -69.672545875,  3, 5,  "DOM R00.XX"},
        {19.544104,   -71.73764725,   3, 7,  "DOM RK0.00"},
        {18.822464,   -69.822545875,  3, 5,  "DOM S00.XX"},
        {18.554104,   -69.437429625,  3, 5,  "DOM SK0.00"},
        {18.259064,   -71.23246025,   3, 5,  "DOM T00.XX"},
        {19.844104,   -71.67764725,   3, 6,  "DOM TK0.00"},
        {19.204564,   -70.2309325,    3, 5,  "DOM V00.XX"},
        {18.383504,   -71.227129625,  3, 5,  "DOM VK0.00"},
        {19.063864,   -69.4261325,    3, 5,  "DOM W00.XX"},
        {19.219804,   -69.6462025,    3, 5,  "DOM WK0.00"},
        {19.201864,   -70.1507325,    3, 5,  "DOM X00.XX"},
        {19.734104,   -71.47764725,   3, 5,  "DOM XK0.00"},
        {18.304964,   -71.21526025,   3, 5,  "DOM Y00.XX"},
        {19.212604,   -69.3691025,    3, 5,  "DOM YK0.00"},
        {18.882464,   -71.732545875,  3, 6,  "DOM Z00.XX"},
        {18.041904,   -71.77255775,   3, 6,  "DOM ZK0.00"},
        {19.894595,   -71.9901775,    2, 5,  "DOM 012.XXX"},
        {19.894595,   -71.4954175,    2, 4,  "DOM 112.XXX"},
        {19.894595,   -71.0006575,    2, 4,  "DOM 212.XXX"},
        {19.894595,   -70.5058975,    2, 4,  "DOM 312.XXX"},
        {19.894595,   -70.0111375,    2, 4,  "DOM 412.XXX"},
        {19.403555,   -71.9901775,    2, 5,  "DOM 512.XXX"},
        {19.403555,   -71.4954175,    2, 4,  "DOM 612.XXX"},
        {19.403555,   -71.0006575,    2, 4,  "DOM 712.XXX"},
        {19.403555,   -70.5058975,    3, 5,  "DOM 812.XXX"},
        {19.403555,   -70.0111375,    2, 4,  "DOM 912.XXX"},
        {19.403555,   -69.5163775,    2, 4,  "DOM B12.XXX"},
        {19.403555,   -69.0216185,    2, 4,  "DOM C12.XXX"},
        {18.912515,   -71.990464,     2, 5,  "DOM D12.XXX"},
        {18.912515,   -71.500913,     2, 4,  "DOM F12.XXX"},
        {18.912515,   -71.011361,     2, 4,  "DOM G12.XXX"},
        {18.912515,   -70.521809,     2, 4,  "DOM H12.XXX"},
        {18.912515,   -70.032257,     2, 4,  "DOM J12.XXX"},
        {18.912515,   -69.542705,     2, 4,  "DOM K12.XXX"},
        {18.912515,   -69.053153,     2, 4,  "DOM L12.XXX"},
        {18.421475,   -71.990465,     2, 5,  "DOM N12.XXX"},
        {18.421475,   -71.500913,     2, 4,  "DOM P12.XXX"},
        {18.421475,   -71.011361,     2, 4,  "DOM Q12.XXX"},
        {18.421475,   -70.521809,     2, 4,  "DOM R12.XXX"},
        {18.421475,   -70.032257,     3, 5,  "DOM S12.XXX"},
        {18.421475,   -69.542705,     2, 4,  "DOM T12.XXX"},
        {17.4811645,  -71.889809,     2, 3,  "DOM X12.XXX"},
        {17.930435,   -71.500913,     2, 4,  "DOM Y12.XXX"},
        {18.4173405,  -68.581526,     3, 5,  "DOM Z12.XXX"},
        {18.3753575,  -69.0534725,    2, 4,  "DOM V12.XXX"},
        {19.821992,   -71.8860005,    2, 5,  "DOM 1234.XXX"},
        {48.182126,   17.0744875,     4, 7,  "SVK 12.XX"},
        {48.414129,   16.9975415,     3, 6,  "SVK 12.XXX"},
        {48.760024,   21.1924805,     3, 4,  "SVK 000.XX"},
        {48.350724,   18.0189805,     3, 4,  "SVK 100.XX"},
        {49.046924,   21.16800225,    3, 5,  "SVK 200.XX"},
        {49.250724,   18.69350225,    3, 7,  "SVK 300.XX"},
        {48.774624,   19.0908805,     3, 4,  "SVK 400.XX"},
        {49.118524,   18.86130225,    3, 5,  "SVK 500.XX"},
        {48.914824,   17.96910225,    3, 6,  "SVK 600.XX"},
        {49.108924,   20.22550225,    3, 5,  "SVK 700.XX"},
        {48.830424,   18.5556805,     3, 4,  "SVK 800.XX"},
        {48.599164,   19.0936275,     3, 4,  "SVK 900.XX"},
        {49.115704,   18.40788325,    3, 7,  "SVK 9K0.00"},
        {47.997564,   18.099657625,   3, 6,  "SVK B00.XX"},
        {48.943504,   20.50158325,    3, 4,  "SVK BK0.00"},
        {48.767664,   21.8634275,     3, 4,  "SVK C00.XX"},
        {47.771604,   18.075979875,   3, 6,  "SVK CK0.00"},
        {48.239064,   18.531757625,   3, 4,  "SVK D00.XX"},
        {48.924104,   21.87048325,    3, 4,  "SVK DK0.00"},
        {49.310164,   21.24371275,    3, 6,  "SVK F00.XX"},
        {49.074104,   19.57048325,    3, 5,  "SVK FK0.00"},
        {48.610764,   17.7818275,     3, 6,  "SVK G00.XX"},
        {49.066404,   19.27368325,    3, 5,  "SVK GK0.00"},
        {48.582464,   18.1136275,     3, 4,  "SVK H00.XX"},
        {48.339504,   19.6163175,     3, 6,  "SVK HK0.00"},
        {49.463964,   18.728797,      3, 7,  "SVK J00.XX"},
        {48.964104,   18.14048325,    4, 5,  "SVK JK0.00"},
        {48.402464,   19.9736275,     3, 6,  "SVK K00.XX"},
        {48.633404,   18.3535175,     3, 4,  "SVK KK0.00"},
        {48.164264,   17.810757625,   3, 4,  "SVK L00.XX"},
        {48.439404,   17.7503175,     3, 4,  "SVK LK0.00"},
        {48.816664,   19.59291275,    3, 4,  "SVK M00.XX"},
        {48.884104,   21.65048325,    3, 4,  "SVK MK0.00"},
        {48.649164,   21.6728275,     3, 4,  "SVK N00.XX"},
        {48.747904,   17.7936175,     3, 6,  "SVK NK0.00"},
        {48.695864,   17.3170275,     3, 6,  "SVK P00.XX"},
        {48.976304,   22.09888325,    3, 4,  "SVK PK0.00"},
        {49.152564,   20.36781275,    3, 5,  "SVK Q00.XX"},
        {48.714104,   18.2109175,     3, 4,  "SVK QK0.00"},
        {49.232464,   19.25311275,    3, 6,  "SVK R00.XX"},
        {48.584104,   18.8209175,     3, 4,  "SVK RK0.00"},
        {48.655364,   20.4825275,     3, 4,  "SVK S00.XX"},
        {49.114104,   18.28048325,    3, 7,  "SVK SK0.00"},
        {48.742464,   18.7136275,     3, 4,  "SVK T00.XX"},
        {48.274504,   17.7072175,     3, 4,  "SVK TK0.00"},
        {49.312464,   18.73311275,    3, 7,  "SVK V00.XX"},
        {48.172804,   17.720279875,   3, 4,  "SVK VK0.00"},
        {49.312464,   20.64311275,    3, 6,  "SVK W00.XX"},
        {48.384104,   18.3609175,     3, 4,  "SVK WK0.00"},
        {48.577364,   19.3476275,     3, 4,  "SVK X00.XX"},
        {48.844104,   17.19048325,    3, 7,  "SVK XK0.00"},
        {48.707564,   20.0682275,     3, 4,  "SVK Y00.XX"},
        {48.948104,   18.06588325,    3, 6,  "SVK YK0.00"},
        {48.212464,   19.304057625,   3, 4,  "SVK Z00.XX"},
        {48.764104,   17.5309175,     3, 6,  "SVK ZK0.00"},
        {49.424979,   18.006061,      2, 6,  "SVK 0HH.HHH"},
        {49.424979,   18.714349,      2, 6,  "SVK 1HH.HHH"},
        {49.424979,   19.422637,      2, 5,  "SVK 2HH.HHH"},
        {49.424979,   20.130925,      2, 5,  "SVK 3HH.HHH"},
        {49.424979,   20.839213,      2, 5,  "SVK 4HH.HHH"},
        {49.424979,   21.547501,      2, 5,  "SVK 5HH.HHH"},
        {49.424979,   22.255789,      2, 6,  "SVK 6HH.HHH"},
        {49.132659,   16.9855425,     2, 6,  "SVK 712.XXX"},
        {49.132659,   17.6886225,     2, 6,  "SVK 812.XXX"},
        {49.132659,   18.3917025,     2, 6,  "SVK 912.XXX"},
        {49.132659,   19.0947825,     2, 4,  "SVK B12.XXX"},
        {49.132659,   19.7978625,     2, 4,  "SVK C12.XXX"},
        {49.132659,   20.5009425,     2, 4,  "SVK D12.XXX"},
        {49.132659,   21.2040225,     2, 4,  "SVK F12.XXX"},
        {49.132659,   21.9071025,     2, 4,  "SVK G12.XXX"},
        {48.641619,   16.8495615,     2, 7,  "SVK H12.XXX"},
        {48.641619,   17.5422255,     2, 5,  "SVK J12.XXX"},
        {48.641619,   18.2348895,     2, 3,  "SVK K12.XXX"},
        {48.641619,   18.9275535,     2, 3,  "SVK L12.XXX"},
        {48.641619,   19.6202175,     2, 3,  "SVK M12.XXX"},
        {48.641619,   20.3128815,     2, 3,  "SVK N12.XXX"},
        {48.641619,   21.0055455,     2, 3,  "SVK P12.XXX"},
        {48.641619,   21.6982095,     3, 4,  "SVK Q12.XXX"},
        {48.150579,   16.849275,      2, 5,  "SVK R12.XXX"},
        {48.150579,   17.536731,      3, 4,  "SVK S12.XXX"},
        {48.150579,   18.224187,      2, 3,  "SVK T12.XXX"},
        {48.150579,   18.911643,      2, 3,  "SVK V12.XXX"},
        {48.150579,   19.599099,      2, 5,  "SVK W12.XXX"},
        {48.6715,     19.695,         2, 3,  "SVK F60G.KGF"},
        {9.965145,    -84.118394,     4, 5,  "CRI 12.XX"},
        {10.020975,   -84.3789665,    3, 4,  "CRI 12.XXX"},
        {9.949814,    -83.108858375,  3, 4,  "CRI 000.XX"},
        {10.587914,   -85.49822825,   3, 4,  "CRI 200.XX"},
        {9.985014,    -84.859758375,  3, 4,  "CRI 400.XX"},
        {9.985014,    -84.735751375,  3, 4,  "CRI 600.XX"},
        {9.350714,    -83.7724885,    3, 4,  "CRI 800.XX"},
        {10.496414,   -85.02932825,   3, 4,  "CRI B00.XX"},
        {9.854314,    -83.734558375,  3, 4,  "CRI D00.XX"},
        {10.388514,   -84.37832825,   3, 4,  "CRI G00.XX"},
        {10.410514,   -85.16212825,   3, 4,  "CRI J00.XX"},
        {10.190314,   -83.84072825,   3, 4,  "CRI L00.XX"},
        {10.190314,   -83.71638125,   3, 4,  "CRI N00.XX"},
        {10.092914,   -83.57942825,   3, 4,  "CRI Q00.XX"},
        {10.081114,   -83.37662825,   3, 4,  "CRI S00.XX"},
        {10.140814,   -85.50822825,   3, 4,  "CRI V00.XX"},
        {10.120424,   -84.48735725,   3, 4,  "CRI X00.XX"},
        {9.695224,    -84.044944375,  3, 4,  "CRI Y00.XX"},
        {9.209424,    -83.3888315,    3, 4,  "CRI Z00.XX"},
        {10.7359095,  -84.057771,     2, 5,  "CRI 512.XXX"},
        {11.179594,   -85.9513245,    2, 6,  "CRI 112.XXX"},
        {11.179594,   -85.4773965,    2, 6,  "CRI 212.XXX"},
        {11.179594,   -85.0034685,    2, 6,  "CRI 312.XXX"},
        {11.179594,   -84.5295405,    2, 6,  "CRI 412.XXX"},
        {10.688554,   -85.9513245,    2, 3,  "CRI 612.XXX"},
        {10.688554,   -85.4773965,    2, 3,  "CRI 712.XXX"},
        {10.688554,   -85.0034685,    2, 3,  "CRI 812.XXX"},
        {10.688554,   -84.5295405,    2, 3,  "CRI 912.XXX"},
        {10.688554,   -84.0556125,    2, 3,  "CRI B12.XXX"},
        {10.688554,   -83.5816845,    2, 3,  "CRI C12.XXX"},
        {10.197514,   -85.9513245,    2, 3,  "CRI D12.XXX"},
        {10.197514,   -85.4773965,    3, 4,  "CRI F12.XXX"},
        {10.197514,   -85.0034685,    2, 3,  "CRI G12.XXX"},
        {10.197514,   -84.5295405,    2, 3,  "CRI H12.XXX"},
        {10.197514,   -84.0556125,    2, 3,  "CRI J12.XXX"},
        {10.197514,   -83.5816845,    2, 3,  "CRI K12.XXX"},
        {10.197514,   -83.1077565,    2, 3,  "CRI L12.XXX"},
        {9.706474,    -85.3352175,    2, 3,  "CRI M12.XXX"},
        {9.706474,    -84.8612895,    2, 3,  "CRI N12.XXX"},
        {9.706474,    -84.3873615,    2, 3,  "CRI P12.XXX"},
        {9.706474,    -83.9134335,    2, 3,  "CRI Q12.XXX"},
        {9.706474,    -83.4395055,    2, 3,  "CRI R12.XXX"},
        {9.706474,    -82.9655775,    2, 3,  "CRI S12.XXX"},
        {9.215435,    -84.0793085,    2, 3,  "CRI T12.XXX"},
        {9.215435,    -83.6053805,    2, 3,  "CRI V12.XXX"},
        {9.215435,    -83.1314525,    2, 3,  "CRI W12.XXX"},
        {8.724395,    -83.961113,     2, 3,  "CRI X12.XXX"},
        {8.724395,    -83.492393,     2, 3,  "CRI Y12.XXX"},
        {8.2804215,   -83.0396225,    2, 5,  "CRI Z12.XXX"},
        {5.5872505,   -87.230651,     1, 2,  "CRI 012.XXX"},
        {8.3724,      -82.932229,     2, 5,  "CRI M6JV.L2V"},
        {43.8513945,  18.304128,      4, 5,  "BIH 12.XX"},
        {44.207247,   17.866602,      3, 4,  "BIH 12.XXX"},
        {44.827624,   17.137635125,   3, 4,  "BIH 000.XX"},
        {44.582524,   18.600587625,   3, 4,  "BIH 100.XX"},
        {43.380724,   17.7544045,     3, 4,  "BIH 200.XX"},
        {44.860724,   15.812935125,   3, 6,  "BIH 300.XX"},
        {44.889424,   18.730435125,   3, 4,  "BIH 400.XX"},
        {44.800724,   19.162935125,   3, 6,  "BIH 500.XX"},
        {45.020724,   16.652935125,   3, 4,  "BIH 600.XX"},
        {44.100724,   17.393952,      3, 4,  "BIH 700.XX"},
        {42.750724,   18.284856,      3, 6,  "BIH 800.XX"},
        {44.270724,   17.613387625,   3, 4,  "BIH 900.XX"},
        {44.770724,   18.032935125,   3, 4,  "BIH B00.XX"},
        {45.010724,   15.882935125,   3, 6,  "BIH C00.XX"},
        {43.710724,   18.923952,      3, 4,  "BIH D00.XX"},
        {45.220924,   15.76587075,    3, 6,  "BIH F00.XX"},
        {43.690724,   17.903952,      3, 4,  "BIH G00.XX"},
        {44.489124,   18.622787625,   3, 4,  "BIH H00.XX"},
        {44.583924,   18.442287625,   3, 4,  "BIH J00.XX"},
        {44.196424,   17.733687625,   3, 4,  "BIH K00.XX"},
        {44.899164,   16.108133375,   3, 4,  "BIH L00.XX"},
        {43.504104,   18.7443915,     3, 6,  "BIH LK0.00"},
        {44.712464,   18.266633375,   3, 4,  "BIH M00.XX"},
        {44.874104,   18.393451125,   3, 4,  "BIH MK0.00"},
        {45.148664,   17.20600425,    3, 6,  "BIH N00.XX"},
        {44.438604,   18.112940625,   3, 4,  "BIH NK0.00"},
        {44.779564,   16.613133375,   3, 4,  "BIH P00.XX"},
        {44.408904,   17.052140625,   3, 4,  "BIH PK0.00"},
        {42.882564,   18.384393,      3, 4,  "BIH Q00.XX"},
        {43.823204,   16.958302,      3, 6,  "BIH QK0.00"},
        {44.994864,   17.854033375,   3, 4,  "BIH R00.XX"},
        {45.157104,   16.77318875,    3, 6,  "BIH RK0.00"},
        {45.022464,   18.286633375,   3, 4,  "BIH S00.XX"},
        {45.117204,   17.96458875,    3, 7,  "BIH SK0.00"},
        {44.173564,   17.615476875,   3, 4,  "BIH T00.XX"},
        {44.274104,   17.043740625,   3, 4,  "BIH TK0.00"},
        {44.352464,   17.226976875,   3, 4,  "BIH V00.XX"},
        {45.044104,   16.343451125,   3, 6,  "BIH VK0.00"},
        {43.832464,   17.567406,      3, 4,  "BIH W00.XX"},
        {44.402004,   19.078640625,   3, 6,  "BIH WK0.00"},
        {43.212464,   17.5077495,     3, 6,  "BIH X00.XX"},
        {43.374104,   17.5543915,     3, 6,  "BIH XK0.00"},
        {43.422464,   17.8377495,     3, 4,  "BIH Y00.XX"},
        {44.134104,   17.363740625,   3, 4,  "BIH YK0.00"},
        {43.952464,   18.757406,      3, 4,  "BIH Z00.XX"},
        {44.424104,   18.003740625,   3, 4,  "BIH ZK0.00"},
        {45.176731,   16.050931,      2, 5,  "BIH 0HH.HHH"},
        {45.176731,   16.707139,      2, 5,  "BIH 1HH.HHH"},
        {45.176731,   17.363347,      2, 5,  "BIH 2HH.HHH"},
        {45.176731,   18.019555,      2, 6,  "BIH 3HH.HHH"},
        {45.176731,   18.675763,      2, 5,  "BIH 4HH.HHH"},
        {44.884411,   15.7620205,     2, 5,  "BIH 512.XXX"},
        {44.884411,   16.4130205,     2, 3,  "BIH 612.XXX"},
        {44.884411,   17.0640205,     2, 3,  "BIH 712.XXX"},
        {44.884411,   17.7150205,     2, 3,  "BIH 812.XXX"},
        {44.884411,   18.3660205,     2, 3,  "BIH 912.XXX"},
        {44.884411,   19.0170205,     2, 7,  "BIH B12.XXX"},
        {44.393371,   16.087234,      2, 5,  "BIH C12.XXX"},
        {44.393371,   16.733026,      2, 3,  "BIH D12.XXX"},
        {44.393371,   17.378818,      2, 3,  "BIH F12.XXX"},
        {44.393371,   18.02461,       2, 3,  "BIH G12.XXX"},
        {44.393371,   18.670402,      2, 3,  "BIH H12.XXX"},
        {44.393371,   19.316194,      2, 5,  "BIH J12.XXX"},
        {43.902331,   16.4150515,     2, 5,  "BIH K12.XXX"},
        {43.902331,   17.0556355,     2, 5,  "BIH L12.XXX"},
        {43.902331,   17.6962195,     2, 3,  "BIH M12.XXX"},
        {43.902331,   18.3368035,     3, 4,  "BIH N12.XXX"},
        {43.902331,   18.9773875,     2, 3,  "BIH P12.XXX"},
        {43.411291,   17.247524,      2, 5,  "BIH Q12.XXX"},
        {43.411291,   17.8829,        3, 4,  "BIH S12.XXX"},
        {43.411291,   18.518276,      2, 5,  "BIH T12.XXX"},
        {42.920251,   17.565212,      2, 5,  "BIH V12.XXX"},
        {42.920251,   18.200588,      2, 5,  "BIH W12.XXX"},
        {43.915598,   17.6723315,     2, 3,  "BIH 9MKB.2XC"},
        {45.835145,   15.9158045,     4, 7,  "HRV 12.XX"},
        {45.8399275,  15.498672,      3, 6,  "HRV 12.XXX"},
        {43.580724,   16.3162045,     3, 4,  "HRV 000.XX"},
        {43.580724,   16.4344045,     3, 6,  "HRV 100.XX"},
        {45.394924,   14.37867075,    3, 4,  "HRV 200.XX"},
        {45.590724,   18.62237075,    3, 4,  "HRV 300.XX"},
        {44.161824,   15.196887625,   3, 4,  "HRV 400.XX"},
        {44.908824,   13.805435125,   3, 6,  "HRV 500.XX"},
        {45.200724,   17.95237075,    3, 6,  "HRV 600.XX"},
        {45.540724,   15.48237075,    3, 6,  "HRV 700.XX"},
        {46.350724,   16.27124,       3, 6,  "HRV 800.XX"},
        {43.780724,   15.833952,      3, 4,  "HRV 900.XX"},
        {45.520724,   16.30237075,    3, 6,  "HRV B00.XX"},
        {45.330724,   18.74237075,    3, 4,  "HRV C00.XX"},
        {42.700724,   18.014856,      3, 6,  "HRV D00.XX"},
        {45.390724,   18.93237075,    3, 6,  "HRV F00.XX"},
        {45.950724,   16.781805375,   3, 4,  "HRV G00.XX"},
        {46.200724,   16.771805375,   3, 4,  "HRV H00.XX"},
        {45.350724,   18.35237075,    3, 4,  "HRV J00.XX"},
        {45.380724,   17.62237075,    3, 4,  "HRV K00.XX"},
        {46.430724,   16.36124,       3, 8,  "HRV L00.XX"},
        {45.880724,   17.331805375,   3, 7,  "HRV M00.XX"},
        {45.520724,   16.72237075,    3, 4,  "HRV N00.XX"},
        {43.090724,   17.5744045,     3, 6,  "HRV P00.XX"},
        {45.482024,   16.22417075,    3, 6,  "HRV Q00.XX"},
        {45.110724,   18.642935125,   3, 6,  "HRV R00.XX"},
        {45.130724,   13.582935125,   3, 6,  "HRV S00.XX"},
        {43.340724,   16.9644045,     3, 4,  "HRV T00.XX"},
        {45.300724,   17.32237075,    3, 4,  "HRV V00.XX"},
        {46.060724,   16.481805375,   3, 6,  "HRV W00.XX"},
        {43.740724,   16.583952,      3, 6,  "HRV X00.XX"},
        {44.080724,   16.143952,      3, 6,  "HRV Y00.XX"},
        {45.740724,   17.651805375,   3, 7,  "HRV Z00.XX"},
        {46.37412,    15.6099595,     2, 6,  "HRV 012.XXX"},
        {46.528626,   16.1615185,     2, 7,  "HRV 112.XXX"},
        {46.37412,    16.8280515,     2, 5,  "HRV 212.XXX"},
        {45.976155,   14.5070175,     2, 6,  "HRV 312.XXX"},
        {45.976155,   15.1684325,     2, 5,  "HRV 412.XXX"},
        {45.976155,   15.8298485,     3, 6,  "HRV 512.XXX"},
        {45.976155,   16.4912645,     2, 5,  "HRV 612.XXX"},
        {45.976155,   17.1526805,     2, 6,  "HRV 712.XXX"},
        {45.976155,   17.8140965,     2, 6,  "HRV 812.XXX"},
        {45.976155,   18.4755125,     2, 6,  "HRV 912.XXX"},
        {45.485115,   13.514607,      2, 7,  "HRV B12.XXX"},
        {45.485115,   14.170815,      2, 5,  "HRV C12.XXX"},
        {45.485115,   14.827023,      2, 5,  "HRV D12.XXX"},
        {45.485115,   15.483231,      3, 6,  "HRV F12.XXX"},
        {45.485115,   16.139439,      2, 5,  "HRV G12.XXX"},
        {45.485115,   16.795647,      3, 4,  "HRV H12.XXX"},
        {45.485115,   17.451855,      2, 3,  "HRV J12.XXX"},
        {45.485115,   18.108063,      2, 3,  "HRV K12.XXX"},
        {45.415422,   18.7627005,     2, 3,  "HRV L12.XXX"},
        {45.1204305,  18.757979,      3, 6,  "HRV M12.XXX"},
        {44.994086,   13.5217165,     2, 5,  "HRV N12.XXX"},
        {44.994086,   14.1727165,     2, 3,  "HRV P12.XXX"},
        {44.994086,   14.8237165,     2, 3,  "HRV Q12.XXX"},
        {44.994086,   15.4747165,     2, 3,  "HRV R12.XXX"},
        {44.503074,   13.8797665,     2, 3,  "HRV S12.XXX"},
        {44.503074,   14.5307665,     2, 3,  "HRV T12.XXX"},
        {44.503074,   15.1817665,     2, 3,  "HRV V12.XXX"},
        {44.503074,   15.8327665,     2, 5,  "HRV W12.XXX"},
        {44.012034,   14.53048,       2, 3,  "HRV X12.XXX"},
        {44.012034,   15.176272,      2, 3,  "HRV Y12.XXX"},
        {44.012034,   15.822064,      2, 3,  "HRV Z12.XXX"},
        {43.600194,   16.467856,      2, 5,  "HRV 01.XXXX"},
        {43.109154,   15.8592745,     3, 4,  "HRV 11.XXXX"},
        {43.109154,   16.4998585,     2, 3,  "HRV 21.XXXX"},
        {43.109154,   17.1404425,     2, 3,  "HRV 31.XXXX"},
        {42.667218,   15.730871,      2, 5,  "HRV 41.XXXX"},
        {42.618114,   16.366247,      3, 4,  "HRV 51.XXXX"},
        {42.618114,   17.001623,      2, 3,  "HRV 61.XXXX"},
        {42.618114,   17.636999,      2, 5,  "HRV 71.XXXX"},
        {42.408275,   18.2021865,     2, 3,  "HRV 81.XXXX"},
        {42.408275,   15.9965975,     2, 3,  "HRV 91.XXXX"},
        {45.0003255,  18.6933115,     2, 5,  "HRV Z1.XXXX"},
        {45.0775,     18.8,           3, 6,  "HRV CJH5.N9Q"},
        {6.183978,    1.19877125,     4, 7,  "TGO 00.XX"},
        {6.159858,    1.24429125,     4, 5,  "TGO J0.XX"},
        {6.2699755,   1.045777,       3, 4,  "TGO 12.XXX"},
        {8.970515,    1.0882125,      3, 4,  "TGO 000.XX"},
        {6.880515,    0.568382375,    3, 6,  "TGO 200.XX"},
        {7.510607,    1.048308375,    3, 4,  "TGO 400.XX"},
        {9.530515,    1.128042625,    3, 5,  "TGO 600.XX"},
        {10.849514,   0.12587175,     3, 7,  "TGO 800.XX"},
        {9.300725,    0.7488695,      3, 4,  "TGO B00.XX"},
        {6.990725,    1.128982375,    3, 4,  "TGO C00.XX"},
        {9.060725,    1.3688695,      3, 4,  "TGO D00.XX"},
        {10.390724,   0.40864275,     3, 7,  "TGO F00.XX"},
        {7.630725,    0.558982375,    3, 6,  "TGO G00.XX"},
        {9.810725,    1.068756625,    3, 5,  "TGO H00.XX"},
        {9.380725,    1.1988695,      3, 5,  "TGO J00.XX"},
        {8.600725,    0.9388695,      3, 4,  "TGO K00.XX"},
        {8.360725,    0.948982375,    3, 4,  "TGO L00.XX"},
        {10.670724,   0.48864275,     3, 7,  "TGO M00.XX"},
        {7.800725,    1.158982375,    3, 4,  "TGO N00.XX"},
        {6.673026,    1.35451825,     3, 4,  "TGO P00.XX"},
        {8.110725,    1.218982375,    3, 4,  "TGO Q00.XX"},
        {6.660556,    1.48314525,     3, 4,  "TGO R00.XX"},
        {7.498147,    0.875572375,    3, 4,  "TGO S00.XX"},
        {9.730725,    0.568756625,    3, 7,  "TGO T00.XX"},
        {9.496728,    0.7710845,      3, 5,  "TGO V00.XX"},
        {9.706045,    1.269561625,    3, 7,  "TGO W00.XX"},
        {9.988336,    0.998576625,    3, 5,  "TGO X00.XX"},
        {6.710725,    1.12909525,     3, 4,  "TGO Y00.XX"},
        {9.790725,    1.278756625,    3, 7,  "TGO Z00.XX"},
        {10.60701,    -0.149335,      2, 6,  "TGO 012.XXX"},
        {10.60701,    0.212413,       2, 6,  "TGO 112.XXX"},
        {10.971835,   0.5895675,      2, 5,  "TGO 212.XXX"},
        {10.480795,   0.1156395,      2, 6,  "TGO 312.XXX"},
        {10.480795,   0.5895675,      2, 4,  "TGO 412.XXX"},
        {10.480795,   1.0634955,      2, 6,  "TGO 512.XXX"},
        {9.989755,    0.2341205,      2, 6,  "TGO 612.XXX"},
        {9.989755,    0.7080485,      2, 4,  "TGO 712.XXX"},
        {9.989755,    1.1819765,      2, 4,  "TGO 812.XXX"},
        {9.498715,    0.2341205,      2, 6,  "TGO 912.XXX"},
        {9.498715,    0.7080485,      2, 4,  "TGO B12.XXX"},
        {9.498715,    1.1819765,      3, 5,  "TGO C12.XXX"},
        {9.007675,    0.3762995,      2, 5,  "TGO D12.XXX"},
        {9.007675,    0.8502275,      2, 3,  "TGO F12.XXX"},
        {9.007675,    1.3241555,      2, 3,  "TGO G12.XXX"},
        {8.516635,    0.376013,       2, 5,  "TGO H12.XXX"},
        {8.516635,    0.844733,       2, 3,  "TGO J12.XXX"},
        {8.516635,    1.313453,       2, 3,  "TGO K12.XXX"},
        {8.025595,    0.376013,       2, 5,  "TGO L12.XXX"},
        {8.025595,    0.844733,       2, 3,  "TGO M12.XXX"},
        {8.025595,    1.313453,       2, 3,  "TGO N12.XXX"},
        {7.534555,    0.376013,       2, 5,  "TGO P12.XXX"},
        {7.534555,    0.844733,       2, 3,  "TGO Q12.XXX"},
        {7.534555,    1.313453,       2, 3,  "TGO R12.XXX"},
        {7.043515,    0.376013,       2, 5,  "TGO S12.XXX"},
        {7.043515,    0.844733,       2, 3,  "TGO T12.XXX"},
        {7.043515,    1.313453,       2, 3,  "TGO V12.XXX"},
        {6.552475,    0.610373,       2, 5,  "TGO W12.XXX"},
        {6.552475,    1.079093,       2, 3,  "TGO X12.XXX"},
        {6.552475,    1.547813,       2, 5,  "TGO Y12.XXX"},
        {8.6234,      0.8315,         2, 3,  "TGO V9X5.T6M"},
        {56.9747,     24.0687575,     4, 6,  "LVA 12.XX"},
        {57.052355,   23.6409465,     3, 5,  "LVA 12.XXX"},
        {55.920724,   26.468319625,   3, 8,  "LVA 000.XX"},
        {56.556824,   20.989215625,   3, 5,  "LVA 100.XX"},
        {56.556824,   21.144175625,   3, 5,  "LVA 200.XX"},
        {57.434724,   21.508868,      3, 5,  "LVA 300.XX"},
        {56.550724,   27.247115625,   3, 5,  "LVA 400.XX"},
        {56.547324,   25.797315625,   3, 4,  "LVA 500.XX"},
        {57.569724,   25.338268,      3, 4,  "LVA 600.XX"},
        {56.844124,   24.53019875,    3, 4,  "LVA 700.XX"},
        {57.010524,   23.08349875,    3, 5,  "LVA 800.XX"},
        {57.358424,   25.217768,      3, 4,  "LVA 900.XX"},
        {57.020724,   21.87609875,    3, 5,  "LVA B00.XX"},
        {56.713024,   22.43409875,    3, 5,  "LVA C00.XX"},
        {57.290724,   22.514968,      3, 5,  "LVA D00.XX"},
        {56.450724,   24.107115625,   3, 7,  "LVA F00.XX"},
        {55.948024,   27.074119625,   3, 7,  "LVA G00.XX"},
        {57.194824,   24.77219875,    3, 4,  "LVA H00.XX"},
        {56.671024,   23.209215625,   3, 5,  "LVA J00.XX"},
        {56.592124,   27.619515625,   3, 6,  "LVA K00.XX"},
        {56.401924,   26.103915625,   3, 4,  "LVA L00.XX"},
        {57.209424,   26.66929875,    3, 4,  "LVA M00.XX"},
        {56.889824,   26.14709875,    3, 4,  "LVA N00.XX"},
        {57.548224,   24.633868,      3, 4,  "LVA P00.XX"},
        {56.354624,   26.684115625,   3, 4,  "LVA Q00.XX"},
        {56.636924,   25.158515625,   3, 4,  "LVA R00.XX"},
        {57.181124,   27.17669875,    3, 5,  "LVA S00.XX"},
        {57.473024,   25.831668,      3, 4,  "LVA T00.XX"},
        {57.819224,   25.955251125,   3, 7,  "LVA V00.XX"},
        {56.780624,   24.69879875,    3, 4,  "LVA W00.XX"},
        {56.764924,   21.52599875,    3, 5,  "LVA X00.XX"},
        {57.921524,   25.312651125,   3, 6,  "LVA Y00.XX"},
        {57.150724,   24.45609875,    3, 4,  "LVA Z00.XX"},
        {56.055025,   20.900025,      2, 4,  "LVA 02W.S12"},
        {56.244025,   21.620025,      2, 6,  "LVA 2MG.S0P"},
        {56.244025,   23.255025,      2, 6,  "LVA 8P7.60W"},
        {56.133025,   24.323025,      2, 6,  "LVA C90.010"},
        {57.635025,   25.670025,      2, 3,  "LVA L0L.S0Y"},
        {56.885025,   25.670025,      2, 3,  "LVA LGD.S0L"},
        {55.650025,   25.670025,      2, 7,  "LVA QJS.S12"},
        {56.875,      24.5825,        2, 3,  "LVA K8CF.JFQ"},
        {54.7241,     25.2017775,     4, 7,  "LTU 12.XX"},
        {54.889115,   24.9220265,     3, 5,  "LTU 12.XXX"},
        {54.892714,   23.8468555,     3, 5,  "LTU 000.XX"},
        {55.767545,   21.067688125,   3, 5,  "LTU 200.XX"},
        {55.910514,   23.211869625,   3, 6,  "LTU 400.XX"},
        {55.720814,   24.257569625,   3, 5,  "LTU 600.XX"},
        {54.390314,   23.9336135,     3, 6,  "LTU 800.XX"},
        {54.540314,   23.2589135,     3, 6,  "LTU B00.XX"},
        {56.286114,   22.249111625,   3, 7,  "LTU D00.XX"},
        {55.032014,   24.2080555,     3, 5,  "LTU G00.XX"},
        {55.280214,   23.9088975,     3, 5,  "LTU J00.XX"},
        {55.480514,   25.4933975,     3, 6,  "LTU L00.XX"},
        {55.970514,   22.121869625,   3, 5,  "LTU N00.XX"},
        {55.240514,   24.6533975,     3, 5,  "LTU Q00.XX"},
        {55.230514,   22.1733975,     3, 7,  "LTU S00.XX"},
        {55.608545,   26.4102165,     3, 6,  "LTU V00.XX"},
        {55.950724,   21.778019625,   3, 5,  "LTU W00.XX"},
        {55.390724,   21.3990365,     3, 5,  "LTU X00.XX"},
        {55.939324,   21.135019625,   3, 5,  "LTU Y00.XX"},
        {55.846424,   23.475719625,   3, 6,  "LTU Z00.XX"},
        {55.015025,   20.950025,      2, 6,  "LTU 02W.L12"},
        {53.893025,   22.583025,      2, 4,  "LTU 656.D0Y"},
        {54.920025,   25.880025,      2, 5,  "LTU WZK.L0Y"},
        {55.1725,     23.2095,        2, 4,  "LTU HF39.DW3"},
        {6.88946,     79.843297,      4, 5,  "LKA 12.XX"},
        {6.8743755,   79.827265,      3, 4,  "LKA 12.XXX"},
        {6.892424,    80.04279425,    4, 5,  "LKA 000.XX"},
        {9.729524,    79.986955625,   3, 4,  "LKA 100.XX"},
        {7.330724,    80.588981375,   3, 4,  "LKA 200.XX"},
        {9.719624,    80.119155625,   3, 4,  "LKA 300.XX"},
        {7.470124,    81.772881375,   3, 4,  "LKA 400.XX"},
        {6.106224,    80.17199425,    3, 4,  "LKA 500.XX"},
        {8.629024,    81.1624685,     3, 4,  "LKA 600.XX"},
        {7.777424,    81.651081375,   3, 4,  "LKA 700.XX"},
        {9.825924,    80.098755625,   3, 4,  "LKA 800.XX"},
        {9.834573,    80.186445625,   3, 4,  "LKA 900.XX"},
        {7.890724,    80.608981375,   3, 4,  "LKA B00.XX"},
        {8.360724,    80.368981375,   3, 4,  "LKA C00.XX"},
        {8.800724,    80.4488685,     3, 4,  "LKA D00.XX"},
        {6.740724,    80.33909425,    3, 4,  "LKA F00.XX"},
        {5.962045,    80.48992625,    3, 4,  "LKA G00.XX"},
        {9.049724,    79.8436685,     3, 8,  "LKA H00.XX"},
        {7.030724,    81.008981375,   3, 4,  "LKA J00.XX"},
        {8.080724,    79.792981375,   3, 8,  "LKA K00.XX"},
        {7.510724,    80.578981375,   3, 4,  "LKA L00.XX"},
        {7.692924,    81.700281375,   3, 4,  "LKA M00.XX"},
        {7.537524,    80.325881375,   3, 4,  "LKA N00.XX"},
        {6.998624,    80.729681375,   3, 4,  "LKA P00.XX"},
        {7.210724,    80.528981375,   3, 4,  "LKA Q00.XX"},
        {7.600134,    79.786226875,   3, 4,  "LKA R00.XX"},
        {7.838724,    81.548481375,   3, 4,  "LKA S00.XX"},
        {6.018724,    80.40419425,    3, 4,  "LKA T00.XX"},
        {6.936164,    80.041728125,   4, 5,  "LKA V00.XX"},
        {6.241304,    80.03540025,    3, 4,  "LKA VK0.00"},
        {9.385664,    80.3573415,     3, 4,  "LKA W00.XX"},
        {7.295104,    81.661628375,   3, 4,  "LKA WK0.00"},
        {7.262464,    80.318828125,   3, 4,  "LKA X00.XX"},
        {6.884104,    80.573728375,   3, 4,  "LKA XK0.00"},
        {7.062464,    80.498828125,   3, 4,  "LKA Y00.XX"},
        {7.935904,    80.994628375,   3, 4,  "LKA YK0.00"},
        {6.662464,    80.67891375,    3, 4,  "LKA Z00.XX"},
        {6.137004,    81.09400025,    3, 4,  "LKA ZK0.00"},
        {8.957025,    79.500025,      2, 7,  "LKA 00B.S0P"},
        {9.365427,    79.502932,      2, 7,  "LKA 0BD.S11"},
        {9.466358,    79.634768,      2, 7,  "LKA 0C0.S17"},
        {9.140025,    79.750025,      2, 7,  "LKA 11F.L0L"},
        {8.555025,    79.875025,      2, 7,  "LKA 4HL.S0W"},
        {8.050025,    79.688025,      2, 7,  "LKA 83M.S0L"},
        {6.660025,    79.688025,      2, 3,  "LKA D37.L0Z"},
        {6.360025,    79.922025,      2, 3,  "LKA T9M.S0Y"},
        {5.900025,    80.000025,      2, 3,  "LKA WRZ.L0N"},
        {6.921716,    79.8703375,     4, 5,  "LKA 5Q9J.4RV"},
        {41.767508,   44.72148,       4, 7,  "GEO 12.XX"},
        {41.435555,   44.6021015,     3, 6,  "GEO 12.XXX"},
        {42.273145,   42.6020725,     3, 5,  "GEO 000.XX"},
        {42.549324,   41.7820085,     3, 5,  "GEO 100.XX"},
        {42.020724,   44.05576,       3, 6,  "GEO 200.XX"},
        {43.042645,   40.953384,      3, 5,  "GEO 300.XX"},
        {43.348924,   40.2231045,     3, 5,  "GEO 400.XX"},
        {42.880724,   41.614856,      3, 5,  "GEO 500.XX"},
        {42.764424,   41.428756,      3, 5,  "GEO 600.XX"},
        {41.666124,   41.59176,       3, 6,  "GEO 700.XX"},
        {41.860624,   41.75756,       3, 6,  "GEO 800.XX"},
        {42.192124,   41.6480085,     3, 5,  "GEO 900.XX"},
        {42.269924,   43.8863085,     3, 5,  "GEO B00.XX"},
        {42.052224,   43.5196085,     3, 6,  "GEO C00.XX"},
        {42.310724,   42.0053085,     3, 5,  "GEO D00.XX"},
        {42.210724,   42.2953085,     3, 5,  "GEO F00.XX"},
        {42.150724,   42.9553085,     3, 5,  "GEO G00.XX"},
        {41.982424,   45.41266,       3, 6,  "GEO H00.XX"},
        {41.970724,   41.93576,       3, 6,  "GEO J00.XX"},
        {41.680724,   42.92576,       3, 6,  "GEO K00.XX"},
        {42.370724,   42.5453085,     3, 5,  "GEO L00.XX"},
        {41.970724,   44.35576,       3, 6,  "GEO M00.XX"},
        {42.389824,   42.9319085,     3, 5,  "GEO N00.XX"},
        {42.330724,   43.2153085,     3, 5,  "GEO P00.XX"},
        {41.893524,   43.34496,       3, 6,  "GEO Q00.XX"},
        {42.670724,   41.674856,      3, 5,  "GEO R00.XX"},
        {43.169724,   40.5475045,     3, 5,  "GEO S00.XX"},
        {41.748545,   45.2291,        3, 6,  "GEO T00.XX"},
        {42.359624,   42.3885085,     3, 5,  "GEO V00.XX"},
        {42.830724,   42.674856,      3, 5,  "GEO W00.XX"},
        {41.790724,   45.74576,       3, 8,  "GEO X00.XX"},
        {42.983424,   41.056656,      4, 6,  "GEO Y00.XX"},
        {41.486724,   44.4777125,     3, 6,  "GEO Z00.XX"},
        {43.065025,   40.006025,      2, 4,  "GEO 011.S10"},
        {42.688025,   40.870025,      2, 4,  "GEO 1HB.S08"},
        {41.427025,   41.470025,      2, 5,  "GEO 3CC.D0T"},
        {42.770025,   42.985025,      2, 4,  "GEO DFR.S0G"},
        {41.100025,   42.985025,      2, 5,  "GEO FFM.D07"},
        {41.353025,   45.330025,      2, 7,  "GEO VF4.L0M"},
        {41.225025,   45.700025,      2, 10, "GEO X7T.S14"},
        {41.100025,   45.800025,      2, 7,  "GEO XCC.D01"},
        {41.053025,   46.440025,      2, 7,  "GEO ZK9.S0M"},
        {43.4105125,  40.249181,      2, 7,  "GEO 1234.XXX"},
        {53.382524,   -6.3337485,     4, 6,  "IRL 12.XX"},
        {53.509143,   -6.7937565,     3, 5,  "IRL 12.XXX"},
        {51.917545,   -8.542639375,   3, 5,  "IRL 000.XX"},
        {52.697724,   -8.68086925,    3, 4,  "IRL 100.XX"},
        {53.306545,   -9.13032625,    3, 4,  "IRL 200.XX"},
        {52.290824,   -7.183578125,   3, 5,  "IRL 300.XX"},
        {54.039124,   -6.458264375,   3, 5,  "IRL 400.XX"},
        {53.760724,   -6.428364375,   3, 5,  "IRL 500.XX"},
        {52.311124,   -9.768878125,   3, 4,  "IRL 600.XX"},
        {52.693224,   -7.31536925,    3, 5,  "IRL 700.XX"},
        {52.884824,   -9.04916925,    3, 4,  "IRL 800.XX"},
        {54.310724,   -8.5442555,     3, 5,  "IRL 900.XX"},
        {53.460724,   -8.01757325,    3, 5,  "IRL B00.XX"},
        {52.380724,   -6.545878125,   3, 5,  "IRL C00.XX"},
        {52.400724,   -7.775878125,   3, 5,  "IRL D00.XX"},
        {52.880724,   -6.98666925,    3, 5,  "IRL F00.XX"},
        {53.692424,   -6.746164375,   3, 5,  "IRL G00.XX"},
        {53.570724,   -7.408364375,   3, 5,  "IRL H00.XX"},
        {54.990624,   -7.8315595,     3, 5,  "IRL J00.XX"},
        {53.116524,   -9.63257325,    3, 4,  "IRL K00.XX"},
        {53.320724,   -7.55757325,    3, 5,  "IRL L00.XX"},
        {53.080724,   -7.36757325,    3, 5,  "IRL M00.XX"},
        {52.841124,   -6.25476925,    3, 5,  "IRL N00.XX"},
        {54.160724,   -9.2291555,     3, 4,  "IRL P00.XX"},
        {51.876926,   -8.405818875,   4, 6,  "IRL Q00.XX"},
        {53.622464,   -6.253154125,   3, 5,  "IRL R00.XX"},
        {53.854104,   -9.343786375,   3, 4,  "IRL RK0.00"},
        {52.712464,   -8.97066575,    3, 4,  "IRL S00.XX"},
        {52.494104,   -6.61270125,    3, 5,  "IRL SK0.00"},
        {52.676594,   -6.31863125,    3, 5,  "IRL T00.XX"},
        {52.134104,   -8.702194125,   3, 4,  "IRL TK0.00"},
        {53.002464,   -6.10135275,    3, 5,  "IRL V00.XX"},
        {52.084104,   -7.672194125,   3, 5,  "IRL VK0.00"},
        {53.576564,   -6.169854125,   3, 5,  "IRL W00.XX"},
        {53.664004,   -6.307286375,   3, 5,  "IRL WK0.00"},
        {52.691064,   -7.86906575,    3, 5,  "IRL X00.XX"},
        {53.719204,   -7.841586375,   3, 5,  "IRL XK0.00"},
        {52.173964,   -7.204764375,   3, 5,  "IRL Y00.XX"},
        {52.385404,   -6.981694125,   3, 5,  "IRL YK0.00"},
        {53.007164,   -7.02945275,    3, 5,  "IRL Z00.XX"},
        {51.914104,   -8.211759875,   3, 5,  "IRL ZK0.00"},
        {53.6475185,  -10.458425,     2, 3,  "IRL 123.XXX"},
        {54.609323,   -10.1586395,    2, 3,  "IRL 12.XXXX"},
        {53.43,       -8.045,         2, 4,  "IRL 6MJM.XL4"},
        {8.455103,    -13.2937275,    4, 6,  "SLE 12.XX"},
        {8.665563,    -13.275148,     3, 5,  "SLE 12.XXX"},
        {8.626414,    -11.0322885,    4, 7,  "SLE 000.XX"},
        {8.860514,    -12.1117885,    3, 5,  "SLE 200.XX"},
        {7.932214,    -11.801618625,  3, 5,  "SLE 400.XX"},
        {7.860514,    -11.251618625,  3, 5,  "SLE 600.XX"},
        {8.427614,    -10.396118625,  3, 8,  "SLE 800.XX"},
        {8.575314,    -11.1509885,    3, 5,  "SLE B00.XX"},
        {8.666114,    -12.5885885,    3, 5,  "SLE D00.XX"},
        {8.180514,    -12.121618625,  3, 5,  "SLE G00.XX"},
        {8.810724,    -12.8236315,    3, 5,  "SLE J00.XX"},
        {8.760724,    -11.9719315,    3, 5,  "SLE K00.XX"},
        {9.004924,    -12.0052315,    3, 5,  "SLE L00.XX"},
        {7.562124,    -12.533618625,  3, 5,  "SLE M00.XX"},
        {8.452124,    -11.902818625,  3, 5,  "SLE N00.XX"},
        {7.640724,    -12.221018625,  3, 5,  "SLE P00.XX"},
        {8.320724,    -10.621018625,  3, 6,  "SLE Q00.XX"},
        {9.620724,    -11.591244375,  3, 5,  "SLE R00.XX"},
        {8.210724,    -12.481018625,  3, 5,  "SLE S00.XX"},
        {8.060724,    -10.971018625,  3, 8,  "SLE T00.XX"},
        {9.160724,    -12.9611315,    3, 6,  "SLE V00.XX"},
        {8.960724,    -13.0811315,    3, 5,  "SLE W00.XX"},
        {8.210724,    -10.791018625,  3, 6,  "SLE X00.XX"},
        {8.140724,    -10.751018625,  4, 7,  "SLE Y00.XX"},
        {7.890724,    -11.511018625,  3, 5,  "SLE Z00.XX"},
        {9.954595,    -12.6662175,    2, 5,  "SLE 012.XXX"},
        {9.954595,    -12.1922895,    2, 5,  "SLE 112.XXX"},
        {9.954595,    -11.7183615,    2, 5,  "SLE 212.XXX"},
        {9.954595,    -11.2444335,    2, 5,  "SLE 312.XXX"},
        {9.463555,    -13.2823245,    2, 5,  "SLE 412.XXX"},
        {9.463555,    -12.8083965,    2, 5,  "SLE 512.XXX"},
        {9.463555,    -12.3344685,    2, 5,  "SLE 612.XXX"},
        {9.463555,    -11.8605405,    2, 4,  "SLE 712.XXX"},
        {9.463555,    -11.3866125,    2, 4,  "SLE 812.XXX"},
        {9.463555,    -10.9126845,    2, 5,  "SLE 912.XXX"},
        {8.972515,    -13.2823235,    2, 4,  "SLE B12.XXX"},
        {8.972515,    -12.8083955,    2, 4,  "SLE C12.XXX"},
        {8.972515,    -12.3344675,    2, 4,  "SLE D12.XXX"},
        {8.972515,    -11.8605395,    2, 4,  "SLE F12.XXX"},
        {8.972515,    -11.3866115,    2, 4,  "SLE G12.XXX"},
        {8.972515,    -10.9126835,    2, 5,  "SLE H12.XXX"},
        {8.481475,    -13.519575,     2, 4,  "SLE J12.XXX"},
        {8.481475,    -13.050855,     3, 5,  "SLE K12.XXX"},
        {8.481475,    -12.582135,     2, 4,  "SLE L12.XXX"},
        {8.481475,    -12.113415,     2, 4,  "SLE M12.XXX"},
        {8.481475,    -11.644695,     2, 4,  "SLE N12.XXX"},
        {8.481475,    -11.175975,     2, 4,  "SLE P12.XXX"},
        {8.481475,    -10.707255,     2, 5,  "SLE Q12.XXX"},
        {7.8700935,   -13.0550895,    2, 4,  "SLE R12.XXX"},
        {7.515118,    -13.0562425,    2, 4,  "SLE X12.XXX"},
        {7.990435,    -12.455581,     2, 4,  "SLE S12.XXX"},
        {7.990435,    -11.986861,     2, 4,  "SLE T12.XXX"},
        {7.990435,    -11.518141,     2, 4,  "SLE V12.XXX"},
        {7.990435,    -11.049421,     2, 7,  "SLE W12.XXX"},
        {7.499395,    -12.45558,      3, 5,  "SLE Y12.XXX"},
        {7.499395,    -11.98686,      2, 4,  "SLE Z12.XXX"},
        {7.087555,    -11.51814,      2, 3,  "SLE 11.XXXX"},
        {7.087555,    -11.049421,     2, 5,  "SLE 21.XXXX"},
        {6.9282845,   -11.7303055,    2, 3,  "SLE 31.XXXX"},
        {8.456749,    -11.98876,      2, 4,  "SLE 78YY.8MZ"},
        {9.015792,    -79.5577175,    4, 5,  "PAN 00.XX"},
        {8.989629,    -79.5105805,    4, 5,  "PAN J0.XX"},
        {8.991305,    -79.8292695,    3, 4,  "PAN 12.XXX"},
        {8.400214,    -82.489818625,  3, 4,  "PAN 000.XX"},
        {9.390524,    -79.9142315,    3, 4,  "PAN 200.XX"},
        {9.390524,    -79.8267815,    3, 4,  "PAN 300.XX"},
        {8.147424,    -81.026718625,  3, 4,  "PAN 400.XX"},
        {9.479524,    -82.5548315,    3, 6,  "PAN 500.XX"},
        {8.050724,    -81.361018625,  3, 4,  "PAN 600.XX"},
        {8.321424,    -82.892918625,  3, 6,  "PAN 700.XX"},
        {8.547024,    -82.6441315,    3, 4,  "PAN 800.XX"},
        {8.860524,    -82.9123315,    3, 6,  "PAN 900.XX"},
        {8.550724,    -80.4011315,    3, 4,  "PAN B00.XX"},
        {9.210724,    -79.1411315,    3, 4,  "PAN C00.XX"},
        {9.441224,    -78.6050315,    3, 6,  "PAN D00.XX"},
        {8.453224,    -80.316018625,  3, 4,  "PAN F00.XX"},
        {7.980724,    -80.821018625,  3, 4,  "PAN G00.XX"},
        {7.796024,    -80.307618625,  4, 5,  "PAN H00.XX"},
        {9.591924,    -79.685844375,  3, 4,  "PAN J00.XX"},
        {8.286124,    -80.579918625,  3, 4,  "PAN K00.XX"},
        {7.999324,    -80.478518625,  3, 4,  "PAN L00.XX"},
        {8.600724,    -82.4611315,    3, 4,  "PAN M00.XX"},
        {8.370624,    -80.585818625,  3, 4,  "PAN N00.XX"},
        {8.349524,    -81.238718625,  3, 4,  "PAN P00.XX"},
        {8.788024,    -79.9198315,    3, 4,  "PAN Q00.XX"},
        {8.030724,    -81.081018625,  3, 4,  "PAN R00.XX"},
        {8.091024,    -80.945618625,  4, 5,  "PAN S00.XX"},
        {7.878324,    -80.320418625,  3, 4,  "PAN T00.XX"},
        {8.276424,    -81.886818625,  3, 4,  "PAN V00.XX"},
        {8.816024,    -82.4702315,    3, 4,  "PAN W00.XX"},
        {8.541824,    -79.9563315,    3, 4,  "PAN X00.XX"},
        {8.620724,    -79.9111315,    3, 4,  "PAN Y00.XX"},
        {8.835824,    -79.5780315,    4, 5,  "PAN Z00.XX"},
        {9.575491,    -83.0253245,    2, 5,  "PAN 012.XXX"},
        {9.084451,    -83.0253245,    2, 5,  "PAN 112.XXX"},
        {8.593411,    -83.025611,     2, 5,  "PAN 212.XXX"},
        {8.102371,    -83.025611,     2, 5,  "PAN 312.XXX"},
        {9.57549,     -82.5566045,    2, 5,  "PAN 412.XXX"},
        {9.08445,     -82.5566045,    2, 3,  "PAN 512.XXX"},
        {8.59341,     -82.556891,     2, 3,  "PAN 612.XXX"},
        {8.10237,     -82.556891,     2, 3,  "PAN 712.XXX"},
        {9.280866,    -82.0878845,    2, 3,  "PAN 812.XXX"},
        {8.789826,    -82.088171,     2, 3,  "PAN 912.XXX"},
        {8.298786,    -82.088171,     2, 3,  "PAN B12.XXX"},
        {7.635882,    -81.947555,     2, 3,  "PAN C12.XXX"},
        {8.888034,    -81.6191645,    2, 3,  "PAN D12.XXX"},
        {8.396994,    -81.619451,     2, 3,  "PAN F12.XXX"},
        {7.905954,    -81.619451,     2, 3,  "PAN G12.XXX"},
        {9.109002,    -81.1504445,    2, 3,  "PAN H12.XXX"},
        {8.617962,    -81.150731,     2, 3,  "PAN J12.XXX"},
        {8.126922,    -81.150731,     2, 3,  "PAN K12.XXX"},
        {7.635882,    -81.150731,     2, 3,  "PAN L12.XXX"},
        {9.123734,    -80.6817245,    2, 3,  "PAN M12.XXX"},
        {8.632694,    -80.682011,     2, 3,  "PAN N12.XXX"},
        {8.141654,    -80.682011,     2, 3,  "PAN P12.XXX"},
        {7.650614,    -80.682011,     2, 3,  "PAN Q12.XXX"},
        {9.418358,    -80.2130045,    2, 3,  "PAN R12.XXX"},
        {8.927318,    -80.2130045,    2, 3,  "PAN S12.XXX"},
        {8.436278,    -80.213291,     2, 3,  "PAN T12.XXX"},
        {7.797926,    -80.213291,     2, 3,  "PAN V12.XXX"},
        {9.614774,    -79.7442845,    2, 3,  "PAN W12.XXX"},
        {9.123734,    -79.7442845,    3, 4,  "PAN X12.XXX"},
        {8.632694,    -79.744571,     2, 3,  "PAN Y12.XXX"},
        {9.614774,    -79.2755645,    2, 3,  "PAN Z12.XXX"},
        {8.711894,    -79.2755645,    2, 3,  "PAN 01.XXXX"},
        {8.220854,    -79.181065,     2, 3,  "PAN 11.XXXX"},
        {9.202934,    -78.8058025,    2, 5,  "PAN 21.XXXX"},
        {8.711894,    -78.8058025,    2, 5,  "PAN 31.XXXX"},
        {8.220854,    -78.806089,     3, 6,  "PAN 41.XXXX"},
        {7.729814,    -78.806089,     2, 5,  "PAN 51.XXXX"},
        {9.202934,    -78.3370825,    2, 5,  "PAN 61.XXXX"},
        {8.711894,    -78.3370825,    2, 5,  "PAN 71.XXXX"},
        {8.220854,    -78.337369,     2, 5,  "PAN 81.XXXX"},
        {7.729814,    -78.337369,     2, 5,  "PAN 91.XXXX"},
        {7.238774,    -78.337369,     2, 5,  "PAN B1.XXXX"},
        {8.711894,    -77.8683625,    2, 5,  "PAN C1.XXXX"},
        {8.220854,    -77.868649,     2, 5,  "PAN D1.XXXX"},
        {7.729814,    -77.868649,     2, 5,  "PAN F1.XXXX"},
        {7.238774,    -77.868649,     2, 5,  "PAN G1.XXXX"},
        {8.220854,    -77.582935,     3, 6,  "PAN H1.XXXX"},
        {7.729814,    -77.582935,     3, 6,  "PAN J1.XXXX"},
        {7.37612,     -82.330877,     2, 3,  "PAN X123.XX"},
        {7.717075,    -81.854345,     2, 3,  "PAN Y123.XX"},
        {9.001393,    -81.635992,     2, 3,  "PAN Z123.XX"},
        {8.43,        -80.097,        2, 3,  "PAN SYTW.GJ7"},
        {50.1151,     14.3719615,     4, 7,  "CZE 12.XX"},
        {50.006345,   14.22090675,    3, 6,  "CZE 00.XXX"},
        {49.295084,   16.40395375,    3, 5,  "CZE C0.XXX"},
        {49.875868,   18.14973,       3, 6,  "CZE P0.XXX"},
        {49.782124,   13.307624,      3, 5,  "CZE 000.XX"},
        {49.642124,   17.187624,      3, 5,  "CZE 100.XX"},
        {50.803424,   14.9962685,     3, 6,  "CZE 200.XX"},
        {49.020724,   14.41140225,    3, 6,  "CZE 300.XX"},
        {50.260724,   15.77034675,    3, 5,  "CZE 400.XX"},
        {50.710724,   13.9562685,     3, 5,  "CZE 500.XX"},
        {50.070724,   15.70694675,    3, 5,  "CZE 600.XX"},
        {49.253424,   17.58830225,    3, 5,  "CZE 700.XX"},
        {50.190724,   14.04034675,    3, 5,  "CZE 800.XX"},
        {50.550724,   13.6069685,     3, 5,  "CZE 900.XX"},
        {49.980724,   17.82694675,    3, 6,  "CZE B00.XX"},
        {50.280724,   12.78014675,    3, 5,  "CZE C00.XX"},
        {50.812124,   14.1262685,     3, 6,  "CZE D00.XX"},
        {50.690724,   13.7562685,     3, 5,  "CZE F00.XX"},
        {50.509324,   13.3330685,     3, 5,  "CZE G00.XX"},
        {49.440724,   15.517624,      3, 5,  "CZE H00.XX"},
        {49.495724,   17.390824,      3, 5,  "CZE J00.XX"},
        {49.520724,   17.057624,      3, 5,  "CZE K00.XX"},
        {50.460724,   14.8362685,     3, 6,  "CZE L00.XX"},
        {50.731864,   15.1344665,     3, 5,  "CZE M00.XX"},
        {50.684104,   14.4891805,     3, 6,  "CZE MK0.00"},
        {49.232464,   15.82311275,    3, 5,  "CZE N00.XX"},
        {49.684104,   18.620049,      3, 6,  "CZE NK0.00"},
        {49.407364,   14.627597,      3, 6,  "CZE P00.XX"},
        {49.681704,   13.965549,      3, 5,  "CZE PK0.00"},
        {48.872464,   16.01311275,    3, 6,  "CZE Q00.XX"},
        {50.070204,   12.32641475,    3, 5,  "CZE QK0.00"},
        {50.585664,   15.8786665,     3, 5,  "CZE R00.XX"},
        {50.024104,   15.14961475,    3, 5,  "CZE RK0.00"},
        {49.321964,   14.10461275,    3, 5,  "CZE S00.XX"},
        {49.965104,   16.94121475,    3, 5,  "CZE SK0.00"},
        {49.315164,   17.34881275,    3, 5,  "CZE T00.XX"},
        {49.350604,   17.946549,      3, 7,  "CZE TK0.00"},
        {49.492464,   17.922597,      3, 7,  "CZE V00.XX"},
        {48.858804,   17.10718325,    3, 6,  "CZE VK0.00"},
        {50.609864,   13.5518665,     3, 5,  "CZE W00.XX"},
        {49.594104,   17.950249,      3, 7,  "CZE WK0.00"},
        {49.068264,   17.41461275,    3, 7,  "CZE X00.XX"},
        {48.751004,   16.8354175,     3, 6,  "CZE XK0.00"},
        {49.762464,   18.572597,      3, 6,  "CZE Y00.XX"},
        {50.084204,   17.65621475,    3, 6,  "CZE YK0.00"},
        {50.202364,   12.59508225,    3, 5,  "CZE Z00.XX"},
        {50.525304,   14.0996805,     3, 5,  "CZE ZK0.00"},
        {51.010401,   13.2294925,     2, 4,  "CZE 112.XXX"},
        {51.010401,   13.9638205,     2, 5,  "CZE 212.XXX"},
        {51.010401,   14.6981485,     2, 6,  "CZE 312.XXX"},
        {50.596212,   15.426932,      2, 4,  "CZE 412.XXX"},
        {50.421153,   12.1352395,     2, 4,  "CZE 512.XXX"},
        {50.519361,   12.8591515,     2, 4,  "CZE 612.XXX"},
        {50.519361,   13.5830635,     2, 4,  "CZE 712.XXX"},
        {50.519361,   14.3069755,     2, 5,  "CZE 812.XXX"},
        {50.519361,   15.0308875,     2, 5,  "CZE 912.XXX"},
        {50.519361,   15.7547995,     2, 4,  "CZE B12.XXX"},
        {50.519361,   16.4787115,     2, 5,  "CZE C12.XXX"},
        {50.519361,   17.2026235,     2, 5,  "CZE D12.XXX"},
        {50.028321,   12.424517,      3, 5,  "CZE F12.XXX"},
        {50.028321,   13.143221,      2, 4,  "CZE G12.XXX"},
        {50.028321,   13.861925,      2, 4,  "CZE H12.XXX"},
        {50.028321,   14.580629,      3, 6,  "CZE J12.XXX"},
        {50.028321,   15.299333,      2, 4,  "CZE K12.XXX"},
        {50.028321,   16.018037,      2, 4,  "CZE L12.XXX"},
        {50.028321,   16.736741,      2, 4,  "CZE M12.XXX"},
        {50.028321,   17.455445,      2, 4,  "CZE N12.XXX"},
        {50.028321,   18.174149,      2, 5,  "CZE P12.XXX"},
        {49.537281,   12.529771,      2, 4,  "CZE Q12.XXX"},
        {49.537281,   13.238059,      2, 4,  "CZE R12.XXX"},
        {49.537281,   13.946347,      2, 4,  "CZE S12.XXX"},
        {49.537281,   14.654635,      2, 5,  "CZE T12.XXX"},
        {49.537281,   15.362923,      2, 4,  "CZE V12.XXX"},
        {49.537281,   16.071211,      2, 4,  "CZE W12.XXX"},
        {49.537281,   16.779499,      2, 4,  "CZE X12.XXX"},
        {49.537281,   17.487787,      2, 4,  "CZE Y12.XXX"},
        {49.537281,   18.196075,      2, 6,  "CZE Z12.XXX"},
        {48.611991,   13.2081505,     2, 4,  "CZE 1123.XX"},
        {48.611991,   13.9112305,     2, 6,  "CZE 2123.XX"},
        {48.611991,   14.6143105,     2, 6,  "CZE 3123.XX"},
        {48.611991,   15.3173905,     2, 5,  "CZE 4123.XX"},
        {48.611991,   16.0204705,     2, 5,  "CZE 5123.XX"},
        {48.611991,   16.7235505,     2, 5,  "CZE 6123.XX"},
        {48.611991,   17.4266305,     2, 5,  "CZE 7123.XX"},
        {48.588261,   14.4139695,     2, 6,  "CZE 8HHH.HH"},
        {50.264336,   12.7435425,     2, 4,  "CZE 1234.XXX"},
        {4.943294,    -52.340519,     4, 6,  "GUF 12.XX"},
        {5.203922,    -52.689301,     4, 6,  "GUF 12.XXX"},
        {5.525244,    -54.08622775,   3, 8,  "GUF 000.XX"},
        {5.275674,    -52.881882875,  3, 5,  "GUF 600.XX"},
        {5.689774,    -53.92955175,   3, 4,  "GUF C00.XX"},
        {5.151674,    -54.401082875,  3, 7,  "GUF J00.XX"},
        {4.266074,    -54.402082875,  3, 8,  "GUF P00.XX"},
        {5.398974,    -53.04715175,   3, 4,  "GUF V00.XX"},
        {5.734595,    -54.212111,     2, 5,  "GUF 112.XXX"},
        {5.734595,    -53.743391,     3, 4,  "GUF 212.XXX"},
        {5.4122225,   -53.2761505,    2, 3,  "GUF 312.XXX"},
        {5.248107,    -54.44647,      2, 6,  "GUF 412.XXX"},
        {5.248107,    -53.97775,      2, 4,  "GUF 512.XXX"},
        {5.248107,    -53.50903,      2, 4,  "GUF 612.XXX"},
        {5.248107,    -53.04031,      2, 4,  "GUF 712.XXX"},
        {5.248107,    -52.57159,      3, 5,  "GUF 812.XXX"},
        {4.757067,    -54.44647,      2, 6,  "GUF 912.XXX"},
        {4.757067,    -53.97775,      2, 4,  "GUF B12.XXX"},
        {4.757067,    -53.50903,      2, 4,  "GUF C12.XXX"},
        {4.757067,    -53.04031,      2, 4,  "GUF D12.XXX"},
        {4.757067,    -52.57159,      2, 4,  "GUF F12.XXX"},
        {4.757067,    -52.10287,      2, 4,  "GUF G12.XXX"},
        {4.266027,    -54.399598,     3, 8,  "GUF H12.XXX"},
        {4.266027,    -53.930878,     2, 5,  "GUF J12.XXX"},
        {4.266027,    -53.462158,     2, 5,  "GUF K12.XXX"},
        {4.266027,    -52.993438,     2, 5,  "GUF L12.XXX"},
        {4.266027,    -52.524718,     2, 6,  "GUF M12.XXX"},
        {4.266027,    -52.055998,     2, 6,  "GUF N12.XXX"},
        {3.774987,    -54.165238,     2, 7,  "GUF P12.XXX"},
        {3.774987,    -53.696518,     2, 5,  "GUF Q12.XXX"},
        {3.774987,    -53.227798,     2, 5,  "GUF R12.XXX"},
        {3.774987,    -52.759078,     2, 5,  "GUF S12.XXX"},
        {3.774987,    -52.290358,     2, 6,  "GUF T12.XXX"},
        {3.283947,    -54.188674,     2, 7,  "GUF V12.XXX"},
        {3.283947,    -53.719954,     2, 5,  "GUF W12.XXX"},
        {3.283947,    -53.251234,     2, 5,  "GUF X12.XXX"},
        {3.283947,    -52.782514,     2, 5,  "GUF Y12.XXX"},
        {3.283947,    -52.595026,     3, 6,  "GUF Z12.XXX"},
        {2.481417,    -54.563434,     3, 11, "GUF 0123.XX"},
        {2.481417,    -54.094714,     3, 9,  "GUF 1123.XX"},
        {2.481417,    -53.625994,     3, 9,  "GUF 2123.XX"},
        {2.481417,    -53.157274,     3, 9,  "GUF 3123.XX"},
        {2.481417,    -52.876042,     5, 11, "GUF 4123.XX"},
        {2.111385,    -54.563434,     2, 10, "GUF 5123.XX"},
        {2.111385,    -54.094714,     2, 8,  "GUF 6123.XX"},
        {2.111385,    -53.625994,     2, 8,  "GUF 7123.XX"},
        {2.111385,    -53.157274,     2, 8,  "GUF 8123.XX"},
        {2.111385,    -52.969786,     3, 9,  "GUF 9123.XX"},
        {5.3278325,   -52.657549,     2, 3,  "GUF B123.XX"},
        {4.813857,    -52.12609,      2, 4,  "GUF C123.XX"},
        {4.908194,    -52.302629,     4, 6,  "GUF R71B.ZJW"},
        {24.506,      54.324642,      4, 6,  "ARE 12.XX"},
        {25.388927,   55.0678965,     3, 7,  "ARE 12.XXX"},
        {24.379214,   54.37891925,    3, 5,  "ARE 000.XX"},
        {24.379214,   54.51277925,    3, 5,  "ARE 200.XX"},
        {24.379214,   54.64663925,    3, 5,  "ARE 400.XX"},
        {24.256905,   54.44584925,    3, 5,  "ARE 600.XX"},
        {24.256905,   54.57970925,    3, 5,  "ARE 800.XX"},
        {24.501523,   54.61451225,    4, 6,  "ARE B00.XX"},
        {24.623832,   54.66805625,    4, 6,  "ARE D00.XX"},
        {24.210514,   55.67311925,    3, 5,  "ARE G00.XX"},
        {24.186052,   55.53925925,    3, 5,  "ARE J00.XX"},
        {24.088205,   55.619745125,   3, 5,  "ARE L00.XX"},
        {24.088205,   55.753265125,   3, 5,  "ARE N00.XX"},
        {25.730414,   55.87883975,    3, 7,  "ARE Q00.XX"},
        {25.893724,   55.956013875,   3, 7,  "ARE S00.XX"},
        {25.160995,   56.3135475,     3, 7,  "ARE T00.XX"},
        {25.435145,   56.33358175,    3, 7,  "ARE V00.XX"},
        {25.576545,   55.52524875,    3, 7,  "ARE W00.XX"},
        {25.478545,   55.47557875,    3, 7,  "ARE X00.XX"},
        {25.046124,   54.9468525,     4, 6,  "ARE Y00.XX"},
        {25.632224,   56.24602675,    4, 9,  "ARE Z00.XX"},
        {26.037895,   55.8971715,     2, 6,  "ARE 012.XXX"},
        {25.661679,   55.8971715,     3, 7,  "ARE 112.XXX"},
        {25.170639,   55.8971715,     2, 6,  "ARE 212.XXX"},
        {25.828632,   55.3815795,     2, 6,  "ARE 312.XXX"},
        {25.337592,   55.3815795,     3, 7,  "ARE 412.XXX"},
        {25.337592,   54.8659875,     3, 7,  "ARE 512.XXX"},
        {24.94476,    54.092313,      3, 5,  "ARE 612.XXX"},
        {24.94476,    54.602697,      3, 5,  "ARE 712.XXX"},
        {24.94476,    55.113081,      5, 7,  "ARE 812.XXX"},
        {24.94476,    55.623465,      3, 5,  "ARE 912.XXX"},
        {24.45372,    51.540392,      2, 6,  "ARE B12.XXX"},
        {24.45372,    52.050776,      3, 7,  "ARE C12.XXX"},
        {24.45372,    52.56116,       3, 7,  "ARE D12.XXX"},
        {24.45372,    53.071544,      3, 7,  "ARE F12.XXX"},
        {24.45372,    53.581928,      3, 5,  "ARE G12.XXX"},
        {24.45372,    54.092312,      3, 5,  "ARE H12.XXX"},
        {24.45372,    54.602696,      4, 6,  "ARE J12.XXX"},
        {24.45372,    55.11308,       3, 5,  "ARE K12.XXX"},
        {24.45372,    55.623464,      2, 4,  "ARE L12.XXX"},
        {23.96268,    51.5708335,     2, 5,  "ARE M12.XXX"},
        {23.96268,    52.0760095,     2, 6,  "ARE N12.XXX"},
        {23.96268,    52.5811855,     2, 4,  "ARE P12.XXX"},
        {23.96268,    53.0863615,     2, 4,  "ARE Q12.XXX"},
        {23.96268,    53.5915375,     2, 4,  "ARE R12.XXX"},
        {23.96268,    54.0967135,     2, 4,  "ARE S12.XXX"},
        {23.96268,    54.6018895,     2, 4,  "ARE T12.XXX"},
        {23.96268,    55.1070655,     2, 4,  "ARE V12.XXX"},
        {23.47164,    52.5811855,     2, 4,  "ARE W12.XXX"},
        {23.47164,    53.0863615,     2, 4,  "ARE X12.XXX"},
        {23.47164,    53.5915375,     2, 4,  "ARE Y12.XXX"},
        {23.47164,    54.0967135,     2, 4,  "ARE Z12.XXX"},
        {23.040105,   52.0509835,     2, 6,  "ARE B123.XX"},
        {23.040105,   54.5768635,     3, 7,  "ARE C123.XX"},
        {23.040105,   55.0820395,     3, 7,  "ARE F123.XX"},
        {22.628111,   52.4551245,     2, 6,  "ARE H123.XX"},
        {22.628111,   52.9603005,     2, 6,  "ARE K123.XX"},
        {22.628111,   53.4654765,     2, 6,  "ARE M123.XX"},
        {22.628111,   53.9706525,     2, 6,  "ARE P123.XX"},
        {22.628111,   54.4758285,     2, 6,  "ARE R123.XX"},
        {22.628111,   54.9810045,     2, 6,  "ARE S123.XX"},
        {24.993127,   51.837943,      2, 5,  "ARE 12.XXXX"},
        {24.4709,     54.3659,        4, 6,  "ARE LG3D.SPY"},
        {48.2551,     16.3144875,     4, 5,  "AUT 12.XX"},
        {47.870529,   16.1582865,     3, 4,  "AUT 12.XXX"},
        {48.344224,   14.2337805,     3, 5,  "AUT 000.XX"},
        {47.120724,   15.380975625,   3, 4,  "AUT 100.XX"},
        {47.034235,   15.380975625,   3, 4,  "AUT 200.XX"},
        {47.292045,   11.33846525,    3, 5,  "AUT 300.XX"},
        {47.850324,   12.970645875,   3, 5,  "AUT 400.XX"},
        {46.663824,   14.24424,       3, 6,  "AUT 500.XX"},
        {46.660724,   13.79124,       3, 8,  "AUT 600.XX"},
        {48.210724,   13.969545875,   3, 5,  "AUT 700.XX"},
        {48.250824,   15.598745875,   3, 4,  "AUT 800.XX"},
        {48.080724,   14.349545875,   3, 5,  "AUT 900.XX"},
        {47.290424,   9.54371025,     3, 8,  "AUT B00.XX"},
        {47.507624,   9.64361025,     3, 8,  "AUT C00.XX"},
        {47.421324,   9.64161025,     3, 7,  "AUT D00.XX"},
        {47.434224,   14.99391025,    3, 5,  "AUT F00.XX"},
        {46.875824,   14.782475625,   3, 6,  "AUT G00.XX"},
        {48.452724,   15.5719805,     3, 4,  "AUT H00.XX"},
        {48.259424,   14.204345875,   3, 5,  "AUT J00.XX"},
        {48.150724,   14.824445875,   3, 5,  "AUT K00.XX"},
        {47.473424,   15.21991025,    3, 4,  "AUT L00.XX"},
        {47.748824,   13.01461025,    3, 5,  "AUT M00.XX"},
        {48.283324,   12.960845875,   3, 5,  "AUT N00.XX"},
        {46.845124,   13.469575625,   3, 8,  "AUT P00.XX"},
        {47.632924,   12.11261025,    3, 6,  "AUT Q00.XX"},
        {47.100724,   15.050675625,   3, 4,  "AUT R00.XX"},
        {46.836724,   15.480675625,   3, 6,  "AUT S00.XX"},
        {47.424364,   12.81768675,    3, 5,  "AUT T00.XX"},
        {47.709404,   16.01134125,    3, 4,  "AUT TK0.00"},
        {46.742464,   14.028515875,   3, 6,  "AUT V00.XX"},
        {47.330404,   9.59334125,     3, 8,  "AUT VK0.00"},
        {48.321764,   16.0003275,     3, 4,  "AUT W00.XX"},
        {47.159904,   9.762603625,    3, 6,  "AUT WK0.00"},
        {47.314364,   11.02128675,    3, 5,  "AUT X00.XX"},
        {47.913804,   13.745779875,   3, 5,  "AUT XK0.00"},
        {46.772664,   14.310615875,   3, 6,  "AUT Y00.XX"},
        {47.338404,   11.65714125,    3, 5,  "AUT YK0.00"},
        {47.232464,   14.78448675,    3, 4,  "AUT Z00.XX"},
        {46.824004,   12.751203625,   3, 6,  "AUT ZK0.00"},
        {48.7667325,  13.4754025,     2, 6,  "AUT 012.XXX"},
        {48.7667325,  14.1784825,     2, 6,  "AUT 112.XXX"},
        {48.983623,   14.8815625,     2, 6,  "AUT 212.XXX"},
        {48.8847285,  15.5846425,     2, 5,  "AUT 312.XXX"},
        {48.7957695,  16.2877215,     2, 5,  "AUT 412.XXX"},
        {48.492611,   12.7769565,     2, 4,  "AUT 512.XXX"},
        {48.492611,   13.4696205,     2, 4,  "AUT 612.XXX"},
        {48.492611,   14.1622845,     2, 4,  "AUT 712.XXX"},
        {48.492611,   14.8549485,     2, 4,  "AUT 812.XXX"},
        {48.492611,   15.5476125,     2, 3,  "AUT 912.XXX"},
        {48.492611,   16.229607,      2, 3,  "AUT B12.XXX"},
        {48.492611,   16.72688,       2, 3,  "AUT C12.XXX"},
        {48.001571,   12.77667,       2, 4,  "AUT D12.XXX"},
        {48.001571,   13.464126,      2, 4,  "AUT F12.XXX"},
        {48.001571,   14.151582,      2, 4,  "AUT G12.XXX"},
        {48.001571,   14.839038,      2, 4,  "AUT H12.XXX"},
        {48.001571,   15.526494,      2, 3,  "AUT J12.XXX"},
        {48.001571,   16.2049995,     3, 4,  "AUT K12.XXX"},
        {48.012153,   16.726881,      2, 3,  "AUT L12.XXX"},
        {47.510531,   12.7815925,     2, 4,  "AUT M12.XXX"},
        {47.510531,   13.4638405,     2, 4,  "AUT N12.XXX"},
        {47.510531,   14.1460885,     2, 4,  "AUT P12.XXX"},
        {47.510531,   14.8283365,     2, 4,  "AUT Q12.XXX"},
        {47.510531,   15.5105845,     2, 3,  "AUT R12.XXX"},
        {47.510531,   16.1928325,     2, 5,  "AUT S12.XXX"},
        {47.019491,   12.781306,      2, 5,  "AUT T12.XXX"},
        {47.019491,   13.458346,      2, 5,  "AUT V12.XXX"},
        {47.019491,   14.135386,      2, 3,  "AUT W12.XXX"},
        {47.019491,   14.812425,      2, 3,  "AUT X12.XXX"},
        {47.019491,   15.489465,      3, 4,  "AUT Y12.XXX"},
        {47.019491,   16.166505,      2, 5,  "AUT Z12.XXX"},
        {46.561511,   13.434988,      2, 7,  "AUT XHHH.HH"},
        {46.561511,   14.101612,      2, 5,  "AUT YHHH.HH"},
        {46.561511,   14.768236,      2, 5,  "AUT ZHHH.HH"},
        {47.546039,   9.4953055,      2, 8,  "AUT 0123.XX"},
        {47.1463075,  9.494656,       2, 8,  "AUT 1123.XX"},
        {47.5629935,  10.237565,      2, 6,  "AUT 2123.XX"},
        {47.2073475,  10.2447275,     2, 5,  "AUT 3123.XX"},
        {47.478768,   10.9178525,     2, 4,  "AUT 4123.XX"},
        {47.2073475,  10.9269755,     2, 3,  "AUT 5123.XX"},
        {47.272983,   11.580632,      3, 5,  "AUT 6123.XX"},
        {47.231205,   11.6075975,     2, 3,  "AUT 7123.XX"},
        {47.296919,   12.26231,       3, 5,  "AUT 8123.XX"},
        {46.7687715,  12.267746,      2, 5,  "AUT 9123.XX"},
        {47.694,      13.3245,        2, 4,  "AUT L8T9.GQ5"},
        {40.435624,   49.7914235,     4, 5,  "AZE 12.XX"},
        {40.448845,   49.5523125,     3, 4,  "AZE 12.XXX"},
        {40.730744,   46.280945625,   3, 5,  "AZE 000.XX"},
        {40.730744,   46.361235625,   3, 5,  "AZE 100.XX"},
        {40.774545,   46.964295625,   3, 4,  "AZE 200.XX"},
        {39.983524,   48.863603625,   3, 4,  "AZE 300.XX"},
        {39.232024,   45.36869475,    3, 8,  "AZE 400.XX"},
        {41.239224,   47.1473125,     3, 8,  "AZE 500.XX"},
        {40.658724,   47.096551125,   3, 4,  "AZE 600.XX"},
        {39.876424,   46.726055125,   3, 4,  "AZE 700.XX"},
        {38.791124,   48.771233375,   4, 7,  "AZE 800.XX"},
        {40.035424,   46.875803625,   3, 4,  "AZE 900.XX"},
        {40.430724,   47.057003625,   3, 4,  "AZE B00.XX"},
        {41.510724,   48.74576,       3, 5,  "AZE C00.XX"},
        {39.628624,   48.913455125,   3, 6,  "AZE D00.XX"},
        {39.269324,   48.46459475,    3, 6,  "AZE F00.XX"},
        {40.667824,   47.684251125,   3, 4,  "AZE G00.XX"},
        {40.884024,   45.997551125,   3, 5,  "AZE H00.XX"},
        {40.094924,   47.386903625,   3, 4,  "AZE J00.XX"},
        {39.910724,   47.997455125,   3, 4,  "AZE K00.XX"},
        {40.675724,   48.571351125,   3, 4,  "AZE L00.XX"},
        {40.040724,   48.427003625,   3, 4,  "AZE M00.XX"},
        {39.735724,   48.022055125,   3, 6,  "AZE N00.XX"},
        {40.699924,   47.404851125,   3, 4,  "AZE P00.XX"},
        {40.081924,   48.876603625,   3, 4,  "AZE Q00.XX"},
        {41.388464,   48.4842235,     3, 8,  "AZE R00.XX"},
        {41.084704,   49.0944495,     3, 5,  "AZE RK0.00"},
        {41.223764,   48.9552235,     3, 5,  "AZE S00.XX"},
        {41.094804,   45.3328495,     3, 6,  "AZE SK0.00"},
        {39.389264,   49.209768375,   3, 6,  "AZE T00.XX"},
        {39.754104,   46.716346125,   3, 6,  "AZE TK0.00"},
        {41.638664,   46.59648,       3, 8,  "AZE V00.XX"},
        {39.441104,   48.528846125,   3, 6,  "AZE VK0.00"},
        {40.352464,   46.889724875,   3, 4,  "AZE W00.XX"},
        {40.343804,   48.128456625,   3, 4,  "AZE WK0.00"},
        {40.595664,   46.297381375,   3, 5,  "AZE X00.XX"},
        {39.929104,   48.334456625,   3, 4,  "AZE XK0.00"},
        {40.582464,   48.349381375,   3, 4,  "AZE Y00.XX"},
        {41.414104,   48.3855495,     3, 8,  "AZE YK0.00"},
        {40.523364,   47.610281375,   3, 4,  "AZE Z00.XX"},
        {38.421104,   48.818280375,   3, 6,  "AZE ZK0.00"},
        {41.884595,   46.0343,        2, 9,  "AZE 012.XXX"},
        {41.884595,   46.659259,      2, 7,  "AZE 112.XXX"},
        {41.884595,   48.034171,      2, 7,  "AZE 212.XXX"},
        {41.884595,   48.659131,      2, 4,  "AZE 312.XXX"},
        {41.442659,   45.0017875,     2, 7,  "AZE 412.XXX"},
        {41.442659,   45.6215395,     2, 9,  "AZE 512.XXX"},
        {41.442659,   46.2412915,     3, 10, "AZE 612.XXX"},
        {41.442659,   46.8610435,     3, 8,  "AZE 712.XXX"},
        {41.442659,   47.4807955,     2, 7,  "AZE 812.XXX"},
        {41.442659,   48.1005475,     3, 8,  "AZE 912.XXX"},
        {41.442659,   48.7202995,     3, 5,  "AZE B12.XXX"},
        {40.951619,   45.218414,      2, 4,  "AZE C12.XXX"},
        {40.951619,   45.832958,      2, 4,  "AZE D12.XXX"},
        {40.951619,   46.447502,      2, 4,  "AZE F12.XXX"},
        {40.951619,   47.062046,      2, 3,  "AZE G12.XXX"},
        {40.951619,   47.67659,       2, 3,  "AZE H12.XXX"},
        {40.951619,   48.291134,      2, 3,  "AZE J12.XXX"},
        {40.951619,   48.905678,      2, 3,  "AZE K12.XXX"},
        {40.951619,   49.520222,      2, 3,  "AZE L12.XXX"},
        {40.460579,   45.3155175,     2, 4,  "AZE M12.XXX"},
        {40.460579,   45.9248535,     2, 4,  "AZE N12.XXX"},
        {40.460579,   46.5341895,     2, 4,  "AZE P12.XXX"},
        {40.460579,   47.1435255,     2, 3,  "AZE Q12.XXX"},
        {40.460579,   47.7528615,     2, 3,  "AZE R12.XXX"},
        {40.460579,   48.3621975,     2, 3,  "AZE S12.XXX"},
        {40.460579,   48.9715335,     2, 3,  "AZE T12.XXX"},
        {40.460579,   49.5808695,     3, 4,  "AZE V12.XXX"},
        {40.607891,   50.0988045,     4, 7,  "AZE W12.XXX"},
        {39.969539,   45.619899,      2, 4,  "AZE X12.XXX"},
        {39.969539,   46.224027,      2, 4,  "AZE Y12.XXX"},
        {39.969539,   46.828155,      2, 3,  "AZE Z12.XXX"},
        {39.557699,   47.432283,      2, 5,  "AZE B1.XXXX"},
        {39.557699,   48.036411,      2, 5,  "AZE C1.XXXX"},
        {39.557699,   48.640539,      2, 5,  "AZE D1.XXXX"},
        {39.557699,   49.244667,      2, 5,  "AZE F1.XXXX"},
        {39.066659,   46.4101865,     3, 8,  "AZE G1.XXXX"},
        {39.066659,   47.0091065,     2, 6,  "AZE H1.XXXX"},
        {39.066659,   48.1470545,     2, 6,  "AZE K1.XXXX"},
        {39.066659,   48.7459745,     2, 5,  "AZE L1.XXXX"},
        {39.066659,   49.3448945,     2, 5,  "AZE M1.XXXX"},
        {38.870243,   46.4101865,     2, 7,  "AZE P1.XXXX"},
        {38.575619,   48.05693,       2, 6,  "AZE Q1.XXXX"},
        {38.575619,   48.472529,      3, 6,  "AZE R1.XXXX"},
        {38.575619,   49.066241,      2, 5,  "AZE S1.XXXX"},
        {38.421795,   48.5071355,     2, 5,  "AZE T1.XXXX"},
        {39.3631895,  44.793101,      2, 7,  "AZE 11.XXXX"},
        {39.349288,   45.392542,      2, 6,  "AZE 21.XXXX"},
        {38.976163,   45.089744,      2, 6,  "AZE 31.XXXX"},
        {38.873729,   45.6305835,     2, 7,  "AZE 41.XXXX"},
        {40.400524,   49.8406805,     4, 5,  "AZE VF2D.38T"},
        {44.847802,   20.406995,      4, 5,  "SRB 12.XX"},
        {45.079219,   20.207995,      3, 4,  "SRB 12.XXX"},
        {42.690724,   21.114856,      3, 4,  "SRB 000.XX"},
        {42.669924,   21.004256,      3, 6,  "SRB 100.XX"},
        {42.270724,   20.6853085,     3, 8,  "SRB 200.XX"},
        {42.700724,   20.254856,      3, 6,  "SRB 300.XX"},
        {42.430724,   20.3753085,     3, 8,  "SRB 400.XX"},
        {42.930724,   20.814856,      3, 4,  "SRB 500.XX"},
        {42.510724,   21.4253085,     3, 4,  "SRB 600.XX"},
        {42.418324,   21.1425085,     3, 4,  "SRB 700.XX"},
        {42.450724,   20.6053085,     3, 6,  "SRB 800.XX"},
        {42.950724,   21.134856,      3, 4,  "SRB 900.XX"},
        {45.297024,   19.76917075,    3, 4,  "SRB B00.XX"},
        {43.361424,   21.8600045,     3, 4,  "SRB C00.XX"},
        {44.054524,   20.857352,      3, 4,  "SRB D00.XX"},
        {46.136824,   19.621805375,   3, 6,  "SRB F00.XX"},
        {45.398524,   20.34787075,    3, 4,  "SRB G00.XX"},
        {43.924524,   20.311452,      3, 4,  "SRB H00.XX"},
        {43.040724,   21.894856,      3, 4,  "SRB J00.XX"},
        {44.686624,   20.891635125,   3, 4,  "SRB K00.XX"},
        {44.320724,   19.833387625,   3, 4,  "SRB L00.XX"},
        {43.755024,   20.609152,      3, 4,  "SRB M00.XX"},
        {43.615724,   21.272152,      3, 4,  "SRB N00.XX"},
        {43.897324,   19.808452,      3, 4,  "SRB P00.XX"},
        {42.557664,   21.855393,      3, 4,  "SRB Q00.XX"},
        {44.751904,   19.651251125,   3, 4,  "SRB QK0.00"},
        {45.784864,   19.069375125,   3, 9,  "SRB R00.XX"},
        {44.617304,   21.147451125,   3, 4,  "SRB RK0.00"},
        {45.838264,   20.418675125,   3, 6,  "SRB S00.XX"},
        {43.142904,   22.5631915,     3, 6,  "SRB SK0.00"},
        {43.917464,   22.230506,      3, 4,  "SRB T00.XX"},
        {44.047904,   22.096502,      3, 4,  "SRB TK0.00"},
        {44.994764,   19.552633375,   3, 4,  "SRB V00.XX"},
        {45.109804,   21.261451125,   3, 4,  "SRB VK0.00"},
        {43.992464,   21.217406,      3, 4,  "SRB W00.XX"},
        {45.000404,   19.785051125,   3, 4,  "SRB WK0.00"},
        {45.252064,   19.34870425,    3, 6,  "SRB X00.XX"},
        {45.040204,   20.043751125,   3, 4,  "SRB XK0.00"},
        {45.586664,   19.59730425,    3, 4,  "SRB Y00.XX"},
        {45.612404,   20.00508875,    3, 4,  "SRB YK0.00"},
        {43.866264,   21.371806,      3, 4,  "SRB Z00.XX"},
        {44.362004,   20.928340625,   3, 4,  "SRB ZK0.00"},
        {46.149595,   18.866338,      2, 5,  "SRB 112.XXX"},
        {46.149595,   19.532962,      2, 5,  "SRB 212.XXX"},
        {46.149595,   20.199586,      2, 6,  "SRB 312.XXX"},
        {45.658555,   18.9379215,     2, 5,  "SRB 412.XXX"},
        {45.658555,   19.5993375,     2, 3,  "SRB 512.XXX"},
        {45.658555,   20.2607535,     2, 3,  "SRB 612.XXX"},
        {45.658555,   20.9221695,     2, 5,  "SRB 712.XXX"},
        {45.167515,   19.003777,      2, 5,  "SRB 812.XXX"},
        {45.167515,   19.659985,      2, 3,  "SRB 912.XXX"},
        {45.167515,   20.316193,      2, 3,  "SRB B12.XXX"},
        {45.167515,   20.972401,      2, 3,  "SRB C12.XXX"},
        {44.676475,   19.0743195,     2, 5,  "SRB D12.XXX"},
        {44.676475,   19.7253195,     2, 3,  "SRB F12.XXX"},
        {44.676475,   20.3763195,     3, 4,  "SRB G12.XXX"},
        {44.676475,   21.0273195,     2, 3,  "SRB H12.XXX"},
        {44.676475,   21.6783195,     2, 5,  "SRB J12.XXX"},
        {44.676475,   22.3293195,     2, 6,  "SRB K12.XXX"},
        {44.185435,   19.074033,      2, 5,  "SRB L12.XXX"},
        {44.185435,   19.719825,      2, 3,  "SRB M12.XXX"},
        {44.185435,   20.365617,      2, 3,  "SRB N12.XXX"},
        {44.185435,   21.011409,      2, 3,  "SRB P12.XXX"},
        {44.185435,   21.657201,      2, 3,  "SRB Q12.XXX"},
        {44.185435,   22.302993,      2, 3,  "SRB R12.XXX"},
        {43.694395,   19.2404025,     2, 5,  "SRB S12.XXX"},
        {43.694395,   19.8809865,     2, 3,  "SRB T12.XXX"},
        {43.694395,   20.5215705,     2, 3,  "SRB V12.XXX"},
        {43.694395,   21.1621545,     2, 3,  "SRB W12.XXX"},
        {43.694395,   21.8027385,     2, 3,  "SRB X12.XXX"},
        {43.694395,   22.4433225,     2, 5,  "SRB Y12.XXX"},
        {42.816067,   19.579625,      2, 5,  "SRB B1.XXXX"},
        {42.816067,   20.215001,      2, 5,  "SRB C1.XXXX"},
        {42.816067,   20.850377,      2, 3,  "SRB D1.XXXX"},
        {42.816067,   21.485753,      2, 3,  "SRB F1.XXXX"},
        {42.816067,   22.121129,      2, 3,  "SRB G1.XXXX"},
        {42.816067,   22.756505,      2, 5,  "SRB H1.XXXX"},
        {42.325027,   20.0420175,     2, 7,  "SRB J1.XXXX"},
        {42.325027,   20.6721855,     2, 7,  "SRB K1.XXXX"},
        {42.325027,   21.3023535,     2, 5,  "SRB L1.XXXX"},
        {42.2934175,  21.933242,      2, 5,  "SRB M1.XXXX"},
        {41.885024,   20.388302,      2, 5,  "SRB N1.XXXX"},
        {42.134594,   20.9275205,     2, 7,  "SRB P1.XXXX"},
        {44.0275,     20.9175,        3, 4,  "SRB HM30.YW5"},
        {31.9941,     35.8712755,     4, 7,  "JOR 12.XX"},
        {32.124742,   35.7289505,     3, 6,  "JOR 12.XXX"},
        {32.550904,   35.736687,      3, 8,  "JOR 000.XX"},
        {32.321594,   35.669661,      3, 8,  "JOR 400.XX"},
        {29.547394,   34.956447625,   3, 8,  "JOR 700.XX"},
        {32.604394,   35.963037375,   3, 6,  "JOR B00.XX"},
        {32.350494,   36.110061,      3, 6,  "JOR F00.XX"},
        {30.184194,   35.643731875,   3, 7,  "JOR J00.XX"},
        {30.824794,   35.520416125,   3, 7,  "JOR M00.XX"},
        {32.331894,   35.838761,      4, 9,  "JOR Q00.XX"},
        {31.174294,   35.6276925,     3, 7,  "JOR T00.XX"},
        {32.700394,   36.499637375,   2, 5,  "JOR X00.XX"},
        {33.274154,   38.300957,      2, 5,  "JOR 1HH.HHH"},
        {33.274154,   38.853005,      2, 6,  "JOR 2HH.HHH"},
        {32.981835,   35.569549,      2, 5,  "JOR 312.XXX"},
        {32.981835,   37.170489,      2, 5,  "JOR 412.XXX"},
        {32.981835,   37.722537,      2, 5,  "JOR 512.XXX"},
        {32.981835,   38.274585,      2, 5,  "JOR 612.XXX"},
        {32.981835,   38.826633,      2, 6,  "JOR 712.XXX"},
        {32.490795,   35.514345,      2, 7,  "JOR 812.XXX"},
        {32.490795,   36.066393,      2, 5,  "JOR 912.XXX"},
        {32.490795,   36.618441,      2, 5,  "JOR B12.XXX"},
        {32.490795,   37.170489,      2, 5,  "JOR C12.XXX"},
        {32.490795,   37.722537,      2, 5,  "JOR D12.XXX"},
        {32.490795,   38.274585,      2, 5,  "JOR F12.XXX"},
        {32.490795,   38.826633,      2, 6,  "JOR G12.XXX"},
        {31.999755,   35.5192665,     2, 7,  "JOR H12.XXX"},
        {31.999755,   36.0661065,     3, 6,  "JOR J12.XXX"},
        {31.999755,   36.6129465,     2, 5,  "JOR K12.XXX"},
        {31.999755,   37.1597865,     2, 5,  "JOR L12.XXX"},
        {31.999755,   37.7066265,     2, 5,  "JOR M12.XXX"},
        {31.999755,   38.2534665,     2, 5,  "JOR N12.XXX"},
        {31.999755,   38.8003065,     2, 6,  "JOR P12.XXX"},
        {31.508715,   35.3552135,     2, 8,  "JOR Q12.XXX"},
        {31.508715,   35.9020535,     2, 6,  "JOR R12.XXX"},
        {31.508715,   36.4488935,     2, 6,  "JOR S12.XXX"},
        {31.508715,   36.9957335,     2, 5,  "JOR T12.XXX"},
        {31.017675,   34.97214,       2, 6,  "JOR V12.XXX"},
        {31.017675,   35.513772,      2, 6,  "JOR W12.XXX"},
        {31.017675,   36.055404,      2, 6,  "JOR X12.XXX"},
        {31.017675,   36.597036,      2, 6,  "JOR Y12.XXX"},
        {31.017675,   37.138668,      2, 5,  "JOR Z12.XXX"},
        {30.583425,   37.653468,      2, 5,  "JOR C123.XX"},
        {30.0951,     34.9504875,     2, 6,  "JOR D123.XX"},
        {30.0951,     35.4869115,     2, 6,  "JOR F123.XX"},
        {30.0951,     36.0233355,     2, 6,  "JOR G123.XX"},
        {30.0951,     36.5597595,     2, 6,  "JOR H123.XX"},
        {30.0951,     37.0961835,     2, 5,  "JOR J123.XX"},
        {30.0951,     37.6326075,     2, 5,  "JOR K123.XX"},
        {29.601345,   34.9504865,     2, 7,  "JOR L123.XX"},
        {29.601345,   35.4869105,     2, 6,  "JOR M123.XX"},
        {29.601345,   36.0233345,     2, 6,  "JOR N123.XX"},
        {29.601345,   36.5597585,     2, 6,  "JOR P123.XX"},
        {29.601345,   37.0961825,     2, 5,  "JOR Q123.XX"},
        {29.577615,   35.224226,      2, 6,  "JOR SHHH.HH"},
        {29.577615,   35.755442,      2, 6,  "JOR THHH.HH"},
        {29.5481325,  36.0307535,     2, 6,  "JOR V123.XX"},
        {31.27865,    37.09,          2, 6,  "JOR 6P3C.2NG"},
        {38.774127,   -9.192376,      5, 8,  "PRT 12.XX"},
        {38.758442,   -9.4692465,     4, 7,  "PRT 12.XXX"},
        {41.25559,    -8.7229615,     4, 7,  "PRT 000.XX"},
        {41.25559,    -8.6086035,     4, 7,  "PRT 100.XX"},
        {41.169101,   -8.6897975,     4, 7,  "PRT 200.XX"},
        {41.169101,   -8.5754395,     4, 7,  "PRT 300.XX"},
        {41.082612,   -8.6566335,     4, 7,  "PRT 400.XX"},
        {41.590724,   -8.48424,       4, 7,  "PRT 500.XX"},
        {40.260224,   -8.494096375,   4, 7,  "PRT 600.XX"},
        {32.670545,   -17.003733125,  4, 5,  "PRT 700.XX"},
        {40.641445,   -8.747604375,   4, 7,  "PRT 800.XX"},
        {39.790724,   -8.852544875,   4, 7,  "PRT 900.XX"},
        {37.051045,   -8.055719375,   5, 8,  "PRT B00.XX"},
        {41.480724,   -8.3537875,     4, 7,  "PRT C00.XX"},
        {37.150545,   -8.597919375,   4, 7,  "PRT D00.XX"},
        {38.564204,   -7.940819625,   4, 7,  "PRT DK0.00"},
        {38.027264,   -7.899772375,   4, 7,  "PRT F00.XX"},
        {39.812904,   -7.533653875,   4, 7,  "PRT FK0.00"},
        {38.909764,   -9.08297375,    4, 7,  "PRT G00.XX"},
        {39.740804,   -8.961453875,   4, 7,  "PRT GK0.00"},
        {37.057164,   -7.886757625,   5, 8,  "PRT H00.XX"},
        {39.234104,   -8.72343725,    4, 7,  "PRT HK0.00"},
        {41.382864,   -8.7809765,     4, 7,  "PRT J00.XX"},
        {40.664104,   -7.954232875,   4, 7,  "PRT JK0.00"},
        {40.561464,   -7.288818625,   4, 7,  "PRT K00.XX"},
        {39.393904,   -9.182453875,   4, 7,  "PRT KK0.00"},
        {39.135564,   -9.39397375,    4, 7,  "PRT L00.XX"},
        {37.112804,   -8.054095875,   4, 7,  "PRT LK0.00"},
        {40.912464,   -8.530618625,   4, 7,  "PRT M00.XX"},
        {37.135004,   -7.661095875,   4, 7,  "PRT MK0.00"},
        {41.351864,   -8.5967765,     4, 7,  "PRT N00.XX"},
        {37.750785,   -25.7186285,    4, 5,  "PRT NK0.00"},
        {41.818564,   -6.80142,       4, 8,  "PRT P00.XX"},
        {39.596004,   -8.439453875,   4, 7,  "PRT PK0.00"},
        {41.762764,   -7.51332,       4, 7,  "PRT Q00.XX"},
        {41.421304,   -8.7835505,     4, 7,  "PRT QK0.00"},
        {38.936064,   -8.90287375,    4, 7,  "PRT R00.XX"},
        {39.453604,   -8.513553875,   4, 7,  "PRT RK0.00"},
        {40.302364,   -7.519975125,   4, 7,  "PRT S00.XX"},
        {41.524104,   -8.65474,       4, 7,  "PRT SK0.00"},
        {37.111985,   -8.756919375,   4, 7,  "PRT T00.XX"},
        {40.865895,   -8.671837125,   4, 7,  "PRT TK0.00"},
        {38.799664,   -7.472015875,   4, 7,  "PRT V00.XX"},
        {40.144004,   -8.896443375,   4, 7,  "PRT VK0.00"},
        {39.479064,   -8.221131625,   4, 7,  "PRT W00.XX"},
        {41.304104,   -7.7844505,     4, 7,  "PRT WK0.00"},
        {39.932464,   -8.660275125,   4, 7,  "PRT X00.XX"},
        {37.064104,   -8.122495875,   4, 7,  "PRT XK0.00"},
        {37.096145,   -8.322919375,   4, 7,  "PRT Y00.XX"},
        {39.284104,   -7.46343725,    4, 7,  "PRT YK0.00"},
        {41.280788,   -8.1214065,     4, 7,  "PRT Z00.XX"},
        {41.443264,   -8.208911,      4, 7,  "PRT ZK0.00"},
        {42.14119,    -8.9581,        3, 7,  "PRT 012.XXX"},
        {42.14119,    -8.33314,       3, 7,  "PRT 112.XXX"},
        {42.14119,    -7.708179,      3, 7,  "PRT 212.XXX"},
        {42.14119,    -7.08322,       3, 7,  "PRT 312.XXX"},
        {41.65015,    -8.9531785,     3, 6,  "PRT 412.XXX"},
        {41.65015,    -8.3334265,     3, 6,  "PRT 512.XXX"},
        {41.65015,    -7.7136745,     3, 6,  "PRT 612.XXX"},
        {41.65015,    -7.0939225,     3, 6,  "PRT 712.XXX"},
        {41.65015,    -6.4741705,     3, 6,  "PRT 812.XXX"},
        {41.15911,    -8.953464,      3, 6,  "PRT 912.XXX"},
        {41.15911,    -8.33892,       3, 6,  "PRT B12.XXX"},
        {41.15911,    -7.724376,      3, 6,  "PRT C12.XXX"},
        {41.15911,    -7.109832,      3, 6,  "PRT D12.XXX"},
        {40.66807,    -8.9485425,     3, 6,  "PRT F12.XXX"},
        {40.66807,    -8.3392065,     3, 6,  "PRT G12.XXX"},
        {40.66807,    -7.7298705,     3, 6,  "PRT H12.XXX"},
        {40.66807,    -7.1205345,     3, 6,  "PRT J12.XXX"},
        {40.17703,    -9.070697,      3, 6,  "PRT K12.XXX"},
        {40.17703,    -8.466569,      4, 7,  "PRT L12.XXX"},
        {40.17703,    -7.862441,      3, 6,  "PRT M12.XXX"},
        {39.7284665,  -7.278749,      4, 7,  "PRT N12.XXX"},
        {39.68599,    -9.3778385,     3, 6,  "PRT P12.XXX"},
        {39.68599,    -8.7789185,     3, 6,  "PRT Q12.XXX"},
        {39.68599,    -8.1799985,     3, 6,  "PRT R12.XXX"},
        {39.68599,    -7.5810785,     3, 6,  "PRT S12.XXX"},
        {39.19495,    -9.845282,      2, 3,  "PRT T12.XXX"},
        {39.19495,    -9.25157,       3, 6,  "PRT V12.XXX"},
        {39.19495,    -8.657858,      3, 6,  "PRT W12.XXX"},
        {39.19495,    -8.064146,      3, 6,  "PRT X12.XXX"},
        {39.19495,    -7.470434,      3, 6,  "PRT Y12.XXX"},
        {38.70391,    -9.5435045,     3, 6,  "PRT Z12.XXX"},
        {38.29207,    -8.9550005,     3, 6,  "PRT 01.XXXX"},
        {38.29207,    -8.3664965,     3, 6,  "PRT 11.XXXX"},
        {38.29207,    -7.7779925,     3, 6,  "PRT 21.XXXX"},
        {37.80103,    -8.9550005,     3, 6,  "PRT 31.XXXX"},
        {37.80103,    -8.3664965,     3, 6,  "PRT 41.XXXX"},
        {37.80103,    -7.7779925,     3, 6,  "PRT 51.XXXX"},
        {37.92379,    -7.4837405,     4, 7,  "PRT 61.XXXX"},
        {37.30999,    -9.0138505,     3, 6,  "PRT 71.XXXX"},
        {37.30999,    -8.4253465,     3, 6,  "PRT 81.XXXX"},
        {37.30999,    -7.8368425,     3, 6,  "PRT 91.XXXX"},
        {36.81895,    -9.014137,      3, 6,  "PRT B1.XXXX"},
        {36.81895,    -8.430842,      3, 6,  "PRT C1.XXXX"},
        {36.81895,    -7.847546,      3, 6,  "PRT D1.XXXX"},
        {32.765173,   -17.301484,     3, 4,  "PRT M123.XX"},
        {32.7214675,  -16.542435,     3, 4,  "PRT R123.XX"},
        {29.858726,   -16.2148205,    3, 6,  "PRT S123.XX"},
        {39.317676,   -31.4143815,    3, 4,  "PRT T123.XX"},
        {38.5017865,  -28.8180625,    3, 4,  "PRT V123.XX"},
        {38.63592,    -28.3188365,    4, 5,  "PRT W123.XX"},
        {38.6812375,  -27.822419,     3, 4,  "PRT X123.XX"},
        {37.781552,   -25.858851,     3, 4,  "PRT Y123.XX"},
        {36.747577,   -25.375736,     3, 4,  "PRT Z123.XX"},
        {41.7571005,  -7.968424,      3, 6,  "PRT 1HHH.HHH"},
        {41.1118665,  -9.7101685,     2, 5,  "PRT 2123.XXX"},
        {38.383835,   -9.8572315,     2, 5,  "PRT 3123.XXX"},
        {34.2852995,  -18.025804,     2, 3,  "PRT M123.XXX"},
        {31.6041095,  -17.9994165,    2, 3,  "PRT N123.XXX"},
        {40.4584515,  -31.4073525,    2, 3,  "PRT T123.XXX"},
        {39.5197695,  -28.9416205,    2, 3,  "PRT X123.XXX"},
        {38.2600935,  -26.18882,      2, 3,  "PRT Z123.XXX"},
        {37.362324,   -25.087,        2, 3,  "PRT 5DJ9.NBMW"},
        {47.529345,   18.9905325,     4, 5,  "HUN 12.XX"},
        {47.769219,   18.74574,       3, 6,  "HUN 12.XXX"},
        {47.568124,   21.57861025,    3, 4,  "HUN 000.XX"},
        {48.111545,   20.671934375,   3, 4,  "HUN 100.XX"},
        {46.293724,   20.08924,       3, 4,  "HUN 200.XX"},
        {46.112224,   18.178505375,   4, 5,  "HUN 300.XX"},
        {47.727224,   17.59391025,    3, 6,  "HUN 400.XX"},
        {47.995424,   21.667245875,   3, 4,  "HUN 500.XX"},
        {46.950724,   19.630675625,   3, 4,  "HUN 600.XX"},
        {47.226124,   18.356675625,   3, 4,  "HUN 700.XX"},
        {47.275624,   16.56681025,    3, 6,  "HUN 800.XX"},
        {47.207624,   20.121275625,   3, 4,  "HUN 900.XX"},
        {47.605324,   18.32951025,    3, 4,  "HUN B00.XX"},
        {46.400724,   17.73124,       3, 4,  "HUN C00.XX"},
        {46.713524,   21.02894,       3, 4,  "HUN D00.XX"},
        {46.853264,   16.782615875,   3, 6,  "HUN F00.XX"},
        {47.096004,   17.883203625,   3, 4,  "HUN FK0.00"},
        {47.907764,   20.318157625,   3, 4,  "HUN G00.XX"},
        {47.681204,   16.54364125,    3, 6,  "HUN GK0.00"},
        {47.022045,   18.906128125,   3, 4,  "HUN H00.XX"},
        {46.454104,   16.952365,      3, 4,  "HUN HK0.00"},
        {46.427464,   20.274545,      4, 5,  "HUN J00.XX"},
        {48.055765,   19.778738625,   3, 6,  "HUN JK0.00"},
        {48.239364,   20.247157625,   3, 6,  "HUN K00.XX"},
        {46.177104,   18.922565,      3, 6,  "HUN KK0.00"},
        {47.192764,   19.738415875,   3, 4,  "HUN L00.XX"},
        {46.345104,   18.665965,      3, 4,  "HUN LK0.00"},
        {47.805764,   19.885757625,   3, 6,  "HUN M00.XX"},
        {47.324104,   17.43164125,    3, 4,  "HUN MK0.00"},
        {46.658545,   21.241505,      3, 6,  "HUN N00.XX"},
        {48.252604,   20.596779875,   3, 6,  "HUN NK0.00"},
        {47.684264,   21.45708675,    3, 4,  "HUN P00.XX"},
        {46.704104,   19.802003625,   3, 4,  "HUN PK0.00"},
        {46.578545,   20.591325,      4, 5,  "HUN Q00.XX"},
        {46.654104,   20.222365,      3, 4,  "HUN QK0.00"},
        {47.880964,   17.240257625,   3, 6,  "HUN R00.XX"},
        {46.424104,   19.442365,      3, 4,  "HUN RK0.00"},
        {47.512464,   19.86448675,    3, 4,  "HUN S00.XX"},
        {46.191104,   18.222265,      3, 4,  "HUN SK0.00"},
        {47.047464,   19.738015875,   3, 4,  "HUN T00.XX"},
        {46.212304,   20.446665,      4, 7,  "HUN TK0.00"},
        {47.667264,   18.27948675,    3, 4,  "HUN V00.XX"},
        {47.439304,   21.34674125,    3, 4,  "HUN VK0.00"},
        {46.905664,   18.006815875,   3, 4,  "HUN W00.XX"},
        {47.664104,   19.64164125,    3, 4,  "HUN WK0.00"},
        {47.192464,   20.364915875,   3, 4,  "HUN X00.XX"},
        {47.306504,   20.88884125,    3, 4,  "HUN XK0.00"},
        {46.782664,   17.234715875,   3, 4,  "HUN Y00.XX"},
        {46.767204,   21.083803625,   3, 4,  "HUN YK0.00"},
        {47.193364,   18.098415875,   3, 4,  "HUN Z00.XX"},
        {46.374104,   18.092365,      3, 4,  "HUN ZK0.00"},
        {48.539505,   19.4358625,     2, 6,  "HUN 012.XXX"},
        {48.539505,   20.1285265,     2, 5,  "HUN 112.XXX"},
        {48.539505,   20.8211905,     2, 5,  "HUN 212.XXX"},
        {48.539505,   21.5138545,     2, 5,  "HUN 312.XXX"},
        {48.539505,   22.2065185,     2, 6,  "HUN 412.XXX"},
        {48.048465,   16.838085,      2, 7,  "HUN 512.XXX"},
        {48.048465,   17.525541,      2, 6,  "HUN 612.XXX"},
        {48.048465,   18.212997,      2, 5,  "HUN 712.XXX"},
        {48.048465,   18.900453,      2, 5,  "HUN 812.XXX"},
        {48.048465,   19.587909,      2, 5,  "HUN 912.XXX"},
        {48.048465,   20.275365,      2, 3,  "HUN B12.XXX"},
        {48.048465,   20.962821,      2, 3,  "HUN C12.XXX"},
        {48.048465,   21.650277,      2, 3,  "HUN D12.XXX"},
        {48.048465,   22.337733,      2, 4,  "HUN F12.XXX"},
        {47.802945,   16.150629,      2, 6,  "HUN G12.XXX"},
        {47.557425,   16.8361325,     2, 3,  "HUN H12.XXX"},
        {47.557425,   17.5183805,     2, 3,  "HUN J12.XXX"},
        {47.557425,   18.2006285,     2, 3,  "HUN K12.XXX"},
        {47.557425,   18.8828765,     3, 4,  "HUN L12.XXX"},
        {47.557425,   19.5651245,     2, 3,  "HUN M12.XXX"},
        {47.557425,   20.2473725,     2, 3,  "HUN N12.XXX"},
        {47.557425,   20.9296205,     2, 3,  "HUN P12.XXX"},
        {47.557425,   21.6118685,     3, 4,  "HUN Q12.XXX"},
        {47.311905,   16.1538845,     2, 5,  "HUN R12.XXX"},
        {47.066385,   16.829023,      2, 5,  "HUN S12.XXX"},
        {47.066385,   17.506063,      2, 3,  "HUN T12.XXX"},
        {47.066385,   18.183103,      2, 3,  "HUN V12.XXX"},
        {47.066385,   18.860143,      2, 3,  "HUN W12.XXX"},
        {47.066385,   19.537183,      2, 3,  "HUN X12.XXX"},
        {47.066385,   20.214223,      2, 3,  "HUN Y12.XXX"},
        {47.066385,   20.891263,      2, 3,  "HUN Z12.XXX"},
        {46.654545,   21.568303,      2, 5,  "HUN 01.XXXX"},
        {46.409025,   16.151983,      2, 7,  "HUN 11.XXXX"},
        {46.163505,   16.826888,      2, 6,  "HUN 21.XXXX"},
        {46.163505,   17.493512,      2, 3,  "HUN 31.XXXX"},
        {46.163505,   18.160136,      2, 3,  "HUN 41.XXXX"},
        {46.163505,   18.82676,       2, 3,  "HUN 51.XXXX"},
        {46.163505,   19.493384,      2, 5,  "HUN 61.XXXX"},
        {46.1502835,  20.154435,      3, 6,  "HUN 71.XXXX"},
        {46.163505,   20.821059,      3, 8,  "HUN 81.XXXX"},
        {45.885585,   17.453123,      3, 6,  "HUN 9H.HHHH"},
        {45.885585,   18.119747,      3, 6,  "HUN BH.HHHH"},
        {45.885585,   18.786371,      3, 6,  "HUN CH.HHHH"},
        {45.885585,   19.452995,      3, 6,  "HUN DH.HHHH"},
        {46.135491,   20.121468,      4, 7,  "HUN 7123.XX"},
        {46.14381,    20.788035,      3, 8,  "HUN 8123.XX"},
        {46.117365,   17.465155,      3, 4,  "HUN 9HHH.HH"},
        {46.117365,   18.131779,      3, 4,  "HUN BHHH.HH"},
        {46.117365,   18.798403,      3, 4,  "HUN CHHH.HH"},
        {46.117365,   19.465027,      3, 6,  "HUN DHHH.HH"},
        {47.15665,    19.5025,        2, 3,  "HUN DBPK.J3J"},
        {37.591345,   126.9160275,    4, 5,  "KOR 12.XX"},
        {37.6404865,  126.6237475,    3, 6,  "KOR 12.XXX"},
        {35.172514,   129.02221,      3, 4,  "KOR 000.XX"},
        {35.851014,   128.598853375,  3, 4,  "KOR 200.XX"},
        {35.832667,   128.448345375,  3, 4,  "KOR 400.XX"},
        {36.322214,   127.32739175,   3, 4,  "KOR 600.XX"},
        {35.200224,   126.849719625,  3, 4,  "KOR 800.XX"},
        {35.200224,   126.744731625,  3, 4,  "KOR 900.XX"},
        {35.582424,   129.27738,      3, 4,  "KOR B00.XX"},
        {35.881524,   127.090341375,  3, 4,  "KOR C00.XX"},
        {36.676724,   127.42530275,   3, 4,  "KOR D00.XX"},
        {35.263824,   128.62418,      3, 4,  "KOR F00.XX"},
        {35.272473,   128.520585,     3, 4,  "KOR G00.XX"},
        {37.773924,   127.0087245,    3, 4,  "KOR H00.XX"},
        {36.062924,   129.309641375,  3, 4,  "KOR J00.XX"},
        {35.229824,   128.04428,      3, 4,  "KOR K00.XX"},
        {33.535024,   126.462223625,  3, 4,  "KOR L00.XX"},
        {36.854324,   127.080163125,  3, 4,  "KOR M00.XX"},
        {35.989324,   126.921141375,  3, 4,  "KOR N00.XX"},
        {36.153724,   128.306241375,  3, 4,  "KOR P00.XX"},
        {34.849824,   126.349919625,  3, 4,  "KOR Q00.XX"},
        {36.026324,   126.660341375,  3, 4,  "KOR R00.XX"},
        {37.911624,   127.686085875,  3, 4,  "KOR S00.XX"},
        {35.287424,   128.83938,      3, 4,  "KOR T00.XX"},
        {37.389624,   127.8942245,    3, 4,  "KOR V00.XX"},
        {35.005324,   127.460619625,  3, 4,  "KOR W00.XX"},
        {37.806724,   128.8600245,    3, 4,  "KOR X00.XX"},
        {37.027024,   127.877563125,  3, 4,  "KOR Y00.XX"},
        {35.896024,   129.161741375,  3, 4,  "KOR Z00.XX"},
        {38.579595,   126.9589945,    2, 5,  "KOR 012.XXX"},
        {38.579595,   127.5474985,    2, 5,  "KOR 112.XXX"},
        {38.579595,   128.1360015,    2, 5,  "KOR 212.XXX"},
        {37.965795,   124.5863305,    2, 4,  "KOR 312.XXX"},
        {37.793931,   125.6054355,    2, 6,  "KOR 412.XXX"},
        {38.088555,   126.1939395,    2, 5,  "KOR 512.XXX"},
        {38.088555,   126.7824435,    2, 5,  "KOR 612.XXX"},
        {38.088555,   127.3709475,    2, 3,  "KOR 712.XXX"},
        {38.088555,   127.9594515,    2, 3,  "KOR 812.XXX"},
        {38.088555,   128.5479555,    2, 3,  "KOR 912.XXX"},
        {37.597515,   125.958251,     3, 5,  "KOR B12.XXX"},
        {37.597515,   126.541547,     2, 3,  "KOR C12.XXX"},
        {37.597515,   127.124843,     3, 4,  "KOR D12.XXX"},
        {37.597515,   127.708139,     2, 3,  "KOR F12.XXX"},
        {37.597515,   128.291435,     2, 3,  "KOR G12.XXX"},
        {37.597515,   128.874731,     2, 3,  "KOR H12.XXX"},
        {37.106475,   125.6715245,    2, 3,  "KOR J12.XXX"},
        {37.106475,   126.2496125,    2, 3,  "KOR K12.XXX"},
        {37.106475,   126.8277005,    2, 3,  "KOR L12.XXX"},
        {37.106475,   127.4057885,    2, 3,  "KOR M12.XXX"},
        {37.106475,   127.9838765,    2, 3,  "KOR N12.XXX"},
        {37.106475,   128.5619645,    2, 3,  "KOR P12.XXX"},
        {37.106475,   129.1400525,    2, 3,  "KOR Q12.XXX"},
        {36.271707,   125.671238,     2, 3,  "KOR R12.XXX"},
        {36.615435,   126.244118,     2, 3,  "KOR S12.XXX"},
        {36.615435,   126.816998,     2, 3,  "KOR T12.XXX"},
        {36.615435,   127.389878,     2, 3,  "KOR V12.XXX"},
        {36.615435,   127.962758,     2, 3,  "KOR W12.XXX"},
        {36.615435,   128.535638,     2, 3,  "KOR X12.XXX"},
        {36.615435,   129.108518,     2, 3,  "KOR Y12.XXX"},
        {36.124395,   126.244118,     2, 3,  "KOR Z12.XXX"},
        {35.712555,   126.816998,     2, 3,  "KOR 01.XXXX"},
        {35.712555,   127.389878,     2, 3,  "KOR 11.XXXX"},
        {35.712555,   127.962758,     2, 3,  "KOR 21.XXXX"},
        {35.712555,   128.535638,     2, 3,  "KOR 31.XXXX"},
        {35.712555,   129.108518,     2, 3,  "KOR 41.XXXX"},
        {35.221515,   125.671238,     2, 3,  "KOR 51.XXXX"},
        {35.221515,   126.244118,     2, 3,  "KOR 61.XXXX"},
        {35.221515,   126.816998,     2, 3,  "KOR 71.XXXX"},
        {35.221515,   127.389878,     2, 3,  "KOR 81.XXXX"},
        {35.221515,   127.962758,     2, 3,  "KOR 91.XXXX"},
        {35.221515,   128.535638,     3, 4,  "KOR B1.XXXX"},
        {35.221515,   129.108518,     3, 4,  "KOR C1.XXXX"},
        {34.484955,   125.074349,     2, 3,  "KOR D1.XXXX"},
        {34.730475,   125.8620845,    2, 3,  "KOR F1.XXXX"},
        {34.730475,   126.4297565,    2, 3,  "KOR G1.XXXX"},
        {34.730475,   126.9974285,    2, 3,  "KOR H1.XXXX"},
        {34.730475,   127.5651005,    2, 3,  "KOR J1.XXXX"},
        {34.730475,   128.1327725,    2, 3,  "KOR K1.XXXX"},
        {34.730475,   128.7004445,    2, 5,  "KOR L1.XXXX"},
        {33.993915,   125.067058,     2, 3,  "KOR M1.XXXX"},
        {34.239435,   125.629522,     2, 3,  "KOR N1.XXXX"},
        {34.239435,   126.191986,     2, 3,  "KOR P1.XXXX"},
        {34.239435,   126.75445,      2, 3,  "KOR Q1.XXXX"},
        {34.239435,   127.316914,     2, 3,  "KOR R1.XXXX"},
        {34.239435,   127.879378,     2, 3,  "KOR S1.XXXX"},
        {34.239435,   128.441842,     2, 5,  "KOR T1.XXXX"},
        {33.748395,   126.276355,     2, 3,  "KOR V1.XXXX"},
        {33.748395,   126.838819,     2, 3,  "KOR W1.XXXX"},
        {33.133795,   126.0320345,    2, 3,  "KOR X1.XXXX"},
        {33.133795,   126.5892905,    2, 3,  "KOR Y1.XXXX"},
        {37.290375,   130.4011265,    2, 3,  "KOR Z1.XXXX"},
        {33.7636565,  127.373191,     2, 3,  "KOR Z123.XX"},
        {37.5562445,  126.9636,       4, 5,  "KOR C6J0.4C0"},
        {64.1524385,  -22.0257945,    4, 7,  "ISL 12.XX"},
        {63.8596345,  -22.0945,       3, 6,  "ISL 12.XXX"},
        {64.002714,   -22.751348375,  3, 6,  "ISL 000.XX"},
        {63.942114,   -21.195048375,  3, 4,  "ISL 200.XX"},
        {65.722124,   -18.202896375,  3, 4,  "ISL 400.XX"},
        {63.472124,   -20.359382125,  3, 4,  "ISL 500.XX"},
        {66.121024,   -23.220496375,  4, 7,  "ISL 600.XX"},
        {65.780724,   -19.758196375,  3, 4,  "ISL 700.XX"},
        {63.890724,   -22.540964375,  3, 6,  "ISL 800.XX"},
        {66.090724,   -17.395996375,  3, 4,  "ISL 900.XX"},
        {64.580724,   -21.9942675,    3, 6,  "ISL B00.XX"},
        {65.300724,   -14.4962755,    3, 4,  "ISL C00.XX"},
        {64.300724,   -15.3026595,    3, 4,  "ISL D00.XX"},
        {66.020724,   -18.678196375,  3, 4,  "ISL F00.XX"},
        {65.190724,   -13.7962755,    3, 4,  "ISL G00.XX"},
        {66.200724,   -19.030230125,  3, 4,  "ISL H00.XX"},
        {65.093424,   -22.8344675,    3, 6,  "ISL J00.XX"},
        {64.930724,   -23.8344675,    3, 6,  "ISL K00.XX"},
        {65.110724,   -14.0962755,    3, 4,  "ISL L00.XX"},
        {66.110724,   -18.748196375,  3, 4,  "ISL M00.XX"},
        {66.190724,   -23.370230125,  3, 6,  "ISL N00.XX"},
        {65.700724,   -20.408196375,  3, 4,  "ISL P00.XX"},
        {64.010724,   -22.460964375,  3, 6,  "ISL Q00.XX"},
        {64.960724,   -23.3644675,    3, 6,  "ISL R00.XX"},
        {63.790724,   -20.320964375,  4, 5,  "ISL S00.XX"},
        {65.290724,   -14.1162755,    3, 4,  "ISL T00.XX"},
        {65.070724,   -14.3144675,    3, 4,  "ISL V00.XX"},
        {65.620724,   -24.098196375,  3, 6,  "ISL W00.XX"},
        {63.870724,   -20.490964375,  3, 4,  "ISL X00.XX"},
        {64.970724,   -14.1144675,    3, 4,  "ISL Y00.XX"},
        {63.899624,   -21.178164375,  3, 4,  "ISL Z00.XX"},
        {66.2857385,  -23.170878,     2, 5,  "ISL 012.XXX"},
        {66.565974,   -16.5924265,    2, 3,  "ISL 112.XXX"},
        {66.565974,   -15.4414585,    2, 3,  "ISL 212.XXX"},
        {66.186275,   -24.2946435,    2, 5,  "ISL 312.XXX"},
        {66.186275,   -23.1645075,    3, 6,  "ISL 412.XXX"},
        {66.186275,   -22.0343715,    2, 5,  "ISL 512.XXX"},
        {66.186275,   -20.9042355,    2, 3,  "ISL 612.XXX"},
        {66.186275,   -19.7740995,    2, 3,  "ISL 712.XXX"},
        {66.186275,   -18.6439635,    2, 3,  "ISL 812.XXX"},
        {66.186275,   -17.5138275,    2, 3,  "ISL 912.XXX"},
        {66.186275,   -16.3836915,    2, 3,  "ISL B12.XXX"},
        {66.186275,   -15.2535555,    2, 3,  "ISL C12.XXX"},
        {65.695235,   -24.5114005,    2, 5,  "ISL D12.XXX"},
        {65.695235,   -23.4020965,    2, 5,  "ISL F12.XXX"},
        {65.695235,   -22.2927925,    2, 5,  "ISL G12.XXX"},
        {65.695235,   -21.1834885,    2, 3,  "ISL H12.XXX"},
        {65.695235,   -20.0741845,    2, 3,  "ISL J12.XXX"},
        {65.695235,   -18.9648805,    2, 3,  "ISL K12.XXX"},
        {65.695235,   -17.8555765,    2, 3,  "ISL L12.XXX"},
        {65.695235,   -16.7462725,    2, 3,  "ISL M12.XXX"},
        {65.695235,   -15.6369685,    2, 3,  "ISL N12.XXX"},
        {65.695235,   -14.5276645,    2, 3,  "ISL P12.XXX"},
        {65.105987,   -24.1582455,    2, 5,  "ISL Q12.XXX"},
        {65.204195,   -23.0697735,    2, 5,  "ISL R12.XXX"},
        {65.204195,   -21.9813015,    2, 5,  "ISL S12.XXX"},
        {65.204195,   -20.8928295,    2, 3,  "ISL T12.XXX"},
        {65.204195,   -19.8043575,    2, 3,  "ISL V12.XXX"},
        {65.204195,   -18.7158855,    2, 3,  "ISL W12.XXX"},
        {65.204195,   -17.6274135,    2, 3,  "ISL X12.XXX"},
        {65.204195,   -16.5389415,    2, 3,  "ISL Y12.XXX"},
        {65.204195,   -15.4504695,    2, 3,  "ISL Z12.XXX"},
        {64.792355,   -14.3619975,    2, 3,  "ISL 01.XXXX"},
        {64.301315,   -22.4291905,    2, 5,  "ISL 11.XXXX"},
        {64.301315,   -21.3615505,    3, 6,  "ISL 21.XXXX"},
        {64.301315,   -20.2939105,    2, 3,  "ISL 31.XXXX"},
        {64.301315,   -19.2262705,    2, 3,  "ISL 41.XXXX"},
        {64.301315,   -18.1586305,    2, 3,  "ISL 51.XXXX"},
        {64.301315,   -17.0909905,    2, 3,  "ISL 61.XXXX"},
        {64.301315,   -16.0233505,    2, 3,  "ISL 71.XXXX"},
        {64.301315,   -14.9557105,    2, 3,  "ISL 81.XXXX"},
        {63.810275,   -22.7935945,    2, 5,  "ISL 91.XXXX"},
        {63.810275,   -21.7467865,    2, 5,  "ISL B1.XXXX"},
        {63.810275,   -20.6999785,    2, 3,  "ISL C1.XXXX"},
        {63.810275,   -19.6531705,    2, 3,  "ISL D1.XXXX"},
        {63.810275,   -18.6063625,    2, 3,  "ISL F1.XXXX"},
        {63.810275,   -17.5595545,    2, 3,  "ISL G1.XXXX"},
        {63.810275,   -16.5127465,    2, 3,  "ISL H1.XXXX"},
        {63.810275,   -15.4659385,    2, 3,  "ISL J1.XXXX"},
        {63.319235,   -21.0047505,    2, 3,  "ISL K1.XXXX"},
        {63.319235,   -19.9787745,    2, 3,  "ISL L1.XXXX"},
        {63.319235,   -18.9527985,    2, 3,  "ISL M1.XXXX"},
        {63.319235,   -17.9268225,    2, 3,  "ISL N1.XXXX"},
        {67.7252055,  -24.8554185,    1, 4,  "ISL 1234.XXX"},
        {14.6651,     -90.566629,     4, 5,  "GTM 12.XX"},
        {14.779711,   -90.848892,     3, 4,  "GTM 12.XXX"},
        {14.885324,   -91.5677355,    4, 5,  "GTM 000.XX"},
        {14.340724,   -90.819822625,  4, 5,  "GTM 100.XX"},
        {15.359824,   -91.530048375,  3, 4,  "GTM 200.XX"},
        {15.750024,   -88.629148375,  3, 4,  "GTM 300.XX"},
        {15.510124,   -90.426448375,  3, 4,  "GTM 400.XX"},
        {14.945424,   -91.4091355,    4, 5,  "GTM 500.XX"},
        {14.742924,   -91.906322625,  3, 9,  "GTM 600.XX"},
        {14.560024,   -91.531022625,  3, 4,  "GTM 700.XX"},
        {14.583724,   -91.710122625,  3, 9,  "GTM 800.XX"},
        {14.951624,   -91.4923355,    3, 4,  "GTM 900.XX"},
        {15.007424,   -91.8318355,    3, 9,  "GTM B00.XX"},
        {14.798324,   -91.2104355,    3, 4,  "GTM C00.XX"},
        {15.004624,   -89.5986355,    3, 4,  "GTM D00.XX"},
        {14.331524,   -89.934522625,  3, 6,  "GTM F00.XX"},
        {16.948324,   -89.950088,     3, 6,  "GTM G00.XX"},
        {14.444524,   -90.306022625,  3, 4,  "GTM H00.XX"},
        {15.084224,   -91.4534355,    3, 4,  "GTM J00.XX"},
        {14.927624,   -91.6495355,    3, 8,  "GTM K00.XX"},
        {15.070724,   -91.1920355,    3, 4,  "GTM L00.XX"},
        {14.851824,   -91.6886355,    3, 8,  "GTM M00.XX"},
        {14.742464,   -90.9119455,    3, 4,  "GTM N00.XX"},
        {15.414204,   -91.177395375,  3, 4,  "GTM NK0.00"},
        {14.582464,   -89.381858875,  4, 5,  "GTM P00.XX"},
        {15.093004,   -90.3433235,    3, 4,  "GTM PK0.00"},
        {14.783464,   -91.0149455,    3, 4,  "GTM Q00.XX"},
        {13.932945,   -90.82531625,   3, 4,  "GTM QK0.00"},
        {14.112264,   -91.09067325,   3, 4,  "GTM R00.XX"},
        {14.677104,   -91.039850625,  3, 4,  "GTM RK0.00"},
        {14.850864,   -91.4823455,    4, 5,  "GTM S00.XX"},
        {14.833704,   -91.3633235,    3, 4,  "GTM SK0.00"},
        {14.302064,   -91.399558875,  3, 4,  "GTM T00.XX"},
        {15.364304,   -90.481895375,  3, 4,  "GTM TK0.00"},
        {14.672864,   -90.846158875,  4, 5,  "GTM V00.XX"},
        {14.180304,   -91.330150625,  3, 4,  "GTM VK0.00"},
        {14.352164,   -91.049158875,  3, 4,  "GTM W00.XX"},
        {14.931804,   -91.1371235,    3, 4,  "GTM WK0.00"},
        {14.649464,   -90.022758875,  3, 4,  "GTM X00.XX"},
        {14.795204,   -89.5698235,    4, 5,  "GTM XK0.00"},
        {14.651764,   -91.261558875,  3, 4,  "GTM Y00.XX"},
        {15.665904,   -91.734495375,  3, 9,  "GTM YK0.00"},
        {15.098264,   -90.5252455,    3, 4,  "GTM Z00.XX"},
        {15.105204,   -90.6525235,    3, 4,  "GTM ZK0.00"},
        {17.686359,   -90.843413,     2, 8,  "GTM 0HH.HHH"},
        {17.686359,   -90.353861,     2, 5,  "GTM 1HH.HHH"},
        {17.686359,   -89.864309,     2, 5,  "GTM 2HH.HHH"},
        {17.686359,   -89.374757,     2, 5,  "GTM 3HH.HHH"},
        {17.394039,   -91.552173,     2, 14, "GTM 412.XXX"},
        {17.394039,   -91.062621,     2, 14, "GTM 512.XXX"},
        {17.394039,   -90.573069,     2, 8,  "GTM 612.XXX"},
        {17.394039,   -90.083517,     2, 5,  "GTM 712.XXX"},
        {17.394039,   -89.593965,     2, 3,  "GTM 812.XXX"},
        {16.902999,   -91.0576995,    2, 10, "GTM 912.XXX"},
        {16.902999,   -90.5733555,    2, 8,  "GTM B12.XXX"},
        {16.902999,   -90.0890115,    2, 5,  "GTM C12.XXX"},
        {16.902999,   -89.6046675,    2, 3,  "GTM D12.XXX"},
        {16.411959,   -92.0263875,    2, 12, "GTM F12.XXX"},
        {16.411959,   -91.5420435,    2, 10, "GTM G12.XXX"},
        {16.411959,   -91.0576995,    2, 10, "GTM H12.XXX"},
        {16.411959,   -90.5733555,    2, 8,  "GTM J12.XXX"},
        {16.411959,   -90.0890115,    2, 5,  "GTM K12.XXX"},
        {16.411959,   -89.6046675,    2, 3,  "GTM L12.XXX"},
        {15.920919,   -92.0748225,    2, 8,  "GTM M12.XXX"},
        {15.920919,   -91.5904785,    2, 3,  "GTM N12.XXX"},
        {15.920919,   -91.1061345,    2, 3,  "GTM P12.XXX"},
        {15.920919,   -90.6217905,    2, 3,  "GTM Q12.XXX"},
        {15.920919,   -90.1374465,    2, 3,  "GTM R12.XXX"},
        {15.920919,   -89.6531025,    2, 3,  "GTM S12.XXX"},
        {15.920919,   -89.1687585,    2, 5,  "GTM T12.XXX"},
        {15.920919,   -88.6844145,    2, 5,  "GTM V12.XXX"},
        {15.429879,   -92.2093555,    2, 8,  "GTM W12.XXX"},
        {15.429879,   -91.7357815,    2, 8,  "GTM X12.XXX"},
        {15.429879,   -91.2514375,    2, 3,  "GTM Y12.XXX"},
        {15.429879,   -90.7670935,    2, 3,  "GTM Z12.XXX"},
        {15.018039,   -90.2827495,    2, 3,  "GTM 01.XXXX"},
        {15.018039,   -89.7984055,    2, 3,  "GTM 11.XXXX"},
        {15.018039,   -89.3140615,    2, 3,  "GTM 21.XXXX"},
        {15.018039,   -88.8297175,    2, 5,  "GTM 31.XXXX"},
        {14.526999,   -92.209642,     2, 3,  "GTM 41.XXXX"},
        {14.526999,   -91.741276,     2, 3,  "GTM 51.XXXX"},
        {14.526999,   -91.26214,      2, 3,  "GTM 61.XXXX"},
        {14.526999,   -90.783004,     3, 4,  "GTM 71.XXXX"},
        {14.526999,   -90.303868,     2, 3,  "GTM 81.XXXX"},
        {14.526999,   -89.824732,     2, 3,  "GTM 91.XXXX"},
        {14.526999,   -89.580373,     3, 4,  "GTM B1.XXXX"},
        {14.035959,   -92.153333,     2, 3,  "GTM C1.XXXX"},
        {14.035959,   -91.674197,     2, 3,  "GTM D1.XXXX"},
        {14.035959,   -91.195061,     2, 3,  "GTM F1.XXXX"},
        {14.035959,   -90.715925,     2, 3,  "GTM G1.XXXX"},
        {14.035959,   -90.236789,     2, 3,  "GTM H1.XXXX"},
        {14.035959,   -89.757653,     2, 5,  "GTM J1.XXXX"},
        {13.544919,   -91.813146,     2, 3,  "GTM K1.XXXX"},
        {13.544919,   -91.33401,      2, 3,  "GTM L1.XXXX"},
        {13.544919,   -90.854874,     2, 3,  "GTM M1.XXXX"},
        {13.544919,   -90.375738,     2, 3,  "GTM N1.XXXX"},
        {15.66,       -90.224529,     2, 3,  "GTM 44MW.XTF"},
        {23.139153,   -82.4303565,    4, 6,  "CUB 12.XX"},
        {23.124075,   -82.52698125,   3, 5,  "CUB 00.XXX"},
        {19.973594,   -75.918347875,  3, 5,  "CUB 70.XXX"},
        {21.320094,   -78.02602225,   3, 6,  "CUB F0.XXX"},
        {20.814294,   -76.36304,      3, 5,  "CUB M0.XXX"},
        {22.342894,   -80.0899045,    3, 6,  "CUB T0.XXX"},
        {20.186324,   -75.246278125,  3, 5,  "CUB 000.XX"},
        {20.418924,   -76.685778125,  3, 5,  "CUB 100.XX"},
        {22.456624,   -83.7417435,    3, 5,  "CUB 200.XX"},
        {22.199024,   -80.4926435,    3, 6,  "CUB 300.XX"},
        {23.066545,   -81.61985625,   3, 5,  "CUB 400.XX"},
        {20.975545,   -77.01176,      3, 6,  "CUB 500.XX"},
        {21.978824,   -79.498530625,  3, 6,  "CUB 600.XX"},
        {20.357224,   -77.162978125,  3, 5,  "CUB 700.XX"},
        {20.260724,   -76.043278125,  3, 5,  "CUB 800.XX"},
        {21.886124,   -78.805530625,  3, 6,  "CUB 900.XX"},
        {23.047064,   -81.24989075,   3, 5,  "CUB B00.XX"},
        {21.175004,   -76.60983675,   3, 6,  "CUB BK0.00"},
        {20.303364,   -76.280089375,  3, 5,  "CUB C00.XX"},
        {20.654104,   -75.717792,     3, 5,  "CUB CK0.00"},
        {22.727464,   -80.92969075,   3, 5,  "CUB D00.XX"},
        {20.640804,   -74.963292,     3, 5,  "CUB DK0.00"},
        {22.515564,   -83.5531195,    3, 5,  "CUB F00.XX"},
        {22.816604,   -82.79672625,   3, 5,  "CUB FK0.00"},
        {22.856064,   -82.05869075,   3, 5,  "CUB G00.XX"},
        {20.181204,   -75.858219125,  3, 5,  "CUB GK0.00"},
        {22.718164,   -83.07209075,   3, 5,  "CUB H00.XX"},
        {20.334204,   -74.528019125,  3, 5,  "CUB HK0.00"},
        {22.979464,   -82.18589075,   3, 5,  "CUB J00.XX"},
        {21.777304,   -80.008208625,  3, 6,  "CUB JK0.00"},
        {22.114564,   -78.6591195,    3, 6,  "CUB K00.XX"},
        {22.513804,   -81.1592815,    3, 5,  "CUB KK0.00"},
        {22.818664,   -80.11769075,   3, 6,  "CUB L00.XX"},
        {21.544004,   -77.295308625,  3, 6,  "CUB LK0.00"},
        {21.537764,   -78.25764725,   3, 6,  "CUB M00.XX"},
        {22.795604,   -81.22152625,   3, 5,  "CUB MK0.00"},
        {22.592064,   -80.26939075,   3, 6,  "CUB N00.XX"},
        {22.370104,   -80.1880815,    3, 6,  "CUB NK0.00"},
        {22.322564,   -79.6872195,    3, 6,  "CUB P00.XX"},
        {22.336604,   -79.2627815,    3, 6,  "CUB PK0.00"},
        {20.972464,   -75.752976,     3, 7,  "CUB Q00.XX"},
        {21.044104,   -77.37793675,   3, 6,  "CUB QK0.00"},
        {22.799064,   -81.58149075,   3, 5,  "CUB R00.XX"},
        {22.144104,   -80.2280815,    3, 6,  "CUB RK0.00"},
        {20.382464,   -76.462889375,  3, 5,  "CUB S00.XX"},
        {20.720804,   -78.024792,     3, 5,  "CUB SK0.00"},
        {22.082164,   -79.5184195,    3, 6,  "CUB T00.XX"},
        {22.493904,   -79.5498815,    3, 6,  "CUB TK0.00"},
        {20.182464,   -75.682889375,  3, 5,  "CUB V00.XX"},
        {22.967804,   -82.59682625,   3, 5,  "CUB VK0.00"},
        {22.490864,   -79.7695195,    3, 6,  "CUB W00.XX"},
        {22.144104,   -79.9980815,    3, 6,  "CUB WK0.00"},
        {22.892464,   -82.53349075,   3, 5,  "CUB X00.XX"},
        {22.514104,   -79.4980815,    4, 7,  "CUB XK0.00"},
        {22.662464,   -80.08349075,   3, 6,  "CUB Y00.XX"},
        {21.766704,   -79.297508625,  3, 6,  "CUB YK0.00"},
        {22.986164,   -82.41989075,   3, 5,  "CUB Z00.XX"},
        {22.777204,   -81.94202625,   3, 5,  "CUB ZK0.00"},
        {19.910534,   -77.6215155,    2, 4,  "CUB 1234.XX"},
        {22.2939765,  -84.8568235,    2, 4,  "CUB 123.XXX"},
        {22.9566885,  -80.318594,     2, 5,  "CUB 12.XXXX"},
        {23.0451515,  -84.578048,     2, 4,  "CUB 1234.XXX"},
        {42.7331,     23.272638,      4, 5,  "BGR 12.XX"},
        {42.593915,   23.014793,      3, 4,  "BGR 00.XXX"},
        {42.112224,   24.6107865,     3, 4,  "BGR C0.XXX"},
        {43.330115,   27.5463375,     3, 4,  "BGR P0.XXX"},
        {42.526845,   27.3953025,     3, 4,  "BGR 000.XX"},
        {43.888924,   25.916552,      3, 6,  "BGR 100.XX"},
        {42.450115,   25.5818025,     3, 4,  "BGR 200.XX"},
        {43.457724,   24.5614045,     3, 4,  "BGR 300.XX"},
        {42.699824,   26.267356,      3, 4,  "BGR 400.XX"},
        {43.616024,   27.763552,      3, 4,  "BGR 500.XX"},
        {43.288224,   26.8885045,     3, 4,  "BGR 600.XX"},
        {41.991324,   25.49396,       3, 4,  "BGR 700.XX"},
        {42.247424,   24.2696085,     3, 4,  "BGR 800.XX"},
        {42.541924,   26.4416085,     3, 4,  "BGR 900.XX"},
        {42.064824,   23.0158085,     3, 6,  "BGR B00.XX"},
        {43.113124,   25.5569045,     3, 4,  "BGR C00.XX"},
        {42.923724,   25.262656,      3, 4,  "BGR D00.XX"},
        {43.260724,   23.5068045,     3, 4,  "BGR F00.XX"},
        {42.674424,   25.327556,      3, 4,  "BGR G00.XX"},
        {44.042624,   22.806552,      3, 6,  "BGR H00.XX"},
        {42.288545,   22.6496885,     3, 6,  "BGR J00.XX"},
        {43.411204,   23.2142915,     3, 4,  "BGR JK0.00"},
        {42.071664,   25.5695365,     3, 4,  "BGR K00.XX"},
        {41.625004,   25.34446,       4, 5,  "BGR KK0.00"},
        {43.265764,   26.5129495,     3, 4,  "BGR L00.XX"},
        {43.145504,   24.6796915,     3, 4,  "BGR LK0.00"},
        {42.279364,   23.0892365,     3, 4,  "BGR M00.XX"},
        {44.088504,   27.211340625,   3, 6,  "BGR MK0.00"},
        {43.144064,   25.6644495,     3, 4,  "BGR N00.XX"},
        {43.535904,   26.4714915,     3, 4,  "BGR NK0.00"},
        {41.604664,   24.65878,       3, 4,  "BGR P00.XX"},
        {43.597904,   25.321702,      3, 4,  "BGR PK0.00"},
        {41.407545,   23.1242515,     3, 6,  "BGR Q00.XX"},
        {42.343004,   23.4952705,     3, 4,  "BGR QK0.00"},
        {41.559664,   23.23008,       3, 4,  "BGR R00.XX"},
        {42.666105,   24.727503,      3, 4,  "BGR RK0.00"},
        {42.491264,   25.9625365,     3, 4,  "BGR S00.XX"},
        {42.022555,   23.9713975,     3, 4,  "BGR SK0.00"},
        {43.045564,   25.0844495,     3, 4,  "BGR T00.XX"},
        {42.713804,   27.221381,      3, 4,  "BGR TK0.00"},
        {42.912264,   23.779093,      3, 4,  "BGR V00.XX"},
        {41.918804,   25.87416,       3, 5,  "BGR VK0.00"},
        {42.664164,   26.938793,      3, 4,  "BGR W00.XX"},
        {43.323204,   26.2087915,     3, 4,  "BGR WK0.00"},
        {42.045364,   24.2666365,     3, 4,  "BGR X00.XX"},
        {41.568104,   23.68926,       3, 4,  "BGR XK0.00"},
        {42.522464,   24.138093,      3, 4,  "BGR Y00.XX"},
        {43.271504,   24.0725915,     3, 4,  "BGR YK0.00"},
        {42.212464,   25.2884365,     3, 4,  "BGR Z00.XX"},
        {41.769904,   26.14566,       3, 5,  "BGR ZK0.00"},
        {44.170491,   22.385526,      2, 5,  "BGR 112.XXX"},
        {44.170491,   23.031318,      2, 5,  "BGR 212.XXX"},
        {44.170491,   23.67711,       2, 5,  "BGR 312.XXX"},
        {44.170491,   25.614485,      2, 5,  "BGR 412.XXX"},
        {44.170491,   26.260277,      2, 5,  "BGR 512.XXX"},
        {44.170491,   26.906069,      2, 5,  "BGR 612.XXX"},
        {44.170491,   27.551861,      2, 5,  "BGR 712.XXX"},
        {43.679451,   22.3904465,     2, 5,  "BGR 812.XXX"},
        {43.679451,   23.0310305,     2, 3,  "BGR 912.XXX"},
        {43.679451,   23.6716145,     2, 5,  "BGR B12.XXX"},
        {43.732135,   24.31348,       2, 5,  "BGR C12.XXX"},
        {43.679451,   24.9527825,     2, 5,  "BGR D12.XXX"},
        {43.679451,   25.5933665,     2, 5,  "BGR F12.XXX"},
        {43.679451,   26.2339505,     2, 3,  "BGR G12.XXX"},
        {43.679451,   26.8745345,     2, 3,  "BGR H12.XXX"},
        {43.679451,   27.5151185,     2, 3,  "BGR J12.XXX"},
        {43.777659,   28.1557025,     3, 6,  "BGR K12.XXX"},
        {43.188411,   22.39016,       2, 5,  "BGR L12.XXX"},
        {43.188411,   23.025536,      2, 3,  "BGR M12.XXX"},
        {43.188411,   23.660912,      2, 3,  "BGR N12.XXX"},
        {43.188411,   24.296288,      2, 3,  "BGR P12.XXX"},
        {43.188411,   24.931664,      2, 3,  "BGR Q12.XXX"},
        {43.188411,   25.56704,       2, 3,  "BGR R12.XXX"},
        {43.188411,   26.202416,      2, 3,  "BGR S12.XXX"},
        {43.188411,   26.837792,      2, 3,  "BGR T12.XXX"},
        {43.188411,   27.473168,      2, 3,  "BGR V12.XXX"},
        {42.697371,   22.3950815,     2, 5,  "BGR W12.XXX"},
        {42.697371,   23.0252495,     3, 4,  "BGR X12.XXX"},
        {42.697371,   23.6554175,     2, 3,  "BGR Y12.XXX"},
        {42.697371,   24.2855855,     2, 3,  "BGR Z12.XXX"},
        {42.285531,   24.9157535,     2, 3,  "BGR 01.XXXX"},
        {42.285531,   25.5459215,     2, 3,  "BGR 11.XXXX"},
        {42.285531,   26.1760895,     2, 3,  "BGR 21.XXXX"},
        {42.285531,   26.8062575,     2, 3,  "BGR 31.XXXX"},
        {42.285531,   27.4364255,     2, 3,  "BGR 41.XXXX"},
        {41.794491,   22.470416,      2, 5,  "BGR 51.XXXX"},
        {41.794491,   23.095376,      2, 3,  "BGR 61.XXXX"},
        {41.794491,   23.720336,      2, 3,  "BGR 71.XXXX"},
        {41.794491,   24.345296,      2, 3,  "BGR 81.XXXX"},
        {41.794491,   24.970256,      2, 3,  "BGR 91.XXXX"},
        {41.794491,   25.595216,      2, 3,  "BGR B1.XXXX"},
        {41.794491,   26.220176,      3, 5,  "BGR C1.XXXX"},
        {41.794491,   26.845136,      2, 5,  "BGR D1.XXXX"},
        {41.794491,   27.470096,      2, 5,  "BGR F1.XXXX"},
        {41.303451,   22.7565695,     2, 7,  "BGR G1.XXXX"},
        {41.303451,   23.3763215,     2, 5,  "BGR H1.XXXX"},
        {41.303451,   23.9960735,     2, 5,  "BGR J1.XXXX"},
        {41.303451,   24.6158255,     2, 5,  "BGR K1.XXXX"},
        {41.3319045,  25.2349525,     3, 4,  "BGR L1.XXXX"},
        {41.326131,   25.802639,      3, 7,  "BGR M1.XXXX"},
        {41.2866245,  25.2048755,     3, 6,  "BGR P123.XX"},
        {41.304823,   25.773249,      3, 7,  "BGR Q123.XX"},
        {42.747,      25.485,         2, 3,  "BGR QQYH.2MH"},
        {6.34405,     -10.813195,     4, 5,  "LBR 12.XX"},
        {6.455495,    -10.8260015,    3, 4,  "LBR 12.XXX"},
        {6.064195,    -8.20525075,    3, 6,  "LBR 000.XX"},
        {5.887794,    -10.09365075,   3, 4,  "LBR 300.XX"},
        {7.555472,    -8.628396625,   4, 7,  "LBR 600.XX"},
        {6.990515,    -9.551618625,   3, 4,  "LBR 900.XX"},
        {4.402208,    -7.791917875,   3, 5,  "LBR C00.XX"},
        {6.870314,    -10.864618625,  3, 4,  "LBR F00.XX"},
        {5.005208,    -9.075630875,   3, 4,  "LBR H00.XX"},
        {7.205686,    -9.046778625,   3, 6,  "LBR K00.XX"},
        {4.660515,    -8.281278875,   4, 6,  "LBR M00.XX"},
        {8.400515,    -9.821618625,   3, 6,  "LBR P00.XX"},
        {6.717914,    -11.38694875,   3, 4,  "LBR R00.XX"},
        {6.475769,    -8.93017875,    3, 4,  "LBR T00.XX"},
        {7.343107,    -8.774103625,   3, 6,  "LBR W00.XX"},
        {5.433775,    -9.62432675,    3, 4,  "LBR Y00.XX"},
        {8.509563,    -10.55891,      2, 7,  "LBR 212.XXX"},
        {8.509563,    -10.090191,     2, 6,  "LBR 312.XXX"},
        {8.509563,    -9.621471,      2, 5,  "LBR 412.XXX"},
        {8.018523,    -11.027631,     2, 7,  "LBR 512.XXX"},
        {8.018523,    -10.558911,     2, 5,  "LBR 612.XXX"},
        {8.018523,    -10.090191,     2, 5,  "LBR 712.XXX"},
        {8.018523,    -9.621471,      2, 5,  "LBR 812.XXX"},
        {7.527483,    -11.49635,      2, 6,  "LBR B12.XXX"},
        {7.527483,    -11.02763,      2, 7,  "LBR C12.XXX"},
        {7.527483,    -10.55891,      2, 5,  "LBR D12.XXX"},
        {7.527483,    -10.09019,      2, 5,  "LBR F12.XXX"},
        {7.527483,    -9.62147,       2, 5,  "LBR G12.XXX"},
        {7.527483,    -9.15275,       2, 5,  "LBR H12.XXX"},
        {7.527483,    -8.68403,       3, 6,  "LBR J12.XXX"},
        {7.036443,    -11.49635,      2, 5,  "LBR K12.XXX"},
        {7.036443,    -11.02763,      2, 3,  "LBR L12.XXX"},
        {7.036443,    -10.55891,      2, 3,  "LBR M12.XXX"},
        {7.036443,    -10.09019,      2, 3,  "LBR N12.XXX"},
        {7.036443,    -9.62147,       2, 3,  "LBR P12.XXX"},
        {7.036443,    -9.15275,       2, 3,  "LBR Q12.XXX"},
        {7.036443,    -8.68403,       2, 3,  "LBR R12.XXX"},
        {6.545403,    -11.074502,     2, 3,  "LBR S12.XXX"},
        {6.545403,    -10.605782,     3, 4,  "LBR T12.XXX"},
        {6.545403,    -10.137062,     2, 3,  "LBR V12.XXX"},
        {6.545403,    -9.668342,      2, 3,  "LBR W12.XXX"},
        {6.545403,    -9.199622,      2, 3,  "LBR X12.XXX"},
        {6.545403,    -8.730902,      2, 3,  "LBR Y12.XXX"},
        {6.545403,    -8.262182,      2, 4,  "LBR Z12.XXX"},
        {7.664974,    -8.730903,      2, 5,  "LBR 912.XXX"},
        {5.642523,    -10.622187,     2, 3,  "LBR B1.XXXX"},
        {5.642523,    -10.153467,     2, 3,  "LBR C1.XXXX"},
        {5.642523,    -9.684747,      2, 3,  "LBR D1.XXXX"},
        {5.642523,    -9.216027,      2, 3,  "LBR F1.XXXX"},
        {5.642523,    -8.747307,      2, 3,  "LBR G1.XXXX"},
        {5.642523,    -8.278587,      2, 4,  "LBR H1.XXXX"},
        {5.642523,    -7.809867,      2, 4,  "LBR K1.XXXX"},
        {5.151483,    -10.153466,     2, 3,  "LBR L1.XXXX"},
        {5.151483,    -9.684746,      2, 3,  "LBR M1.XXXX"},
        {5.151483,    -9.216026,      2, 3,  "LBR P1.XXXX"},
        {5.151483,    -8.747306,      2, 3,  "LBR Q1.XXXX"},
        {5.151483,    -8.278586,      2, 4,  "LBR R1.XXXX"},
        {5.151483,    -7.809866,      2, 4,  "LBR S1.XXXX"},
        {4.660443,    -9.333206,      2, 3,  "LBR T1.XXXX"},
        {4.660443,    -8.864486,      2, 3,  "LBR V1.XXXX"},
        {4.660443,    -8.395766,      3, 5,  "LBR W1.XXXX"},
        {4.660443,    -7.927046,      3, 5,  "LBR X1.XXXX"},
        {4.373795,    -8.395766,      2, 4,  "LBR Y1.XXXX"},
        {4.373795,    -7.927046,      2, 4,  "LBR Z1.XXXX"},
        {6.4548385,   -9.433889,      2, 3,  "LBR C3R5.RWF"},
        {14.1182,     -87.248732,     4, 5,  "HND 12.XX"},
        {15.623652,   -88.1903575,    3, 4,  "HND 12.XXX"},
        {14.063114,   -87.26890675,   3, 4,  "HND 000.XX"},
        {15.784334,   -86.86336625,   3, 4,  "HND 200.XX"},
        {13.350424,   -87.21080975,   3, 4,  "HND 300.XX"},
        {14.500724,   -87.672822625,  3, 4,  "HND 400.XX"},
        {15.867124,   -87.96256125,   3, 4,  "HND 500.XX"},
        {14.083624,   -86.61160975,   3, 6,  "HND 600.XX"},
        {14.627224,   -87.885422625,  3, 4,  "HND 700.XX"},
        {14.710724,   -86.271922625,  3, 4,  "HND 800.XX"},
        {14.869724,   -85.9402355,    3, 4,  "HND 900.XX"},
        {15.788545,   -87.53776625,   3, 4,  "HND B00.XX"},
        {15.682124,   -86.052248375,  3, 4,  "HND C00.XX"},
        {14.810724,   -88.8220355,    3, 4,  "HND D00.XX"},
        {15.520724,   -86.622148375,  3, 4,  "HND F00.XX"},
        {13.481524,   -87.51660975,   3, 4,  "HND G00.XX"},
        {13.900724,   -86.60180975,   3, 6,  "HND H00.XX"},
        {14.389424,   -87.720722625,  3, 6,  "HND J00.XX"},
        {15.170724,   -87.1720355,    3, 4,  "HND K00.XX"},
        {15.071624,   -88.8086355,    3, 6,  "HND L00.XX"},
        {14.961124,   -88.2968355,    3, 4,  "HND M00.XX"},
        {14.440724,   -87.131922625,  3, 4,  "HND N00.XX"},
        {13.566124,   -87.50420975,   3, 4,  "HND P00.XX"},
        {14.360724,   -88.211922625,  3, 6,  "HND Q00.XX"},
        {14.570024,   -86.899722625,  3, 4,  "HND R00.XX"},
        {15.333924,   -87.639948375,  4, 5,  "HND S00.XX"},
        {16.350424,   -86.596674125,  3, 4,  "HND T00.XX"},
        {15.660724,   -86.322148375,  3, 4,  "HND V00.XX"},
        {14.732324,   -88.006322625,  3, 4,  "HND W00.XX"},
        {14.190724,   -88.08180975,   3, 6,  "HND X00.XX"},
        {15.572024,   -86.290948375,  3, 4,  "HND Y00.XX"},
        {15.345724,   -87.718048375,  3, 4,  "HND Z00.XX"},
        {17.200838,   -84.144465,     2, 3,  "HND W1.XXXX"},
        {16.073203,   -87.1462035,    2, 3,  "HND X1.XXXX"},
        {16.073203,   -86.6618595,    2, 3,  "HND Y1.XXXX"},
        {16.073203,   -86.1775155,    2, 3,  "HND Z1.XXXX"},
        {15.994003,   -88.4028935,    2, 5,  "HND 012.XXX"},
        {15.994003,   -87.9185495,    2, 5,  "HND 112.XXX"},
        {15.994003,   -87.4342055,    2, 5,  "HND 212.XXX"},
        {15.994003,   -86.9498615,    2, 3,  "HND 312.XXX"},
        {15.994003,   -86.4655175,    2, 3,  "HND 412.XXX"},
        {15.994003,   -85.9811735,    2, 3,  "HND 512.XXX"},
        {15.994003,   -85.4968295,    2, 3,  "HND 612.XXX"},
        {15.994003,   -85.0124855,    2, 3,  "HND 712.XXX"},
        {15.994003,   -84.5281415,    2, 3,  "HND 812.XXX"},
        {15.994003,   -84.0437975,    2, 3,  "HND 912.XXX"},
        {15.502963,   -88.7903685,    2, 5,  "HND C12.XXX"},
        {15.502963,   -89.2747125,    2, 5,  "HND B12.XXX"},
        {15.502963,   -88.3060245,    2, 5,  "HND D12.XXX"},
        {15.502963,   -87.8216805,    3, 4,  "HND F12.XXX"},
        {15.502963,   -87.3373365,    2, 3,  "HND G12.XXX"},
        {15.502963,   -86.8529925,    2, 3,  "HND H12.XXX"},
        {15.502963,   -86.3686485,    2, 3,  "HND J12.XXX"},
        {15.502963,   -85.8843045,    2, 3,  "HND K12.XXX"},
        {15.502963,   -85.3999605,    2, 3,  "HND L12.XXX"},
        {15.502963,   -84.9156165,    2, 3,  "HND M12.XXX"},
        {15.502963,   -84.4312725,    2, 3,  "HND N12.XXX"},
        {15.502963,   -83.9469285,    2, 3,  "HND P12.XXX"},
        {15.257442,   -83.4625845,    2, 3,  "HND Q12.XXX"},
        {15.011923,   -87.763845,     2, 3,  "HND V12.XXX"},
        {15.011923,   -88.242981,     2, 3,  "HND T12.XXX"},
        {15.011923,   -88.722117,     3, 6,  "HND S12.XXX"},
        {15.011923,   -89.201253,     2, 5,  "HND R12.XXX"},
        {15.011923,   -87.284709,     2, 3,  "HND W12.XXX"},
        {15.011923,   -86.805573,     2, 3,  "HND X12.XXX"},
        {15.011923,   -86.326437,     2, 3,  "HND Y12.XXX"},
        {15.011923,   -85.847301,     2, 3,  "HND Z12.XXX"},
        {14.580388,   -85.391901,     2, 5,  "HND 0123.XX"},
        {14.580388,   -84.912765,     2, 5,  "HND 1123.XX"},
        {14.580388,   -84.433629,     2, 5,  "HND 2123.XX"},
        {14.580388,   -83.954493,     2, 5,  "HND 3123.XX"},
        {14.089348,   -85.516477,     2, 5,  "HND D123.XX"},
        {14.089348,   -89.349565,     2, 7,  "HND 4123.XX"},
        {14.089348,   -88.870429,     2, 5,  "HND 5123.XX"},
        {14.089348,   -88.391293,     2, 5,  "HND 6123.XX"},
        {14.089348,   -87.912157,     2, 5,  "HND 7123.XX"},
        {14.089348,   -87.433021,     2, 3,  "HND 8123.XX"},
        {14.089348,   -86.953885,     2, 3,  "HND 9123.XX"},
        {14.089348,   -86.474749,     2, 5,  "HND B123.XX"},
        {14.089348,   -85.995613,     2, 5,  "HND C123.XX"},
        {13.598308,   -88.774602,     2, 5,  "HND F123.XX"},
        {13.598308,   -88.295466,     2, 5,  "HND G123.XX"},
        {13.598308,   -87.81633,      2, 5,  "HND H123.XX"},
        {13.598308,   -87.337194,     2, 3,  "HND J123.XX"},
        {13.598308,   -86.858058,     2, 5,  "HND K123.XX"},
        {13.598308,   -86.378922,     2, 5,  "HND L123.XX"},
        {13.598308,   -85.899786,     2, 5,  "HND M123.XX"},
        {13.104553,   -88.055898,     2, 5,  "HND N123.XX"},
        {13.104553,   -87.576762,     2, 5,  "HND P123.XX"},
        {13.104553,   -87.097626,     2, 5,  "HND Q123.XX"},
        {13.041553,   -87.810362,     2, 5,  "HND RHHH.HH"},
        {13.041553,   -87.331226,     2, 5,  "HND SHHH.HH"},
        {13.041553,   -86.85209,      2, 5,  "HND THHH.HH"},
        {15.24245,    -86.1775,       2, 3,  "HND DCKR.593"},
        {6.351898,    2.3472725,      4, 5,  "BEN 12.XX"},
        {6.492845,    2.0684635,      3, 4,  "BEN 12.XXX"},
        {9.395346,    2.5402275,      3, 4,  "BEN 000.XX"},
        {9.395346,    2.6066565,      3, 4,  "BEN 100.XX"},
        {9.745926,    1.631756625,    3, 5,  "BEN 200.XX"},
        {7.220226,    2.039682375,    3, 4,  "BEN 300.XX"},
        {7.222226,    1.952682375,    3, 4,  "BEN 400.XX"},
        {10.341724,   1.33894275,     3, 7,  "BEN 500.XX"},
        {6.660926,    1.65719525,     3, 6,  "BEN 600.XX"},
        {8.077526,    2.453682375,    3, 4,  "BEN 700.XX"},
        {10.370624,   1.63884275,     3, 5,  "BEN 800.XX"},
        {7.016826,    2.599482375,    3, 4,  "BEN 900.XX"},
        {11.169824,   2.892429875,    3, 5,  "BEN B00.XX"},
        {9.034326,    1.6528695,      3, 6,  "BEN C00.XX"},
        {7.115526,    1.925382375,    3, 4,  "BEN D00.XX"},
        {8.014426,    2.198982375,    3, 4,  "BEN F00.XX"},
        {8.536126,    2.3707695,      3, 4,  "BEN G00.XX"},
        {10.397524,   2.34624275,     3, 5,  "BEN H00.XX"},
        {11.344724,   2.403929875,    3, 5,  "BEN J00.XX"},
        {7.970326,    1.939882375,    3, 4,  "BEN K00.XX"},
        {9.974726,    3.162156625,    3, 5,  "BEN L00.XX"},
        {11.882724,   3.328929875,    4, 8,  "BEN M00.XX"},
        {6.273045,    1.66772625,     3, 7,  "BEN N00.XX"},
        {6.773726,    2.61549525,     3, 4,  "BEN P00.XX"},
        {7.818426,    2.150982375,    3, 4,  "BEN Q00.XX"},
        {10.268224,   2.62974275,     3, 4,  "BEN R00.XX"},
        {9.573726,    1.871256625,    3, 5,  "BEN S00.XX"},
        {10.268524,   1.95944275,     3, 5,  "BEN T00.XX"},
        {12.122324,   3.133229875,    4, 7,  "BEN V00.XX"},
        {6.816266,    1.74781475,     3, 6,  "BEN W00.XX"},
        {6.381406,    1.86360125,     3, 4,  "BEN WK0.00"},
        {6.958866,    1.658329125,    3, 6,  "BEN X00.XX"},
        {8.885406,    2.5675565,      3, 4,  "BEN XK0.00"},
        {10.638264,   1.23117025,     3, 5,  "BEN Y00.XX"},
        {10.809104,   2.09731075,     3, 5,  "BEN YK0.00"},
        {7.372466,    2.578829125,    3, 4,  "BEN Z00.XX"},
        {7.209965,    2.312443375,    3, 4,  "BEN ZK0.00"},
        {6.562116,    1.524425,       2, 5,  "BEN 012.XXX"},
        {6.562116,    1.993145,       2, 3,  "BEN 112.XXX"},
        {6.562116,    2.461865,       3, 4,  "BEN 212.XXX"},
        {7.053156,    1.524425,       2, 5,  "BEN 312.XXX"},
        {7.053156,    1.993145,       3, 4,  "BEN 412.XXX"},
        {7.053156,    2.461865,       2, 3,  "BEN 512.XXX"},
        {7.544196,    1.524425,       2, 5,  "BEN 612.XXX"},
        {7.544196,    1.993145,       2, 3,  "BEN 712.XXX"},
        {7.544196,    2.461865,       2, 3,  "BEN 812.XXX"},
        {8.035236,    1.524425,       2, 5,  "BEN 912.XXX"},
        {8.035236,    1.993145,       2, 3,  "BEN B12.XXX"},
        {8.035236,    2.461865,       3, 4,  "BEN C12.XXX"},
        {8.526275,    1.524425,       2, 5,  "BEN D12.XXX"},
        {8.526275,    1.993145,       2, 3,  "BEN F12.XXX"},
        {8.526275,    2.461865,       2, 3,  "BEN G12.XXX"},
        {9.017315,    1.5247115,      2, 5,  "BEN H12.XXX"},
        {9.017315,    1.9986395,      2, 3,  "BEN J12.XXX"},
        {9.017315,    2.4725675,      2, 3,  "BEN K12.XXX"},
        {9.508355,    1.3588365,      2, 6,  "BEN L12.XXX"},
        {9.508355,    1.8327645,      2, 4,  "BEN M12.XXX"},
        {9.508355,    2.3066925,      2, 4,  "BEN N12.XXX"},
        {9.508355,    2.7806205,      2, 4,  "BEN P12.XXX"},
        {9.999395,    1.2877475,      2, 6,  "BEN Q12.XXX"},
        {9.999395,    1.7616755,      2, 4,  "BEN R12.XXX"},
        {9.999395,    2.2356035,      2, 4,  "BEN S12.XXX"},
        {9.999395,    2.7095315,      2, 4,  "BEN T12.XXX"},
        {9.999395,    3.1834595,      2, 4,  "BEN V12.XXX"},
        {10.490435,   0.7901225,      2, 6,  "BEN W12.XXX"},
        {10.490435,   1.2640505,      2, 6,  "BEN X12.XXX"},
        {10.490435,   1.7379785,      2, 4,  "BEN Y12.XXX"},
        {10.490435,   2.2119065,      2, 4,  "BEN Z12.XXX"},
        {10.078595,   2.6858345,      2, 4,  "BEN 01.XXXX"},
        {10.078595,   3.1597625,      2, 4,  "BEN 11.XXXX"},
        {10.078595,   3.5521435,      3, 5,  "BEN 21.XXXX"},
        {10.569635,   0.7901225,      2, 6,  "BEN 31.XXXX"},
        {10.569635,   1.2640505,      2, 4,  "BEN 41.XXXX"},
        {10.569635,   1.7379785,      2, 4,  "BEN 51.XXXX"},
        {10.569635,   2.2119065,      2, 4,  "BEN 61.XXXX"},
        {10.569635,   2.6858345,      2, 4,  "BEN 71.XXXX"},
        {10.569635,   3.1597625,      2, 4,  "BEN 81.XXXX"},
        {10.569635,   3.5521435,      3, 5,  "BEN 91.XXXX"},
        {11.060675,   0.9559975,      2, 5,  "BEN B1.XXXX"},
        {11.060675,   1.4299255,      2, 5,  "BEN C1.XXXX"},
        {11.060675,   1.9038535,      2, 5,  "BEN D1.XXXX"},
        {11.060675,   2.3777815,      2, 4,  "BEN F1.XXXX"},
        {11.060675,   2.8517095,      2, 4,  "BEN G1.XXXX"},
        {11.060675,   3.3256375,      2, 4,  "BEN H1.XXXX"},
        {11.865015,   2.148112,       3, 6,  "BEN V1.XXXX"},
        {11.545639,   2.6147455,      3, 4,  "BEN W1.XXXX"},
        {11.798772,   3.104304,       3, 6,  "BEN X1.XXXX"},
        {11.9544205,  2.3956755,      3, 6,  "BEN Y1.XXXX"},
        {11.9544205,  2.8696035,      3, 6,  "BEN Z1.XXXX"},
        {11.890641,   2.1323995,      3, 6,  "BEN V123.XX"},
        {11.890641,   2.6063275,      3, 5,  "BEN W123.XX"},
        {11.855544,   3.0816925,      3, 6,  "BEN X123.XX"},
        {11.934701,   2.3721975,      3, 6,  "BEN Y123.XX"},
        {11.934701,   2.8461255,      3, 6,  "BEN Z123.XX"},
        {9.255,       2.315,          2, 3,  "BEN XH2Z.8RD"},
        {15.3723,     38.8757585,     4, 5,  "ERI 12.XX"},
        {15.558646,   38.7139805,     3, 4,  "ERI 12.XXX"},
        {15.758514,   38.394683625,   3, 6,  "ERI 000.XX"},
        {12.986814,   42.632563125,   3, 6,  "ERI 200.XX"},
        {15.597014,   39.366583625,   4, 5,  "ERI 400.XX"},
        {13.910514,   41.62719325,    3, 5,  "ERI 600.XX"},
        {14.867514,   38.7518535,     3, 5,  "ERI 800.XX"},
        {15.100514,   37.5268535,     3, 6,  "ERI B00.XX"},
        {14.824614,   39.3060535,     4, 6,  "ERI D00.XX"},
        {13.247714,   42.26659325,    3, 6,  "ERI G00.XX"},
        {15.041914,   38.9849535,     3, 4,  "ERI J00.XX"},
        {14.615114,   38.768623375,   3, 6,  "ERI L00.XX"},
        {14.670514,   39.357023375,   3, 6,  "ERI N00.XX"},
        {15.144224,   36.6157645,     3, 6,  "ERI Q00.XX"},
        {14.939824,   40.2680645,     4, 5,  "ERI R00.XX"},
        {16.705824,   38.434025875,   3, 6,  "ERI S00.XX"},
        {16.228624,   38.64303875,    3, 4,  "ERI T00.XX"},
        {15.924924,   38.40473875,    3, 6,  "ERI V00.XX"},
        {16.291524,   38.00683875,    3, 6,  "ERI W00.XX"},
        {15.582424,   37.985351625,   3, 6,  "ERI X00.XX"},
        {15.072324,   37.5247645,     3, 6,  "ERI Y00.XX"},
        {15.058724,   37.6117645,     3, 6,  "ERI Z00.XX"},
        {17.976795,   38.355006,      2, 5,  "ERI 012.XXX"},
        {17.619715,   37.361195,      2, 5,  "ERI 112.XXX"},
        {17.619715,   37.850747,      2, 5,  "ERI 212.XXX"},
        {17.619715,   38.340299,      3, 6,  "ERI 312.XXX"},
        {17.619715,   38.829851,      2, 3,  "ERI 412.XXX"},
        {17.128674,   36.8765645,     2, 5,  "ERI 512.XXX"},
        {17.128674,   37.3609085,     2, 5,  "ERI 612.XXX"},
        {17.128674,   37.8452525,     2, 5,  "ERI 712.XXX"},
        {17.128674,   38.3295965,     2, 5,  "ERI 812.XXX"},
        {17.128674,   38.8139405,     2, 3,  "ERI 912.XXX"},
        {16.637635,   36.8765645,     2, 5,  "ERI B12.XXX"},
        {16.637635,   37.3609085,     2, 5,  "ERI C12.XXX"},
        {16.637635,   37.8452525,     2, 5,  "ERI D12.XXX"},
        {16.637635,   38.3295965,     2, 5,  "ERI F12.XXX"},
        {16.637635,   38.8139405,     2, 3,  "ERI G12.XXX"},
        {16.146595,   36.6343925,     2, 5,  "ERI H12.XXX"},
        {16.146595,   37.1187365,     2, 5,  "ERI J12.XXX"},
        {16.146595,   37.6030805,     2, 5,  "ERI K12.XXX"},
        {16.146595,   38.0874245,     2, 5,  "ERI L12.XXX"},
        {16.146595,   38.5717685,     2, 5,  "ERI M12.XXX"},
        {16.146595,   39.0561125,     2, 3,  "ERI N12.XXX"},
        {15.655555,   36.4648725,     2, 6,  "ERI P12.XXX"},
        {15.655555,   36.9492165,     2, 5,  "ERI Q12.XXX"},
        {15.655555,   37.4335605,     2, 5,  "ERI R12.XXX"},
        {15.655555,   37.9179045,     2, 5,  "ERI S12.XXX"},
        {15.655555,   38.4022485,     2, 5,  "ERI T12.XXX"},
        {15.655555,   38.8865925,     2, 3,  "ERI V12.XXX"},
        {15.655555,   39.3709365,     4, 5,  "ERI W12.XXX"},
        {15.655555,   39.8552805,     3, 4,  "ERI X12.XXX"},
        {15.764976,   39.8995465,     3, 4,  "ERI Y12.XXX"},
        {15.814615,   40.3395795,     3, 4,  "ERI Z12.XXX"},
        {14.752727,   36.4648925,     2, 6,  "ERI 01.XXXX"},
        {14.752727,   36.9492365,     2, 6,  "ERI 11.XXXX"},
        {14.752727,   37.4335805,     2, 6,  "ERI 21.XXXX"},
        {14.752727,   37.9179245,     2, 6,  "ERI 31.XXXX"},
        {14.752727,   38.4022685,     2, 6,  "ERI 41.XXXX"},
        {14.752727,   38.8866125,     2, 4,  "ERI B1.XXXX"},
        {14.752727,   39.3709565,     3, 5,  "ERI C1.XXXX"},
        {14.752727,   39.8553005,     3, 5,  "ERI D1.XXXX"},
        {14.752727,   40.3396445,     3, 5,  "ERI F1.XXXX"},
        {14.261687,   36.464606,      2, 6,  "ERI 51.XXXX"},
        {14.261687,   36.943742,      2, 6,  "ERI 61.XXXX"},
        {14.3081785,  37.4230225,     2, 7,  "ERI 71.XXXX"},
        {14.261687,   37.902014,      2, 7,  "ERI 81.XXXX"},
        {14.261687,   38.38115,       2, 7,  "ERI 91.XXXX"},
        {14.261687,   38.860286,      2, 5,  "ERI G1.XXXX"},
        {14.261687,   39.339421,      2, 5,  "ERI H1.XXXX"},
        {14.261687,   39.818557,      2, 5,  "ERI J1.XXXX"},
        {14.261687,   40.297694,      2, 4,  "ERI K1.XXXX"},
        {14.261687,   40.77683,       2, 4,  "ERI L1.XXXX"},
        {14.261687,   41.255966,      2, 4,  "ERI M1.XXXX"},
        {13.770647,   40.681002,      2, 4,  "ERI N1.XXXX"},
        {13.770647,   41.160138,      2, 4,  "ERI P1.XXXX"},
        {13.770647,   41.639274,      2, 4,  "ERI Q1.XXXX"},
        {13.279607,   41.160138,      2, 4,  "ERI R1.XXXX"},
        {13.279607,   41.639274,      2, 4,  "ERI S1.XXXX"},
        {13.279607,   42.11841,       2, 5,  "ERI T1.XXXX"},
        {12.788567,   41.735101,      2, 4,  "ERI V1.XXXX"},
        {12.788567,   42.214238,      3, 6,  "ERI W1.XXXX"},
        {12.788567,   42.693373,      3, 6,  "ERI X1.XXXX"},
        {12.383795,   42.238194,      2, 6,  "ERI Y1.XXXX"},
        {12.383795,   42.708222,      2, 6,  "ERI Z1.XXXX"},
        {16.6304765,  39.3462695,     2, 3,  "ERI 1234.XX"},
        {15.3372,     38.9149115,     4, 5,  "ERI CGFN.W29"},
        {-15.758145,  34.9745835,     4, 6,  "MWI 12.XX"},
        {-15.706606,  34.843773375,   3, 5,  "MWI 00.XXX"},
        {-13.960686,  33.62859775,    3, 6,  "MWI J0.XXX"},
        {-11.411476,  33.969929875,   3, 6,  "MWI 000.XX"},
        {-15.350376,  35.286351625,   3, 5,  "MWI 100.XX"},
        {-9.895576,   33.870455625,   3, 5,  "MWI 200.XX"},
        {-14.416976,  35.218677375,   3, 5,  "MWI 300.XX"},
        {-12.997376,  33.448003125,   3, 6,  "MWI 400.XX"},
        {-13.754776,  34.41649025,    3, 5,  "MWI 500.XX"},
        {-12.872476,  34.226503125,   3, 5,  "MWI 600.XX"},
        {-16.889476,  35.212012,      3, 5,  "MWI 700.XX"},
        {-15.028376,  35.1854645,     3, 5,  "MWI 800.XX"},
        {-14.330776,  34.280777375,   3, 5,  "MWI 900.XX"},
        {-14.949876,  34.9164645,     3, 5,  "MWI B00.XX"},
        {-10.974576,  33.81994275,    3, 6,  "MWI C00.XX"},
        {-11.862076,  33.555829875,   3, 6,  "MWI D00.XX"},
        {-15.982976,  35.46023875,    3, 5,  "MWI F00.XX"},
        {-13.759276,  32.83819025,    3, 7,  "MWI G00.XX"},
        {-13.490576,  33.69819025,    3, 6,  "MWI H00.XX"},
        {-11.083976,  33.634529875,   3, 7,  "MWI J00.XX"},
        {-11.566576,  34.230429875,   3, 6,  "MWI K00.XX"},
        {-15.969276,  35.25773875,    3, 5,  "MWI L00.XX"},
        {-14.044776,  34.84699025,    3, 5,  "MWI M00.XX"},
        {-15.555376,  34.502451625,   3, 5,  "MWI N00.XX"},
        {-14.783576,  34.6053645,     3, 5,  "MWI P00.XX"},
        {-9.658576,   33.231955625,   3, 6,  "MWI Q00.XX"},
        {-15.980176,  34.78413875,    3, 5,  "MWI R00.XX"},
        {-13.290076,  34.04869025,    3, 5,  "MWI S00.XX"},
        {-16.023576,  35.07923875,    3, 5,  "MWI T00.XX"},
        {-10.583276,  34.09914275,    3, 6,  "MWI V00.XX"},
        {-13.598276,  33.87749025,    3, 5,  "MWI W00.XX"},
        {-15.747476,  35.59843875,    4, 6,  "MWI X00.XX"},
        {-13.949076,  34.44979025,    3, 5,  "MWI Y00.XX"},
        {-14.841376,  35.4832645,     4, 6,  "MWI Z00.XX"},
        {-9.410405,   32.9376385,     2, 7,  "MWI 012.XXX"},
        {-9.410405,   33.4115665,     2, 5,  "MWI 112.XXX"},
        {-9.410405,   33.8854945,     2, 4,  "MWI 212.XXX"},
        {-9.901445,   33.3404775,     2, 5,  "MWI 312.XXX"},
        {-9.901445,   33.8144055,     2, 4,  "MWI 412.XXX"},
        {-10.392485,  33.3404775,     2, 5,  "MWI 512.XXX"},
        {-10.392485,  33.8144055,     2, 4,  "MWI 612.XXX"},
        {-10.883525,  33.1035135,     2, 6,  "MWI 712.XXX"},
        {-10.883525,  33.5774415,     2, 6,  "MWI 812.XXX"},
        {-10.883525,  34.0513695,     2, 5,  "MWI 912.XXX"},
        {-11.374565,  33.1035135,     2, 6,  "MWI B12.XXX"},
        {-11.374565,  33.5774415,     2, 6,  "MWI C12.XXX"},
        {-11.374565,  34.0513695,     2, 5,  "MWI D12.XXX"},
        {-11.865605,  33.2693885,     2, 5,  "MWI F12.XXX"},
        {-11.865605,  33.7433165,     2, 4,  "MWI G12.XXX"},
        {-12.356645,  32.956414,      2, 6,  "MWI H12.XXX"},
        {-12.356645,  33.43555,       2, 5,  "MWI J12.XXX"},
        {-12.356645,  33.914686,      2, 4,  "MWI K12.XXX"},
        {-12.847685,  32.956414,      2, 5,  "MWI L12.XXX"},
        {-12.847685,  33.43555,       2, 5,  "MWI M12.XXX"},
        {-12.847685,  33.914686,      2, 4,  "MWI N12.XXX"},
        {-13.338725,  32.69825,       2, 5,  "MWI P12.XXX"},
        {-13.338725,  33.172025,      2, 5,  "MWI Q12.XXX"},
        {-13.338725,  33.651161,      2, 5,  "MWI R12.XXX"},
        {-13.338725,  34.130297,      3, 5,  "MWI S12.XXX"},
        {-13.338725,  34.609433,      2, 4,  "MWI T12.XXX"},
        {-13.338725,  35.088569,      2, 5,  "MWI V12.XXX"},
        {-13.829765,  32.69825,       2, 6,  "MWI W12.XXX"},
        {-13.829765,  33.172025,      2, 5,  "MWI X12.XXX"},
        {-13.829765,  33.651161,      3, 6,  "MWI Y12.XXX"},
        {-13.829765,  34.130297,      2, 4,  "MWI Z12.XXX"},
        {-14.241605,  34.609433,      2, 4,  "MWI 01.XXXX"},
        {-14.241605,  35.088569,      2, 4,  "MWI 11.XXXX"},
        {-14.732645,  33.411593,      2, 5,  "MWI 21.XXXX"},
        {-14.732645,  33.890729,      2, 4,  "MWI 31.XXXX"},
        {-14.732645,  34.369865,      2, 4,  "MWI 41.XXXX"},
        {-14.732645,  34.849001,      2, 4,  "MWI 51.XXXX"},
        {-14.732645,  35.328137,      2, 4,  "MWI 61.XXXX"},
        {-14.732645,  35.497222,      3, 5,  "MWI 71.XXXX"},
        {-15.223685,  34.5618055,     2, 4,  "MWI 81.XXXX"},
        {-15.223685,  35.0461495,     2, 4,  "MWI 91.XXXX"},
        {-15.223685,  35.4923005,     3, 5,  "MWI B1.XXXX"},
        {-15.714725,  34.2227655,     2, 4,  "MWI C1.XXXX"},
        {-15.714725,  34.7071095,     2, 4,  "MWI D1.XXXX"},
        {-15.714725,  35.1914535,     3, 5,  "MWI F1.XXXX"},
        {-15.714725,  35.4923005,     3, 5,  "MWI G1.XXXX"},
        {-16.205765,  34.2227655,     2, 4,  "MWI H1.XXXX"},
        {-16.205765,  34.7071095,     2, 4,  "MWI J1.XXXX"},
        {-16.205765,  35.1914535,     2, 4,  "MWI K1.XXXX"},
        {-16.205765,  35.4923005,     3, 5,  "MWI L1.XXXX"},
        {-16.696805,  34.4165025,     2, 4,  "MWI M1.XXXX"},
        {-16.696805,  34.9008465,     3, 5,  "MWI N1.XXXX"},
        {-17.106205,  34.9008465,     2, 4,  "MWI P1.XXXX"},
        {-15.793245,  35.0137365,     4, 6,  "MWI QT4M.G20"},
        {39.0691,     125.7060655,    4, 6,  "PRK 12.XX"},
        {39.092404,   125.57984875,   3, 5,  "PRK 00.XXX"},
        {39.979304,   127.386137625,  3, 5,  "PRK 80.XXX"},
        {41.844904,   129.58688,      3, 7,  "PRK J0.XXX"},
        {40.014984,   124.344307125,  3, 10, "PRK S0.XXX"},
        {39.616214,   125.572367125,  3, 5,  "PRK 000.XX"},
        {38.752514,   125.316085375,  3, 7,  "PRK 200.XX"},
        {39.168114,   127.34387575,   3, 4,  "PRK 400.XX"},
        {38.033214,   125.660863875,  3, 5,  "PRK 600.XX"},
        {37.946114,   126.502263875,  3, 6,  "PRK 800.XX"},
        {39.223814,   125.78107575,   3, 5,  "PRK B00.XX"},
        {38.478814,   125.720485375,  3, 5,  "PRK D00.XX"},
        {40.951014,   126.5358995,    3, 7,  "PRK G00.XX"},
        {40.687514,   129.124409125,  3, 4,  "PRK J00.XX"},
        {41.436124,   128.1510125,    3, 7,  "PRK L00.XX"},
        {38.786024,   125.591233375,  3, 5,  "PRK M00.XX"},
        {42.278724,   130.2742085,    3, 9,  "PRK N00.XX"},
        {42.565424,   130.292856,     3, 9,  "PRK P00.XX"},
        {42.234545,   129.1907625,    3, 8,  "PRK Q00.XX"},
        {40.473624,   128.846651125,  3, 4,  "PRK R00.XX"},
        {40.181624,   128.377803625,  3, 4,  "PRK S00.XX"},
        {40.085624,   127.917603625,  3, 4,  "PRK T00.XX"},
        {40.091724,   128.129003625,  3, 4,  "PRK V00.XX"},
        {40.019724,   125.196603625,  3, 10, "PRK W00.XX"},
        {37.968024,   125.320285875,  3, 5,  "PRK X00.XX"},
        {42.478724,   129.6966085,    3, 8,  "PRK Y00.XX"},
        {40.370424,   128.596203625,  3, 4,  "PRK Z00.XX"},
        {42.976595,   129.458573,     2, 8,  "PRK 012.XXX"},
        {42.976595,   130.093949,     2, 8,  "PRK 112.XXX"},
        {42.496848,   128.8916565,    2, 7,  "PRK 212.XXX"},
        {42.496848,   129.5218245,    2, 7,  "PRK 312.XXX"},
        {42.496848,   130.1144985,    3, 9,  "PRK 412.XXX"},
        {42.005808,   126.591257,     2, 7,  "PRK 512.XXX"},
        {42.005808,   127.997417,     2, 7,  "PRK 612.XXX"},
        {42.005808,   128.622377,     2, 7,  "PRK 712.XXX"},
        {42.005808,   129.247337,     2, 7,  "PRK 812.XXX"},
        {42.005808,   129.872297,     2, 7,  "PRK 912.XXX"},
        {41.514768,   126.1399575,    2, 6,  "PRK B12.XXX"},
        {41.514768,   126.7597095,    2, 6,  "PRK C12.XXX"},
        {41.514768,   127.3794615,    2, 6,  "PRK D12.XXX"},
        {41.514768,   127.9992135,    2, 6,  "PRK F12.XXX"},
        {41.514768,   128.6189655,    2, 6,  "PRK G12.XXX"},
        {41.514768,   129.2387175,    2, 6,  "PRK H12.XXX"},
        {41.023728,   125.148068,     2, 11, "PRK J12.XXX"},
        {41.023728,   125.762612,     2, 11, "PRK K12.XXX"},
        {41.023728,   126.377156,     2, 6,  "PRK L12.XXX"},
        {41.023728,   126.9917,       2, 6,  "PRK M12.XXX"},
        {41.023728,   127.606244,     2, 6,  "PRK N12.XXX"},
        {41.023728,   128.220788,     2, 4,  "PRK P12.XXX"},
        {41.023728,   128.835332,     2, 4,  "PRK Q12.XXX"},
        {41.023728,   129.449876,     2, 4,  "PRK R12.XXX"},
        {40.532688,   124.3848095,    2, 9,  "PRK S12.XXX"},
        {40.532688,   124.9941455,    2, 9,  "PRK T12.XXX"},
        {40.532688,   125.6034815,    2, 7,  "PRK V12.XXX"},
        {40.532688,   126.2128175,    2, 4,  "PRK W12.XXX"},
        {40.532688,   126.8221535,    2, 4,  "PRK X12.XXX"},
        {40.532688,   127.4314895,    2, 4,  "PRK Y12.XXX"},
        {40.532688,   128.0408255,    2, 3,  "PRK Z12.XXX"},
        {40.120848,   128.6501615,    2, 3,  "PRK 01.XXXX"},
        {39.629808,   124.201722,     2, 6,  "PRK 11.XXXX"},
        {39.629808,   124.80585,      2, 6,  "PRK 21.XXXX"},
        {39.629808,   125.409978,     2, 6,  "PRK 31.XXXX"},
        {39.629808,   126.014106,     2, 4,  "PRK 41.XXXX"},
        {39.629808,   126.618234,     2, 3,  "PRK 51.XXXX"},
        {39.629808,   127.222362,     2, 3,  "PRK 61.XXXX"},
        {39.629808,   127.82649,      2, 3,  "PRK 71.XXXX"},
        {39.138768,   124.5087075,    2, 6,  "PRK 81.XXXX"},
        {39.138768,   125.1076275,    2, 6,  "PRK 91.XXXX"},
        {39.138768,   125.7065475,    3, 5,  "PRK B1.XXXX"},
        {39.138768,   126.3054675,    2, 3,  "PRK C1.XXXX"},
        {39.138768,   126.9043875,    2, 3,  "PRK D1.XXXX"},
        {39.138768,   127.5033075,    2, 3,  "PRK F1.XXXX"},
        {38.647728,   124.927665,     2, 4,  "PRK G1.XXXX"},
        {38.647728,   125.521377,     2, 4,  "PRK H1.XXXX"},
        {38.647728,   126.115089,     2, 4,  "PRK J1.XXXX"},
        {38.647728,   126.708801,     2, 3,  "PRK K1.XXXX"},
        {38.647728,   127.302513,     2, 3,  "PRK L1.XXXX"},
        {38.647728,   127.896225,     2, 3,  "PRK M1.XXXX"},
        {38.156688,   124.3388745,    2, 4,  "PRK N1.XXXX"},
        {38.156688,   124.9273785,    2, 4,  "PRK P1.XXXX"},
        {38.156688,   125.5158825,    2, 4,  "PRK Q1.XXXX"},
        {38.156688,   126.1043865,    2, 4,  "PRK R1.XXXX"},
        {38.156688,   126.6928905,    2, 3,  "PRK S1.XXXX"},
        {38.156688,   127.2813945,    2, 5,  "PRK T1.XXXX"},
        {38.156688,   127.8698985,    2, 5,  "PRK V1.XXXX"},
        {37.665648,   124.6331265,    2, 6,  "PRK W1.XXXX"},
        {37.665648,   125.2216305,    2, 4,  "PRK X1.XXXX"},
        {37.665648,   125.8101345,    2, 6,  "PRK Y1.XXXX"},
        {37.665648,   126.3986385,    2, 5,  "PRK Z1.XXXX"},
        {39.034,      125.7544805,    4, 6,  "PRK 7QLN.D3R"},
        {12.133621,   -86.3118275,    4, 5,  "NIC 12.XX"},
        {12.184215,   -86.3688885,    3, 4,  "NIC 12.XXX"},
        {12.478724,   -86.919584,     3, 4,  "NIC 000.XX"},
        {12.680624,   -87.179396875,  3, 4,  "NIC 100.XX"},
        {12.976024,   -85.978396875,  3, 4,  "NIC 200.XX"},
        {13.132724,   -86.395696875,  3, 4,  "NIC 300.XX"},
        {12.051924,   -83.840570125,  3, 4,  "NIC 400.XX"},
        {13.683824,   -86.49630975,   3, 6,  "NIC 500.XX"},
        {12.597724,   -87.056184,     3, 4,  "NIC 600.XX"},
        {13.135824,   -86.049596875,  3, 4,  "NIC 700.XX"},
        {12.143424,   -85.410884,     3, 4,  "NIC 800.XX"},
        {11.730724,   -84.501470125,  3, 4,  "NIC 900.XX"},
        {12.304824,   -86.608084,     3, 4,  "NIC B00.XX"},
        {13.971124,   -86.16140975,   3, 6,  "NIC C00.XX"},
        {14.075124,   -83.44280975,   4, 5,  "NIC D00.XX"},
        {11.483224,   -85.868070125,  4, 5,  "NIC F00.XX"},
        {12.190724,   -84.261584,     3, 4,  "NIC G00.XX"},
        {11.885124,   -86.478770125,  3, 4,  "NIC H00.XX"},
        {12.510724,   -85.701584,     3, 4,  "NIC J00.XX"},
        {12.553924,   -87.212284,     3, 4,  "NIC K00.XX"},
        {12.894824,   -86.138096875,  3, 4,  "NIC L00.XX"},
        {12.366324,   -86.706284,     3, 4,  "NIC M00.XX"},
        {13.520724,   -86.63180975,   3, 6,  "NIC N00.XX"},
        {12.267924,   -86.475784,     3, 4,  "NIC P00.XX"},
        {12.392464,   -85.541602,     3, 4,  "NIC Q00.XX"},
        {12.058504,   -85.117861125,  3, 4,  "NIC QK0.00"},
        {12.734664,   -86.148887625,  3, 4,  "NIC R00.XX"},
        {13.039804,   -86.951205875,  3, 6,  "NIC RK0.00"},
        {11.150664,   -84.790515375,  3, 6,  "NIC S00.XX"},
        {12.917704,   -85.243205875,  3, 4,  "NIC SK0.00"},
        {13.580064,   -86.05497325,   3, 4,  "NIC T00.XX"},
        {13.716704,   -84.81007875,   3, 4,  "NIC TK0.00"},
        {11.995264,   -85.199315375,  3, 4,  "NIC V00.XX"},
        {13.358004,   -86.42867875,   3, 4,  "NIC VK0.00"},
        {12.842464,   -85.491687625,  3, 4,  "NIC W00.XX"},
        {13.716004,   -86.16237875,   3, 6,  "NIC WK0.00"},
        {12.892464,   -86.571687625,  3, 4,  "NIC X00.XX"},
        {12.044104,   -85.016561125,  3, 4,  "NIC XK0.00"},
        {13.928064,   -84.42077325,   3, 4,  "NIC Y00.XX"},
        {12.165804,   -83.076534,     3, 4,  "NIC YK0.00"},
        {12.524064,   -86.909302,     3, 4,  "NIC Z00.XX"},
        {11.244104,   -85.886561125,  4, 5,  "NIC ZK0.00"},
        {14.839979,   -85.269029,     2, 5,  "NIC 0HH.HHH"},
        {14.839979,   -84.789893,     2, 5,  "NIC 1HH.HHH"},
        {14.839979,   -84.310757,     2, 5,  "NIC 2HH.HHH"},
        {14.839979,   -83.831621,     2, 5,  "NIC 3HH.HHH"},
        {14.839979,   -83.352485,     3, 6,  "NIC 4HH.HHH"},
        {14.547659,   -85.483573,     2, 5,  "NIC 512.XXX"},
        {14.547659,   -85.004437,     2, 3,  "NIC 612.XXX"},
        {14.547659,   -84.525301,     2, 3,  "NIC 712.XXX"},
        {14.547659,   -84.046165,     2, 3,  "NIC 812.XXX"},
        {14.547659,   -83.567029,     3, 4,  "NIC 912.XXX"},
        {14.056619,   -86.920981,     2, 5,  "NIC B12.XXX"},
        {14.056619,   -86.441845,     2, 5,  "NIC C12.XXX"},
        {14.056619,   -85.962709,     2, 5,  "NIC D12.XXX"},
        {14.056619,   -85.483573,     2, 5,  "NIC F12.XXX"},
        {14.056619,   -85.004437,     2, 3,  "NIC G12.XXX"},
        {14.056619,   -84.525301,     2, 3,  "NIC H12.XXX"},
        {14.056619,   -84.046165,     2, 3,  "NIC J12.XXX"},
        {14.056619,   -83.567029,     3, 4,  "NIC K12.XXX"},
        {13.565579,   -86.920981,     2, 5,  "NIC L12.XXX"},
        {13.565579,   -86.441845,     2, 3,  "NIC M12.XXX"},
        {13.565579,   -85.962709,     2, 3,  "NIC N12.XXX"},
        {13.565579,   -85.483573,     2, 3,  "NIC P12.XXX"},
        {13.565579,   -85.004437,     2, 3,  "NIC Q12.XXX"},
        {13.565579,   -84.525301,     2, 3,  "NIC R12.XXX"},
        {13.565579,   -84.046165,     2, 3,  "NIC S12.XXX"},
        {13.565579,   -83.567029,     3, 4,  "NIC T12.XXX"},
        {13.074539,   -87.668433,     2, 5,  "NIC V12.XXX"},
        {13.074539,   -87.189297,     2, 5,  "NIC W12.XXX"},
        {13.074539,   -86.710161,     2, 5,  "NIC X12.XXX"},
        {13.074539,   -86.231025,     2, 3,  "NIC Y12.XXX"},
        {13.074539,   -85.751889,     2, 3,  "NIC Z12.XXX"},
        {12.662699,   -85.272753,     2, 3,  "NIC 01.XXXX"},
        {12.662699,   -84.793617,     2, 3,  "NIC 11.XXXX"},
        {12.662699,   -84.314481,     2, 3,  "NIC 21.XXXX"},
        {12.662699,   -83.835345,     2, 3,  "NIC 31.XXXX"},
        {12.171659,   -87.668433,     2, 3,  "NIC 41.XXXX"},
        {12.171659,   -87.189297,     2, 3,  "NIC 51.XXXX"},
        {12.171659,   -86.710161,     2, 3,  "NIC 61.XXXX"},
        {12.171659,   -86.231025,     3, 4,  "NIC 71.XXXX"},
        {12.171659,   -85.751889,     2, 3,  "NIC 81.XXXX"},
        {12.171659,   -85.272753,     2, 3,  "NIC 91.XXXX"},
        {12.171659,   -84.793617,     2, 3,  "NIC B1.XXXX"},
        {12.171659,   -84.314481,     2, 3,  "NIC C1.XXXX"},
        {12.171659,   -83.835345,     2, 3,  "NIC D1.XXXX"},
        {11.680619,   -86.8968935,    2, 3,  "NIC F1.XXXX"},
        {11.680619,   -86.4229655,    2, 3,  "NIC G1.XXXX"},
        {11.680619,   -85.9490375,    2, 3,  "NIC H1.XXXX"},
        {11.680619,   -85.4751095,    2, 3,  "NIC J1.XXXX"},
        {11.680619,   -85.0011815,    2, 3,  "NIC K1.XXXX"},
        {11.680619,   -84.5272535,    2, 3,  "NIC L1.XXXX"},
        {11.680619,   -84.0533255,    2, 3,  "NIC M1.XXXX"},
        {11.189579,   -86.4229655,    2, 3,  "NIC N1.XXXX"},
        {11.189579,   -85.9490375,    3, 6,  "NIC P1.XXXX"},
        {11.189579,   -85.4751095,    3, 6,  "NIC Q1.XXXX"},
        {11.189579,   -85.0011815,    3, 6,  "NIC R1.XXXX"},
        {11.189579,   -84.5272535,    3, 6,  "NIC S1.XXXX"},
        {11.189579,   -84.0533255,    3, 4,  "NIC T1.XXXX"},
        {11.042267,   -85.9490375,    2, 5,  "NIC V1.XXXX"},
        {10.993163,   -85.4751095,    2, 5,  "NIC W1.XXXX"},
        {10.944059,   -85.0011815,    2, 5,  "NIC X1.XXXX"},
        {10.791836,   -84.5272535,    2, 5,  "NIC Y1.XXXX"},
        {10.737822,   -84.0533255,    2, 5,  "NIC Z1.XXXX"},
        {14.48159,    -83.5455115,    3, 4,  "NIC 1234.XX"},
        {12.8675,     -85.0,          2, 3,  "NIC GW1V.DLQ"},
        {38.008532,   23.6778835,     4, 5,  "GRC 12.XX"},
        {38.028555,   23.3366495,     3, 4,  "GRC 12.XXX"},
        {38.280724,   21.708585875,   3, 4,  "GRC 000.XX"},
        {35.345724,   25.08028,       4, 5,  "GRC 100.XX"},
        {39.680724,   22.367455125,   3, 4,  "GRC 200.XX"},
        {40.620724,   22.936551125,   4, 5,  "GRC 300.XX"},
        {39.410724,   22.887455125,   3, 4,  "GRC 400.XX"},
        {39.700724,   20.797455125,   3, 6,  "GRC 500.XX"},
        {40.980724,   24.3408125,     3, 4,  "GRC 600.XX"},
        {41.127124,   23.4963125,     3, 4,  "GRC 700.XX"},
        {38.530724,   23.548133375,   3, 4,  "GRC 800.XX"},
        {35.550724,   23.97028,       4, 5,  "GRC 900.XX"},
        {36.455524,   28.14700275,    3, 5,  "GRC B00.XX"},
        {40.300724,   22.447003625,   3, 4,  "GRC C00.XX"},
        {37.050724,   22.069263125,   3, 4,  "GRC D00.XX"},
        {40.917424,   25.824151125,   3, 5,  "GRC F00.XX"},
        {39.600724,   21.717455125,   3, 4,  "GRC G00.XX"},
        {38.940724,   22.37779475,    3, 4,  "GRC H00.XX"},
        {41.150724,   24.8412125,     3, 4,  "GRC J00.XX"},
        {40.560724,   22.146551125,   3, 4,  "GRC K00.XX"},
        {38.660724,   21.358133375,   3, 4,  "GRC L00.XX"},
        {40.700724,   22.866551125,   3, 4,  "GRC M00.XX"},
        {39.410724,   21.867455125,   3, 4,  "GRC N00.XX"},
        {39.664424,   19.825855125,   4, 7,  "GRC P00.XX"},
        {41.132464,   25.3591235,     3, 4,  "GRC Q00.XX"},
        {41.142004,   24.1106495,     3, 4,  "GRC QK0.00"},
        {40.312464,   21.749724875,   3, 4,  "GRC R00.XX"},
        {40.504104,   21.645767125,   3, 4,  "GRC RK0.00"},
        {35.358364,   24.433215,      4, 5,  "GRC S00.XX"},
        {39.104004,   26.50306275,    3, 6,  "GRC SK0.00"},
        {40.813864,   22.343181375,   3, 4,  "GRC T00.XX"},
        {37.509604,   22.3400865,     3, 4,  "GRC TK0.00"},
        {37.650664,   22.7006845,     3, 4,  "GRC V00.XX"},
        {38.392185,   26.116626125,   3, 5,  "GRC VK0.00"},
        {37.687264,   21.3953845,     3, 4,  "GRC W00.XX"},
        {38.310004,   23.284980375,   3, 4,  "GRC WK0.00"},
        {38.262464,   22.040927625,   3, 4,  "GRC X00.XX"},
        {38.440604,   22.865180375,   3, 4,  "GRC XK0.00"},
        {40.660664,   22.050281375,   3, 4,  "GRC Y00.XX"},
        {39.154104,   20.95656275,    3, 4,  "GRC YK0.00"},
        {37.970345,   22.909284375,   3, 4,  "GRC Z00.XX"},
        {40.781692,   22.024067125,   3, 4,  "GRC ZK0.00"},
        {39.455775,   19.39477,       2, 3,  "GRC 01.XXXX"},
        {38.058075,   20.3212265,     3, 4,  "GRC 11.XXXX"},
        {37.576375,   20.5158265,     3, 4,  "GRC 21.XXXX"},
        {35.246375,   23.410175,      3, 4,  "GRC 31.XXXX"},
        {35.172719,   23.983055,      3, 4,  "GRC 41.XXXX"},
        {35.270927,   24.555935,      4, 5,  "GRC 51.XXXX"},
        {34.833795,   24.5608565,     3, 4,  "GRC 61.XXXX"},
        {34.94193,    25.1285285,     3, 4,  "GRC 71.XXXX"},
        {35.177072,   25.712097,      3, 4,  "GRC 81.XXXX"},
        {37.297675,   24.2440265,     3, 4,  "GRC 91.XXXX"},
        {35.896075,   27.410975,      3, 5,  "GRC B1.XXXX"},
        {36.067939,   27.754703,      4, 6,  "GRC C1.XXXX"},
        {38.971175,   25.4587915,     3, 4,  "GRC D1.XXXX"},
        {38.971175,   26.0577115,     2, 4,  "GRC F1.XXXX"},
        {36.627375,   26.8128615,     4, 6,  "GRC G1.XXXX"},
        {36.787675,   24.95614,       4, 5,  "GRC H1.XXXX"},
        {36.787675,   25.539436,      4, 5,  "GRC J1.XXXX"},
        {36.343675,   25.0046615,     3, 4,  "GRC K1.XXXX"},
        {36.270075,   26.2367615,     3, 5,  "GRC L1.XXXX"},
        {36.567021,   24.23323,       2, 3,  "GRC M1.XXXX"},
        {37.4723065,  24.8161125,     3, 4,  "GRC N1.XXXX"},
        {37.547475,   24.7099265,     3, 4,  "GRC P1.XXXX"},
        {39.710175,   24.97197,       2, 3,  "GRC Q1.XXXX"},
        {35.5805235,  26.8400425,     3, 4,  "GRC R1.XXXX"},
        {37.6022355,  26.020005,      2, 4,  "GRC S1.XXXX"},
        {36.818075,   24.28054,       4, 5,  "GRC T1.XXXX"},
        {38.694675,   24.254905,      4, 5,  "GRC V1.XXXX"},
        {40.389175,   24.4016565,     2, 3,  "GRC W1.XXXX"},
        {40.308875,   25.3690565,     2, 3,  "GRC X1.XXXX"},
        {37.362675,   26.5268265,     4, 7,  "GRC Y1.XXXX"},
        {38.167575,   25.7422265,     2, 4,  "GRC Z1.XXXX"},
        {41.427597,   22.8069615,     2, 7,  "GRC 012.XXX"},
        {41.5453335,  23.9387755,     2, 5,  "GRC 112.XXX"},
        {41.5453335,  24.5585265,     2, 5,  "GRC 212.XXX"},
        {41.264167,   25.7489655,     3, 8,  "GRC 312.XXX"},
        {41.264167,   26.202798,      2, 4,  "GRC 412.XXX"},
        {41.159451,   20.873816,      2, 8,  "GRC 512.XXX"},
        {41.159451,   21.48836,       2, 5,  "GRC 612.XXX"},
        {41.159451,   22.102904,      2, 5,  "GRC 712.XXX"},
        {41.159451,   22.717448,      2, 5,  "GRC 812.XXX"},
        {41.159451,   23.331992,      2, 3,  "GRC 912.XXX"},
        {41.159451,   23.946536,      2, 3,  "GRC B12.XXX"},
        {41.159451,   24.56108,       2, 3,  "GRC C12.XXX"},
        {41.282211,   25.175624,      2, 5,  "GRC D12.XXX"},
        {41.159451,   25.790168,      2, 4,  "GRC F12.XXX"},
        {40.668411,   20.7128105,     2, 5,  "GRC G12.XXX"},
        {40.668411,   21.3221465,     2, 3,  "GRC H12.XXX"},
        {40.668411,   21.9314825,     2, 3,  "GRC J12.XXX"},
        {40.668411,   22.5408185,     2, 3,  "GRC K12.XXX"},
        {40.668411,   23.1501545,     2, 3,  "GRC L12.XXX"},
        {40.668411,   23.7594905,     2, 3,  "GRC M12.XXX"},
        {40.177371,   20.225055,      2, 5,  "GRC N12.XXX"},
        {40.177371,   20.829183,      2, 5,  "GRC P12.XXX"},
        {40.177371,   21.433311,      2, 3,  "GRC Q12.XXX"},
        {40.177371,   22.037439,      2, 3,  "GRC R12.XXX"},
        {40.177371,   22.641567,      2, 3,  "GRC S12.XXX"},
        {40.177371,   23.245695,      2, 3,  "GRC T12.XXX"},
        {40.177371,   23.849823,      2, 3,  "GRC V12.XXX"},
        {39.686331,   19.7768805,     3, 6,  "GRC W12.XXX"},
        {39.686331,   20.3758005,     2, 5,  "GRC X12.XXX"},
        {39.686331,   20.9747205,     2, 5,  "GRC Y12.XXX"},
        {39.686331,   21.5736405,     2, 3,  "GRC Z12.XXX"},
        {39.254796,   22.1428905,     2, 3,  "GRC 0123.XX"},
        {39.254796,   22.7418105,     2, 3,  "GRC 1123.XX"},
        {38.763756,   20.43594,       3, 4,  "GRC 2123.XX"},
        {38.763756,   21.029652,      2, 3,  "GRC 3123.XX"},
        {38.763756,   21.623364,      2, 3,  "GRC 4123.XX"},
        {38.763756,   22.217076,      2, 3,  "GRC 5123.XX"},
        {38.763756,   22.810788,      2, 3,  "GRC 6123.XX"},
        {38.763756,   23.4045,        2, 3,  "GRC 7123.XX"},
        {38.272716,   20.4411195,     4, 5,  "GRC 8123.XX"},
        {38.272716,   21.0296235,     3, 4,  "GRC 9123.XX"},
        {38.272716,   21.6181275,     2, 3,  "GRC B123.XX"},
        {38.272716,   22.2066315,     2, 3,  "GRC C123.XX"},
        {38.272716,   22.7951355,     2, 3,  "GRC D123.XX"},
        {38.272716,   23.3836395,     2, 3,  "GRC F123.XX"},
        {38.272716,   23.9721435,     2, 3,  "GRC G123.XX"},
        {37.781676,   21.0884735,     2, 3,  "GRC H123.XX"},
        {37.781676,   21.6769775,     2, 3,  "GRC J123.XX"},
        {37.781676,   22.2654815,     2, 3,  "GRC K123.XX"},
        {37.781676,   22.8539855,     2, 3,  "GRC L123.XX"},
        {37.781676,   23.4424895,     3, 4,  "GRC M123.XX"},
        {37.781676,   24.0309935,     3, 4,  "GRC N123.XX"},
        {37.287921,   21.2355995,     2, 3,  "GRC P123.XX"},
        {37.287921,   21.8241035,     2, 3,  "GRC Q123.XX"},
        {37.287921,   22.4126075,     2, 3,  "GRC R123.XX"},
        {37.287921,   23.0011115,     2, 3,  "GRC S123.XX"},
        {37.287921,   23.5896155,     3, 4,  "GRC T123.XX"},
        {36.801355,   21.529766,      2, 3,  "GRC V123.XX"},
        {36.812706,   22.0031065,     2, 3,  "GRC W123.XX"},
        {36.812706,   22.5531065,     2, 3,  "GRC X123.XX"},
        {36.308556,   22.2932875,     2, 3,  "GRC Y123.XX"},
        {36.3438485,  22.871119,      2, 3,  "GRC Z123.XX"},
        {39.1809145,  19.4290255,     2, 3,  "GRC 012.XXXX"},
        {38.3906625,  20.066855,      2, 3,  "GRC 112.XXXX"},
        {39.5865245,  23.929454,      2, 3,  "GRC 212.XXXX"},
        {37.4293715,  23.1907785,     3, 4,  "GRC 312.XXXX"},
        {37.3915585,  24.8629235,     3, 4,  "GRC 412.XXXX"},
        {37.3915585,  26.1646035,     3, 5,  "GRC 512.XXXX"},
        {35.8865245,  23.3127515,     2, 3,  "GRC 612.XXXX"},
        {36.0675675,  25.092729,      2, 3,  "GRC 712.XXXX"},
        {36.5668955,  26.573581,      4, 6,  "GRC 812.XXXX"},
        {36.037683,   28.0063135,     3, 5,  "GRC 912.XXXX"},
        {37.973432,   23.7254565,     4, 5,  "GRC FJ4V.BRG"},
        {38.595416,   68.7222445,     4, 6,  "TJK 12.XX"},
        {38.4888245,  68.2012425,     4, 7,  "TJK 12.XXX"},
        {38.341624,   68.975585875,   3, 6,  "TJK 000.XX"},
        {38.408024,   69.246633375,   3, 6,  "TJK 100.XX"},
        {40.326524,   69.588003625,   3, 7,  "TJK 200.XX"},
        {37.942524,   69.734585875,   3, 6,  "TJK 300.XX"},
        {37.880724,   68.718585875,   3, 6,  "TJK 400.XX"},
        {40.345624,   70.362903625,   3, 7,  "TJK 500.XX"},
        {39.976545,   68.958493125,   3, 5,  "TJK 600.XX"},
        {38.550724,   68.168133375,   3, 6,  "TJK 700.XX"},
        {40.162745,   70.587493125,   4, 9,  "TJK 800.XX"},
        {39.512045,   67.464690625,   3, 6,  "TJK 900.XX"},
        {37.530724,   71.4989245,     4, 7,  "TJK B00.XX"},
        {37.859324,   69.588085875,   3, 6,  "TJK C00.XX"},
        {40.286324,   69.683403625,   4, 8,  "TJK D00.XX"},
        {37.631024,   68.5782245,     3, 6,  "TJK F00.XX"},
        {37.538024,   69.3649245,     3, 6,  "TJK G00.XX"},
        {37.689624,   69.5650245,     3, 6,  "TJK H00.XX"},
        {38.139024,   69.276985875,   3, 6,  "TJK J00.XX"},
        {37.736124,   68.7778245,     3, 6,  "TJK K00.XX"},
        {40.169145,   69.439393125,   3, 8,  "TJK L00.XX"},
        {40.454124,   69.241051125,   3, 6,  "TJK M00.XX"},
        {40.254424,   69.747103625,   4, 8,  "TJK N00.XX"},
        {37.300724,   68.079263125,   3, 7,  "TJK P00.XX"},
        {40.544324,   69.264551125,   3, 7,  "TJK Q00.XX"},
        {40.173704,   69.316332125,   3, 8,  "TJK R00.XX"},
        {39.039904,   70.34736275,    3, 5,  "TJK RK0.00"},
        {40.569164,   69.578381375,   3, 9,  "TJK S00.XX"},
        {40.665204,   70.314967125,   3, 9,  "TJK SK0.00"},
        {37.872464,   68.865427625,   3, 6,  "TJK T00.XX"},
        {38.088768,   69.994670625,   3, 6,  "TJK TK0.00"},
        {38.747964,   69.658884125,   3, 5,  "TJK V00.XX"},
        {37.942304,   68.784769875,   3, 6,  "TJK VK0.00"},
        {40.233364,   68.795524875,   3, 6,  "TJK W00.XX"},
        {38.522004,   68.515480375,   4, 6,  "TJK WK0.00"},
        {38.566064,   69.286184125,   3, 5,  "TJK X00.XX"},
        {37.398604,   68.5987865,     3, 7,  "TJK XK0.00"},
        {40.290064,   68.768824875,   3, 6,  "TJK Y00.XX"},
        {39.956304,   69.098756625,   3, 5,  "TJK YK0.00"},
        {37.786564,   68.7623845,     3, 6,  "TJK Z00.XX"},
        {38.560904,   68.304180375,   4, 7,  "TJK ZK0.00"},
        {36.9806825,  71.5309795,     2, 4,  "TJK 1234.XX"},
        {40.594868,   69.2705095,     2, 8,  "TJK 012.XXX"},
        {41.007535,   70.218783,      2, 8,  "TJK 112.XXX"},
        {40.516495,   68.4906895,     2, 5,  "TJK 212.XXX"},
        {40.516495,   69.1000255,     2, 5,  "TJK 312.XXX"},
        {40.516495,   69.7093615,     2, 6,  "TJK 412.XXX"},
        {40.516495,   70.3186975,     2, 6,  "TJK 512.XXX"},
        {40.035275,   68.581804,      2, 4,  "TJK 612.XXX"},
        {40.035275,   69.185932,      2, 4,  "TJK 712.XXX"},
        {40.21205,    70.424394,      3, 8,  "TJK 812.XXX"},
        {39.632623,   67.3764905,     2, 5,  "TJK 912.XXX"},
        {39.632623,   67.9754105,     2, 5,  "TJK B12.XXX"},
        {39.632623,   68.5743305,     3, 5,  "TJK C12.XXX"},
        {39.632623,   69.1732505,     3, 5,  "TJK D12.XXX"},
        {39.632623,   69.7721705,     2, 5,  "TJK F12.XXX"},
        {39.632623,   70.3710905,     2, 5,  "TJK G12.XXX"},
        {39.632623,   70.9700105,     2, 6,  "TJK H12.XXX"},
        {39.632623,   71.5689305,     2, 6,  "TJK J12.XXX"},
        {39.632623,   72.1678505,     2, 6,  "TJK K12.XXX"},
        {39.632623,   72.7667705,     2, 6,  "TJK L12.XXX"},
        {39.632623,   73.3656905,     2, 5,  "TJK M12.XXX"},
        {39.141583,   67.376204,      2, 5,  "TJK N12.XXX"},
        {39.141583,   67.969916,      2, 5,  "TJK P12.XXX"},
        {39.141583,   68.563628,      2, 4,  "TJK Q12.XXX"},
        {39.141583,   69.15734,       2, 4,  "TJK R12.XXX"},
        {39.141583,   69.751052,      2, 4,  "TJK S12.XXX"},
        {39.141583,   70.344764,      2, 4,  "TJK T12.XXX"},
        {39.141583,   70.938476,      2, 4,  "TJK V12.XXX"},
        {39.141583,   71.532188,      2, 4,  "TJK W12.XXX"},
        {39.141583,   72.1259,        2, 4,  "TJK X12.XXX"},
        {39.141583,   72.719612,      2, 4,  "TJK Y12.XXX"},
        {39.141583,   73.313324,      2, 3,  "TJK Z12.XXX"},
        {38.238703,   67.9748375,     2, 5,  "TJK 01.XXXX"},
        {38.238703,   68.5633415,     2, 5,  "TJK 11.XXXX"},
        {38.238703,   69.1518455,     2, 5,  "TJK 21.XXXX"},
        {38.238703,   69.7403495,     2, 5,  "TJK 31.XXXX"},
        {38.238703,   70.3288535,     2, 5,  "TJK 41.XXXX"},
        {38.238703,   70.9173575,     2, 5,  "TJK 51.XXXX"},
        {38.238703,   71.5058615,     2, 5,  "TJK 61.XXXX"},
        {38.238703,   72.0943655,     2, 5,  "TJK 71.XXXX"},
        {38.238703,   72.6828695,     2, 5,  "TJK 81.XXXX"},
        {38.238703,   73.2713735,     2, 4,  "TJK 91.XXXX"},
        {38.238703,   73.8598775,     2, 6,  "TJK B1.XXXX"},
        {38.238703,   74.4483815,     2, 6,  "TJK C1.XXXX"},
        {37.747663,   71.2881155,     2, 5,  "TJK D1.XXXX"},
        {37.256623,   71.287829,      2, 5,  "TJK F1.XXXX"},
        {37.747663,   67.7883395,     2, 5,  "TJK G1.XXXX"},
        {37.747663,   68.3768435,     2, 5,  "TJK H1.XXXX"},
        {37.747663,   68.9653475,     2, 5,  "TJK J1.XXXX"},
        {37.747663,   69.5538515,     2, 5,  "TJK K1.XXXX"},
        {37.747663,   70.1423555,     2, 5,  "TJK L1.XXXX"},
        {37.256623,   67.788053,      2, 6,  "TJK M1.XXXX"},
        {37.256623,   68.371349,      2, 6,  "TJK N1.XXXX"},
        {37.256623,   68.954645,      2, 6,  "TJK P1.XXXX"},
        {37.256623,   69.537941,      2, 6,  "TJK Q1.XXXX"},
        {37.256623,   70.121237,      2, 6,  "TJK R1.XXXX"},
        {36.765583,   67.788053,      2, 5,  "TJK S1.XXXX"},
        {36.765583,   68.371349,      2, 5,  "TJK T1.XXXX"},
        {36.765583,   68.954645,      2, 5,  "TJK V1.XXXX"},
        {38.863,      71.2645,        2, 4,  "TJK MHNK.9X4"},
        {23.7667,     90.361042,      4, 5,  "BGD 12.XX"},
        {23.5216915,  90.2134945,     3, 4,  "BGD 12.XXX"},
        {22.392545,   91.7455425,     3, 6,  "BGD 000.XX"},
        {22.329545,   91.7602425,     3, 6,  "BGD 100.XX"},
        {22.867024,   89.51263075,    3, 4,  "BGD 200.XX"},
        {24.414045,   88.55301725,    3, 9,  "BGD 300.XX"},
        {23.472945,   91.157276375,   3, 9,  "BGD 400.XX"},
        {24.790624,   90.3634525,     3, 8,  "BGD 500.XX"},
        {24.912445,   91.8220785,     3, 8,  "BGD 600.XX"},
        {25.790724,   89.204913875,   3, 5,  "BGD 700.XX"},
        {23.960124,   90.660591125,   3, 4,  "BGD 800.XX"},
        {22.737924,   90.31663075,    3, 4,  "BGD 900.XX"},
        {21.489224,   91.95058225,    4, 5,  "BGD B00.XX"},
        {23.210124,   89.162317875,   3, 5,  "BGD C00.XX"},
        {24.888824,   89.3268525,     3, 4,  "BGD D00.XX"},
        {24.015324,   91.062491125,   3, 4,  "BGD F00.XX"},
        {25.670724,   88.59502675,    3, 9,  "BGD G00.XX"},
        {24.047324,   89.195091125,   3, 4,  "BGD H00.XX"},
        {24.633424,   88.21807825,    3, 11, "BGD J00.XX"},
        {24.288524,   89.89197825,    3, 10, "BGD K00.XX"},
        {24.960724,   89.8952525,     3, 10, "BGD L00.XX"},
        {24.860724,   88.9152525,     3, 8,  "BGD M00.XX"},
        {24.500824,   89.62917825,    3, 4,  "BGD N00.XX"},
        {23.270024,   90.637017875,   3, 4,  "BGD P00.XX"},
        {22.986724,   91.07843075,    3, 4,  "BGD Q00.XX"},
        {23.922464,   89.097851375,   3, 8,  "BGD R00.XX"},
        {23.626804,   88.831657125,   3, 9,  "BGD RK0.00"},
        {22.883564,   91.06440925,    3, 4,  "BGD S00.XX"},
        {22.709304,   89.04737375,    3, 9,  "BGD SK0.00"},
        {25.345764,   89.50692225,    3, 4,  "BGD T00.XX"},
        {23.592904,   89.816901875,   3, 4,  "BGD TK0.00"},
        {24.133064,   89.038351375,   3, 8,  "BGD V00.XX"},
        {24.053304,   90.957657125,   3, 4,  "BGD VK0.00"},
        {24.423664,   88.94906575,    3, 8,  "BGD W00.XX"},
        {24.168904,   89.57118425,    3, 4,  "BGD WK0.00"},
        {25.027564,   89.9834935,     3, 11, "BGD X00.XX"},
        {22.679304,   90.59757375,    3, 4,  "BGD XK0.00"},
        {23.554864,   89.138123625,   3, 4,  "BGD Y00.XX"},
        {24.423804,   90.75238425,    3, 8,  "BGD YK0.00"},
        {25.826064,   89.611136625,   3, 5,  "BGD Z00.XX"},
        {24.367204,   91.39798425,    3, 11, "BGD ZK0.00"},
        {26.594595,   88.3287635,     2, 10, "BGD 012.XXX"},
        {26.437283,   88.8443555,     2, 8,  "BGD 112.XXX"},
        {26.191763,   88.1070585,     2, 11, "BGD 212.XXX"},
        {26.191763,   88.6226505,     3, 9,  "BGD 312.XXX"},
        {26.0816735,  89.1341495,     3, 9,  "BGD 412.XXX"},
        {25.7901065,  89.5603095,     2, 4,  "BGD 512.XXX"},
        {25.6828415,  88.3383495,     2, 8,  "BGD 612.XXX"},
        {25.700723,   88.8701345,     2, 7,  "BGD 712.XXX"},
        {25.6295395,  89.3849985,     2, 3,  "BGD 812.XXX"},
        {25.209683,   88.0931715,     2, 11, "BGD 912.XXX"},
        {25.209683,   88.6087625,     2, 8,  "BGD B12.XXX"},
        {25.209683,   89.1243545,     2, 4,  "BGD C12.XXX"},
        {24.76621,    89.623196,      2, 3,  "BGD D12.XXX"},
        {25.2034995,  90.098065,      2, 10, "BGD F12.XXX"},
        {25.0906535,  90.60749,       2, 10, "BGD G12.XXX"},
        {25.209683,   91.1723305,     2, 10, "BGD H12.XXX"},
        {25.209683,   91.6879225,     2, 10, "BGD J12.XXX"},
        {24.608731,   92.17885,       2, 9,  "BGD K12.XXX"},
        {24.685521,   88.0327625,     2, 10, "BGD L12.XXX"},
        {24.7007615,  88.577501,      2, 8,  "BGD M12.XXX"},
        {24.718643,   89.094053,      2, 7,  "BGD N12.XXX"},
        {24.718643,   89.604436,      2, 3,  "BGD P12.XXX"},
        {24.718643,   90.11482,       2, 7,  "BGD Q12.XXX"},
        {24.718643,   90.625204,      2, 7,  "BGD R12.XXX"},
        {24.718643,   91.135589,      2, 7,  "BGD S12.XXX"},
        {24.643332,   91.6443925,     2, 7,  "BGD T12.XXX"},
        {24.227603,   88.583668,      2, 8,  "BGD V12.XXX"},
        {24.227603,   89.094051,      2, 7,  "BGD W12.XXX"},
        {24.227603,   89.604435,      2, 3,  "BGD X12.XXX"},
        {24.227603,   90.114819,      2, 3,  "BGD Y12.XXX"},
        {24.227603,   90.625204,      2, 3,  "BGD Z12.XXX"},
        {23.815763,   91.135588,      2, 8,  "BGD 01.XXXX"},
        {24.110387,   91.645972,      2, 8,  "BGD 11.XXXX"},
        {23.324723,   88.5885885,     2, 8,  "BGD 21.XXXX"},
        {23.324723,   89.0937645,     2, 7,  "BGD 31.XXXX"},
        {23.324723,   89.5989405,     2, 3,  "BGD 41.XXXX"},
        {23.324723,   90.1041165,     2, 3,  "BGD 51.XXXX"},
        {23.324723,   90.6092925,     2, 3,  "BGD 61.XXXX"},
        {23.324723,   91.1144685,     2, 3,  "BGD 71.XXXX"},
        {22.833683,   88.7178065,     2, 8,  "BGD B1.XXXX"},
        {22.833683,   89.2229825,     2, 4,  "BGD C1.XXXX"},
        {22.833683,   89.7281585,     2, 3,  "BGD D1.XXXX"},
        {22.833683,   90.2333345,     2, 3,  "BGD F1.XXXX"},
        {22.833683,   90.7385105,     2, 3,  "BGD G1.XXXX"},
        {22.833683,   91.2436865,     2, 5,  "BGD H1.XXXX"},
        {23.6311025,  91.869874,      2, 8,  "BGD 81.XXXX"},
        {23.0696355,  91.748,         2, 9,  "BGD J1.XXXX"},
        {23.0462045,  92.1259835,     2, 8,  "BGD K1.XXXX"},
        {22.342642,   88.9350315,     2, 8,  "BGD L1.XXXX"},
        {22.342642,   89.4402075,     2, 3,  "BGD M1.XXXX"},
        {22.342642,   89.9453835,     2, 3,  "BGD N1.XXXX"},
        {22.342642,   90.4505595,     2, 3,  "BGD P1.XXXX"},
        {22.342642,   90.9557355,     2, 3,  "BGD Q1.XXXX"},
        {22.342642,   91.4609115,     2, 5,  "BGD R1.XXXX"},
        {22.342642,   91.9660875,     2, 5,  "BGD S1.XXXX"},
        {22.342642,   92.2046145,     3, 10, "BGD T1.XXXX"},
        {21.851603,   91.682903,      3, 4,  "BGD V1.XXXX"},
        {21.851603,   92.182871,      2, 4,  "BGD W1.XXXX"},
        {21.360562,   91.857891,      3, 4,  "BGD X1.XXXX"},
        {21.511068,   92.345749,      2, 4,  "BGD Y1.XXXX"},
        {21.029297,   92.0471715,     2, 3,  "BGD Z1.XXXX"},
        {21.922553,   89.103313,      2, 4,  "BGD 1234.XX"},
        {26.218368,   88.1734485,     2, 11, "BGD 1234.XXX"},
        {27.7451,     85.2689595,     4, 8,  "NPL 12.XX"},
        {27.916315,   85.1425365,     4, 10, "NPL 12.XXX"},
        {26.430414,   87.222031125,   3, 11, "NPL 000.XX"},
        {28.200514,   83.920911875,   3, 11, "NPL 200.XX"},
        {27.000514,   84.801591375,   3, 10, "NPL 400.XX"},
        {26.790514,   87.205291375,   3, 12, "NPL 600.XX"},
        {27.643514,   84.330651625,   3, 9,  "NPL 800.XX"},
        {26.699414,   85.845431125,   3, 12, "NPL B00.XX"},
        {29.004024,   80.119957375,   3, 15, "NPL D00.XX"},
        {27.719424,   83.400435625,   3, 9,  "NPL F00.XX"},
        {28.730724,   80.543783125,   3, 13, "NPL G00.XX"},
        {27.450724,   84.974235625,   4, 10, "NPL H00.XX"},
        {28.088224,   81.574709875,   3, 12, "NPL J00.XX"},
        {26.716124,   87.623487125,   3, 11, "NPL K00.XX"},
        {27.555124,   83.404735625,   3, 9,  "NPL L00.XX"},
        {28.247424,   81.297509875,   3, 12, "NPL M00.XX"},
        {26.713524,   87.224387125,   3, 12, "NPL N00.XX"},
        {28.571324,   81.065783125,   3, 11, "NPL P00.XX"},
        {28.170724,   82.244009875,   3, 11, "NPL Q00.XX"},
        {26.837924,   86.653661375,   3, 12, "NPL R00.XX"},
        {28.617624,   81.566683125,   3, 7,  "NPL S00.XX"},
        {27.062524,   84.977961375,   3, 9,  "NPL T00.XX"},
        {26.580724,   86.694687125,   3, 11, "NPL V00.XX"},
        {26.778024,   86.415387125,   3, 12, "NPL W00.XX"},
        {26.810724,   85.224687125,   3, 10, "NPL X00.XX"},
        {26.650424,   87.064087125,   3, 11, "NPL Y00.XX"},
        {26.893524,   85.525561375,   3, 10, "NPL Z00.XX"},
        {30.3709085,  80.227444,      2, 13, "NPL 12.XXXX"},
        {27.9700035,  84.7413615,     3, 11, "NPL 123.XXX"},
        {29.683315,   82.790862,      2, 6,  "NPL 1234.XX"},
        {30.1642255,  80.3444995,     2, 13, "NPL 1234.XXX"},
        {36.848835,   10.116680625,   4, 5,  "TUN 00.XX"},
        {36.784625,   10.085310625,   4, 5,  "TUN J0.XX"},
        {36.889494,   10.00493325,    3, 4,  "TUN 00.XXX"},
        {35.775314,   10.51137,       3, 4,  "TUN J0.XXX"},
        {37.256114,   9.789383125,    3, 4,  "TUN 000.XX"},
        {33.871514,   10.021968,      3, 4,  "TUN 200.XX"},
        {33.838524,   10.960484,      3, 4,  "TUN 400.XX"},
        {35.718724,   10.04628,       3, 4,  "TUN 500.XX"},
        {34.808244,   10.744872125,   3, 4,  "TUN 600.XX"},
        {34.808244,   10.670638125,   3, 4,  "TUN 700.XX"},
        {34.454124,   8.732445375,    3, 7,  "TUN 800.XX"},
        {35.220724,   8.78028,        3, 6,  "TUN 900.XX"},
        {33.552524,   11.024823625,   3, 4,  "TUN B00.XX"},
        {33.899624,   10.792784,      3, 4,  "TUN C00.XX"},
        {36.467245,   10.67319975,    3, 4,  "TUN D00.XX"},
        {36.425095,   10.53627875,    3, 4,  "TUN F00.XX"},
        {32.970724,   10.401749375,   3, 5,  "TUN G00.XX"},
        {33.388824,   10.435623625,   3, 4,  "TUN H00.XX"},
        {36.769924,   9.15380275,     3, 6,  "TUN J00.XX"},
        {35.663024,   10.92658,       3, 4,  "TUN K00.XX"},
        {37.195224,   9.738963125,    3, 4,  "TUN L00.XX"},
        {36.211324,   8.655541375,    3, 7,  "TUN M00.XX"},
        {35.533545,   11.025575,      3, 4,  "TUN N00.XX"},
        {36.539924,   8.72750275,     3, 6,  "TUN P00.XX"},
        {34.356024,   8.349745375,    3, 6,  "TUN Q00.XX"},
        {35.077124,   9.434219625,    3, 6,  "TUN R00.XX"},
        {36.900624,   11.033763125,   3, 4,  "TUN S00.XX"},
        {33.928324,   9.730284,       3, 4,  "TUN T00.XX"},
        {36.791924,   10.923363125,   3, 4,  "TUN V00.XX"},
        {33.956824,   8.083384,       3, 6,  "TUN W00.XX"},
        {36.599424,   10.77710275,    3, 4,  "TUN X00.XX"},
        {33.510624,   8.970823625,    3, 6,  "TUN Y00.XX"},
        {35.443324,   10.92418,       3, 4,  "TUN Z00.XX"},
        {33.795307,   7.692334,       2, 5,  "TUN 12.XXXX"},
        {37.3166065,  8.234238,       2, 3,  "TUN 123.XXX"},
        {30.395674,   8.449735,       2, 5,  "TUN 1234.XX"},
        {37.084138,   7.648873,       1, 5,  "TUN 1234.XXX"},
        {5.854445,    -55.21377375,   4, 5,  "SUR 00.XX"},
        {5.823057,    -55.15838875,   4, 5,  "SUR J0.XX"},
        {5.951915,    -55.394513,     3, 4,  "SUR 12.XXX"},
        {5.930204,    -57.07162475,   3, 5,  "SUR 000.XX"},
        {5.636504,    -54.49112475,   3, 4,  "SUR 400.XX"},
        {5.851104,    -54.96022475,   4, 5,  "SUR 800.XX"},
        {5.785804,    -56.76692475,   3, 5,  "SUR D00.XX"},
        {5.484994,    -54.17565075,   4, 7,  "SUR J00.XX"},
        {5.794294,    -55.56605075,   3, 4,  "SUR M00.XX"},
        {5.040394,    -55.260942875,  3, 5,  "SUR Q00.XX"},
        {5.040394,    -55.110767875,  3, 5,  "SUR T00.XX"},
        {5.829694,    -56.36995075,   3, 4,  "SUR X00.XX"},
        {5.981377,    -57.189711,     2, 6,  "SUR 012.XXX"},
        {5.981377,    -56.720991,     2, 4,  "SUR 112.XXX"},
        {5.981377,    -56.252271,     2, 3,  "SUR 212.XXX"},
        {5.981377,    -55.783551,     2, 3,  "SUR 312.XXX"},
        {5.981377,    -55.314831,     3, 4,  "SUR 412.XXX"},
        {5.981377,    -54.846111,     2, 3,  "SUR 512.XXX"},
        {5.907721,    -54.421935,     3, 4,  "SUR 612.XXX"},
        {5.490337,    -57.311578,     2, 5,  "SUR 712.XXX"},
        {5.490337,    -56.842858,     2, 4,  "SUR 812.XXX"},
        {5.490337,    -56.374138,     2, 3,  "SUR 912.XXX"},
        {5.490337,    -55.905418,     2, 3,  "SUR B12.XXX"},
        {5.490337,    -55.436698,     2, 3,  "SUR C12.XXX"},
        {5.490337,    -54.967978,     2, 3,  "SUR D12.XXX"},
        {5.490337,    -54.499258,     2, 3,  "SUR F12.XXX"},
        {4.999297,    -58.047468,     2, 6,  "SUR G12.XXX"},
        {4.999297,    -57.578748,     2, 6,  "SUR H12.XXX"},
        {4.999297,    -57.110028,     2, 6,  "SUR J12.XXX"},
        {4.999297,    -56.641308,     2, 5,  "SUR K12.XXX"},
        {4.999297,    -56.172588,     2, 4,  "SUR L12.XXX"},
        {4.999297,    -55.703868,     2, 4,  "SUR M12.XXX"},
        {4.999297,    -55.235148,     3, 5,  "SUR N12.XXX"},
        {4.999297,    -54.766428,     2, 4,  "SUR P12.XXX"},
        {4.508257,    -58.047468,     2, 6,  "SUR Q12.XXX"},
        {4.508257,    -57.578748,     2, 6,  "SUR R12.XXX"},
        {4.508257,    -57.110028,     2, 6,  "SUR S12.XXX"},
        {4.508257,    -56.641308,     2, 5,  "SUR T12.XXX"},
        {4.508257,    -56.172588,     2, 4,  "SUR V12.XXX"},
        {4.508257,    -55.703868,     2, 4,  "SUR W12.XXX"},
        {4.508257,    -55.235148,     2, 4,  "SUR X12.XXX"},
        {4.508257,    -54.766428,     2, 4,  "SUR Y12.XXX"},
        {4.017217,    -58.047468,     2, 6,  "SUR Z12.XXX"},
        {3.605377,    -57.578748,     2, 6,  "SUR 01.XXXX"},
        {3.605377,    -57.110028,     2, 6,  "SUR 11.XXXX"},
        {3.605377,    -56.641308,     2, 5,  "SUR 21.XXXX"},
        {3.605377,    -56.172588,     2, 4,  "SUR 31.XXXX"},
        {3.605377,    -55.703868,     2, 4,  "SUR 41.XXXX"},
        {3.605377,    -55.235148,     2, 4,  "SUR 51.XXXX"},
        {3.605377,    -54.766428,     2, 5,  "SUR 61.XXXX"},
        {3.605377,    -54.421935,     3, 6,  "SUR 71.XXXX"},
        {3.114337,    -57.695928,     2, 6,  "SUR 81.XXXX"},
        {3.114337,    -57.227208,     2, 6,  "SUR 91.XXXX"},
        {3.114337,    -56.758488,     2, 5,  "SUR B1.XXXX"},
        {3.114337,    -56.289768,     2, 4,  "SUR C1.XXXX"},
        {3.114337,    -55.821048,     2, 4,  "SUR D1.XXXX"},
        {3.114337,    -55.352328,     2, 4,  "SUR F1.XXXX"},
        {3.114337,    -54.883608,     2, 5,  "SUR G1.XXXX"},
        {3.114337,    -54.421935,     2, 5,  "SUR H1.XXXX"},
        {2.623297,    -57.250644,     2, 8,  "SUR J1.XXXX"},
        {2.623297,    -56.781924,     2, 7,  "SUR K1.XXXX"},
        {2.623297,    -56.313204,     2, 6,  "SUR L1.XXXX"},
        {2.623297,    -55.844484,     2, 6,  "SUR M1.XXXX"},
        {2.623297,    -55.375764,     2, 6,  "SUR N1.XXXX"},
        {2.623297,    -54.907044,     2, 7,  "SUR P1.XXXX"},
        {2.623297,    -54.438324,     2, 10, "SUR Q1.XXXX"},
        {2.132257,    -57.016284,     2, 9,  "SUR R1.XXXX"},
        {2.132257,    -56.547564,     2, 9,  "SUR S1.XXXX"},
        {2.132257,    -56.078844,     2, 6,  "SUR T1.XXXX"},
        {2.132257,    -55.610124,     2, 6,  "SUR V1.XXXX"},
        {2.132257,    -55.141404,     2, 6,  "SUR W1.XXXX"},
        {2.132257,    -54.672684,     2, 8,  "SUR X1.XXXX"},
        {1.848497,    -56.735052,     3, 10, "SUR Y1.XXXX"},
        {1.848497,    -56.266332,     3, 9,  "SUR Z1.XXXX"},
        {2.0119755,   -56.7466455,    3, 10, "SUR Y123.XX"},
        {2.0119755,   -56.2779255,    3, 9,  "SUR Z123.XX"},
        {5.83313,     -55.1870315,    4, 5,  "SUR P1WF.TTJ"},
        {-34.8505,    -56.2154085,    4, 5,  "URY 12.XX"},
        {-34.8709025, -56.4476055,    3, 4,  "URY 12.XXX"},
        {-31.401486,  -58.0055945,    3, 9,  "URY 000.XX"},
        {-32.270205,  -58.115735,     3, 8,  "URY 200.XX"},
        {-30.860476,  -55.573520875,  3, 9,  "URY 300.XX"},
        {-34.888455,  -55.004720875,  3, 4,  "URY 400.XX"},
        {-34.888455,  -54.912077875,  3, 4,  "URY 500.XX"},
        {-31.664076,  -56.02798525,   3, 7,  "URY 600.XX"},
        {-32.326076,  -54.206012,     3, 7,  "URY 700.XX"},
        {-33.211276,  -58.078476375,  3, 8,  "URY 800.XX"},
        {-30.359276,  -56.513894125,  3, 7,  "URY 900.XX"},
        {-34.340576,  -55.292154625,  3, 4,  "URY B00.XX"},
        {-34.295476,  -56.753054625,  3, 4,  "URY C00.XX"},
        {-34.059276,  -56.268816,     3, 4,  "URY D00.XX"},
        {-34.392476,  -57.883254625,  3, 6,  "URY F00.XX"},
        {-33.109976,  -58.358276375,  3, 8,  "URY G00.XX"},
        {-33.340776,  -56.571176375,  3, 7,  "URY H00.XX"},
        {-34.438476,  -54.376254625,  3, 4,  "URY J00.XX"},
        {-34.751476,  -54.968980375,  3, 4,  "URY K00.XX"},
        {-33.191476,  -54.433476375,  3, 7,  "URY L00.XX"},
        {-34.483876,  -56.329654625,  3, 4,  "URY M00.XX"},
        {-33.476276,  -56.946376375,  3, 7,  "URY N00.XX"},
        {-33.948376,  -58.356716,     3, 7,  "URY P00.XX"},
        {-34.403376,  -56.456054625,  3, 4,  "URY Q00.XX"},
        {-32.573976,  -53.433050625,  3, 7,  "URY R00.XX"},
        {-32.663676,  -57.678250625,  3, 7,  "URY S00.XX"},
        {-33.490076,  -58.265576375,  3, 8,  "URY T00.XX"},
        {-30.217776,  -57.637494125,  3, 9,  "URY V00.XX"},
        {-32.769276,  -56.558250625,  3, 7,  "URY W00.XX"},
        {-34.362076,  -57.496454625,  3, 4,  "URY X00.XX"},
        {-33.653676,  -53.507516,     3, 7,  "URY Y00.XX"},
        {-34.274976,  -57.298154625,  3, 4,  "URY Z00.XX"},
        {-34.3699475, -58.326136,     2, 6,  "URY 123.XXX"},
        {-33.3043885, -58.1878965,    2, 7,  "URY 12.XXXX"},
        {-31.486369,  -58.0765105,    2, 7,  "URY 1234.XX"},
        {-34.8856,    -56.1695195,    4, 5,  "URY FZBF.G0T"},
        {11.5971,     104.8650515,    4, 7,  "KHM 12.XX"},
        {11.811219,   104.7077115,    3, 6,  "KHM 12.XXX"},
        {10.596514,   103.47157175,   3, 6,  "KHM 000.XX"},
        {13.081914,   103.111363125,  3, 6,  "KHM 200.XX"},
        {13.362214,   103.78629325,   3, 6,  "KHM 400.XX"},
        {13.640414,   102.54139325,   3, 6,  "KHM 600.XX"},
        {12.277424,   104.601316,     3, 6,  "KHM 800.XX"},
        {11.531024,   105.314729875,  3, 7,  "KHM 900.XX"},
        {12.579724,   103.877416,     3, 6,  "KHM B00.XX"},
        {11.021724,   104.73664275,   3, 6,  "KHM C00.XX"},
        {11.523524,   104.483329875,  3, 6,  "KHM D00.XX"},
        {11.854424,   106.128529875,  4, 6,  "KHM F00.XX"},
        {12.098024,   105.057629875,  3, 6,  "KHM G00.XX"},
        {13.610024,   102.94649025,   3, 6,  "KHM H00.XX"},
        {12.520724,   105.988416,     3, 5,  "KHM J00.XX"},
        {10.650724,   104.13864275,   3, 6,  "KHM K00.XX"},
        {12.760724,   104.848303125,  3, 6,  "KHM L00.XX"},
        {11.645924,   102.931229875,  3, 6,  "KHM M00.XX"},
        {11.120724,   105.758529875,  3, 6,  "KHM N00.XX"},
        {10.559824,   104.27954275,   3, 6,  "KHM P00.XX"},
        {12.490724,   107.148416,     3, 5,  "KHM Q00.XX"},
        {14.002324,   106.74619025,   3, 7,  "KHM R00.XX"},
        {13.560024,   105.93699025,   3, 5,  "KHM S00.XX"},
        {12.909324,   102.565703125,  3, 6,  "KHM T00.XX"},
        {12.562024,   104.153316,     3, 6,  "KHM V00.XX"},
        {12.016724,   105.412029875,  4, 7,  "KHM W00.XX"},
        {12.795924,   103.419803125,  3, 6,  "KHM X00.XX"},
        {9.964924,    102.869955625,  2, 5,  "KHM Y00.XX"},
        {9.326545,    103.4502275,    2, 5,  "KHM Z00.XX"},
        {11.557803,   102.8020795,    2, 5,  "KHM 123.XXX"},
        {12.424046,   105.430209,     2, 5,  "KHM 1234.XX"},
        {13.774606,   102.492781,     2, 5,  "KHM 12.XXXX"},
        {11.98748,    104.985,        2, 5,  "KHM MMH7.0KC"},
        {33.5537,     36.2484335,     4, 7,  "SYR 12.XX"},
        {33.540975,   36.113863125,   3, 6,  "SYR 00.XXX"},
        {36.220814,   36.991280625,   3, 5,  "SYR J0.XXX"},
        {34.706814,   36.638119625,   3, 4,  "SYR 000.XX"},
        {35.586644,   35.717275,      3, 4,  "SYR 200.XX"},
        {35.096814,   36.683219625,   3, 4,  "SYR 400.XX"},
        {35.376724,   40.09128,       3, 5,  "SYR 600.XX"},
        {36.548524,   40.69330275,    3, 6,  "SYR 700.XX"},
        {37.090734,   41.189844625,   3, 6,  "SYR 800.XX"},
        {35.982434,   38.929776875,   3, 6,  "SYR 900.XX"},
        {34.931024,   35.866219625,   3, 4,  "SYR B00.XX"},
        {35.991124,   36.614141375,   3, 5,  "SYR C00.XX"},
        {32.679124,   36.040749375,   3, 7,  "SYR D00.XX"},
        {35.865524,   38.490641375,   3, 5,  "SYR F00.XX"},
        {36.567224,   37.90440275,    3, 5,  "SYR G00.XX"},
        {32.761824,   36.539049375,   3, 6,  "SYR H00.XX"},
        {35.051824,   36.998519625,   3, 4,  "SYR J00.XX"},
        {35.685724,   36.64488,       3, 4,  "SYR K00.XX"},
        {35.410224,   35.91608,       3, 4,  "SYR L00.XX"},
        {35.853524,   36.272241375,   3, 5,  "SYR M00.XX"},
        {36.413424,   37.48220275,    3, 5,  "SYR N00.XX"},
        {32.933724,   35.993749375,   3, 6,  "SYR P00.XX"},
        {34.491524,   40.868845375,   3, 5,  "SYR Q00.XX"},
        {35.259545,   35.922775,      3, 4,  "SYR R00.XX"},
        {34.590724,   38.230845375,   3, 4,  "SYR S00.XX"},
        {35.860624,   36.563141375,   3, 5,  "SYR T00.XX"},
        {35.061024,   40.392819625,   3, 5,  "SYR V00.XX"},
        {34.040424,   36.647484,      3, 4,  "SYR W00.XX"},
        {33.191324,   35.819023625,   3, 8,  "SYR X00.XX"},
        {34.962624,   36.686119625,   3, 4,  "SYR Y00.XX"},
        {34.578024,   36.520145375,   3, 6,  "SYR Z00.XX"},
        {36.4667905,  35.840603,      2, 4,  "SYR 123.XXX"},
        {34.1549565,  35.779189,      2, 6,  "SYR 12.XXXX"},
        {34.6069785,  39.6455335,     2, 4,  "SYR 1234.XX"},
        {34.8179,     38.98345,       2, 4,  "SYR B84Z.MSN"},
        {14.6542225,  -17.487378,     4, 5,  "SEN 12.XX"},
        {14.801395,   -17.5039835,    3, 4,  "SEN 12.XXX"},
        {14.201624,   -16.11630975,   3, 4,  "SEN 000.XX"},
        {12.576545,   -16.312496,     3, 6,  "SEN 100.XX"},
        {14.470724,   -17.022622625,  3, 4,  "SEN 200.XX"},
        {16.062124,   -16.51246125,   3, 5,  "SEN 300.XX"},
        {14.906545,   -15.9337675,    3, 5,  "SEN 400.XX"},
        {14.836545,   -15.9337675,    3, 5,  "SEN 500.XX"},
        {14.692124,   -16.273022625,  3, 4,  "SEN 600.XX"},
        {15.664724,   -16.265848375,  3, 5,  "SEN 700.XX"},
        {16.469395,   -15.726765625,  3, 6,  "SEN 800.XX"},
        {13.794824,   -13.72180975,   3, 4,  "SEN 900.XX"},
        {12.950724,   -14.991696875,  3, 4,  "SEN B00.XX"},
        {14.374024,   -16.447722625,  3, 4,  "SEN C00.XX"},
        {12.841524,   -16.269696875,  3, 4,  "SEN D00.XX"},
        {14.217724,   -16.87100975,   3, 4,  "SEN F00.XX"},
        {13.786224,   -15.81890975,   3, 5,  "SEN G00.XX"},
        {12.744124,   -15.593496875,  3, 4,  "SEN H00.XX"},
        {15.362064,   -15.507731125,  3, 5,  "SEN J00.XX"},
        {13.627504,   -15.61287875,   3, 5,  "SEN JK0.00"},
        {14.119064,   -15.58677325,   3, 4,  "SEN K00.XX"},
        {14.700404,   -16.491850625,  3, 4,  "SEN KK0.00"},
        {16.525264,   -15.536802375,  3, 6,  "SEN L00.XX"},
        {13.144104,   -14.13677875,   3, 5,  "SEN LK0.00"},
        {15.124964,   -16.6656455,    3, 5,  "SEN M00.XX"},
        {15.364504,   -16.472195375,  3, 5,  "SEN MK0.00"},
        {12.571464,   -12.216502,     3, 7,  "SEN N00.XX"},
        {14.262304,   -15.971750625,  3, 4,  "SEN NK0.00"},
        {13.989364,   -14.83527325,   3, 4,  "SEN P00.XX"},
        {13.876704,   -16.38297875,   3, 4,  "SEN PK0.00"},
        {14.767164,   -16.7133455,    3, 5,  "SEN Q00.XX"},
        {13.127604,   -13.789205875,  3, 4,  "SEN QK0.00"},
        {12.745164,   -14.207287625,  3, 4,  "SEN R00.XX"},
        {15.594104,   -13.346995375,  3, 6,  "SEN RK0.00"},
        {15.425264,   -15.162731125,  3, 5,  "SEN S00.XX"},
        {15.243604,   -12.904495375,  3, 6,  "SEN SK0.00"},
        {14.517564,   -16.111158875,  3, 4,  "SEN T00.XX"},
        {14.901804,   -12.4872235,    3, 6,  "SEN TK0.00"},
        {12.565264,   -15.889802,     3, 6,  "SEN V00.XX"},
        {12.868304,   -14.514505875,  3, 4,  "SEN VK0.00"},
        {13.802464,   -16.52177325,   3, 5,  "SEN W00.XX"},
        {12.812104,   -15.987805875,  3, 4,  "SEN WK0.00"},
        {13.932464,   -15.96177325,   3, 4,  "SEN X00.XX"},
        {12.774004,   -16.529305875,  3, 4,  "SEN XK0.00"},
        {14.448364,   -16.747858875,  3, 4,  "SEN Y00.XX"},
        {16.658004,   -14.997540125,  2, 5,  "SEN YK0.00"},
        {12.484364,   -16.569302,     3, 6,  "SEN Z00.XX"},
        {14.184104,   -16.696850625,  3, 4,  "SEN ZK0.00"},
        {12.997835,   -16.651282,     2, 3,  "SEN 12.XXXX"},
        {13.9158515,  -17.5392165,    2, 3,  "SEN 123.XXX"},
        {14.2165265,  -15.100738,     2, 3,  "SEN 1234.XX"},
        {16.388475,   -17.3929165,    2, 3,  "SEN 1234.XXX"},
        {42.8965,     74.538638,      4, 7,  "KGZ 12.XX"},
        {42.848965,   73.823437,      3, 6,  "KGZ 12.XXX"},
        {40.504814,   72.733309125,   3, 6,  "KGZ 000.XX"},
        {40.909114,   72.880309125,   3, 6,  "KGZ 200.XX"},
        {42.481614,   78.3104415,     3, 9,  "KGZ 400.XX"},
        {42.807614,   75.204462,      4, 8,  "KGZ 600.XX"},
        {41.436545,   75.8902975,     3, 4,  "KGZ 800.XX"},
        {42.540945,   72.161305,      3, 7,  "KGZ 900.XX"},
        {40.266545,   72.025293125,   3, 6,  "KGZ B00.XX"},
        {40.828624,   73.252251125,   3, 4,  "KGZ C00.XX"},
        {42.496724,   76.1313085,     3, 6,  "KGZ D00.XX"},
        {41.067024,   72.7111125,     3, 6,  "KGZ F00.XX"},
        {40.755024,   72.837651125,   3, 6,  "KGZ G00.XX"},
        {41.390724,   72.1662125,     3, 6,  "KGZ H00.XX"},
        {41.300724,   72.3962125,     3, 6,  "KGZ J00.XX"},
        {41.720724,   74.38576,       3, 4,  "KGZ K00.XX"},
        {41.923324,   72.90056,       3, 6,  "KGZ L00.XX"},
        {40.821824,   72.952351125,   3, 6,  "KGZ M00.XX"},
        {42.844024,   75.656256,      3, 7,  "KGZ N00.XX"},
        {42.386024,   77.9548085,     3, 9,  "KGZ P00.XX"},
        {41.204624,   75.7620125,     3, 4,  "KGZ Q00.XX"},
        {39.917545,   69.492290625,   3, 7,  "KGZ R00.XX"},
        {42.139734,   76.9162625,     3, 8,  "KGZ S00.XX"},
        {41.081724,   72.2940125,     3, 6,  "KGZ T00.XX"},
        {39.940545,   69.554293125,   3, 7,  "KGZ V00.XX"},
        {41.211024,   75.8674125,     3, 4,  "KGZ W00.XX"},
        {42.770724,   78.304856,      3, 10, "KGZ X00.XX"},
        {42.790724,   75.534856,      3, 7,  "KGZ Y00.XX"},
        {42.679834,   77.021684,      3, 8,  "KGZ Z00.XX"},
        {42.765196,   71.091851,      2, 8,  "KGZ 123.XXX"},
        {41.90903,    70.637704,      2, 8,  "KGZ 12.XXXX"},
        {40.160281,   69.546539,      2, 8,  "KGZ 0HHH.HH"},
        {39.732241,   69.84115,       2, 4,  "KGZ 1123.XX"},
        {41.693535,   73.859685,      3, 4,  "KGZ 2123.XX"},
        {41.693535,   74.484645,      3, 4,  "KGZ 3123.XX"},
        {41.693535,   75.109605,      2, 3,  "KGZ 4123.XX"},
        {41.693535,   75.734565,      2, 3,  "KGZ 5123.XX"},
        {41.693535,   76.359525,      2, 3,  "KGZ 6123.XX"},
        {41.693535,   76.984485,      2, 5,  "KGZ 7123.XX"},
        {41.693535,   77.609445,      2, 5,  "KGZ 8123.XX"},
        {41.693535,   78.234405,      2, 6,  "KGZ 9123.XX"},
        {41.693535,   78.859365,      2, 6,  "KGZ B123.XX"},
        {41.202495,   73.8648645,     3, 4,  "KGZ C123.XX"},
        {41.202495,   74.4846165,     2, 3,  "KGZ D123.XX"},
        {41.202495,   75.1043685,     2, 3,  "KGZ F123.XX"},
        {41.202495,   75.7241205,     2, 3,  "KGZ G123.XX"},
        {41.202495,   76.3438725,     2, 3,  "KGZ H123.XX"},
        {41.202495,   76.9636245,     2, 5,  "KGZ J123.XX"},
        {41.202495,   77.5833765,     2, 5,  "KGZ K123.XX"},
        {41.5350065,  78.2247015,     2, 6,  "KGZ L123.XX"},
        {40.711455,   73.864836,      3, 5,  "KGZ M123.XX"},
        {40.711455,   74.47938,       2, 4,  "KGZ N123.XX"},
        {40.711455,   75.093923,      2, 4,  "KGZ P123.XX"},
        {40.711455,   75.708468,      2, 4,  "KGZ Q123.XX"},
        {40.711455,   76.323012,      2, 4,  "KGZ R123.XX"},
        {40.983485,   76.957238,      2, 6,  "KGZ S123.XX"},
        {40.220415,   73.8726185,     3, 7,  "KGZ T123.XX"},
        {40.220415,   74.4819545,     2, 6,  "KGZ V123.XX"},
        {40.220415,   75.0912905,     2, 6,  "KGZ W123.XX"},
        {40.220415,   75.7006265,     2, 6,  "KGZ X123.XX"},
        {40.220415,   76.3099625,     2, 6,  "KGZ Y123.XX"},
        {39.729375,   73.87259,       3, 7,  "KGZ Z123.XX"},
        {41.2207,     74.7395995,     2, 3,  "KGZ RY4V.V26"},
        {53.9365,     27.4879095,     4, 5,  "BLR 12.XX"},
        {53.976104,   27.346040125,   3, 4,  "BLR 00.XXX"},
        {52.496104,   30.793456375,   3, 5,  "BLR 80.XXX"},
        {53.966404,   30.123140125,   3, 4,  "BLR J0.XXX"},
        {55.091384,   29.9821015,     3, 5,  "BLR S0.XXX"},
        {53.719544,   23.729404125,   3, 5,  "BLR 000.XX"},
        {53.719544,   23.832101125,   3, 5,  "BLR 100.XX"},
        {52.148844,   23.593927375,   3, 6,  "BLR 200.XX"},
        {52.148844,   23.692890375,   3, 6,  "BLR 300.XX"},
        {53.189485,   29.14017375,    3, 4,  "BLR 400.XX"},
        {53.178024,   25.95322675,    3, 4,  "BLR 500.XX"},
        {54.258845,   28.4493825,     3, 4,  "BLR 600.XX"},
        {52.153145,   26.007132375,   3, 5,  "BLR 700.XX"},
        {54.550724,   30.3408445,     3, 4,  "BLR 800.XX"},
        {52.094024,   29.178621875,   3, 5,  "BLR 900.XX"},
        {52.860324,   27.46833075,    3, 4,  "BLR B00.XX"},
        {55.533034,   28.5088925,     3, 5,  "BLR C00.XX"},
        {53.943524,   25.229135625,   3, 6,  "BLR D00.XX"},
        {54.354724,   26.7846445,     3, 4,  "BLR F00.XX"},
        {55.531124,   28.7161365,     3, 5,  "BLR G00.XX"},
        {52.636545,   29.63996875,    3, 4,  "BLR H00.XX"},
        {52.411924,   30.324021875,   3, 4,  "BLR J00.XX"},
        {52.931324,   29.94403075,    3, 4,  "BLR K00.XX"},
        {53.070724,   27.48242675,    3, 4,  "BLR L00.XX"},
        {52.250724,   24.284121875,   3, 5,  "BLR M00.XX"},
        {53.748324,   31.642935625,   3, 9,  "BLR N00.XX"},
        {54.112464,   28.2815445,     3, 4,  "BLR P00.XX"},
        {53.079904,   29.98771975,    3, 4,  "BLR PK0.00"},
        {53.101164,   25.27324725,    3, 4,  "BLR Q00.XX"},
        {53.150004,   24.39921975,    3, 4,  "BLR QK0.00"},
        {52.139264,   29.276335625,   3, 5,  "BLR R00.XX"},
        {54.481104,   26.3522065,     3, 4,  "BLR RK0.00"},
        {53.319464,   28.57504725,    3, 4,  "BLR S00.XX"},
        {54.280304,   30.9317065,     3, 6,  "BLR SK0.00"},
        {52.556064,   24.90353425,    3, 4,  "BLR T00.XX"},
        {53.591604,   25.769713625,   3, 4,  "BLR TK0.00"},
        {54.512564,   26.8569445,     3, 4,  "BLR V00.XX"},
        {52.545704,   24.40409875,    3, 4,  "BLR VK0.00"},
        {53.702464,   27.088045875,   3, 4,  "BLR W00.XX"},
        {53.504104,   28.106213625,   3, 4,  "BLR WK0.00"},
        {55.132464,   26.7860705,     3, 6,  "BLR X00.XX"},
        {52.245104,   26.766505875,   3, 5,  "BLR XK0.00"},
        {53.535964,   30.169045875,   3, 4,  "BLR Y00.XX"},
        {52.405504,   31.275005875,   3, 8,  "BLR YK0.00"},
        {54.892764,   28.6463575,     3, 4,  "BLR Z00.XX"},
        {53.596304,   31.900513625,   3, 11, "BLR ZK0.00"},
        {53.825522,   23.3442365,     2, 4,  "BLR 123.XXX"},
        {53.665681,   28.320425,      2, 3,  "BLR 12.XXXX"},
        {55.070304,   25.359242,      2, 5,  "BLR 1234.XX"},
        {53.717191,   27.9867085,     2, 3,  "BLR RK0G.QP4"},
        {6.782793,    -58.200399,     4, 5,  "GUY 12.XX"},
        {6.654079,    -58.514215,     3, 4,  "GUY 12.XXX"},
        {5.968704,    -58.39122475,   3, 4,  "GUY 000.XX"},
        {6.249304,    -57.61052475,   3, 4,  "GUY 400.XX"},
        {6.249304,    -57.43658475,   3, 4,  "GUY 800.XX"},
        {5.907404,    -57.28842475,   3, 4,  "GUY D00.XX"},
        {7.257794,    -58.608258625,  3, 4,  "GUY J00.XX"},
        {6.384394,    -58.72485075,   3, 4,  "GUY M00.XX"},
        {6.467894,    -57.74825075,   3, 4,  "GUY Q00.XX"},
        {6.392894,    -57.70245075,   3, 4,  "GUY T00.XX"},
        {6.554994,    -57.85915075,   3, 4,  "GUY X00.XX"},
        {4.854064,    -59.622863,     2, 7,  "GUY 12.XXXX"},
        {5.5091735,   -59.3394535,    2, 3,  "GUY 123.XXX"},
        {7.164254,    -61.3509115,    2, 4,  "GUY 1234.XX"},
        {8.046152,    -61.2508525,    2, 4,  "GUY 1234.XXX"},
        {17.988645,   102.52023625,   4, 7,  "LAO 00.XX"},
        {17.942215,   102.61171125,   4, 7,  "LAO J0.XX"},
        {18.241271,   102.399255,     3, 6,  "LAO 12.XXX"},
        {16.550514,   104.686343875,  3, 6,  "LAO 000.XX"},
        {15.10886,    105.7518145,    3, 5,  "LAO 200.XX"},
        {20.400514,   103.974985875,  4, 7,  "LAO 400.XX"},
        {17.386031,   104.740925125,  3, 6,  "LAO 600.XX"},
        {19.870514,   102.07515575,   3, 5,  "LAO 800.XX"},
        {14.795648,   106.7751165,    3, 5,  "LAO B00.XX"},
        {18.378786,   103.58317225,   3, 6,  "LAO D00.XX"},
        {20.947221,   101.339008,     3, 4,  "LAO G00.XX"},
        {21.170514,   101.08447725,   3, 9,  "LAO J00.XX"},
        {19.380724,   103.3270605,    3, 6,  "LAO L00.XX"},
        {15.760724,   106.367851625,  3, 5,  "LAO M00.XX"},
        {21.737432,   102.062053375,  3, 8,  "LAO N00.XX"},
        {19.127288,   101.4802905,    3, 5,  "LAO P00.XX"},
        {14.943499,   105.8522355,    3, 5,  "LAO Q00.XX"},
        {20.840724,   104.256608,     3, 5,  "LAO R00.XX"},
        {15.620724,   105.757851625,  3, 5,  "LAO S00.XX"},
        {18.532585,   102.391005375,  3, 6,  "LAO T00.XX"},
        {14.153471,   105.81879825,   3, 7,  "LAO V00.XX"},
        {18.954332,   102.407328375,  3, 6,  "LAO W00.XX"},
        {20.350724,   101.606721875,  3, 5,  "LAO X00.XX"},
        {15.450724,   106.657851625,  3, 5,  "LAO Y00.XX"},
        {18.272788,   104.14739025,   3, 6,  "LAO Z00.XX"},
        {16.333525,   105.125316,     2, 5,  "LAO 12.XXXX"},
        {20.3646265,  101.4060825,    2, 4,  "LAO 123.XXX"},
        {16.338624,   104.5156815,    2, 5,  "LAO 0123.XX"},
        {20.369669,   103.9210705,    3, 6,  "LAO 1123.XX"},
        {17.171426,   104.562828,     2, 5,  "LAO 2123.XX"},
        {20.844263,   101.029677,     2, 4,  "LAO 3123.XX"},
        {21.465332,   101.858537,     2, 7,  "LAO 4123.XX"},
        {18.000688,   103.948008,     3, 6,  "LAO 5123.XX"},
        {18.203415,   103.890324,     2, 5,  "LAO JKN0.DX0"},
        {44.4751,     26.0478555,     4, 6,  "ROU 12.XX"},
        {44.506104,   25.931601125,   3, 5,  "ROU 00.XXX"},
        {47.226104,   27.393010125,   3, 7,  "ROU 80.XXX"},
        {46.826104,   23.424695,      3, 5,  "ROU J0.XXX"},
        {45.654684,   21.066310875,   3, 6,  "ROU S0.XXX"},
        {44.222645,   28.572313125,   3, 4,  "ROU 000.XX"},
        {44.359824,   23.758187625,   3, 4,  "ROU 100.XX"},
        {45.480724,   27.98237075,    3, 5,  "ROU 200.XX"},
        {45.693924,   25.55587075,    3, 5,  "ROU 300.XX"},
        {44.980724,   25.972935125,   3, 5,  "ROU 400.XX"},
        {45.317924,   27.89867075,    3, 5,  "ROU 500.XX"},
        {47.105324,   21.862775625,   3, 6,  "ROU 600.XX"},
        {46.620724,   26.86124,       3, 5,  "ROU 700.XX"},
        {46.223124,   21.26984,       3, 7,  "ROU 800.XX"},
        {44.900724,   24.812935125,   3, 5,  "ROU 900.XX"},
        {45.831024,   24.081105375,   3, 5,  "ROU B00.XX"},
        {46.594524,   24.50454,       3, 5,  "ROU C00.XX"},
        {47.700724,   23.52011025,    3, 5,  "ROU D00.XX"},
        {45.190724,   26.76237075,    3, 5,  "ROU F00.XX"},
        {47.830724,   22.829545875,   3, 7,  "ROU G00.XX"},
        {47.756464,   26.615757625,   3, 7,  "ROU H00.XX"},
        {45.105204,   24.331251125,   3, 5,  "ROU HK0.00"},
        {47.671664,   26.19588675,    3, 5,  "ROU J00.XX"},
        {46.927704,   26.331603625,   3, 5,  "ROU JK0.00"},
        {44.644945,   22.606415625,   3, 7,  "ROU K00.XX"},
        {45.679304,   27.131127375,   3, 5,  "ROU KK0.00"},
        {45.060964,   23.227633375,   3, 5,  "ROU L00.XX"},
        {45.180104,   28.75828875,    3, 5,  "ROU LK0.00"},
        {44.943264,   25.407333375,   3, 5,  "ROU M00.XX"},
        {45.307304,   21.85428875,    3, 4,  "ROU MK0.00"},
        {47.152464,   24.454915875,   3, 5,  "ROU N00.XX"},
        {44.415504,   24.323240625,   3, 5,  "ROU NK0.00"},
        {45.776764,   22.867775125,   3, 5,  "ROU P00.XX"},
        {46.641604,   27.680865,      3, 5,  "ROU PK0.00"},
        {44.221264,   27.283076875,   3, 4,  "ROU Q00.XX"},
        {43.893304,   25.924402,      3, 6,  "ROU QK0.00"},
        {46.942464,   26.884915875,   3, 5,  "ROU R00.XX"},
        {45.880704,   22.884127375,   3, 5,  "ROU RK0.00"},
        {46.225764,   27.626145,      3, 5,  "ROU S00.XX"},
        {46.074104,   23.532727375,   3, 5,  "ROU SK0.00"},
        {47.192464,   23.014915875,   3, 5,  "ROU T00.XX"},
        {45.870904,   25.768627375,   3, 5,  "ROU TK0.00"},
        {46.582464,   23.735345,      3, 5,  "ROU V00.XX"},
        {46.159804,   24.313827375,   3, 5,  "ROU VK0.00"},
        {44.592964,   27.330576875,   3, 5,  "ROU W00.XX"},
        {46.244404,   26.746065,      3, 5,  "ROU WK0.00"},
        {43.989764,   25.270706,      3, 4,  "ROU X00.XX"},
        {45.404104,   23.34308875,    3, 5,  "ROU XK0.00"},
        {45.702464,   21.865775125,   3, 4,  "ROU Y00.XX"},
        {44.258204,   28.261440625,   3, 4,  "ROU YK0.00"},
        {45.865964,   27.385875125,   3, 5,  "ROU Z00.XX"},
        {46.364104,   25.772365,      3, 5,  "ROU ZK0.00"},
        {48.080974,   22.8036535,     2, 6,  "ROU 01.XXXX"},
        {47.912628,   23.7270605,     2, 4,  "ROU 11.XXXX"},
        {47.8641425,  25.243299,      2, 4,  "ROU 21.XXXX"},
        {47.883818,   25.9374595,     2, 4,  "ROU 31.XXXX"},
        {47.883818,   26.617772,      2, 6,  "ROU 41.XXXX"},
        {47.390118,   21.9362495,     2, 5,  "ROU 51.XXXX"},
        {47.424732,   22.5734555,     2, 4,  "ROU 61.XXXX"},
        {47.424732,   23.2094555,     2, 4,  "ROU 71.XXXX"},
        {47.424732,   23.8454555,     2, 4,  "ROU 81.XXXX"},
        {47.424732,   24.4814555,     2, 4,  "ROU 91.XXXX"},
        {47.424732,   25.1174555,     2, 4,  "ROU B1.XXXX"},
        {47.424732,   25.7534555,     2, 4,  "ROU C1.XXXX"},
        {47.424732,   26.3894555,     2, 4,  "ROU D1.XXXX"},
        {47.424732,   27.0253865,     2, 4,  "ROU F1.XXXX"},
        {46.865475,   21.549776,      2, 5,  "ROU G1.XXXX"},
        {46.865475,   22.213776,      2, 4,  "ROU H1.XXXX"},
        {46.865475,   22.877776,      2, 4,  "ROU J1.XXXX"},
        {46.865475,   23.541776,      3, 5,  "ROU K1.XXXX"},
        {46.865475,   24.205776,      2, 4,  "ROU L1.XXXX"},
        {46.865475,   24.869776,      2, 4,  "ROU M1.XXXX"},
        {46.865475,   25.533776,      2, 4,  "ROU N1.XXXX"},
        {46.865475,   26.197776,      2, 4,  "ROU P1.XXXX"},
        {46.865475,   26.861776,      2, 4,  "ROU Q1.XXXX"},
        {46.865475,   27.5254905,     2, 4,  "ROU R1.XXXX"},
        {46.336243,   21.137139,      2, 6,  "ROU S1.XXXX"},
        {46.336243,   21.789139,      2, 3,  "ROU T1.XXXX"},
        {46.336243,   22.441139,      2, 4,  "ROU V1.XXXX"},
        {46.336243,   23.093139,      2, 4,  "ROU W1.XXXX"},
        {46.336243,   23.745139,      2, 4,  "ROU X1.XXXX"},
        {46.336243,   24.397139,      2, 4,  "ROU Y1.XXXX"},
        {46.336243,   25.049139,      2, 4,  "ROU Z1.XXXX"},
        {46.766257,   25.701139,      2, 4,  "ROU 012.XXX"},
        {46.766257,   26.353139,      2, 4,  "ROU 112.XXX"},
        {46.766257,   27.005139,      2, 4,  "ROU 212.XXX"},
        {46.766257,   27.6569535,     2, 4,  "ROU 312.XXX"},
        {45.740808,   20.274405,      2, 5,  "ROU 412.XXX"},
        {45.740808,   20.881405,      2, 3,  "ROU 512.XXX"},
        {46.254024,   21.5087445,     2, 3,  "ROU 612.XXX"},
        {46.254024,   22.1157445,     2, 3,  "ROU 712.XXX"},
        {46.254024,   22.7227445,     2, 4,  "ROU 812.XXX"},
        {46.254024,   23.3297445,     2, 4,  "ROU 912.XXX"},
        {46.254024,   23.9367445,     2, 4,  "ROU B12.XXX"},
        {46.254024,   24.5437445,     2, 4,  "ROU C12.XXX"},
        {46.254024,   25.1507445,     2, 4,  "ROU D12.XXX"},
        {46.254024,   25.7577445,     2, 4,  "ROU F12.XXX"},
        {46.254024,   26.3647445,     2, 4,  "ROU G12.XXX"},
        {46.254024,   26.972035,      2, 4,  "ROU H12.XXX"},
        {46.254024,   27.5842225,     2, 4,  "ROU J12.XXX"},
        {45.707793,   20.796535,      2, 5,  "ROU K12.XXX"},
        {45.707793,   21.437535,      2, 3,  "ROU L12.XXX"},
        {45.707793,   22.078535,      2, 3,  "ROU M12.XXX"},
        {45.707793,   22.719535,      2, 4,  "ROU N12.XXX"},
        {45.707793,   23.360535,      2, 4,  "ROU P12.XXX"},
        {45.707793,   24.001535,      2, 4,  "ROU Q12.XXX"},
        {45.707793,   24.642535,      2, 4,  "ROU R12.XXX"},
        {45.707793,   25.283535,      2, 4,  "ROU S12.XXX"},
        {45.707793,   25.924535,      2, 4,  "ROU T12.XXX"},
        {45.707793,   26.565535,      2, 4,  "ROU V12.XXX"},
        {45.707793,   27.206535,      3, 5,  "ROU W12.XXX"},
        {45.707793,   27.8473495,     2, 4,  "ROU X12.XXX"},
        {45.4396175,  28.5066465,     2, 4,  "ROU Y12.XXX"},
        {45.0976855,  21.3803305,     2, 5,  "ROU Z12.XXX"},
        {44.720256,   22.103648,      3, 6,  "ROU 0123.XX"},
        {44.720256,   22.737648,      2, 6,  "ROU 1123.XX"},
        {44.720256,   23.371648,      2, 4,  "ROU 2123.XX"},
        {44.720256,   24.005648,      2, 4,  "ROU 3123.XX"},
        {44.720256,   24.639648,      2, 4,  "ROU 4123.XX"},
        {44.720256,   25.273648,      2, 4,  "ROU 5123.XX"},
        {44.720256,   25.907648,      2, 4,  "ROU 6123.XX"},
        {44.720256,   26.541648,      2, 4,  "ROU 7123.XX"},
        {44.720256,   27.175648,      2, 4,  "ROU 8123.XX"},
        {44.720256,   27.809648,      2, 4,  "ROU 9123.XX"},
        {44.720256,   28.443648,      2, 4,  "ROU B123.XX"},
        {44.720256,   29.077648,      2, 4,  "ROU C123.XX"},
        {44.635922,   21.5909905,     2, 5,  "ROU D123.XX"},
        {44.180265,   22.4537335,     2, 7,  "ROU F123.XX"},
        {44.180265,   23.1137335,     2, 5,  "ROU G123.XX"},
        {44.180265,   23.7737335,     2, 5,  "ROU H123.XX"},
        {44.180265,   24.4337335,     2, 3,  "ROU J123.XX"},
        {44.180265,   25.0937335,     2, 3,  "ROU K123.XX"},
        {44.180265,   25.7537335,     2, 5,  "ROU L123.XX"},
        {44.180265,   26.4137335,     2, 5,  "ROU M123.XX"},
        {44.180265,   27.0737335,     2, 5,  "ROU N123.XX"},
        {44.180265,   27.7337335,     2, 5,  "ROU P123.XX"},
        {44.180265,   28.3937335,     2, 3,  "ROU Q123.XX"},
        {44.109404,   22.843451,      2, 7,  "ROU R123.XX"},
        {43.6767765,  23.473477,      2, 5,  "ROU S123.XX"},
        {43.6767765,  24.103477,      2, 5,  "ROU T123.XX"},
        {43.6670015,  24.7335625,     2, 5,  "ROU V123.XX"},
        {43.6670015,  25.3435625,     2, 5,  "ROU W123.XX"},
        {43.987175,   25.975143,      2, 5,  "ROU X123.XX"},
        {43.9830375,  26.9553755,     2, 5,  "ROU Y123.XX"},
        {44.08301,    27.956997,      2, 5,  "ROU Z123.XX"},
        {45.938825,   24.978325,      2, 4,  "ROU QF2V.H56"},
        {5.615345,    -0.23796325,    4, 5,  "GHA 10.XX"},
        {5.599595,    -0.19832575,    4, 5,  "GHA J0.XX"},
        {5.6588015,   -0.469895,      3, 4,  "GHA 12.XXX"},
        {6.773734,    -1.70290575,    3, 4,  "GHA 000.XX"},
        {6.773734,    -1.61593675,    3, 4,  "GHA 100.XX"},
        {6.687245,    -1.70290575,    3, 4,  "GHA 200.XX"},
        {6.687245,    -1.61593675,    3, 4,  "GHA 300.XX"},
        {9.456115,    -0.8816295,     3, 5,  "GHA 400.XX"},
        {6.211045,    -1.70177375,    3, 4,  "GHA 500.XX"},
        {10.830724,   -0.89135725,    3, 5,  "GHA 600.XX"},
        {6.136765,    -0.30325875,    3, 4,  "GHA 700.XX"},
        {4.954731,    -1.824142875,   3, 4,  "GHA 800.XX"},
        {7.371295,    -2.360273125,   3, 4,  "GHA 900.XX"},
        {5.158145,    -1.299774375,   3, 4,  "GHA B00.XX"},
        {6.656178,    0.43581925,     3, 6,  "GHA C00.XX"},
        {10.090024,   -2.54825725,    3, 6,  "GHA D00.XX"},
        {11.065045,   -0.297155625,   3, 6,  "GHA F00.XX"},
        {6.561421,    -0.80638625,    3, 4,  "GHA G00.XX"},
        {4.945051,    -1.735565875,   3, 4,  "GHA GK0.00"},
        {9.452465,    -0.0412585,     3, 5,  "GHA H00.XX"},
        {5.529414,    -0.72225775,    3, 4,  "GHA HK0.00"},
        {6.809028,    -1.11771925,    3, 4,  "GHA J00.XX"},
        {5.349175,    -0.65754475,    3, 4,  "GHA JK0.00"},
        {7.593612,    -1.972136875,   3, 4,  "GHA K00.XX"},
        {7.459825,    -2.623574875,   3, 5,  "GHA KK0.00"},
        {5.854825,    -0.68536025,    3, 4,  "GHA L00.XX"},
        {7.144105,    0.443729375,    3, 6,  "GHA LK0.00"},
        {6.08944,     1.00856875,     3, 4,  "GHA M00.XX"},
        {5.294105,    -2.02619975,    3, 4,  "GHA MK0.00"},
        {7.067645,    -1.418573125,   3, 4,  "GHA N00.XX"},
        {5.924045,    -1.00047725,    3, 4,  "GHA NK0.00"},
        {5.548386,    -0.86407375,    3, 4,  "GHA P00.XX"},
        {6.040938,    -0.47436475,    3, 4,  "GHA PK0.00"},
        {5.805045,    0.86722625,     3, 4,  "GHA Q00.XX"},
        {5.918305,    0.96380775,     3, 4,  "GHA QK0.00"},
        {6.397392,    -0.39787925,    3, 4,  "GHA R00.XX"},
        {7.734105,    -2.136271625,   3, 4,  "GHA RK0.00"},
        {9.641236,    -0.860942125,   3, 5,  "GHA S00.XX"},
        {5.126525,    -1.369815625,   3, 4,  "GHA SK0.00"},
        {7.033545,    0.281026875,    3, 4,  "GHA T00.XX"},
        {5.954105,    -1.81619975,    3, 4,  "GHA TK0.00"},
        {8.069045,    -1.746773125,   3, 4,  "GHA V00.XX"},
        {5.459415,    -2.15297725,    3, 4,  "GHA VK0.00"},
        {5.292858,    -0.78703825,    3, 4,  "GHA W00.XX"},
        {4.867571,    -2.245145875,   3, 4,  "GHA WK0.00"},
        {6.832465,    -1.90108625,    3, 4,  "GHA X00.XX"},
        {6.092508,    -0.14850675,    3, 4,  "GHA XK0.00"},
        {5.211545,    -1.114274375,   3, 4,  "GHA Y00.XX"},
        {6.62507,     -1.23629975,    3, 4,  "GHA YK0.00"},
        {5.008554,    -1.679907625,   3, 4,  "GHA Z00.XX"},
        {5.697618,    -1.29299775,    3, 4,  "GHA ZK0.00"},
        {8.032739,    -2.5519185,     2, 4,  "GHA 12.XXXX"},
        {9.20678,     -2.8234925,     2, 4,  "GHA 1234.XX"},
        {7.4196375,   -3.0039695,     2, 5,  "GHA 012.XXX"},
        {7.042719,    -3.233669,      2, 5,  "GHA 112.XXX"},
        {6.597109,    -3.233669,      2, 5,  "GHA 212.XXX"},
        {6.6997405,   -2.694929,      2, 4,  "GHA 312.XXX"},
        {6.6997405,   -2.215793,      2, 3,  "GHA 412.XXX"},
        {6.6997405,   -1.736657,      2, 3,  "GHA 512.XXX"},
        {6.6997405,   -1.257521,      2, 3,  "GHA 612.XXX"},
        {6.6997405,   -0.778386,      2, 3,  "GHA 712.XXX"},
        {6.6997405,   -0.29925,       2, 3,  "GHA 812.XXX"},
        {6.749393,    0.1800595,      2, 3,  "GHA 912.XXX"},
        {6.749393,    0.6230595,      2, 5,  "GHA B12.XXX"},
        {6.2032445,   -3.11393,       2, 5,  "GHA C12.XXX"},
        {6.2032445,   -2.634794,      2, 4,  "GHA D12.XXX"},
        {6.2032445,   -2.155658,      2, 3,  "GHA F12.XXX"},
        {6.2032445,   -1.676522,      3, 4,  "GHA G12.XXX"},
        {6.2032445,   -1.197386,      2, 3,  "GHA H12.XXX"},
        {6.2032445,   -0.71825,       2, 3,  "GHA J12.XXX"},
        {6.2032445,   -0.239113,      2, 3,  "GHA K12.XXX"},
        {6.1565385,   0.240022,       2, 3,  "GHA L12.XXX"},
        {6.121647,    0.7189955,      2, 5,  "GHA M12.XXX"},
        {5.7094755,   -3.04393,       2, 5,  "GHA N12.XXX"},
        {5.7094755,   -2.564794,      2, 4,  "GHA P12.XXX"},
        {5.7094755,   -2.085658,      2, 3,  "GHA Q12.XXX"},
        {5.7094755,   -1.606522,      2, 3,  "GHA R12.XXX"},
        {5.7094755,   -1.127386,      2, 3,  "GHA S12.XXX"},
        {5.7094755,   -0.64825,       2, 3,  "GHA T12.XXX"},
        {5.7094755,   -0.169115,      3, 4,  "GHA V12.XXX"},
        {5.086592,    -3.0913795,     2, 5,  "GHA W12.XXX"},
        {4.7381385,   -2.4364185,     2, 3,  "GHA X12.XXX"},
        {4.7381385,   -2.009098,      2, 3,  "GHA Y12.XXX"},
        {5.247641,    -1.5695465,     2, 3,  "GHA Z12.XXX"},
        {7.9508135,   -1.028075,      2, 3,  "GHA RLWB.TLV"},
        {0.3551,      32.54211,       4, 5,  "UGA 12.XX"},
        {0.480831,    32.371425,      3, 4,  "UGA 12.XXX"},
        {2.820724,    32.23932,       3, 4,  "UGA 000.XX"},
        {2.300724,    32.84932,       3, 4,  "UGA 100.XX"},
        {0.468015,    33.137054,      3, 4,  "UGA 200.XX"},
        {1.130724,    34.12932,       3, 6,  "UGA 300.XX"},
        {-0.559276,   30.60932,       3, 4,  "UGA 400.XX"},
        {-0.289276,   31.68932,       3, 4,  "UGA 500.XX"},
        {0.196545,    30.000225,      3, 7,  "UGA 600.XX"},
        {0.675624,    33.14012,       3, 4,  "UGA 700.XX"},
        {3.070624,    30.87392,       3, 6,  "UGA 800.XX"},
        {-1.209276,   29.93932,       3, 6,  "UGA 900.XX"},
        {3.340724,    32.829207125,   3, 4,  "UGA B00.XX"},
        {0.764624,    34.17102,       3, 6,  "UGA C00.XX"},
        {1.750724,    33.55932,       3, 4,  "UGA D00.XX"},
        {0.710724,    30.22932,       3, 7,  "UGA F00.XX"},
        {0.660224,    33.45862,       3, 4,  "UGA G00.XX"},
        {0.498824,    34.07362,       3, 6,  "UGA H00.XX"},
        {0.440724,    32.00932,       3, 4,  "UGA J00.XX"},
        {1.487124,    31.31392,       3, 4,  "UGA K00.XX"},
        {0.392464,    32.899085,      3, 4,  "UGA L00.XX"},
        {3.397804,    30.937673125,   3, 6,  "UGA LK0.00"},
        {1.696764,    31.684785,      3, 4,  "UGA M00.XX"},
        {2.428904,    30.947945,      3, 7,  "UGA MK0.00"},
        {1.192264,    33.694285,      3, 4,  "UGA N00.XX"},
        {0.839404,    32.472745,      3, 4,  "UGA NK0.00"},
        {2.513264,    31.058185,      3, 7,  "UGA P00.XX"},
        {-0.125896,   30.473945,      3, 4,  "UGA PK0.00"},
        {-0.530136,   30.135385,      3, 4,  "UGA Q00.XX"},
        {1.755104,    33.134445,      3, 4,  "UGA QK0.00"},
        {0.595664,    32.507385,      3, 4,  "UGA R00.XX"},
        {3.393104,    31.754673125,   3, 4,  "UGA RK0.00"},
        {0.706564,    32.876685,      3, 4,  "UGA S00.XX"},
        {0.736304,    32.497945,      3, 4,  "UGA SK0.00"},
        {-0.863036,   29.609085,      3, 6,  "UGA T00.XX"},
        {2.467204,    31.454645,      3, 4,  "UGA TK0.00"},
        {0.673164,    30.484285,      3, 7,  "UGA V00.XX"},
        {0.558304,    31.370745,      3, 4,  "UGA VK0.00"},
        {-0.564736,   30.366985,      3, 4,  "UGA W00.XX"},
        {0.602504,    30.608245,      3, 7,  "UGA WK0.00"},
        {3.472464,    31.208999375,   3, 6,  "UGA X00.XX"},
        {-0.144096,   31.827245,      3, 4,  "UGA XK0.00"},
        {0.721764,    30.028485,      3, 7,  "UGA Y00.XX"},
        {0.184404,    30.428045,      3, 7,  "UGA YK0.00"},
        {3.022464,    34.079085,      3, 5,  "UGA Z00.XX"},
        {0.277504,    30.135845,      3, 7,  "UGA ZK0.00"},
        {2.768277,    30.8907865,     2, 5,  "UGA 12.XXXX"},
        {1.612768,    31.5497905,     2, 3,  "UGA 123.XXX"},
        {1.639681,    29.649826,      2, 6,  "UGA 1234.XX"},
        {3.834339,    29.770886,      1, 6,  "UGA 1234.XXX"},
        {51.537802,   -0.1883,        4, 5,  "GBR 12.XX"},
        {51.568245,   -0.477773,      3, 4,  "GBR 12.XXX"},
        {55.910724,   -4.341980375,   3, 4,  "GBR 000.XX"},
        {52.631924,   -2.18016925,    3, 4,  "GBR 100.XX"},
        {52.588679,   -2.03842325,    3, 4,  "GBR 200.XX"},
        {52.588679,   -1.89667725,    3, 4,  "GBR 300.XX"},
        {52.545435,   -2.18016925,    3, 4,  "GBR 400.XX"},
        {52.50219,    -2.037632125,   3, 4,  "GBR 500.XX"},
        {52.50219,    -1.897568125,   3, 4,  "GBR 600.XX"},
        {53.462124,   -3.00067325,    3, 4,  "GBR 700.XX"},
        {55.988124,   -3.290780375,   3, 4,  "GBR 800.XX"},
        {53.428124,   -1.53697325,    3, 4,  "GBR 900.XX"},
        {53.846524,   -1.618964375,   3, 4,  "GBR B00.XX"},
        {51.500624,   -2.627000875,   3, 4,  "GBR C00.XX"},
        {53.520724,   -2.31757325,    3, 4,  "GBR D00.XX"},
        {52.680724,   -1.19666925,    3, 4,  "GBR F00.XX"},
        {53.800824,   -0.428564375,   3, 4,  "GBR G00.XX"},
        {52.460724,   -1.565878125,   3, 4,  "GBR H00.XX"},
        {53.840324,   -1.828964375,   3, 4,  "GBR J00.XX"},
        {51.531624,   -3.247100875,   3, 4,  "GBR K00.XX"},
        {53.010624,   -1.24246925,    3, 4,  "GBR L00.XX"},
        {53.050724,   -2.25757325,    3, 4,  "GBR M00.XX"},
        {54.640224,   -5.9949595,     3, 6,  "GBR N00.XX"},
        {52.958224,   -1.55206925,    3, 4,  "GBR P00.XX"},
        {51.491124,   -1.051800875,   3, 4,  "GBR Q00.XX"},
        {50.404464,   -4.2049335,     3, 5,  "GBR R00.XX"},
        {50.932324,   -1.44434125,    3, 5,  "GBR RK0.00"},
        {57.161064,   -2.17876175,    3, 4,  "GBR S00.XX"},
        {54.968804,   -1.6430725,     3, 4,  "GBR SK0.00"},
        {53.782664,   -2.764054125,   3, 4,  "GBR T00.XX"},
        {51.891304,   -0.466059875,   3, 4,  "GBR TK0.00"},
        {54.920964,   -1.4599425,     3, 4,  "GBR V00.XX"},
        {50.803004,   -1.1290195,     3, 5,  "GBR VK0.00"},
        {52.651664,   1.23643425,     3, 4,  "GBR W00.XX"},
        {51.628404,   -3.988359875,   3, 4,  "GBR WK0.00"},
        {50.751794,   -1.9325545,     3, 5,  "GBR X00.XX"},
        {50.730937,   -2.0208195,     3, 5,  "GBR XK0.00"},
        {51.559845,   0.631460625,    3, 4,  "GBR Y00.XX"},
        {51.562645,   -1.823091125,   3, 4,  "GBR YK0.00"},
        {56.485904,   -3.058153875,   3, 4,  "GBR Z00.XX"},
        {53.833405,   -3.053535625,   3, 4,  "GBR ZK0.00"},
        {55.954411,   -5.0289675,     2, 3,  "GBR 01.XXXX"},
        {55.954411,   -4.2008955,     2, 3,  "GBR 11.XXXX"},
        {55.954411,   -3.3728235,     2, 3,  "GBR 21.XXXX"},
        {55.463371,   -4.8423645,     2, 3,  "GBR 31.XXXX"},
        {54.972331,   -4.8296575,     2, 3,  "GBR 41.XXXX"},
        {52.780863,   -4.6280775,     2, 3,  "GBR 51.XXXX"},
        {52.780863,   -3.8625015,     2, 3,  "GBR 61.XXXX"},
        {52.780863,   -3.0969255,     2, 3,  "GBR 71.XXXX"},
        {52.289823,   -4.6234425,     2, 3,  "GBR 81.XXXX"},
        {52.289823,   -3.8682825,     2, 3,  "GBR 91.XXXX"},
        {52.289823,   -3.1131225,     2, 3,  "GBR B1.XXXX"},
        {51.798783,   -5.363786,      2, 3,  "GBR C1.XXXX"},
        {51.798783,   -4.613834,      2, 3,  "GBR D1.XXXX"},
        {51.798783,   -3.863882,      2, 3,  "GBR Y1.XXXX"},
        {51.798783,   -3.11393,       2, 3,  "GBR F1.XXXX"},
        {51.5221855,  -5.245685,      2, 3,  "GBR G1.XXXX"},
        {51.307743,   -3.834457,      2, 3,  "GBR H1.XXXX"},
        {51.307743,   -3.09492,       2, 3,  "GBR J1.XXXX"},
        {50.816703,   -4.5616755,     2, 4,  "GBR K1.XXXX"},
        {50.816703,   -3.8273475,     2, 4,  "GBR L1.XXXX"},
        {50.816703,   -3.0930195,     2, 4,  "GBR M1.XXXX"},
        {50.325663,   -4.7479655,     2, 4,  "GBR N1.XXXX"},
        {50.694293,   -3.492848,      3, 5,  "GBR P1.XXXX"},
        {50.422063,   -4.023852,      2, 4,  "GBR Q1.XXXX"},
        {54.424185,   -6.1861455,     2, 5,  "GBR R1.XXXX"},
        {54.896203,   -7.4013745,     2, 5,  "GBR S1.XXXX"},
        {54.896203,   -6.5941345,     2, 5,  "GBR T1.XXXX"},
        {56.669514,   -3.614351,      2, 3,  "GBR V1.XXXX"},
        {56.749215,   -3.3724485,     2, 3,  "GBR W1.XXXX"},
        {56.9914225,  -2.52543,       2, 3,  "GBR X1.XXXX"},
        {50.3053165,  -5.249101,      2, 3,  "GBR Z1.XXXX"},
        {53.1763425,  -2.241051,      2, 3,  "GBR 123.XXX"},
        {55.732439,   -3.9117415,     2, 3,  "GBR 1234.XX"},
        {54.998711,   -3.380176,      2, 3,  "GBR LH0H.JBM"},
        {9.528045,    -13.722045875,  3, 4,  "GIN 00.XX"},
        {9.562825,    -13.679970625,  4, 5,  "GIN C0.XX"},
        {9.613285,    -13.664873125,  4, 5,  "GIN P0.XX"},
        {9.940115,    -13.6952885,    3, 4,  "GIN 12.XXX"},
        {7.802545,    -8.869050125,   3, 4,  "GIN 000.XX"},
        {10.037514,   -12.92812825,   3, 4,  "GIN 200.XX"},
        {10.440545,   -9.35244525,    3, 4,  "GIN 400.XX"},
        {8.542514,    -10.1937885,    3, 6,  "GIN 600.XX"},
        {10.648514,   -14.61802825,   3, 4,  "GIN 800.XX"},
        {9.165514,    -10.1617885,    3, 4,  "GIN B00.XX"},
        {11.303714,   -12.352698125,  3, 4,  "GIN D00.XX"},
        {11.381614,   -9.213598125,   3, 4,  "GIN G00.XX"},
        {9.250037,    -9.0661145,     3, 4,  "GIN J00.XX"},
        {10.379114,   -13.64792825,   3, 4,  "GIN L00.XX"},
        {11.084614,   -13.874798125,  3, 6,  "GIN N00.XX"},
        {12.057114,   -12.359898125,  2, 3,  "GIN Q00.XX"},
        {10.603914,   -8.75762825,    3, 6,  "GIN S00.XX"},
        {10.021114,   -10.80412825,   3, 4,  "GIN V00.XX"},
        {7.782334,    -8.590270625,   3, 5,  "GIN X00.XX"},
        {11.333624,   -10.756770125,  3, 4,  "GIN Z00.XX"},
        {11.6577255,  -14.645987,     2, 5,  "GIN 123.XXX"},
        {9.607525,    -10.912825,     2, 5,  "GIN 12.XXXX"},
        {10.09175,    -11.9054505,    2, 3,  "GIN 1234.XX"},
        {9.935,       -11.3601775,    2, 5,  "GIN 86WF.PZ5"},
        {-2.241875,   -79.9474635,    5, 8,  "ECU 12.XX"},
        {-2.073557,   -80.090976,     4, 7,  "ECU 00.XXX"},
        {-0.205606,   -78.644172,     4, 9,  "ECU J0.XXX"},
        {-2.871932,   -79.045475,     4, 9,  "ECU 000.XX"},
        {-0.215176,   -79.20968,      4, 7,  "ECU 100.XX"},
        {-3.249655,   -80.003139375,  4, 7,  "ECU 200.XX"},
        {-0.952935,   -80.76302,      4, 7,  "ECU 300.XX"},
        {-1.013376,   -80.50498,      4, 7,  "ECU 400.XX"},
        {-1.222876,   -78.66638,      4, 9,  "ECU 500.XX"},
        {-1.614576,   -78.69688,      4, 9,  "ECU 600.XX"},
        {-0.972576,   -79.50288,      4, 7,  "ECU 700.XX"},
        {-3.947025,   -79.243470375,  4, 8,  "ECU 800.XX"},
        {-2.093776,   -79.63288,      4, 7,  "ECU 900.XX"},
        {0.395524,    -78.15938,      4, 7,  "ECU B00.XX"},
        {0.989524,    -79.70728,      4, 5,  "ECU C00.XX"},
        {-1.767476,   -79.57148,      4, 7,  "ECU D00.XX"},
        {-2.220336,   -80.954115,     5, 8,  "ECU F00.XX"},
        {-0.938896,   -78.647555,     4, 9,  "ECU FK0.00"},
        {-0.982536,   -77.844615,     4, 9,  "ECU G00.XX"},
        {-3.335296,   -79.835526875,  4, 7,  "ECU GK0.00"},
        {-0.683336,   -80.129115,     4, 7,  "ECU H00.XX"},
        {-3.455896,   -79.986126875,  4, 8,  "ECU HK0.00"},
        {-3.464436,   -80.259300625,  4, 8,  "ECU J00.XX"},
        {-1.330096,   -80.055855,     4, 7,  "ECU JK0.00"},
        {-1.044436,   -79.663115,     4, 7,  "ECU K00.XX"},
        {-1.355896,   -80.606055,     4, 7,  "ECU KK0.00"},
        {-1.837436,   -80.010815,     4, 7,  "ECU L00.XX"},
        {-1.591696,   -79.026455,     4, 9,  "ECU LK0.00"},
        {-1.352536,   -79.935115,     4, 7,  "ECU M00.XX"},
        {-2.754096,   -78.878755,     4, 9,  "ECU MK0.00"},
        {-2.201236,   -81.013315,     3, 6,  "ECU N00.XX"},
        {0.319404,    -79.496455,     4, 5,  "ECU NK0.00"},
        {-2.213936,   -80.893715,     5, 8,  "ECU P00.XX"},
        {-2.430296,   -79.370855,     4, 7,  "ECU PK0.00"},
        {0.243164,    -78.290015,     4, 7,  "ECU Q00.XX"},
        {-2.174596,   -79.487855,     4, 7,  "ECU QK0.00"},
        {-1.550836,   -79.782515,     4, 7,  "ECU R00.XX"},
        {-0.615496,   -80.439255,     4, 7,  "ECU RK0.00"},
        {0.062464,    -78.190915,     4, 7,  "ECU S00.XX"},
        {-2.635896,   -80.416055,     4, 7,  "ECU SK0.00"},
        {-2.657536,   -79.650915,     4, 7,  "ECU T00.XX"},
        {-1.499796,   -78.028755,     4, 9,  "ECU TK0.00"},
        {0.095764,    -76.927315,     4, 7,  "ECU V00.XX"},
        {-2.315896,   -78.146055,     3, 8,  "ECU VK0.00"},
        {-1.683736,   -79.063715,     4, 7,  "ECU W00.XX"},
        {-1.826496,   -80.257655,     4, 7,  "ECU WK0.00"},
        {-1.617536,   -80.010615,     4, 7,  "ECU X00.XX"},
        {-2.101296,   -79.720855,     4, 7,  "ECU XK0.00"},
        {0.332864,    -78.263615,     4, 7,  "ECU Y00.XX"},
        {-3.994696,   -79.383826875,  4, 8,  "ECU YK0.00"},
        {-0.497536,   -78.600915,     4, 9,  "ECU Z00.XX"},
        {1.266404,    -78.862155,     3, 6,  "ECU ZK0.00"},
        {-2.188291,   -80.84047,      3, 6,  "ECU 12.XXXX"},
        {0.093857,    -80.816425,     3, 4,  "ECU 123.XXX"},
        {0.591905,    -79.898395,     3, 4,  "ECU 0123.XX"},
        {-1.229135,   -78.04549,      4, 9,  "ECU 1123.XX"},
        {-0.150836,   -77.12819,      3, 8,  "ECU 3123.XX"},
        {1.444768,    -81.605124,     2, 3,  "ECU 1123.XXX"},
        {1.444768,    -79.430381,     2, 3,  "ECU 2123.XXX"},
        {1.444768,    -77.261252,     2, 5,  "ECU 3123.XXX"},
        {-0.729974,   -81.605124,     2, 3,  "ECU 4123.XXX"},
        {-0.729974,   -79.430381,     3, 6,  "ECU 5123.XXX"},
        {-0.729974,   -77.261252,     2, 7,  "ECU 6123.XXX"},
        {-2.893281,   -81.605124,     2, 3,  "ECU 7123.XXX"},
        {-2.893281,   -79.430381,     3, 6,  "ECU 8123.XXX"},
        {0.8816215,   -91.6782385,    2, 3,  "ECU G123.XXX"},
        {0.941614,    -91.9851735,    2, 3,  "ECU H123.XXX"},
        {1.21906,     -91.4260625,    2, 3,  "ECU 1234.XXXX"},
        {27.1369995,  -13.1876,       4, 10, "ESH YRG.TC"},
        {23.720764,   -15.970148625,  4, 10, "ESH Z00.XX"},
        {26.736904,   -11.701921875,  4, 10, "ESH ZK0.00"},
        {26.854723,   -14.3778755,    3, 8,  "ESH 12.XXXX"},
        {23.915715,   -15.9832935,    3, 8,  "ESH Z12.XXX"},
        {26.7994445,  -13.082416,     3, 8,  "ESH 8HHH.HHH"},
        {26.7994445,  -10.133107,     2, 6,  "ESH 9HHH.HHH"},
        {25.9196985,  -17.654534,     2, 5,  "ESH B123.XXX"},
        {25.9196985,  -14.764807,     2, 6,  "ESH C123.XXX"},
        {23.1613675,  -17.6585975,    2, 5,  "ESH D123.XXX"},
        {23.1613675,  -14.7986615,    2, 6,  "ESH F123.XXX"},
        {24.19893,    -13.2081275,    2, 6,  "ESH 8RFX.3L2P"},
        {0.439684,    9.408725,       3, 4,  "GAB 00.XX"},
        {0.382219,    9.430845,       3, 4,  "GAB J0.XX"},
        {0.510238,    9.32974,        2, 3,  "GAB 12.XXX"},
        {-0.688355,   8.728625,       3, 4,  "GAB 000.XX"},
        {-1.646686,   13.52099,       3, 5,  "GAB 200.XX"},
        {-1.561986,   13.16889,       3, 5,  "GAB 400.XX"},
        {1.639424,    11.52232,       3, 5,  "GAB 600.XX"},
        {0.601624,    12.80602,       3, 5,  "GAB 700.XX"},
        {-1.839876,   11.03572,       3, 4,  "GAB 800.XX"},
        {-0.640876,   10.20662,       3, 4,  "GAB 900.XX"},
        {-2.898576,   10.94882,       3, 4,  "GAB B00.XX"},
        {-1.111176,   12.39862,       3, 5,  "GAB C00.XX"},
        {2.144424,    11.45562,       3, 6,  "GAB D00.XX"},
        {-2.695376,   9.98042,        3, 4,  "GAB F00.XX"},
        {-1.350576,   13.11782,       3, 5,  "GAB G00.XX"},
        {-0.765076,   12.68882,       3, 5,  "GAB H00.XX"},
        {-0.618176,   13.63272,       3, 5,  "GAB J00.XX"},
        {-2.761576,   10.10872,       3, 4,  "GAB K00.XX"},
        {-2.362376,   11.30672,       3, 5,  "GAB L00.XX"},
        {-0.035376,   11.89252,       3, 5,  "GAB M00.XX"},
        {-1.195476,   10.57792,       3, 4,  "GAB N00.XX"},
        {-0.123676,   10.72912,       3, 4,  "GAB P00.XX"},
        {-2.501243,   9.750723,       3, 4,  "GAB Q00.XX"},
        {-3.377876,   10.641107125,   2, 3,  "GAB R00.XX"},
        {-1.854176,   11.86792,       3, 5,  "GAB S00.XX"},
        {0.847124,    11.49542,       3, 5,  "GAB T00.XX"},
        {1.032624,    13.89632,       2, 4,  "GAB V00.XX"},
        {-1.546576,   14.21452,       3, 6,  "GAB W00.XX"},
        {-1.597476,   11.60192,       3, 5,  "GAB X00.XX"},
        {-2.113376,   12.12702,       3, 5,  "GAB Y00.XX"},
        {1.011584,    9.551839,       2, 5,  "GAB Z00.XX"},
        {2.2576085,   11.1610765,     2, 6,  "GAB 123.XXX"},
        {-1.235728,   11.2283145,     2, 4,  "GAB 12.XXXX"},
        {-2.5751265,  8.7781895,      2, 3,  "GAB 1234.XX"},
        {1.882715,    8.9077305,      1, 3,  "GAB 1234.XXX"},
        {-36.8452,    174.712848,     5, 6,  "NZL 12.XX"},
        {-36.649885,  174.5053615,    3, 4,  "NZL 12.XXX"},
        {-43.443476,  172.5111045,    4, 5,  "NZL 000.XX"},
        {-43.443476,  172.6293065,    4, 5,  "NZL 100.XX"},
        {-43.529965,  172.498831,     4, 5,  "NZL 200.XX"},
        {-43.540855,  172.61477,      4, 5,  "NZL 300.XX"},
        {-41.280455,  174.7152975,    5, 6,  "NZL 400.XX"},
        {-41.162455,  174.7572975,    5, 6,  "NZL 500.XX"},
        {-41.088455,  174.8222975,    5, 6,  "NZL 600.XX"},
        {-41.165976,  174.8781125,    5, 6,  "NZL 700.XX"},
        {-41.108675,  174.9702975,    6, 7,  "NZL 800.XX"},
        {-37.731656,  175.2094995,    5, 6,  "NZL 900.XX"},
        {-37.731656,  175.2862255,    5, 6,  "NZL B00.XX"},
        {-45.839276,  170.421805375,  4, 5,  "NZL C00.XX"},
        {-37.658876,  176.1142245,    5, 6,  "NZL D00.XX"},
        {-40.309276,  175.557003625,  5, 6,  "NZL F00.XX"},
        {-39.605876,  176.797855125,  5, 6,  "NZL G00.XX"},
        {-41.256576,  173.1930125,    4, 5,  "NZL H00.XX"},
        {-39.466876,  176.821655125,  5, 6,  "NZL J00.XX"},
        {-38.093676,  176.196185875,  5, 6,  "NZL K00.XX"},
        {-35.682455,  174.291268875,  4, 5,  "NZL L00.XX"},
        {-39.031255,  174.02128875,   5, 6,  "NZL M00.XX"},
        {-46.380555,  168.330775,     4, 5,  "NZL N00.XX"},
        {-39.885276,  174.972803625,  5, 6,  "NZL P00.XX"},
        {-40.852276,  174.973051125,  5, 6,  "NZL Q00.XX"},
        {-38.642936,  177.981484125,  4, 5,  "NZL R00.XX"},
        {-41.526096,  173.91876,      6, 7,  "NZL RK0.00"},
        {-44.362255,  171.187813125,  4, 5,  "NZL S00.XX"},
        {-38.699996,  176.050080375,  5, 6,  "NZL SK0.00"},
        {-37.192736,  174.861542375,  4, 5,  "NZL T00.XX"},
        {-40.955896,  175.6155495,    5, 6,  "NZL TK0.00"},
        {-40.607536,  175.239381375,  5, 6,  "NZL V00.XX"},
        {-37.966396,  176.950269875,  5, 6,  "NZL VK0.00"},
        {-43.888836,  171.702406,     4, 5,  "NZL W00.XX"},
        {-37.904296,  175.440969875,  5, 6,  "NZL WK0.00"},
        {-38.214636,  175.825727625,  5, 6,  "NZL X00.XX"},
        {-40.228496,  175.536656625,  5, 6,  "NZL XK0.00"},
        {-38.006736,  175.289727625,  5, 6,  "NZL Y00.XX"},
        {-45.092396,  170.921251125,  4, 5,  "NZL YK0.00"},
        {-43.289936,  172.5295495,    4, 5,  "NZL Z00.XX"},
        {-39.585896,  174.246346125,  5, 6,  "NZL ZK0.00"},
        {-36.7920165, 173.8182005,    3, 4,  "NZL 123.XXX"},
        {-39.66526,   173.867849,     4, 5,  "NZL 12.XXXX"},
        {-43.676735,  172.3255175,    3, 4,  "NZL 1123.XX"},
        {-41.445735,  174.6127195,    4, 5,  "NZL 2123.XX"},
        {-38.088635,  175.0745725,    4, 5,  "NZL 3123.XX"},
        {-45.92702,   170.1732155,    3, 4,  "NZL 4123.XX"},
        {-37.831535,  175.8011725,    4, 5,  "NZL 5123.XX"},
        {-40.647735,  175.2318705,    5, 6,  "NZL 6123.XX"},
        {-39.811135,  176.502842,     4, 5,  "NZL 7123.XX"},
        {-41.531135,  172.9451195,    3, 4,  "NZL 8123.XX"},
        {-38.40542,   175.7481725,    4, 5,  "NZL 9123.XX"},
        {-36.042035,  174.041495,     3, 4,  "NZL B123.XX"},
        {-39.43372,   173.7934215,    5, 6,  "NZL C123.XX"},
        {-46.61402,   167.973836,     3, 4,  "NZL D123.XX"},
        {-40.170235,  174.756742,     4, 5,  "NZL F123.XX"},
        {-41.122835,  174.828691,     6, 7,  "NZL G123.XX"},
        {-38.77512,   177.767193,     3, 4,  "NZL H123.XX"},
        {-41.634035,  173.5496195,    3, 4,  "NZL J123.XX"},
        {-44.511035,  170.792838,     3, 4,  "NZL K123.XX"},
        {-38.92542,   175.789393,     4, 5,  "NZL L123.XX"},
        {-41.184135,  175.345091,     4, 5,  "NZL M123.XX"},
        {-38.31302,   176.6070725,    4, 5,  "NZL N123.XX"},
        {-44.010735,  171.498938,     3, 4,  "NZL P123.XX"},
        {-45.299335,  170.569987,     3, 4,  "NZL Q123.XX"},
        {-34.6267585, 172.7177425,    3, 4,  "NZL B123.XXX"},
        {-36.7920165, 177.1547925,    2, 3,  "NZL C123.XXX"},
        {-39.4732065, 171.2606925,    2, 3,  "NZL D123.XXX"},
        {-42.1543965, 167.059841,     2, 3,  "NZL F123.XXX"},
        {-42.1543965, 170.664552,     2, 3,  "NZL G123.XXX"},
        {-44.8355865, 163.8328045,    2, 3,  "NZL H123.XXX"},
        {-44.8355865, 167.5864705,    2, 3,  "NZL K123.XXX"},
        {-36.7920165, 173.8182005,    3, 4,  "NZL L123.XXX"},
        {-39.4732065, 173.7833935,    4, 5,  "NZL M123.XXX"},
        {-49.023894,  177.8334895,    2, 3,  "NZL N123.XXX"},
        {-43.638002,  -177.0768895,   2, 3,  "NZL P123.XXX"},
        {-47.451016,  165.762671,     3, 4,  "NZL R123.XXX"},
        {-50.143378,  165.129324,     2, 3,  "NZL X123.XXX"},
        {-47.088079,  178.145662,     2, 3,  "NZL Y123.XXX"},
        {-51.901082,  168.1791155,    2, 3,  "NZL Z123.XXX"},
        {-34.0146895, 171.424567,     2, 3,  "NZL 9123.XXX"},
        {-36.8803,    174.76,         5, 6,  "NZL L39F.BHYK"},
        {12.3981,     -1.568732,      4, 7,  "BFA 12.XX"},
        {12.472592,   -1.688451,      3, 6,  "BFA 00.XXX"},
        {11.189314,   -4.474371875,   3, 4,  "BFA J0.XXX"},
        {12.290724,   -2.411584,      3, 6,  "BFA 000.XX"},
        {13.610724,   -2.46180975,    3, 6,  "BFA 100.XX"},
        {10.685224,   -4.79235725,    3, 5,  "BFA 200.XX"},
        {12.510624,   -3.498284,      3, 6,  "BFA 300.XX"},
        {13.118924,   -1.118096875,   3, 4,  "BFA 400.XX"},
        {11.821524,   -0.409770125,   3, 4,  "BFA 500.XX"},
        {12.100924,   0.324929875,    3, 5,  "BFA 600.XX"},
        {14.073624,   -0.06550975,    2, 3,  "BFA 700.XX"},
        {12.358124,   -2.516084,      3, 6,  "BFA 800.XX"},
        {11.523524,   -3.565770125,   3, 4,  "BFA 900.XX"},
        {14.140724,   -1.67180975,    2, 5,  "BFA B00.XX"},
        {11.147824,   -2.114670125,   3, 6,  "BFA C00.XX"},
        {11.213924,   -1.202870125,   3, 4,  "BFA D00.XX"},
        {13.383924,   -1.56600975,    3, 6,  "BFA F00.XX"},
        {13.001424,   -2.298496875,   3, 6,  "BFA G00.XX"},
        {12.221524,   -0.396384,      3, 4,  "BFA H00.XX"},
        {12.291724,   -0.667884,      3, 4,  "BFA J00.XX"},
        {12.110724,   -1.381470125,   3, 4,  "BFA K00.XX"},
        {11.023124,   -4.94515725,    3, 4,  "BFA L00.XX"},
        {13.098564,   -3.447087625,   3, 6,  "BFA M00.XX"},
        {13.065404,   -3.095305875,   3, 6,  "BFA MK0.00"},
        {12.748064,   -3.895287625,   3, 7,  "BFA N00.XX"},
        {11.654104,   -1.096561125,   3, 4,  "BFA NK0.00"},
        {11.762464,   -2.961515375,   3, 4,  "BFA P00.XX"},
        {12.654104,   -0.596705875,   3, 4,  "BFA PK0.00"},
        {10.975264,   -3.27392975,    3, 4,  "BFA Q00.XX"},
        {10.653204,   -5.18848925,    3, 7,  "BFA QK0.00"},
        {13.220164,   -2.38537325,    3, 6,  "BFA R00.XX"},
        {11.073204,   -5.337161125,   3, 6,  "BFA RK0.00"},
        {12.989964,   -0.178587625,   3, 4,  "BFA S00.XX"},
        {11.794104,   -0.576561125,   3, 4,  "BFA SK0.00"},
        {10.152464,   -3.49142975,    3, 5,  "BFA T00.XX"},
        {10.284104,   -3.54648925,    3, 5,  "BFA TK0.00"},
        {13.512464,   -3.20177325,    3, 6,  "BFA V00.XX"},
        {11.644104,   -2.206561125,   3, 4,  "BFA VK0.00"},
        {10.346264,   -3.20442975,    2, 4,  "BFA W00.XX"},
        {13.394104,   -0.16677875,    3, 4,  "BFA WK0.00"},
        {11.552464,   -3.291515375,   3, 4,  "BFA X00.XX"},
        {11.634104,   -3.916561125,   3, 4,  "BFA XK0.00"},
        {11.162464,   -3.091515375,   3, 4,  "BFA Y00.XX"},
        {14.434104,   -0.256850625,   2, 3,  "BFA YK0.00"},
        {12.092464,   1.758484625,    3, 5,  "BFA Z00.XX"},
        {11.236604,   -0.720761125,   3, 4,  "BFA ZK0.00"},
        {13.5735565,  -3.225014,      2, 5,  "BFA 123.XXX"},
        {10.3585865,  -5.438522,      2, 6,  "BFA 12.XXXX"},
        {13.432147,   -0.5188525,     2, 3,  "BFA 1234.XX"},
        {12.23407,    -1.5555,        3, 6,  "BFA QQXM.PV1"},
        {14.6335,     120.962168,     6, 7,  "PHL 12.XX"},
        {14.741115,   120.82179,      5, 6,  "PHL 12.XXX"},
        {7.101545,    125.515226875,  5, 6,  "PHL 000.XX"},
        {7.143545,    125.598533875,  5, 6,  "PHL 100.XX"},
        {10.334824,   123.81464275,   5, 6,  "PHL 200.XX"},
        {10.372014,   123.90257275,   5, 6,  "PHL 300.XX"},
        {8.514424,    124.6079685,    5, 6,  "PHL 400.XX"},
        {10.708324,   122.92464275,   5, 6,  "PHL 500.XX"},
        {10.761824,   122.51314275,   5, 6,  "PHL 600.XX"},
        {15.196224,   120.5485645,    5, 6,  "PHL 700.XX"},
        {16.461524,   120.541425875,  5, 6,  "PHL 800.XX"},
        {14.308224,   121.358877375,  5, 6,  "PHL 900.XX"},
        {15.070324,   120.6426645,    5, 6,  "PHL B00.XX"},
        {13.979024,   121.56109025,   5, 6,  "PHL C00.XX"},
        {6.159924,    125.12529425,   5, 6,  "PHL D00.XX"},
        {14.873224,   120.2372645,    5, 6,  "PHL F00.XX"},
        {11.258624,   124.959729875,  5, 6,  "PHL G00.XX"},
        {10.416624,   123.62204275,   5, 6,  "PHL H00.XX"},
        {7.245324,    124.198481375,  5, 6,  "PHL J00.XX"},
        {6.974224,    122.038681375,  5, 6,  "PHL K00.XX"},
        {12.138924,   124.530229875,  5, 6,  "PHL L00.XX"},
        {13.675024,   123.14159025,   5, 6,  "PHL M00.XX"},
        {8.040124,    124.235681375,  5, 6,  "PHL N00.XX"},
        {14.075964,   121.28702675,   5, 6,  "PHL P00.XX"},
        {15.485304,   120.942004625,  5, 6,  "PHL PK0.00"},
        {16.042464,   120.31788325,   5, 6,  "PHL Q00.XX"},
        {11.572304,   122.721738875,  5, 6,  "PHL QK0.00"},
        {14.972664,   120.5930545,    5, 6,  "PHL R00.XX"},
        {8.946504,    125.4955555,    5, 6,  "PHL RK0.00"},
        {16.713164,   121.516697625,  5, 6,  "PHL S00.XX"},
        {7.441604,    125.781128375,  5, 6,  "PHL SK0.00"},
        {9.330164,    123.2549415,    5, 6,  "PHL T00.XX"},
        {15.151704,   120.7472765,    5, 6,  "PHL TK0.00"},
        {6.761664,    125.32411375,   5, 6,  "PHL V00.XX"},
        {14.490704,   121.263149375,  6, 7,  "PHL VK0.00"},
        {17.631264,   121.687825375,  5, 6,  "PHL W00.XX"},
        {8.191504,    126.316128375,  5, 6,  "PHL WK0.00"},
        {10.542664,   123.97247025,   5, 6,  "PHL X00.XX"},
        {9.745504,    118.728383625,  5, 6,  "PHL XK0.00"},
        {13.441764,   123.36072675,   5, 6,  "PHL Y00.XX"},
        {14.952004,   120.8720765,    5, 6,  "PHL YK0.00"},
        {6.061264,    120.97381375,   5, 6,  "PHL Z00.XX"},
        {13.147804,   123.70872125,   5, 6,  "PHL ZK0.00"},
        {16.2304335,  119.7690725,    4, 5,  "PHL 123.XXX"},
        {11.45693,    122.0284375,    4, 5,  "PHL 12.XXXX"},
        {7.01358,     125.466405,     5, 6,  "PHL 0123.XX"},
        {8.21858,     124.438205,     5, 6,  "PHL 1123.XX"},
        {16.211279,   120.2540825,    5, 6,  "PHL 2123.XX"},
        {6.06858,     124.818205,     4, 5,  "PHL 3123.XX"},
        {11.05858,    124.7908335,    4, 5,  "PHL 4123.XX"},
        {7.03668,     124.150705,     4, 5,  "PHL 5123.XX"},
        {6.90318,     121.869505,     4, 5,  "PHL 6123.XX"},
        {11.72078,    124.5076335,    4, 5,  "PHL 7123.XX"},
        {13.25718,    123.045654,     4, 5,  "PHL 8123.XX"},
        {7.787879,    124.022405,     4, 5,  "PHL 9123.XX"},
        {8.681265,    125.2279335,    4, 5,  "PHL B123.XX"},
        {16.37858,    121.1256825,    4, 5,  "PHL C123.XX"},
        {17.385865,   121.477903,     4, 5,  "PHL D123.XX"},
        {7.99278,     125.998005,     4, 5,  "PHL F123.XX"},
        {9.505865,    118.4908335,    4, 5,  "PHL G123.XX"},
        {5.76308,     120.828005,     4, 6,  "PHL H123.XX"},
        {12.840865,   123.643054,     4, 5,  "PHL J123.XX"},
        {8.31068,     123.159905,     4, 5,  "PHL K123.XX"},
        {7.79368,     123.401705,     4, 5,  "PHL L123.XX"},
        {6.54948,     125.038705,     4, 5,  "PHL M123.XX"},
        {9.567165,    125.3466335,    4, 5,  "PHL N123.XX"},
        {17.345865,   120.242903,     4, 5,  "PHL P123.XX"},
        {6.72858,     125.988205,     4, 5,  "PHL Q123.XX"},
        {13.91418,    122.618554,     4, 5,  "PHL R123.XX"},
        {17.85648,    120.466103,     4, 5,  "PHL S123.XX"},
        {15.7162475,  117.237479,     3, 8,  "PHL 1234.XXX"},
        {7.5481935,   116.9404095,    3, 4,  "PHL 123.XXXX"},
        {14.5984,     121.0009,       6, 7,  "PHL CDH3.T7JT"},
        {41.930289,   12.440254,      5, 6,  "ITA 12.XX"},
        {45.444394,   8.98791275,     4, 6,  "ITA 00.XXX"},
        {41.985084,   12.31886,       4, 5,  "ITA C0.XXX"},
        {41.021684,   14.091502375,   4, 5,  "ITA P0.XXX"},
        {45.109624,   7.620735125,    4, 6,  "ITA 000.XX"},
        {38.165024,   13.308585875,   4, 5,  "ITA 100.XX"},
        {43.799545,   11.16131,       4, 5,  "ITA 200.XX"},
        {44.519545,   11.269313125,   4, 5,  "ITA 300.XX"},
        {44.426545,   8.840031125,    4, 6,  "ITA 400.XX"},
        {37.549324,   15.0289245,     4, 5,  "ITA 500.XX"},
        {41.127545,   16.7475975,     4, 5,  "ITA 600.XX"},
        {45.452545,   12.30215575,    4, 5,  "ITA 700.XX"},
        {45.452534,   10.92905575,    4, 5,  "ITA 800.XX"},
        {38.240545,   15.500284375,   4, 5,  "ITA 900.XX"},
        {45.673424,   13.74917075,    4, 7,  "ITA B00.XX"},
        {45.446124,   11.81267075,    4, 5,  "ITA C00.XX"},
        {45.582124,   10.16237075,    4, 5,  "ITA D00.XX"},
        {44.690724,   10.862935125,   4, 5,  "ITA F00.XX"},
        {43.901745,   11.030728,      4, 5,  "ITA G00.XX"},
        {39.254745,   9.08628875,     4, 5,  "ITA H00.XX"},
        {38.160045,   15.630084375,   4, 5,  "ITA J00.XX"},
        {44.810494,   10.281415625,   4, 5,  "ITA K00.XX"},
        {43.092604,   12.3221915,     4, 5,  "ITA KK0.00"},
        {43.584545,   10.2980075,     4, 5,  "ITA L00.XX"},
        {41.451504,   15.51526,       4, 5,  "ITA LK0.00"},
        {40.768164,   14.496781375,   4, 5,  "ITA M00.XX"},
        {44.704104,   10.586151125,   4, 5,  "ITA MK0.00"},
        {44.432464,   12.166976875,   4, 5,  "ITA N00.XX"},
        {40.461704,   17.220967125,   4, 5,  "ITA NK0.00"},
        {44.852464,   11.566633375,   4, 5,  "ITA P00.XX"},
        {44.054104,   12.534102,      4, 5,  "ITA PK0.00"},
        {37.091764,   15.225842375,   4, 5,  "ITA Q00.XX"},
        {42.461104,   14.1737705,     4, 5,  "ITA QK0.00"},
        {40.742464,   8.519381375,    4, 5,  "ITA R00.XX"},
        {41.458204,   12.86096,       4, 5,  "ITA RK0.00"},
        {45.707564,   9.624075125,    4, 5,  "ITA S00.XX"},
        {44.215004,   12.016840625,   4, 5,  "ITA SK0.00"},
        {45.562364,   11.50180425,    4, 5,  "ITA T00.XX"},
        {42.561104,   12.605381,      4, 5,  "ITA TK0.00"},
        {45.462464,   8.57620425,     4, 6,  "ITA V00.XX"},
        {46.062304,   13.196027375,   3, 4,  "ITA VK0.00"},
        {46.501664,   11.292745,      4, 5,  "ITA W00.XX"},
        {43.458704,   11.8295915,     4, 5,  "ITA WK0.00"},
        {38.917464,   16.55232625,    4, 5,  "ITA X00.XX"},
        {41.221804,   16.2617495,     4, 5,  "ITA XK0.00"},
        {46.126045,   11.088121875,   4, 5,  "ITA Y00.XX"},
        {43.567104,   13.484306,      4, 5,  "ITA YK0.00"},
        {45.049545,   9.632148625,    4, 5,  "ITA Z00.XX"},
        {40.623405,   17.917272375,   4, 5,  "ITA ZK0.00"},
        {44.795375,   7.309495,       3, 5,  "ITA 01.XXXX"},
        {37.766575,   12.9795265,     4, 5,  "ITA 11.XXXX"},
        {37.238275,   14.76534,       3, 4,  "ITA 21.XXXX"},
        {40.802775,   16.451435,      3, 4,  "ITA 31.XXXX"},
        {37.951975,   15.1785265,     3, 4,  "ITA 41.XXXX"},
        {45.602475,   13.3087815,     3, 4,  "ITA 51.XXXX"},
        {40.407875,   17.098435,      3, 4,  "ITA 61.XXXX"},
        {39.006875,   8.8738915,      3, 4,  "ITA 71.XXXX"},
        {43.686275,   12.52173,       3, 4,  "ITA 81.XXXX"},
        {36.754575,   14.80754,       4, 5,  "ITA 91.XXXX"},
        {40.516875,   8.160035,       3, 4,  "ITA B1.XXXX"},
        {45.912475,   10.77016,       3, 4,  "ITA C1.XXXX"},
        {45.198475,   8.1563815,      3, 5,  "ITA D1.XXXX"},
        {43.313475,   13.1639515,     3, 4,  "ITA F1.XXXX"},
        {46.373275,   10.948725,      3, 4,  "ITA G1.XXXX"},
        {38.908275,   16.1285905,     3, 4,  "ITA H1.XXXX"},
        {40.278275,   17.7086565,     3, 4,  "ITA J1.XXXX"},
        {41.218275,   15.8044215,     3, 4,  "ITA K1.XXXX"},
        {45.675275,   8.23816,        3, 5,  "ITA L1.XXXX"},
        {44.713275,   8.027995,       3, 5,  "ITA M1.XXXX"},
        {37.625775,   12.4384265,     3, 4,  "ITA N1.XXXX"},
        {37.078275,   13.96054,       3, 4,  "ITA P1.XXXX"},
        {42.674475,   10.536665,      3, 4,  "ITA Q1.XXXX"},
        {40.335475,   15.5458565,     3, 4,  "ITA R1.XXXX"},
        {42.015075,   11.6086865,     2, 3,  "ITA S1.XXXX"},
        {43.898275,   7.95773,        3, 5,  "ITA T1.XXXX"},
        {36.743275,   14.30544,       3, 4,  "ITA V1.XXXX"},
        {40.376575,   16.5123565,     3, 4,  "ITA W1.XXXX"},
        {37.123275,   13.45044,       3, 4,  "ITA X1.XXXX"},
        {44.178275,   7.2555165,      3, 5,  "ITA Y1.XXXX"},
        {38.955275,   16.7218915,     3, 4,  "ITA Z1.XXXX"},
        {43.1330425,  12.2806775,     3, 4,  "ITA 123.XXX"},
        {45.72229,    8.9558965,      3, 5,  "ITA 1234.XX"},
        {41.081342,   7.8127755,      2, 3,  "ITA 012.XXXX"},
        {46.4344765,  6.7169595,      2, 6,  "ITA 112.XXXX"},
        {46.504325,   9.9814915,      2, 5,  "ITA 212.XXXX"},
        {44.441805,   9.9707465,      3, 4,  "ITA 312.XXXX"},
        {43.485123,   13.5534425,     3, 4,  "ITA 412.XXXX"},
        {41.6222915,  11.9052265,     2, 3,  "ITA 612.XXXX"},
        {41.9709085,  15.611167,      3, 4,  "ITA 712.XXXX"},
        {35.9634905,  11.7941325,     2, 3,  "ITA 812.XXXX"},
        {38.9992925,  14.3019125,     2, 3,  "ITA 912.XXXX"},
        {41.275,      12.53,          3, 4,  "ITA J90N.BKS"},
        {23.620905,   58.5190035,     4, 5,  "OMN 12.XX"},
        {23.496855,   57.9487245,     3, 4,  "OMN 12.XXX"},
        {17.004414,   53.958774,      3, 5,  "OMN 000.XX"},
        {17.036614,   54.085374,      4, 6,  "OMN 200.XX"},
        {24.343514,   56.65281925,    3, 4,  "OMN 400.XX"},
        {23.207514,   56.435027875,   3, 4,  "OMN 600.XX"},
        {23.817314,   57.298189125,   3, 4,  "OMN 800.XX"},
        {23.777614,   57.423389125,   4, 5,  "OMN B00.XX"},
        {24.219724,   56.83037825,    3, 4,  "OMN D00.XX"},
        {22.961445,   57.50824375,    3, 4,  "OMN F00.XX"},
        {23.486545,   57.402076375,   3, 4,  "OMN G00.XX"},
        {23.713724,   57.836391125,   3, 4,  "OMN H00.XX"},
        {22.606824,   59.4625565,     3, 4,  "OMN J00.XX"},
        {24.307124,   55.75457825,    3, 6,  "OMN K00.XX"},
        {23.010724,   57.25593075,    3, 4,  "OMN L00.XX"},
        {24.772324,   56.4027525,     3, 4,  "OMN M00.XX"},
        {22.610724,   58.0761565,     3, 4,  "OMN N00.XX"},
        {24.020924,   57.053691125,   3, 4,  "OMN P00.XX"},
        {23.809924,   57.555891125,   4, 5,  "OMN Q00.XX"},
        {23.333624,   57.917917875,   3, 4,  "OMN R00.XX"},
        {23.278824,   58.852017875,   3, 4,  "OMN S00.XX"},
        {22.752724,   58.48833075,    3, 4,  "OMN T00.XX"},
        {26.210824,   56.202413875,   3, 6,  "OMN V00.XX"},
        {23.617424,   56.480917875,   3, 4,  "OMN W00.XX"},
        {23.137524,   57.24723075,    3, 4,  "OMN X00.XX"},
        {23.447324,   57.782417875,   3, 4,  "OMN Y00.XX"},
        {23.351624,   57.481017875,   3, 4,  "OMN Z00.XX"},
        {24.7970505,  56.3088505,     2, 5,  "OMN 123.XXX"},
        {19.06713,    52.3426615,     2, 5,  "OMN 12.XXXX"},
        {22.332009,   59.2617895,     2, 3,  "OMN 0123.XX"},
        {24.182292,   55.750754,      2, 6,  "OMN 1123.XX"},
        {25.93868,    56.0596005,     2, 7,  "OMN 2123.XX"},
        {25.88544,    56.150858,      2, 7,  "OMN 3123.XX"},
        {25.2395385,  56.211541,      2, 7,  "OMN 4123.XX"},
        {25.8375245,  52.190845,      1, 6,  "OMN 1234.XXX"},
        {52.2951,     20.9594355,     5, 6,  "POL 12.XX"},
        {50.307175,   18.6087435,     3, 4,  "POL 12.XXX"},
        {52.343924,   20.884121875,   4, 5,  "POL 000.XX"},
        {52.343924,   21.024185875,   4, 5,  "POL 100.XX"},
        {52.257435,   20.884121875,   4, 5,  "POL 200.XX"},
        {52.257435,   21.024185875,   5, 6,  "POL 300.XX"},
        {52.170946,   20.954153875,   4, 5,  "POL 400.XX"},
        {51.810724,   19.394799125,   4, 5,  "POL 500.XX"},
        {50.096224,   19.89174675,    3, 4,  "POL 600.XX"},
        {51.146724,   16.96159025,    3, 4,  "POL 700.XX"},
        {52.446024,   16.848221875,   3, 4,  "POL 800.XX"},
        {54.408624,   18.5585445,     3, 4,  "POL 900.XX"},
        {53.470724,   14.46242675,    3, 5,  "POL B00.XX"},
        {53.151145,   17.91537375,    3, 4,  "POL C00.XX"},
        {51.281224,   22.49249025,    3, 5,  "POL D00.XX"},
        {53.176224,   23.08362675,    3, 4,  "POL F00.XX"},
        {54.563424,   18.4262445,     3, 4,  "POL G00.XX"},
        {50.850924,   19.0604685,     3, 4,  "POL H00.XX"},
        {51.441724,   21.08779025,    3, 4,  "POL J00.XX"},
        {50.918124,   20.5616685,     3, 4,  "POL K00.XX"},
        {53.042845,   18.54143975,    3, 4,  "POL L00.XX"},
        {49.860124,   18.976524,      3, 4,  "POL M00.XX"},
        {53.810324,   20.408635625,   2, 3,  "POL N00.XX"},
        {50.048364,   21.95668225,    3, 4,  "POL P00.XX"},
        {50.085304,   18.51321475,    3, 4,  "POL PK0.00"},
        {50.805664,   16.2314665,     3, 6,  "POL Q00.XX"},
        {50.665604,   17.9051805,     3, 4,  "POL QK0.00"},
        {52.555964,   19.66333425,    3, 4,  "POL R00.XX"},
        {54.162204,   19.3654065,     3, 4,  "POL RK0.00"},
        {52.753964,   15.18833425,    3, 4,  "POL S00.XX"},
        {52.653904,   19.03099875,    3, 4,  "POL SK0.00"},
        {50.021164,   20.92428225,    3, 4,  "POL T00.XX"},
        {51.937004,   15.447605875,   3, 4,  "POL TK0.00"},
        {51.776664,   18.047750375,   3, 4,  "POL V00.XX"},
        {54.185904,   16.1423065,     3, 4,  "POL VK0.00"},
        {51.214464,   16.12975175,    3, 4,  "POL W00.XX"},
        {53.478104,   18.72751975,    2, 3,  "POL WK0.00"},
        {54.476464,   16.9717445,     2, 3,  "POL X00.XX"},
        {49.948504,   18.54941475,    3, 6,  "POL XK0.00"},
        {50.915664,   15.69105175,    3, 4,  "POL Y00.XX"},
        {49.612904,   20.662149,      3, 6,  "POL YK0.00"},
        {52.185895,   20.764214375,   4, 5,  "POL Z00.XX"},
        {51.423175,   19.64985375,    3, 4,  "POL ZK0.00"},
        {50.583052,   16.2045715,     2, 5,  "POL 012.XXX"},
        {50.583052,   16.9284835,     2, 3,  "POL 112.XXX"},
        {50.583052,   17.6523955,     2, 3,  "POL 212.XXX"},
        {50.583052,   18.3763075,     2, 3,  "POL 312.XXX"},
        {50.583052,   19.1002195,     2, 3,  "POL 412.XXX"},
        {50.583052,   19.8241315,     2, 3,  "POL 512.XXX"},
        {50.583052,   20.5480435,     2, 3,  "POL 612.XXX"},
        {50.583052,   21.2719555,     2, 3,  "POL 712.XXX"},
        {50.583052,   21.9958675,     2, 3,  "POL 812.XXX"},
        {50.583052,   22.7197795,     2, 4,  "POL 912.XXX"},
        {50.583052,   23.4436915,     2, 4,  "POL B12.XXX"},
        {50.092012,   17.652109,      2, 6,  "POL C12.XXX"},
        {50.092012,   18.370813,      2, 3,  "POL D12.XXX"},
        {50.092012,   19.089517,      3, 4,  "POL F12.XXX"},
        {50.092012,   19.808221,      2, 3,  "POL G12.XXX"},
        {50.092012,   20.526925,      2, 3,  "POL H12.XXX"},
        {50.092012,   21.245629,      2, 3,  "POL J12.XXX"},
        {50.092012,   21.964333,      2, 3,  "POL K12.XXX"},
        {50.092012,   22.683037,      2, 4,  "POL L12.XXX"},
        {49.600972,   18.842605,      2, 7,  "POL M12.XXX"},
        {49.600972,   19.550893,      2, 5,  "POL N12.XXX"},
        {49.600972,   20.259181,      2, 5,  "POL P12.XXX"},
        {49.600972,   20.967469,      2, 5,  "POL Q12.XXX"},
        {49.600972,   21.675757,      2, 5,  "POL R12.XXX"},
        {49.600972,   22.384045,      2, 6,  "POL S12.XXX"},
        {52.450115,   20.6191665,     3, 4,  "POL T12.XXX"},
        {51.970115,   19.12628,       3, 4,  "POL V12.XXX"},
        {54.645315,   18.2147265,     2, 3,  "POL W12.XXX"},
        {53.585115,   14.4348965,     2, 4,  "POL X12.XXX"},
        {54.368215,   18.9863205,     2, 3,  "POL Y12.XXX"},
        {54.390115,   15.8352615,     2, 3,  "POL Z12.XXX"},
        {53.053049,   15.4419885,     2, 3,  "POL 12.XXXX"},
        {53.120009,   19.5332445,     2, 3,  "POL 1234.XX"},
        {51.92,       19.1275,        3, 4,  "POL 8QBM.1HS"},
        {5.365101,    -4.06789,       4, 5,  "CIV 12.XX"},
        {5.290252,    -4.4051875,     3, 4,  "CIV 12.XXX"},
        {7.741445,    -5.091337125,   3, 4,  "CIV 000.XX"},
        {7.741445,    -5.029719125,   3, 4,  "CIV 100.XX"},
        {6.917446,    -6.490318625,   3, 4,  "CIV 200.XX"},
        {6.850446,    -5.30520575,    3, 4,  "CIV 300.XX"},
        {9.499646,    -5.6707315,     2, 3,  "CIV 400.XX"},
        {4.800246,    -6.694092875,   3, 4,  "CIV 500.XX"},
        {5.872946,    -5.40030575,    3, 4,  "CIV 600.XX"},
        {7.448646,    -7.593318625,   3, 4,  "CIV 700.XX"},
        {6.172046,    -5.99140575,    3, 4,  "CIV 800.XX"},
        {6.769846,    -3.53820575,    3, 4,  "CIV 900.XX"},
        {7.003186,    -5.775271875,   3, 4,  "CIV B00.XX"},
        {6.645472,    -4.74879375,    3, 4,  "CIV BK0.00"},
        {5.942485,    -4.23784625,    3, 4,  "CIV C00.XX"},
        {6.615426,    -5.93749975,    3, 4,  "CIV CK0.00"},
        {7.270086,    -8.181871875,   3, 5,  "CIV D00.XX"},
        {8.034526,    -2.827871625,   2, 3,  "CIV DK0.00"},
        {9.606749,    -5.235590125,   2, 4,  "CIV F00.XX"},
        {8.138297,    -5.122534625,   3, 4,  "CIV FK0.00"},
        {6.505786,    -6.61358625,    3, 4,  "CIV G00.XX"},
        {6.362126,    -5.43179975,    3, 4,  "CIV GK0.00"},
        {9.516386,    -7.593844125,   2, 3,  "CIV H00.XX"},
        {6.560809,    -5.03929975,    3, 4,  "CIV HK0.00"},
        {6.117986,    -3.89378625,    3, 4,  "CIV J00.XX"},
        {5.774084,    -6.62567375,    3, 4,  "CIV JK0.00"},
        {6.752486,    -7.38448625,    3, 4,  "CIV K00.XX"},
        {7.953026,    -6.701571625,   3, 4,  "CIV KK0.00"},
        {7.149361,    -3.233741875,   3, 6,  "CIV L00.XX"},
        {7.053685,    -3.999636625,   3, 4,  "CIV LK0.00"},
        {5.480886,    -3.23798625,    3, 4,  "CIV M00.XX"},
        {5.890774,    -4.85185975,    3, 4,  "CIV MK0.00"},
        {6.407265,    -3.91351925,    3, 4,  "CIV N00.XX"},
        {5.852432,    -5.71202375,    3, 4,  "CIV NK0.00"},
        {10.495764,   -6.43492975,    2, 5,  "CIV P00.XX"},
        {6.521642,    -7.52490875,    3, 4,  "CIV PK0.00"},
        {9.536086,    -6.513144125,   2, 3,  "CIV Q00.XX"},
        {5.259917,    -3.630515875,   3, 4,  "CIV QK0.00"},
        {6.686286,    -4.00178625,    3, 4,  "CIV R00.XX"},
        {7.422026,    -6.077971625,   3, 4,  "CIV RK0.00"},
        {7.394186,    -6.508371875,   3, 4,  "CIV S00.XX"},
        {6.313626,    -3.97799975,    3, 4,  "CIV SK0.00"},
        {6.670386,    -4.22928625,    3, 4,  "CIV T00.XX"},
        {6.184054,    -5.32864475,    3, 4,  "CIV TK0.00"},
        {6.483622,    -4.40148425,    3, 4,  "CIV V00.XX"},
        {8.272011,    -7.697967625,   3, 5,  "CIV VK0.00"},
        {6.332465,    -5.97108625,    3, 4,  "CIV W00.XX"},
        {9.264105,    -3.0263445,     2, 3,  "CIV WK0.00"},
        {4.967948,    -6.120720625,   3, 4,  "CIV X00.XX"},
        {5.844127,    -4.77078675,    3, 4,  "CIV XK0.00"},
        {7.752465,    -7.651171875,   3, 5,  "CIV Y00.XX"},
        {7.798812,    -3.194956625,   3, 4,  "CIV YK0.00"},
        {7.171299,    -5.254957875,   3, 4,  "CIV Z00.XX"},
        {4.418844,    -7.386058875,   3, 4,  "CIV ZK0.00"},
        {8.2949445,   -5.4322385,     2, 3,  "CIV 123.XXX"},
        {8.086575,    -8.048447,      2, 4,  "CIV 12.XXXX"},
        {4.834643,    -7.438269,      2, 3,  "CIV 1234.XX"},
        {7.545,       -5.5473615,     2, 3,  "CIV JTB6.C54"},
        {59.960289,   10.675062,      4, 5,  "NOR 12.XX"},
        {59.997355,   10.34212,       3, 4,  "NOR 12.XXX"},
        {63.446545,   10.294494375,   3, 4,  "NOR 000.XX"},
        {63.381545,   10.294494375,   3, 4,  "NOR 100.XX"},
        {60.414424,   5.20876275,     3, 4,  "NOR 200.XX"},
        {60.327935,   5.210005375,    3, 4,  "NOR 300.XX"},
        {59.009724,   5.609491625,    3, 4,  "NOR 400.XX"},
        {58.923235,   5.609491625,    3, 4,  "NOR 500.XX"},
        {58.836746,   5.609491625,    3, 4,  "NOR 600.XX"},
        {59.258724,   10.871391625,   3, 4,  "NOR 700.XX"},
        {59.790824,   10.109148,      3, 4,  "NOR 800.XX"},
        {58.182024,   7.918551125,    3, 4,  "NOR 900.XX"},
        {69.706724,   18.84961875,    2, 3,  "NOR B00.XX"},
        {59.316624,   10.360991625,   3, 4,  "NOR C00.XX"},
        {62.517324,   6.106599125,    4, 5,  "NOR D00.XX"},
        {62.517324,   6.293272125,    4, 5,  "NOR F00.XX"},
        {59.454424,   5.240348,       3, 4,  "NOR G00.XX"},
        {59.182824,   10.125791625,   3, 4,  "NOR H00.XX"},
        {59.477924,   10.580448,      3, 4,  "NOR J00.XX"},
        {67.330724,   14.307575625,   2, 4,  "NOR K00.XX"},
        {58.500824,   8.687321375,    3, 4,  "NOR L00.XX"},
        {60.839824,   11.00196275,    3, 5,  "NOR M00.XX"},
        {59.095424,   9.969191625,    3, 4,  "NOR N00.XX"},
        {59.167924,   11.325691625,   3, 5,  "NOR P00.XX"},
        {61.161024,   10.37890625,    3, 4,  "NOR Q00.XX"},
        {62.747545,   7.046945625,    3, 4,  "NOR R00.XX"},
        {66.322004,   14.101403875,   2, 4,  "NOR RK0.00"},
        {59.422464,   10.379144,      3, 4,  "NOR S00.XX"},
        {59.656104,   9.600348,       4, 5,  "NOR SK0.00"},
        {60.801764,   10.59045525,    3, 4,  "NOR T00.XX"},
        {63.100204,   7.703051875,    3, 4,  "NOR TK0.00"},
        {68.435064,   17.326773,      2, 4,  "NOR V00.XX"},
        {60.167304,   10.185852375,   3, 4,  "NOR VK0.00"},
        {60.897264,   11.50212475,    3, 5,  "NOR W00.XX"},
        {69.955004,   23.222302875,   2, 4,  "NOR WK0.00"},
        {60.171864,   11.108600125,   3, 5,  "NOR X00.XX"},
        {64.010504,   11.4482525,     3, 5,  "NOR XK0.00"},
        {60.204164,   11.926800125,   3, 5,  "NOR Y00.XX"},
        {58.254104,   7.910568375,    3, 4,  "NOR YK0.00"},
        {59.789664,   5.422444,       3, 4,  "NOR Z00.XX"},
        {58.032604,   7.411392125,    3, 4,  "NOR ZK0.00"},
        {63.558267,   10.0431345,     2, 3,  "NOR 012.XXX"},
        {64.049307,   10.8546445,     2, 3,  "NOR 112.XXX"},
        {63.379871,   6.9985635,      2, 3,  "NOR 212.XXX"},
        {63.379871,   8.0245395,      2, 3,  "NOR 312.XXX"},
        {63.379871,   9.0505155,      2, 3,  "NOR 412.XXX"},
        {62.888831,   5.976936,       2, 3,  "NOR 512.XXX"},
        {62.888831,   6.987288,       2, 3,  "NOR 612.XXX"},
        {62.888831,   7.99764,        2, 3,  "NOR 712.XXX"},
        {62.397791,   4.975854,       2, 3,  "NOR 812.XXX"},
        {62.397791,   5.965374,       2, 3,  "NOR 912.XXX"},
        {62.397791,   6.954894,       3, 4,  "NOR B12.XXX"},
        {62.569655,   6.057035,       3, 4,  "NOR C12.XXX"},
        {61.931303,   5.0796755,      2, 3,  "NOR D12.XXX"},
        {61.931303,   6.0535715,      2, 3,  "NOR F12.XXX"},
        {61.440263,   4.986634,       2, 3,  "NOR G12.XXX"},
        {61.440263,   5.944906,       2, 3,  "NOR H12.XXX"},
        {61.440263,   6.903178,       2, 3,  "NOR J12.XXX"},
        {60.949223,   4.9961905,      2, 3,  "NOR K12.XXX"},
        {60.949223,   5.9388385,      2, 3,  "NOR L12.XXX"},
        {60.949223,   6.8814865,      2, 3,  "NOR M12.XXX"},
        {61.36882,    7.9114005,      2, 3,  "NOR 1234.XX"},
        {60.37743,    5.028355,       2, 3,  "NOR 12.XXXX"},
        {79.1460125,  -7.648473,      1, 3,  "NOR 123.XXXX"},
        {61.572,      18.045,         1, 3,  "NOR HG14.GX4"},
        {3.186072,    101.664781,     4, 6,  "MYS 12.XX"},
        {3.252215,    101.395025,     3, 5,  "MYS 12.XXX"},
        {1.538834,    103.62358,      3, 6,  "MYS 000.XX"},
        {1.52586,     103.710069,     3, 6,  "MYS 100.XX"},
        {1.600545,    103.75808,      3, 6,  "MYS 200.XX"},
        {1.510145,    103.87628,      3, 6,  "MYS 300.XX"},
        {4.590545,    101.029360625,  3, 5,  "MYS 400.XX"},
        {4.654545,    101.043725625,  3, 5,  "MYS 500.XX"},
        {1.597244,    110.29127,      3, 6,  "MYS 600.XX"},
        {1.597244,    110.352379,     3, 6,  "MYS 700.XX"},
        {5.979334,    116.04034125,   3, 4,  "MYS 800.XX"},
        {5.886545,    118.02902625,   3, 8,  "MYS 900.XX"},
        {2.744234,    101.91838,      3, 5,  "MYS B00.XX"},
        {3.847315,    103.272225625,  3, 5,  "MYS C00.XX"},
        {5.325545,    103.09634125,   3, 5,  "MYS D00.XX"},
        {6.157434,    102.22814125,   3, 5,  "MYS F00.XX"},
        {4.289834,    117.836525625,  3, 6,  "MYS G00.XX"},
        {4.903745,    100.690225625,  3, 5,  "MYS H00.XX"},
        {6.172845,    100.33192625,   3, 5,  "MYS J00.XX"},
        {5.465885,    100.27022625,   3, 6,  "MYS K00.XX"},
        {5.368545,    100.25472625,   3, 6,  "MYS L00.XX"},
        {5.678334,    100.45514125,   3, 6,  "MYS M00.XX"},
        {4.456545,    113.967360625,  3, 5,  "MYS N00.XX"},
        {2.346545,    111.815445,     3, 5,  "MYS P00.XX"},
        {5.362234,    100.41184125,   4, 6,  "MYS Q00.XX"},
        {2.249434,    102.21628,      3, 6,  "MYS R00.XX"},
        {2.053545,    103.27028,      3, 6,  "MYS S00.XX"},
        {1.869434,    102.920225,     3, 6,  "MYS T00.XX"},
        {5.437134,    100.52522625,   3, 5,  "MYS V00.XX"},
        {3.202234,    113.030525,     3, 5,  "MYS W00.XX"},
        {2.082734,    102.53538,      3, 6,  "MYS X00.XX"},
        {5.440075,    100.36322625,   3, 6,  "MYS Y00.XX"},
        {2.572099,    101.789425,     3, 5,  "MYS Z00.XX"},
        {3.324004,    101.553782875,  3, 5,  "MYS ZK0.00"},
        {3.9395585,   101.3827475,    2, 4,  "MYS 123.XXX"},
        {5.5721855,   100.337491,     2, 5,  "MYS 12.XXXX"},
        {1.315409,    110.12036,      2, 5,  "MYS 1123.XX"},
        {5.689944,    115.84163,      2, 4,  "MYS 2123.XX"},
        {5.63273,     117.8494,       2, 7,  "MYS 3123.XX"},
        {4.036659,    117.63235,      2, 5,  "MYS 4123.XX"},
        {4.172314,    113.74955,      2, 4,  "MYS 5123.XX"},
        {2.063915,    111.59895,      2, 4,  "MYS 6123.XX"},
        {2.941664,    112.82262,      2, 4,  "MYS 7123.XX"},
        {4.795864,    118.10821,      2, 7,  "MYS 8123.XX"},
        {5.055864,    115.0082,       2, 6,  "MYS 9123.XX"},
        {3.993072,    103.245949,     3, 5,  "MYS B123.XX"},
        {4.484112,    103.245949,     3, 5,  "MYS C123.XX"},
        {4.975152,    103.245949,     3, 5,  "MYS D123.XX"},
        {3.545409,    100.361189,     2, 5,  "MYS F123.XX"},
        {3.545409,    100.829908,     2, 4,  "MYS G123.XX"},
        {3.099967,    101.052337,     2, 4,  "MYS H123.XX"},
        {6.108467,    99.622565,      2, 4,  "MYS J123.XX"},
        {6.2656,      100.102625,     2, 4,  "MYS K123.XX"},
        {6.2656,      100.571345,     2, 4,  "MYS L123.XX"},
        {1.839521,    103.941631,     3, 6,  "MYS M123.XX"},
        {1.348481,    103.941631,     3, 7,  "MYS N123.XX"},
        {2.898429,    100.303705,     1, 4,  "MYS 1234.XXX"},
        {10.8097,     106.6446695,    4, 5,  "VNM 12.XX"},
        {10.932294,   106.56262325,   3, 4,  "VNM 00.XXX"},
        {21.084814,   105.668512,     3, 6,  "VNM J0.XXX"},
        {16.143324,   108.09783875,   3, 4,  "VNM 000.XX"},
        {16.143324,   108.18769075,   3, 4,  "VNM 100.XX"},
        {16.056835,   108.11580875,   3, 4,  "VNM 200.XX"},
        {16.056835,   108.20566075,   3, 4,  "VNM 300.XX"},
        {20.863175,   106.636112,     3, 5,  "VNM 400.XX"},
        {16.506424,   107.551025875,  2, 5,  "VNM 500.XX"},
        {12.295834,   109.172124,     3, 4,  "VNM 600.XX"},
        {10.085424,   105.70904275,   3, 4,  "VNM 700.XX"},
        {10.026545,   105.061628125,  3, 5,  "VNM 800.XX"},
        {10.412524,   107.05764275,   3, 4,  "VNM 900.XX"},
        {10.430724,   105.38864275,   3, 7,  "VNM B00.XX"},
        {21.006545,   107.18464125,   3, 6,  "VNM C00.XX"},
        {10.995524,   108.06894275,   2, 3,  "VNM D00.XX"},
        {20.978545,   106.99054,      3, 6,  "VNM F00.XX"},
        {11.967524,   109.115629875,  3, 4,  "VNM G00.XX"},
        {21.603924,   105.807869375,  3, 10, "VNM H00.XX"},
        {11.969545,   108.396144375,  3, 4,  "VNM J00.XX"},
        {13.781864,   109.18742675,   3, 4,  "VNM K00.XX"},
        {20.423304,   106.141180875,  3, 5,  "VNM KK0.00"},
        {12.692464,   108.008312375,  3, 4,  "VNM L00.XX"},
        {10.346915,   106.33961525,   3, 4,  "VNM LK0.00"},
        {9.615464,    105.944555875,  3, 4,  "VNM M00.XX"},
        {13.972404,   107.98492125,   3, 4,  "VNM MK0.00"},
        {19.823164,   105.74219625,   3, 5,  "VNM N00.XX"},
        {9.174104,    105.1236555,    3, 5,  "VNM NK0.00"},
        {9.308764,    105.6971415,    3, 4,  "VNM P00.XX"},
        {10.240364,   105.94012925,   3, 6,  "VNM PK0.00"},
        {20.858945,   105.32224,      3, 5,  "VNM Q00.XX"},
        {18.673004,   105.654270375,  2, 4,  "VNM QK0.00"},
        {11.584164,   108.984584625,  3, 4,  "VNM R00.XX"},
        {21.690485,   104.847369625,  3, 10, "VNM RK0.00"},
        {21.333305,   105.35974125,   3, 10, "VNM S00.XX"},
        {13.083004,   109.285594125,  3, 4,  "VNM SK0.00"},
        {21.324264,   105.57315275,   3, 10, "VNM T00.XX"},
        {10.692004,   105.07791075,   3, 7,  "VNM TK0.00"},
        {15.569864,   108.455768875,  3, 4,  "VNM V00.XX"},
        {20.928604,   106.302008,     3, 6,  "VNM VK0.00"},
        {10.256664,   106.34607025,   3, 4,  "VNM W00.XX"},
        {9.939404,    106.321483625,  3, 4,  "VNM WK0.00"},
        {20.093564,   105.843010625,  3, 5,  "VNM X00.XX"},
        {21.275204,   106.17706325,   3, 10, "VNM XK0.00"},
        {20.466464,   106.305710625,  3, 5,  "VNM Y00.XX"},
        {14.344804,   107.979049375,  3, 4,  "VNM YK0.00"},
        {21.195464,   106.02655275,   3, 10, "VNM Z00.XX"},
        {10.294104,   105.73351075,   3, 6,  "VNM ZK0.00"},
        {11.5135455,  104.887512,     2, 7,  "VNM 123.XXX"},
        {21.841111,   104.8729005,    2, 9,  "VNM 12.XXXX"},
        {16.0141575,  108.0058125,    2, 3,  "VNM 1234.XX"},
        {15.45,       105.8175,       1, 4,  "VNM PN1M.PCB"},
        {60.222398,   24.865062,      4, 6,  "FIN 12.XX"},
        {60.384605,   24.575161875,   3, 5,  "FIN 00.XXX"},
        {61.507005,   23.43179925,    3, 6,  "FIN J0.XXX"},
        {60.490724,   22.16796275,    4, 7,  "FIN 000.XX"},
        {65.060824,   25.3866325,     3, 5,  "FIN 100.XX"},
        {61.027124,   25.57410625,    3, 5,  "FIN 200.XX"},
        {62.939624,   27.550199125,   3, 5,  "FIN 300.XX"},
        {62.300724,   25.663781375,   3, 5,  "FIN 400.XX"},
        {61.527124,   21.702637875,   3, 6,  "FIN 500.XX"},
        {61.100724,   28.09660625,    3, 8,  "FIN 600.XX"},
        {63.149024,   21.547417875,   3, 6,  "FIN 700.XX"},
        {60.510824,   26.83676275,    3, 7,  "FIN 800.XX"},
        {62.655524,   29.691899125,   2, 6,  "FIN 900.XX"},
        {61.040724,   24.36660625,    3, 5,  "FIN B00.XX"},
        {60.434724,   25.56806275,    3, 5,  "FIN C00.XX"},
        {61.731124,   27.178637875,   3, 5,  "FIN D00.XX"},
        {61.170724,   21.43040625,    3, 6,  "FIN F00.XX"},
        {60.645264,   24.79595525,    3, 5,  "FIN G00.XX"},
        {60.474104,   25.04745575,    3, 5,  "FIN GK0.00"},
        {66.512064,   25.610429625,   2, 4,  "FIN H00.XX"},
        {60.244104,   24.028252375,   3, 6,  "FIN HK0.00"},
        {63.852464,   23.050870875,   3, 6,  "FIN J00.XX"},
        {64.224104,   27.6706525,     3, 5,  "FIN JK0.00"},
        {60.884564,   26.65312475,    3, 5,  "FIN K00.XX"},
        {61.174204,   28.71928725,    2, 9,  "FIN KK0.00"},
        {62.797664,   22.783175375,   3, 6,  "FIN L00.XX"},
        {61.862604,   28.859746875,   2, 5,  "FIN LK0.00"},
        {60.754064,   24.71435525,    3, 5,  "FIN M00.XX"},
        {60.382104,   23.07915575,    3, 6,  "FIN MK0.00"},
        {60.502464,   22.11765525,    3, 6,  "FIN N00.XX"},
        {63.561604,   27.143038625,   3, 5,  "FIN NK0.00"},
        {62.332564,   27.807778125,   3, 5,  "FIN P00.XX"},
        {65.738704,   24.506106625,   3, 5,  "FIN PK0.00"},
        {65.854064,   24.085474875,   3, 6,  "FIN Q00.XX"},
        {61.204104,   25.97658725,    3, 5,  "FIN QK0.00"},
        {61.351564,   22.84352475,    3, 6,  "FIN R00.XX"},
        {60.914104,   26.55658725,    3, 5,  "FIN RK0.00"},
        {61.282464,   23.96662475,    3, 6,  "FIN S00.XX"},
        {63.074104,   27.602751875,   3, 5,  "FIN SK0.00"},
        {63.691264,   22.640870875,   3, 6,  "FIN T00.XX"},
        {60.814104,   23.57745575,    3, 6,  "FIN TK0.00"},
        {65.972464,   29.105374875,   2, 5,  "FIN V00.XX"},
        {64.682735,   24.4194945,     3, 5,  "FIN VK0.00"},
        {60.655364,   25.23815525,    3, 5,  "FIN W00.XX"},
        {60.794104,   21.35745575,    2, 5,  "FIN WK0.00"},
        {62.408864,   25.847178125,   3, 5,  "FIN X00.XX"},
        {60.684004,   26.75015575,    3, 7,  "FIN XK0.00"},
        {60.382464,   25.19765525,    4, 6,  "FIN Y00.XX"},
        {65.184104,   25.2883365,     3, 5,  "FIN YK0.00"},
        {60.936964,   24.57632475,    3, 5,  "FIN Z00.XX"},
        {59.980604,   23.420152375,   3, 6,  "FIN ZK0.00"},
        {62.8451775,  21.701773,      2, 5,  "FIN 12.XXXX"},
        {61.074915,   21.570264,      2, 5,  "FIN 123.XXX"},
        {63.813988,   22.7723005,     2, 5,  "FIN 1234.XX"},
        {69.375,      25.4,           1, 3,  "FIN TD8.3FTT"},
        {64.912875,   25.4,           2, 4,  "FIN RT04.RCL"},
        {-4.206251,   15.22211,       4, 8,  "COG 12.XX"},
        {-4.123106,   15.017816875,   3, 6,  "COG 00.XXX"},
        {-4.753986,   11.776766875,   3, 5,  "COG J0.XXX"},
        {-4.219286,   12.612021125,   3, 6,  "COG 000.XX"},
        {-4.161876,   13.262607125,   3, 6,  "COG 200.XX"},
        {-4.094876,   13.014007125,   3, 6,  "COG 300.XX"},
        {-2.920576,   12.67532,       3, 5,  "COG 400.XX"},
        {-0.443276,   15.85592,       3, 4,  "COG 500.XX"},
        {1.650724,    16.00932,       2, 4,  "COG 600.XX"},
        {-4.131076,   13.510907125,   3, 6,  "COG 700.XX"},
        {-1.835376,   15.83182,       3, 4,  "COG 800.XX"},
        {1.643624,    18.00422,       2, 5,  "COG 900.XX"},
        {-4.321576,   14.727007125,   3, 6,  "COG B00.XX"},
        {-3.645376,   13.336007125,   3, 5,  "COG C00.XX"},
        {-2.500376,   14.71402,       3, 4,  "COG D00.XX"},
        {-4.128276,   11.895707125,   3, 4,  "COG F00.XX"},
        {-0.840576,   14.79702,       3, 4,  "COG G00.XX"},
        {-1.839276,   12.65492,       2, 5,  "COG H00.XX"},
        {2.089424,    18.00052,       2, 5,  "COG J00.XX"},
        {-1.179276,   16.75932,       3, 6,  "COG K00.XX"},
        {1.680724,    14.53932,       2, 4,  "COG L00.XX"},
        {-4.216776,   14.318907125,   3, 6,  "COG M00.XX"},
        {-0.039976,   14.46772,       3, 5,  "COG N00.XX"},
        {-3.434476,   12.270207125,   3, 5,  "COG P00.XX"},
        {1.405024,    17.43532,       2, 3,  "COG Q00.XX"},
        {-3.238476,   13.186207125,   3, 5,  "COG R00.XX"},
        {-2.824076,   13.78402,       3, 5,  "COG S00.XX"},
        {-4.208876,   11.623707125,   3, 4,  "COG T00.XX"},
        {-3.948676,   11.266107125,   3, 5,  "COG V00.XX"},
        {0.473324,    14.64172,       2, 3,  "COG W00.XX"},
        {2.099524,    14.08362,       2, 5,  "COG X00.XX"},
        {-1.413076,   15.06352,       3, 4,  "COG Y00.XX"},
        {-3.957476,   13.911907125,   3, 5,  "COG Z00.XX"},
        {-2.4304215,  11.2497095,     2, 5,  "COG 123.XXX"},
        {-2.622475,   13.996403,      2, 4,  "COG 12.XXXX"},
        {0.070259,    14.194772,      2, 4,  "COG 1234.XX"},
        {3.109866,    11.4130475,     1, 4,  "COG 1234.XXX"},
        {52.554,      13.3518935,     4, 5,  "DEU 12.XX"},
        {52.537214,   13.25984775,    3, 4,  "DEU 000.XX"},
        {52.537214,   13.46029875,    4, 5,  "DEU 200.XX"},
        {52.414905,   13.261035875,   3, 4,  "DEU 400.XX"},
        {52.414905,   13.459108875,   3, 4,  "DEU 600.XX"},
        {53.623844,   9.855178125,    3, 4,  "DEU 800.XX"},
        {48.118014,   11.474183875,   3, 4,  "DEU B00.XX"},
        {50.922614,   6.86674325,     3, 5,  "DEU D00.XX"},
        {50.160724,   8.61694675,     3, 5,  "DEU G00.XX"},
        {51.550724,   7.414799125,    3, 4,  "DEU H00.XX"},
        {48.835824,   9.1329805,      3, 5,  "DEU J00.XX"},
        {51.508524,   6.925999125,    4, 5,  "DEU K00.XX"},
        {51.271724,   6.73129025,     3, 4,  "DEU L00.XX"},
        {53.120724,   8.74242675,     3, 4,  "DEU M00.XX"},
        {52.440724,   9.664121875,    3, 4,  "DEU N00.XX"},
        {51.470224,   6.675799125,    3, 4,  "DEU P00.XX"},
        {49.490724,   10.987624,      3, 4,  "DEU Q00.XX"},
        {51.390724,   12.33559025,    3, 4,  "DEU R00.XX"},
        {51.090724,   13.67559025,    3, 4,  "DEU S00.XX"},
        {51.507524,   7.137299125,    4, 5,  "DEU T00.XX"},
        {51.300724,   7.11559025,     3, 4,  "DEU V00.XX"},
        {52.067824,   8.477921875,    3, 4,  "DEU W00.XX"},
        {50.754145,   7.0326025,      3, 5,  "DEU X00.XX"},
        {49.540724,   8.407624,       3, 5,  "DEU Y00.XX"},
        {49.026045,   8.33475325,     3, 5,  "DEU Z00.XX"},
        {51.472604,   7.044799125,    4, 5,  "DEU 00.XXX"},
        {51.923404,   7.553621875,    3, 4,  "DEU 10.XXX"},
        {48.322604,   10.8289805,     3, 4,  "DEU 20.XXX"},
        {50.790104,   12.8539685,     3, 4,  "DEU 30.XXX"},
        {50.738504,   6.0410685,      3, 7,  "DEU 40.XXX"},
        {50.032604,   8.17154675,     3, 5,  "DEU 50.XXX"},
        {51.150404,   6.38619025,     3, 4,  "DEU 60.XXX"},
        {52.088904,   11.559021875,   3, 4,  "DEU 70.XXX"},
        {51.476204,   6.801599125,    3, 4,  "DEU 80.XXX"},
        {52.227304,   10.445221875,   3, 4,  "DEU 90.XXX"},
        {51.298704,   6.51559025,     3, 4,  "DEU B0.XXX"},
        {51.442604,   11.894799125,   3, 4,  "DEU C0.XXX"},
        {54.282604,   10.0508445,     3, 4,  "DEU D0.XXX"},
        {53.834704,   10.601935625,   2, 3,  "DEU F0.XXX"},
        {47.958104,   7.786745875,    3, 5,  "DEU G0.XXX"},
        {51.332904,   7.39349025,     3, 4,  "DEU H0.XXX"},
        {50.952604,   10.96559025,    3, 4,  "DEU J0.XXX"},
        {54.061304,   12.0456445,     3, 4,  "DEU K0.XXX"},
        {51.282604,   9.41559025,     3, 4,  "DEU L0.XXX"},
        {49.957704,   8.20314675,     3, 5,  "DEU M0.XXX"},
        {51.632604,   7.734799125,    3, 4,  "DEU N0.XXX"},
        {49.186704,   6.90970225,     3, 5,  "DEU P0.XXX"},
        {51.520104,   7.129599125,    4, 5,  "DEU Q0.XXX"},
        {51.392604,   6.812299125,    3, 4,  "DEU R0.XXX"},
        {52.242604,   7.984121875,    3, 4,  "DEU S0.XXX"},
        {51.141304,   6.98889025,     3, 4,  "DEU T0.XXX"},
        {51.006304,   6.93129025,     3, 5,  "DEU V0.XXX"},
        {53.112604,   8.14242675,     3, 4,  "DEU W0.XXX"},
        {51.163604,   6.60179025,     3, 4,  "DEU X0.XXX"},
        {49.376204,   8.596524,       3, 5,  "DEU Y0.XXX"},
        {51.682604,   8.674799125,    3, 4,  "DEU Z0.XXX"},
        {50.080581,   8.146874,       2, 4,  "DEU 12.XXXX"},
        {52.24278,    12.8951565,     2, 3,  "DEU 0123.XX"},
        {53.33858,    9.3637545,      2, 3,  "DEU 1123.XX"},
        {52.87358,    8.1340055,      2, 3,  "DEU 2123.XX"},
        {51.18358,    11.814179,      2, 3,  "DEU 3123.XX"},
        {50.95858,    13.239279,      2, 5,  "DEU 4123.XX"},
        {50.630865,   12.3181585,     3, 4,  "DEU 5123.XX"},
        {51.744565,   11.547328,      2, 3,  "DEU 6123.XX"},
        {53.860865,   9.9336035,      2, 3,  "DEU 7123.XX"},
        {47.57858,    7.415134,       2, 6,  "DEU 8123.XX"},
        {50.725865,   10.9444585,     3, 4,  "DEU 9123.XX"},
        {53.625865,   11.3638035,     2, 3,  "DEU B123.XX"},
        {49.09728,    6.477632,       2, 6,  "DEU C123.XX"},
        {48.720865,   11.9949115,     3, 4,  "DEU D123.XX"},
        {53.42638,    8.0146545,      2, 3,  "DEU F123.XX"},
        {50.05288,    7.2062095,      2, 4,  "DEU G123.XX"},
        {50.459365,   11.6247585,     3, 4,  "DEU H123.XX"},
        {51.37358,    13.919279,      3, 4,  "DEU J123.XX"},
        {49.515865,   6.274581,       2, 7,  "DEU K123.XX"},
        {49.06948,    7.220332,       2, 4,  "DEU L123.XX"},
        {54.370365,   9.0272525,      2, 3,  "DEU M123.XX"},
        {47.49358,    9.045134,       2, 6,  "DEU N123.XX"},
        {52.28358,    11.8140565,     2, 3,  "DEU P123.XX"},
        {52.64478,    9.6728055,      2, 3,  "DEU Q123.XX"},
        {53.33858,    12.8888545,     2, 3,  "DEU R123.XX"},
        {53.01858,    10.0188545,     3, 4,  "DEU S123.XX"},
        {52.01728,    14.0630565,     2, 3,  "DEU T123.XX"},
        {47.62858,    10.055034,      2, 5,  "DEU V123.XX"},
        {48.305865,   11.7949115,     3, 4,  "DEU W123.XX"},
        {47.62858,    11.810034,      2, 5,  "DEU X123.XX"},
        {53.970865,   12.8537035,     2, 3,  "DEU Y123.XX"},
        {50.93858,    14.339279,      2, 6,  "DEU Z123.XX"},
        {52.0897855,  6.097021,       2, 5,  "DEU 123.XXX"},
        {52.9223085,  6.360317,       1, 4,  "DEU 1234.XXX"},
        {35.7051,     139.693034,     5, 6,  "JPN 12.XX"},
        {35.949093,   139.513798375,  4, 5,  "JPN 00.XXX"},
        {35.949093,   139.620227375,  4, 5,  "JPN 10.XXX"},
        {35.949093,   139.726656375,  4, 5,  "JPN 20.XXX"},
        {35.862604,   139.449941375,  4, 5,  "JPN 30.XXX"},
        {35.862604,   139.556370375,  4, 5,  "JPN 40.XXX"},
        {35.862604,   139.662799375,  4, 5,  "JPN 50.XXX"},
        {35.862604,   139.769228375,  4, 5,  "JPN 60.XXX"},
        {35.862604,   139.875657375,  4, 5,  "JPN 70.XXX"},
        {35.776115,   139.449941375,  4, 5,  "JPN 80.XXX"},
        {35.776115,   139.556370375,  4, 5,  "JPN 90.XXX"},
        {35.776115,   139.662799375,  4, 5,  "JPN B0.XXX"},
        {35.776115,   139.769228375,  4, 5,  "JPN C0.XXX"},
        {35.776115,   139.875657375,  4, 5,  "JPN D0.XXX"},
        {35.776115,   139.982086375,  4, 5,  "JPN F0.XXX"},
        {35.689626,   139.449941375,  4, 5,  "JPN G0.XXX"},
        {35.689626,   139.556370375,  4, 5,  "JPN H0.XXX"},
        {35.689626,   139.662799375,  4, 5,  "JPN J0.XXX"},
        {35.689626,   139.769228375,  5, 6,  "JPN K0.XXX"},
        {35.689626,   139.875657375,  4, 5,  "JPN L0.XXX"},
        {35.689626,   139.982086375,  4, 5,  "JPN M0.XXX"},
        {35.603137,   139.45028,      4, 5,  "JPN N0.XXX"},
        {35.603137,   139.555989,     4, 5,  "JPN P0.XXX"},
        {35.603137,   139.661698,     4, 5,  "JPN Q0.XXX"},
        {35.603137,   139.767407,     4, 5,  "JPN R0.XXX"},
        {35.603137,   139.873116,     4, 5,  "JPN S0.XXX"},
        {35.516648,   139.397425,     4, 5,  "JPN T0.XXX"},
        {35.516648,   139.503134,     4, 5,  "JPN V0.XXX"},
        {35.516648,   139.608843,     4, 5,  "JPN W0.XXX"},
        {35.516648,   139.714552,     4, 5,  "JPN X0.XXX"},
        {35.430159,   139.45028,      4, 5,  "JPN Y0.XXX"},
        {35.430159,   139.555989,     4, 5,  "JPN Z0.XXX"},
        {34.720724,   135.450619625,  5, 6,  "JPN 000.XX"},
        {35.190724,   136.860619625,  5, 6,  "JPN 100.XX"},
        {43.100724,   141.2844045,    6, 7,  "JPN 200.XX"},
        {34.723924,   135.120219625,  4, 5,  "JPN 300.XX"},
        {35.050724,   135.700619625,  5, 6,  "JPN 400.XX"},
        {33.630724,   130.361523625,  4, 5,  "JPN 500.XX"},
        {34.431424,   132.405245375,  5, 6,  "JPN 600.XX"},
        {38.300724,   140.838585875,  4, 5,  "JPN 700.XX"},
        {33.920724,   130.811184,     5, 6,  "JPN 800.XX"},
        {35.650724,   140.06028,      4, 5,  "JPN 900.XX"},
        {34.610724,   135.430845375,  4, 5,  "JPN B00.XX"},
        {32.840724,   130.661749375,  4, 5,  "JPN C00.XX"},
        {34.697224,   133.867319625,  4, 5,  "JPN D00.XX"},
        {35.632124,   139.34258,      5, 6,  "JPN F00.XX"},
        {34.753624,   137.671819625,  4, 5,  "JPN G00.XX"},
        {35.700724,   139.28028,      4, 5,  "JPN H00.XX"},
        {31.630724,   130.51231475,   4, 5,  "JPN J00.XX"},
        {34.710524,   135.549019625,  6, 7,  "JPN K00.XX"},
        {37.960724,   138.988585875,  4, 5,  "JPN L00.XX"},
        {34.870724,   134.640619625,  4, 5,  "JPN M00.XX"},
        {33.847664,   132.730702,     5, 6,  "JPN N00.XX"},
        {34.974104,   138.358372625,  5, 6,  "JPN NK0.00"},
        {34.746764,   135.302872875,  4, 5,  "JPN P00.XX"},
        {36.554104,   136.60772075,   4, 5,  "JPN PK0.00"},
        {34.743264,   135.373872875,  5, 6,  "JPN Q00.XX"},
        {36.554104,   139.85772075,   4, 5,  "JPN QK0.00"},
        {33.252464,   131.563159875,  4, 5,  "JPN R00.XX"},
        {34.585404,   133.741017375,  4, 5,  "JPN RK0.00"},
        {35.282464,   139.632215,     4, 5,  "JPN S00.XX"},
        {32.744104,   129.849096375,  5, 6,  "JPN SK0.00"},
        {34.829164,   135.617772875,  5, 6,  "JPN T00.XX"},
        {35.414104,   136.728155,     5, 6,  "JPN TK0.00"},
        {35.347864,   139.435715,     4, 5,  "JPN V00.XX"},
        {34.806704,   135.378372625,  4, 5,  "JPN VK0.00"},
        {34.512564,   133.335245125,  5, 6,  "JPN W00.XX"},
        {34.214104,   135.138517375,  4, 5,  "JPN WK0.00"},
        {34.772464,   137.352472875,  4, 5,  "JPN X00.XX"},
        {34.684504,   135.777872625,  5, 6,  "JPN XK0.00"},
        {36.662464,   138.14170025,   4, 5,  "JPN Y00.XX"},
        {35.084104,   137.128372625,  4, 5,  "JPN YK0.00"},
        {37.062464,   140.841442375,  4, 5,  "JPN Z00.XX"},
        {43.764104,   142.324102,     6, 10, "JPN ZK0.00"},
        {34.9971845,  138.0129165,    4, 5,  "JPN 123.XXX"},
        {34.145934,   133.204855,     4, 5,  "JPN 12.XXXX"},
        {43.225897,   141.199533,     5, 6,  "JPN 0123.XX"},
        {33.862593,   130.3579265,    3, 4,  "JPN 1123.XX"},
        {34.462861,   132.2419685,    4, 5,  "JPN 2123.XX"},
        {38.563549,   140.725725,     3, 4,  "JPN 3123.XX"},
        {32.585961,   130.4230495,    3, 4,  "JPN 4123.XX"},
        {31.355865,   130.2947765,    3, 4,  "JPN 5123.XX"},
        {38.034601,   138.8062325,    3, 4,  "JPN 6123.XX"},
        {34.059905,   132.698166,     4, 5,  "JPN 7123.XX"},
        {36.39868,    136.3722235,    3, 4,  "JPN 8123.XX"},
        {32.988429,   131.403021,     3, 4,  "JPN 9123.XX"},
        {32.846301,   129.806269,     4, 5,  "JPN B123.XX"},
        {43.9305475,  141.8262095,    5, 9,  "JPN C123.XX"},
        {33.472457,   133.220486,     3, 4,  "JPN D123.XX"},
        {36.906235,   136.970844,     3, 4,  "JPN F123.XX"},
        {39.337965,   140.018742,     3, 4,  "JPN G123.XX"},
        {31.660409,   131.003021,     3, 4,  "JPN H123.XX"},
        {26.262925,   127.6388215,    3, 4,  "JPN J123.XX"},
        {40.604365,   140.271491,     3, 4,  "JPN K123.XX"},
        {37.903309,   139.9991545,    3, 4,  "JPN L123.XX"},
        {39.51315,    140.968306,     3, 4,  "JPN M123.XX"},
        {42.104925,   140.525248,     4, 5,  "JPN N123.XX"},
        {33.835865,   134.271846,     4, 5,  "JPN P123.XX"},
        {38.097383,   139.963249,     3, 4,  "JPN Q123.XX"},
        {35.83928,    135.970495,     4, 5,  "JPN R123.XX"},
        {33.989665,   130.8832005,    3, 4,  "JPN S123.XX"},
        {40.319665,   141.1192705,    3, 4,  "JPN T123.XX"},
        {33.075865,   130.2396245,    3, 4,  "JPN V123.XX"},
        {36.466704,   137.789192,     3, 4,  "JPN W123.XX"},
        {42.933265,   143.816889,     3, 4,  "JPN X123.XX"},
        {42.685865,   142.875789,     3, 4,  "JPN Y123.XX"},
        {35.498006,   132.3933145,    3, 4,  "JPN Z123.XX"},
        {45.4963885,  145.5205285,    2, 6,  "JPN 0123.XXX"},
        {32.59866,    128.2600725,    2, 3,  "JPN 1123.XXX"},
        {28.367171,   128.811376,     2, 3,  "JPN 2123.XXX"},
        {27.9521025,  126.476108,     2, 3,  "JPN 3123.XXX"},
        {26.6495785,  122.9367665,    2, 4,  "JPN 4123.XXX"},
        {34.5110905,  138.349473,     3, 4,  "JPN 5123.XXX"},
        {31.8299005,  139.0014715,    2, 3,  "JPN 6123.XXX"},
        {29.1323945,  139.6361575,    2, 3,  "JPN 7123.XXX"},
        {26.6495785,  140.2595095,    3, 4,  "JPN 8123.XXX"},
        {26.6495785,  129.8441795,    2, 3,  "JPN 9123.XXX"},
        {31.2233145,  129.312561,     2, 3,  "JPN B123.XXX"},
        {36.3179835,  130.8350135,    2, 3,  "JPN C123.XXX"},
        {34.4740615,  132.053073,     3, 4,  "JPN F123.XXX"},
        {44.4688015,  142.6089275,    3, 7,  "JPN G123.XXX"},
        {45.4883885,  139.8847075,    2, 4,  "JPN J123.XXX"},
        {35.9158055,  134.048932,     2, 3,  "JPN K123.XXX"},
        {43.9325635,  139.054622,     2, 4,  "JPN L123.XXX"},
        {38.6649845,  138.280205,     3, 4,  "JPN M123.XXX"},
        {34.860523,   135.4579165,    4, 5,  "JPN N123.XXX"},
        {41.5358085,  139.110352,     3, 4,  "JPN S123.XXX"},
        {37.1922805,  138.2932885,    3, 4,  "JPN T123.XXX"},
        {41.935585,   139.763509,     3, 4,  "JPN Z123.XXX"},
        {37.5620915,  135.3901765,    2, 3,  "JPN V123.XXX"},
        {38.5952995,  131.123831,     2, 3,  "JPN W123.XXX"},
        {35.67,       139.739344,     5, 6,  "JPN MGX7.FF61"},
        {-17.790909,  31.0103425,     4, 7,  "ZWE 12.XX"},
        {-17.775221,  30.887672875,   3, 6,  "ZWE 00.XXX"},
        {-20.125941,  28.397976125,   2, 4,  "ZWE J0.XXX"},
        {-19.484986,  29.72745575,    3, 4,  "ZWE 000.XX"},
        {-17.898986,  30.613505125,   3, 6,  "ZWE 200.XX"},
        {-18.362186,  29.83873525,    3, 4,  "ZWE 400.XX"},
        {-20.035476,  30.785021875,   3, 5,  "ZWE 600.XX"},
        {-18.881976,  29.7801605,     3, 4,  "ZWE 700.XX"},
        {-18.159176,  31.50748625,    3, 5,  "ZWE 800.XX"},
        {-20.276576,  30.019621875,   3, 4,  "ZWE 900.XX"},
        {-17.334976,  30.147699125,   3, 5,  "ZWE B00.XX"},
        {-18.313176,  26.45878625,    3, 5,  "ZWE C00.XX"},
        {-18.093676,  30.09558625,    3, 4,  "ZWE D00.XX"},
        {-18.974776,  29.7190605,     3, 4,  "ZWE F00.XX"},
        {-16.469876,  28.804225875,   3, 6,  "ZWE G00.XX"},
        {-17.266176,  31.283212,      3, 6,  "ZWE H00.XX"},
        {-17.894476,  25.76698625,    3, 7,  "ZWE J00.XX"},
        {-18.954776,  32.5535605,     3, 5,  "ZWE K00.XX"},
        {-18.960455,  32.6423845,     3, 5,  "ZWE L00.XX"},
        {-16.788276,  29.655812,      3, 5,  "ZWE M00.XX"},
        {-18.496876,  32.088273375,   3, 5,  "ZWE N00.XX"},
        {-19.637576,  29.95023475,    3, 4,  "ZWE P00.XX"},
        {-21.008876,  31.63208225,    3, 5,  "ZWE Q00.XX"},
        {-20.447176,  27.766821875,   3, 6,  "ZWE R00.XX"},
        {-16.728876,  31.543625875,   3, 6,  "ZWE S00.XX"},
        {-20.156576,  32.589921875,   3, 5,  "ZWE T00.XX"},
        {-20.897276,  28.963708,      3, 5,  "ZWE V00.XX"},
        {-19.768376,  32.82583475,    3, 6,  "ZWE W00.XX"},
        {-18.975176,  30.8529605,     3, 5,  "ZWE X00.XX"},
        {-19.247976,  30.4845605,     3, 5,  "ZWE Y00.XX"},
        {-22.170476,  29.9520565,     3, 6,  "ZWE Z00.XX"},
        {-18.044985,  29.795855,      2, 4,  "ZWE 112.XXX"},
        {-18.536025,  29.648989,      2, 3,  "ZWE 212.XXX"},
        {-19.027065,  29.6492755,     2, 3,  "ZWE 312.XXX"},
        {-19.518105,  29.6492755,     2, 3,  "ZWE 412.XXX"},
        {-20.009145,  29.6987515,     2, 3,  "ZWE 512.XXX"},
        {-16.322085,  28.7663765,     2, 5,  "ZWE G12.XXX"},
        {-17.854685,  25.625055,      2, 6,  "ZWE H12.XXX"},
        {-16.628485,  29.4021765,     2, 4,  "ZWE J12.XXX"},
        {-20.287785,  27.6941415,     2, 5,  "ZWE K12.XXX"},
        {-20.794985,  28.94612,       2, 4,  "ZWE L12.XXX"},
        {-21.871185,  29.77342,       2, 3,  "ZWE M12.XXX"},
        {-18.227485,  26.283655,      2, 4,  "ZWE P12.XXX"},
        {-18.227485,  26.773207,      2, 4,  "ZWE Q12.XXX"},
        {-18.286409,  27.262759,      2, 4,  "ZWE R12.XXX"},
        {-18.286409,  27.752311,      2, 4,  "ZWE S12.XXX"},
        {-18.777449,  27.507535,      2, 4,  "ZWE T12.XXX"},
        {-16.41307,   30.2794175,     2, 5,  "ZWE 12.XXXX"},
        {-19.0273,    30.181613,      2, 3,  "ZWE 1234.XX"},
        {-16.0800925, 25.5183825,     1, 3,  "ZWE 1234.XXX"},
        {-25.2649,    -57.6661985,    4, 8,  "PRY 12.XX"},
        {-25.111585,  -57.6442065,    3, 7,  "PRY 12.XXX"},
        {-25.537286,  -54.72866025,   3, 7,  "PRY 000.XX"},
        {-25.659595,  -54.71513825,   3, 7,  "PRY 200.XX"},
        {-25.537286,  -54.86387925,   3, 7,  "PRY 400.XX"},
        {-25.414977,  -54.71513825,   3, 5,  "PRY 600.XX"},
        {-27.348386,  -55.910848375,  3, 11, "PRY 800.XX"},
        {-22.557386,  -55.7918625,    3, 8,  "PRY B00.XX"},
        {-25.479486,  -56.08756025,   3, 5,  "PRY D00.XX"},
        {-25.409276,  -56.48497325,   3, 5,  "PRY G00.XX"},
        {-23.359776,  -57.457382125,  3, 9,  "PRY H00.XX"},
        {-25.736376,  -56.505186125,  3, 7,  "PRY J00.XX"},
        {-26.825676,  -58.318938625,  3, 7,  "PRY K00.XX"},
        {-25.356676,  -57.18637325,   4, 8,  "PRY L00.XX"},
        {-26.840776,  -57.067238625,  3, 7,  "PRY M00.XX"},
        {-24.630976,  -56.48012175,   3, 5,  "PRY N00.XX"},
        {-27.366955,  -56.928646875,  3, 9,  "PRY P00.XX"},
        {-26.661755,  -57.187819375,  3, 7,  "PRY Q00.XX"},
        {-23.306776,  -57.098882125,  3, 7,  "PRY R00.XX"},
        {-25.331576,  -55.75247325,   3, 5,  "PRY S00.XX"},
        {-24.438976,  -55.73252175,   3, 5,  "PRY T00.XX"},
        {-25.419376,  -57.08057325,   3, 7,  "PRY V00.XX"},
        {-25.219376,  -57.12527325,   3, 7,  "PRY W00.XX"},
        {-25.579276,  -57.20077325,   3, 7,  "PRY X00.XX"},
        {-27.117076,  -56.283338625,  3, 9,  "PRY Y00.XX"},
        {-25.754776,  -55.137486125,  3, 7,  "PRY Z00.XX"},
        {-24.3800035, -57.716191,     2, 6,  "PRY 123.XXX"},
        {-26.907275,  -58.492684,     2, 6,  "PRY 12.XXXX"},
        {-22.911251,  -59.7052045,    2, 6,  "PRY 1234.XX"},
        {-19.859103,  -62.3554375,    1, 4,  "PRY 1234.XXX"},
        {33.376145,   44.35587,       4, 5,  "IRQ 12.XX"},
        {33.358975,   44.081697125,   3, 4,  "IRQ 00.XXX"},
        {30.516014,   47.649052125,   3, 6,  "IRQ J0.XXX"},
        {36.436224,   43.04760275,    3, 5,  "IRQ 000.XX"},
        {36.436224,   43.15475275,    3, 5,  "IRQ 100.XX"},
        {36.349735,   43.04760275,    3, 5,  "IRQ 200.XX"},
        {36.349735,   43.15475275,    3, 5,  "IRQ 300.XX"},
        {36.227744,   43.936022875,   3, 5,  "IRQ 400.XX"},
        {36.217744,   44.011220875,   3, 5,  "IRQ 500.XX"},
        {35.530324,   44.32638,       3, 4,  "IRQ 600.XX"},
        {35.432967,   44.316275,      3, 4,  "IRQ 700.XX"},
        {35.589634,   45.367275,      3, 6,  "IRQ 800.XX"},
        {32.068324,   44.311188,      3, 6,  "IRQ 900.XX"},
        {32.653024,   43.956249375,   3, 4,  "IRQ B00.XX"},
        {31.080724,   46.2125405,     3, 4,  "IRQ C00.XX"},
        {32.513324,   44.370488,      3, 4,  "IRQ D00.XX"},
        {33.472224,   43.241323625,   3, 4,  "IRQ F00.XX"},
        {32.036324,   44.87971475,    3, 6,  "IRQ G00.XX"},
        {32.550224,   45.782988,      3, 6,  "IRQ H00.XX"},
        {31.884624,   47.11891475,    3, 6,  "IRQ J00.XX"},
        {33.786924,   44.584584,      3, 4,  "IRQ K00.XX"},
        {33.356364,   43.749059875,   3, 4,  "IRQ L00.XX"},
        {34.190704,   43.854417375,   3, 4,  "IRQ LK0.00"},
        {30.403164,   47.679262625,   4, 7,  "IRQ M00.XX"},
        {36.350025,   42.39881925,    3, 5,  "IRQ MK0.00"},
        {31.333264,   45.2459325,     2, 3,  "IRQ N00.XX"},
        {31.404104,   46.1396025,     3, 4,  "IRQ NK0.00"},
        {35.531164,   44.802715,      3, 6,  "IRQ P00.XX"},
        {32.294104,   44.649313,      3, 4,  "IRQ PK0.00"},
        {30.903964,   46.421790375,   3, 4,  "IRQ Q00.XX"},
        {36.853604,   42.798604125,   3, 5,  "IRQ QK0.00"},
        {34.362464,   45.342645125,   3, 4,  "IRQ R00.XX"},
        {35.620504,   45.910355,      2, 5,  "IRQ RK0.00"},
        {32.727864,   44.238432125,   3, 4,  "IRQ S00.XX"},
        {34.915504,   43.458872625,   3, 4,  "IRQ SK0.00"},
        {32.789864,   44.246632125,   3, 4,  "IRQ T00.XX"},
        {32.904104,   45.039096375,   3, 4,  "IRQ TK0.00"},
        {36.864445,   42.926280625,   3, 5,  "IRQ V00.XX"},
        {33.384104,   43.538951625,   3, 4,  "IRQ VK0.00"},
        {32.562464,   44.183332125,   3, 4,  "IRQ W00.XX"},
        {37.13343,    42.608250375,   3, 5,  "IRQ WK0.00"},
        {34.896864,   44.580972875,   3, 6,  "IRQ X00.XX"},
        {34.470304,   41.881717375,   2, 5,  "IRQ XK0.00"},
        {34.152464,   42.332645125,   2, 4,  "IRQ Y00.XX"},
        {31.954104,   44.55945775,    3, 6,  "IRQ YK0.00"},
        {29.983264,   48.434362625,   3, 8,  "IRQ Z00.XX"},
        {32.920104,   44.749796375,   3, 4,  "IRQ ZK0.00"},
        {34.3860205,  42.638998,      2, 3,  "IRQ 123.XXX"},
        {32.32763,    45.8376815,     2, 5,  "IRQ 12.XXXX"},
        {36.124244,   42.4874145,     2, 4,  "IRQ 1234.XX"},
        {33.195,      43.7448,        2, 3,  "IRQ NG8N.FM9"},
        {33.585632,   -7.6937705,     5, 6,  "MAR 12.XX"},
        {33.704615,   -7.817322,      4, 5,  "MAR 12.XXX"},
        {34.015424,   -6.899316,      4, 5,  "MAR 000.XX"},
        {33.976024,   -6.981216,      4, 5,  "MAR 100.XX"},
        {34.085624,   -6.855016,      4, 5,  "MAR 200.XX"},
        {34.070824,   -5.048816,      4, 5,  "MAR 300.XX"},
        {31.683545,   -8.08377425,    4, 5,  "MAR 400.XX"},
        {31.683545,   -8.01688825,    4, 5,  "MAR 500.XX"},
        {30.443024,   -9.607494125,   4, 5,  "MAR 600.XX"},
        {30.388824,   -9.548494125,   5, 6,  "MAR 700.XX"},
        {35.786145,   -5.895473125,   4, 5,  "MAR 800.XX"},
        {33.902145,   -5.603024,      5, 6,  "MAR 900.XX"},
        {34.721724,   -1.957380375,   4, 9,  "MAR B00.XX"},
        {34.275745,   -6.656098125,   4, 5,  "MAR C00.XX"},
        {32.326424,   -9.280812,      4, 5,  "MAR D00.XX"},
        {35.608045,   -5.423525,      4, 5,  "MAR F00.XX"},
        {32.920524,   -6.962250625,   4, 5,  "MAR G00.XX"},
        {32.365724,   -6.428312,      4, 5,  "MAR H00.XX"},
        {33.246564,   -8.553540125,   4, 5,  "MAR J00.XX"},
        {35.184005,   -3.003335,      4, 7,  "MAR JK0.00"},
        {33.013264,   -7.656967875,   4, 5,  "MAR K00.XX"},
        {34.991304,   -5.924527375,   5, 6,  "MAR KK0.00"},
        {33.839964,   -6.109898,      5, 6,  "MAR L00.XX"},
        {35.167504,   -6.165045,      4, 5,  "MAR LK0.00"},
        {29.002264,   -10.087693875,  4, 5,  "MAR M00.XX"},
        {34.223604,   -4.035782625,   5, 6,  "MAR MK0.00"},
        {32.506164,   -6.743611,      4, 5,  "MAR N00.XX"},
        {32.938604,   -5.698403625,   4, 5,  "MAR NK0.00"},
        {31.942864,   -4.46863875,    4, 7,  "MAR P00.XX"},
        {34.919104,   -2.358027375,   4, 8,  "MAR PK0.00"},
        {32.873964,   -6.611067875,   4, 5,  "MAR Q00.XX"},
        {34.254704,   -5.966582625,   4, 5,  "MAR QK0.00"},
        {34.421064,   -2.932354875,   4, 8,  "MAR R00.XX"},
        {34.211104,   -5.751382625,   4, 5,  "MAR RK0.00"},
        {30.481764,   -8.916509625,   4, 5,  "MAR S00.XX"},
        {34.314904,   -2.208382625,   4, 7,  "MAR SK0.00"},
        {32.245664,   -7.984311,      4, 5,  "MAR T00.XX"},
        {32.231004,   -8.549687,      4, 5,  "MAR TK0.00"},
        {32.061764,   -7.423511,      4, 5,  "MAR V00.XX"},
        {35.224804,   -3.967345,      5, 6,  "MAR VK0.00"},
        {34.802564,   -5.616227125,   4, 5,  "MAR W00.XX"},
        {29.698604,   -9.769290375,   4, 5,  "MAR WK0.00"},
        {33.905164,   -6.360598,      5, 6,  "MAR X00.XX"},
        {30.391404,   -9.237135125,   4, 5,  "MAR XK0.00"},
        {28.442464,   -11.135122625,  4, 5,  "MAR Y00.XX"},
        {27.131104,   -13.216766625,  4, 10, "MAR YK0.00"},
        {23.720764,   -15.970148625,  4, 10, "MAR Z00.XX"},
        {26.736904,   -11.701921875,  4, 10, "MAR ZK0.00"},
        {26.854723,   -14.3778755,    3, 8,  "MAR 12.XXXX"},
        {35.787727,   -6.174541,      3, 4,  "MAR 012.XXX"},
        {35.876115,   -5.601661,      3, 6,  "MAR 112.XXX"},
        {35.296687,   -6.2899245,     3, 4,  "MAR 212.XXX"},
        {35.385075,   -5.5519505,     3, 4,  "MAR 312.XXX"},
        {35.028915,   -5.99479,       4, 5,  "MAR 412.XXX"},
        {35.028915,   -5.432326,      4, 5,  "MAR 512.XXX"},
        {34.175115,   -4.90329,       3, 4,  "MAR 612.XXX"},
        {31.831115,   -8.2435335,     3, 4,  "MAR 712.XXX"},
        {30.517515,   -9.6461985,     3, 4,  "MAR 812.XXX"},
        {35.111115,   -2.3646035,     3, 6,  "MAR 912.XXX"},
        {32.463615,   -9.262955,      3, 4,  "MAR B12.XXX"},
        {33.363315,   -8.662793,      3, 4,  "MAR C12.XXX"},
        {32.872274,   -8.712477,      3, 4,  "MAR D12.XXX"},
        {32.381235,   -8.7130765,     3, 4,  "MAR F12.XXX"},
        {35.362315,   -3.2047035,     3, 4,  "MAR G12.XXX"},
        {29.189915,   -10.288785,     3, 4,  "MAR H12.XXX"},
        {34.429615,   -4.254589,      3, 4,  "MAR J12.XXX"},
        {32.079615,   -4.6057335,     3, 6,  "MAR K12.XXX"},
        {34.524415,   -3.37779,       3, 4,  "MAR L12.XXX"},
        {30.669415,   -9.1115985,     3, 4,  "MAR M12.XXX"},
        {34.642515,   -2.55889,       3, 7,  "MAR N12.XXX"},
        {31.681115,   -9.7931335,     3, 4,  "MAR P12.XXX"},
        {35.249115,   -4.3222205,     3, 4,  "MAR Q12.XXX"},
        {35.249115,   -3.7545485,     3, 4,  "MAR R12.XXX"},
        {29.904615,   -9.9702985,     3, 4,  "MAR S12.XXX"},
        {28.630115,   -11.3262635,    3, 4,  "MAR T12.XXX"},
        {31.120115,   -7.14102,       3, 4,  "MAR V12.XXX"},
        {32.881615,   -4.897155,      3, 4,  "MAR W12.XXX"},
        {31.720115,   -5.7655335,     3, 4,  "MAR X12.XXX"},
        {30.867115,   -8.21792,       3, 4,  "MAR Y12.XXX"},
        {23.915715,   -15.9832935,    3, 8,  "MAR Z12.XXX"},
        {34.40389,    -7.9390665,     2, 3,  "MAR 1234.XX"},
        {35.8683885,  -6.8508865,     2, 7,  "MAR 0123.XXX"},
        {35.8683885,  -4.0904435,     3, 6,  "MAR 1123.XXX"},
        {33.9469525,  -10.012118,     2, 3,  "MAR 2123.XXX"},
        {33.9469525,  -6.884063,      6, 7,  "MAR 3123.XXX"},
        {33.9469525,  -4.004456,      5, 6,  "MAR 4123.XXX"},
        {31.2657625,  -11.4558985,    2, 3,  "MAR 5123.XXX"},
        {31.2657625,  -8.4172165,     2, 3,  "MAR 6123.XXX"},
        {31.2657625,  -5.3785345,     2, 5,  "MAR 7123.XXX"},
        {28.6008885,  -14.437814,     2, 5,  "MAR 8123.XXX"},
        {28.6008885,  -11.488505,     2, 3,  "MAR 9123.XXX"},
        {25.9196985,  -17.654534,     2, 5,  "MAR B123.XXX"},
        {25.9196985,  -14.764807,     2, 6,  "MAR C123.XXX"},
        {23.1613675,  -17.6585975,    2, 5,  "MAR D123.XXX"},
        {23.1613675,  -14.7986615,    2, 6,  "MAR F123.XXX"},
        {33.5757245,  -7.6385,        5, 6,  "MAR L4QS.7WS4"},
        {41.317456,   69.1887595,     4, 8,  "UZB 12.XX"},
        {41.439215,   68.9420215,     3, 7,  "UZB 12.XXX"},
        {40.978314,   71.5830995,     3, 8,  "UZB 000.XX"},
        {39.630814,   66.884567125,   3, 4,  "UZB 200.XX"},
        {40.759814,   72.273909125,   3, 6,  "UZB 400.XX"},
        {39.755514,   64.350067125,   3, 5,  "UZB 600.XX"},
        {42.442914,   59.5184415,     3, 6,  "UZB 800.XX"},
        {40.424724,   71.731003625,   3, 6,  "UZB B00.XX"},
        {38.893724,   65.73849475,    3, 5,  "UZB C00.XX"},
        {40.580724,   70.886551125,   3, 8,  "UZB D00.XX"},
        {41.502224,   69.5258125,     3, 8,  "UZB F00.XX"},
        {41.592124,   60.57026,       3, 6,  "UZB G00.XX"},
        {40.167824,   67.788203625,   3, 4,  "UZB H00.XX"},
        {41.056024,   70.0424125,     3, 7,  "UZB J00.XX"},
        {40.155724,   65.296703625,   3, 5,  "UZB K00.XX"},
        {40.509624,   71.667951125,   3, 6,  "UZB L00.XX"},
        {40.267724,   69.190103625,   3, 6,  "UZB M00.XX"},
        {37.268524,   67.234563125,   2, 5,  "UZB N00.XX"},
        {40.890724,   69.536551125,   3, 7,  "UZB P00.XX"},
        {42.447824,   59.3928085,     3, 6,  "UZB Q00.XX"},
        {39.101824,   66.77709475,    3, 4,  "UZB R00.XX"},
        {40.543824,   68.729851125,   3, 6,  "UZB S00.XX"},
        {39.940724,   66.207003625,   3, 5,  "UZB T00.XX"},
        {38.317024,   67.858485875,   2, 4,  "UZB V00.XX"},
        {41.595024,   60.94236,       3, 6,  "UZB W00.XX"},
        {41.041924,   71.1795125,     3, 8,  "UZB X00.XX"},
        {39.764424,   64.503055125,   4, 6,  "UZB Y00.XX"},
        {40.750724,   72.006551125,   3, 6,  "UZB Z00.XX"},
        {41.282595,   68.5548165,     2, 6,  "UZB 123.XXX"},
        {39.166436,   63.731179,      2, 4,  "UZB 12.XXXX"},
        {43.626206,   58.0833785,     2, 3,  "UZB 1234.XX"},
        {42.3626475,  56.857962,      1, 3,  "UZB 1234.XXX"},
        {59.3651,     17.995904,      4, 6,  "SWE 12.XX"},
        {59.531904,   17.6151345,     3, 5,  "SWE 12.XXX"},
        {57.760724,   11.933951125,   3, 4,  "SWE 000.XX"},
        {55.636824,   12.9388365,     3, 4,  "SWE 100.XX"},
        {59.896124,   17.553405375,   3, 5,  "SWE 200.XX"},
        {59.666424,   16.462848,      3, 5,  "SWE 300.XX"},
        {59.316924,   15.129991625,   3, 5,  "SWE 400.XX"},
        {58.444124,   15.557021375,   3, 5,  "SWE 500.XX"},
        {56.081124,   12.680719625,   3, 6,  "SWE 600.XX"},
        {57.820824,   14.130951125,   3, 4,  "SWE 700.XX"},
        {58.638724,   16.108421375,   3, 5,  "SWE 800.XX"},
        {55.747124,   13.127619625,   3, 4,  "SWE 900.XX"},
        {63.867724,   20.156535625,   3, 6,  "SWE B00.XX"},
        {60.710324,   17.06466275,    3, 5,  "SWE C00.XX"},
        {57.763624,   12.876951125,   3, 4,  "SWE D00.XX"},
        {59.403424,   16.411348,      3, 5,  "SWE F00.XX"},
        {59.442824,   13.427548,      3, 5,  "SWE G00.XX"},
        {56.682145,   12.71530875,    3, 4,  "SWE H00.XX"},
        {56.920924,   14.72049875,    3, 4,  "SWE J00.XX"},
        {62.449424,   17.220281375,   3, 5,  "SWE K00.XX"},
        {65.615415,   22.027543125,   3, 6,  "SWE L00.XX"},
        {58.307594,   12.252426875,   3, 5,  "SWE M00.XX"},
        {63.177304,   14.587451875,   3, 5,  "SWE MK0.00"},
        {60.502264,   15.36925525,    3, 5,  "SWE N00.XX"},
        {60.600104,   15.59175575,    3, 5,  "SWE NK0.00"},
        {56.692264,   16.27603825,    3, 4,  "SWE P00.XX"},
        {58.390504,   13.804768375,   3, 5,  "SWE PK0.00"},
        {56.191064,   15.521510875,   3, 4,  "SWE Q00.XX"},
        {56.026304,   14.094297625,   3, 4,  "SWE QK0.00"},
        {58.367164,   11.870448125,   3, 5,  "SWE R00.XX"},
        {58.534704,   14.985068375,   3, 5,  "SWE RK0.00"},
        {63.304564,   18.652473625,   3, 5,  "SWE S00.XX"},
        {55.871804,   12.800097625,   3, 6,  "SWE SK0.00"},
        {59.341964,   14.456044,      3, 5,  "SWE T00.XX"},
        {58.754104,   16.969844625,   3, 5,  "SWE TK0.00"},
        {57.120864,   12.19953825,    3, 4,  "SWE V00.XX"},
        {55.381604,   13.1044485,     3, 4,  "SWE VK0.00"},
        {58.522464,   13.101348125,   3, 5,  "SWE W00.XX"},
        {59.624104,   17.789048,      3, 5,  "SWE WK0.00"},
        {57.942464,   12.482206375,   3, 4,  "SWE X00.XX"},
        {56.246304,   12.823618625,   3, 4,  "SWE XK0.00"},
        {60.632464,   16.70765525,    3, 5,  "SWE Y00.XX"},
        {65.313804,   21.4116365,     3, 6,  "SWE YK0.00"},
        {57.645364,   18.239479,      3, 4,  "SWE Z00.XX"},
        {58.364104,   12.280568375,   3, 5,  "SWE ZK0.00"},
        {55.8266115,  11.3253715,     2, 5,  "SWE 12.XXXX"},
        {57.910165,   14.593116,      3, 4,  "SWE 0123.XX"},
        {57.910165,   15.46806,       2, 3,  "SWE 1123.XX"},
        {57.910165,   16.343003,      2, 3,  "SWE 2123.XX"},
        {57.419125,   14.598267,      3, 4,  "SWE 3123.XX"},
        {57.419125,   15.462795,      2, 3,  "SWE 4123.XX"},
        {57.419125,   16.327323,      2, 3,  "SWE 5123.XX"},
        {56.928085,   14.6085975,     3, 4,  "SWE 6123.XX"},
        {56.928085,   15.4575015,     2, 3,  "SWE 7123.XX"},
        {56.928085,   16.3064055,     2, 3,  "SWE 8123.XX"},
        {56.437045,   14.6137485,     3, 4,  "SWE 9123.XX"},
        {56.437045,   15.4522365,     2, 3,  "SWE B123.XX"},
        {56.437045,   16.2907245,     2, 3,  "SWE C123.XX"},
        {55.946005,   14.6188995,     3, 4,  "SWE D123.XX"},
        {55.946005,   15.4469715,     2, 3,  "SWE F123.XX"},
        {55.946005,   16.2750435,     2, 3,  "SWE G123.XX"},
        {65.220565,   21.282694,      2, 5,  "SWE H123.XX"},
        {65.711605,   21.272392,      2, 5,  "SWE J123.XX"},
        {65.711605,   22.402528,      2, 5,  "SWE K123.XX"},
        {63.561465,   19.6314,        2, 5,  "SWE L123.XX"},
        {62.95178,    14.1424305,     2, 4,  "SWE M123.XX"},
        {63.07018,    18.2833305,     2, 4,  "SWE N123.XX"},
        {57.356765,   18.088467,      2, 3,  "SWE P123.XX"},
        {56.865725,   18.0815065,     2, 3,  "SWE Q123.XX"},
        {57.602285,   18.495628,      3, 4,  "SWE R123.XX"},
        {59.040365,   12.463294,      2, 5,  "SWE S123.XX"},
        {59.163125,   13.364278,      2, 4,  "SWE T123.XX"},
        {58.6748,     13.369429,      2, 4,  "SWE V123.XX"},
        {62.523165,   17.1099245,     2, 4,  "SWE W123.XX"},
        {62.03484,    16.766631,      2, 4,  "SWE X123.XX"},
        {61.5438,     16.6285335,     2, 4,  "SWE Y123.XX"},
        {61.050045,   16.3901535,     2, 4,  "SWE Z123.XX"},
        {61.0039945,  14.430626,      2, 4,  "SWE 123.XXX"},
        {68.835,      17.565,         1, 3,  "SWE MS8.139C"},
        {62.195,      17.565,         2, 4,  "SWE GX5K.69X"},
        {-9.4416255,  147.137638,     4, 7,  "PNG 12.XX"},
        {-9.181125,   147.0184965,    3, 4,  "PNG 12.XXX"},
        {-6.704786,   146.91965125,   3, 4,  "PNG 000.XX"},
        {-5.238186,   145.704921125,  3, 4,  "PNG 200.XX"},
        {-3.540556,   143.560225625,  3, 4,  "PNG 400.XX"},
        {-6.196176,   155.55919425,   3, 5,  "PNG 600.XX"},
        {-6.035976,   145.37499425,   3, 4,  "PNG 700.XX"},
        {-2.665976,   141.25772,      3, 4,  "PNG 800.XX"},
        {-5.524376,   150.10749425,   3, 4,  "PNG 900.XX"},
        {-4.158876,   152.124507125,  3, 4,  "PNG B00.XX"},
        {-5.812076,   144.21749425,   3, 4,  "PNG C00.XX"},
        {-9.020976,   143.1758685,    3, 4,  "PNG D00.XX"},
        {-2.551876,   150.77102,      3, 4,  "PNG F00.XX"},
        {-10.250976,  150.42494275,   3, 6,  "PNG G00.XX"},
        {-6.123376,   143.62309425,   3, 4,  "PNG H00.XX"},
        {-8.710876,   148.2129685,    3, 4,  "PNG J00.XX"},
        {-7.146576,   146.617181375,  3, 4,  "PNG K00.XX"},
        {-6.072776,   141.26009425,   3, 4,  "PNG L00.XX"},
        {-5.979376,   144.92999425,   3, 4,  "PNG M00.XX"},
        {-2.010776,   147.25582,      3, 4,  "PNG N00.XX"},
        {-7.289476,   146.654781375,  3, 4,  "PNG P00.XX"},
        {-6.178076,   155.03899425,   3, 4,  "PNG Q00.XX"},
        {-5.418776,   143.66229425,   3, 4,  "PNG R00.XX"},
        {-8.830576,   147.7057685,    3, 4,  "PNG S00.XX"},
        {-6.226976,   145.81019425,   3, 4,  "PNG T00.XX"},
        {-7.903776,   145.709581375,  3, 4,  "PNG V00.XX"},
        {-6.268876,   155.41699425,   3, 4,  "PNG W00.XX"},
        {-3.119976,   142.31212,      3, 4,  "PNG X00.XX"},
        {-4.311476,   152.229307125,  3, 4,  "PNG Y00.XX"},
        {-5.394376,   154.61349425,   3, 4,  "PNG Z00.XX"},
        {-7.7100595,  146.4548745,    2, 3,  "PNG 123.XXX"},
        {-6.062504,   143.70896,      2, 3,  "PNG 12.XXXX"},
        {-3.807685,   143.40884,      2, 3,  "PNG 0123.XX"},
        {-6.504625,   155.2972,       2, 3,  "PNG 1123.XX"},
        {-2.94079,    141.0666,       2, 3,  "PNG 2123.XX"},
        {-5.796475,   149.9166,       2, 3,  "PNG 3123.XX"},
        {-4.50999,    151.9859,       2, 3,  "PNG 4123.XX"},
        {-9.29579,    142.9878325,    2, 6,  "PNG 5123.XX"},
        {-2.82669,    150.5799,       2, 3,  "PNG 6123.XX"},
        {-10.523075,  150.2371325,    2, 5,  "PNG 7123.XX"},
        {-7.490125,   146.4452,       2, 3,  "PNG 8123.XX"},
        {-6.344875,   141.0692,       2, 3,  "PNG 9123.XX"},
        {-2.285589,   147.0647,       2, 3,  "PNG B123.XX"},
        {-6.450175,   154.8481,       2, 3,  "PNG C123.XX"},
        {-8.175875,   145.5188,       2, 3,  "PNG D123.XX"},
        {-3.39479,    142.121,        2, 3,  "PNG F123.XX"},
        {-5.66919,    154.4226,       2, 3,  "PNG G123.XX"},
        {-5.574111,   141.503557,     1, 2,  "PNG 1234.XXX"},
        {4.083101,    9.686355,       4, 5,  "CMR 12.XX"},
        {4.018485,    9.560165125,    3, 4,  "CMR 00.XXX"},
        {3.966084,    11.336968375,   3, 4,  "CMR C0.XXX"},
        {9.428584,    13.2617355,     3, 5,  "CMR P0.XXX"},
        {12.119324,   14.973529875,   3, 8,  "CMR 000.XX"},
        {6.010724,    10.11829425,    3, 5,  "CMR 100.XX"},
        {10.620835,   14.26422875,    3, 6,  "CMR 200.XX"},
        {5.522824,    10.37569425,    3, 5,  "CMR 300.XX"},
        {10.780724,   13.76064275,    3, 6,  "CMR 400.XX"},
        {7.362624,    13.541981375,   3, 5,  "CMR 500.XX"},
        {4.617724,    13.644207125,   3, 5,  "CMR 600.XX"},
        {4.680725,    9.399208125,    3, 5,  "CMR 700.XX"},
        {5.770724,    10.85909425,    3, 5,  "CMR 800.XX"},
        {4.076326,    9.153929125,    3, 4,  "CMR 900.XX"},
        {4.760725,    9.689208125,    3, 5,  "CMR B00.XX"},
        {5.000725,    9.899208125,    3, 5,  "CMR C00.XX"},
        {10.148724,   14.40894275,    3, 7,  "CMR D00.XX"},
        {3.835524,    10.092507125,   3, 4,  "CMR F00.XX"},
        {5.666224,    10.21289425,    3, 5,  "CMR G00.XX"},
        {6.252424,    10.63739425,    3, 5,  "CMR H00.XX"},
        {6.560724,    14.24909425,    3, 5,  "CMR J00.XX"},
        {5.488624,    10.01669425,    3, 5,  "CMR K00.XX"},
        {9.972324,    13.902855625,   3, 6,  "CMR L00.XX"},
        {5.184024,    10.233007125,   3, 5,  "CMR M00.XX"},
        {5.521564,    10.60301375,    3, 5,  "CMR N00.XX"},
        {3.514104,    11.473873125,   3, 5,  "CMR NK0.00"},
        {2.934064,    11.126985,      3, 4,  "CMR P00.XX"},
        {5.164104,    10.153873125,   3, 5,  "CMR PK0.00"},
        {4.762464,    11.198999375,   3, 5,  "CMR Q00.XX"},
        {4.154105,    9.203874125,    3, 4,  "CMR QK0.00"},
        {10.352764,   15.21067025,    3, 7,  "CMR R00.XX"},
        {6.382504,    10.05240025,    3, 5,  "CMR RK0.00"},
        {5.155364,    10.494199375,   3, 5,  "CMR S00.XX"},
        {11.045104,   14.118738875,   3, 6,  "CMR SK0.00"},
        {6.005364,    10.40821375,    3, 5,  "CMR T00.XX"},
        {2.927204,    11.946045,      3, 5,  "CMR TK0.00"},
        {4.099961,    9.276203375,    3, 4,  "CMR V00.XX"},
        {4.424104,    14.333873125,   3, 5,  "CMR VK0.00"},
        {5.902464,    14.51891375,    3, 6,  "CMR W00.XX"},
        {6.741504,    11.77940025,    3, 5,  "CMR WK0.00"},
        {6.279264,    10.26241375,    3, 5,  "CMR X00.XX"},
        {4.075577,    9.340084125,    3, 4,  "CMR XK0.00"},
        {4.514212,    9.534667375,    3, 5,  "CMR Y00.XX"},
        {2.933832,    9.897851,       3, 4,  "CMR YK0.00"},
        {5.490985,    9.83813275,     3, 5,  "CMR Z00.XX"},
        {3.504104,    15.023873125,   3, 6,  "CMR ZK0.00"},
        {7.110275,    13.374425,      2, 4,  "CMR 01.XXXX"},
        {6.815651,    13.843145,      2, 4,  "CMR 11.XXXX"},
        {6.324611,    14.077505,      2, 4,  "CMR 21.XXXX"},
        {4.365275,    13.476425,      2, 4,  "CMR 31.XXXX"},
        {4.218275,    14.151425,      2, 3,  "CMR 41.XXXX"},
        {5.677775,    14.192025,      2, 4,  "CMR 51.XXXX"},
        {6.538275,    11.601425,      2, 4,  "CMR 61.XXXX"},
        {2.722075,    9.872525,       2, 3,  "CMR 71.XXXX"},
        {2.722075,    10.341244,      2, 3,  "CMR 81.XXXX"},
        {2.722075,    10.809964,      2, 3,  "CMR 91.XXXX"},
        {2.722075,    11.278684,      2, 4,  "CMR B1.XXXX"},
        {2.722075,    11.747404,      2, 4,  "CMR C1.XXXX"},
        {3.213115,    10.575605,      2, 3,  "CMR D1.XXXX"},
        {3.213115,    11.044324,      2, 3,  "CMR F1.XXXX"},
        {3.213115,    11.513044,      2, 4,  "CMR G1.XXXX"},
        {2.231035,    10.622477,      2, 4,  "CMR H1.XXXX"},
        {2.231035,    11.091197,      2, 5,  "CMR J1.XXXX"},
        {3.216675,    14.805325,      2, 5,  "CMR K1.XXXX"},
        {6.258275,    12.411425,      2, 4,  "CMR L1.XXXX"},
        {6.749315,    12.411425,      2, 4,  "CMR M1.XXXX"},
        {6.749315,    12.880144,      2, 4,  "CMR N1.XXXX"},
        {2.948275,    13.411425,      2, 4,  "CMR P1.XXXX"},
        {1.933275,    14.992325,      2, 4,  "CMR Q1.XXXX"},
        {3.506975,    12.120225,      2, 4,  "CMR R1.XXXX"},
        {4.458275,    12.161425,      2, 4,  "CMR S1.XXXX"},
        {8.189375,    13.969925,      2, 5,  "CMR T1.XXXX"},
        {8.189375,    13.501205,      2, 5,  "CMR V1.XXXX"},
        {8.803174,    13.4077475,     2, 4,  "CMR W1.XXXX"},
        {6.258278,    13.177425,      2, 4,  "CMR X1.XXXX"},
        {8.141098,    14.721845,      2, 5,  "CMR Y1.XXXX"},
        {2.528876,    15.090101,      2, 5,  "CMR Z1.XXXX"},
        {6.3805115,   9.0541715,      2, 4,  "CMR 123.XXX"},
        {9.803977,    13.2846035,     2, 4,  "CMR 1234.XX"},
        {12.312382,   8.6242665,      1, 4,  "CMR 1234.XXX"},
        {37.9706,     58.3530075,     4, 8,  "TKM 12.XX"},
        {38.127659,   57.9588225,     3, 7,  "TKM 12.XXX"},
        {39.140724,   63.51779475,    2, 4,  "TKM 000.XX"},
        {39.054235,   63.51779475,    2, 4,  "TKM 100.XX"},
        {41.890724,   59.90576,       3, 6,  "TKM 200.XX"},
        {37.637324,   61.7886245,     3, 6,  "TKM 300.XX"},
        {39.550724,   54.307455125,   2, 3,  "TKM 400.XX"},
        {40.069424,   52.906403625,   2, 3,  "TKM 500.XX"},
        {37.660724,   62.1089245,     3, 6,  "TKM 600.XX"},
        {37.420724,   60.4489245,     3, 5,  "TKM 700.XX"},
        {39.020724,   56.21779475,    3, 5,  "TKM 800.XX"},
        {42.180724,   59.6153085,     3, 8,  "TKM 900.XX"},
        {37.850724,   65.998585875,   2, 5,  "TKM B00.XX"},
        {37.878224,   65.169985875,   2, 5,  "TKM C00.XX"},
        {37.337824,   62.3053245,     3, 6,  "TKM D00.XX"},
        {41.916224,   59.57566,       3, 6,  "TKM F00.XX"},
        {42.370724,   59.0853085,     3, 6,  "TKM G00.XX"},
        {42.091924,   59.3334085,     3, 6,  "TKM H00.XX"},
        {39.244224,   54.53919475,    3, 4,  "TKM J00.XX"},
        {38.460224,   57.394333375,   3, 5,  "TKM K00.XX"},
        {41.223724,   61.3360125,     3, 6,  "TKM L00.XX"},
        {41.253995,   61.2216545,     3, 6,  "TKM M00.XX"},
        {39.296324,   55.46499475,    3, 4,  "TKM N00.XX"},
        {37.386524,   59.5715245,     3, 7,  "TKM P00.XX"},
        {38.480724,   56.228133375,   3, 5,  "TKM Q00.XX"},
        {38.827124,   63.833633375,   2, 5,  "TKM R00.XX"},
        {36.570024,   61.17970275,    3, 7,  "TKM S00.XX"},
        {41.664564,   59.87358,       3, 6,  "TKM T00.XX"},
        {38.075404,   64.833369875,   2, 5,  "TKM TK0.00"},
        {42.079264,   59.9070365,     3, 8,  "TKM V00.XX"},
        {39.626704,   54.209546125,   2, 3,  "TKM VK0.00"},
        {40.787564,   55.342681375,   2, 5,  "TKM W00.XX"},
        {37.654104,   61.6272865,     3, 6,  "TKM WK0.00"},
        {37.425064,   62.3032845,     3, 6,  "TKM X00.XX"},
        {39.164104,   63.56656275,    2, 5,  "TKM XK0.00"},
        {38.742264,   56.763884125,   3, 5,  "TKM Y00.XX"},
        {35.955355,   62.904156625,   2, 4,  "TKM YK0.00"},
        {41.552564,   52.55338,       2, 5,  "TKM Z00.XX"},
        {36.869404,   60.375004125,   3, 7,  "TKM ZK0.00"},
        {38.567072,   54.6513795,     2, 3,  "TKM 123.XXX"},
        {38.2469155,  59.548801,      2, 6,  "TKM 12.XXXX"},
        {40.467802,   58.2166525,     2, 4,  "TKM 1234.XX"},
        {42.266989,   52.9448685,     1, 5,  "TKM 1234.XXX"},
        {40.431024,   -3.749967625,   4, 5,  "ESP 00.XX"},
        {41.371604,   2.1323965,      4, 6,  "ESP J0.XX"},
        {40.592663,   -3.9166465,     3, 4,  "ESP 12.XXX"},
        {39.519924,   -0.427444875,   4, 5,  "ESP 000.XX"},
        {41.433824,   2.0190125,      4, 6,  "ESP 100.XX"},
        {41.477524,   2.1510125,      4, 6,  "ESP 200.XX"},
        {41.347324,   1.9733125,      4, 6,  "ESP 300.XX"},
        {41.367224,   2.0876125,      5, 7,  "ESP 400.XX"},
        {37.433224,   -6.0201755,     4, 5,  "ESP 500.XX"},
        {41.690724,   -0.94424,       4, 6,  "ESP 600.XX"},
        {36.756424,   -4.49159725,    4, 5,  "ESP 700.XX"},
        {38.018924,   -1.177814125,   4, 5,  "ESP 800.XX"},
        {43.291334,   -3.0092925,     4, 6,  "ESP 900.XX"},
        {41.689924,   -4.79594,       4, 6,  "ESP B00.XX"},
        {38.404224,   -0.535066625,   4, 5,  "ESP C00.XX"},
        {37.926624,   -4.817314125,   4, 5,  "ESP D00.XX"},
        {42.269524,   -8.7695915,     4, 5,  "ESP F00.XX"},
        {43.571024,   -5.7295955,     4, 5,  "ESP G00.XX"},
        {37.212624,   -3.653736875,   4, 5,  "ESP H00.XX"},
        {43.381624,   -8.4655955,     4, 5,  "ESP J00.XX"},
        {42.899924,   -2.751844,      4, 6,  "ESP K00.XX"},
        {38.311924,   -0.723914125,   4, 5,  "ESP L00.XX"},
        {43.430224,   -5.8868955,     4, 5,  "ESP M00.XX"},
        {37.629064,   -1.0209155,     4, 5,  "ESP N00.XX"},
        {42.806604,   -1.685419,      4, 6,  "ESP NK0.00"},
        {41.558064,   2.06358,        4, 6,  "ESP P00.XX"},
        {36.678604,   -6.15667925,    4, 5,  "ESP PK0.00"},
        {41.571264,   1.97208,        4, 6,  "ESP Q00.XX"},
        {39.574204,   2.620146125,    4, 5,  "ESP QK0.00"},
        {28.124264,   -15.480850375,  4, 5,  "ESP R00.XX"},
        {28.450304,   -16.307400875,  3, 4,  "ESP RK0.00"},
        {43.314845,   -2.0221275,     4, 6,  "ESP S00.XX"},
        {43.469095,   -3.8611735,     4, 6,  "ESP SK0.00"},
        {42.362464,   -3.7315635,     4, 6,  "ESP T00.XX"},
        {36.833104,   -2.473095875,   4, 7,  "ESP TK0.00"},
        {39.982664,   -0.100175125,   4, 5,  "ESP V00.XX"},
        {40.950904,   -5.6921505,     4, 5,  "ESP VK0.00"},
        {39.013364,   -1.91377375,    4, 5,  "ESP W00.XX"},
        {37.251104,   -6.9691135,     4, 7,  "ESP WK0.00"},
        {42.457364,   -2.4817635,     4, 6,  "ESP X00.XX"},
        {36.568995,   -4.66081875,    4, 5,  "ESP XK0.00"},
        {38.883964,   -7.00877375,    4, 8,  "ESP Y00.XX"},
        {36.616156,   -4.53908475,    4, 5,  "ESP YK0.00"},
        {42.605464,   -5.623307,      4, 5,  "ESP Z00.XX"},
        {37.768704,   -3.8205135,     4, 5,  "ESP ZK0.00"},
        {39.08693,    -2.8400495,     3, 4,  "ESP 12.XXXX"},
        {43.46886,    -9.179519,      3, 4,  "ESP 1234.XX"},
        {40.104075,   -3.995255,      3, 4,  "ESP 012.XXX"},
        {41.698415,   1.9397215,      3, 5,  "ESP 112.XXX"},
        {39.697415,   -0.7252085,     3, 4,  "ESP 212.XXX"},
        {37.536315,   -6.20906,       3, 4,  "ESP 312.XXX"},
        {41.850115,   -1.1605785,     3, 5,  "ESP 412.XXX"},
        {36.906715,   -4.9167385,     3, 4,  "ESP 512.XXX"},
        {36.765965,   -4.3210825,     3, 4,  "ESP 612.XXX"},
        {43.413215,   -3.180035,      3, 5,  "ESP 712.XXX"},
        {41.849315,   -5.0122785,     4, 6,  "ESP 812.XXX"},
        {38.086015,   -5.0225735,     3, 4,  "ESP 912.XXX"},
        {37.372015,   -3.86256,       3, 4,  "ESP B12.XXX"},
        {42.864715,   -2.8437135,     3, 5,  "ESP C12.XXX"},
        {42.914015,   -1.818435,      4, 6,  "ESP D12.XXX"},
        {36.811415,   -6.4114385,     3, 4,  "ESP F12.XXX"},
        {39.791615,   2.37137,        3, 4,  "ESP G12.XXX"},
        {28.153015,   -15.8142635,    3, 4,  "ESP H12.XXX"},
        {28.428515,   -16.8514635,    3, 4,  "ESP J12.XXX"},
        {36.432715,   -5.703025,      3, 4,  "ESP K12.XXX"},
        {43.355715,   -2.271335,      3, 5,  "ESP L12.XXX"},
        {43.475815,   -4.0730485,     3, 5,  "ESP M12.XXX"},
        {42.550115,   -3.9652135,     3, 5,  "ESP N12.XXX"},
        {40.170115,   -0.31883,       3, 4,  "ESP P12.XXX"},
        {41.170115,   -5.943465,      3, 4,  "ESP Q12.XXX"},
        {37.552115,   -7.32666,       3, 7,  "ESP R12.XXX"},
        {38.990315,   -7.098095,      3, 7,  "ESP S12.XXX"},
        {37.970115,   -4.0566735,     3, 4,  "ESP T12.XXX"},
        {41.425815,   0.8925215,      5, 7,  "ESP V12.XXX"},
        {41.820115,   0.3594215,      4, 6,  "ESP W12.XXX"},
        {39.670115,   -6.6413085,     3, 6,  "ESP X12.XXX"},
        {42.095115,   2.656,          3, 5,  "ESP Y12.XXX"},
        {40.828755,   0.31218,        3, 4,  "ESP Z12.XXX"},
        {42.8278275,  0.480351,       3, 5,  "ESP 0123.XXX"},
        {43.7767405,  -9.588373,      2, 3,  "ESP 1123.XXX"},
        {41.1118665,  -9.7101685,     2, 5,  "ESP 2123.XXX"},
        {38.383835,   -9.8572315,     2, 5,  "ESP 3123.XXX"},
        {43.7767405,  -6.043244,      3, 4,  "ESP 4123.XXX"},
        {41.1118665,  -6.3139945,     2, 3,  "ESP 5123.XXX"},
        {38.383835,   -6.5802355,     2, 3,  "ESP 6123.XXX"},
        {43.2782255,  -2.506689,      2, 4,  "ESP 7123.XXX"},
        {41.1118665,  -2.9178505,     2, 3,  "ESP 8123.XXX"},
        {38.432771,   -3.306867,      2, 3,  "ESP 9123.XXX"},
        {40.4412995,  1.161881,       3, 4,  "ESP M123.XXX"},
        {27.8726495,  -18.1896905,    2, 3,  "ESP T123.XXX"},
        {27.675424,   -15.938861,     2, 3,  "ESP G123.XXX"},
        {35.2980705,  -2.96657,       2, 8,  "ESP Z123.XXX"},
        {35.2925,     -2.90025,       2, 8,  "ESP SJP6.KZXV"},
        {13.765145,   100.4912955,    4, 6,  "THA 12.XX"},
        {13.948515,   100.29709,      3, 6,  "THA 12.XXX"},
        {17.390514,   102.726005125,  2, 5,  "THA 000.XX"},
        {13.340014,   100.92099325,   3, 5,  "THA 200.XX"},
        {14.952714,   102.0311535,    3, 5,  "THA 400.XX"},
        {18.854245,   98.942036875,   3, 5,  "THA 600.XX"},
        {7.040724,    100.428981375,  3, 5,  "THA 800.XX"},
        {13.222425,   100.90673125,   3, 5,  "THA 900.XX"},
        {18.326924,   99.43888625,    3, 5,  "THA B00.XX"},
        {16.475824,   102.789625875,  2, 5,  "THA C00.XX"},
        {9.172224,    99.2884685,     3, 4,  "THA D00.XX"},
        {8.465424,    99.909081375,   3, 4,  "THA F00.XX"},
        {15.303324,   104.820351625,  2, 5,  "THA G00.XX"},
        {13.860724,   100.01819025,   3, 5,  "THA H00.XX"},
        {12.731924,   101.236703125,  3, 4,  "THA J00.XX"},
        {14.125424,   100.57969025,   3, 6,  "THA K00.XX"},
        {16.863624,   100.227512,     2, 5,  "THA L00.XX"},
        {15.746624,   100.070151625,  2, 4,  "THA M00.XX"},
        {12.650724,   102.071516,     3, 4,  "THA N00.XX"},
        {12.958524,   100.857603125,  3, 5,  "THA P00.XX"},
        {13.580724,   99.77819025,    3, 5,  "THA Q00.XX"},
        {6.590224,    101.24279425,   2, 4,  "THA R00.XX"},
        {7.215545,    100.571930875,  3, 5,  "THA S00.XX"},
        {7.920724,    98.338981375,   3, 4,  "THA T00.XX"},
        {14.400724,   100.528077375,  3, 6,  "THA V00.XX"},
        {19.950724,   99.78683475,    3, 5,  "THA W00.XX"},
        {14.572124,   100.875077375,  3, 6,  "THA X00.XX"},
        {13.578124,   100.18789025,   3, 5,  "THA Y00.XX"},
        {14.064324,   99.48899025,    2, 4,  "THA Z00.XX"},
        {14.9889835,  99.7695055,     2, 4,  "THA 123.XXX"},
        {9.08253,     98.3621305,     2, 3,  "THA 12.XXXX"},
        {17.7689965,  98.7548035,     2, 4,  "THA 1234.XX"},
        {11.6794195,  97.760861,      1, 3,  "THA 1234.XXX"},
        {15.3901,     44.1683275,     4, 5,  "YEM 12.XX"},
        {15.422294,   44.0298515,     3, 4,  "YEM 00.XXX"},
        {12.920414,   44.799460875,   3, 5,  "YEM J0.XXX"},
        {14.836124,   42.9259645,     3, 5,  "YEM 000.XX"},
        {13.629324,   43.95819025,    3, 5,  "YEM 100.XX"},
        {13.629324,   44.04708125,    3, 5,  "YEM 200.XX"},
        {14.593424,   49.092777375,   2, 3,  "YEM 300.XX"},
        {14.628019,   49.170321375,   2, 3,  "YEM 400.XX"},
        {13.999124,   44.11679025,    3, 5,  "YEM 500.XX"},
        {15.153924,   44.2945645,     4, 5,  "YEM 600.XX"},
        {14.245824,   43.307577375,   3, 5,  "YEM 700.XX"},
        {15.088324,   43.2326645,     4, 5,  "YEM 800.XX"},
        {14.577124,   44.370077375,   3, 5,  "YEM 900.XX"},
        {14.827424,   49.5667645,     2, 3,  "YEM B00.XX"},
        {14.470724,   44.798077375,   3, 5,  "YEM C00.XX"},
        {13.833024,   44.09659025,    3, 5,  "YEM D00.XX"},
        {14.877724,   43.1243645,     3, 5,  "YEM F00.XX"},
        {15.700924,   43.896951625,   3, 4,  "YEM G00.XX"},
        {14.333824,   44.358377375,   3, 5,  "YEM H00.XX"},
        {14.033624,   45.53329025,    3, 5,  "YEM J00.XX"},
        {15.987924,   48.74963875,    2, 3,  "YEM K00.XX"},
        {13.258424,   44.07929025,    3, 5,  "YEM L00.XX"},
        {13.903524,   44.64049025,    3, 5,  "YEM M00.XX"},
        {14.385924,   47.021577375,   3, 5,  "YEM N00.XX"},
        {15.269624,   51.2025645,     2, 3,  "YEM P00.XX"},
        {13.427624,   45.65949025,    3, 5,  "YEM Q00.XX"},
        {13.250224,   45.26699025,    3, 5,  "YEM R00.XX"},
        {15.708764,   43.571868875,   3, 4,  "YEM S00.XX"},
        {14.513004,   43.297749375,   3, 5,  "YEM SK0.00"},
        {15.717464,   42.685468875,   3, 4,  "YEM T00.XX"},
        {15.324104,   42.983004625,   3, 4,  "YEM TK0.00"},
        {15.482864,   45.286068875,   3, 4,  "YEM V00.XX"},
        {13.882504,   45.83802125,    3, 5,  "YEM VK0.00"},
        {13.329164,   43.22982675,    3, 5,  "YEM W00.XX"},
        {13.104004,   45.342094125,   3, 5,  "YEM WK0.00"},
        {14.541164,   46.805641125,   3, 5,  "YEM X00.XX"},
        {16.172404,   44.75153175,    3, 4,  "YEM XK0.00"},
        {16.957264,   43.723311,      3, 4,  "YEM Y00.XX"},
        {16.191504,   52.16053175,    2, 3,  "YEM YK0.00"},
        {13.952164,   45.65972675,    3, 5,  "YEM Z00.XX"},
        {13.710404,   44.71122125,    3, 5,  "YEM ZK0.00"},
        {15.1934785,  42.9594665,     3, 4,  "YEM 123.XXX"},
        {17.307248,   42.8364295,     2, 5,  "YEM 12.XXXX"},
        {15.71187,    45.695898,      2, 3,  "YEM 1234.XX"},
        {18.512779,   42.2687485,     1, 4,  "YEM 1234.XXX"},
        {48.8951,     2.282744,       4, 5,  "FRA 12.XX"},
        {49.060115,   2.0297415,      3, 4,  "FRA 12.XXX"},
        {45.808324,   4.762301875,    3, 4,  "FRA 000.XX"},
        {45.808324,   4.833756875,    3, 4,  "FRA 100.XX"},
        {45.808324,   4.905211875,    3, 4,  "FRA 200.XX"},
        {43.652744,   1.355352,       3, 4,  "FRA 300.XX"},
        {43.652744,   1.439547,       3, 4,  "FRA 400.XX"},
        {43.751724,   7.222852,       3, 6,  "FRA 500.XX"},
        {43.350724,   5.3499045,      3, 4,  "FRA 600.XX"},
        {47.254424,   -1.613524375,   3, 4,  "FRA 700.XX"},
        {48.620124,   7.6847805,      3, 5,  "FRA 800.XX"},
        {43.650724,   3.813952,       3, 4,  "FRA 900.XX"},
        {44.878724,   -0.648264875,   3, 4,  "FRA B00.XX"},
        {48.150724,   -1.723354125,   3, 4,  "FRA C00.XX"},
        {49.550224,   0.069724,       3, 5,  "FRA D00.XX"},
        {49.291624,   3.96360225,     3, 4,  "FRA F00.XX"},
        {50.680724,   3.0062685,      3, 4,  "FRA G00.XX"},
        {45.478924,   4.33277075,     2, 3,  "FRA H00.XX"},
        {43.153224,   5.8557045,      3, 4,  "FRA J00.XX"},
        {47.510724,   -0.60568975,    3, 4,  "FRA K00.XX"},
        {45.219524,   5.67147075,     3, 4,  "FRA L00.XX"},
        {48.443624,   -4.5521195,     2, 3,  "FRA M00.XX"},
        {48.043524,   0.151545875,    3, 4,  "FRA N00.XX"},
        {47.369224,   4.98361025,     3, 4,  "FRA P00.XX"},
        {43.549564,   5.3945495,      3, 4,  "FRA Q00.XX"},
        {45.769704,   3.053627375,    3, 4,  "FRA QK0.00"},
        {43.845464,   4.317106,       3, 4,  "FRA R00.XX"},
        {49.885104,   2.26221475,     3, 4,  "FRA RK0.00"},
        {47.392464,   0.64448675,     3, 4,  "FRA S00.XX"},
        {45.823904,   1.222827375,    3, 4,  "FRA SK0.00"},
        {49.131264,   6.13721275,     3, 5,  "FRA T00.XX"},
        {47.240804,   5.97804125,     3, 6,  "FRA TK0.00"},
        {49.193564,   -0.40888725,    3, 5,  "FRA V00.XX"},
        {47.896804,   1.866779875,    3, 4,  "FRA VK0.00"},
        {47.772464,   7.294057625,    3, 7,  "FRA W00.XX"},
        {42.694104,   2.854681,       3, 6,  "FRA WK0.00"},
        {49.452464,   1.032597,       3, 5,  "FRA X00.XX"},
        {48.679004,   6.1366175,      3, 5,  "FRA XK0.00"},
        {50.722064,   3.1247665,      3, 6,  "FRA Y00.XX"},
        {43.302304,   -0.4110085,     3, 6,  "FRA YK0.00"},
        {46.592464,   0.295345,       3, 4,  "FRA Z00.XX"},
        {43.945304,   4.772202,       3, 4,  "FRA ZK0.00"},
        {43.179575,   5.0628515,      2, 3,  "FRA 01.XXXX"},
        {45.407375,   4.3711815,      3, 4,  "FRA 11.XXXX"},
        {43.600775,   1.09723,        2, 3,  "FRA 21.XXXX"},
        {43.363775,   6.7246515,      2, 3,  "FRA 31.XXXX"},
        {46.990175,   -1.8934885,     2, 3,  "FRA 41.XXXX"},
        {48.487975,   7.4524415,      2, 4,  "FRA 51.XXXX"},
        {43.298275,   3.4952515,      2, 3,  "FRA 61.XXXX"},
        {44.623275,   -0.907005,      2, 3,  "FRA 71.XXXX"},
        {47.898275,   -1.9659235,     2, 3,  "FRA 81.XXXX"},
        {49.133575,   -0.42998,       2, 4,  "FRA 91.XXXX"},
        {50.288275,   2.6730715,      2, 3,  "FRA B1.XXXX"},
        {43.005975,   5.685465,       2, 3,  "FRA C1.XXXX"},
        {47.058275,   -1.0111885,     2, 3,  "FRA D1.XXXX"},
        {45.153275,   5.5208815,      2, 3,  "FRA F1.XXXX"},
        {47.984775,   -4.6036235,     2, 3,  "FRA G1.XXXX"},
        {47.770975,   -0.3008235,     2, 3,  "FRA H1.XXXX"},
        {47.116775,   4.7451115,      2, 3,  "FRA J1.XXXX"},
        {45.563875,   2.8017815,      2, 3,  "FRA K1.XXXX"},
        {43.608875,   4.29653,        2, 3,  "FRA L1.XXXX"},
        {47.065375,   0.3840115,      2, 3,  "FRA M1.XXXX"},
        {45.618075,   0.9709815,      2, 3,  "FRA N1.XXXX"},
        {48.657675,   5.8738415,      2, 4,  "FRA P1.XXXX"},
        {47.034975,   5.7180115,      2, 3,  "FRA Q1.XXXX"},
        {47.653275,   6.79919,        2, 6,  "FRA R1.XXXX"},
        {42.487475,   2.5932865,      2, 5,  "FRA S1.XXXX"},
        {43.062375,   -0.4348485,     2, 5,  "FRA T1.XXXX"},
        {46.483275,   0.138825,       2, 3,  "FRA V1.XXXX"},
        {45.958275,   -1.47664,       2, 3,  "FRA W1.XXXX"},
        {50.646175,   1.9437365,      3, 4,  "FRA X1.XXXX"},
        {43.058275,   2.7751515,      2, 3,  "FRA Y1.XXXX"},
        {47.258275,   -2.79591,       2, 3,  "FRA Z1.XXXX"},
        {46.845865,   2.0578135,      2, 3,  "FRA 0123.XX"},
        {44.765865,   4.640487,       2, 3,  "FRA 1123.XX"},
        {47.50858,    -3.709966,      2, 3,  "FRA 2123.XX"},
        {46.08858,    -0.799664,      2, 3,  "FRA 3123.XX"},
        {49.515865,   4.374581,       2, 3,  "FRA 4123.XX"},
        {48.247165,   -2.4111885,     2, 3,  "FRA 5123.XX"},
        {47.83858,    -1.1173375,     2, 3,  "FRA 6123.XX"},
        {46.435865,   -1.774815,      2, 3,  "FRA 7123.XX"},
        {45.67858,    5.790336,       2, 3,  "FRA 8123.XX"},
        {46.555865,   4.505185,       2, 3,  "FRA 9123.XX"},
        {46.575865,   1.365185,       2, 3,  "FRA B123.XX"},
        {44.925865,   1.185487,       2, 3,  "FRA C123.XX"},
        {41.695865,   8.42094,        2, 3,  "FRA D123.XX"},
        {43.535865,   1.870638,       2, 3,  "FRA F123.XX"},
        {48.575865,   4.3124115,      2, 3,  "FRA G123.XX"},
        {50.511165,   1.5328585,      2, 4,  "FRA H123.XX"},
        {42.985865,   2.025789,       2, 3,  "FRA J123.XX"},
        {48.285865,   -3.1124885,     2, 3,  "FRA K123.XX"},
        {45.42858,    -0.1718845,     2, 3,  "FRA L123.XX"},
        {42.475865,   8.9732805,      2, 3,  "FRA M123.XX"},
        {49.09608,    5.806932,       2, 3,  "FRA N123.XX"},
        {45.91858,    4.635436,       2, 3,  "FRA P123.XX"},
        {50.08148,    3.0825095,      3, 4,  "FRA Q123.XX"},
        {43.255865,   -1.8265825,     2, 6,  "FRA R123.XX"},
        {43.895865,   3.760638,       2, 3,  "FRA S123.XX"},
        {43.330565,   4.7047175,      2, 3,  "FRA T123.XX"},
        {46.10858,    2.250336,       2, 3,  "FRA V123.XX"},
        {46.765865,   2.8178135,      2, 3,  "FRA W123.XX"},
        {45.81858,    3.740336,       2, 3,  "FRA X123.XX"},
        {44.335865,   5.7632665,      2, 3,  "FRA Y123.XX"},
        {47.94858,    6.1026625,      2, 4,  "FRA Z123.XX"},
        {50.1040275,  0.5055915,      2, 4,  "FRA 123.XXX"},
        {46.205,      2.2,            1, 2,  "FRA HLHL.WDH"},
        {60.418607,   19.524964,      2, 6,  "ALA 12.XXX"},
        {60.056465,   20.4051015,     2, 6,  "ALA 123.XX"},
        {60.1737915,  20.29,          2, 6,  "ALA L4N6.Q46"},
        {-1.233277,   36.803732,      4, 6,  "KEN 12.XX"},
        {-1.055194,   36.72003,       3, 5,  "KEN 12.XXX"},
        {-3.966376,   39.561107125,   3, 5,  "KEN 000.XX"},
        {-3.994917,   39.647836125,   3, 5,  "KEN 100.XX"},
        {-0.252276,   36.00772,       3, 4,  "KEN 200.XX"},
        {-0.252276,   36.094209,      3, 4,  "KEN 300.XX"},
        {-0.049276,   34.70072,       3, 5,  "KEN 400.XX"},
        {-0.049276,   34.787209,      3, 5,  "KEN 500.XX"},
        {1.051224,    34.95972,       3, 5,  "KEN 600.XX"},
        {0.331824,    34.71952,       3, 5,  "KEN 700.XX"},
        {-3.179676,   40.053607125,   3, 5,  "KEN 800.XX"},
        {-0.383476,   36.93282,       3, 4,  "KEN 900.XX"},
        {-0.444336,   39.616085,      3, 4,  "KEN B00.XX"},
        {0.561204,    34.517145,      3, 5,  "KEN BK0.00"},
        {0.071164,    37.607985,      3, 4,  "KEN C00.XX"},
        {0.332004,    34.464045,      3, 5,  "KEN CK0.00"},
        {-0.720636,   36.415385,      3, 4,  "KEN D00.XX"},
        {1.743004,    40.034645,      3, 4,  "KEN DK0.00"},
        {-0.527836,   34.424585,      3, 5,  "KEN F00.XX"},
        {-1.075896,   34.443945,      3, 6,  "KEN FK0.00"},
        {0.024064,    37.031785,      3, 4,  "KEN G00.XX"},
        {-0.543296,   37.430045,      3, 4,  "KEN GK0.00"},
        {0.476464,    34.070385,      3, 6,  "KEN H00.XX"},
        {3.934604,    41.837973125,   3, 8,  "KEN HK0.00"},
        {-3.603336,   39.817299375,   3, 5,  "KEN J00.XX"},
        {-0.367096,   35.258345,      3, 4,  "KEN JK0.00"},
        {-1.501736,   37.227385,      3, 5,  "KEN K00.XX"},
        {0.353204,    37.556845,      3, 4,  "KEN KK0.00"},
        {-0.659136,   34.741485,      3, 5,  "KEN L00.XX"},
        {0.027904,    36.341345,      3, 4,  "KEN LK0.00"},
        {-1.077036,   35.835185,      3, 5,  "KEN M00.XX"},
        {-0.258096,   35.704245,      3, 4,  "KEN MK0.00"},
        {-0.713836,   37.126485,      3, 4,  "KEN N00.XX"},
        {0.603604,    34.737345,      3, 5,  "KEN NK0.00"},
        {0.216164,    35.079185,      3, 4,  "KEN P00.XX"},
        {-2.280196,   40.863745,      3, 4,  "KEN PK0.00"},
        {3.137864,    35.566285,      3, 4,  "KEN Q00.XX"},
        {-3.393396,   38.541873125,   3, 6,  "KEN QK0.00"},
        {1.102564,    36.660285,      3, 4,  "KEN R00.XX"},
        {-1.119896,   37.705645,      3, 5,  "KEN RK0.00"},
        {2.391264,    35.619985,      3, 4,  "KEN S00.XX"},
        {-0.275896,   36.353945,      3, 4,  "KEN SK0.00"},
        {-0.482336,   37.227485,      3, 4,  "KEN T00.XX"},
        {3.523604,    39.026473125,   3, 5,  "KEN TK0.00"},
        {2.353464,    37.960185,      3, 4,  "KEN V00.XX"},
        {-0.850396,   34.560045,      3, 5,  "KEN VK0.00"},
        {0.088864,    34.244785,      3, 6,  "KEN W00.XX"},
        {-0.158696,   35.168145,      3, 4,  "KEN WK0.00"},
        {-1.365036,   37.977885,      3, 5,  "KEN X00.XX"},
        {1.243204,    35.068645,      3, 4,  "KEN XK0.00"},
        {-1.171536,   34.599785,      3, 6,  "KEN Y00.XX"},
        {-1.891996,   36.257245,      3, 5,  "KEN YK0.00"},
        {-3.378636,   37.647199375,   3, 6,  "KEN Z00.XX"},
        {-4.104196,   39.619273125,   3, 5,  "KEN ZK0.00"},
        {1.2798415,   34.0066715,     2, 5,  "KEN 123.XXX"},
        {0.551551,    36.753365,      2, 3,  "KEN 12.XXXX"},
        {-4.220335,   39.403905,      3, 5,  "KEN 1123.XX"},
        {-3.642435,   39.675105,      2, 4,  "KEN 2123.XX"},
        {-0.690935,   39.415205,      2, 3,  "KEN 3123.XX"},
        {1.522165,    39.771905,      2, 3,  "KEN 4123.XX"},
        {3.515965,    41.460605,      2, 5,  "KEN 5123.XX"},
        {-2.508435,   40.658005,      2, 3,  "KEN 6123.XX"},
        {2.891265,    35.365405,      2, 3,  "KEN 7123.XX"},
        {-3.621635,   38.336205,      2, 5,  "KEN 8123.XX"},
        {0.810964,    36.578605,      3, 4,  "KEN 9123.XX"},
        {2.135065,    35.371005,      2, 3,  "KEN B123.XX"},
        {3.102265,    38.821305,      2, 3,  "KEN C123.XX"},
        {2.106865,    37.759305,      2, 3,  "KEN D123.XX"},
        {-1.961135,   36.128205,      2, 4,  "KEN F123.XX"},
        {-3.636335,   37.572105,      2, 5,  "KEN G123.XX"},
        {-4.679435,   39.157505,      2, 5,  "KEN H123.XX"},
        {4.371919,    34.194859,      1, 5,  "KEN 1234.XXX"},
        {-24.6149,    25.868742,      4, 7,  "BWA 12.XX"},
        {-24.474437,  25.657365,      3, 6,  "BWA 12.XXX"},
        {-21.194986,  27.45687725,    3, 5,  "BWA 000.XX"},
        {-24.346856,  25.45024625,    3, 6,  "BWA 200.XX"},
        {-21.992886,  27.780207375,   3, 5,  "BWA 400.XX"},
        {-20.012486,  23.370785875,   3, 5,  "BWA 600.XX"},
        {-22.417186,  26.6381375,     3, 7,  "BWA 800.XX"},
        {-24.943376,  25.2890525,     3, 6,  "BWA B00.XX"},
        {-23.064476,  26.78323075,    3, 6,  "BWA C00.XX"},
        {-24.350276,  26.09547825,    3, 6,  "BWA D00.XX"},
        {-25.173876,  25.64492675,    3, 6,  "BWA F00.XX"},
        {-22.501776,  27.0828565,     3, 6,  "BWA G00.XX"},
        {-24.638476,  25.49467825,    3, 6,  "BWA H00.XX"},
        {-24.739076,  25.3735525,     3, 6,  "BWA J00.XX"},
        {-21.388176,  27.41928225,    3, 5,  "BWA K00.XX"},
        {-21.379276,  25.54638225,    3, 5,  "BWA L00.XX"},
        {-20.468476,  26.998208,      3, 5,  "BWA M00.XX"},
        {-21.929276,  28.376269375,   3, 5,  "BWA N00.XX"},
        {-21.833076,  27.708869375,   3, 5,  "BWA P00.XX"},
        {-21.659276,  21.596269375,   3, 5,  "BWA Q00.XX"},
        {-21.273476,  25.33428225,    3, 5,  "BWA R00.XX"},
        {-17.768576,  25.131099125,   3, 6,  "BWA S00.XX"},
        {-23.002876,  26.46323075,    3, 6,  "BWA T00.XX"},
        {-25.985376,  22.360113875,   3, 7,  "BWA V00.XX"},
        {-24.561876,  24.68607825,    3, 7,  "BWA W00.XX"},
        {-19.337176,  22.1244605,     3, 5,  "BWA X00.XX"},
        {-24.060576,  24.986091125,   3, 7,  "BWA Y00.XX"},
        {-20.088976,  27.168421875,   3, 5,  "BWA Z00.XX"},
        {-20.469039,  25.3658645,     2, 4,  "BWA 12.XXXX"},
        {-20.22832,   23.1827315,     2, 4,  "BWA 0123.XX"},
        {-22.20142,   28.172752,      2, 6,  "BWA 1123.XX"},
        {-21.93142,   21.392752,      2, 4,  "BWA 2123.XX"},
        {-18.245655,  24.936103,      2, 4,  "BWA 3123.XX"},
        {-26.26172,   22.1540295,     2, 6,  "BWA 4123.XX"},
        {-19.612035,  21.9279315,     2, 4,  "BWA 5123.XX"},
        {-20.40312,   26.7900315,     3, 5,  "BWA 6123.XX"},
        {-18.41312,   24.261303,      2, 4,  "BWA 7123.XX"},
        {-18.75762,   21.716203,      2, 4,  "BWA 8123.XX"},
        {-20.70122,   22.4665315,     2, 4,  "BWA 9123.XX"},
        {-23.91302,   22.5506805,     2, 6,  "BWA B123.XX"},
        {-24.78452,   23.544201,      2, 6,  "BWA C123.XX"},
        {-24.229635,  21.520401,      2, 6,  "BWA D123.XX"},
        {-22.9418595, 24.146618,      2, 6,  "BWA 123.XXX"},
        {-18.4012975, 20.3195795,     1, 3,  "BWA 1234.XXX"},
        {-18.886001,  47.5178725,     5, 6,  "MDG 12.XX"},
        {-18.720985,  47.290999,      4, 5,  "MDG 12.XXX"},
        {-18.082376,  49.34368625,    4, 5,  "MDG 000.XX"},
        {-18.168865,  49.32552325,    4, 5,  "MDG 100.XX"},
        {-19.824076,  47.00983475,    4, 5,  "MDG 200.XX"},
        {-21.403776,  47.05498225,    4, 5,  "MDG 300.XX"},
        {-23.316876,  43.642017875,   4, 5,  "MDG 400.XX"},
        {-13.337676,  48.19539025,    4, 5,  "MDG 500.XX"},
        {-15.661076,  46.287351625,   4, 5,  "MDG 600.XX"},
        {-12.284736,  49.258898,      4, 5,  "MDG 700.XX"},
        {-19.674196,  47.30755275,    4, 5,  "MDG 7K0.00"},
        {-25.164036,  46.0518935,     4, 5,  "MDG 800.XX"},
        {-17.592896,  48.190215125,   4, 5,  "MDG 8K0.00"},
        {-25.013036,  46.9365935,     4, 5,  "MDG 900.XX"},
        {-17.831496,  48.391615125,   4, 5,  "MDG 9K0.00"},
        {-19.157636,  46.7058675,     4, 5,  "MDG B00.XX"},
        {-16.182596,  49.74023175,    4, 5,  "MDG BK0.00"},
        {-20.569736,  48.491124,      4, 5,  "MDG C00.XX"},
        {-19.910096,  48.76735275,    4, 5,  "MDG CK0.00"},
        {-16.910636,  49.542611,      4, 5,  "MDG D00.XX"},
        {-20.294096,  44.265680875,   4, 5,  "MDG DK0.00"},
        {-22.127436,  47.9725805,     4, 5,  "MDG F00.XX"},
        {-19.407196,  46.9143975,     4, 5,  "MDG FK0.00"},
        {-25.026936,  46.3612935,     4, 5,  "MDG G00.XX"},
        {-14.903896,  50.2403765,     4, 5,  "MDG GK0.00"},
        {-17.454736,  49.163425375,   4, 5,  "MDG H00.XX"},
        {-22.003896,  47.342691375,   4, 5,  "MDG HK0.00"},
        {-14.250436,  50.120841125,   4, 5,  "MDG J00.XX"},
        {-20.245896,  47.342280875,   4, 5,  "MDG JK0.00"},
        {-13.660636,  48.41982675,    4, 5,  "MDG K00.XX"},
        {-20.535896,  47.212208,      4, 5,  "MDG KK0.00"},
        {-23.707536,  44.336251375,   4, 5,  "MDG L00.XX"},
        {-18.925896,  47.7824975,     4, 5,  "MDG LK0.00"},
        {-16.092736,  46.63238325,    4, 5,  "MDG M00.XX"},
        {-25.324996,  45.45499475,    4, 5,  "MDG MK0.00"},
        {-21.817536,  46.896767125,   4, 5,  "MDG N00.XX"},
        {-19.845096,  46.82775275,    4, 5,  "MDG NK0.00"},
        {-21.223636,  48.29985275,    4, 5,  "MDG P00.XX"},
        {-19.385896,  47.4024975,     4, 5,  "MDG PK0.00"},
        {-18.927536,  48.1873675,     4, 5,  "MDG Q00.XX"},
        {-20.555896,  46.772208,      4, 5,  "MDG QK0.00"},
        {-18.757536,  46.007454125,   4, 5,  "MDG R00.XX"},
        {-22.295896,  44.4819185,     4, 5,  "MDG RK0.00"},
        {-24.687536,  44.7059935,     4, 5,  "MDG S00.XX"},
        {-22.825896,  47.78527375,    4, 5,  "MDG SK0.00"},
        {-19.422636,  48.17769625,    4, 5,  "MDG T00.XX"},
        {-20.055296,  48.108480875,   4, 5,  "MDG TK0.00"},
        {-23.330436,  47.565923625,   4, 5,  "MDG V00.XX"},
        {-19.705796,  44.51945275,    4, 5,  "MDG VK0.00"},
        {-25.159636,  45.0237935,     4, 5,  "MDG W00.XX"},
        {-15.432496,  49.714304625,   4, 5,  "MDG WK0.00"},
        {-16.457536,  46.677797625,   4, 5,  "MDG X00.XX"},
        {-22.925896,  44.49177375,    4, 5,  "MDG XK0.00"},
        {-14.647536,  49.618141125,   4, 5,  "MDG Y00.XX"},
        {-14.885896,  47.9630765,     4, 5,  "MDG YK0.00"},
        {-19.523536,  45.42779625,    4, 5,  "MDG Z00.XX"},
        {-17.385896,  49.382715125,   4, 5,  "MDG ZK0.00"},
        {-18.4547005, 46.3065525,     3, 4,  "MDG 123.XXX"},
        {-16.6997045, 49.082478,      3, 4,  "MDG 12.XXXX"},
        {-21.86255,   46.773547,      3, 4,  "MDG 0123.XX"},
        {-23.588975,  43.4415895,     3, 4,  "MDG 1123.XX"},
        {-16.131515,  46.2564115,     3, 4,  "MDG 3123.XX"},
        {-25.342085,  45.9908285,     3, 4,  "MDG 5123.XX"},
        {-17.940435,  48.076108,      3, 4,  "MDG 6123.XX"},
        {-12.52862,   49.0613325,     3, 4,  "MDG 4123.XX"},
        {-13.75105,   48.101189,      3, 4,  "MDG 2123.XX"},
        {-25.47924,   45.0205685,     3, 4,  "MDG D123.XX"},
        {-25.259635,  46.7208285,     3, 4,  "MDG 7123.XX"},
        {-20.51962,   44.0539405,     3, 4,  "MDG 8123.XX"},
        {-22.37132,   47.758647,      3, 4,  "MDG 9123.XX"},
        {-22.22942,   47.123457,      3, 4,  "MDG B123.XX"},
        {-23.95142,   44.1253795,     3, 4,  "MDG C123.XX"},
        {-21.46752,   48.085757,      3, 4,  "MDG F123.XX"},
        {-19.00142,   45.797908,      3, 4,  "MDG G123.XX"},
        {-22.524135,  44.2653795,     3, 4,  "MDG H123.XX"},
        {-24.93142,   44.487596,      3, 4,  "MDG J123.XX"},
        {-23.05142,   47.5688795,     3, 4,  "MDG K123.XX"},
        {-23.57432,   47.3548895,     3, 4,  "MDG L123.XX"},
        {-19.93132,   44.3076305,     3, 4,  "MDG M123.XX"},
        {-16.701419,  46.4756915,     3, 4,  "MDG N123.XX"},
        {-23.15142,   44.2753795,     3, 4,  "MDG P123.XX"},
        {-15.11142,   47.753049,      3, 4,  "MDG Q123.XX"},
        {-19.770135,  45.2211405,     3, 4,  "MDG R123.XX"},
        {-22.29142,   43.152752,      2, 3,  "MDG S123.XX"},
        {-12.8811125, 43.473375,      2, 3,  "MDG 1234.XXX"},
        {-18.9211015, 47.557867,      5, 6,  "MDG FKN2.VPGL"},
        {50.4804,     30.4469195,     4, 5,  "UKR 12.XX"},
        {50.337965,   30.28690675,    3, 4,  "UKR 00.XXX"},
        {50.046904,   36.07898475,    2, 5,  "UKR 80.XXX"},
        {48.533204,   34.8043525,     2, 3,  "UKR J0.XXX"},
        {48.077855,   37.657671875,   3, 5,  "UKR S0.XXX"},
        {46.521624,   30.65314,       2, 3,  "UKR 000.XX"},
        {46.435135,   30.65314,       2, 3,  "UKR 100.XX"},
        {47.129345,   37.471028125,   3, 5,  "UKR 200.XX"},
        {47.155145,   37.566314125,   3, 5,  "UKR 300.XX"},
        {47.863724,   35.129545875,   2, 3,  "UKR 400.XX"},
        {49.878724,   23.960624,      3, 5,  "UKR 500.XX"},
        {47.950724,   33.319545875,   2, 3,  "UKR 600.XX"},
        {46.992805,   31.934263125,   2, 3,  "UKR 700.XX"},
        {48.595465,   39.2571375,     3, 6,  "UKR 800.XX"},
        {44.990724,   34.042935125,   2, 3,  "UKR 900.XX"},
        {49.259834,   28.39134125,    3, 4,  "UKR B00.XX"},
        {44.605545,   33.425013125,   2, 3,  "UKR C00.XX"},
        {49.612245,   34.469845,      2, 3,  "UKR D00.XX"},
        {46.674545,   32.53786,       2, 3,  "UKR F00.XX"},
        {51.532745,   31.225960625,   3, 6,  "UKR G00.XX"},
        {50.949834,   34.71188525,    2, 7,  "UKR H00.XX"},
        {49.448945,   31.995045,      3, 4,  "UKR J00.XX"},
        {48.329834,   37.9802375,     3, 5,  "UKR K00.XX"},
        {50.283845,   28.59444875,    3, 4,  "UKR L00.XX"},
        {50.643045,   26.1826025,     3, 4,  "UKR M00.XX"},
        {49.449834,   26.934036,      3, 4,  "UKR N00.XX"},
        {48.529834,   32.1954705,     2, 3,  "UKR P00.XX"},
        {48.529834,   34.5554705,     2, 3,  "UKR Q00.XX"},
        {48.329834,   25.8654705,     3, 4,  "UKR R00.XX"},
        {49.099834,   33.37334125,    2, 3,  "UKR S00.XX"},
        {49.590545,   25.538545,      3, 4,  "UKR T00.XX"},
        {48.949834,   24.64475325,    3, 4,  "UKR V00.XX"},
        {50.777745,   25.2667125,     3, 4,  "UKR W00.XX"},
        {49.819045,   30.029145,      3, 4,  "UKR X00.XX"},
        {48.769545,   37.5040375,     3, 5,  "UKR Y00.XX"},
        {46.881545,   35.307263125,   2, 3,  "UKR Z00.XX"},
        {49.3934045,  35.938521,      2, 3,  "UKR 123.XXX"},
        {51.39817,    28.530053,      2, 4,  "UKR 12.XXXX"},
        {50.814699,   23.689535,      2, 4,  "UKR 1234.XX"},
        {51.823803,   22.7891945,     1, 4,  "UKR 1234.XXX"},
        {4.8765875,   31.5390885,     5, 6,  "SSD 12.XX"},
        {5.046115,    31.376425,      4, 5,  "SSD 12.XXX"},
        {9.533194,    31.584725625,   5, 9,  "SSD 000.XX"},
        {7.697194,    27.919541375,   4, 5,  "SSD 300.XX"},
        {3.828794,    32.406557125,   4, 6,  "SSD 600.XX"},
        {4.566194,    28.319957125,   4, 7,  "SSD 900.XX"},
        {4.089194,    30.602957125,   4, 8,  "SSD D00.XX"},
        {8.747714,    27.3431115,     4, 6,  "SSD H00.XX"},
        {8.513514,    28.0382115,     4, 5,  "SSD K00.XX"},
        {6.782514,    29.62955125,    4, 5,  "SSD M00.XX"},
        {8.593114,    33.0051115,     4, 6,  "SSD P00.XX"},
        {6.530514,    30.42855125,    4, 5,  "SSD R00.XX"},
        {6.210714,    31.51605125,    4, 5,  "SSD T00.XX"},
        {9.868114,    32.065541625,   5, 9,  "SSD W00.XX"},
        {11.726614,   32.748801875,   5, 9,  "SSD Y00.XX"},
        {6.3026475,   30.3385765,     3, 4,  "SSD 123.XXX"},
        {8.925844,    27.454771,      3, 5,  "SSD 12.XXXX"},
        {9.304864,    31.4314325,     3, 4,  "SSD 1123.XX"},
        {4.337864,    28.1632,        3, 6,  "SSD 3123.XX"},
        {8.381224,    32.83511,       3, 4,  "SSD 4123.XX"},
        {6.318624,    30.25821,       4, 5,  "SSD 5123.XX"},
        {9.653509,    31.8983325,     5, 9,  "SSD 6123.XX"},
        {11.514724,   32.5819325,     4, 8,  "SSD 7123.XX"},
        {10.548876,   23.824372,      3, 9,  "SSD 123.XXXX"},
        {10.796,      29.7,           3, 8,  "SSD GMQ6.412"},
        {7.865,       29.7,           3, 4,  "SSD M4J3.TZQH"},
        {4.389268,    18.505060625,   4, 7,  "CAF 00.XX"},
        {4.359184,    18.549913125,   4, 7,  "CAF J0.XX"},
        {4.561115,    18.243306,      3, 6,  "CAF 12.XXX"},
        {3.913124,    17.919407125,   3, 4,  "CAF 000.XX"},
        {4.298824,    15.737507125,   3, 5,  "CAF 100.XX"},
        {7.030724,    19.145981375,   3, 4,  "CAF 200.XX"},
        {6.359724,    16.33909425,    3, 4,  "CAF 300.XX"},
        {4.981724,    15.825207125,   3, 5,  "CAF 400.XX"},
        {5.775324,    19.06299425,    3, 4,  "CAF 500.XX"},
        {5.802324,    20.61939425,    3, 4,  "CAF 600.XX"},
        {6.582724,    21.94509425,    3, 4,  "CAF 700.XX"},
        {5.984524,    15.57149425,    3, 5,  "CAF 800.XX"},
        {6.548524,    17.41059425,    3, 4,  "CAF 900.XX"},
        {4.791024,    22.776207125,   3, 6,  "CAF B00.XX"},
        {3.560724,    15.999207125,   3, 6,  "CAF C00.XX"},
        {5.028224,    23.877907125,   3, 8,  "CAF D00.XX"},
        {6.292624,    21.16029425,    3, 4,  "CAF F00.XX"},
        {4.643424,    21.825107125,   3, 6,  "CAF G00.XX"},
        {5.090724,    21.169207125,   3, 6,  "CAF H00.XX"},
        {7.030724,    15.598981375,   3, 5,  "CAF J00.XX"},
        {4.663124,    22.213807125,   3, 6,  "CAF K00.XX"},
        {8.436424,    20.626581375,   3, 5,  "CAF L00.XX"},
        {5.000724,    18.659207125,   3, 6,  "CAF M00.XX"},
        {5.840724,    14.78909425,    3, 5,  "CAF N00.XX"},
        {5.350024,    17.06489425,    3, 4,  "CAF P00.XX"},
        {4.367124,    22.492207125,   3, 6,  "CAF Q00.XX"},
        {5.070124,    25.086007125,   3, 8,  "CAF R00.XX"},
        {4.155424,    15.104807125,   3, 5,  "CAF S00.XX"},
        {5.736924,    15.91099425,    3, 5,  "CAF T00.XX"},
        {4.732024,    18.169107125,   3, 4,  "CAF V00.XX"},
        {5.059124,    19.945907125,   3, 6,  "CAF W00.XX"},
        {3.687224,    18.523107125,   3, 8,  "CAF X00.XX"},
        {4.346064,    21.155499375,   3, 7,  "CAF Y00.XX"},
        {5.393004,    26.46180025,    3, 8,  "CAF YK0.00"},
        {10.296864,   22.75857025,    3, 7,  "CAF Z00.XX"},
        {8.064104,    22.373728375,   3, 5,  "CAF ZK0.00"},
        {6.0934785,   16.2610765,     3, 4,  "CAF 123.XXX"},
        {6.544177,    20.541075,      2, 3,  "CAF 12.XXXX"},
        {4.024009,    15.5465,        2, 4,  "CAF 0123.XX"},
        {6.758624,    18.9552,        2, 3,  "CAF 1123.XX"},
        {6.087624,    16.1482,        2, 4,  "CAF 2123.XX"},
        {4.706909,    15.6342,        2, 4,  "CAF 3123.XX"},
        {5.503224,    18.8721,        2, 3,  "CAF 4123.XX"},
        {5.588624,    15.55035,       2, 4,  "CAF 5123.XX"},
        {6.276424,    17.2197,        2, 3,  "CAF 6123.XX"},
        {3.285909,    15.8082,        2, 5,  "CAF 7123.XX"},
        {4.753409,    23.6869,        2, 7,  "CAF 8123.XX"},
        {6.758624,    15.4082,        2, 4,  "CAF 9123.XX"},
        {8.164324,    20.4358,        2, 4,  "CAF B123.XX"},
        {5.568624,    14.5982,        2, 5,  "CAF C123.XX"},
        {4.795309,    24.895,         2, 7,  "CAF D123.XX"},
        {3.880609,    14.9138,        2, 4,  "CAF F123.XX"},
        {4.784309,    19.7549,        2, 5,  "CAF G123.XX"},
        {5.164764,    26.2562,        2, 7,  "CAF H123.XX"},
        {10.052979,   22.5608425,     2, 6,  "CAF J123.XX"},
        {7.838578,    22.16821,       2, 4,  "CAF K123.XX"},
        {10.4056495,  14.8719305,     1, 6,  "CAF 1234.XXX"},
        {2.084087,    45.30098,       4, 5,  "SOM 00.XX"},
        {2.110195,    45.347239,      4, 5,  "SOM J0.XX"},
        {2.299701,    45.02318,       3, 4,  "SOM 12.XXX"},
        {9.59537,     44.021597625,   3, 5,  "SOM 000.XX"},
        {10.474724,   44.97184275,    3, 5,  "SOM 100.XX"},
        {-0.306056,   42.490167,      4, 5,  "SOM 200.XX"},
        {1.760724,    44.71932,       3, 4,  "SOM 300.XX"},
        {0.120724,    42.70932,       4, 5,  "SOM 400.XX"},
        {3.154724,    43.60932,       3, 4,  "SOM 500.XX"},
        {3.839435,    42.506254125,   4, 6,  "SOM 600.XX"},
        {9.562724,    45.492755625,   3, 5,  "SOM 700.XX"},
        {11.305524,   49.144429875,   3, 4,  "SOM 800.XX"},
        {6.810724,    47.39009425,    3, 5,  "SOM 900.XX"},
        {4.780825,    45.166307125,   3, 5,  "SOM B00.XX"},
        {2.81616,     45.459893,      3, 4,  "SOM C00.XX"},
        {2.380724,    42.23932,       4, 5,  "SOM D00.XX"},
        {1.802464,    44.499085,      3, 4,  "SOM F00.XX"},
        {8.399304,    48.458128375,   3, 4,  "SOM FK0.00"},
        {9.518664,    49.054455875,   3, 4,  "SOM G00.XX"},
        {10.609004,   47.34101075,    3, 5,  "SOM GK0.00"},
        {0.527864,    42.729785,      4, 5,  "SOM H00.XX"},
        {8.463604,    47.3355555,     3, 5,  "SOM HK0.00"},
        {9.949164,    43.155355875,   3, 5,  "SOM J00.XX"},
        {2.794104,    44.053945,      3, 4,  "SOM JK0.00"},
        {1.141464,    43.996785,      3, 4,  "SOM K00.XX"},
        {3.844104,    47.153873125,   3, 5,  "SOM KK0.00"},
        {4.189964,    42.026499375,   4, 6,  "SOM L00.XX"},
        {2.614104,    44.863945,      3, 4,  "SOM LK0.00"},
        {4.023964,    44.482799375,   3, 5,  "SOM M00.XX"},
        {1.970604,    44.808245,      3, 4,  "SOM MK0.00"},
        {7.992864,    49.787228125,   3, 4,  "SOM N00.XX"},
        {3.848404,    45.538773125,   3, 5,  "SOM NK0.00"},
        {2.420264,    42.946785,      4, 5,  "SOM P00.XX"},
        {11.454704,   49.863138875,   3, 4,  "SOM PK0.00"},
        {9.512464,    50.778655875,   3, 4,  "SOM Q00.XX"},
        {3.323604,    42.195473125,   4, 5,  "SOM QK0.00"},
        {0.525064,    42.040085,      4, 5,  "SOM R00.XX"},
        {11.844104,   51.023438875,   3, 4,  "SOM RK0.00"},
        {10.438564,   51.22807025,    3, 4,  "SOM S00.XX"},
        {4.117104,    43.865073125,   3, 5,  "SOM SK0.00"},
        {2.984164,    45.502385,      3, 4,  "SOM T00.XX"},
        {5.344104,    48.49380025,    3, 4,  "SOM TK0.00"},
        {5.762464,    46.47891375,    2, 4,  "SOM V00.XX"},
        {9.404104,    45.0336555,     3, 5,  "SOM VK0.00"},
        {4.698164,    46.588699375,   2, 4,  "SOM W00.XX"},
        {3.384104,    45.563873125,   3, 4,  "SOM WK0.00"},
        {1.653264,    42.424285,      3, 4,  "SOM X00.XX"},
        {11.339004,   43.445338875,   2, 4,  "SOM XK0.00"},
        {11.162464,   48.148484625,   2, 3,  "SOM Y00.XX"},
        {11.264104,   51.023438875,   2, 3,  "SOM YK0.00"},
        {3.832464,    43.208999375,   2, 4,  "SOM Z00.XX"},
        {4.524104,    43.003873125,   3, 5,  "SOM ZK0.00"},
        {3.6252815,   43.2268665,     2, 4,  "SOM 123.XXX"},
        {9.213975,    44.8528115,     2, 4,  "SOM 01.XXXX"},
        {9.342975,    43.8571115,     2, 4,  "SOM 11.XXXX"},
        {10.096875,   44.8247115,     2, 4,  "SOM 21.XXXX"},
        {-0.586725,   42.286525,      3, 4,  "SOM 31.XXXX"},
        {-0.131725,   42.541425,      4, 5,  "SOM 41.XXXX"},
        {3.586975,    42.338425,      3, 5,  "SOM 51.XXXX"},
        {9.310275,    45.3283115,     2, 4,  "SOM 61.XXXX"},
        {10.871775,   48.9733115,     2, 3,  "SOM 71.XXXX"},
        {6.558275,    47.222425,      2, 4,  "SOM 81.XXXX"},
        {4.528375,    44.998525,      2, 4,  "SOM 91.XXXX"},
        {2.128275,    42.071425,      3, 4,  "SOM B1.XXXX"},
        {8.193475,    48.275825,      2, 3,  "SOM C1.XXXX"},
        {9.294475,    48.8801115,     2, 3,  "SOM D1.XXXX"},
        {10.597675,   46.9795115,     2, 4,  "SOM F1.XXXX"},
        {0.344375,    42.464825,      3, 4,  "SOM G1.XXXX"},
        {8.257775,    47.153325,      2, 4,  "SOM H1.XXXX"},
        {9.605875,    43.1213115,     2, 4,  "SOM J1.XXXX"},
        {3.638275,    46.971425,      2, 4,  "SOM K1.XXXX"},
        {3.965775,    41.848925,      3, 8,  "SOM L1.XXXX"},
        {3.799775,    44.305225,      2, 4,  "SOM M1.XXXX"},
        {7.768675,    49.609825,      2, 3,  "SOM N1.XXXX"},
        {3.692575,    45.341825,      2, 4,  "SOM P1.XXXX"},
        {2.290175,    42.722025,      3, 4,  "SOM Q1.XXXX"},
        {11.092675,   49.6814115,     2, 3,  "SOM R1.XXXX"},
        {9.350475,    50.4201115,     2, 3,  "SOM S1.XXXX"},
        {3.107275,    42.086925,      3, 4,  "SOM T1.XXXX"},
        {0.300874,    41.862425,      3, 5,  "SOM V1.XXXX"},
        {10.539715,   50.9093615,     2, 3,  "SOM W1.XXXX"},
        {3.911275,    43.682625,      2, 4,  "SOM X1.XXXX"},
        {5.161575,    48.272125,      2, 3,  "SOM Y1.XXXX"},
        {11.748675,   50.712684,      2, 3,  "SOM Z1.XXXX"},
        {0.770555,    41.847205,      2, 4,  "SOM 1234.XX"},
        {11.0488875,  41.3488465,     1, 3,  "SOM 1234.XXX"},
        {34.5651,     69.124532,      4, 5,  "AFG 12.XX"},
        {34.622294,   68.961798625,   3, 4,  "AFG 00.XXX"},
        {31.643014,   65.53430925,    3, 4,  "AFG J0.XXX"},
        {36.752224,   67.04990275,    3, 4,  "AFG 000.XX"},
        {36.752224,   67.15705275,    3, 4,  "AFG 100.XX"},
        {35.060724,   69.120619625,   3, 4,  "AFG 200.XX"},
        {34.388124,   62.132345375,   3, 4,  "AFG 300.XX"},
        {34.388124,   62.236852375,   3, 4,  "AFG 400.XX"},
        {34.467424,   70.395345375,   3, 4,  "AFG 500.XX"},
        {37.159124,   70.508763125,   3, 4,  "AFG 600.XX"},
        {34.706724,   70.160119625,   3, 4,  "AFG 700.XX"},
        {35.019224,   63.088419625,   3, 4,  "AFG 800.XX"},
        {36.241424,   68.691841375,   3, 4,  "AFG 900.XX"},
        {36.764624,   68.81570275,    3, 6,  "AFG B00.XX"},
        {34.934424,   71.080519625,   3, 6,  "AFG C00.XX"},
        {33.640024,   69.187684,      3, 6,  "AFG D00.XX"},
        {34.560724,   65.200845375,   3, 4,  "AFG F00.XX"},
        {36.726524,   69.03470275,    3, 4,  "AFG G00.XX"},
        {35.957224,   64.740041375,   3, 5,  "AFG H00.XX"},
        {36.789124,   66.820163125,   3, 4,  "AFG J00.XX"},
        {33.599524,   68.379823625,   3, 6,  "AFG K00.XX"},
        {36.015795,   68.664636875,   3, 4,  "AFG L00.XX"},
        {36.690804,   67.68452075,    3, 4,  "AFG LK0.00"},
        {36.675964,   65.73120025,    3, 5,  "AFG M00.XX"},
        {34.570104,   68.917417375,   3, 4,  "AFG MK0.00"},
        {32.405964,   62.077789,      3, 4,  "AFG N00.XX"},
        {36.927604,   65.084304125,   3, 5,  "AFG NK0.00"},
        {31.604264,   64.33526125,    3, 4,  "AFG P00.XX"},
        {34.444104,   68.748517375,   3, 4,  "AFG PK0.00"},
        {36.746604,   69.493039625,   3, 6,  "AFG Q00.XX"},
        {34.793704,   67.471372625,   3, 4,  "AFG QK0.00"},
        {32.113664,   66.892089,      3, 4,  "AFG R00.XX"},
        {30.949804,   61.822820125,   3, 6,  "AFG RK0.00"},
        {37.194664,   68.874542375,   3, 7,  "AFG S00.XX"},
        {34.350304,   61.454717375,   3, 6,  "AFG SK0.00"},
        {34.661164,   61.153072875,   3, 6,  "AFG T00.XX"},
        {36.990904,   68.362904125,   3, 6,  "AFG TK0.00"},
        {33.968764,   68.905502,      3, 6,  "AFG V00.XX"},
        {34.012304,   68.988734,      3, 6,  "AFG VK0.00"},
        {33.951264,   69.032202,      3, 6,  "AFG W00.XX"},
        {37.384504,   69.7763865,     3, 7,  "AFG WK0.00"},
        {33.358664,   69.869759875,   3, 6,  "AFG X00.XX"},
        {33.346514,   69.948072625,   3, 6,  "AFG XK0.00"},
        {33.329264,   62.113559875,   3, 4,  "AFG Y00.XX"},
        {37.015304,   66.738604125,   3, 4,  "AFG YK0.00"},
        {36.922764,   66.141742375,   3, 5,  "AFG Z00.XX"},
        {34.928604,   69.227672625,   3, 4,  "AFG ZK0.00"},
        {35.6551805,  67.5535215,     2, 3,  "AFG 123.XXX"},
        {36.391525,   66.250156,      2, 4,  "AFG 12.XXXX"},
        {34.116024,   61.955601,      2, 3,  "AFG 0123.XX"},
        {34.744409,   62.8622835,     2, 3,  "AFG 1123.XX"},
        {34.659609,   70.8543735,     2, 5,  "AFG 2123.XX"},
        {34.288624,   64.971841,      2, 3,  "AFG 3123.XX"},
        {35.685124,   64.506789,      2, 4,  "AFG 4123.XX"},
        {36.432079,   65.4888225,     2, 4,  "AFG 5123.XX"},
        {32.159364,   61.841192,      2, 5,  "AFG 6123.XX"},
        {36.702079,   64.8361325,     2, 4,  "AFG 7123.XX"},
        {31.357664,   64.1062855,     2, 3,  "AFG 8123.XX"},
        {31.869779,   66.6632755,     2, 3,  "AFG 9123.XX"},
        {30.721465,   61.693474,      2, 5,  "AFG B123.XX"},
        {34.271524,   61.059561,      2, 5,  "AFG C123.XX"},
        {33.082664,   61.8800245,     2, 5,  "AFG D123.XX"},
        {31.89332,    64.9151355,     2, 3,  "AFG F123.XX"},
        {31.89332,    65.4619765,     2, 3,  "AFG G123.XX"},
        {31.89332,    66.0088165,     2, 3,  "AFG H123.XX"},
        {31.399565,   64.9151365,     2, 3,  "AFG K123.XX"},
        {31.399565,   65.4619765,     2, 3,  "AFG L123.XX"},
        {31.399565,   66.0088165,     2, 3,  "AFG M123.XX"},
        {30.908525,   64.915108,      2, 3,  "AFG P123.XX"},
        {30.908525,   65.45674,       2, 3,  "AFG Q123.XX"},
        {30.908525,   65.998372,      2, 3,  "AFG R123.XX"},
        {31.931987,   63.1315295,     2, 3,  "AFG X123.XX"},
        {34.170957,   66.296248,      2, 3,  "AFG Z123.XX"},
        {37.850263,   60.999303,      1, 5,  "AFG 1234.XXX"},
        {16.8444,     96.1227275,     4, 5,  "MMR 12.XX"},
        {16.816694,   96.012806875,   3, 4,  "MMR 00.XXX"},
        {22.055784,   95.921556125,   3, 4,  "MMR C0.XXX"},
        {19.822055,   96.03632075,    3, 4,  "MMR P0.XXX"},
        {16.513724,   97.613625875,   3, 5,  "MMR 000.XX"},
        {17.356924,   96.436212,      3, 4,  "MMR 100.XX"},
        {16.827424,   94.693025875,   2, 3,  "MMR 200.XX"},
        {22.166545,   95.0967425,     3, 4,  "MMR 300.XX"},
        {20.188545,   92.822532375,   2, 3,  "MMR 400.XX"},
        {20.905534,   95.818012,      3, 4,  "MMR 500.XX"},
        {12.470545,   98.570124,      2, 4,  "MMR 600.XX"},
        {20.807534,   96.968912,      3, 4,  "MMR 700.XX"},
        {14.121134,   98.16228525,    2, 4,  "MMR 800.XX"},
        {22.980334,   97.70349575,    2, 6,  "MMR 900.XX"},
        {18.853034,   95.211209875,   3, 4,  "MMR B00.XX"},
        {21.491834,   95.34497325,    3, 4,  "MMR C00.XX"},
        {17.674134,   95.409448625,   3, 4,  "MMR D00.XX"},
        {22.056334,   96.418953875,   3, 4,  "MMR F00.XX"},
        {21.384834,   95.03997325,    3, 4,  "MMR G00.XX"},
        {17.006445,   97.335235,      3, 5,  "MMR H00.XX"},
        {20.480034,   94.846332375,   3, 4,  "MMR J00.XX"},
        {18.959034,   96.3918905,     3, 4,  "MMR K00.XX"},
        {20.176045,   94.916239375,   4, 5,  "MMR L00.XX"},
        {16.315445,   97.67350775,    3, 5,  "MMR M00.XX"},
        {17.984034,   96.67732925,    3, 4,  "MMR N00.XX"},
        {20.928634,   94.762512,      3, 4,  "MMR P00.XX"},
        {22.597934,   95.6465345,     3, 4,  "MMR Q00.XX"},
        {22.933545,   96.40024375,    3, 4,  "MMR R00.XX"},
        {25.411845,   97.34124875,    2, 3,  "MMR S00.XX"},
        {21.301545,   99.57387325,    2, 7,  "MMR T00.XX"},
        {16.319834,   95.35530775,    3, 4,  "MMR V00.XX"},
        {16.319834,   95.63530775,    3, 4,  "MMR W00.XX"},
        {20.039834,   95.494232375,   3, 4,  "MMR X00.XX"},
        {19.388545,   95.1622375,     3, 4,  "MMR Y00.XX"},
        {20.220724,   94.836721875,   3, 4,  "MMR Z00.XX"},
        {17.8975385,  94.896041,      2, 3,  "MMR 123.XXX"},
        {20.57742,    94.381715,      2, 3,  "MMR 12.XXXX"},
        {23.32557,    94.281239,      2, 5,  "MMR 1234.XX"},
        {12.1449805,  92.473928,      1, 7,  "MMR 1234.XXX"},
        {-15.3849,    28.2523275,     4, 5,  "ZMB 12.XX"},
        {-15.353896,  28.165753125,   3, 4,  "ZMB 00.XXX"},
        {-12.747696,  28.078201625,   3, 4,  "ZMB 80.XXX"},
        {-12.916696,  28.516401625,   3, 6,  "ZMB J0.XXX"},
        {-14.538016,  28.328888875,   3, 4,  "ZMB S0.XXX"},
        {-12.516876,  27.827016,      3, 4,  "ZMB 000.XX"},
        {-12.525895,  28.18383,       3, 4,  "ZMB 100.XX"},
        {-13.121115,  28.35558525,    3, 6,  "ZMB 200.XX"},
        {-17.805676,  25.809999125,   3, 6,  "ZMB 300.XX"},
        {-10.171476,  31.14584275,    3, 5,  "ZMB 400.XX"},
        {-13.597876,  32.59239025,    3, 5,  "ZMB 500.XX"},
        {-12.324676,  27.796316,      3, 6,  "ZMB 600.XX"},
        {-15.821776,  27.71323875,    3, 5,  "ZMB 700.XX"},
        {-15.714176,  28.128751625,   3, 5,  "ZMB 800.XX"},
        {-11.159276,  28.848529875,   3, 6,  "ZMB 900.XX"},
        {-16.755476,  26.933425875,   3, 5,  "ZMB B00.XX"},
        {-15.223676,  23.117551625,   3, 5,  "ZMB C00.XX"},
        {-12.151766,  26.343224,      3, 6,  "ZMB D00.XX"},
        {-13.925855,  28.65933125,    3, 4,  "ZMB F00.XX"},
        {-11.829825,  31.383829375,   3, 5,  "ZMB G00.XX"},
        {-16.285896,  27.45293175,    3, 5,  "ZMB GK0.00"},
        {-9.301745,   28.7239825,     3, 6,  "ZMB H00.XX"},
        {-9.812065,   29.032859375,   3, 4,  "ZMB HK0.00"},
        {-11.365836,  29.514584625,   3, 7,  "ZMB J00.XX"},
        {-8.845696,   31.3393555,     3, 5,  "ZMB JK0.00"},
        {-14.982736,  27.0428545,     3, 4,  "ZMB K00.XX"},
        {-14.269496,  31.303649375,   3, 5,  "ZMB KK0.00"},
        {-17.449236,  24.269525375,   3, 6,  "ZMB L00.XX"},
        {-16.522996,  28.682459875,   3, 5,  "ZMB LK0.00"},
        {-12.623736,  28.025612375,   4, 5,  "ZMB M00.XX"},
        {-14.806796,  24.7731765,     3, 4,  "ZMB MK0.00"},
        {-17.343136,  27.190525375,   3, 5,  "ZMB N00.XX"},
        {-10.553096,  32.04671075,    3, 6,  "ZMB NK0.00"},
        {-10.145436,  32.60457025,    3, 5,  "ZMB P00.XX"},
        {-17.033096,  26.451087,      3, 5,  "ZMB PK0.00"},
        {-11.728236,  24.400584625,   3, 4,  "ZMB Q00.XX"},
        {-13.616496,  29.36062125,    3, 4,  "ZMB QK0.00"},
        {-13.497536,  28.12822675,    3, 4,  "ZMB R00.XX"},
        {-14.085896,  32.03132125,    3, 5,  "ZMB RK0.00"},
        {-17.233236,  27.420711,      3, 5,  "ZMB S00.XX"},
        {-15.867596,  27.84903175,    3, 5,  "ZMB SK0.00"},
        {-10.885136,  29.62867025,    3, 7,  "ZMB T00.XX"},
        {-9.337996,   32.7209555,     3, 6,  "ZMB TK0.00"},
        {-16.100636,  23.27868325,    3, 5,  "ZMB V00.XX"},
        {-15.575896,  28.253004625,   3, 4,  "ZMB VK0.00"},
        {-12.277536,  33.138398,      3, 5,  "ZMB W00.XX"},
        {-13.233196,  30.20312125,    3, 5,  "ZMB WK0.00"},
        {-14.995636,  22.6325545,     3, 5,  "ZMB X00.XX"},
        {-15.139196,  23.1271765,     3, 5,  "ZMB XK0.00"},
        {-8.761936,   31.0782415,     3, 5,  "ZMB Y00.XX"},
        {-15.746496,  26.012204625,   3, 5,  "ZMB YK0.00"},
        {-13.527536,  23.07822675,    3, 5,  "ZMB Z00.XX"},
        {-13.475896,  24.97322125,    3, 4,  "ZMB ZK0.00"},
        {-8.472852,   28.547233,      2, 6,  "ZMB 12.XXXX"},
        {-12.498985,  27.99339,       3, 4,  "ZMB 012.XXX"},
        {-12.846085,  28.28189,       4, 7,  "ZMB 112.XXX"},
        {-14.237685,  28.23259,       2, 3,  "ZMB 212.XXX"},
        {-17.557285,  25.637155,      2, 4,  "ZMB 312.XXX"},
        {-9.990985,   31.0779115,     2, 4,  "ZMB 412.XXX"},
        {-13.438485,  32.42099,       2, 4,  "ZMB 512.XXX"},
        {-12.240985,  27.58309,       2, 5,  "ZMB 612.XXX"},
        {-10.999885,  28.6843115,     2, 6,  "ZMB 712.XXX"},
        {-14.982085,  22.9445765,     2, 4,  "ZMB 812.XXX"},
        {-11.975785,  26.1618115,     2, 5,  "ZMB 912.XXX"},
        {-13.757385,  28.46639,       2, 3,  "ZMB B12.XXX"},
        {-11.637985,  31.2202115,     2, 5,  "ZMB C12.XXX"},
        {-8.599785,   31.0322115,     3, 5,  "ZMB F12.XXX"},
        {-11.178185,  29.3404115,     2, 6,  "ZMB D12.XXX"},
        {-14.063485,  31.11729,       2, 4,  "ZMB G12.XXX"},
        {-17.130785,  24.086855,      2, 5,  "ZMB H12.XXX"},
        {-14.600785,  24.58689,       2, 3,  "ZMB J12.XXX"},
        {-13.374885,  24.68679,       2, 3,  "ZMB Z12.XXX"},
        {-10.347085,  31.8675115,     2, 4,  "ZMB K12.XXX"},
        {-9.957785,   32.4303105,     2, 4,  "ZMB L12.XXX"},
        {-11.540585,  24.2264115,     2, 5,  "ZMB M12.XXX"},
        {-13.409885,  29.17679,       2, 5,  "ZMB N12.XXX"},
        {-13.309885,  27.94679,       2, 3,  "ZMB P12.XXX"},
        {-13.879885,  31.84679,       2, 4,  "ZMB Q12.XXX"},
        {-9.256685,   32.5697115,     2, 4,  "ZMB R12.XXX"},
        {-15.919885,  23.0596765,     2, 4,  "ZMB S12.XXX"},
        {-12.089885,  32.9643115,     2, 4,  "ZMB T12.XXX"},
        {-13.019885,  30.02679,       2, 3,  "ZMB V12.XXX"},
        {-14.789885,  22.4696765,     2, 4,  "ZMB W12.XXX"},
        {-15.583785,  25.6765765,     2, 3,  "ZMB X12.XXX"},
        {-13.339885,  22.89679,       2, 4,  "ZMB Y12.XXX"},
        {-15.12611,   26.2128865,     2, 3,  "ZMB 1234.XX"},
        {-8.8686255,  22.4036205,     1, 5,  "ZMB 1234.XXX"},
        {-33.4249,    -70.6835665,    5, 7,  "CHL 12.XX"},
        {-33.373655,  -70.907602875,  4, 6,  "CHL 00.XXX"},
        {-32.957866,  -71.659306125,  4, 6,  "CHL J0.XXX"},
        {-23.549455,  -70.420955625,  3, 5,  "CHL 000.XX"},
        {-36.713376,  -73.142636875,  4, 5,  "CHL 100.XX"},
        {-36.810655,  -73.150719375,  4, 5,  "CHL 200.XX"},
        {-38.687076,  -72.650266625,  4, 5,  "CHL 300.XX"},
        {-20.214155,  -70.157960625,  3, 5,  "CHL 400.XX"},
        {-34.134166,  -70.788682125,  4, 5,  "CHL 500.XX"},
        {-35.402205,  -71.71198,      4, 5,  "CHL 600.XX"},
        {-18.438366,  -70.333290125,  3, 5,  "CHL 700.XX"},
        {-41.419166,  -73.0065815,    3, 4,  "CHL 800.XX"},
        {-37.438766,  -72.4036135,    4, 5,  "CHL 900.XX"},
        {-29.941766,  -71.382791625,  3, 5,  "CHL B00.XX"},
        {-36.570166,  -72.16329625,   4, 5,  "CHL C00.XX"},
        {-29.873966,  -71.282852875,  3, 5,  "CHL D00.XX"},
        {-36.946455,  -73.188719375,  4, 5,  "CHL F00.XX"},
        {-53.096855,  -70.96462625,   3, 4,  "CHL G00.XX"},
        {-40.559655,  -73.184559375,  4, 5,  "CHL H00.XX"},
        {-22.444115,  -68.9470305,    3, 6,  "CHL HK0.00"},
        {-39.812736,  -73.271131625,  4, 5,  "CHL J00.XX"},
        {-27.376996,  -70.356411375,  3, 7,  "CHL JK0.00"},
        {-34.968806,  -71.271017875,  4, 5,  "CHL K00.XX"},
        {-30.611296,  -71.227879875,  3, 5,  "CHL KK0.00"},
        {-33.677455,  -71.25699,      4, 6,  "CHL L00.XX"},
        {-33.535775,  -71.624265125,  4, 6,  "CHL LK0.00"},
        {-36.869055,  -73.049719375,  4, 5,  "CHL M00.XX"},
        {-32.745815,  -70.740153875,  4, 6,  "CHL MK0.00"},
        {-33.721455,  -70.78861,      4, 6,  "CHL N00.XX"},
        {-34.575996,  -71.014269375,  4, 5,  "CHL NK0.00"},
        {-32.805455,  -70.633833125,  4, 8,  "CHL P00.XX"},
        {-33.650175,  -70.954854,     4, 6,  "CHL PK0.00"},
        {-36.595055,  -72.98292125,   4, 5,  "CHL Q00.XX"},
        {-34.405996,  -70.893269375,  4, 5,  "CHL QK0.00"},
        {-36.415955,  -71.99818825,   4, 5,  "CHL R00.XX"},
        {-33.790436,  -70.780726,     4, 5,  "CHL RK0.00"},
        {-32.774655,  -71.226561125,  4, 6,  "CHL S00.XX"},
        {-37.095775,  -73.171790625,  4, 5,  "CHL SK0.00"},
        {-37.783455,  -72.744715625,  4, 5,  "CHL T00.XX"},
        {-28.576375,  -70.797138625,  3, 5,  "CHL TK0.00"},
        {-35.327155,  -72.440225,     4, 5,  "CHL V00.XX"},
        {-36.733196,  -73.01581875,   4, 5,  "CHL VK0.00"},
        {-39.262406,  -72.26955825,   4, 5,  "CHL W00.XX"},
        {-45.578015,  -72.10627375,   3, 4,  "CHL WK0.00"},
        {-35.957455,  -72.365723125,  4, 5,  "CHL X00.XX"},
        {-34.440815,  -71.110286375,  4, 5,  "CHL XK0.00"},
        {-33.262406,  -70.903731875,  4, 6,  "CHL Y00.XX"},
        {-41.895655,  -73.86414,      3, 4,  "CHL YK0.00"},
        {-38.740455,  -72.999301125,  4, 5,  "CHL Z00.XX"},
        {-40.285996,  -73.107199625,  4, 5,  "CHL ZK0.00"},
        {-34.7423155, -72.397439,     3, 4,  "CHL 123.XXX"},
        {-35.598806,  -73.5013465,    2, 3,  "CHL 12.XXXX"},
        {-40.285516,  -73.6817515,    3, 4,  "CHL 1234.XX"},
        {-17.5516115, -71.1060015,    2, 7,  "CHL B123.XXX"},
        {-20.1663255, -70.544258,     3, 5,  "CHL C123.XXX"},
        {-22.8475155, -72.581187,     2, 4,  "CHL D123.XXX"},
        {-22.8475155, -69.69146,      2, 4,  "CHL F123.XXX"},
        {-25.5287055, -71.134946,     2, 4,  "CHL G123.XXX"},
        {-28.2098955, -72.19473,      2, 4,  "CHL H123.XXX"},
        {-30.9074015, -72.7329255,    2, 4,  "CHL J123.XXX"},
        {-33.5885915, -72.821296,     2, 4,  "CHL K123.XXX"},
        {-36.2534655, -73.832021,     2, 3,  "CHL L123.XXX"},
        {-38.9346555, -74.548427,     2, 3,  "CHL M123.XXX"},
        {-41.6321615, -74.9754125,    2, 3,  "CHL N123.XXX"},
        {-44.3133515, -74.653989,     2, 3,  "CHL P123.XXX"},
        {-44.3133515, -78.377864,     2, 3,  "CHL Q123.XXX"},
        {-46.9945415, -75.574463,     2, 3,  "CHL R123.XXX"},
        {-49.6757315, -75.6857295,    2, 3,  "CHL S123.XXX"},
        {-52.0188625, -76.7940425,    2, 3,  "CHL T123.XXX"},
        {-52.0188625, -72.4743475,    3, 4,  "CHL V123.XXX"},
        {-53.9120115, -74.717749,     3, 4,  "CHL W123.XXX"},
        {-53.9120115, -70.710439,     4, 5,  "CHL X123.XXX"},
        {-32.4270795, -81.1705015,    2, 3,  "CHL Y123.XXX"},
        {-25.0396685, -81.33252,      2, 3,  "CHL Z123.XXX"},
        {-25.8274025, -109.887602,    2, 3,  "CHL 0123.XXX"},
        {-33.46,      -70.6385195,    5, 9,  "CHL WDZP.62SB"},
        {40.991555,   28.8871915,     4, 5,  "TUR 10.XX"},
        {41.048525,   28.9382415,     4, 5,  "TUR J0.XX"},
        {39.931904,   32.541903625,   2, 3,  "TUR 00.XXX"},
        {39.931904,   32.654579625,   2, 3,  "TUR 10.XXX"},
        {39.940552,   32.767255625,   2, 3,  "TUR 20.XXX"},
        {39.940552,   32.879931625,   2, 3,  "TUR 30.XXX"},
        {39.854063,   32.767255625,   2, 3,  "TUR 40.XXX"},
        {39.854063,   32.879931625,   2, 3,  "TUR 50.XXX"},
        {38.502775,   27.032639875,   3, 4,  "TUR 60.XXX"},
        {38.417104,   27.192433375,   4, 5,  "TUR 70.XXX"},
        {38.367004,   27.086133375,   3, 4,  "TUR 80.XXX"},
        {38.280515,   27.086133375,   3, 4,  "TUR 90.XXX"},
        {41.048104,   28.6223125,     3, 4,  "TUR B0.XXX"},
        {41.048104,   28.7366705,     3, 4,  "TUR C0.XXX"},
        {41.048104,   28.8510285,     3, 4,  "TUR D0.XXX"},
        {41.043779,   28.9653865,     4, 5,  "TUR F0.XXX"},
        {41.043779,   29.0797445,     3, 4,  "TUR G0.XXX"},
        {40.961615,   28.5479795,     3, 4,  "TUR H0.XXX"},
        {40.961615,   28.6623375,     3, 4,  "TUR J0.XXX"},
        {40.961615,   28.7766955,     3, 4,  "TUR K0.XXX"},
        {40.95729,    29.0099855,     3, 4,  "TUR L0.XXX"},
        {40.95729,    29.1243435,     3, 4,  "TUR M0.XXX"},
        {40.95729,    29.2387015,     3, 4,  "TUR N0.XXX"},
        {40.870801,   29.098952125,   3, 4,  "TUR P0.XXX"},
        {40.870801,   29.212589125,   3, 4,  "TUR Q0.XXX"},
        {40.862152,   29.326226125,   4, 5,  "TUR R0.XXX"},
        {40.763294,   29.256873625,   3, 4,  "TUR S0.XXX"},
        {40.752485,   29.350289625,   3, 4,  "TUR T0.XXX"},
        {40.838295,   29.445834625,   3, 4,  "TUR V0.XXX"},
        {40.188404,   28.916103625,   3, 4,  "TUR W0.XXX"},
        {40.168795,   29.029717625,   3, 4,  "TUR X0.XXX"},
        {36.961785,   35.242322625,   2, 3,  "TUR Y0.XXX"},
        {36.964648,   35.332233125,   2, 3,  "TUR Z0.XXX"},
        {37.106924,   37.324063125,   3, 5,  "TUR 000.XX"},
        {37.911224,   32.442185875,   3, 4,  "TUR 100.XX"},
        {36.948724,   30.645263125,   3, 4,  "TUR 200.XX"},
        {37.970124,   40.140185875,   2, 3,  "TUR 300.XX"},
        {36.856424,   34.576663125,   3, 4,  "TUR 400.XX"},
        {38.776524,   35.428033375,   3, 4,  "TUR 500.XX"},
        {39.790334,   30.446290625,   3, 4,  "TUR 600.XX"},
        {37.211145,   38.759544625,   3, 5,  "TUR 700.XX"},
        {41.336324,   36.2716125,     3, 4,  "TUR 800.XX"},
        {38.396124,   38.251633375,   3, 4,  "TUR 900.XX"},
        {37.589045,   36.8172825,     3, 4,  "TUR B00.XX"},
        {38.541224,   43.320333375,   3, 4,  "TUR C00.XX"},
        {40.799224,   30.325851125,   3, 4,  "TUR D00.XX"},
        {37.812924,   29.0253245,     3, 4,  "TUR F00.XX"},
        {38.694045,   39.126849875,   3, 4,  "TUR G00.XX"},
        {39.780724,   36.951455125,   3, 4,  "TUR H00.XX"},
        {39.686324,   27.842855125,   3, 4,  "TUR J00.XX"},
        {38.651545,   27.315649875,   3, 4,  "TUR K00.XX"},
        {40.772945,   29.750976625,   3, 4,  "TUR L00.XX"},
        {39.435545,   29.934290625,   3, 4,  "TUR M00.XX"},
        {36.245124,   36.120641375,   3, 6,  "TUR N00.XX"},
        {39.935345,   41.235493125,   3, 4,  "TUR P00.XX"},
        {36.945415,   34.853229875,   3, 4,  "TUR PK0.00"},
        {40.998545,   39.6542975,     3, 4,  "TUR Q00.XX"},
        {39.828465,   33.480254375,   3, 4,  "TUR QK0.00"},
        {37.773545,   38.2050825,     3, 4,  "TUR R00.XX"},
        {37.788745,   30.5140715,     3, 4,  "TUR RK0.00"},
        {37.897864,   41.090527625,   3, 4,  "TUR S00.XX"},
        {37.068104,   36.219204125,   3, 5,  "TUR SK0.00"},
        {40.561164,   34.917881375,   3, 4,  "TUR T00.XX"},
        {36.560004,   36.13472075,    3, 6,  "TUR TK0.00"},
        {37.844864,   27.801627625,   3, 4,  "TUR V00.XX"},
        {38.665604,   29.374980375,   3, 4,  "TUR VK0.00"},
        {41.179464,   27.7600235,     3, 4,  "TUR W00.XX"},
        {38.362804,   33.984380375,   3, 4,  "TUR WK0.00"},
        {38.767664,   30.511184125,   3, 4,  "TUR X00.XX"},
        {37.227004,   39.729004125,   3, 7,  "TUR XK0.00"},
        {37.765264,   39.2826845,     3, 4,  "TUR Y00.XX"},
        {41.667304,   26.52856,       3, 6,  "TUR YK0.00"},
        {40.102564,   29.463424875,   3, 4,  "TUR Z00.XX"},
        {37.184104,   40.557504125,   3, 7,  "TUR ZK0.00"},
        {39.3356185,  26.340384,      2, 5,  "TUR 123.XXX"},
        {41.808438,   26.671155,      2, 5,  "TUR 12.XXXX"},
        {36.666679,   36.9617225,     2, 5,  "TUR 0123.XX"},
        {37.486114,   32.3509005,     2, 3,  "TUR 1123.XX"},
        {36.676579,   30.4153225,     2, 3,  "TUR 2123.XX"},
        {37.655564,   40.1449715,     2, 3,  "TUR 3123.XX"},
        {36.640249,   34.4620225,     2, 3,  "TUR 4123.XX"},
        {38.504379,   35.186288,      2, 3,  "TUR 5123.XX"},
        {39.359259,   29.903327,      2, 3,  "TUR 6123.XX"},
        {36.858985,   38.306459,      2, 5,  "TUR 7123.XX"},
        {41.198664,   35.8063185,     2, 3,  "TUR 8123.XX"},
        {38.123979,   38.0176715,     2, 3,  "TUR 9123.XX"},
        {37.172935,   36.379919,      2, 4,  "TUR B123.XX"},
        {38.269079,   43.0863715,     2, 3,  "TUR C123.XX"},
        {40.524364,   30.075386,      2, 3,  "TUR D123.XX"},
        {38.44433,    38.846438,      2, 3,  "TUR F123.XX"},
        {39.505864,   36.705237,      2, 3,  "TUR G123.XX"},
        {36.153729,   36.06519,       2, 5,  "TUR H123.XX"},
        {39.674365,   40.947287,      2, 3,  "TUR J123.XX"},
        {40.775544,   39.319636,      2, 3,  "TUR K123.XX"},
        {39.531685,   33.255347,      2, 3,  "TUR L123.XX"},
        {37.530794,   38.1231815,     2, 3,  "TUR M123.XX"},
        {37.519185,   30.1138415,     2, 3,  "TUR N123.XX"},
        {37.786279,   40.7839715,     2, 3,  "TUR P123.XX"},
        {36.732864,   35.771539,      2, 5,  "TUR Q123.XX"},
        {40.480214,   34.900336,      2, 3,  "TUR R123.XX"},
        {38.137279,   33.7317715,     2, 3,  "TUR S123.XX"},
        {38.511179,   30.501688,      2, 3,  "TUR T123.XX"},
        {36.998764,   39.473039,      2, 5,  "TUR V123.XX"},
        {37.518664,   39.0356715,     2, 3,  "TUR W123.XX"},
        {37.025864,   40.396619,      2, 6,  "TUR X123.XX"},
        {40.250864,   36.0238695,     2, 3,  "TUR Y123.XX"},
        {40.720864,   37.831086,      2, 3,  "TUR Z123.XX"},
        {36.557699,   26.315517,      1, 5,  "TUR 1234.XXX"},
        {24.889045,   66.9735575,     5, 6,  "PAK 12.XX"},
        {25.001865,   66.8894515,     4, 5,  "PAK 00.XXX"},
        {31.648055,   74.1467245,     4, 11, "PAK J0.XXX"},
        {31.527941,   72.9858885,     4, 6,  "PAK 000.XX"},
        {31.527941,   73.0867925,     4, 6,  "PAK 100.XX"},
        {31.441452,   72.9858885,     4, 6,  "PAK 200.XX"},
        {31.441452,   73.0867925,     4, 6,  "PAK 300.XX"},
        {33.735134,   72.96327,       4, 6,  "PAK 400.XX"},
        {33.679545,   72.96327,       4, 6,  "PAK 500.XX"},
        {33.622545,   72.96727,       4, 6,  "PAK 600.XX"},
        {33.566545,   72.995268125,   4, 6,  "PAK 700.XX"},
        {30.237224,   71.428105875,   4, 6,  "PAK 800.XX"},
        {25.414534,   68.31314875,    5, 8,  "PAK 900.XX"},
        {32.189834,   74.136925,      4, 10, "PAK B00.XX"},
        {34.022145,   71.494176,      4, 6,  "PAK C00.XX"},
        {30.212334,   66.949259375,   4, 6,  "PAK D00.XX"},
        {32.106434,   72.632265,      4, 6,  "PAK F00.XX"},
        {32.535034,   74.488132,      4, 11, "PAK G00.XX"},
        {29.408545,   71.625785875,   5, 7,  "PAK H00.XX"},
        {27.729434,   68.809753125,   4, 5,  "PAK J00.XX"},
        {31.310434,   72.2805105,     4, 6,  "PAK K00.XX"},
        {31.742934,   73.93677175,    4, 11, "PAK L00.XX"},
        {27.583045,   68.159253125,   4, 5,  "PAK M00.XX"},
        {32.610234,   74.020673875,   4, 11, "PAK N00.XX"},
        {34.231734,   71.988117875,   4, 6,  "PAK P00.XX"},
        {31.149834,   74.3998105,     4, 11, "PAK Q00.XX"},
        {28.449134,   70.256224625,   5, 6,  "PAK R00.XX"},
        {30.699834,   73.057068625,   4, 8,  "PAK S00.XX"},
        {30.834934,   73.401068625,   4, 8,  "PAK T00.XX"},
        {33.799834,   72.698376,      4, 6,  "PAK V00.XX"},
        {30.079634,   70.601259375,   5, 7,  "PAK W00.XX"},
        {25.535545,   68.97622175,    5, 8,  "PAK X00.XX"},
        {26.243224,   68.377246375,   6, 7,  "PAK XK0.00"},
        {34.797594,   72.322582125,   3, 5,  "PAK Y00.XX"},
        {31.722504,   72.95115225,    4, 6,  "PAK YK0.00"},
        {31.993694,   74.18006675,    4, 11, "PAK Z00.XX"},
        {30.161104,   72.647961125,   5, 11, "PAK ZK0.00"},
        {31.337523,   72.291133,      3, 5,  "PAK 123.XXX"},
        {25.013828,   66.8887535,     3, 4,  "PAK 12.XXXX"},
        {27.697465,   69.0792785,     3, 4,  "PAK 1123.XX"},
        {27.93048,    68.2988785,     3, 4,  "PAK 2123.XX"},
        {28.13288,    69.8656785,     4, 9,  "PAK 3123.XX"},
        {28.470165,   70.380699,      4, 5,  "PAK 4123.XX"},
        {28.91718,    70.884799,      5, 6,  "PAK 5123.XX"},
        {29.08018,    71.460099,      4, 5,  "PAK 6123.XX"},
        {29.811565,   72.2632275,     4, 10, "PAK 7123.XX"},
        {29.800065,   70.2474275,     4, 6,  "PAK 8123.XX"},
        {29.843765,   70.7810275,     4, 6,  "PAK 9123.XX"},
        {30.02908,    71.4518275,     4, 6,  "PAK B123.XX"},
        {29.93848,    66.6746265,     3, 5,  "PAK C123.XX"},
        {30.14798,    71.9116275,     5, 7,  "PAK D123.XX"},
        {30.762265,   70.615848,      3, 5,  "PAK F123.XX"},
        {33.597465,   71.158646,      3, 5,  "PAK G123.XX"},
        {33.800265,   71.715246,      4, 6,  "PAK H123.XX"},
        {29.27752,    67.569635,      3, 4,  "PAK P123.XX"},
        {32.308048,   71.291938,      3, 5,  "PAK Q123.XX"},
        {31.590145,   70.5665275,     3, 5,  "PAK R123.XX"},
        {36.8992995,  70.6243195,     2, 5,  "PAK 5123.XXX"},
        {34.2181095,  67.463076,      2, 5,  "PAK 6123.XXX"},
        {34.2181095,  70.591131,      2, 4,  "PAK 7123.XXX"},
        {29.6528665,  61.0261675,     2, 7,  "PAK B123.XXX"},
        {29.131144,   66.2110205,     2, 3,  "PAK D123.XXX"},
        {31.5369195,  68.7603475,     2, 4,  "PAK F123.XXX"},
        {31.5369195,  71.7990295,     2, 4,  "PAK G123.XXX"},
        {28.8394135,  61.5552335,     2, 6,  "PAK H123.XXX"},
        {28.8394135,  64.5343335,     2, 3,  "PAK K123.XXX"},
        {28.8394135,  67.5134335,     2, 3,  "PAK L123.XXX"},
        {30.1800085,  69.89784,       3, 5,  "PAK M123.XXX"},
        {26.3058945,  61.648923,      3, 6,  "PAK N123.XXX"},
        {26.3058945,  64.53865,       3, 4,  "PAK P123.XXX"},
        {26.3058945,  67.428377,      4, 5,  "PAK Q123.XXX"},
        {26.6944615,  68.3238735,     4, 5,  "PAK R123.XXX"},
        {34.452256,   72.512561,      3, 9,  "PAK 0123.XXX"},
        {34.452256,   75.012561,      2, 10, "PAK 1123.XXX"},
        {33.897648,   77.5079215,     2, 9,  "PAK 2123.XXX"},
        {33.8031485,  73.545259,      4, 11, "PAK 3123.XXX"},
        {33.8031485,  76.673314,      2, 8,  "PAK 4123.XXX"},
        {24.853945,   67.0152365,     5, 6,  "PAK 9XQ8.H97K"},
        {-25.905386,  32.5402175,     3, 6,  "MOZ 12.XX"},
        {-25.707027,  32.2643005,     2, 5,  "MOZ 12.XXX"},
        {-19.768076,  34.83183475,    3, 4,  "MOZ 000.XX"},
        {-19.681587,  34.80430175,    3, 4,  "MOZ 100.XX"},
        {-15.063376,  39.1666645,     3, 4,  "MOZ 200.XX"},
        {-15.089322,  39.2560365,     3, 4,  "MOZ 300.XX"},
        {-19.080976,  33.4262605,     3, 4,  "MOZ 400.XX"},
        {-14.476255,  40.660731875,   3, 4,  "MOZ 500.XX"},
        {-14.504776,  40.564077375,   3, 4,  "MOZ 600.XX"},
        {-17.812076,  36.855399125,   3, 4,  "MOZ 700.XX"},
        {-16.126776,  33.55403875,    3, 5,  "MOZ 800.XX"},
        {-25.027645,  33.6320475,     3, 4,  "MOZ 900.XX"},
        {-15.438676,  36.934451625,   3, 4,  "MOZ B00.XX"},
        {-23.819876,  35.262791125,   3, 4,  "MOZ C00.XX"},
        {-13.257455,  35.22073125,    3, 4,  "MOZ D00.XX"},
        {-12.949976,  40.482203125,   3, 4,  "MOZ F00.XX"},
        {-19.572076,  34.68933475,    3, 4,  "MOZ G00.XX"},
        {-16.162076,  39.88703875,    3, 4,  "MOZ H00.XX"},
        {-14.759576,  36.4937645,     3, 4,  "MOZ J00.XX"},
        {-13.086476,  38.975603125,   3, 4,  "MOZ K00.XX"},
        {-16.810776,  38.222512,      3, 4,  "MOZ L00.XX"},
        {-23.856106,  35.376349625,   3, 4,  "MOZ M00.XX"},
        {-24.531096,  32.95448425,    3, 6,  "MOZ MK0.00"},
        {-24.678636,  33.5082935,     3, 4,  "MOZ N00.XX"},
        {-15.038415,  40.6224675,     4, 5,  "MOZ NK0.00"},
        {-18.925155,  32.8394625,     3, 6,  "MOZ P00.XX"},
        {-24.715896,  34.7013395,     3, 4,  "MOZ PK0.00"},
        {-15.001455,  40.5991475,     3, 4,  "MOZ Q00.XX"},
        {-24.486596,  34.98858425,    3, 4,  "MOZ QK0.00"},
        {-24.061136,  34.698451375,   3, 4,  "MOZ R00.XX"},
        {-25.037496,  33.0762395,     3, 4,  "MOZ RK0.00"},
        {-13.188636,  37.47112675,    3, 4,  "MOZ S00.XX"},
        {-25.016296,  33.7650395,     3, 4,  "MOZ SK0.00"},
        {-23.887536,  35.124851375,   3, 4,  "MOZ T00.XX"},
        {-25.405896,  32.77119475,    3, 6,  "MOZ TK0.00"},
        {-26.332036,  32.619664375,   3, 6,  "MOZ V00.XX"},
        {-25.035496,  32.6355395,     3, 6,  "MOZ VK0.00"},
        {-15.611436,  30.405968875,   3, 6,  "MOZ W00.XX"},
        {-24.106196,  35.267157125,   3, 4,  "MOZ WK0.00"},
        {-12.726936,  34.937712375,   3, 4,  "MOZ X00.XX"},
        {-25.605596,  32.21019475,    3, 6,  "MOZ XK0.00"},
        {-14.346336,  35.599641125,   3, 7,  "MOZ Y00.XX"},
        {-25.978996,  31.986222875,   3, 8,  "MOZ YK0.00"},
        {-24.895136,  34.1503935,     3, 4,  "MOZ Z00.XX"},
        {-24.710796,  33.8554395,     3, 4,  "MOZ ZK0.00"},
        {-24.212585,  32.0284545,     2, 5,  "MOZ 123.XXX"},
        {-19.0035735, 32.856492,      2, 5,  "MOZ 12.XXXX"},
        {-26.59022,   32.3086295,     2, 5,  "MOZ 0123.XX"},
        {-15.351135,  39.0190825,     2, 3,  "MOZ 1123.XX"},
        {-18.086935,  36.655903,      2, 3,  "MOZ 2123.XX"},
        {-16.39892,   33.3619825,     2, 4,  "MOZ 3123.XX"},
        {-15.713535,  36.7422825,     2, 3,  "MOZ 4123.XX"},
        {-13.532635,  35.018754,      2, 5,  "MOZ 5123.XX"},
        {-16.43422,   39.6949825,     2, 3,  "MOZ 6123.XX"},
        {-15.03172,   36.298854,      2, 3,  "MOZ 7123.XX"},
        {-13.361335,  38.780354,      2, 3,  "MOZ 8123.XX"},
        {-17.08292,   38.0306825,     2, 3,  "MOZ 9123.XX"},
        {-26.20902,   31.7309295,     2, 6,  "MOZ B123.XX"},
        {-13.435235,  37.265954,      2, 3,  "MOZ C123.XX"},
        {-15.860935,  30.3622825,     2, 5,  "MOZ D123.XX"},
        {-12.973535,  34.732454,      2, 3,  "MOZ F123.XX"},
        {-14.54382,   35.508454,      2, 6,  "MOZ G123.XX"},
        {-15.858874,  40.1984485,     2, 3,  "MOZ K123.XX"},
        {-15.367834,  40.3582825,     2, 3,  "MOZ L123.XX"},
        {-14.874079,  40.363097,      2, 3,  "MOZ M123.XX"},
        {-14.383039,  40.315183,      2, 3,  "MOZ N123.XX"},
        {-13.891999,  40.157068,      2, 3,  "MOZ P123.XX"},
        {-13.403674,  40.123529,      2, 3,  "MOZ Q123.XX"},
        {-12.912634,  40.171443,      2, 3,  "MOZ R123.XX"},
        {-12.418879,  40.1526655,     2, 3,  "MOZ S123.XX"},
        {-11.927839,  40.1526655,     2, 3,  "MOZ T123.XX"},
        {-11.436799,  40.1526655,     2, 4,  "MOZ V123.XX"},
        {-10.945759,  40.1526655,     2, 4,  "MOZ W123.XX"},
        {-18.869613,  30.5891385,     1, 4,  "MOZ 1234.XXX"},
        {-22.5239,    17.0426435,     4, 7,  "NAM 12.XX"},
        {-22.466706,  16.8972935,     3, 6,  "NAM 00.XXX"},
        {-18.009386,  19.60939175,    2, 4,  "NAM J0.XXX"},
        {-17.741976,  15.642199125,   3, 5,  "NAM 000.XX"},
        {-17.741976,  15.732772125,   3, 5,  "NAM 100.XX"},
        {-22.914276,  14.47003075,    3, 4,  "NAM 200.XX"},
        {-22.618476,  14.51593075,    3, 4,  "NAM 300.XX"},
        {-17.479176,  24.242999125,   3, 6,  "NAM 400.XX"},
        {-19.530176,  18.06953475,    3, 4,  "NAM 500.XX"},
        {-23.278376,  17.034217875,   3, 6,  "NAM 600.XX"},
        {-20.426576,  16.616721875,   3, 4,  "NAM 700.XX"},
        {-21.955176,  16.871169375,   3, 4,  "NAM 800.XX"},
        {-26.537876,  18.092187125,   3, 6,  "NAM 900.XX"},
        {-22.420476,  18.9347565,     3, 6,  "NAM B00.XX"},
        {-19.200776,  17.6645605,     3, 4,  "NAM C00.XX"},
        {-26.611776,  15.104187125,   3, 4,  "NAM D00.XX"},
        {-24.584376,  17.91687825,    3, 6,  "NAM F00.XX"},
        {-17.862376,  15.93668625,    3, 5,  "NAM G00.XX"},
        {-20.342076,  14.903021875,   3, 4,  "NAM H00.XX"},
        {-28.524076,  16.358583125,   3, 4,  "NAM J00.XX"},
        {-20.544976,  17.398608,      3, 4,  "NAM K00.XX"},
        {-20.065576,  16.116921875,   3, 4,  "NAM L00.XX"},
        {-22.389276,  14.9461565,     3, 4,  "NAM M00.XX"},
        {-26.459276,  17.104687125,   3, 6,  "NAM N00.XX"},
        {-21.389276,  15.90638225,    3, 4,  "NAM P00.XX"},
        {-27.977676,  18.711009875,   3, 6,  "NAM Q00.XX"},
        {-18.011576,  13.79478625,    3, 5,  "NAM R00.XX"},
        {-21.889576,  15.813369375,   3, 4,  "NAM S00.XX"},
        {-19.627536,  17.30719625,    3, 4,  "NAM T00.XX"},
        {-22.005896,  15.551991375,   3, 4,  "NAM TK0.00"},
        {-22.347536,  16.0866805,     3, 4,  "NAM V00.XX"},
        {-24.155896,  19.07148425,    3, 6,  "NAM VK0.00"},
        {-17.465536,  16.301525375,   3, 5,  "NAM W00.XX"},
        {-17.904396,  15.04274225,    3, 5,  "NAM WK0.00"},
        {-17.504836,  14.950325375,   3, 5,  "NAM X00.XX"},
        {-17.413896,  15.867915125,   3, 5,  "NAM XK0.00"},
        {-24.817636,  16.9519935,     3, 6,  "NAM Y00.XX"},
        {-28.445896,  18.700399125,   3, 6,  "NAM YK0.00"},
        {-22.107536,  14.2466805,     3, 4,  "NAM Z00.XX"},
        {-24.078496,  17.555357125,   3, 6,  "NAM ZK0.00"},
        {-17.81936,   15.0566755,     2, 4,  "NAM 123.XXX"},
        {-22.868195,  14.3925415,     2, 3,  "NAM 12.XXXX"},
        {-17.918435,  24.038203,      2, 6,  "NAM 0123.XX"},
        {-26.909135,  14.809949,      2, 3,  "NAM 1123.XX"},
        {-26.909135,  15.33075,       2, 3,  "NAM 2123.XX"},
        {-26.909135,  15.851549,      2, 3,  "NAM 3123.XX"},
        {-26.909135,  16.37235,       2, 3,  "NAM 4123.XX"},
        {-26.909135,  16.89315,       2, 5,  "NAM 5123.XX"},
        {-26.909135,  17.41395,       2, 5,  "NAM 6123.XX"},
        {-20.69872,   16.4205315,     2, 3,  "NAM 7123.XX"},
        {-22.695335,  18.7339805,     2, 5,  "NAM 8123.XX"},
        {-20.60312,   14.8044315,     2, 3,  "NAM 9123.XX"},
        {-28.66352,   16.1895775,     2, 3,  "NAM B123.XX"},
        {-20.88362,   17.2995315,     2, 3,  "NAM C123.XX"},
        {-20.33772,   15.9207315,     2, 3,  "NAM D123.XX"},
        {-21.66142,   15.702752,      2, 3,  "NAM F123.XX"},
        {-18.286435,  13.595403,      2, 3,  "NAM G123.XX"},
        {-24.384135,  18.847601,      2, 5,  "NAM H123.XX"},
        {-25.06152,   16.733601,      2, 5,  "NAM J123.XX"},
        {-24.306735,  17.331401,      2, 5,  "NAM K123.XX"},
        {-24.85652,   17.709001,      2, 5,  "NAM L123.XX"},
        {-25.350274,  17.7090295,     2, 5,  "NAM M123.XX"},
        {-25.838599,  17.7090295,     2, 5,  "NAM N123.XX"},
        {-26.329639,  17.8637065,     2, 5,  "NAM P123.XX"},
        {-26.823394,  17.935866,      2, 5,  "NAM Q123.XX"},
        {-27.311719,  18.378546,      2, 5,  "NAM R123.XX"},
        {-27.805474,  18.1702545,     2, 5,  "NAM S123.XX"},
        {-28.252535,  18.5020785,     3, 6,  "NAM T123.XX"},
        {-28.71982,   18.4860785,     2, 5,  "NAM V123.XX"},
        {-17.786156,  12.209354,      1, 3,  "NAM 1234.XXX"},
        {10.493705,   -66.9450255,    4, 7,  "VEN 12.XX"},
        {10.448035,   -67.06745525,   3, 6,  "VEN 00.XXX"},
        {10.252815,   -67.73085625,   3, 6,  "VEN C0.XXX"},
        {10.119965,   -68.11530525,   3, 6,  "VEN P0.XXX"},
        {10.715924,   -71.75885725,   3, 6,  "VEN 000.XX"},
        {10.715924,   -71.67092725,   3, 6,  "VEN 100.XX"},
        {10.629435,   -71.69290925,   3, 6,  "VEN 200.XX"},
        {10.097545,   -69.39277125,   3, 6,  "VEN 300.XX"},
        {8.379265,    -62.696873125,  3, 4,  "VEN 400.XX"},
        {10.147545,   -64.71421125,   3, 4,  "VEN 500.XX"},
        {9.765245,    -63.216771875,  3, 4,  "VEN 600.XX"},
        {10.254624,   -64.65945725,   3, 4,  "VEN 700.XX"},
        {8.132795,    -63.596873125,  3, 4,  "VEN 800.XX"},
        {10.466545,   -64.19977125,   3, 4,  "VEN 900.XX"},
        {8.620234,    -71.2009975,    3, 6,  "VEN B00.XX"},
        {8.648034,    -70.2570725,    3, 6,  "VEN C00.XX"},
        {7.848545,    -72.244773125,  2, 5,  "VEN D00.XX"},
        {10.477545,   -66.64547125,   3, 4,  "VEN F00.XX"},
        {10.402904,   -71.47581975,   3, 6,  "VEN FK0.00"},
        {10.211545,   -64.71417125,   3, 4,  "VEN G00.XX"},
        {10.453145,   -68.06802175,   3, 6,  "VEN GK0.00"},
        {9.573045,    -69.227771875,  3, 6,  "VEN H00.XX"},
        {10.229585,   -66.71157075,   3, 4,  "VEN HK0.00"},
        {11.413945,   -69.704423625,  2, 5,  "VEN J00.XX"},
        {9.354945,    -70.6215815,    3, 6,  "VEN JK0.00"},
        {10.483845,   -66.56437125,   4, 5,  "VEN K00.XX"},
        {9.030185,    -69.7740435,    3, 6,  "VEN KK0.00"},
        {8.899905,    -64.2830675,    3, 4,  "VEN L00.XX"},
        {10.139944,   -66.80113175,   3, 4,  "VEN LK0.00"},
        {10.661345,   -63.29427125,   3, 4,  "VEN M00.XX"},
        {10.175104,   -66.91108075,   3, 6,  "VEN MK0.00"},
        {8.928394,    -67.4562675,    3, 6,  "VEN N00.XX"},
        {11.716745,   -70.219208875,  2, 5,  "VEN NK0.00"},
        {10.256794,   -66.88283825,   3, 6,  "VEN P00.XX"},
        {10.157864,   -70.09681975,   3, 6,  "VEN PK0.00"},
        {7.885545,    -67.511213125,  2, 5,  "VEN Q00.XX"},
        {9.201985,    -66.0324955,    2, 3,  "VEN QK0.00"},
        {9.923694,    -67.387952875,  3, 6,  "VEN R00.XX"},
        {10.996684,   -63.86713075,   2, 3,  "VEN RK0.00"},
        {9.944494,    -69.649752875,  3, 6,  "VEN S00.XX"},
        {9.452335,    -64.4990415,    3, 4,  "VEN SK0.00"},
        {10.346545,   -68.79393125,   3, 6,  "VEN T00.XX"},
        {10.034775,   -69.29932375,   3, 6,  "VEN TK0.00"},
        {9.678194,    -68.617552875,  3, 6,  "VEN V00.XX"},
        {9.903495,    -68.335007625,  3, 6,  "VEN VK0.00"},
        {8.632045,    -71.6844725,    3, 6,  "VEN W00.XX"},
        {10.203704,   -71.33618075,   3, 6,  "VEN WK0.00"},
        {8.578194,    -71.2540675,    3, 6,  "VEN X00.XX"},
        {7.694604,    -72.388262375,  2, 6,  "VEN XK0.00"},
        {10.093494,   -69.15433825,   3, 6,  "VEN Y00.XX"},
        {10.042204,   -67.52498075,   3, 6,  "VEN YK0.00"},
        {5.671794,    -67.63557375,   2, 5,  "VEN Z00.XX"},
        {10.069904,   -67.81718075,   3, 6,  "VEN ZK0.00"},
        {9.838435,    -69.6983765,    2, 5,  "VEN 123.XXX"},
        {10.599605,   -64.762825,     2, 3,  "VEN 12.XXXX"},
        {10.90626,    -72.412412,     2, 5,  "VEN 1234.XX"},
        {11.3953815,  -72.8987595,    1, 5,  "VEN 1234.XXX"},
        {6.4212275,   3.3332955,      4, 5,  "NGA 12.XX"},
        {6.700895,    3.16881925,     3, 4,  "NGA 00.XXX"},
        {7.502655,    3.747302125,    3, 4,  "NGA C0.XXX"},
        {12.093384,   8.389503625,    3, 6,  "NGA P0.XXX"},
        {10.594324,   7.35794275,     3, 4,  "NGA 000.XX"},
        {10.594324,   7.44587275,     3, 4,  "NGA 100.XX"},
        {10.507835,   7.35794275,     3, 4,  "NGA 200.XX"},
        {10.507835,   7.44587275,     3, 4,  "NGA 300.XX"},
        {6.423419,    5.54742025,     3, 4,  "NGA 400.XX"},
        {6.423419,    5.63438925,     3, 4,  "NGA 500.XX"},
        {6.33693,     5.54742025,     3, 4,  "NGA 600.XX"},
        {6.33693,     5.63438925,     3, 4,  "NGA 700.XX"},
        {4.847651,    6.972704125,    3, 4,  "NGA 800.XX"},
        {11.880824,   13.116729875,   3, 6,  "NGA 900.XX"},
        {11.127645,   7.673229375,    3, 4,  "NGA B00.XX"},
        {5.147725,    7.326208125,    3, 4,  "NGA C00.XX"},
        {9.95838,     8.844326625,    3, 5,  "NGA D00.XX"},
        {8.529984,    4.5090645,      3, 4,  "NGA F00.XX"},
        {6.492744,    7.47452125,     3, 4,  "NGA G00.XX"},
        {7.197414,    3.303184375,    3, 4,  "NGA H00.XX"},
        {6.187395,    6.76191225,     3, 4,  "NGA J00.XX"},
        {9.097145,    7.4490205,      3, 4,  "NGA K00.XX"},
        {5.547386,    5.72919875,     3, 4,  "NGA L00.XX"},
        {8.125363,    4.214744375,    3, 4,  "NGA LK0.00"},
        {7.858835,    3.905259125,    3, 4,  "NGA M00.XX"},
        {13.045004,   5.217494125,    3, 6,  "NGA MK0.00"},
        {7.567736,    6.195072125,    3, 4,  "NGA N00.XX"},
        {4.938744,    8.310264125,    3, 4,  "NGA NK0.00"},
        {5.017223,    8.312624375,    3, 4,  "NGA P00.XX"},
        {7.763761,    4.531279375,    3, 4,  "NGA PK0.00"},
        {12.998964,   7.576812375,    3, 5,  "NGA Q00.XX"},
        {7.238887,    5.161775375,    3, 4,  "NGA QK0.00"},
        {7.489709,    4.524929125,    3, 4,  "NGA R00.XX"},
        {10.306404,   9.80811075,     3, 5,  "NGA RK0.00"},
        {7.983981,    3.565869125,    3, 4,  "NGA S00.XX"},
        {9.602962,    6.525085625,    3, 4,  "NGA SK0.00"},
        {7.743262,    8.495055125,    3, 5,  "NGA T00.XX"},
        {7.620899,    4.720363375,    3, 4,  "NGA TK0.00"},
        {7.20754,     5.557563125,    3, 4,  "NGA V00.XX"},
        {10.280504,   11.15021075,    3, 5,  "NGA VK0.00"},
        {7.103828,    4.805803125,    3, 4,  "NGA W00.XX"},
        {11.739904,   11.933538875,   3, 6,  "NGA WK0.00"},
        {9.271164,    12.4146415,     3, 5,  "NGA X00.XX"},
        {7.629722,    4.160276375,    3, 4,  "NGA XK0.00"},
        {5.196188,    7.680807375,    3, 4,  "NGA Y00.XX"},
        {12.162504,   6.646566,       3, 5,  "NGA YK0.00"},
        {10.282464,   13.23857025,    3, 6,  "NGA Z00.XX"},
        {6.618312,    3.48190925,     3, 4,  "NGA ZK0.00"},
        {8.9253005,   2.9415975,      2, 3,  "NGA 123.XXX"},
        {5.9719685,   5.6830815,      2, 3,  "NGA 12.XXXX"},
        {7.441535,    6.518551,       2, 3,  "NGA 0123.XX"},
        {11.76858,    8.2783335,      2, 4,  "NGA 1123.XX"},
        {10.25158,    7.1954335,      2, 3,  "NGA 2123.XX"},
        {11.60868,    12.9290335,     2, 4,  "NGA 3123.XX"},
        {11.07768,    7.2839335,      2, 3,  "NGA 4123.XX"},
        {9.68352,     8.6564125,      2, 4,  "NGA 5123.XX"},
        {12.815865,   5.008954,       2, 4,  "NGA 6123.XX"},
        {7.42749,     5.956148,       3, 4,  "NGA 7123.XX"},
        {12.741265,   7.480554,       2, 4,  "NGA 8123.XX"},
        {10.16218,    9.7313335,      2, 4,  "NGA 9123.XX"},
        {9.460805,    6.1379175,      2, 3,  "NGA B123.XX"},
        {7.29922,     8.456096,       2, 4,  "NGA C123.XX"},
        {7.104937,    5.507943,       3, 4,  "NGA D123.XX"},
        {8.84842,     7.4034985,      2, 3,  "NGA F123.XX"},
        {10.01058,    10.9570335,     2, 4,  "NGA G123.XX"},
        {11.51698,    11.8760335,     2, 4,  "NGA H123.XX"},
        {9.087265,    12.1823335,     2, 4,  "NGA J123.XX"},
        {11.89488,    6.5247335,      2, 4,  "NGA K123.XX"},
        {9.99278,     12.8887335,     2, 4,  "NGA L123.XX"},
        {8.818009,    5.9105265,      2, 3,  "NGA M123.XX"},
        {8.904992,    6.9435945,      2, 3,  "NGA N123.XX"},
        {6.427243,    8.767228,       2, 4,  "NGA P123.XX"},
        {8.963917,    3.6293825,      3, 4,  "NGA Q123.XX"},
        {8.246485,    8.333956,       2, 3,  "NGA R123.XX"},
        {12.654865,   10.842754,      2, 5,  "NGA S123.XX"},
        {8.655865,    11.1408335,     2, 4,  "NGA T123.XX"},
        {11.26808,    13.3827335,     2, 5,  "NGA V123.XX"},
        {6.528737,    5.930966,       3, 4,  "NGA W123.XX"},
        {6.623023,    7.099894,       2, 3,  "NGA X123.XX"},
        {12.435865,   10.008054,      2, 5,  "NGA Y123.XX"},
        {11.24838,    9.8555335,      2, 4,  "NGA Z123.XX"},
        {13.2190535,  3.1001055,      1, 4,  "NGA 1234.XXX"},
        {-6.787625,   39.217647,      4, 5,  "TZA 12.XX"},
        {-6.710406,   39.10673775,    3, 4,  "TZA 00.XXX"},
        {-2.510286,   32.86653,       3, 4,  "TZA J0.XXX"},
        {-6.069076,   39.21039425,    3, 4,  "TZA 000.XX"},
        {-6.155565,   39.18778225,    3, 4,  "TZA 100.XX"},
        {-8.868676,   33.4057685,     3, 5,  "TZA 200.XX"},
        {-8.868676,   33.4932185,     3, 5,  "TZA 300.XX"},
        {-3.339576,   36.645507125,   3, 5,  "TZA 400.XX"},
        {-6.763876,   37.62269425,    3, 4,  "TZA 500.XX"},
        {-5.055876,   39.050207125,   3, 4,  "TZA 600.XX"},
        {-6.129276,   35.69909425,    3, 4,  "TZA 700.XX"},
        {-4.841076,   29.610707125,   3, 4,  "TZA 800.XX"},
        {-3.305676,   37.298607125,   3, 5,  "TZA 900.XX"},
        {-4.980176,   32.772607125,   3, 4,  "TZA B00.XX"},
        {-10.620976,  35.61084275,    3, 5,  "TZA C00.XX"},
        {-1.478276,   33.76272,       3, 5,  "TZA D00.XX"},
        {-7.729276,   35.648981375,   3, 4,  "TZA F00.XX"},
        {-9.261776,   32.7247685,     3, 6,  "TZA G00.XX"},
        {-3.618076,   33.379707125,   3, 4,  "TZA H00.XX"},
        {-10.235776,  40.14624275,    3, 4,  "TZA J00.XX"},
        {-5.076836,   30.361099375,   3, 4,  "TZA K00.XX"},
        {-6.841396,   36.96880025,    3, 4,  "TZA KK0.00"},
        {-3.450036,   31.865599375,   3, 4,  "TZA L00.XX"},
        {-7.966596,   31.596628375,   3, 4,  "TZA LK0.00"},
        {-6.425136,   38.85901375,    3, 4,  "TZA M00.XX"},
        {-1.334096,   31.781745,      3, 5,  "TZA MK0.00"},
        {-6.330536,   31.04321375,    3, 4,  "TZA N00.XX"},
        {-4.824296,   34.725573125,   3, 4,  "TZA NK0.00"},
        {-4.980836,   29.965999375,   3, 4,  "TZA P00.XX"},
        {-8.858596,   34.8004555,     3, 4,  "TZA PK0.00"},
        {-2.637536,   32.609085,      3, 4,  "TZA Q00.XX"},
        {-3.010096,   31.903245,      3, 4,  "TZA QK0.00"},
        {-2.002836,   33.838685,      3, 4,  "TZA R00.XX"},
        {-8.123496,   36.657228375,   3, 4,  "TZA RK0.00"},
        {-9.325536,   34.7381415,     3, 4,  "TZA S00.XX"},
        {-10.002096,  39.67971075,    3, 4,  "TZA SK0.00"},
        {-9.093636,   32.9105415,     3, 5,  "TZA T00.XX"},
        {-6.151296,   36.83180025,    3, 4,  "TZA TK0.00"},
        {-7.679736,   36.948428125,   4, 5,  "TZA V00.XX"},
        {-5.128796,   31.019673125,   3, 4,  "TZA VK0.00"},
        {-10.710836,  38.77467025,    3, 5,  "TZA W00.XX"},
        {-5.162796,   38.414473125,   3, 4,  "TZA WK0.00"},
        {-4.562636,   30.085099375,   3, 4,  "TZA X00.XX"},
        {-10.940296,  39.24921075,    3, 5,  "TZA XK0.00"},
        {-2.837536,   33.049085,      3, 4,  "TZA Y00.XX"},
        {-8.799496,   35.7842555,     3, 4,  "TZA YK0.00"},
        {-8.281136,   35.258228125,   3, 4,  "TZA Z00.XX"},
        {-4.285896,   33.853873125,   3, 4,  "TZA ZK0.00"},
        {-2.7844305,  36.7646275,     2, 4,  "TZA 12.XXXX"},
        {-5.455485,   36.851145,      2, 3,  "TZA 123.XXX"},
        {-9.143535,   33.2614335,     2, 4,  "TZA 0123.XX"},
        {-6.40142,    35.508205,      2, 3,  "TZA 1123.XX"},
        {-5.165535,   29.586305,      2, 3,  "TZA 2123.XX"},
        {-5.255035,   32.581605,      2, 3,  "TZA 3123.XX"},
        {-10.89312,   35.4230335,     2, 4,  "TZA 4123.XX"},
        {-1.753135,   33.571605,      2, 3,  "TZA 5123.XX"},
        {-8.00142,    35.458205,      2, 3,  "TZA 6123.XX"},
        {-9.444535,   32.6185325,     2, 5,  "TZA 7123.XX"},
        {-3.892935,   33.188704,      2, 3,  "TZA 8123.XX"},
        {-10.53442,   39.9742455,     2, 4,  "TZA 9123.XX"},
        {-5.323435,   30.160305,      2, 3,  "TZA B123.XX"},
        {-3.696635,   31.664805,      2, 3,  "TZA C123.XX"},
        {-8.19212,    31.391105,      2, 4,  "TZA D123.XX"},
        {-1.562335,   31.576005,      2, 3,  "TZA F123.XX"},
        {-6.57442,    30.842505,      2, 3,  "TZA G123.XX"},
        {-5.052535,   34.519905,      2, 3,  "TZA H123.XX"},
        {-9.086835,   34.5976335,     2, 3,  "TZA J123.XX"},
        {-2.884135,   32.408205,      2, 3,  "TZA K123.XX"},
        {-3.238335,   31.697505,      3, 4,  "TZA L123.XX"},
        {-2.249434,   33.637805,      2, 3,  "TZA M123.XX"},
        {-8.13582,    36.600205,      2, 3,  "TZA N123.XX"},
        {-9.572135,   34.5402335,     2, 3,  "TZA P123.XX"},
        {-10.246435,  39.5190335,     2, 3,  "TZA Q123.XX"},
        {-5.357035,   30.814005,      2, 3,  "TZA R123.XX"},
        {-10.95472,   38.5769335,     2, 4,  "TZA S123.XX"},
        {-4.809235,   29.884305,      3, 4,  "TZA T123.XX"},
        {-11.16582,   39.0465335,     2, 4,  "TZA V123.XX"},
        {-3.151735,   32.857405,      2, 3,  "TZA W123.XX"},
        {-9.027735,   35.5814335,     2, 3,  "TZA X123.XX"},
        {-8.52502,    35.057605,      2, 3,  "TZA Y123.XX"},
        {-4.514135,   33.648205,      2, 3,  "TZA Z123.XX"},
        {-1.733636,   29.7287245,     1, 5,  "TZA 1234.XXX"},
        {30.0981,     31.2071175,     4, 5,  "EGY 12.XX"},
        {30.116875,   30.8884095,     3, 4,  "EGY 12.XXX"},
        {31.226424,   29.8570405,     3, 4,  "EGY 000.XX"},
        {31.286966,   29.9377635,     3, 4,  "EGY 100.XX"},
        {31.142224,   29.7143405,     3, 4,  "EGY 200.XX"},
        {31.280424,   32.2466405,     3, 4,  "EGY 300.XX"},
        {30.016724,   32.479105875,   3, 4,  "EGY 400.XX"},
        {30.979945,   31.115168625,   3, 4,  "EGY 500.XX"},
        {25.740724,   32.60502675,    3, 4,  "EGY 600.XX"},
        {31.082524,   31.3305405,     3, 4,  "EGY 700.XX"},
        {27.222624,   31.148661375,   4, 5,  "EGY 800.XX"},
        {30.828724,   30.949879125,   3, 4,  "EGY 900.XX"},
        {24.120724,   32.847291125,   3, 4,  "EGY B00.XX"},
        {29.093124,   31.043257375,   3, 4,  "EGY C00.XX"},
        {26.590724,   31.673587125,   3, 4,  "EGY D00.XX"},
        {30.592464,   31.464190375,   3, 4,  "EGY F00.XX"},
        {29.304104,   30.810254375,   3, 4,  "EGY FK0.00"},
        {30.606264,   32.239990375,   3, 4,  "EGY G00.XX"},
        {31.119904,   30.1008025,     3, 4,  "EGY GK0.00"},
        {31.045564,   30.4265325,     3, 4,  "EGY H00.XX"},
        {28.091204,   30.718943875,   3, 4,  "EGY HK0.00"},
        {26.184264,   32.703936625,   3, 4,  "EGY J00.XX"},
        {30.556204,   30.975820125,   3, 4,  "EGY JK0.00"},
        {30.475064,   31.131790375,   3, 4,  "EGY K00.XX"},
        {27.724704,   30.822288625,   3, 4,  "EGY KK0.00"},
        {31.105664,   30.8941325,     3, 4,  "EGY L00.XX"},
        {30.418704,   31.534364875,   3, 4,  "EGY LK0.00"},
        {31.133764,   33.7732325,     2, 3,  "EGY M00.XX"},
        {30.704104,   31.239820125,   3, 4,  "EGY MK0.00"},
        {26.342464,   31.845564375,   3, 4,  "EGY N00.XX"},
        {24.974104,   32.8413395,     3, 4,  "EGY NK0.00"},
        {29.863564,   31.298933875,   3, 4,  "EGY P00.XX"},
        {31.124104,   30.6096025,     3, 4,  "EGY PK0.00"},
        {31.322464,   30.2639325,     3, 4,  "EGY Q00.XX"},
        {31.214104,   31.3196025,     3, 4,  "EGY QK0.00"},
        {31.182464,   31.9839325,     3, 4,  "EGY R00.XX"},
        {30.724104,   31.639820125,   3, 4,  "EGY RK0.00"},
        {31.092464,   31.5639325,     3, 4,  "EGY S00.XX"},
        {31.001004,   29.7481025,     3, 4,  "EGY SK0.00"},
        {31.432464,   31.7839325,     3, 4,  "EGY T00.XX"},
        {28.307504,   30.680643875,   3, 4,  "EGY TK0.00"},
        {30.488764,   30.885690375,   3, 4,  "EGY V00.XX"},
        {26.761504,   31.474078125,   3, 4,  "EGY VK0.00"},
        {29.176264,   31.103906125,   3, 4,  "EGY W00.XX"},
        {30.881004,   31.427120125,   3, 4,  "EGY WK0.00"},
        {29.502464,   30.814533875,   3, 4,  "EGY X00.XX"},
        {30.905504,   30.262820125,   3, 4,  "EGY XK0.00"},
        {30.447464,   30.990662625,   3, 4,  "EGY Y00.XX"},
        {27.308304,   30.922288625,   3, 4,  "EGY YK0.00"},
        {25.637064,   32.52242225,    3, 4,  "EGY Z00.XX"},
        {30.814104,   30.789820125,   3, 4,  "EGY ZK0.00"},
        {29.848025,   29.300025,      2, 3,  "EGY 03K.S0G"},
        {28.860025,   30.348025,      2, 3,  "EGY Q20.610"},
        {27.423025,   30.545025,      2, 3,  "EGY V2X.L0S"},
        {27.151025,   30.715025,      3, 4,  "EGY X62.S13"},
        {26.400025,   33.617025,      2, 3,  "EGY XZV.60G"},
        {27.020691,   30.532276,      2, 3,  "EGY 12.XXXX"},
        {24.406462,   30.483952,      2, 3,  "EGY 1234.XX"},
        {30.982254,   25.131316,      1, 3,  "EGY 1234.XXX"},
        {18.100861,   -16.022168,     4, 5,  "MRT 12.XX"},
        {18.268515,   -16.059098,     3, 4,  "MRT 12.XXX"},
        {16.600514,   -11.463656125,  3, 5,  "MRT 000.XX"},
        {16.138114,   -13.56028625,   3, 5,  "MRT 200.XX"},
        {16.138114,   -13.43322125,   4, 6,  "MRT 400.XX"},
        {16.509914,   -15.865956125,  3, 6,  "MRT 600.XX"},
        {22.710314,   -12.54410225,   2, 7,  "MRT 800.XX"},
        {20.502214,   -13.111884,     2, 3,  "MRT B00.XX"},
        {16.600514,   -7.337056125,   3, 4,  "MRT D00.XX"},
        {18.534314,   -11.489534625,  2, 3,  "MRT G00.XX"},
        {16.980514,   -13.563826,     3, 4,  "MRT J00.XX"},
        {17.284914,   -7.100126,      3, 4,  "MRT L00.XX"},
        {19.790724,   -14.44316525,   2, 3,  "MRT N00.XX"},
        {17.094124,   -13.965688,     3, 4,  "MRT P00.XX"},
        {16.651224,   -14.308774125,  3, 5,  "MRT Q00.XX"},
        {15.199424,   -12.2393355,    3, 8,  "MRT R00.XX"},
        {20.504824,   -12.404678125,  2, 3,  "MRT S00.XX"},
        {16.283224,   -8.21306125,    3, 4,  "MRT T00.XX"},
        {16.700724,   -9.662374125,   3, 4,  "MRT V00.XX"},
        {15.846824,   -9.46886125,    3, 4,  "MRT W00.XX"},
        {22.730124,   -12.73666925,   2, 7,  "MRT X00.XX"},
        {25.254124,   -11.60877325,   2, 3,  "MRT Y00.XX"},
        {20.970324,   -11.672692,     2, 3,  "MRT Z00.XX"},
        {18.023983,   -16.4202355,    2, 3,  "MRT 123.XXX"},
        {16.445605,   -13.263099,     2, 4,  "MRT 12.XXXX"},
        {17.257595,   -10.227473,     2, 3,  "MRT 1234.XX"},
        {26.4866365,  -16.790253,     1, 2,  "MRT 1234.XXX"},
        {-17.7521,    -63.220074,     4, 6,  "BOL 12.XX"},
        {-17.851506,  -63.269785875,  3, 5,  "BOL 00.XXX"},
        {-17.334325,  -66.356907875,  3, 5,  "BOL C0.XXX"},
        {-16.627045,  -68.323390625,  3, 5,  "BOL P0.XXX"},
        {-17.976886,  -67.16876475,   3, 5,  "BOL 000.XX"},
        {-18.993876,  -65.3140395,    3, 5,  "BOL 200.XX"},
        {-21.487676,  -64.76721775,   2, 4,  "BOL 300.XX"},
        {-19.537776,  -65.79706525,   3, 5,  "BOL 400.XX"},
        {-17.294376,  -63.294888,     3, 5,  "BOL 500.XX"},
        {-14.817455,  -64.9418525,    2, 4,  "BOL 600.XX"},
        {-21.943455,  -63.692448125,  2, 6,  "BOL 700.XX"},
        {-10.970976,  -66.09385725,   2, 6,  "BOL 800.XX"},
        {-10.782976,  -65.39605725,   2, 6,  "BOL 900.XX"},
        {-18.406876,  -66.612826625,  3, 5,  "BOL B00.XX"},
        {-22.055476,  -65.6423435,    2, 6,  "BOL C00.XX"},
        {-19.990976,  -63.567778125,  2, 4,  "BOL D00.XX"},
        {-22.693376,  -64.37996925,   2, 6,  "BOL F00.XX"},
        {-21.399276,  -65.76361775,   2, 4,  "BOL G00.XX"},
        {-10.979976,  -68.79615725,   2, 9,  "BOL H00.XX"},
        {-16.335276,  -61.009174125,  2, 6,  "BOL J00.XX"},
        {-17.482576,  -63.204900875,  3, 5,  "BOL K00.XX"},
        {-14.819576,  -66.7857355,    3, 5,  "BOL L00.XX"},
        {-21.259325,  -63.50565875,   2, 4,  "BOL M00.XX"},
        {-18.249276,  -66.88271375,   3, 5,  "BOL N00.XX"},
        {-17.395455,  -63.910114375,  3, 5,  "BOL P00.XX"},
        {-17.526595,  -65.901093375,  3, 5,  "BOL Q00.XX"},
        {-17.076076,  -63.271388,     3, 5,  "BOL R00.XX"},
        {-13.698876,  -65.46610975,   2, 6,  "BOL S00.XX"},
        {-15.851376,  -63.22706125,   2, 4,  "BOL T00.XX"},
        {-15.795876,  -67.60146125,   3, 5,  "BOL V00.XX"},
        {-17.960376,  -63.43371375,   3, 5,  "BOL W00.XX"},
        {-18.936276,  -57.8435395,    2, 6,  "BOL X00.XX"},
        {-17.319276,  -63.442600875,  3, 5,  "BOL Y00.XX"},
        {-20.419276,  -66.873278125,  2, 4,  "BOL Z00.XX"},
        {-17.0444545, -65.0345575,    2, 4,  "BOL 123.XXX"},
        {-17.236508,  -67.766496,     2, 4,  "BOL 12.XXXX"},
        {-14.488357,  -68.651827,     2, 4,  "BOL 1234.XX"},
        {-10.5897175, -69.21865,      1, 8,  "BOL 1234.XXX"},
        {9.0646175,   38.701477,      4, 5,  "ETH 12.XX"},
        {9.132015,    38.6136115,     3, 4,  "ETH 12.XXX"},
        {9.616545,    41.776128125,   2, 4,  "ETH 000.XX"},
        {13.548924,   39.43899025,    3, 4,  "ETH 100.XX"},
        {8.586024,    39.2310685,     3, 4,  "ETH 200.XX"},
        {11.633824,   37.345929875,   3, 6,  "ETH 300.XX"},
        {12.631724,   37.411616,      3, 6,  "ETH 400.XX"},
        {11.172424,   39.603229875,   3, 4,  "ETH 500.XX"},
        {7.091845,    38.455621875,   3, 4,  "ETH 600.XX"},
        {7.713024,    36.799781375,   2, 3,  "ETH 700.XX"},
        {9.350424,    42.0821685,     2, 4,  "ETH 800.XX"},
        {7.241124,    38.575981375,   3, 4,  "ETH 900.XX"},
        {6.072624,    37.53059425,    2, 3,  "ETH B00.XX"},
        {11.119124,   39.703129875,   3, 4,  "ETH C00.XX"},
        {9.130924,    36.5055685,     2, 3,  "ETH D00.XX"},
        {10.381724,   37.68914275,    3, 6,  "ETH F00.XX"},
        {7.975864,    39.101628125,   3, 4,  "ETH G00.XX"},
        {14.274704,   39.435049375,   3, 6,  "ETH GK0.00"},
        {7.564664,    37.827928125,   3, 4,  "ETH H00.XX"},
        {6.843504,    37.736228375,   3, 4,  "ETH HK0.00"},
        {9.680964,    39.499755875,   3, 4,  "ETH J00.XX"},
        {6.409104,    38.27560025,    2, 3,  "ETH JK0.00"},
        {7.022464,    39.938828125,   3, 4,  "ETH K00.XX"},
        {12.414104,   39.533366,      3, 4,  "ETH KK0.00"},
        {14.109964,   38.24432675,    3, 6,  "ETH L00.XX"},
        {8.969504,    37.8311555,     3, 4,  "ETH LK0.00"},
        {5.344564,    39.54581375,    2, 3,  "ETH M00.XX"},
        {9.345704,    42.7725555,     2, 4,  "ETH MK0.00"},
        {14.130664,   38.69992675,    3, 4,  "ETH N00.XX"},
        {14.167204,   38.85482125,    3, 4,  "ETH NK0.00"},
        {8.544864,    37.9416415,     3, 4,  "ETH P00.XX"},
        {11.824404,   39.565938875,   3, 4,  "ETH PK0.00"},
        {6.756064,    38.36091375,    3, 4,  "ETH Q00.XX"},
        {8.144104,    38.793728375,   3, 4,  "ETH QK0.00"},
        {8.612464,    39.0887415,     3, 4,  "ETH R00.XX"},
        {7.854104,    39.603728375,   3, 4,  "ETH RK0.00"},
        {12.177564,   39.611298,      3, 4,  "ETH S00.XX"},
        {9.174104,    35.8036555,     2, 5,  "ETH SK0.00"},
        {8.132464,    38.338828125,   3, 4,  "ETH T00.XX"},
        {9.063904,    40.8610555,     2, 3,  "ETH TK0.00"},
        {5.892464,    38.94891375,    2, 3,  "ETH V00.XX"},
        {12.774104,   39.513294125,   3, 4,  "ETH VK0.00"},
        {9.796564,    38.706255875,   3, 4,  "ETH W00.XX"},
        {7.911604,    38.688928375,   3, 4,  "ETH WK0.00"},
        {8.553764,    34.7722415,     2, 5,  "ETH X00.XX"},
        {11.071404,   37.857138875,   3, 6,  "ETH XK0.00"},
        {11.751364,   41.040384625,   2, 4,  "ETH Y00.XX"},
        {8.244104,    34.563728375,   2, 5,  "ETH YK0.00"},
        {10.975064,   36.48027025,    2, 5,  "ETH Z00.XX"},
        {9.064304,    38.4840555,     3, 4,  "ETH ZK0.00"},
        {9.2889225,   37.5217765,     2, 3,  "ETH 123.XXX"},
        {11.761743,   37.4277445,     2, 5,  "ETH 12.XXXX"},
        {14.509893,   37.3572195,     2, 7,  "ETH 1234.XX"},
        {9.718072,    33.51484,       1, 8,  "ETH 1234.XXX"},
        {4.6651,      -74.12789,      5, 6,  "COL 12.XX"},
        {4.778935,    -74.227852375,  4, 5,  "COL 00.XXX"},
        {3.515084,    -76.646231625,  4, 5,  "COL C0.XXX"},
        {6.345084,    -75.72660925,   4, 5,  "COL P0.XXX"},
        {11.032745,   -74.84777125,   4, 5,  "COL 000.XX"},
        {10.948545,   -74.84377125,   4, 5,  "COL 100.XX"},
        {10.442545,   -75.56577125,   4, 5,  "COL 200.XX"},
        {10.376545,   -75.53477125,   4, 5,  "COL 300.XX"},
        {7.938145,    -72.547973125,  4, 6,  "COL 400.XX"},
        {7.168934,    -73.179078125,  4, 6,  "COL 500.XX"},
        {4.839834,    -75.723139375,  5, 6,  "COL 600.XX"},
        {11.244545,   -74.237770625,  4, 5,  "COL 700.XX"},
        {4.456545,    -75.257939375,  4, 5,  "COL 800.XX"},
        {1.229834,    -77.32302,      4, 7,  "COL 900.XX"},
        {5.068545,    -75.550039375,  4, 5,  "COL B00.XX"},
        {2.972434,    -75.31942,      4, 5,  "COL C00.XX"},
        {4.156545,    -73.660439375,  4, 6,  "COL D00.XX"},
        {4.563534,    -75.721639375,  4, 5,  "COL F00.XX"},
        {10.491834,   -73.30583625,   4, 6,  "COL G00.XX"},
        {8.794545,    -75.9179975,    4, 5,  "COL H00.XX"},
        {9.330834,    -75.4391975,    4, 5,  "COL J00.XX"},
        {7.085334,    -73.142778125,  5, 7,  "COL K00.XX"},
        {3.556545,    -76.349439375,  4, 5,  "COL L00.XX"},
        {3.884545,    -77.083339375,  4, 5,  "COL M00.XX"},
        {2.486545,    -76.64852,      4, 5,  "COL N00.XX"},
        {7.088545,    -73.897478125,  4, 5,  "COL P00.XX"},
        {4.842934,    -75.808839375,  4, 5,  "COL Q00.XX"},
        {4.119834,    -76.253139375,  4, 5,  "COL R00.XX"},
        {4.779634,    -75.965539375,  4, 5,  "COL S00.XX"},
        {4.317994,    -74.830010375,  4, 5,  "COL T00.XX"},
        {1.614004,    -75.646145,     4, 5,  "COL TK0.00"},
        {11.399094,   -72.272123625,  4, 6,  "COL V00.XX"},
        {5.724204,    -72.95459025,   4, 6,  "COL VK0.00"},
        {3.921394,    -76.328010375,  4, 5,  "COL W00.XX"},
        {5.542285,    -73.38123325,   4, 6,  "COL WK0.00"},
        {7.087594,    -73.201081125,  4, 6,  "COL X00.XX"},
        {10.874304,   -74.79798075,   4, 5,  "COL XK0.00"},
        {9.261245,    -74.8035525,    4, 5,  "COL Y00.XX"},
        {11.511895,   -72.934808875,  4, 6,  "COL YK0.00"},
        {4.837594,    -74.390910375,  4, 5,  "COL Z00.XX"},
        {5.829604,    -73.06039025,   4, 6,  "COL ZK0.00"},
        {4.541415,    -76.6484905,    3, 4,  "COL 123.XXX"},
        {8.392405,    -76.0532485,    3, 4,  "COL 12.XXXX"},
        {7.65428,     -72.811995,     3, 5,  "COL 0123.XX"},
        {6.84348,     -73.346095,     3, 5,  "COL 1123.XX"},
        {0.791265,    -77.717995,     3, 6,  "COL 2123.XX"},
        {2.743865,    -75.541795,     3, 4,  "COL 3123.XX"},
        {10.03498,    -73.4957665,    3, 4,  "COL 4123.XX"},
        {3.642365,    -77.291795,     3, 4,  "COL 5123.XX"},
        {2.269565,    -76.841295,     3, 4,  "COL 6123.XX"},
        {6.83458,     -74.115295,     3, 4,  "COL 7123.XX"},
        {1.556665,    -76.072595,     3, 4,  "COL 8123.XX"},
        {11.15008,    -72.4848665,    3, 5,  "COL 9123.XX"},
        {5.44938,     -73.386395,     3, 5,  "COL B123.XX"},
        {11.24008,    -73.1504665,    3, 5,  "COL C123.XX"},
        {1.361965,    -79.040895,     3, 6,  "COL D123.XX"},
        {7.65358,     -76.921795,     3, 4,  "COL F123.XX"},
        {8.04358,     -73.716795,     3, 4,  "COL G123.XX"},
        {5.235865,    -74.901795,     3, 4,  "COL H123.XX"},
        {5.45858,     -76.891795,     3, 4,  "COL J123.XX"},
        {6.63968,     -70.985695,     3, 5,  "COL K123.XX"},
        {5.96358,     -75.751795,     3, 4,  "COL L123.XX"},
        {5.115865,    -72.641795,     3, 6,  "COL M123.XX"},
        {12.345865,   -81.733346,     3, 4,  "COL N123.XX"},
        {7.56358,     -75.241795,     3, 4,  "COL P123.XX"},
        {7.16948,     -72.886895,     4, 6,  "COL Q123.XX"},
        {5.38858,     -74.051795,     3, 4,  "COL R123.XX"},
        {2.736565,    -76.655495,     4, 5,  "COL S123.XX"},
        {6.83858,     -74.931795,     3, 4,  "COL T123.XX"},
        {6.24858,     -74.651795,     3, 4,  "COL V123.XX"},
        {6.36148,     -73.370695,     3, 5,  "COL W123.XX"},
        {6.54568,     -72.126895,     3, 5,  "COL X123.XX"},
        {2.008765,    -75.944195,     4, 5,  "COL Y123.XX"},
        {-1.3701675,  -78.6434945,    2, 8,  "COL 1234.XXX"},
        {10.6450515,  -81.7207595,    2, 3,  "COL 123.XXXX"},
        {12.168144,   -81.1944395,    2, 3,  "COL 1234.XXXX"},
        {-33.910588,  18.37205,       4, 5,  "ZAF 00.XX"},
        {-33.968098,  18.461041,      4, 5,  "ZAF J0.XX"},
        {-29.826576,  30.960031625,   4, 5,  "ZAF 000.XX"},
        {-26.149276,  27.994913875,   4, 6,  "ZAF 100.XX"},
        {-25.697176,  28.162213875,   4, 6,  "ZAF 200.XX"},
        {-26.214276,  27.813713875,   4, 6,  "ZAF 300.XX"},
        {-33.915676,  25.549984,      4, 5,  "ZAF 400.XX"},
        {-26.139076,  28.256813875,   4, 6,  "ZAF 500.XX"},
        {-26.609876,  27.908387125,   4, 6,  "ZAF 600.XX"},
        {-29.572476,  30.348431625,   4, 5,  "ZAF 700.XX"},
        {-32.964576,  27.837349375,   4, 5,  "ZAF 800.XX"},
        {-25.972776,  28.162413875,   4, 6,  "ZAF 900.XX"},
        {-29.078276,  26.167457375,   4, 5,  "ZAF B00.XX"},
        {-26.198476,  28.163813875,   4, 6,  "ZAF C00.XX"},
        {-26.666676,  27.789987125,   4, 6,  "ZAF D00.XX"},
        {-27.708876,  29.895035625,   3, 4,  "ZAF F00.XX"},
        {-26.067976,  27.732713875,   4, 6,  "ZAF G00.XX"},
        {-27.927576,  26.693009875,   4, 5,  "ZAF H00.XX"},
        {-26.208676,  28.315713875,   5, 7,  "ZAF J00.XX"},
        {-26.206976,  28.408713875,   5, 7,  "ZAF K00.XX"},
        {-33.725176,  25.357484,      4, 5,  "ZAF L00.XX"},
        {-25.871936,  29.204136625,   4, 6,  "ZAF M00.XX"},
        {-26.277696,  28.100578125,   4, 6,  "ZAF MK0.00"},
        {-29.217336,  26.674306125,   4, 5,  "ZAF N00.XX"},
        {-33.732496,  18.949534,      4, 5,  "ZAF NK0.00"},
        {-25.978136,  28.076336625,   4, 6,  "ZAF P00.XX"},
        {-28.742596,  24.722699125,   4, 6,  "ZAF PK0.00"},
        {-26.847036,  26.621193125,   4, 6,  "ZAF Q00.XX"},
        {-26.363996,  27.364178125,   4, 6,  "ZAF QK0.00"},
        {-25.847936,  28.151936625,   4, 6,  "ZAF R00.XX"},
        {-34.075896,  18.808734,      4, 5,  "ZAF RK0.00"},
        {-26.165036,  27.663936625,   4, 6,  "ZAF S00.XX"},
        {-25.765496,  29.438722875,   4, 5,  "ZAF SK0.00"},
        {-25.645436,  27.20112225,    4, 6,  "ZAF T00.XX"},
        {-26.364396,  28.356478125,   4, 6,  "ZAF TK0.00"},
        {-26.698636,  27.059064375,   4, 6,  "ZAF V00.XX"},
        {-33.974796,  22.416534,      4, 5,  "ZAF VK0.00"},
        {-28.543336,  29.745277375,   4, 5,  "ZAF W00.XX"},
        {-23.898096,  29.427057125,   4, 5,  "ZAF WK0.00"},
        {-24.152736,  28.95486575,    3, 5,  "ZAF X00.XX"},
        {-29.815396,  30.600209625,   3, 4,  "ZAF XK0.00"},
        {-25.484036,  28.04842225,    4, 6,  "ZAF Y00.XX"},
        {-33.650496,  19.413934,      4, 5,  "ZAF YK0.00"},
        {-26.533936,  29.050964375,   4, 6,  "ZAF Z00.XX"},
        {-27.665896,  27.180688625,   4, 5,  "ZAF ZK0.00"},
        {-33.694277,  18.37641,       4, 5,  "ZAF 12.XXX"},
        {-30.101025,  30.6483015,     4, 5,  "ZAF 01.XXXX"},
        {-34.022925,  25.23291,       3, 4,  "ZAF 11.XXXX"},
        {-29.881725,  30.0615015,     3, 4,  "ZAF 21.XXXX"},
        {-33.221724,  27.384345,      3, 4,  "ZAF 31.XXXX"},
        {-29.361425,  26.018415,      3, 4,  "ZAF 41.XXXX"},
        {-28.166725,  29.8461365,     3, 4,  "ZAF 51.XXXX"},
        {-28.086725,  26.7111365,     3, 4,  "ZAF 61.XXXX"},
        {-29.431725,  26.543615,      3, 4,  "ZAF 71.XXXX"},
        {-34.143325,  18.92361,       3, 4,  "ZAF 81.XXXX"},
        {-28.936825,  24.486915,      3, 5,  "ZAF 91.XXXX"},
        {-34.001425,  22.1689315,     4, 5,  "ZAF B1.XXXX"},
        {-25.540125,  30.9012715,     4, 6,  "ZAF C1.XXXX"},
        {-24.146725,  30.957885,      3, 5,  "ZAF D1.XXXX"},
        {-28.740825,  29.7394365,     3, 4,  "ZAF F1.XXXX"},
        {-24.236725,  28.997885,      3, 5,  "ZAF G1.XXXX"},
        {-33.711725,  19.1273315,     4, 5,  "ZAF H1.XXXX"},
        {-28.963225,  31.751315,      3, 4,  "ZAF J1.XXXX"},
        {-23.251725,  29.6704065,     3, 4,  "ZAF K1.XXXX"},
        {-31.791725,  28.5518665,     3, 4,  "ZAF L1.XXXX"},
        {-26.389625,  25.9363715,     3, 5,  "ZAF M1.XXXX"},
        {-33.661725,  26.4573315,     3, 4,  "ZAF N1.XXXX"},
        {-28.081725,  30.5261365,     3, 4,  "ZAF P1.XXXX"},
        {-33.721724,  18.3572315,     4, 5,  "ZAF Q1.XXXX"},
        {-28.216725,  28.1361365,     3, 4,  "ZAF R1.XXXX"},
        {-32.091725,  26.7717665,     3, 4,  "ZAF S1.XXXX"},
        {-33.163425,  17.883145,      3, 4,  "ZAF T1.XXXX"},
        {-34.350625,  21.84631,       3, 4,  "ZAF V1.XXXX"},
        {-28.671725,  21.0011365,     3, 5,  "ZAF W1.XXXX"},
        {-26.082325,  25.4046715,     3, 5,  "ZAF X1.XXXX"},
        {-26.551725,  29.6558715,     3, 4,  "ZAF Y1.XXXX"},
        {-23.341725,  30.3804065,     3, 5,  "ZAF Z1.XXXX"},
        {-28.63142,   28.7149785,     3, 5,  "ZAF 0123.XX"},
        {-27.194135,  24.47245,       3, 5,  "ZAF 1123.XX"},
        {-34.091635,  22.938846,      3, 4,  "ZAF 2123.XX"},
        {-29.56642,   31.037199,      3, 4,  "ZAF 3123.XX"},
        {-32.584135,  22.296997,      3, 4,  "ZAF 4123.XX"},
        {-32.534134,  24.266997,      3, 4,  "ZAF 5123.XX"},
        {-31.090035,  30.064348,      3, 4,  "ZAF 6123.XX"},
        {-32.564135,  27.826997,      3, 4,  "ZAF 7123.XX"},
        {-27.23142,   30.55245,       3, 4,  "ZAF 8123.XX"},
        {-29.264135,  29.557299,      3, 4,  "ZAF 9123.XX"},
        {-27.42142,   25.07245,       3, 5,  "ZAF B123.XX"},
        {-32.43142,   25.3447765,     3, 4,  "ZAF C123.XX"},
        {-26.01142,   30.8002295,     3, 6,  "ZAF D123.XX"},
        {-33.00142,   26.356997,      3, 4,  "ZAF F123.XX"},
        {-30.88142,   23.7399275,     3, 4,  "ZAF G123.XX"},
        {-27.65642,   25.52735,       3, 4,  "ZAF H123.XX"},
        {-24.434135,  29.247601,      3, 5,  "ZAF J123.XX"},
        {-30.78142,   29.1599275,     3, 4,  "ZAF K123.XX"},
        {-34.64142,   18.951846,      3, 4,  "ZAF L123.XX"},
        {-24.01642,   29.9653805,     3, 4,  "ZAF M123.XX"},
        {-28.074135,  26.1050785,     3, 4,  "ZAF N123.XX"},
        {-27.59142,   29.63245,       3, 4,  "ZAF P123.XX"},
        {-30.51142,   30.4899275,     3, 4,  "ZAF Q123.XX"},
        {-30.924135,  26.442148,      3, 4,  "ZAF R123.XX"},
        {-34.144135,  19.926846,      3, 4,  "ZAF S123.XX"},
        {-28.184135,  24.6651785,     3, 5,  "ZAF T123.XX"},
        {-28.63142,   26.4650785,     3, 4,  "ZAF V123.XX"},
        {-25.324135,  30.2002295,     3, 5,  "ZAF W123.XX"},
        {-32.794135,  27.136997,      3, 4,  "ZAF X123.XX"},
        {-24.93142,   28.147601,      4, 6,  "ZAF Y123.XX"},
        {-28.55142,   27.3650785,     3, 4,  "ZAF Z123.XX"},
        {-24.8810165, 26.654769,      3, 6,  "ZAF 123.XXX"},
        {-24.5928525, 17.065382,      2, 5,  "ZAF 1234.XXX"},
        {-46.4040615, 37.0941095,     2, 3,  "ZAF M12.XXXX"},
        {-34.758,     27.47,          2, 3,  "ZAF L7J5.PMFM"},
        {12.6735,     -8.026549,      5, 7,  "MLI 12.XX"},
        {12.838569,   -8.218788,      4, 5,  "MLI 12.XXX"},
        {11.359824,   -5.719170125,   4, 5,  "MLI 000.XX"},
        {12.418824,   -5.509584,      4, 7,  "MLI 100.XX"},
        {14.530724,   -4.221922625,   4, 6,  "MLI 200.XX"},
        {14.572424,   -4.128522625,   4, 6,  "MLI 300.XX"},
        {14.490724,   -11.481922625,  4, 6,  "MLI 400.XX"},
        {13.320624,   -4.95070975,    4, 6,  "MLI 500.XX"},
        {13.456524,   -6.31870975,    4, 5,  "MLI 600.XX"},
        {13.499324,   -6.23180975,    4, 5,  "MLI 700.XX"},
        {15.290724,   -9.625448375,   4, 6,  "MLI 800.XX"},
        {16.307824,   -3.43736125,    4, 5,  "MLI 900.XX"},
        {13.741424,   -6.11790975,    4, 5,  "MLI B00.XX"},
        {16.812824,   -3.047974125,   4, 5,  "MLI C00.XX"},
        {13.965524,   -4.59460975,    4, 6,  "MLI D00.XX"},
        {16.311524,   -0.05966125,    4, 5,  "MLI F00.XX"},
        {13.619824,   -8.07690975,    5, 6,  "MLI G00.XX"},
        {11.460724,   -7.531470125,   4, 5,  "MLI H00.XX"},
        {14.282424,   -6.031522625,   4, 5,  "MLI J00.XX"},
        {12.911824,   -7.594596875,   4, 5,  "MLI K00.XX"},
        {13.588424,   -7.48800975,    5, 6,  "MLI L00.XX"},
        {15.209324,   -7.3271355,     4, 6,  "MLI M00.XX"},
        {13.828124,   -10.87900975,   5, 6,  "MLI N00.XX"},
        {11.958324,   -8.467870125,   4, 6,  "MLI P00.XX"},
        {18.482724,   1.367373375,    4, 6,  "MLI Q00.XX"},
        {14.112424,   -3.12380975,    4, 6,  "MLI R00.XX"},
        {15.942464,   -4.02211675,    4, 5,  "MLI S00.XX"},
        {16.410004,   -3.688340125,   4, 5,  "MLI SK0.00"},
        {11.109664,   -6.927615375,   4, 5,  "MLI T00.XX"},
        {12.349504,   -4.806434,      4, 7,  "MLI TK0.00"},
        {14.001164,   -5.38797325,    4, 6,  "MLI V00.XX"},
        {14.999104,   -2.9772235,     4, 6,  "MLI VK0.00"},
        {14.362464,   -3.641858875,   4, 6,  "MLI W00.XX"},
        {14.447204,   -4.944650625,   4, 6,  "MLI WK0.00"},
        {12.846764,   -4.957487625,   4, 7,  "MLI X00.XX"},
        {13.034104,   -9.516705875,   4, 5,  "MLI XK0.00"},
        {14.744964,   -6.1361455,     4, 6,  "MLI Y00.XX"},
        {13.716404,   -6.02967875,    4, 5,  "MLI YK0.00"},
        {16.133864,   -3.78161675,    4, 5,  "MLI Z00.XX"},
        {11.853904,   -6.797761125,   4, 5,  "MLI ZK0.00"},
        {14.150356,   -8.9078705,     4, 5,  "MLI 12.XXXX"},
        {14.8786475,  -6.2917825,     3, 5,  "MLI 123.XXX"},
        {16.03938,    -0.2517175,     3, 4,  "MLI 0123.XX"},
        {11.00708,    -6.0541665,     3, 4,  "MLI 1123.XX"},
        {14.14528,    -11.660146,     4, 6,  "MLI 2123.XX"},
        {14.961865,   -9.7891175,     3, 5,  "MLI 3123.XX"},
        {16.03678,    -3.8002175,     3, 4,  "MLI 4123.XX"},
        {16.37498,    -3.2289175,     3, 4,  "MLI 5123.XX"},
        {11.18858,    -7.7191665,     3, 5,  "MLI 6123.XX"},
        {14.908665,   -7.7040175,     3, 5,  "MLI 7123.XX"},
        {13.46868,    -11.170446,     4, 5,  "MLI 8123.XX"},
        {18.21058,    1.168103,       3, 5,  "MLI 9123.XX"},
        {13.84028,    -3.318946,      3, 5,  "MLI B123.XX"},
        {15.641765,   -4.3137175,     3, 4,  "MLI C123.XX"},
        {11.01428,    -7.0695665,     3, 4,  "MLI D123.XX"},
        {14.725865,   -3.2428175,     3, 5,  "MLI F123.XX"},
        {14.00688,    -3.814646,      4, 6,  "MLI G123.XX"},
        {12.987265,   -9.892246,      3, 4,  "MLI H123.XX"},
        {24.9483885,  -6.511934,      2, 6,  "MLI 0123.XXX"},
        {24.9483885,  -3.622207,      2, 5,  "MLI 1123.XXX"},
        {22.4719905,  -6.483856,      3, 5,  "MLI 2123.XXX"},
        {22.4719905,  -3.653711,      3, 6,  "MLI 3123.XXX"},
        {22.4719905,  -0.823566,      2, 5,  "MLI 4123.XXX"},
        {22.4719905,  1.552717,       3, 7,  "MLI 5123.XXX"},
        {19.7744845,  -6.4855285,     2, 4,  "MLI 6123.XXX"},
        {19.7744845,  -3.6851745,     2, 3,  "MLI 7123.XXX"},
        {19.7744845,  -0.8848205,     2, 5,  "MLI 8123.XXX"},
        {19.7744845,  1.5808355,      3, 7,  "MLI 9123.XXX"},
        {15.6932945,  -12.1460695,    2, 7,  "MLI B123.XXX"},
        {15.6932945,  -9.4579505,     2, 5,  "MLI C123.XXX"},
        {17.1096105,  -6.7166505,     2, 4,  "MLI D123.XXX"},
        {17.1096105,  -3.9758785,     2, 3,  "MLI F123.XXX"},
        {17.1096105,  -1.2351065,     2, 3,  "MLI G123.XXX"},
        {16.7270065,  1.492644,       2, 4,  "MLI H123.XXX"},
        {14.4284205,  -12.146674,     3, 6,  "MLI K123.XXX"},
        {14.4284205,  -9.458554,      3, 4,  "MLI L123.XXX"},
        {14.4284205,  -6.747574,      2, 3,  "MLI M123.XXX"},
        {14.4284205,  -4.036593,      3, 5,  "MLI N123.XXX"},
        {10.927664,   -8.8043735,     2, 5,  "MLI P123.XXX"},
        {12.6384,     -7.987817,      5, 7,  "MLI 7TZS.V1GM"},
        {-8.802198,   13.2074165,     4, 5,  "AGO 12.XX"},
        {-8.718093,   13.0459285,     3, 4,  "AGO 12.XXX"},
        {-11.763691,  19.856844375,   3, 4,  "AGO 000.XX"},
        {-14.835455,  13.4682325,     3, 4,  "AGO 100.XX"},
        {-14.877876,  13.4363645,     3, 4,  "AGO 200.XX"},
        {-14.877876,  13.5257365,     3, 4,  "AGO 300.XX"},
        {-12.720656,  15.674447625,   3, 4,  "AGO 400.XX"},
        {-12.720656,  15.737083625,   3, 4,  "AGO 500.XX"},
        {-12.572056,  13.340616,      3, 4,  "AGO 600.XX"},
        {-12.532056,  13.403083,      3, 4,  "AGO 700.XX"},
        {-12.340655,  16.90223,       3, 4,  "AGO 800.XX"},
        {-12.317176,  13.516616,      3, 4,  "AGO 900.XX"},
        {-12.400276,  13.510516,      3, 4,  "AGO B00.XX"},
        {-15.145876,  12.1105645,     3, 4,  "AGO C00.XX"},
        {-9.519455,   16.294228125,   3, 4,  "AGO D00.XX"},
        {-5.555055,   12.16072625,    3, 6,  "AGO F00.XX"},
        {-9.647455,   20.346928125,   3, 4,  "AGO G00.XX"},
        {-6.220276,   14.19699425,    3, 6,  "AGO H00.XX"},
        {-7.579276,   15.008981375,   3, 6,  "AGO J00.XX"},
        {-8.390076,   20.691581375,   3, 4,  "AGO K00.XX"},
        {-11.350176,  15.076029875,   3, 4,  "AGO L00.XX"},
        {-11.166776,  13.815929875,   3, 4,  "AGO M00.XX"},
        {-6.112976,   12.32129425,    3, 6,  "AGO N00.XX"},
        {-8.565336,   13.6292415,     3, 4,  "AGO P00.XX"},
        {-14.666296,  17.668249375,   3, 4,  "AGO PK0.00"},
        {-12.836636,  15.525312375,   3, 4,  "AGO Q00.XX"},
        {-13.795396,  14.66192125,    3, 4,  "AGO QK0.00"},
        {-9.287536,   14.8787415,     3, 4,  "AGO R00.XX"},
        {-12.924196,  15.222394125,   3, 4,  "AGO RK0.00"},
        {-12.134236,  17.248098,      3, 4,  "AGO S00.XX"},
        {-10.715596,  22.20491075,    3, 7,  "AGO SK0.00"},
        {-12.014736,  17.447684625,   3, 4,  "AGO T00.XX"},
        {-12.569696,  16.198466,      3, 4,  "AGO TK0.00"},
        {-11.637536,  20.408484625,   3, 4,  "AGO V00.XX"},
        {-7.236196,   12.856328375,   3, 4,  "AGO VK0.00"},
        {-8.177536,   15.338828125,   3, 4,  "AGO W00.XX"},
        {-11.569196,  20.751338875,   3, 4,  "AGO WK0.00"},
        {-17.056536,  15.681511,      3, 5,  "AGO X00.XX"},
        {-13.745496,  15.03782125,    3, 4,  "AGO XK0.00"},
        {-11.394836,  14.272384625,   3, 4,  "AGO Y00.XX"},
        {-7.766096,   15.250628375,   3, 6,  "AGO YK0.00"},
        {-8.761336,   17.9609415,     3, 4,  "AGO Z00.XX"},
        {-7.355796,   14.826228375,   3, 6,  "AGO ZK0.00"},
        {-11.3118975, 14.452829,      3, 4,  "AGO 123.XXX"},
        {-7.308,      12.974259,      2, 3,  "AGO 12.XXXX"},
        {-12.018522,  19.6791025,     2, 3,  "AGO 0123.XX"},
        {-15.12332,   13.286169,      2, 3,  "AGO 1123.XX"},
        {-12.731895,  13.234449,      2, 3,  "AGO 2123.XX"},
        {-15.42069,   11.9182915,     2, 3,  "AGO 3123.XX"},
        {-9.777635,   16.1153425,     2, 3,  "AGO 4123.XX"},
        {-5.811719,   11.97721,       2, 3,  "AGO 5123.XX"},
        {-9.905135,   20.1687325,     2, 3,  "AGO 6123.XX"},
        {-6.492375,   14.0061,        2, 5,  "AGO 7123.XX"},
        {-8.662175,   20.5008,        2, 3,  "AGO 8123.XX"},
        {-11.438875,  13.6282325,     2, 3,  "AGO 9123.XX"},
        {-6.385075,   12.1304,        2, 5,  "AGO B123.XX"},
        {-14.89182,   17.458159,      2, 3,  "AGO C123.XX"},
        {-12.31837,   17.1502425,     2, 3,  "AGO D123.XX"},
        {-10.94112,   22.0022325,     2, 4,  "AGO F123.XX"},
        {-11.838565,  20.3792825,     2, 3,  "AGO G123.XX"},
        {-17.303135,  15.471698,      2, 4,  "AGO H123.XX"},
        {-11.63872,   14.0747425,     2, 3,  "AGO J123.XX"},
        {-9.007935,   17.7630325,     2, 3,  "AGO K123.XX"},
        {-5.3271585,  12.1189025,     1, 4,  "AGO 1234.XXX"},
        {13.5491,     2.071268,       4, 7,  "NER 12.XX"},
        {13.525694,   2.00780875,     3, 6,  "NER 00.XXX"},
        {13.466314,   6.92369775,     3, 5,  "NER J0.XXX"},
        {13.847724,   8.94619025,     3, 5,  "NER 000.XX"},
        {17.011224,   7.944512,       3, 4,  "NER 100.XX"},
        {14.929324,   5.2218645,      3, 4,  "NER 200.XX"},
        {18.781724,   7.322173375,    3, 4,  "NER 300.XX"},
        {13.089724,   3.152303125,    3, 5,  "NER 400.XX"},
        {13.805424,   5.23109025,     3, 5,  "NER 500.XX"},
        {11.902524,   3.389729875,    3, 8,  "NER 600.XX"},
        {13.685324,   3.96299025,     3, 5,  "NER 700.XX"},
        {14.772524,   0.8724645,      3, 7,  "NER 800.XX"},
        {14.127724,   5.90529025,     3, 4,  "NER 900.XX"},
        {13.134724,   2.834903125,    3, 5,  "NER B00.XX"},
        {13.044824,   8.867003125,    3, 6,  "NER C00.XX"},
        {13.968324,   7.61859025,     3, 4,  "NER D00.XX"},
        {13.797724,   7.94519025,     3, 5,  "NER F00.XX"},
        {13.355024,   12.57029025,    3, 5,  "NER G00.XX"},
        {14.046724,   0.71229025,     3, 5,  "NER H00.XX"},
        {13.753524,   9.11279025,     3, 5,  "NER J00.XX"},
        {14.539224,   6.716877375,    3, 4,  "NER K00.XX"},
        {14.250424,   1.411477375,    3, 5,  "NER L00.XX"},
        {14.293124,   13.065977375,   3, 4,  "NER M00.XX"},
        {14.501624,   5.204777375,    3, 4,  "NER N00.XX"},
        {13.471824,   8.43579025,     3, 5,  "NER P00.XX"},
        {13.614624,   7.01819025,     4, 6,  "NER Q00.XX"},
        {14.979364,   8.8422545,      3, 4,  "NER R00.XX"},
        {13.978204,   10.24152125,    3, 4,  "NER RK0.00"},
        {15.474264,   6.250368875,    3, 4,  "NER S00.XX"},
        {13.499104,   7.74792125,     3, 5,  "NER SK0.00"},
        {14.362464,   3.298141125,    3, 4,  "NER T00.XX"},
        {12.992504,   2.822494125,    3, 5,  "NER TK0.00"},
        {13.676264,   6.66572675,     3, 5,  "NER V00.XX"},
        {13.213904,   12.00132125,    3, 5,  "NER VK0.00"},
        {13.111164,   2.321312375,    3, 5,  "NER W00.XX"},
        {13.314104,   2.30322125,     4, 6,  "NER WK0.00"},
        {13.329764,   7.14562675,     4, 6,  "NER X00.XX"},
        {14.745204,   5.7545765,      3, 4,  "NER XK0.00"},
        {15.912464,   5.76788325,     3, 4,  "NER Y00.XX"},
        {13.544104,   8.44322125,     3, 5,  "NER YK0.00"},
        {14.332464,   2.058141125,    3, 5,  "NER Z00.XX"},
        {14.414104,   6.023149375,    3, 4,  "NER ZK0.00"},
        {13.863641,   0.833761,       2, 4,  "NER 12.XXXX"},
        {15.4274955,  5.2860385,      2, 3,  "NER 123.XXX"},
        {13.52848,    8.834354,       2, 4,  "NER 1123.XX"},
        {16.71658,    7.6054825,      2, 3,  "NER 2123.XX"},
        {18.50958,    7.122903,       2, 3,  "NER 3123.XX"},
        {11.6941,     3.2253335,      2, 7,  "NER 4123.XX"},
        {12.817465,   8.671554,       2, 5,  "NER 6123.XX"},
        {13.053165,   12.375054,      2, 5,  "NER 8123.XX"},
        {13.89488,    12.750254,      2, 3,  "NER B123.XX"},
        {13.25908,    8.236854,       2, 4,  "NER C123.XX"},
        {14.732765,   8.6398825,      2, 3,  "NER D123.XX"},
        {13.75268,    10.031354,      2, 4,  "NER F123.XX"},
        {13.081665,   11.789654,      2, 5,  "NER G123.XX"},
        {15.598965,   5.5545825,      3, 4,  "NER H123.XX"},
        {17.9180895,  0.722514,       1, 4,  "NER 1234.XXX"},
        {12.166898,   15.035868,      4, 8,  "TCD 12.XX"},
        {12.064535,   14.929176875,   3, 7,  "TCD 00.XXX"},
        {8.672985,    15.9288885,     3, 6,  "TCD C0.XXX"},
        {9.241416,    18.2469705,     2, 4,  "TCD P0.XXX"},
        {13.869724,   20.79019025,    3, 4,  "TCD 000.XX"},
        {9.349947,    15.7601015,     3, 6,  "TCD 100.XX"},
        {8.956026,    17.5047395,     3, 5,  "TCD 200.XX"},
        {9.404724,    14.8638685,     3, 7,  "TCD 300.XX"},
        {11.070724,   20.24164275,    3, 4,  "TCD 400.XX"},
        {10.321724,   15.33064275,    3, 7,  "TCD 500.XX"},
        {12.224724,   18.651416,      3, 4,  "TCD 600.XX"},
        {8.714397,    16.8043595,     3, 5,  "TCD 700.XX"},
        {13.250424,   18.30219025,    3, 4,  "TCD 800.XX"},
        {9.443897,    16.2519385,     3, 5,  "TCD 900.XX"},
        {13.339624,   19.65079025,    3, 4,  "TCD B00.XX"},
        {12.022424,   18.179429875,   3, 4,  "TCD C00.XX"},
        {14.160724,   15.26819025,    3, 5,  "TCD D00.XX"},
        {12.527424,   15.399016,      3, 6,  "TCD F00.XX"},
        {11.850224,   15.826329875,   3, 6,  "TCD G00.XX"},
        {9.699386,    14.182112625,   3, 7,  "TCD H00.XX"},
        {9.490724,    18.8988685,     3, 5,  "TCD J00.XX"},
        {9.051606,    16.2722865,     3, 5,  "TCD K00.XX"},
        {13.046824,   15.685403125,   3, 6,  "TCD L00.XX"},
        {13.682424,   16.44739025,    3, 4,  "TCD M00.XX"},
        {12.420724,   17.018416,      3, 4,  "TCD N00.XX"},
        {9.357899,    16.1136455,     3, 6,  "TCD P00.XX"},
        {10.514424,   16.68204275,    3, 5,  "TCD Q00.XX"},
        {17.967824,   19.06488625,    3, 4,  "TCD R00.XX"},
        {9.956936,    15.102790625,   3, 7,  "TCD S00.XX"},
        {8.717843,    16.5251555,     3, 5,  "TCD T00.XX"},
        {11.826324,   17.118329875,   3, 4,  "TCD V00.XX"},
        {13.510724,   22.15819025,    3, 6,  "TCD W00.XX"},
        {10.955024,   15.50114275,    3, 6,  "TCD X00.XX"},
        {8.380724,    17.728981375,   3, 5,  "TCD Y00.XX"},
        {14.540664,   20.889041125,   3, 4,  "TCD Z00.XX"},
        {7.738974,    15.662610375,   3, 6,  "TCD ZK0.00"},
        {10.9262415,  14.8845405,     2, 6,  "TCD 123.XXX"},
        {13.667181,   14.9513795,     2, 4,  "TCD 12.XXXX"},
        {13.597624,   20.595049,      2, 3,  "TCD 0123.XX"},
        {8.681211,    17.3167125,     3, 5,  "TCD 1123.XX"},
        {10.798624,   20.0538425,     2, 4,  "TCD 2123.XX"},
        {11.952624,   18.4638325,     2, 3,  "TCD 3123.XX"},
        {12.975609,   18.107049,      2, 3,  "TCD 4123.XX"},
        {13.064809,   19.455649,      2, 3,  "TCD 5123.XX"},
        {11.750324,   17.9917425,     2, 3,  "TCD 6123.XX"},
        {13.888624,   15.073049,      3, 5,  "TCD 7123.XX"},
        {9.424571,    13.9941925,     2, 6,  "TCD 8123.XX"},
        {9.215909,    18.7108325,     2, 4,  "TCD 9123.XX"},
        {17.693009,   18.865498,      2, 3,  "TCD P123.XX"},
        {13.238624,   21.963049,      2, 5,  "TCD Q123.XX"},
        {8.108624,    17.5382,        2, 4,  "TCD R123.XX"},
        {14.296779,   20.683959,      2, 3,  "TCD S123.XX"},
        {7.513449,    15.45709,       2, 5,  "TCD T123.XX"},
        {14.3827535,  13.8309495,     1, 3,  "TCD 1234.XXX"},
        {-12.098406,  -77.064035,     5, 6,  "PER 12.XX"},
        {-12.223105,  -77.170954125,  4, 5,  "PER 00.XXX"},
        {-16.390546,  -71.73407675,   3, 5,  "PER J0.XXX"},
        {-8.051756,   -79.100637125,  4, 5,  "PER 000.XX"},
        {-8.051756,   -79.039019125,  4, 5,  "PER 100.XX"},
        {-6.705156,   -79.92816775,   4, 5,  "PER 200.XX"},
        {-6.705156,   -79.86671975,   4, 5,  "PER 300.XX"},
        {-3.738656,   -73.349098375,  4, 10, "PER 400.XX"},
        {-3.703656,   -73.287820375,  4, 10, "PER 500.XX"},
        {-5.141856,   -80.694198375,  4, 5,  "PER 600.XX"},
        {-5.141856,   -80.632920375,  4, 5,  "PER 700.XX"},
        {-12.016256,  -75.298214625,  4, 5,  "PER 800.XX"},
        {-12.016256,  -75.235917625,  4, 5,  "PER 900.XX"},
        {-9.051756,   -78.6129065,    4, 5,  "PER B00.XX"},
        {-9.101455,   -78.5337725,    5, 6,  "PER C00.XX"},
        {-8.349076,   -74.605018625,  4, 5,  "PER D00.XX"},
        {-13.516855,  -72.00176875,   4, 6,  "PER F00.XX"},
        {-17.982455,  -70.28997075,   4, 8,  "PER G00.XX"},
        {-14.016676,  -75.76800975,   4, 5,  "PER H00.XX"},
        {-15.459276,  -70.182148375,  4, 6,  "PER J00.XX"},
        {-13.129276,  -74.26180975,   4, 5,  "PER K00.XX"},
        {-4.892555,   -80.731374375,  4, 7,  "PER L00.XX"},
        {-9.942345,   -76.261802625,  4, 5,  "PER LK0.00"},
        {-13.407536,  -76.17177325,   4, 5,  "PER M00.XX"},
        {-6.493896,   -76.39239975,   4, 5,  "PER MK0.00"},
        {-7.153236,   -78.532171875,  4, 5,  "PER N00.XX"},
        {-4.590096,   -81.289326875,  4, 7,  "PER NK0.00"},
        {-15.838336,  -70.04281675,   4, 6,  "PER P00.XX"},
        {-3.587896,   -80.465826875,  4, 8,  "PER PK0.00"},
        {-11.925455,  -76.720823625,  4, 5,  "PER Q00.XX"},
        {-9.523896,   -77.554216375,  4, 5,  "PER QK0.00"},
        {-5.268536,   -80.70308625,   4, 5,  "PER R00.XX"},
        {-11.505896,  -77.236561125,  4, 5,  "PER RK0.00"},
        {-10.677536,  -76.30142975,   4, 5,  "PER S00.XX"},
        {-13.726596,  -76.22277875,   4, 5,  "PER SK0.00"},
        {-11.093436,  -77.632315375,  4, 5,  "PER T00.XX"},
        {-5.103696,   -80.201426875,  4, 5,  "PER TK0.00"},
        {-17.626536,  -71.361374625,  4, 6,  "PER V00.XX"},
        {-13.636896,  -72.90697875,   4, 6,  "PER VK0.00"},
        {-11.383936,  -75.743615375,  4, 5,  "PER W00.XX"},
        {-10.752496,  -77.77678925,   4, 5,  "PER WK0.00"},
        {-17.177536,  -70.972289,     4, 6,  "PER X00.XX"},
        {-5.101996,   -81.129026875,  4, 5,  "PER XK0.00"},
        {-9.280436,   -76.0334585,    4, 5,  "PER Y00.XX"},
        {-5.715896,   -78.83619975,   4, 5,  "PER YK0.00"},
        {-7.207536,   -79.451171875,  4, 5,  "PER Z00.XX"},
        {-5.902896,   -76.14839975,   4, 5,  "PER ZK0.00"},
        {-9.999798,   -77.7419935,    3, 4,  "PER 12.XXXX"},
        {-3.541731,   -81.262575,     3, 6,  "PER 1234.XX"},
        {-0.058375,   -69.112935,     4, 10, "PER 012.XXX"},
        {-0.058375,   -69.112935,     4, 10, "PER 112.XXX"},
        {-7.75489,    -79.34321,      3, 4,  "PER 212.XXX"},
        {-6.56984,    -79.94736,      3, 4,  "PER 312.XXX"},
        {-3.56874,    -73.51195,      3, 9,  "PER 412.XXX"},
        {-8.89934,    -78.7532595,    3, 4,  "PER 512.XXX"},
        {-8.18964,    -74.77256,      3, 4,  "PER 612.XXX"},
        {-13.330585,  -72.180095,     3, 5,  "PER 712.XXX"},
        {-17.825585,  -70.4908,       3, 7,  "PER 812.XXX"},
        {-13.85724,   -75.939405,     3, 4,  "PER 912.XXX"},
        {-15.47524,   -70.2856145,    3, 5,  "PER B12.XXX"},
        {-12.96984,   -74.433205,     3, 4,  "PER C12.XXX"},
        {-13.37019,   -76.381205,     3, 4,  "PER D12.XXX"},
        {-6.28784,    -76.57476,      3, 4,  "PER F12.XXX"},
        {-6.96554,    -78.70957,      3, 4,  "PER G12.XXX"},
        {-9.31784,    -77.7334795,    3, 4,  "PER H12.XXX"},
        {-17.43884,   -71.54684,      3, 5,  "PER J12.XXX"},
        {-13.43084,   -73.093405,     3, 5,  "PER K12.XXX"},
        {-16.98984,   -71.15784,      3, 5,  "PER L12.XXX"},
        {-9.09274,    -76.2078795,    3, 4,  "PER M12.XXX"},
        {-7.10984,    -79.70357,      3, 4,  "PER N12.XXX"},
        {-5.69684,    -76.33076,      3, 4,  "PER P12.XXX"},
        {-12.58984,   -75.203195,     3, 4,  "PER Q12.XXX"},
        {-5.82984,    -77.17857,      3, 4,  "PER R12.XXX"},
        {-12.46484,   -69.403155,     3, 6,  "PER S12.XXX"},
        {-14.08984,   -71.443195,     3, 5,  "PER T12.XXX"},
        {-6.96984,    -76.94857,      3, 4,  "PER V12.XXX"},
        {-12.87484,   -76.558205,     3, 4,  "PER W12.XXX"},
        {-12.294121,  -69.096386,     3, 6,  "PER X12.XXX"},
        {-12.8540805, -80.9145875,    2, 3,  "PER 1234.XXX"},
        {-12.0666265, -77.0376,       5, 6,  "PER 7CG9.WHZB"},
        {47.91753,    106.8184525,    5, 6,  "MNG 12.XX"},
        {48.108115,   106.57709,      4, 5,  "MNG 12.XXX"},
        {49.011714,   103.96981725,   4, 5,  "MNG 000.XX"},
        {49.453914,   105.854198,     4, 6,  "MNG 200.XX"},
        {48.055114,   114.437983875,  4, 5,  "MNG 400.XX"},
        {47.986514,   91.551183875,   5, 6,  "MNG 600.XX"},
        {44.876014,   110.051077125,  4, 8,  "MNG 800.XX"},
        {48.941414,   89.89001725,    4, 7,  "MNG B00.XX"},
        {49.961514,   91.97227975,    4, 9,  "MNG D00.XX"},
        {49.680724,   100.087624,     4, 6,  "MNG G00.XX"},
        {47.775224,   96.79291025,    4, 5,  "MNG H00.XX"},
        {50.271724,   106.14494675,   4, 10, "MNG J00.XX"},
        {46.730724,   100.06124,      4, 5,  "MNG K00.XX"},
        {46.300424,   102.72014,      4, 5,  "MNG L00.XX"},
        {47.515324,   101.40671025,   4, 5,  "MNG M00.XX"},
        {46.406724,   96.19194,       4, 5,  "MNG N00.XX"},
        {48.880624,   106.40540225,   4, 5,  "MNG P00.XX"},
        {48.859224,   103.47190225,   4, 5,  "MNG Q00.XX"},
        {43.625024,   104.346652,     4, 6,  "MNG R00.XX"},
        {46.714124,   113.21674,      4, 5,  "MNG S00.XX"},
        {45.806524,   106.214205375,  4, 5,  "MNG T00.XX"},
        {47.369124,   110.58911025,   4, 5,  "MNG V00.XX"},
        {48.796824,   98.2012805,     4, 5,  "MNG W00.XX"},
        {47.809524,   107.210145875,  5, 6,  "MNG X00.XX"},
        {46.393324,   108.32454,      3, 4,  "MNG Y00.XX"},
        {44.710724,   102.117935125,  3, 5,  "MNG Z00.XX"},
        {50.2058355,  103.8861385,    3, 8,  "MNG 123.XXX"},
        {47.97479,    99.7548445,     3, 4,  "MNG 1234.XX"},
        {47.862919,   114.2257755,    3, 4,  "MNG 01.XXXX"},
        {47.794319,   91.3389755,     3, 4,  "MNG 11.XXXX"},
        {44.683819,   109.8448,       3, 5,  "MNG 21.XXXX"},
        {48.749219,   89.6750505,     3, 6,  "MNG 31.XXXX"},
        {49.769319,   91.74718,       3, 6,  "MNG 41.XXXX"},
        {49.428319,   99.83018,       3, 5,  "MNG 51.XXXX"},
        {47.522819,   96.546885,      3, 4,  "MNG 61.XXXX"},
        {50.019319,   105.8910805,    4, 10, "MNG 71.XXXX"},
        {46.154319,   95.954055,      3, 4,  "MNG C1.XXXX"},
        {48.606819,   103.2259405,    3, 4,  "MNG D1.XXXX"},
        {43.372619,   104.1228505,    3, 5,  "MNG F1.XXXX"},
        {46.461719,   112.97422,      3, 4,  "MNG G1.XXXX"},
        {45.554119,   105.9832805,    3, 5,  "MNG H1.XXXX"},
        {47.116719,   110.3506105,    3, 4,  "MNG J1.XXXX"},
        {48.544419,   97.9546505,     3, 4,  "MNG K1.XXXX"},
        {52.0883885,  88.3069485,     2, 11, "MNG L123.XXX"},
        {52.0883885,  92.4181065,     2, 9,  "MNG M123.XXX"},
        {52.0883885,  96.5292645,     2, 11, "MNG N123.XXX"},
        {52.0883885,  100.6404225,    2, 11, "MNG P123.XXX"},
        {52.0883885,  104.7515805,    2, 12, "MNG Q123.XXX"},
        {52.0883885,  112.9738965,    2, 15, "MNG R123.XXX"},
        {49.5412575,  87.887936,      2, 7,  "MNG S123.XXX"},
        {49.5412575,  91.663051,      3, 5,  "MNG T123.XXX"},
        {49.5412575,  95.565672,      3, 5,  "MNG V123.XXX"},
        {49.5412575,  99.468293,      3, 5,  "MNG W123.XXX"},
        {49.5412575,  103.370914,     3, 5,  "MNG X123.XXX"},
        {49.5412575,  107.273535,     4, 6,  "MNG Y123.XXX"},
        {49.5412575,  111.176156,     2, 7,  "MNG Z123.XXX"},
        {49.5412575,  115.078777,     3, 8,  "MNG 0123.XXX"},
        {46.8600675,  90.730972,      2, 6,  "MNG 1123.XXX"},
        {46.8600675,  94.454847,      2, 3,  "MNG 2123.XXX"},
        {46.8600675,  98.178722,      2, 3,  "MNG 3123.XXX"},
        {46.8600675,  101.902597,     3, 4,  "MNG 4123.XXX"},
        {46.8600675,  105.626472,     2, 3,  "MNG 5123.XXX"},
        {46.8600675,  109.350347,     2, 3,  "MNG 6123.XXX"},
        {46.8600675,  113.074222,     3, 4,  "MNG 7123.XXX"},
        {48.2006625,  116.289967,     3, 7,  "MNG 8123.XXX"},
        {44.1872085,  94.9079895,     2, 6,  "MNG 9123.XXX"},
        {44.1872085,  98.4829095,     2, 4,  "MNG B123.XXX"},
        {44.1872085,  102.0578295,    2, 4,  "MNG C123.XXX"},
        {44.1872085,  105.6327495,    2, 4,  "MNG D123.XXX"},
        {44.1872085,  109.2076695,    2, 4,  "MNG F123.XXX"},
        {51.413132,   88.9102755,     2, 13, "MNG 1234.XXXX"},
        {35.7137,     51.33049,       5, 6,  "IRN 12.XX"},
        {35.748494,   51.177105,      4, 5,  "IRN 00.XXX"},
        {36.307814,   59.382680625,   5, 7,  "IRN J0.XXX"},
        {32.642814,   51.602917375,   4, 5,  "IRN 000.XX"},
        {38.112045,   46.212784375,   4, 5,  "IRN 200.XX"},
        {29.628245,   52.459447125,   4, 5,  "IRN 400.XX"},
        {35.870844,   50.870276875,   4, 5,  "IRN 600.XX"},
        {34.707545,   50.802621875,   4, 5,  "IRN 800.XX"},
        {31.359544,   48.6183155,     4, 7,  "IRN B00.XX"},
        {34.382944,   47.015876875,   4, 6,  "IRN D00.XX"},
        {29.530644,   60.794400125,   4, 6,  "IRN G00.XX"},
        {37.575034,   45.0040865,     4, 5,  "IRN J00.XX"},
        {30.306345,   57.019759375,   4, 5,  "IRN K00.XX"},
        {31.914034,   54.30047175,    4, 5,  "IRN L00.XX"},
        {37.313234,   49.5376865,     4, 5,  "IRN M00.XX"},
        {34.117425,   49.62447,       4, 5,  "IRN N00.XX"},
        {34.829434,   48.457979125,   4, 6,  "IRN P00.XX"},
        {38.280334,   48.235128375,   4, 5,  "IRN Q00.XX"},
        {36.316834,   49.95420375,    4, 5,  "IRN R00.XX"},
        {30.386734,   48.229408375,   4, 7,  "IRN S00.XX"},
        {35.329834,   46.96742,       4, 6,  "IRN T00.XX"},
        {36.693545,   48.43557875,    4, 6,  "IRN V00.XX"},
        {33.535045,   48.313268125,   4, 6,  "IRN W00.XX"},
        {27.216545,   56.238451875,   5, 6,  "IRN X00.XX"},
        {33.925545,   48.70687,       4, 5,  "IRN Y00.XX"},
        {36.870834,   54.391044625,   5, 7,  "IRN Z00.XX"},
        {36.9514995,  49.9015885,     3, 4,  "IRN 123.XXX"},
        {32.524474,   51.267045,      3, 4,  "IRN 11.XXXX"},
        {29.471775,   52.4265015,     3, 4,  "IRN 21.XXXX"},
        {31.100075,   48.3936665,     3, 6,  "IRN 31.XXXX"},
        {34.127475,   46.78051,       3, 5,  "IRN 41.XXXX"},
        {29.271175,   60.571315,      3, 4,  "IRN 51.XXXX"},
        {37.333475,   44.7680265,     3, 6,  "IRN 61.XXXX"},
        {30.067675,   56.8065015,     3, 4,  "IRN 71.XXXX"},
        {31.672475,   54.0815665,     3, 4,  "IRN 81.XXXX"},
        {37.112975,   49.23674,       3, 4,  "IRN 91.XXXX"},
        {33.884275,   49.39871,       3, 4,  "IRN B1.XXXX"},
        {34.587875,   48.22761,       3, 5,  "IRN C1.XXXX"},
        {30.173575,   47.9748015,     3, 6,  "IRN F1.XXXX"},
        {35.088275,   46.7400965,     3, 5,  "IRN G1.XXXX"},
        {36.462275,   48.2102615,     3, 5,  "IRN H1.XXXX"},
        {33.274074,   48.1047315,     3, 5,  "IRN J1.XXXX"},
        {27.045475,   55.89825,       4, 5,  "IRN K1.XXXX"},
        {33.489375,   48.6515315,     3, 5,  "IRN L1.XXXX"},
        {36.629275,   54.1594615,     4, 6,  "IRN M1.XXXX"},
        {33.768275,   51.32971,       3, 4,  "IRN N1.XXXX"},
        {36.008275,   57.375075,      4, 6,  "IRN P1.XXXX"},
        {36.421775,   53.0654615,     3, 5,  "IRN Q1.XXXX"},
        {36.008275,   58.565075,      5, 7,  "IRN R1.XXXX"},
        {29.258275,   55.493615,      3, 4,  "IRN S1.XXXX"},
        {38.318275,   44.705805,      3, 5,  "IRN T1.XXXX"},
        {32.168275,   48.224345,      3, 6,  "IRN V1.XXXX"},
        {37.258275,   57.0633265,     3, 6,  "IRN W1.XXXX"},
        {32.668275,   58.974345,      4, 5,  "IRN X1.XXXX"},
        {28.697875,   50.792815,      3, 4,  "IRN Z1.XXXX"},
        {39.09983,    45.2115365,     3, 7,  "IRN 1234.XX"},
        {38.4041095,  53.6839515,     2, 4,  "IRN 2123.XXX"},
        {38.4041095,  56.9609615,     2, 6,  "IRN 3123.XXX"},
        {39.7283875,  44.1464965,     2, 5,  "IRN 0123.XXX"},
        {39.7283875,  47.4830885,     2, 5,  "IRN 1123.XXX"},
        {37.0635135,  44.5358435,     2, 6,  "IRN 4123.XXX"},
        {37.0635135,  47.7532715,     3, 5,  "IRN 5123.XXX"},
        {37.0635135,  50.9706995,     2, 3,  "IRN 6123.XXX"},
        {37.0635135,  54.1881275,     4, 6,  "IRN 7123.XXX"},
        {37.0635135,  57.4055555,     3, 5,  "IRN 8123.XXX"},
        {37.0635135,  58.3707835,     4, 6,  "IRN 9123.XXX"},
        {34.3823235,  45.492908,      2, 5,  "IRN B123.XXX"},
        {34.3823235,  48.620963,      2, 4,  "IRN C123.XXX"},
        {34.3823235,  51.749018,      3, 4,  "IRN D123.XXX"},
        {34.3823235,  54.877073,      2, 3,  "IRN F123.XXX"},
        {34.3823235,  58.005128,      2, 3,  "IRN G123.XXX"},
        {34.3823235,  58.943544,      3, 4,  "IRN H123.XXX"},
        {31.7011335,  47.7089335,     2, 5,  "IRN J123.XXX"},
        {31.7011335,  50.7476155,     2, 3,  "IRN K123.XXX"},
        {31.7011335,  53.7862975,     2, 3,  "IRN L123.XXX"},
        {31.7011335,  56.8249795,     2, 3,  "IRN M123.XXX"},
        {31.7011335,  58.9520565,     3, 4,  "IRN N123.XXX"},
        {29.0036275,  50.7745655,     3, 4,  "IRN P123.XXX"},
        {29.0036275,  53.7536655,     2, 3,  "IRN Q123.XXX"},
        {29.0036275,  56.7327655,     2, 3,  "IRN R123.XXX"},
        {29.0036275,  59.7118655,     2, 3,  "IRN S123.XXX"},
        {29.0036275,  60.4838605,     3, 4,  "IRN T123.XXX"},
        {27.6949945,  53.7817615,     3, 4,  "IRN V123.XXX"},
        {27.6949945,  56.7012795,     3, 4,  "IRN W123.XXX"},
        {27.6949945,  59.6207975,     3, 4,  "IRN X123.XXX"},
        {38.764258,   44.7227365,     3, 5,  "IRN 1234.XXXX"},
        {32.881024,   13.143919125,   4, 5,  "LBY 00.XX"},
        {32.091604,   20.036504,      4, 5,  "LBY J0.XX"},
        {32.708925,   12.975693875,   3, 4,  "LBY 00.XXX"},
        {32.187742,   19.97515325,    3, 4,  "LBY C0.XXX"},
        {32.379387,   14.929993,      3, 4,  "LBY P0.XXX"},
        {32.670524,   14.235549375,   3, 4,  "LBY 000.XX"},
        {30.775924,   20.161979125,   2, 3,  "LBY 100.XX"},
        {32.110824,   23.908688,      3, 4,  "LBY 200.XX"},
        {32.210724,   12.972088,      3, 4,  "LBY 300.XX"},
        {32.793624,   12.671949375,   3, 4,  "LBY 400.XX"},
        {32.504524,   14.511588,      3, 4,  "LBY 500.XX"},
        {31.212524,   16.5355405,     2, 3,  "LBY 600.XX"},
        {26.620724,   12.724687125,   3, 4,  "LBY 700.XX"},
        {31.791124,   13.95731475,    3, 4,  "LBY 800.XX"},
        {32.802424,   21.711349375,   3, 4,  "LBY 900.XX"},
        {32.111124,   12.488188,      3, 4,  "LBY B00.XX"},
        {27.078524,   14.382561375,   3, 4,  "LBY C00.XX"},
        {32.791224,   22.595749375,   3, 4,  "LBY D00.XX"},
        {32.570724,   12.972088,      3, 4,  "LBY F00.XX"},
        {31.910924,   10.93231475,    3, 6,  "LBY G00.XX"},
        {32.821824,   12.433349375,   3, 4,  "LBY H00.XX"},
        {25.964924,   13.870013875,   3, 4,  "LBY J00.XX"},
        {32.474224,   13.590788,      3, 4,  "LBY K00.XX"},
        {32.532624,   20.783988,      3, 4,  "LBY L00.XX"},
        {32.961024,   12.038049375,   2, 3,  "LBY M00.XX"},
        {32.835224,   21.826849375,   3, 4,  "LBY N00.XX"},
        {27.561964,   14.232620875,   3, 4,  "LBY P00.XX"},
        {31.442004,   12.9561025,     3, 4,  "LBY PK0.00"},
        {32.200064,   20.556989,      3, 4,  "LBY Q00.XX"},
        {30.943604,   20.094020125,   2, 3,  "LBY QK0.00"},
        {32.541264,   20.546989,      3, 4,  "LBY R00.XX"},
        {24.951504,   10.1529395,     2, 5,  "LBY RK0.00"},
        {29.160264,   21.258306125,   2, 3,  "LBY S00.XX"},
        {24.194104,   23.26148425,    2, 3,  "LBY SK0.00"},
        {32.782464,   12.543332125,   3, 4,  "LBY T00.XX"},
        {30.388304,   19.565764875,   2, 3,  "LBY TK0.00"},
        {31.684264,   20.21716125,    3, 4,  "LBY V00.XX"},
        {29.158704,   16.113554375,   2, 3,  "LBY VK0.00"},
        {30.137164,   9.465562625,    2, 5,  "LBY W00.XX"},
        {32.573404,   13.991696375,   3, 4,  "LBY WK0.00"},
        {31.765264,   25.03736125,    2, 3,  "LBY X00.XX"},
        {31.944104,   11.98945775,    3, 4,  "LBY XK0.00"},
        {29.139664,   15.915406125,   2, 3,  "LBY Y00.XX"},
        {32.751904,   22.206396375,   3, 4,  "LBY YK0.00"},
        {32.966764,   11.829732125,   2, 3,  "LBY Z00.XX"},
        {29.029704,   21.515854375,   2, 3,  "LBY ZK0.00"},
        {31.9537215,  10.7277595,     2, 5,  "LBY 123.XXX"},
        {31.8036115,  20.077731,      2, 3,  "LBY 12.XXXX"},
        {27.92389,    12.3474085,     2, 3,  "LBY 1234.XX"},
        {20.7931145,  9.825216,       1, 5,  "LBY 1234.XXX"},
        {15.6013045,  32.498507,      5, 6,  "SDN 12.XX"},
        {15.772275,   32.3136745,     3, 4,  "SDN 12.XXX"},
        {19.596795,   37.14123875,    4, 5,  "SDN 000.XX"},
        {19.672545,   37.14123875,    4, 5,  "SDN 100.XX"},
        {12.095724,   24.843029875,   5, 9,  "SDN 200.XX"},
        {13.227524,   30.17779025,    4, 5,  "SDN 300.XX"},
        {15.497324,   36.338151625,   4, 5,  "SDN 400.XX"},
        {14.078724,   35.33429025,    4, 6,  "SDN 500.XX"},
        {14.430424,   33.484477375,   4, 6,  "SDN 600.XX"},
        {13.196124,   32.61819025,    4, 5,  "SDN 700.XX"},
        {13.669824,   25.30759025,    4, 5,  "SDN 800.XX"},
        {13.490624,   22.41329025,    4, 7,  "SDN 900.XX"},
        {11.836824,   34.331429875,   5, 10, "SDN B00.XX"},
        {14.274224,   32.956977375,   4, 5,  "SDN C00.XX"},
        {11.043224,   29.67254275,    5, 9,  "SDN D00.XX"},
        {11.495624,   26.088029875,   5, 9,  "SDN F00.XX"},
        {13.594224,   33.55439025,    4, 6,  "SDN G00.XX"},
        {17.757324,   33.967599125,   4, 5,  "SDN H00.XX"},
        {14.790724,   33.2949645,     4, 6,  "SDN J00.XX"},
        {16.727624,   33.396825875,   4, 5,  "SDN K00.XX"},
        {13.226624,   32.70539025,    4, 5,  "SDN L00.XX"},
        {12.942624,   31.179303125,   4, 5,  "SDN M00.XX"},
        {14.039424,   32.25469025,    4, 5,  "SDN N00.XX"},
        {15.363924,   35.568951625,   4, 5,  "SDN P00.XX"},
        {17.603064,   33.932825375,   4, 5,  "SDN Q00.XX"},
        {12.685004,   28.397994125,   4, 5,  "SDN QK0.00"},
        {13.160264,   33.88512675,    4, 6,  "SDN R00.XX"},
        {11.323104,   27.786138875,   5, 9,  "SDN RK0.00"},
        {12.059464,   29.621184625,   5, 9,  "SDN S00.XX"},
        {13.298004,   33.85372125,    4, 6,  "SDN SK0.00"},
        {14.974564,   35.8661545,     4, 5,  "SDN T00.XX"},
        {13.004104,   31.833294125,   4, 5,  "SDN TK0.00"},
        {12.912464,   23.438312375,   4, 6,  "SDN V00.XX"},
        {19.094104,   37.3024975,     4, 5,  "SDN VK0.00"},
        {13.429264,   33.64332675,    4, 6,  "SDN W00.XX"},
        {11.453904,   31.207838875,   5, 9,  "SDN WK0.00"},
        {11.878864,   34.340084625,   5, 10, "SDN X00.XX"},
        {13.415404,   34.59702125,    4, 6,  "SDN XK0.00"},
        {14.071464,   33.15062675,    4, 6,  "SDN Y00.XX"},
        {13.272504,   34.15012125,    4, 6,  "SDN YK0.00"},
        {18.032464,   33.95753975,    4, 5,  "SDN Z00.XX"},
        {12.720404,   30.614794125,   4, 5,  "SDN ZK0.00"},
        {13.081413,   29.5709545,     3, 4,  "SDN 12.XXXX"},
        {15.6865375,  32.1900215,     3, 4,  "SDN 123.XXX"},
        {19.376765,   36.8313315,     3, 4,  "SDN 1123.XX"},
        {11.82358,    24.6553335,     4, 8,  "SDN 2123.XX"},
        {15.222465,   36.1459825,     3, 4,  "SDN 3123.XX"},
        {13.76048,    35.137054,      3, 5,  "SDN 4123.XX"},
        {13.31488,    25.078554,      3, 4,  "SDN 5123.XX"},
        {13.21848,    22.218154,      3, 5,  "SDN 6123.XX"},
        {11.56288,    34.0408335,     4, 9,  "SDN 7123.XX"},
        {11.28308,    25.9182335,     4, 8,  "SDN 8123.XX"},
        {17.322365,   33.761903,      3, 4,  "SDN 9123.XX"},
        {16.50198,    33.2591825,     3, 4,  "SDN B123.XX"},
        {14.914665,   35.5138825,     3, 4,  "SDN C123.XX"},
        {12.419265,   28.109854,      3, 4,  "SDN D123.XX"},
        {11.02088,    27.5712335,     4, 8,  "SDN F123.XX"},
        {12.665865,   23.233054,      3, 5,  "SDN G123.XX"},
        {18.896365,   36.9678315,     3, 4,  "SDN H123.XX"},
        {17.785865,   33.747903,      3, 4,  "SDN J123.XX"},
        {20.515262,   22.4451405,     2, 5,  "SDN 1234.XXX"},
        {10.548876,   23.824372,      3, 9,  "SDN 123.XXXX"},
        {16.271,      30.22,          2, 3,  "SDN MB43.XFPT"},
        {-6.1622,     106.79211,      5, 6,  "IDN 12.XX"},
        {-6.2368885,  106.5829305,    4, 5,  "IDN 12.XXX"},
        {-7.206455,   112.660226875,  4, 5,  "IDN 000.XX"},
        {-7.258455,   112.670226875,  4, 5,  "IDN 100.XX"},
        {-7.310455,   112.670226875,  4, 5,  "IDN 200.XX"},
        {-7.361455,   112.670226875,  4, 5,  "IDN 300.XX"},
        {-6.869276,   107.524081375,  4, 5,  "IDN 400.XX"},
        {-6.877925,   107.611290375,  4, 5,  "IDN 500.XX"},
        {3.591545,    98.624225625,   4, 5,  "IDN 600.XX"},
        {3.684045,    98.627225625,   4, 5,  "IDN 700.XX"},
        {-2.941476,   104.71762,      4, 5,  "IDN 800.XX"},
        {-6.949876,   110.379081375,  4, 5,  "IDN 900.XX"},
        {-5.108176,   119.401507125,  4, 5,  "IDN B00.XX"},
        {-7.922276,   112.595681375,  4, 5,  "IDN C00.XX"},
        {-5.383576,   105.22559425,   4, 5,  "IDN D00.XX"},
        {-6.539276,   106.74909425,   4, 5,  "IDN F00.XX"},
        {-0.906476,   100.34622,      4, 5,  "IDN G00.XX"},
        {-7.535955,   110.768321875,  4, 5,  "IDN H00.XX"},
        {-3.309336,   114.562899375,  4, 5,  "IDN J00.XX"},
        {0.500204,    101.413745,     4, 5,  "IDN JK0.00"},
        {-0.487236,   117.102085,     4, 5,  "IDN K00.XX"},
        {-0.029396,   109.307445,     4, 5,  "IDN KK0.00"},
        {-8.637536,   115.1887415,    4, 5,  "IDN L00.XX"},
        {-7.801596,   110.345528375,  4, 5,  "IDN LK0.00"},
        {-1.241336,   116.804185,     4, 5,  "IDN M00.XX"},
        {-1.621896,   103.585745,     4, 5,  "IDN MK0.00"},
        {1.497464,    124.818885,     4, 5,  "IDN N00.XX"},
        {-8.585496,   116.0732555,    4, 5,  "IDN NK0.00"},
        {-6.704036,   108.52371375,   4, 5,  "IDN P00.XX"},
        {-7.815896,   111.983728375,  4, 5,  "IDN PK0.00"},
        {-6.860936,   109.099528125,  4, 5,  "IDN Q00.XX"},
        {-6.885196,   109.645828375,  4, 5,  "IDN QK0.00"},
        {-8.157436,   113.664828125,  4, 5,  "IDN R00.XX"},
        {-3.685815,   128.158224375,  4, 5,  "IDN RK0.00"},
        {5.562464,    95.28891375,    4, 5,  "IDN S00.XX"},
        {-7.728915,   108.996093125,  4, 5,  "IDN SK0.00"},
        {-3.795155,   102.247145625,  4, 5,  "IDN T00.XX"},
        {-7.422396,   109.213037625,  4, 5,  "IDN TK0.00"},
        {2.977594,    99.029175,      4, 5,  "IDN V00.XX"},
        {-7.319296,   108.183837625,  4, 5,  "IDN VK0.00"},
        {-7.609255,   111.502126875,  4, 5,  "IDN W00.XX"},
        {-3.979996,   122.484882875,  4, 5,  "IDN WK0.00"},
        {-0.894933,   119.835225,     4, 5,  "IDN X00.XX"},
        {1.437985,    125.111155,     4, 5,  "IDN XK0.00"},
        {3.630994,    98.466425625,   4, 5,  "IDN Y00.XX"},
        {-7.635996,   112.873637625,  4, 5,  "IDN YK0.00"},
        {-10.153506,  123.57426175,   4, 6,  "IDN Z00.XX"},
        {1.052505,    103.924535,     4, 6,  "IDN ZK0.00"},
        {-6.625493,   106.001385,     3, 4,  "IDN 123.XXX"},
        {-7.6844935,  109.6902675,    3, 4,  "IDN 12.XXXX"},
        {3.420865,    98.418205,      3, 4,  "IDN 0123.XX"},
        {-3.224135,   104.526805,     3, 4,  "IDN 1123.XX"},
        {-5.428135,   119.3555935,    3, 4,  "IDN 2123.XX"},
        {-5.496335,   105.066405,     3, 4,  "IDN 3123.XX"},
        {-1.003035,   100.260905,     3, 4,  "IDN 4123.XX"},
        {-3.604135,   114.483205,     3, 4,  "IDN 5123.XX"},
        {0.325865,    101.198205,     3, 4,  "IDN 6123.XX"},
        {-0.734135,   116.918205,     3, 4,  "IDN 7123.XX"},
        {-0.254135,   109.108205,     3, 4,  "IDN 8123.XX"},
        {-8.84592,    114.991605,     3, 4,  "IDN 9123.XX"},
        {-1.416635,   116.600805,     3, 4,  "IDN B123.XX"},
        {-1.824135,   103.378205,     3, 4,  "IDN C123.XX"},
        {1.245865,    124.783205,     3, 4,  "IDN D123.XX"},
        {-8.81222,    116.009005,     3, 4,  "IDN F123.XX"},
        {-8.18142,    113.568205,     3, 4,  "IDN G123.XX"},
        {-3.769935,   127.897705,     3, 4,  "IDN H123.XX"},
        {5.200565,    95.197805,      3, 4,  "IDN J123.XX"},
        {-4.031735,   102.173005,     3, 4,  "IDN K123.XX"},
        {2.910865,    98.868205,      3, 4,  "IDN L123.XX"},
        {-4.203135,   122.298605,     3, 4,  "IDN M123.XX"},
        {-1.134135,   119.608205,     3, 4,  "IDN N123.XX"},
        {-10.387535,  123.2832335,    3, 5,  "IDN P123.XX"},
        {1.1773825,   103.7359825,    3, 6,  "IDN Q123.XX"},
        {-2.444135,   113.688205,     3, 4,  "IDN R123.XX"},
        {0.390665,    122.774805,     3, 4,  "IDN S123.XX"},
        {-2.907835,   140.473105,     3, 4,  "IDN T123.XX"},
        {4.800346,    96.774505,      3, 4,  "IDN V123.XX"},
        {-2.223735,   105.743555,     3, 4,  "IDN W123.XX"},
        {0.74373,     104.2155935,    3, 4,  "IDN X123.XX"},
        {1.055365,    98.975405,      3, 4,  "IDN Y123.XX"},
        {-8.546419,   114.118205,     3, 4,  "IDN Z123.XX"},
        {-0.6347245,  129.7533495,    2, 3,  "IDN 012.XXXX"},
        {-1.728032,   130.480401,     3, 4,  "IDN 112.XXXX"},
        {0.41692,     133.161592,     2, 3,  "IDN 212.XXXX"},
        {-2.26427,    133.161592,     2, 3,  "IDN 312.XXXX"},
        {-0.682367,   135.842782,     2, 3,  "IDN 412.XXXX"},
        {-3.363557,   135.842782,     2, 3,  "IDN 512.XXXX"},
        {-6.044747,   135.842782,     2, 3,  "IDN 612.XXXX"},
        {-1.486724,   138.523972,     2, 3,  "IDN 712.XXXX"},
        {-4.167914,   138.523972,     2, 3,  "IDN 812.XXXX"},
        {-6.849104,   138.523972,     2, 3,  "IDN 912.XXXX"},
        {2.064613,    118.848163,     3, 5,  "IDN B12.XXXX"},
        {2.064613,    121.529353,     2, 3,  "IDN C12.XXXX"},
        {2.064613,    124.210543,     2, 3,  "IDN D12.XXXX"},
        {-0.616576,   118.848163,     3, 4,  "IDN F12.XXXX"},
        {-0.616576,   121.529353,     2, 3,  "IDN G12.XXXX"},
        {-0.616576,   124.210543,     2, 3,  "IDN H12.XXXX"},
        {-3.297766,   118.848163,     2, 3,  "IDN J12.XXXX"},
        {-3.297766,   121.529353,     2, 3,  "IDN K12.XXXX"},
        {-5.978956,   120.510501,     2, 3,  "IDN L12.XXXX"},
        {2.44893,     127.151699,     3, 4,  "IDN M12.XXXX"},
        {-0.232259,   127.151699,     2, 3,  "IDN N12.XXXX"},
        {-2.91345,    125.811104,     3, 4,  "IDN P12.XXXX"},
        {-1.706914,   128.492293,     3, 4,  "IDN Q12.XXXX"},
        {-3.985926,   131.173483,     3, 4,  "IDN R12.XXXX"},
        {-5.326521,   132.782197,     3, 4,  "IDN S12.XXXX"},
        {-6.398997,   130.449562,     2, 3,  "IDN T12.XXXX"},
        {-6.398997,   127.768372,     2, 3,  "IDN V12.XXXX"},
        {-7.471473,   125.087182,     2, 3,  "IDN W12.XXXX"},
        {4.628193,    125.062763,     2, 6,  "IDN X12.XXXX"},
        {3.209077,    105.134699,     2, 4,  "IDN Y12.XXXX"},
        {4.683732,    107.815889,     2, 4,  "IDN Z12.XXXX"},
        {4.3626855,   114.7059575,    2, 5,  "IDN 0123.XXX"},
        {4.3626855,   117.3871475,    2, 4,  "IDN 1123.XXX"},
        {-0.606478,   108.6955465,    2, 3,  "IDN 2123.XXX"},
        {1.6814965,   111.0863505,    2, 4,  "IDN 3123.XXX"},
        {1.6814965,   113.7675405,    2, 4,  "IDN 4123.XXX"},
        {1.6814965,   116.4487305,    2, 4,  "IDN 5123.XXX"},
        {-0.9996935,  109.3435765,    2, 3,  "IDN 6123.XXX"},
        {-0.9996935,  112.0247665,    2, 3,  "IDN 7123.XXX"},
        {-0.9996935,  114.7059565,    2, 3,  "IDN 8123.XXX"},
        {-3.6808835,  114.1697185,    2, 3,  "IDN 9123.XXX"},
        {5.8452725,   95.1063715,     2, 3,  "IDN B123.XXX"},
        {5.8452725,   97.7875615,     2, 4,  "IDN C123.XXX"},
        {3.1640975,   95.7766685,     2, 3,  "IDN D123.XXX"},
        {3.1640975,   98.4578585,     2, 3,  "IDN F123.XXX"},
        {1.4471185,   101.136293,     2, 4,  "IDN G123.XXX"},
        {0.4829085,   98.2432765,     2, 3,  "IDN H123.XXX"},
        {0.4829085,   100.9244665,    2, 3,  "IDN J123.XXX"},
        {0.4829085,   103.6056565,    2, 3,  "IDN K123.XXX"},
        {-2.1982815,  98.2432765,     2, 3,  "IDN L123.XXX"},
        {-2.1982815,  100.9244665,    2, 3,  "IDN M123.XXX"},
        {-2.1982815,  103.6056565,    2, 3,  "IDN N123.XXX"},
        {-2.1982815,  106.2868465,    2, 3,  "IDN P123.XXX"},
        {-4.8794715,  102.0773775,    2, 3,  "IDN Q123.XXX"},
        {-4.8794715,  104.7585675,    2, 3,  "IDN R123.XXX"},
        {-5.6943235,  107.4402795,    2, 3,  "IDN S123.XXX"},
        {-6.2305615,  110.1214695,    2, 3,  "IDN T123.XXX"},
        {-6.4986805,  112.8026595,    2, 3,  "IDN V123.XXX"},
        {-6.7667995,  115.4838495,    2, 3,  "IDN W123.XXX"},
        {-8.761156,   118.2518325,    2, 3,  "IDN X123.XXX"},
        {-9.8743905,  118.9765845,    2, 4,  "IDN Y123.XXX"},
        {-9.2422525,  122.578271,     2, 4,  "IDN Z123.XXX"},
        {4.7281415,   96.678782,      2, 3,  "IDN 1234.XXXX"},
        {19.4437715,  -99.1748535,    5, 14, "MX-DIF 12.XX"},
        {19.199879,   -99.3087425,    4, 12, "MX-DIF 12.XXX"},
        {19.319,      -99.1516,       4, 12, "MX-DIF PR9.817"},
        {19.310865,   -98.2733505,    5, 14, "MX-TLA 12.XX"},
        {19.114415,   -98.1080685,    4, 14, "MX-TLA 123.XX"},
        {19.55588,    -98.5635205,    4, 13, "MX-TLA 12.XXX"},
        {19.541328,   -98.692129,     3, 13, "MX-TLA 123.XXX"},
        {18.963749,   -99.2484315,    5, 12, "MX-MOR 12.XX"},
        {19.103435,   -99.467069,     4, 11, "MX-MOR 12.XXX"},
        {18.609217,   -99.017571,     4, 17, "MX-MOR 123.XX"},
        {18.7335,     -99.066,        4, 18, "MX-MOR S5M.3VS"},
        {21.9149,     -102.3215,      5, 15, "MX-AGU 12.XX"},
        {21.875555,   -102.7528205,   4, 14, "MX-AGU 12.XXX"},
        {22.426925,   -102.471134,    4, 14, "MX-AGU 123.XX"},
        {22.3746285,  -102.8430235,   3, 15, "MX-AGU 123.XXX"},
        {19.2783575,  -103.7703655,   5, 12, "MX-CL 12.XX"},
        {19.468104,   -103.9475585,   4, 11, "MX-CL 12.XXX"},
        {19.166511,   -104.4185505,   4, 11, "MX-CL 000.XX"},
        {18.942015,   -104.056010625, 5, 12, "MX-CL J00.XX"},
        {19.353667,   -104.659614,    3, 10, "MX-CL 123.XXX"},
        {20.566403,   -100.422764,    5, 12, "MX-QUE 12.XX"},
        {20.790015,   -100.5721785,   4, 11, "MX-QUE 12.XXX"},
        {20.392269,   -100.1019285,   4, 14, "MX-QUE 123.XX"},
        {20.076381,   -100.5952455,   3, 16, "MX-QUE 123.XXX"},
        {20.129185,   -98.7843735,    5, 15, "MX-HID 12.XX"},
        {20.246415,   -98.9749585,    4, 14, "MX-HID 12.XXX"},
        {20.096545,   -99.39064525,   4, 14, "MX-HID 000.XX"},
        {20.312673,   -99.294760625,  4, 11, "MX-HID 800.XX"},
        {20.490062,   -99.380076125,  4, 11, "MX-HID J00.XX"},
        {20.125904,   -98.507950125,  5, 15, "MX-HID S00.XX"},
        {21.373083,   -99.8068375,    3, 16, "MX-HID 123.XXX"},
        {19.4437715,  -99.1748535,    5, 14, "MX-MX 12.XX"},
        {19.199879,   -99.3087425,    4, 12, "MX-MX 12.XXX"},
        {19.400545,   -99.7797625,    4, 8,  "MX-MX 000.XX"},
        {19.935045,   -99.23676125,   4, 12, "MX-MX 800.XX"},
        {19.718545,   -98.8747625,    4, 14, "MX-MX J00.XX"},
        {19.718545,   -99.4227625,    4, 11, "MX-MX S00.XX"},
        {20.2742305,  -100.541415,    3, 16, "MX-MX 123.XXX"},
        {18.0427,     -92.969974,     6, 11, "MX-TAB 12.XX"},
        {18.146515,   -93.195845,     5, 10, "MX-TAB 12.XXX"},
        {18.041545,   -93.460764375,  4, 8,  "MX-TAB 000.XX"},
        {17.489774,   -91.526676875,  5, 13, "MX-TAB 500.XX"},
        {18.271974,   -93.37434575,   5, 10, "MX-TAB B00.XX"},
        {17.827804,   -92.632226875,  5, 14, "MX-TAB H00.XX"},
        {17.808404,   -91.839126875,  5, 17, "MX-TAB M00.XX"},
        {18.558004,   -92.731906625,  5, 10, "MX-TAB R00.XX"},
        {18.431545,   -93.28965875,   5, 10, "MX-TAB W00.XX"},
        {17.958982,   -94.057515,     3, 16, "MX-TAB 123.XXX"},
        {21.5365,     -104.926616,    5, 11, "MX-NAY 12.XX"},
        {21.548215,   -105.14988,     4, 10, "MX-NAY 12.XXX"},
        {22.474724,   -105.5696745,   4, 16, "MX-NAY 000.XX"},
        {20.831524,   -105.441716,    4, 11, "MX-NAY 800.XX"},
        {21.952045,   -105.317758125, 4, 10, "MX-NAY J00.XX"},
        {21.096404,   -104.548168,    4, 10, "MX-NAY S00.XX"},
        {22.872899,   -106.612432,    3, 12, "MX-NAY 123.XXX"},
        {21.1678,     -101.707916,    5, 17, "MX-GUA 12.XX"},
        {21.028194,   -101.80506,     5, 15, "MX-GUA 00.XXX"},
        {20.781184,   -101.531512,    4, 10, "MX-GUA C0.XXX"},
        {20.640684,   -101.016534375, 4, 8,  "MX-GUA P0.XXX"},
        {20.564504,   -101.292008,    5, 9,  "MX-GUA 000.XX"},
        {21.011904,   -101.367908,    5, 9,  "MX-GUA 400.XX"},
        {20.934404,   -101.545808,    4, 10, "MX-GUA 800.XX"},
        {21.002504,   -101.955908,    4, 12, "MX-GUA D00.XX"},
        {20.933294,   -100.862824,    4, 8,  "MX-GUA J00.XX"},
        {20.375394,   -101.309116125, 4, 12, "MX-GUA M00.XX"},
        {21.164194,   -101.01023975,  4, 13, "MX-GUA Q00.XX"},
        {20.152694,   -101.253516125, 4, 12, "MX-GUA T00.XX"},
        {20.069094,   -100.839716125, 4, 12, "MX-GUA X00.XX"},
        {21.6200035,  -102.0242375,   3, 19, "MX-GUA 123.XXX"},
        {19.0851,     -98.2390145,    5, 11, "MX-PUE 12.XX"},
        {19.142294,   -98.3818775,    5, 15, "MX-PUE 00.XXX"},
        {18.459314,   -97.55510825,   4, 13, "MX-PUE J0.XXX"},
        {18.910524,   -98.630017625,  4, 13, "MX-PUE 000.XX"},
        {19.288824,   -98.6144575,    4, 16, "MX-PUE 800.XX"},
        {19.868224,   -97.54893625,   4, 10, "MX-PUE J00.XX"},
        {20.270604,   -98.168950125,  4, 14, "MX-PUE S00.XX"},
        {18.196329,   -99.077098,     3, 11, "MX-PUE 123.XXX"},
        {21.0111,     -89.659116,     5, 9,  "MX-YUC 12.XX"},
        {20.991895,   -89.954496,     4, 8,  "MX-YUC 12.XXX"},
        {20.743844,   -88.361996,     4, 10, "MX-YUC 000.XX"},
        {21.098874,   -88.33769275,   4, 10, "MX-YUC 600.XX"},
        {21.301545,   -89.84775875,   4, 8,  "MX-YUC C00.XX"},
        {20.272074,   -89.450087125,  4, 11, "MX-YUC J00.XX"},
        {20.611874,   -90.039456,     4, 11, "MX-YUC P00.XX"},
        {21.151374,   -89.34059275,   5, 9,  "MX-YUC V00.XX"},
        {21.2191315,  -90.321563,     3, 7,  "MX-YUC 123.XXX"},
        {22.941818,   -90.263006,     3, 7,  "MX-YUC 12.XXXX"},
        {21.181233,   -86.9073425,    5, 9,  "MX-ROO 12.XX"},
        {21.245787,   -87.172508,     4, 8,  "MX-ROO 12.XXX"},
        {18.686545,   -88.599763125,  4, 8,  "MX-ROO 000.XX"},
        {20.632224,   -87.190496125,  4, 8,  "MX-ROO C00.XX"},
        {19.632624,   -88.19931625,   4, 11, "MX-ROO P00.XX"},
        {21.736826,   -87.62248,      3, 10, "MX-ROO 012.XXX"},
        {21.736826,   -87.122512,     3, 7,  "MX-ROO 112.XXX"},
        {21.245787,   -87.672476,     3, 10, "MX-ROO 212.XXX"},
        {21.245787,   -87.172508,     4, 8,  "MX-ROO 312.XXX"},
        {20.754747,   -88.1675225,    3, 11, "MX-ROO 412.XXX"},
        {20.754747,   -87.6727625,    3, 10, "MX-ROO 512.XXX"},
        {20.754747,   -87.1780025,    3, 7,  "MX-ROO 612.XXX"},
        {20.263707,   -87.1780025,    3, 7,  "MX-ROO 712.XXX"},
        {20.263707,   -89.2906275,    3, 14, "MX-ROO 812.XXX"},
        {20.263707,   -88.7958675,    3, 10, "MX-ROO 912.XXX"},
        {20.263707,   -88.3011075,    3, 10, "MX-ROO B12.XXX"},
        {20.263707,   -87.8063475,    3, 10, "MX-ROO C12.XXX"},
        {19.772667,   -89.2906275,    3, 13, "MX-ROO D12.XXX"},
        {19.772667,   -88.7958675,    3, 10, "MX-ROO F12.XXX"},
        {19.772667,   -88.3011075,    3, 10, "MX-ROO G12.XXX"},
        {19.772667,   -87.8063475,    3, 10, "MX-ROO H12.XXX"},
        {19.281627,   -89.142486,     3, 10, "MX-ROO J12.XXX"},
        {19.281627,   -88.652934,     3, 7,  "MX-ROO K12.XXX"},
        {19.281627,   -88.163382,     3, 7,  "MX-ROO L12.XXX"},
        {19.281627,   -87.67383,      3, 7,  "MX-ROO M12.XXX"},
        {18.790587,   -89.142486,     3, 10, "MX-ROO N12.XXX"},
        {18.790587,   -88.652934,     3, 7,  "MX-ROO P12.XXX"},
        {18.790587,   -88.163382,     3, 7,  "MX-ROO Q12.XXX"},
        {18.790587,   -87.67383,      3, 7,  "MX-ROO R12.XXX"},
        {18.325635,   -89.191442,     3, 12, "MX-ROO S12.XXX"},
        {18.325635,   -88.995621,     4, 10, "MX-ROO T12.XXX"},
        {18.594171,   -87.967562,     4, 8,  "MX-ROO V12.XXX"},
        {24.8289,     -107.4312985,   6, 10, "MX-SIN 12.XX"},
        {24.926915,   -107.743815,    5, 9,  "MX-SIN 12.XXX"},
        {23.350954,   -106.495797625, 4, 10, "MX-SIN 000.XX"},
        {25.818424,   -109.05387025,  4, 10, "MX-SIN 800.XX"},
        {25.665424,   -108.65607025,  4, 10, "MX-SIN J00.XX"},
        {25.476404,   -108.25281425,  4, 8,  "MX-SIN S00.XX"},
        {27.0247045,  -109.3699435,   3, 10, "MX-SIN 123.XXX"},
        {24.87693,    -108.0697905,   4, 8,  "MX-SIN 12.XXXX"},
        {19.854785,   -90.5670475,    6, 10, "MX-CAM 12.XX"},
        {20.045615,   -90.6772585,    5, 9,  "MX-CAM 12.XXX"},
        {18.786545,   -91.875763125,  5, 10, "MX-CAM 000.XX"},
        {19.475324,   -90.7847575,    5, 9,  "MX-CAM C00.XX"},
        {18.665824,   -90.890977625,  5, 9,  "MX-CAM P00.XX"},
        {18.261628,   -91.3292165,    5, 14, "MX-CAM 123.XXX"},
        {18.056109,   -92.3884185,    4, 13, "MX-CAM 12.XXXX"},
        {19.7376,     -101.2349145,   6, 10, "MX-MIC 12.XX"},
        {19.783405,   -101.39937925,  5, 9,  "MX-MIC 00.XXX"},
        {19.429314,   -102.2460345,   5, 12, "MX-MIC J0.XXX"},
        {19.967204,   -102.35672725,  5, 12, "MX-MIC 000.XX"},
        {19.111045,   -102.4036575,   5, 12, "MX-MIC 400.XX"},
        {19.445804,   -100.4512475,   4, 11, "MX-MIC 800.XX"},
        {18.032745,   -102.33476375,  5, 9,  "MX-MIC D00.XX"},
        {20.314694,   -102.099416125, 5, 15, "MX-MIC J00.XX"},
        {20.043594,   -102.754316125, 5, 12, "MX-MIC M00.XX"},
        {19.674194,   -100.64940825,  4, 8,  "MX-MIC Q00.XX"},
        {19.814194,   -101.85940825,  5, 11, "MX-MIC T00.XX"},
        {19.557094,   -101.72860825,  5, 11, "MX-MIC X00.XX"},
        {20.1624065,  -102.9462385,   4, 11, "MX-MIC 123.XXX"},
        {19.974677,   -103.5705345,   3, 10, "MX-MIC 12.XXXX"},
        {22.1935,     -101.0160565,   6, 12, "MX-SLP 12.XX"},
        {22.323415,   -101.11178,     5, 11, "MX-SLP 12.XXX"},
        {22.031704,   -99.049920625,  4, 8,  "MX-SLP 000.XX"},
        {23.699044,   -100.736453125, 5, 12, "MX-SLP 700.XX"},
        {21.953344,   -100.063277625, 5, 9,  "MX-SLP F00.XX"},
        {21.369444,   -98.92018375,   4, 11, "MX-SLP M00.XX"},
        {22.204744,   -98.5526715,    4, 14, "MX-SLP T00.XX"},
        {21.792768,   -102.2985055,   3, 17, "MX-SLP 123.XXX"},
        {23.559525,   -100.9536825,   4, 13, "MX-SLP 12.XXXX"},
        {16.87616,    -99.928007,     6, 9,  "MX-GRO 12.XX"},
        {17.156115,   -100.1033235,   5, 8,  "MX-GRO 12.XXX"},
        {17.659545,   -99.571764375,  5, 8,  "MX-GRO 000.XX"},
        {18.399244,   -99.59493175,   5, 12, "MX-GRO 700.XX"},
        {17.698744,   -101.663637875, 4, 7,  "MX-GRO F00.XX"},
        {18.595744,   -99.652225625,  5, 12, "MX-GRO M00.XX"},
        {17.643644,   -98.654637875,  4, 9,  "MX-GRO T00.XX"},
        {18.490051,   -102.0854695,   3, 11, "MX-GRO 123.XXX"},
        {18.548859,   -100.1420795,   4, 14, "MX-GRO 12.XXXX"},
        {25.7331,     -100.3476985,   5, 12, "MX-NLE 12.XX"},
        {25.6768495,  -100.613677,    4, 11, "MX-NLE 12.XXX"},
        {25.293774,   -100.0810065,   4, 12, "MX-NLE 000.XX"},
        {24.916024,   -99.7203315,    4, 11, "MX-NLE C00.XX"},
        {27.537024,   -99.756447375,  4, 13, "MX-NLE P00.XX"},
        {23.347861,   -100.8689795,   3, 14, "MX-NLE 123.XXX"},
        {27.650844,   -101.062323,    3, 11, "MX-NLE 12.XXXX"},
        {32.540999,   -117.064426,    5, 12, "MX-BCN 12.XX"},
        {32.462396,   -117.095131,    4, 8,  "MX-BCN 12.XXX"},
        {32.605494,   -115.593379,    4, 10, "MX-BCN 000.XX"},
        {31.956804,   -116.81622925,  4, 8,  "MX-BCN J00.XX"},
        {32.6736995,  -117.428154,    1, 5,  "MX-BCN 123.XXX"},
        {29.317187,   -115.985944,    4, 8,  "MX-BCN 12.XXXX"},
        {30.493485,   -118.2796315,   1, 3,  "MX-BCN 1234.XX"},
        {19.21539,    -96.2069625,    5, 9,  "MX-VER 00.XX"},
        {19.148025,   -96.1838695,    5, 9,  "MX-VER J0.XX"},
        {19.277894,   -96.3244775,    4, 8,  "MX-VER 00.XXX"},
        {19.540314,   -97.1474345,    4, 11, "MX-VER J0.XXX"},
        {18.088904,   -94.53146675,   4, 11, "MX-VER 000.XX"},
        {20.568545,   -97.491675625,  4, 11, "MX-VER 400.XX"},
        {18.048545,   -94.73276375,   4, 11, "MX-VER 800.XX"},
        {18.898404,   -97.054706625,  5, 12, "MX-VER D00.XX"},
        {18.842004,   -97.224406625,  4, 11, "MX-VER J00.XX"},
        {20.969504,   -97.476508,     4, 8,  "MX-VER N00.XX"},
        {18.469545,   -95.317763125,  6, 14, "MX-VER S00.XX"},
        {20.081894,   -97.102016125,  5, 12, "MX-VER X00.XX"},
        {19.9225505,  -97.3528655,    3, 11, "MX-VER 123.XXX"},
        {18.614229,   -96.159451,     4, 10, "MX-VER 12.XXXX"},
        {22.302191,   -98.582609,     3, 13, "MX-VER 1234.XX"},
        {16.7652935,  -93.168528,     7, 12, "MX-CHP 12.XX"},
        {16.928951,   -93.364265,     6, 11, "MX-CHP 12.XXX"},
        {16.330645,   -92.16976625,   7, 12, "MX-CHP 000.XX"},
        {16.684824,   -92.685159125,  6, 11, "MX-CHP C00.XX"},
        {14.956124,   -92.4241205,    4, 7,  "MX-CHP P00.XX"},
        {17.1781485,  -94.134421,     4, 16, "MX-CHP 123.XXX"},
        {16.2232895,  -94.080965,     5, 13, "MX-CHP 12.XXXX"},
        {24.1751,     -110.344258,    5, 9,  "MX-BCS 12.XX"},
        {24.340115,   -110.547115,    4, 8,  "MX-BCS 12.XXX"},
        {23.236545,   -109.80375625,  4, 8,  "MX-BCS 000.XX"},
        {26.005324,   -111.584710125, 4, 8,  "MX-BCS 800.XX"},
        {23.024924,   -110.07945325,  4, 8,  "MX-BCS J00.XX"},
        {25.045504,   -111.7435795,   4, 8,  "MX-BCS S00.XX"},
        {25.404391,   -112.200293,    4, 8,  "MX-BCS 123.XXX"},
        {27.74733,    -113.5202385,   3, 9,  "MX-BCS 12.XXXX"},
        {27.81429,    -116.5462725,   1, 3,  "MX-BCS 1234.XX"},
        {22.776545,   -102.62875625,  5, 11, "MX-ZAC 00.XX"},
        {22.743035,   -102.55095225,  5, 14, "MX-ZAC J0.XX"},
        {22.980115,   -102.7969935,   4, 10, "MX-ZAC 12.XXX"},
        {23.181704,   -102.92307325,  4, 10, "MX-ZAC 000.XX"},
        {22.639944,   -102.2935715,   4, 14, "MX-ZAC 700.XX"},
        {22.670944,   -103.1163715,   4, 13, "MX-ZAC F00.XX"},
        {23.844444,   -103.212241875, 4, 10, "MX-ZAC M00.XX"},
        {22.268844,   -102.1164715,   4, 18, "MX-ZAC T00.XX"},
        {23.022298,   -104.262379,    3, 13, "MX-ZAC 123.XXX"},
        {24.570272,   -104.0145625,   3, 11, "MX-ZAC 1234.XX"},
        {20.7004,     -103.378816,    5, 9,  "MX-JAL 12.XX"},
        {20.827015,   -103.5142585,   4, 8,  "MX-JAL 12.XXX"},
        {20.696704,   -105.289168,    4, 12, "MX-JAL 000.XX"},
        {19.656744,   -103.53400725,  4, 11, "MX-JAL 700.XX"},
        {21.391644,   -102.07558375,  4, 16, "MX-JAL F00.XX"},
        {20.881545,   -102.798304,    4, 8,  "MX-JAL M00.XX"},
        {20.458545,   -102.951510625, 4, 8,  "MX-JAL T00.XX"},
        {20.3235755,  -105.585269,    3, 7,  "MX-JAL 123.XXX"},
        {21.4337415,  -104.28708,     3, 13, "MX-JAL 1234.XX"},
        {22.297441,   -97.8967285,    5, 12, "MX-TAM 12.XX"},
        {22.472494,   -98.1592065,    4, 10, "MX-TAM 00.XXX"},
        {26.006114,   -98.429351625,  4, 13, "MX-TAM J0.XXX"},
        {25.863224,   -97.675710125,  4, 10, "MX-TAM 000.XX"},
        {27.522624,   -99.740247375,  4, 14, "MX-TAM 800.XX"},
        {23.846724,   -99.210771875,  4, 13, "MX-TAM J00.XX"},
        {22.797404,   -99.09927325,   4, 11, "MX-TAM S00.XX"},
        {22.248028,   -100.166861,    3, 11, "MX-TAM 123.XXX"},
        {27.515684,   -99.804716,     3, 15, "MX-TAM 12.XXXX"},
        {17.1003,     -96.766174,     5, 8,  "MX-OAX 12.XX"},
        {17.195615,   -96.8747235,    4, 9,  "MX-OAX 12.XXX"},
        {18.154545,   -96.19118875,   4, 11, "MX-OAX 000.XX"},
        {16.311824,   -95.32111925,   4, 7,  "MX-OAX 800.XX"},
        {16.588254,   -95.220071625,  4, 7,  "MX-OAX J00.XX"},
        {17.823104,   -97.902943875,  4, 10, "MX-OAX S00.XX"},
        {16.0139715,  -98.579098,     3, 6,  "MX-OAX 123.XXX"},
        {18.176926,   -96.157441,     3, 10, "MX-OAX 12.XXXX"},
        {24.046863,   -104.7112355,   5, 9,  "MX-DUR 12.XX"},
        {24.260715,   -104.819715,    4, 8,  "MX-DUR 12.XXX"},
        {25.636774,   -103.63690325,  4, 12, "MX-DUR 000.XX"},
        {25.108024,   -105.4483315,   4, 11, "MX-DUR C00.XX"},
        {23.860924,   -105.455391875, 4, 11, "MX-DUR P00.XX"},
        {24.5386475,  -106.0996865,   4, 11, "MX-DUR 123.XXX"},
        {26.5985355,  -107.1062355,   3, 13, "MX-DUR 12.XXXX"},
        {26.6632435,  -104.715565,    3, 11, "MX-DUR 1234.XX"},
        {25.378531,   -101.0368785,   5, 11, "MX-COA 12.XX"},
        {25.595494,   -101.10929275,  4, 10, "MX-COA 00.XXX"},
        {25.632914,   -103.53387275,  4, 14, "MX-COA J0.XXX"},
        {26.908124,   -101.535268625, 4, 9,  "MX-COA 000.XX"},
        {28.747124,   -100.665405875, 4, 10, "MX-COA 800.XX"},
        {29.325324,   -101.071985625, 4, 10, "MX-COA J00.XX"},
        {27.923204,   -101.310837375, 4, 10, "MX-COA S00.XX"},
        {25.941686,   -103.4378605,   3, 13, "MX-COA 123.XXX"},
        {27.083138,   -103.866729,    3, 11, "MX-COA 12.XXXX"},
        {29.5652615,  -101.790813,    3, 9,  "MX-COA 1234.XX"},
        {29.1444,     -111.010442,    5, 9,  "MX-SON 12.XX"},
        {29.217494,   -111.155714375, 4, 8,  "MX-SON 00.XXX"},
        {27.496514,   -110.144415625, 4, 10, "MX-SON J0.XXX"},
        {31.262344,   -111.0704795,   4, 8,  "MX-SON 000.XX"},
        {32.411774,   -114.852291,    4, 11, "MX-SON 600.XX"},
        {27.130474,   -109.601554625, 4, 10, "MX-SON C00.XX"},
        {27.963074,   -110.990428125, 4, 11, "MX-SON J00.XX"},
        {31.288474,   -109.6458175,   4, 8,  "MX-SON P00.XX"},
        {30.703774,   -112.221111875, 4, 8,  "MX-SON V00.XX"},
        {28.648665,   -111.3507945,   3, 7,  "MX-SON 123.XXX"},
        {31.1451035,  -111.3754015,   4, 8,  "MX-SON 12.XXXX"},
        {32.014264,   -115.010503,    3, 10, "MX-SON 0123.XX"},
        {31.52594,    -115.0053235,   3, 10, "MX-SON 6123.XX"},
        {31.918771,   -114.4584835,   3, 11, "MX-SON 1123.XX"},
        {31.425017,   -114.4584835,   3, 11, "MX-SON 7123.XX"},
        {31.751818,   -113.9116435,   3, 11, "MX-SON 2123.XX"},
        {31.258063,   -113.9116435,   3, 9,  "MX-SON 8123.XX"},
        {31.584864,   -113.3648035,   3, 11, "MX-SON 3123.XX"},
        {31.584864,   -112.8179635,   3, 12, "MX-SON 4123.XX"},
        {31.584864,   -112.2711235,   3, 10, "MX-SON 5123.XX"},
        {31.091109,   -113.4194875,   3, 9,  "MX-SON 9123.XX"},
        {31.091109,   -112.8726475,   3, 9,  "MX-SON B123.XX"},
        {31.091109,   -112.3258075,   3, 7,  "MX-SON C123.XX"},
        {31.091109,   -111.7789675,   3, 7,  "MX-SON D123.XX"},
        {30.600069,   -113.419516,    3, 9,  "MX-SON F123.XX"},
        {30.600069,   -112.877884,    3, 9,  "MX-SON G123.XX"},
        {30.600069,   -112.336252,    3, 7,  "MX-SON H123.XX"},
        {30.600069,   -111.79462,     3, 7,  "MX-SON J123.XX"},
        {30.111744,   -113.1543525,   3, 9,  "MX-SON K123.XX"},
        {30.111744,   -112.6179285,   3, 7,  "MX-SON L123.XX"},
        {30.111744,   -112.0815045,   3, 7,  "MX-SON M123.XX"},
        {29.617989,   -113.1543525,   3, 10, "MX-SON N123.XX"},
        {29.617989,   -112.6179285,   3, 7,  "MX-SON P123.XX"},
        {29.617989,   -112.0815045,   3, 7,  "MX-SON Q123.XX"},
        {29.129664,   -112.617957,    3, 7,  "MX-SON R123.XX"},
        {29.129664,   -112.086741,    3, 7,  "MX-SON S123.XX"},
        {28.635909,   -112.617957,    3, 7,  "MX-SON T123.XX"},
        {28.635909,   -112.086741,    3, 7,  "MX-SON V123.XX"},
        {28.147584,   -112.4002915,   3, 7,  "MX-SON W123.XX"},
        {28.341285,   -111.879463,    4, 8,  "MX-SON X123.XX"},
        {31.7601,     -106.5101245,   5, 14, "MX-CHH 12.XX"},
        {31.711394,   -106.6787225,   4, 10, "MX-CHH 00.XXX"},
        {28.719614,   -106.217769125, 4, 9,  "MX-CHH J0.XXX"},
        {28.269724,   -105.609427125, 4, 9,  "MX-CHH 000.XX"},
        {26.964045,   -105.857748125, 4, 11, "MX-CHH 800.XX"},
        {28.447724,   -106.955027125, 4, 8,  "MX-CHH J00.XX"},
        {30.453704,   -108.051814125, 4, 8,  "MX-CHH S00.XX"},
        {27.6666125,  -108.260591,    3, 7,  "MX-CHH 123.XXX"},
        {30.0654505,  -108.305391,    3, 7,  "MX-CHH 1234.XX"},
        {30.9393865,  -108.891375,    3, 10, "MX-CHH 01.XXXX"},
        {30.85066,    -108.9058695,   3, 10, "MX-CHH 11.XXXX"},
        {30.419295,   -108.665323,    3, 10, "MX-CHH 21.XXXX"},
        {29.323516,   -108.7412125,   3, 10, "MX-CHH 31.XXXX"},
        {28.6557575,  -108.743681,    3, 10, "MX-CHH 41.XXXX"},
        {28.144708,   -109.037735,    3, 10, "MX-CHH 51.XXXX"},
        {27.850209,   -108.993487,    3, 10, "MX-CHH 61.XXXX"},
        {27.3435535,  -108.743826,    3, 10, "MX-CHH 71.XXXX"},
        {31.185011,   -105.78756,     3, 9,  "MX-CHH 81.XXXX"},
        {30.3348315,  -105.8030405,   3, 8,  "MX-CHH 91.XXXX"},
        {30.3348315,  -105.2600405,   3, 8,  "MX-CHH B1.XXXX"},
        {30.2044225,  -105.7855275,   3, 8,  "MX-CHH C1.XXXX"},
        {30.2044225,  -105.1725275,   3, 9,  "MX-CHH D1.XXXX"},
        {29.8295825,  -105.786731,    3, 8,  "MX-CHH F1.XXXX"},
        {29.8295825,  -105.222731,    3, 9,  "MX-CHH G1.XXXX"},
        {29.8295825,  -104.658731,    3, 9,  "MX-CHH H1.XXXX"},
        {28.895709,   -105.8041875,   3, 8,  "MX-CHH J1.XXXX"},
        {28.895709,   -105.264944,    3, 8,  "MX-CHH K1.XXXX"},
        {28.895709,   -104.7220935,   3, 8,  "MX-CHH L1.XXXX"},
        {28.895709,   -104.179207,    3, 8,  "MX-CHH M1.XXXX"},
        {28.402209,   -105.8041875,   3, 8,  "MX-CHH N1.XXXX"},
        {28.402209,   -105.264944,    3, 8,  "MX-CHH P1.XXXX"},
        {28.402209,   -104.7220935,   3, 8,  "MX-CHH Q1.XXXX"},
        {28.402209,   -104.179207,    3, 8,  "MX-CHH R1.XXXX"},
        {28.919349,   -103.6223685,   3, 11, "MX-CHH S1.XXXX"},
        {27.886303,   -104.218766,    3, 8,  "MX-CHH T1.XXXX"},
        {27.514576,   -104.218302,    3, 8,  "MX-CHH V1.XXXX"},
        {26.727303,   -104.2191345,   3, 11, "MX-CHH W1.XXXX"},
        {26.059512,   -107.834297,    3, 10, "MX-CHH X1.XXXX"},
        {25.924256,   -107.154049,    3, 13, "MX-CHH Y1.XXXX"},
        {25.660939,   -107.1534705,   3, 13, "MX-CHH Z1.XXXX"},
        {64.20745,    -51.7505725,    5, 6,  "GRL 12.XX"},
        {64.381115,   -52.1772135,    4, 5,  "GRL 12.XXX"},
        {66.944804,   -53.89055275,   4, 6,  "GRL 000.XX"},
        {69.211194,   -51.18224425,   4, 5,  "GRL 400.XX"},
        {60.711194,   -46.09331225,   4, 5,  "GRL 700.XX"},
        {68.704194,   -53.071223,     4, 6,  "GRL B00.XX"},
        {68.704194,   -52.668536,     4, 6,  "GRL F00.XX"},
        {65.411194,   -53.0771095,    4, 6,  "GRL J00.XX"},
        {62.00317,    -49.763126625,  3, 4,  "GRL M00.XX"},
        {65.609194,   -37.817643375,  3, 4,  "GRL Q00.XX"},
        {60.911194,   -46.20341175,   4, 5,  "GRL T00.XX"},
        {60.137194,   -45.385630625,  4, 5,  "GRL X00.XX"},
        {60.908421,   -48.4124085,    3, 4,  "GRL 123.XXX"},
        {63.822741,   -53.9198035,    3, 5,  "GRL 12.XXXX"},
        {69.25209,    -54.001908,     3, 5,  "GRL 1234.XX"},
        {62.8829385,  -54.9719455,    2, 4,  "GRL 1234.XXX"},
        {80.1704935,  -71.34761,      2, 6,  "GRL 123.XXXX"},
        {81.961383,   -71.00318,      2, 6,  "GRL 1234.XXXX"},
        {24.7067,     46.681442,      6, 7,  "SAU 12.XX"},
        {21.732555,   39.08812725,    4, 5,  "SAU 00.XXX"},
        {24.680314,   46.57007975,    5, 6,  "SAU J0.XXX"},
        {28.372714,   36.498273125,   4, 6,  "SAU 000.XX"},
        {26.345214,   43.901431125,   4, 5,  "SAU 200.XX"},
        {21.513924,   39.75318225,    4, 5,  "SAU 400.XX"},
        {21.513924,   39.84591725,    4, 5,  "SAU 500.XX"},
        {21.513924,   39.93865225,    4, 5,  "SAU 600.XX"},
        {21.427435,   39.73463525,    4, 5,  "SAU 700.XX"},
        {21.427435,   39.82737025,    4, 5,  "SAU 800.XX"},
        {24.500724,   39.53537825,    4, 5,  "SAU 900.XX"},
        {24.500724,   39.63003525,    4, 5,  "SAU B00.XX"},
        {24.414235,   39.53537825,    4, 5,  "SAU C00.XX"},
        {24.414235,   39.63003525,    4, 5,  "SAU D00.XX"},
        {26.470724,   50.006487125,   5, 6,  "SAU F00.XX"},
        {26.470724,   50.102826125,   5, 6,  "SAU G00.XX"},
        {26.384235,   49.951573125,   5, 6,  "SAU H00.XX"},
        {26.384235,   50.047912125,   5, 6,  "SAU J00.XX"},
        {26.384235,   50.144251125,   5, 6,  "SAU K00.XX"},
        {26.297746,   50.134843875,   5, 6,  "SAU L00.XX"},
        {21.302924,   40.38148225,    4, 5,  "SAU M00.XX"},
        {25.390645,   49.54474875,    5, 6,  "SAU N00.XX"},
        {25.472745,   49.50933975,    5, 6,  "SAU P00.XX"},
        {18.327245,   42.68393625,    4, 6,  "SAU Q00.XX"},
        {27.558345,   41.656353125,   4, 5,  "SAU R00.XX"},
        {24.171545,   47.262845625,   5, 6,  "SAU S00.XX"},
        {28.466324,   45.915283125,   4, 5,  "SAU T00.XX"},
        {18.240295,   42.48023625,    4, 6,  "SAU V00.XX"},
        {31.022624,   40.9857405,     4, 6,  "SAU W00.XX"},
        {26.594524,   49.996187125,   5, 6,  "SAU X00.XX"},
        {26.130124,   43.959013875,   4, 5,  "SAU Y00.XX"},
        {24.114045,   38.011036625,   4, 5,  "SAU Z00.XX"},
        {25.429022,   45.7112695,     3, 4,  "SAU 12.XXXX"},
        {27.518209,   47.4253805,     3, 4,  "SAU 1234.XX"},
        {24.898515,   46.509785,      4, 5,  "SAU 012.XXX"},
        {21.715115,   39.08582,       3, 4,  "SAU 112.XXX"},
        {21.644515,   39.58002,       3, 4,  "SAU 212.XXX"},
        {24.660115,   39.385885,      3, 4,  "SAU 312.XXX"},
        {26.699815,   49.74585,       4, 5,  "SAU 412.XXX"},
        {21.498915,   40.14272,       3, 4,  "SAU 512.XXX"},
        {28.584315,   36.3346365,     3, 5,  "SAU 612.XXX"},
        {26.427515,   43.7554715,     3, 4,  "SAU 712.XXX"},
        {25.542115,   49.2963715,     5, 6,  "SAU 812.XXX"},
        {18.466215,   42.398255,      3, 5,  "SAU 912.XXX"},
        {27.725015,   41.4701365,     3, 4,  "SAU B12.XXX"},
        {24.274015,   47.015885,      4, 5,  "SAU C12.XXX"},
        {28.630115,   45.7311365,     3, 4,  "SAU D12.XXX"},
        {31.182015,   40.79218,       3, 5,  "SAU F12.XXX"},
        {24.292015,   37.948685,      3, 4,  "SAU G12.XXX"},
        {27.176215,   49.41825,       4, 5,  "SAU H12.XXX"},
        {31.530115,   37.1018665,     3, 6,  "SAU J12.XXX"},
        {30.090115,   39.8016015,     3, 5,  "SAU K12.XXX"},
        {26.149515,   43.2822715,     3, 4,  "SAU L12.XXX"},
        {17.797815,   44.067955,      3, 5,  "SAU M12.XXX"},
        {17.225115,   42.472155,      3, 5,  "SAU N12.XXX"},
        {28.500315,   48.1555365,     4, 5,  "SAU P12.XXX"},
        {20.210115,   42.3850415,     3, 4,  "SAU Q12.XXX"},
        {26.421215,   44.6266715,     3, 4,  "SAU R12.XXX"},
        {24.690115,   44.152885,      3, 4,  "SAU S12.XXX"},
        {17.670115,   46.902155,      3, 5,  "SAU T12.XXX"},
        {31.870115,   38.4218665,     3, 6,  "SAU V12.XXX"},
        {25.984415,   49.3130715,     4, 5,  "SAU W12.XXX"},
        {23.000115,   38.8004065,     3, 4,  "SAU X12.XXX"},
        {29.830115,   43.2665015,     3, 5,  "SAU Y12.XXX"},
        {24.120115,   42.702885,      3, 4,  "SAU Z12.XXX"},
        {32.0993885,  36.135477,      2, 6,  "SAU 0123.XXX"},
        {32.0993885,  39.20395,       2, 6,  "SAU 1123.XXX"},
        {32.0993885,  42.272423,      2, 4,  "SAU 2123.XXX"},
        {29.4345145,  34.5975315,     2, 4,  "SAU 3123.XXX"},
        {29.4345145,  37.5766315,     2, 3,  "SAU 4123.XXX"},
        {29.4345145,  40.5557315,     2, 4,  "SAU 5123.XXX"},
        {29.4345145,  43.5348315,     3, 5,  "SAU 6123.XXX"},
        {29.4345145,  46.5139315,     2, 4,  "SAU 7123.XXX"},
        {29.4345145,  47.7055715,     3, 9,  "SAU 8123.XXX"},
        {26.7533245,  35.8464885,     2, 4,  "SAU 9123.XXX"},
        {26.7533245,  38.7660065,     2, 3,  "SAU B123.XXX"},
        {26.7533245,  41.6855245,     2, 3,  "SAU C123.XXX"},
        {26.7533245,  44.6050425,     2, 3,  "SAU D123.XXX"},
        {26.7533245,  47.5245605,     3, 4,  "SAU F123.XXX"},
        {26.7533245,  50.4440785,     2, 3,  "SAU G123.XXX"},
        {24.0721345,  37.9994175,     3, 4,  "SAU H123.XXX"},
        {24.0721345,  40.8593535,     2, 3,  "SAU J123.XXX"},
        {24.0721345,  43.7192895,     2, 3,  "SAU K123.XXX"},
        {24.0721345,  46.5792255,     3, 4,  "SAU L123.XXX"},
        {24.0721345,  49.4391615,     2, 3,  "SAU M123.XXX"},
        {22.8348445,  52.2939255,     2, 4,  "SAU N123.XXX"},
        {21.3909445,  38.8681235,     2, 3,  "SAU P123.XXX"},
        {21.3909445,  41.6684775,     2, 3,  "SAU Q123.XXX"},
        {21.3909445,  44.4688315,     2, 3,  "SAU R123.XXX"},
        {21.3909445,  47.2691855,     2, 3,  "SAU S123.XXX"},
        {21.3909445,  50.0695395,     2, 3,  "SAU T123.XXX"},
        {21.3909445,  52.8698935,     2, 4,  "SAU V123.XXX"},
        {18.7097545,  40.717006,      2, 3,  "SAU W123.XXX"},
        {19.7659145,  43.4583765,     3, 4,  "SAU X123.XXX"},
        {19.4977955,  46.2587305,     3, 4,  "SAU Y123.XXX"},
        {20.8547065,  49.0596245,     3, 4,  "SAU Z123.XXX"},
        {24.6716,     46.7227,        6, 7,  "SAU KGXF.DFDN"},
        {-4.304075,   15.282348,      5, 9,  "COD 12.XX"},
        {-4.490975,   15.172273625,   4, 8,  "COD 00.XXX"},
        {-11.549316,  27.323203625,   4, 6,  "COD C0.XXX"},
        {-6.091016,   23.53249075,    4, 6,  "COD P0.XXX"},
        {-10.677276,  25.44654275,    5, 7,  "COD 000.XX"},
        {-5.849276,   22.35909425,    4, 6,  "COD 100.XX"},
        {0.567624,    25.14972,       4, 5,  "COD 200.XX"},
        {-10.952676,  26.69484275,    4, 6,  "COD 300.XX"},
        {-5.779876,   13.01669425,    3, 5,  "COD 400.XX"},
        {-6.390276,   20.74389425,    4, 6,  "COD 500.XX"},
        {-2.467076,   28.80972,       5, 6,  "COD 600.XX"},
        {-5.787776,   13.43119425,    4, 6,  "COD 700.XX"},
        {-4.999876,   18.766507125,   4, 6,  "COD 800.XX"},
        {-3.342476,   29.117207125,   4, 6,  "COD 900.XX"},
        {-6.965776,   23.410981375,   4, 6,  "COD B00.XX"},
        {0.076524,    18.21982,       4, 6,  "COD C00.XX"},
        {0.161824,    29.25612,       5, 6,  "COD D00.XX"},
        {-1.618376,   29.16542,       5, 7,  "COD F00.XX"},
        {2.786564,    27.583485,      4, 5,  "COD G00.XX"},
        {1.560304,    30.222845,      5, 8,  "COD GK0.00"},
        {3.258964,    19.746799375,   4, 6,  "COD H00.XX"},
        {-2.954296,   25.901145,      4, 5,  "COD HK0.00"},
        {-3.303236,   17.353099375,   4, 6,  "COD J00.XX"},
        {-4.338296,   20.569673125,   4, 5,  "COD JK0.00"},
        {-5.914836,   29.15801375,    4, 5,  "COD K00.XX"},
        {0.490304,    29.438645,      5, 6,  "COD KK0.00"},
        {-6.720036,   23.91791375,    4, 6,  "COD L00.XX"},
        {2.190004,    22.442345,      4, 5,  "COD LK0.00"},
        {-5.235836,   14.837999375,   4, 6,  "COD M00.XX"},
        {-11.764796,  27.223038875,   4, 6,  "COD MK0.00"},
        {-8.721936,   24.9666415,     4, 6,  "COD N00.XX"},
        {2.159004,    21.488745,      4, 5,  "COD NK0.00"},
        {-3.509736,   23.577499375,   4, 5,  "COD P00.XX"},
        {-6.146496,   24.45540025,    4, 5,  "COD PK0.00"},
        {-4.425236,   26.634499375,   4, 5,  "COD Q00.XX"},
        {-4.855396,   21.534173125,   4, 6,  "COD QK0.00"},
        {4.297264,    20.973199375,   4, 7,  "COD R00.XX"},
        {-4.559896,   18.580373125,   4, 7,  "COD RK0.00"},
        {2.817364,    24.703585,      4, 6,  "COD S00.XX"},
        {1.249104,    23.574645,      4, 5,  "COD SK0.00"},
        {-4.957536,   23.398999375,   4, 6,  "COD T00.XX"},
        {-2.719196,   17.664245,      4, 6,  "COD TK0.00"},
        {-1.924436,   18.259885,      4, 6,  "COD V00.XX"},
        {-5.015096,   12.917173125,   4, 8,  "COD VK0.00"},
        {-4.056736,   19.537299375,   4, 5,  "COD W00.XX"},
        {-4.818396,   17.008773125,   4, 7,  "COD WK0.00"},
        {-9.150036,   25.8002415,     4, 6,  "COD X00.XX"},
        {0.773804,    24.414345,      4, 5,  "COD XK0.00"},
        {-7.284836,   27.358228125,   4, 5,  "COD Y00.XX"},
        {2.734104,    23.753945,      4, 6,  "COD YK0.00"},
        {-5.321636,   21.37701375,    4, 6,  "COD Z00.XX"},
        {-10.875896,  26.57351075,    4, 6,  "COD ZK0.00"},
        {-4.6389965,  21.9475615,     3, 5,  "COD 123.XXX"},
        {-4.66093,    15.05181,       3, 7,  "COD 31.XXXX"},
        {-10.735725,  25.2432705,     3, 5,  "COD 41.XXXX"},
        {0.315174,    24.98182,       3, 4,  "COD 51.XXXX"},
        {-11.161725,  26.4524205,     3, 5,  "COD 61.XXXX"},
        {-6.036275,   13.05628,       3, 5,  "COD 71.XXXX"},
        {-6.642725,   20.57623,       3, 5,  "COD 81.XXXX"},
        {-2.695625,   28.62162,       3, 4,  "COD 91.XXXX"},
        {-5.252325,   18.59872,       3, 5,  "COD B1.XXXX"},
        {-3.594925,   28.84942,       3, 4,  "COD C1.XXXX"},
        {-0.175926,   18.05192,       3, 5,  "COD D1.XXXX"},
        {0.096924,    29.17217,       4, 5,  "COD F1.XXXX"},
        {-1.870825,   28.99752,       4, 6,  "COD G1.XXXX"},
        {2.562374,    27.40582,       3, 5,  "COD H1.XXXX"},
        {1.556374,    29.92587,       4, 7,  "COD J1.XXXX"},
        {3.034774,    19.56922,       3, 5,  "COD K1.XXXX"},
        {-3.160125,   25.71862,       3, 4,  "COD L1.XXXX"},
        {-3.527425,   17.17552,       3, 5,  "COD M1.XXXX"},
        {-4.544125,   20.38722,       3, 5,  "COD N1.XXXX"},
        {-6.139025,   28.98053,       4, 5,  "COD P1.XXXX"},
        {1.984174,    22.25982,       3, 4,  "COD Q1.XXXX"},
        {-5.325875,   14.80092,       3, 5,  "COD R1.XXXX"},
        {-11.970625,  27.0439205,     3, 5,  "COD S1.XXXX"},
        {-8.946125,   24.7922105,     3, 5,  "COD T1.XXXX"},
        {1.953174,    21.30622,       3, 4,  "COD V1.XXXX"},
        {-3.733925,   23.39992,       3, 4,  "COD W1.XXXX"},
        {-4.649425,   26.45692,       3, 4,  "COD X1.XXXX"},
        {-5.061225,   21.35172,       3, 5,  "COD Y1.XXXX"},
        {4.080674,    20.88352,       3, 5,  "COD Z1.XXXX"},
        {-4.788135,   18.3747,        3, 6,  "COD 0123.XX"},
        {2.570764,    24.5027,        3, 5,  "COD 1123.XX"},
        {1.020864,    23.3689,        3, 4,  "COD 2123.XX"},
        {-2.947435,   17.4585,        3, 5,  "COD 3123.XX"},
        {-2.171035,   18.059,         3, 5,  "COD 4123.XX"},
        {-5.243335,   12.7115,        3, 5,  "COD 5123.XX"},
        {-4.303335,   19.3365,        3, 4,  "COD 6123.XX"},
        {-5.046635,   16.8031,        3, 6,  "COD 7123.XX"},
        {-9.396635,   25.6023325,     3, 5,  "COD 8123.XX"},
        {0.545564,    24.2086,        3, 4,  "COD 9123.XX"},
        {-7.52872,    27.15761,       3, 4,  "COD B123.XX"},
        {2.505864,    23.5482,        3, 5,  "COD C123.XX"},
        {-5.568235,   21.17631,       3, 5,  "COD D123.XX"},
        {-5.624135,   25.51821,       3, 4,  "COD F123.XX"},
        {-3.254135,   16.6882,        3, 5,  "COD G123.XX"},
        {-0.454135,   20.6282,        3, 4,  "COD H123.XX"},
        {-3.834135,   26.4382,        3, 4,  "COD J123.XX"},
        {3.875864,    22.2082,        3, 5,  "COD K123.XX"},
        {-5.614135,   26.74821,       3, 4,  "COD L123.XX"},
        {2.810864,    22.01817,       3, 5,  "COD M123.XX"},
        {0.465864,    22.6482,        3, 4,  "COD N123.XX"},
        {3.055864,    25.2782,        3, 5,  "COD P123.XX"},
        {-2.954135,   17.9082,        4, 6,  "COD Q123.XX"},
        {3.105864,    20.6382,        3, 5,  "COD R123.XX"},
        {-6.28142,    26.67821,       3, 4,  "COD S123.XX"},
        {-7.29142,    29.48821,       4, 6,  "COD T123.XX"},
        {-2.259135,   16.1682,        3, 6,  "COD V123.XX"},
        {-7.80142,    23.93821,       3, 5,  "COD W123.XX"},
        {3.425864,    18.3882,        3, 6,  "COD X123.XX"},
        {4.495864,    25.5882,        3, 7,  "COD Y123.XX"},
        {2.805864,    29.2982,        3, 4,  "COD Z123.XX"},
        {-8.25957,    21.842394,      2, 4,  "COD 112.XXXX"},
        {-8.25957,    24.523584,      2, 4,  "COD 212.XXXX"},
        {-8.25957,    26.45404,       3, 5,  "COD 312.XXXX"},
        {-6.382737,   28.27725,       3, 4,  "COD 412.XXXX"},
        {-10.0682145, 22.320194,      3, 6,  "COD 512.XXXX"},
        {-10.222419,  25.6271745,     3, 5,  "COD 612.XXXX"},
        {-12.9820035, 28.3054445,     2, 5,  "COD 712.XXXX"},
        {-10.206893,  27.5098405,     4, 6,  "COD 812.XXXX"},
        {5.3383885,   18.2913485,     2, 5,  "COD 0123.XXX"},
        {5.3383885,   20.9725385,     2, 5,  "COD 1123.XXX"},
        {5.3383885,   23.6537285,     2, 6,  "COD 2123.XXX"},
        {5.3383885,   26.3349185,     2, 7,  "COD 3123.XXX"},
        {5.3383885,   28.7304815,     3, 6,  "COD 4123.XXX"},
        {2.6571985,   17.7551105,     2, 5,  "COD 5123.XXX"},
        {2.6571985,   20.4363005,     2, 4,  "COD 6123.XXX"},
        {2.6571985,   23.1174905,     2, 4,  "COD 7123.XXX"},
        {2.6571985,   25.7986805,     2, 4,  "COD 8123.XXX"},
        {2.6571985,   28.4798705,     2, 3,  "COD 9123.XXX"},
        {2.6571985,   28.7304815,     3, 4,  "COD B123.XXX"},
        {-0.0239915,  16.0123375,     2, 5,  "COD C123.XXX"},
        {-0.0239915,  18.6935275,     2, 4,  "COD D123.XXX"},
        {-0.0239915,  21.3747175,     2, 3,  "COD F123.XXX"},
        {-0.0239915,  24.0559075,     2, 3,  "COD G123.XXX"},
        {-0.0239915,  26.7370975,     2, 3,  "COD H123.XXX"},
        {-0.0239915,  27.2733355,     3, 4,  "COD J123.XXX"},
        {-2.7051815,  14.7253655,     2, 5,  "COD K123.XXX"},
        {-2.7051815,  17.4065555,     2, 4,  "COD L123.XXX"},
        {-2.7051815,  20.0877455,     2, 3,  "COD M123.XXX"},
        {-2.7051815,  22.7689355,     2, 3,  "COD N123.XXX"},
        {-2.7051815,  25.4501255,     2, 3,  "COD P123.XXX"},
        {-2.7051815,  26.7370975,     3, 4,  "COD Q123.XXX"},
        {-4.0457765,  12.1246115,     2, 5,  "COD R123.XXX"},
        {-5.3700555,  14.8063235,     2, 4,  "COD S123.XXX"},
        {-5.3700555,  17.4875135,     2, 4,  "COD T123.XXX"},
        {-5.3700555,  20.1687035,     2, 4,  "COD V123.XXX"},
        {-5.3700555,  22.8498935,     3, 5,  "COD W123.XXX"},
        {-5.3700555,  25.5310835,     3, 4,  "COD X123.XXX"},
        {-5.3700555,  28.2122735,     2, 3,  "COD Y123.XXX"},
        {-5.6381745,  17.4875135,     3, 5,  "COD Z123.XXX"},
        {-4.339,      15.3201225,     5, 9,  "COD 5JQ0.D83N"},
        {36.8137,     2.992848,       5, 6,  "DZA 12.XX"},
        {36.666791,   2.7423805,      4, 5,  "DZA 12.XXX"},
        {35.727545,   -0.670603125,   4, 5,  "DZA 000.XX"},
        {36.401124,   6.56960275,     4, 5,  "DZA 100.XX"},
        {35.590624,   6.11948,        4, 5,  "DZA 200.XX"},
        {36.916545,   7.706280625,    4, 6,  "DZA 300.XX"},
        {36.230724,   5.359941375,    4, 5,  "DZA 400.XX"},
        {35.241624,   -0.66442,       4, 5,  "DZA 500.XX"},
        {34.871124,   5.684819625,    5, 6,  "DZA 600.XX"},
        {34.705924,   3.208819625,    5, 6,  "DZA 700.XX"},
        {35.460124,   8.05358,        4, 6,  "DZA 800.XX"},
        {36.899724,   6.893563125,    4, 5,  "DZA 900.XX"},
        {36.776624,   5.00810275,     4, 5,  "DZA B00.XX"},
        {35.396724,   1.28028,        4, 5,  "DZA C00.XX"},
        {36.192124,   1.281841375,    4, 5,  "DZA D00.XX"},
        {36.750824,   3.99630275,     4, 5,  "DZA F00.XX"},
        {31.619264,   -2.26153875,    3, 6,  "DZA G00.XX"},
        {36.065004,   4.731038375,    4, 5,  "DZA GK0.00"},
        {35.952464,   0.053258125,    4, 5,  "DZA H00.XX"},
        {36.264204,   2.73672075,     4, 5,  "DZA HK0.00"},
        {34.902464,   -1.357527125,   5, 8,  "DZA J00.XX"},
        {31.945204,   5.29745775,     3, 4,  "DZA JK0.00"},
        {36.294564,   7.92210025,     4, 6,  "DZA K00.XX"},
        {34.833955,   0.126621375,    5, 6,  "DZA KK0.00"},
        {36.468745,   7.39827875,     4, 5,  "DZA L00.XX"},
        {35.422304,   7.108355,       4, 5,  "DZA LK0.00"},
        {36.813964,   5.712042375,    4, 5,  "DZA M00.XX"},
        {36.145704,   5.652138375,    4, 5,  "DZA MK0.00"},
        {33.382464,   6.823159875,    3, 4,  "DZA N00.XX"},
        {35.723504,   0.516138375,    4, 5,  "DZA NK0.00"},
        {35.722464,   4.501958125,    4, 5,  "DZA P00.XX"},
        {35.204104,   4.148155,       4, 5,  "DZA PK0.00"},
        {33.822164,   2.830902,       3, 4,  "DZA Q00.XX"},
        {35.788904,   7.356238375,    4, 5,  "DZA QK0.00"},
        {35.462964,   2.864515,       4, 5,  "DZA R00.XX"},
        {35.394104,   0.108155,       4, 5,  "DZA RK0.00"},
        {35.399964,   5.329915,       4, 5,  "DZA S00.XX"},
        {36.374104,   3.86772075,     4, 5,  "DZA SK0.00"},
        {32.502464,   3.633589,       3, 4,  "DZA T00.XX"},
        {34.154104,   3.468517375,    3, 4,  "DZA TK0.00"},
        {35.882545,   7.075868875,    4, 5,  "DZA V00.XX"},
        {34.848304,   -1.768427375,   5, 8,  "DZA VK0.00"},
        {36.149264,   2.883758125,    4, 5,  "DZA W00.XX"},
        {36.253904,   2.18852075,     4, 5,  "DZA WK0.00"},
        {36.770664,   6.219342375,    4, 5,  "DZA X00.XX"},
        {36.252604,   6.68602075,     4, 5,  "DZA XK0.00"},
        {32.789364,   4.464432125,    3, 4,  "DZA Y00.XX"},
        {35.881304,   2.711838375,    4, 5,  "DZA YK0.00"},
        {35.081994,   2.970273125,    4, 5,  "DZA Z00.XX"},
        {33.672604,   0.995734,       3, 4,  "DZA ZK0.00"},
        {35.548925,   -2.0293995,     3, 6,  "DZA 12.XXXX"},
        {36.8934185,  2.1530165,      3, 4,  "DZA 123.XXX"},
        {34.7477105,  5.3636695,      4, 5,  "DZA 1234.XX"},
        {36.836335,   -2.999762,      2, 6,  "DZA 012.XXXX"},
        {36.836335,   0.217665,       2, 5,  "DZA 112.XXXX"},
        {36.836335,   3.435093,       3, 4,  "DZA 212.XXXX"},
        {36.836335,   6.652521,       3, 4,  "DZA 312.XXXX"},
        {34.785224,   -2.973686,      3, 6,  "DZA 412.XXXX"},
        {34.785224,   0.184159,       4, 5,  "DZA 512.XXXX"},
        {34.785224,   3.342005,       4, 5,  "DZA 612.XXXX"},
        {34.785224,   6.499851,       4, 5,  "DZA 712.XXXX"},
        {32.104034,   -5.4459535,     2, 6,  "DZA 812.XXXX"},
        {32.104034,   -2.3774805,     2, 5,  "DZA 912.XXXX"},
        {32.104034,   0.6909915,      2, 3,  "DZA B12.XXXX"},
        {32.104034,   3.7594645,      2, 3,  "DZA C12.XXXX"},
        {32.104034,   6.8279375,      2, 3,  "DZA D12.XXXX"},
        {29.422844,   -8.48504,       2, 5,  "DZA F12.XXXX"},
        {29.422844,   -5.817955,      3, 6,  "DZA G12.XXXX"},
        {29.422844,   -2.838855,      2, 5,  "DZA H12.XXXX"},
        {29.422844,   0.140244,       2, 3,  "DZA J12.XXXX"},
        {29.422844,   3.119344,       2, 3,  "DZA K12.XXXX"},
        {29.422844,   6.098444,       2, 3,  "DZA L12.XXXX"},
        {29.422844,   9.077544,       2, 3,  "DZA M12.XXXX"},
        {26.741654,   -8.473069,      2, 4,  "DZA N12.XXXX"},
        {26.741654,   -5.553551,      2, 4,  "DZA P12.XXXX"},
        {26.741654,   -2.634033,      2, 3,  "DZA Q12.XXXX"},
        {26.741654,   0.285484,       2, 3,  "DZA R12.XXXX"},
        {26.741654,   3.205002,       2, 3,  "DZA S12.XXXX"},
        {26.741654,   6.12452,        2, 3,  "DZA T12.XXXX"},
        {26.741654,   9.044038,       2, 3,  "DZA V12.XXXX"},
        {24.2688335,  -4.1370415,     2, 5,  "DZA 0123.XXX"},
        {24.2688335,  -1.2771065,     2, 5,  "DZA 1123.XXX"},
        {24.2688335,  1.5828295,      2, 3,  "DZA 2123.XXX"},
        {24.2688335,  4.4427655,      2, 3,  "DZA 3123.XXX"},
        {24.2688335,  7.3027015,      2, 3,  "DZA 4123.XXX"},
        {24.2688335,  9.2485585,      3, 4,  "DZA 5123.XXX"},
        {21.5713275,  -1.248994,      2, 5,  "DZA 6123.XXX"},
        {21.5713275,  1.581151,       2, 7,  "DZA 7123.XXX"},
        {21.5713275,  4.411296,       2, 4,  "DZA 8123.XXX"},
        {21.5713275,  7.241441,       2, 4,  "DZA 9123.XXX"},
        {36.7786,     3.04,           5, 6,  "DZA K0KJ.FH3L"},
        {43.2894,     76.8781975,     5, 8,  "KAZ 12.XX"},
        {43.232794,   76.7175455,     4, 9,  "KAZ 00.XXX"},
        {49.950884,   72.902389,      3, 4,  "KAZ C0.XXX"},
        {42.283325,   69.4607865,     5, 8,  "KAZ P0.XXX"},
        {42.878814,   71.298262,      5, 9,  "KAZ 000.XX"},
        {51.151514,   71.34894325,    3, 4,  "KAZ 200.XX"},
        {44.820114,   65.416777125,   3, 5,  "KAZ 400.XX"},
        {52.320724,   76.903321875,   3, 6,  "KAZ 600.XX"},
        {50.012224,   82.54554675,    3, 5,  "KAZ 700.XX"},
        {50.454924,   80.1934685,     3, 5,  "KAZ 800.XX"},
        {50.323624,   57.12884675,    3, 5,  "KAZ 900.XX"},
        {53.254724,   63.58612675,    3, 5,  "KAZ B00.XX"},
        {54.919624,   69.1034405,     4, 6,  "KAZ C00.XX"},
        {51.271724,   51.34889025,    3, 8,  "KAZ D00.XX"},
        {50.111624,   72.88904675,    3, 4,  "KAZ F00.XX"},
        {43.699724,   51.130752,      3, 4,  "KAZ G00.XX"},
        {47.150624,   51.851375625,   3, 4,  "KAZ H00.XX"},
        {51.764224,   75.253099125,   3, 5,  "KAZ J00.XX"},
        {43.327245,   68.1842625,     4, 6,  "KAZ K00.XX"},
        {53.009524,   63.04363075,    3, 8,  "KAZ L00.XX"},
        {47.837324,   67.639745875,   3, 4,  "KAZ M00.XX"},
        {53.328245,   69.34087375,    4, 6,  "KAZ N00.XX"},
        {45.038545,   78.304815625,   4, 7,  "KAZ P00.XX"},
        {46.888024,   74.913975625,   3, 4,  "KAZ Q00.XX"},
        {47.904845,   67.438734375,   3, 4,  "KAZ R00.XX"},
        {45.678124,   63.22107075,    3, 4,  "KAZ S00.XX"},
        {50.383124,   83.45234675,    4, 6,  "KAZ T00.XX"},
        {43.546045,   68.4713075,     4, 6,  "KAZ V00.XX"},
        {52.966245,   70.12636875,    4, 6,  "KAZ W00.XX"},
        {43.361845,   52.8003075,     3, 4,  "KAZ X00.XX"},
        {52.376224,   71.787821875,   3, 5,  "KAZ Y00.XX"},
        {50.294524,   66.84944675,    3, 4,  "KAZ Z00.XX"},
        {43.25507,    68.032765,      3, 5,  "KAZ 123.XXX"},
        {45.188287,   75.336364,      3, 4,  "KAZ 12.XXXX"},
        {55.101375,   67.0070225,     3, 8,  "KAZ 1234.XX"},
        {55.196335,   61.2195615,     2, 8,  "KAZ 012.XXXX"},
        {55.196335,   65.5988385,     2, 11, "KAZ 112.XXXX"},
        {55.196335,   69.9781155,     3, 8,  "KAZ 212.XXXX"},
        {55.196335,   74.3573925,     2, 9,  "KAZ 312.XXXX"},
        {52.515145,   47.3101795,     2, 8,  "KAZ 412.XXXX"},
        {52.515145,   51.4511285,     2, 11, "KAZ 512.XXXX"},
        {52.515145,   55.5920775,     2, 10, "KAZ 612.XXXX"},
        {52.515145,   59.7330265,     2, 9,  "KAZ 712.XXXX"},
        {52.515145,   63.8739755,     2, 4,  "KAZ 812.XXXX"},
        {52.515145,   68.0149245,     2, 4,  "KAZ 912.XXXX"},
        {52.515145,   72.1558735,     2, 4,  "KAZ B12.XXXX"},
        {52.515145,   76.2968225,     2, 5,  "KAZ C12.XXXX"},
        {52.515145,   80.4377715,     2, 8,  "KAZ D12.XXXX"},
        {50.370193,   83.6448445,     3, 5,  "KAZ F12.XXXX"},
        {49.833955,   46.72519,       2, 8,  "KAZ G12.XXXX"},
        {49.833955,   50.633471,      2, 7,  "KAZ H12.XXXX"},
        {49.833955,   54.565883,      2, 4,  "KAZ J12.XXXX"},
        {49.833955,   58.498295,      2, 4,  "KAZ K12.XXXX"},
        {49.833955,   62.430707,      2, 3,  "KAZ L12.XXXX"},
        {49.833955,   66.363119,      2, 3,  "KAZ M12.XXXX"},
        {49.833955,   70.295531,      2, 3,  "KAZ N12.XXXX"},
        {49.833955,   74.227943,      2, 3,  "KAZ P12.XXXX"},
        {49.833955,   78.160355,      2, 3,  "KAZ Q12.XXXX"},
        {49.833955,   82.092767,      2, 4,  "KAZ R12.XXXX"},
        {47.152765,   48.548872,      2, 8,  "KAZ S12.XXXX"},
        {47.152765,   52.302538,      2, 3,  "KAZ T12.XXXX"},
        {47.152765,   56.056204,      2, 3,  "KAZ V12.XXXX"},
        {44.471575,   49.7550575,     2, 3,  "KAZ W12.XXXX"},
        {44.471575,   53.3597685,     2, 3,  "KAZ X12.XXXX"},
        {42.987525,   49.805352,      3, 4,  "KAZ Y12.XXXX"},
        {42.987525,   53.261108,      3, 4,  "KAZ Z12.XXXX"},
        {47.3448185,  59.6049165,     2, 3,  "KAZ 0123.XXX"},
        {47.3448185,  63.3585825,     2, 3,  "KAZ 1123.XXX"},
        {47.3448185,  67.1122485,     2, 3,  "KAZ 2123.XXX"},
        {47.3448185,  70.8659145,     2, 3,  "KAZ 3123.XXX"},
        {47.3448185,  74.6195805,     2, 3,  "KAZ 4123.XXX"},
        {47.3448185,  78.3732465,     2, 3,  "KAZ 5123.XXX"},
        {47.3448185,  82.1269125,     2, 3,  "KAZ 6123.XXX"},
        {44.6636285,  59.688645,      2, 4,  "KAZ 7123.XXX"},
        {44.6636285,  63.293356,      2, 4,  "KAZ 8123.XXX"},
        {44.6636285,  66.898067,      2, 4,  "KAZ 9123.XXX"},
        {44.6636285,  70.502778,      2, 4,  "KAZ B123.XXX"},
        {44.6636285,  74.107489,      2, 3,  "KAZ C123.XXX"},
        {44.6636285,  77.7122,        3, 6,  "KAZ D123.XXX"},
        {43.211811,   65.151112,      3, 5,  "KAZ F123.XXX"},
        {43.211811,   68.606868,      4, 6,  "KAZ G123.XXX"},
        {43.2543,     76.9299805,     5, 10, "KAZ RT2D.S582"},
        {-34.566251,  -58.446604,     5, 8,  "ARG 12.XX"},
        {-34.444435,  -58.713375,     4, 5,  "ARG 12.XXX"},
        {-31.347546,  -64.2803925,    4, 6,  "ARG 010.XX"},
        {-31.381566,  -64.2254785,    4, 6,  "ARG 0C0.00"},
        {-31.426655,  -64.2836475,    4, 6,  "ARG 0Q0.00"},
        {-31.399565,  -64.2227485,    4, 6,  "ARG 120.XX"},
        {-32.914216,  -60.698239375,  4, 6,  "ARG 1F0.00"},
        {-32.977935,  -60.684490125,  4, 6,  "ARG 1R0.00"},
        {-32.877806,  -68.858021625,  4, 6,  "ARG 230.XX"},
        {-34.923196,  -57.987584875,  4, 7,  "ARG 2G0.00"},
        {-26.824746,  -65.242330125,  4, 6,  "ARG 2T0.00"},
        {-37.988786,  -57.610492875,  4, 5,  "ARG 340.XX"},
        {-24.794676,  -65.4430805,    4, 6,  "ARG 3H0.00"},
        {-31.627726,  -60.73276575,   4, 6,  "ARG 3V0.00"},
        {-31.563976,  -68.56329425,   4, 6,  "ARG 460.XX"},
        {-27.446726,  -59.013641125,  4, 7,  "ARG 4K0.00"},
        {-27.797706,  -64.297292375,  4, 6,  "ARG 4W0.00"},
        {-38.975256,  -68.08940275,   4, 5,  "ARG 570.XX"},
        {-27.483606,  -58.840162375,  4, 7,  "ARG 5L0.00"},
        {-38.701856,  -62.299767625,  4, 5,  "ARG 5Y0.00"},
        {-27.406236,  -55.945997375,  5, 11, "ARG 680.XX"},
        {-31.727586,  -60.54372075,   4, 6,  "ARG 6M0.00"},
        {-24.174236,  -65.31956625,   4, 6,  "ARG 6Z0.00"},
        {-26.185286,  -58.212789125,  4, 8,  "ARG 7B0.XX"},
        {-28.492276,  -65.803772375,  4, 6,  "ARG 7P0.00"},
        {-33.1287005, -64.3485,       4, 6,  "ARG 855.CW"},
        {-45.868466,  -67.540710375,  4, 5,  "ARG 8C0.XX"},
        {-33.362356,  -60.248358125,  4, 6,  "ARG 8Q0.00"},
        {-33.295866,  -66.361856625,  4, 6,  "ARG 920.XX"},
        {-31.361246,  -58.0477375,    4, 8,  "ARG 9D0.00"},
        {-29.437436,  -66.878715375,  4, 6,  "ARG 9R0.00"},
        {-34.614846,  -68.360759125,  4, 5,  "ARG B30.XX"},
        {-41.171136,  -71.3371575,    4, 7,  "ARG BG0.00"},
        {-43.261986,  -65.3452515,    4, 5,  "ARG BT0.00"},
        {-33.674426,  -65.501006,     4, 6,  "ARG C40.XX"},
        {-37.329916,  -59.1595235,    5, 6,  "ARG CH0.00"},
        {-36.624566,  -64.31589575,   4, 5,  "ARG CV0.00"},
        {-33.061376,  -68.508042125,  4, 6,  "ARG D60.XX"},
        {-32.428196,  -63.272209,     4, 6,  "ARG DJ0.00"},
        {-34.110846,  -59.062366,     4, 5,  "ARG DW0.00"},
        {-33.876656,  -60.597054,     4, 5,  "ARG F70.XX"},
        {-51.624146,  -69.263391375,  4, 5,  "ARG FL0.00"},
        {-29.150026,  -59.681523875,  4, 6,  "ARG FX0.00"},
        {-36.882736,  -60.349526125,  4, 5,  "ARG G80.XX"},
        {-35.026726,  -58.454931125,  5, 6,  "ARG GM0.00"},
        {-38.551576,  -58.762070875,  4, 5,  "ARG GZ0.00"},
        {-39.036426,  -67.63685325,   4, 5,  "ARG HB0.XX"},
        {-31.249506,  -61.5288225,    4, 6,  "ARG HN0.00"},
        {-34.153656,  -58.988546625,  4, 5,  "ARG J00.00"},
        {-26.777806,  -60.475237625,  4, 7,  "ARG JC0.00"},
        {-40.791956,  -63.028201875,  4, 5,  "ARG JQ0.00"},
        {-31.454436,  -62.1192425,    4, 6,  "ARG K10.XX"},
        {-33.008886,  -58.548555375,  4, 6,  "ARG KD0.00"},
        {-34.573036,  -60.987785375,  4, 5,  "ARG KR0.00"},
        {-34.586886,  -59.136371625,  4, 5,  "ARG L30.XX"},
        {-42.792276,  -65.068365,     4, 5,  "ARG LG0.00"},
        {-23.124116,  -64.346636625,  4, 6,  "ARG LS0.00"},
        {-33.037966,  -68.927701375,  4, 6,  "ARG M40.XX"},
        {-33.773356,  -61.996946,     4, 5,  "ARG MH0.00"},
        {-29.157506,  -59.294402875,  4, 6,  "ARG MV0.00"},
        {-32.489046,  -58.269309,     4, 8,  "ARG N50.XX"},
        {-33.214436,  -68.498581375,  4, 6,  "ARG NJ0.00"},
        {-33.688586,  -59.717486,     4, 6,  "ARG NW0.00"},
        {-26.191496,  -54.623989625,  4, 9,  "ARG P70.XX"},
        {-38.886886,  -62.10662225,   4, 5,  "ARG PL0.00"},
        {-22.569666,  -63.8363355,    4, 7,  "ARG PX0.00"},
        {-38.932576,  -69.26974075,   4, 5,  "ARG Q80.XX"},
        {-31.427966,  -64.5259875,    4, 6,  "ARG QM0.00"},
        {-27.482116,  -55.153843625,  4, 10, "ARG QZ0.00"},
        {-35.653656,  -63.800195,     4, 5,  "ARG R90.XX"},
        {-34.909046,  -60.068895875,  4, 5,  "ARG RN0.00"},
        {-36.783196,  -59.898342375,  4, 5,  "ARG S00.00"},
        {-32.177346,  -64.145493,     4, 6,  "ARG SC0.00"},
        {-34.670126,  -59.470753125,  4, 5,  "ARG SP0.00"},
        {-38.353036,  -60.300695375,  4, 5,  "ARG T10.XX"},
        {-23.818426,  -64.815298625,  4, 6,  "ARG TD0.00"},
        {-33.222576,  -60.376329125,  4, 6,  "ARG TR0.00"},
        {-28.136426,  -58.793656625,  4, 6,  "ARG V30.XX"},
        {-31.659506,  -64.45895925,   4, 6,  "ARG VF0.00"},
        {-24.213656,  -64.89585575,   4, 6,  "ARG VS0.00"},
        {-32.617506,  -62.706633875,  4, 6,  "ARG W40.XX"},
        {-35.441956,  -60.916235,     4, 5,  "ARG WH0.00"},
        {-34.644736,  -60.520534625,  4, 5,  "ARG WT0.00"},
        {-33.168586,  -59.368581375,  4, 6,  "ARG X50.XX"},
        {-29.163036,  -58.106252375,  4, 6,  "ARG XJ0.00"},
        {-43.277186,  -65.1399505,    4, 5,  "ARG XW0.00"},
        {-36.331036,  -57.71570025,   4, 5,  "ARG Y70.XX"},
        {-34.864116,  -61.569769875,  4, 5,  "ARG YK0.00"},
        {-35.408266,  -60.208655,     4, 5,  "ARG YX0.00"},
        {-32.612116,  -60.206420375,  4, 6,  "ARG Z80.XX"},
        {-54.807506,  -68.3468125,    4, 7,  "ARG ZM0.00"},
        {-32.7657315, -60.822922,     3, 5,  "ARG 123.XXX"},
        {-31.685825,  -64.5412335,    3, 5,  "ARG 01.XXXX"},
        {-33.225025,  -68.938755,     3, 5,  "ARG 11.XXXX"},
        {-27.053025,  -65.45395,      3, 5,  "ARG 21.XXXX"},
        {-38.269025,  -58.0147735,    3, 4,  "ARG 31.XXXX"},
        {-25.099825,  -65.7086285,    3, 5,  "ARG 41.XXXX"},
        {-31.768225,  -60.9354335,    3, 5,  "ARG 51.XXXX"},
        {-31.764925,  -68.7349335,    3, 5,  "ARG 61.XXXX"},
        {-27.689625,  -59.13415,      3, 5,  "ARG 71.XXXX"},
        {-28.007025,  -64.4682635,    3, 5,  "ARG 81.XXXX"},
        {-39.0780975, -68.214405,     3, 4,  "ARG 91.XXXX"},
        {-39.011725,  -62.440295,     3, 4,  "ARG B1.XXXX"},
        {-27.593525,  -56.14955,      4, 10, "ARG C1.XXXX"},
        {-24.2212325, -65.305459,     3, 5,  "ARG D1.XXXX"},
        {-26.390125,  -58.4128285,    3, 7,  "ARG F1.XXXX"},
        {-28.815725,  -65.947684,     3, 5,  "ARG G1.XXXX"},
        {-33.340425,  -64.594155,     3, 5,  "ARG H1.XXXX"},
        {-46.013025,  -67.8721185,    3, 4,  "ARG J1.XXXX"},
        {-33.521325,  -66.6223675,    3, 5,  "ARG K1.XXXX"},
        {-31.589625,  -58.4076335,    4, 6,  "ARG L1.XXXX"},
        {-29.624725,  -67.087585,     3, 5,  "ARG M1.XXXX"},
        {-34.829225,  -68.58359,      3, 4,  "ARG N1.XXXX"},
        {-41.370125,  -71.5788785,    3, 6,  "ARG P1.XXXX"},
        {-43.489225,  -65.4932485,    3, 4,  "ARG Q1.XXXX"},
        {-33.887725,  -65.7146685,    3, 4,  "ARG R1.XXXX"},
        {-37.527825,  -59.38976,      3, 4,  "ARG S1.XXXX"},
        {-36.828325,  -64.5403385,    3, 4,  "ARG T1.XXXX"},
        {-32.625025,  -63.488555,     3, 5,  "ARG V1.XXXX"},
        {-51.838525,  -69.56242,      3, 4,  "ARG W1.XXXX"},
        {-29.351625,  -59.697685,     3, 5,  "ARG X1.XXXX"},
        {-37.051525,  -60.3467385,    3, 4,  "ARG Y1.XXXX"},
        {-38.662625,  -59.0088735,    3, 4,  "ARG Z1.XXXX"},
        {-31.484135,  -61.7652235,    3, 5,  "ARG 0123.XX"},
        {-27.024135,  -60.70755,      3, 6,  "ARG 1123.XX"},
        {-41.044135,  -63.303909,     3, 4,  "ARG 2123.XX"},
        {-31.664135,  -62.3552235,    3, 5,  "ARG 3123.XX"},
        {-34.82142,   -61.238154,     3, 4,  "ARG 4123.XX"},
        {-43.004135,  -65.354211,     3, 4,  "ARG 5123.XX"},
        {-23.37142,   -64.5646195,    3, 5,  "ARG 6123.XX"},
        {-33.984135,  -62.2403745,    3, 4,  "ARG 7123.XX"},
        {-32.650535,  -58.598303,     4, 6,  "ARG 8123.XX"},
        {-26.43142,   -54.8497705,    3, 7,  "ARG 9123.XX"},
        {-22.784135,  -64.0546195,    3, 6,  "ARG B123.XX"},
        {-39.17142,   -69.533607,     3, 4,  "ARG C123.XX"},
        {-27.71142,   -55.38755,      3, 7,  "ARG D123.XX"},
        {-35.894135,  -64.053305,     3, 4,  "ARG F123.XX"},
        {-32.41142,   -64.3852235,    3, 5,  "ARG G123.XX"},
        {-38.60142,   -60.5558275,    3, 4,  "ARG H123.XX"},
        {-24.05142,   -65.0346195,    3, 5,  "ARG J123.XX"},
        {-28.35142,   -59.0249215,    3, 5,  "ARG K123.XX"},
        {-32.834135,  -62.953003,     3, 5,  "ARG L123.XX"},
        {-35.694135,  -61.173305,     3, 4,  "ARG M123.XX"},
        {-29.41142,   -58.342701,     3, 5,  "ARG N123.XX"},
        {-36.56142,   -57.973305,     3, 4,  "ARG P123.XX"},
        {-35.114135,  -61.8155255,    3, 4,  "ARG Q123.XX"},
        {-35.664135,  -60.463305,     3, 4,  "ARG R123.XX"},
        {-32.844135,  -60.453003,     4, 6,  "ARG S123.XX"},
        {-55.024135,  -68.7039985,    3, 6,  "ARG T123.XX"},
        {-22.03307,   -68.533616,     2, 7,  "ARG 012.XXXX"},
        {-22.03307,   -65.67368,      2, 5,  "ARG 112.XXXX"},
        {-22.03307,   -62.813744,     2, 5,  "ARG 212.XXXX"},
        {-22.03307,   -59.953808,     2, 6,  "ARG 312.XXXX"},
        {-24.71426,   -68.559692,     2, 6,  "ARG 412.XXXX"},
        {-24.71426,   -65.640174,     3, 5,  "ARG 512.XXXX"},
        {-24.71426,   -62.720656,     2, 4,  "ARG 612.XXXX"},
        {-24.71426,   -59.801138,     2, 5,  "ARG 712.XXXX"},
        {-27.39545,   -70.337478,     2, 7,  "ARG 812.XXXX"},
        {-27.39545,   -67.358378,     2, 4,  "ARG 912.XXXX"},
        {-27.39545,   -64.379278,     2, 4,  "ARG B12.XXXX"},
        {-27.39545,   -61.400178,     2, 5,  "ARG C12.XXXX"},
        {-27.39545,   -58.421078,     2, 6,  "ARG D12.XXXX"},
        {-25.786736,  -56.4004165,    2, 6,  "ARG F12.XXXX"},
        {-30.07664,   -70.4221725,    2, 6,  "ARG G12.XXXX"},
        {-30.07664,   -67.3536995,    2, 4,  "ARG H12.XXXX"},
        {-30.07664,   -64.2852265,    2, 4,  "ARG J12.XXXX"},
        {-30.07664,   -61.2167535,    2, 4,  "ARG K12.XXXX"},
        {-30.07664,   -59.9893645,    3, 5,  "ARG L12.XXXX"},
        {-32.75783,   -70.476182,     2, 7,  "ARG M12.XXXX"},
        {-32.75783,   -67.318336,     2, 4,  "ARG N12.XXXX"},
        {-32.75783,   -64.16049,      2, 4,  "ARG P12.XXXX"},
        {-32.75783,   -61.002644,     2, 4,  "ARG Q12.XXXX"},
        {-35.43902,   -71.254639,     2, 6,  "ARG R12.XXXX"},
        {-35.43902,   -67.977629,     2, 3,  "ARG S12.XXXX"},
        {-35.43902,   -64.700619,     2, 3,  "ARG T12.XXXX"},
        {-35.43902,   -61.423609,     2, 3,  "ARG V12.XXXX"},
        {-34.956405,  -59.6588595,    4, 5,  "ARG W12.XXXX"},
        {-37.9118405, -71.823579,     2, 6,  "ARG 0123.XXX"},
        {-37.9118405, -68.457196,     2, 3,  "ARG 1123.XXX"},
        {-37.9118405, -65.090813,     2, 3,  "ARG 2123.XXX"},
        {-37.9118405, -61.72443,      2, 3,  "ARG 3123.XXX"},
        {-37.4187295, -58.358695,     3, 4,  "ARG 4123.XXX"},
        {-40.6093465, -72.1099445,    2, 6,  "ARG 5123.XXX"},
        {-40.6093465, -68.5946065,    2, 3,  "ARG 6123.XXX"},
        {-40.6093465, -65.0792685,    2, 3,  "ARG 7123.XXX"},
        {-43.2905365, -71.952961,     2, 5,  "ARG 8123.XXX"},
        {-43.2905365, -68.288668,     2, 3,  "ARG 9123.XXX"},
        {-45.9554105, -72.5123155,    2, 5,  "ARG B123.XXX"},
        {-45.9554105, -68.6990675,    2, 3,  "ARG C123.XXX"},
        {-48.6529165, -73.547841,     2, 5,  "ARG D123.XXX"},
        {-48.6529165, -69.526056,     2, 3,  "ARG F123.XXX"},
        {-49.8594515, -72.3170665,    3, 6,  "ARG G123.XXX"},
        {-52.4972815, -65.108213,     3, 4,  "ARG L123.XXX"},
        {-52.4972815, -68.69922,      2, 5,  "ARG K123.XXX"},
        {-34.601351,  -58.401136,     5, 8,  "ARG RCNX.1YMV"},
        {20.36724,    72.8238215,     3, 11, "IN-DD 12.XX"},
        {20.739011,   70.8776195,     3, 9,  "IN-DD 12.XXX"},
        {20.3579875,  72.930732,      4, 13, "IN-DN 12.XX"},
        {20.335131,   72.937175,      4, 13, "IN-DN 12.XXX"},
        {30.7562,     76.720416,      4, 17, "IN-CH 12.XX"},
        {30.792252,   76.6831935,     3, 15, "IN-CH 12.XXX"},
        {11.681452,   92.6871695,     5, 9,  "IN-AN 12.XX"},
        {11.598555,   92.5227835,     4, 8,  "IN-AN 12.XXX"},
        {10.518921,   92.2164365,     3, 7,  "IN-AN 123.XX"},
        {11.160025,   92.120325,      1, 2,  "IN-AN 068.S0Z"},
        {7.842025,    92.671025,      3, 6,  "IN-AN M2Y.S03"},
        {6.720025,    93.600025,      1, 2,  "IN-AN V1J.D0Z"},
        {11.139228,   92.72163,       3, 7,  "IN-AN X00.S16"},
        {13.371282,   94.22184,       3, 7,  "IN-AN Y07.S16"},
        {12.21921,    93.798519,      3, 7,  "IN-AN Z07.S16"},
        {8.33221,     73.004713,      1, 2,  "IN-LD 12.XX"},
        {10.7721045,  72.5807835,     4, 7,  "IN-LD 12.XXX"},
        {10.780551,   71.9264365,     4, 7,  "IN-LD 123.XX"},
        {12.3899835,  71.763613,      3, 6,  "IN-LD 123.XXX"},
        {28.667856,   77.17675,       4, 14, "IN-DL 12.XX"},
        {28.841563,   76.852054,      3, 11, "IN-DL 12.XXX"},
        {25.612231,   91.8541145,     5, 11, "IN-ML 12.XX"},
        {25.723294,   91.5719235,     4, 10, "IN-ML 12.XXX"},
        {25.531504,   91.17153075,    4, 9,  "IN-ML 000.XX"},
        {25.486604,   90.55153075,    4, 9,  "IN-ML 400.XX"},
        {25.256104,   90.5445105,     4, 9,  "IN-ML 800.XX"},
        {25.460904,   92.12813075,    4, 10, "IN-ML D00.XX"},
        {25.528804,   90.10313075,    4, 9,  "IN-ML J00.XX"},
        {25.322504,   90.33563075,    4, 9,  "IN-ML N00.XX"},
        {25.411004,   92.30613075,    5, 12, "IN-ML S00.XX"},
        {25.919594,   91.812957875,   4, 10, "IN-ML X00.XX"},
        {25.542007,   89.8753315,     3, 12, "IN-ML 123.XXX"},
        {25.930126,   93.6828015,     5, 12, "IN-NL 12.XX"},
        {25.995563,   93.6741975,     4, 11, "IN-NL 12.XXX"},
        {26.649904,   94.535410125,   4, 14, "IN-NL 000.XX"},
        {26.343104,   94.383510125,   4, 11, "IN-NL 400.XX"},
        {26.090904,   94.201290875,   4, 11, "IN-NL 800.XX"},
        {26.250704,   94.737490875,   4, 10, "IN-NL D00.XX"},
        {26.005094,   94.473957875,   4, 10, "IN-NL J00.XX"},
        {25.881694,   94.359357875,   4, 11, "IN-NL M00.XX"},
        {26.736694,   94.948042125,   4, 17, "IN-NL Q00.XX"},
        {26.899094,   94.994626375,   5, 21, "IN-NL T00.XX"},
        {25.683794,   94.59366575,    4, 13, "IN-NL X00.XX"},
        {25.195261,   93.329058,      3, 13, "IN-NL 123.XXX"},
        {24.8311,     93.8988015,     5, 11, "IN-MN 12.XX"},
        {24.990115,   93.712885,      4, 10, "IN-MN 12.XXX"},
        {25.121974,   94.2191235,     4, 10, "IN-MN 000.XX"},
        {25.248274,   93.8846235,     4, 13, "IN-MN 500.XX"},
        {24.963174,   93.4254235,     4, 11, "IN-MN B00.XX"},
        {24.465663,   93.68819125,    4, 10, "IN-MN H00.XX"},
        {24.465663,   93.87750725,    4, 10, "IN-MN M00.XX"},
        {24.292684,   93.65032725,    4, 10, "IN-MN R00.XX"},
        {24.292684,   93.83964325,    4, 10, "IN-MN W00.XX"},
        {23.894446,   92.962821,      3, 11, "IN-MN 123.XXX"},
        {23.8694,     91.249542,      5, 10, "IN-TR 12.XX"},
        {23.935907,   91.2193585,     4, 9,  "IN-TR 12.XXX"},
        {23.388194,   91.645020875,   4, 7,  "IN-TR 000.XX"},
        {23.985494,   91.909605125,   5, 8,  "IN-TR 300.XX"},
        {24.304594,   91.92259725,    4, 11, "IN-TR 600.XX"},
        {24.389694,   92.08389725,    4, 12, "IN-TR 900.XX"},
        {24.245494,   92.08689725,    4, 11, "IN-TR D00.XX"},
        {23.828094,   92.098105125,   4, 7,  "IN-TR H00.XX"},
        {24.158094,   91.963905125,   4, 11, "IN-TR L00.XX"},
        {23.936014,   91.777089125,   4, 7,  "IN-TR P00.XX"},
        {24.130614,   91.765989125,   4, 11, "IN-TR R00.XX"},
        {24.019914,   91.545889125,   4, 9,  "IN-TR T00.XX"},
        {23.014314,   91.63489775,    4, 9,  "IN-TR W00.XX"},
        {23.237914,   91.430127875,   4, 9,  "IN-TR Y00.XX"},
        {23.169105,   91.135925,      3, 8,  "IN-TR 123.XXX"},
        {23.791953,   92.676459,      5, 9,  "IN-MZ 12.XX"},
        {23.928515,   92.4955065,     4, 8,  "IN-MZ 12.XXX"},
        {22.495004,   92.8602615,     4, 8,  "IN-MZ 000.XX"},
        {23.534545,   93.120244375,   4, 8,  "IN-MZ 700.XX"},
        {24.276444,   92.56646425,    4, 11, "IN-MZ F00.XX"},
        {22.892244,   92.69344075,    4, 8,  "IN-MZ M00.XX"},
        {23.334544,   92.740746875,   4, 8,  "IN-MZ T00.XX"},
        {22.744212,   92.185584,      3, 10, "IN-MZ 123.XXX"},
        {27.3661,     88.5669595,     5, 9,  "IN-SK 12.XX"},
        {27.531115,   88.37725,       4, 8,  "IN-SK 12.XXX"},
        {27.928545,   88.520253125,   4, 10, "IN-SK 000.XX"},
        {27.460842,   88.020251875,   4, 12, "IN-SK J00.XX"},
        {27.1609515,  87.982266,      3, 14, "IN-SK 123.XXX"},
        {30.9451,     75.806216,      5, 10, "IN-PB 12.XX"},
        {30.845694,   75.674764125,   4, 11, "IN-PB 00.XXX"},
        {31.72099,    74.68888525,    4, 10, "IN-PB C0.XXX"},
        {31.421157,   75.4198865,     4, 9,  "IN-PB P0.XXX"},
        {30.310114,   76.322653875,   4, 10, "IN-PB 000.XX"},
        {30.191814,   74.878953875,   5, 16, "IN-PB 200.XX"},
        {32.246714,   75.576726,      4, 12, "IN-PB 400.XX"},
        {31.510514,   75.83836575,    4, 12, "IN-PB 600.XX"},
        {30.690214,   76.620515125,   4, 12, "IN-PB 800.XX"},
        {30.858724,   75.126479125,   4, 9,  "IN-PB B00.XX"},
        {31.856824,   75.15571475,    4, 9,  "IN-PB C00.XX"},
        {30.182124,   74.152005875,   4, 12, "IN-PB D00.XX"},
        {30.565324,   75.835979125,   4, 11, "IN-PB F00.XX"},
        {30.720924,   76.200279125,   4, 11, "IN-PB G00.XX"},
        {31.259824,   75.7324405,     5, 13, "IN-PB H00.XX"},
        {30.528724,   74.498379125,   5, 15, "IN-PB J00.XX"},
        {30.403624,   75.487505875,   4, 10, "IN-PB K00.XX"},
        {31.416624,   75.3348405,     4, 9,  "IN-PB L00.XX"},
        {30.516324,   76.541479125,   4, 11, "IN-PB M00.XX"},
        {30.715424,   74.706279125,   5, 15, "IN-PB N00.XX"},
        {30.288324,   75.796905875,   4, 10, "IN-PB P00.XX"},
        {30.840424,   75.409279125,   5, 12, "IN-PB Q00.XX"},
        {30.620924,   74.777179125,   5, 13, "IN-PB R00.XX"},
        {30.048824,   75.356205875,   5, 16, "IN-PB S00.XX"},
        {30.230324,   74.451505875,   5, 15, "IN-PB T00.XX"},
        {32.079324,   75.355988,      4, 9,  "IN-PB V00.XX"},
        {30.443624,   73.983205875,   4, 10, "IN-PB W00.XX"},
        {31.136224,   75.2922405,     5, 9,  "IN-PB X00.XX"},
        {30.411424,   76.087005875,   4, 12, "IN-PB Y00.XX"},
        {30.967724,   74.569979125,   5, 13, "IN-PB Z00.XX"},
        {32.122025,   75.273025,      3, 8,  "IN-PB 00R.S0H"},
        {29.727025,   73.875025,      3, 12, "IN-PB 14W.600"},
        {29.522025,   75.154025,      4, 15, "IN-PB Y0D.S0Y"},
        {28.49451,    76.983578,      5, 13, "IN-HR 12.XX"},
        {28.468214,   76.9505365,     4, 12, "IN-HR 12.XXX"},
        {29.431714,   76.910793625,   4, 9,  "IN-HR 000.XX"},
        {29.309405,   76.911133375,   4, 9,  "IN-HR 200.XX"},
        {30.350714,   76.685153875,   4, 10, "IN-HR 400.XX"},
        {30.350714,   76.826148875,   4, 10, "IN-HR 600.XX"},
        {30.120514,   77.209553875,   4, 11, "IN-HR 800.XX"},
        {28.873614,   76.454773125,   4, 9,  "IN-HR B00.XX"},
        {28.873614,   76.593729125,   4, 9,  "IN-HR D00.XX"},
        {29.127514,   75.636333375,   4, 9,  "IN-HR G00.XX"},
        {29.127514,   75.775969375,   4, 9,  "IN-HR J00.XX"},
        {29.730224,   76.947231625,   4, 9,  "IN-HR L00.XX"},
        {29.030724,   76.963557375,   4, 9,  "IN-HR M00.XX"},
        {30.714824,   76.802779125,   4, 17, "IN-HR N00.XX"},
        {28.833424,   76.093483125,   4, 9,  "IN-HR P00.XX"},
        {29.570724,   74.983331625,   5, 15, "IN-HR Q00.XX"},
        {28.734524,   76.884083125,   4, 12, "IN-HR R00.XX"},
        {29.356124,   76.272857375,   4, 9,  "IN-HR S00.XX"},
        {30.005224,   76.802505875,   4, 12, "IN-HR T00.XX"},
        {29.841924,   76.355531625,   4, 12, "IN-HR V00.XX"},
        {28.237224,   76.572409875,   4, 10, "IN-HR W00.XX"},
        {29.140424,   75.918957375,   4, 9,  "IN-HR X00.XX"},
        {28.087224,   76.060909875,   4, 10, "IN-HR Y00.XX"},
        {29.553824,   75.407131625,   5, 15, "IN-HR Z00.XX"},
        {30.491025,   76.682025,      3, 12, "IN-HR 00V.S09"},
        {29.214025,   74.444025,      3, 10, "IN-HR 11L.L07"},
        {27.640025,   75.280025,      3, 9,  "IN-HR 45S.S16"},
        {27.0911025,  93.585924,      5, 15, "IN-AR 12.XX"},
        {27.182894,   93.485314625,   4, 14, "IN-AR 00.XXX"},
        {28.064414,   95.187758125,   4, 11, "IN-AR J0.XXX"},
        {28.163794,   94.719794875,   4, 12, "IN-AR 000.XX"},
        {27.583894,   91.833310625,   4, 13, "IN-AR 300.XX"},
        {26.958194,   95.430626375,   4, 14, "IN-AR 600.XX"},
        {27.132894,   95.665526375,   4, 14, "IN-AR 900.XX"},
        {27.918194,   96.080094875,   4, 11, "IN-AR D00.XX"},
        {28.121814,   95.767611875,   4, 11, "IN-AR H00.XX"},
        {28.778114,   95.834573125,   4, 11, "IN-AR K00.XX"},
        {28.592814,   94.968773125,   4, 11, "IN-AR M00.XX"},
        {27.961414,   94.183911875,   4, 14, "IN-AR P00.XX"},
        {27.221714,   92.377091375,   4, 13, "IN-AR R00.XX"},
        {27.338014,   92.927051625,   4, 13, "IN-AR T00.XX"},
        {28.245414,   95.540411875,   4, 12, "IN-AR W00.XX"},
        {27.542314,   93.751051625,   4, 13, "IN-AR Y00.XX"},
        {29.127593,   91.66744,       3, 10, "IN-AR 123.XXX"},
        {29.233375,   94.8660345,     3, 10, "IN-AR 12.XXXX"},
        {26.192143,   91.7220025,     5, 11, "IN-AS 12.XX"},
        {26.483915,   91.4084715,     4, 7,  "IN-AS 12.XXX"},
        {24.788014,   92.7356795,     4, 8,  "IN-AS 000.XX"},
        {26.651314,   92.714331125,   4, 10, "IN-AS 200.XX"},
        {27.426614,   94.870951625,   4, 14, "IN-AS 400.XX"},
        {26.736714,   94.143631125,   4, 16, "IN-AS 600.XX"},
        {26.328014,   92.616931125,   4, 8,  "IN-AS 800.XX"},
        {27.473014,   95.288251625,   4, 14, "IN-AS B00.XX"},
        {27.350914,   95.262951625,   4, 14, "IN-AS D00.XX"},
        {26.958114,   94.551991375,   5, 18, "IN-AS G00.XX"},
        {26.000314,   93.697469875,   4, 12, "IN-AS J00.XX"},
        {26.492914,   93.902931125,   4, 11, "IN-AS L00.XX"},
        {26.473514,   90.464231125,   4, 7,  "IN-AS N00.XX"},
        {26.044814,   89.900369875,   4, 10, "IN-AS Q00.XX"},
        {27.288124,   94.055061375,   5, 15, "IN-AS S00.XX"},
        {24.913924,   92.3163525,     4, 10, "IN-AS T00.XX"},
        {25.891524,   93.392313875,   4, 11, "IN-AS V00.XX"},
        {25.791924,   93.126213875,   4, 8,  "IN-AS W00.XX"},
        {26.194924,   90.554413875,   4, 10, "IN-AS X00.XX"},
        {26.362024,   90.959287125,   4, 7,  "IN-AS Y00.XX"},
        {26.540824,   90.914587125,   4, 7,  "IN-AS Z00.XX"},
        {26.983115,   89.76525,       3, 13, "IN-AS 012.XXX"},
        {26.983115,   90.28605,       1, 6,  "IN-AS 112.XXX"},
        {26.983115,   90.80685,       1, 6,  "IN-AS 212.XXX"},
        {26.983115,   91.32765,       1, 6,  "IN-AS 312.XXX"},
        {26.983115,   91.84845,       3, 13, "IN-AS 412.XXX"},
        {26.983115,   92.36925,       3, 13, "IN-AS 512.XXX"},
        {26.983115,   92.89005,       3, 13, "IN-AS 612.XXX"},
        {26.983115,   93.41085,       3, 16, "IN-AS 712.XXX"},
        {26.983115,   93.93165,       3, 16, "IN-AS 812.XXX"},
        {27.474155,   93.93165,       4, 14, "IN-AS 912.XXX"},
        {27.924595,   93.9319365,     3, 13, "IN-AS B12.XXX"},
        {27.474155,   93.405642,      3, 13, "IN-AS C12.XXX"},
        {26.492075,   93.9313635,     4, 11, "IN-AS D12.XXX"},
        {26.492075,   93.4157715,     3, 10, "IN-AS F12.XXX"},
        {26.492075,   92.9001795,     3, 7,  "IN-AS G12.XXX"},
        {26.492075,   92.3845875,     3, 7,  "IN-AS H12.XXX"},
        {26.492075,   91.8689955,     4, 7,  "IN-AS J12.XXX"},
        {26.492075,   91.3534035,     3, 6,  "IN-AS K12.XXX"},
        {26.492075,   90.8378115,     3, 6,  "IN-AS L12.XXX"},
        {26.492075,   90.3222195,     3, 6,  "IN-AS M12.XXX"},
        {26.492075,   89.8066275,     4, 12, "IN-AS N12.XXX"},
        {26.001035,   89.8066275,     4, 18, "IN-AS P12.XXX"},
        {26.001035,   90.3222195,     3, 9,  "IN-AS Q12.XXX"},
        {26.001035,   90.8378115,     3, 9,  "IN-AS R12.XXX"},
        {26.001035,   91.3534035,     3, 9,  "IN-AS S12.XXX"},
        {26.001035,   91.8689955,     3, 9,  "IN-AS T12.XXX"},
        {26.001035,   92.3845875,     3, 10, "IN-AS V12.XXX"},
        {26.001035,   92.9001795,     3, 7,  "IN-AS W12.XXX"},
        {26.001035,   93.4157715,     3, 10, "IN-AS X12.XXX"},
        {26.001035,   93.9313635,     3, 11, "IN-AS Y12.XXX"},
        {27.4562735,  93.9261115,     4, 14, "IN-AS Z12.XXX"},
        {25.075745,   92.1012495,     3, 11, "IN-AS 1123.XX"},
        {25.075745,   92.6168415,     3, 10, "IN-AS 2123.XX"},
        {25.075745,   93.1324335,     3, 10, "IN-AS 3123.XX"},
        {24.58742,    92.101221,      4, 9,  "IN-AS 4123.XX"},
        {24.58742,    92.611605,      4, 8,  "IN-AS 5123.XX"},
        {24.58742,    93.121989,      3, 10, "IN-AS 6123.XX"},
        {24.122385,   92.101221,      3, 12, "IN-AS 7123.XX"},
        {24.122385,   92.611605,      3, 10, "IN-AS 8123.XX"},
        {27.490345,   94.4314865,     4, 14, "IN-AS K123.XX"},
        {27.490345,   94.9574945,     5, 15, "IN-AS L123.XX"},
        {27.490345,   95.4835025,     4, 14, "IN-AS M123.XX"},
        {27.04254,    94.431458,      3, 16, "IN-AS N123.XX"},
        {27.04254,    94.952258,      3, 16, "IN-AS P123.XX"},
        {27.04254,    95.473058,      3, 13, "IN-AS Q123.XX"},
        {26.548785,   94.431458,      4, 11, "IN-AS R123.XX"},
        {26.548785,   94.952258,      3, 10, "IN-AS S123.XX"},
        {26.57213,    94.3787075,     4, 11, "IN-AS T123.XX"},
        {25.617606,   85.07888875,    5, 8,  "IN-BR 00.XX"},
        {25.579035,   85.14893575,    5, 8,  "IN-BR J0.XX"},
        {25.583994,   84.98809275,    4, 7,  "IN-BR 00.XXX"},
        {24.918084,   84.8245595,     4, 9,  "IN-BR C0.XXX"},
        {25.386384,   86.8362595,     4, 9,  "IN-BR P0.XXX"},
        {26.170724,   85.334913875,   4, 7,  "IN-BR 000.XX"},
        {25.820724,   87.424913875,   5, 10, "IN-BR 100.XX"},
        {26.192124,   85.854113875,   4, 9,  "IN-BR 200.XX"},
        {25.250724,   85.47502675,    4, 9,  "IN-BR 300.XX"},
        {25.600724,   84.61502675,    4, 9,  "IN-BR 400.XX"},
        {25.396124,   86.45372675,    4, 9,  "IN-BR 500.XX"},
        {25.846624,   84.674913875,   4, 9,  "IN-BR 600.XX"},
        {25.803379,   84.770771875,   4, 7,  "IN-BR 700.XX"},
        {25.590724,   87.52502675,    4, 9,  "IN-BR 800.XX"},
        {25.458224,   86.08542675,    4, 9,  "IN-BR 900.XX"},
        {26.841124,   84.460461375,   4, 10, "IN-BR B00.XX"},
        {25.925224,   86.552913875,   4, 9,  "IN-BR C00.XX"},
        {24.993824,   83.9709525,     4, 11, "IN-BR D00.XX"},
        {24.957324,   84.1362525,     4, 11, "IN-BR F00.XX"},
        {26.690024,   84.866187125,   4, 10, "IN-BR G00.XX"},
        {24.929324,   85.4969525,     4, 9,  "IN-BR H00.XX"},
        {27.171624,   84.042861375,   4, 10, "IN-BR J00.XX"},
        {25.604524,   83.93002675,    4, 9,  "IN-BR K00.XX"},
        {26.143124,   87.902113875,   5, 11, "IN-BR L00.XX"},
        {26.634124,   85.448987125,   4, 9,  "IN-BR M00.XX"},
        {25.330424,   86.44422675,    4, 11, "IN-BR N00.XX"},
        {25.255324,   84.94182675,    4, 9,  "IN-BR P00.XX"},
        {24.793924,   84.3302525,     4, 12, "IN-BR Q00.XX"},
        {26.262124,   84.312713875,   4, 9,  "IN-BR R00.XX"},
        {25.209924,   86.0535525,     4, 11, "IN-BR S00.XX"},
        {24.971424,   86.1802525,     4, 11, "IN-BR T00.XX"},
        {26.388024,   86.016687125,   4, 11, "IN-BR V00.XX"},
        {25.899424,   85.736613875,   4, 9,  "IN-BR W00.XX"},
        {26.166324,   87.420813875,   5, 10, "IN-BR X00.XX"},
        {25.399464,   85.90222225,    4, 9,  "IN-BR Y00.XX"},
        {26.459804,   84.412878125,   4, 9,  "IN-BR YK0.00"},
        {26.133264,   86.563936625,   4, 9,  "IN-BR Z00.XX"},
        {25.551704,   84.11829475,    4, 9,  "IN-BR ZK0.00"},
        {27.478115,   83.76825,       3, 11, "IN-BR 012.XXX"},
        {27.478115,   84.28905,       3, 11, "IN-BR 112.XXX"},
        {26.987075,   83.76825,       3, 9,  "IN-BR 212.XXX"},
        {26.987075,   84.28905,       3, 9,  "IN-BR 312.XXX"},
        {26.987075,   84.80985,       3, 10, "IN-BR 412.XXX"},
        {26.987075,   85.33065,       3, 9,  "IN-BR 512.XXX"},
        {26.987075,   85.85145,       3, 11, "IN-BR 612.XXX"},
        {26.987075,   86.37225,       3, 11, "IN-BR 712.XXX"},
        {26.987075,   86.89305,       3, 11, "IN-BR 812.XXX"},
        {26.496035,   83.7731715,     3, 8,  "IN-BR 912.XXX"},
        {26.496035,   84.2887635,     3, 8,  "IN-BR B12.XXX"},
        {26.496035,   84.8043555,     3, 8,  "IN-BR C12.XXX"},
        {26.496035,   85.3199475,     3, 8,  "IN-BR D12.XXX"},
        {26.496035,   85.8355395,     3, 10, "IN-BR F12.XXX"},
        {26.496035,   86.3511315,     3, 10, "IN-BR G12.XXX"},
        {26.496035,   86.8667235,     3, 10, "IN-BR H12.XXX"},
        {26.496035,   87.3823155,     3, 10, "IN-BR J12.XXX"},
        {26.510766,   87.8457715,     4, 12, "IN-BR K12.XXX"},
        {26.004995,   83.7731715,     3, 8,  "IN-BR L12.XXX"},
        {26.004995,   84.2887635,     3, 8,  "IN-BR M12.XXX"},
        {26.004995,   84.8043555,     3, 6,  "IN-BR N12.XXX"},
        {26.004995,   85.3199475,     3, 6,  "IN-BR P12.XXX"},
        {26.004995,   85.8355395,     3, 8,  "IN-BR Q12.XXX"},
        {26.004995,   86.3511315,     3, 8,  "IN-BR R12.XXX"},
        {26.004995,   86.8667235,     3, 8,  "IN-BR S12.XXX"},
        {26.004995,   87.3823155,     3, 8,  "IN-BR T12.XXX"},
        {26.004995,   87.8457715,     5, 11, "IN-BR V12.XXX"},
        {26.155115,   87.4255315,     5, 10, "IN-BR Z12.XXX"},
        {25.102115,   83.3263635,     3, 11, "IN-BR 01.XXXX"},
        {25.102115,   83.7731715,     4, 11, "IN-BR 11.XXXX"},
        {25.102115,   84.2887635,     3, 10, "IN-BR 21.XXXX"},
        {25.102115,   84.8043555,     3, 8,  "IN-BR 31.XXXX"},
        {25.102115,   85.3199475,     3, 8,  "IN-BR 41.XXXX"},
        {25.102115,   85.8355395,     3, 10, "IN-BR 51.XXXX"},
        {25.102115,   86.3511315,     3, 10, "IN-BR 61.XXXX"},
        {25.102115,   86.8667235,     3, 10, "IN-BR 71.XXXX"},
        {25.102115,   87.3823155,     3, 11, "IN-BR 81.XXXX"},
        {25.102115,   87.8457715,     4, 13, "IN-BR 91.XXXX"},
        {24.611075,   83.326077,      4, 11, "IN-BR B1.XXXX"},
        {24.611075,   83.767677,      6, 14, "IN-BR C1.XXXX"},
        {24.611075,   84.278061,      4, 12, "IN-BR D1.XXXX"},
        {24.611075,   84.788445,      4, 10, "IN-BR F1.XXXX"},
        {24.611075,   85.298829,      4, 10, "IN-BR G1.XXXX"},
        {24.611075,   85.809213,      4, 12, "IN-BR H1.XXXX"},
        {24.611075,   86.319597,      4, 12, "IN-BR J1.XXXX"},
        {24.611075,   86.829981,      4, 12, "IN-BR K1.XXXX"},
        {24.291795,   83.326077,      3, 11, "IN-BR L1.XXXX"},
        {24.291795,   83.767677,      4, 12, "IN-BR M1.XXXX"},
        {24.291795,   84.278061,      3, 11, "IN-BR N1.XXXX"},
        {24.291795,   84.788445,      3, 9,  "IN-BR P1.XXXX"},
        {24.291795,   85.298829,      3, 9,  "IN-BR Q1.XXXX"},
        {24.291795,   85.809213,      3, 11, "IN-BR R1.XXXX"},
        {24.291795,   86.319597,      3, 11, "IN-BR S1.XXXX"},
        {24.291795,   86.829981,      3, 12, "IN-BR T1.XXXX"},
        {30.3557,     77.9909175,     5, 10, "IN-UT 12.XX"},
        {30.540115,   77.8165015,     4, 10, "IN-UT 12.XXX"},
        {29.940604,   78.010928625,   4, 11, "IN-UT 000.XX"},
        {29.873704,   77.809628625,   4, 12, "IN-UT 400.XX"},
        {29.196804,   79.420309375,   4, 12, "IN-UT 800.XX"},
        {28.975404,   79.336409375,   4, 13, "IN-UT D00.XX"},
        {29.205194,   78.911763375,   5, 13, "IN-UT J00.XX"},
        {30.058494,   78.163931875,   4, 11, "IN-UT M00.XX"},
        {29.553994,   80.132347625,   4, 14, "IN-UT Q00.XX"},
        {29.406994,   79.046263375,   4, 12, "IN-UT T00.XX"},
        {29.236794,   78.743263375,   4, 12, "IN-UT X00.XX"},
        {29.486025,   77.547025,      3, 14, "IN-UT 040.L0L"},
        {29.780025,   80.425025,      3, 13, "IN-UT Q1H.L0R"},
        {28.680025,   78.717025,      3, 12, "IN-UT S1M.S0M"},
        {15.3877865,  73.7658485,     3, 6,  "IN-GA 12.XX"},
        {15.6435645,  73.7050585,     3, 8,  "IN-GA 12.XXX"},
        {14.928406,   73.8727075,     3, 6,  "IN-GA 123.XX"},
        {8.5420425,   76.912268,      5, 10, "IN-KL 12.XX"},
        {8.624794,    76.776259625,   5, 10, "IN-KL 00.XXX"},
        {10.002414,   76.185714375,   4, 7,  "IN-KL J0.XXX"},
        {11.275974,   75.750506875,   4, 9,  "IN-KL 000.XX"},
        {8.944674,    76.5136115,     4, 9,  "IN-KL 500.XX"},
        {10.516674,   76.11177475,    4, 7,  "IN-KL B00.XX"},
        {9.719345,    76.285028125,   4, 9,  "IN-KL H00.XX"},
        {10.754004,   76.60071475,    4, 9,  "IN-KL M00.XX"},
        {11.872704,   75.299074875,   4, 9,  "IN-KL R00.XX"},
        {9.610404,    76.456454625,   4, 9,  "IN-KL W00.XX"},
        {12.746595,   74.885358,      3, 9,  "IN-KL 112.XXX"},
        {12.449718,   74.9338645,     4, 10, "IN-KL 212.XXX"},
        {12.449718,   75.4077925,     3, 9,  "IN-KL 312.XXX"},
        {11.958678,   75.0760425,     3, 8,  "IN-KL 412.XXX"},
        {11.958678,   75.5499705,     3, 10, "IN-KL 512.XXX"},
        {11.958678,   76.0238985,     3, 10, "IN-KL 612.XXX"},
        {11.467638,   75.5499705,     3, 8,  "IN-KL 712.XXX"},
        {11.467638,   76.0238985,     3, 8,  "IN-KL 812.XXX"},
        {11.467638,   76.4978265,     3, 11, "IN-KL 912.XXX"},
        {10.976598,   75.5499705,     3, 8,  "IN-KL B12.XXX"},
        {10.976598,   76.0238985,     3, 8,  "IN-KL C12.XXX"},
        {10.976598,   76.4978265,     3, 10, "IN-KL D12.XXX"},
        {10.485558,   76.0049415,     3, 6,  "IN-KL F12.XXX"},
        {10.485558,   76.4788695,     3, 8,  "IN-KL G12.XXX"},
        {10.485558,   76.9521435,     3, 9,  "IN-KL H12.XXX"},
        {9.994518,    76.0049415,     3, 6,  "IN-KL J12.XXX"},
        {9.994518,    76.4788695,     4, 9,  "IN-KL K12.XXX"},
        {9.994518,    76.9521435,     3, 8,  "IN-KL L12.XXX"},
        {9.503478,    76.0049415,     3, 6,  "IN-KL M12.XXX"},
        {9.503478,    76.4788695,     3, 8,  "IN-KL N12.XXX"},
        {9.503478,    76.9521435,     3, 8,  "IN-KL P12.XXX"},
        {9.012438,    76.4788695,     3, 8,  "IN-KL Q12.XXX"},
        {9.012438,    76.9521435,     3, 8,  "IN-KL R12.XXX"},
        {8.732635,    76.478583,      4, 9,  "IN-KL S12.XXX"},
        {8.732635,    76.947303,      4, 9,  "IN-KL T12.XXX"},
        {13.081,      80.208968,      5, 12, "IN-TN 12.XX"},
        {13.234715,   79.89099,       4, 11, "IN-TN 12.XXX"},
        {9.907114,    78.052541625,   4, 7,  "IN-TN 000.XX"},
        {10.790714,   78.64537175,    4, 7,  "IN-TN 200.XX"},
        {11.638314,   78.091501875,   4, 11, "IN-TN 400.XX"},
        {8.706714,    77.6606115,     4, 7,  "IN-TN 600.XX"},
        {11.088814,   77.275201875,   4, 11, "IN-TN 800.XX"},
        {11.910214,   79.724801875,   4, 10, "IN-TN B00.XX"},
        {8.794914,    78.0518115,     4, 7,  "IN-TN D00.XX"},
        {10.748214,   79.07597175,    4, 7,  "IN-TN G00.XX"},
        {8.209834,    77.392226875,   4, 7,  "IN-TN J00.XX"},
        {10.389834,   77.93506375,    4, 7,  "IN-TN K00.XX"},
        {12.959945,   79.104930625,   4, 11, "IN-TN L00.XX"},
        {10.106195,   78.75522875,    4, 7,  "IN-TN M00.XX"},
        {9.487705,    77.7533275,     4, 7,  "IN-TN N00.XX"},
        {10.983961,   78.02702875,    4, 9,  "IN-TN P00.XX"},
        {11.093924,   76.87464275,    4, 12, "IN-TN Q00.XX"},
        {11.093924,   76.96257275,    4, 11, "IN-TN R00.XX"},
        {11.007435,   76.96257275,    4, 11, "IN-TN S00.XX"},
        {11.007435,   76.87464275,    4, 12, "IN-TN T00.XX"},
        {11.792124,   79.712929875,   4, 10, "IN-TN V00.XX"},
        {12.880724,   79.658303125,   4, 11, "IN-TN W00.XX"},
        {11.390724,   77.679729875,   4, 9,  "IN-TN X00.XX"},
        {11.002124,   79.33864275,    4, 9,  "IN-TN Y00.XX"},
        {12.274624,   79.029016,      4, 9,  "IN-TN Z00.XX"},
        {13.4865005,  79.9579015,     3, 10, "IN-TN 112.XXX"},
        {13.227038,   79.414481,      3, 11, "IN-TN 212.XXX"},
        {13.144607,   78.633457,      3, 10, "IN-TN 312.XXX"},
        {12.939612,   77.507709,      3, 14, "IN-TN 412.XXX"},
        {12.939612,   77.986844,      3, 13, "IN-TN 512.XXX"},
        {12.939612,   78.46598,       3, 13, "IN-TN 612.XXX"},
        {12.939612,   78.945116,      3, 10, "IN-TN 712.XXX"},
        {12.939612,   79.424252,      3, 10, "IN-TN 812.XXX"},
        {12.939612,   79.903388,      4, 11, "IN-TN 912.XXX"},
        {12.448572,   79.7885265,     3, 8,  "IN-TN B12.XXX"},
        {12.448572,   79.3145985,     3, 8,  "IN-TN C12.XXX"},
        {12.448572,   78.8406705,     3, 8,  "IN-TN D12.XXX"},
        {12.448572,   78.3667425,     3, 11, "IN-TN F12.XXX"},
        {12.448572,   77.8928145,     3, 11, "IN-TN G12.XXX"},
        {12.448572,   77.4188865,     3, 11, "IN-TN H12.XXX"},
        {11.957532,   79.5041695,     3, 8,  "IN-TN J12.XXX"},
        {11.957532,   79.0302415,     3, 8,  "IN-TN K12.XXX"},
        {11.957532,   78.5563135,     3, 10, "IN-TN L12.XXX"},
        {11.957532,   78.0823855,     3, 10, "IN-TN M12.XXX"},
        {11.957532,   77.6084575,     3, 10, "IN-TN N12.XXX"},
        {11.957532,   77.1345295,     3, 12, "IN-TN P12.XXX"},
        {11.957532,   76.6606015,     4, 13, "IN-TN Q12.XXX"},
        {11.957532,   76.2540715,     3, 13, "IN-TN R12.XXX"},
        {11.466492,   76.2540715,     3, 11, "IN-TN S12.XXX"},
        {11.466492,   76.6606015,     4, 12, "IN-TN T12.XXX"},
        {11.466492,   77.1345295,     3, 10, "IN-TN V12.XXX"},
        {11.466492,   77.6084575,     3, 8,  "IN-TN W12.XXX"},
        {11.466492,   78.0823855,     3, 8,  "IN-TN X12.XXX"},
        {11.466492,   78.5563135,     3, 8,  "IN-TN Y12.XXX"},
        {11.466492,   79.0302415,     3, 8,  "IN-TN Z12.XXX"},
        {11.034957,   79.4806915,     3, 8,  "IN-TN 0123.XX"},
        {10.543917,   79.4806915,     3, 6,  "IN-TN 1123.XX"},
        {10.543917,   79.0067635,     3, 6,  "IN-TN 2123.XX"},
        {10.543917,   78.5328355,     3, 6,  "IN-TN 3123.XX"},
        {10.543917,   78.0589075,     3, 6,  "IN-TN 4123.XX"},
        {10.543917,   77.5849795,     3, 6,  "IN-TN 5123.XX"},
        {10.543917,   77.1110515,     3, 8,  "IN-TN 6123.XX"},
        {10.543917,   76.6371235,     3, 9,  "IN-TN 7123.XX"},
        {10.052877,   76.6371235,     3, 9,  "IN-TN 8123.XX"},
        {10.052877,   77.1110515,     3, 9,  "IN-TN 9123.XX"},
        {10.052877,   77.5849795,     3, 6,  "IN-TN B123.XX"},
        {10.052877,   78.0589075,     3, 6,  "IN-TN C123.XX"},
        {10.052877,   78.5328355,     3, 6,  "IN-TN D123.XX"},
        {10.052877,   79.0067635,     3, 6,  "IN-TN F123.XX"},
        {10.052877,   79.4806915,     3, 6,  "IN-TN G123.XX"},
        {9.559122,    79.0067635,     3, 6,  "IN-TN H123.XX"},
        {9.559122,    78.5328355,     3, 6,  "IN-TN J123.XX"},
        {9.559122,    78.0589075,     3, 6,  "IN-TN K123.XX"},
        {9.559122,    77.5849795,     3, 6,  "IN-TN L123.XX"},
        {9.559122,    77.1110515,     3, 9,  "IN-TN M123.XX"},
        {9.068082,    77.1110515,     3, 9,  "IN-TN N123.XX"},
        {9.068082,    77.5849795,     3, 6,  "IN-TN P123.XX"},
        {9.068082,    78.0589075,     3, 6,  "IN-TN Q123.XX"},
        {9.068082,    78.5328355,     3, 6,  "IN-TN R123.XX"},
        {9.068082,    79.0067635,     3, 6,  "IN-TN S123.XX"},
        {8.577042,    77.9404255,     3, 6,  "IN-TN T123.XX"},
        {8.577042,    77.4664975,     3, 6,  "IN-TN V123.XX"},
        {8.577042,    76.9925695,     3, 11, "IN-TN W123.XX"},
        {8.088717,    76.992541,      3, 6,  "IN-TN X123.XX"},
        {8.088717,    77.461261,      3, 6,  "IN-TN Y123.XX"},
        {8.088717,    77.929981,      3, 6,  "IN-TN Z123.XX"},
        {31.1244,     77.1382755,     5, 8,  "IN-HP 12.XX"},
        {31.252615,   76.94088,       4, 9,  "IN-HP 12.XXX"},
        {32.216204,   76.199127,      4, 11, "IN-HP 000.XX"},
        {31.753244,   76.84893275,    4, 12, "IN-HP 700.XX"},
        {30.585244,   77.171402125,   4, 10, "IN-HP F00.XX"},
        {31.539944,   76.8073205,     4, 12, "IN-HP M00.XX"},
        {32.568244,   76.009344,      4, 12, "IN-HP T00.XX"},
        {31.100025,   75.576025,      3, 9,  "IN-HP 04B.S14"},
        {31.100025,   78.023025,      3, 9,  "IN-HP N3D.D0L"},
        {30.378025,   76.577025,      3, 12, "IN-HP W1G.D12"},
        {34.1191,     74.761532,      5, 11, "IN-JK 12.XX"},
        {34.176294,   74.600234,      4, 10, "IN-JK 00.XXX"},
        {32.724314,   74.670192625,   4, 10, "IN-JK J0.XXX"},
        {33.725194,   75.057698,      4, 9,  "IN-JK 000.XX"},
        {34.208194,   74.256774375,   4, 10, "IN-JK 300.XX"},
        {32.906194,   75.054037375,   4, 9,  "IN-JK 600.XX"},
        {32.377194,   75.438861,      4, 12, "IN-JK 900.XX"},
        {35.935794,   74.235911375,   4, 12, "IN-JK D00.XX"},
        {35.301494,   75.490535,      4, 11, "IN-JK H00.XX"},
        {33.189045,   73.685268125,   4, 11, "IN-JK L00.XX"},
        {34.358594,   73.380574375,   3, 10, "IN-JK P00.XX"},
        {33.365194,   74.229821625,   4, 11, "IN-JK S00.XX"},
        {33.126014,   75.473477625,   4, 9,  "IN-JK W00.XX"},
        {33.300314,   75.690377625,   4, 9,  "IN-JK Y00.XX"},
        {35.299367,   73.4810395,     3, 10, "IN-JK 12.XXXX"},
        {34.8862305,  73.5123705,     3, 12, "IN-JK 123.XXX"},
        {34.761137,   76.665236,      3, 10, "IN-JK 1234.XX"},
        {21.2811,     81.597584,      5, 12, "IN-CT 12.XX"},
        {21.206876,   81.205504,      4, 9,  "IN-CT 12.XXX"},
        {22.379694,   82.6232445,     4, 11, "IN-CT 000.XX"},
        {22.067394,   82.069052375,   4, 12, "IN-CT 300.XX"},
        {21.094194,   80.95976025,    4, 11, "IN-CT 600.XX"},
        {21.889194,   83.315552375,   4, 10, "IN-CT 900.XX"},
        {19.077194,   81.9480075,     4, 12, "IN-CT D00.XX"},
        {23.126894,   83.09142875,    4, 7,  "IN-CT H00.XX"},
        {20.714094,   81.490676,      4, 9,  "IN-CT L00.XX"},
        {23.169994,   82.290620875,   4, 9,  "IN-CT P00.XX"},
        {20.575394,   81.011476,      4, 7,  "IN-CT S00.XX"},
        {21.717514,   81.881307375,   4, 12, "IN-CT W00.XX"},
        {21.106314,   82.00617725,    4, 12, "IN-CT Y00.XX"},
        {23.2215765,  81.086856,      3, 9,  "IN-CT 12.XXXX"},
        {21.745905,   80.4804235,     3, 10, "IN-CT 123.XXX"},
        {19.951908,   80.33725,       3, 8,  "IN-CT 1234.XX"},
        {23.3948,     85.2869435,     5, 8,  "IN-JH 12.XX"},
        {23.729965,   86.052938625,   4, 10, "IN-JH 00.XXX"},
        {23.369014,   85.145770125,   4, 7,  "IN-JH J0.XXX"},
        {22.773714,   86.13389775,    4, 9,  "IN-JH 000.XX"},
        {24.468914,   86.61821925,    4, 12, "IN-JH 200.XX"},
        {23.951414,   85.304689125,   4, 7,  "IN-JH 400.XX"},
        {24.164314,   86.23741925,    4, 9,  "IN-JH 600.XX"},
        {23.640114,   85.270589125,   4, 7,  "IN-JH 800.XX"},
        {23.646229,   85.404109125,   4, 7,  "IN-JH B00.XX"},
        {24.023414,   84.003989125,   4, 12, "IN-JH D00.XX"},
        {23.717714,   86.749589125,   4, 10, "IN-JH G00.XX"},
        {25.220514,   87.57783975,    4, 12, "IN-JH J00.XX"},
        {24.411614,   85.47511925,    4, 10, "IN-JH L00.XX"},
        {22.524414,   85.7398375,     4, 11, "IN-JH N00.XX"},
        {24.247814,   86.57941925,    4, 9,  "IN-JH Q00.XX"},
        {24.268214,   87.18301925,    4, 13, "IN-JH S00.XX"},
        {23.024014,   84.47739775,    4, 7,  "IN-JH V00.XX"},
        {22.655114,   85.55819775,    4, 7,  "IN-JH X00.XX"},
        {24.855124,   87.1628525,     4, 12, "IN-JH Z00.XX"},
        {25.292595,   86.9936705,     3, 12, "IN-JH 012.XXX"},
        {25.292595,   87.4797715,     4, 12, "IN-JH 112.XXX"},
        {24.801555,   83.38424,       3, 11, "IN-JH 212.XXX"},
        {24.801555,   83.894624,      3, 11, "IN-JH 312.XXX"},
        {24.801555,   84.405008,      3, 11, "IN-JH 412.XXX"},
        {24.801555,   84.915392,      3, 10, "IN-JH 512.XXX"},
        {24.801555,   85.425776,      3, 9,  "IN-JH 612.XXX"},
        {24.801555,   85.93616,       3, 11, "IN-JH 712.XXX"},
        {24.801555,   86.446544,      3, 11, "IN-JH 812.XXX"},
        {24.801555,   86.956928,      3, 11, "IN-JH 912.XXX"},
        {24.801555,   87.467312,      3, 10, "IN-JH B12.XXX"},
        {24.310515,   83.333201,      3, 11, "IN-JH C12.XXX"},
        {24.310515,   83.843585,      3, 11, "IN-JH D12.XXX"},
        {24.310515,   84.353969,      3, 11, "IN-JH F12.XXX"},
        {24.310515,   84.864353,      3, 9,  "IN-JH G12.XXX"},
        {24.310515,   85.374737,      3, 9,  "IN-JH H12.XXX"},
        {24.310515,   85.885121,      3, 11, "IN-JH J12.XXX"},
        {24.310515,   86.395505,      3, 11, "IN-JH K12.XXX"},
        {24.310515,   86.905889,      3, 11, "IN-JH L12.XXX"},
        {24.310515,   87.416273,      3, 10, "IN-JH M12.XXX"},
        {23.819475,   83.5933145,     3, 9,  "IN-JH N12.XXX"},
        {23.819475,   84.0984905,     3, 9,  "IN-JH P12.XXX"},
        {23.819475,   84.6036665,     3, 6,  "IN-JH Q12.XXX"},
        {23.819475,   85.1088425,     3, 6,  "IN-JH R12.XXX"},
        {23.819475,   85.6140185,     3, 6,  "IN-JH S12.XXX"},
        {23.819475,   86.1191945,     4, 9,  "IN-JH T12.XXX"},
        {23.641786,   86.6180295,     3, 9,  "IN-JH V12.XXX"},
        {23.328435,   84.0580775,     3, 9,  "IN-JH W12.XXX"},
        {23.328435,   84.5632535,     3, 6,  "IN-JH X12.XXX"},
        {23.328435,   85.0684295,     3, 6,  "IN-JH Y12.XXX"},
        {23.328435,   85.5736055,     3, 6,  "IN-JH Z12.XXX"},
        {22.916595,   86.0787815,     3, 9,  "IN-JH 01.XXXX"},
        {22.425555,   83.9065245,     3, 11, "IN-JH 11.XXXX"},
        {22.425555,   84.4117005,     4, 12, "IN-JH 21.XXXX"},
        {22.425555,   84.9168765,     4, 9,  "IN-JH 31.XXXX"},
        {22.425555,   85.4220525,     4, 9,  "IN-JH 41.XXXX"},
        {22.425555,   85.9272285,     4, 11, "IN-JH 51.XXXX"},
        {22.425555,   86.4324045,     4, 12, "IN-JH 61.XXXX"},
        {21.973795,   83.956755,      3, 11, "IN-JH 71.XXXX"},
        {21.973795,   84.456723,      3, 9,  "IN-JH 81.XXXX"},
        {21.973795,   84.956691,      3, 9,  "IN-JH 91.XXXX"},
        {21.973795,   85.456659,      3, 9,  "IN-JH B1.XXXX"},
        {21.973795,   85.956627,      3, 11, "IN-JH C1.XXXX"},
        {21.973795,   86.456595,      3, 11, "IN-JH D1.XXXX"},
        {13.0065,     77.555368,      5, 14, "IN-KA 12.XX"},
        {13.171515,   77.38089,       4, 13, "IN-KA 12.XXX"},
        {15.340514,   75.066683625,   4, 7,  "IN-KA 000.XX"},
        {12.290514,   76.587532,      4, 13, "IN-KA 200.XX"},
        {17.314614,   76.769574,      4, 13, "IN-KA 400.XX"},
        {15.840514,   74.44921375,    4, 9,  "IN-KA 600.XX"},
        {12.881714,   74.795963125,   4, 7,  "IN-KA 800.XX"},
        {14.496824,   75.883377375,   4, 9,  "IN-KA B00.XX"},
        {15.177424,   76.8815645,     4, 12, "IN-KA C00.XX"},
        {16.870724,   75.676512,      4, 9,  "IN-KA D00.XX"},
        {13.970724,   75.52819025,    4, 9,  "IN-KA F00.XX"},
        {13.389324,   77.06709025,    4, 14, "IN-KA G00.XX"},
        {16.250724,   77.30773875,    4, 15, "IN-KA H00.XX"},
        {17.952824,   77.45998625,    4, 14, "IN-KA J00.XX"},
        {15.320724,   76.327851625,   4, 9,  "IN-KA K00.XX"},
        {13.880724,   75.64819025,    4, 9,  "IN-KA L00.XX"},
        {13.010724,   78.238303125,   4, 13, "IN-KA M00.XX"},
        {14.267324,   76.361577375,   4, 9,  "IN-KA N00.XX"},
        {13.177724,   78.088903125,   4, 13, "IN-KA P00.XX"},
        {12.563924,   76.856816,      4, 15, "IN-KA Q00.XX"},
        {13.050824,   76.058203125,   4, 9,  "IN-KA R00.XX"},
        {16.200724,   75.62173875,    4, 11, "IN-KA S00.XX"},
        {13.375724,   74.70919025,    4, 7,  "IN-KA T00.XX"},
        {13.365724,   75.74019025,    4, 9,  "IN-KA V00.XX"},
        {14.656724,   75.590077375,   4, 9,  "IN-KA W00.XX"},
        {15.472724,   76.488851625,   4, 9,  "IN-KA X00.XX"},
        {15.469424,   75.592851625,   4, 9,  "IN-KA Y00.XX"},
        {13.342624,   77.49999025,    4, 14, "IN-KA Z00.XX"},
        {17.8443895,  74.8752175,     3, 9,  "IN-KA 12.XXXX"},
        {13.0347345,  74.6277625,     3, 6,  "IN-KA 123.XXX"},
        {14.160882,   74.210462,      3, 6,  "IN-KA 1234.XX"},
        {26.9427,     75.7633,        5, 8,  "IN-RJ 12.XX"},
        {26.828994,   75.645711375,   4, 9,  "IN-RJ 00.XXX"},
        {26.393684,   72.865727625,   3, 6,  "IN-RJ C0.XXX"},
        {25.324584,   75.6865595,     4, 10, "IN-RJ P0.XXX"},
        {28.005014,   73.266111875,   4, 7,  "IN-RJ 000.XX"},
        {26.438414,   74.547831125,   4, 9,  "IN-RJ 200.XX"},
        {24.563914,   73.64271925,    4, 9,  "IN-RJ 400.XX"},
        {25.321914,   74.55283975,    4, 9,  "IN-RJ 600.XX"},
        {27.605024,   76.583435625,   4, 7,  "IN-RJ 800.XX"},
        {27.262224,   77.449661375,   4, 10, "IN-RJ 900.XX"},
        {27.649624,   75.097635625,   4, 9,  "IN-RJ B00.XX"},
        {25.822124,   73.276813875,   4, 7,  "IN-RJ C00.XX"},
        {29.943424,   73.842331625,   4, 10, "IN-RJ D00.XX"},
        {26.210724,   75.734913875,   4, 9,  "IN-RJ F00.XX"},
        {26.628924,   74.806187125,   4, 9,  "IN-RJ G00.XX"},
        {29.641924,   74.263431625,   4, 12, "IN-RJ H00.XX"},
        {26.151124,   74.300213875,   4, 9,  "IN-RJ J00.XX"},
        {26.749424,   77.833787125,   4, 12, "IN-RJ K00.XX"},
        {26.053724,   76.317313875,   4, 9,  "IN-RJ L00.XX"},
        {28.341924,   74.920909875,   4, 9,  "IN-RJ M00.XX"},
        {28.159324,   75.346309875,   4, 10, "IN-RJ N00.XX"},
        {24.932224,   74.5836525,     4, 9,  "IN-RJ P00.XX"},
        {26.525224,   76.670587125,   4, 9,  "IN-RJ Q00.XX"},
        {25.137224,   76.4660525,     4, 9,  "IN-RJ R00.XX"},
        {28.251324,   76.808809875,   4, 10, "IN-RJ S00.XX"},
        {25.470924,   75.60072675,    4, 9,  "IN-RJ T00.XX"},
        {27.739924,   74.424535625,   4, 7,  "IN-RJ V00.XX"},
        {23.588124,   74.389717875,   4, 11, "IN-RJ W00.XX"},
        {27.044545,   74.666251875,   4, 7,  "IN-RJ X00.XX"},
        {27.239524,   73.693861375,   4, 7,  "IN-RJ Y00.XX"},
        {26.783424,   76.984787125,   4, 9,  "IN-RJ Z00.XX"},
        {25.481823,   74.3638255,     3, 8,  "IN-RJ 12.XXXX"},
        {28.3713825,  74.26268,       3, 6,  "IN-RJ 123.XXX"},
        {27.790409,   73.0802775,     3, 6,  "IN-RJ 0123.XX"},
        {24.352024,   73.457196,      3, 8,  "IN-RJ 1123.XX"},
        {26.990124,   77.237645,      3, 9,  "IN-RJ 2123.XX"},
        {25.550024,   73.0721385,     3, 6,  "IN-RJ 3123.XX"},
        {29.517859,   73.8394765,     3, 9,  "IN-RJ 4123.XX"},
        {26.474609,   77.621545,      3, 11, "IN-RJ 5123.XX"},
        {26.967424,   73.481845,      3, 6,  "IN-RJ 6123.XX"},
        {20.3168,     85.7953855,     5, 8,  "IN-OR 12.XX"},
        {20.1381385,  85.556887,      4, 7,  "IN-OR 12.XXX"},
        {19.314194,   84.7210075,     4, 9,  "IN-OR 000.XX"},
        {22.234194,   84.7616445,     4, 10, "IN-OR 300.XX"},
        {19.849094,   85.75059175,    4, 7,  "IN-OR 600.XX"},
        {21.472614,   83.86107725,    4, 9,  "IN-OR 900.XX"},
        {21.474314,   86.86537725,    4, 9,  "IN-OR C00.XX"},
        {21.915014,   86.670007375,   4, 9,  "IN-OR F00.XX"},
        {20.689914,   83.446216,      4, 10, "IN-OR H00.XX"},
        {21.799514,   83.834807375,   4, 9,  "IN-OR K00.XX"},
        {20.268914,   86.575785875,   4, 7,  "IN-OR M00.XX"},
        {21.331414,   83.55477725,    4, 10, "IN-OR P00.XX"},
        {19.911114,   83.09975575,    4, 11, "IN-OR R00.XX"},
        {19.189114,   83.3384955,     4, 11, "IN-OR T00.XX"},
        {21.109418,   86.43870025,    4, 7,  "IN-OR W00.XX"},
        {20.871545,   85.05169,       4, 7,  "IN-OR Y00.XX"},
        {22.039544,   84.7977925,     3, 9,  "IN-OR 12.XXXX"},
        {22.2479135,  81.899047,      3, 11, "IN-OR 123.XXX"},
        {17.84927,    81.640768,      3, 11, "IN-OR 1234.XX"},
        {23.0556,     72.5474435,     5, 10, "IN-GJ 12.XX"},
        {22.971394,   72.41716275,    4, 9,  "IN-GJ 00.XXX"},
        {21.309984,   72.69103375,    4, 9,  "IN-GJ C0.XXX"},
        {22.405084,   73.0335785,     4, 7,  "IN-GJ P0.XXX"},
        {22.324524,   70.7495565,     4, 7,  "IN-GJ 000.XX"},
        {21.796124,   72.086269375,   4, 7,  "IN-GJ 100.XX"},
        {22.494545,   70.0236345,     4, 7,  "IN-GJ 200.XX"},
        {21.566545,   70.40994125,    4, 7,  "IN-GJ 300.XX"},
        {23.103724,   70.06093075,    4, 9,  "IN-GJ 400.XX"},
        {20.985124,   72.894608,      4, 9,  "IN-GJ 500.XX"},
        {22.728024,   72.81373075,    4, 7,  "IN-GJ 600.XX"},
        {23.268324,   72.604317875,   4, 9,  "IN-GJ 700.XX"},
        {23.636324,   72.331317875,   4, 9,  "IN-GJ 800.XX"},
        {22.606024,   72.9020565,     4, 7,  "IN-GJ 900.XX"},
        {21.684924,   69.572869375,   4, 7,  "IN-GJ B00.XX"},
        {22.859724,   70.79193075,    5, 8,  "IN-GJ C00.XX"},
        {22.750724,   71.60253075,    5, 8,  "IN-GJ D00.XX"},
        {21.759324,   72.955069375,   4, 9,  "IN-GJ F00.XX"},
        {20.409724,   72.881721875,   4, 12, "IN-GJ G00.XX"},
        {20.954724,   70.334608,      4, 7,  "IN-GJ H00.XX"},
        {23.286524,   69.626117875,   4, 9,  "IN-GJ J00.XX"},
        {20.648924,   72.889208,      4, 11, "IN-GJ K00.XX"},
        {22.816724,   73.57493075,    4, 7,  "IN-GJ L00.XX"},
        {22.210724,   71.6231565,     4, 7,  "IN-GJ M00.XX"},
        {24.212724,   72.38347825,    4, 9,  "IN-GJ N00.XX"},
        {23.888824,   72.083091125,   4, 9,  "IN-GJ P00.XX"},
        {21.801024,   70.568469375,   4, 7,  "IN-GJ Q00.XX"},
        {22.002724,   70.746969375,   4, 7,  "IN-GJ R00.XX"},
        {21.671824,   72.966569375,   4, 9,  "IN-GJ S00.XX"},
        {21.615464,   71.185067125,   4, 7,  "IN-GJ T00.XX"},
        {24.250304,   72.15508425,    4, 9,  "IN-GJ TK0.00"},
        {21.745664,   70.415567125,   4, 7,  "IN-GJ V00.XX"},
        {22.831704,   74.22667375,    5, 10, "IN-GJ VK0.00"},
        {22.621664,   73.42820925,    4, 7,  "IN-GJ W00.XX"},
        {22.319404,   72.6000185,     4, 7,  "IN-GJ WK0.00"},
        {21.100664,   71.73065275,    4, 7,  "IN-GJ X00.XX"},
        {21.333004,   71.28106325,    4, 7,  "IN-GJ XK0.00"},
        {23.721364,   72.507351375,   4, 9,  "IN-GJ Y00.XX"},
        {22.986404,   71.43907375,    4, 9,  "IN-GJ YK0.00"},
        {23.124364,   69.991023625,   4, 9,  "IN-GJ Z00.XX"},
        {21.294504,   70.22396325,    4, 7,  "IN-GJ ZK0.00"},
        {23.788902,   68.274369,      3, 8,  "IN-GJ 12.XXXX"},
        {24.704595,   71.813485,      3, 8,  "IN-GJ 012.XXX"},
        {24.704595,   72.323869,      3, 8,  "IN-GJ 112.XXX"},
        {24.704595,   72.834252,      3, 8,  "IN-GJ 212.XXX"},
        {24.292515,   71.813485,      4, 9,  "IN-GJ 312.XXX"},
        {24.292515,   72.323869,      4, 9,  "IN-GJ 412.XXX"},
        {24.292515,   72.834252,      4, 9,  "IN-GJ 512.XXX"},
        {23.801475,   71.8184055,     3, 8,  "IN-GJ 612.XXX"},
        {23.801475,   72.3235815,     3, 8,  "IN-GJ 712.XXX"},
        {23.801475,   72.8287575,     3, 8,  "IN-GJ 812.XXX"},
        {23.801475,   73.3339335,     3, 8,  "IN-GJ 912.XXX"},
        {23.801475,   73.8391095,     3, 8,  "IN-GJ B12.XXX"},
        {23.310435,   71.8184055,     3, 8,  "IN-GJ C12.XXX"},
        {23.310435,   72.3235815,     3, 8,  "IN-GJ D12.XXX"},
        {23.310435,   72.8287575,     3, 8,  "IN-GJ F12.XXX"},
        {23.310435,   73.3339335,     3, 8,  "IN-GJ G12.XXX"},
        {23.310435,   73.8391095,     3, 8,  "IN-GJ H12.XXX"},
        {23.310435,   74.0526145,     4, 11, "IN-GJ J12.XXX"},
        {22.819395,   69.2925265,     4, 7,  "IN-GJ K12.XXX"},
        {22.819395,   69.7977025,     4, 7,  "IN-GJ L12.XXX"},
        {22.819395,   70.3028785,     4, 7,  "IN-GJ M12.XXX"},
        {22.819395,   70.8080545,     5, 8,  "IN-GJ N12.XXX"},
        {22.819395,   71.3132305,     4, 7,  "IN-GJ P12.XXX"},
        {22.819395,   71.8184065,     3, 6,  "IN-GJ Q12.XXX"},
        {22.819395,   72.3235825,     3, 6,  "IN-GJ R12.XXX"},
        {22.819395,   72.8287585,     3, 6,  "IN-GJ S12.XXX"},
        {22.819395,   73.3339345,     3, 6,  "IN-GJ T12.XXX"},
        {22.819395,   73.8391105,     3, 6,  "IN-GJ V12.XXX"},
        {22.819395,   74.0526145,     4, 9,  "IN-GJ W12.XXX"},
        {22.328355,   69.292239,      3, 6,  "IN-GJ X12.XXX"},
        {22.328355,   69.792207,      3, 6,  "IN-GJ Y12.XXX"},
        {22.328355,   70.292175,      3, 6,  "IN-GJ Z12.XXX"},
        {21.89682,    70.767375,      3, 6,  "IN-GJ 0123.XX"},
        {21.89682,    71.267343,      3, 6,  "IN-GJ 1123.XX"},
        {21.89682,    71.767311,      3, 6,  "IN-GJ 2123.XX"},
        {21.89682,    72.267279,      3, 6,  "IN-GJ 3123.XX"},
        {21.89682,    72.767247,      3, 8,  "IN-GJ 4123.XX"},
        {21.89682,    73.267215,      3, 8,  "IN-GJ 5123.XX"},
        {21.89682,    73.767183,      3, 8,  "IN-GJ 6123.XX"},
        {21.40578,    69.29247,       3, 6,  "IN-GJ 7123.XX"},
        {21.40578,    69.792438,      3, 6,  "IN-GJ 8123.XX"},
        {21.40578,    70.292406,      3, 6,  "IN-GJ 9123.XX"},
        {21.40578,    70.792374,      3, 6,  "IN-GJ B123.XX"},
        {21.40578,    71.292342,      3, 6,  "IN-GJ C123.XX"},
        {21.40578,    71.79231,       3, 6,  "IN-GJ D123.XX"},
        {21.40578,    72.292278,      3, 6,  "IN-GJ F123.XX"},
        {21.40578,    72.792246,      3, 8,  "IN-GJ G123.XX"},
        {21.40578,    73.292214,      3, 8,  "IN-GJ H123.XX"},
        {21.40578,    73.792182,      3, 8,  "IN-GJ J123.XX"},
        {20.912025,   69.702444,      3, 6,  "IN-GJ K123.XX"},
        {20.912025,   70.202412,      3, 6,  "IN-GJ L123.XX"},
        {20.912025,   70.70238,       3, 6,  "IN-GJ M123.XX"},
        {20.912025,   71.202348,      3, 6,  "IN-GJ N123.XX"},
        {20.912025,   71.702316,      3, 6,  "IN-GJ P123.XX"},
        {20.912025,   72.582259,      3, 8,  "IN-GJ Q123.XX"},
        {20.912025,   73.082227,      3, 8,  "IN-GJ R123.XX"},
        {20.912025,   73.582195,      3, 8,  "IN-GJ S123.XX"},
        {20.4237,     72.7874265,     3, 10, "IN-GJ T123.XX"},
        {20.4237,     73.2821865,     3, 8,  "IN-GJ V123.XX"},
        {20.4237,     73.7769465,     3, 8,  "IN-GJ W123.XX"},
        {20.30092,    72.7498525,     3, 8,  "IN-GJ Y123.XX"},
        {22.055999,   68.9314795,     3, 6,  "IN-GJ X123.XX"},
        {20.851183,   70.4057475,     3, 6,  "IN-GJ Z123.XX"},
        {22.6031,     88.3077435,     5, 8,  "IN-WB 12.XX"},
        {22.4770725,  88.1971835,     4, 7,  "IN-WB 12.XXX"},
        {23.522614,   87.248027875,   4, 9,  "IN-WB 000.XX"},
        {23.664714,   86.902589125,   4, 10, "IN-WB 200.XX"},
        {26.693914,   88.352531125,   4, 8,  "IN-WB 400.XX"},
        {23.233214,   87.807227875,   4, 9,  "IN-WB 600.XX"},
        {23.714314,   86.772989125,   4, 11, "IN-WB 800.XX"},
        {22.489545,   88.0130425,     4, 7,  "IN-WB B00.XX"},
        {23.370213,   86.321574875,   4, 10, "IN-WB C00.XX"},
        {25.050024,   88.0999525,     4, 11, "IN-WB D00.XX"},
        {22.380724,   87.2596565,     4, 11, "IN-WB F00.XX"},
        {22.466224,   87.2781565,     4, 11, "IN-WB G00.XX"},
        {24.140724,   88.204991125,   4, 7,  "IN-WB H00.XX"},
        {25.660724,   88.07502675,    4, 10, "IN-WB J00.XX"},
        {23.450724,   88.456417875,   4, 7,  "IN-WB K00.XX"},
        {25.270724,   88.72502675,    4, 9,  "IN-WB L00.XX"},
        {22.882324,   88.59543075,    4, 7,  "IN-WB M00.XX"},
        {23.276724,   87.021817875,   4, 9,  "IN-WB N00.XX"},
        {23.744224,   87.035191125,   5, 11, "IN-WB P00.XX"},
        {23.659424,   87.070917875,   4, 10, "IN-WB Q00.XX"},
        {22.696124,   88.81783075,    4, 7,  "IN-WB R00.XX"},
        {23.449624,   88.325017875,   4, 7,  "IN-WB S00.XX"},
        {27.076024,   88.214661375,   4, 13, "IN-WB T00.XX"},
        {23.730324,   88.255591125,   4, 7,  "IN-WB V00.XX"},
        {23.081824,   88.78633075,    4, 9,  "IN-WB W00.XX"},
        {26.568924,   88.660587125,   4, 9,  "IN-WB X00.XX"},
        {22.070845,   88.034741875,   4, 7,  "IN-WB Y00.XX"},
        {23.254445,   88.337276375,   4, 7,  "IN-WB Z00.XX"},
        {27.193739,   87.87369,       3, 11, "IN-WB 012.XXX"},
        {27.193739,   88.39449,       3, 11, "IN-WB 112.XXX"},
        {27.193739,   88.91529,       3, 13, "IN-WB 212.XXX"},
        {27.193739,   89.40785,       3, 10, "IN-WB 312.XXX"},
        {26.702699,   87.873689,      3, 11, "IN-WB 412.XXX"},
        {26.702699,   88.394489,      4, 8,  "IN-WB 512.XXX"},
        {26.702699,   88.915289,      3, 10, "IN-WB 612.XXX"},
        {26.702699,   89.40785,       3, 10, "IN-WB 712.XXX"},
        {26.211659,   87.7744505,     3, 9,  "IN-WB 812.XXX"},
        {26.211659,   88.2900425,     3, 11, "IN-WB 912.XXX"},
        {26.211659,   88.8056345,     3, 9,  "IN-WB B12.XXX"},
        {26.211659,   89.3212265,     3, 8,  "IN-WB C12.XXX"},
        {25.720619,   87.7486715,     3, 10, "IN-WB D12.XXX"},
        {25.720619,   88.2642635,     3, 9,  "IN-WB F12.XXX"},
        {25.524203,   88.7798555,     3, 8,  "IN-WB G12.XXX"},
        {25.229579,   87.7486715,     3, 12, "IN-WB H12.XXX"},
        {25.229579,   88.2642635,     3, 11, "IN-WB J12.XXX"},
        {24.738539,   87.748385,      3, 11, "IN-WB K12.XXX"},
        {24.738539,   88.258769,      3, 10, "IN-WB L12.XXX"},
        {24.247499,   86.753136,      3, 9,  "IN-WB M12.XXX"},
        {24.247499,   87.26352,       3, 10, "IN-WB N12.XXX"},
        {24.247499,   87.773904,      3, 9,  "IN-WB P12.XXX"},
        {24.247499,   88.284288,      3, 6,  "IN-WB Q12.XXX"},
        {23.756459,   85.8393665,     3, 9,  "IN-WB R12.XXX"},
        {23.756459,   86.3445425,     3, 10, "IN-WB S12.XXX"},
        {23.756459,   86.8497185,     4, 11, "IN-WB T12.XXX"},
        {23.756459,   87.3548945,     3, 8,  "IN-WB V12.XXX"},
        {23.756459,   87.8600705,     3, 8,  "IN-WB W12.XXX"},
        {23.756459,   88.3652465,     3, 6,  "IN-WB X12.XXX"},
        {23.265419,   85.8393665,     3, 9,  "IN-WB Y12.XXX"},
        {23.265419,   86.3445425,     3, 9,  "IN-WB Z12.XXX"},
        {22.853579,   86.8497185,     3, 9,  "IN-WB 01.XXXX"},
        {22.853579,   87.3548945,     3, 8,  "IN-WB 11.XXXX"},
        {22.853579,   87.8600705,     3, 8,  "IN-WB 21.XXXX"},
        {22.853579,   88.3652465,     4, 7,  "IN-WB 31.XXXX"},
        {22.853579,   88.8704225,     3, 8,  "IN-WB 41.XXXX"},
        {22.362539,   86.3445425,     3, 11, "IN-WB 51.XXXX"},
        {22.362539,   86.8497185,     3, 11, "IN-WB 61.XXXX"},
        {22.362539,   87.3548945,     3, 10, "IN-WB 71.XXXX"},
        {22.362539,   87.8600705,     3, 8,  "IN-WB 81.XXXX"},
        {22.362539,   88.3652465,     4, 7,  "IN-WB 91.XXXX"},
        {22.362539,   88.8704225,     3, 6,  "IN-WB B1.XXXX"},
        {21.871499,   86.697879,      3, 9,  "IN-WB C1.XXXX"},
        {21.871499,   87.197847,      4, 10, "IN-WB D1.XXXX"},
        {21.871499,   87.697815,      4, 7,  "IN-WB F1.XXXX"},
        {21.871499,   88.197783,      4, 7,  "IN-WB G1.XXXX"},
        {21.871499,   88.697751,      4, 7,  "IN-WB H1.XXXX"},
        {21.463795,   87.197847,      3, 9,  "IN-WB J1.XXXX"},
        {21.463795,   87.697815,      3, 6,  "IN-WB K1.XXXX"},
        {21.463795,   88.197783,      3, 6,  "IN-WB L1.XXXX"},
        {21.463795,   88.697751,      3, 6,  "IN-WB M1.XXXX"},
        {22.7551,     75.8201435,     5, 8,  "IN-MP 12.XX"},
        {22.810604,   75.71572175,    4, 7,  "IN-MP 00.XXX"},
        {23.263004,   77.281884375,   4, 9,  "IN-MP 80.XXX"},
        {23.236104,   79.79522175,    4, 7,  "IN-MP J0.XXX"},
        {26.175584,   78.066565375,   4, 11, "IN-MP S0.XXX"},
        {23.218145,   75.752076375,   4, 10, "IN-MP 000.XX"},
        {22.999924,   76.00223075,    4, 9,  "IN-MP 100.XX"},
        {24.612124,   80.78547825,    4, 9,  "IN-MP 200.XX"},
        {24.612124,   80.88017825,    4, 9,  "IN-MP 300.XX"},
        {23.873424,   78.719791125,   4, 9,  "IN-MP 400.XX"},
        {23.390724,   74.985817875,   4, 10, "IN-MP 500.XX"},
        {23.869124,   80.345591125,   4, 11, "IN-MP 600.XX"},
        {21.355024,   76.17408225,    4, 9,  "IN-MP 700.XX"},
        {21.870724,   76.306269375,   4, 9,  "IN-MP 800.XX"},
        {26.550724,   77.944687125,   4, 13, "IN-MP 900.XX"},
        {26.607424,   78.734487125,   4, 10, "IN-MP B00.XX"},
        {24.688424,   77.27337825,    4, 11, "IN-MP C00.XX"},
        {25.468624,   77.60612675,    4, 11, "IN-MP D00.XX"},
        {23.558524,   77.766017875,   4, 9,  "IN-MP F00.XX"},
        {24.112724,   75.014091125,   4, 10, "IN-MP G00.XX"},
        {22.097624,   78.907269375,   4, 9,  "IN-MP H00.XX"},
        {24.948924,   79.5438525,     4, 9,  "IN-MP J00.XX"},
        {24.508624,   74.82017825,    4, 10, "IN-MP K00.XX"},
        {22.651924,   75.63963075,    4, 7,  "IN-MP L00.XX"},
        {23.875724,   79.397591125,   4, 9,  "IN-MP M00.XX"},
        {22.787624,   77.68523075,    4, 7,  "IN-MP N00.XX"},
        {23.248924,   77.041517875,   4, 10, "IN-MP P00.XX"},
        {21.864424,   75.572069375,   4, 9,  "IN-MP Q00.XX"},
        {21.948924,   77.856369375,   4, 9,  "IN-MP R00.XX"},
        {22.103664,   79.5153805,     4, 9,  "IN-MP S00.XX"},
        {22.593204,   75.28307375,    4, 7,  "IN-MP SK0.00"},
        {21.823564,   80.155067125,   4, 9,  "IN-MP T00.XX"},
        {22.665604,   74.93407375,    4, 7,  "IN-MP TK0.00"},
        {25.678264,   78.42502225,    4, 10, "IN-MP V00.XX"},
        {23.458204,   75.385601875,   4, 10, "IN-MP VK0.00"},
        {22.130464,   78.1343805,     4, 7,  "IN-MP W00.XX"},
        {22.606204,   77.73247375,    4, 7,  "IN-MP WK0.00"},
        {22.562564,   75.7228805,     4, 7,  "IN-MP X00.XX"},
        {23.298604,   81.333301875,   4, 10, "IN-MP XK0.00"},
        {23.649264,   75.092051375,   4, 10, "IN-MP Y00.XX"},
        {23.411404,   76.251301875,   4, 10, "IN-MP YK0.00"},
        {24.765364,   78.7969935,     4, 9,  "IN-MP Z00.XX"},
        {22.033204,   74.876991375,   4, 9,  "IN-MP ZK0.00"},
        {23.3126705,  78.387453,      3, 6,  "IN-MP 12.XXXX"},
        {23.211676,   74.955345,      3, 9,  "IN-MP 123.XXX"},
        {26.138624,   77.8349085,     3, 10, "IN-MP 0123.XX"},
        {24.340024,   80.624926,      3, 8,  "IN-MP 1123.XX"},
        {24.389128,   81.13531,       3, 8,  "IN-MP 2123.XX"},
        {24.438232,   81.645693,      3, 8,  "IN-MP 3123.XX"},
        {21.098624,   75.972747,      3, 8,  "IN-MP 4123.XX"},
        {26.332564,   78.522245,      3, 8,  "IN-MP 5123.XX"},
        {24.41628,    76.044633,      3, 9,  "IN-MP 6123.XX"},
        {24.41628,    76.555017,      3, 9,  "IN-MP 7123.XX"},
        {24.41628,    77.065401,      3, 11, "IN-MP 8123.XX"},
        {24.41628,    77.575785,      3, 10, "IN-MP 9123.XX"},
        {24.41628,    78.086169,      3, 10, "IN-MP B123.XX"},
        {24.41628,    78.596553,      3, 8,  "IN-MP C123.XX"},
        {25.196479,   77.4013385,     3, 10, "IN-MP D123.XX"},
        {24.035019,   74.712196,      3, 9,  "IN-MP F123.XX"},
        {24.674064,   79.3388285,     3, 8,  "IN-MP G123.XX"},
        {25.434379,   78.2094385,     3, 10, "IN-MP H123.XX"},
        {24.947196,   75.5972385,     3, 9,  "IN-MP J123.XX"},
        {23.762065,   77.620239,      3, 8,  "IN-MP K123.XX"},
        {17.4179,     78.446526,      4, 15, "IN-TG 12.XX"},
        {17.618515,   78.236555,      3, 14, "IN-TG 12.XXX"},
        {16.560724,   80.569625875,   4, 15, "IN-TG 300.XX"},
        {16.534777,   80.656113875,   5, 17, "IN-TG 400.XX"},
        {16.342124,   80.397625875,   4, 15, "IN-TG 500.XX"},
        {18.018724,   79.56938625,    5, 15, "IN-TG 600.XX"},
        {18.046724,   79.50328625,    4, 13, "IN-TG 700.XX"},
        {15.862124,   77.99403875,    4, 17, "IN-TG 900.XX"},
        {18.720724,   78.057173375,   4, 14, "IN-TG G00.XX"},
        {18.482124,   79.087173375,   4, 13, "IN-TG K00.XX"},
        {18.764464,   79.461254125,   4, 13, "IN-TG L00.XX"},
        {16.728764,   81.059697625,   4, 13, "IN-TG M00.XX"},
        {17.2439995,  80.1436995,     4, 13, "IN-TG NRG.TC"},
        {16.196264,   81.10138325,    4, 13, "IN-TG P00.XX"},
        {16.252464,   80.59848325,    4, 15, "IN-TG Q00.XX"},
        {16.758464,   77.971797625,   4, 17, "IN-TG R00.XX"},
        {17.0569995,  79.2724995,     4, 13, "IN-TG TRG.TC"},
        {16.4349995,  80.9955,        4, 13, "IN-TG WRG.TC"},
        {19.684364,   78.49239625,    4, 13, "IN-TG X00.XX"},
        {16.228104,   80.02283175,    4, 15, "IN-TG XK0.00"},
        {17.1409995,  79.6207995,     4, 13, "IN-TG YRG.TC"},
        {16.0959995,  80.1678995,     4, 15, "IN-TG ZRG.TC"},
        {15.9385,     77.928,         3, 15, "IN-TG HD.0X0R"},
        {16.8707485,  79.211641,      3, 11, "IN-TG 123.XXX"},
        {17.757909,   79.336948,      3, 11, "IN-TG 2123.XX"},
        {18.448624,   77.857898,      3, 12, "IN-TG 4123.XX"},
        {18.359204,   79.063388,      3, 11, "IN-TG 6123.XX"},
        {16.514579,   77.7696815,     3, 15, "IN-TG 8123.XX"},
        {19.440479,   78.2857405,     3, 11, "IN-TG B123.XX"},
        {17.4179,     78.446526,      4, 15, "IN-AP 12.XX"},
        {17.618515,   78.236555,      3, 14, "IN-AP 12.XXX"},
        {17.770724,   83.268299125,   4, 9,  "IN-AP 000.XX"},
        {17.766399,   83.177726125,   4, 9,  "IN-AP 100.XX"},
        {17.721724,   83.148399125,   4, 7,  "IN-AP 200.XX"},
        {16.560724,   80.569625875,   4, 15, "IN-AP 300.XX"},
        {16.534777,   80.656113875,   5, 17, "IN-AP 400.XX"},
        {16.342124,   80.397625875,   4, 15, "IN-AP 500.XX"},
        {18.018724,   79.56938625,    5, 15, "IN-AP 600.XX"},
        {18.046724,   79.50328625,    4, 13, "IN-AP 700.XX"},
        {14.474824,   79.938077375,   4, 9,  "IN-AP 800.XX"},
        {15.862124,   77.99403875,    4, 17, "IN-AP 900.XX"},
        {17.052124,   81.756512,      4, 7,  "IN-AP B00.XX"},
        {14.512724,   78.783077375,   4, 9,  "IN-AP C00.XX"},
        {17.051624,   82.198512,      4, 7,  "IN-AP D00.XX"},
        {16.965135,   82.198512,      4, 7,  "IN-AP F00.XX"},
        {18.720724,   78.057173375,   4, 14, "IN-AP G00.XX"},
        {13.670724,   79.39489025,    4, 9,  "IN-AP H00.XX"},
        {14.714824,   77.562377375,   4, 11, "IN-AP J00.XX"},
        {18.482124,   79.087173375,   4, 13, "IN-AP K00.XX"},
        {18.764464,   79.461254125,   4, 13, "IN-AP L00.XX"},
        {18.114104,   83.37264225,    4, 12, "IN-AP LK0.00"},
        {16.728764,   81.059697625,   4, 13, "IN-AP M00.XX"},
        {15.503404,   80.003704625,   4, 11, "IN-AP MK0.00"},
        {15.488364,   78.448368875,   4, 13, "IN-AP N00.XX"},
        {17.238104,   80.116487,      4, 13, "IN-AP NK0.00"},
        {16.196264,   81.10138325,    4, 13, "IN-AP P00.XX"},
        {15.622104,   77.247704625,   4, 14, "IN-AP PK0.00"},
        {16.252464,   80.59848325,    4, 15, "IN-AP Q00.XX"},
        {14.750104,   78.5230765,     4, 11, "IN-AP QK0.00"},
        {16.758464,   77.971797625,   4, 17, "IN-AP R00.XX"},
        {13.214104,   79.07322125,    4, 11, "IN-AP RK0.00"},
        {13.845464,   77.46622675,    4, 12, "IN-AP S00.XX"},
        {16.534804,   81.495159875,   4, 9,  "IN-AP SK0.00"},
        {13.569364,   78.47722675,    4, 12, "IN-AP T00.XX"},
        {17.051104,   79.245287,      4, 13, "IN-AP TK0.00"},
        {15.177464,   77.3391545,     4, 12, "IN-AP V00.XX"},
        {18.294004,   83.86534225,    4, 12, "IN-AP VK0.00"},
        {14.429464,   77.687741125,   4, 11, "IN-AP W00.XX"},
        {16.429104,   80.968359875,   4, 15, "IN-AP WK0.00"},
        {19.684364,   78.49239625,    4, 13, "IN-AP X00.XX"},
        {16.228104,   80.02283175,    4, 15, "IN-AP XK0.00"},
        {14.934064,   77.9636545,     4, 11, "IN-AP Y00.XX"},
        {17.135104,   79.593587,      4, 13, "IN-AP YK0.00"},
        {16.826464,   81.494111,      4, 7,  "IN-AP Z00.XX"},
        {16.090104,   80.14083175,    4, 15, "IN-AP ZK0.00"},
        {13.255676,   76.823892,      3, 13, "IN-AP 12.XXXX"},
        {16.8707485,  79.211641,      3, 11, "IN-AP 123.XXX"},
        {17.471409,   83.008848,      3, 6,  "IN-AP 1123.XX"},
        {17.757909,   79.336948,      3, 11, "IN-AP 2123.XX"},
        {14.202724,   79.743049,      3, 8,  "IN-AP 3123.XX"},
        {18.448624,   77.857898,      3, 12, "IN-AP 4123.XX"},
        {13.200212,   79.038179,      3, 10, "IN-AP 5123.XX"},
        {18.359204,   79.063388,      3, 11, "IN-AP 6123.XX"},
        {17.888579,   83.157898,      4, 12, "IN-AP 7123.XX"},
        {16.514579,   77.7696815,     3, 15, "IN-AP 8123.XX"},
        {18.068479,   83.650598,      3, 11, "IN-AP 9123.XX"},
        {19.440479,   78.2857405,     3, 11, "IN-AP B123.XX"},
        {18.904029,   72.792768,      5, 8,  "IN-MH 12.XX"},
        {18.911695,   72.7871945,     4, 7,  "IN-MH 12.XXX"},
        {18.605321,   73.788073375,   5, 8,  "IN-MH 000.XX"},
        {18.605321,   73.879126375,   4, 7,  "IN-MH 100.XX"},
        {18.518832,   73.879126375,   4, 7,  "IN-MH 200.XX"},
        {18.518832,   73.788073375,   4, 7,  "IN-MH 300.XX"},
        {21.22765,    78.99058225,    4, 9,  "IN-MH 400.XX"},
        {21.240624,   79.08331725,    4, 9,  "IN-MH 500.XX"},
        {21.141161,   78.99058225,    4, 9,  "IN-MH 600.XX"},
        {21.154135,   79.08331725,    4, 9,  "IN-MH 700.XX"},
        {20.059373,   73.690714875,   4, 9,  "IN-MH 800.XX"},
        {20.059373,   73.782728875,   4, 9,  "IN-MH 900.XX"},
        {19.972884,   73.78284175,    4, 7,  "IN-MH B00.XX"},
        {19.972884,   73.69106775,    4, 7,  "IN-MH C00.XX"},
        {18.668924,   73.757273375,   4, 7,  "IN-MH D00.XX"},
        {19.921724,   75.30383475,    4, 7,  "IN-MH F00.XX"},
        {17.702624,   75.872899125,   4, 10, "IN-MH G00.XX"},
        {20.973024,   77.716708,      4, 7,  "IN-MH H00.XX"},
        {19.208324,   73.2113185,     5, 8,  "IN-MH J00.XX"},
        {19.209124,   77.2719605,     4, 11, "IN-MH K00.XX"},
        {16.732224,   74.185125875,   4, 9,  "IN-MH L00.XX"},
        {16.904224,   74.536312,      4, 9,  "IN-MH M00.XX"},
        {20.597624,   74.486508,      4, 9,  "IN-MH N00.XX"},
        {21.041724,   75.516608,      4, 9,  "IN-MH P00.XX"},
        {20.745724,   76.959908,      4, 7,  "IN-MH Q00.XX"},
        {18.447724,   76.530873375,   4, 7,  "IN-MH R00.XX"},
        {20.945024,   74.726608,      4, 7,  "IN-MH S00.XX"},
        {19.144924,   74.6970605,     4, 7,  "IN-MH T00.XX"},
        {19.972464,   79.270410625,   4, 7,  "IN-MH V00.XX"},
        {19.258104,   76.7483975,     4, 11, "IN-MH VK0.00"},
        {16.714864,   74.424597625,   4, 9,  "IN-MH W00.XX"},
        {19.838104,   75.85875275,    4, 7,  "IN-MH WK0.00"},
        {21.049464,   75.74965275,    4, 9,  "IN-MH X00.XX"},
        {18.985304,   75.7278975,     4, 7,  "IN-MH XK0.00"},
        {21.480664,   80.16285275,    4, 9,  "IN-MH Y00.XX"},
        {17.679704,   73.979515125,   4, 7,  "IN-MH YK0.00"},
        {18.249464,   75.65813975,    4, 10, "IN-MH Z00.XX"},
        {20.384104,   78.097280875,   4, 7,  "IN-MH ZK0.00"},
        {19.98693,    75.624782,      3, 6,  "IN-MH 12.XXXX"},
        {20.1789835,  72.7560125,     3, 9,  "IN-MH 123.XXX"},
        {20.904021,   78.849527,      4, 7,  "IN-MH 0123.XX"},
        {20.904021,   79.349495,      3, 6,  "IN-MH 1123.XX"},
        {20.833965,   77.388152,      4, 7,  "IN-MH 2123.XX"},
        {16.543579,   74.1645825,     3, 8,  "IN-MH 3123.XX"},
        {20.496365,   74.402652,      3, 8,  "IN-MH 4123.XX"},
        {20.785265,   75.424752,      3, 6,  "IN-MH 5123.XX"},
        {20.470765,   76.130992,      3, 6,  "IN-MH 6123.XX"},
        {20.470765,   76.63096,       3, 6,  "IN-MH 7123.XX"},
        {20.470765,   77.130928,      3, 6,  "IN-MH 8123.XX"},
        {19.85124,    78.8659275,     3, 10, "IN-MH 9123.XX"},
        {19.85124,    79.3606875,     3, 10, "IN-MH B123.XX"},
        {21.163124,   79.948752,      3, 8,  "IN-MH C123.XX"},
        {20.15848,    77.8855315,     4, 7,  "IN-MH D123.XX"},
        {21.14148,    73.995652,      3, 9,  "IN-MH F123.XX"},
        {20.511765,   78.358652,      4, 7,  "IN-MH G123.XX"},
        {26.8821,     80.8919,        5, 9,  "IN-UP 12.XX"},
        {28.666985,   77.277229625,   4, 15, "IN-UP 00.XXX"},
        {26.942084,   80.782673375,   4, 8,  "IN-UP C0.XXX"},
        {26.565584,   80.227573375,   4, 9,  "IN-UP P0.XXX"},
        {27.265924,   77.907061375,   4, 9,  "IN-UP 000.XX"},
        {27.265924,   78.003880375,   4, 9,  "IN-UP 100.XX"},
        {27.179435,   78.003880375,   4, 9,  "IN-UP 200.XX"},
        {27.179435,   77.907061375,   4, 9,  "IN-UP 300.XX"},
        {29.032724,   77.664557375,   4, 11, "IN-UP 400.XX"},
        {28.946235,   77.664557375,   4, 11, "IN-UP 500.XX"},
        {25.378024,   82.95542675,    5, 8,  "IN-UP 600.XX"},
        {25.291535,   82.93630275,    5, 10, "IN-UP 700.XX"},
        {25.482124,   81.72812675,    4, 9,  "IN-UP 800.XX"},
        {25.451852,   81.82374475,    4, 9,  "IN-UP 900.XX"},
        {25.538341,   81.82374475,    4, 9,  "IN-UP B00.XX"},
        {28.404724,   79.377983125,   4, 10, "IN-UP C00.XX"},
        {28.880724,   78.723583125,   4, 13, "IN-UP D00.XX"},
        {27.933824,   78.024309875,   4, 9,  "IN-UP F00.XX"},
        {30.002124,   77.493105875,   4, 12, "IN-UP G00.XX"},
        {26.800224,   83.336087125,   4, 10, "IN-UP H00.XX"},
        {27.199424,   78.351661375,   4, 7,  "IN-UP J00.XX"},
        {25.490724,   78.52182675,    4, 10, "IN-UP K00.XX"},
        {29.507724,   77.678031625,   4, 12, "IN-UP L00.XX"},
        {27.540724,   77.634235625,   4, 9,  "IN-UP M00.XX"},
        {27.920724,   79.878409875,   4, 10, "IN-UP N00.XX"},
        {28.804564,   78.984877375,   4, 13, "IN-UP P00.XX"},
        {25.939104,   83.531122875,   4, 9,  "IN-UP PK0.00"},
        {27.389045,   79.560753125,   4, 8,  "IN-UP Q00.XX"},
        {28.724104,   77.740399125,   4, 11, "IN-UP QK0.00"},
        {26.792464,   78.989293125,   4, 11, "IN-UP R00.XX"},
        {25.130104,   82.5379395,     4, 9,  "IN-UP RK0.00"},
        {28.422464,   77.814877375,   4, 9,  "IN-UP S00.XX"},
        {28.564804,   78.539699125,   4, 10, "IN-UP SK0.00"},
        {28.910064,   78.438906125,   4, 12, "IN-UP T00.XX"},
        {25.921704,   80.785122875,   4, 9,  "IN-UP TK0.00"},
        {26.242464,   81.209536625,   4, 9,  "IN-UP V00.XX"},
        {25.984104,   79.421122875,   4, 9,  "IN-UP VK0.00"},
        {27.592464,   81.555220875,   4, 8,  "IN-UP W00.XX"},
        {27.564104,   80.650588625,   4, 8,  "IN-UP WK0.00"},
        {25.760064,   82.655736625,   4, 9,  "IN-UP X00.XX"},
        {26.768104,   82.117533375,   4, 10, "IN-UP XK0.00"},
        {28.043164,   79.085049625,   4, 10, "IN-UP Y00.XX"},
        {25.476104,   80.31449475,    4, 9,  "IN-UP YK0.00"},
        {27.960464,   80.745049625,   4, 12, "IN-UP Z00.XX"},
        {27.592104,   78.022688625,   4, 9,  "IN-UP ZK0.00"},
        {27.524035,   80.3534425,     3, 7,  "IN-UP 12.XXXX"},
        {29.0566835,  77.3034105,     3, 11, "IN-UP 123.XXX"},
        {29.730465,   77.2798275,     3, 11, "IN-UP 0123.XX"},
        {26.525865,   83.11435,       4, 7,  "IN-UP 1123.XX"},
        {25.21858,    78.3102295,     3, 10, "IN-UP 2123.XX"},
        {29.113504,   77.091795,      3, 11, "IN-UP 3123.XX"},
        {29.113504,   77.623011,      4, 11, "IN-UP 4123.XX"},
        {25.77388,    83.1236295,     3, 6,  "IN-UP 5123.XX"},
        {25.75858,    79.2001295,     3, 8,  "IN-UP 6123.XX"},
        {25.26754,    79.2001295,     3, 8,  "IN-UP 7123.XX"},
        {27.78261,    80.6564805,     3, 11, "IN-UP 8123.XX"},
        {27.78261,    81.1824875,     3, 11, "IN-UP 9123.XX"},
        {24.47028,    78.157701,      3, 11, "IN-UP B123.XX"},
        {25.046865,   82.8692295,     3, 8,  "IN-UP C123.XX"},
        {11.961202,   79.7629025,     4, 11, "IN-PY 12.XX"},
        {11.766025,   79.595025,      3, 9,  "IN-PY 0L.S15"},
        {10.822025,   79.727025,      3, 9,  "IN-PY FC.S0W"},
        {16.704025,   82.183025,      3, 9,  "IN-PY K4.S0Z"},
        {11.673025,   75.522025,      3, 11, "IN-PY M2.S11"},
        {11.703525,   75.522025,      4, 12, "IN-PY N1.S17"},
        {-33.8349,    151.164532,     5, 7,  "AU-NSW 12.XX"},
        {-33.674785,  150.77691,      4, 6,  "AU-NSW 12.XXX"},
        {-32.879276,  151.604349375,  4, 6,  "AU-NSW 000.XX"},
        {-32.879276,  151.706934375,  4, 6,  "AU-NSW 100.XX"},
        {-32.965765,  151.635124375,  4, 6,  "AU-NSW 200.XX"},
        {-34.413876,  150.820845375,  4, 8,  "AU-NSW 300.XX"},
        {-34.312455,  150.862271875,  4, 8,  "AU-NSW 400.XX"},
        {-34.535435,  150.757771875,  4, 8,  "AU-NSW 500.XX"},
        {-36.042655,  146.877661875,  3, 7,  "AU-NSW 600.XX"},
        {-36.108455,  146.820276875,  3, 8,  "AU-NSW 700.XX"},
        {-34.837666,  150.552279125,  4, 8,  "AU-NSW 800.XX"},
        {-30.247876,  153.065305875,  4, 6,  "AU-NSW 900.XX"},
        {-31.407276,  152.8469405,    4, 6,  "AU-NSW B00.XX"},
        {-33.366876,  149.525823625,  4, 6,  "AU-NSW C00.XX"},
        {-35.094076,  147.310919625,  3, 7,  "AU-NSW D00.XX"},
        {-28.770576,  153.256383125,  4, 8,  "AU-NSW F00.XX"},
        {-31.861576,  152.43241475,   4, 6,  "AU-NSW G00.XX"},
        {-32.212576,  148.568688,     3, 5,  "AU-NSW H00.XX"},
        {-31.054276,  150.8709405,    4, 6,  "AU-NSW J00.XX"},
        {-30.474276,  151.614479125,  4, 6,  "AU-NSW K00.XX"},
        {-33.728276,  150.654984,     4, 6,  "AU-NSW L00.XX"},
        {-34.709276,  149.660619625,  4, 8,  "AU-NSW M00.XX"},
        {-31.921076,  141.41501475,   3, 5,  "AU-NSW N00.XX"},
        {-33.700455,  150.286176,     4, 6,  "AU-NSW P00.XX"},
        {-32.803976,  151.311349375,  4, 6,  "AU-NSW Q00.XX"},
        {-32.144976,  152.472588,     4, 6,  "AU-NSW R00.XX"},
        {-29.665476,  152.859631625,  4, 6,  "AU-NSW S00.XX"},
        {-28.793376,  153.514683125,  4, 8,  "AU-NSW T00.XX"},
        {-34.243676,  145.995045375,  3, 7,  "AU-NSW V00.XX"},
        {-30.339236,  153.044162625,  4, 6,  "AU-NSW W00.XX"},
        {-32.823145,  151.427184125,  4, 6,  "AU-NSW WK0.00"},
        {-32.543436,  151.130032125,  4, 6,  "AU-NSW X00.XX"},
        {-32.275896,  150.859313,     4, 6,  "AU-NSW XK0.00"},
        {-32.754036,  151.708432125,  4, 6,  "AU-NSW Y00.XX"},
        {-34.667296,  150.806172625,  4, 8,  "AU-NSW YK0.00"},
        {-33.472636,  150.114659875,  4, 6,  "AU-NSW Z00.XX"},
        {-28.866196,  153.015899125,  4, 8,  "AU-NSW ZK0.00"},
        {-32.5747005, 149.2777375,    3, 5,  "AU-NSW 123.XXX"},
        {-30.3020415, 150.2876085,    3, 5,  "AU-NSW 12.XXXX"},
        {-28.347511,  149.3997185,    3, 7,  "AU-NSW 1234.XX"},
        {-32.1349195, 141.6599605,    2, 4,  "AU-NSW 1234.XXX"},
        {-35.2723,    149.08899,      3, 9,  "AU-ACT 12.XX"},
        {-35.2553955, 148.779193,     2, 8,  "AU-ACT 12.XXX"},
        {-35.82328,   148.7527645,    2, 8,  "AU-ACT 123.XX"},
        {-35.1233,    150.6765915,    3, 10, "AU-JBT 12.XX"},
        {-35.1143935, 150.6001055,    2, 9,  "AU-JBT 12.XXX"},
        {-12.378055,  130.84133,      5, 7,  "AU-NT 00.XX"},
        {-12.432475,  130.819,        5, 7,  "AU-NT J0.XX"},
        {-12.358185,  130.76489,      4, 6,  "AU-NT 12.XXX"},
        {-23.581706,  133.631173875,  4, 6,  "AU-NT 000.XX"},
        {-14.360696,  132.066585375,  4, 6,  "AU-NT J00.XX"},
        {-11.1347005, 130.579254,     3, 5,  "AU-NT 123.XXX"},
        {-13.972931,  131.060503,     3, 5,  "AU-NT 12.XXXX"},
        {-22.54611,   132.5450345,    3, 5,  "AU-NT 1234.XX"},
        {-14.9516115, 129.3468,       2, 4,  "AU-NT 1234.XXX"},
        {-34.8901,    138.5578915,    5, 7,  "AU-SA 12.XX"},
        {-34.729085,  138.4910965,    4, 6,  "AU-SA 12.XXX"},
        {-33.006796,  137.423367375,  4, 6,  "AU-SA 000.XX"},
        {-37.803196,  140.6672635,    4, 6,  "AU-SA 400.XX"},
        {-34.592896,  138.629346375,  4, 6,  "AU-SA 800.XX"},
        {-32.482496,  137.701787,     4, 6,  "AU-SA D00.XX"},
        {-33.162796,  137.930286625,  4, 6,  "AU-SA J00.XX"},
        {-35.499955,  138.574025,     4, 6,  "AU-SA N00.XX"},
        {-34.679096,  135.731046375,  4, 6,  "AU-SA S00.XX"},
        {-35.113706,  139.188758625,  4, 6,  "AU-SA X00.XX"},
        {-35.3227395, 138.2815815,    3, 5,  "AU-SA 12.XXXX"},
        {-35.021323,  137.2525835,    3, 5,  "AU-SA 123.XXX"},
        {-32.572851,  134.19704,      3, 5,  "AU-SA 1234.XX"},
        {-26.8550845, 129.4334455,    2, 4,  "AU-SA 1234.XXX"},
        {-42.83121,   147.243905,     5, 7,  "AU-TAS 00.XX"},
        {-42.890045,  147.276689,     5, 7,  "AU-TAS J0.XX"},
        {-42.755885,  147.046865,     4, 6,  "AU-TAS 12.XXX"},
        {-41.419626,  146.9634335,    5, 7,  "AU-TAS 000.XX"},
        {-41.008676,  145.6692985,    5, 7,  "AU-TAS C00.XX"},
        {-41.103455,  146.0302975,    6, 8,  "AU-TAS P00.XX"},
        {-41.0524345, 144.954768,     4, 6,  "AU-TAS 123.XXX"},
        {-40.1510595, 144.7618245,    3, 5,  "AU-TAS 12.XXXX"},
        {-39.38671,   141.2793835,    3, 5,  "AU-TAS 1234.XX"},
        {-39.6029935, 141.32508,      3, 5,  "AU-TAS 1234.XXX"},
        {-37.7749,    144.9144075,    5, 7,  "AU-VIC 12.XX"},
        {-37.611185,  144.7426265,    5, 7,  "AU-VIC 12.XXX"},
        {-38.131376,  144.299285875,  4, 6,  "AU-VIC 000.XX"},
        {-38.044887,  144.299285875,  4, 6,  "AU-VIC 100.XX"},
        {-37.519276,  143.7889245,    4, 6,  "AU-VIC 200.XX"},
        {-36.719276,  144.229263125,  4, 8,  "AU-VIC 300.XX"},
        {-38.205176,  144.994685875,  4, 6,  "AU-VIC 400.XX"},
        {-38.134676,  145.072885875,  4, 6,  "AU-VIC 500.XX"},
        {-34.149276,  142.110845375,  4, 8,  "AU-VIC 600.XX"},
        {-36.343176,  145.33590275,   4, 8,  "AU-VIC 700.XX"},
        {-37.649276,  144.5189245,    4, 6,  "AU-VIC 800.XX"},
        {-38.320276,  142.433933375,  4, 6,  "AU-VIC 900.XX"},
        {-38.058576,  145.218285875,  4, 6,  "AU-VIC B00.XX"},
        {-37.528176,  144.6873245,    4, 6,  "AU-VIC C00.XX"},
        {-38.177455,  146.475628375,  4, 6,  "AU-VIC D00.XX"},
        {-36.319276,  146.24960275,   4, 8,  "AU-VIC F00.XX"},
        {-38.093455,  147.005628375,  4, 6,  "AU-VIC G00.XX"},
        {-38.148476,  146.230485875,  4, 6,  "AU-VIC H00.XX"},
        {-38.169976,  146.355485875,  4, 6,  "AU-VIC J00.XX"},
        {-37.835476,  144.602485875,  4, 6,  "AU-VIC K00.XX"},
        {-36.681976,  142.15150275,   4, 8,  "AU-VIC L00.XX"},
        {-36.089276,  144.699941375,  4, 8,  "AU-VIC M00.XX"},
        {-37.629276,  144.3789245,    4, 6,  "AU-VIC N00.XX"},
        {-38.261155,  144.476284375,  4, 6,  "AU-VIC P00.XX"},
        {-37.778876,  147.577385875,  4, 6,  "AU-VIC Q00.XX"},
        {-38.298876,  143.543033375,  4, 6,  "AU-VIC R00.XX"},
        {-38.305976,  141.539833375,  4, 6,  "AU-VIC S00.XX"},
        {-37.985676,  145.287585875,  5, 7,  "AU-VIC T00.XX"},
        {-35.299276,  143.49028,      3, 7,  "AU-VIC V00.XX"},
        {-37.689276,  141.9689245,    4, 6,  "AU-VIC W00.XX"},
        {-38.105376,  145.844085875,  4, 6,  "AU-VIC X00.XX"},
        {-36.502776,  145.92220275,   4, 8,  "AU-VIC Y00.XX"},
        {-37.029345,  143.676344625,  4, 8,  "AU-VIC Z00.XX"},
        {-36.0928185, 143.2863685,    3, 7,  "AU-VIC 123.XXX"},
        {-36.234228,  146.55758,      3, 7,  "AU-VIC 1234.XX"},
        {-37.073066,  141.302201,     3, 7,  "AU-VIC 12.XXXX"},
        {-34.3408425, 141.372642,     3, 7,  "AU-VIC 1234.XXX"},
        {-31.9249,    115.7982755,    5, 7,  "AU-WA 12.XX"},
        {-32.1946885, 115.702061,     4, 6,  "AU-WA 12.XXX"},
        {-32.350886,  115.700126,     4, 6,  "AU-WA 000.XX"},
        {-32.405965,  115.721965,     4, 6,  "AU-WA 200.XX"},
        {-32.532955,  115.627939875,  4, 6,  "AU-WA 400.XX"},
        {-30.785686,  121.393715125,  3, 5,  "AU-WA 600.XX"},
        {-28.678455,  114.578255625,  3, 5,  "AU-WA 800.XX"},
        {-33.378586,  115.596677625,  4, 6,  "AU-WA B00.XX"},
        {-35.039486,  117.805819625,  4, 6,  "AU-WA D00.XX"},
        {-20.310856,  118.538177375,  3, 5,  "AU-WA G00.XX"},
        {-17.968586,  122.17373525,   3, 5,  "AU-WA J00.XX"},
        {-33.638455,  115.15107,      4, 6,  "AU-WA L00.XX"},
        {-20.761386,  116.775316,     3, 5,  "AU-WA N00.XX"},
        {-33.858286,  121.810668,     4, 6,  "AU-WA Q00.XX"},
        {-33.395586,  116.071377625,  4, 6,  "AU-WA S00.XX"},
        {-24.907986,  113.6109795,    3, 5,  "AU-WA V00.XX"},
        {-31.668286,  116.59636575,   4, 6,  "AU-WA X00.XX"},
        {-33.216476,  115.679223625,  4, 6,  "AU-WA Z00.XX"},
        {-31.3703495, 115.081578,     3, 5,  "AU-WA 123.XXX"},
        {-32.769131,  117.088841,     4, 6,  "AU-WA 12.XXXX"},
        {-31.629695,  120.1932455,    3, 5,  "AU-WA 1234.XX"},
        {-13.9728195, 121.7043595,    3, 5,  "AU-WA 0123.XXX"},
        {-16.2567535, 124.3516935,    2, 4,  "AU-WA 1123.XXX"},
        {-16.2015425, 126.7257835,    2, 4,  "AU-WA 2123.XXX"},
        {-16.6540095, 120.898156,     2, 4,  "AU-WA 3123.XXX"},
        {-16.6540095, 123.668719,     2, 4,  "AU-WA 4123.XXX"},
        {-16.6540095, 126.335028,     2, 4,  "AU-WA 5123.XXX"},
        {-19.3515155, 113.112513,     2, 4,  "AU-WA 6123.XXX"},
        {-19.3515155, 115.942658,     2, 4,  "AU-WA 7123.XXX"},
        {-19.3515155, 118.772803,     2, 4,  "AU-WA 8123.XXX"},
        {-19.3515155, 121.602948,     2, 4,  "AU-WA 9123.XXX"},
        {-19.3515155, 124.433093,     2, 4,  "AU-WA B123.XXX"},
        {-19.3515155, 126.277171,     3, 5,  "AU-WA C123.XXX"},
        {-22.0163895, 113.0844005,    2, 4,  "AU-WA D123.XXX"},
        {-22.0163895, 115.9443365,    2, 4,  "AU-WA F123.XXX"},
        {-22.0163895, 118.8042725,    2, 4,  "AU-WA G123.XXX"},
        {-24.7138955, 113.057443,     2, 4,  "AU-WA H123.XXX"},
        {-24.7138955, 116.006752,     2, 4,  "AU-WA J123.XXX"},
        {-24.7138955, 118.956061,     2, 4,  "AU-WA K123.XXX"},
        {-27.3950855, 113.029911,     2, 4,  "AU-WA L123.XXX"},
        {-27.3950855, 116.038802,     2, 4,  "AU-WA M123.XXX"},
        {-27.3950855, 119.047693,     2, 4,  "AU-WA N123.XXX"},
        {-30.0599595, 113.905634,     2, 4,  "AU-WA P123.XXX"},
        {-30.0599595, 116.974107,     2, 4,  "AU-WA Q123.XXX"},
        {-30.0599595, 120.04258,      2, 4,  "AU-WA R123.XXX"},
        {-30.0599595, 123.111053,     2, 4,  "AU-WA S123.XXX"},
        {-30.0599595, 126.048461,     3, 5,  "AU-WA T123.XXX"},
        {-32.7411495, 114.6165745,    2, 4,  "AU-WA V123.XXX"},
        {-32.7411495, 117.7744205,    4, 6,  "AU-WA W123.XXX"},
        {-32.7411495, 120.9322665,    3, 5,  "AU-WA X123.XXX"},
        {-32.7411495, 124.0901125,    2, 4,  "AU-WA Y123.XXX"},
        {-22.224759,  120.790371,     3, 5,  "AU-WA 012.XXXX"},
        {-22.224759,  123.650307,     2, 4,  "AU-WA 112.XXXX"},
        {-22.224759,  126.318384,     3, 5,  "AU-WA 212.XXXX"},
        {-24.905949,  120.7661525,    3, 5,  "AU-WA 312.XXXX"},
        {-24.905949,  123.7154615,    2, 4,  "AU-WA 412.XXXX"},
        {-24.905949,  126.2345835,    3, 5,  "AU-WA 512.XXXX"},
        {-27.587139,  120.7400765,    3, 5,  "AU-WA 612.XXXX"},
        {-27.587139,  123.7489675,    2, 4,  "AU-WA 712.XXXX"},
        {-27.587139,  126.1787165,    3, 5,  "AU-WA 812.XXXX"},
        {-12.453665,  121.8493695,    2, 4,  "AU-WA 912.XXXX"},
        {-16.326616,  117.9381035,    2, 4,  "AU-WA B12.XXXX"},
        {-27.4248,    152.9876595,    5, 7,  "AU-QLD 12.XX"},
        {-27.447485,  152.912050375,  4, 6,  "AU-QLD 00.XXX"},
        {-27.675235,  152.726328125,  4, 6,  "AU-QLD J0.XXX"},
        {-27.844555,  153.284254375,  4, 6,  "AU-QLD 000.XX"},
        {-27.910455,  153.293254375,  4, 6,  "AU-QLD 100.XX"},
        {-27.971455,  153.311854375,  4, 6,  "AU-QLD 200.XX"},
        {-28.039985,  153.352254375,  4, 6,  "AU-QLD 300.XX"},
        {-28.104976,  153.402609875,  4, 6,  "AU-QLD 400.XX"},
        {-26.590776,  153.022387125,  4, 6,  "AU-QLD 500.XX"},
        {-26.677265,  153.046471125,  4, 6,  "AU-QLD 600.XX"},
        {-26.763754,  153.058769375,  4, 6,  "AU-QLD 700.XX"},
        {-19.265666,  146.7023375,    4, 6,  "AU-QLD 800.XX"},
        {-19.251455,  146.7569615,    4, 6,  "AU-QLD 900.XX"},
        {-16.875076,  145.694812,     3, 5,  "AU-QLD B00.XX"},
        {-16.961565,  145.694812,     3, 5,  "AU-QLD C00.XX"},
        {-27.524976,  151.899535625,  4, 6,  "AU-QLD D00.XX"},
        {-21.099276,  149.13638225,   4, 6,  "AU-QLD F00.XX"},
        {-23.329105,  150.473244375,  4, 6,  "AU-QLD G00.XX"},
        {-25.257455,  152.80024875,   4, 6,  "AU-QLD H00.XX"},
        {-26.386115,  152.999750625,  4, 6,  "AU-QLD J00.XX"},
        {-20.663955,  139.47094,      3, 5,  "AU-QLD K00.XX"},
        {-24.834276,  152.2992525,    4, 6,  "AU-QLD L00.XX"},
        {-23.824376,  151.205091125,  4, 6,  "AU-QLD M00.XX"},
        {-25.492276,  152.65012675,   4, 6,  "AU-QLD N00.XX"},
        {-28.173576,  151.981609875,  4, 9,  "AU-QLD P00.XX"},
        {-26.153876,  152.620013875,  4, 6,  "AU-QLD Q00.XX"},
        {-27.577255,  153.282073125,  5, 7,  "AU-QLD R00.XX"},
        {-23.089276,  150.695817875,  4, 6,  "AU-QLD S00.XX"},
        {-27.181136,  151.222793125,  4, 6,  "AU-QLD T00.XX"},
        {-23.511856,  148.138117625,  3, 5,  "AU-QLD TK0.00"},
        {-19.987336,  148.202710625,  4, 6,  "AU-QLD V00.XX"},
        {-17.541975,  145.990051875,  3, 5,  "AU-QLD VK0.00"},
        {-20.059036,  146.234810625,  4, 6,  "AU-QLD W00.XX"},
        {-19.553635,  147.35220025,   4, 6,  "AU-QLD WK0.00"},
        {-26.463215,  153.072550625,  4, 6,  "AU-QLD X00.XX"},
        {-26.552496,  151.819078125,  4, 6,  "AU-QLD XK0.00"},
        {-16.985936,  145.390711,     3, 5,  "AU-QLD Y00.XX"},
        {-22.001396,  148.024491375,  3, 5,  "AU-QLD YK0.00"},
        {-23.567536,  148.846423625,  3, 5,  "AU-QLD Z00.XX"},
        {-17.264495,  145.465491,     3, 5,  "AU-QLD ZK0.00"},
        {-25.7225785, 150.755342,     3, 5,  "AU-QLD 123.XXX"},
        {-23.249758,  150.4105165,    3, 5,  "AU-QLD 12.XXXX"},
        {-19.8708275, 146.196422,     3, 5,  "AU-QLD 1234.XX"},
        {-28.5870255, 138.535522,     2, 6,  "AU-QLD 1234.XXX"},
        {-10.3686055, 138.2966565,    2, 5,  "AU-QLD 123.XXXX"},
        {-15.831256,  -47.9446785,    4, 11, "BR-DF 12.XX"},
        {-15.6145365, -48.2633555,    3, 10, "BR-DF 12.XXX"},
        {-15.5725425, -47.785536,     3, 10, "BR-DF 123.XX"},
        {-15.6884485, -48.261311,     3, 11, "BR-DF 123.XXX"},
        {-10.961403,  -37.103521,     4, 6,  "BR-SE 12.XX"},
        {-10.723885,  -37.2896885,    3, 7,  "BR-SE 12.XXX"},
        {-10.605326,  -37.58995925,   3, 7,  "BR-SE 000.XX"},
        {-11.189776,  -37.570222125,  3, 7,  "BR-SE C00.XX"},
        {-10.924976,  -37.71694225,   3, 7,  "BR-SE P00.XX"},
        {-11.5351215, -38.290045,     2, 6,  "BR-SE 123.XXX"},
        {-9.596095,   -35.7626465,    4, 6,  "BR-AL 12.XX"},
        {-9.6180625,  -36.0984545,    3, 5,  "BR-AL 12.XXX"},
        {-9.998135,   -36.9157665,    3, 7,  "BR-AL 123.XX"},
        {-9.4675055,  -38.160432,     2, 9,  "BR-AL 123.XXX"},
        {-22.902455,  -43.26475625,   4, 8,  "BR-RJ 00.XX"},
        {-22.937965,  -43.22861125,   4, 8,  "BR-RJ J0.XX"},
        {-22.875595,  -43.626014,     3, 7,  "BR-RJ 12.XXX"},
        {-22.576455,  -43.33197625,   3, 7,  "BR-RJ 000.XX"},
        {-22.767206,  -42.95407125,   4, 8,  "BR-RJ 300.XX"},
        {-22.923806,  -43.81377125,   3, 7,  "BR-RJ 600.XX"},
        {-22.840455,  -42.39340725,   4, 8,  "BR-RJ 900.XX"},
        {-21.773106,  -41.400747625,  4, 8,  "BR-RJ D00.XX"},
        {-22.515186,  -43.2462625,    3, 7,  "BR-RJ H00.XX"},
        {-22.482155,  -44.2142275,    3, 9,  "BR-RJ K00.XX"},
        {-22.181955,  -42.5674575,    3, 7,  "BR-RJ M00.XX"},
        {-22.374386,  -41.8289625,    4, 8,  "BR-RJ P00.XX"},
        {-22.963455,  -44.33540725,   3, 8,  "BR-RJ R00.XX"},
        {-22.428386,  -43.0211625,    3, 7,  "BR-RJ T00.XX"},
        {-22.886186,  -42.11850225,   4, 8,  "BR-RJ W00.XX"},
        {-22.443455,  -44.5917575,    3, 9,  "BR-RJ Y00.XX"},
        {-22.312203,  -44.792564,     2, 8,  "BR-RJ 123.XXX"},
        {-20.954694,  -42.3261995,    2, 7,  "BR-RJ 12.XXXX"},
        {-20.384115,  -40.3374595,    4, 8,  "BR-ES 12.XX"},
        {-20.534725,  -40.528637,     3, 7,  "BR-ES 12.XXX"},
        {-20.660656,  -40.627796,     3, 7,  "BR-ES 000.XX"},
        {-20.834026,  -41.230656,     3, 9,  "BR-ES 600.XX"},
        {-19.384426,  -40.1541825,    3, 7,  "BR-ES C00.XX"},
        {-19.470326,  -40.7145825,    3, 7,  "BR-ES J00.XX"},
        {-18.711426,  -39.931413625,  3, 7,  "BR-ES P00.XX"},
        {-19.796326,  -40.41981925,   3, 7,  "BR-ES V00.XX"},
        {-20.6324495, -41.871624,     2, 6,  "BR-ES 123.XXX"},
        {-5.77332,    -35.263793,     5, 7,  "BR-RN 12.XX"},
        {-6.154525,   -35.5034535,    4, 8,  "BR-RN 12.XXX"},
        {-5.080006,   -37.441914875,  4, 8,  "BR-RN 000.XX"},
        {-6.335996,   -37.37912975,   4, 10, "BR-RN J00.XX"},
        {-5.377099,   -38.123196,     3, 7,  "BR-RN 123.XXX"},
        {-5.859785,   -38.4417155,    2, 6,  "BR-RN 12.XXXX"},
        {-7.0989,     -34.89559,      4, 6,  "BR-PB 12.XX"},
        {-6.832685,   -35.229475,     3, 7,  "BR-PB 12.XXX"},
        {-7.181226,   -36.038564625,  4, 6,  "BR-PB 000.XX"},
        {-6.992776,   -37.486303625,  4, 7,  "BR-PB C00.XX"},
        {-6.793276,   -38.36712375,   3, 8,  "BR-PB P00.XX"},
        {-6.370845,   -37.698855,     3, 9,  "BR-PB 123.XXX"},
        {-6.5946905,  -38.6194255,    2, 6,  "BR-PB 12.XXXX"},
        {-27.552,     -48.6575405,    4, 6,  "BR-SC 12.XX"},
        {-27.456806,  -48.743842625,  3, 5,  "BR-SC 00.XXX"},
        {-26.313386,  -48.946335875,  3, 7,  "BR-SC J0.XXX"},
        {-26.892096,  -49.191569625,  3, 5,  "BR-SC 000.XX"},
        {-27.803696,  -50.422250375,  3, 8,  "BR-SC 400.XX"},
        {-28.650096,  -49.465110875,  3, 5,  "BR-SC 800.XX"},
        {-26.810796,  -48.775689875,  3, 5,  "BR-SC D00.XX"},
        {-27.086996,  -52.731669625,  3, 7,  "BR-SC J00.XX"},
        {-26.449996,  -49.153889875,  3, 6,  "BR-SC N00.XX"},
        {-26.981096,  -48.761069625,  3, 5,  "BR-SC S00.XX"},
        {-27.113806,  -49.026473625,  3, 5,  "BR-SC X00.XX"},
        {-28.651745,  -50.6082685,    2, 7,  "BR-SC 123.XXX"},
        {-26.6576105, -53.6707535,    2, 8,  "BR-SC 12.XXXX"},
        {-8.0181,     -34.92949,      4, 8,  "BR-PE 12.XX"},
        {-8.2540685,  -35.169042,     3, 7,  "BR-PE 12.XXX"},
        {-8.299806,   -36.069458625,  3, 8,  "BR-PE 000.XX"},
        {-9.399806,   -40.5996665,    3, 9,  "BR-PE 300.XX"},
        {-8.898706,   -36.5559665,    3, 7,  "BR-PE 600.XX"},
        {-8.139806,   -35.389458625,  3, 7,  "BR-PE 900.XX"},
        {-7.941962,   -36.305793625,  3, 8,  "BR-PE D00.XX"},
        {-7.861506,   -35.282058625,  3, 7,  "BR-PE H00.XX"},
        {-8.226106,   -35.653958625,  3, 7,  "BR-PE L00.XX"},
        {-8.401455,   -37.099773125,  3, 5,  "BR-PE P00.XX"},
        {-7.977406,   -38.353558625,  3, 7,  "BR-PE S00.XX"},
        {-8.428686,   -35.112818625,  3, 5,  "BR-PE W00.XX"},
        {-7.582986,   -35.075418625,  3, 7,  "BR-PE Y00.XX"},
        {-7.857518,   -38.0775905,    2, 8,  "BR-PE 123.XXX"},
        {-8.072626,   -41.212029,     2, 7,  "BR-PE 12.XXXX"},
        {-0.00028,    -51.102862,     4, 9,  "BR-AP 12.XX"},
        {0.270215,    -51.363075,     3, 7,  "BR-AP 12.XXX"},
        {-0.958535,   -52.559795,     2, 6,  "BR-AP 123.XX"},
        {-1.223204,   -52.535861,     2, 6,  "BR-AP 123.XXX"},
        {4.2783685,   -52.359188,     2, 6,  "BR-AP 12.XXXX"},
        {0.414846,    -54.802457,     2, 6,  "BR-AP 1234.XX"},
        {-3.7093,     -38.56379,      4, 6,  "BR-CE 12.XX"},
        {-4.194885,   -38.6960365,    3, 5,  "BR-CE 12.XXX"},
        {-7.043455,   -39.469773125,  3, 5,  "BR-CE 000.XX"},
        {-3.501455,   -40.485774375,  3, 7,  "BR-CE J00.XX"},
        {-5.2510925,  -39.3199275,    2, 4,  "BR-CE 123.XXX"},
        {-4.5881435,  -41.3719935,    2, 7,  "BR-CE 1234.XX"},
        {-6.366622,   -40.8386705,    2, 7,  "BR-CE 12.XXXX"},
        {-9.929,      -67.8638305,    5, 8,  "BR-AC 12.XX"},
        {-9.787885,   -68.0105885,    4, 9,  "BR-AC 12.XXX"},
        {-7.584606,   -72.969675625,  4, 10, "BR-AC 000.XX"},
        {-9.020796,   -68.8296595,    4, 10, "BR-AC J00.XX"},
        {-8.7987375,  -69.3323735,    3, 9,  "BR-AC 123.XXX"},
        {-10.7432035, -71.504384,     3, 7,  "BR-AC 12.XXXX"},
        {-9.986065,   -73.9232585,    3, 7,  "BR-AC 1234.XX"},
        {-7.381862,   -73.736919,     3, 9,  "BR-AC 1234.XXX"},
        {-25.4107,    -49.2906985,    4, 6,  "BR-PR 12.XX"},
        {-25.704885,  -49.4682685,    3, 5,  "BR-PR 12.XXX"},
        {-23.378455,  -52.062755625,  3, 9,  "BR-PR 000.XX"},
        {-23.255455,  -51.217155625,  3, 9,  "BR-PR 300.XX"},
        {-25.056256,  -50.2327525,    3, 7,  "BR-PR 600.XX"},
        {-25.454955,  -54.60075125,   3, 8,  "BR-PR 900.XX"},
        {-24.916956,  -53.5345225,    3, 5,  "BR-PR C00.XX"},
        {-25.408386,  -51.53886025,   3, 5,  "BR-PR F00.XX"},
        {-25.577086,  -48.62056025,   3, 5,  "BR-PR H00.XX"},
        {-23.584086,  -51.516572125,  3, 9,  "BR-PR K00.XX"},
        {-24.751886,  -53.8030205,    3, 5,  "BR-PR M00.XX"},
        {-23.428886,  -51.504072125,  3, 9,  "BR-PR P00.XX"},
        {-23.273455,  -51.401755625,  3, 9,  "BR-PR R00.XX"},
        {-25.473086,  -49.60596025,   3, 5,  "BR-PR T00.XX"},
        {-23.790786,  -53.374010875,  3, 8,  "BR-PR W00.XX"},
        {-24.044786,  -52.448210875,  3, 9,  "BR-PR Y00.XX"},
        {-24.197325,  -51.089969,     2, 6,  "BR-PR 123.XXX"},
        {-23.981515,  -53.7006255,    2, 7,  "BR-PR 12.XXXX"},
        {-25.5707325, -54.6202925,    2, 9,  "BR-PR 0123.XX"},
        {-25.5303805, -54.2275205,    2, 4,  "BR-PR 1123.XX"},
        {-24.8084205, -54.432207,     2, 6,  "BR-PR 2123.XX"},
        {-24.72572,   -54.376799,     2, 6,  "BR-PR 3123.XX"},
        {-24.237395,  -54.376799,     2, 6,  "BR-PR 4123.XX"},
        {-23.890952,  -54.0653885,    3, 8,  "BR-PR 5123.XX"},
        {-23.890952,  -53.5602125,    2, 7,  "BR-PR 6123.XX"},
        {-23.890952,  -53.0550365,    2, 9,  "BR-PR 7123.XX"},
        {-23.890952,  -52.5498605,    2, 8,  "BR-PR 8123.XX"},
        {-23.890952,  -52.0446845,    2, 8,  "BR-PR 9123.XX"},
        {-23.890952,  -51.5395085,    2, 8,  "BR-PR B123.XX"},
        {-23.890952,  -51.0343325,    2, 8,  "BR-PR C123.XX"},
        {-23.890952,  -50.5291565,    2, 6,  "BR-PR D123.XX"},
        {-23.890952,  -50.0239805,    2, 6,  "BR-PR F123.XX"},
        {-23.399912,  -54.0653885,    2, 7,  "BR-PR G123.XX"},
        {-23.399912,  -53.5602125,    2, 7,  "BR-PR H123.XX"},
        {-23.399912,  -53.0550365,    2, 9,  "BR-PR J123.XX"},
        {-23.399912,  -52.5498605,    2, 8,  "BR-PR K123.XX"},
        {-23.399912,  -52.0446845,    3, 9,  "BR-PR L123.XX"},
        {-23.399912,  -51.5395085,    2, 8,  "BR-PR M123.XX"},
        {-23.399912,  -51.0343325,    2, 8,  "BR-PR N123.XX"},
        {-23.399912,  -50.5291565,    2, 6,  "BR-PR P123.XX"},
        {-23.399912,  -50.0239805,    2, 6,  "BR-PR Q123.XX"},
        {-22.989655,  -53.5602125,    3, 8,  "BR-PR R123.XX"},
        {-22.989655,  -53.0550365,    3, 10, "BR-PR S123.XX"},
        {-22.989655,  -52.5498605,    3, 9,  "BR-PR T123.XX"},
        {-22.989655,  -52.0446845,    3, 9,  "BR-PR V123.XX"},
        {-22.989655,  -51.5395085,    3, 9,  "BR-PR W123.XX"},
        {-22.8484485, -51.0048685,    2, 10, "BR-PR X123.XX"},
        {2.83036,     -60.749941,     5, 9,  "BR-RR 12.XX"},
        {3.016115,    -60.882575,     4, 8,  "BR-RR 12.XXX"},
        {1.915094,    -61.302235,     4, 10, "BR-RR 000.XX"},
        {1.028104,    -60.5929,       4, 9,  "BR-RR J00.XX"},
        {2.5398405,   -61.4562785,    3, 6,  "BR-RR 123.XXX"},
        {5.028977,    -61.390775,     3, 7,  "BR-RR 12.XXXX"},
        {3.755342,    -64.141715,     3, 6,  "BR-RR 1234.XX"},
        {4.8020355,   -64.645453,     2, 5,  "BR-RR 1234.XXX"},
        {-8.738894,   -63.913663,     5, 9,  "BR-RO 12.XX"},
        {-8.618285,   -63.9663885,    4, 8,  "BR-RO 12.XXX"},
        {-10.843576,  -62.06050225,   4, 7,  "BR-RO 000.XX"},
        {-9.870376,   -63.174462375,  4, 7,  "BR-RO 800.XX"},
        {-12.696276,  -60.267420875,  4, 9,  "BR-RO J00.XX"},
        {-11.375396,  -61.565868125,  4, 9,  "BR-RO S00.XX"},
        {-9.0786095,  -64.5712395,    3, 7,  "BR-RO 123.XXX"},
        {-10.881938,  -62.181499,     3, 6,  "BR-RO 12.XXXX"},
        {-11.071641,  -65.2525665,    3, 6,  "BR-RO 1234.XX"},
        {-8.2815195,  -66.6246335,    2, 8,  "BR-RO 1234.XXX"},
        {-23.524495,  -46.6942585,    5, 7,  "BR-SP 12.XX"},
        {-23.502501,  -46.8722095,    4, 6,  "BR-SP 12.XXX"},
        {-22.882855,  -47.14160425,   4, 8,  "BR-SP 000.XX"},
        {-22.855155,  -47.07815625,   4, 8,  "BR-SP 100.XX"},
        {-23.173276,  -45.939182125,  4, 6,  "BR-SP 200.XX"},
        {-21.143276,  -47.85861775,   4, 8,  "BR-SP 300.XX"},
        {-23.492176,  -47.532782125,  4, 6,  "BR-SP 400.XX"},
        {-23.913576,  -46.390708875,  4, 6,  "BR-SP 500.XX"},
        {-20.770476,  -49.434592,     4, 8,  "BR-SP 600.XX"},
        {-22.683076,  -47.69146925,   4, 8,  "BR-SP 700.XX"},
        {-22.286576,  -49.1288435,    4, 8,  "BR-SP 800.XX"},
        {-23.946376,  -46.476608875,  4, 6,  "BR-SP 900.XX"},
        {-23.493176,  -46.241582125,  4, 6,  "BR-SP B00.XX"},
        {-23.168476,  -46.926682125,  4, 6,  "BR-SP C00.XX"},
        {-20.492076,  -47.447292,     4, 8,  "BR-SP D00.XX"},
        {-23.930576,  -46.300708875,  5, 7,  "BR-SP F00.XX"},
        {-22.531576,  -47.4554435,    4, 8,  "BR-SP G00.XX"},
        {-23.519776,  -46.311982125,  4, 6,  "BR-SP H00.XX"},
        {-22.986376,  -45.61676925,   4, 6,  "BR-SP J00.XX"},
        {-23.410876,  -47.493282125,  4, 6,  "BR-SP K00.XX"},
        {-23.999676,  -46.556608875,  4, 6,  "BR-SP L00.XX"},
        {-22.797636,  -47.31329075,   4, 8,  "BR-SP M00.XX"},
        {-22.233996,  -49.9740815,    4, 8,  "BR-SP MK0.00"},
        {-23.290036,  -45.996476375,  4, 6,  "BR-SP N00.XX"},
        {-22.129596,  -51.4359815,    4, 9,  "BR-SP NK0.00"},
        {-22.011736,  -47.925132875,  4, 8,  "BR-SP P00.XX"},
        {-22.746796,  -47.35842625,   4, 8,  "BR-SP PK0.00"},
        {-23.524036,  -46.963676375,  4, 6,  "BR-SP Q00.XX"},
        {-21.795296,  -48.196908625,  4, 8,  "BR-SP QK0.00"},
        {-22.858236,  -47.23109075,   4, 8,  "BR-SP R00.XX"},
        {-22.758896,  -47.43382625,   4, 8,  "BR-SP RK0.00"},
        {-22.392536,  -47.5985195,    4, 8,  "BR-SP S00.XX"},
        {-21.214596,  -50.47643675,   4, 8,  "BR-SP SK0.00"},
        {-23.593636,  -46.962676375,  4, 6,  "BR-SP T00.XX"},
        {-23.109496,  -47.244398125,  4, 6,  "BR-SP TK0.00"},
        {-23.274536,  -46.771176375,  4, 6,  "BR-SP V00.XX"},
        {-23.278596,  -47.325398125,  4, 6,  "BR-SP VK0.00"},
        {-22.922836,  -45.49479075,   4, 8,  "BR-SP W00.XX"},
        {-22.358296,  -46.9658815,    4, 8,  "BR-SP WK0.00"},
        {-23.583636,  -48.079076375,  4, 7,  "BR-SP X00.XX"},
        {-22.959996,  -46.56942625,   4, 6,  "BR-SP XK0.00"},
        {-23.872736,  -46.468948625,  4, 6,  "BR-SP Y00.XX"},
        {-22.296296,  -48.5881815,    4, 8,  "BR-SP YK0.00"},
        {-22.876836,  -48.49419075,   4, 9,  "BR-SP Z00.XX"},
        {-21.141996,  -49.00203675,   4, 8,  "BR-SP ZK0.00"},
        {-23.7003965, -48.5189335,    3, 6,  "BR-SP 123.XXX"},
        {-20.261293,  -51.5850425,    3, 8,  "BR-SP 12.XXXX"},
        {-20.194333,  -48.8285225,    3, 8,  "BR-SP 1234.XX"},
        {-20.055421,  -52.8982455,    2, 7,  "BR-SP 1234.XXX"},
        {-5.0574,     -42.82409,      5, 11, "BR-PI 12.XX"},
        {-4.958485,   -42.838175,     4, 9,  "BR-PI 12.XXX"},
        {-2.881676,   -41.871265,     4, 8,  "BR-PI 000.XX"},
        {-7.043576,   -41.533083625,  4, 6,  "BR-PI 800.XX"},
        {-6.769776,   -43.12044375,   4, 9,  "BR-PI J00.XX"},
        {-4.166096,   -41.892461875,  4, 8,  "BR-PI S00.XX"},
        {-5.4673145,  -43.094335,     3, 8,  "BR-PI 123.XXX"},
        {-6.62787,    -43.3314185,    3, 8,  "BR-PI 12.XXXX"},
        {-9.318679,   -45.902575,     3, 11, "BR-PI 1234.XX"},
        {-3.1797075,  -46.0149515,    2, 9,  "BR-PI 1234.XXX"},
        {-10.191706,  -48.49917675,   4, 8,  "BR-TO 00.XXX"},
        {-7.194686,   -48.392159375,  4, 10, "BR-TO J0.XXX"},
        {-11.674226,  -49.216557125,  4, 6,  "BR-TO 000.XX"},
        {-10.129176,  -49.02604225,   4, 6,  "BR-TO C00.XX"},
        {-10.652476,  -48.54194225,   4, 6,  "BR-TO P00.XX"},
        {-12.2223375, -50.7592165,    3, 7,  "BR-TO 123.XXX"},
        {-9.6670815,  -48.0552115,    3, 9,  "BR-TO 12.XXXX"},
        {-6.912515,   -48.967735,     3, 7,  "BR-TO 1234.XX"},
        {-5.6005015,  -50.800409,     2, 6,  "BR-TO 1234.XXX"},
        {-30.0151,    -51.2460825,    5, 7,  "BR-RS 12.XX"},
        {-30.185721,  -51.3627945,    4, 6,  "BR-RS 12.XXX"},
        {-29.175406,  -51.257936625,  4, 7,  "BR-RS 000.XX"},
        {-31.688476,  -52.44973625,   4, 6,  "BR-RS 300.XX"},
        {-29.663455,  -53.901245875,  4, 6,  "BR-RS 600.XX"},
        {-32.063706,  -52.191539,     4, 6,  "BR-RS 900.XX"},
        {-28.265506,  -52.482705125,  4, 8,  "BR-RS D00.XX"},
        {-29.799506,  -57.149152375,  3, 7,  "BR-RS H00.XX"},
        {-29.729806,  -52.541852375,  4, 6,  "BR-RS L00.XX"},
        {-31.350886,  -54.1744945,    4, 8,  "BR-RS P00.XX"},
        {-27.626455,  -52.390746875,  4, 8,  "BR-RS R00.XX"},
        {-30.913386,  -55.607684875,  4, 8,  "BR-RS T00.XX"},
        {-29.145855,  -51.545743125,  4, 7,  "BR-RS W00.XX"},
        {-29.817286,  -55.849606375,  4, 8,  "BR-RS Y00.XX"},
        {-27.482537,  -52.8512275,    3, 7,  "BR-RS 123.XXX"},
        {-29.365455,  -55.8500745,    3, 7,  "BR-RS 12.XXXX"},
        {-30.890207,  -52.832143,     3, 5,  "BR-RS 1234.XX"},
        {-27.3962725, -57.488076,     2, 8,  "BR-RS 1234.XXX"},
        {-2.4904,     -44.31029,      5, 7,  "BR-MA 12.XX"},
        {-2.939445,   -44.4154575,    4, 8,  "BR-MA 12.XXX"},
        {-5.491996,   -47.51382475,   4, 11, "BR-MA 000.XX"},
        {-5.107896,   -42.967084875,  4, 9,  "BR-MA 400.XX"},
        {-4.888196,   -43.480684875,  4, 8,  "BR-MA 800.XX"},
        {-4.939596,   -47.576284875,  4, 8,  "BR-MA D00.XX"},
        {-4.231706,   -44.862142875,  4, 8,  "BR-MA J00.XX"},
        {-3.667206,   -45.450342875,  4, 8,  "BR-MA M00.XX"},
        {-7.537106,   -46.134258625,  4, 12, "BR-MA Q00.XX"},
        {-3.741206,   -43.409942875,  4, 8,  "BR-MA T00.XX"},
        {-5.510606,   -45.32275075,   4, 8,  "BR-MA X00.XX"},
        {-4.950853,   -44.8892165,    3, 7,  "BR-MA 123.XXX"},
        {-3.689887,   -47.592137,     3, 7,  "BR-MA 12.XXXX"},
        {-5.995237,   -46.1878925,    3, 11, "BR-MA 1234.XX"},
        {-1.602592,   -48.506748,     2, 7,  "BR-MA 1234.XXX"},
        {-16.6557,    -49.3131725,    5, 9,  "BR-GO 12.XX"},
        {-16.533784,  -49.5217235,    4, 8,  "BR-GO 12.XXX"},
        {-16.295056,  -49.09975525,   4, 8,  "BR-GO 000.XX"},
        {-16.062055,  -48.04618525,   4, 8,  "BR-GO 600.XX"},
        {-17.769326,  -51.040676875,  4, 12, "BR-GO C00.XX"},
        {-15.724526,  -48.398503375,  4, 8,  "BR-GO J00.XX"},
        {-18.398026,  -49.32644575,   4, 9,  "BR-GO P00.XX"},
        {-15.521926,  -47.441203375,  4, 10, "BR-GO V00.XX"},
        {-15.8198555, -50.4384115,    3, 9,  "BR-GO 123.XXX"},
        {-18.149453,  -51.100465,     3, 9,  "BR-GO 12.XXXX"},
        {-14.017631,  -49.934578,     3, 5,  "BR-GO 1234.XX"},
        {-12.8175155, -53.006129,     2, 6,  "BR-GO 1234.XXX"},
        {-20.4283,    -54.6523145,    5, 8,  "BR-MS 12.XX"},
        {-20.248685,  -54.8963585,    4, 7,  "BR-MS 12.XXX"},
        {-22.130496,  -54.9161385,    4, 7,  "BR-MS 000.XX"},
        {-19.054356,  -57.7420195,    3, 6,  "BR-MS 700.XX"},
        {-20.778756,  -51.847896,     4, 8,  "BR-MS F00.XX"},
        {-22.495056,  -55.7755715,    4, 9,  "BR-MS M00.XX"},
        {-23.037156,  -54.31635925,   4, 8,  "BR-MS T00.XX"},
        {-21.4687005, -55.7109735,    3, 6,  "BR-MS 123.XXX"},
        {-18.99588,   -55.586972,     3, 5,  "BR-MS 12.XXXX"},
        {-18.825865,  -52.875757,     3, 7,  "BR-MS 1234.XX"},
        {-17.647227,  -57.993453,     2, 7,  "BR-MS 1234.XXX"},
        {-12.9398,    -38.529232,     5, 7,  "BR-BA 12.XX"},
        {-12.577685,  -38.51161,      4, 6,  "BR-BA 12.XXX"},
        {-12.264806,  -39.037198,     4, 6,  "BR-BA 000.XX"},
        {-14.870006,  -40.9239295,    4, 8,  "BR-BA 300.XX"},
        {-14.810006,  -39.3603295,    4, 6,  "BR-BA 600.XX"},
        {-9.415506,   -40.5864665,    3, 10, "BR-BA 900.XX"},
        {-14.827206,  -39.1659295,    4, 6,  "BR-BA D00.XX"},
        {-12.124206,  -45.080790125,  4, 6,  "BR-BA H00.XX"},
        {-13.864206,  -40.16401375,   4, 6,  "BR-BA L00.XX"},
        {-12.162086,  -38.496868,     4, 6,  "BR-BA P00.XX"},
        {-17.560386,  -39.801594875,  4, 8,  "BR-BA R00.XX"},
        {-16.437186,  -39.152356125,  4, 6,  "BR-BA T00.XX"},
        {-9.417386,   -38.2970885,    3, 7,  "BR-BA W00.XX"},
        {-16.378986,  -39.637156125,  4, 6,  "BR-BA Y00.XX"},
        {-17.414566,  -40.9148325,    3, 7,  "BR-BA 12.XXXX"},
        {-12.4135795, -40.89668,      3, 5,  "BR-BA 123.XXX"},
        {-11.186112,  -45.6598125,    3, 7,  "BR-BA 1234.XX"},
        {-9.104918,   -46.3735025,    2, 10, "BR-BA 1234.XXX"},
        {-19.862535,  -43.982812,     5, 7,  "BR-MG 12.XX"},
        {-19.664985,  -44.2279585,    4, 8,  "BR-MG 12.XXX"},
        {-18.932886,  -48.341034625,  4, 8,  "BR-MG 000.XX"},
        {-21.775686,  -43.443992625,  4, 8,  "BR-MG 200.XX"},
        {-16.748386,  -43.918556125,  4, 8,  "BR-MG 400.XX"},
        {-19.764086,  -48.00074425,   4, 8,  "BR-MG 600.XX"},
        {-18.830276,  -42.000926625,  4, 6,  "BR-MG 800.XX"},
        {-19.428176,  -42.59446525,   4, 6,  "BR-MG 900.XX"},
        {-19.411676,  -44.27686525,   4, 6,  "BR-MG B00.XX"},
        {-20.108876,  -44.926478125,  4, 8,  "BR-MG C00.XX"},
        {-21.775876,  -46.610830625,  3, 8,  "BR-MG D00.XX"},
        {-18.551276,  -46.549126625,  4, 8,  "BR-MG F00.XX"},
        {-21.180576,  -43.81091775,   4, 7,  "BR-MG G00.XX"},
        {-21.521876,  -45.481430625,  3, 7,  "BR-MG H00.XX"},
        {-22.186976,  -45.9786435,    3, 7,  "BR-MG J00.XX"},
        {-20.624476,  -43.830192,     4, 6,  "BR-MG K00.XX"},
        {-17.826576,  -41.546800875,  4, 8,  "BR-MG L00.XX"},
        {-19.483476,  -42.67286525,   4, 6,  "BR-MG M00.XX"},
        {-19.591876,  -43.27086525,   4, 6,  "BR-MG N00.XX"},
        {-20.677376,  -46.649292,     3, 8,  "BR-MG P00.XX"},
        {-18.604576,  -48.238326625,  4, 9,  "BR-MG Q00.XX"},
        {-21.090276,  -42.42491775,   4, 7,  "BR-MG R00.XX"},
        {-21.077076,  -42.98791775,   4, 7,  "BR-MG S00.XX"},
        {-18.942976,  -49.5087395,    4, 8,  "BR-MG T00.XX"},
        {-19.556676,  -46.99236525,   4, 6,  "BR-MG V00.XX"},
        {-22.387276,  -45.5054435,    3, 7,  "BR-MG W00.XX"},
        {-21.208776,  -45.03831775,   4, 8,  "BR-MG X00.XX"},
        {-21.087876,  -44.28981775,   4, 9,  "BR-MG Y00.XX"},
        {-20.033276,  -44.628278125,  4, 8,  "BR-MG Z00.XX"},
        {-19.2564135, -45.020246,     3, 5,  "BR-MG 123.XXX"},
        {-16.700317,  -44.0065475,    3, 7,  "BR-MG 1234.XX"},
        {-19.186266,  -49.506632,     3, 7,  "BR-MG 12.XXXX"},
        {-14.809262,  -50.682239,     2, 8,  "BR-MG 1234.XXX"},
        {-15.596715,  -56.1381085,    5, 7,  "BR-MT 12.XX"},
        {-15.432385,  -56.3381235,    4, 6,  "BR-MT 12.XXX"},
        {-16.419306,  -54.746040125,  4, 6,  "BR-MT 000.XX"},
        {-11.764096,  -55.594854125,  4, 6,  "BR-MT J00.XX"},
        {-14.8433625, -56.644662,     3, 5,  "BR-MT 123.XXX"},
        {-10.76397,   -56.5957625,    3, 5,  "BR-MT 12.XXXX"},
        {-9.50821,    -61.5395665,    3, 10, "BR-MT 1234.XX"},
        {-8.0543185,  -61.263162,     2, 8,  "BR-MT 1234.XXX"},
        {-1.467365,   -48.5052705,    5, 9,  "BR-PA 12.XX"},
        {-1.317985,   -48.48437,      4, 8,  "BR-PA 12.XXX"},
        {0.048004,    -51.234745,     3, 8,  "BR-PA 000.XX"},
        {-2.476356,   -54.87744,      4, 6,  "BR-PA 700.XX"},
        {-5.214126,   -49.208453375,  4, 8,  "BR-PA F00.XX"},
        {-1.647356,   -48.98274,      4, 6,  "BR-PA M00.XX"},
        {-1.513356,   -48.78694,      4, 6,  "BR-PA T00.XX"},
        {-0.3936165,  -50.1158235,    3, 7,  "BR-PA 123.XXX"},
        {-2.487146,   -55.94502,      3, 5,  "BR-PA 12.XXXX"},
        {-3.433486,   -50.396002,     3, 5,  "BR-PA 1234.XX"},
        {1.7696885,   -58.4529315,    2, 7,  "BR-PA 1234.XXX"},
        {-3.105885,   -60.068645,     5, 7,  "BR-AM 12.XX"},
        {-2.880285,   -60.235375,     4, 6,  "BR-AM 12.XXX"},
        {-2.619596,   -56.865645,     4, 8,  "BR-AM 000.XX"},
        {-3.212056,   -60.74714,      4, 6,  "BR-AM 700.XX"},
        {-3.047256,   -58.54304,      4, 8,  "BR-AM F00.XX"},
        {-3.273556,   -64.858933875,  4, 6,  "BR-AM M00.XX"},
        {-4.118156,   -63.213633875,  4, 6,  "BR-AM T00.XX"},
        {-1.8210165,  -61.3489235,    3, 5,  "BR-AM 123.XXX"},
        {-2.01307,    -58.60223,      3, 7,  "BR-AM 12.XXXX"},
        {-4.4788535,  -65.109233,     3, 5,  "BR-AM 1234.XX"},
        {-7.9257395,  -73.2138535,    2, 9,  "BR-AM 1234.XXX"},
        {38.9451,     -77.0679345,    4, 13, "US-DC 12.XX"},
        {38.977851,   -77.1083025,    3, 11, "US-DC 12.XXX"},
        {38.893375,   -77.014,        4, 12, "US-DC LZ2S.QSP"},
        {41.8566,     -71.46372,      5, 11, "US-RI 12.XX"},
        {41.890021,   -71.7808195,    4, 11, "US-RI 12.XXX"},
        {41.5462105,  -71.86409,      4, 13, "US-RI 123.XX"},
        {41.585,      -71.503,        4, 9,  "US-RI KFJ.4C7"},
        {41.585,      -71.503,        4, 9,  "US-RI TG8R.4PT"},
        {39.7811,     -75.600836,     5, 10, "US-DE 12.XX"},
        {39.295994,   -75.7741355,    4, 10, "US-DE 12.XXX"},
        {38.509584,   -75.64251,      4, 10, "US-DE 123.XX"},
        {38.892712,   -75.78326,      3, 9,  "US-DE 123.XXX"},
        {39.1455,     -75.394,        3, 12, "US-DE NYJF.P2K"},
        {41.2249,     -73.2371185,    5, 8,  "US-CT 12.XX"},
        {41.768545,   -73.1105065,    4, 11, "US-CT 12.XXX"},
        {41.256474,   -73.2279465,    5, 11, "US-CT 000.XX"},
        {41.179146,   -73.4477715,    4, 9,  "US-CT 500.XX"},
        {41.092152,   -73.7033825,    4, 9,  "US-CT B00.XX"},
        {41.333804,   -72.9795995,    5, 11, "US-CT H00.XX"},
        {41.401604,   -73.5505995,    4, 9,  "US-CT M00.XX"},
        {41.554404,   -72.20796,      4, 10, "US-CT R00.XX"},
        {41.386904,   -72.2232995,    4, 10, "US-CT W00.XX"},
        {41.513794,   -72.760997,     4, 10, "US-CT 85Y.25X"},
        {41.513794,   -72.760997,     4, 10, "US-CT S1BV.FYS"},
        {40.793111,   -74.071084375,  5, 10, "US-NJ 00.XX"},
        {40.712655,   -74.104584875,  5, 10, "US-NJ J0.XX"},
        {40.4970185,  -74.4804485,    5, 8,  "US-NJ 12.XXX"},
        {40.428504,   -74.495165375,  4, 6,  "US-NJ 000.XX"},
        {40.022944,   -74.294385375,  4, 6,  "US-NJ 700.XX"},
        {40.242244,   -74.811885375,  4, 9,  "US-NJ F00.XX"},
        {39.951244,   -75.144609875,  4, 12, "US-NJ M00.XX"},
        {39.516545,   -75.276309375,  4, 12, "US-NJ T00.XX"},
        {39.5225135,  -75.573757,     3, 12, "US-NJ 123.XXX"},
        {40.1405,     -74.734,        4, 9,  "US-NJ PN4D.BTW"},
        {43.0154,     -71.510262,     5, 11, "US-NH 12.XX"},
        {42.892642,   -71.5873355,    4, 10, "US-NH 12.XXX"},
        {43.229924,   -71.7262955,    4, 10, "US-NH 000.XX"},
        {43.141224,   -70.936237,     4, 10, "US-NH 800.XX"},
        {43.385843,   -71.0204935,    4, 8,  "US-NH J00.XX"},
        {42.967704,   -72.433001,     4, 11, "US-NH S00.XX"},
        {44.0014,     -71.576,        3, 9,  "US-NH NFB.G1R"},
        {44.0014,     -71.576,        3, 9,  "US-NH TFCS.0M1"},
        {44.5187,     -73.2406445,    5, 9,  "US-VT 12.XX"},
        {44.785915,   -73.3073835,    4, 10, "US-VT 12.XXX"},
        {43.988665,   -72.862762,     4, 8,  "US-VT 123.XX"},
        {42.907975,   -73.422202,     3, 9,  "US-VT 123.XXX"},
        {43.8725,     -72.44,         3, 10, "US-VT S986.P48"},
        {42.4011,     -71.1181605,    5, 8,  "US-MA 12.XX"},
        {42.553015,   -71.3889135,    5, 8,  "US-MA 12.XXX"},
        {42.268804,   -71.9182205,    4, 8,  "US-MA 000.XX"},
        {42.150004,   -72.6829205,    4, 8,  "US-MA 400.XX"},
        {42.638804,   -71.433181,     4, 7,  "US-MA 800.XX"},
        {41.664704,   -71.03866,      4, 7,  "US-MA D00.XX"},
        {42.728194,   -71.235443,     4, 11, "US-MA J00.XX"},
        {42.050194,   -71.1186115,    4, 7,  "US-MA M00.XX"},
        {41.713294,   -71.25538,      4, 11, "US-MA Q00.XX"},
        {41.894394,   -71.18818,      4, 11, "US-MA T00.XX"},
        {42.449494,   -73.3324115,    4, 10, "US-MA X00.XX"},
        {42.0576595,  -71.683502,     3, 6,  "US-MA JCP.PSH"},
        {42.0576595,  -71.683502,     3, 6,  "US-MA T9PS.XSD"},
        {21.33679,    -157.90388675,  5, 7,  "US-HI 00.XX"},
        {21.297235,   -157.87847775,  5, 7,  "US-HI J0.XX"},
        {21.472955,   -158.28237275,  4, 6,  "US-HI 00.XXX"},
        {21.542925,   -158.15537275,  5, 7,  "US-HI C0.XXX"},
        {21.292935,   -157.98843475,  4, 6,  "US-HI P0.XXX"},
        {21.012833,   -156.6796225,   4, 6,  "US-HI 123.XX"},
        {21.700025,   -160.299975,    3, 5,  "US-HI 016.S0L"},
        {21.200025,   -158.309975,    3, 5,  "US-HI 317.L09"},
        {20.444025,   -157.414975,    3, 5,  "US-HI 51P.S00"},
        {18.880025,   -156.099975,    3, 5,  "US-HI C2V.612"},
        {28.095393,   -177.512675,    3, 5,  "US-HI M0H.S0F"},
        {22.890389,   -162.101747,    3, 5,  "US-HI N0P.S0Y"},
        {23.462193,   -164.828467,    3, 5,  "US-HI P0H.S0F"},
        {23.556209,   -166.357087,    3, 5,  "US-HI Q0S.S04"},
        {25.656993,   -171.853567,    3, 5,  "US-HI R0H.S0F"},
        {25.945993,   -174.087267,    3, 5,  "US-HI S0H.S0F"},
        {27.655661,   -176.000555,    3, 5,  "US-HI T0P.S0Y"},
        {28.290161,   -178.415051,    3, 5,  "US-HI V0F.S0P"},
        {22.094855,   -177.5882825,   2, 4,  "US-HI 1234.XXX"},
        {39.3337,     -76.6594345,    5, 8,  "US-MD 12.XX"},
        {39.498715,   -76.8733085,    4, 6,  "US-MD 12.XXX"},
        {39.145344,   -77.33992725,   4, 9,  "US-MD 000.XX"},
        {39.018974,   -77.10268925,   5, 8,  "US-MD 600.XX"},
        {38.620474,   -77.044783625,  4, 9,  "US-MD C00.XX"},
        {39.441474,   -77.569493875,  4, 7,  "US-MD J00.XX"},
        {39.641574,   -77.841093875,  4, 9,  "US-MD P00.XX"},
        {39.612474,   -77.180293875,  4, 6,  "US-MD V00.XX"},
        {38.9513915,  -79.366421,     3, 11, "US-MD 123.XXX"},
        {38.8051145,  -77.2648255,    3, 8,  "US-MD LPB7.T27"},
        {38.339876,   -81.7666815,    5, 8,  "US-WV 12.XX"},
        {38.4326915,  -82.556899,     4, 13, "US-WV 12.XXX"},
        {39.418545,   -81.64805825,   4, 10, "US-WV 000.XX"},
        {40.415674,   -80.753667375,  4, 9,  "US-WV 500.XX"},
        {39.645974,   -80.080793875,  4, 6,  "US-WV B00.XX"},
        {40.123045,   -80.797956875,  4, 9,  "US-WV H00.XX"},
        {39.490804,   -80.254657875,  4, 6,  "US-WV M00.XX"},
        {37.783804,   -81.2965365,    4, 7,  "US-WV R00.XX"},
        {39.461804,   -78.075657875,  4, 12, "US-WV W00.XX"},
        {40.601674,   -80.8557795,    3, 8,  "US-WV 012.XXX"},
        {40.145674,   -80.8557795,    3, 8,  "US-WV 112.XXX"},
        {39.684997,   -81.7179645,    3, 8,  "US-WV 212.XXX"},
        {39.684997,   -81.1190445,    3, 8,  "US-WV 312.XXX"},
        {39.684997,   -80.5201245,    3, 6,  "US-WV 412.XXX"},
        {39.684997,   -79.9212045,    4, 6,  "US-WV 512.XXX"},
        {39.684997,   -79.3222845,    3, 8,  "US-WV 612.XXX"},
        {39.684997,   -78.7233645,    3, 8,  "US-WV 712.XXX"},
        {39.192021,   -78.157202,     3, 11, "US-WV 812.XXX"},
        {39.193957,   -82.436954,     3, 9,  "US-WV 912.XXX"},
        {39.193957,   -81.843242,     3, 10, "US-WV B12.XXX"},
        {39.193957,   -81.24953,      3, 9,  "US-WV C12.XXX"},
        {39.193957,   -80.655819,     3, 7,  "US-WV D12.XXX"},
        {39.193957,   -80.062107,     3, 6,  "US-WV F12.XXX"},
        {39.193957,   -79.468395,     3, 9,  "US-WV G12.XXX"},
        {39.193957,   -78.874682,     3, 9,  "US-WV H12.XXX"},
        {38.702917,   -82.5685865,    3, 13, "US-WV J12.XXX"},
        {38.702917,   -81.9800825,    3, 10, "US-WV K12.XXX"},
        {38.702917,   -81.3915785,    3, 7,  "US-WV L12.XXX"},
        {38.702917,   -80.8030745,    3, 7,  "US-WV M12.XXX"},
        {38.702917,   -80.2145705,    3, 6,  "US-WV N12.XXX"},
        {38.702917,   -79.6260665,    3, 8,  "US-WV P12.XXX"},
        {38.211877,   -82.6123645,    3, 9,  "US-WV Q12.XXX"},
        {38.211877,   -82.0389335,    3, 9,  "US-WV R12.XXX"},
        {38.211877,   -81.4504295,    3, 6,  "US-WV S12.XXX"},
        {38.211877,   -80.8619255,    3, 6,  "US-WV T12.XXX"},
        {38.211877,   -80.2734215,    3, 6,  "US-WV V12.XXX"},
        {37.7206745,  -82.308577,     3, 9,  "US-WV W12.XXX"},
        {37.2494395,  -81.7566095,    3, 8,  "US-WV X12.XXX"},
        {37.24739,    -81.2840835,    3, 8,  "US-WV Y12.XXX"},
        {37.720837,   -80.7736255,    3, 6,  "US-WV Z12.XXX"},
        {38.9227415,  -80.181837,     3, 6,  "US-WV H4DJ.S3G"},
        {34.002824,   -81.056804,     5, 9,  "US-SC 00.XX"},
        {32.770004,   -79.990132375,  5, 7,  "US-SC J0.XX"},
        {33.090115,   -80.287955,     4, 6,  "US-SC 12.XXX"},
        {34.026244,   -81.162008,     4, 8,  "US-SC 000.XX"},
        {34.940974,   -81.142279375,  4, 10, "US-SC 600.XX"},
        {34.868974,   -82.511279375,  4, 10, "US-SC C00.XX"},
        {33.935974,   -80.514938,     4, 7,  "US-SC J00.XX"},
        {32.230174,   -80.885491,     4, 9,  "US-SC P00.XX"},
        {34.244574,   -79.916742625,  4, 7,  "US-SC V00.XX"},
        {35.170595,   -83.3321675,    3, 11, "US-SC 012.XXX"},
        {35.170595,   -82.7644955,    3, 11, "US-SC 112.XXX"},
        {35.170595,   -82.1968235,    3, 11, "US-SC 212.XXX"},
        {35.170595,   -81.6291515,    3, 8,  "US-SC 312.XXX"},
        {35.170595,   -81.0614795,    3, 8,  "US-SC 412.XXX"},
        {34.777263,   -83.332454,     4, 10, "US-SC 512.XXX"},
        {34.777263,   -82.76999,      4, 10, "US-SC 612.XXX"},
        {34.777263,   -82.207526,     4, 8,  "US-SC 712.XXX"},
        {34.777263,   -81.645062,     4, 8,  "US-SC 812.XXX"},
        {34.777263,   -81.082598,     4, 10, "US-SC 912.XXX"},
        {34.777263,   -80.520134,     3, 8,  "US-SC B12.XXX"},
        {34.777263,   -79.95767,      3, 8,  "US-SC C12.XXX"},
        {34.777263,   -79.395206,     3, 8,  "US-SC D12.XXX"},
        {34.286223,   -82.826236,     3, 9,  "US-SC F12.XXX"},
        {34.286223,   -82.263772,     3, 7,  "US-SC G12.XXX"},
        {34.286223,   -81.701308,     3, 7,  "US-SC H12.XXX"},
        {34.286223,   -81.138844,     3, 7,  "US-SC J12.XXX"},
        {34.286223,   -80.57638,      3, 6,  "US-SC K12.XXX"},
        {34.286223,   -80.013916,     3, 6,  "US-SC L12.XXX"},
        {34.286223,   -79.451452,     3, 8,  "US-SC M12.XXX"},
        {34.286223,   -79.059522,     4, 9,  "US-SC N12.XXX"},
        {33.795183,   -82.3432195,    3, 9,  "US-SC P12.XXX"},
        {33.795183,   -81.7859635,    3, 9,  "US-SC Q12.XXX"},
        {33.795183,   -81.2287075,    3, 9,  "US-SC R12.XXX"},
        {33.795183,   -80.6714515,    3, 6,  "US-SC S12.XXX"},
        {33.795183,   -80.1141955,    3, 6,  "US-SC T12.XXX"},
        {33.795183,   -79.5569395,    3, 6,  "US-SC V12.XXX"},
        {33.795183,   -79.0546005,    4, 7,  "US-SC W12.XXX"},
        {32.872608,   -81.953003,     3, 8,  "US-SC D123.XX"},
        {32.872608,   -81.400955,     3, 8,  "US-SC F123.XX"},
        {32.872608,   -80.848907,     3, 8,  "US-SC G123.XX"},
        {32.872608,   -80.296859,     4, 6,  "US-SC H123.XX"},
        {32.872608,   -79.744811,     3, 5,  "US-SC J123.XX"},
        {32.872608,   -79.192763,     3, 5,  "US-SC K123.XX"},
        {32.378853,   -81.511364,     3, 8,  "US-SC L123.XX"},
        {32.378853,   -80.959316,     4, 9,  "US-SC M123.XX"},
        {32.378853,   -80.407268,     4, 6,  "US-SC N123.XX"},
        {32.378853,   -79.85522,      3, 5,  "US-SC P123.XX"},
        {32.0461,     -81.2301605,    3, 9,  "US-SC Q123.XX"},
        {32.0461,     -80.6833205,    3, 5,  "US-SC R123.XX"},
        {33.624,      -80.947,        3, 8,  "US-SC PXW5.TJY"},
        {43.6961,     -70.337004,     5, 8,  "US-ME 12.XX"},
        {43.927915,   -70.4728485,    4, 7,  "US-ME 12.XXX"},
        {44.141624,   -70.383454,     4, 7,  "US-ME 000.XX"},
        {44.873924,   -68.939609875,  4, 8,  "US-ME 800.XX"},
        {43.533724,   -70.6365955,    4, 10, "US-ME J00.XX"},
        {44.346404,   -70.002029375,  4, 7,  "US-ME S00.XX"},
        {45.941162,   -70.6875145,    3, 9,  "US-ME 012.XXX"},
        {45.941162,   -70.0260985,    3, 9,  "US-ME 112.XXX"},
        {45.941162,   -69.3646825,    3, 9,  "US-ME 212.XXX"},
        {45.941162,   -68.7032665,    3, 9,  "US-ME 312.XXX"},
        {45.941162,   -68.0418505,    3, 9,  "US-ME 412.XXX"},
        {45.450122,   -71.048236,     3, 9,  "US-ME 512.XXX"},
        {45.450122,   -70.428442,     4, 10, "US-ME 612.XXX"},
        {45.450122,   -69.772234,     3, 9,  "US-ME 712.XXX"},
        {45.450122,   -69.116026,     3, 8,  "US-ME 812.XXX"},
        {45.450122,   -68.459818,     3, 9,  "US-ME 912.XXX"},
        {45.450122,   -67.80361,      3, 11, "US-ME B12.XXX"},
        {45.450122,   -67.505184,     4, 12, "US-ME C12.XXX"},
        {44.959082,   -71.0485225,    3, 9,  "US-ME D12.XXX"},
        {44.959082,   -70.4287285,    3, 6,  "US-ME F12.XXX"},
        {44.959082,   -69.7777285,    3, 6,  "US-ME G12.XXX"},
        {44.959082,   -69.1267285,    3, 6,  "US-ME H12.XXX"},
        {44.959082,   -68.4757285,    3, 7,  "US-ME J12.XXX"},
        {44.959082,   -67.8247285,    3, 9,  "US-ME K12.XXX"},
        {44.959082,   -67.5002625,    4, 10, "US-ME L12.XXX"},
        {44.468042,   -71.014915,     3, 9,  "US-ME M12.XXX"},
        {44.468042,   -70.369123,     3, 6,  "US-ME N12.XXX"},
        {44.468042,   -69.723331,     3, 6,  "US-ME P12.XXX"},
        {44.468042,   -69.077539,     3, 6,  "US-ME Q12.XXX"},
        {44.468042,   -68.431747,     3, 6,  "US-ME R12.XXX"},
        {44.468042,   -67.785955,     3, 6,  "US-ME S12.XXX"},
        {43.977002,   -71.014915,     3, 9,  "US-ME T12.XXX"},
        {43.977002,   -70.369123,     3, 6,  "US-ME V12.XXX"},
        {43.977002,   -69.723331,     3, 6,  "US-ME W12.XXX"},
        {43.977002,   -69.077539,     3, 6,  "US-ME X12.XXX"},
        {43.485962,   -70.9551015,    3, 9,  "US-ME Y12.XXX"},
        {43.0584145,  -70.6211355,    4, 11, "US-ME Z12.XXX"},
        {46.980032,   -69.7817255,    3, 9,  "US-ME K123.XX"},
        {46.980032,   -69.0994775,    3, 8,  "US-ME L123.XX"},
        {46.980032,   -68.4172295,    3, 11, "US-ME M123.XX"},
        {46.488992,   -70.464002,     3, 9,  "US-ME P123.XX"},
        {46.488992,   -69.786962,     3, 9,  "US-ME Q123.XX"},
        {46.488992,   -69.109922,     3, 8,  "US-ME R123.XX"},
        {46.488992,   -68.432882,     3, 11, "US-ME S123.XX"},
        {46.000667,   -70.391147,     3, 9,  "US-ME T123.XX"},
        {46.000667,   -69.724523,     3, 9,  "US-ME X123.XX"},
        {46.000667,   -69.057899,     3, 8,  "US-ME Y123.XX"},
        {46.000667,   -68.391275,     3, 9,  "US-ME Z123.XX"},
        {45.1883435,  -68.984705,     3, 9,  "US-ME XD7L.BTR"},
        {39.8031,     -86.206836,     5, 7,  "US-IN 12.XX"},
        {39.968115,   -86.42683,      4, 6,  "US-IN 12.XXX"},
        {41.103394,   -85.2278485,    4, 6,  "US-IN 000.XX"},
        {41.680494,   -86.39888,      4, 9,  "US-IN 300.XX"},
        {41.680494,   -86.199201,     4, 9,  "US-IN 600.XX"},
        {41.680494,   -85.999522,     4, 9,  "US-IN 900.XX"},
        {38.024645,   -87.650355625,  4, 10, "US-IN D00.XX"},
        {41.577194,   -87.59978,      4, 10, "US-IN H00.XX"},
        {39.159194,   -86.62203825,   4, 6,  "US-IN L00.XX"},
        {41.573514,   -87.42748,      5, 8,  "US-IN P00.XX"},
        {40.181214,   -85.469812375,  4, 6,  "US-IN R00.XX"},
        {40.390914,   -86.965012375,  4, 6,  "US-IN T00.XX"},
        {39.444314,   -87.475132875,  4, 9,  "US-IN W00.XX"},
        {40.079414,   -85.749312375,  4, 6,  "US-IN Y00.XX"},
        {41.715963,   -87.8132935,    3, 13, "US-IN 012.XXX"},
        {41.715963,   -87.1935415,    3, 9,  "US-IN 112.XXX"},
        {41.715963,   -86.5737895,    3, 9,  "US-IN 212.XXX"},
        {41.715963,   -85.9540375,    4, 12, "US-IN 312.XXX"},
        {41.715963,   -85.3656585,    3, 11, "US-IN 412.XXX"},
        {41.224923,   -87.658642,     3, 8,  "US-IN 512.XXX"},
        {41.224923,   -87.044098,     3, 5,  "US-IN 612.XXX"},
        {41.224923,   -86.429554,     3, 5,  "US-IN 712.XXX"},
        {41.224923,   -85.81501,      3, 5,  "US-IN 812.XXX"},
        {41.224923,   -85.360737,     4, 6,  "US-IN 912.XXX"},
        {40.733883,   -87.6537205,    3, 8,  "US-IN B12.XXX"},
        {40.733883,   -87.0443845,    3, 5,  "US-IN C12.XXX"},
        {40.733883,   -86.4350485,    3, 5,  "US-IN D12.XXX"},
        {40.733883,   -85.8257125,    3, 5,  "US-IN F12.XXX"},
        {40.733883,   -85.3558155,    4, 6,  "US-IN G12.XXX"},
        {40.242843,   -87.654007,     3, 8,  "US-IN H12.XXX"},
        {40.242843,   -87.049879,     3, 5,  "US-IN J12.XXX"},
        {40.242843,   -86.445751,     3, 5,  "US-IN K12.XXX"},
        {40.242843,   -85.841623,     3, 5,  "US-IN L12.XXX"},
        {40.242843,   -85.350894,     5, 7,  "US-IN M12.XXX"},
        {39.751803,   -87.6490855,    3, 8,  "US-IN N12.XXX"},
        {39.751803,   -87.0501655,    3, 5,  "US-IN P12.XXX"},
        {39.751803,   -86.4512455,    4, 6,  "US-IN Q12.XXX"},
        {39.751803,   -85.8523255,    3, 5,  "US-IN R12.XXX"},
        {39.751803,   -85.3459725,    4, 6,  "US-IN S12.XXX"},
        {39.260763,   -87.6490855,    3, 8,  "US-IN T12.XXX"},
        {39.260763,   -87.0501655,    3, 5,  "US-IN V12.XXX"},
        {39.260763,   -86.4512455,    3, 5,  "US-IN W12.XXX"},
        {39.260763,   -85.8523255,    3, 5,  "US-IN X12.XXX"},
        {39.260763,   -85.3459725,    4, 6,  "US-IN Y12.XXX"},
        {38.338188,   -87.768622,     4, 12, "US-IN 0123.XX"},
        {38.338188,   -87.17491,      3, 8,  "US-IN 1123.XX"},
        {38.338188,   -86.581198,     3, 8,  "US-IN 2123.XX"},
        {38.338188,   -85.987486,     3, 8,  "US-IN 3123.XX"},
        {38.681916,   -85.393774,     3, 8,  "US-IN 4123.XX"},
        {37.9599335,  -88.0949565,    3, 11, "US-IN 5123.XX"},
        {37.8610155,  -87.7168365,    3, 9,  "US-IN 6123.XX"},
        {37.8630415,  -87.180232,     3, 8,  "US-IN 7123.XX"},
        {37.870223,   -86.6869505,    3, 8,  "US-IN 8123.XX"},
        {38.3037715,  -86.139843,     3, 8,  "US-IN 9123.XX"},
        {39.764184,   -86.438946,     4, 6,  "US-IN 7RJ9.NCX"},
        {38.0684,     -84.5505925,    5, 7,  "US-KY 12.XX"},
        {37.854495,   -84.750643125,  4, 6,  "US-KY 00.XXX"},
        {38.259814,   -85.903477875,  4, 9,  "US-KY J0.XXX"},
        {37.015244,   -86.576005875,  4, 6,  "US-KY 000.XX"},
        {37.779074,   -87.2228055,    4, 7,  "US-KY 600.XX"},
        {39.040574,   -84.59048925,   5, 8,  "US-KY C00.XX"},
        {36.881974,   -87.609499875,  4, 6,  "US-KY J00.XX"},
        {37.763974,   -84.4163055,    4, 6,  "US-KY P00.XX"},
        {39.011774,   -84.82108925,   4, 11, "US-KY V00.XX"},
        {37.6816665,  -89.379968,     3, 11, "US-KY 12.XXXX"},
        {38.969762,   -85.3250795,    3, 10, "US-KY 123.XXX"},
        {37.817,      -85.77,         3, 6,  "US-KY 8H75.SZ6"},
        {35.1851,     -90.0634085,    5, 10, "US-TN 12.XX"},
        {35.130795,   -90.146889875,  4, 9,  "US-TN 00.XXX"},
        {36.175314,   -86.989219375,  4, 6,  "US-TN J0.XXX"},
        {35.986244,   -84.103341625,  4, 7,  "US-TN 000.XX"},
        {35.093874,   -85.331179375,  4, 6,  "US-TN 600.XX"},
        {36.562474,   -87.48109525,   4, 9,  "US-TN C00.XX"},
        {35.861974,   -86.508889625,  4, 6,  "US-TN J00.XX"},
        {35.650274,   -88.932085,     4, 6,  "US-TN P00.XX"},
        {36.386034,   -82.48472125,   4, 9,  "US-TN V00.XX"},
        {35.6300105,  -90.1225935,    3, 9,  "US-TN 12.XXXX"},
        {35.811663,   -85.789855,     3, 5,  "US-TN 123.XXX"},
        {35.8315,     -85.9799505,    3, 5,  "US-TN FVZQ.L0Y"},
        {36.8881,     -76.068152,     5, 7,  "US-VA 12.XX"},
        {37.126815,   -76.4990385,    4, 6,  "US-VA 12.XXX"},
        {38.859804,   -77.251216625,  4, 9,  "US-VA 000.XX"},
        {37.559804,   -77.5685365,    4, 6,  "US-VA 400.XX"},
        {37.285804,   -80.067815875,  4, 7,  "US-VA 800.XX"},
        {36.730304,   -76.71479525,   4, 6,  "US-VA D00.XX"},
        {37.373094,   -79.2854595,    4, 7,  "US-VA J00.XX"},
        {38.800194,   -77.471414625,  4, 9,  "US-VA M00.XX"},
        {38.633594,   -77.402114625,  4, 9,  "US-VA Q00.XX"},
        {38.948294,   -77.46313825,   4, 9,  "US-VA T00.XX"},
        {38.449394,   -78.959414625,  4, 10, "US-VA X00.XX"},
        {39.421095,   -78.5388805,    3, 11, "US-VA 012.XXX"},
        {39.166208,   -77.9411705,    3, 11, "US-VA 112.XXX"},
        {38.934523,   -79.737007,     3, 8,  "US-VA 212.XXX"},
        {38.934523,   -79.143295,     3, 11, "US-VA 312.XXX"},
        {38.934523,   -78.549583,     3, 11, "US-VA 412.XXX"},
        {38.934523,   -77.955871,     3, 9,  "US-VA 512.XXX"},
        {38.934523,   -77.362159,     4, 9,  "US-VA 612.XXX"},
        {38.443483,   -79.9695695,    3, 8,  "US-VA 712.XXX"},
        {38.443483,   -79.3810655,    3, 11, "US-VA 812.XXX"},
        {38.443483,   -78.7925615,    4, 10, "US-VA 912.XXX"},
        {38.443483,   -78.2040575,    3, 9,  "US-VA B12.XXX"},
        {38.443483,   -77.6155535,    3, 8,  "US-VA C12.XXX"},
        {38.443483,   -77.0270495,    3, 8,  "US-VA D12.XXX"},
        {38.443483,   -76.4385455,    3, 8,  "US-VA F12.XXX"},
        {37.952443,   -80.2991325,    3, 8,  "US-VA G12.XXX"},
        {37.952443,   -79.7106285,    3, 6,  "US-VA H12.XXX"},
        {37.952443,   -79.1221245,    3, 9,  "US-VA J12.XXX"},
        {37.952443,   -78.5336205,    3, 9,  "US-VA K12.XXX"},
        {37.952443,   -77.9451165,    3, 9,  "US-VA L12.XXX"},
        {37.952443,   -77.3566125,    3, 8,  "US-VA M12.XXX"},
        {37.952443,   -76.7681085,    3, 8,  "US-VA N12.XXX"},
        {37.952443,   -76.1796045,    3, 8,  "US-VA P12.XXX"},
        {37.981905,   -75.7225695,    4, 9,  "US-VA Q12.XXX"},
        {37.461403,   -77.910092,     4, 7,  "US-VA R12.XXX"},
        {37.461403,   -77.326796,     3, 5,  "US-VA S12.XXX"},
        {37.461403,   -76.7435,       3, 5,  "US-VA T12.XXX"},
        {37.461403,   -76.160204,     3, 5,  "US-VA V12.XXX"},
        {36.975635,   -77.9051705,    3, 5,  "US-VA W12.XXX"},
        {36.975635,   -77.3270825,    3, 5,  "US-VA X12.XXX"},
        {36.975635,   -76.7489945,    3, 5,  "US-VA Y12.XXX"},
        {36.975635,   -76.1709065,    4, 6,  "US-VA Z12.XXX"},
        {37.058675,   -83.109609,     3, 8,  "US-VA 1123.XX"},
        {37.058675,   -82.526313,     3, 8,  "US-VA 2123.XX"},
        {37.058675,   -81.943017,     3, 5,  "US-VA 3123.XX"},
        {37.058675,   -81.359721,     3, 5,  "US-VA 4123.XX"},
        {36.57035,    -83.6721265,    3, 12, "US-VA 5123.XX"},
        {36.57035,    -83.1096375,    4, 13, "US-VA 6123.XX"},
        {36.57035,    -82.5315495,    3, 14, "US-VA 7123.XX"},
        {36.57035,    -81.9534615,    3, 11, "US-VA 8123.XX"},
        {36.57035,    -81.3753735,    3, 8,  "US-VA 9123.XX"},
        {37.039033,   -80.802465,     4, 6,  "US-VA B123.XX"},
        {37.039033,   -80.219169,     3, 5,  "US-VA C123.XX"},
        {37.039033,   -79.635873,     3, 5,  "US-VA D123.XX"},
        {37.039033,   -79.052577,     3, 5,  "US-VA F123.XX"},
        {37.039033,   -78.469281,     3, 5,  "US-VA G123.XX"},
        {36.550708,   -80.7972855,    3, 8,  "US-VA H123.XX"},
        {36.550708,   -80.2191975,    3, 8,  "US-VA J123.XX"},
        {36.550708,   -79.6411095,    3, 8,  "US-VA K123.XX"},
        {36.550708,   -79.0630215,    3, 8,  "US-VA L123.XX"},
        {36.550708,   -78.4849335,    3, 8,  "US-VA M123.XX"},
        {37.99825,    -79.420865,     3, 9,  "US-VA J4J1.2CB"},
        {39.9961,     -83.0477765,    5, 7,  "US-OH 12.XX"},
        {40.101728,   -83.185810125,  4, 6,  "US-OH 00.XXX"},
        {41.424591,   -81.8800825,    4, 6,  "US-OH J0.XXX"},
        {39.774974,   -84.291822875,  5, 7,  "US-OH 000.XX"},
        {39.272268,   -84.58075825,   4, 6,  "US-OH 500.XX"},
        {39.406545,   -84.60371125,   4, 6,  "US-OH B00.XX"},
        {41.650776,   -83.681792,     4, 6,  "US-OH H00.XX"},
        {41.086804,   -81.6332995,    4, 6,  "US-OH M00.XX"},
        {40.839399,   -81.521123875,  4, 6,  "US-OH R00.XX"},
        {41.105804,   -80.7917455,    4, 6,  "US-OH W00.XX"},
        {41.689075,   -84.7841045,    3, 11, "US-OH 112.XXX"},
        {41.689075,   -84.1643525,    3, 8,  "US-OH 212.XXX"},
        {41.689075,   -83.5446005,    4, 9,  "US-OH 312.XXX"},
        {41.689075,   -82.9248485,    3, 8,  "US-OH 412.XXX"},
        {41.934595,   -82.310018,     3, 9,  "US-OH 512.XXX"},
        {41.934595,   -81.685058,     3, 8,  "US-OH 612.XXX"},
        {41.934595,   -81.10058,      4, 9,  "US-OH 712.XXX"},
        {41.453375,   -84.7929065,    4, 9,  "US-OH 812.XXX"},
        {41.453375,   -84.1851845,    4, 6,  "US-OH 912.XXX"},
        {41.453375,   -83.5654325,    4, 6,  "US-OH B12.XXX"},
        {41.453375,   -82.9456805,    4, 6,  "US-OH C12.XXX"},
        {41.453375,   -82.3259285,    3, 5,  "US-OH D12.XXX"},
        {41.453375,   -81.7061765,    4, 6,  "US-OH F12.XXX"},
        {41.453375,   -81.0956585,    3, 5,  "US-OH G12.XXX"},
        {40.962335,   -84.793193,     3, 8,  "US-OH H12.XXX"},
        {40.962335,   -84.190679,     3, 5,  "US-OH J12.XXX"},
        {40.962335,   -83.576135,     3, 5,  "US-OH K12.XXX"},
        {40.962335,   -82.961591,     3, 5,  "US-OH L12.XXX"},
        {40.962335,   -82.347047,     3, 5,  "US-OH M12.XXX"},
        {40.962335,   -81.732503,     3, 5,  "US-OH N12.XXX"},
        {40.962335,   -81.117959,     3, 5,  "US-OH P12.XXX"},
        {40.471295,   -84.7934795,    3, 8,  "US-OH Q12.XXX"},
        {40.471295,   -84.2216925,    4, 6,  "US-OH R12.XXX"},
        {40.471295,   -83.6123565,    3, 5,  "US-OH S12.XXX"},
        {40.471295,   -83.0030205,    3, 5,  "US-OH T12.XXX"},
        {40.471295,   -82.3936845,    3, 6,  "US-OH X12.XXX"},
        {40.471295,   -81.7843485,    3, 6,  "US-OH Y12.XXX"},
        {40.471295,   -81.1750125,    3, 6,  "US-OH Z12.XXX"},
        {39.546005,   -84.823694,     3, 8,  "US-OH 1123.XX"},
        {39.546005,   -84.318049,     4, 6,  "US-OH 2123.XX"},
        {39.546005,   -83.713921,     3, 5,  "US-OH 3123.XX"},
        {39.546005,   -83.109793,     3, 5,  "US-OH 4123.XX"},
        {39.546005,   -82.505665,     3, 6,  "US-OH 5123.XX"},
        {39.546005,   -81.901537,     3, 6,  "US-OH 6123.XX"},
        {39.546005,   -81.297409,     3, 8,  "US-OH 7123.XX"},
        {39.05768,    -84.8237225,    3, 12, "US-OH 8123.XX"},
        {39.05768,    -84.3784905,    4, 10, "US-OH 9123.XX"},
        {39.05768,    -83.7795705,    3, 8,  "US-OH B123.XX"},
        {39.05768,    -83.1806505,    3, 9,  "US-OH C123.XX"},
        {39.05768,    -82.5817305,    3, 10, "US-OH D123.XX"},
        {39.05768,    -81.9828105,    4, 13, "US-OH F123.XX"},
        {39.05768,    -81.3838905,    3, 9,  "US-OH G123.XX"},
        {38.56664,    -84.438411,     3, 8,  "US-OH H123.XX"},
        {38.56664,    -83.844699,     3, 8,  "US-OH J123.XX"},
        {38.56664,    -83.250987,     3, 9,  "US-OH K123.XX"},
        {38.56664,    -82.657275,     4, 10, "US-OH L123.XX"},
        {38.861264,   -82.0635345,    3, 12, "US-OH M123.XX"},
        {38.4141,     -82.842159,     3, 9,  "US-OH N123.XX"},
        {40.19,       -82.6685,       3, 5,  "US-OH D4ML.9H6"},
        {39.9871,     -75.2352765,    6, 11, "US-PA 12.XX"},
        {40.003455,   -75.371016875,  4, 9,  "US-PA 00.XXX"},
        {40.351215,   -80.185737875,  4, 7,  "US-PA C0.XXX"},
        {40.513425,   -75.640331375,  4, 7,  "US-PA P0.XXX"},
        {40.388074,   -76.050267375,  4, 6,  "US-PA 000.XX"},
        {41.424374,   -75.7768465,    4, 7,  "US-PA 500.XX"},
        {41.339395,   -76.0236085,    4, 7,  "US-PA B00.XX"},
        {40.168845,   -76.433083875,  4, 6,  "US-PA H00.XX"},
        {40.194045,   -74.991906875,  4, 9,  "US-PA M00.XX"},
        {40.319045,   -77.016383875,  4, 6,  "US-PA R00.XX"},
        {42.160545,   -80.2474975,    4, 9,  "US-PA W00.XX"},
        {42.106725,   -80.4855,       3, 8,  "US-PA 112.XXX"},
        {42.106725,   -79.86054,      4, 9,  "US-PA 212.XXX"},
        {42.327693,   -80.341759,     3, 8,  "US-PA 012.XXX"},
        {41.959413,   -79.23558,      3, 11, "US-PA 312.XXX"},
        {41.959413,   -78.61062,      3, 10, "US-PA 412.XXX"},
        {41.959413,   -77.98566,      3, 10, "US-PA 512.XXX"},
        {41.959413,   -77.3607,       3, 10, "US-PA 612.XXX"},
        {41.959413,   -76.73574,      3, 10, "US-PA 712.XXX"},
        {41.959413,   -76.11078,      3, 10, "US-PA 812.XXX"},
        {41.959413,   -75.48582,      3, 10, "US-PA 912.XXX"},
        {41.615685,   -80.4858065,    3, 5,  "US-PA B12.XXX"},
        {41.615685,   -79.8733255,    3, 5,  "US-PA C12.XXX"},
        {41.615685,   -79.2535735,    4, 7,  "US-PA D12.XXX"},
        {41.615685,   -78.6338215,    4, 7,  "US-PA F12.XXX"},
        {41.615685,   -78.0140695,    4, 7,  "US-PA G12.XXX"},
        {41.615685,   -77.3943175,    4, 7,  "US-PA H12.XXX"},
        {41.615685,   -76.7745655,    4, 7,  "US-PA J12.XXX"},
        {41.615685,   -76.1548135,    4, 7,  "US-PA K12.XXX"},
        {41.615685,   -75.5350615,    4, 7,  "US-PA L12.XXX"},
        {41.124645,   -80.486093,     3, 5,  "US-PA M12.XXX"},
        {41.124645,   -79.87882,      3, 5,  "US-PA N12.XXX"},
        {41.124645,   -79.264276,     3, 6,  "US-PA P12.XXX"},
        {41.124645,   -78.649732,     3, 6,  "US-PA Q12.XXX"},
        {41.124645,   -78.035188,     3, 6,  "US-PA R12.XXX"},
        {41.124645,   -77.420644,     3, 6,  "US-PA S12.XXX"},
        {41.124645,   -76.8061,       3, 6,  "US-PA T12.XXX"},
        {41.124645,   -76.191556,     3, 6,  "US-PA V12.XXX"},
        {41.124645,   -75.577012,     3, 9,  "US-PA W12.XXX"},
        {41.492925,   -75.2756585,    4, 9,  "US-PA X12.XXX"},
        {40.199355,   -80.5165655,    3, 9,  "US-PA 1123.XX"},
        {40.199355,   -79.9127815,    4, 7,  "US-PA 2123.XX"},
        {40.199355,   -79.3034455,    3, 6,  "US-PA 3123.XX"},
        {40.199355,   -78.6941095,    3, 6,  "US-PA 4123.XX"},
        {40.199355,   -78.0847735,    3, 6,  "US-PA 5123.XX"},
        {40.199355,   -77.4754375,    3, 5,  "US-PA 6123.XX"},
        {40.199355,   -76.8661015,    4, 6,  "US-PA 7123.XX"},
        {40.199355,   -76.2567655,    3, 5,  "US-PA 8123.XX"},
        {40.199355,   -75.6474295,    3, 5,  "US-PA 9123.XX"},
        {39.711385,   -80.516594,     3, 9,  "US-PA B123.XX"},
        {39.711385,   -79.918018,     4, 10, "US-PA C123.XX"},
        {39.711385,   -79.31389,      3, 11, "US-PA D123.XX"},
        {39.711385,   -78.709762,     3, 11, "US-PA F123.XX"},
        {39.711385,   -78.105634,     3, 9,  "US-PA G123.XX"},
        {39.711385,   -77.501506,     3, 8,  "US-PA H123.XX"},
        {39.711385,   -76.897378,     3, 8,  "US-PA J123.XX"},
        {39.711385,   -76.29325,      3, 8,  "US-PA K123.XX"},
        {39.711385,   -75.689122,     3, 12, "US-PA L123.XX"},
        {39.953835,   -75.2960015,    5, 10, "US-PA M123.XX"},
        {41.036549,   -77.60495,      3, 6,  "US-PA L79Q.ZXY"},
        {32.347099,   -90.250026,     5, 8,  "US-MS 12.XX"},
        {32.404294,   -90.355337,     4, 7,  "US-MS 00.XXX"},
        {30.348405,   -89.200325625,  4, 9,  "US-MS J0.XXX"},
        {34.982545,   -90.115566875,  4, 12, "US-MS 000.XX"},
        {31.349444,   -89.4549795,    4, 7,  "US-MS 700.XX"},
        {32.405944,   -88.817056,     4, 7,  "US-MS F00.XX"},
        {34.275644,   -88.806289625,  4, 6,  "US-MS M00.XX"},
        {33.433044,   -91.113825375,  4, 10, "US-MS T00.XX"},
        {34.951595,   -90.781362,     3, 8,  "US-MS 012.XXX"},
        {34.951595,   -90.218898,     3, 8,  "US-MS 112.XXX"},
        {34.951595,   -89.656434,     3, 6,  "US-MS 212.XXX"},
        {34.951595,   -89.09397,      3, 5,  "US-MS 312.XXX"},
        {34.951595,   -88.628522,     4, 6,  "US-MS 412.XXX"},
        {34.482651,   -90.927602,     3, 8,  "US-MS 512.XXX"},
        {34.482651,   -90.365138,     3, 8,  "US-MS 612.XXX"},
        {34.482651,   -89.802674,     3, 6,  "US-MS 712.XXX"},
        {34.482651,   -89.24021,      3, 5,  "US-MS 812.XXX"},
        {34.482651,   -88.677746,     3, 5,  "US-MS 912.XXX"},
        {33.991611,   -91.4851445,    3, 8,  "US-MS B12.XXX"},
        {33.991611,   -90.9278885,    3, 8,  "US-MS C12.XXX"},
        {33.991611,   -90.3706325,    3, 6,  "US-MS D12.XXX"},
        {33.991611,   -89.8133765,    3, 6,  "US-MS F12.XXX"},
        {33.991611,   -89.2561205,    3, 5,  "US-MS G12.XXX"},
        {33.991611,   -88.6988645,    3, 5,  "US-MS H12.XXX"},
        {33.500571,   -91.4851445,    3, 8,  "US-MS K12.XXX"},
        {33.500571,   -90.9278885,    4, 7,  "US-MS L12.XXX"},
        {33.500571,   -90.3706325,    3, 6,  "US-MS M12.XXX"},
        {33.500571,   -89.8133765,    3, 6,  "US-MS N12.XXX"},
        {33.500571,   -89.2561205,    3, 5,  "US-MS P12.XXX"},
        {33.500571,   -88.6988645,    3, 5,  "US-MS Q12.XXX"},
        {33.009531,   -91.485431,     3, 11, "US-MS R12.XXX"},
        {33.009531,   -90.933383,     3, 11, "US-MS S12.XXX"},
        {33.009531,   -90.381335,     3, 7,  "US-MS T12.XXX"},
        {33.009531,   -89.829287,     3, 7,  "US-MS X12.XXX"},
        {33.009531,   -89.277239,     3, 6,  "US-MS Y12.XXX"},
        {33.009531,   -88.725191,     3, 5,  "US-MS Z12.XXX"},
        {32.084241,   -91.652979,     3, 8,  "US-MS 1123.XX"},
        {32.084241,   -91.103712,     3, 8,  "US-MS 2123.XX"},
        {32.084241,   -90.551664,     3, 6,  "US-MS 3123.XX"},
        {32.084241,   -89.999616,     3, 6,  "US-MS 4123.XX"},
        {32.084241,   -89.447568,     3, 6,  "US-MS 5123.XX"},
        {32.084241,   -88.89552,      3, 6,  "US-MS 6123.XX"},
        {31.595916,   -91.6505805,    3, 8,  "US-MS 7123.XX"},
        {31.595916,   -91.1037405,    3, 8,  "US-MS 8123.XX"},
        {31.595916,   -90.5569005,    3, 6,  "US-MS 9123.XX"},
        {31.595916,   -90.0100605,    3, 6,  "US-MS B123.XX"},
        {31.595916,   -89.4632205,    3, 6,  "US-MS C123.XX"},
        {31.595916,   -88.9163805,    3, 6,  "US-MS D123.XX"},
        {31.102161,   -91.6505805,    3, 8,  "US-MS F123.XX"},
        {31.102161,   -91.1037405,    3, 8,  "US-MS G123.XX"},
        {31.102161,   -90.5569005,    3, 6,  "US-MS K123.XX"},
        {31.102161,   -90.0100605,    3, 6,  "US-MS L123.XX"},
        {31.102161,   -89.4632205,    3, 6,  "US-MS M123.XX"},
        {31.102161,   -88.9163805,    3, 6,  "US-MS N123.XX"},
        {30.611121,   -91.650609,     3, 8,  "US-MS P123.XX"},
        {30.611121,   -91.108977,     3, 9,  "US-MS Q123.XX"},
        {30.611121,   -90.567345,     3, 8,  "US-MS R123.XX"},
        {30.611121,   -90.025713,     3, 8,  "US-MS S123.XX"},
        {30.611121,   -89.484081,     4, 7,  "US-MS T123.XX"},
        {30.611121,   -88.942449,     4, 7,  "US-MS V123.XX"},
        {30.1591,     -89.8580435,    3, 8,  "US-MS X123.XX"},
        {30.1591,     -89.3216195,    3, 8,  "US-MS Y123.XX"},
        {30.1591,     -88.7851955,    3, 6,  "US-MS Z123.XX"},
        {32.571,      -89.8765,       3, 6,  "US-MS 7M00.272"},
        {29.9511,     -90.1558825,    5, 7,  "US-LA 12.XX"},
        {30.047294,   -90.272671625,  4, 6,  "US-LA 00.XXX"},
        {30.454414,   -91.272147875,  4, 7,  "US-LA J0.XXX"},
        {32.526024,   -93.882501,     4, 7,  "US-LA 000.XX"},
        {30.252524,   -92.160844125,  4, 6,  "US-LA 800.XX"},
        {30.280624,   -93.398944125,  4, 6,  "US-LA J00.XX"},
        {32.609934,   -92.253461,     4, 6,  "US-LA S00.XX"},
        {32.974595,   -94.013631,     3, 7,  "US-LA 012.XXX"},
        {32.974595,   -93.516787,     4, 7,  "US-LA 112.XXX"},
        {32.974595,   -92.964739,     3, 5,  "US-LA 212.XXX"},
        {32.974595,   -92.412691,     3, 5,  "US-LA 312.XXX"},
        {32.974595,   -91.860643,     3, 5,  "US-LA 412.XXX"},
        {32.974595,   -91.308595,     3, 8,  "US-LA 512.XXX"},
        {32.483555,   -94.013631,     3, 7,  "US-LA 612.XXX"},
        {32.483555,   -93.516787,     4, 7,  "US-LA 712.XXX"},
        {32.483555,   -92.964739,     3, 5,  "US-LA 812.XXX"},
        {32.483555,   -92.412691,     3, 5,  "US-LA 912.XXX"},
        {32.483555,   -91.860643,     3, 5,  "US-LA B12.XXX"},
        {32.483555,   -91.308595,     3, 8,  "US-LA C12.XXX"},
        {31.992515,   -94.0139175,    3, 7,  "US-LA D12.XXX"},
        {31.992515,   -93.5170735,    4, 8,  "US-LA F12.XXX"},
        {31.992515,   -92.9702335,    3, 5,  "US-LA G12.XXX"},
        {31.992515,   -92.4233935,    3, 5,  "US-LA H12.XXX"},
        {31.992515,   -91.8765535,    3, 5,  "US-LA J12.XXX"},
        {31.992515,   -91.3297135,    3, 8,  "US-LA K12.XXX"},
        {31.501475,   -93.7904935,    3, 8,  "US-LA L12.XXX"},
        {31.501475,   -93.2436535,    3, 5,  "US-LA M12.XXX"},
        {31.501475,   -92.6968135,    3, 5,  "US-LA N12.XXX"},
        {31.501475,   -92.1499735,    3, 5,  "US-LA P12.XXX"},
        {31.501475,   -91.6031335,    3, 8,  "US-LA Q12.XXX"},
        {31.010435,   -93.79078,      3, 8,  "US-LA R12.XXX"},
        {31.010435,   -93.249148,     3, 5,  "US-LA S12.XXX"},
        {31.010435,   -92.707516,     3, 5,  "US-LA T12.XXX"},
        {31.010435,   -92.165884,     3, 5,  "US-LA V12.XXX"},
        {31.010435,   -91.624252,     3, 8,  "US-LA W12.XXX"},
        {31.010435,   -91.08262,      3, 8,  "US-LA X12.XXX"},
        {31.010435,   -90.540988,     3, 8,  "US-LA Y12.XXX"},
        {31.010435,   -89.999356,     3, 8,  "US-LA Z12.XXX"},
        {30.107555,   -93.7858585,    3, 8,  "US-LA 01.XXXX"},
        {30.107555,   -93.2494345,    3, 5,  "US-LA 11.XXXX"},
        {30.107555,   -92.7130105,    3, 5,  "US-LA 21.XXXX"},
        {30.107555,   -92.1765865,    3, 5,  "US-LA 31.XXXX"},
        {30.107555,   -91.6401625,    3, 5,  "US-LA 41.XXXX"},
        {30.107555,   -91.1037385,    3, 5,  "US-LA 51.XXXX"},
        {30.107555,   -90.5673145,    3, 5,  "US-LA 61.XXXX"},
        {30.107555,   -90.0308905,    4, 6,  "US-LA 71.XXXX"},
        {30.107555,   -89.4944665,    3, 5,  "US-LA 81.XXXX"},
        {29.616515,   -94.0144905,    3, 8,  "US-LA 91.XXXX"},
        {29.616515,   -93.5176465,    4, 7,  "US-LA B1.XXXX"},
        {29.616515,   -92.9812225,    3, 5,  "US-LA C1.XXXX"},
        {29.616515,   -92.4447985,    3, 5,  "US-LA D1.XXXX"},
        {29.616515,   -91.9083745,    3, 5,  "US-LA F1.XXXX"},
        {29.616515,   -91.3719505,    3, 5,  "US-LA G1.XXXX"},
        {29.616515,   -90.8355265,    3, 5,  "US-LA H1.XXXX"},
        {29.616515,   -90.2991025,    3, 5,  "US-LA J1.XXXX"},
        {29.616515,   -89.7626785,    3, 5,  "US-LA K1.XXXX"},
        {29.616515,   -89.2649145,    4, 6,  "US-LA L1.XXXX"},
        {29.125475,   -92.981509,     3, 5,  "US-LA M1.XXXX"},
        {29.125475,   -92.450293,     3, 5,  "US-LA N1.XXXX"},
        {29.125475,   -91.919077,     3, 5,  "US-LA P1.XXXX"},
        {29.125475,   -91.387861,     3, 5,  "US-LA Q1.XXXX"},
        {29.125475,   -90.856645,     4, 6,  "US-LA R1.XXXX"},
        {29.125475,   -90.325429,     4, 6,  "US-LA S1.XXXX"},
        {29.125475,   -89.794213,     4, 6,  "US-LA T1.XXXX"},
        {29.125475,   -89.262997,     4, 6,  "US-LA V1.XXXX"},
        {28.887795,   -91.122253,     3, 5,  "US-LA W1.XXXX"},
        {28.887795,   -90.591037,     3, 5,  "US-LA X1.XXXX"},
        {28.887795,   -90.059821,     3, 5,  "US-LA Y1.XXXX"},
        {28.887795,   -89.528605,     3, 5,  "US-LA Z1.XXXX"},
        {30.937,      -91.401,        3, 8,  "US-LA 53JK.D1Q"},
        {33.5521,     -86.8435665,    5, 7,  "US-AL 12.XX"},
        {33.416394,   -87.003690375,  4, 6,  "US-AL 00.XXX"},
        {32.297125,   -86.481311,     4, 6,  "US-AL C0.XXX"},
        {34.825084,   -86.793357875,  4, 6,  "US-AL P0.XXX"},
        {30.727504,   -88.278848875,  4, 7,  "US-AL 000.XX"},
        {33.235544,   -87.685325375,  4, 6,  "US-AL 700.XX"},
        {31.246644,   -85.5044795,    4, 7,  "US-AL F00.XX"},
        {34.593744,   -87.116589625,  5, 7,  "US-AL M00.XX"},
        {32.635244,   -85.555256,     4, 9,  "US-AL T00.XX"},
        {34.9457135,  -88.215026,     3, 8,  "US-AL 012.XXX"},
        {34.9457135,  -87.647354,     3, 5,  "US-AL 112.XXX"},
        {34.9457135,  -87.079682,     3, 5,  "US-AL 212.XXX"},
        {34.9457135,  -86.51201,      3, 5,  "US-AL 312.XXX"},
        {34.9457135,  -85.944338,     3, 5,  "US-AL 412.XXX"},
        {34.560942,   -88.186001,     4, 9,  "US-AL 512.XXX"},
        {34.560942,   -87.623537,     4, 6,  "US-AL 612.XXX"},
        {34.560942,   -87.061073,     5, 7,  "US-AL 712.XXX"},
        {34.560942,   -86.498609,     4, 6,  "US-AL 812.XXX"},
        {34.560942,   -85.936145,     4, 6,  "US-AL 912.XXX"},
        {34.069902,   -88.360365,     3, 8,  "US-AL B12.XXX"},
        {34.069902,   -87.797901,     3, 5,  "US-AL C12.XXX"},
        {34.069902,   -87.235437,     3, 5,  "US-AL D12.XXX"},
        {34.069902,   -86.672973,     3, 5,  "US-AL F12.XXX"},
        {34.069902,   -86.110509,     3, 5,  "US-AL G12.XXX"},
        {34.069902,   -85.548045,     3, 8,  "US-AL K12.XXX"},
        {33.578862,   -88.3554435,    3, 8,  "US-AL L12.XXX"},
        {33.578862,   -87.7981875,    3, 5,  "US-AL M12.XXX"},
        {33.578862,   -87.2409315,    3, 5,  "US-AL N12.XXX"},
        {33.578862,   -86.6836755,    4, 6,  "US-AL P12.XXX"},
        {33.578862,   -86.1264195,    3, 5,  "US-AL Q12.XXX"},
        {33.578862,   -85.5691635,    3, 8,  "US-AL R12.XXX"},
        {33.087822,   -88.35573,      3, 8,  "US-AL S12.XXX"},
        {33.087822,   -87.803682,     3, 5,  "US-AL T12.XXX"},
        {33.087822,   -87.251634,     3, 5,  "US-AL V12.XXX"},
        {33.087822,   -86.699586,     3, 5,  "US-AL X12.XXX"},
        {33.087822,   -86.147538,     3, 5,  "US-AL Y12.XXX"},
        {33.087822,   -85.59549,      3, 8,  "US-AL Z12.XXX"},
        {32.162532,   -88.471979,     3, 8,  "US-AL 0123.XX"},
        {32.162532,   -87.919931,     3, 5,  "US-AL 1123.XX"},
        {32.162532,   -87.367883,     3, 5,  "US-AL 2123.XX"},
        {32.162532,   -86.815835,     3, 5,  "US-AL 3123.XX"},
        {32.162532,   -86.263787,     3, 5,  "US-AL 4123.XX"},
        {32.162532,   -85.711739,     3, 5,  "US-AL 5123.XX"},
        {32.20966,    -85.18988,      4, 9,  "US-AL 6123.XX"},
        {31.674207,   -88.4680595,    3, 8,  "US-AL 7123.XX"},
        {31.674207,   -87.9212195,    3, 5,  "US-AL 8123.XX"},
        {31.674207,   -87.3743795,    3, 5,  "US-AL 9123.XX"},
        {31.674207,   -86.8275395,    3, 5,  "US-AL B123.XX"},
        {31.674207,   -86.2806995,    3, 5,  "US-AL C123.XX"},
        {31.674207,   -85.7338595,    3, 5,  "US-AL D123.XX"},
        {31.180452,   -88.4680595,    3, 8,  "US-AL G123.XX"},
        {31.180452,   -87.9212195,    3, 5,  "US-AL H123.XX"},
        {31.180452,   -87.3743795,    3, 5,  "US-AL J123.XX"},
        {31.180452,   -86.8275395,    3, 5,  "US-AL K123.XX"},
        {31.180452,   -86.2806995,    3, 5,  "US-AL L123.XX"},
        {31.180452,   -85.7338595,    3, 5,  "US-AL M123.XX"},
        {31.4997575,  -85.1899655,    3, 8,  "US-AL P123.XX"},
        {30.689412,   -88.461255,     3, 8,  "US-AL Q123.XX"},
        {30.689412,   -87.919623,     3, 5,  "US-AL R123.XX"},
        {31.1170675,  -87.34527,      3, 5,  "US-AL S123.XX"},
        {31.1170675,  -86.2499275,    3, 5,  "US-AL T123.XX"},
        {30.201087,   -88.4263895,    3, 8,  "US-AL X123.XX"},
        {30.201087,   -87.8899655,    3, 5,  "US-AL Z123.XX"},
        {32.576,      -86.6815,       3, 5,  "US-AL DT3G.L7M"},
        {34.7897,     -92.3349085,    5, 7,  "US-AR 12.XX"},
        {35.997395,   -94.332164625,  4, 8,  "US-AR 00.XXX"},
        {34.763914,   -92.491513375,  4, 6,  "US-AR J0.XXX"},
        {35.409324,   -94.508635,     3, 9,  "US-AR 000.XX"},
        {35.883624,   -90.854453625,  4, 6,  "US-AR 800.XX"},
        {35.106224,   -92.562915375,  4, 6,  "US-AR J00.XX"},
        {34.271704,   -92.160566625,  4, 6,  "US-AR S00.XX"},
        {36.454595,   -94.586485,     3, 10, "US-AR 012.XXX"},
        {36.454595,   -94.013605,     3, 7,  "US-AR 112.XXX"},
        {36.454595,   -93.440725,     3, 6,  "US-AR 212.XXX"},
        {36.454595,   -92.867845,     3, 6,  "US-AR 312.XXX"},
        {36.454595,   -92.294965,     3, 6,  "US-AR 412.XXX"},
        {36.454595,   -91.722085,     3, 8,  "US-AR 512.XXX"},
        {36.454595,   -91.149205,     3, 8,  "US-AR 612.XXX"},
        {36.454595,   -90.576325,     3, 8,  "US-AR 712.XXX"},
        {35.963555,   -94.586484,     3, 9,  "US-AR 812.XXX"},
        {35.963555,   -94.013604,     3, 6,  "US-AR 912.XXX"},
        {35.963555,   -93.440724,     3, 5,  "US-AR B12.XXX"},
        {35.963555,   -92.867844,     3, 5,  "US-AR C12.XXX"},
        {35.963555,   -92.294964,     3, 5,  "US-AR D12.XXX"},
        {35.963555,   -91.722084,     3, 5,  "US-AR F12.XXX"},
        {35.963555,   -91.149204,     3, 5,  "US-AR G12.XXX"},
        {35.963555,   -90.576324,     4, 6,  "US-AR H12.XXX"},
        {35.963555,   -90.185365,     4, 9,  "US-AR J12.XXX"},
        {35.472515,   -94.4383425,    4, 10, "US-AR K12.XXX"},
        {35.472515,   -93.8706705,    3, 6,  "US-AR L12.XXX"},
        {35.472515,   -93.3029985,    3, 5,  "US-AR M12.XXX"},
        {35.472515,   -92.7353265,    3, 5,  "US-AR N12.XXX"},
        {35.472515,   -92.1676545,    3, 5,  "US-AR P12.XXX"},
        {35.472515,   -91.5999825,    3, 5,  "US-AR Q12.XXX"},
        {35.472515,   -91.0323105,    3, 5,  "US-AR R12.XXX"},
        {35.472515,   -90.4646385,    3, 5,  "US-AR S12.XXX"},
        {34.981475,   -94.580547,     3, 9,  "US-AR T12.XXX"},
        {34.981475,   -94.018083,     3, 6,  "US-AR V12.XXX"},
        {34.981475,   -93.455619,     3, 5,  "US-AR W12.XXX"},
        {34.981475,   -92.893155,     3, 5,  "US-AR X12.XXX"},
        {34.981475,   -92.330691,     4, 6,  "US-AR Y12.XXX"},
        {34.981475,   -91.768227,     3, 5,  "US-AR Z12.XXX"},
        {34.569635,   -91.205763,     3, 6,  "US-AR 01.XXXX"},
        {34.569635,   -90.643299,     3, 8,  "US-AR 11.XXXX"},
        {34.078595,   -94.580547,     3, 9,  "US-AR 21.XXXX"},
        {34.078595,   -94.018083,     3, 6,  "US-AR 31.XXXX"},
        {34.078595,   -93.455619,     3, 5,  "US-AR 41.XXXX"},
        {34.078595,   -92.893155,     3, 5,  "US-AR 51.XXXX"},
        {34.078595,   -92.330691,     3, 5,  "US-AR 61.XXXX"},
        {34.078595,   -91.768227,     3, 5,  "US-AR 71.XXXX"},
        {34.078595,   -91.205763,     3, 6,  "US-AR 81.XXXX"},
        {34.078595,   -90.643299,     3, 8,  "US-AR 91.XXXX"},
        {33.587555,   -94.5756255,    3, 7,  "US-AR B1.XXXX"},
        {33.587555,   -94.0183695,    3, 7,  "US-AR C1.XXXX"},
        {33.587555,   -93.4611135,    3, 5,  "US-AR D1.XXXX"},
        {33.587555,   -92.9038575,    3, 5,  "US-AR F1.XXXX"},
        {33.587555,   -92.3466015,    3, 5,  "US-AR G1.XXXX"},
        {33.587555,   -91.7893455,    3, 5,  "US-AR H1.XXXX"},
        {33.587555,   -91.2320895,    3, 8,  "US-AR J1.XXXX"},
        {33.096515,   -94.3638685,    3, 7,  "US-AR K1.XXXX"},
        {33.096515,   -93.8066125,    4, 7,  "US-AR L1.XXXX"},
        {33.096515,   -93.2493565,    4, 6,  "US-AR M1.XXXX"},
        {33.096515,   -92.6921005,    4, 6,  "US-AR N1.XXXX"},
        {33.096515,   -92.1348445,    4, 6,  "US-AR P1.XXXX"},
        {33.096515,   -91.5775885,    4, 7,  "US-AR Q1.XXXX"},
        {33.036795,   -94.141253,     3, 7,  "US-AR R1.XXXX"},
        {33.036795,   -93.589205,     3, 6,  "US-AR S1.XXXX"},
        {33.036795,   -93.037157,     3, 5,  "US-AR T1.XXXX"},
        {33.0171,     -92.512457,     3, 8,  "US-AR X123.XX"},
        {33.0171,     -91.960409,     3, 8,  "US-AR Y123.XX"},
        {33.0171,     -91.408361,     3, 11, "US-AR Z123.XX"},
        {34.7515,     -92.131,        4, 6,  "US-AR 3YTR.MT4"},
        {35.2621,     -80.88931,      5, 7,  "US-NC 12.XX"},
        {35.319294,   -81.052158625,  4, 6,  "US-NC 00.XXX"},
        {35.779314,   -78.90703,      4, 6,  "US-NC J0.XXX"},
        {35.999804,   -79.005374625,  4, 6,  "US-NC 000.XX"},
        {35.175845,   -79.039726875,  4, 7,  "US-NC 400.XX"},
        {34.291545,   -77.957208125,  4, 6,  "US-NC 800.XX"},
        {36.109304,   -80.352174625,  4, 6,  "US-NC D00.XX"},
        {36.081304,   -79.949974625,  4, 6,  "US-NC J00.XX"},
        {35.956304,   -80.119674625,  4, 6,  "US-NC N00.XX"},
        {35.623804,   -77.468655,     4, 6,  "US-NC S00.XX"},
        {35.590094,   -82.650065,     4, 9,  "US-NC X00.XX"},
        {36.543595,   -82.571845,     3, 10, "US-NC 012.XXX"},
        {36.543595,   -81.998965,     3, 10, "US-NC 112.XXX"},
        {36.543595,   -81.426085,     3, 6,  "US-NC 212.XXX"},
        {36.543595,   -80.853205,     3, 6,  "US-NC 312.XXX"},
        {36.543595,   -80.280325,     3, 8,  "US-NC 412.XXX"},
        {36.543595,   -79.707445,     3, 8,  "US-NC 512.XXX"},
        {36.052555,   -83.717605,     3, 8,  "US-NC 612.XXX"},
        {36.052555,   -83.144725,     3, 8,  "US-NC 712.XXX"},
        {36.052555,   -82.571845,     3, 8,  "US-NC 812.XXX"},
        {36.052555,   -81.998965,     3, 8,  "US-NC 912.XXX"},
        {36.052555,   -81.426085,     3, 5,  "US-NC B12.XXX"},
        {36.052555,   -80.853205,     3, 5,  "US-NC C12.XXX"},
        {36.052555,   -80.280325,     4, 6,  "US-NC D12.XXX"},
        {36.052555,   -79.707445,     3, 5,  "US-NC F12.XXX"},
        {35.561515,   -84.2855635,    3, 8,  "US-NC G12.XXX"},
        {35.561515,   -83.7178915,    3, 8,  "US-NC H12.XXX"},
        {35.561515,   -83.1502195,    3, 8,  "US-NC J12.XXX"},
        {35.561515,   -82.5825475,    4, 9,  "US-NC K12.XXX"},
        {35.561515,   -82.0148755,    3, 8,  "US-NC L12.XXX"},
        {35.561515,   -81.4472035,    3, 5,  "US-NC M12.XXX"},
        {35.561515,   -80.8795315,    3, 5,  "US-NC N12.XXX"},
        {35.561515,   -80.3118595,    3, 5,  "US-NC P12.XXX"},
        {35.561515,   -79.7441875,    3, 5,  "US-NC Q12.XXX"},
        {35.0160365,  -84.257215,     3, 8,  "US-NC R12.XXX"},
        {35.070475,   -81.4472035,    3, 8,  "US-NC S12.XXX"},
        {35.070475,   -80.8795315,    4, 9,  "US-NC T12.XXX"},
        {35.070475,   -80.3118595,    3, 6,  "US-NC V12.XXX"},
        {35.070475,   -79.7441875,    3, 6,  "US-NC W12.XXX"},
        {34.579435,   -79.744473,     3, 8,  "US-NC X12.XXX"},
        {34.198135,   -78.900778,     4, 9,  "US-NC Y12.XXX"},
        {34.198135,   -78.338314,     4, 6,  "US-NC Z12.XXX"},
        {36.097382,   -79.186644,     4, 6,  "US-NC 01.XXXX"},
        {36.097382,   -78.613764,     3, 5,  "US-NC 11.XXXX"},
        {36.097382,   -78.040884,     3, 5,  "US-NC 21.XXXX"},
        {36.097382,   -77.468004,     3, 5,  "US-NC 31.XXXX"},
        {36.097382,   -76.895124,     3, 5,  "US-NC 41.XXXX"},
        {36.097382,   -76.322244,     3, 5,  "US-NC 51.XXXX"},
        {36.097382,   -75.891365,     4, 6,  "US-NC 61.XXXX"},
        {35.606342,   -79.186644,     3, 5,  "US-NC 71.XXXX"},
        {35.606342,   -78.613764,     4, 6,  "US-NC 81.XXXX"},
        {35.606342,   -78.040884,     3, 5,  "US-NC 91.XXXX"},
        {35.606342,   -77.468004,     4, 6,  "US-NC B1.XXXX"},
        {35.606342,   -76.895124,     3, 5,  "US-NC C1.XXXX"},
        {35.606342,   -76.322244,     3, 5,  "US-NC D1.XXXX"},
        {35.606342,   -75.891365,     4, 6,  "US-NC F1.XXXX"},
        {35.115302,   -79.1817225,    3, 6,  "US-NC G1.XXXX"},
        {35.115302,   -78.6140505,    3, 6,  "US-NC H1.XXXX"},
        {35.115302,   -78.0463785,    3, 5,  "US-NC J1.XXXX"},
        {35.115302,   -77.4787065,    3, 5,  "US-NC K1.XXXX"},
        {35.115302,   -76.9110345,    3, 5,  "US-NC L1.XXXX"},
        {35.115302,   -76.3433625,    3, 5,  "US-NC M1.XXXX"},
        {35.115302,   -75.8864435,    4, 6,  "US-NC N1.XXXX"},
        {34.624262,   -79.182009,     3, 8,  "US-NC P1.XXXX"},
        {34.624262,   -78.619545,     3, 6,  "US-NC Q1.XXXX"},
        {34.624262,   -78.057081,     3, 5,  "US-NC R1.XXXX"},
        {34.624262,   -77.494617,     3, 5,  "US-NC S1.XXXX"},
        {34.624262,   -76.932153,     3, 5,  "US-NC T1.XXXX"},
        {34.624262,   -76.369689,     3, 5,  "US-NC V1.XXXX"},
        {34.133222,   -79.182009,     3, 8,  "US-NC W1.XXXX"},
        {34.133222,   -78.619545,     4, 9,  "US-NC X1.XXXX"},
        {34.133222,   -78.057081,     4, 6,  "US-NC Y1.XXXX"},
        {34.133222,   -77.494617,     3, 5,  "US-NC Z1.XXXX"},
        {35.17075,    -79.836,        3, 6,  "US-NC RMYZ.TTM"},
        {40.742045,   -74.018704375,  4, 11, "US-NY 00.XX"},
        {40.771935,   -74.001383125,  4, 11, "US-NY C0.XX"},
        {40.836995,   -73.974994125,  4, 10, "US-NY P0.XX"},
        {40.8871855,  -73.938782,     4, 10, "US-NY 12.XXX"},
        {42.943804,   -78.941101,     4, 9,  "US-NY 000.XX"},
        {43.193344,   -77.7387475,    4, 8,  "US-NY 700.XX"},
        {43.104744,   -76.292972,     4, 8,  "US-NY F00.XX"},
        {42.819974,   -73.991628,     4, 7,  "US-NY M00.XX"},
        {40.686545,   -74.256554375,  4, 10, "US-NY T00.XX"},
        {43.374715,   -79.123397,     3, 8,  "US-NY 012.XXX"},
        {43.374715,   -78.488021,     3, 8,  "US-NY 112.XXX"},
        {43.374715,   -77.852645,     3, 7,  "US-NY 212.XXX"},
        {43.374715,   -77.217269,     3, 7,  "US-NY 312.XXX"},
        {43.374715,   -76.581893,     3, 7,  "US-NY 412.XXX"},
        {43.374715,   -75.946517,     3, 7,  "US-NY 512.XXX"},
        {43.374715,   -75.311141,     3, 7,  "US-NY 612.XXX"},
        {43.374715,   -74.675765,     3, 7,  "US-NY 712.XXX"},
        {43.374715,   -74.040389,     3, 6,  "US-NY 812.XXX"},
        {43.374715,   -73.849776,     4, 7,  "US-NY 912.XXX"},
        {42.883675,   -79.4997005,    3, 9,  "US-NY B12.XXX"},
        {42.883675,   -78.8695325,    4, 9,  "US-NY C12.XXX"},
        {42.883675,   -78.2393645,    3, 8,  "US-NY D12.XXX"},
        {42.883675,   -77.6091965,    3, 7,  "US-NY F12.XXX"},
        {42.883675,   -76.9790285,    3, 7,  "US-NY G12.XXX"},
        {42.883675,   -76.3488605,    3, 7,  "US-NY H12.XXX"},
        {42.883675,   -75.7186925,    3, 7,  "US-NY J12.XXX"},
        {42.883675,   -75.0885245,    3, 7,  "US-NY K12.XXX"},
        {42.883675,   -74.4583565,    3, 7,  "US-NY L12.XXX"},
        {42.883675,   -73.8281885,    3, 6,  "US-NY M12.XXX"},
        {41.901595,   -75.277861,     3, 10, "US-NY P12.XXX"},
        {41.901595,   -74.652901,     3, 7,  "US-NY Q12.XXX"},
        {41.901595,   -74.027941,     3, 6,  "US-NY R12.XXX"},
        {41.410555,   -74.5854835,    4, 6,  "US-NY T12.XXX"},
        {41.410555,   -73.9657315,    3, 5,  "US-NY V12.XXX"},
        {41.754283,   -74.8953595,    4, 11, "US-NY S12.XXX"},
        {40.9044475,  -74.2239565,    3, 9,  "US-NY Z12.XXX"},
        {40.944066,   -73.606562,     4, 6,  "US-NY W12.XXX"},
        {41.066826,   -72.992018,     3, 8,  "US-NY X12.XXX"},
        {41.250966,   -72.377474,     3, 11, "US-NY Y12.XXX"},
        {44.976832,   -75.1717755,    3, 8,  "US-NY 0123.XX"},
        {44.413585,   -75.8799975,    3, 8,  "US-NY 1123.XX"},
        {44.413585,   -75.2289975,    3, 8,  "US-NY 2123.XX"},
        {44.413585,   -74.5779975,    3, 8,  "US-NY 3123.XX"},
        {44.413585,   -73.9269975,    3, 6,  "US-NY 4123.XX"},
        {43.922545,   -76.465925,     3, 8,  "US-NY 5123.XX"},
        {43.922545,   -75.820133,     3, 8,  "US-NY 6123.XX"},
        {43.922545,   -75.174341,     3, 8,  "US-NY 7123.XX"},
        {43.922545,   -74.528549,     3, 8,  "US-NY 8123.XX"},
        {43.922545,   -73.882757,     3, 6,  "US-NY 9123.XX"},
        {43.431505,   -76.9128005,    3, 7,  "US-NY B123.XX"},
        {43.431505,   -76.2722165,    3, 7,  "US-NY C123.XX"},
        {43.431505,   -75.6316325,    3, 7,  "US-NY D123.XX"},
        {43.431505,   -74.9910485,    3, 7,  "US-NY F123.XX"},
        {43.431505,   -74.3504645,    3, 7,  "US-NY G123.XX"},
        {43.431505,   -73.7098805,    3, 6,  "US-NY H123.XX"},
        {41.958385,   -79.7595515,    3, 12, "US-NY J123.XX"},
        {41.958385,   -79.3392645,    4, 11, "US-NY K123.XX"},
        {41.958385,   -78.7090965,    3, 10, "US-NY L123.XX"},
        {41.958385,   -78.0789285,    3, 10, "US-NY M123.XX"},
        {41.958385,   -77.4487605,    3, 10, "US-NY N123.XX"},
        {41.958385,   -76.8185925,    3, 10, "US-NY P123.XX"},
        {41.958385,   -76.1884245,    3, 10, "US-NY Q123.XX"},
        {41.958385,   -75.5582565,    3, 10, "US-NY R123.XX"},
        {41.958385,   -74.9280885,    3, 10, "US-NY S123.XX"},
        {41.958385,   -74.2979205,    3, 6,  "US-NY T123.XX"},
        {41.958385,   -73.9828355,    4, 7,  "US-NY V123.XX"},
        {42.7465,     -75.77,         3, 7,  "US-NY NBLY.WVJ"},
        {41.6361,     -93.65952,      5, 7,  "US-IA 12.XX"},
        {41.711294,   -93.89004,      4, 9,  "US-IA 00.XXX"},
        {42.007314,   -91.84946,      4, 9,  "US-IA J0.XXX"},
        {41.651645,   -90.6497,       5, 8,  "US-IA 000.XX"},
        {42.538745,   -96.4946975,    4, 13, "US-IA 300.XX"},
        {42.548324,   -92.4996975,    4, 10, "US-IA 600.XX"},
        {41.682894,   -91.64748,      4, 9,  "US-IA 900.XX"},
        {41.245394,   -95.9317485,    4, 11, "US-IA D00.XX"},
        {42.010914,   -93.7037585,    4, 9,  "US-IA H00.XX"},
        {42.488714,   -90.7963585,    4, 10, "US-IA K00.XX"},
        {43.148814,   -93.3057165,    4, 9,  "US-IA M00.XX"},
        {42.038114,   -92.9963585,    4, 9,  "US-IA P00.XX"},
        {41.816214,   -90.33238,      4, 13, "US-IA R00.XX"},
        {40.849545,   -91.272704375,  5, 10, "US-IA T00.XX"},
        {42.470814,   -94.2365585,    4, 9,  "US-IA W00.XX"},
        {40.991814,   -92.4992005,    4, 6,  "US-IA Y00.XX"},
        {43.456595,   -96.6047605,    3, 10, "US-IA 112.XXX"},
        {43.456595,   -95.9679775,    3, 6,  "US-IA 212.XXX"},
        {43.456595,   -95.3273935,    3, 6,  "US-IA 312.XXX"},
        {43.456595,   -94.6868095,    3, 8,  "US-IA 412.XXX"},
        {43.456595,   -94.0462255,    3, 8,  "US-IA 512.XXX"},
        {43.456595,   -93.4056415,    3, 8,  "US-IA 612.XXX"},
        {43.456595,   -92.7650575,    3, 9,  "US-IA 712.XXX"},
        {43.456595,   -92.1244735,    3, 9,  "US-IA 812.XXX"},
        {43.456595,   -91.4838895,    3, 11, "US-IA 912.XXX"},
        {42.970465,   -96.605047,     3, 12, "US-IA B12.XXX"},
        {42.970465,   -95.973472,     3, 9,  "US-IA C12.XXX"},
        {42.970465,   -95.338096,     3, 9,  "US-IA D12.XXX"},
        {42.970465,   -94.70272,      3, 8,  "US-IA F12.XXX"},
        {42.970465,   -94.067344,     3, 8,  "US-IA G12.XXX"},
        {42.970465,   -93.431968,     3, 8,  "US-IA H12.XXX"},
        {42.970465,   -92.796592,     3, 9,  "US-IA J12.XXX"},
        {42.970465,   -92.161216,     3, 9,  "US-IA K12.XXX"},
        {42.970465,   -91.52584,      3, 11, "US-IA L12.XXX"},
        {42.970465,   -90.890464,     3, 11, "US-IA M12.XXX"},
        {42.479425,   -96.6039265,    3, 9,  "US-IA N12.XXX"},
        {42.479425,   -95.9737585,    3, 9,  "US-IA P12.XXX"},
        {42.479425,   -95.3435905,    3, 9,  "US-IA Q12.XXX"},
        {42.479425,   -94.7134225,    3, 8,  "US-IA R12.XXX"},
        {42.479425,   -94.0832545,    4, 9,  "US-IA S12.XXX"},
        {42.479425,   -93.4530865,    3, 8,  "US-IA T12.XXX"},
        {42.479425,   -92.8229185,    3, 8,  "US-IA V12.XXX"},
        {42.479425,   -92.1927505,    3, 8,  "US-IA W12.XXX"},
        {42.479425,   -91.5625825,    3, 8,  "US-IA X12.XXX"},
        {42.479425,   -90.9324145,    3, 9,  "US-IA Y12.XXX"},
        {42.479425,   -90.7345015,    5, 11, "US-IA Z12.XXX"},
        {41.576545,   -96.604213,     3, 8,  "US-IA 01.XXXX"},
        {41.576545,   -95.979253,     3, 8,  "US-IA 11.XXXX"},
        {41.576545,   -95.354293,     3, 8,  "US-IA 21.XXXX"},
        {41.576545,   -94.729333,     3, 5,  "US-IA 31.XXXX"},
        {41.576545,   -94.104373,     3, 5,  "US-IA 41.XXXX"},
        {41.576545,   -93.479413,     4, 6,  "US-IA 51.XXXX"},
        {41.576545,   -92.854453,     3, 5,  "US-IA 61.XXXX"},
        {41.576545,   -92.229493,     3, 5,  "US-IA 71.XXXX"},
        {41.576545,   -91.604533,     3, 5,  "US-IA 81.XXXX"},
        {41.576545,   -90.979573,     3, 6,  "US-IA 91.XXXX"},
        {41.576545,   -90.72958,      4, 7,  "US-IA B1.XXXX"},
        {41.085505,   -96.5992915,    3, 8,  "US-IA C1.XXXX"},
        {41.085505,   -95.9795395,    3, 9,  "US-IA D1.XXXX"},
        {41.085505,   -95.3597875,    3, 8,  "US-IA F1.XXXX"},
        {41.085505,   -94.7400355,    3, 5,  "US-IA G1.XXXX"},
        {41.085505,   -94.1202835,    3, 5,  "US-IA H1.XXXX"},
        {41.085505,   -93.5005315,    3, 5,  "US-IA J1.XXXX"},
        {41.085505,   -92.8807795,    3, 5,  "US-IA K1.XXXX"},
        {41.085505,   -92.2610275,    3, 5,  "US-IA L1.XXXX"},
        {41.085505,   -91.6412755,    3, 5,  "US-IA M1.XXXX"},
        {41.085505,   -91.0215235,    3, 8,  "US-IA N1.XXXX"},
        {40.594465,   -95.979826,     3, 8,  "US-IA P1.XXXX"},
        {40.594465,   -95.365282,     3, 11, "US-IA Q1.XXXX"},
        {40.594465,   -94.750738,     3, 8,  "US-IA R1.XXXX"},
        {40.594465,   -94.136194,     3, 8,  "US-IA S1.XXXX"},
        {40.594465,   -93.52165,      3, 8,  "US-IA T1.XXXX"},
        {40.594465,   -92.907106,     3, 8,  "US-IA V1.XXXX"},
        {40.594465,   -92.292562,     3, 8,  "US-IA W1.XXXX"},
        {40.594465,   -91.678018,     4, 9,  "US-IA X1.XXXX"},
        {40.594465,   -91.063474,     3, 11, "US-IA Y1.XXXX"},
        {40.408795,   -91.6730965,    3, 8,  "US-IA Z1.XXXX"},
        {41.9385,     -93.3895,       3, 8,  "US-IA QK37.GGP"},
        {41.911,      -87.71202,      5, 11, "US-IL 12.XX"},
        {41.6103695,  -88.035503,     4, 7,  "US-IL 12.XXX"},
        {42.097545,   -88.3369105,    4, 10, "US-IL 000.XX"},
        {41.890325,   -88.279005,     4, 10, "US-IL 400.XX"},
        {41.717346,   -88.279005,     4, 10, "US-IL 800.XX"},
        {41.544367,   -88.274392,     4, 6,  "US-IL D00.XX"},
        {42.379445,   -89.1503785,    4, 10, "US-IL J00.XX"},
        {39.890345,   -89.740429375,  4, 7,  "US-IL N00.XX"},
        {40.817545,   -89.687088375,  4, 6,  "US-IL S00.XX"},
        {42.360294,   -88.0023115,    4, 10, "US-IL X00.XX"},
        {42.463595,   -90.6575105,    3, 13, "US-IL 012.XXX"},
        {42.463595,   -90.0273425,    3, 9,  "US-IL 112.XXX"},
        {42.463595,   -89.3971745,    3, 9,  "US-IL 212.XXX"},
        {42.463595,   -88.7670065,    3, 9,  "US-IL 312.XXX"},
        {42.463595,   -88.1368385,    3, 9,  "US-IL 412.XXX"},
        {41.977465,   -90.531763,     3, 12, "US-IL 512.XXX"},
        {41.977465,   -89.906803,     3, 9,  "US-IL 612.XXX"},
        {41.977465,   -89.281843,     3, 9,  "US-IL 712.XXX"},
        {41.977465,   -88.656884,     3, 9,  "US-IL 812.XXX"},
        {41.977465,   -88.031924,     4, 10, "US-IL 912.XXX"},
        {41.486425,   -91.1518025,    3, 8,  "US-IL B12.XXX"},
        {41.486425,   -90.5320505,    3, 8,  "US-IL C12.XXX"},
        {41.486425,   -89.9122985,    3, 5,  "US-IL D12.XXX"},
        {41.486425,   -89.2925465,    3, 5,  "US-IL F12.XXX"},
        {41.486425,   -88.6727945,    3, 5,  "US-IL G12.XXX"},
        {41.486425,   -88.0530425,    4, 7,  "US-IL H12.XXX"},
        {40.995385,   -91.480193,     3, 8,  "US-IL J12.XXX"},
        {40.995385,   -90.878408,     3, 8,  "US-IL K12.XXX"},
        {40.995385,   -90.263864,     3, 6,  "US-IL L12.XXX"},
        {40.995385,   -89.64932,      3, 5,  "US-IL M12.XXX"},
        {40.995385,   -89.034776,     3, 5,  "US-IL N12.XXX"},
        {40.995385,   -88.420232,     3, 5,  "US-IL P12.XXX"},
        {40.995385,   -88.005737,     4, 7,  "US-IL Q12.XXX"},
        {40.504345,   -91.4804795,    3, 11, "US-IL R12.XXX"},
        {40.504345,   -90.8786945,    3, 9,  "US-IL S12.XXX"},
        {40.504345,   -90.2693585,    3, 7,  "US-IL T12.XXX"},
        {40.504345,   -89.6600225,    3, 6,  "US-IL V12.XXX"},
        {40.504345,   -89.0506865,    3, 5,  "US-IL W12.XXX"},
        {40.504345,   -88.4413505,    3, 5,  "US-IL X12.XXX"},
        {40.504345,   -88.0008155,    4, 7,  "US-IL Y12.XXX"},
        {40.013305,   -91.480766,     3, 8,  "US-IL Z12.XXX"},
        {39.601465,   -90.884189,     3, 8,  "US-IL 01.XXXX"},
        {39.601465,   -90.280061,     3, 6,  "US-IL 11.XXXX"},
        {39.601465,   -89.675933,     3, 6,  "US-IL 21.XXXX"},
        {39.601465,   -89.071805,     3, 5,  "US-IL 31.XXXX"},
        {39.601465,   -88.467677,     3, 5,  "US-IL 41.XXXX"},
        {39.601465,   -87.995894,     4, 7,  "US-IL 51.XXXX"},
        {39.110425,   -91.4810525,    3, 9,  "US-IL 61.XXXX"},
        {39.110425,   -90.8844755,    3, 9,  "US-IL 71.XXXX"},
        {39.110425,   -90.2855555,    3, 8,  "US-IL 81.XXXX"},
        {39.110425,   -89.6866355,    3, 8,  "US-IL 91.XXXX"},
        {39.110425,   -89.0877155,    3, 6,  "US-IL B1.XXXX"},
        {39.110425,   -88.4887955,    3, 6,  "US-IL C1.XXXX"},
        {39.110425,   -87.9909725,    4, 8,  "US-IL D1.XXXX"},
        {38.619385,   -90.884762,     3, 8,  "US-IL F1.XXXX"},
        {38.619385,   -90.29105,      3, 9,  "US-IL G1.XXXX"},
        {38.619385,   -89.697338,     3, 8,  "US-IL H1.XXXX"},
        {38.619385,   -89.103626,     3, 9,  "US-IL J1.XXXX"},
        {38.619385,   -88.509914,     3, 6,  "US-IL K1.XXXX"},
        {38.619385,   -87.986051,     4, 8,  "US-IL L1.XXXX"},
        {38.128345,   -90.4642425,    3, 8,  "US-IL M1.XXXX"},
        {38.128345,   -89.8757385,    3, 8,  "US-IL N1.XXXX"},
        {38.128345,   -89.2872345,    3, 11, "US-IL P1.XXXX"},
        {38.128345,   -88.6987305,    3, 8,  "US-IL Q1.XXXX"},
        {38.128345,   -88.1102265,    3, 8,  "US-IL R1.XXXX"},
        {37.637305,   -90.2288405,    3, 8,  "US-IL S1.XXXX"},
        {37.637305,   -89.6403365,    3, 8,  "US-IL T1.XXXX"},
        {37.637305,   -89.0518325,    3, 8,  "US-IL V1.XXXX"},
        {37.637305,   -88.4633285,    3, 8,  "US-IL W1.XXXX"},
        {37.2886585,  -89.488631,     4, 12, "US-IL X1.XXXX"},
        {37.210265,   -89.0477205,    4, 9,  "US-IL Y1.XXXX"},
        {37.210265,   -88.5377205,    4, 9,  "US-IL Z1.XXXX"},
        {37.1316775,  -89.5168365,    4, 12, "US-IL X123.XX"},
        {37.127729,   -89.076808,     4, 9,  "US-IL Y123.XX"},
        {37.127729,   -88.566808,     4, 9,  "US-IL Z123.XX"},
        {39.73925,    -89.4695,       3, 6,  "US-IL 4282.95R"},
        {33.7927,     -84.433468,     5, 7,  "US-GA 12.XX"},
        {34.038515,   -84.61339,      4, 6,  "US-GA 12.XXX"},
        {33.470774,   -82.144932375,  4, 9,  "US-GA 000.XX"},
        {32.496874,   -85.063991,     5, 10, "US-GA 500.XX"},
        {32.082174,   -81.26295425,   4, 7,  "US-GA B00.XX"},
        {33.939604,   -83.486034,     4, 7,  "US-GA H00.XX"},
        {32.788104,   -83.768132625,  5, 7,  "US-GA M00.XX"},
        {31.588104,   -84.27153225,   4, 6,  "US-GA R00.XX"},
        {32.617004,   -83.761132625,  5, 7,  "US-GA W00.XX"},
        {34.9393885,  -85.4862745,    3, 8,  "US-GA 123.XXX"},
        {31.2918205,  -82.633675,     4, 6,  "US-GA 1234.XX"},
        {33.022837,   -85.05586,      4, 7,  "US-GA 12.XXXX"},
        {32.6775,     -83.213,        4, 7,  "US-GA L9YS.8PB"},
        {43.0741,     -87.9800025,    5, 11, "US-WI 12.XX"},
        {43.131294,   -88.303669,     4, 10, "US-WI 00.XXX"},
        {43.206375,   -89.601207,     4, 10, "US-WI J0.XXX"},
        {44.519974,   -88.171855375,  4, 10, "US-WI 000.XX"},
        {42.787074,   -88.018767,     4, 10, "US-WI 500.XX"},
        {42.612374,   -88.068467,     4, 10, "US-WI B00.XX"},
        {44.288813,   -88.519751875,  4, 10, "US-WI H00.XX"},
        {44.099634,   -88.77809,      4, 10, "US-WI M00.XX"},
        {44.955445,   -91.569510375,  4, 12, "US-WI R00.XX"},
        {42.708804,   -89.124381,     4, 10, "US-WI W00.XX"},
        {46.4779345,  -89.7940365,    4, 14, "US-WI 12.XXXX"},
        {46.914509,   -92.7577025,    3, 11, "US-WI 1234.XX"},
        {43.719828,   -91.9816015,    3, 11, "US-WI 123.XXX"},
        {44.795,      -89.795,        4, 12, "US-WI 3QKZ.LPR"},
        {25.785024,   -80.250115375,  5, 8,  "US-FL 00.XX"},
        {30.303604,   -81.688784875,  5, 7,  "US-FL J0.XX"},
        {25.797604,   -80.4242685,    4, 7,  "US-FL 12.XXX"},
        {30.337804,   -81.755651125,  4, 6,  "US-FL 000.XX"},
        {27.958594,   -82.539305125,  4, 6,  "US-FL 400.XX"},
        {27.767694,   -82.763189375,  4, 6,  "US-FL 700.XX"},
        {28.530294,   -81.461420875,  4, 6,  "US-FL B00.XX"},
        {30.436694,   -84.369068125,  4, 7,  "US-FL F00.XX"},
        {27.288194,   -80.433773625,  4, 6,  "US-FL J00.XX"},
        {26.612494,   -82.068557875,  4, 6,  "US-FL M00.XX"},
        {26.743494,   -80.193457875,  4, 7,  "US-FL Q00.XX"},
        {27.981294,   -82.845305125,  4, 6,  "US-FL T00.XX"},
        {29.646094,   -82.449152375,  4, 6,  "US-FL X00.XX"},
        {28.1046755,  -82.840347,     3, 5,  "US-FL 123.XXX"},
        {30.577496,   -83.3258035,    4, 7,  "US-FL 12.XXXX"},
        {25.065865,   -81.1920585,    3, 5,  "US-FL 0123.XX"},
        {25.065865,   -80.6764665,    4, 6,  "US-FL 1123.XX"},
        {24.479332,   -82.996659,     3, 5,  "US-FL 2123.XX"},
        {24.479332,   -82.384198,     3, 5,  "US-FL 3123.XX"},
        {24.479332,   -81.873814,     3, 5,  "US-FL 4123.XX"},
        {24.479332,   -81.36343,      3, 5,  "US-FL 5123.XX"},
        {24.722137,   -80.8530175,    3, 5,  "US-FL 6123.XX"},
        {30.522345,   -87.637952,     3, 8,  "US-FL B123.XX"},
        {30.522345,   -87.09632,      3, 6,  "US-FL C123.XX"},
        {30.522345,   -86.554688,     3, 6,  "US-FL D123.XX"},
        {30.522345,   -86.013056,     3, 6,  "US-FL F123.XX"},
        {30.522345,   -85.471423,     3, 7,  "US-FL G123.XX"},
        {30.522345,   -84.929791,     3, 7,  "US-FL H123.XX"},
        {30.522345,   -84.388159,     3, 6,  "US-FL J123.XX"},
        {30.522345,   -83.846527,     3, 6,  "US-FL K123.XX"},
        {30.03402,    -87.6380645,    4, 6,  "US-FL L123.XX"},
        {30.03402,    -87.6379805,    4, 6,  "US-FL M123.XX"},
        {30.03402,    -87.1015565,    3, 5,  "US-FL N123.XX"},
        {30.03402,    -86.5651325,    3, 5,  "US-FL P123.XX"},
        {30.03402,    -86.0287085,    3, 5,  "US-FL Q123.XX"},
        {30.03402,    -85.4922845,    3, 5,  "US-FL R123.XX"},
        {30.03402,    -84.9558605,    3, 5,  "US-FL S123.XX"},
        {30.03402,    -84.4194365,    3, 5,  "US-FL T123.XX"},
        {30.03402,    -83.8830125,    3, 5,  "US-FL V123.XX"},
        {29.540265,   -85.5995685,    3, 5,  "US-FL W123.XX"},
        {29.540265,   -85.0631445,    3, 5,  "US-FL X123.XX"},
        {29.540265,   -84.5267205,    3, 5,  "US-FL Y123.XX"},
        {29.540265,   -83.9902965,    3, 5,  "US-FL Z123.XX"},
        {30.569,      -84.984,        3, 7,  "US-FL HHXH.5WG"},
        {39.1386,     -94.6011345,    6, 12, "US-MO 12.XX"},
        {38.894495,   -94.61324225,   4, 10, "US-MO 00.XXX"},
        {38.840115,   -90.536254125,  4, 9,  "US-MO J0.XXX"},
        {37.189404,   -93.488212875,  4, 6,  "US-MO 000.XX"},
        {38.977244,   -92.46982725,   4, 6,  "US-MO 700.XX"},
        {38.775244,   -90.826245625,  4, 9,  "US-MO F00.XX"},
        {37.196545,   -94.584219375,  4, 9,  "US-MO M00.XX"},
        {39.954545,   -94.905677375,  4, 9,  "US-MO T00.XX"},
        {36.614535,   -94.8268465,    3, 8,  "US-MO 123.XXX"},
        {37.520261,   -91.7009645,    3, 5,  "US-MO 1234.XX"},
        {39.3454565,  -95.5762795,    3, 8,  "US-MO 12.XXXX"},
        {38.3045705,  -92.43735,      3, 5,  "US-MO ST2N.9DK"},
        {35.5031,     -97.56231,      5, 8,  "US-OK 12.XX"},
        {35.179415,   -97.770965,     4, 7,  "US-OK 12.XXX"},
        {36.207204,   -96.146274625,  4, 7,  "US-OK 000.XX"},
        {36.207204,   -95.933414625,  4, 7,  "US-OK 400.XX"},
        {36.034225,   -96.146274625,  4, 7,  "US-OK 800.XX"},
        {36.034225,   -95.933414625,  4, 7,  "US-OK D00.XX"},
        {34.618694,   -98.496125625,  4, 7,  "US-OK J00.XX"},
        {36.387294,   -97.96411225,   4, 7,  "US-OK M00.XX"},
        {36.117094,   -97.154388625,  4, 7,  "US-OK Q00.XX"},
        {35.744494,   -95.414888625,  4, 7,  "US-OK T00.XX"},
        {36.755494,   -96.04601225,   4, 6,  "US-OK X00.XX"},
        {34.307735,   -96.887202,     3, 6,  "US-OK 123.XXX"},
        {34.070437,   -99.3540745,    3, 7,  "US-OK 12.XXXX"},
        {36.5057885,  -102.9995785,   3, 5,  "US-OK B123.XX"},
        {36.5057885,  -102.4006585,   3, 5,  "US-OK C123.XX"},
        {36.5057885,  -101.8017385,   3, 5,  "US-OK D123.XX"},
        {36.5068565,  -101.2028185,   3, 5,  "US-OK F123.XX"},
        {36.5068565,  -100.6038985,   3, 5,  "US-OK G123.XX"},
        {36.5175155,  -100.0058165,   4, 6,  "US-OK H123.XX"},
        {36.340024,   -100.0065505,   2, 6,  "US-OK J123.XX"},
        {35.848984,   -100.006579,    2, 6,  "US-OK K123.XX"},
        {35.355229,   -100.006579,    2, 6,  "US-OK L123.XX"},
        {34.864189,   -100.0013995,   3, 7,  "US-OK M123.XX"},
        {34.375864,   -100.001428,    3, 7,  "US-OK N123.XX"},
        {36.6278765,  -102.760117,    3, 5,  "US-OK X123.XXX"},
        {33.848663,   -99.9920575,    2, 6,  "US-OK Y123.XXX"},
        {33.8627205,  -97.1875575,    3, 8,  "US-OK Z123.XXX"},
        {46.8794805,  -96.9151145,    5, 11, "US-ND 12.XX"},
        {46.969294,   -97.243077625,  4, 7,  "US-ND 00.XXX"},
        {46.817314,   -101.02489,     4, 7,  "US-ND J0.XXX"},
        {47.950244,   -97.190289125,  4, 9,  "US-ND 000.XX"},
        {48.306645,   -101.469265625, 4, 7,  "US-ND 600.XX"},
        {46.894974,   -102.930896375, 4, 7,  "US-ND C00.XX"},
        {46.926974,   -98.848896375,  4, 7,  "US-ND J00.XX"},
        {48.162974,   -103.761580125, 4, 7,  "US-ND P00.XX"},
        {46.280974,   -96.833755,     4, 10, "US-ND V00.XX"},
        {46.6302995,  -104.035728,    3, 8,  "US-ND 123.XXX"},
        {46.4552215,  -101.446799,    3, 6,  "US-ND 12.XXXX"},
        {48.524253,   -98.94918,      3, 6,  "US-ND 1234.XX"},
        {48.453482,   -103.5196675,   3, 6,  "US-ND 1234.XXX"},
        {47.6411,     -122.387572,    5, 8,  "US-WA 12.XX"},
        {47.4685605,  -122.407421,    4, 7,  "US-WA 12.XXX"},
        {47.745545,   -117.51966875,  4, 7,  "US-WA 000.XX"},
        {47.323382,   -122.624801875, 4, 7,  "US-WA 600.XX"},
        {45.724345,   -122.72648125,  4, 10, "US-WA C00.XX"},
        {48.805374,   -122.6504225,   4, 10, "US-WA J00.XX"},
        {46.311245,   -119.372575,    4, 7,  "US-WA P00.XX"},
        {46.697604,   -120.655175,    4, 7,  "US-WA V00.XX"},
        {46.3720685,  -124.7554245,   3, 6,  "US-WA 123.XXX"},
        {46.2535785,  -121.95742,     3, 8,  "US-WA 12.XXXX"},
        {48.2320705,  -119.4412665,   3, 6,  "US-WA 1234.XX"},
        {47.273,      -120.858,       3, 6,  "US-WA 5TS3.N79"},
        {43.577,      -96.7836025,    5, 11, "US-SD 12.XX"},
        {43.590694,   -96.9723835,    4, 10, "US-SD 00.XXX"},
        {44.111314,   -103.414372,    4, 7,  "US-SD J0.XXX"},
        {45.465004,   -98.59946325,   4, 7,  "US-SD 000.XX"},
        {44.307704,   -96.939102375,  4, 10, "US-SD 400.XX"},
        {44.910604,   -97.226662875,  4, 9,  "US-SD 800.XX"},
        {43.720004,   -98.155402,     4, 7,  "US-SD D00.XX"},
        {42.935004,   -97.502581,     4, 10, "US-SD J00.XX"},
        {44.385104,   -100.452702375, 4, 7,  "US-SD N00.XX"},
        {44.376304,   -98.334402375,  4, 7,  "US-SD S00.XX"},
        {42.780794,   -97.019243,     4, 10, "US-SD X00.XX"},
        {43.3063205,  -103.961385,    3, 6,  "US-SD 12.XXXX"},
        {44.5775465,  -101.3224775,   3, 6,  "US-SD 1234.XX"},
        {43.432219,   -98.7866095,    3, 6,  "US-SD 123.XXX"},
        {44.212575,   -100.248,       3, 6,  "US-SD 7CWZ.C4Q"},
        {41.270224,   -95.9943215,    5, 10, "US-NE 00.XX"},
        {40.785104,   -96.737866125,  5, 7,  "US-NE J0.XX"},
        {41.308494,   -96.2978255,    4, 9,  "US-NE 00.XXX"},
        {40.809314,   -96.886117125,  4, 6,  "US-NE J0.XXX"},
        {40.936774,   -98.480240875,  4, 6,  "US-NE 000.XX"},
        {40.714974,   -99.207940875,  4, 6,  "US-NE 500.XX"},
        {41.409974,   -96.5893465,    4, 9,  "US-NE B00.XX"},
        {40.593804,   -98.524178875,  4, 6,  "US-NE H00.XX"},
        {41.138504,   -100.8829995,   4, 6,  "US-NE M00.XX"},
        {42.040904,   -97.5422205,    4, 7,  "US-NE R00.XX"},
        {41.412904,   -97.4211995,    4, 6,  "US-NE W00.XX"},
        {40.4876425,  -103.95034,     3, 8,  "US-NE 1234.XX"},
        {40.1720915,  -100.9469025,   3, 5,  "US-NE 12.XXXX"},
        {40.369376,   -98.176491,     3, 5,  "US-NE 123.XXX"},
        {41.500705,   -99.6841,       3, 5,  "US-NE 9L27.SKD"},
        {37.7271,     -97.3813925,    5, 7,  "US-KS 12.XX"},
        {38.797874,   -94.949942625,  4, 7,  "US-KS 00.XXX"},
        {37.701314,   -97.5473885,    4, 6,  "US-KS J0.XXX"},
        {39.089624,   -95.83490625,   4, 6,  "US-KS 000.XX"},
        {39.029145,   -95.39167525,   4, 9,  "US-KS 800.XX"},
        {39.225624,   -96.72890625,   4, 6,  "US-KS J00.XX"},
        {38.858604,   -97.729989625,  4, 6,  "US-KS S00.XX"},
        {38.631589,   -101.960613,    3, 5,  "US-KS 1234.XX"},
        {37.3125455,  -99.5058675,    3, 5,  "US-KS 12.XXXX"},
        {37.477074,   -97.087676,     3, 5,  "US-KS 123.XXX"},
        {38.49665,    -98.316,        3, 5,  "US-KS CTW6.KRM"},
        {43.6448,     -116.285204,    5, 8,  "US-ID 12.XX"},
        {43.573395,   -116.9462125,   4, 10, "US-ID 12.XXX"},
        {43.500704,   -112.1902715,   4, 7,  "US-ID 000.XX"},
        {42.914944,   -112.619772,    4, 7,  "US-ID 700.XX"},
        {47.813145,   -117.04366875,  4, 10, "US-ID F00.XX"},
        {42.731145,   -114.576695,    4, 7,  "US-ID M00.XX"},
        {46.480244,   -117.06638,     4, 10, "US-ID T00.XX"},
        {42.3023715,  -117.2298985,   3, 9,  "US-ID 123.XXX"},
        {42.079091,   -114.04242,     3, 6,  "US-ID 12.XXXX"},
        {48.5631755,  -117.0364375,   3, 11, "US-ID 0123.XX"},
        {48.5631755,  -116.5364375,   3, 8,  "US-ID 1123.XX"},
        {47.94858,    -117.0459325,   3, 9,  "US-ID 2123.XX"},
        {47.94858,    -116.3532685,   3, 6,  "US-ID 3123.XX"},
        {47.45754,    -117.045961,    3, 9,  "US-ID 4123.XX"},
        {47.45754,    -116.358505,    3, 6,  "US-ID 5123.XX"},
        {47.45754,    -116.221013,    4, 7,  "US-ID 6123.XX"},
        {46.963785,   -117.0407815,   3, 9,  "US-ID 7123.XX"},
        {46.963785,   -116.3585335,   3, 6,  "US-ID 8123.XX"},
        {46.963785,   -115.6762855,   3, 8,  "US-ID 9123.XX"},
        {46.472745,   -117.074922,    3, 9,  "US-ID B123.XX"},
        {46.472745,   -116.397882,    3, 6,  "US-ID C123.XX"},
        {46.472745,   -115.720842,    3, 8,  "US-ID D123.XX"},
        {46.472745,   -115.043802,    3, 9,  "US-ID F123.XX"},
        {46.472745,   -114.908394,    4, 10, "US-ID G123.XX"},
        {45.98442,    -117.069771,    3, 11, "US-ID H123.XX"},
        {45.98442,    -116.403147,    3, 6,  "US-ID J123.XX"},
        {45.98442,    -115.736523,    3, 8,  "US-ID K123.XX"},
        {45.98442,    -115.069899,    3, 8,  "US-ID L123.XX"},
        {45.98442,    -114.936574,    4, 9,  "US-ID M123.XX"},
        {45.49338,    -116.9312665,   3, 8,  "US-ID N123.XX"},
        {45.49338,    -116.2698505,   3, 6,  "US-ID P123.XX"},
        {45.49338,    -115.6084345,   3, 8,  "US-ID Q123.XX"},
        {45.49338,    -114.9470185,   3, 8,  "US-ID R123.XX"},
        {45.49338,    -114.2856025,   3, 8,  "US-ID S123.XX"},
        {44.999625,   -116.931295,    3, 8,  "US-ID T123.XX"},
        {44.999625,   -116.275087,    3, 6,  "US-ID V123.XX"},
        {44.999625,   -115.618879,    3, 8,  "US-ID W123.XX"},
        {44.999625,   -114.962671,    3, 8,  "US-ID X123.XX"},
        {44.999625,   -114.306463,    3, 8,  "US-ID Y123.XX"},
        {44.999625,   -114.04398,     4, 9,  "US-ID Z123.XX"},
        {45.495,      -114.1435,      3, 8,  "US-ID HV83.HDJ"},
        {40.7788,     -111.942978,    5, 7,  "US-UT 12.XX"},
        {40.5199275,  -112.118017,    4, 6,  "US-UT 12.XXX"},
        {40.310604,   -111.790965375, 4, 6,  "US-UT 000.XX"},
        {40.091944,   -111.814985375, 4, 6,  "US-UT 700.XX"},
        {41.176444,   -112.1801435,   4, 6,  "US-UT F00.XX"},
        {41.384244,   -112.1758435,   4, 6,  "US-UT M00.XX"},
        {37.133744,   -113.710805875, 4, 6,  "US-UT T00.XX"},
        {39.3792175,  -114.039965,    3, 8,  "US-UT 123.XXX"},
        {39.1668695,  -111.4422815,   3, 5,  "US-UT 12.XXXX"},
        {37.6973775,  -113.8754335,   3, 5,  "US-UT 1234.XX"},
        {39.4996,     -111.547,       3, 5,  "US-UT L3VW.JZ0"},
        {45.0174,     -93.309746,     5, 10, "US-MN 12.XX"},
        {45.179815,   -93.561005,     4, 9,  "US-MN 12.XXX"},
        {44.052524,   -92.686254,     4, 10, "US-MN 000.XX"},
        {46.808324,   -92.345105,     4, 12, "US-MN 800.XX"},
        {45.620924,   -94.37310825,   4, 9,  "US-MN J00.XX"},
        {44.674904,   -93.429129375,  4, 9,  "US-MN S00.XX"},
        {46.1095835,  -94.728339,     3, 8,  "US-MN 123.XXX"},
        {48.59872,    -94.635011,     3, 8,  "US-MN 12.XXXX"},
        {46.788491,   -96.9428725,    3, 10, "US-MN 1234.XX"},
        {46.43725,    -93.35975,      3, 8,  "US-MN Q65T.FYL"},
        {42.3999,     -83.0976605,    5, 10, "US-MI 12.XX"},
        {42.60115,    -83.484758,     4, 9,  "US-MI 12.XXX"},
        {42.990304,   -85.829301,     4, 9,  "US-MI 000.XX"},
        {42.756744,   -84.688372,     4, 9,  "US-MI 700.XX"},
        {42.327645,   -83.8456975,    4, 9,  "US-MI F00.XX"},
        {43.128245,   -83.814095,     4, 9,  "US-MI M00.XX"},
        {42.197545,   -83.4056975,    4, 9,  "US-MI T00.XX"},
        {43.564819,   -86.412838,     3, 8,  "US-MI 123.XXX"},
        {46.69558,    -86.295026,     3, 8,  "US-MI 12.XXXX"},
        {47.678672,   -89.272956,     3, 8,  "US-MI 1123.XX"},
        {47.77688,    -88.5854715,    3, 8,  "US-MI 2123.XX"},
        {43.994581,   -83.131403,     3, 8,  "US-MI 3123.XX"},
        {41.745865,   -87.05906,      3, 11, "US-MI 4123.XX"},
        {47.059965,   -88.9255725,    3, 9,  "US-MI B123.XX"},
        {47.059965,   -88.2433245,    3, 9,  "US-MI C123.XX"},
        {46.568925,   -90.426547,     3, 13, "US-MI D123.XX"},
        {46.568925,   -89.749507,     3, 14, "US-MI F123.XX"},
        {46.568925,   -89.072467,     3, 11, "US-MI G123.XX"},
        {46.568925,   -88.395427,     3, 11, "US-MI H123.XX"},
        {46.568925,   -87.718387,     3, 11, "US-MI J123.XX"},
        {46.0806,     -90.421396,     3, 13, "US-MI K123.XX"},
        {46.0806,     -89.754772,     3, 14, "US-MI L123.XX"},
        {46.0806,     -89.088148,     3, 11, "US-MI M123.XX"},
        {46.0806,     -88.421524,     3, 11, "US-MI N123.XX"},
        {46.0806,     -87.7549,       3, 11, "US-MI P123.XX"},
        {46.0806,     -87.088276,     3, 11, "US-MI Q123.XX"},
        {45.58956,    -89.0829685,    3, 11, "US-MI R123.XX"},
        {45.58956,    -88.4215525,    3, 11, "US-MI S123.XX"},
        {45.58956,    -87.7601365,    3, 11, "US-MI T123.XX"},
        {45.58956,    -87.0987205,    3, 11, "US-MI V123.XX"},
        {45.095805,   -88.090873,     3, 11, "US-MI W123.XX"},
        {45.095805,   -87.434665,     3, 11, "US-MI X123.XX"},
        {45.095805,   -86.778457,     3, 11, "US-MI Y123.XX"},
        {44.995,      -86.28125,      3, 8,  "US-MI 7TZ7.VGF"},
        {41.1722,     -104.8548185,   5, 7,  "US-WY 12.XX"},
        {41.276994,   -104.9806255,   4, 6,  "US-WY 00.XXX"},
        {41.569114,   -109.5535065,   4, 9,  "US-WY J0.XXX"},
        {42.882974,   -106.443967,    4, 7,  "US-WY 000.XX"},
        {41.326974,   -105.7187465,   4, 6,  "US-WY 500.XX"},
        {44.291974,   -105.636455375, 4, 7,  "US-WY B00.XX"},
        {44.802804,   -107.077262875, 4, 9,  "US-WY H00.XX"},
        {41.273804,   -111.0568995,   4, 9,  "US-WY M00.XX"},
        {43.030804,   -108.513781,    4, 7,  "US-WY R00.XX"},
        {43.485804,   -110.9302415,   4, 7,  "US-WY W00.XX"},
        {42.0470055,  -110.9485235,   3, 6,  "US-WY 12.XXXX"},
        {42.342603,   -108.6559125,   3, 6,  "US-WY 1234.XX"},
        {42.2810935,  -106.38578,     3, 6,  "US-WY 123.XXX"},
        {43.00035,    -107.5375,      3, 6,  "US-WY TQY0.3G7"},
        {45.5581,     -122.7100865,   5, 11, "US-OR 12.XX"},
        {45.517995,   -123.115963,    4, 7,  "US-OR 12.XXX"},
        {44.135545,   -123.244294,    4, 7,  "US-OR 000.XX"},
        {45.022945,   -123.248684375, 4, 7,  "US-OR 700.XX"},
        {44.664845,   -123.389686875, 4, 7,  "US-OR F00.XX"},
        {42.481545,   -122.9766975,   4, 7,  "US-OR M00.XX"},
        {44.083244,   -121.460824,    4, 7,  "US-OR T00.XX"},
        {44.2981765,  -124.429501,    3, 6,  "US-OR 123.XXX"},
        {44.0899875,  -120.504142,    3, 6,  "US-OR 12.XXXX"},
        {46.0049635,  -123.8457565,   3, 9,  "US-OR 1234.XX"},
        {44.145425,   -120.6316,      3, 6,  "US-OR 68YR.89V"},
        {39.7741,     -105.033836,    5, 7,  "US-CO 12.XX"},
        {39.962515,   -105.20853,     5, 7,  "US-CO 12.XXX"},
        {38.974445,   -104.87701125,  4, 6,  "US-CO 000.XX"},
        {38.794545,   -104.857385125, 4, 6,  "US-CO 400.XX"},
        {40.607224,   -105.152688375, 4, 6,  "US-CO 700.XX"},
        {40.457465,   -105.151858875, 4, 6,  "US-CO B00.XX"},
        {38.342024,   -104.681755625, 4, 6,  "US-CO F00.XX"},
        {40.031194,   -105.297593375, 4, 6,  "US-CO J00.XX"},
        {40.447545,   -104.822658875, 4, 6,  "US-CO M00.XX"},
        {40.151594,   -105.201193375, 4, 6,  "US-CO Q00.XX"},
        {39.125745,   -108.67360725,  4, 6,  "US-CO T00.XX"},
        {39.479845,   -104.919709375, 4, 6,  "US-CO X00.XX"},
        {40.9580995,  -105.3082885,   3, 5,  "US-CO 123.XXX"},
        {40.6519015,  -108.841265,    3, 5,  "US-CO 12.XXXX"},
        {37.852753,   -108.8084095,   3, 5,  "US-CO 1234.XX"},
        {38.997936,   -105.5508905,   3, 5,  "US-CO V694.Y5Z"},
        {36.1645,     -115.20631,     5, 9,  "US-NV 12.XX"},
        {36.229935,   -115.380485,    4, 8,  "US-NV 12.XXX"},
        {39.215461,   -119.996637,    4, 8,  "US-NV 123.XX"},
        {37.5695785,  -117.163108,    3, 7,  "US-NV 123.XXX"},
        {41.230061,   -119.799729,    3, 7,  "US-NV 12.XXXX"},
        {38.4882215,  -116.901553,    3, 7,  "US-NV 1234.XX"},
        {38.48,       -117.0235,      3, 7,  "US-NV BRMB.DWP"},
        {33.4831,     -112.1185665,   5, 7,  "US-AZ 12.XX"},
        {32.4060555,  -111.222333,    4, 6,  "US-AZ 12.XXX"},
        {33.689729,   -112.446646,    4, 6,  "US-AZ 012.XX"},
        {33.689729,   -112.342858,    4, 6,  "US-AZ 112.XX"},
        {33.689729,   -112.23907,     4, 6,  "US-AZ 212.XX"},
        {33.689729,   -112.135282,    4, 6,  "US-AZ 312.XX"},
        {33.689729,   -112.031494,    4, 6,  "US-AZ 412.XX"},
        {33.689729,   -111.927706,    4, 6,  "US-AZ 512.XX"},
        {33.603239,   -112.3211995,   4, 6,  "US-AZ 612.XX"},
        {33.603239,   -112.2183725,   4, 6,  "US-AZ 712.XX"},
        {33.603239,   -112.1155455,   4, 6,  "US-AZ 812.XX"},
        {33.603239,   -112.0127185,   4, 6,  "US-AZ 912.XX"},
        {33.603239,   -111.9098915,   4, 6,  "US-AZ B12.XX"},
        {33.516749,   -112.3983195,   4, 6,  "US-AZ C12.XX"},
        {33.516749,   -112.2954925,   4, 6,  "US-AZ D12.XX"},
        {33.516749,   -112.1926655,   4, 6,  "US-AZ F12.XX"},
        {33.516749,   -112.0898385,   4, 6,  "US-AZ G12.XX"},
        {33.516749,   -111.9870115,   4, 6,  "US-AZ H12.XX"},
        {33.473504,   -111.8841845,   4, 6,  "US-AZ J12.XX"},
        {33.473504,   -111.7813575,   4, 6,  "US-AZ K12.XX"},
        {33.473504,   -111.6785305,   4, 6,  "US-AZ L12.XX"},
        {33.430259,   -112.1926655,   4, 6,  "US-AZ M12.XX"},
        {33.430259,   -112.0898385,   5, 7,  "US-AZ N12.XX"},
        {33.430259,   -111.9870115,   4, 6,  "US-AZ P12.XX"},
        {33.387014,   -111.8841845,   4, 6,  "US-AZ Q12.XX"},
        {33.387014,   -111.7813575,   4, 6,  "US-AZ R12.XX"},
        {33.387014,   -111.6785305,   4, 6,  "US-AZ S12.XX"},
        {33.456206,   -111.5757035,   4, 6,  "US-AZ T12.XX"},
        {33.343769,   -112.0898385,   4, 6,  "US-AZ V12.XX"},
        {33.343769,   -111.9870115,   4, 6,  "US-AZ W12.XX"},
        {33.300524,   -111.8841845,   4, 6,  "US-AZ X12.XX"},
        {33.300524,   -111.7813575,   4, 6,  "US-AZ Y12.XX"},
        {33.300524,   -111.6785305,   4, 6,  "US-AZ Z12.XX"},
        {34.1702735,  -113.023555,    3, 5,  "US-AZ 123.XXX"},
        {36.8358485,  -112.939386,    3, 5,  "US-AZ 12.XXXX"},
        {32.2744575,  -114.762784,    3, 13, "US-AZ 1234.XX"},
        {34.1681305,  -111.9317105,   3, 5,  "US-AZ KMRR.GN6"},
        {35.1191,     -106.6954085,   5, 7,  "US-NM 12.XX"},
        {34.866742,   -106.7896935,   4, 6,  "US-NM 12.XXX"},
        {35.648344,   -106.13766,     4, 7,  "US-NM 000.XX"},
        {32.329474,   -106.867591,    4, 6,  "US-NM 600.XX"},
        {33.409974,   -104.638132375, 4, 7,  "US-NM C00.XX"},
        {36.824961,   -108.25017225,  4, 6,  "US-NM J00.XX"},
        {34.418574,   -103.356142625, 4, 7,  "US-NM P00.XX"},
        {32.733974,   -103.267595625, 4, 7,  "US-NM V00.XX"},
        {36.9549985,  -108.4078535,   3, 5,  "US-NM 123.XXX"},
        {34.088023,   -108.860982,    3, 5,  "US-NM 12.XXXX"},
        {34.3459025,  -105.912056,    4, 7,  "US-NM 1234.XX"},
        {34.166147,   -106.026119,    3, 6,  "US-NM TPZN.LJJ"},
        {45.777675,   -108.6132535,   5, 8,  "US-MT 12.XX"},
        {45.697315,   -108.822163125, 4, 7,  "US-MT 00.XXX"},
        {46.880344,   -114.341014875, 4, 10, "US-MT C0.XXX"},
        {47.609984,   -111.56680825,  4, 8,  "US-MT P0.XXX"},
        {45.735444,   -111.26553925,  4, 8,  "US-MT 000.XX"},
        {46.013874,   -112.655012625, 3, 7,  "US-MT 600.XX"},
        {46.642274,   -112.133555,    4, 8,  "US-MT C00.XX"},
        {48.169974,   -114.424380125, 4, 8,  "US-MT J00.XX"},
        {48.565974,   -109.8289225,   3, 6,  "US-MT P00.XX"},
        {46.423974,   -105.980555,    4, 7,  "US-MT V00.XX"},
        {48.7259565,  -115.3950315,   3, 9,  "US-MT 123.XXX"},
        {47.71323,    -111.4995115,   3, 7,  "US-MT 12.XXXX"},
        {47.78019,    -107.8144795,   3, 6,  "US-MT 1234.XX"},
        {46.680355,   -110.034002,    3, 6,  "US-MT Q120.69B"},
        {34.0821,     -118.300968,    5, 7,  "US-CA 12.XX"},
        {34.017894,   -118.408249,    4, 6,  "US-CA 12.XXX"},
        {36.728514,   -119.84770825,  4, 8,  "US-CA 000.XX"},
        {38.562514,   -121.544314625, 4, 6,  "US-CA 200.XX"},
        {37.878545,   -122.3107175,   4, 6,  "US-CA 400.XX"},
        {32.763124,   -117.186650625, 4, 6,  "US-CA 600.XX"},
        {32.763124,   -117.084065625, 4, 6,  "US-CA 700.XX"},
        {32.676635,   -117.114840625, 4, 11, "US-CA 800.XX"},
        {37.798085,   -122.5143175,   4, 6,  "US-CA 900.XX"},
        {37.733915,   -122.5080175,   4, 6,  "US-CA B00.XX"},
        {37.379724,   -122.0546755,   4, 6,  "US-CA C00.XX"},
        {37.379724,   -121.9460835,   4, 6,  "US-CA D00.XX"},
        {35.413724,   -119.06872,     4, 8,  "US-CA F00.XX"},
        {33.980724,   -117.448816,    4, 6,  "US-CA G00.XX"},
        {38.007224,   -121.347814125, 4, 6,  "US-CA H00.XX"},
        {37.698324,   -121.0410755,   4, 6,  "US-CA J00.XX"},
        {37.578524,   -122.0512755,   4, 6,  "US-CA K00.XX"},
        {34.186545,   -118.338228125, 4, 6,  "US-CA L00.XX"},
        {33.685524,   -118.03273,     4, 6,  "US-CA M00.XX"},
        {33.719524,   -117.842916,    5, 7,  "US-CA N00.XX"},
        {34.101824,   -117.805716,    5, 7,  "US-CA P00.XX"},
        {34.107024,   -117.702916,    4, 6,  "US-CA Q00.XX"},
        {34.149424,   -117.606116,    4, 6,  "US-CA R00.XX"},
        {34.140724,   -117.505216,    4, 6,  "US-CA S00.XX"},
        {34.166024,   -117.341654625, 4, 6,  "US-CA T00.XX"},
        {38.490724,   -122.771466625, 4, 6,  "US-CA V00.XX"},
        {36.726024,   -121.68769725,  4, 6,  "US-CA W00.XX"},
        {33.909224,   -117.618816,    4, 6,  "US-CA X00.XX"},
        {34.171545,   -118.173882125, 4, 6,  "US-CA Y00.XX"},
        {37.707724,   -122.1534755,   4, 6,  "US-CA Z00.XX"},
        {41.366353,   -124.2456935,   3, 5,  "US-CA 0123.XX"},
        {41.366353,   -123.6259415,   3, 5,  "US-CA 1123.XX"},
        {41.366353,   -123.0061895,   3, 5,  "US-CA 2123.XX"},
        {41.366353,   -122.3864375,   3, 5,  "US-CA 3123.XX"},
        {40.875313,   -124.183747,    3, 5,  "US-CA 4123.XX"},
        {40.875313,   -123.569203,    3, 5,  "US-CA 5123.XX"},
        {40.875313,   -122.954659,    3, 5,  "US-CA 6123.XX"},
        {40.875313,   -122.340115,    3, 5,  "US-CA 7123.XX"},
        {40.384273,   -124.404982,    3, 5,  "US-CA 8123.XX"},
        {40.384273,   -123.790438,    3, 5,  "US-CA 9123.XX"},
        {40.384273,   -123.175894,    3, 5,  "US-CA B123.XX"},
        {40.384273,   -122.56135,     3, 5,  "US-CA C123.XX"},
        {39.893233,   -124.3629305,   3, 5,  "US-CA D123.XX"},
        {39.893233,   -123.7535945,   3, 5,  "US-CA F123.XX"},
        {39.893233,   -123.1442585,   3, 5,  "US-CA G123.XX"},
        {39.893233,   -122.5349225,   3, 5,  "US-CA H123.XX"},
        {39.402193,   -123.918143,    3, 5,  "US-CA J123.XX"},
        {39.402193,   -123.314015,    3, 5,  "US-CA K123.XX"},
        {39.402193,   -122.709887,    3, 5,  "US-CA L123.XX"},
        {39.402193,   -122.105759,    3, 5,  "US-CA M123.XX"},
        {39.402193,   -121.501631,    3, 5,  "US-CA N123.XX"},
        {38.913868,   -123.8283865,   3, 5,  "US-CA P123.XX"},
        {38.913868,   -123.2294665,   3, 5,  "US-CA Q123.XX"},
        {38.913868,   -122.6305465,   3, 5,  "US-CA R123.XX"},
        {38.913868,   -122.0316265,   3, 5,  "US-CA S123.XX"},
        {38.913868,   -121.4327065,   3, 5,  "US-CA T123.XX"},
        {38.443275,   -123.674815,    3, 5,  "US-CA 01.XXXX"},
        {38.443275,   -123.081103,    3, 5,  "US-CA 11.XXXX"},
        {38.443275,   -122.487391,    3, 5,  "US-CA 21.XXXX"},
        {38.443275,   -121.893679,    3, 5,  "US-CA 31.XXXX"},
        {38.443275,   -121.299967,    3, 5,  "US-CA 41.XXXX"},
        {37.952235,   -123.0761815,   3, 5,  "US-CA 51.XXXX"},
        {37.952235,   -122.4876775,   3, 5,  "US-CA 61.XXXX"},
        {37.952235,   -121.8991735,   3, 5,  "US-CA 71.XXXX"},
        {37.952235,   -121.3106695,   4, 6,  "US-CA 81.XXXX"},
        {37.461195,   -122.7054245,   3, 5,  "US-CA 91.XXXX"},
        {37.461195,   -122.1169205,   3, 5,  "US-CA B1.XXXX"},
        {37.461195,   -121.5284165,   3, 5,  "US-CA C1.XXXX"},
        {37.461195,   -120.9399125,   3, 5,  "US-CA D1.XXXX"},
        {36.970155,   -122.411459,    3, 5,  "US-CA F1.XXXX"},
        {36.970155,   -121.828163,    3, 5,  "US-CA G1.XXXX"},
        {36.970155,   -121.244867,    3, 5,  "US-CA H1.XXXX"},
        {36.970155,   -120.661571,    3, 5,  "US-CA J1.XXXX"},
        {36.970155,   -120.078275,    3, 5,  "US-CA K1.XXXX"},
        {36.479115,   -121.9515665,   3, 5,  "US-CA L1.XXXX"},
        {36.479115,   -121.3734785,   3, 5,  "US-CA M1.XXXX"},
        {36.479115,   -120.7953905,   3, 5,  "US-CA N1.XXXX"},
        {36.479115,   -120.2173025,   3, 5,  "US-CA P1.XXXX"},
        {36.479115,   -119.6392145,   3, 7,  "US-CA Q1.XXXX"},
        {35.988075,   -121.402669,    3, 5,  "US-CA R1.XXXX"},
        {35.988075,   -120.829789,    3, 5,  "US-CA S1.XXXX"},
        {35.988075,   -120.256909,    3, 5,  "US-CA T1.XXXX"},
        {35.988075,   -119.684029,    3, 7,  "US-CA V1.XXXX"},
        {35.988075,   -119.111149,    3, 7,  "US-CA W1.XXXX"},
        {35.497035,   -120.887077,    3, 5,  "US-CA X1.XXXX"},
        {35.497035,   -120.314197,    3, 5,  "US-CA Y1.XXXX"},
        {35.497035,   -119.741317,    3, 7,  "US-CA Z1.XXXX"},
        {35.908875,   -119.168437,    3, 7,  "US-CA 012.XXX"},
        {35.908875,   -118.595557,    3, 7,  "US-CA 112.XXX"},
        {35.417835,   -120.8993425,   3, 5,  "US-CA 212.XXX"},
        {35.417835,   -120.3316705,   3, 5,  "US-CA 312.XXX"},
        {35.417835,   -119.7639985,   3, 7,  "US-CA 412.XXX"},
        {35.417835,   -119.1963265,   3, 7,  "US-CA 512.XXX"},
        {35.417835,   -118.6286545,   3, 7,  "US-CA 612.XXX"},
        {35.417835,   -118.0609825,   3, 7,  "US-CA 712.XXX"},
        {34.926795,   -120.65553,     3, 5,  "US-CA 812.XXX"},
        {34.926795,   -120.093066,    3, 5,  "US-CA 912.XXX"},
        {34.926795,   -119.530602,    3, 5,  "US-CA B12.XXX"},
        {34.926795,   -118.968138,    3, 5,  "US-CA C12.XXX"},
        {34.926795,   -118.405674,    3, 5,  "US-CA D12.XXX"},
        {34.926795,   -117.84321,     3, 5,  "US-CA F12.XXX"},
        {34.926795,   -117.280746,    3, 5,  "US-CA G12.XXX"},
        {34.383026,   -120.463867,    3, 5,  "US-CA H12.XXX"},
        {34.435815,   -119.329578,    3, 5,  "US-CA J12.XXX"},
        {34.435815,   -118.767114,    3, 5,  "US-CA K12.XXX"},
        {34.435815,   -118.20465,     3, 5,  "US-CA L12.XXX"},
        {34.435815,   -117.642186,    3, 5,  "US-CA M12.XXX"},
        {34.435815,   -117.079722,    3, 5,  "US-CA N12.XXX"},
        {33.944775,   -118.4640865,   3, 5,  "US-CA P12.XXX"},
        {33.944775,   -117.9068305,   4, 6,  "US-CA Q12.XXX"},
        {33.944775,   -117.3495745,   4, 6,  "US-CA R12.XXX"},
        {33.944775,   -116.7923185,   3, 5,  "US-CA S12.XXX"},
        {33.748359,   -116.2350625,   3, 5,  "US-CA T12.XXX"},
        {33.453734,   -117.73994,     3, 5,  "US-CA V12.XXX"},
        {33.453734,   -117.187892,    3, 5,  "US-CA W12.XXX"},
        {32.973635,   -117.270699,    3, 5,  "US-CA X12.XXX"},
        {32.973635,   -116.718651,    3, 5,  "US-CA Y12.XXX"},
        {32.715275,   -115.717862,    3, 10, "US-CA Z12.XXX"},
        {34.826446,   -124.1972845,   2, 4,  "US-CA 1234.XXX"},
        {29.7981,     -95.4058825,    4, 6,  "US-TX 12.XX"},
        {33.081323,   -97.052655,     4, 6,  "US-TX 12.XXX"},
        {30.247514,   -97.813446125,  5, 7,  "US-TX 000.XX"},
        {32.718614,   -97.402382625,  4, 6,  "US-TX 200.XX"},
        {31.771614,   -106.53203425,  3, 13, "US-TX 400.XX"},
        {32.783744,   -97.189733125,  4, 6,  "US-TX 600.XX"},
        {27.802824,   -97.466264375,  4, 6,  "US-TX 800.XX"},
        {27.546595,   -99.527746875,  3, 15, "US-TX 900.XX"},
        {29.846924,   -95.508868375,  4, 6,  "US-TX B00.XX"},
        {29.890168,   -95.409646375,  4, 6,  "US-TX C00.XX"},
        {29.846924,   -95.310424375,  4, 6,  "US-TX D00.XX"},
        {29.760435,   -95.508868375,  4, 6,  "US-TX F00.XX"},
        {29.71719,    -95.409646375,  4, 6,  "US-TX G00.XX"},
        {29.760435,   -95.310424375,  4, 6,  "US-TX H00.XX"},
        {29.71719,    -95.211202375,  4, 6,  "US-TX J00.XX"},
        {29.480224,   -98.680768375,  5, 7,  "US-TX K00.XX"},
        {29.480224,   -98.581546375,  5, 7,  "US-TX L00.XX"},
        {29.480224,   -98.482324375,  5, 7,  "US-TX M00.XX"},
        {29.393735,   -98.680542625,  5, 7,  "US-TX N00.XX"},
        {29.393735,   -98.581801625,  5, 7,  "US-TX P00.XX"},
        {29.393735,   -98.483060625,  5, 7,  "US-TX Q00.XX"},
        {33.608224,   -101.920276375, 3, 5,  "US-TX R00.XX"},
        {35.244224,   -101.88872,     3, 6,  "US-TX S00.XX"},
        {25.970724,   -97.525086125,  3, 10, "US-TX T00.XX"},
        {30.130724,   -94.186894125,  4, 6,  "US-TX V00.XX"},
        {26.260724,   -98.285086125,  3, 10, "US-TX W00.XX"},
        {31.583924,   -97.20968525,   5, 7,  "US-TX X00.XX"},
        {32.490724,   -99.787912,     3, 5,  "US-TX Y00.XX"},
        {33.940724,   -98.568816,     4, 9,  "US-TX Z00.XX"},
        {31.4441615,  -96.5848065,    3, 5,  "US-TX 123.XXX"},
        {31.252108,   -99.549237,     4, 6,  "US-TX 12.XXXX"},
        {34.000258,   -98.5912915,    3, 8,  "US-TX 1234.XX"},
        {36.1625625,  -102.968741,    2, 5,  "US-TX B123.XXX"},
        {34.577121,   -102.957458,    2, 5,  "US-TX C123.XXX"},
        {34.577121,   -100.0378,      2, 5,  "US-TX D123.XXX"},
        {33.583608,   -97.1556735,    3, 5,  "US-TX F123.XXX"},
        {30.8283985,  -106.5399545,   2, 9,  "US-TX G123.XXX"},
        {29.9865985,  -105.134847,    2, 9,  "US-TX H123.XXX"},
        {31.9036285,  -101.320199,    2, 4,  "US-TX J123.XXX"},
        {31.889706,   -98.683379,     4, 6,  "US-TX K123.XXX"},
        {31.889706,   -96.047379,     3, 5,  "US-TX L123.XXX"},
        {29.736286,   -101.3217275,   2, 9,  "US-TX M123.XXX"},
        {29.72211,    -98.6848895,    4, 6,  "US-TX N123.XXX"},
        {29.856732,   -96.05415,      3, 5,  "US-TX P123.XXX"},
        {27.314653,   -99.763205,     2, 12, "US-TX Q123.XXX"},
        {31.7243935,  -99.63525,      3, 5,  "US-TX X123.XXX"},
        {29.553223,   -99.6362985,    4, 6,  "US-TX Z123.XXX"},
        {61.2161,     -149.902464,    5, 7,  "US-AK 12.XX"},
        {61.385805,   -150.07110075,  4, 6,  "US-AK 00.XXX"},
        {64.843175,   -147.9959825,   3, 5,  "US-AK J0.XXX"},
        {58.419374,   -134.675560125, 4, 9,  "US-AK 000.XX"},
        {61.554545,   -149.883530625, 4, 6,  "US-AK 600.XX"},
        {61.696545,   -149.883530625, 4, 6,  "US-AK C00.XX"},
        {61.69298,    -149.341530625, 5, 7,  "US-AK J00.XX"},
        {57.136204,   -135.50519025,  3, 8,  "US-AK P00.XX"},
        {55.436004,   -131.8086255,   3, 8,  "US-AK V00.XX"},
        {62.4789835,  -152.2904275,   3, 5,  "US-AK 123.XXX"},
        {57.04023,    -134.3059945,   3, 8,  "US-AK 12.XXXX"},
        {58.630971,   -136.8262795,   3, 8,  "US-AK 1234.XX"},
        {59.606402,   -140.8055475,   2, 5,  "US-AK 0123.XXX"},
        {71.2918835,  -160.5443065,   2, 4,  "US-AK 1123.XXX"},
        {70.270977,   -147.690442,    2, 4,  "US-AK 2123.XXX"},
        {70.270977,   -154.691327,    2, 4,  "US-AK 3123.XXX"},
        {67.498137,   -160.895034,    2, 4,  "US-AK 4123.XXX"},
        {67.498137,   -166.862034,    2, 4,  "US-AK 5123.XXX"},
        {67.5434595,  -147.0608975,   2, 4,  "US-AK 6123.XXX"},
        {67.5434595,  -153.4063805,   2, 4,  "US-AK 7123.XXX"},
        {67.5434595,  -159.7518635,   3, 5,  "US-AK 8123.XXX"},
        {66.460439,   -167.885179,    2, 4,  "US-AK 9123.XXX"},
        {64.849015,   -146.5376195,   2, 4,  "US-AK B123.XXX"},
        {64.849015,   -152.3170735,   2, 4,  "US-AK C123.XXX"},
        {64.849015,   -158.0965275,   2, 4,  "US-AK D123.XXX"},
        {64.849015,   -163.8759815,   2, 4,  "US-AK F123.XXX"},
        {64.849015,   -169.6554355,   2, 7,  "US-AK G123.XXX"},
        {61.1645915,  -173.479144,    2, 5,  "US-AK H123.XXX"},
        {62.138035,   -146.131872,    2, 4,  "US-AK J123.XXX"},
        {62.138035,   -151.464461,    3, 5,  "US-AK K123.XXX"},
        {62.138035,   -156.79705,     2, 4,  "US-AK L123.XXX"},
        {62.138035,   -162.129639,    2, 4,  "US-AK M123.XXX"},
        {62.138035,   -167.462228,    2, 4,  "US-AK N123.XXX"},
        {58.8997465,  -152.2083935,   2, 4,  "US-AK P123.XXX"},
        {59.395122,   -157.1560665,   2, 4,  "US-AK Q123.XXX"},
        {59.395122,   -162.1013725,   2, 4,  "US-AK R123.XXX"},
        {58.0574075,  -171.851077,    2, 4,  "US-AK S123.XXX"},
        {55.442162,   -162.572601,    2, 4,  "US-AK T123.XXX"},
        {54.1798445,  -167.07936,     2, 4,  "US-AK V123.XXX"},
        {53.196962,   -171.8349985,   2, 4,  "US-AK W123.XXX"},
        {52.619862,   -177.1667895,   2, 4,  "US-AK X123.XXX"},
        {52.619862,   177.5032105,    2, 4,  "US-AK Y123.XXX"},
        {52.699335,   172.459471,     2, 5,  "US-AK Z123.XXX"},
        {49.2866,     -123.178656,    5, 8,  "CA-BC 12.XX"},
        {49.2245145,  -123.25731,     4, 7,  "CA-BC 12.XXX"},
        {48.477745,   -123.5612625,   4, 10, "CA-BC 000.XX"},
        {48.519145,   -123.4433625,   4, 10, "CA-BC 100.XX"},
        {48.496545,   -123.3570625,   4, 10, "CA-BC 200.XX"},
        {49.071645,   -122.39265875,  4, 7,  "CA-BC 300.XX"},
        {49.930924,   -119.50105325,  4, 9,  "CA-BC 400.XX"},
        {49.189124,   -124.03119775,  4, 7,  "CA-BC 500.XX"},
        {49.244145,   -124.10294675,  4, 7,  "CA-BC 600.XX"},
        {53.928334,   -122.835696875, 3, 6,  "CA-BC 700.XX"},
        {49.192634,   -122.00174675,  4, 7,  "CA-BC 800.XX"},
        {50.065534,   -125.29155125,  4, 7,  "CA-BC 900.XX"},
        {54.321945,   -130.3540175,   3, 7,  "CA-BC B00.XX"},
        {49.347134,   -124.476215,    4, 7,  "CA-BC C00.XX"},
        {54.541434,   -128.6723335,   3, 6,  "CA-BC D00.XX"},
        {49.106945,   -117.81864675,  4, 9,  "CA-BC F00.XX"},
        {50.718224,   -120.4276315,   4, 7,  "CA-BC G00.XX"},
        {50.300424,   -119.33845325,  4, 9,  "CA-BC H00.XX"},
        {49.521324,   -119.647276,    4, 9,  "CA-BC J00.XX"},
        {49.720524,   -125.029376,    4, 7,  "CA-BC K00.XX"},
        {49.541524,   -115.826176,    4, 9,  "CA-BC L00.XX"},
        {56.285224,   -120.904284375, 3, 6,  "CA-BC M00.XX"},
        {49.286224,   -124.85949775,  4, 7,  "CA-BC N00.XX"},
        {50.755624,   -119.3176315,   4, 9,  "CA-BC P00.XX"},
        {49.876124,   -124.567176,    4, 7,  "CA-BC Q00.XX"},
        {55.801324,   -120.307580375, 3, 6,  "CA-BC R00.XX"},
        {52.178924,   -122.203378125, 3, 6,  "CA-BC S00.XX"},
        {49.528224,   -117.352876,    4, 9,  "CA-BC T00.XX"},
        {53.022324,   -122.53176925,  3, 6,  "CA-BC V00.XX"},
        {49.357224,   -117.74119775,  4, 9,  "CA-BC W00.XX"},
        {51.050724,   -118.27860975,  4, 9,  "CA-BC X00.XX"},
        {50.124364,   -120.83461775,  4, 7,  "CA-BC Y00.XX"},
        {49.663804,   -116.017451,    4, 9,  "CA-BC YK0.00"},
        {48.791064,   -123.7541725,   4, 10, "CA-BC Z00.XX"},
        {48.695455,   -123.4458375,   4, 10, "CA-BC ZK0.00"},
        {50.9089835,  -126.280049,    3, 6,  "CA-BC 123.XXX"},
        {51.414039,   -122.187883,    3, 6,  "CA-BC 12.XXXX"},
        {51.480999,   -118.241706,    3, 8,  "CA-BC 1234.XX"},
        {51.3500235,  -138.230592,    2, 6,  "CA-BC 1234.XXX"},
        {51.048724,   -114.10446425,  5, 10, "CA-AB 00.XX"},
        {53.501804,   -113.575094625, 5, 8,  "CA-AB J0.XX"},
        {51.113794,   -114.3327445,   4, 9,  "CA-AB 00.XXX"},
        {53.529814,   -113.80142275,  4, 7,  "CA-AB J0.XXX"},
        {52.264194,   -113.951191125, 4, 7,  "CA-AB 000.XX"},
        {49.671314,   -112.942602,    4, 7,  "CA-AB 300.XX"},
        {50.015014,   -110.80482025,  3, 6,  "CA-AB 500.XX"},
        {55.170214,   -118.9118025,   3, 8,  "CA-AB 700.XX"},
        {56.693814,   -111.50501625,  4, 7,  "CA-AB 900.XX"},
        {51.272214,   -114.11105675,  4, 9,  "CA-AB C00.XX"},
        {53.509514,   -114.04311025,  4, 7,  "CA-AB F00.XX"},
        {53.282514,   -113.59091025,  4, 7,  "CA-AB H00.XX"},
        {53.722014,   -113.275198375, 4, 7,  "CA-AB K00.XX"},
        {53.281214,   -110.20601025,  3, 6,  "CA-AB M00.XX"},
        {52.983614,   -112.89925225,  4, 7,  "CA-AB P00.XX"},
        {50.544514,   -111.9945385,   4, 7,  "CA-AB R00.XX"},
        {54.419714,   -110.3174865,   3, 6,  "CA-AB T00.XX"},
        {52.448814,   -113.835864125, 4, 7,  "CA-AB W00.XX"},
        {52.950014,   -113.47705225,  4, 7,  "CA-AB Y00.XX"},
        {51.6175835,  -115.2222075,   3, 9,  "CA-AB 123.XXX"},
        {54.10672,    -115.227472,    3, 8,  "CA-AB 12.XXXX"},
        {56.85487,    -115.4484935,   3, 8,  "CA-AB 1234.XX"},
        {59.234957,   -119.638849,    2, 7,  "CA-AB 1234.XXX"},
        {43.7011,     -79.432204,     4, 8,  "CA-ON 12.XX"},
        {43.8135635,  -79.810081,     4, 7,  "CA-ON 12.XXX"},
        {45.452545,   -75.75418125,   3, 10, "CA-ON 000.XX"},
        {45.482445,   -75.58256725,   3, 10, "CA-ON 100.XX"},
        {45.390845,   -75.82005425,   3, 9,  "CA-ON 200.XX"},
        {45.390845,   -75.69752825,   3, 9,  "CA-ON 300.XX"},
        {43.269524,   -79.9311955,    4, 7,  "CA-ON 400.XX"},
        {43.269524,   -79.8129935,    4, 7,  "CA-ON 500.XX"},
        {43.492524,   -80.5480955,    4, 7,  "CA-ON 600.XX"},
        {43.021124,   -81.361144,     4, 7,  "CA-ON 700.XX"},
        {43.021124,   -81.243903,     4, 7,  "CA-ON 800.XX"},
        {43.214734,   -79.2828925,    3, 7,  "CA-ON 900.XX"},
        {42.324324,   -83.0694915,    3, 11, "CA-ON B00.XX"},
        {43.931324,   -78.983548,     3, 7,  "CA-ON C00.XX"},
        {43.939973,   -78.894175,     3, 7,  "CA-ON D00.XX"},
        {43.403924,   -79.8469955,    4, 7,  "CA-ON F00.XX"},
        {43.419245,   -80.3748935,    4, 7,  "CA-ON G00.XX"},
        {44.421824,   -79.740912375,  4, 8,  "CA-ON H00.XX"},
        {43.584424,   -80.3204955,    4, 7,  "CA-ON J00.XX"},
        {44.272534,   -76.604868875,  3, 7,  "CA-ON K00.XX"},
        {46.524245,   -81.032175,     4, 7,  "CA-ON L00.XX"},
        {48.450345,   -89.3058425,    3, 6,  "CA-ON M00.XX"},
        {43.191124,   -80.3225955,    4, 7,  "CA-ON N00.XX"},
        {43.893724,   -79.118048,     3, 7,  "CA-ON P00.XX"},
        {43.145624,   -79.1534955,    3, 9,  "CA-ON Q00.XX"},
        {43.019124,   -82.439544,     3, 9,  "CA-ON R00.XX"},
        {45.355824,   -75.93902925,   3, 9,  "CA-ON S00.XX"},
        {44.340724,   -78.396612375,  3, 7,  "CA-ON T00.XX"},
        {46.545945,   -84.40414,      3, 9,  "CA-ON V00.XX"},
        {44.215124,   -77.441812375,  3, 7,  "CA-ON W00.XX"},
        {43.004664,   -79.295807,     3, 7,  "CA-ON X00.XX"},
        {46.301504,   -79.483535,     3, 9,  "CA-ON XK0.00"},
        {45.049294,   -74.778284375,  3, 9,  "CA-ON Y00.XX"},
        {42.400804,   -82.2263295,    3, 7,  "CA-ON YK0.00"},
        {48.489864,   -81.3787725,    3, 6,  "CA-ON Z00.XX"},
        {44.105004,   -77.609259375,  3, 7,  "CA-ON ZK0.00"},
        {45.2101615,  -81.6615155,    4, 7,  "CA-ON 123.XXX"},
        {47.690158,   -81.724681,     3, 6,  "CA-ON 1234.XX"},
        {45.660027,   -77.947036,     2, 8,  "CA-ON 12.XXXX"},
        {42.507037,   -94.6348755,    2, 8,  "CA-ON 1234.XXX"},
        {45.5491,     -73.6505865,    5, 8,  "CA-QC 12.XX"},
        {45.769215,   -73.8579185,    4, 7,  "CA-QC 12.XXX"},
        {46.906324,   -71.393424375,  5, 8,  "CA-QC 000.XX"},
        {46.906324,   -71.267294375,  5, 8,  "CA-QC 100.XX"},
        {46.819835,   -71.393424375,  5, 8,  "CA-QC 200.XX"},
        {46.819835,   -71.267294375,  5, 8,  "CA-QC 300.XX"},
        {46.733346,   -71.304569,     5, 8,  "CA-QC 400.XX"},
        {45.490434,   -75.81374425,   4, 9,  "CA-QC 500.XX"},
        {45.524065,   -75.69121825,   4, 9,  "CA-QC 600.XX"},
        {45.415405,   -71.99518125,   4, 7,  "CA-QC 700.XX"},
        {48.436545,   -71.2834125,    4, 7,  "CA-QC 800.XX"},
        {48.454634,   -71.1377955,    4, 7,  "CA-QC 900.XX"},
        {46.397624,   -72.61876,      4, 7,  "CA-QC B00.XX"},
        {45.328224,   -73.32462925,   5, 8,  "CA-QC C00.XX"},
        {45.901395,   -72.551542125,  4, 7,  "CA-QC D00.XX"},
        {45.833924,   -74.066394625,  4, 7,  "CA-QC F00.XX"},
        {45.450724,   -72.78762925,   4, 7,  "CA-QC G00.XX"},
        {46.620124,   -72.77586,      4, 7,  "CA-QC H00.XX"},
        {45.670524,   -73.00462925,   4, 7,  "CA-QC J00.XX"},
        {45.595624,   -73.24262925,   5, 8,  "CA-QC K00.XX"},
        {48.500524,   -68.5896195,    3, 6,  "CA-QC L00.XX"},
        {45.583624,   -74.00042925,   4, 7,  "CA-QC M00.XX"},
        {46.099124,   -72.021394625,  4, 7,  "CA-QC N00.XX"},
        {48.282145,   -79.056665625,  3, 7,  "CA-QC P00.XX"},
        {45.300645,   -74.19090125,   4, 7,  "CA-QC Q00.XX"},
        {46.056724,   -73.170594625,  4, 7,  "CA-QC R00.XX"},
        {48.138524,   -77.866354125,  4, 8,  "CA-QC S00.XX"},
        {46.160824,   -70.713994625,  4, 8,  "CA-QC T00.XX"},
        {48.603924,   -71.6983195,    4, 7,  "CA-QC V00.XX"},
        {50.273424,   -66.42925325,   3, 7,  "CA-QC W00.XX"},
        {45.412645,   -74.06104425,   4, 7,  "CA-QC X00.XX"},
        {46.120324,   -71.373794625,  5, 8,  "CA-QC Y00.XX"},
        {45.309724,   -72.19982925,   4, 7,  "CA-QC Z00.XX"},
        {46.293107,   -75.858715,     3, 7,  "CA-QC 123.XXX"},
        {48.2003005,  -79.2825445,    3, 7,  "CA-QC 12.XXXX"},
        {45.422604,   -71.786942,     4, 7,  "CA-QC 1234.XX"},
        {53.1270655,  -79.352986,     2, 6,  "CA-QC 1234.XXX"},
        {60.5933565,  -80.3509065,    2, 6,  "CA-QC 123.XXXX"},
        {52.1851,     -106.7200645,   5, 8,  "CA-SK 12.XX"},
        {52.242294,   -106.939037875, 4, 7,  "CA-SK 00.XXX"},
        {50.463114,   -104.83479275,  4, 7,  "CA-SK J0.XXX"},
        {53.210094,   -105.87980925,  4, 7,  "CA-SK 000.XX"},
        {50.382694,   -105.68139425,  4, 7,  "CA-SK 300.XX"},
        {51.230394,   -102.61358875,  4, 7,  "CA-SK 600.XX"},
        {50.292294,   -107.90979425,  4, 7,  "CA-SK 900.XX"},
        {52.764194,   -108.40224625,  4, 7,  "CA-SK D00.XX"},
        {49.133694,   -103.10689975,  4, 7,  "CA-SK H00.XX"},
        {49.657194,   -103.967747,    4, 7,  "CA-SK L00.XX"},
        {53.264814,   -110.00691025,  3, 9,  "CA-SK P00.XX"},
        {52.197314,   -105.163164125, 4, 7,  "CA-SK R00.XX"},
        {54.107614,   -108.5481865,   3, 6,  "CA-SK T00.XX"},
        {52.841314,   -104.71435225,  4, 7,  "CA-SK W00.XX"},
        {50.916014,   -102.87905675,  4, 7,  "CA-SK Y00.XX"},
        {53.4289835,  -109.832881,    3, 6,  "CA-SK 123.XXX"},
        {53.23693,    -105.5296615,   3, 6,  "CA-SK 12.XXXX"},
        {50.593275,   -107.877308,    3, 6,  "CA-SK 1234.XX"},
        {59.234957,   -109.694533,    2, 5,  "CA-SK 1234.XXX"},
        {49.9313,     -97.1870385,    5, 8,  "CA-MB 12.XX"},
        {50.138115,   -97.425215,     4, 7,  "CA-MB 12.XXX"},
        {49.849104,   -100.082949,    4, 7,  "CA-MB 000.XX"},
        {49.969604,   -98.39498925,   4, 7,  "CA-MB 400.XX"},
        {49.549804,   -96.765649,     4, 7,  "CA-MB 800.XX"},
        {55.752104,   -98.003059375,  4, 7,  "CA-MB D00.XX"},
        {49.169494,   -98.01319975,   4, 7,  "CA-MB J00.XX"},
        {54.762694,   -102.0060825,   3, 8,  "CA-MB M00.XX"},
        {51.144294,   -100.16818875,  4, 7,  "CA-MB Q00.XX"},
        {49.188294,   -98.24109975,   4, 7,  "CA-MB T00.XX"},
        {50.344894,   -97.37779425,   4, 7,  "CA-MB X00.XX"},
        {51.6175785,  -100.2508665,   3, 6,  "CA-MB 123.XXX"},
        {54.106715,   -100.256131,    3, 6,  "CA-MB 12.XXXX"},
        {56.854865,   -100.4771525,   3, 6,  "CA-MB 1234.XX"},
        {59.234957,   -101.537373,    2, 7,  "CA-MB 1234.XXX"},
        {47.6148,     -52.784772,     5, 7,  "CA-NL 12.XX"},
        {47.768215,   -53.28321,      4, 6,  "CA-NL 12.XXX"},
        {48.949204,   -58.07310775,   4, 8,  "CA-NL 000.XX"},
        {48.983545,   -54.67275875,   4, 6,  "CA-NL 400.XX"},
        {49.013845,   -55.76945875,   5, 7,  "CA-NL 700.XX"},
        {52.933494,   -67.01424625,   4, 9,  "CA-NL B00.XX"},
        {53.346205,   -60.54801025,   4, 8,  "CA-NL F00.XX"},
        {48.593624,   -58.6556625,    4, 8,  "CA-NL J00.XX"},
        {48.160994,   -54.054213125,  4, 6,  "CA-NL M00.XX"},
        {49.201194,   -57.51679975,   4, 8,  "CA-NL Q00.XX"},
        {47.177494,   -55.336934375,  4, 6,  "CA-NL T00.XX"},
        {47.054094,   -55.284234375,  4, 6,  "CA-NL X00.XX"},
        {49.2195835,  -56.3260255,    4, 6,  "CA-NL 123.XXX"},
        {49.912322,   -59.239515,     3, 7,  "CA-NL 12.XXXX"},
        {51.6252805,  -57.4772415,    4, 8,  "CA-NL 1234.XX"},
        {60.6174425,  -67.398312,     3, 9,  "CA-NL 123.XXXX"},
        {53.68875,    -60.303,        3, 7,  "CA-NL JGV0.2W4"},
        {45.3156,     -66.1124865,    5, 11, "CA-NB 12.XX"},
        {45.573615,   -66.3465185,    4, 10, "CA-NB 12.XXX"},
        {46.115244,   -64.931409625,  4, 10, "CA-NB 000.XX"},
        {45.925574,   -66.720612625,  4, 9,  "CA-NB 600.XX"},
        {47.650374,   -65.83923875,   4, 10, "CA-NB C00.XX"},
        {47.959274,   -66.819080125,  4, 10, "CA-NB J00.XX"},
        {47.413474,   -68.40473875,   4, 12, "CA-NB P00.XX"},
        {47.048574,   -65.693196375,  4, 11, "CA-NB V00.XX"},
        {46.3855245,  -67.715042,     4, 10, "CA-NB 123.XXX"},
        {47.2037055,  -68.8347,       3, 11, "CA-NB 12.XXXX"},
        {46.3185,     -66.399,        4, 10, "CA-NB 4Z07.JP7"},
        {44.6941,     -63.638846,     6, 8,  "CA-NS 12.XX"},
        {44.873815,   -63.8702835,    5, 10, "CA-NS 12.XXX"},
        {45.630374,   -62.79997125,   4, 8,  "CA-NS 000.XX"},
        {46.184874,   -60.290012625,  4, 8,  "CA-NS 500.XX"},
        {43.830074,   -66.179014,     4, 7,  "CA-NS B00.XX"},
        {45.376504,   -63.42496325,   4, 8,  "CA-NS H00.XX"},
        {45.605104,   -61.46776325,   5, 9,  "CA-NS M00.XX"},
        {45.860804,   -64.402563625,  4, 11, "CA-NS R00.XX"},
        {45.008704,   -64.202462875,  5, 12, "CA-NS W00.XX"},
        {45.2356445,  -65.765654,     3, 12, "CA-NS 123.XXX"},
        {43.979234,   -66.2412085,    3, 6,  "CA-NS 12.XXXX"},
        {45.7156525,  -61.5812665,    4, 8,  "CA-NS 1234.XX"},
        {45.292,      -63.04775,      3, 7,  "CA-NS CBYV.T9Y"},
        {46.274,      -63.18913,      5, 10, "CA-PE 12.XX"},
        {46.319595,   -63.804328,     4, 12, "CA-PE 12.XXX"},
        {46.160274,   -62.914698625,  4, 9,  "CA-PE 000.XX"},
        {47.051345,   -64.252671875,  4, 11, "CA-PE C00.XX"},
        {46.472545,   -62.428675,     4, 9,  "CA-PE P00.XX"},
        {46.864937,   -64.3574505,    3, 10, "CA-PE 123.XXX"},
        {46.547,      -63.1685,       3, 8,  "CA-PE C3DG.M4V"},
        {60.690686,   -135.1676595,   5, 11, "CA-YT 12.XX"},
        {60.944515,   -135.5051635,   4, 10, "CA-YT 12.XXX"},
        {64.039024,   -139.525297375, 4, 8,  "CA-YT 000.XX"},
        {60.162934,   -129.038232625, 4, 9,  "CA-YT 800.XX"},
        {60.808624,   -137.75416725,  4, 8,  "CA-YT J00.XX"},
        {62.140004,   -136.506447625, 4, 8,  "CA-YT S00.XX"},
        {62.6189835,  -138.7304275,   3, 7,  "CA-YT 123.XXX"},
        {62.42693,    -133.297966,    3, 9,  "CA-YT 12.XXXX"},
        {65.175079,   -139.755141,    3, 7,  "CA-YT 1234.XX"},
        {68.996685,   -140.4039385,   2, 6,  "CA-YT 1234.XXX"},
        {62.4836,     -114.474674,    5, 10, "CA-NT 12.XX"},
        {62.648615,   -114.851925,    4, 9,  "CA-NT 12.XXX"},
        {60.794104,   -116.03013025,  4, 8,  "CA-NT 000.XX"},
        {68.367004,   -133.818141,    4, 10, "CA-NT 400.XX"},
        {62.829304,   -116.198576875, 4, 8,  "CA-NT 800.XX"},
        {61.829004,   -121.557233125, 4, 7,  "CA-NT D00.XX"},
        {60.099545,   -112.167553125, 3, 7,  "CA-NT J00.XX"},
        {65.284794,   -126.9534095,   3, 8,  "CA-NT M00.XX"},
        {69.423594,   -133.21358525,  4, 10, "CA-NT Q00.XX"},
        {68.228594,   -135.242723,    4, 10, "CA-NT T00.XX"},
        {60.251394,   -123.543630625, 4, 7,  "CA-NT X00.XX"},
        {63.0471025,  -118.967416,    3, 7,  "CA-NT 123.XXX"},
        {62.426525,   -124.203518,    3, 8,  "CA-NT 12.XXXX"},
        {69.51509,    -136.250338,    3, 9,  "CA-NT 1234.XX"},
        {62.547183,   -135.306581,    2, 9,  "CA-NT 1234.XXX"},
        {78.4284555,  -135.510348,    2, 4,  "CA-NT 123.XXXX"},
        {63.7851,     -68.5853405,    5, 8,  "CA-NU 12.XX"},
        {63.950115,   -68.9816135,    4, 7,  "CA-NU 12.XXX"},
        {61.162904,   -94.28710675,   3, 6,  "CA-NU 000.XX"},
        {69.157544,   -105.35145925,  3, 8,  "CA-NU 700.XX"},
        {64.190544,   -83.4335795,    3, 6,  "CA-NU F00.XX"},
        {67.853844,   -115.35752375,  3, 8,  "CA-NU M00.XX"},
        {62.867344,   -92.353837875,  3, 6,  "CA-NU T00.XX"},
        {65.0289835,  -71.1917015,    3, 6,  "CA-NU 123.XXX"},
        {66.925679,   -120.863805,    2, 7,  "CA-NU 12.XXXX"},
        {60.273746,   -101.711845,    2, 5,  "CA-NU 1234.XX"},
        {61.899812,   -113.926778,    2, 8,  "CA-NU 1234.XXX"},
        {81.5568015,  -108.168619,    2, 4,  "CA-NU 123.XXXX"},
        {34.452256,   72.512561,      2, 9,  "IND 0123.XXX"},
        {34.452256,   75.012561,      2, 10, "IND 1123.XXX"},
        {33.897648,   77.5079215,     2, 9,  "IND 2123.XXX"},
        {33.8031485,  73.545259,      2, 11, "IND 3123.XXX"},
        {33.8031485,  76.673314,      2, 8,  "IND 4123.XXX"},
        {25.8244575,  82.718794,      2, 8,  "IND 5123.XXX"},
        {25.8244575,  85.608521,      2, 6,  "IND 6123.XXX"},
        {23.1269515,  82.7781545,     2, 8,  "IND 7123.XXX"},
        {23.1269515,  85.6380365,     2, 6,  "IND 8123.XXX"},
        {23.937687,   88.3961765,     2, 6,  "IND 9123.XXX"},
        {23.1269515,  68.4784745,     2, 6,  "IND B123.XXX"},
        {23.1269515,  71.3384105,     2, 8,  "IND C123.XXX"},
        {23.1269515,  74.1983465,     2, 12, "IND D123.XXX"},
        {23.1269515,  77.0582825,     2, 9,  "IND F123.XXX"},
        {23.1269515,  79.9182185,     2, 7,  "IND G123.XXX"},
        {20.278892,   72.702966,      2, 7,  "IND H123.XXX"},
        {20.278892,   75.602966,      2, 5,  "IND J123.XXX"},
        {20.278892,   78.502966,      2, 5,  "IND K123.XXX"},
        {20.278892,   81.402966,      2, 9,  "IND L123.XXX"},
        {20.278892,   84.302966,      2, 8,  "IND M123.XXX"},
        {17.9555125,  72.903212,      2, 6,  "IND N123.XXX"},
        {17.9555125,  75.703212,      2, 9,  "IND P123.XXX"},
        {17.9555125,  78.503212,      2, 11, "IND Q123.XXX"},
        {17.9555125,  81.303212,      2, 10, "IND R123.XXX"},
        {15.4855605,  73.5580535,     2, 5,  "IND S123.XXX"},
        {15.4855605,  76.2988255,     2, 10, "IND T123.XXX"},
        {15.4855605,  79.0395975,     2, 10, "IND V123.XXX"},
        {12.397974,   74.472839,      2, 5,  "IND W123.XXX"},
        {12.397974,   77.621043,      2, 11, "IND X123.XXX"},
        {10.5952995,  74.9415745,     2, 5,  "IND Y123.XXX"},
        {8.066279,    77.530191,      2, 5,  "IND Z123.XXX"},
        {30.929905,   72.2684785,     2, 6,  "IND B12.XXXX"},
        {30.929905,   75.317191,      3, 11, "IND C12.XXXX"},
        {30.929905,   78.355873,      2, 8,  "IND D12.XXXX"},
        {28.079146,   69.6152955,     2, 7,  "IND F12.XXXX"},
        {28.297278,   72.2995055,     2, 7,  "IND G12.XXXX"},
        {28.297278,   75.2488145,     2, 8,  "IND H12.XXXX"},
        {28.297278,   78.1981235,     2, 8,  "IND J12.XXXX"},
        {28.297278,   81.1474325,     2, 10, "IND K12.XXXX"},
        {28.297278,   84.0967415,     2, 10, "IND L12.XXXX"},
        {28.297278,   87.0460505,     2, 9,  "IND M12.XXXX"},
        {25.616088,   68.3402095,     2, 7,  "IND P12.XXXX"},
        {25.616088,   71.2299365,     2, 5,  "IND Q12.XXXX"},
        {25.616088,   74.1196635,     2, 7,  "IND R12.XXXX"},
        {25.616088,   77.0093905,     2, 10, "IND S12.XXXX"},
        {25.616088,   79.8991175,     2, 7,  "IND T12.XXXX"},
        {29.235694,   94.62265,       2, 10, "IND W12.XXXX"},
        {29.235694,   91.64355,       2, 10, "IND V12.XXXX"},
        {26.666057,   89.963711,      2, 7,  "IND X12.XXXX"},
        {26.666057,   92.883229,      2, 10, "IND Y12.XXXX"},
        {23.650625,   91.303458,      2, 9,  "IND Z12.XXXX"},
        {12.19793,    71.8298415,     2, 6,  "IND 512.XXXX"},
        {11.472836,   92.2797885,     2, 7,  "IND 612.XXXX"},
        {7.9814245,   92.2733745,     2, 5,  "IND 712.XXXX"},
        {30.929905,   74.51274,       3, 15, "IND 812.XXXX"},
        {35.48238,    73.75,          2, 11, "IND 61VS.0MVC"},
        {-12.357369,  114.3932595,    1, 3,  "AUS 1234.XXXX"},
        {2.5616895,   -72.495813,     1, 5,  "BRA 1234.XXXX"},
        {61.6698015,  176.874733,     1, 4,  "USA 1234.XXXX"},
        {18.49693,    -92.3776385,    3, 13, "MEX 312.XXXX"},
        {21.17812,    -92.405572,     2, 4,  "MEX 212.XXXX"},
        {19.998396,   -89.605218,     2, 10, "MEX 412.XXXX"},
        {20.960444,   -89.6368425,    2, 9,  "MEX 112.XXXX"},
        {29.765858,   -118.2905525,   2, 7,  "MEX 512.XXXX"},
        {20.21133,    -112.495072,    2, 4,  "MEX 612.XXXX"},
        {19.46223,    -115.944772,    2, 4,  "MEX 712.XXXX"},
        {23.769544,   -91.4890305,    2, 4,  "MEX 812.XXXX"},
        {18.713128,   -93.2713425,    3, 5,  "MEX 912.XXXX"},
        {32.5025285,  -117.151004,    2, 7,  "MEX 0123.XXX"},
        {31.7406495,  -116.6588575,   2, 8,  "MEX 1123.XXX"},
        {31.7406495,  -113.6201755,   2, 11, "MEX 2123.XXX"},
        {31.7406495,  -110.5814935,   2, 9,  "MEX 3123.XXX"},
        {31.7406495,  -107.5428115,   2, 9,  "MEX 4123.XXX"},
        {29.0316905,  -104.535115,    3, 11, "MEX 5123.XXX"},
        {29.0431445,  -116.3280385,   2, 7,  "MEX 6123.XXX"},
        {29.0431445,  -113.3489385,   2, 9,  "MEX 7123.XXX"},
        {29.0431445,  -110.3698385,   2, 7,  "MEX 8123.XXX"},
        {29.0431445,  -107.3907385,   2, 7,  "MEX 9123.XXX"},
        {29.0431445,  -104.4116385,   3, 11, "MEX B123.XXX"},
        {29.0431445,  -101.4325385,   3, 11, "MEX C123.XXX"},
        {26.3619545,  -113.5001535,   2, 9,  "MEX D123.XXX"},
        {23.7958955,  -110.7187425,   3, 9,  "MEX F123.XXX"},
        {26.3619545,  -108.6382615,   2, 12, "MEX G123.XXX"},
        {26.3619545,  -105.7187435,   2, 13, "MEX H123.XXX"},
        {26.3619545,  -102.7992255,   2, 11, "MEX J123.XXX"},
        {26.3619545,  -99.8797075,    2, 13, "MEX K123.XXX"},
        {23.6970805,  -106.7708815,   2, 9,  "MEX L123.XXX"},
        {23.6970805,  -103.9109455,   2, 10, "MEX M123.XXX"},
        {23.6970805,  -101.0510095,   2, 13, "MEX N123.XXX"},
        {23.6970805,  -98.1910735,    2, 7,  "MEX P123.XXX"},
        {21.0158905,  -105.6565795,   2, 10, "MEX Q123.XXX"},
        {21.0158905,  -102.8562255,   2, 8,  "MEX R123.XXX"},
        {21.0158905,  -100.0558715,   2, 10, "MEX S123.XXX"},
        {21.0158905,  -97.2555175,    2, 7,  "MEX T123.XXX"},
        {18.3183845,  -103.528196,    2, 7,  "MEX V123.XXX"},
        {18.3183845,  -100.757633,    2, 10, "MEX W123.XXX"},
        {18.350219,   -97.9858775,    2, 15, "MEX X123.XXX"},
        {18.7100665,  -95.215973,     3, 10, "MEX Y123.XXX"},
        {17.1678125,  -94.2474085,    3, 12, "MEX Z123.XXX"},
        {17.41,       -91.1651045,    3, 14, "MEX VVK2.1XFV"},
        {55.7841,     37.5480415,     5, 13, "RU-MOW 12.XX"},
        {55.954596,   37.218282,      4, 13, "RU-MOW 12.XXX"},
        {55.861895,   37.5755165,     4, 11, "RU-MOW FHH.HHH"},
        {55.569575,   37.2112385,     4, 10, "RU-MOW Q12.XXX"},
        {55.7545555,  37.5675,        5, 13, "RU-MOW HHH2.5XM"},
        {59.956756,   30.2139225,     5, 15, "RU-SPE 12.XX"},
        {59.663242,   30.011588,      3, 13, "RU-SPE 12.XXX"},
        {60.222125,   29.462931,      3, 11, "RU-SPE 123.XX"},
        {59.93765,    30.092125,      4, 13, "RU-SPE 44V9.RX3"},
        {54.7445,     20.4492255,     4, 7,  "RU-KGD 12.XX"},
        {54.919615,   20.0015265,     3, 5,  "RU-KGD 12.XXX"},
        {54.436261,   20.7588755,     3, 6,  "RU-KGD 123.XX"},
        {54.8724605,  19.7250155,     2, 4,  "RU-KGD 123.XXX"},
        {43.268635,   44.7328665,     4, 10, "RU-IN 12.XX"},
        {43.5237285,  44.5141935,     3, 8,  "RU-IN 12.XXX"},
        {42.694632,   44.643477,      3, 10, "RU-IN 123.XX"},
        {43.11518,    44.8375,        3, 12, "RU-IN MTM1.FK2"},
        {44.943994,   38.9176195,     5, 13, "RU-AD 12.XX"},
        {44.870063,   38.7175045,     4, 11, "RU-AD 12.XXX"},
        {44.428963,   39.9105625,     4, 10, "RU-AD 123.XX"},
        {44.48675,    39.72,          3, 9,  "RU-AD K46.6W3"},
        {44.48675,    39.72,          3, 9,  "RU-AD 7NFT.GTZ"},
        {43.003015,   44.6185055,     5, 8,  "RU-SE 12.XX"},
        {43.255635,   44.3777985,     4, 10, "RU-SE 12.XXX"},
        {43.211294,   43.874914,      4, 9,  "RU-SE 000.XX"},
        {43.825545,   44.25031,       4, 13, "RU-SE J00.XX"},
        {42.597337,   43.404636,      3, 7,  "RU-SE 123.XXX"},
        {43.196,      44.179,         4, 9,  "RU-SE LS1S.XHH"},
        {43.4957555,  43.54238,       5, 10, "RU-KB 12.XX"},
        {43.683115,   43.3145515,     4, 9,  "RU-KB 12.XXX"},
        {43.3270195,  43.9234015,     4, 9,  "RU-KB 123.XX"},
        {43.8109595,  42.4721745,     3, 12, "RU-KB 123.XXX"},
        {43.455435,   43.439135,      4, 9,  "RU-KB JR9Z.S7Q"},
        {44.2154985,  42.013591,      5, 11, "RU-KC 12.XX"},
        {44.453615,   41.74863,       4, 10, "RU-KC 12.XXX"},
        {43.988024,   41.017746,      4, 12, "RU-KC 000.XX"},
        {43.899624,   41.420246,      4, 13, "RU-KC 800.XX"},
        {43.836024,   41.743746,      5, 11, "RU-KC J00.XX"},
        {43.983304,   42.363358,      4, 10, "RU-KC S00.XX"},
        {44.3915265,  40.756488,      3, 11, "RU-KC 123.XXX"},
        {43.845,      41.6835,        4, 13, "RU-KC DQ3S.VXJ"},
        {43.258015,   45.647534,      5, 11, "RU-CE 12.XX"},
        {43.493115,   45.3945515,     4, 9,  "RU-CE 12.XXX"},
        {42.567825,   45.362789,      4, 9,  "RU-CE 123.XX"},
        {42.5426475,  44.839821,      3, 7,  "RU-CE 123.XXX"},
        {43.2435,     45.746,         4, 10, "RU-CE PSSN.7XS"},
        {56.145065,   47.2144605,     5, 16, "RU-CU 12.XX"},
        {56.0546915,  46.9436335,     4, 12, "RU-CU 12.XXX"},
        {54.917874,   46.1556855,     4, 12, "RU-CU 000.XX"},
        {55.566424,   47.2671955,     4, 10, "RU-CU C00.XX"},
        {55.551424,   46.1798955,     4, 9,  "RU-CU P00.XX"},
        {54.718959,   45.920902,      3, 14, "RU-CU 123.XXX"},
        {55.4765,     47.1665,        3, 6,  "RU-CU YH5S.4JB"},
        {57.0301,     40.9085575,     4, 9,  "RU-IVA 12.XX"},
        {57.097915,   40.7622515,     3, 8,  "RU-IVA 12.XXX"},
        {57.430494,   41.712831,      3, 8,  "RU-IVA 000.XX"},
        {57.009104,   40.11119075,    3, 8,  "RU-IVA J00.XX"},
        {57.350042,   39.496737,      2, 7,  "RU-IVA 123.XXX"},
        {52.6419,     39.5126935,     5, 7,  "RU-LIP 12.XX"},
        {52.789815,   39.3459665,     4, 6,  "RU-LIP 12.XXX"},
        {52.758894,   38.10217875,    4, 6,  "RU-LIP 000.XX"},
        {53.058604,   38.72115075,    4, 9,  "RU-LIP J00.XX"},
        {53.4519475,  37.833431,      3, 11, "RU-LIP 123.XXX"},
        {52.7383,     39.2483,        3, 5,  "RU-LIP KQXT.759"},
        {53.0027,     36.0291935,     5, 10, "RU-ORL 12.XX"},
        {53.071415,   35.7218315,     4, 6,  "RU-ORL 12.XXX"},
        {53.323224,   36.39790475,    4, 12, "RU-ORL 000.XX"},
        {52.487624,   37.375198875,   4, 6,  "RU-ORL 800.XX"},
        {53.480024,   35.81590475,    4, 9,  "RU-ORL J00.XX"},
        {52.868404,   37.15440175,    4, 6,  "RU-ORL S00.XX"},
        {53.4580685,  34.905369,      3, 12, "RU-ORL 123.XXX"},
        {52.7895,     36.4275,        4, 6,  "RU-ORL FQWP.B0G"},
        {54.2211,     37.5220675,     5, 7,  "RU-TUL 12.XX"},
        {54.330015,   37.2404615,     4, 10, "RU-TUL 12.XXX"},
        {54.016774,   38.115559625,   4, 6,  "RU-TUL 000.XX"},
        {54.584224,   36.9615695,     4, 10, "RU-TUL C00.XX"},
        {53.718924,   37.865627625,   4, 6,  "RU-TUL P00.XX"},
        {54.853364,   36.0130665,     3, 9,  "RU-TUL 123.XXX"},
        {53.909,      37.4265,        4, 6,  "RU-TUL HM9T.4M2"},
        {50.6291,     36.5253195,     5, 8,  "RU-BE 12.XX"},
        {50.796115,   36.2516365,     4, 7,  "RU-BE 12.XXX"},
        {51.383545,   37.46335625,    4, 10, "RU-BE 000.XX"},
        {51.383545,   37.81946225,    4, 10, "RU-BE 800.XX"},
        {50.911354,   36.9892335,     4, 10, "RU-BE J00.XX"},
        {50.722545,   38.3323525,     4, 11, "RU-BE S00.XX"},
        {50.973277,   35.444391,      3, 9,  "RU-BE 123.XXX"},
        {50.61585,    37.30135,       3, 6,  "RU-BE HX48.FGR"},
        {56.1751,     40.3447415,     5, 7,  "RU-VLA 12.XX"},
        {56.409591,   39.9279135,     4, 9,  "RU-VLA 12.XXX"},
        {56.406545,   40.920403125,   4, 8,  "RU-VLA 000.XX"},
        {55.548775,   41.8970495,     4, 9,  "RU-VLA 500.XX"},
        {55.666545,   40.5393925,     4, 6,  "RU-VLA B00.XX"},
        {56.356804,   38.510119625,   4, 9,  "RU-VLA H00.XX"},
        {56.00339,    39.360398125,   4, 9,  "RU-VLA M00.XX"},
        {56.228354,   41.962238625,   4, 9,  "RU-VLA R00.XX"},
        {56.151162,   38.711519625,   4, 7,  "RU-VLA W00.XX"},
        {56.3306675,  38.413825,      3, 8,  "RU-VLA 123.XXX"},
        {55.9655,     40.626,         4, 6,  "RU-VLA MGWJ.629"},
        {51.772722,   36.106376,      5, 8,  "RU-KRS 12.XX"},
        {51.916115,   35.83328,       4, 7,  "RU-KRS 12.XXX"},
        {52.3109,     35.029839875,   4, 13, "RU-KRS 000.XX"},
        {51.541038,   34.56252825,    4, 7,  "RU-KRS 800.XX"},
        {51.708545,   35.168360625,   4, 7,  "RU-KRS J00.XX"},
        {51.903804,   36.718431125,   4, 7,  "RU-KRS S00.XX"},
        {51.8506485,  34.2045935,     3, 9,  "RU-KRS 123.XXX"},
        {51.671,      36.31775,       4, 7,  "RU-KRS FTQK.JXL"},
        {54.55771,    36.2192985,     5, 11, "RU-KLU 12.XX"},
        {54.807015,   35.8601265,     4, 7,  "RU-KLU 12.XXX"},
        {55.160274,   36.3632855,     4, 9,  "RU-KLU 000.XX"},
        {54.127545,   34.200378125,   4, 7,  "RU-KLU C00.XX"},
        {54.126545,   35.300378125,   4, 7,  "RU-KLU P00.XX"},
        {55.1837085,  33.5693695,     3, 8,  "RU-KLU 123.XXX"},
        {54.314,      35.35275,       3, 7,  "RU-KLU DLCR.TJX"},
        {52.6784915,  41.368718,      5, 7,  "RU-TT 12.XX"},
        {52.776506,   41.285667,      4, 6,  "RU-TT 12.XXX"},
        {52.911244,   40.30254075,    4, 9,  "RU-TT 000.XX"},
        {51.976436,   42.227257625,   4, 10, "RU-TT 600.XX"},
        {53.257545,   41.20037375,    4, 6,  "RU-TT C00.XX"},
        {51.874545,   41.421360625,   4, 10, "RU-TT J00.XX"},
        {52.966424,   42.67284075,    4, 9,  "RU-TT P00.XX"},
        {53.554904,   41.71837375,    4, 9,  "RU-TT V00.XX"},
        {51.6173835,  39.936746,      3, 10, "RU-TT 123.XXX"},
        {52.7065,     41.581,         4, 6,  "RU-TT PQ7W.T72"},
        {53.271545,   34.30937375,    5, 7,  "RU-BRY 00.XX"},
        {53.293558,   34.24686375,    5, 10, "RU-BRY J0.XX"},
        {53.459815,   34.0063965,     4, 10, "RU-BRY 12.XXX"},
        {52.778004,   32.02710175,    4, 8,  "RU-BRY 000.XX"},
        {52.584545,   31.667364375,   4, 8,  "RU-BRY 700.XX"},
        {52.929974,   32.52083575,    4, 8,  "RU-BRY F00.XX"},
        {53.888174,   33.900733125,   4, 10, "RU-BRY M00.XX"},
        {53.686674,   34.073133125,   4, 10, "RU-BRY T00.XX"},
        {53.8191635,  31.3873825,     3, 8,  "RU-BRY 123.XXX"},
        {52.9425,     33.287,         3, 5,  "RU-BRY 9QF9.04W"},
        {57.65126,    39.772748,      5, 9,  "RU-YAR 12.XX"},
        {57.768394,   39.465793,      4, 6,  "RU-YAR 00.XXX"},
        {58.065884,   38.596093625,   4, 6,  "RU-YAR J0.XXX"},
        {57.514074,   38.158362,      4, 9,  "RU-YAR 000.XX"},
        {57.254124,   39.12012575,    4, 6,  "RU-YAR C00.XX"},
        {56.826624,   38.59822575,    4, 7,  "RU-YAR P00.XX"},
        {56.6497985,  37.094775,      3, 11, "RU-YAR 123.XXX"},
        {57.8455,     39.14225,       3, 5,  "RU-YAR K9RP.H29"},
        {54.638225,   39.642367,      5, 10, "RU-RYA 12.XX"},
        {54.7120275,  39.1853765,     4, 9,  "RU-RYA 12.XXX"},
        {53.743004,   39.855037625,   4, 6,  "RU-RYA 000.XX"},
        {54.40339,    41.7533825,     4, 6,  "RU-RYA 700.XX"},
        {55.005545,   41.1056875,     4, 6,  "RU-RYA F00.XX"},
        {54.348545,   38.7923175,     4, 12, "RU-RYA M00.XX"},
        {53.853044,   39.344930625,   4, 6,  "RU-RYA T00.XX"},
        {55.115994,   38.8099365,     3, 12, "RU-RYA 123.XXX"},
        {54.3409,     40.6825,        3, 5,  "RU-RYA MLYP.P1J"},
        {46.3640525,  47.970028,      5, 7,  "RU-AST 12.XX"},
        {46.484011,   47.72836,       5, 11, "RU-AST 12.XXX"},
        {48.000571,   45.7010175,     4, 12, "RU-AST 123.XX"},
        {48.351965,   45.2015065,     3, 9,  "RU-AST 12.XXXX"},
        {47.788897,   45.981717,      4, 12, "RU-AST 123.XXX"},
        {46.9335,     47.292365,      4, 10, "RU-AST TFG8.WD5"},
        {55.7841,     37.5480415,     5, 13, "RU-MOS 12.XX"},
        {55.954596,   37.218282,      4, 13, "RU-MOS 12.XXX"},
        {55.496545,   37.4683925,     4, 9,  "RU-MOS 000.XX"},
        {55.630545,   38.0673925,     4, 6,  "RU-MOS 200.XX"},
        {55.131944,   38.6875655,     4, 12, "RU-MOS 400.XX"},
        {55.886545,   38.390398125,   4, 9,  "RU-MOS 600.XX"},
        {54.966644,   37.2765655,     4, 6,  "RU-MOS 800.XX"},
        {55.846545,   38.824888125,   4, 9,  "RU-MOS B00.XX"},
        {55.969744,   37.974398125,   5, 14, "RU-MOS D00.XX"},
        {56.331545,   37.949403125,   4, 9,  "RU-MOS G00.XX"},
        {56.369634,   36.649623125,   4, 9,  "RU-MOS J00.XX"},
        {55.170834,   37.3979545,     4, 6,  "RU-MOS L00.XX"},
        {55.348334,   38.6373925,     4, 9,  "RU-MOS N00.XX"},
        {55.422234,   36.6538545,     4, 6,  "RU-MOS P00.XX"},
        {56.073545,   37.787398125,   4, 9,  "RU-MOS Q00.XX"},
        {55.424834,   38.9643925,     4, 9,  "RU-MOS R00.XX"},
        {56.066434,   37.365479125,   4, 9,  "RU-MOS S00.XX"},
        {54.908634,   38.0219105,     4, 6,  "RU-MOS T00.XX"},
        {56.358545,   37.446403125,   4, 9,  "RU-MOS V00.XX"},
        {55.813534,   38.574079125,   4, 9,  "RU-MOS W00.XX"},
        {56.216634,   36.916023125,   4, 9,  "RU-MOS X00.XX"},
        {55.765145,   37.975398125,   4, 7,  "RU-MOS Y00.XX"},
        {55.762878,   38.235198125,   4, 7,  "RU-MOS Z00.XX"},
        {56.843975,   37.3049385,     3, 12, "RU-MOS 1HH.HHH"},
        {56.843975,   38.1434255,     3, 11, "RU-MOS 2HH.HHH"},
        {56.551655,   35.2776645,     3, 9,  "RU-MOS 312.XXX"},
        {56.551655,   36.1161525,     3, 8,  "RU-MOS 412.XXX"},
        {56.551655,   36.9546405,     3, 8,  "RU-MOS 512.XXX"},
        {56.551655,   37.7931285,     3, 11, "RU-MOS 612.XXX"},
        {55.8605,     35.3165155,     3, 11, "RU-MOS BSH.D2T"},
        {56.060615,   35.5485845,     3, 8,  "RU-MOS C12.XXX"},
        {56.060615,   36.3766565,     3, 8,  "RU-MOS D12.XXX"},
        {56.060615,   37.2047285,     3, 8,  "RU-MOS F12.XXX"},
        {56.060615,   38.0328005,     3, 8,  "RU-MOS G12.XXX"},
        {56.060615,   38.8608725,     3, 9,  "RU-MOS H12.XXX"},
        {56.060615,   39.6889445,     3, 8,  "RU-MOS K12.XXX"},
        {55.36946,    35.330473,      3, 8,  "RU-MOS LRH.GDP"},
        {55.569575,   35.5759265,     3, 5,  "RU-MOS M12.XXX"},
        {55.569575,   36.3935825,     3, 5,  "RU-MOS P12.XXX"},
        {55.569575,   37.2112385,     4, 10, "RU-MOS Q12.XXX"},
        {55.569575,   38.0288945,     3, 5,  "RU-MOS R12.XXX"},
        {55.569575,   38.8465505,     3, 8,  "RU-MOS S12.XXX"},
        {55.569575,   39.6642065,     3, 8,  "RU-MOS T12.XXX"},
        {55.078535,   37.0523425,     3, 8,  "RU-MOS V12.XXX"},
        {55.078535,   37.8595825,     3, 5,  "RU-MOS W12.XXX"},
        {55.078535,   38.6668225,     3, 6,  "RU-MOS X12.XXX"},
        {55.078535,   39.4740625,     3, 8,  "RU-MOS Y12.XXX"},
        {54.587495,   38.3485615,     3, 8,  "RU-MOS Z12.XXX"},
        {55.61625,    37.67,          4, 10, "RU-MOS HHNF.33J"},
        {54.8138,     31.9803245,     5, 8,  "RU-SMO 12.XX"},
        {54.964115,   31.6636265,     4, 7,  "RU-SMO 12.XXX"},
        {53.967704,   32.640837625,   4, 11, "RU-SMO 000.XX"},
        {55.219244,   34.0773685,     4, 9,  "RU-SMO 700.XX"},
        {55.098944,   32.5075205,     4, 7,  "RU-SMO F00.XX"},
        {55.153144,   33.0541205,     4, 6,  "RU-SMO M00.XX"},
        {55.627646,   30.9808345,     4, 11, "RU-SMO T00.XX"},
        {55.9146985,  33.532736,      3, 8,  "RU-SMO 112.XXX"},
        {55.9146985,  34.4829705,     3, 9,  "RU-SMO 212.XXX"},
        {55.735801,   30.7919805,     3, 13, "RU-SMO 312.XXX"},
        {55.735801,   31.6021675,     3, 9,  "RU-SMO 412.XXX"},
        {55.735801,   32.4198235,     3, 9,  "RU-SMO 512.XXX"},
        {55.735801,   33.2374795,     3, 8,  "RU-SMO 612.XXX"},
        {55.735801,   34.0551355,     3, 8,  "RU-SMO 712.XXX"},
        {55.735801,   34.6273245,     4, 9,  "RU-SMO 812.XXX"},
        {55.244761,   30.7914075,     3, 7,  "RU-SMO 912.XXX"},
        {55.244761,   31.5963865,     3, 6,  "RU-SMO B12.XXX"},
        {55.244761,   32.4036265,     3, 6,  "RU-SMO C12.XXX"},
        {55.244761,   33.2108665,     3, 5,  "RU-SMO D12.XXX"},
        {55.244761,   34.0181065,     3, 8,  "RU-SMO F12.XXX"},
        {55.244761,   34.6371675,     4, 9,  "RU-SMO G12.XXX"},
        {54.753721,   30.7937815,     3, 7,  "RU-SMO H12.XXX"},
        {54.753721,   31.5906055,     3, 6,  "RU-SMO J12.XXX"},
        {54.753721,   32.3874295,     4, 7,  "RU-SMO K12.XXX"},
        {54.753721,   33.1842535,     3, 5,  "RU-SMO L12.XXX"},
        {54.901033,   33.9810775,     4, 9,  "RU-SMO M12.XXX"},
        {55.048345,   34.6371675,     5, 10, "RU-SMO N12.XXX"},
        {54.26573,    31.3456215,     3, 7,  "RU-SMO P12.XXX"},
        {54.26573,    32.1320295,     3, 6,  "RU-SMO Q12.XXX"},
        {54.231243,   32.9178275,     3, 5,  "RU-SMO R12.XXX"},
        {53.8095435,  31.796872,      3, 10, "RU-SMO S12.XXX"},
        {53.8095435,  32.574872,      3, 10, "RU-SMO T12.XXX"},
        {54.7415,     33.0735,        3, 5,  "RU-SMO 9K3N.PMJ"},
        {43.001,      47.444638,      6, 8,  "RU-DA 12.XX"},
        {43.136915,   47.118165,      5, 7,  "RU-DA 12.XXX"},
        {43.289974,   46.5307615,     5, 10, "RU-DA 000.XX"},
        {42.146924,   48.0181615,     4, 6,  "RU-DA C00.XX"},
        {42.855024,   46.748543,      5, 7,  "RU-DA P00.XX"},
        {41.5980045,  45.6141015,     3, 7,  "RU-DA 123.XXX"},
        {44.7416265,  45.3001315,     3, 11, "RU-DA 12.XXXX"},
        {43.09,       46.839,         5, 7,  "RU-DA STD3.S38"},
        {51.71878,    39.1189555,     6, 9,  "RU-VOR 12.XX"},
        {51.904115,   38.90028,       5, 11, "RU-VOR 12.XXX"},
        {51.424344,   41.86172025,    5, 7,  "RU-VOR 000.XX"},
        {51.305474,   39.09022625,    5, 11, "RU-VOR 600.XX"},
        {51.012074,   39.44252625,    5, 8,  "RU-VOR C00.XX"},
        {50.201774,   39.40854675,    5, 9,  "RU-VOR J00.XX"},
        {49.722674,   39.670457,      4, 10, "RU-VOR P00.XX"},
        {50.213074,   40.23324675,    5, 10, "RU-VOR V00.XX"},
        {51.6647335,  38.2954275,     4, 10, "RU-VOR 123.XXX"},
        {51.672118,   38.383906,      4, 10, "RU-VOR 12.XXXX"},
        {50.8305,     40.5415,        4, 6,  "RU-VOR MWRQ.7PV"},
        {58.5846,     31.20023,       6, 11, "RU-NGR 12.XX"},
        {58.704115,   30.943525,      5, 13, "RU-NGR 12.XXX"},
        {58.425304,   33.660762375,   5, 9,  "RU-NGR 000.XX"},
        {59.217844,   31.367858625,   5, 10, "RU-NGR 700.XX"},
        {58.460144,   33.039498375,   5, 9,  "RU-NGR F00.XX"},
        {58.581544,   35.556098375,   4, 13, "RU-NGR M00.XX"},
        {58.027045,   31.253585625,   5, 11, "RU-NGR T00.XX"},
        {59.2322165,  29.804307,      4, 10, "RU-NGR 123.XXX"},
        {58.4039985,  29.9202675,     4, 10, "RU-NGR 12.XXXX"},
        {58.1765,     32.9315,        4, 9,  "RU-NGR 88XV.1YT"},
        {57.8421,     28.278172,      5, 7,  "RU-PSK 12.XX"},
        {58.003615,   28.051895,      4, 7,  "RU-PSK 12.XXX"},
        {56.319404,   30.365619625,   4, 6,  "RU-PSK 000.XX"},
        {57.340004,   28.175957,      4, 6,  "RU-PSK 400.XX"},
        {57.788704,   29.412696125,   4, 6,  "RU-PSK 800.XX"},
        {56.013104,   29.703840625,   4, 8,  "RU-PSK D00.XX"},
        {57.530704,   29.749257,      4, 9,  "RU-PSK J00.XX"},
        {56.331504,   29.212919625,   4, 6,  "RU-PSK N00.XX"},
        {57.025404,   28.75965875,    4, 6,  "RU-PSK S00.XX"},
        {58.268294,   28.937421375,   4, 7,  "RU-PSK X00.XX"},
        {58.511385,   27.34196,       3, 11, "RU-PSK 012.XXX"},
        {58.511385,   28.0395525,     3, 9,  "RU-PSK 112.XXX"},
        {58.924991,   28.788281,      3, 9,  "RU-PSK 212.XXX"},
        {58.433951,   27.464875,      3, 11, "RU-PSK 312.XXX"},
        {58.433951,   28.339819,      3, 9,  "RU-PSK 412.XXX"},
        {58.433951,   29.214763,      3, 9,  "RU-PSK 512.XXX"},
        {57.942911,   27.382016,      3, 7,  "RU-PSK 612.XXX"},
        {57.942911,   28.246544,      4, 6,  "RU-PSK 712.XXX"},
        {57.942911,   29.111072,      3, 5,  "RU-PSK 812.XXX"},
        {57.942911,   29.9756,        3, 9,  "RU-PSK 912.XXX"},
        {57.451871,   27.5212515,     3, 7,  "RU-PSK B12.XXX"},
        {57.451871,   28.3701555,     3, 5,  "RU-PSK C12.XXX"},
        {57.451871,   29.2190595,     3, 5,  "RU-PSK D12.XXX"},
        {57.451871,   30.0679635,     4, 9,  "RU-PSK F12.XXX"},
        {56.9288045,  27.694668,      3, 7,  "RU-PSK G12.XXX"},
        {56.9288045,  28.558668,      3, 5,  "RU-PSK H12.XXX"},
        {56.9288045,  29.422638,      3, 5,  "RU-PSK J12.XXX"},
        {56.9288045,  30.285668,      3, 8,  "RU-PSK K12.XXX"},
        {56.499253,   28.1195465,     3, 7,  "RU-PSK L12.XXX"},
        {56.499253,   28.9476185,     3, 5,  "RU-PSK M12.XXX"},
        {56.499253,   29.7630835,     3, 5,  "RU-PSK N12.XXX"},
        {56.499253,   30.362069,      3, 5,  "RU-PSK P12.XXX"},
        {56.499253,   30.9609345,     3, 8,  "RU-PSK Q12.XXX"},
        {56.034635,   28.2980765,     3, 7,  "RU-PSK R12.XXX"},
        {56.034635,   29.1157325,     3, 7,  "RU-PSK S12.XXX"},
        {56.034635,   29.9333885,     4, 8,  "RU-PSK T12.XXX"},
        {56.034635,   30.7510445,     3, 8,  "RU-PSK V12.XXX"},
        {57.30425,    29.42175,       3, 5,  "RU-PSK 3CX2.GBQ"},
        {57.8031,     40.869772,      5, 10, "RU-KOS 12.XX"},
        {57.862915,   40.560595,      4, 9,  "RU-KOS 12.XXX"},
        {58.491404,   41.299062375,   4, 9,  "RU-KOS 000.XX"},
        {58.409544,   42.162098375,   4, 6,  "RU-KOS 700.XX"},
        {58.370644,   44.563798375,   5, 7,  "RU-KOS F00.XX"},
        {58.399545,   45.417426875,   5, 7,  "RU-KOS M00.XX"},
        {57.903144,   43.529738125,   5, 10, "RU-KOS T00.XX"},
        {58.9803565,  40.5721655,     3, 11, "RU-KOS 123.XXX"},
        {59.040196,   42.632614,      4, 9,  "RU-KOS 12.XXXX"},
        {58.4475,     44.022,         4, 6,  "RU-KOS S8P4.KLY"},
        {45.072,      41.905954,      6, 9,  "RU-STA 12.XX"},
        {45.185894,   41.786294875,   5, 8,  "RU-STA 00.XXX"},
        {44.118114,   42.812728,      5, 7,  "RU-STA J0.XXX"},
        {43.970545,   42.418834,      5, 14, "RU-STA 000.XX"},
        {44.629774,   41.765744625,   5, 7,  "RU-STA 500.XX"},
        {44.176874,   43.263244625,   6, 8,  "RU-STA B00.XX"},
        {44.752204,   44.082437125,   5, 10, "RU-STA H00.XX"},
        {44.703704,   42.812337125,   5, 8,  "RU-STA M00.XX"},
        {45.338904,   42.71133675,    5, 10, "RU-STA R00.XX"},
        {45.081204,   43.259637125,   5, 8,  "RU-STA W00.XX"},
        {45.972685,   40.981978,      3, 12, "RU-STA 123.XXX"},
        {45.250706,   41.6320075,     4, 12, "RU-STA 12.XXXX"},
        {44.94825,    43.2805,        4, 7,  "RU-STA HMXD.FWS"},
        {45.0736,     38.935654,      6, 13, "RU-KDA 12.XX"},
        {44.977394,   38.755894125,   5, 12, "RU-KDA 00.XXX"},
        {43.614794,   39.6881315,     4, 6,  "RU-KDA C0.XXX"},
        {44.883884,   37.473826375,   5, 8,  "RU-KDA P0.XXX"},
        {45.448045,   40.39241875,    5, 7,  "RU-KDA 000.XX"},
        {45.056004,   40.948737125,   5, 10, "RU-KDA 400.XX"},
        {46.659804,   38.120435,      4, 7,  "RU-KDA 800.XX"},
        {45.313504,   38.00403675,    5, 8,  "RU-KDA D00.XX"},
        {45.857294,   40.036544375,   4, 7,  "RU-KDA J00.XX"},
        {44.094194,   39.016194,      4, 9,  "RU-KDA M00.XX"},
        {44.622994,   40.642954625,   4, 9,  "RU-KDA Q00.XX"},
        {44.918394,   37.848423125,   6, 9,  "RU-KDA T00.XX"},
        {45.617194,   38.87398375,    4, 7,  "RU-KDA X00.XX"},
        {44.9058745,  37.337241,      4, 7,  "RU-KDA 123.XXX"},
        {46.0199825,  36.824423,      3, 6,  "RU-KDA 12.XXXX"},
        {45.132,      39.1665,        4, 10, "RU-KDA 6L3T.X8G"},
        {46.3488,     44.20947,       7, 12, "RU-KL 12.XX"},
        {46.580615,   43.98946,       6, 11, "RU-KL 12.XXX"},
        {47.810404,   44.25045925,    5, 13, "RU-KL 000.XX"},
        {47.349144,   44.44198025,    5, 7,  "RU-KL 700.XX"},
        {48.002844,   44.497810875,   4, 9,  "RU-KL F00.XX"},
        {46.167744,   41.812590375,   4, 13, "RU-KL M00.XX"},
        {45.408844,   47.14506075,    4, 9,  "RU-KL T00.XX"},
        {46.7214685,  43.7406625,     5, 10, "RU-KL 123.XXX"},
        {47.767865,   43.8353855,     4, 12, "RU-KL 12.XXXX"},
        {46.957817,   41.76854,       3, 9,  "RU-KL 1234.XX"},
        {46.4705,     44.6815,        5, 7,  "RU-KL MG7Q.4FN"},
        {56.8884,     35.8289575,     5, 8,  "RU-TVE 12.XX"},
        {57.118515,   35.4586515,     5, 8,  "RU-TVE 12.XXX"},
        {56.278174,   34.053898625,   4, 6,  "RU-TVE 000.XX"},
        {56.691474,   36.663498625,   4, 7,  "RU-TVE 500.XX"},
        {57.042274,   33.95288275,    4, 9,  "RU-TVE B00.XX"},
        {57.048004,   34.80765875,    5, 8,  "RU-TVE H00.XX"},
        {57.605204,   34.371357,      5, 11, "RU-TVE M00.XX"},
        {57.923304,   33.853096125,   4, 10, "RU-TVE R00.XX"},
        {56.825504,   37.16965875,    4, 12, "RU-TVE W00.XX"},
        {56.150883,   34.127463,      4, 6,  "RU-TVE 123.XXX"},
        {58.0113365,  31.07424,       3, 11, "RU-TVE 12.XXXX"},
        {57.2485,     34.5535,        4, 9,  "RU-TVE CC66.ZKX"},
        {59.956756,   30.2139225,     6, 15, "RU-LEN 12.XX"},
        {59.663242,   30.011588,      7, 13, "RU-LEN 12.XXX"},
        {59.629574,   29.891664,      5, 8,  "RU-LEN 000.XX"},
        {60.699974,   28.52215975,    5, 9,  "RU-LEN 500.XX"},
        {59.913874,   28.978612375,   5, 9,  "RU-LEN B00.XX"},
        {59.629804,   33.308952,      4, 6,  "RU-LEN H00.XX"},
        {59.744204,   29.704252,      5, 10, "RU-LEN M00.XX"},
        {59.470904,   31.767352,      5, 7,  "RU-LEN R00.XX"},
        {60.028604,   30.457611375,   6, 13, "RU-LEN W00.XX"},
        {61.4510605,  31.1569385,     4, 11, "RU-LEN 12.XXXX"},
        {58.908334,   26.9702635,     3, 8,  "RU-LEN 123.XXX"},
        {60.1479565,  26.895256,      3, 8,  "RU-LEN 1234.XX"},
        {60.776392,   27.4581655,     4, 9,  "RU-LEN 1234.XXX"},
        {47.2491,     39.6448295,     7, 11, "RU-ROS 12.XX"},
        {47.416491,   39.4993485,     5, 9,  "RU-ROS 12.XXX"},
        {47.248704,   38.760234625,   4, 8,  "RU-ROS 000.XX"},
        {47.715404,   40.08333425,    6, 9,  "RU-ROS 400.XX"},
        {47.566034,   41.99799925,    6, 12, "RU-ROS 800.XX"},
        {47.738804,   39.78673425,    6, 9,  "RU-ROS D00.XX"},
        {47.086304,   39.220834625,   4, 8,  "RU-ROS J00.XX"},
        {48.308804,   40.105533875,   4, 7,  "RU-ROS N00.XX"},
        {47.905504,   39.913133875,   6, 9,  "RU-ROS S00.XX"},
        {46.490494,   41.441205,      5, 8,  "RU-ROS X00.XX"},
        {47.4941895,  39.6455235,     6, 10, "RU-ROS 123.XXX"},
        {47.180934,   38.4429595,     3, 7,  "RU-ROS 12.XXXX"},
        {48.042575,   39.675184,      5, 9,  "RU-ROS 1234.XX"},
        {48.08325,    41.2725,        3, 6,  "RU-ROS C94R.0GQ"},
        {48.7534,     44.4484455,     6, 8,  "RU-VGG 12.XX"},
        {48.402076,   44.120706,      4, 7,  "RU-VGG 12.XXX"},
        {48.946545,   44.7225375,     5, 7,  "RU-VGG 000.XX"},
        {50.110874,   45.17424675,    5, 8,  "RU-VGG 600.XX"},
        {50.110374,   43.15774675,    4, 8,  "RU-VGG C00.XX"},
        {49.738974,   43.477457,      4, 7,  "RU-VGG J00.XX"},
        {50.326174,   44.63584675,    5, 8,  "RU-VGG P00.XX"},
        {50.806974,   41.8114365,     4, 10, "RU-VGG V00.XX"},
        {48.835947,   42.14838,       3, 8,  "RU-VGG 123.XXX"},
        {50.479245,   41.4185175,     3, 9,  "RU-VGG 12.XXXX"},
        {49.366197,   44.254136,      5, 8,  "RU-VGG 1234.XX"},
        {49.343,      44.295,         5, 8,  "RU-VGG L5BV.TG7"},
        {59.1512,     37.860323,      5, 10, "RU-VLG 12.XX"},
        {59.2603265,  37.4706765,     4, 6,  "RU-VLG 12.XXX"},
        {59.220494,   39.751642625,   5, 7,  "RU-VLG 000.XX"},
        {59.234394,   39.466142625,   4, 6,  "RU-VLG 300.XX"},
        {59.479394,   39.933856,      4, 6,  "RU-VLG 600.XX"},
        {58.781014,   36.356763625,   4, 9,  "RU-VLG 900.XX"},
        {59.848814,   38.244229375,   4, 6,  "RU-VLG C00.XX"},
        {59.391514,   35.775196,      4, 9,  "RU-VLG F00.XX"},
        {60.972214,   36.33532525,    4, 11, "RU-VLG H00.XX"},
        {58.820414,   40.133863625,   4, 9,  "RU-VLG K00.XX"},
        {59.974314,   45.644129375,   4, 8,  "RU-VLG M00.XX"},
        {60.743414,   46.15316175,    4, 11, "RU-VLG P00.XX"},
        {59.101714,   35.164763625,   4, 12, "RU-VLG R00.XX"},
        {59.489814,   45.370096,      4, 9,  "RU-VLG T00.XX"},
        {59.958414,   40.091829375,   4, 6,  "RU-VLG W00.XX"},
        {59.950614,   42.665329375,   5, 7,  "RU-VLG Y00.XX"},
        {58.905743,   34.7382635,     3, 11, "RU-VLG 123.XXX"},
        {60.730205,   39.2901135,     3, 8,  "RU-VLG 12.XXXX"},
        {59.201427,   40.9019465,     4, 9,  "RU-VLG 1234.XX"},
        {60.0465,     40.9395,        4, 6,  "RU-VLG N491.53G"},
        {68.9462115,  33.0319255,     5, 7,  "RU-MUR 12.XX"},
        {69.189219,   32.4561815,     4, 6,  "RU-MUR 12.XXX"},
        {67.512281,   32.747635,      4, 6,  "RU-MUR 123.XX"},
        {67.232539,   28.440307,      3, 7,  "RU-MUR 123.XXX"},
        {66.5667905,  33.4315965,     3, 8,  "RU-MUR 12.XXXX"},
        {67.162451,   35.1057595,     4, 6,  "RU-MUR 1234.XX"},
        {68.003,      34.91175,       4, 6,  "RU-MUR 59ZK.67F"},
        {61.8308,     34.2631535,     5, 7,  "RU-KR 12.XX"},
        {62.000115,   33.8634315,     4, 6,  "RU-KR 12.XXX"},
        {62.207994,   34.097491375,   4, 6,  "RU-KR 000.XX"},
        {60.965194,   32.87278825,    4, 10, "RU-KR 300.XX"},
        {63.739994,   34.122560625,   4, 6,  "RU-KR 600.XX"},
        {64.507194,   34.6119425,     4, 6,  "RU-KR 900.XX"},
        {61.518894,   30.058285875,   4, 12, "RU-KR D00.XX"},
        {62.871994,   34.348281125,   4, 6,  "RU-KR H00.XX"},
        {62.102894,   32.180891375,   4, 6,  "RU-KR L00.XX"},
        {61.704014,   30.515417875,   4, 8,  "RU-KR P00.XX"},
        {61.793614,   36.433317875,   4, 8,  "RU-KR R00.XX"},
        {64.588714,   30.5009895,     4, 8,  "RU-KR T00.XX"},
        {64.992545,   34.4685225,     4, 6,  "RU-KR W00.XX"},
        {61.524814,   31.383917875,   4, 11, "RU-KR Y00.XX"},
        {61.2847465,  29.512483,      3, 11, "RU-KR 123.XXX"},
        {63.6253575,  30.2493045,     3, 7,  "RU-KR 1234.XX"},
        {66.0887205,  29.689916,      3, 8,  "RU-KR 12.XXXX"},
        {65.1981805,  29.772335,      3, 7,  "RU-KR 1234.XXX"},
        {67.675,      52.9673295,     6, 13, "RU-NEN 12.XX"},
        {67.852215,   52.5200615,     5, 12, "RU-NEN 12.XXX"},
        {66.996165,   56.4812085,     5, 12, "RU-NEN 123.XX"},
        {69.3989835,  57.1392695,     4, 9,  "RU-NEN 123.XXX"},
        {69.20693,    50.571165,      4, 9,  "RU-NEN 12.XXXX"},
        {68.389097,   43.9371165,     4, 9,  "RU-NEN 1234.XX"},
        {68.710716,   43.2730245,     3, 8,  "RU-NEN 123.XXXX"},
        {68.13525,    54.39,          4, 11, "RU-NEN P5ZM.204"},
        {61.704645,   50.7353655,     5, 9,  "RU-KO 12.XX"},
        {61.5246605,  50.5049225,     4, 8,  "RU-KO 12.XXX"},
        {63.654545,   53.486503125,   4, 8,  "RU-KO 000.XX"},
        {67.558644,   63.674350625,   4, 14, "RU-KO 700.XX"},
        {66.053344,   59.910814625,   4, 12, "RU-KO F00.XX"},
        {65.139444,   56.8873165,     4, 8,  "RU-KO M00.XX"},
        {62.562644,   50.609162125,   4, 8,  "RU-KO T00.XX"},
        {62.8997035,  48.2740725,     3, 7,  "RU-KO 123.XXX"},
        {65.45693,    52.9964095,     3, 7,  "RU-KO 12.XXXX"},
        {67.95389,    59.6227265,     3, 12, "RU-KO 1234.XX"},
        {63.813,      55.828,         3, 7,  "RU-KO QD4N.41D"},
        {64.5851,     40.5073915,     5, 7,  "RU-ARK 12.XX"},
        {64.541494,   39.7877925,     4, 6,  "RU-ARK 12.XXX"},
        {63.984774,   37.864509625,   4, 7,  "RU-ARK 000.XX"},
        {61.296024,   46.33983725,    4, 9,  "RU-ARK C00.XX"},
        {61.296024,   46.90034725,    4, 9,  "RU-ARK P00.XX"},
        {65.9362305,  36.137144,      3, 8,  "RU-ARK 123.XXX"},
        {63.070525,   37.6630345,     3, 6,  "RU-ARK 12.XXXX"},
        {63.210383,   42.9149305,     3, 5,  "RU-ARK 1234.XX"},
        {68.710716,   43.2730245,     3, 8,  "RU-ARK 123.XXXX"},
        {64.83025,    47.3555,        2, 6,  "RU-ARK HHZ1.5WL"},
        {54.2242,     45.1223675,     5, 7,  "RU-MO 12.XX"},
        {54.366115,   44.8138615,     4, 6,  "RU-MO 12.XXX"},
        {54.420004,   43.6654435,     4, 6,  "RU-MO 000.XX"},
        {54.634804,   43.8132225,     4, 9,  "RU-MO 400.XX"},
        {54.095804,   42.6564435,     4, 9,  "RU-MO 800.XX"},
        {53.933204,   43.044124625,   4, 9,  "RU-MO D00.XX"},
        {54.857294,   46.1594175,     4, 16, "RU-MO J00.XX"},
        {54.578994,   45.9918805,     4, 12, "RU-MO M00.XX"},
        {54.049894,   43.782435625,   4, 6,  "RU-MO Q00.XX"},
        {54.474694,   45.2461805,     4, 9,  "RU-MO T00.XX"},
        {54.674494,   45.1160175,     4, 9,  "RU-MO X00.XX"},
        {54.6440675,  42.296506,      3, 11, "RU-MO 123.XXX"},
        {54.4185,     44.44275,       3, 5,  "RU-MO 4L4Y.9WD"},
        {56.3438,     43.9070995,     6, 8,  "RU-NIZ 12.XX"},
        {56.514715,   43.4530215,     5, 7,  "RU-NIZ 12.XXX"},
        {56.232304,   43.107019625,   5, 7,  "RU-NIZ 000.XX"},
        {55.369804,   43.6412015,     4, 6,  "RU-NIZ 400.XX"},
        {55.980004,   43.013740625,   5, 7,  "RU-NIZ 800.XX"},
        {55.383504,   42.0039015,     4, 9,  "RU-NIZ D00.XX"},
        {56.269794,   44.302020625,   5, 7,  "RU-NIZ J00.XX"},
        {55.534494,   45.3565545,     4, 6,  "RU-NIZ M00.XX"},
        {56.647894,   43.301720625,   5, 9,  "RU-NIZ Q00.XX"},
        {57.506545,   45.617415,      4, 10, "RU-NIZ T00.XX"},
        {56.063894,   44.946483625,   5, 7,  "RU-NIZ X00.XX"},
        {56.9383345,  41.9471085,     3, 7,  "RU-NIZ 123.XXX"},
        {57.576865,   42.8650735,     3, 11, "RU-NIZ 12.XXXX"},
        {56.2775,     44.7655,        4, 6,  "RU-NIZ 4GN2.TH1"},
        {53.2247,     44.9187515,     5, 7,  "RU-PNZ 12.XX"},
        {53.385115,   44.6457315,     5, 7,  "RU-PNZ 12.XXX"},
        {53.790334,   45.907378125,   4, 12, "RU-PNZ 000.XX"},
        {53.153545,   46.45010475,    4, 9,  "RU-PNZ 400.XX"},
        {53.734904,   42.891724625,   4, 12, "RU-PNZ 800.XX"},
        {53.475804,   44.41040575,    4, 6,  "RU-PNZ D00.XX"},
        {53.521545,   42.53498975,    4, 12, "RU-PNZ J00.XX"},
        {52.909104,   45.97772675,    4, 9,  "RU-PNZ N00.XX"},
        {53.551545,   43.47240475,    4, 6,  "RU-PNZ S00.XX"},
        {52.918824,   44.91736875,    4, 6,  "RU-PNZ X00.XX"},
        {53.420149,   42.2341645,     3, 11, "RU-PNZ 123.XXX"},
        {53.166,      44.53825,       3, 5,  "RU-PNZ 4Q96.MJ9"},
        {58.6411,     49.55273,       6, 8,  "RU-KI 12.XX"},
        {58.6261385,  49.207016,      4, 6,  "RU-KI 12.XXX"},
        {58.727074,   52.018300375,   4, 7,  "RU-KI 000.XX"},
        {57.600574,   48.724899,      4, 6,  "RU-KI 500.XX"},
        {56.260545,   50.813403125,   4, 10, "RU-KI B00.XX"},
        {59.366404,   52.079252,      4, 9,  "RU-KI H00.XX"},
        {59.041404,   49.064893625,   4, 6,  "RU-KI M00.XX"},
        {60.629404,   47.06706975,    4, 11, "RU-KI R00.XX"},
        {57.322904,   47.792657,      4, 9,  "RU-KI W00.XX"},
        {57.6035945,  49.2776695,     4, 6,  "RU-KI 123.XXX"},
        {58.162428,   46.4135085,     4, 9,  "RU-KI 12.XXXX"},
        {56.748441,   46.46376,       3, 11, "RU-KI 1234.XX"},
        {58.56,       50.0975,        5, 7,  "RU-KI D8Y4.801"},
        {56.6526685,  47.8115795,     5, 13, "RU-ME 12.XX"},
        {56.810115,   47.4480865,     4, 12, "RU-ME 12.XXX"},
        {56.361004,   46.376719625,   5, 14, "RU-ME 000.XX"},
        {55.924104,   48.175340625,   5, 13, "RU-ME 400.XX"},
        {56.943304,   47.73875875,    4, 12, "RU-ME 800.XX"},
        {56.293604,   46.094819625,   4, 13, "RU-ME D00.XX"},
        {56.006804,   47.911440625,   4, 12, "RU-ME J00.XX"},
        {56.943304,   48.94045875,    4, 9,  "RU-ME N00.XX"},
        {56.809004,   46.68365875,    4, 12, "RU-ME S00.XX"},
        {57.003394,   48.57184975,    4, 9,  "RU-ME X00.XX"},
        {56.843614,   45.7557735,     3, 9,  "RU-ME 123.XXX"},
        {56.58815,    47.912,         4, 12, "RU-ME 9FJ8.ZJT"},
        {51.839505,   55.0683815,     5, 12, "RU-ORE 12.XX"},
        {51.951115,   54.72028,       4, 11, "RU-ORE 12.XXX"},
        {51.330937,   58.19638625,    4, 8,  "RU-ORE 000.XX"},
        {51.330937,   58.50247525,    4, 8,  "RU-ORE 500.XX"},
        {52.834204,   52.05495375,    4, 10, "RU-ORE B00.XX"},
        {51.484545,   57.30135625,    4, 8,  "RU-ORE H00.XX"},
        {51.426545,   58.84501425,    4, 8,  "RU-ORE M00.XX"},
        {52.509545,   52.977364375,   4, 8,  "RU-ORE R00.XX"},
        {51.196545,   54.88835625,    4, 8,  "RU-ORE W00.XX"},
        {51.6797725,  50.7827085,     3, 10, "RU-ORE 123.XXX"},
        {50.8122245,  54.2418555,     3, 7,  "RU-ORE 12.XXXX"},
        {51.1728525,  57.334751,      3, 7,  "RU-ORE 1234.XX"},
        {52.431,      56.2345,        3, 10, "RU-ORE QSH4.7MZ"},
        {54.3371,     48.2880675,     5, 13, "RU-ULY 12.XX"},
        {54.417202,   48.0418225,     4, 12, "RU-ULY 12.XXX"},
        {54.242045,   49.4609825,     4, 13, "RU-ULY 000.XX"},
        {54.073345,   46.945538125,   4, 6,  "RU-ULY 400.XX"},
        {53.726324,   46.984378125,   4, 6,  "RU-ULY 700.XX"},
        {54.369545,   47.0453825,     4, 6,  "RU-ULY B00.XX"},
        {53.181724,   47.61958975,    4, 6,  "RU-ULY F00.XX"},
        {53.906845,   46.219438125,   4, 12, "RU-ULY J00.XX"},
        {53.786545,   46.601938125,   4, 12, "RU-ULY M00.XX"},
        {54.356545,   49.9506865,     4, 13, "RU-ULY Q00.XX"},
        {53.251224,   47.37058975,    4, 6,  "RU-ULY T00.XX"},
        {52.740824,   47.04376875,    4, 7,  "RU-ULY X00.XX"},
        {54.669835,   45.9581905,     3, 14, "RU-ULY 123.XXX"},
        {53.7142,     48.024045,      3, 8,  "RU-ULY 9NQS.838"},
        {58.0137555,  56.137272,      5, 7,  "RU-PM 12.XX"},
        {58.1829035,  55.8342455,     4, 6,  "RU-PM 12.XXX"},
        {59.468545,   56.627208,      4, 8,  "RU-PM 000.XX"},
        {59.728024,   56.6491,        4, 8,  "RU-PM 300.XX"},
        {56.790545,   53.91370875,    4, 10, "RU-PM 600.XX"},
        {58.177545,   57.691420625,   4, 9,  "RU-PM 900.XX"},
        {57.484545,   56.767203,      4, 6,  "RU-PM D00.XX"},
        {58.363045,   57.685576875,   5, 10, "RU-PM H00.XX"},
        {58.130224,   55.508636625,   4, 6,  "RU-PM L00.XX"},
        {60.391045,   54.167826875,   5, 9,  "RU-PM P00.XX"},
        {60.456545,   56.93954575,    4, 8,  "RU-PM S00.XX"},
        {59.113544,   57.568610125,   4, 9,  "RU-PM W00.XX"},
        {58.600144,   57.700102875,   4, 9,  "RU-PM Y00.XX"},
        {58.246851,   53.9289455,     3, 11, "RU-PM 123.XXX"},
        {59.510337,   53.504276,      3, 10, "RU-PM 12.XXXX"},
        {61.571403,   52.066021,      3, 10, "RU-PM 1234.XX"},
        {58.891,      55.6325,        3, 5,  "RU-PM P7K8.FGD"},
        {54.7845145,  55.9001965,     6, 8,  "RU-BA 12.XX"},
        {54.8628905,  55.673784,      4, 6,  "RU-BA 12.XXX"},
        {53.648994,   55.849935625,   4, 7,  "RU-BA 000.XX"},
        {53.351994,   55.81079075,    4, 9,  "RU-BA 300.XX"},
        {56.089794,   54.101583625,   4, 12, "RU-BA 600.XX"},
        {53.499194,   55.85119075,    4, 7,  "RU-BA 900.XX"},
        {53.941194,   58.235235625,   4, 8,  "RU-BA D00.XX"},
        {52.945114,   55.83904775,    4, 9,  "RU-BA H00.XX"},
        {52.708014,   55.66404775,    4, 11, "RU-BA K00.XX"},
        {54.085014,   54.0094135,     4, 12, "RU-BA M00.XX"},
        {54.464214,   53.4071135,     4, 9,  "RU-BA P00.XX"},
        {54.575214,   53.6206555,     4, 9,  "RU-BA R00.XX"},
        {52.696014,   58.56934775,    4, 10, "RU-BA T00.XX"},
        {52.572314,   58.21524775,    4, 10, "RU-BA W00.XX"},
        {54.203614,   54.9246135,     4, 7,  "RU-BA Y00.XX"},
        {53.827435,   53.1738935,     3, 8,  "RU-BA 123.XXX"},
        {52.948605,   54.026991,      3, 8,  "RU-BA 12.XXXX"},
        {55.977813,   55.948683,      4, 6,  "RU-BA 1234.XX"},
        {54.053,      56.575,         4, 7,  "RU-BA RM0W.XX4"},
        {56.8933545,  53.178228,      5, 9,  "RU-UD 12.XX"},
        {56.985815,   52.7724865,     4, 8,  "RU-UD 12.XXX"},
        {56.456674,   53.562098625,   4, 14, "RU-UD 000.XX"},
        {57.032374,   53.72038275,    4, 8,  "RU-UD 500.XX"},
        {58.143774,   52.432084125,   4, 10, "RU-UD B00.XX"},
        {56.436704,   52.072819625,   4, 11, "RU-UD H00.XX"},
        {57.570904,   52.938357,      4, 10, "RU-UD M00.XX"},
        {57.000804,   51.94145875,    4, 10, "RU-UD R00.XX"},
        {57.893004,   53.583696125,   4, 10, "RU-UD W00.XX"},
        {56.24709,    51.137679,      3, 13, "RU-UD 123.XXX"},
        {57.20165,    52.7806,        3, 7,  "RU-UD KC3P.49K"},
        {55.8194875,  49.1010865,     5, 7,  "RU-TA 12.XX"},
        {55.627405,   51.7210205,     4, 6,  "RU-TA 00.XXX"},
        {55.858904,   48.773035125,   4, 9,  "RU-TA J0.XXX"},
        {54.934045,   52.1886275,     4, 6,  "RU-TA 000.XX"},
        {55.879945,   48.456398125,   4, 10, "RU-TA 300.XX"},
        {54.577144,   52.6091825,     5, 7,  "RU-TA 600.XX"},
        {54.637644,   52.3433875,     4, 10, "RU-TA 900.XX"},
        {55.386765,   50.3778925,     4, 6,  "RU-TA D00.XX"},
        {55.283114,   51.9264975,     4, 6,  "RU-TA H00.XX"},
        {54.402514,   50.7154135,     5, 11, "RU-TA K00.XX"},
        {54.826714,   52.9728555,     4, 6,  "RU-TA M00.XX"},
        {55.687314,   51.248269625,   4, 6,  "RU-TA P00.XX"},
        {56.143714,   50.774611625,   5, 10, "RU-TA R00.XX"},
        {54.947814,   48.1816555,     4, 9,  "RU-TA T00.XX"},
        {56.336214,   50.152111625,   4, 12, "RU-TA W00.XX"},
        {55.886114,   52.182269625,   4, 9,  "RU-TA Y00.XX"},
        {54.1103585,  47.2519455,     3, 8,  "RU-TA 123.XXX"},
        {56.599675,   50.686131,      4, 9,  "RU-TA 12.XXXX"},
        {55.327,      50.7525,        5, 7,  "RU-TA FJYK.ZFB"},
        {53.2199155,  50.07856,       6, 11, "RU-SAM 12.XX"},
        {53.323975,   49.81963275,    6, 11, "RU-SAM 00.XXX"},
        {53.467925,   49.23297175,    5, 10, "RU-SAM J0.XXX"},
        {53.213145,   48.32037375,    4, 9,  "RU-SAM 000.XX"},
        {53.042204,   49.54175375,    5, 10, "RU-SAM 600.XX"},
        {53.676545,   49.000378125,   5, 10, "RU-SAM C00.XX"},
        {53.417204,   51.10241075,    5, 10, "RU-SAM J00.XX"},
        {53.334204,   50.37991075,    6, 8,  "RU-SAM P00.XX"},
        {54.004304,   51.038736125,   5, 14, "RU-SAM V00.XX"},
        {54.427707,   48.087797,      3, 12, "RU-SAM 123.XXX"},
        {54.594934,   48.9516895,     4, 12, "RU-SAM 12.XXXX"},
        {53.2265,     50.2435,        5, 10, "RU-SAM FQ51.VLH"},
        {51.5784,     45.936376,      5, 7,  "RU-SAR 12.XX"},
        {51.689736,   45.5714705,     4, 6,  "RU-SAR 12.XXX"},
        {52.058234,   47.666536625,   4, 8,  "RU-SAR 000.XX"},
        {51.618734,   43.022436625,   4, 9,  "RU-SAR 400.XX"},
        {52.123634,   47.176599375,   4, 8,  "RU-SAR 800.XX"},
        {52.084134,   48.683899375,   4, 9,  "RU-SAR D00.XX"},
        {51.948824,   44.889144625,   4, 6,  "RU-SAR J00.XX"},
        {52.359624,   45.261000375,   4, 9,  "RU-SAR M00.XX"},
        {52.368824,   46.356200375,   4, 9,  "RU-SAR Q00.XX"},
        {52.305824,   43.642200375,   4, 9,  "RU-SAR T00.XX"},
        {51.226824,   43.62219625,    4, 9,  "RU-SAR X00.XX"},
        {52.283077,   42.673961,      3, 8,  "RU-SAR 123.XXX"},
        {49.8079985,  47.317924,      3, 10, "RU-SAR 12.XXXX"},
        {51.311,      46.67825,       3, 5,  "RU-SAR 7WM1.W4F"},
        {66.0937825,  76.524418,      6, 9,  "RU-YAN 12.XX"},
        {66.308815,   76.0207065,     5, 8,  "RU-YAN 12.XXX"},
        {63.300574,   75.183442375,   5, 10, "RU-YAN 000.XX"},
        {63.840604,   74.432061125,   5, 10, "RU-YAN 600.XX"},
        {65.015904,   77.5044565,     5, 11, "RU-YAN C00.XX"},
        {65.486804,   64.5620705,     4, 14, "RU-YAN J00.XX"},
        {64.536604,   76.3538425,     5, 11, "RU-YAN P00.XX"},
        {63.245504,   74.365711375,   5, 10, "RU-YAN V00.XX"},
        {65.5934785,  71.302893,      4, 9,  "RU-YAN 123.XXX"},
        {65.468385,   77.1625615,     4, 10, "RU-YAN 1234.XX"},
        {68.082615,   74.1200625,     3, 5,  "RU-YAN 12.XXXX"},
        {62.2054505,  62.1939925,     3, 13, "RU-YAN 123.XXXX"},
        {66.995685,   76.9493085,     4, 7,  "RU-YAN V6LS.886"},
        {61.2766405,  73.342304,      6, 8,  "RU-KM 12.XX"},
        {61.248854,   72.94119925,    5, 7,  "RU-KM 00.XXX"},
        {61.087974,   76.04013725,    5, 8,  "RU-KM J0.XXX"},
        {61.197334,   72.38945725,    5, 7,  "RU-KM 000.XX"},
        {61.046545,   68.89815725,    5, 8,  "RU-KM 400.XX"},
        {62.317934,   74.329566875,   5, 10, "RU-KM 800.XX"},
        {61.729234,   64.383842375,   5, 14, "RU-KM D00.XX"},
        {62.193124,   65.321476875,   5, 11, "RU-KM J00.XX"},
        {62.184124,   77.326772875,   4, 7,  "RU-KM M00.XX"},
        {61.401045,   63.28546125,    5, 15, "RU-KM Q00.XX"},
        {61.327224,   74.99595725,    5, 7,  "RU-KM T00.XX"},
        {61.759645,   75.228761375,   5, 7,  "RU-KM X00.XX"},
        {62.6489835,  71.9890125,     4, 9,  "RU-KM 123.XXX"},
        {62.45693,    66.815878,      4, 10, "RU-KM 12.XXXX"},
        {63.328247,   61.292252,      4, 10, "RU-KM 1234.XX"},
        {62.8956165,  59.959942,      3, 9,  "RU-KM 123.XXXX"},
        {62.163,      72.5815,        4, 6,  "RU-KM NH8M.65J"},
        {56.87209,    60.530996,      6, 8,  "RU-SVE 12.XX"},
        {57.038115,   60.2070865,     5, 7,  "RU-SVE 12.XXX"},
        {56.963034,   59.76480875,    5, 7,  "RU-SVE 000.XX"},
        {57.998545,   59.845420625,   6, 8,  "RU-SVE 400.XX"},
        {56.463034,   61.775103125,   5, 7,  "RU-SVE 800.XX"},
        {59.675934,   60.439304,      5, 12, "RU-SVE D00.XX"},
        {57.382545,   59.874415,      5, 7,  "RU-SVE J00.XX"},
        {57.123545,   61.37840875,    5, 7,  "RU-SVE N00.XX"},
        {59.811945,   59.947404,      5, 12, "RU-SVE S00.XX"},
        {56.539045,   60.113303125,   5, 7,  "RU-SVE X00.XX"},
        {57.344565,   57.4086035,     4, 9,  "RU-SVE 123.XXX"},
        {61.437865,   58.6738615,     4, 13, "RU-SVE 12.XXXX"},
        {58.442126,   58.635448,      4, 10, "RU-SVE 1234.XX"},
        {56.4990685,  57.2828935,     4, 13, "RU-SVE 123.XXXX"},
        {58.887915,   57.9696285,     3, 8,  "RU-SVE 1234.XXX"},
        {57.1736,     65.4786575,     5, 10, "RU-TYU 12.XX"},
        {57.329115,   65.1210515,     4, 9,  "RU-TYU 12.XXX"},
        {58.321804,   68.139720625,   4, 6,  "RU-TYU 000.XX"},
        {56.205304,   69.253164125,   4, 6,  "RU-TYU 500.XX"},
        {56.728704,   66.112121125,   4, 13, "RU-TYU B00.XX"},
        {56.535545,   66.328103125,   4, 10, "RU-TYU H00.XX"},
        {58.207134,   68.459832625,   6, 8,  "RU-TYU M00.XX"},
        {56.942834,   68.46878575,    4, 6,  "RU-TYU R00.XX"},
        {56.709534,   69.641242125,   4, 6,  "RU-TYU W00.XX"},
        {56.2279895,  65.0980425,     3, 12, "RU-TYU 123.XXX"},
        {58.356033,   65.1273665,     3, 9,  "RU-TYU 12.XXXX"},
        {59.0258425,  68.514806,      4, 9,  "RU-TYU 1234.XX"},
        {57.5696,     70.00475,       3, 5,  "RU-TYU K2K3.XFD"},
        {55.4895,     65.2744835,     6, 11, "RU-KGN 12.XX"},
        {55.707915,   64.9858565,     5, 10, "RU-KGN 12.XXX"},
        {56.142204,   63.431364125,   4, 10, "RU-KGN 000.XX"},
        {55.308404,   67.0550745,     4, 11, "RU-KGN 500.XX"},
        {55.308404,   63.1015745,     4, 11, "RU-KGN B00.XX"},
        {56.375134,   62.419442125,   4, 10, "RU-KGN H00.XX"},
        {55.154634,   67.7863325,     4, 12, "RU-KGN M00.XX"},
        {56.048634,   64.281659125,   4, 6,  "RU-KGN R00.XX"},
        {56.314134,   62.735742125,   4, 13, "RU-KGN W00.XX"},
        {56.780907,   62.1436225,     3, 9,  "RU-KGN 123.XXX"},
        {56.590505,   64.5763855,     4, 9,  "RU-KGN 12.XXXX"},
        {55.5125,     65.3495,        5, 10, "RU-KGN BY57.VY8"},
        {55.1931225,  61.354914,      5, 9,  "RU-CH 12.XX"},
        {55.229834,   61.0950975,     4, 8,  "RU-CH 00.XXX"},
        {53.488174,   58.88137175,    4, 10, "RU-CH J0.XXX"},
        {55.222234,   59.5548155,     4, 9,  "RU-CH 000.XX"},
        {55.056224,   59.9503875,     4, 9,  "RU-CH 400.XX"},
        {55.785724,   60.499102125,   4, 6,  "RU-CH 700.XX"},
        {54.137524,   61.4847425,     4, 9,  "RU-CH B00.XX"},
        {55.289545,   60.0603925,     4, 6,  "RU-CH F00.XX"},
        {56.131724,   60.126002125,   4, 10, "RU-CH J00.XX"},
        {54.904545,   61.2732875,     4, 8,  "RU-CH M00.XX"},
        {55.531424,   60.1041685,     4, 6,  "RU-CH Q00.XX"},
        {53.127724,   60.52328975,    4, 7,  "RU-CH T00.XX"},
        {55.038124,   57.1739875,     4, 10, "RU-CH X00.XX"},
        {55.5901445,  57.300012,      3, 9,  "RU-CH 123.XXX"},
        {53.8951615,  59.0118775,     3, 9,  "RU-CH 12.XXXX"},
        {54.174,      60.2425,        3, 6,  "RU-CH 46KY.98X"},
        {51.846445,   107.5547905,    6, 14, "RU-BU 12.XX"},
        {51.969115,   107.18828,      5, 13, "RU-BU 12.XXX"},
        {50.659724,   107.4757405,    5, 9,  "RU-BU 000.XX"},
        {55.871345,   109.520398125,  5, 16, "RU-BU 300.XX"},
        {51.377624,   106.42279625,   5, 12, "RU-BU 600.XX"},
        {50.427324,   106.33798475,   5, 10, "RU-BU 900.XX"},
        {51.932624,   107.895244625,  6, 17, "RU-BU D00.XX"},
        {52.283624,   107.541400375,  5, 11, "RU-BU H00.XX"},
        {50.443545,   103.25034875,   4, 8,  "RU-BU L00.XX"},
        {52.211144,   109.680127375,  5, 14, "RU-BU P00.XX"},
        {56.386144,   114.753934125,  4, 14, "RU-BU R00.XX"},
        {51.509344,   107.312743625,  5, 12, "RU-BU T00.XX"},
        {54.353944,   110.1978195,    5, 14, "RU-BU W00.XX"},
        {52.576844,   111.40144275,   5, 14, "RU-BU Y00.XX"},
        {52.5765785,  105.623387,     4, 11, "RU-BU 123.XXX"},
        {54.196525,   108.543192,     4, 13, "RU-BU 12.XXXX"},
        {56.944675,   109.3946465,    4, 15, "RU-BU 1234.XX"},
        {55.2549305,  99.2087335,     3, 9,  "RU-BU 123.XXXX"},
        {53.6035,     108.2755,       3, 12, "RU-BU GVFF.9L4"},
        {52.0564825,  113.389427,     6, 17, "RU-ZAB 12.XX"},
        {52.219815,   113.04278,      5, 14, "RU-ZAB 12.XXX"},
        {50.139245,   117.93234875,   5, 10, "RU-ZAB 000.XX"},
        {52.321634,   117.473499375,  5, 14, "RU-ZAB 400.XX"},
        {51.352734,   108.74471425,   4, 13, "RU-ZAB 800.XX"},
        {52.047334,   116.471836625,  5, 18, "RU-ZAB D00.XX"},
        {51.850924,   113.745744625,  6, 17, "RU-ZAB J00.XX"},
        {51.703545,   113.900144625,  5, 15, "RU-ZAB M00.XX"},
        {50.422724,   116.3060525,    5, 15, "RU-ZAB Q00.XX"},
        {51.411545,   110.37829625,   4, 12, "RU-ZAB T00.XX"},
        {53.786224,   119.622138125,  5, 10, "RU-ZAB X00.XX"},
        {52.4789835,  111.501387,     4, 15, "RU-ZAB 123.XXX"},
        {52.28693,    115.7435625,    4, 13, "RU-ZAB 12.XXXX"},
        {55.03508,    116.7676175,    4, 12, "RU-ZAB 1234.XX"},
        {58.3355325,  108.301469,     3, 11, "RU-ZAB 123.XXXX"},
        {53.7965,     114.9395,       3, 11, "RU-ZAB QJXB.21K"},
        {52.316537,   104.2385025,    6, 12, "RU-IRK 12.XX"},
        {52.401234,   103.895516375,  5, 11, "RU-IRK 00.XXX"},
        {52.511105,   103.46395875,   5, 11, "RU-IRK J0.XXX"},
        {56.194545,   101.340898125,  5, 11, "RU-IRK 000.XX"},
        {56.360045,   101.643403125,  5, 11, "RU-IRK 400.XX"},
        {58.062734,   102.588420625,  5, 8,  "RU-IRK 800.XX"},
        {52.843734,   103.46182175,   5, 11, "RU-IRK D00.XX"},
        {53.175945,   103.00637375,   5, 11, "RU-IRK J00.XX"},
        {56.846545,   105.62810875,   4, 12, "RU-IRK M00.XX"},
        {54.623724,   100.4541865,    4, 10, "RU-IRK Q00.XX"},
        {57.883545,   113.951420625,  4, 11, "RU-IRK T00.XX"},
        {52.623045,   103.79136875,   6, 12, "RU-IRK X00.XX"},
        {53.7515785,  102.1861905,    4, 10, "RU-IRK 123.XXX"},
        {58.354094,   100.0707595,    4, 8,  "RU-IRK 12.XXXX"},
        {53.824571,   101.3001075,    4, 10, "RU-IRK 1234.XX"},
        {62.9785205,  96.583302,      2, 6,  "RU-IRK 123.XXXX"},
        {53.420655,   96.582796,      3, 10, "RU-IRK 1234.XXX"},
        {55.07027,    82.872803,      5, 8,  "RU-NVS 12.XX"},
        {54.7083455,  82.585538,      4, 7,  "RU-NVS 12.XXX"},
        {54.716534,   83.1466325,     5, 8,  "RU-NVS 000.XX"},
        {55.474134,   78.1876155,     4, 7,  "RU-NVS 400.XX"},
        {54.459734,   77.1073825,     4, 9,  "RU-NVS 800.XX"},
        {55.277634,   75.8166155,     4, 12, "RU-NVS D00.XX"},
        {55.269634,   80.0717155,     4, 7,  "RU-NVS J00.XX"},
        {54.366545,   80.3163495,     4, 10, "RU-NVS N00.XX"},
        {55.299145,   84.2110155,     4, 7,  "RU-NVS S00.XX"},
        {53.807424,   82.137678125,   4, 10, "RU-NVS X00.XX"},
        {53.839143,   81.252707,      3, 10, "RU-NVS 123.XXX"},
        {56.288415,   75.3757435,     3, 11, "RU-NVS 12.XXXX"},
        {54.269681,   75.4554325,     3, 10, "RU-NVS 1234.XX"},
        {55.2625,     80.1005,        4, 7,  "RU-NVS BDB2.HMT"},
        {56.5288,     84.9122995,     6, 15, "RU-TOM 12.XX"},
        {56.679415,   84.6647865,     5, 12, "RU-TOM 12.XXX"},
        {57.082074,   85.98595175,    5, 8,  "RU-TOM 000.XX"},
        {60.804204,   77.37802275,    5, 11, "RU-TOM 600.XX"},
        {58.419804,   82.723541875,   5, 8,  "RU-TOM C00.XX"},
        {57.441504,   83.698131,      5, 8,  "RU-TOM J00.XX"},
        {57.107504,   81.98980975,    5, 9,  "RU-TOM P00.XX"},
        {57.733704,   83.500431,      5, 8,  "RU-TOM V00.XX"},
        {58.2895785,  83.159719,      4, 7,  "RU-TOM 123.XXX"},
        {58.598405,   78.5126845,     4, 10, "RU-TOM 12.XXXX"},
        {60.284813,   75.8516285,     4, 10, "RU-TOM 1234.XX"},
        {59.809844,   75.5249395,     3, 8,  "RU-TOM 123.XXXX"},
        {58.3515,     82.216,         4, 7,  "RU-TOM DLQ1.GT1"},
        {54.929997,   73.3392175,     6, 10, "RU-OMS 12.XX"},
        {55.107215,   72.9719915,     5, 9,  "RU-OMS 12.XXX"},
        {55.334545,   72.8963925,     5, 10, "RU-OMS 000.XX"},
        {56.941434,   74.32468575,    4, 7,  "RU-OMS 400.XX"},
        {54.980834,   71.1028325,     5, 10, "RU-OMS 800.XX"},
        {54.634334,   73.5277495,     5, 9,  "RU-OMS D00.XX"},
        {54.224924,   74.6284865,     4, 8,  "RU-OMS J00.XX"},
        {55.603424,   71.2138685,     4, 9,  "RU-OMS M00.XX"},
        {55.117724,   74.3890275,     5, 9,  "RU-OMS Q00.XX"},
        {56.422545,   75.040403125,   5, 8,  "RU-OMS T00.XX"},
        {55.961445,   71.979202125,   4, 7,  "RU-OMS X00.XX"},
        {54.9588745,  70.52062,       4, 9,  "RU-OMS 123.XXX"},
        {55.6437615,  70.635512,      3, 8,  "RU-OMS 12.XXXX"},
        {56.74481,    70.558297,      3, 8,  "RU-OMS 1234.XX"},
        {56.0065,     73.3315,        3, 6,  "RU-OMS 36CC.58R"},
        {53.743705,   91.3621765,     6, 10, "RU-KK 12.XX"},
        {53.926215,   90.9336615,     5, 9,  "RU-KK 12.XXX"},
        {53.206545,   91.26407375,    5, 10, "RU-KK 000.XX"},
        {52.716045,   90.01036875,    5, 9,  "RU-KK 700.XX"},
        {54.586874,   89.8887785,     4, 8,  "RU-KK F00.XX"},
        {53.123474,   90.68836875,    5, 10, "RU-KK M00.XX"},
        {53.180374,   90.29437375,    5, 9,  "RU-KK T00.XX"},
        {52.7141,     88.3671825,     4, 10, "RU-KK 123.XXX"},
        {53.7106175,  88.1251755,     3, 10, "RU-KK 12.XXXX"},
        {53.3595,     89.907,         4, 8,  "RU-KK NWSD.QR2"},
        {53.772444,   87.0839755,     5, 11, "RU-KEM 12.XX"},
        {53.822925,   86.850983125,   5, 11, "RU-KEM 00.XXX"},
        {55.327945,   85.5775205,     4, 7,  "RU-KEM J0.XXX"},
        {53.925434,   86.573027125,   4, 10, "RU-KEM 000.XX"},
        {54.720334,   86.0343325,     5, 8,  "RU-KEM 400.XX"},
        {53.738545,   87.916927125,   4, 10, "RU-KEM 800.XX"},
        {55.786134,   84.757859125,   4, 14, "RU-KEM D00.XX"},
        {54.547355,   86.2315125,     5, 8,  "RU-KEM J00.XX"},
        {56.149315,   85.930602125,   4, 11, "RU-KEM M00.XX"},
        {55.685824,   86.1521925,     4, 11, "RU-KEM Q00.XX"},
        {56.280224,   87.583843125,   4, 11, "RU-KEM T00.XX"},
        {52.882545,   87.73904875,    4, 7,  "RU-KEM X00.XX"},
        {56.5501535,  84.6255505,     3, 12, "RU-KEM 123.XXX"},
        {54.4136355,  85.163241,      4, 10, "RU-KEM 12.XXXX"},
        {54.496,      86.9215,        4, 7,  "RU-KEM KQXV.3D3"},
        {51.987216,   85.8892565,     5, 11, "RU-AL 12.XX"},
        {52.147315,   85.63668,       4, 10, "RU-AL 12.XXX"},
        {51.353504,   85.51241125,    4, 7,  "RU-AL 000.XX"},
        {52.296545,   86.995729375,   4, 13, "RU-AL 500.XX"},
        {51.034545,   84.67011125,    4, 7,  "RU-AL B00.XX"},
        {51.536545,   85.88835625,    4, 9,  "RU-AL H00.XX"},
        {50.858034,   85.8953525,     4, 7,  "RU-AL M00.XX"},
        {50.328545,   85.49908975,    4, 8,  "RU-AL R00.XX"},
        {50.034545,   88.48784875,    4, 8,  "RU-AL W00.XX"},
        {51.9355775,  84.0866505,     3, 12, "RU-AL 123.XXX"},
        {49.5948155,  84.1673155,     3, 8,  "RU-AL 12.XXXX"},
        {50.866,      86.896,         3, 6,  "RU-AL KSBC.GTM"},
        {53.383209,   83.666777,      5, 9,  "RU-ALT 12.XX"},
        {53.452174,   83.45897175,    4, 8,  "RU-ALT 00.XXX"},
        {52.623634,   84.898116375,   4, 11, "RU-ALT J0.XXX"},
        {51.588545,   81.110760625,   4, 8,  "RU-ALT 000.XX"},
        {53.799304,   84.823936125,   4, 11, "RU-ALT 500.XX"},
        {52.061545,   85.253336625,   4, 10, "RU-ALT B00.XX"},
        {53.898834,   81.164827125,   4, 10, "RU-ALT H00.XX"},
        {52.335545,   85.003664375,   4, 13, "RU-ALT M00.XX"},
        {52.560834,   82.616099375,   4, 9,  "RU-ALT R00.XX"},
        {53.870634,   83.421127125,   4, 10, "RU-ALT W00.XX"},
        {51.746259,   83.577572,      4, 8,  "RU-ALT 123.XXX"},
        {51.3397735,  78.85973,       2, 5,  "RU-ALT 12.XXXX"},
        {53.8915795,  78.1017985,     3, 11, "RU-ALT 1234.XX"},
        {52.546,      82.5275,        3, 8,  "RU-ALT F3W5.52V"},
        {51.688465,   94.389568,      5, 9,  "RU-TY 12.XX"},
        {51.718244,   93.9958995,     5, 9,  "RU-TY 12.XXX"},
        {51.236545,   90.45521425,    4, 8,  "RU-TY 000.XX"},
        {51.181545,   93.38535625,    4, 8,  "RU-TY 400.XX"},
        {51.447634,   91.07731425,    4, 11, "RU-TY 800.XX"},
        {51.054934,   89.99511425,    4, 8,  "RU-TY D00.XX"},
        {51.518545,   95.45535625,    4, 8,  "RU-TY J00.XX"},
        {51.359934,   91.40081425,    4, 11, "RU-TY N00.XX"},
        {52.193934,   93.815899375,   4, 8,  "RU-TY S00.XX"},
        {51.206545,   94.26335625,    4, 8,  "RU-TY X00.XX"},
        {51.1788195,  93.715908,      4, 8,  "RU-TY 123.XXX"},
        {52.764022,   93.8320175,     3, 7,  "RU-TY 12.XXXX"},
        {51.349297,   88.9746415,     3, 13, "RU-TY 1234.XX"},
        {51.7355,     94.035,         5, 9,  "RU-TY TDL2.DJT"},
        {56.0427,     92.8196415,     5, 7,  "RU-KYA 12.XX"},
        {56.1795565,  92.4761215,     4, 6,  "RU-KYA 12.XXX"},
        {69.404034,   87.84932075,    4, 6,  "RU-KYA 000.XX"},
        {56.306324,   90.313543125,   4, 6,  "RU-KYA 400.XX"},
        {56.258024,   95.537443125,   5, 7,  "RU-KYA 800.XX"},
        {53.727545,   91.546838125,   3, 11, "RU-KYA D00.XX"},
        {56.166724,   94.413902125,   4, 6,  "RU-KYA J00.XX"},
        {58.298045,   92.363220625,   4, 6,  "RU-KYA N00.XX"},
        {69.572624,   88.14162175,    4, 6,  "RU-KYA S00.XX"},
        {56.273724,   89.405743125,   4, 6,  "RU-KYA X00.XX"},
        {57.2819835,  88.87807,       3, 8,  "RU-KYA 123.XXX"},
        {57.08993,    93.6085675,     3, 5,  "RU-KYA 12.XXXX"},
        {59.83808,    90.551042,      3, 5,  "RU-KYA 1234.XX"},
        {75.8131265,  88.085043,      3, 5,  "RU-KYA 0123.XXX"},
        {75.8131265,  97.171297,      3, 5,  "RU-KYA 1123.XXX"},
        {73.1319365,  81.8927705,     3, 7,  "RU-KYA 2123.XXX"},
        {73.1319365,  89.8171765,     3, 5,  "RU-KYA 3123.XXX"},
        {73.1319365,  97.7415825,     3, 5,  "RU-KYA 4123.XXX"},
        {70.4507465,  79.0794215,     3, 7,  "RU-KYA 5123.XXX"},
        {70.4507465,  86.1100975,     3, 5,  "RU-KYA 6123.XXX"},
        {70.4507465,  93.1407735,     3, 5,  "RU-KYA 7123.XXX"},
        {70.4507465,  100.1714495,    3, 5,  "RU-KYA 8123.XXX"},
        {72.0594605,  105.576842,     3, 7,  "RU-KYA 9123.XXX"},
        {67.7695565,  81.933366,      2, 6,  "RU-KYA B123.XXX"},
        {67.7695565,  88.278849,      2, 4,  "RU-KYA C123.XXX"},
        {67.7695565,  94.624332,      2, 4,  "RU-KYA D123.XXX"},
        {67.7695565,  100.969815,     2, 4,  "RU-KYA F123.XXX"},
        {65.0883665,  84.4009645,     2, 8,  "RU-KYA G123.XXX"},
        {65.0883665,  90.1804185,     2, 4,  "RU-KYA H123.XXX"},
        {65.0883665,  95.9598725,     2, 4,  "RU-KYA J123.XXX"},
        {65.0883665,  101.7393265,    2, 4,  "RU-KYA K123.XXX"},
        {62.4071765,  84.4478545,     2, 8,  "RU-KYA L123.XXX"},
        {62.4071765,  89.7506525,     2, 4,  "RU-KYA M123.XXX"},
        {62.4071765,  95.0534505,     2, 4,  "RU-KYA N123.XXX"},
        {62.4071765,  100.3562485,    2, 6,  "RU-KYA P123.XXX"},
        {61.5899675,  103.022515,     3, 8,  "RU-KYA Q123.XXX"},
        {59.7259865,  87.234261,      2, 7,  "RU-KYA R123.XXX"},
        {59.7259865,  92.090194,      3, 5,  "RU-KYA S123.XXX"},
        {59.7259865,  96.946127,      2, 7,  "RU-KYA T123.XXX"},
        {60.7984625,  101.2327375,    3, 8,  "RU-KYA V123.XXX"},
        {57.0447965,  88.641625,      2, 7,  "RU-KYA W123.XXX"},
        {57.0447965,  93.199648,      3, 5,  "RU-KYA X123.XXX"},
        {54.3905785,  90.6194215,     2, 7,  "RU-KYA Y123.XXX"},
        {54.3708265,  94.764496,      2, 4,  "RU-KYA Z123.XXX"},
        {80.5209195,  77.427912,      2, 4,  "RU-KYA 123.XXXX"},
        {59.5354545,  150.7766015,    5, 8,  "RU-MAG 12.XX"},
        {59.8818845,  150.161386,     4, 7,  "RU-MAG 12.XXX"},
        {60.199804,   150.705046875,  4, 7,  "RU-MAG 000.XX"},
        {62.989104,   152.129261625,  4, 7,  "RU-MAG 500.XX"},
        {62.809545,   147.744785625,  4, 8,  "RU-MAG B00.XX"},
        {62.538734,   155.522366875,  4, 7,  "RU-MAG H00.XX"},
        {61.185834,   149.43185725,   4, 7,  "RU-MAG M00.XX"},
        {62.046734,   159.072266875,  4, 11, "RU-MAG R00.XX"},
        {62.590634,   149.457011625,  4, 7,  "RU-MAG W00.XX"},
        {61.4535785,  148.584701,     3, 6,  "RU-MAG 123.XXX"},
        {63.938343,   147.7551125,    3, 7,  "RU-MAG 12.XXXX"},
        {62.860798,   153.2854505,    3, 6,  "RU-MAG 1234.XX"},
        {65.8189855,  145.4018785,    2, 6,  "RU-MAG 1234.XXX"},
        {64.765674,   177.642599,     5, 9,  "RU-CHU 12.XX"},
        {64.964015,   177.1086465,    4, 8,  "RU-CHU 12.XXX"},
        {68.277224,   165.79413825,   4, 6,  "RU-CHU 000.XX"},
        {69.832334,   169.98189775,   4, 6,  "RU-CHU J00.XX"},
        {66.0419835,  175.189334,     3, 7,  "RU-CHU 123.XXX"},
        {70.008287,   163.2511175,    3, 5,  "RU-CHU 12.XXXX"},
        {70.075247,   169.9538135,    3, 5,  "RU-CHU 1234.XX"},
        {69.998068,   158.912157,     2, 6,  "RU-CHU 1234.XXX"},
        {53.0712135,  158.5740705,    5, 7,  "RU-KAM 12.XX"},
        {53.285815,   158.0860315,    4, 6,  "RU-KAM 12.XXX"},
        {54.741304,   158.2290775,    4, 6,  "RU-KAM 000.XX"},
        {57.924654,   158.246561,     4, 7,  "RU-KAM C00.XX"},
        {52.962054,   156.11711675,   4, 8,  "RU-KAM P00.XX"},
        {53.9268045,  156.0133385,    3, 7,  "RU-KAM 123.XXX"},
        {56.415941,   155.8324015,    3, 6,  "RU-KAM 12.XXXX"},
        {59.164091,   155.9544805,    3, 8,  "RU-KAM 1234.XX"},
        {63.968438,   156.230061,     2, 7,  "RU-KAM 1234.XXX"},
        {46.973675,   142.6944065,    5, 9,  "RU-SAK 12.XX"},
        {47.033715,   142.509925,     4, 8,  "RU-SAK 12.XXX"},
        {49.257674,   142.87184925,   5, 9,  "RU-SAK 000.XX"},
        {49.083204,   141.99364025,   5, 9,  "RU-SAK 600.XX"},
        {47.137104,   142.010766125,  4, 8,  "RU-SAK C00.XX"},
        {50.971504,   142.0693185,    5, 9,  "RU-SAK J00.XX"},
        {53.657804,   142.787236125,  4, 8,  "RU-SAK P00.XX"},
        {51.874604,   142.979336625,  5, 9,  "RU-SAK V00.XX"},
        {47.242143,   141.795168,     3, 7,  "RU-SAK 123.XXX"},
        {51.498485,   141.7346135,    3, 7,  "RU-SAK 12.XXXX"},
        {51.454611,   141.871112,     4, 8,  "RU-SAK 1234.XX"},
        {53.655601,   141.7616395,    3, 7,  "RU-SAK 1234.XXX"},
        {43.155345,   131.8580975,    5, 8,  "RU-PO 12.XX"},
        {43.397356,   131.844809,     4, 9,  "RU-PO 12.XXX"},
        {43.872945,   131.79431,      4, 10, "RU-PO 000.XX"},
        {42.924545,   132.840555,     4, 7,  "RU-PO 500.XX"},
        {44.259104,   133.179595125,  4, 9,  "RU-PO B00.XX"},
        {43.226545,   133.0703075,    4, 7,  "RU-PO H00.XX"},
        {44.644934,   132.669848125,  4, 9,  "RU-PO M00.XX"},
        {44.613545,   135.416313125,  4, 6,  "RU-PO R00.XX"},
        {45.526434,   133.30229175,   4, 9,  "RU-PO W00.XX"},
        {42.851527,   130.7557955,    3, 9,  "RU-PO 123.XXX"},
        {45.320401,   133.976373,     3, 8,  "RU-PO 12.XXXX"},
        {46.92004,    133.568476,     3, 10, "RU-PO 1234.XX"},
        {48.0312435,  130.711309,     2, 12, "RU-PO 1234.XXX"},
        {48.821415,   132.8724275,    4, 11, "RU-YEV 12.XX"},
        {48.963215,   132.5902415,    3, 12, "RU-YEV 12.XXX"},
        {48.653804,   133.6369475,    3, 10, "RU-YEV 000.XX"},
        {49.039545,   130.94354025,   3, 13, "RU-YEV 500.XX"},
        {48.620504,   134.3499475,    3, 11, "RU-YEV B00.XX"},
        {49.061145,   131.69606525,   3, 12, "RU-YEV H00.XX"},
        {48.004545,   132.476601375,  3, 12, "RU-YEV M00.XX"},
        {47.830534,   130.93329925,   3, 13, "RU-YEV R00.XX"},
        {48.560545,   134.6359185,    4, 12, "RU-YEV W00.XX"},
        {48.92149,    130.640433,     2, 11, "RU-YEV 123.XXX"},
        {48.42601,    135.0347905,    5, 9,  "RU-KHA 12.XX"},
        {48.556505,   134.7426275,    4, 12, "RU-KHA 00.XXX"},
        {50.672235,   136.79726775,   4, 6,  "RU-KHA J0.XXX"},
        {50.330334,   136.59434875,   4, 6,  "RU-KHA 000.XX"},
        {49.133745,   140.11234125,   4, 6,  "RU-KHA 700.XX"},
        {53.177545,   140.46488775,   3, 5,  "RU-KHA F00.XX"},
        {59.486545,   143.03644,      3, 7,  "RU-KHA M00.XX"},
        {47.681074,   134.64391825,   4, 13, "RU-KHA T00.XX"},
        {49.3789835,  134.411521,     3, 12, "RU-KHA 123.XXX"},
        {51.86812,    134.311384,     3, 8,  "RU-KHA 12.XXXX"},
        {49.038087,   138.259882,     3, 5,  "RU-KHA 1234.XX"},
        {49.2868035,  130.962134,     2, 12, "RU-KHA 1234.XXX"},
        {50.254947,   127.476104,     5, 11, "RU-AMU 12.XX"},
        {50.453134,   127.30938775,   4, 9,  "RU-AMU 00.XXX"},
        {50.822265,   128.1546865,    4, 7,  "RU-AMU J0.XXX"},
        {51.467545,   128.00035625,   4, 7,  "RU-AMU 000.XX"},
        {53.782734,   127.075378125,  4, 6,  "RU-AMU 400.XX"},
        {50.187234,   129.32178975,   4, 7,  "RU-AMU 800.XX"},
        {49.873134,   129.278127,     4, 7,  "RU-AMU D00.XX"},
        {52.067524,   127.603700375,  4, 9,  "RU-AMU J00.XX"},
        {55.232624,   124.6487685,    4, 6,  "RU-AMU N00.XX"},
        {49.481024,   129.993329,     4, 9,  "RU-AMU S00.XX"},
        {49.868324,   129.749729,     4, 7,  "RU-AMU X00.XX"},
        {51.6108455,  127.3542075,    3, 8,  "RU-AMU 123.XXX"},
        {54.099982,   126.13347,      3, 5,  "RU-AMU 12.XXXX"},
        {55.775656,   121.6777965,    3, 10, "RU-AMU 1234.XX"},
        {56.4845535,  120.2048135,    2, 12, "RU-AMU 1234.XXX"},
        {62.0753,     129.635509,     5, 7,  "RU-SA 12.XX"},
        {61.8330725,  129.3820675,    4, 6,  "RU-SA 12.XXX"},
        {56.706545,   124.553621125,  4, 8,  "RU-SA 000.XX"},
        {61.543745,   128.840469375,  4, 6,  "RU-SA 500.XX"},
        {64.005904,   127.292861125,  3, 5,  "RU-SA B00.XX"},
        {60.766545,   114.79045375,   4, 9,  "RU-SA H00.XX"},
        {58.642334,   125.264836875,  4, 6,  "RU-SA M00.XX"},
        {62.223034,   117.454966875,  4, 8,  "RU-SA R00.XX"},
        {62.056545,   132.350476875,  4, 8,  "RU-SA W00.XX"},
        {63.3189835,  127.777384,     3, 5,  "RU-SA 123.XXX"},
        {58.75693,    123.0157775,    3, 5,  "RU-SA 12.XXXX"},
        {62.55389,    113.841286,     3, 8,  "RU-SA 1234.XX"},
        {60.329155,   107.05935,      2, 8,  "RU-SA 1234.XXX"},
        {68.1371575,  106.9566375,    2, 5,  "RU-SA 123.XXXX"},
        {81.9815375,  -137.796004,    1, 2,  "CAN 1234.XXXX"},
        {80.5374855,  46.068281,      1, 4,  "RUS 0123.XXXX"},
        {75.8739455,  45.389186,      1, 4,  "RUS 1123.XXXX"},
        {75.8739455,  80.418358,      1, 4,  "RUS 2123.XXXX"},
        {74.9038095,  115.4097155,    1, 3,  "RUS 3123.XXXX"},
        {75.330344,   152.1589115,    1, 3,  "RUS 4123.XXXX"},
        {68.9616175,  145.59929,      1, 4,  "RUS 5123.XXXX"},
        {69.7320325,  169.3564325,    1, 5,  "RUS 6123.XXXX"},
        {51.989943,   142.777099,     1, 8,  "RUS 7123.XXXX"},
        {51.712092,   155.4879955,    1, 4,  "RUS 8123.XXXX"},
        {48.798557,   140.2249995,    1, 5,  "RUS 9123.XXXX"},
        {69.536102,   29.1948725,     1, 7,  "RUS B123.XXXX"},
        {68.9616175,  50.4839005,     1, 9,  "RUS C123.XXXX"},
        {68.9616175,  74.34929,       1, 4,  "RUS D123.XXXX"},
        {68.9616175,  98.09929,       1, 4,  "RUS F123.XXXX"},
        {68.9616175,  121.84929,      1, 4,  "RUS G123.XXXX"},
        {54.9022745,  19.6955155,     1, 4,  "RUS K123.XXXX"},
        {57.979173,   27.455316,      1, 8,  "RUS M123.XXXX"},
        {52.1767295,  31.2108305,     1, 5,  "RUS P123.XXXX"},
        {49.729467,   37.083134,      1, 3,  "RUS Q123.XXXX"},
        {50.9699155,  49.712478,      1, 7,  "RUS R123.XXXX"},
        {60.3237345,  62.9910605,     1, 11, "RUS S123.XXXX"},
        {49.39898,    79.3441325,     1, 4,  "RUS T123.XXXX"},
        {49.463617,   96.2441325,     1, 4,  "RUS V123.XXXX"},
        {49.463617,   113.0941325,    1, 7,  "RUS W123.XXXX"},
        {51.9433525,  129.9279955,    1, 6,  "RUS X123.XXXX"},
        {42.9935925,  129.9082725,    1, 8,  "RUS Z123.XXXX"},
        {31.2571,     121.4142755,    5, 10, "CN-SH 12.XX"},
        {31.302195,   121.144764,     4, 9,  "CN-SH 12.XXX"},
        {30.937245,   121.1370935,    4, 12, "CN-SH 123.XX"},
        {31.836827,   120.9082805,    3, 8,  "CN-SH 123.XXX"},
        {31.268,      121.577,        4, 9,  "CN-SH XK4W.X5K"},
        {39.1651,     117.1520655,    5, 12, "CN-TJ 12.XX"},
        {39.408995,   116.9099975,    4, 11, "CN-TJ 12.XXX"},
        {39.191545,   117.42628875,   4, 11, "CN-TJ 000.XX"},
        {39.361545,   117.66720475,   4, 11, "CN-TJ C00.XX"},
        {38.886545,   117.337286875,  4, 11, "CN-TJ P00.XX"},
        {39.4,        117.3975435,    4, 11, "CN-TJ SWV.ZC1"},
        {39.4,        117.3975435,    4, 11, "CN-TJ P3T0.9MT"},
        {39.9421,     116.3482235,    5, 12, "CN-BJ 12.XX"},
        {40.067171,   116.128082,     4, 11, "CN-BJ 12.XXX"},
        {40.3389975,  116.0350425,    4, 11, "CN-BJ 123.XX"},
        {40.25,       116.47,         4, 11, "CN-BJ CVN.WVD"},
        {40.25,       116.47,         4, 11, "CN-BJ MHM7.23L"},
        {20.064596,   110.2869525,    5, 7,  "CN-HI 12.XX"},
        {20.050115,   110.1076415,    4, 6,  "CN-HI 12.XXX"},
        {19.576545,   109.47623875,   4, 7,  "CN-HI 000.XX"},
        {18.319545,   109.36323625,   4, 7,  "CN-HI 400.XX"},
        {19.717434,   110.70723875,   4, 6,  "CN-HI 800.XX"},
        {19.272545,   110.3942375,    4, 6,  "CN-HI D00.XX"},
        {19.783324,   109.92123875,   4, 6,  "CN-HI J00.XX"},
        {18.865524,   110.317904875,  4, 6,  "CN-HI M00.XX"},
        {19.954724,   109.60748275,   4, 6,  "CN-HI Q00.XX"},
        {18.404545,   109.06951225,   4, 7,  "CN-HI T00.XX"},
        {18.446545,   109.713236875,  4, 6,  "CN-HI X00.XX"},
        {19.8768325,  108.6534755,    3, 6,  "CN-HI 123.XXX"},
        {17.693817,   110.844121,     3, 5,  "CN-HI 12.XXXX"},
        {15.5044015,  113.753063,     3, 5,  "CN-HI 1234.XX"},
        {19.743183,   108.897353,     3, 6,  "CN-HI 1234.XXX"},
        {38.4984,     106.211306,     5, 13, "CN-NX 12.XX"},
        {38.126539,   105.9741535,    4, 12, "CN-NX 12.XXX"},
        {39.036545,   106.27248875,   4, 13, "CN-NX 000.XX"},
        {38.110969,   106.044284375,  4, 12, "CN-NX 700.XX"},
        {37.578045,   105.0737895,    4, 10, "CN-NX F00.XX"},
        {36.102702,   106.141418875,  4, 10, "CN-NX M00.XX"},
        {39.309574,   106.68528875,   4, 13, "CN-NX T00.XX"},
        {39.375563,   105.8761995,    3, 12, "CN-NX 012.XXX"},
        {39.375563,   106.4751185,    3, 12, "CN-NX 112.XXX"},
        {38.884523,   105.816021,     3, 12, "CN-NX 212.XXX"},
        {38.884523,   106.409732,     4, 13, "CN-NX 312.XXX"},
        {38.393483,   105.7615705,    3, 11, "CN-NX 412.XXX"},
        {38.393483,   106.3500745,    4, 12, "CN-NX 512.XXX"},
        {38.393483,   106.9385785,    3, 11, "CN-NX 612.XXX"},
        {37.804235,   104.2903105,    3, 9,  "CN-NX 712.XXX"},
        {37.804235,   104.8788145,    3, 9,  "CN-NX 812.XXX"},
        {37.902443,   105.4673185,    3, 9,  "CN-NX 912.XXX"},
        {37.902443,   106.0558225,    3, 11, "CN-NX B12.XXX"},
        {37.902443,   106.6443265,    3, 11, "CN-NX C12.XXX"},
        {37.902443,   107.1868705,    4, 12, "CN-NX D12.XXX"},
        {37.411403,   104.584276,     4, 11, "CN-NX F12.XXX"},
        {37.411403,   105.167572,     5, 12, "CN-NX G12.XXX"},
        {37.411403,   105.750868,     3, 11, "CN-NX H12.XXX"},
        {37.411403,   106.334164,     3, 11, "CN-NX J12.XXX"},
        {37.411403,   106.91746,      3, 11, "CN-NX K12.XXX"},
        {36.920363,   105.0558345,    3, 8,  "CN-NX L12.XXX"},
        {36.920363,   105.6339225,    3, 9,  "CN-NX M12.XXX"},
        {36.920363,   106.2120105,    3, 9,  "CN-NX N12.XXX"},
        {36.429323,   105.315688,     3, 8,  "CN-NX P12.XXX"},
        {36.429323,   105.888568,     3, 9,  "CN-NX Q12.XXX"},
        {36.429323,   106.461448,     3, 9,  "CN-NX R12.XXX"},
        {35.938283,   105.315688,     3, 8,  "CN-NX S12.XXX"},
        {35.938283,   105.888568,     3, 9,  "CN-NX T12.XXX"},
        {35.938283,   106.461448,     3, 9,  "CN-NX V12.XXX"},
        {35.307223,   105.857376,     3, 9,  "CN-NX W12.XXX"},
        {37.345,      105.9965,       3, 9,  "CN-NX VKVM.T09"},
        {29.5841,     106.4941175,    5, 9,  "CN-CQ 12.XX"},
        {29.756115,   106.295742,     4, 8,  "CN-CQ 12.XXX"},
        {30.879034,   108.284076625,  4, 9,  "CN-CQ 000.XX"},
        {29.311545,   106.175568875,  4, 8,  "CN-CQ 400.XX"},
        {30.047124,   106.181739375,  4, 9,  "CN-CQ 700.XX"},
        {28.954624,   105.351883625,  4, 12, "CN-CQ B00.XX"},
        {29.752545,   107.235258125,  4, 8,  "CN-CQ F00.XX"},
        {29.412524,   105.851256875,  4, 8,  "CN-CQ J00.XX"},
        {29.891545,   106.945554125,  4, 8,  "CN-CQ M00.XX"},
        {29.067524,   106.576068875,  4, 11, "CN-CQ Q00.XX"},
        {31.232024,   108.3130025,    4, 9,  "CN-CQ T00.XX"},
        {29.218724,   107.008168875,  4, 11, "CN-CQ X00.XX"},
        {29.7122985,  105.3728375,    3, 8,  "CN-CQ 123.XXX"},
        {32.043078,   107.501083,     3, 10, "CN-CQ 12.XXXX"},
        {30.2855945,  107.393168,     4, 9,  "CN-CQ 1234.XX"},
        {30.1825,     107.7335,       4, 9,  "CN-CQ P9TK.J71"},
        {30.3369,     120.1006175,    6, 8,  "CN-ZJ 12.XX"},
        {30.357034,   120.037467375,  5, 7,  "CN-ZJ 00.XXX"},
        {28.615074,   121.174828625,  4, 6,  "CN-ZJ J0.XXX"},
        {28.053744,   120.565115375,  4, 9,  "CN-ZJ 000.XX"},
        {29.906144,   121.491800125,  4, 6,  "CN-ZJ 200.XX"},
        {30.809944,   120.673923625,  5, 10, "CN-ZJ 400.XX"},
        {30.049244,   120.508661375,  6, 8,  "CN-ZJ 600.XX"},
        {30.909144,   119.992723625,  5, 10, "CN-ZJ 800.XX"},
        {29.142444,   119.566538875,  5, 7,  "CN-ZJ B00.XX"},
        {28.009844,   120.703392375,  4, 9,  "CN-ZJ D00.XX"},
        {29.763744,   120.136600125,  5, 7,  "CN-ZJ G00.XX"},
        {27.684545,   120.490253125,  4, 9,  "CN-ZJ J00.XX"},
        {28.770545,   121.405377625,  4, 6,  "CN-ZJ L00.XX"},
        {29.369245,   120.014638875,  5, 7,  "CN-ZJ N00.XX"},
        {28.475445,   119.826255625,  5, 7,  "CN-ZJ Q00.XX"},
        {28.989545,   118.826256875,  5, 7,  "CN-ZJ S00.XX"},
        {30.267644,   121.182261375,  4, 6,  "CN-ZJ V00.XX"},
        {30.566545,   119.916423625,  5, 7,  "CN-ZJ X00.XX"},
        {30.119734,   120.435208375,  6, 8,  "CN-ZJ Z00.XX"},
        {30.630715,   119.364393,     4, 9,  "CN-ZJ 123.XXX"},
        {27.9943405,  118.35345,      3, 12, "CN-ZJ 12.XXXX"},
        {28.507203,   118.1005465,    3, 8,  "CN-ZJ 1234.XX"},
        {29.159,      120.48,         4, 6,  "CN-ZJ T5MP.L2F"},
        {32.0661,     118.712374,     5, 10, "CN-JS 12.XX"},
        {32.011224,   118.66371175,   4, 9,  "CN-JS 00.XXX"},
        {31.249824,   120.4779875,    4, 6,  "CN-JS 80.XXX"},
        {34.204824,   117.044515875,  4, 9,  "CN-JS J0.XXX"},
        {31.455064,   120.1759275,    4, 6,  "CN-JS S0.XXX"},
        {31.822424,   119.86048775,   4, 6,  "CN-JS 000.XX"},
        {32.232045,   119.354973,     4, 7,  "CN-JS 300.XX"},
        {33.431524,   120.080936125,  5, 7,  "CN-JS 600.XX"},
        {32.533924,   119.820373,     4, 6,  "CN-JS 900.XX"},
        {33.649024,   118.938036125,  5, 8,  "CN-JS D00.XX"},
        {32.440544,   119.339738,     4, 7,  "CN-JS H00.XX"},
        {34.624044,   119.094176875,  5, 11, "CN-JS K00.XX"},
        {33.979444,   118.217384,     5, 10, "CN-JS M00.XX"},
        {32.286545,   119.095265,     4, 9,  "CN-JS P00.XX"},
        {32.047244,   120.79787675,   4, 6,  "CN-JS R00.XX"},
        {31.428244,   120.9151155,    4, 9,  "CN-JS T00.XX"},
        {31.697444,   120.66927675,   4, 6,  "CN-JS W00.XX"},
        {32.472644,   119.482038,     4, 7,  "CN-JS Y00.XX"},
        {32.041827,   118.4608315,    3, 8,  "CN-JS 123.XXX"},
        {33.9795265,  116.536309,     3, 11, "CN-JS 12.XXXX"},
        {32.949264,   117.814526,     3, 9,  "CN-JS 1234.XX"},
        {32.8945,     119.32,         3, 6,  "CN-JS SLNL.6TW"},
        {26.0792,     119.23195,      5, 7,  "CN-FJ 12.XX"},
        {26.043585,   119.151648375,  4, 6,  "CN-FJ 00.XXX"},
        {24.651045,   117.94078225,   4, 7,  "CN-FJ C0.XXX"},
        {24.463954,   117.60351925,   4, 6,  "CN-FJ P0.XXX"},
        {26.688934,   118.099810625,  4, 7,  "CN-FJ 000.XX"},
        {25.472334,   118.96102975,   4, 6,  "CN-FJ 400.XX"},
        {26.314534,   117.518190375,  4, 7,  "CN-FJ 800.XX"},
        {24.946545,   118.5048085,    4, 6,  "CN-FJ D00.XX"},
        {26.061134,   117.277090375,  4, 7,  "CN-FJ J00.XX"},
        {25.179734,   116.9200085,    4, 9,  "CN-FJ N00.XX"},
        {25.442534,   118.54692975,   5, 7,  "CN-FJ S00.XX"},
        {25.035145,   118.3235795,    4, 7,  "CN-FJ X00.XX"},
        {24.4425985,  115.9489945,    3, 8,  "CN-FJ 123.XXX"},
        {25.419035,   118.3200005,    4, 7,  "CN-FJ 12.XXXX"},
        {27.266711,   116.07723,      3, 9,  "CN-FJ 1234.XX"},
        {25.91,       118.32,         4, 7,  "CN-FJ NGXV.07C"},
        {31.8571,     117.2037755,    5, 8,  "CN-AH 12.XX"},
        {31.870355,   117.14157175,   4, 7,  "CN-AH 00.XXX"},
        {32.668244,   116.721334375,  5, 8,  "CN-AH C0.XXX"},
        {33.040084,   117.142834375,  5, 8,  "CN-AH P0.XXX"},
        {34.026545,   116.723514,     4, 9,  "CN-AH 000.XX"},
        {31.766545,   118.44576375,   4, 9,  "CN-AH 300.XX"},
        {31.441624,   118.3391625,    4, 7,  "CN-AH 600.XX"},
        {30.613724,   116.960824625,  4, 6,  "CN-AH 900.XX"},
        {30.992545,   117.748260625,  4, 7,  "CN-AH D00.XX"},
        {32.376824,   118.237573,     5, 8,  "CN-AH H00.XX"},
        {31.793145,   116.43126375,   4, 8,  "CN-AH L00.XX"},
        {33.917824,   115.693214,     4, 9,  "CN-AH P00.XX"},
        {32.963524,   115.738150875,  5, 12, "CN-AH S00.XX"},
        {30.686545,   117.417423625,  4, 7,  "CN-AH W00.XX"},
        {33.661945,   116.915684,     4, 9,  "CN-AH Y00.XX"},
        {30.4990085,  115.5653815,    3, 8,  "CN-AH 123.XXX"},
        {32.5213855,  115.533818,     4, 11, "CN-AH 12.XXXX"},
        {34.1699,     115.001124,     3, 9,  "CN-AH 1234.XX"},
        {32.029,      117.275,        3, 6,  "CN-AH P17T.FVS"},
        {41.7921,     123.34148,      5, 11, "CN-LN 12.XX"},
        {41.808984,   123.23566,      4, 10, "CN-LN 00.XXX"},
        {38.997424,   121.52440675,   4, 8,  "CN-LN C0.XXX"},
        {41.105124,   122.7585125,    4, 10, "CN-LN P0.XXX"},
        {41.909344,   123.73706,      4, 10, "CN-LN 000.XX"},
        {41.909344,   123.900139,     4, 10, "CN-LN 200.XX"},
        {41.347744,   123.6294375,    4, 10, "CN-LN 400.XX"},
        {41.347744,   123.7911575,    4, 10, "CN-LN 600.XX"},
        {42.074344,   121.5880835,    4, 8,  "CN-LN 800.XX"},
        {41.283144,   123.1128375,    4, 10, "CN-LN B00.XX"},
        {41.166744,   121.0432975,    4, 8,  "CN-LN D00.XX"},
        {40.176144,   124.283522125,  4, 8,  "CN-LN G00.XX"},
        {41.189044,   121.9812375,    4, 10, "CN-LN J00.XX"},
        {40.591045,   122.158295625,  5, 9,  "CN-LN L00.XX"},
        {41.608045,   120.34376,      4, 8,  "CN-LN N00.XX"},
        {40.788544,   120.798645625,  4, 8,  "CN-LN Q00.XX"},
        {42.338944,   123.7664835,    4, 10, "CN-LN S00.XX"},
        {39.675444,   121.889699625,  4, 8,  "CN-LN V00.XX"},
        {40.893934,   122.681576625,  4, 10, "CN-LN X00.XX"},
        {41.832634,   120.69044,      4, 8,  "CN-LN Y00.XX"},
        {41.128034,   120.6913185,    4, 8,  "CN-LN Z00.XX"},
        {40.0688505,  121.21023,      4, 8,  "CN-LN 123.XXX"},
        {42.5655795,  119.054587,     3, 9,  "CN-LN 12.XXXX"},
        {42.141518,   122.3506425,    3, 9,  "CN-LN 1234.XX"},
        {41.1005,     122.29,         3, 9,  "CN-LN 6VS0.37M"},
        {36.1952225,  117.0557195,    5, 9,  "CN-SD 12.XX"},
        {36.727365,   116.70472475,   4, 8,  "CN-SD 00.XXX"},
        {36.037895,   120.230055375,  5, 7,  "CN-SD J0.XXX"},
        {36.833744,   117.966007625,  5, 9,  "CN-SD 000.XX"},
        {37.572944,   121.2323995,    5, 9,  "CN-SD 200.XX"},
        {36.202344,   117.027622875,  4, 8,  "CN-SD 400.XX"},
        {35.439545,   116.51533,      4, 7,  "CN-SD 600.XX"},
        {36.743545,   119.05331475,   6, 10, "CN-SD 800.XX"},
        {37.463445,   118.4541325,    5, 12, "CN-SD B00.XX"},
        {35.113944,   118.240338125,  4, 10, "CN-SD D00.XX"},
        {35.275545,   115.38573,      4, 7,  "CN-SD G00.XX"},
        {35.458144,   119.40603,      5, 7,  "CN-SD J00.XX"},
        {36.486545,   115.91901475,   4, 8,  "CN-SD L00.XX"},
        {35.933744,   117.667022875,  4, 6,  "CN-SD N00.XX"},
        {35.440644,   116.857075,     4, 6,  "CN-SD Q00.XX"},
        {34.887644,   117.504038125,  4, 9,  "CN-SD S00.XX"},
        {37.000244,   120.579807625,  5, 7,  "CN-SD V00.XX"},
        {36.313934,   119.94497875,   5, 7,  "CN-SD X00.XX"},
        {37.479434,   116.2707865,    4, 12, "CN-SD Y00.XX"},
        {36.416634,   119.70520375,   5, 9,  "CN-SD Z00.XX"},
        {37.378885,   119.032252,     5, 10, "CN-SD 123.XXX"},
        {37.607228,   115.4797895,    3, 10, "CN-SD 12.XXXX"},
        {35.2979725,  114.965718,     3, 8,  "CN-SD 1234.XX"},
        {37.9979035,  118.1186695,    4, 11, "CN-SD 123.XXXX"},
        {36.39,       118.875,        4, 8,  "CN-SD RNKC.HRQ"},
        {37.8911,     112.4854075,    5, 9,  "CN-SX 12.XX"},
        {37.994914,   112.3933345,    4, 8,  "CN-SX 00.XXX"},
        {40.091874,   113.122762125,  4, 8,  "CN-SX J0.XXX"},
        {35.364224,   111.568155,     4, 9,  "CN-SX 000.XX"},
        {37.904624,   113.501044375,  4, 11, "CN-SX 300.XX"},
        {35.569624,   112.767155,     4, 7,  "CN-SX 600.XX"},
        {36.148345,   111.412732875,  4, 7,  "CN-SX 900.XX"},
        {35.128724,   110.910877125,  4, 11, "CN-SX D00.XX"},
        {38.493524,   112.656514875,  5, 9,  "CN-SX H00.XX"},
        {35.680024,   111.125955,     4, 9,  "CN-SX L00.XX"},
        {38.797524,   112.630014875,  5, 9,  "CN-SX P00.XX"},
        {34.870224,   111.098577125,  4, 11, "CN-SX S00.XX"},
        {37.104644,   111.807507625,  4, 6,  "CN-SX W00.XX"},
        {36.620244,   111.63301475,   4, 6,  "CN-SX Y00.XX"},
        {38.6530585,  110.485214,     3, 10, "CN-SX 123.XXX"},
        {36.3076895,  110.4182115,    3, 9,  "CN-SX 12.XXXX"},
        {38.306203,   110.9865355,    4, 11, "CN-SX 1234.XX"},
        {37.661,      112.3875,       3, 7,  "CN-SX D6M2.0VK"},
        {28.7186,     115.823258,     5, 7,  "CN-JX 12.XX"},
        {28.826715,   115.674815,     4, 6,  "CN-JX 12.XXX"},
        {27.713934,   113.790253125,  4, 9,  "CN-JX 000.XX"},
        {29.357924,   117.122656875,  4, 6,  "CN-JX 400.XX"},
        {29.747524,   115.933554125,  4, 12, "CN-JX 700.XX"},
        {28.515724,   117.860983625,  4, 6,  "CN-JX B00.XX"},
        {25.898545,   114.838249375,  4, 6,  "CN-JX F00.XX"},
        {27.134624,   114.879827875,  4, 6,  "CN-JX J00.XX"},
        {27.893424,   114.309413125,  4, 8,  "CN-JX M00.XX"},
        {28.289545,   116.965798375,  4, 7,  "CN-JX Q00.XX"},
        {28.034045,   116.258898375,  5, 10, "CN-JX T00.XX"},
        {27.885545,   114.845213125,  4, 6,  "CN-JX X00.XX"},
        {27.035481,   113.8766355,    3, 8,  "CN-JX 123.XXX"},
        {29.7015095,  113.697937,     3, 11, "CN-JX 12.XXXX"},
        {27.889113,   116.0477045,    4, 9,  "CN-JX 1234.XX"},
        {27.2915,     116.01,         4, 9,  "CN-JX HBVY.RG8"},
        {34.77182,    113.6202435,    5, 10, "CN-HA 12.XX"},
        {34.718975,   113.483710125,  4, 9,  "CN-HA 00.XXX"},
        {34.655824,   112.312215875,  4, 9,  "CN-HA C0.XXX"},
        {33.708024,   113.11865,      4, 6,  "CN-HA P0.XXX"},
        {32.190045,   114.013373,     4, 8,  "CN-HA 000.XX"},
        {36.140045,   114.248132875,  4, 10, "CN-HA 300.XX"},
        {35.374224,   113.782255,     4, 9,  "CN-HA 600.XX"},
        {34.843944,   114.258838125,  4, 7,  "CN-HA 900.XX"},
        {35.792044,   114.975722875,  4, 9,  "CN-HA C00.XX"},
        {35.265844,   113.14213,      4, 9,  "CN-HA F00.XX"},
        {34.067144,   113.757184,     5, 7,  "CN-HA H00.XX"},
        {33.625944,   113.952592125,  4, 6,  "CN-HA K00.XX"},
        {33.649945,   114.575392125,  5, 7,  "CN-HA M00.XX"},
        {34.790545,   111.081073125,  4, 11, "CN-HA P00.XX"},
        {33.038444,   112.476130875,  4, 9,  "CN-HA R00.XX"},
        {35.792944,   114.195422875,  4, 7,  "CN-HA T00.XX"},
        {33.029644,   113.941730875,  4, 8,  "CN-HA W00.XX"},
        {34.463244,   115.576376875,  4, 12, "CN-HA Y00.XX"},
        {36.334595,   113.645075,     3, 11, "CN-HA 012.XXX"},
        {36.334595,   114.217955,     3, 9,  "CN-HA 112.XXX"},
        {36.334595,   114.790835,     3, 9,  "CN-HA 212.XXX"},
        {36.334595,   115.363715,     3, 11, "CN-HA 312.XXX"},
        {36.334595,   115.936595,     3, 10, "CN-HA 412.XXX"},
        {35.843555,   113.129483,     3, 8,  "CN-HA 512.XXX"},
        {35.843555,   113.702363,     3, 8,  "CN-HA 612.XXX"},
        {35.843555,   114.275243,     3, 6,  "CN-HA 712.XXX"},
        {35.843555,   114.848123,     3, 8,  "CN-HA 812.XXX"},
        {35.843555,   115.421003,     3, 8,  "CN-HA 912.XXX"},
        {35.352515,   113.1172175,    3, 8,  "CN-HA B12.XXX"},
        {35.352515,   113.6848895,    3, 8,  "CN-HA C12.XXX"},
        {35.352515,   114.2525615,    3, 6,  "CN-HA D12.XXX"},
        {35.352515,   114.8202335,    3, 8,  "CN-HA F12.XXX"},
        {34.861475,   112.889862,     4, 9,  "CN-HA G12.XXX"},
        {34.861475,   113.452326,     3, 8,  "CN-HA H12.XXX"},
        {34.861475,   114.01479,      3, 6,  "CN-HA J12.XXX"},
        {34.861475,   114.577254,     3, 5,  "CN-HA K12.XXX"},
        {34.861475,   115.139718,     3, 8,  "CN-HA L12.XXX"},
        {34.861475,   115.702182,     3, 8,  "CN-HA M12.XXX"},
        {34.370435,   112.76612,      4, 6,  "CN-HA N12.XXX"},
        {34.370435,   113.328584,     3, 5,  "CN-HA P12.XXX"},
        {34.370435,   113.891048,     3, 5,  "CN-HA Q12.XXX"},
        {34.370435,   114.453512,     3, 5,  "CN-HA R12.XXX"},
        {34.370435,   115.015976,     3, 11, "CN-HA S12.XXX"},
        {34.370435,   115.57844,      4, 12, "CN-HA T12.XXX"},
        {34.370435,   116.140904,     3, 11, "CN-HA V12.XXX"},
        {33.879395,   113.9972135,    4, 6,  "CN-HA W12.XXX"},
        {33.879395,   114.5544695,    4, 6,  "CN-HA X12.XXX"},
        {33.879395,   115.1117255,    4, 9,  "CN-HA Y12.XXX"},
        {33.724004,   115.9243525,    4, 9,  "CN-HA Z12.XXX"},
        {34.1515815,  113.2875395,    4, 6,  "CN-HA 12.XXXX"},
        {32.806667,   110.4250855,    3, 9,  "CN-HA 1234.XX"},
        {33.879,      113.505,        3, 5,  "CN-HA G71Y.J90"},
        {26.5991,     106.6599,       5, 9,  "CN-GZ 12.XX"},
        {26.667056,   106.4845925,    4, 8,  "CN-GZ 12.XXX"},
        {27.758434,   106.831352125,  4, 8,  "CN-GZ 000.XX"},
        {26.306224,   105.843357375,  4, 12, "CN-GZ 400.XX"},
        {26.641145,   104.759142625,  4, 11, "CN-GZ 700.XX"},
        {26.606545,   107.884642625,  4, 8,  "CN-GZ B00.XX"},
        {26.329324,   107.426257375,  4, 10, "CN-GZ F00.XX"},
        {25.164424,   104.8336795,    4, 10, "CN-GZ J00.XX"},
        {27.777424,   109.092913125,  4, 8,  "CN-GZ M00.XX"},
        {28.195224,   106.730498375,  4, 9,  "CN-GZ Q00.XX"},
        {27.351624,   105.212327875,  5, 12, "CN-GZ T00.XX"},
        {26.921024,   104.195127875,  4, 11, "CN-GZ X00.XX"},
        {28.1551385,  105.7799845,    3, 10, "CN-GZ 12.XXXX"},
        {26.7127105,  106.078137,     4, 10, "CN-GZ 123.XXX"},
        {27.315865,   105.1403975,    4, 11, "CN-GZ 0123.XX"},
        {26.999404,   103.583385,     3, 10, "CN-GZ 1123.XX"},
        {26.999404,   104.104185,     3, 10, "CN-GZ 2123.XX"},
        {26.999404,   104.624985,     3, 10, "CN-GZ 3123.XX"},
        {26.999404,   105.145785,     3, 10, "CN-GZ 4123.XX"},
        {26.999404,   105.666585,     3, 9,  "CN-GZ 5123.XX"},
        {26.505649,   103.583385,     3, 10, "CN-GZ 6123.XX"},
        {26.505649,   104.104185,     3, 10, "CN-GZ 7123.XX"},
        {26.505649,   104.624985,     3, 10, "CN-GZ 8123.XX"},
        {26.505649,   105.145785,     3, 10, "CN-GZ 9123.XX"},
        {26.505649,   105.666585,     3, 9,  "CN-GZ B123.XX"},
        {26.017324,   104.4218445,    3, 10, "CN-GZ C123.XX"},
        {26.017324,   104.9374365,    3, 12, "CN-GZ D123.XX"},
        {26.017324,   105.4530285,    3, 11, "CN-GZ F123.XX"},
        {25.526284,   104.1640485,    3, 7,  "CN-GZ G123.XX"},
        {25.526284,   104.6796405,    3, 9,  "CN-GZ H123.XX"},
        {25.526284,   105.1952325,    3, 9,  "CN-GZ J123.XX"},
        {25.526284,   105.7108245,    3, 10, "CN-GZ K123.XX"},
        {25.032529,   104.4218445,    3, 7,  "CN-GZ L123.XX"},
        {25.032529,   104.9374365,    5, 11, "CN-GZ M123.XX"},
        {25.032529,   105.4530285,    4, 11, "CN-GZ N123.XX"},
        {24.6141,     104.524935,     3, 9,  "CN-GZ P123.XX"},
        {24.6141,     105.035319,     3, 9,  "CN-GZ Q123.XX"},
        {24.6141,     105.545703,     3, 10, "CN-GZ R123.XX"},
        {24.6141,     106.056087,     3, 10, "CN-GZ S123.XX"},
        {26.91,       106.585,        3, 7,  "CN-GZ MKF3.79S"},
        {23.1381,     113.1937435,    5, 7,  "CN-GD 12.XX"},
        {23.303115,   113.0140065,    4, 6,  "CN-GD 12.XXX"},
        {23.498345,   116.632616375,  4, 9,  "CN-GD 000.XX"},
        {23.585144,   116.294223375,  4, 9,  "CN-GD 300.XX"},
        {21.230744,   110.29567025,   4, 8,  "CN-GD 500.XX"},
        {24.821545,   113.4792475,    3, 8,  "CN-GD 700.XX"},
        {23.476744,   113.126723375,  4, 6,  "CN-GD 900.XX"},
        {22.299545,   113.4385425,    4, 6,  "CN-GD C00.XX"},
        {22.610744,   112.9953315,    4, 6,  "CN-GD F00.XX"},
        {23.084244,   113.68479275,   4, 6,  "CN-GD H00.XX"},
        {21.906545,   111.911200875,  4, 8,  "CN-GD K00.XX"},
        {23.696544,   116.542223375,  4, 9,  "CN-GD M00.XX"},
        {21.719344,   110.833900875,  4, 8,  "CN-GD P00.XX"},
        {22.570144,   113.3145315,    4, 6,  "CN-GD R00.XX"},
        {23.112444,   112.39329275,   4, 6,  "CN-GD T00.XX"},
        {23.188845,   114.37009275,   5, 7,  "CN-GD W00.XX"},
        {22.845545,   113.17759275,   4, 6,  "CN-GD Y00.XX"},
        {23.8549245,  111.978144,     3, 8,  "CN-GD 123.XXX"},
        {24.432451,   114.2108005,    3, 5,  "CN-GD 12.XXXX"},
        {22.232271,   109.705224,     3, 8,  "CN-GD 1234.XX"},
        {22.848,      113.41,         3, 5,  "CN-GD BR6G.78F"},
        {30.5935,     114.243816,     5, 7,  "CN-HB 12.XX"},
        {30.656194,   114.073271125,  4, 6,  "CN-HB 00.XXX"},
        {30.182514,   114.901252125,  4, 7,  "CN-HB J0.XXX"},
        {30.790545,   111.265760625,  4, 6,  "CN-HB 000.XX"},
        {32.109944,   112.097038,     4, 7,  "CN-HB 200.XX"},
        {30.385244,   112.153259375,  4, 6,  "CN-HB 400.XX"},
        {32.664245,   110.722130875,  4, 11, "CN-HB 600.XX"},
        {31.746044,   113.30737675,   4, 9,  "CN-HB 800.XX"},
        {30.989144,   113.499623625,  4, 6,  "CN-HB B00.XX"},
        {32.422644,   111.585038,     4, 9,  "CN-HB D00.XX"},
        {30.414544,   113.378661375,  4, 6,  "CN-HB G00.XX"},
        {30.706244,   113.090623625,  4, 6,  "CN-HB J00.XX"},
        {29.886545,   115.470800125,  4, 10, "CN-HB L00.XX"},
        {30.469845,   114.840259375,  4, 6,  "CN-HB N00.XX"},
        {32.175444,   112.676938,     4, 7,  "CN-HB Q00.XX"},
        {29.886534,   114.263547125,  4, 10, "CN-HB S00.XX"},
        {31.059834,   112.1405105,    4, 6,  "CN-HB T00.XX"},
        {29.851934,   113.429058125,  4, 9,  "CN-HB V00.XX"},
        {30.952434,   113.873368625,  4, 6,  "CN-HB W00.XX"},
        {30.324134,   111.448108375,  4, 6,  "CN-HB X00.XX"},
        {30.446834,   112.841708375,  4, 6,  "CN-HB Y00.XX"},
        {31.648234,   113.95437175,   4, 9,  "CN-HB Z00.XX"},
        {29.132792,   113.3276285,    3, 8,  "CN-HB 123.XXX"},
        {30.293792,   110.7523395,    3, 5,  "CN-HB 12.XXXX"},
        {31.986206,   108.4515275,    3, 13, "CN-HB 1234.XX"},
        {31.16,       112.26,         3, 5,  "CN-HB D3PT.WV7"},
        {43.882,      125.215296,     5, 11, "CN-JL 12.XX"},
        {43.939094,   125.026602,     4, 10, "CN-JL 00.XXX"},
        {43.860214,   126.355428,     4, 8,  "CN-JL J0.XXX"},
        {43.157494,   124.2744255,    4, 11, "CN-JL 000.XX"},
        {42.901494,   125.036257,     4, 11, "CN-JL 300.XX"},
        {41.736994,   125.86992,      4, 8,  "CN-JL 600.XX"},
        {42.910794,   129.405757,     4, 6,  "CN-JL 900.XX"},
        {45.612194,   122.71678375,   4, 10, "CN-JL D00.XX"},
        {41.918294,   126.31292,      4, 6,  "CN-JL H00.XX"},
        {45.141494,   124.693023125,  4, 11, "CN-JL L00.XX"},
        {44.135014,   125.763755625,  4, 10, "CN-JL P00.XX"},
        {43.339614,   128.1510835,    4, 6,  "CN-JL R00.XX"},
        {43.483014,   124.7454835,    4, 13, "CN-JL T00.XX"},
        {42.959414,   126.663062,     4, 6,  "CN-JL W00.XX"},
        {44.515014,   125.614355625,  4, 10, "CN-JL Y00.XX"},
        {41.726315,   124.23422,      3, 10, "CN-JL 123.XXX"},
        {45.3095705,  121.833085,     3, 9,  "CN-JL 12.XXXX"},
        {42.585005,   127.729526,     3, 5,  "CN-JL 1234.XX"},
        {43.57,       126.5,          3, 7,  "CN-JL GNYV.SKJ"},
        {38.022513,   114.4387235,    5, 10, "CN-HE 12.XX"},
        {38.011834,   114.323546375,  4, 9,  "CN-HE 00.XXX"},
        {36.540124,   114.32072475,   4, 7,  "CN-HE C0.XXX"},
        {38.849024,   115.288440875,  4, 8,  "CN-HE P0.XXX"},
        {39.714545,   118.106770625,  3, 7,  "CN-HE 000.XX"},
        {39.771424,   118.347670625,  3, 7,  "CN-HE 300.XX"},
        {39.608545,   116.636290625,  4, 11, "CN-HE 600.XX"},
        {39.987723,   119.471441125,  3, 10, "CN-HE 900.XX"},
        {40.840223,   114.732110625,  4, 8,  "CN-HE D00.XX"},
        {37.121545,   114.426188625,  4, 7,  "CN-HE H00.XX"},
        {38.340545,   116.743344375,  4, 9,  "CN-HE L00.XX"},
        {37.496688,   116.2392825,    4, 11, "CN-HE P00.XX"},
        {37.761545,   115.6064995,    4, 11, "CN-HE R00.XX"},
        {40.638045,   114.983795625,  4, 8,  "CN-HE T00.XX"},
        {38.558588,   114.917314875,  4, 8,  "CN-HE W00.XX"},
        {37.968288,   115.145390375,  4, 9,  "CN-HE Y00.XX"},
        {36.8960385,  113.4631535,    3, 9,  "CN-HE 123.XXX"},
        {39.1992045,  116.091756,     3, 7,  "CN-HE 12.XXXX"},
        {40.210857,   113.9356325,    3, 10, "CN-HE 1234.XX"},
        {39.354,      116.6665,       3, 7,  "CN-HE MW1T.0D1"},
        {34.2621,     108.802532,     5, 7,  "CN-SN 12.XX"},
        {34.427115,   108.59771,      4, 8,  "CN-SN 12.XXX"},
        {34.375145,   107.043271875,  4, 8,  "CN-SN 000.XX"},
        {34.955524,   108.869877125,  4, 6,  "CN-SN 300.XX"},
        {34.568545,   109.373791875,  4, 6,  "CN-SN 600.XX"},
        {33.118824,   106.904650875,  4, 10, "CN-SN 900.XX"},
        {34.550545,   108.798991875,  4, 6,  "CN-SN D00.XX"},
        {34.453024,   109.118291875,  5, 7,  "CN-SN H00.XX"},
        {32.727545,   108.941850875,  4, 8,  "CN-SN L00.XX"},
        {38.374624,   109.676644375,  4, 8,  "CN-SN P00.XX"},
        {34.765345,   109.140273125,  4, 6,  "CN-SN S00.XX"},
        {34.671644,   108.871776875,  4, 6,  "CN-SN W00.XX"},
        {35.516944,   110.37113,      4, 10, "CN-SN Y00.XX"},
        {35.828835,   107.042409,     3, 8,  "CN-SN 123.XXX"},
        {36.674737,   108.8014085,    3, 5,  "CN-SN 12.XXXX"},
        {33.421245,   105.659841,     3, 9,  "CN-SN 1234.XX"},
        {35.65,       108.374,        3, 7,  "CN-SN 52X5.D9J"},
        {40.5835535,  109.9439525,    5, 7,  "CN-NM 12.XX"},
        {40.576965,   109.728392625,  4, 6,  "CN-NM 00.XXX"},
        {40.770155,   111.400064625,  4, 6,  "CN-NM J0.XXX"},
        {42.322845,   118.8203025,    4, 9,  "CN-NM 000.XX"},
        {43.704724,   122.132342,     4, 10, "CN-NM 300.XX"},
        {41.077645,   113.0327895,    4, 6,  "CN-NM 600.XX"},
        {49.259045,   119.66647325,   4, 12, "CN-NM 900.XX"},
        {39.803545,   106.740290625,  4, 8,  "CN-NM D00.XX"},
        {46.111945,   121.928321875,  4, 11, "CN-NM H00.XX"},
        {40.802844,   107.325795625,  4, 8,  "CN-NM K00.XX"},
        {48.041844,   122.653151375,  4, 8,  "CN-NM M00.XX"},
        {39.845345,   109.916499625,  4, 6,  "CN-NM P00.XX"},
        {44.001744,   115.986152,     4, 6,  "CN-NM R00.XX"},
        {49.317045,   120.61989025,   4, 12, "CN-NM T00.XX"},
        {49.499545,   117.640345,     4, 12, "CN-NM W00.XX"},
        {50.464545,   124.0195435,    4, 11, "CN-NM Y00.XX"},
        {41.4951545,  109.15267,      3, 5,  "CN-NM 123.XXX"},
        {41.286785,   105.8097745,    3, 7,  "CN-NM 12.XXXX"},
        {42.040175,   118.6351175,    3, 7,  "CN-NM 0123.XX"},
        {43.409164,   121.9236165,    3, 10, "CN-NM 1123.XX"},
        {40.789624,   112.838596,     3, 5,  "CN-NM 2123.XX"},
        {48.96133,    119.422397,     3, 5,  "CN-NM 3123.XX"},
        {45.84028,    121.697861,     3, 10, "CN-NM 4123.XX"},
        {47.762724,   122.4063615,    3, 7,  "CN-NM 5123.XX"},
        {43.719909,   115.750733,     3, 5,  "CN-NM 6123.XX"},
        {49.04983,    120.384347,     3, 6,  "CN-NM 7123.XX"},
        {49.20658,    117.366117,     3, 11, "CN-NM 8123.XX"},
        {50.191575,   123.7728585,    3, 10, "CN-NM 9123.XX"},
        {42.8709975,  97.7004975,     1, 4,  "CN-NM 123.XXXX"},
        {51.2329195,  115.8280265,    1, 15, "CN-NM 1234.XXX"},
        {45.7746,     126.603512,     5, 10, "CN-HL 12.XX"},
        {45.792525,   126.47082875,   4, 9,  "CN-HL 00.XXX"},
        {47.283925,   123.733853125,  4, 8,  "CN-HL C0.XXX"},
        {47.296065,   130.16936125,   4, 7,  "CN-HL P0.XXX"},
        {44.628444,   129.511106125,  4, 8,  "CN-HL 000.XX"},
        {46.831245,   130.232144125,  4, 7,  "CN-HL 200.XX"},
        {45.815045,   130.865321875,  4, 11, "CN-HL 400.XX"},
        {45.313845,   130.85238275,   4, 12, "CN-HL 600.XX"},
        {47.259845,   123.538328125,  4, 8,  "CN-HL 800.XX"},
        {46.674044,   126.89269,      4, 6,  "CN-HL B00.XX"},
        {46.693545,   124.757325,     4, 8,  "CN-HL D00.XX"},
        {46.570545,   124.789525,     4, 8,  "CN-HL G00.XX"},
        {46.736745,   131.092025,     4, 11, "CN-HL J00.XX"},
        {46.462045,   125.16759,      4, 8,  "CN-HL L00.XX"},
        {46.616545,   125.028325,     4, 8,  "CN-HL N00.XX"},
        {47.749545,   128.62239825,   4, 6,  "CN-HL Q00.XX"},
        {46.117944,   125.882321875,  4, 11, "CN-HL S00.XX"},
        {48.290545,   126.450334375,  3, 5,  "CN-HL V00.XX"},
        {45.567634,   126.92015575,   4, 8,  "CN-HL X00.XX"},
        {50.250545,   127.42071975,   3, 10, "CN-HL Y00.XX"},
        {45.403845,   126.25705575,   4, 9,  "CN-HL Z00.XX"},
        {47.6516835,  123.5828105,    3, 7,  "CN-HL 123.XXX"},
        {48.508225,   128.499636,     3, 5,  "CN-HL 12.XXXX"},
        {45.893995,   128.4843965,    3, 7,  "CN-HL 1234.XX"},
        {48.48,       127.96,         2, 4,  "CN-HL KBRN.9WP"},
        {28.208747,   112.959329,     5, 7,  "CN-HN 12.XX"},
        {28.26607,    112.855657375,  4, 6,  "CN-HN 00.XXX"},
        {27.918047,   112.849738625,  4, 6,  "CN-HN C0.XXX"},
        {26.929699,   112.537987625,  4, 6,  "CN-HN P0.XXX"},
        {29.446173,   113.063992875,  4, 8,  "CN-HN 000.XX"},
        {27.323397,   111.375127875,  4, 6,  "CN-HN 300.XX"},
        {29.064846,   111.590000875,  4, 8,  "CN-HN 600.XX"},
        {28.609649,   112.225940625,  4, 6,  "CN-HN 900.XX"},
        {25.840516,   112.961675375,  4, 6,  "CN-HN D00.XX"},
        {27.795258,   111.923127125,  4, 6,  "CN-HN H00.XX"},
        {26.470924,   112.767442625,  4, 6,  "CN-HN L00.XX"},
        {27.614824,   109.894713125,  4, 6,  "CN-HN P00.XX"},
        {28.357028,   109.641169375,  4, 7,  "CN-HN S00.XX"},
        {26.48969,    111.543066625,  4, 6,  "CN-HN W00.XX"},
        {29.16239,    110.398091875,  4, 9,  "CN-HN Y00.XX"},
        {29.9188505,  111.410337,     3, 7,  "CN-HN 123.XXX"},
        {27.045607,   111.508076,     3, 5,  "CN-HN 12.XXXX"},
        {25.99463,    109.250434,     3, 10, "CN-HN 1234.XX"},
        {27.3935,     111.5305,       3, 5,  "CN-HN 6B3N.M4Y"},
        {22.8389,     108.2682435,    5, 8,  "CN-GX 12.XX"},
        {22.735274,   108.14026775,   4, 7,  "CN-GX 00.XXX"},
        {24.239415,   109.27791925,   4, 6,  "CN-GX C0.XXX"},
        {25.293524,   110.1121625,    4, 10, "CN-GX P0.XXX"},
        {23.534724,   111.196516375,  4, 8,  "CN-GX 000.XX"},
        {21.535124,   109.04035325,   4, 7,  "CN-GX 300.XX"},
        {22.661076,   110.03140975,   4, 9,  "CN-GX 600.XX"},
        {24.740236,   107.9772795,    4, 7,  "CN-GX 900.XX"},
        {22.063524,   108.542245875,  4, 7,  "CN-GX D00.XX"},
        {23.923934,   106.560001625,  4, 6,  "CN-GX H00.XX"},
        {23.158224,   109.52992375,   4, 6,  "CN-GX L00.XX"},
        {23.280563,   108.749357375,  4, 7,  "CN-GX P00.XX"},
        {23.406544,   109.979223375,  5, 10, "CN-GX R00.XX"},
        {21.723844,   109.127800875,  4, 7,  "CN-GX T00.XX"},
        {24.526444,   109.67121625,   4, 8,  "CN-GX W00.XX"},
        {24.464044,   111.47771625,   4, 8,  "CN-GX Y00.XX"},
        {23.043759,   107.368144,     3, 6,  "CN-GX 123.XXX"},
        {25.274773,   109.2200165,    3, 10, "CN-GX 12.XXXX"},
        {25.379425,   105.4521535,    3, 10, "CN-GX 1234.XX"},
        {23.6405,     108.283,        3, 5,  "CN-GX QSZN.22J"},
        {30.6959,     104.018216,     5, 7,  "CN-SC 12.XX"},
        {30.843215,   103.8142015,    4, 6,  "CN-SC 12.XXX"},
        {29.416624,   104.667691875,  4, 6,  "CN-SC 000.XX"},
        {31.506419,   104.5789485,    4, 6,  "CN-SC 300.XX"},
        {29.651624,   104.968154125,  4, 6,  "CN-SC 600.XX"},
        {26.597545,   101.574842625,  3, 7,  "CN-SC 900.XX"},
        {28.822424,   104.511783625,  4, 9,  "CN-SC D00.XX"},
        {32.463545,   105.693265,     4, 9,  "CN-SC H00.XX"},
        {30.853124,   106.009024625,  4, 7,  "CN-SC L00.XX"},
        {31.176624,   104.3022025,    4, 6,  "CN-SC P00.XX"},
        {29.645324,   103.625954125,  4, 6,  "CN-SC S00.XX"},
        {28.934244,   105.363477625,  4, 13, "CN-SC W00.XX"},
        {27.971545,   102.183254375,  4, 8,  "CN-SC Y00.XX"},
        {32.5830965,  102.548223,     3, 9,  "CN-SC 123.XXX"},
        {29.261563,   102.2534125,    3, 5,  "CN-SC 12.XXXX"},
        {32.441687,   105.6112595,    3, 8,  "CN-SC 1234.XX"},
        {33.394834,   97.835114,      2, 10, "CN-SC 1234.XXX"},
        {25.0797,     102.6624015,    5, 7,  "CN-YN 12.XX"},
        {24.781674,   102.5728715,    4, 6,  "CN-YN 00.XXX"},
        {27.430374,   103.550109875,  4, 8,  "CN-YN J0.XXX"},
        {23.784234,   103.162027625,  4, 6,  "CN-YN 000.XX"},
        {25.616545,   103.71936475,   4, 7,  "CN-YN 400.XX"},
        {25.679545,   100.14256475,   3, 6,  "CN-YN 700.XX"},
        {23.431124,   103.077816375,  4, 6,  "CN-YN B00.XX"},
        {24.744545,   102.54824625,   4, 6,  "CN-YN F00.XX"},
        {24.956545,   102.3512475,    4, 6,  "CN-YN J00.XX"},
        {24.417424,   102.45959425,   4, 6,  "CN-YN M00.XX"},
        {25.104324,   101.4626795,    4, 6,  "CN-YN Q00.XX"},
        {22.826545,   100.85624375,   4, 7,  "CN-YN T00.XX"},
        {22.047024,   100.724345875,  4, 8,  "CN-YN X00.XX"},
        {25.7104585,  101.283945,     3, 5,  "CN-YN 123.XXX"},
        {25.761559,   102.735757,     3, 5,  "CN-YN 12.XXXX"},
        {21.977987,   99.291632,      3, 6,  "CN-YN 1234.XX"},
        {25.194,      101.86,         3, 5,  "CN-YN 9PJ2.4JK"},
        {29.6496715,  91.0375925,     5, 7,  "CN-XZ 12.XX"},
        {29.606415,   90.910671125,   4, 6,  "CN-XZ 00.XXX"},
        {29.356101,   88.697822875,   4, 6,  "CN-XZ J0.XXX"},
        {29.189894,   91.684863375,   4, 11, "CN-XZ 000.XX"},
        {31.135594,   97.0587925,     3, 5,  "CN-XZ 300.XX"},
        {31.453294,   91.9533925,     3, 5,  "CN-XZ 600.XX"},
        {29.678594,   94.237947625,   4, 6,  "CN-XZ 900.XX"},
        {28.436636,   92.216618625,   4, 12, "CN-XZ D00.XX"},
        {29.295119,   90.863198875,   4, 6,  "CN-XZ H00.XX"},
        {32.499594,   80.018661,      3, 5,  "CN-XZ L00.XX"},
        {29.818194,   91.632247625,   4, 6,  "CN-XZ P00.XX"},
        {29.681794,   98.499947625,   3, 7,  "CN-XZ S00.XX"},
        {29.495314,   94.439893625,   4, 6,  "CN-XZ W00.XX"},
        {32.278614,   84.029626,      3, 5,  "CN-XZ Y00.XX"},
        {30.7917995,  90.136891,      3, 5,  "CN-XZ 123.XXX"},
        {30.58343,    87.2009445,     3, 5,  "CN-XZ 12.XXXX"},
        {30.65039,    93.1404515,     3, 5,  "CN-XZ 1234.XX"},
        {28.9178365,  79.097186,      2, 12, "CN-XZ 1234.XXX"},
        {36.052003,   103.791297,     5, 7,  "CN-GS 12.XX"},
        {36.15564,    103.3391675,    4, 6,  "CN-GS 12.XXX"},
        {39.014434,   100.35189375,   4, 10, "CN-GS 000.XX"},
        {35.659934,   103.104465,     4, 8,  "CN-GS 400.XX"},
        {36.618634,   104.07292775,   4, 6,  "CN-GS 800.XX"},
        {34.602519,   105.613271875,  3, 7,  "CN-GS D00.XX"},
        {38.582424,   102.128714875,  4, 10, "CN-GS J00.XX"},
        {39.870124,   98.194270625,   4, 8,  "CN-GS M00.XX"},
        {35.570945,   106.570275,     3, 10, "CN-GS Q00.XX"},
        {37.992424,   102.521444375,  4, 10, "CN-GS T00.XX"},
        {39.803724,   98.387290625,   5, 9,  "CN-GS X00.XX"},
        {37.3653835,  102.444397,     3, 8,  "CN-GS 123.XXX"},
        {39.85452,    99.8738255,     3, 7,  "CN-GS 12.XXXX"},
        {41.262075,   96.391159,      3, 7,  "CN-GS 1234.XX"},
        {37.68,       100.745,        3, 10, "CN-GS L4RN.SCT"},
        {36.646533,   101.7004845,    5, 9,  "CN-QH 12.XX"},
        {36.798515,   101.4951615,    4, 8,  "CN-QH 12.XXX"},
        {36.521545,   102.04027875,   5, 9,  "CN-QH 000.XX"},
        {37.003734,   101.569308625,  4, 8,  "CN-QH 400.XX"},
        {37.930234,   95.240171375,   4, 9,  "CN-QH 800.XX"},
        {36.467545,   94.76357875,    4, 11, "CN-QH D00.XX"},
        {37.434424,   101.5057825,    4, 11, "CN-QH J00.XX"},
        {36.346924,   100.48131075,   4, 8,  "CN-QH M00.XX"},
        {37.339545,   100.0438665,    4, 8,  "CN-QH Q00.XX"},
        {36.350145,   102.69527875,   4, 9,  "CN-QH T00.XX"},
        {34.507624,   100.195891875,  4, 8,  "CN-QH X00.XX"},
        {37.8102775,  99.9215975,     3, 10, "CN-QH 123.XXX"},
        {34.937034,   98.841338,      3, 9,  "CN-QH 12.XXXX"},
        {38.580778,   93.023417,      3, 9,  "CN-QH 1234.XX"},
        {33.2253305,  90.0116545,     2, 6,  "CN-QH 1234.XXX"},
        {43.8443,     87.558096,      5, 7,  "CN-XJ 12.XX"},
        {43.950534,   87.323878,      5, 7,  "CN-XJ 00.XXX"},
        {44.387574,   85.938887125,   4, 6,  "CN-XJ J0.XXX"},
        {44.061424,   87.190142,      4, 6,  "CN-XJ 000.XX"},
        {41.213424,   80.1798895,     4, 7,  "CN-XJ 300.XX"},
        {39.549924,   75.903570625,   4, 7,  "CN-XJ 600.XX"},
        {43.972024,   81.242642,      4, 6,  "CN-XJ 900.XX"},
        {41.805224,   86.08756,       4, 6,  "CN-XJ D00.XX"},
        {45.636644,   84.80698275,    4, 8,  "CN-XJ H00.XX"},
        {44.439444,   84.804706125,   4, 6,  "CN-XJ K00.XX"},
        {47.885444,   88.031051375,   4, 8,  "CN-XJ M00.XX"},
        {42.874444,   93.418806,      4, 6,  "CN-XJ P00.XX"},
        {37.160244,   79.860907625,   4, 6,  "CN-XJ R00.XX"},
        {45.706544,   85.00928275,    4, 8,  "CN-XJ T00.XX"},
        {38.464544,   77.170914875,   5, 7,  "CN-XJ W00.XX"},
        {41.760144,   82.89486,       4, 6,  "CN-XJ Y00.XX"},
        {46.1175215,  84.492761,      3, 7,  "CN-XJ 123.XXX"},
        {45.925468,   80.9180285,     2, 5,  "CN-XJ 12.XXXX"},
        {40.917864,   79.9773185,     3, 6,  "CN-XJ 0123.XX"},
        {0,           0,              0, 0, NULL}
};
