# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.6.6, generator: @autorest/python@5.6.4)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AcrAccessToken(msrest.serialization.Model):
    """AcrAccessToken.

    :param access_token: The access token for performing authenticated requests.
    :type access_token: str
    """

    _attribute_map = {
        'access_token': {'key': 'access_token', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AcrAccessToken, self).__init__(**kwargs)
        self.access_token = kwargs.get('access_token', None)


class AcrErrorInfo(msrest.serialization.Model):
    """Error information.

    :param code: Error code.
    :type code: str
    :param message: Error message.
    :type message: str
    :param detail: Error details.
    :type detail: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'detail': {'key': 'detail', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AcrErrorInfo, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.detail = kwargs.get('detail', None)


class AcrErrors(msrest.serialization.Model):
    """Acr error response describing why the operation failed.

    :param errors: Array of detailed error.
    :type errors: list[~container_registry.models.AcrErrorInfo]
    """

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[AcrErrorInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AcrErrors, self).__init__(**kwargs)
        self.errors = kwargs.get('errors', None)


class AcrManifests(msrest.serialization.Model):
    """Manifest attributes.

    :param registry_login_server: Registry login server.
    :type registry_login_server: str
    :param repository: Image name.
    :type repository: str
    :param manifests: List of manifests.
    :type manifests: list[~container_registry.models.ManifestAttributesBase]
    :param link:
    :type link: str
    """

    _attribute_map = {
        'registry_login_server': {'key': 'registry', 'type': 'str'},
        'repository': {'key': 'imageName', 'type': 'str'},
        'manifests': {'key': 'manifests', 'type': '[ManifestAttributesBase]'},
        'link': {'key': 'link', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AcrManifests, self).__init__(**kwargs)
        self.registry_login_server = kwargs.get('registry_login_server', None)
        self.repository = kwargs.get('repository', None)
        self.manifests = kwargs.get('manifests', None)
        self.link = kwargs.get('link', None)


class AcrRefreshToken(msrest.serialization.Model):
    """AcrRefreshToken.

    :param refresh_token: The refresh token to be used for generating access tokens.
    :type refresh_token: str
    """

    _attribute_map = {
        'refresh_token': {'key': 'refresh_token', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AcrRefreshToken, self).__init__(**kwargs)
        self.refresh_token = kwargs.get('refresh_token', None)


class Annotations(msrest.serialization.Model):
    """Additional information provided through arbitrary metadata.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, str]
    :param created: Date and time on which the image was built (string, date-time as defined by
     https://tools.ietf.org/html/rfc3339#section-5.6).
    :type created: ~datetime.datetime
    :param authors: Contact details of the people or organization responsible for the image.
    :type authors: str
    :param url: URL to find more information on the image.
    :type url: str
    :param documentation: URL to get documentation on the image.
    :type documentation: str
    :param source: URL to get source code for building the image.
    :type source: str
    :param version: Version of the packaged software. The version MAY match a label or tag in the
     source code repository, may also be Semantic versioning-compatible.
    :type version: str
    :param revision: Source control revision identifier for the packaged software.
    :type revision: str
    :param vendor: Name of the distributing entity, organization or individual.
    :type vendor: str
    :param licenses: License(s) under which contained software is distributed as an SPDX License
     Expression.
    :type licenses: str
    :param name: Name of the reference for a target.
    :type name: str
    :param title: Human-readable title of the image.
    :type title: str
    :param description: Human-readable description of the software packaged in the image.
    :type description: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{str}'},
        'created': {'key': 'org\\.opencontainers\\.image\\.created', 'type': 'iso-8601'},
        'authors': {'key': 'org\\.opencontainers\\.image\\.authors', 'type': 'str'},
        'url': {'key': 'org\\.opencontainers\\.image\\.url', 'type': 'str'},
        'documentation': {'key': 'org\\.opencontainers\\.image\\.documentation', 'type': 'str'},
        'source': {'key': 'org\\.opencontainers\\.image\\.source', 'type': 'str'},
        'version': {'key': 'org\\.opencontainers\\.image\\.version', 'type': 'str'},
        'revision': {'key': 'org\\.opencontainers\\.image\\.revision', 'type': 'str'},
        'vendor': {'key': 'org\\.opencontainers\\.image\\.vendor', 'type': 'str'},
        'licenses': {'key': 'org\\.opencontainers\\.image\\.licenses', 'type': 'str'},
        'name': {'key': 'org\\.opencontainers\\.image\\.ref\\.name', 'type': 'str'},
        'title': {'key': 'org\\.opencontainers\\.image\\.title', 'type': 'str'},
        'description': {'key': 'org\\.opencontainers\\.image\\.description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Annotations, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.created = kwargs.get('created', None)
        self.authors = kwargs.get('authors', None)
        self.url = kwargs.get('url', None)
        self.documentation = kwargs.get('documentation', None)
        self.source = kwargs.get('source', None)
        self.version = kwargs.get('version', None)
        self.revision = kwargs.get('revision', None)
        self.vendor = kwargs.get('vendor', None)
        self.licenses = kwargs.get('licenses', None)
        self.name = kwargs.get('name', None)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)


class ArtifactManifestPlatform(msrest.serialization.Model):
    """Manifest attributes details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar digest: Required. Manifest digest.
    :vartype digest: str
    :ivar architecture: CPU architecture. Possible values include: "386", "amd64", "arm", "arm64",
     "mips", "mipsle", "mips64", "mips64le", "ppc64", "ppc64le", "riscv64", "s390x", "wasm".
    :vartype architecture: str or ~container_registry.models.ArtifactArchitecture
    :ivar operating_system: Operating system. Possible values include: "aix", "android", "darwin",
     "dragonfly", "freebsd", "illumos", "ios", "js", "linux", "netbsd", "openbsd", "plan9",
     "solaris", "windows".
    :vartype operating_system: str or ~container_registry.models.ArtifactOperatingSystem
    """

    _validation = {
        'digest': {'required': True, 'readonly': True},
        'architecture': {'readonly': True},
        'operating_system': {'readonly': True},
    }

    _attribute_map = {
        'digest': {'key': 'digest', 'type': 'str'},
        'architecture': {'key': 'architecture', 'type': 'str'},
        'operating_system': {'key': 'os', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArtifactManifestPlatform, self).__init__(**kwargs)
        self.digest = None
        self.architecture = None
        self.operating_system = None


class ArtifactManifestProperties(msrest.serialization.Model):
    """Manifest attributes details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar registry_login_server: Registry login server.
    :vartype registry_login_server: str
    :ivar repository_name: Repository name.
    :vartype repository_name: str
    :ivar digest: Required. Manifest.
    :vartype digest: str
    :ivar size: Image size.
    :vartype size: long
    :ivar created_on: Required. Created time.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: Required. Last update time.
    :vartype last_updated_on: ~datetime.datetime
    :ivar architecture: CPU architecture. Possible values include: "386", "amd64", "arm", "arm64",
     "mips", "mipsle", "mips64", "mips64le", "ppc64", "ppc64le", "riscv64", "s390x", "wasm".
    :vartype architecture: str or ~container_registry.models.ArtifactArchitecture
    :ivar operating_system: Operating system. Possible values include: "aix", "android", "darwin",
     "dragonfly", "freebsd", "illumos", "ios", "js", "linux", "netbsd", "openbsd", "plan9",
     "solaris", "windows".
    :vartype operating_system: str or ~container_registry.models.ArtifactOperatingSystem
    :ivar related_artifacts: List of artifacts that are referenced by this manifest list, with
     information about the platform each supports.  This list will be empty if this is a leaf
     manifest and not a manifest list.
    :vartype related_artifacts: list[~container_registry.models.ArtifactManifestPlatform]
    :ivar tags: A set of tags. List of tags.
    :vartype tags: list[str]
    :param can_delete: Delete enabled.
    :type can_delete: bool
    :param can_write: Write enabled.
    :type can_write: bool
    :param can_list: List enabled.
    :type can_list: bool
    :param can_read: Read enabled.
    :type can_read: bool
    :param quarantine_state: Quarantine state.
    :type quarantine_state: str
    :param quarantine_details: Quarantine details.
    :type quarantine_details: str
    """

    _validation = {
        'registry_login_server': {'readonly': True},
        'repository_name': {'readonly': True},
        'digest': {'required': True, 'readonly': True},
        'size': {'readonly': True},
        'created_on': {'required': True, 'readonly': True},
        'last_updated_on': {'required': True, 'readonly': True},
        'architecture': {'readonly': True},
        'operating_system': {'readonly': True},
        'related_artifacts': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'registry_login_server': {'key': 'registry', 'type': 'str'},
        'repository_name': {'key': 'imageName', 'type': 'str'},
        'digest': {'key': 'manifest.digest', 'type': 'str'},
        'size': {'key': 'manifest.imageSize', 'type': 'long'},
        'created_on': {'key': 'manifest.createdTime', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'manifest.lastUpdateTime', 'type': 'iso-8601'},
        'architecture': {'key': 'manifest.architecture', 'type': 'str'},
        'operating_system': {'key': 'manifest.os', 'type': 'str'},
        'related_artifacts': {'key': 'manifest.references', 'type': '[ArtifactManifestPlatform]'},
        'tags': {'key': 'manifest.tags', 'type': '[str]'},
        'can_delete': {'key': 'manifest.changeableAttributes.deleteEnabled', 'type': 'bool'},
        'can_write': {'key': 'manifest.changeableAttributes.writeEnabled', 'type': 'bool'},
        'can_list': {'key': 'manifest.changeableAttributes.listEnabled', 'type': 'bool'},
        'can_read': {'key': 'manifest.changeableAttributes.readEnabled', 'type': 'bool'},
        'quarantine_state': {'key': 'manifest.changeableAttributes.quarantineState', 'type': 'str'},
        'quarantine_details': {'key': 'manifest.changeableAttributes.quarantineDetails', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArtifactManifestProperties, self).__init__(**kwargs)
        self.registry_login_server = None
        self.repository_name = None
        self.digest = None
        self.size = None
        self.created_on = None
        self.last_updated_on = None
        self.architecture = None
        self.operating_system = None
        self.related_artifacts = None
        self.tags = None
        self.can_delete = kwargs.get('can_delete', None)
        self.can_write = kwargs.get('can_write', None)
        self.can_list = kwargs.get('can_list', None)
        self.can_read = kwargs.get('can_read', None)
        self.quarantine_state = kwargs.get('quarantine_state', None)
        self.quarantine_details = kwargs.get('quarantine_details', None)


class ArtifactTagProperties(msrest.serialization.Model):
    """Tag attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar registry_login_server: Required. Registry login server.
    :vartype registry_login_server: str
    :ivar repository_name: Required. Image name.
    :vartype repository_name: str
    :ivar name: Required. Tag name.
    :vartype name: str
    :ivar digest: Required. Tag digest.
    :vartype digest: str
    :ivar created_on: Required. Tag created time.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: Required. Tag last update time.
    :vartype last_updated_on: ~datetime.datetime
    :param can_delete: Delete enabled.
    :type can_delete: bool
    :param can_write: Write enabled.
    :type can_write: bool
    :param can_list: List enabled.
    :type can_list: bool
    :param can_read: Read enabled.
    :type can_read: bool
    """

    _validation = {
        'registry_login_server': {'required': True, 'readonly': True},
        'repository_name': {'required': True, 'readonly': True},
        'name': {'required': True, 'readonly': True},
        'digest': {'required': True, 'readonly': True},
        'created_on': {'required': True, 'readonly': True},
        'last_updated_on': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'registry_login_server': {'key': 'registry', 'type': 'str'},
        'repository_name': {'key': 'imageName', 'type': 'str'},
        'name': {'key': 'tag.name', 'type': 'str'},
        'digest': {'key': 'tag.digest', 'type': 'str'},
        'created_on': {'key': 'tag.createdTime', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'tag.lastUpdateTime', 'type': 'iso-8601'},
        'can_delete': {'key': 'tag.changeableAttributes.deleteEnabled', 'type': 'bool'},
        'can_write': {'key': 'tag.changeableAttributes.writeEnabled', 'type': 'bool'},
        'can_list': {'key': 'tag.changeableAttributes.listEnabled', 'type': 'bool'},
        'can_read': {'key': 'tag.changeableAttributes.readEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArtifactTagProperties, self).__init__(**kwargs)
        self.registry_login_server = None
        self.repository_name = None
        self.name = None
        self.digest = None
        self.created_on = None
        self.last_updated_on = None
        self.can_delete = kwargs.get('can_delete', None)
        self.can_write = kwargs.get('can_write', None)
        self.can_list = kwargs.get('can_list', None)
        self.can_read = kwargs.get('can_read', None)


class ContainerRepositoryProperties(msrest.serialization.Model):
    """Properties of this repository.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar registry_login_server: Required. Registry login server.
    :vartype registry_login_server: str
    :ivar name: Required. Image name.
    :vartype name: str
    :ivar created_on: Required. Image created time.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: Required. Image last update time.
    :vartype last_updated_on: ~datetime.datetime
    :ivar manifest_count: Required. Number of the manifests.
    :vartype manifest_count: int
    :ivar tag_count: Required. Number of the tags.
    :vartype tag_count: int
    :param can_delete: Delete enabled.
    :type can_delete: bool
    :param can_write: Write enabled.
    :type can_write: bool
    :param can_list: List enabled.
    :type can_list: bool
    :param can_read: Read enabled.
    :type can_read: bool
    :param teleport_enabled: Enables Teleport functionality on new images in the repository
     improving Container startup performance.
    :type teleport_enabled: bool
    """

    _validation = {
        'registry_login_server': {'required': True, 'readonly': True},
        'name': {'required': True, 'readonly': True},
        'created_on': {'required': True, 'readonly': True},
        'last_updated_on': {'required': True, 'readonly': True},
        'manifest_count': {'required': True, 'readonly': True},
        'tag_count': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'registry_login_server': {'key': 'registry', 'type': 'str'},
        'name': {'key': 'imageName', 'type': 'str'},
        'created_on': {'key': 'createdTime', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'lastUpdateTime', 'type': 'iso-8601'},
        'manifest_count': {'key': 'manifestCount', 'type': 'int'},
        'tag_count': {'key': 'tagCount', 'type': 'int'},
        'can_delete': {'key': 'changeableAttributes.deleteEnabled', 'type': 'bool'},
        'can_write': {'key': 'changeableAttributes.writeEnabled', 'type': 'bool'},
        'can_list': {'key': 'changeableAttributes.listEnabled', 'type': 'bool'},
        'can_read': {'key': 'changeableAttributes.readEnabled', 'type': 'bool'},
        'teleport_enabled': {'key': 'changeableAttributes.teleportEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContainerRepositoryProperties, self).__init__(**kwargs)
        self.registry_login_server = None
        self.name = None
        self.created_on = None
        self.last_updated_on = None
        self.manifest_count = None
        self.tag_count = None
        self.can_delete = kwargs.get('can_delete', None)
        self.can_write = kwargs.get('can_write', None)
        self.can_list = kwargs.get('can_list', None)
        self.can_read = kwargs.get('can_read', None)
        self.teleport_enabled = kwargs.get('teleport_enabled', None)


class DeleteRepositoryResult(msrest.serialization.Model):
    """Deleted repository.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar deleted_manifests: SHA of the deleted image.
    :vartype deleted_manifests: list[str]
    :ivar deleted_tags: Tag of the deleted image.
    :vartype deleted_tags: list[str]
    """

    _validation = {
        'deleted_manifests': {'readonly': True},
        'deleted_tags': {'readonly': True},
    }

    _attribute_map = {
        'deleted_manifests': {'key': 'manifestsDeleted', 'type': '[str]'},
        'deleted_tags': {'key': 'tagsDeleted', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeleteRepositoryResult, self).__init__(**kwargs)
        self.deleted_manifests = None
        self.deleted_tags = None


class Descriptor(msrest.serialization.Model):
    """Docker V2 image layer descriptor including config and layers.

    :param media_type: Layer media type.
    :type media_type: str
    :param size: Layer size.
    :type size: long
    :param digest: Layer digest.
    :type digest: str
    :param urls: Specifies a list of URIs from which this object may be downloaded.
    :type urls: list[str]
    :param annotations: Additional information provided through arbitrary metadata.
    :type annotations: ~container_registry.models.Annotations
    """

    _attribute_map = {
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'size': {'key': 'size', 'type': 'long'},
        'digest': {'key': 'digest', 'type': 'str'},
        'urls': {'key': 'urls', 'type': '[str]'},
        'annotations': {'key': 'annotations', 'type': 'Annotations'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Descriptor, self).__init__(**kwargs)
        self.media_type = kwargs.get('media_type', None)
        self.size = kwargs.get('size', None)
        self.digest = kwargs.get('digest', None)
        self.urls = kwargs.get('urls', None)
        self.annotations = kwargs.get('annotations', None)


class FsLayer(msrest.serialization.Model):
    """Image layer information.

    :param blob_sum: SHA of an image layer.
    :type blob_sum: str
    """

    _attribute_map = {
        'blob_sum': {'key': 'blobSum', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FsLayer, self).__init__(**kwargs)
        self.blob_sum = kwargs.get('blob_sum', None)


class History(msrest.serialization.Model):
    """A list of unstructured historical data for v1 compatibility.

    :param v1_compatibility: The raw v1 compatibility information.
    :type v1_compatibility: str
    """

    _attribute_map = {
        'v1_compatibility': {'key': 'v1Compatibility', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(History, self).__init__(**kwargs)
        self.v1_compatibility = kwargs.get('v1_compatibility', None)


class ImageSignature(msrest.serialization.Model):
    """Signature of a signed manifest.

    :param header: A JSON web signature.
    :type header: ~container_registry.models.JWK
    :param signature: A signature for the image manifest, signed by a libtrust private key.
    :type signature: str
    :param protected: The signed protected header.
    :type protected: str
    """

    _attribute_map = {
        'header': {'key': 'header', 'type': 'JWK'},
        'signature': {'key': 'signature', 'type': 'str'},
        'protected': {'key': 'protected', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageSignature, self).__init__(**kwargs)
        self.header = kwargs.get('header', None)
        self.signature = kwargs.get('signature', None)
        self.protected = kwargs.get('protected', None)


class JWK(msrest.serialization.Model):
    """A JSON web signature.

    :param jwk: JSON web key parameter.
    :type jwk: ~container_registry.models.JWKHeader
    :param alg: The algorithm used to sign or encrypt the JWT.
    :type alg: str
    """

    _attribute_map = {
        'jwk': {'key': 'jwk', 'type': 'JWKHeader'},
        'alg': {'key': 'alg', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JWK, self).__init__(**kwargs)
        self.jwk = kwargs.get('jwk', None)
        self.alg = kwargs.get('alg', None)


class JWKHeader(msrest.serialization.Model):
    """JSON web key parameter.

    :param crv: crv value.
    :type crv: str
    :param kid: kid value.
    :type kid: str
    :param kty: kty value.
    :type kty: str
    :param x: x value.
    :type x: str
    :param y: y value.
    :type y: str
    """

    _attribute_map = {
        'crv': {'key': 'crv', 'type': 'str'},
        'kid': {'key': 'kid', 'type': 'str'},
        'kty': {'key': 'kty', 'type': 'str'},
        'x': {'key': 'x', 'type': 'str'},
        'y': {'key': 'y', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JWKHeader, self).__init__(**kwargs)
        self.crv = kwargs.get('crv', None)
        self.kid = kwargs.get('kid', None)
        self.kty = kwargs.get('kty', None)
        self.x = kwargs.get('x', None)
        self.y = kwargs.get('y', None)


class Manifest(msrest.serialization.Model):
    """Returns the requested manifest file.

    :param schema_version: Schema version.
    :type schema_version: int
    """

    _attribute_map = {
        'schema_version': {'key': 'schemaVersion', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Manifest, self).__init__(**kwargs)
        self.schema_version = kwargs.get('schema_version', None)


class ManifestAttributesBase(msrest.serialization.Model):
    """Manifest details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar digest: Required. Manifest.
    :vartype digest: str
    :ivar size: Image size.
    :vartype size: long
    :ivar created_on: Required. Created time.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: Required. Last update time.
    :vartype last_updated_on: ~datetime.datetime
    :ivar architecture: CPU architecture. Possible values include: "386", "amd64", "arm", "arm64",
     "mips", "mipsle", "mips64", "mips64le", "ppc64", "ppc64le", "riscv64", "s390x", "wasm".
    :vartype architecture: str or ~container_registry.models.ArtifactArchitecture
    :ivar operating_system: Operating system. Possible values include: "aix", "android", "darwin",
     "dragonfly", "freebsd", "illumos", "ios", "js", "linux", "netbsd", "openbsd", "plan9",
     "solaris", "windows".
    :vartype operating_system: str or ~container_registry.models.ArtifactOperatingSystem
    :ivar related_artifacts: List of artifacts that are referenced by this manifest list, with
     information about the platform each supports.  This list will be empty if this is a leaf
     manifest and not a manifest list.
    :vartype related_artifacts: list[~container_registry.models.ArtifactManifestPlatform]
    :ivar tags: A set of tags. List of tags.
    :vartype tags: list[str]
    :param can_delete: Delete enabled.
    :type can_delete: bool
    :param can_write: Write enabled.
    :type can_write: bool
    :param can_list: List enabled.
    :type can_list: bool
    :param can_read: Read enabled.
    :type can_read: bool
    :param quarantine_state: Quarantine state.
    :type quarantine_state: str
    :param quarantine_details: Quarantine details.
    :type quarantine_details: str
    """

    _validation = {
        'digest': {'required': True, 'readonly': True},
        'size': {'readonly': True},
        'created_on': {'required': True, 'readonly': True},
        'last_updated_on': {'required': True, 'readonly': True},
        'architecture': {'readonly': True},
        'operating_system': {'readonly': True},
        'related_artifacts': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'digest': {'key': 'digest', 'type': 'str'},
        'size': {'key': 'imageSize', 'type': 'long'},
        'created_on': {'key': 'createdTime', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'lastUpdateTime', 'type': 'iso-8601'},
        'architecture': {'key': 'architecture', 'type': 'str'},
        'operating_system': {'key': 'os', 'type': 'str'},
        'related_artifacts': {'key': 'references', 'type': '[ArtifactManifestPlatform]'},
        'tags': {'key': 'tags', 'type': '[str]'},
        'can_delete': {'key': 'changeableAttributes.deleteEnabled', 'type': 'bool'},
        'can_write': {'key': 'changeableAttributes.writeEnabled', 'type': 'bool'},
        'can_list': {'key': 'changeableAttributes.listEnabled', 'type': 'bool'},
        'can_read': {'key': 'changeableAttributes.readEnabled', 'type': 'bool'},
        'quarantine_state': {'key': 'changeableAttributes.quarantineState', 'type': 'str'},
        'quarantine_details': {'key': 'changeableAttributes.quarantineDetails', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManifestAttributesBase, self).__init__(**kwargs)
        self.digest = None
        self.size = None
        self.created_on = None
        self.last_updated_on = None
        self.architecture = None
        self.operating_system = None
        self.related_artifacts = None
        self.tags = None
        self.can_delete = kwargs.get('can_delete', None)
        self.can_write = kwargs.get('can_write', None)
        self.can_list = kwargs.get('can_list', None)
        self.can_read = kwargs.get('can_read', None)
        self.quarantine_state = kwargs.get('quarantine_state', None)
        self.quarantine_details = kwargs.get('quarantine_details', None)


class ManifestAttributesManifest(msrest.serialization.Model):
    """List of manifest attributes.

    :param references: List of manifest attributes details.
    :type references: list[~container_registry.models.ArtifactManifestPlatform]
    :param quarantine_tag: Quarantine tag name.
    :type quarantine_tag: str
    """

    _attribute_map = {
        'references': {'key': 'references', 'type': '[ArtifactManifestPlatform]'},
        'quarantine_tag': {'key': 'quarantineTag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManifestAttributesManifest, self).__init__(**kwargs)
        self.references = kwargs.get('references', None)
        self.quarantine_tag = kwargs.get('quarantine_tag', None)


class ManifestList(Manifest):
    """Returns the requested Docker multi-arch-manifest file.

    :param schema_version: Schema version.
    :type schema_version: int
    :param media_type: Media type for this Manifest.
    :type media_type: str
    :param manifests: List of V2 image layer information.
    :type manifests: list[~container_registry.models.ManifestListAttributes]
    """

    _attribute_map = {
        'schema_version': {'key': 'schemaVersion', 'type': 'int'},
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'manifests': {'key': 'manifests', 'type': '[ManifestListAttributes]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManifestList, self).__init__(**kwargs)
        self.media_type = kwargs.get('media_type', None)
        self.manifests = kwargs.get('manifests', None)


class ManifestListAttributes(msrest.serialization.Model):
    """ManifestListAttributes.

    :param media_type: The MIME type of the referenced object. This will generally be
     application/vnd.docker.image.manifest.v2+json, but it could also be
     application/vnd.docker.image.manifest.v1+json.
    :type media_type: str
    :param size: The size in bytes of the object.
    :type size: long
    :param digest: The digest of the content, as defined by the Registry V2 HTTP API Specification.
    :type digest: str
    :param platform: The platform object describes the platform which the image in the manifest
     runs on. A full list of valid operating system and architecture values are listed in the Go
     language documentation for $GOOS and $GOARCH.
    :type platform: ~container_registry.models.Platform
    """

    _attribute_map = {
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'size': {'key': 'size', 'type': 'long'},
        'digest': {'key': 'digest', 'type': 'str'},
        'platform': {'key': 'platform', 'type': 'Platform'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManifestListAttributes, self).__init__(**kwargs)
        self.media_type = kwargs.get('media_type', None)
        self.size = kwargs.get('size', None)
        self.digest = kwargs.get('digest', None)
        self.platform = kwargs.get('platform', None)


class ManifestWrapper(Manifest):
    """Returns the requested manifest file.

    :param schema_version: Schema version.
    :type schema_version: int
    :param media_type: Media type for this Manifest.
    :type media_type: str
    :param manifests: (ManifestList, OCIIndex) List of V2 image layer information.
    :type manifests: list[~container_registry.models.ManifestListAttributes]
    :param config: (V2, OCI) Image config descriptor.
    :type config: ~container_registry.models.Descriptor
    :param layers: (V2, OCI) List of V2 image layer information.
    :type layers: list[~container_registry.models.Descriptor]
    :param annotations: (OCI, OCIIndex) Additional metadata.
    :type annotations: ~container_registry.models.Annotations
    :param architecture: (V1) CPU architecture.
    :type architecture: str
    :param name: (V1) Image name.
    :type name: str
    :param tag: (V1) Image tag.
    :type tag: str
    :param fs_layers: (V1) List of layer information.
    :type fs_layers: list[~container_registry.models.FsLayer]
    :param history: (V1) Image history.
    :type history: list[~container_registry.models.History]
    :param signatures: (V1) Image signature.
    :type signatures: list[~container_registry.models.ImageSignature]
    """

    _attribute_map = {
        'schema_version': {'key': 'schemaVersion', 'type': 'int'},
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'manifests': {'key': 'manifests', 'type': '[ManifestListAttributes]'},
        'config': {'key': 'config', 'type': 'Descriptor'},
        'layers': {'key': 'layers', 'type': '[Descriptor]'},
        'annotations': {'key': 'annotations', 'type': 'Annotations'},
        'architecture': {'key': 'architecture', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'fs_layers': {'key': 'fsLayers', 'type': '[FsLayer]'},
        'history': {'key': 'history', 'type': '[History]'},
        'signatures': {'key': 'signatures', 'type': '[ImageSignature]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManifestWrapper, self).__init__(**kwargs)
        self.media_type = kwargs.get('media_type', None)
        self.manifests = kwargs.get('manifests', None)
        self.config = kwargs.get('config', None)
        self.layers = kwargs.get('layers', None)
        self.annotations = kwargs.get('annotations', None)
        self.architecture = kwargs.get('architecture', None)
        self.name = kwargs.get('name', None)
        self.tag = kwargs.get('tag', None)
        self.fs_layers = kwargs.get('fs_layers', None)
        self.history = kwargs.get('history', None)
        self.signatures = kwargs.get('signatures', None)


class ManifestWriteableProperties(msrest.serialization.Model):
    """Changeable attributes.

    :param can_delete: Delete enabled.
    :type can_delete: bool
    :param can_write: Write enabled.
    :type can_write: bool
    :param can_list: List enabled.
    :type can_list: bool
    :param can_read: Read enabled.
    :type can_read: bool
    :param quarantine_state: Quarantine state.
    :type quarantine_state: str
    :param quarantine_details: Quarantine details.
    :type quarantine_details: str
    """

    _attribute_map = {
        'can_delete': {'key': 'deleteEnabled', 'type': 'bool'},
        'can_write': {'key': 'writeEnabled', 'type': 'bool'},
        'can_list': {'key': 'listEnabled', 'type': 'bool'},
        'can_read': {'key': 'readEnabled', 'type': 'bool'},
        'quarantine_state': {'key': 'quarantineState', 'type': 'str'},
        'quarantine_details': {'key': 'quarantineDetails', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManifestWriteableProperties, self).__init__(**kwargs)
        self.can_delete = kwargs.get('can_delete', None)
        self.can_write = kwargs.get('can_write', None)
        self.can_list = kwargs.get('can_list', None)
        self.can_read = kwargs.get('can_read', None)
        self.quarantine_state = kwargs.get('quarantine_state', None)
        self.quarantine_details = kwargs.get('quarantine_details', None)


class OCIIndex(Manifest):
    """Returns the requested OCI index file.

    :param schema_version: Schema version.
    :type schema_version: int
    :param manifests: List of OCI image layer information.
    :type manifests: list[~container_registry.models.ManifestListAttributes]
    :param annotations: Additional information provided through arbitrary metadata.
    :type annotations: ~container_registry.models.Annotations
    """

    _attribute_map = {
        'schema_version': {'key': 'schemaVersion', 'type': 'int'},
        'manifests': {'key': 'manifests', 'type': '[ManifestListAttributes]'},
        'annotations': {'key': 'annotations', 'type': 'Annotations'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OCIIndex, self).__init__(**kwargs)
        self.manifests = kwargs.get('manifests', None)
        self.annotations = kwargs.get('annotations', None)


class OCIManifest(Manifest):
    """Returns the requested OCI Manifest file.

    :param schema_version: Schema version.
    :type schema_version: int
    :param config: V2 image config descriptor.
    :type config: ~container_registry.models.Descriptor
    :param layers: List of V2 image layer information.
    :type layers: list[~container_registry.models.Descriptor]
    :param annotations: Additional information provided through arbitrary metadata.
    :type annotations: ~container_registry.models.Annotations
    """

    _attribute_map = {
        'schema_version': {'key': 'schemaVersion', 'type': 'int'},
        'config': {'key': 'config', 'type': 'Descriptor'},
        'layers': {'key': 'layers', 'type': '[Descriptor]'},
        'annotations': {'key': 'annotations', 'type': 'Annotations'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OCIManifest, self).__init__(**kwargs)
        self.config = kwargs.get('config', None)
        self.layers = kwargs.get('layers', None)
        self.annotations = kwargs.get('annotations', None)


class Paths108HwamOauth2ExchangePostRequestbodyContentApplicationXWwwFormUrlencodedSchema(msrest.serialization.Model):
    """Paths108HwamOauth2ExchangePostRequestbodyContentApplicationXWwwFormUrlencodedSchema.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar grant_type: Required. Can take a value of access_token. Default value: "access_token".
    :vartype grant_type: str
    :param service: Required. Indicates the name of your Azure container registry.
    :type service: str
    :param aad_access_token: Required. AAD access token, mandatory when grant_type is
     access_token_refresh_token or access_token.
    :type aad_access_token: str
    """

    _validation = {
        'grant_type': {'required': True, 'constant': True},
        'service': {'required': True},
        'aad_access_token': {'required': True},
    }

    _attribute_map = {
        'grant_type': {'key': 'grant_type', 'type': 'str'},
        'service': {'key': 'service', 'type': 'str'},
        'aad_access_token': {'key': 'access_token', 'type': 'str'},
    }

    grant_type = "access_token"

    def __init__(
        self,
        **kwargs
    ):
        super(Paths108HwamOauth2ExchangePostRequestbodyContentApplicationXWwwFormUrlencodedSchema, self).__init__(**kwargs)
        self.service = kwargs['service']
        self.aad_access_token = kwargs['aad_access_token']


class PathsV3R3RxOauth2TokenPostRequestbodyContentApplicationXWwwFormUrlencodedSchema(msrest.serialization.Model):
    """PathsV3R3RxOauth2TokenPostRequestbodyContentApplicationXWwwFormUrlencodedSchema.

    All required parameters must be populated in order to send to Azure.

    :param service: Required. Indicates the name of your Azure container registry.
    :type service: str
    :param scope: Required. Which is expected to be a valid scope, and can be specified more than
     once for multiple scope requests. You obtained this from the Www-Authenticate response header
     from the challenge.
    :type scope: str
    :param acr_refresh_token: Required. Must be a valid ACR refresh token.
    :type acr_refresh_token: str
    :param grant_type: Required. Grant type is expected to be refresh_token. Possible values
     include: "refresh_token", "password".
    :type grant_type: str or ~container_registry.models.TokenGrantType
    """

    _validation = {
        'service': {'required': True},
        'scope': {'required': True},
        'acr_refresh_token': {'required': True},
        'grant_type': {'required': True},
    }

    _attribute_map = {
        'service': {'key': 'service', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
        'acr_refresh_token': {'key': 'refresh_token', 'type': 'str'},
        'grant_type': {'key': 'grant_type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PathsV3R3RxOauth2TokenPostRequestbodyContentApplicationXWwwFormUrlencodedSchema, self).__init__(**kwargs)
        self.service = kwargs['service']
        self.scope = kwargs['scope']
        self.acr_refresh_token = kwargs['acr_refresh_token']
        self.grant_type = kwargs.get('grant_type', "refresh_token")


class Platform(msrest.serialization.Model):
    """The platform object describes the platform which the image in the manifest runs on. A full list of valid operating system and architecture values are listed in the Go language documentation for $GOOS and $GOARCH.

    :param architecture: Specifies the CPU architecture, for example amd64 or ppc64le.
    :type architecture: str
    :param os: The os field specifies the operating system, for example linux or windows.
    :type os: str
    :param os_version: The optional os.version field specifies the operating system version, for
     example 10.0.10586.
    :type os_version: str
    :param os_features: The optional os.features field specifies an array of strings, each listing
     a required OS feature (for example on Windows win32k.
    :type os_features: list[str]
    :param variant: The optional variant field specifies a variant of the CPU, for example armv6l
     to specify a particular CPU variant of the ARM CPU.
    :type variant: str
    :param features: The optional features field specifies an array of strings, each listing a
     required CPU feature (for example sse4 or aes.
    :type features: list[str]
    """

    _attribute_map = {
        'architecture': {'key': 'architecture', 'type': 'str'},
        'os': {'key': 'os', 'type': 'str'},
        'os_version': {'key': 'os\\.version', 'type': 'str'},
        'os_features': {'key': 'os\\.features', 'type': '[str]'},
        'variant': {'key': 'variant', 'type': 'str'},
        'features': {'key': 'features', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Platform, self).__init__(**kwargs)
        self.architecture = kwargs.get('architecture', None)
        self.os = kwargs.get('os', None)
        self.os_version = kwargs.get('os_version', None)
        self.os_features = kwargs.get('os_features', None)
        self.variant = kwargs.get('variant', None)
        self.features = kwargs.get('features', None)


class Repositories(msrest.serialization.Model):
    """List of repositories.

    :param repositories: Repository names.
    :type repositories: list[str]
    :param link:
    :type link: str
    """

    _attribute_map = {
        'repositories': {'key': 'repositories', 'type': '[str]'},
        'link': {'key': 'link', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Repositories, self).__init__(**kwargs)
        self.repositories = kwargs.get('repositories', None)
        self.link = kwargs.get('link', None)


class RepositoryTags(msrest.serialization.Model):
    """Result of the request to list tags of the image.

    :param name: Name of the image.
    :type name: str
    :param tags: A set of tags. List of tags.
    :type tags: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RepositoryTags, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tags = kwargs.get('tags', None)


class RepositoryWriteableProperties(msrest.serialization.Model):
    """Changeable attributes for Repository.

    :param can_delete: Delete enabled.
    :type can_delete: bool
    :param can_write: Write enabled.
    :type can_write: bool
    :param can_list: List enabled.
    :type can_list: bool
    :param can_read: Read enabled.
    :type can_read: bool
    :param teleport_enabled: Enables Teleport functionality on new images in the repository
     improving Container startup performance.
    :type teleport_enabled: bool
    """

    _attribute_map = {
        'can_delete': {'key': 'deleteEnabled', 'type': 'bool'},
        'can_write': {'key': 'writeEnabled', 'type': 'bool'},
        'can_list': {'key': 'listEnabled', 'type': 'bool'},
        'can_read': {'key': 'readEnabled', 'type': 'bool'},
        'teleport_enabled': {'key': 'teleportEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RepositoryWriteableProperties, self).__init__(**kwargs)
        self.can_delete = kwargs.get('can_delete', None)
        self.can_write = kwargs.get('can_write', None)
        self.can_list = kwargs.get('can_list', None)
        self.can_read = kwargs.get('can_read', None)
        self.teleport_enabled = kwargs.get('teleport_enabled', None)


class TagAttributesBase(msrest.serialization.Model):
    """Tag attribute details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Tag name.
    :vartype name: str
    :ivar digest: Required. Tag digest.
    :vartype digest: str
    :ivar created_on: Required. Tag created time.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: Required. Tag last update time.
    :vartype last_updated_on: ~datetime.datetime
    :param can_delete: Delete enabled.
    :type can_delete: bool
    :param can_write: Write enabled.
    :type can_write: bool
    :param can_list: List enabled.
    :type can_list: bool
    :param can_read: Read enabled.
    :type can_read: bool
    """

    _validation = {
        'name': {'required': True, 'readonly': True},
        'digest': {'required': True, 'readonly': True},
        'created_on': {'required': True, 'readonly': True},
        'last_updated_on': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'digest': {'key': 'digest', 'type': 'str'},
        'created_on': {'key': 'createdTime', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'lastUpdateTime', 'type': 'iso-8601'},
        'can_delete': {'key': 'changeableAttributes.deleteEnabled', 'type': 'bool'},
        'can_write': {'key': 'changeableAttributes.writeEnabled', 'type': 'bool'},
        'can_list': {'key': 'changeableAttributes.listEnabled', 'type': 'bool'},
        'can_read': {'key': 'changeableAttributes.readEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagAttributesBase, self).__init__(**kwargs)
        self.name = None
        self.digest = None
        self.created_on = None
        self.last_updated_on = None
        self.can_delete = kwargs.get('can_delete', None)
        self.can_write = kwargs.get('can_write', None)
        self.can_list = kwargs.get('can_list', None)
        self.can_read = kwargs.get('can_read', None)


class TagAttributesTag(msrest.serialization.Model):
    """Tag.

    :param signature_record: SignatureRecord value.
    :type signature_record: str
    """

    _attribute_map = {
        'signature_record': {'key': 'signatureRecord', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagAttributesTag, self).__init__(**kwargs)
        self.signature_record = kwargs.get('signature_record', None)


class TagList(msrest.serialization.Model):
    """List of tag details.

    All required parameters must be populated in order to send to Azure.

    :param registry_login_server: Required. Registry login server.
    :type registry_login_server: str
    :param repository: Required. Image name.
    :type repository: str
    :param tag_attribute_bases: Required. List of tag attribute details.
    :type tag_attribute_bases: list[~container_registry.models.TagAttributesBase]
    :param link:
    :type link: str
    """

    _validation = {
        'registry_login_server': {'required': True},
        'repository': {'required': True},
        'tag_attribute_bases': {'required': True},
    }

    _attribute_map = {
        'registry_login_server': {'key': 'registry', 'type': 'str'},
        'repository': {'key': 'imageName', 'type': 'str'},
        'tag_attribute_bases': {'key': 'tags', 'type': '[TagAttributesBase]'},
        'link': {'key': 'link', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagList, self).__init__(**kwargs)
        self.registry_login_server = kwargs['registry_login_server']
        self.repository = kwargs['repository']
        self.tag_attribute_bases = kwargs['tag_attribute_bases']
        self.link = kwargs.get('link', None)


class TagWriteableProperties(msrest.serialization.Model):
    """Changeable attributes.

    :param can_delete: Delete enabled.
    :type can_delete: bool
    :param can_write: Write enabled.
    :type can_write: bool
    :param can_list: List enabled.
    :type can_list: bool
    :param can_read: Read enabled.
    :type can_read: bool
    """

    _attribute_map = {
        'can_delete': {'key': 'deleteEnabled', 'type': 'bool'},
        'can_write': {'key': 'writeEnabled', 'type': 'bool'},
        'can_list': {'key': 'listEnabled', 'type': 'bool'},
        'can_read': {'key': 'readEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagWriteableProperties, self).__init__(**kwargs)
        self.can_delete = kwargs.get('can_delete', None)
        self.can_write = kwargs.get('can_write', None)
        self.can_list = kwargs.get('can_list', None)
        self.can_read = kwargs.get('can_read', None)


class V1Manifest(Manifest):
    """Returns the requested V1 manifest file.

    :param schema_version: Schema version.
    :type schema_version: int
    :param architecture: CPU architecture.
    :type architecture: str
    :param name: Image name.
    :type name: str
    :param tag: Image tag.
    :type tag: str
    :param fs_layers: List of layer information.
    :type fs_layers: list[~container_registry.models.FsLayer]
    :param history: Image history.
    :type history: list[~container_registry.models.History]
    :param signatures: Image signature.
    :type signatures: list[~container_registry.models.ImageSignature]
    """

    _attribute_map = {
        'schema_version': {'key': 'schemaVersion', 'type': 'int'},
        'architecture': {'key': 'architecture', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'fs_layers': {'key': 'fsLayers', 'type': '[FsLayer]'},
        'history': {'key': 'history', 'type': '[History]'},
        'signatures': {'key': 'signatures', 'type': '[ImageSignature]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(V1Manifest, self).__init__(**kwargs)
        self.architecture = kwargs.get('architecture', None)
        self.name = kwargs.get('name', None)
        self.tag = kwargs.get('tag', None)
        self.fs_layers = kwargs.get('fs_layers', None)
        self.history = kwargs.get('history', None)
        self.signatures = kwargs.get('signatures', None)


class V2Manifest(Manifest):
    """Returns the requested Docker V2 Manifest file.

    :param schema_version: Schema version.
    :type schema_version: int
    :param media_type: Media type for this Manifest.
    :type media_type: str
    :param config: V2 image config descriptor.
    :type config: ~container_registry.models.Descriptor
    :param layers: List of V2 image layer information.
    :type layers: list[~container_registry.models.Descriptor]
    """

    _attribute_map = {
        'schema_version': {'key': 'schemaVersion', 'type': 'int'},
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'config': {'key': 'config', 'type': 'Descriptor'},
        'layers': {'key': 'layers', 'type': '[Descriptor]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(V2Manifest, self).__init__(**kwargs)
        self.media_type = kwargs.get('media_type', None)
        self.config = kwargs.get('config', None)
        self.layers = kwargs.get('layers', None)
