# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, AsyncIterator, Callable, IO, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.polling.async_base_polling import AsyncLROBasePolling
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._operations._operations import (
    build_question_answering_authoring_add_feedback_request,
    build_question_answering_authoring_begin_import_assets_request,
    build_question_answering_authoring_create_project_request,
    build_question_answering_authoring_delete_project_request,
    build_question_answering_authoring_deploy_project_request,
    build_question_answering_authoring_export_request,
    build_question_answering_authoring_get_delete_status_request,
    build_question_answering_authoring_get_deploy_status_request,
    build_question_answering_authoring_get_export_status_request,
    build_question_answering_authoring_get_import_status_request,
    build_question_answering_authoring_get_project_details_request,
    build_question_answering_authoring_get_update_qnas_status_request,
    build_question_answering_authoring_get_update_sources_status_request,
    build_question_answering_authoring_import_from_files_request,
    build_question_answering_authoring_list_deployments_request,
    build_question_answering_authoring_list_projects_request,
    build_question_answering_authoring_list_qnas_request,
    build_question_answering_authoring_list_sources_request,
    build_question_answering_authoring_list_synonyms_request,
    build_question_answering_authoring_update_qnas_request,
    build_question_answering_authoring_update_sources_from_files_request,
    build_question_answering_authoring_update_sources_request,
    build_question_answering_authoring_update_synonyms_request,
)
from ..._utils.model_base import Model as _Model, SdkJSONEncoder, _deserialize, _failsafe_deserialize
from ..._utils.utils import ClientMixinABC, prepare_multipart_form_data
from ..._validation import api_version_validation
from .._configuration import QuestionAnsweringAuthoringClientConfiguration

JSON = MutableMapping[str, Any]
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, dict[str, Any]], Any]]


class _QuestionAnsweringAuthoringClientOperationsMixin(  # pylint: disable=too-many-public-methods
    ClientMixinABC[AsyncPipelineClient[HttpRequest, AsyncHttpResponse], QuestionAnsweringAuthoringClientConfiguration]
):

    @distributed_trace
    def list_projects(
        self, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> AsyncItemPaged["_models.QuestionAnsweringProject"]:
        """Gets all projects for a user.

        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of QuestionAnsweringProject
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.ai.language.questionanswering.authoring.models.QuestionAnsweringProject]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[list[_models.QuestionAnsweringProject]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_question_answering_authoring_list_projects_request(
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.QuestionAnsweringProject], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorResponse, response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_project_details(self, project_name: str, **kwargs: Any) -> _models.QuestionAnsweringProject:
        """Get the requested project metadata.

        :param project_name: Name of the project. Required.
        :type project_name: str
        :return: QuestionAnsweringProject. The QuestionAnsweringProject is compatible with
         MutableMapping
        :rtype: ~azure.ai.language.questionanswering.authoring.models.QuestionAnsweringProject
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.QuestionAnsweringProject] = kwargs.pop("cls", None)

        _request = build_question_answering_authoring_get_project_details_request(
            project_name=project_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.QuestionAnsweringProject, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_project(
        self,
        project_name: str,
        body: _models.QuestionAnsweringProject,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.QuestionAnsweringProject:
        """Create or update a project.

        :param project_name: Name of the project. Required.
        :type project_name: str
        :param body: The resource instance. Required.
        :type body: ~azure.ai.language.questionanswering.authoring.models.QuestionAnsweringProject
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: QuestionAnsweringProject. The QuestionAnsweringProject is compatible with
         MutableMapping
        :rtype: ~azure.ai.language.questionanswering.authoring.models.QuestionAnsweringProject
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_project(
        self, project_name: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.QuestionAnsweringProject:
        """Create or update a project.

        :param project_name: Name of the project. Required.
        :type project_name: str
        :param body: The resource instance. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: QuestionAnsweringProject. The QuestionAnsweringProject is compatible with
         MutableMapping
        :rtype: ~azure.ai.language.questionanswering.authoring.models.QuestionAnsweringProject
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_project(
        self, project_name: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.QuestionAnsweringProject:
        """Create or update a project.

        :param project_name: Name of the project. Required.
        :type project_name: str
        :param body: The resource instance. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: QuestionAnsweringProject. The QuestionAnsweringProject is compatible with
         MutableMapping
        :rtype: ~azure.ai.language.questionanswering.authoring.models.QuestionAnsweringProject
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_project(
        self, project_name: str, body: Union[_models.QuestionAnsweringProject, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.QuestionAnsweringProject:
        """Create or update a project.

        :param project_name: Name of the project. Required.
        :type project_name: str
        :param body: The resource instance. Is one of the following types: QuestionAnsweringProject,
         JSON, IO[bytes] Required.
        :type body: ~azure.ai.language.questionanswering.authoring.models.QuestionAnsweringProject or
         JSON or IO[bytes]
        :return: QuestionAnsweringProject. The QuestionAnsweringProject is compatible with
         MutableMapping
        :rtype: ~azure.ai.language.questionanswering.authoring.models.QuestionAnsweringProject
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.QuestionAnsweringProject] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_question_answering_authoring_create_project_request(
            project_name=project_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.QuestionAnsweringProject, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _delete_project_initial(self, project_name: str, **kwargs: Any) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_question_answering_authoring_delete_project_request(
            project_name=project_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete_project(self, project_name: str, **kwargs: Any) -> AsyncLROPoller[None]:
        """Delete the project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_project_initial(
                project_name=project_name, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def _get_delete_status(
        self, job_id: str, **kwargs: Any
    ) -> _models.QuestionAnsweringAuthoringProjectDeletionJobState:
        """Gets the status of a Project delete job.

        :param job_id: The job ID. Required.
        :type job_id: str
        :return: QuestionAnsweringAuthoringProjectDeletionJobState. The
         QuestionAnsweringAuthoringProjectDeletionJobState is compatible with MutableMapping
        :rtype:
         ~azure.ai.language.questionanswering.authoring.models.QuestionAnsweringAuthoringProjectDeletionJobState
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.QuestionAnsweringAuthoringProjectDeletionJobState] = kwargs.pop("cls", None)

        _request = build_question_answering_authoring_get_delete_status_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.QuestionAnsweringAuthoringProjectDeletionJobState, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _export_initial(
        self,
        project_name: str,
        *,
        file_format: Optional[Union[str, _models.Format]] = None,
        asset_kind: Optional[Union[str, _models.AssetKind]] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_question_answering_authoring_export_request(
            project_name=project_name,
            file_format=file_format,
            asset_kind=asset_kind,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_export(
        self,
        project_name: str,
        *,
        file_format: Optional[Union[str, _models.Format]] = None,
        asset_kind: Optional[Union[str, _models.AssetKind]] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Export project metadata and assets.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :keyword file_format: Knowledge base Import or Export format. Known values are: "json", "tsv",
         and "excel". Default value is None.
        :paramtype file_format: str or ~azure.ai.language.questionanswering.authoring.models.Format
        :keyword asset_kind: Kind of the asset of the project. Known values are: "qnas" and "synonyms".
         Default value is None.
        :paramtype asset_kind: str or ~azure.ai.language.questionanswering.authoring.models.AssetKind
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._export_initial(
                project_name=project_name,
                file_format=file_format,
                asset_kind=asset_kind,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def _get_export_status(
        self, project_name: str, job_id: str, **kwargs: Any
    ) -> _models.QuestionAnsweringAuthoringExportJobState:
        """Gets the status of an Export job, once job completes, returns the project
        metadata, and assets.

        :param project_name: Name of the project. Required.
        :type project_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: QuestionAnsweringAuthoringExportJobState. The QuestionAnsweringAuthoringExportJobState
         is compatible with MutableMapping
        :rtype:
         ~azure.ai.language.questionanswering.authoring.models.QuestionAnsweringAuthoringExportJobState
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.QuestionAnsweringAuthoringExportJobState] = kwargs.pop("cls", None)

        _request = build_question_answering_authoring_get_export_status_request(
            project_name=project_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.QuestionAnsweringAuthoringExportJobState, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _begin_import_assets_initial(
        self,
        project_name: str,
        body: Optional[Union[_models.ImportJobOptions, JSON, IO[bytes]]] = None,
        *,
        file_format: Optional[Union[str, _models.Format]] = None,
        asset_kind: Optional[Union[str, _models.AssetKind]] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if body else None
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if body else None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_question_answering_authoring_begin_import_assets_request(
            project_name=project_name,
            file_format=file_format,
            asset_kind=asset_kind,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_import_assets(
        self,
        project_name: str,
        body: Optional[_models.ImportJobOptions] = None,
        *,
        file_format: Optional[Union[str, _models.Format]] = None,
        asset_kind: Optional[Union[str, _models.AssetKind]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Import project assets.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Project assets the needs to be imported. Default value is None.
        :type body: ~azure.ai.language.questionanswering.authoring.models.ImportJobOptions
        :keyword file_format: Knowledge base Import or Export format. Known values are: "json", "tsv",
         and "excel". Default value is None.
        :paramtype file_format: str or ~azure.ai.language.questionanswering.authoring.models.Format
        :keyword asset_kind: Kind of the asset of the project. Known values are: "qnas" and "synonyms".
         Default value is None.
        :paramtype asset_kind: str or ~azure.ai.language.questionanswering.authoring.models.AssetKind
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_import_assets(
        self,
        project_name: str,
        body: Optional[JSON] = None,
        *,
        file_format: Optional[Union[str, _models.Format]] = None,
        asset_kind: Optional[Union[str, _models.AssetKind]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Import project assets.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Project assets the needs to be imported. Default value is None.
        :type body: JSON
        :keyword file_format: Knowledge base Import or Export format. Known values are: "json", "tsv",
         and "excel". Default value is None.
        :paramtype file_format: str or ~azure.ai.language.questionanswering.authoring.models.Format
        :keyword asset_kind: Kind of the asset of the project. Known values are: "qnas" and "synonyms".
         Default value is None.
        :paramtype asset_kind: str or ~azure.ai.language.questionanswering.authoring.models.AssetKind
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_import_assets(
        self,
        project_name: str,
        body: Optional[IO[bytes]] = None,
        *,
        file_format: Optional[Union[str, _models.Format]] = None,
        asset_kind: Optional[Union[str, _models.AssetKind]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Import project assets.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Project assets the needs to be imported. Default value is None.
        :type body: IO[bytes]
        :keyword file_format: Knowledge base Import or Export format. Known values are: "json", "tsv",
         and "excel". Default value is None.
        :paramtype file_format: str or ~azure.ai.language.questionanswering.authoring.models.Format
        :keyword asset_kind: Kind of the asset of the project. Known values are: "qnas" and "synonyms".
         Default value is None.
        :paramtype asset_kind: str or ~azure.ai.language.questionanswering.authoring.models.AssetKind
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_import_assets(
        self,
        project_name: str,
        body: Optional[Union[_models.ImportJobOptions, JSON, IO[bytes]]] = None,
        *,
        file_format: Optional[Union[str, _models.Format]] = None,
        asset_kind: Optional[Union[str, _models.AssetKind]] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Import project assets.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Project assets the needs to be imported. Is one of the following types:
         ImportJobOptions, JSON, IO[bytes] Default value is None.
        :type body: ~azure.ai.language.questionanswering.authoring.models.ImportJobOptions or JSON or
         IO[bytes]
        :keyword file_format: Knowledge base Import or Export format. Known values are: "json", "tsv",
         and "excel". Default value is None.
        :paramtype file_format: str or ~azure.ai.language.questionanswering.authoring.models.Format
        :keyword asset_kind: Kind of the asset of the project. Known values are: "qnas" and "synonyms".
         Default value is None.
        :paramtype asset_kind: str or ~azure.ai.language.questionanswering.authoring.models.AssetKind
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if body else None
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._begin_import_assets_initial(
                project_name=project_name,
                body=body,
                file_format=file_format,
                asset_kind=asset_kind,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @api_version_validation(
        method_added_on="2025-05-15-preview",
        params_added_on={"2025-05-15-preview": ["api_version", "content_type", "project_name", "asset_kind"]},
        api_versions_list=["2025-05-15-preview"],
    )
    async def _import_from_files_initial(
        self,
        project_name: str,
        body: Union[_models.ImportFiles, JSON],
        *,
        asset_kind: Optional[Union[str, _models.AssetKind]] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _body = body.as_dict() if isinstance(body, _Model) else body
        _file_fields: list[str] = ["files"]
        _data_fields: list[str] = []
        _files, _data = prepare_multipart_form_data(_body, _file_fields, _data_fields)

        _request = build_question_answering_authoring_import_from_files_request(
            project_name=project_name,
            asset_kind=asset_kind,
            api_version=self._config.api_version,
            files=_files,
            data=_data,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_import_from_files(
        self,
        project_name: str,
        body: _models.ImportFiles,
        *,
        asset_kind: Optional[Union[str, _models.AssetKind]] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Import project assets from file.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Collection of files containing project assets the needs to be imported. Required.
        :type body: ~azure.ai.language.questionanswering.authoring.models.ImportFiles
        :keyword asset_kind: Kind of the asset of the project. Known values are: "qnas" and "synonyms".
         Default value is None.
        :paramtype asset_kind: str or ~azure.ai.language.questionanswering.authoring.models.AssetKind
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_import_from_files(
        self,
        project_name: str,
        body: JSON,
        *,
        asset_kind: Optional[Union[str, _models.AssetKind]] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Import project assets from file.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Collection of files containing project assets the needs to be imported. Required.
        :type body: JSON
        :keyword asset_kind: Kind of the asset of the project. Known values are: "qnas" and "synonyms".
         Default value is None.
        :paramtype asset_kind: str or ~azure.ai.language.questionanswering.authoring.models.AssetKind
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    @api_version_validation(
        method_added_on="2025-05-15-preview",
        params_added_on={"2025-05-15-preview": ["api_version", "content_type", "project_name", "asset_kind"]},
        api_versions_list=["2025-05-15-preview"],
    )
    async def begin_import_from_files(
        self,
        project_name: str,
        body: Union[_models.ImportFiles, JSON],
        *,
        asset_kind: Optional[Union[str, _models.AssetKind]] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Import project assets from file.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Collection of files containing project assets the needs to be imported. Is either
         a ImportFiles type or a JSON type. Required.
        :type body: ~azure.ai.language.questionanswering.authoring.models.ImportFiles or JSON
        :keyword asset_kind: Kind of the asset of the project. Known values are: "qnas" and "synonyms".
         Default value is None.
        :paramtype asset_kind: str or ~azure.ai.language.questionanswering.authoring.models.AssetKind
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._import_from_files_initial(
                project_name=project_name,
                body=body,
                asset_kind=asset_kind,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def _get_import_status(
        self, project_name: str, job_id: str, **kwargs: Any
    ) -> _models.QuestionAnsweringAuthoringImportJobState:
        """Gets the status of an Import job.

        :param project_name: Name of the project. Required.
        :type project_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: QuestionAnsweringAuthoringImportJobState. The QuestionAnsweringAuthoringImportJobState
         is compatible with MutableMapping
        :rtype:
         ~azure.ai.language.questionanswering.authoring.models.QuestionAnsweringAuthoringImportJobState
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.QuestionAnsweringAuthoringImportJobState] = kwargs.pop("cls", None)

        _request = build_question_answering_authoring_get_import_status_request(
            project_name=project_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.QuestionAnsweringAuthoringImportJobState, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _deploy_project_initial(
        self, project_name: str, deployment_name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_question_answering_authoring_deploy_project_request(
            project_name=project_name,
            deployment_name=deployment_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_deploy_project(
        self, project_name: str, deployment_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deploy project to production.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use. Required.
        :type deployment_name: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._deploy_project_initial(
                project_name=project_name,
                deployment_name=deployment_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def _get_deploy_status(
        self, project_name: str, deployment_name: str, job_id: str, **kwargs: Any
    ) -> _models.QuestionAnsweringAuthoringProjectDeploymentJobState:
        """Gets the status of a Deploy job.

        :param project_name: Name of the project. Required.
        :type project_name: str
        :param deployment_name: Name of the deployment. Required.
        :type deployment_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: QuestionAnsweringAuthoringProjectDeploymentJobState. The
         QuestionAnsweringAuthoringProjectDeploymentJobState is compatible with MutableMapping
        :rtype:
         ~azure.ai.language.questionanswering.authoring.models.QuestionAnsweringAuthoringProjectDeploymentJobState
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.QuestionAnsweringAuthoringProjectDeploymentJobState] = kwargs.pop("cls", None)

        _request = build_question_answering_authoring_get_deploy_status_request(
            project_name=project_name,
            deployment_name=deployment_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.QuestionAnsweringAuthoringProjectDeploymentJobState, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_deployments(
        self, project_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> AsyncItemPaged["_models.ProjectDeployment"]:
        """List all deployments of a project.

        :param project_name: Name of the project. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of ProjectDeployment
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.ai.language.questionanswering.authoring.models.ProjectDeployment]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[list[_models.ProjectDeployment]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_question_answering_authoring_list_deployments_request(
                    project_name=project_name,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.ProjectDeployment], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorResponse, response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_synonyms(
        self, project_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> AsyncItemPaged["_models.WordAlterations"]:
        """Gets all the synonyms of a project.

        :param project_name: Name of the project. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of WordAlterations
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.ai.language.questionanswering.authoring.models.WordAlterations]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[list[_models.WordAlterations]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_question_answering_authoring_list_synonyms_request(
                    project_name=project_name,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.WordAlterations], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorResponse, response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def update_synonyms(
        self, project_name: str, body: _models.SynonymAssets, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Updates all the synonyms of a project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: All the synonyms of a project. Required.
        :type body: ~azure.ai.language.questionanswering.authoring.models.SynonymAssets
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_synonyms(
        self, project_name: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Updates all the synonyms of a project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: All the synonyms of a project. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_synonyms(
        self, project_name: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Updates all the synonyms of a project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: All the synonyms of a project. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_synonyms(
        self, project_name: str, body: Union[_models.SynonymAssets, JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        """Updates all the synonyms of a project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: All the synonyms of a project. Is one of the following types: SynonymAssets, JSON,
         IO[bytes] Required.
        :type body: ~azure.ai.language.questionanswering.authoring.models.SynonymAssets or JSON or
         IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_question_answering_authoring_update_synonyms_request(
            project_name=project_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def list_sources(
        self, project_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> AsyncItemPaged["_models.QnaSourceRecord"]:
        """Gets all the sources of a project.

        :param project_name: Name of the project. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of QnaSourceRecord
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.ai.language.questionanswering.authoring.models.QnaSourceRecord]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[list[_models.QnaSourceRecord]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_question_answering_authoring_list_sources_request(
                    project_name=project_name,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.QnaSourceRecord], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorResponse, response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _update_sources_initial(
        self, project_name: str, body: Union[list[_models.UpdateSourceRecord], IO[bytes]], **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_question_answering_authoring_update_sources_request(
            project_name=project_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update_sources(
        self,
        project_name: str,
        body: list[_models.UpdateSourceRecord],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Updates the sources of a project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Update sources parameters of a project. Required.
        :type body: list[~azure.ai.language.questionanswering.authoring.models.UpdateSourceRecord]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_sources(
        self, project_name: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Updates the sources of a project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Update sources parameters of a project. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update_sources(
        self, project_name: str, body: Union[list[_models.UpdateSourceRecord], IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Updates the sources of a project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Update sources parameters of a project. Is either a [UpdateSourceRecord] type or a
         IO[bytes] type. Required.
        :type body: list[~azure.ai.language.questionanswering.authoring.models.UpdateSourceRecord] or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_sources_initial(
                project_name=project_name,
                body=body,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @api_version_validation(
        method_added_on="2025-05-15-preview",
        params_added_on={"2025-05-15-preview": ["api_version", "content_type", "project_name"]},
        api_versions_list=["2025-05-15-preview"],
    )
    async def _update_sources_from_files_initial(
        self, project_name: str, body: Union[_models.UpdateSourceFiles, JSON], **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _body = body.as_dict() if isinstance(body, _Model) else body
        _file_fields: list[str] = ["files"]
        _data_fields: list[str] = ["fileOperations"]
        _files, _data = prepare_multipart_form_data(_body, _file_fields, _data_fields)

        _request = build_question_answering_authoring_update_sources_from_files_request(
            project_name=project_name,
            api_version=self._config.api_version,
            files=_files,
            data=_data,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update_sources_from_files(
        self, project_name: str, body: _models.UpdateSourceFiles, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Updates the sources of a project from files.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Collection of files containing project assets the needs to be imported. Required.
        :type body: ~azure.ai.language.questionanswering.authoring.models.UpdateSourceFiles
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_sources_from_files(
        self, project_name: str, body: JSON, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Updates the sources of a project from files.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Collection of files containing project assets the needs to be imported. Required.
        :type body: JSON
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    @api_version_validation(
        method_added_on="2025-05-15-preview",
        params_added_on={"2025-05-15-preview": ["api_version", "content_type", "project_name"]},
        api_versions_list=["2025-05-15-preview"],
    )
    async def begin_update_sources_from_files(
        self, project_name: str, body: Union[_models.UpdateSourceFiles, JSON], **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Updates the sources of a project from files.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Collection of files containing project assets the needs to be imported. Is either
         a UpdateSourceFiles type or a JSON type. Required.
        :type body: ~azure.ai.language.questionanswering.authoring.models.UpdateSourceFiles or JSON
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_sources_from_files_initial(
                project_name=project_name, body=body, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def _get_update_sources_status(
        self, project_name: str, job_id: str, **kwargs: Any
    ) -> _models.QuestionAnsweringAuthoringUpdateSourcesJobState:
        """Gets the status of update sources job.

        :param project_name: Name of the project. Required.
        :type project_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: QuestionAnsweringAuthoringUpdateSourcesJobState. The
         QuestionAnsweringAuthoringUpdateSourcesJobState is compatible with MutableMapping
        :rtype:
         ~azure.ai.language.questionanswering.authoring.models.QuestionAnsweringAuthoringUpdateSourcesJobState
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.QuestionAnsweringAuthoringUpdateSourcesJobState] = kwargs.pop("cls", None)

        _request = build_question_answering_authoring_get_update_sources_status_request(
            project_name=project_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.QuestionAnsweringAuthoringUpdateSourcesJobState, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_qnas(
        self,
        project_name: str,
        *,
        top: Optional[int] = None,
        skip: Optional[int] = None,
        source: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.RetrieveQnaRecord"]:
        """Gets all the QnAs of a project.

        :param project_name: Name of the project. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :keyword source: Source of the QnA. Default value is None.
        :paramtype source: str
        :return: An iterator like instance of RetrieveQnaRecord
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.ai.language.questionanswering.authoring.models.RetrieveQnaRecord]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[list[_models.RetrieveQnaRecord]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_question_answering_authoring_list_qnas_request(
                    project_name=project_name,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    source=source,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.RetrieveQnaRecord], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorResponse, response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _update_qnas_initial(
        self, project_name: str, body: Union[list[_models.UpdateQnaRecord], IO[bytes]], **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_question_answering_authoring_update_qnas_request(
            project_name=project_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update_qnas(
        self,
        project_name: str,
        body: list[_models.UpdateQnaRecord],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Updates the QnAs of a project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Update QnAs parameters of a project. Required.
        :type body: list[~azure.ai.language.questionanswering.authoring.models.UpdateQnaRecord]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_qnas(
        self, project_name: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Updates the QnAs of a project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Update QnAs parameters of a project. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update_qnas(
        self, project_name: str, body: Union[list[_models.UpdateQnaRecord], IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Updates the QnAs of a project.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Update QnAs parameters of a project. Is either a [UpdateQnaRecord] type or a
         IO[bytes] type. Required.
        :type body: list[~azure.ai.language.questionanswering.authoring.models.UpdateQnaRecord] or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_qnas_initial(
                project_name=project_name,
                body=body,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def _get_update_qnas_status(
        self, project_name: str, job_id: str, **kwargs: Any
    ) -> _models.QuestionAnsweringAuthoringUpdateQnasJobState:
        """Gets the status of update QnAs job.

        :param project_name: Name of the project. Required.
        :type project_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: QuestionAnsweringAuthoringUpdateQnasJobState. The
         QuestionAnsweringAuthoringUpdateQnasJobState is compatible with MutableMapping
        :rtype:
         ~azure.ai.language.questionanswering.authoring.models.QuestionAnsweringAuthoringUpdateQnasJobState
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.QuestionAnsweringAuthoringUpdateQnasJobState] = kwargs.pop("cls", None)

        _request = build_question_answering_authoring_get_update_qnas_status_request(
            project_name=project_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.QuestionAnsweringAuthoringUpdateQnasJobState, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def add_feedback(
        self,
        project_name: str,
        body: _models.ActiveLearningFeedback,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Update Active Learning feedback.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Feedback for Active Learning. Required.
        :type body: ~azure.ai.language.questionanswering.authoring.models.ActiveLearningFeedback
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_feedback(
        self, project_name: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update Active Learning feedback.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Feedback for Active Learning. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_feedback(
        self, project_name: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update Active Learning feedback.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Feedback for Active Learning. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_feedback(
        self, project_name: str, body: Union[_models.ActiveLearningFeedback, JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        """Update Active Learning feedback.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: Feedback for Active Learning. Is one of the following types:
         ActiveLearningFeedback, JSON, IO[bytes] Required.
        :type body: ~azure.ai.language.questionanswering.authoring.models.ActiveLearningFeedback or
         JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_question_answering_authoring_add_feedback_request(
            project_name=project_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
