#
# PySNMP MIB module DOCS-CABLE-DEVICE-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/DOCS-CABLE-DEVICE-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:09:24 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( ObjectIdentifier, Integer, OctetString, ) = mibBuilder.importSymbols("ASN1", "ObjectIdentifier", "Integer", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, SingleValueConstraint, ConstraintsUnion, ValueSizeConstraint, ValueRangeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "SingleValueConstraint", "ConstraintsUnion", "ValueSizeConstraint", "ValueRangeConstraint")
( diffServMIBCounterGroup, diffServClfrStatus, diffServMIBMultiFieldClfrGroup, diffServAlgDropStatus, diffServMIBDscpMarkActGroup, diffServClfrElementStorage, diffServDataPathStatus, diffServMIBActionGroup, diffServMultiFieldClfrDstAddr, diffServMIBDataPathGroup, diffServActionStorage, diffServClfrStorage, diffServClfrElementStatus, diffServMultiFieldClfrStorage, diffServMIBAlgDropGroup, diffServMultiFieldClfrSrcAddr, diffServMIBClfrGroup, diffServDataPathStorage, diffServAlgDropType, diffServAlgDropStorage, diffServMultiFieldClfrAddrType, diffServCountActStorage, diffServMIBClfrElementGroup, ) = mibBuilder.importSymbols("DIFFSERV-MIB", "diffServMIBCounterGroup", "diffServClfrStatus", "diffServMIBMultiFieldClfrGroup", "diffServAlgDropStatus", "diffServMIBDscpMarkActGroup", "diffServClfrElementStorage", "diffServDataPathStatus", "diffServMIBActionGroup", "diffServMultiFieldClfrDstAddr", "diffServMIBDataPathGroup", "diffServActionStorage", "diffServClfrStorage", "diffServClfrElementStatus", "diffServMultiFieldClfrStorage", "diffServMIBAlgDropGroup", "diffServMultiFieldClfrSrcAddr", "diffServMIBClfrGroup", "diffServDataPathStorage", "diffServAlgDropType", "diffServAlgDropStorage", "diffServMultiFieldClfrAddrType", "diffServCountActStorage", "diffServMIBClfrElementGroup")
( InterfaceIndexOrZero, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero")
( InetAddress, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType")
( ZeroBasedCounter32, ) = mibBuilder.importSymbols("RMON2-MIB", "ZeroBasedCounter32")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ObjectGroup, NotificationGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "NotificationGroup", "ModuleCompliance")
( mib_2, Counter64, MibIdentifier, ModuleIdentity, Unsigned32, TimeTicks, Counter32, ObjectIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, zeroDotZero, iso, Integer32, NotificationType, Bits, IpAddress, Gauge32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "mib-2", "Counter64", "MibIdentifier", "ModuleIdentity", "Unsigned32", "TimeTicks", "Counter32", "ObjectIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "zeroDotZero", "iso", "Integer32", "NotificationType", "Bits", "IpAddress", "Gauge32")
( StorageType, TextualConvention, DateAndTime, RowStatus, DisplayString, RowPointer, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "StorageType", "TextualConvention", "DateAndTime", "RowStatus", "DisplayString", "RowPointer", "TruthValue")
docsDev = ModuleIdentity((1, 3, 6, 1, 2, 1, 69)).setRevisions(("2006-12-20 00:00", "1999-08-19 00:00",))
if mibBuilder.loadTexts: docsDev.setLastUpdated('200612200000Z')
if mibBuilder.loadTexts: docsDev.setOrganization('IETF IP over Cable Data Network\n                         Working Group')
if mibBuilder.loadTexts: docsDev.setContactInfo('        Rich Woundy\n             Postal: Comcast Cable\n                     27 Industrial Avenue\n                     Chelmsford, MA 01824 U.S.A.\n             Phone:  +1 978 244 4010\n             E-mail: richard_woundy@cable.comcast.com\n\n                     Kevin Marez\n             Postal: Motorola Corporation\n                     6450 Sequence Drive\n                     San Diego, CA 92121 U.S.A.\n             Phone:  +1 858 404 3785\n             E-mail: kevin.marez@motorola.com\n\n             IETF IPCDN Working Group\n             General Discussion: ipcdn@ietf.org\n             Subscribe: http://www.ietf.org/mailman/listinfo/ipcdn\n             Archive: ftp://ftp.ietf.org/ietf-mail-archive/ipcdn\n             Co-chairs: Richard Woundy,\n                        richard_woundy@cable.comcast.com\n                        Jean-Francois Mule,\n                        jf.mule@cablelabs.com')
if mibBuilder.loadTexts: docsDev.setDescription('This is the MIB Module for DOCSIS-compliant cable modems\n\n             and cable-modem termination systems.\n\n             Copyright (C) The IETF Trust (2006).  This version\n             of this MIB module was published in RFC 4639; for full\n             legal notices see the RFC itself.')
docsDevMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 69, 1))
docsDevBase = MibIdentifier((1, 3, 6, 1, 2, 1, 69, 1, 1))
docsDevRole = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("cm", 1), ("cmtsActive", 2), ("cmtsBackup", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevRole.setDescription("Defines the current role of this device.  cm(1) is a\n             Cable Modem, cmtsActive(2) is a Cable Modem Termination\n             System that is controlling the system of cable modems,\n             and cmtsBackup(3) is a CMTS that is currently connected\n             but is not controlling the system (not currently used).\n\n             In general, if this device is a 'cm', its role will not\n             change during operation or between reboots.  If the\n             device is a 'cmts' it may change between cmtsActive and\n             cmtsBackup and back again during normal operation.  NB:\n             At this time, the DOCSIS standards do not support the\n             concept of a backup CMTS, but cmtsBackup is included for\n             completeness.")
docsDevDateTime = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 1, 2), DateAndTime()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevDateTime.setDescription("The current date and time, with time zone information\n             (if known).\n\n             If the real data and time cannot be determined, this\n             shall represent elapsed time from boot relative to\n             the standard epoch '1970-1-1,0:0:0.0'.  In other\n             words, if this agent has been up for 3 minutes and\n             not been able to determine what the actual date and\n             time are, this object will return the value\n             '1970-1-1,0:03:0.0'.")
docsDevResetNow = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 1, 3), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevResetNow.setDescription('Setting this object to true(1) causes the device to\n             reset.  Reading this object always returns false(2).')
docsDevSerialNumber = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 1, 4), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevSerialNumber.setDescription("The manufacturer's serial number for this device.")
docsDevSTPControl = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("stEnabled", 1), ("noStFilterBpdu", 2), ("noStPassBpdu", 3),)).clone('noStFilterBpdu')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevSTPControl.setDescription('This object controls operation of the spanning tree\n             protocol (as distinguished from transparent bridging).\n\n             If set to stEnabled(1), then the spanning tree protocol\n             is enabled, subject to bridging constraints.\n\n             If noStFilterBpdu(2), then spanning tree is not active,\n             and Bridge PDUs received are discarded.\n\n             If noStPassBpdu(3), then spanning tree is not active,\n             and Bridge PDUs are transparently forwarded.\n\n             Note that a device need not implement all of these\n             options, but that noStFilterBpdu(2) is required.')
docsDevIgmpModeControl = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("passive", 1), ("active", 2),)).clone('passive')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevIgmpModeControl.setDescription('This object controls the IGMP mode of operation for\n             the CM or CMTS.  In passive mode, the device forwards\n             IGMP between interfaces as based on knowledge of\n             Multicast Session activity on the subscriber side\n             interface and the rules defined in the DOCSIS RFI\n             specification.  In active mode, the device terminates\n             at and initiates IGMP through its interfaces as based\n             on the knowledge of Multicast Session activity on the\n             subscriber side interface.')
docsDevMaxCpe = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 1, 7), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setUnits('CPEs').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevMaxCpe.setDescription('The maximum number of CPEs that can be granted access\n             through a CM during a CM epoch.  This value can be\n             obtained from the CM configuration file; however,\n             it may be adjusted by the CM according to hardware or\n             software limitations that have been imposed on the\n             implementation.')
docsDevNmAccessTable = MibTable((1, 3, 6, 1, 2, 1, 69, 1, 2), )
if mibBuilder.loadTexts: docsDevNmAccessTable.setDescription('This table controls access to SNMP objects by network\n             management stations.  If the table is empty, access to\n             SNMP objects is unrestricted.  The objects in this table\n             MUST NOT persist across reboots.  The objects in this\n             table are only accessible from cable devices that are\n             not capable of operating in SNMP Coexistence mode\n             (RFC 3584) or in SNMPv3 mode (RFC 3410).\n             See the conformance section for\n             details.  Note that some devices are required by other\n             specifications (e.g., the DOCSIS OSSIv1.1 specification)\n             to support the legacy SNMPv1/v2c docsDevNmAccess mode\n             for backward compatibility.\n\n             This table is deprecated.  Instead, use the SNMP\n             coexistence MIBs from RFC 3584, the TARGET and\n             NOTIFICATION MIBs from RFC 3413, and\n             the View-Based Access Control Model (VACM) MIBs for\n             all SNMP protocol versions from RFC 3415.')
docsDevNmAccessEntry = MibTableRow((1, 3, 6, 1, 2, 1, 69, 1, 2, 1), ).setIndexNames((0, "DOCS-CABLE-DEVICE-MIB", "docsDevNmAccessIndex"))
if mibBuilder.loadTexts: docsDevNmAccessEntry.setDescription('An entry describing access to SNMP objects by a\n             particular network management station.  An entry in\n             this table is not readable unless the management station\n             has read-write permission (either implicit if the table\n             is empty, or explicit through an entry in this table).\n             Entries are ordered by docsDevNmAccessIndex.  The first\n\n             matching entry (e.g., matching IP address and community\n             string) is used to derive access.')
docsDevNmAccessIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)))
if mibBuilder.loadTexts: docsDevNmAccessIndex.setDescription('Index used to order the application of access\n             entries.')
docsDevNmAccessIp = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 2, 1, 2), IpAddress().clone(hexValue="00000000")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevNmAccessIp.setDescription('The IP address (or subnet) of the network management\n             station.  The address 0.0.0.0 is defined to mean\n             any Network Management Station (NMS).  If traps are\n             enabled for this entry, then the value must be the\n             address of a specific device.  Implementations MAY\n             recognize 255.255.255.255 as equivalent to 0.0.0.0.')
docsDevNmAccessIpMask = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 2, 1, 3), IpAddress().clone(hexValue="00000000")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevNmAccessIpMask.setDescription('The IP subnet mask of the network management stations.\n             If traps are enabled for this entry, then the value must\n             be 0.0.0.0.  Implementations MAY recognize\n             255.255.255.255 as equivalent to 0.0.0.0.')
docsDevNmAccessCommunity = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 2, 1, 4), OctetString().clone('public')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevNmAccessCommunity.setDescription('The community string to be matched for access by this\n             entry.  If set to a zero-length string, then any\n             community string will match.  When read, this object\n             SHOULD return a zero-length string.')
docsDevNmAccessControl = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 2, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6,))).clone(namedValues=NamedValues(("none", 1), ("read", 2), ("readWrite", 3), ("roWithTraps", 4), ("rwWithTraps", 5), ("trapsOnly", 6),)).clone('read')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevNmAccessControl.setDescription("Specifies the type of access allowed to this NMS.\n             Setting this object to none(1) causes the table entry\n             to be destroyed.  Read(2) allows access by 'get' and\n             'get-next' PDUs.  ReadWrite(3) allows access by 'set' as\n             well.  RoWithtraps(4), rwWithTraps(5), and trapsOnly(6)\n             control distribution of Trap PDUs transmitted by this\n             device.")
docsDevNmAccessInterfaces = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 2, 1, 6), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1,32))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevNmAccessInterfaces.setDescription("Specifies the set of interfaces from which requests from\n             this NMS will be accepted.  Each octet within\n             the value of this object specifies a set of eight\n\n             interfaces, the first octet specifying ports 1\n             through 8, the second octet specifying interfaces 9\n             through 16, etc.  Within each octet, the most\n             significant bit represents the lowest numbered\n             interface, and the least significant bit represents the\n             highest numbered interface.  Thus, each interface is\n             represented by a single bit within the value of this\n             object.  If that bit has a value of '1' then that\n             interface is included in the set.\n\n             Note that entries in this table apply only to link-layer\n             interfaces (e.g., Ethernet and CATV MAC).  Bits\n             representing upstream and downstream channel interfaces\n             MUST NOT be set to '1'.\n\n             Note that if bits corresponding to non-existing\n             interfaces are set, the result is implementation\n             specific.\n\n             Note that according to the DOCSIS OSSIv1.1\n             specification, when ifIndex '1' is included in the\n             set, then this row applies to all CPE\n             (customer-facing) interfaces.\n\n             The size of this object is the minimum required to\n             represent all configured interfaces for this device.")
docsDevNmAccessStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 2, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevNmAccessStatus.setDescription('Controls and reflects the status of rows in this\n             table.  Rows in this table may be created by either the\n             create-and-go or create-and-wait paradigm.  There is no\n             restriction on changing values in a row of this table\n             while the row is active.\n\n             The following objects MUST have valid values before this\n             object can be set to active: docsDevNmAccessIp,\n             docsDevNmAccessStatus, docsDevNmAccessIpMask,\n             docsDevNmAccessCommunity, docsDevNmAccessControl, and\n             docsDevNmAccessInterfaces.')
docsDevNmAccessTrapVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 2, 1, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("disableSNMPv2trap", 1), ("enableSNMPv2trap", 2),)).clone('disableSNMPv2trap')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevNmAccessTrapVersion.setDescription('Specifies the TRAP version that is sent to this NMS.\n             Setting this object to disableSNMPv2trap (1) causes the\n             trap in SNMPv1 format to be sent to a particular NMS.\n             Setting this object to enableSNMPv2trap (2) causes the\n             trap in SNMPv2 format be sent to a particular NMS.')
docsDevSoftware = MibIdentifier((1, 3, 6, 1, 2, 1, 69, 1, 3))
docsDevSwServer = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 3, 1), IpAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevSwServer.setDescription('The address of the TFTP server used for software\n             upgrades.  If the TFTP server is unknown or is a\n             non-IPv4 address, return 0.0.0.0.\n\n             This object is deprecated.  See docsDevSwServerAddress\n             for its replacement.  This object will have its value\n             modified, given a valid SET to docsDevSwServerAddress.')
docsDevSwFilename = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 3, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,64))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevSwFilename.setDescription('The filename of the software image to be downloaded via\n             TFTP, or the abs_path (as defined in RFC 2616) of the\n             software image to be downloaded via HTTP.\n\n             Unless set via SNMP, this is the filename or abs_path\n             specified by the provisioning server during the boot\n             process that corresponds to the software version that\n\n             is desired for this device.\n\n             If unknown, the value of this object is the zero-length\n             string.')
docsDevSwAdminStatus = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 3, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("upgradeFromMgt", 1), ("allowProvisioningUpgrade", 2), ("ignoreProvisioningUpgrade", 3),)).clone('allowProvisioningUpgrade')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevSwAdminStatus.setDescription('If set to upgradeFromMgt(1), the device will initiate a\n             TFTP or HTTP software image download.  After\n             successfully receiving an image, the device will set\n             its state to ignoreProvisioningUpgrade(3) and reboot.\n             If the download process is interrupted (e.g., by a reset\n             or power failure), the device will load the previous\n             image and, after re-initialization, continue to attempt\n             loading the image specified in docsDevSwFilename.\n\n             If set to allowProvisioningUpgrade(2), the device will\n             use the software version information supplied by the\n             provisioning server when next rebooting (this does not\n             cause a reboot).\n\n             When set to ignoreProvisioningUpgrade(3), the device\n             will disregard software image upgrade information\n             from the provisioning server.\n\n             Note that reading this object can return\n             upgradeFromMgt(1).  This indicates that a software\n             download is currently in progress, and that the device\n             will reboot after successfully receiving an image.')
docsDevSwOperStatus = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 3, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("inProgress", 1), ("completeFromProvisioning", 2), ("completeFromMgt", 3), ("failed", 4), ("other", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevSwOperStatus.setDescription('InProgress(1) indicates that a TFTP or HTTP download is\n             underway, either as a result of a version mismatch at\n             provisioning or as a result of a upgradeFromMgt request.\n             No other docsDevSw* objects can be modified in\n             this state.\n\n             CompleteFromProvisioning(2) indicates that the last\n             software upgrade was a result of version mismatch at\n             provisioning.\n\n             CompleteFromMgt(3) indicates that the last software\n             upgrade was a result of setting docsDevSwAdminStatus to\n             upgradeFromMgt.\n\n             Failed(4) indicates that the last attempted download\n             failed, ordinarily due to TFTP or HTTP timeout.')
docsDevSwCurrentVers = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 3, 5), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevSwCurrentVers.setDescription("The software version currently operating in this device.\n             This string's syntax is that used by the\n             individual vendor to identify software versions.\n             For a CM, this string will describe the current\n             software load.  For a CMTS, this object SHOULD contain\n             a human-readable representation either of the vendor\n             specific designation of the software for the chassis,\n             or of the software for the control processor.  If\n             neither of these is applicable, the value MUST be a\n             zero-length string.")
docsDevSwServerAddressType = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 3, 6), InetAddressType()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevSwServerAddressType.setDescription('The type of address of the TFTP or HTTP server used for\n\n             software upgrades.\n\n             If docsDevSwServerTransportProtocol is currently set to\n             tftp(1), attempting to set this object to dns(16) MUST\n             result in an error.')
docsDevSwServerAddress = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 3, 7), InetAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevSwServerAddress.setDescription('The address of the TFTP or HTTP server used for software\n             upgrades.\n\n             If the TFTP/HTTP server is unknown, return the zero-\n             length address string (see the TextualConvention).\n\n             If docsDevSwServer is also implemented in this agent,\n             this object is tied to it.  A set of this object to an\n             IPv4 address will result in also setting the value of\n             docsDevSwServer to that address.  If this object is set\n             to an IPv6 address, docsDevSwServer is set to 0.0.0.0.\n             If docsDevSwServer is set, this object is also set to\n             that value.  Note that if both are set in the same\n             action, the order of which one sets the other is\n             undefined.')
docsDevSwServerTransportProtocol = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 3, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("tftp", 1), ("http", 2),)).clone('tftp')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevSwServerTransportProtocol.setDescription('This object specifies the transport protocol (TFTP or\n             HTTP) to be used for software upgrades.\n\n             If the value of this object is tftp(1), then the cable\n             device uses TFTP (RFC 1350) read request packets to\n             download the docsDevSwFilename from the\n             docsDevSwServerAddress in octet mode.\n\n             If the value of this object is http(2), then the cable\n             device uses HTTP 1.0 (RFC 1945) or HTTP 1.1 (RFC 2616)\n             GET requests sent to host docsDevSwServerAddress to\n\n             download the software image from path docsDevSwFilename.\n\n             If docsDevSwServerAddressType is currently set to\n             dns(16), attempting to set this object to tftp(1) MUST\n             result in an error.')
docsDevServer = MibIdentifier((1, 3, 6, 1, 2, 1, 69, 1, 4))
docsDevServerBootState = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 4, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8, 9, 10,))).clone(namedValues=NamedValues(("operational", 1), ("disabled", 2), ("waitingForDhcpOffer", 3), ("waitingForDhcpResponse", 4), ("waitingForTimeServer", 5), ("waitingForTftp", 6), ("refusedByCmts", 7), ("forwardingDenied", 8), ("other", 9), ("unknown", 10),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevServerBootState.setDescription('If operational(1), the device has completed loading and\n             processing of configuration parameters, and the CMTS has\n             completed the Registration exchange.\n\n             If disabled(2), then the device was administratively\n             disabled, possibly by being refused network access in\n             the configuration file.\n\n             If waitingForDhcpOffer(3), then a Dynamic Host\n             Configuration Protocol (DHCP) Discover has been\n             transmitted, and no offer has yet been received.\n\n             If waitingForDhcpResponse(4), then a DHCP Request has\n             been transmitted, and no response has yet been received.\n\n             If waitingForTimeServer(5), then a Time Request has been\n             transmitted, and no response has yet been received.\n\n             If waitingForTftp(6), then a request to the TFTP\n             parameter server has been made, and no response\n             received.\n\n             If refusedByCmts(7), then the Registration\n             Request/Response exchange with the CMTS failed.\n\n             If forwardingDenied(8), then the registration process\n             was completed, but the network access option in the\n             received configuration file prohibits forwarding.\n\n             If other(9), then the registration process reached a\n             point that does not fall into one of the above\n             categories.\n\n             If unknown(10), then the device has not yet begun the\n             registration process or is in some other indeterminate\n             state.')
docsDevServerDhcp = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 4, 2), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevServerDhcp.setDescription('The IP address of the DHCP server that assigned an IP\n             address to this device.  Returns 0.0.0.0 if DHCP is not\n             used for IP address assignment, or if this agent is\n             not assigned an IPv4 address.\n\n             This object is deprecated and is replaced by\n             docsDevServerDhcpAddress.')
docsDevServerTime = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 4, 3), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevServerTime.setDescription('The IP address of the Time server (RFC 0868).  Returns\n             0.0.0.0 if the time server IP address is unknown, or if\n             the time server is not an IPv4 server.\n\n             This object is deprecated and is replaced by\n\n             docsDevServerTimeAddress.')
docsDevServerTftp = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 4, 4), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevServerTftp.setDescription('The IP address of the TFTP server responsible for\n             downloading provisioning and configuration parameters\n             to this device.  Returns 0.0.0.0 if the TFTP server\n             address is unknown or is not an IPv4 address.\n\n             This object is deprecated and is replaced by\n             docsDevServerConfigTftpAddress.')
docsDevServerConfigFile = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 4, 5), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevServerConfigFile.setDescription('The name of the device configuration file read from\n             the TFTP server.  Returns a zero-length string if\n             the configuration file name is unknown.')
docsDevServerDhcpAddressType = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 4, 6), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevServerDhcpAddressType.setDescription('The type of address of docsDevServerDhcpAddress.  If\n             DHCP was not used, this value should return\n             unknown(0).')
docsDevServerDhcpAddress = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 4, 7), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevServerDhcpAddress.setDescription('The internet address of the DHCP server that assigned\n             an IP address to this device.  Returns the zero length\n             octet string if DHCP was not used for IP address\n             assignment.')
docsDevServerTimeAddressType = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 4, 8), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevServerTimeAddressType.setDescription('The type of address of docsDevServerTimeAddress.  If\n             no time server exists, this value should return\n             unknown(0).')
docsDevServerTimeAddress = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 4, 9), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevServerTimeAddress.setDescription('The Internet address of the RFC 868 Time server,\n             as provided by DHCP option 4.\n\n             Note that if multiple values are provided to the\n             CM in DHCP option 4, the value of this MIB object\n             MUST be the Time server address from which the Time\n             of Day reference was acquired as based on the DOCSIS\n             RFI specification.  During the period of time where\n             the Time of Day have not been acquired, the Time\n             server address reported by the CM may report the\n             first address value in the DHCP option value or the\n             last server address the CM attempted to get the Time\n             of day value.\n\n             Returns the zero-length octet string if the time server\n             IP address is not provisioned.')
docsDevServerConfigTftpAddressType = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 4, 10), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevServerConfigTftpAddressType.setDescription('The type of address of docsDevServerConfigTftpAddress.\n             If no TFTP server exists, this value should return\n             unknown(0).')
docsDevServerConfigTftpAddress = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 4, 11), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevServerConfigTftpAddress.setDescription('The internet address of the TFTP server responsible for\n             downloading provisioning and configuration parameters\n             to this device.  Returns the zero-length octet string if\n             the config server address is unknown.  There are certain\n             security risks that are involved with using TFTP.')
docsDevEvent = MibIdentifier((1, 3, 6, 1, 2, 1, 69, 1, 5))
docsDevEvControl = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 5, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("resetLog", 1), ("useDefaultReporting", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevEvControl.setDescription('Setting this object to resetLog(1) empties the event\n             log.  All data is deleted.  Setting it to\n             useDefaultReporting(2) returns all event priorities to\n             their factory-default reporting.  Reading this object\n             always returns useDefaultReporting(2).')
docsDevEvSyslog = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 5, 2), IpAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevEvSyslog.setDescription('The IP address of the Syslog server.  If 0.0.0.0, either\n             syslog transmission is inhibited, or the Syslog server\n             address is not an IPv4 address.\n\n             This object is deprecated and is replaced by\n             docsDevEvSyslogAddress.')
docsDevEvThrottleAdminStatus = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 5, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("unconstrained", 1), ("maintainBelowThreshold", 2), ("stopAtThreshold", 3), ("inhibited", 4),)).clone('unconstrained')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevEvThrottleAdminStatus.setDescription('Controls the transmission of traps and syslog messages\n             with respect to the trap pacing threshold.\n\n             unconstrained(1) causes traps and syslog messages to be\n             transmitted without regard to the threshold settings.\n\n             maintainBelowThreshold(2) causes trap transmission and\n             syslog messages to be suppressed if the number of traps\n             would otherwise exceed the threshold.\n\n             stopAtThreshold(3) causes trap transmission to cease at\n             the threshold and not to resume until directed to do so.\n\n             inhibited(4) causes all trap transmission and syslog\n             messages to be suppressed.\n\n             A single event is always treated as a single event for\n             threshold counting.  That is, an event causing both a\n             trap and a syslog message is still treated as a single\n             event.\n\n             Writing to this object resets the thresholding state.')
docsDevEvThrottleInhibited = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 5, 4), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevEvThrottleInhibited.setDescription('If true(1), trap and syslog transmission is currently\n             inhibited due to thresholds and/or the current setting\n             of docsDevEvThrottleAdminStatus.  In addition, this is\n             true(1) when transmission is inhibited because no\n             syslog (docsDevEvSyslog) or trap (docsDevNmAccessEntry)\n             destinations have been set.\n\n             This object is deprecated and is replaced by\n             docsDevEvThrottleThresholdExceeded.')
docsDevEvThrottleThreshold = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 5, 5), Unsigned32()).setUnits('events').setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevEvThrottleThreshold.setDescription('Number of events per docsDevEvThrottleInterval permitted\n             before throttling is to occur.\n\n             A single event, whether the notification could result in\n             messages transmitted using syslog, SNMP, or both\n             protocols, and regardless of the number of destinations,\n             (including zero) is always treated as a single event for\n             threshold counting.  For example, an event causing both\n             a trap and a syslog message is still treated as a single\n             event.\n\n             All system notifications that occur within the device\n             should be taken into consideration when calculating\n             and monitoring the threshold.')
docsDevEvThrottleInterval = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 5, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)).clone(1)).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevEvThrottleInterval.setDescription('The interval over which docsDevEvThrottleThreshold\n             applies.')
docsDevEvControlTable = MibTable((1, 3, 6, 1, 2, 1, 69, 1, 5, 7), )
if mibBuilder.loadTexts: docsDevEvControlTable.setDescription('This table allows control of the reporting of event\n             classes.  For each event priority, a combination of\n\n             logging and reporting mechanisms may be chosen.  The\n             mapping of event types to priorities is\n             vendor dependent.  Vendors may also choose to allow\n             the user to control that mapping through proprietary\n             means.  Table entries MUST persist across reboots for\n             CMTS devices and MUST NOT persist across reboots for CM\n             devices.')
docsDevEvControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 69, 1, 5, 7, 1), ).setIndexNames((0, "DOCS-CABLE-DEVICE-MIB", "docsDevEvPriority"))
if mibBuilder.loadTexts: docsDevEvControlEntry.setDescription('Allows configuration of the reporting mechanisms for a\n             particular event priority.')
docsDevEvPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 5, 7, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8,))).clone(namedValues=NamedValues(("emergency", 1), ("alert", 2), ("critical", 3), ("error", 4), ("warning", 5), ("notice", 6), ("information", 7), ("debug", 8),)))
if mibBuilder.loadTexts: docsDevEvPriority.setDescription('The priority level that is controlled by this\n             entry.  These are ordered from most (emergency) to least\n             (debug) critical.  Each event with a CM or CMTS has a\n             particular priority level associated with it (as defined\n             by the vendor).\n\n             emergency(1) events indicate vendor-specific fatal\n             hardware or software errors that prevent normal system\n             operation.\n\n             alert(2) events indicate a serious failure that causes\n             the reporting system to reboot but is not caused by\n             hardware or software malfunctioning.\n\n             critical(3) events indicate a serious failure that\n             requires attention and prevents the device from\n             transmitting data but that could be recovered without\n             rebooting the system.\n\n             error(4) and warning(5) events indicate that a failure\n             occurred that could interrupt the normal data flow but\n             that does not cause the device to re-register.\n\n             notice(6) and information(7) events indicate a\n             milestone or checkpoint in normal operation that could\n             be of particular importance for troubleshooting.\n\n             debug(8) events are reserved for vendor-specific\n             events.\n\n             During normal operation, no event more\n             critical than notice(6) should be generated.  Events\n             between warning and emergency should be generated at\n             appropriate levels of problems (e.g., emergency when the\n             box is about to crash).')
docsDevEvReporting = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 5, 7, 1, 2), Bits().clone(namedValues=NamedValues(("local", 0), ("traps", 1), ("syslog", 2), ("localVolatile", 8), ("stdInterface", 9),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevEvReporting.setDescription('Defines the action to be taken on occurrence of this\n             event class.  Implementations may not necessarily\n             support all options for all event classes but at\n             minimum must allow traps and syslogging to be\n             disabled.\n\n             If the local(0) bit is set, then log to the internal\n             log and update non-volatile store, for backward\n             compatibility with the original RFC 2669 definition.\n             If the traps(1) bit is set, then generate\n             an SNMP trap; if the syslog(2) bit is set, then\n             send a syslog message (assuming that the syslog address\n             is set).  If the localVolatile(8) bit is set, then\n             log to the internal log without updating non-volatile\n             store.  If the stdInterface(9) bit is set, then the\n             agent ignores all other bits except the local(0),\n             syslog(2), and localVolatile(8) bits.  Setting the\n             stdInterface(9) bit indicates that RFC3413 and\n             RFC3014 are being used to control event reporting\n             mechanisms.')
docsDevEventTable = MibTable((1, 3, 6, 1, 2, 1, 69, 1, 5, 8), )
if mibBuilder.loadTexts: docsDevEventTable.setDescription('Contains a log of network and device events that may be\n             of interest in fault isolation and troubleshooting.\n             If the local(0) bit is set in docsDevEvReporting,\n             entries in this table MUST persist across reboots.')
docsDevEventEntry = MibTableRow((1, 3, 6, 1, 2, 1, 69, 1, 5, 8, 1), ).setIndexNames((0, "DOCS-CABLE-DEVICE-MIB", "docsDevEvIndex"))
if mibBuilder.loadTexts: docsDevEventEntry.setDescription('Describes a network or device event that may be of\n             interest in fault isolation and troubleshooting.\n             Multiple sequential identical events are represented by\n             incrementing docsDevEvCounts and setting\n             docsDevEvLastTime to the current time rather than\n             creating multiple rows.\n\n             Entries are created with the first occurrence of an\n             event.  docsDevEvControl can be used to clear the\n             table.  Individual events cannot be deleted.')
docsDevEvIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 5, 8, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)))
if mibBuilder.loadTexts: docsDevEvIndex.setDescription('Provides relative ordering of the objects in the event\n             log.  This object will always increase except when\n             (a) the log is reset via docsDevEvControl,\n             (b) the device reboots and does not implement\n             non-volatile storage for this log, or (c) it reaches\n             the value 2^31.  The next entry for all the above\n             cases is 1.')
docsDevEvFirstTime = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 5, 8, 1, 2), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevEvFirstTime.setDescription('The value of docsDevDateTime at the time this entry was\n             created.')
docsDevEvLastTime = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 5, 8, 1, 3), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevEvLastTime.setDescription('When an entry reports only one event, this object will\n             have the same value as the corresponding instance of\n             docsDevEvFirstTime.  When an entry reports multiple\n             events, this object will record the value that\n             docsDevDateTime had when the most recent event for this\n             entry occurred.')
docsDevEvCounts = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 5, 8, 1, 4), Counter32()).setUnits('events').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevEvCounts.setDescription('The number of consecutive event instances reported by\n             this entry.  This starts at 1 with the creation of this\n             row and increments by 1 for each subsequent duplicate\n             event.')
docsDevEvLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 5, 8, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8,))).clone(namedValues=NamedValues(("emergency", 1), ("alert", 2), ("critical", 3), ("error", 4), ("warning", 5), ("notice", 6), ("information", 7), ("debug", 8),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevEvLevel.setDescription('The priority level of this event, as defined by the\n             vendor.  These are ordered from most serious (emergency)\n             to least serious (debug).\n\n             emergency(1) events indicate vendor-specific fatal\n             hardware or software errors that prevent normal system\n             operation.\n\n             alert(2) events indicate a serious failure that causes\n             the reporting system to reboot but that is not caused by\n             hardware or software malfunctioning.\n\n             critical(3) events indicate a serious failure that\n             requires attention and prevents the device from\n             transmitting data but that could be recovered without\n             rebooting the system.\n\n             error(4) and warning(5) events indicate that a failure\n             occurred that could interrupt the normal data flow but\n             that does not cause the device to re-register.\n\n             notice(6) and information(7) events indicate a\n             milestone or checkpoint in normal operation that could\n             be of particular importance for troubleshooting.\n\n             debug(8) events are reserved for vendor-specific\n\n             events.\n\n             During normal operation, no event more\n             critical than notice(6) should be generated.  Events\n             between warning and emergency should be generated at\n             appropriate levels of problems (e.g., emergency when the\n             box is about to crash).')
docsDevEvId = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 5, 8, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevEvId.setDescription('For this product, uniquely identifies the type of event\n             that is reported by this entry.')
docsDevEvText = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 5, 8, 1, 7), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevEvText.setDescription('Provides a human-readable description of the event,\n             including all relevant context (interface numbers,\n             etc.).')
docsDevEvSyslogAddressType = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 5, 9), InetAddressType().clone('unknown')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevEvSyslogAddressType.setDescription('The type of address of docsDevEvSyslogAddress.  If\n             no syslog server exists, this value should return\n             unknown(0).')
docsDevEvSyslogAddress = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 5, 10), InetAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevEvSyslogAddress.setDescription('The Internet address of the Syslog server, as provided\n             by DHCP option 7 or set via SNMP management.  If the\n             address of the server is set to the zero-length\n             string, the 0.0.0.0 IPv4 address, or the 0: IPv6\n             address, Syslog transmission is inhibited.\n\n             Note that if multiple values are provided to the CM in\n             DHCP option 7, the value of this MIB object MUST be the\n             first Syslog server address received.\n\n             By default at agent boot, this object returns the zero\n             length string.')
docsDevEvThrottleThresholdExceeded = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 5, 11), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevEvThrottleThresholdExceeded.setDescription('If true(1), trap and syslog transmission is currently\n             inhibited due to exceeding the trap/syslog event\n             threshold in the current interval.')
docsDevFilter = MibIdentifier((1, 3, 6, 1, 2, 1, 69, 1, 6))
docsDevFilterLLCUnmatchedAction = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 6, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("discard", 1), ("accept", 2),)).clone('accept')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevFilterLLCUnmatchedAction.setDescription('LLC (Link Level Control) filters can be defined on an\n             inclusive or exclusive basis: CMs can be configured to\n             forward only packets matching a set of layer three\n             protocols, or to drop packets matching a set of layer\n             three protocols.  Typical use of these filters is to\n\n             filter out possibly harmful (given the context of a\n             large metropolitan LAN) protocols.\n\n             If set to discard(1), any L2 packet that does not match\n             at least one filter in the docsDevFilterLLCTable will be\n             discarded.  If set to accept(2), any L2 packet that\n             does not match at least one filter in the\n             docsDevFilterLLCTable will be accepted for further\n             processing (e.g., bridging).  In other words, if the\n             packet does not match an entry in the table, it takes\n             this action; if it does match an entry in the table, it\n             takes the opposite of this action.')
docsDevFilterLLCTable = MibTable((1, 3, 6, 1, 2, 1, 69, 1, 6, 2), )
if mibBuilder.loadTexts: docsDevFilterLLCTable.setDescription('A list of filters to apply to (bridged) LLC\n             traffic.  The filters in this table are applied to\n             incoming traffic on the appropriate interface(s)  prior\n             to any further processing (e.g., before the packet\n             is handed off for level 3 processing, or for bridging).\n             The specific action taken when no filter is matched is\n             controlled by docsDevFilterLLCUnmatchedAction.  Table\n             entries MUST NOT persist across reboots for any device.')
docsDevFilterLLCEntry = MibTableRow((1, 3, 6, 1, 2, 1, 69, 1, 6, 2, 1), ).setIndexNames((0, "DOCS-CABLE-DEVICE-MIB", "docsDevFilterLLCIndex"))
if mibBuilder.loadTexts: docsDevFilterLLCEntry.setDescription('Describes a single filter to apply to (bridged) LLC\n             traffic received on a specified interface. ')
docsDevFilterLLCIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)))
if mibBuilder.loadTexts: docsDevFilterLLCIndex.setDescription('Index used for the identification of filters (note that\n             LLC filter order is irrelevant).')
docsDevFilterLLCStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 2, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterLLCStatus.setDescription('Controls and reflects the status of rows in this\n             table.  There is no restriction on changing any of the\n             associated columns for this row while this object is set\n             to active.\n\n             Specifying only this object (with the\n             appropriate index) on a CM is sufficient to create a\n             filter row that matches all inbound packets on the\n             ethernet interface and results in the packets being\n             discarded.  docsDevFilterLLCIfIndex (at least) must be\n             specified on a CMTS to create a row.')
docsDevFilterLLCIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 2, 1, 3), InterfaceIndexOrZero()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterLLCIfIndex.setDescription("The entry interface to which this filter applies.  The\n             value corresponds to ifIndex for either a CATV MAC or\n             another network interface.  If the value is zero, the\n             filter applies to all interfaces.  In Cable Modems, the\n             default value is the customer side interface(s).  In\n             CMTSs, this object has to be specified to\n             create a row in this table.\n\n             Note that according to the DOCSIS OSSIv1.1\n             specification, ifIndex '1' in the CM means that this\n             row applies to all Cable Modem-to-CPE Interfaces\n             (CMCI).")
docsDevFilterLLCProtocolType = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 2, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("ethertype", 1), ("dsap", 2),)).clone('ethertype')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterLLCProtocolType.setDescription('The format of the value in docsDevFilterLLCProtocol:\n             either a two-byte Ethernet Ethertype, or a one-byte\n             802.2 Service Access Point (SAP) value.  ethertype(1)\n             also applies to Standard Network Access Protocol\n             (SNAP) encapsulated frames.')
docsDevFilterLLCProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 2, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterLLCProtocol.setDescription('The layer-three protocol for which this filter applies.\n             The protocol value format depends on\n             docsDevFilterLLCProtocolType.  Note that for SNAP\n             frames, ethertype filtering is performed rather than\n             Destination Service Access Point (DSAP) =0xAA.')
docsDevFilterLLCMatches = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 2, 1, 6), Counter32()).setUnits('matches').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevFilterLLCMatches.setDescription('Counts the number of times this filter was matched.')
docsDevFilterIpDefault = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 6, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("discard", 1), ("accept", 2),)).clone('accept')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevFilterIpDefault.setDescription('The default behavior for (bridged) packets that do not\n             match IP filters (or Internet filters, if implemented)\n             is defined by docsDevFilterIpDefault.\n\n             If set to discard(1), all packets not matching an IP\n             filter in docsDevFilterIpTable will be discarded.  If\n             set to accept(2), all packets not matching an IP filter\n             or an Internet filter will be accepted for further\n             processing (e.g., bridging).')
docsDevFilterIpTable = MibTable((1, 3, 6, 1, 2, 1, 69, 1, 6, 4), )
if mibBuilder.loadTexts: docsDevFilterIpTable.setDescription('An ordered list of filters or classifiers to apply to\n             IP traffic.  Filter application is ordered by the filter\n             index, rather than by a best match algorithm (note that\n             this implies that the filter table may have gaps in the\n             index values).  Packets that match no filters will have\n             policy 0 in the docsDevFilterPolicyTable applied to\n             them, if it exists.  Otherwise, Packets that match no\n             filters are discarded or forwarded according to the\n             setting of docsDevFilterIpDefault.\n\n             Any IP packet can theoretically match multiple rows of\n             this table.  When considering a packet, the table is\n             scanned in row index order (e.g., filter 10 is checked\n             before filter 20).  If the packet matches that filter\n             (which means that it matches ALL criteria for that row),\n             actions appropriate to docsDevFilterIpControl and\n             docsDevFilterPolicyId are taken.  If the packet was\n             discarded processing is complete.  If\n             docsDevFilterIpContinue is set to true, the filter\n             comparison continues with the next row in the table,\n             looking for additional matches.\n\n             If the packet matches no filter in the table, the packet\n             is accepted or dropped for further processing\n             according to the setting of docsDevFilterIpDefault.\n             If the packet is accepted, the actions specified by\n             policy group 0 (e.g., the rows in\n             docsDevFilterPolicyTable that have a value of 0 for\n             docsDevFilterPolicyId) are taken, if that policy\n\n             group exists.\n\n             Logically, this table is consulted twice during the\n             processing of any IP packet: once upon its acceptance\n             from the L2 entity, and once upon its transmission to\n             the L2 entity.  In actuality, for cable modems, IP\n             filtering is generally the only IP processing done for\n             transit traffic.  This means that inbound and outbound\n             filtering can generally be done at the same time with\n             one pass through the filter table.\n\n             The objects in this table are only accessible from cable\n             devices that are not operating in DiffServ MIB mode\n             (RFC 3289).  See the conformance section for details.\n\n             Note that some devices are required by other\n             specifications (e.g., the DOCSIS OSSIv1.1 specification)\n             to support the legacy SNMPv1/v2c docsDevFilter mode\n             for backward compatibility.\n\n             Table entries MUST NOT persist across reboots for any\n             device.\n\n             This table is deprecated.  Instead, use the DiffServ MIB\n             from RFC 3289.')
docsDevFilterIpEntry = MibTableRow((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1), ).setIndexNames((0, "DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpIndex"))
if mibBuilder.loadTexts: docsDevFilterIpEntry.setDescription('Describes a filter to apply to IP traffic received on a\n             specified interface.  All identity objects in this table\n             (e.g., source and destination address/mask, protocol,\n             source/dest port, TOS/mask, interface and direction)\n             must match their respective fields in the packet for\n             any given filter to match.\n\n             To create an entry in this table, docsDevFilterIpIfIndex\n             must be specified.')
docsDevFilterIpIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)))
if mibBuilder.loadTexts: docsDevFilterIpIndex.setDescription('Index used to order the application of filters.\n             The filter with the lowest index is always applied\n             first.')
docsDevFilterIpStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterIpStatus.setDescription('Controls and reflects the status of rows in this\n             table.  Specifying only this object (with the\n             appropriate index) on a CM is sufficient to create a\n             filter row that matches all inbound packets on the\n             ethernet interface and results in the packets being\n             discarded.  docsDevFilterIpIfIndex (at least) must be\n             specified on a CMTS to create a row.  Creation of the\n             rows may be done via either create-and-wait or\n             create-and-go, but the filter is not applied until this\n             object is set to (or changes to) active.  There is no\n             restriction in changing any object in a row while this\n             object is set to active.')
docsDevFilterIpControl = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("discard", 1), ("accept", 2), ("policy", 3),)).clone('discard')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterIpControl.setDescription('If set to discard(1), all packets matching this filter\n             will be discarded, and scanning of the remainder of the\n             filter list will be aborted.  If set to accept(2), all\n             packets matching this filter will be accepted for\n             further processing (e.g., bridging).  If\n             docsDevFilterIpContinue is set to true, see if there\n             are other matches; otherwise, done.  If set to\n             policy (3), execute the policy entries\n             matched by docsDevFilterIpPolicyId in\n             docsDevFilterPolicyTable.\n\n             If docsDevFilterIpContinue is set to true, continue\n             scanning the table for other matches; otherwise, done.')
docsDevFilterIpIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 4), InterfaceIndexOrZero()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterIpIfIndex.setDescription("The entry interface to which this filter applies.  The\n             value corresponds to ifIndex for either a CATV MAC or\n             another interface.  If the value is zero, the\n             filter applies to all interfaces.  Default value in CMs\n             is the index of the customer-side (e.g., ethernet)\n             interface(s).  In CMTSes, this object MUST be\n             specified to create a row in this table.\n\n             Note that according to the DOCSIS OSSIv1.1\n             specification, ifIndex '1' in the Cable Modem means\n             that this row applies to all CMCI (customer-facing)\n             interfaces.")
docsDevFilterIpDirection = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("inbound", 1), ("outbound", 2), ("both", 3),)).clone('inbound')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterIpDirection.setDescription('Determines whether the filter is applied to inbound(1)\n             traffic, outbound(2) traffic, or traffic in both(3)\n             directions.')
docsDevFilterIpBroadcast = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 6), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterIpBroadcast.setDescription('If set to true(1), the filter only applies to multicast\n             and broadcast traffic.  If set to false(2), the filter\n             applies to all traffic.')
docsDevFilterIpSaddr = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 7), IpAddress().clone(hexValue="00000000")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterIpSaddr.setDescription('The source IP address, or portion thereof, that is to be\n             matched for this filter.  The source address is first\n             masked (ANDed) against docsDevFilterIpSmask before\n             being compared to this value.  A value of 0 for this\n             object and 0 for the mask matches all IP addresses.')
docsDevFilterIpSmask = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 8), IpAddress().clone(hexValue="00000000")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterIpSmask.setDescription('A bit mask that is to be applied to the source address\n             prior to matching.  This mask is not necessarily the\n             same as a subnet mask, but 1s bits must be leftmost and\n             contiguous.')
docsDevFilterIpDaddr = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 9), IpAddress().clone(hexValue="00000000")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterIpDaddr.setDescription('The destination IP address, or portion thereof, that is\n             to be matched for this filter.  The destination address\n             is first masked (ANDed) against docsDevFilterIpDmask\n             before being compared to this value.  A value of\n             00000000 for this object and 00000000 for the mask\n             matches all IP addresses.')
docsDevFilterIpDmask = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 10), IpAddress().clone(hexValue="00000000")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterIpDmask.setDescription('A bit mask that is to be applied to the destination\n             address prior to matching.  This mask is not necessarily\n             the same as a subnet mask, but 1s bits MUST be leftmost\n             and contiguous.')
docsDevFilterIpProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,256)).clone(256)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterIpProtocol.setDescription('The IP protocol value that is to be matched.  For\n             example, icmp is 1, tcp is 6, and udp is 17.  A value of\n             256 matches ANY protocol.')
docsDevFilterIpSourcePortLow = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 12), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterIpSourcePortLow.setDescription('This is the inclusive lower bound of the transport-layer\n             source port range that is to be matched.  If the IP\n             protocol of the packet is neither UDP nor TCP, this\n\n             object is ignored during matching.')
docsDevFilterIpSourcePortHigh = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 13), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)).clone(65535)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterIpSourcePortHigh.setDescription('This is the inclusive upper bound of the transport-layer\n             source port range that is to be matched.  If the IP\n             protocol of the packet is neither UDP nor TCP, this\n             object is ignored during matching.')
docsDevFilterIpDestPortLow = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterIpDestPortLow.setDescription('This is the inclusive lower bound of the transport-layer\n             destination port range that is to be matched.  If the IP\n             protocol of the packet is neither UDP nor TCP, this\n             object is ignored during matching.')
docsDevFilterIpDestPortHigh = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)).clone(65535)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterIpDestPortHigh.setDescription('This is the inclusive upper bound of the transport-layer\n             destination port range that is to be matched.  If the IP\n             protocol of the packet is neither UDP nor TCP, this\n             object is ignored during matching.')
docsDevFilterIpMatches = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 16), ZeroBasedCounter32()).setUnits('matches').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevFilterIpMatches.setDescription('Counts the number of times this filter was matched.\n             This object is initialized to 0 at boot, or at row\n             creation, and is reset only upon reboot.')
docsDevFilterIpTos = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 17), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1,1)).setFixedLength(1).clone(hexValue="00")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterIpTos.setDescription("This is the value to be matched to the packet's\n             TOS (Type of Service) value (after the TOS value\n             is ANDed with docsDevFilterIpTosMask).  A value for this\n             object of 0 and a mask of 0 matches all TOS values.")
docsDevFilterIpTosMask = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 18), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1,1)).setFixedLength(1).clone(hexValue="00")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterIpTosMask.setDescription("The mask to be applied to the packet's TOS value before\n             matching.")
docsDevFilterIpContinue = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 19), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterIpContinue.setDescription('If this value is set to true and docsDevFilterIpControl\n             is anything but discard (1), continue scanning and\n             applying policies.  See Section 3.3.3 for more\n             details.')
docsDevFilterIpPolicyId = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 4, 1, 20), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterIpPolicyId.setDescription('This object points to an entry in\n             docsDevFilterPolicyTable.  If docsDevFilterIpControl\n\n             is set to policy (3), execute all matching policies\n             in docsDevFilterPolicyTable.  If no matching policy\n             exists, treat as if docsDevFilterIpControl were set\n             to accept (1).  If this object is set to the value of\n             0, there is no matching policy, and\n             docsDevFilterPolicyTable MUST NOT be consulted.')
docsDevFilterPolicyTable = MibTable((1, 3, 6, 1, 2, 1, 69, 1, 6, 5), )
if mibBuilder.loadTexts: docsDevFilterPolicyTable.setDescription('A Table that maps between a policy group ID and a set\n             of pointers to policies to be applied.  All rows with\n             the same docsDevFilterPolicyId are part of the same\n             group of policy pointers and are applied in the order\n             in this table.  docsDevFilterPolicyTable exists to\n             allow multiple policy actions (referenced by policy\n             pointers) to be applied to any given classified packet.\n             The policy actions are applied in index order.\n             For example:\n\n             Index   ID    Type    Action\n              1      1      TOS     1\n              9      5      TOS     1\n              12     1      IPSEC   3\n\n             This says that a packet that matches a filter with\n             policy id 1 first has TOS policy 1 applied (which might\n             set the TOS bits to enable a higher priority) and next\n             has the IPSEC policy 3 applied (which may result in the\n             packets being dumped into a secure VPN to a remote\n             encryptor).\n\n             Policy ID 0 is reserved for default actions and is\n             applied only to packets that match no filters in\n             docsDevFilterIpTable.\n\n             Table entries MUST NOT persist across reboots for any\n             device.\n\n             This table is deprecated.  Instead, use the DiffServ MIB\n\n             from RFC 3289.')
docsDevFilterPolicyEntry = MibTableRow((1, 3, 6, 1, 2, 1, 69, 1, 6, 5, 1), ).setIndexNames((0, "DOCS-CABLE-DEVICE-MIB", "docsDevFilterPolicyIndex"))
if mibBuilder.loadTexts: docsDevFilterPolicyEntry.setDescription('An entry in the docsDevFilterPolicyTable.  Entries are\n             created by Network Management.  To create an entry,\n             docsDevFilterPolicyId MUST be specified.')
docsDevFilterPolicyIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 5, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)))
if mibBuilder.loadTexts: docsDevFilterPolicyIndex.setDescription('Index value for the table.')
docsDevFilterPolicyId = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 5, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterPolicyId.setDescription('Policy ID for this entry.  If a policy ID can apply to\n             multiple rows of this table, all relevant policies are\n             executed.  Policy 0 (if populated) is applied to all\n             packets that do not match any of the filters.  N.B. If\n             docsDevFilterIpPolicyId is set to 0, it DOES NOT match\n             policy 0 of this table.')
docsDevFilterPolicyStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 5, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterPolicyStatus.setDescription('Object used to create an entry in this table.  There is\n             no restriction in changing any object in a row while\n             this object is set to active.\n             The following object MUST have a valid value before this\n             object can be set to active:  docsDevFilterPolicyPtr.')
docsDevFilterPolicyPtr = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 5, 1, 6), RowPointer().clone((0, 0))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterPolicyPtr.setDescription('This object points to a row in an applicable filter\n             policy table.  Currently, the only standard policy\n             table is docsDevFilterTosTable.\n\n             Per the textual convention, this object points to the\n             first accessible object in the row; e.g., to point to a\n             row in docsDevFilterTosTable with an index of 21, the\n             value of this object would be the object identifier\n             docsDevTosStatus.21.\n\n             Vendors are recommended to adhere to the same convention\n             when adding vendor-specific policy table extensions.\n\n             If this pointer references an empty or non-existent\n             row, then no policy action is taken.\n\n             The default upon row creation is a null pointer that\n             results in no policy action being taken.')
docsDevFilterTosTable = MibTable((1, 3, 6, 1, 2, 1, 69, 1, 6, 6), )
if mibBuilder.loadTexts: docsDevFilterTosTable.setDescription('Table used to describe Type of Service (TOS) bits\n\n             processing.\n\n             This table is an adjunct to the docsDevFilterIpTable\n             and the docsDevFilterPolicy table.  Entries in the\n             latter table can point to specific rows in this (and\n             other) tables and cause specific actions to be taken.\n             This table permits the manipulation of the value of the\n             Type of Service bits in the IP header of the matched\n             packet as follows:\n\n             Set the tosBits of the packet to\n                (tosBits & docsDevFilterTosAndMask) |\n                docsDevFilterTosOrMask\n\n             This construct allows you to do a clear and set of all\n             the TOS bits in a flexible manner.\n\n             Table entries MUST NOT persist across reboots for any\n             device.\n\n             This table is deprecated.  Instead, use the DiffServ MIB\n             from RFC 3289.')
docsDevFilterTosEntry = MibTableRow((1, 3, 6, 1, 2, 1, 69, 1, 6, 6, 1), ).setIndexNames((0, "DOCS-CABLE-DEVICE-MIB", "docsDevFilterTosIndex"))
if mibBuilder.loadTexts: docsDevFilterTosEntry.setDescription('A TOS policy entry.')
docsDevFilterTosIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 6, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)))
if mibBuilder.loadTexts: docsDevFilterTosIndex.setDescription('The unique index for this row.  There are no ordering\n             requirements for this table, and any valid index may be\n             specified.')
docsDevFilterTosStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 6, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterTosStatus.setDescription('The object used to create and delete entries in this\n             table.  A row created by specifying just this object\n             results in a row that specifies no change to the TOS\n             bits.  A row may be created using either the\n             create-and-go or create-and-wait paradigms.  There is\n             no restriction on the ability to change values in this\n             row while the row is active.')
docsDevFilterTosAndMask = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 6, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1,1)).setFixedLength(1).clone(hexValue="ff")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterTosAndMask.setDescription("This value is bitwise ANDed with the matched packet's\n             TOS bits.")
docsDevFilterTosOrMask = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 6, 6, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1,1)).setFixedLength(1).clone(hexValue="00")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevFilterTosOrMask.setDescription("This value is bitwise ORed with the result from the\n             AND procedure (tosBits & docsDevFilterTosAndMask).\n             The result then replaces the packet's TOS bits.")
docsDevCpe = MibIdentifier((1, 3, 6, 1, 2, 1, 69, 1, 7))
docsDevCpeEnroll = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 7, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("none", 1), ("any", 2),)).clone('any')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevCpeEnroll.setDescription('This object controls the population of\n             docsDevFilterCpeTable.\n             If set to none, the filters must be set manually\n             by a network management action (either configuration\n             or SNMP set).\n             If set to any, the CM wiretaps the packets originating\n             from the ethernet and enrolls up to docsDevCpeIpMax\n             addresses as based on the source IPv4 or v6 addresses of\n             those packets.')
docsDevCpeIpMax = MibScalar((1, 3, 6, 1, 2, 1, 69, 1, 7, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1,2147483647)).clone(-1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsDevCpeIpMax.setDescription('This object controls the maximum number of CPEs allowed\n             to be learned behind this device.  If set to zero, any\n             number of CPEs may connect up to the maximum permitted\n             for the device.\n             If set to -1, no filtering is done on CPE source\n             addresses, and no entries are made in the\n             docsDevFilterCpeTable via learning.  If an attempt is\n             made to set this to a number greater than that\n             permitted for the device, it is set to that maximum.')
docsDevCpeTable = MibTable((1, 3, 6, 1, 2, 1, 69, 1, 7, 3), )
if mibBuilder.loadTexts: docsDevCpeTable.setDescription('This table lists the IPv4 addresses seen (or permitted)\n             as source addresses in packets originating from the\n             customer interface on this device.  In addition, this\n             table can be provisioned with the specific addresses\n             permitted for the CPEs via the normal row creation\n             mechanisms.  Table entries MUST NOT persist across\n             reboots for any device.\n\n             N.B.  Management action can add entries in this table\n             and in docsDevCpeIpTable past the value of\n\n             docsDevCpeIpMax.  docsDevCpeIpMax ONLY restricts the\n             ability of the CM to add learned addresses\n             automatically.\n\n             This table is deprecated and is replaced by\n             docsDevCpeInetTable.')
docsDevCpeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 69, 1, 7, 3, 1), ).setIndexNames((0, "DOCS-CABLE-DEVICE-MIB", "docsDevCpeIp"))
if mibBuilder.loadTexts: docsDevCpeEntry.setDescription('An entry in the docsDevFilterCpeTable.  There is one\n             entry for each IPv4 CPE seen or provisioned.  If\n             docsDevCpeIpMax is set to -1, this table is ignored;\n             otherwise, upon receipt of an IP packet from the\n             customer interface of the CM, the source IP address is\n             checked against this table.  If the address is in the\n             table, packet processing continues.  If the address is\n             not in the table but docsDevCpeEnroll is set to any\n             and the sum of the table sizes of docsDevCpeTable and\n             docsDevCpeInetTable is less than docsDevCpeIpMax, the\n             address is added to the table, and packet processing\n             continues.  Otherwise, the packet is dropped.\n\n             The filtering actions specified by this table occur\n             after any LLC filtering (docsDevFilterLLCTable), but\n             prior to any IP filtering (docsDevFilterIpTable,\n             docsDevNmAccessTable).')
docsDevCpeIp = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 7, 3, 1, 1), IpAddress())
if mibBuilder.loadTexts: docsDevCpeIp.setDescription('The IPv4 address to which this entry applies.\n\n             N.B.  Attempts to set all zeros or all ones address\n             values MUST be rejected.')
docsDevCpeSource = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 7, 3, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("other", 1), ("manual", 2), ("learned", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevCpeSource.setDescription('This object describes how this entry was created.  If\n             the value is manual(2), this row was created by a\n             network management action (either configuration or\n             SNMP set).  If set to learned(3), then it was found via\n             looking at the source IPv4 address of a received packet.\n             The value other(1) is used for any entries that do not\n             meet manual(2) or learned(3) criteria.')
docsDevCpeStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 7, 3, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevCpeStatus.setDescription('Standard object to manipulate rows.  To create a row in\n             this table, one only needs to specify this object.\n             Management stations SHOULD use the create-and-go\n             mechanism for creating rows in this table.')
docsDevCpeInetTable = MibTable((1, 3, 6, 1, 2, 1, 69, 1, 7, 4), )
if mibBuilder.loadTexts: docsDevCpeInetTable.setDescription('This table lists the IP addresses seen (or permitted) as\n             source addresses in packets originating from the\n             customer interface on this device.  In addition, this\n             table can be provisioned with the specific addresses\n             permitted for the CPEs via the normal row creation\n             mechanisms.\n\n             N.B.  Management action can add entries in this table\n             and in docsDevCpeIpTable past the value of\n             docsDevCpeIpMax.  docsDevCpeIpMax ONLY restricts the\n             ability of the CM to add learned addresses\n             automatically.\n\n             Table entries MUST NOT persist across reboots for any\n             device.\n\n             This table exactly mirrors docsDevCpeTable and applies\n             to IPv4 and IPv6 addresses.')
docsDevCpeInetEntry = MibTableRow((1, 3, 6, 1, 2, 1, 69, 1, 7, 4, 1), ).setIndexNames((0, "DOCS-CABLE-DEVICE-MIB", "docsDevCpeInetType"), (0, "DOCS-CABLE-DEVICE-MIB", "docsDevCpeInetAddr"))
if mibBuilder.loadTexts: docsDevCpeInetEntry.setDescription('An entry in the docsDevFilterCpeInetTable.  There is one\n             entry for each IP CPE seen or provisioned.  If\n             docsDevCpeIpMax is set to -1, this table is ignored;\n             otherwise, upon receipt of an IP packet from the\n             customer interface of the CM, the source IP address is\n             checked against this table.  If the address is in the\n             table, packet processing continues.  If the address is\n             not in the table but docsDevCpeEnroll is set to any and\n             the sum of the table sizes for docsDevCpeTable and\n             docsDevCpeInetTable is less than docsDevCpeIpMax, the\n             address is added to the table, and packet processing\n             continues.  Otherwise, the packet is dropped.\n\n             The filtering actions specified by this table occur\n             after any LLC filtering (docsDevFilterLLCTable), but\n             prior to any IP filtering (docsDevFilterIpTable,\n             docsDevNmAccessTable).\n\n             When an agent (cable modem) restarts, then all\n             dynamically created rows are lost.')
docsDevCpeInetType = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 7, 4, 1, 1), InetAddressType())
if mibBuilder.loadTexts: docsDevCpeInetType.setDescription('The type of internet address of docsDevCpeInetAddr.')
docsDevCpeInetAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 7, 4, 1, 2), InetAddress())
if mibBuilder.loadTexts: docsDevCpeInetAddr.setDescription('The Internet address to which this entry applies.\n\n             Implementors need to be aware that if the size of\n             docsDevCpeInetAddr exceeds 114 octets OIDs of\n             instances of columns in this row will have more\n             than 128 sub-identifiers and cannot be accessed\n             using SNMPv1, SNMPv2c, or SNMPv3.  Only unicast\n             address are allowed for this object.')
docsDevCpeInetSource = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 7, 4, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(2, 3,))).clone(namedValues=NamedValues(("manual", 2), ("learned", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsDevCpeInetSource.setDescription('This object describes how this entry was created.  If\n             the value is manual(2), this row was created by a\n             network management action (either configuration or\n             SNMP set).  If set to learned(3), then it was found\n             via looking at the source IP address of a received\n             packet.')
docsDevCpeInetRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 69, 1, 7, 4, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsDevCpeInetRowStatus.setDescription('Standard object to manipulate rows.  To create a row in\n             this table, one only needs to specify this object.\n             Management stations SHOULD use the create-and-go\n             mechanism for creating rows in this table.')
docsDevNotification = MibIdentifier((1, 3, 6, 1, 2, 1, 69, 2))
docsDevNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 69, 0))
docsDevConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 69, 3))
docsDevGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 69, 3, 1))
docsDevCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 69, 3, 2))
docsDevBasicCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 69, 3, 2, 1)).setObjects(*(("DOCS-CABLE-DEVICE-MIB", "docsDevBaseGroup"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEventGroup"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterGroup"), ("DOCS-CABLE-DEVICE-MIB", "docsDevNmAccessGroup"), ("DOCS-CABLE-DEVICE-MIB", "docsDevServerGroup"), ("DOCS-CABLE-DEVICE-MIB", "docsDevSoftwareGroup"), ("DOCS-CABLE-DEVICE-MIB", "docsDevCpeGroup"),))
if mibBuilder.loadTexts: docsDevBasicCompliance.setDescription('The RFC 2669 compliance statement for MCNS/DOCSIS\n             Cable Modems and Cable Modem Termination Systems.')
docsDevBaseGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 69, 3, 1, 1)).setObjects(*(("DOCS-CABLE-DEVICE-MIB", "docsDevRole"), ("DOCS-CABLE-DEVICE-MIB", "docsDevDateTime"), ("DOCS-CABLE-DEVICE-MIB", "docsDevResetNow"), ("DOCS-CABLE-DEVICE-MIB", "docsDevSerialNumber"), ("DOCS-CABLE-DEVICE-MIB", "docsDevSTPControl"),))
if mibBuilder.loadTexts: docsDevBaseGroup.setDescription('A collection of objects providing device status and\n             control.')
docsDevNmAccessGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 69, 3, 1, 2)).setObjects(*(("DOCS-CABLE-DEVICE-MIB", "docsDevNmAccessIp"), ("DOCS-CABLE-DEVICE-MIB", "docsDevNmAccessIpMask"), ("DOCS-CABLE-DEVICE-MIB", "docsDevNmAccessCommunity"), ("DOCS-CABLE-DEVICE-MIB", "docsDevNmAccessControl"), ("DOCS-CABLE-DEVICE-MIB", "docsDevNmAccessInterfaces"), ("DOCS-CABLE-DEVICE-MIB", "docsDevNmAccessStatus"),))
if mibBuilder.loadTexts: docsDevNmAccessGroup.setDescription('A collection of objects for controlling access to SNMP\n             objects on cable devices.\n\n             This group has been deprecated because all the\n             objects have been deprecated in favor of SNMPv3 and\n             Coexistence MIBs.')
docsDevSoftwareGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 69, 3, 1, 3)).setObjects(*(("DOCS-CABLE-DEVICE-MIB", "docsDevSwServer"), ("DOCS-CABLE-DEVICE-MIB", "docsDevSwFilename"), ("DOCS-CABLE-DEVICE-MIB", "docsDevSwAdminStatus"), ("DOCS-CABLE-DEVICE-MIB", "docsDevSwOperStatus"), ("DOCS-CABLE-DEVICE-MIB", "docsDevSwCurrentVers"),))
if mibBuilder.loadTexts: docsDevSoftwareGroup.setDescription('A collection of objects for controlling software\n             downloads.\n\n             This group has been deprecated and replaced by\n             docsDevSoftwareGroupV2.  Object docsDevSwServer\n             has been replaced by docsDevSwServerAddressType\n             and docsDevSwServerAddress, and\n             docsDevSwServerTransportProtocol has been added to\n             support TFTP and HTTP firmware downloads.')
docsDevServerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 69, 3, 1, 4)).setObjects(*(("DOCS-CABLE-DEVICE-MIB", "docsDevServerBootState"), ("DOCS-CABLE-DEVICE-MIB", "docsDevServerDhcp"), ("DOCS-CABLE-DEVICE-MIB", "docsDevServerTime"), ("DOCS-CABLE-DEVICE-MIB", "docsDevServerTftp"), ("DOCS-CABLE-DEVICE-MIB", "docsDevServerConfigFile"),))
if mibBuilder.loadTexts: docsDevServerGroup.setDescription('A collection of objects providing status about server\n             provisioning.\n\n             This group has been deprecated and replaced by\n             docsDevServerGroupV2.  The objects docsDevServerDhcp,\n             docsDevServerTime, and docsDevServerTftp have\n             been replaced by docsDevServerDhcpAddressType,\n             docsDevServerDhcpAddress, docsDevServerTimeAddressType,\n             docsDevServerTimeAddress,\n             docsDevServerConfigTftpAddressType, and\n             docsDevServerConfigTftpAddress.')
docsDevEventGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 69, 3, 1, 5)).setObjects(*(("DOCS-CABLE-DEVICE-MIB", "docsDevEvControl"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvSyslog"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvThrottleAdminStatus"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvThrottleInhibited"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvThrottleThreshold"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvThrottleInterval"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvReporting"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvFirstTime"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvLastTime"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvCounts"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvLevel"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvId"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvText"),))
if mibBuilder.loadTexts: docsDevEventGroup.setDescription('A collection of objects used to control and monitor\n             events.\n\n             This group has been deprecated and replaced by\n             docsDevEventGroupV2.  The object docsDevEvSyslog has\n\n             been replaced by docsDevEvSyslogAddressType and\n             docsDevEvSyslogAddress, and docsDevEvThrottleInhibited\n             has been replaced by\n             docsDevEvThrottleThresholdExceeded.')
docsDevFilterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 69, 3, 1, 6)).setObjects(*(("DOCS-CABLE-DEVICE-MIB", "docsDevFilterLLCUnmatchedAction"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpDefault"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterLLCStatus"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterLLCIfIndex"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterLLCProtocolType"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterLLCProtocol"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterLLCMatches"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpControl"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpIfIndex"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpStatus"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpDirection"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpBroadcast"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpSaddr"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpSmask"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpDaddr"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpDmask"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpProtocol"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpSourcePortLow"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpSourcePortHigh"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpDestPortLow"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpDestPortHigh"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpMatches"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpTos"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpTosMask"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpContinue"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterIpPolicyId"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterPolicyId"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterPolicyStatus"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterPolicyPtr"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterTosStatus"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterTosAndMask"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterTosOrMask"),))
if mibBuilder.loadTexts: docsDevFilterGroup.setDescription('A collection of objects to specify filters at the link\n             layer and IPv4 layer.\n\n             This group has been deprecated and replaced by various\n             groups from the DiffServ MIB.')
docsDevCpeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 69, 3, 1, 7)).setObjects(*(("DOCS-CABLE-DEVICE-MIB", "docsDevCpeEnroll"), ("DOCS-CABLE-DEVICE-MIB", "docsDevCpeIpMax"), ("DOCS-CABLE-DEVICE-MIB", "docsDevCpeSource"), ("DOCS-CABLE-DEVICE-MIB", "docsDevCpeStatus"),))
if mibBuilder.loadTexts: docsDevCpeGroup.setDescription('A collection of objects used to control the number\n             and specific values of IPv4 addresses allowed for\n             associated Customer Premises Equipment (CPE).\n\n             This group has been deprecated and replaced by\n             docsDevInetCpeGroup.  The object docsDevCpeSource has\n             been replaced by docsDevCpeInetSource, and\n             docsDevCpeStatus has been replaced by\n             docsDevCpeInetRowStatus.')
docsDevGroupsV2 = MibIdentifier((1, 3, 6, 1, 2, 1, 69, 3, 3))
docsDevCompliancesV2 = MibIdentifier((1, 3, 6, 1, 2, 1, 69, 3, 4))
docsDevCmCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 69, 3, 4, 1)).setObjects(*(("DIFFSERV-MIB", "diffServMIBDataPathGroup"), ("DIFFSERV-MIB", "diffServMIBClfrGroup"), ("DIFFSERV-MIB", "diffServMIBClfrElementGroup"), ("DIFFSERV-MIB", "diffServMIBMultiFieldClfrGroup"), ("DIFFSERV-MIB", "diffServMIBActionGroup"), ("DIFFSERV-MIB", "diffServMIBDscpMarkActGroup"), ("DIFFSERV-MIB", "diffServMIBCounterGroup"), ("DIFFSERV-MIB", "diffServMIBAlgDropGroup"), ("DOCS-CABLE-DEVICE-MIB", "docsDevBaseGroup"), ("DOCS-CABLE-DEVICE-MIB", "docsDevBaseIgmpGroup"), ("DOCS-CABLE-DEVICE-MIB", "docsDevBaseMaxCpeGroup"), ("DOCS-CABLE-DEVICE-MIB", "docsDevSoftwareGroupV2"), ("DOCS-CABLE-DEVICE-MIB", "docsDevServerGroupV2"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEventGroupV2"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterLLCGroup"), ("DOCS-CABLE-DEVICE-MIB", "docsDevInetCpeGroup"),))
if mibBuilder.loadTexts: docsDevCmCompliance.setDescription('The compliance statement for DOCSIS Cable Modems.\n\n              This compliance statement applies to implementations\n              of DOCSIS versions that are not IPv6 capable.')
docsDevCmtsCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 69, 3, 4, 2)).setObjects(*(("DOCS-CABLE-DEVICE-MIB", "docsDevBaseGroup"), ("DOCS-CABLE-DEVICE-MIB", "docsDevBaseIgmpGroup"), ("DOCS-CABLE-DEVICE-MIB", "docsDevBaseMaxCpeGroup"), ("DOCS-CABLE-DEVICE-MIB", "docsDevSoftwareGroupV2"), ("DOCS-CABLE-DEVICE-MIB", "docsDevServerGroupV2"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEventGroupV2"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterLLCGroup"), ("DOCS-CABLE-DEVICE-MIB", "docsDevInetCpeGroup"),))
if mibBuilder.loadTexts: docsDevCmtsCompliance.setDescription('The compliance statement for DOCSIS Cable Modem\n              Termination Systems.\n\n              This compliance statement applies to implementations\n              of DOCSIS versions that are not IPv6 capable.')
docsDevBaseIgmpGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 69, 3, 3, 1)).setObjects(*(("DOCS-CABLE-DEVICE-MIB", "docsDevIgmpModeControl"),))
if mibBuilder.loadTexts: docsDevBaseIgmpGroup.setDescription('An object providing cable device IGMP status and\n             control.')
docsDevBaseMaxCpeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 69, 3, 3, 2)).setObjects(*(("DOCS-CABLE-DEVICE-MIB", "docsDevMaxCpe"),))
if mibBuilder.loadTexts: docsDevBaseMaxCpeGroup.setDescription('An object providing management of the maximum number of\n             CPEs permitted access through a cable modem.')
docsDevNmAccessExtGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 69, 3, 3, 3)).setObjects(*(("DOCS-CABLE-DEVICE-MIB", "docsDevNmAccessTrapVersion"),))
if mibBuilder.loadTexts: docsDevNmAccessExtGroup.setDescription('An object, in addition to the objects in\n             docsDevNmAccessGroup, for controlling access to\n             SNMP objects on cable devices.\n\n             This group is included in this MIB due to existing\n             implementations of docsDevNmAccessTrapVersion in\n             DOCSIS cable modems.\n\n             This group has been deprecated because the object has\n             been deprecated in favor of SNMPv3 and Coexistence\n             MIBs.')
docsDevSoftwareGroupV2 = ObjectGroup((1, 3, 6, 1, 2, 1, 69, 3, 3, 4)).setObjects(*(("DOCS-CABLE-DEVICE-MIB", "docsDevSwFilename"), ("DOCS-CABLE-DEVICE-MIB", "docsDevSwAdminStatus"), ("DOCS-CABLE-DEVICE-MIB", "docsDevSwOperStatus"), ("DOCS-CABLE-DEVICE-MIB", "docsDevSwCurrentVers"), ("DOCS-CABLE-DEVICE-MIB", "docsDevSwServerAddressType"), ("DOCS-CABLE-DEVICE-MIB", "docsDevSwServerAddress"), ("DOCS-CABLE-DEVICE-MIB", "docsDevSwServerTransportProtocol"),))
if mibBuilder.loadTexts: docsDevSoftwareGroupV2.setDescription('A collection of objects for controlling software\n             downloads.  This group replaces docsDevSoftwareGroup.')
docsDevServerGroupV2 = ObjectGroup((1, 3, 6, 1, 2, 1, 69, 3, 3, 5)).setObjects(*(("DOCS-CABLE-DEVICE-MIB", "docsDevServerBootState"), ("DOCS-CABLE-DEVICE-MIB", "docsDevServerDhcpAddressType"), ("DOCS-CABLE-DEVICE-MIB", "docsDevServerDhcpAddress"), ("DOCS-CABLE-DEVICE-MIB", "docsDevServerTimeAddressType"), ("DOCS-CABLE-DEVICE-MIB", "docsDevServerTimeAddress"), ("DOCS-CABLE-DEVICE-MIB", "docsDevServerConfigTftpAddressType"), ("DOCS-CABLE-DEVICE-MIB", "docsDevServerConfigTftpAddress"), ("DOCS-CABLE-DEVICE-MIB", "docsDevServerConfigFile"),))
if mibBuilder.loadTexts: docsDevServerGroupV2.setDescription('A collection of objects providing status about server\n             provisioning.  This group replaces docsDevServerGroup.')
docsDevEventGroupV2 = ObjectGroup((1, 3, 6, 1, 2, 1, 69, 3, 3, 6)).setObjects(*(("DOCS-CABLE-DEVICE-MIB", "docsDevEvControl"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvThrottleAdminStatus"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvThrottleThreshold"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvThrottleInterval"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvReporting"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvFirstTime"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvLastTime"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvCounts"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvLevel"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvId"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvText"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvSyslogAddressType"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvSyslogAddress"), ("DOCS-CABLE-DEVICE-MIB", "docsDevEvThrottleThresholdExceeded"),))
if mibBuilder.loadTexts: docsDevEventGroupV2.setDescription('A collection of objects used to control and monitor\n             events.  This group replaces docsDevEventGroup.\n             The event reporting mechanism, and more specifically\n             docsDevEvReporting, can be used to take advantage of\n             the event reporting features of RFC3413 and RFC3014.')
docsDevFilterLLCGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 69, 3, 3, 7)).setObjects(*(("DOCS-CABLE-DEVICE-MIB", "docsDevFilterLLCUnmatchedAction"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterLLCStatus"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterLLCIfIndex"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterLLCProtocolType"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterLLCProtocol"), ("DOCS-CABLE-DEVICE-MIB", "docsDevFilterLLCMatches"),))
if mibBuilder.loadTexts: docsDevFilterLLCGroup.setDescription('A collection of objects to specify link layer filters.')
docsDevInetCpeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 69, 3, 3, 8)).setObjects(*(("DOCS-CABLE-DEVICE-MIB", "docsDevCpeEnroll"), ("DOCS-CABLE-DEVICE-MIB", "docsDevCpeIpMax"), ("DOCS-CABLE-DEVICE-MIB", "docsDevCpeInetSource"), ("DOCS-CABLE-DEVICE-MIB", "docsDevCpeInetRowStatus"),))
if mibBuilder.loadTexts: docsDevInetCpeGroup.setDescription('A collection of objects used to control the number\n             and specific values of Internet (e.g., IPv4 and IPv6)\n             addresses allowed for associated Customer Premises\n             Equipment (CPE).')
mibBuilder.exportSymbols("DOCS-CABLE-DEVICE-MIB", docsDevBase=docsDevBase, docsDevEventEntry=docsDevEventEntry, docsDevNmAccessGroup=docsDevNmAccessGroup, docsDevFilterLLCMatches=docsDevFilterLLCMatches, docsDevCpeTable=docsDevCpeTable, docsDevNmAccessControl=docsDevNmAccessControl, docsDevCpeInetSource=docsDevCpeInetSource, docsDevFilterIpTable=docsDevFilterIpTable, docsDevCmtsCompliance=docsDevCmtsCompliance, docsDevBasicCompliance=docsDevBasicCompliance, docsDevServerDhcpAddress=docsDevServerDhcpAddress, docsDevNotification=docsDevNotification, docsDevFilterLLCEntry=docsDevFilterLLCEntry, docsDevGroups=docsDevGroups, docsDevFilterIpSmask=docsDevFilterIpSmask, docsDevServerBootState=docsDevServerBootState, docsDevFilterLLCTable=docsDevFilterLLCTable, docsDevEvSyslog=docsDevEvSyslog, docsDevEvThrottleInhibited=docsDevEvThrottleInhibited, docsDevServerGroupV2=docsDevServerGroupV2, docsDevEventGroupV2=docsDevEventGroupV2, docsDevCpeGroup=docsDevCpeGroup, docsDevNmAccessInterfaces=docsDevNmAccessInterfaces, docsDevEvId=docsDevEvId, docsDevFilterIpDefault=docsDevFilterIpDefault, docsDevCompliances=docsDevCompliances, docsDevFilterPolicyTable=docsDevFilterPolicyTable, docsDevEventTable=docsDevEventTable, docsDevFilterLLCIfIndex=docsDevFilterLLCIfIndex, docsDevNotifications=docsDevNotifications, docsDevEvReporting=docsDevEvReporting, docsDevServerConfigFile=docsDevServerConfigFile, docsDevFilterLLCProtocol=docsDevFilterLLCProtocol, docsDevCpeInetType=docsDevCpeInetType, docsDevNmAccessIp=docsDevNmAccessIp, docsDevConformance=docsDevConformance, docsDevCpeInetEntry=docsDevCpeInetEntry, docsDevServerTimeAddressType=docsDevServerTimeAddressType, docsDevEvControl=docsDevEvControl, docsDevCmCompliance=docsDevCmCompliance, docsDevEvLastTime=docsDevEvLastTime, docsDevSwServerAddressType=docsDevSwServerAddressType, docsDevNmAccessIndex=docsDevNmAccessIndex, docsDevFilterTosTable=docsDevFilterTosTable, docsDevFilterIpSourcePortLow=docsDevFilterIpSourcePortLow, docsDevFilterTosIndex=docsDevFilterTosIndex, docsDevNmAccessTrapVersion=docsDevNmAccessTrapVersion, docsDevFilterIpControl=docsDevFilterIpControl, docsDevSwFilename=docsDevSwFilename, docsDevFilterTosAndMask=docsDevFilterTosAndMask, docsDevMIBObjects=docsDevMIBObjects, docsDevNmAccessExtGroup=docsDevNmAccessExtGroup, docsDevSwCurrentVers=docsDevSwCurrentVers, docsDevCpeInetAddr=docsDevCpeInetAddr, docsDevFilterTosStatus=docsDevFilterTosStatus, docsDevEvThrottleInterval=docsDevEvThrottleInterval, docsDevGroupsV2=docsDevGroupsV2, docsDevEvControlTable=docsDevEvControlTable, docsDevFilterGroup=docsDevFilterGroup, docsDevFilterLLCStatus=docsDevFilterLLCStatus, docsDevNmAccessTable=docsDevNmAccessTable, docsDevSwServer=docsDevSwServer, docsDevFilterIpDestPortHigh=docsDevFilterIpDestPortHigh, docsDevServerGroup=docsDevServerGroup, docsDevNmAccessIpMask=docsDevNmAccessIpMask, docsDevSTPControl=docsDevSTPControl, docsDevEvControlEntry=docsDevEvControlEntry, docsDevMaxCpe=docsDevMaxCpe, PYSNMP_MODULE_ID=docsDev, docsDevEvent=docsDevEvent, docsDevEvFirstTime=docsDevEvFirstTime, docsDevNmAccessStatus=docsDevNmAccessStatus, docsDevSerialNumber=docsDevSerialNumber, docsDevEvThrottleThreshold=docsDevEvThrottleThreshold, docsDevCpeIp=docsDevCpeIp, docsDev=docsDev, docsDevCpeEnroll=docsDevCpeEnroll, docsDevBaseMaxCpeGroup=docsDevBaseMaxCpeGroup, docsDevEventGroup=docsDevEventGroup, docsDevBaseIgmpGroup=docsDevBaseIgmpGroup, docsDevFilterIpEntry=docsDevFilterIpEntry, docsDevSoftwareGroup=docsDevSoftwareGroup, docsDevEvPriority=docsDevEvPriority, docsDevEvThrottleThresholdExceeded=docsDevEvThrottleThresholdExceeded, docsDevEvSyslogAddress=docsDevEvSyslogAddress, docsDevNmAccessCommunity=docsDevNmAccessCommunity, docsDevEvThrottleAdminStatus=docsDevEvThrottleAdminStatus, docsDevEvCounts=docsDevEvCounts, docsDevFilterIpIndex=docsDevFilterIpIndex, docsDevResetNow=docsDevResetNow, docsDevSwServerAddress=docsDevSwServerAddress, docsDevNmAccessEntry=docsDevNmAccessEntry, docsDevDateTime=docsDevDateTime, docsDevSwServerTransportProtocol=docsDevSwServerTransportProtocol, docsDevServerTime=docsDevServerTime, docsDevServerDhcpAddressType=docsDevServerDhcpAddressType, docsDevInetCpeGroup=docsDevInetCpeGroup, docsDevServerConfigTftpAddress=docsDevServerConfigTftpAddress, docsDevFilterIpBroadcast=docsDevFilterIpBroadcast, docsDevFilterTosEntry=docsDevFilterTosEntry, docsDevRole=docsDevRole, docsDevFilterIpDaddr=docsDevFilterIpDaddr, docsDevFilterIpMatches=docsDevFilterIpMatches, docsDevCompliancesV2=docsDevCompliancesV2, docsDevEvLevel=docsDevEvLevel, docsDevFilterIpContinue=docsDevFilterIpContinue, docsDevCpe=docsDevCpe, docsDevEvSyslogAddressType=docsDevEvSyslogAddressType, docsDevServerDhcp=docsDevServerDhcp, docsDevFilterIpDestPortLow=docsDevFilterIpDestPortLow, docsDevFilterPolicyIndex=docsDevFilterPolicyIndex, docsDevServerTftp=docsDevServerTftp, docsDevFilterPolicyEntry=docsDevFilterPolicyEntry, docsDevFilterLLCProtocolType=docsDevFilterLLCProtocolType, docsDevEvIndex=docsDevEvIndex, docsDevFilterPolicyStatus=docsDevFilterPolicyStatus, docsDevServerConfigTftpAddressType=docsDevServerConfigTftpAddressType, docsDevFilterPolicyPtr=docsDevFilterPolicyPtr, docsDevSoftwareGroupV2=docsDevSoftwareGroupV2, docsDevServer=docsDevServer, docsDevFilterLLCIndex=docsDevFilterLLCIndex, docsDevEvText=docsDevEvText, docsDevCpeIpMax=docsDevCpeIpMax, docsDevFilterIpSourcePortHigh=docsDevFilterIpSourcePortHigh, docsDevBaseGroup=docsDevBaseGroup, docsDevFilterPolicyId=docsDevFilterPolicyId, docsDevFilterLLCUnmatchedAction=docsDevFilterLLCUnmatchedAction, docsDevFilterIpSaddr=docsDevFilterIpSaddr, docsDevFilterTosOrMask=docsDevFilterTosOrMask, docsDevCpeEntry=docsDevCpeEntry, docsDevFilterIpIfIndex=docsDevFilterIpIfIndex, docsDevFilterIpPolicyId=docsDevFilterIpPolicyId, docsDevCpeInetRowStatus=docsDevCpeInetRowStatus, docsDevServerTimeAddress=docsDevServerTimeAddress, docsDevSoftware=docsDevSoftware, docsDevFilterIpTos=docsDevFilterIpTos, docsDevCpeSource=docsDevCpeSource, docsDevFilterIpProtocol=docsDevFilterIpProtocol, docsDevIgmpModeControl=docsDevIgmpModeControl, docsDevCpeStatus=docsDevCpeStatus, docsDevFilterIpTosMask=docsDevFilterIpTosMask, docsDevFilterIpDmask=docsDevFilterIpDmask, docsDevSwOperStatus=docsDevSwOperStatus, docsDevFilterLLCGroup=docsDevFilterLLCGroup, docsDevFilter=docsDevFilter, docsDevSwAdminStatus=docsDevSwAdminStatus, docsDevFilterIpStatus=docsDevFilterIpStatus, docsDevFilterIpDirection=docsDevFilterIpDirection, docsDevCpeInetTable=docsDevCpeInetTable)
