<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_negotiation - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_negotiation</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_negotiation.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_negotiation.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_negotiation.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Effectue la <a href="../content-negotiation.html">ngociation de
contenu</a></td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>negotiation_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_negotiation.c</td></tr></table>
<h3>Sommaire</h3>

    <p>La ngociation de contenu, ou plus prcisment la slection de
    contenu, est la slection parmi plusieurs documents disponibles, du
    document qui "colle" au plus prs des possibilits du client. Pour y
    parvenir, deux mthodes sont employes.</p>

    <ul>
      <li>Une table de correspondances de types (un fichier associ au
      gestionnaire <code>type-map</code>) qui contient une liste
      explicite des fichiers contenant les diffrentes variantes.</li>

      <li>Une recherche multivues (Multiviews) (active par l'<code class="directive"><a href="../mod/core.html#options">Options</a></code> <code>Multiviews</code>), o le
      serveur effectue une recherche de correspondance de modle de nom
      de fichier implicite, et fait son choix parmi les rsultats.</li>
    </ul>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#cachenegotiateddocs">CacheNegotiatedDocs</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#forcelanguagepriority">ForceLanguagePriority</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#languagepriority">LanguagePriority</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#typemaps">Tables de correspondances de types</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#multiviews">Multivues</a></li>
</ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="directive"><a href="../mod/core.html#options">Options</a></code></li>
<li><code class="module"><a href="../mod/mod_mime.html">mod_mime</a></code></li>
<li><a href="../content-negotiation.html">Ngociation de
contenu</a></li>
<li><a href="../env.html">Variables d'environnement</a></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="typemaps" id="typemaps">Tables de correspondances de types</a></h2>
    <p>Une table de correspondances de types possde un format similaire
     celui des en-ttes de messagerie RFC822. Elle contient des
    descriptions de documents spares par des lignes vides, toute ligne
    commenant par un dise ('#') tant considre comme un
    commentaire. Une description de document comporte plusieurs
    enregistrements d'en-ttes ; chaque enregistrement peut tre rparti
    sur plusieurs lignes  condition que les lignes supplmentaires
    commencent par un ou plusieurs espaces. Lors du traitement, les
    espaces de dbut de ligne seront supprims et les lignes
    concatnes. L'enregistrement d'un en-tte comprend un mot-cl qui
    se termine toujours par un caractre "deux-points" ':', suivi d'une
    valeur. Les espaces sont autoriss entre le nom d'en-tte et sa
    valeur, ainsi qu'entre les diffrents lments de la valeur. Les
    en-ttes autoriss sont :</p>

    <dl>
      <dt><code>Content-Encoding:</code></dt>
      <dd>Le codage du fichier. Apache ne reconnat que les codages
      dfinis par une directive <code class="directive"><a href="../mod/mod_mime.html#addencoding">AddEncoding</a></code>. Sont normalement inclus
      les codages <code>x-compress</code> pour les fichiers compresss
      avec compress, et <code>x-gzip</code> pour les fichiers compresss
      avec gzip. Le prfixe <code>x-</code> est ignor lors des
      comparaisons de codages.</dd>

      <dt><code>Content-Language:</code></dt>
      <dd>Le(s) langage(s) de la variante, sous la forme d'un symbole de
      langage Internet standard (<a href="http://www.ietf.org/rfc/rfc1766.txt">RFC 1766</a>). Par
      exemple, <code>en</code> correspond  l'anglais. Si la variante
      contient plusieurs langages, ils sont spars par des
      virgules.</dd>

      <dt><code>Content-Length:</code></dt>
      <dd>La taille du fichier en octets. Si cet en-tte n'est pas
      prsent, c'est la taille relle du fichier qui est utilise.</dd>

      <dt><code>Content-Type:</code></dt>

      <dd>
        Le <a class="glossarylink" href="../glossary.html#mime-type" title="voir glossaire">type MIME</a> du document
	avec des paramtres optionnels. Les paramtres sont spars du
	type de mdium ainsi qu'entre eux par un point-virgule, et
	possdent la syntaxe <code>nom=valeur</code>. Les paramtres
	courants sont :

        <dl>
          <dt><code>level</code></dt>
          <dd>un entier spcifiant la version du type de mdia. Pour
	  <code>text/html</code>, la valeur par dfaut est 2, sinon
	  0.</dd>

          <dt><code>qs</code></dt>
          <dd>un nombre en virgule flottante de 0[.000]  1[.000], indiquant la
	  "qualit" relative de la variante courante par rapport aux
	  autres variantes disponibles, indpendamment des possibilits
	  du client. Par exemple, un fichier jpeg est en gnral une
	  source de qualit suprieure  un fichier ascii s'il est cens
	  reprsenter une image. Cependant, si la ressource reprsente
	  est une image ascii, un fichier ascii possdera une qualit
	  suprieure  un fichier jpeg. Toutes les valeurs de
	  <code>qs</code> sont donc spcifiques  une certaine
	  ressource.</dd>
        </dl>

        <div class="example"><h3>Exemple</h3><p><code>
          Content-Type: image/jpeg; qs=0.8
        </code></p></div>
      </dd>

      <dt><code>URI:</code></dt>
      <dd>l'URI du fichier contenant la variante (du type de mdium
      donn, cod selon le codage de contenu donn). Cet URI est
      considr comme relatif au fichier de correspondances ; il doit
      tre situ sur le mme serveur, et doit faire rfrence au
      fichier auquel le client se verrait accorder l'accs s'il tait
      requis directement.</dd>

      <dt><code>Body:</code></dt>
      <dd>Le contenu rel de la ressource
      peut tre inclus dans la table de correspondances en utilisant
      l'en-tte Body. Cet en-tte doit contenir une chane dsignant un
      dlimiteur pour le contenu du corps. Les lignes suivantes du
      fichier de correspondances de types seront alors considres comme
      parties du corps de la ressource jusqu' ce que le dlimiteur soit
      dtect.

      <div class="example"><h3>Exemple:</h3><p><code>
        Body:----xyz----<br />
        &lt;html&gt;<br />
        &lt;body&gt;<br />
        &lt;p&gt;Contenu de la page.&lt;/p&gt;<br />
        &lt;/body&gt;<br />
        &lt;/html&gt;<br />
        ----xyz----
      </code></p></div>
      </dd>
    </dl>

    <p>Considrons une ressource, <code>document.html</code>, disponible
    en anglais, en franais et en allemand. Les fichiers correspondants
    se nomment respectivement <code>document.html.en</code>,
    <code>document.html.fr</code>, et <code>document.html.de</code>. Le
    fichier de correspondances de types se nommera
    <code>document.html.var</code> et contiendra ce qui suit :</p>

    <div class="example"><p><code>
    URI: document.html<br />
    <br />
    Content-language: en<br />
    Content-type: text/html<br />
    URI: document.html.en<br />
    <br />
    Content-language: fr<br />
    Content-type: text/html<br />
    URI: document.html.fr<br />
    <br />
    Content-language: de<br />
    Content-type: text/html<br />
    URI: document.html.de<br />
    <br />

    </code></p></div>

    <p>Ces quatre fichiers doivent se trouver dans le mme rpertoire,
    et le fichier <code>.var</code> doit tre associ au gestionnaire
    <code>type-map</code> via une directive <code class="directive"><a href="../mod/mod_mime.html#addhandler">AddHandler</a></code> :</p>

    <pre class="prettyprint lang-config">
    AddHandler type-map .var
    </pre>


    <p>A l'arrive d'une requte pour la ressource
    <code>document.html.var</code>, la variante de
    <code>document.html</code> qui correspond le mieux  la prference
    de langage spcifie dans l'en-tte de la requte de l'utilisateur
    <code>Accept-Language</code> sera choisie.</p>

    <p>Si <code>Multiviews</code> est active, et si <code class="directive"><a href="../mod/mod_mime.html#multiviewsmatch">MultiviewsMatch</a></code> est dfinie 
    "handlers" ou "any", une requte pour <code>document.html</code> va
    rechercher <code>document.html.var</code>, et continuer la
    ngociation avec le gestionnaire explicite type-map.</p>

    <p>D'autres directives de configuration, comme <code class="directive"><a href="../mod/mod_alias.html#alias">Alias</a></code>, peuvent tre utilises pour
    associer <code>document.html</code> avec
    <code>document.html.var</code>.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="multiviews" id="multiviews">Multivues</a></h2>
    <p>Une recherche Multivues est active par l'<code class="directive"><a href="../mod/core.html#options">Options</a></code> <code>Multiviews</code>. Si le
    serveur reoit une requte pour <code>/un/rpertoire/foo</code>, et
    si <code>/un/rpertoire/foo</code> n'existe pas, le serveur parcourt
    le rpertoire  la recherche de tous les fichiers de nom
    <code>foo.*</code>, et simule vritablement une correspondance de
    type qui nomme tous ces fichiers en leur assignant les mmes type
    de mdia et codage de contenu qu'ils auraient eus si le client avait
    requis l'un d'entre eux avec son nom complet. Il choisit ensuite le
    fichier qui correspond le mieux au profile du client, puis renvoie
    le document.</p>

    <p>La directive <code class="directive"><a href="../mod/mod_mime.html#multiviewsmatch">MultiviewsMatch</a></code> dfinit si Apache doit
    prendre en compte les fichiers qui ne comportent pas de mtadonnes
    de ngociation de contenu lors du choix du fichier  servir.</p>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheNegotiatedDocs" id="CacheNegotiatedDocs">CacheNegotiatedDocs</a> <a name="cachenegotiateddocs" id="cachenegotiateddocs">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Permet la mise en cache au niveau des serveurs mandataires
des documents dont le contenu a t ngoci</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheNegotiatedDocs On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheNegotiatedDocs Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_negotiation</td></tr>
</table>
    <p>Si elle est dfinie  "on", cette directive permet la mise en
    cache au niveau des serveurs mandataires des documents dont le
    contenu a t ngoci. Le processus de mise en cache sera alors plus
    efficace, mais des clients se trouvant derrire le mandataire
    seront alors susceptibles de se voir servir des versions de
    documents qui ne correspondent pas forcment  leurs attentes.</p>

    <p>Cette directive ne s'applique qu'aux requtes en provenance de
    navigateurs HTTP/1.0. HTTP/1.1 fournit un bien meilleur contrle de
    la mise en cache des documents au contenu ngoci, et cette
    directive n'a aucun effet sur les rponses aux requtes
    HTTP/1.1.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ForceLanguagePriority" id="ForceLanguagePriority">ForceLanguagePriority</a> <a name="forcelanguagepriority" id="forcelanguagepriority">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Action  entreprendre si un document acceptable unique
n'est pas trouv</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ForceLanguagePriority None|Prefer|Fallback [Prefer|Fallback]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ForceLanguagePriority Prefer</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_negotiation</td></tr>
</table>
    <p>La directive <code class="directive">ForceLanguagePriority</code> utilise
    le langage dfini par la directive <code class="directive"><a href="#languagepriority">LanguagePriority</a></code> pour terminer
    la ngociation lorsque le serveur n'est pas en mesure de trouver une
    solution satisfaisante unique.</p>

    <p><code>ForceLanguagePriority Prefer</code> utilise la directive
    <code>LanguagePriority</code> pour servir le rsultat d'un choix
    unique, au lieu de renvoyer un rsultat HTTP 300 (MULTIPLE CHOICES),
    lorsque que plusieurs choix quivalents sont disponibles. Par
    exemple, avec les deux directives ci-dessous, si l'en-tte
    <code>Accept-Language</code> de l'utilisateur assigne 
    <code>en</code> et <code>de</code> une qualit de <code>.500</code>
    (les deux langages sont galement acceptables), alors c'est la
    premire variante acceptable de langue <code>en</code> qui sera
    servie.</p>

    <pre class="prettyprint lang-config">
LanguagePriority en fr de
ForceLanguagePriority Prefer
    </pre>


    <p><code>ForceLanguagePriority Fallback</code> utilise la directive
    <code class="directive"><a href="#languagepriority">LanguagePriority</a></code>
    pour servir un rsultat valide, au lieu de renvoyer un rsultat HTTP
    406 (NOT ACCEPTABLE). Avec les deux directives ci-dessous, si
    l'en-tte <code>Accept-Language</code> de l'utilisateur ne mentionne
    que les rponses de langage <code>es</code>, et si aucune variante
    dans cette langue n'est trouve, c'est la premire variante de la
    liste dfinie par la directive <code class="directive"><a href="#languagepriority">LanguagePriority</a></code> qui sera servie.</p>

    <pre class="prettyprint lang-config">
LanguagePriority en fr de
ForceLanguagePriority Fallback
    </pre>


    <p>Les deux options, <code>Prefer</code> et <code>Fallback</code>,
    peuvent tre spcifies, de faon  ce que la variante servie soit
    la premire variante qui convient dfinie par la directive
    <code class="directive"><a href="#languagepriority">LanguagePriority</a></code> si
    plusieurs variantes sont galement acceptables, ou le premier
    document disponible si aucune variante ne convient  la liste de
    langages acceptables fournie par le client.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="../mod/mod_mime.html#addlanguage">AddLanguage</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="LanguagePriority" id="LanguagePriority">LanguagePriority</a> <a name="languagepriority" id="languagepriority">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>L'ordre de priorit des variantes de langages pour les
cas o le client n'a pas formul de prfrences</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LanguagePriority <var>langage-MIME</var> [<var>langage-MIME</var>]
...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_negotiation</td></tr>
</table>
    <p>La directive <code class="directive">LanguagePriority</code> permet de
    dfinir, au cours du traitement d'une requte Multivues, l'ordre de
    priorit des variantes de langages pour les cas
    o le client n'a pas formul de prfrences. La liste numre les
    <var>langages-MIME</var> dans un ordre de prfrences
    dcroissantes.</p>

    <pre class="prettyprint lang-config">
      LanguagePriority en fr de
    </pre>


    <p>Dans le cas d'une requte pour <code>foo.html</code>, si
    <code>foo.html.fr</code> et <code>foo.html.de</code> existent, et si
    le client n'a pas formul de prfrences, c'est le fichier
    <code>foo.html.fr</code> qui sera renvoy.</p>

    <p>Notez que cette directive n'a d'effet que si le 'meilleur'
    langage n'a pas pu tre dtermin d'une autre manire ou si la
    valeur de la directive  <code class="directive"><a href="#forcelanguagepriority">ForceLanguagePriority</a></code> est
    diffrente de <code>None</code>. En gnral, c'est le client qui
    dtermine le langage prfr, non le serveur.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="../mod/mod_mime.html#addlanguage">AddLanguage</a></code></li>
</ul>
</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_negotiation.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_negotiation.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_negotiation.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_negotiation.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2013 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>