/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-interest-manager.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_INTEREST_MANAGER_H
#define __UNITY_WEBAPPS_INTEREST_MANAGER_H


#define UNITY_WEBAPPS_TYPE_INTEREST_MANAGER              (unity_webapps_interest_manager_get_type())
#define UNITY_WEBAPPS_INTEREST_MANAGER(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_INTEREST_MANAGER, UnityWebappsInterestManager))
#define UNITY_WEBAPPS_INTEREST_MANAGER_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_INTEREST_MANAGER, UnityWebappsInterestManagerClass))
#define UNITY_WEBAPPS_IS_INTEREST_MANAGER(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_INTEREST_MANAGER))
#define UNITY_WEBAPPS_IS_INTEREST_MANAGER_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_INTEREST_MANAGER))
#define UNITY_WEBAPPS_INTEREST_MANAGER_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_INTEREST_MANAGER, UnityWebappsInterestManagerClass))

typedef struct _UnityWebappsInterestManagerPrivate UnityWebappsInterestManagerPrivate;

typedef struct _UnityWebappsInterestManager UnityWebappsInterestManager;


struct _UnityWebappsInterestManager {
	GObject object;

	UnityWebappsInterestManagerPrivate *priv;
	//	UnityWebappsGenInterestManager *interest_manager_proxy;
	//	GDBusConnection *session_bus;
};

typedef struct _UnityWebappsInterest {
	gint id;
	
	gchar *sender;
	gint64 window;
	
	gboolean active;
	gchar *location;
	
	GList *pending_invocations;
	
	guint watcher_id;
	UnityWebappsInterestManager *manager;
	
	gboolean ready;
} UnityWebappsInterest;

typedef struct _UnityWebappsInterestManagerClass UnityWebappsInterestManagerClass;

struct _UnityWebappsInterestManagerClass
{
	GObjectClass parent_class;
};

GType unity_webapps_interest_manager_get_type (void) G_GNUC_CONST;

UnityWebappsInterestManager *unity_webapps_interest_manager_new ();

gint unity_webapps_interest_manager_add_interest (UnityWebappsInterestManager *manager,
												  const gchar *interest_name);

void unity_webapps_interest_manager_remove_interest (UnityWebappsInterestManager *manager,
													 gint interest_id,
													 gboolean user_abandoned);
guint unity_webapps_interest_manager_get_num_interests (UnityWebappsInterestManager *manager);
GVariant *unity_webapps_interest_manager_list_interests (UnityWebappsInterestManager *manager);

const gchar *unity_webapps_interest_manager_get_interest_owner (UnityWebappsInterestManager *manager,
																gint interest_id);

gboolean unity_webapps_interest_manager_get_interest_is_active (UnityWebappsInterestManager *manager,
																gint interest_id);

void unity_webapps_interest_manager_set_interest_is_active (UnityWebappsInterestManager *manager,
															gint interest_id,
															gboolean is_active);

const gchar *unity_webapps_interest_manager_get_interest_location (UnityWebappsInterestManager *manager,
																   gint interest_id);
void unity_webapps_interest_manager_set_interest_location (UnityWebappsInterestManager *manager,
														   gint interest_id,
														   const gchar *location);

guint64 unity_webapps_interest_manager_get_interest_window (UnityWebappsInterestManager *manager,
														   gint interest_id);

void unity_webapps_interest_manager_set_interest_window (UnityWebappsInterestManager *manager,
														 gint interest_id,
														 guint64 window);

void unity_webapps_interest_manager_clear_preview_requests (UnityWebappsInterestManager *manager,
															gint interest_id,
															const gchar *preview_data);
void unity_webapps_interest_manager_add_preview_request (UnityWebappsInterestManager *manager,
														 gint interest_id,
														 GDBusMethodInvocation *invocation);

gint
unity_webapps_interest_manager_get_active_interest_at_window (UnityWebappsInterestManager *manager,
															  guint64 window_id);

void unity_webapps_interest_manager_remove_interests_with_name (UnityWebappsInterestManager *manager,
																const gchar *name);

#endif
