/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.java;

import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.sort.AlphanumericCollator;
import net.sf.saxon.sort.LowercaseFirstCollator;
import net.sf.saxon.sort.NamedCollation;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.sort.UppercaseFirstCollator;
import net.sf.saxon.trans.XPathException;

public abstract class JavaCollationFactory {
    private JavaCollationFactory() {
    }

    public static StringCollator makeCollation(Configuration config, String uri, Properties props) throws XPathException {
        String alphanumeric;
        String caseOrder;
        Collator collator = null;
        StringCollator stringCollator = null;
        String classAtt = props.getProperty("class");
        if (classAtt != null) {
            Object comparator = config.getInstance(classAtt, null);
            if (comparator instanceof Collator) {
                collator = (Collator)comparator;
            } else if (comparator instanceof StringCollator) {
                stringCollator = (StringCollator)comparator;
            } else if (comparator instanceof Comparator) {
                stringCollator = new NamedCollation(uri, (Comparator)comparator);
            } else {
                throw new XPathException("Requested collation class " + classAtt + " is not a Comparator");
            }
        }
        if (collator == null && stringCollator == null) {
            String rulesAtt = props.getProperty("rules");
            if (rulesAtt != null && collator == null) {
                try {
                    collator = new RuleBasedCollator(rulesAtt);
                }
                catch (ParseException e) {
                    throw new XPathException("Invalid collation rules: " + e.getMessage());
                }
            }
            if (collator == null) {
                String langAtt = props.getProperty("lang");
                collator = langAtt != null ? Collator.getInstance(JavaCollationFactory.getLocale(langAtt)) : Collator.getInstance();
            }
        }
        if (collator != null) {
            String decompositionAtt;
            String ignore;
            String strengthAtt = props.getProperty("strength");
            if (strengthAtt != null) {
                if (strengthAtt.equals("primary") && collator instanceof Collator) {
                    collator.setStrength(0);
                } else if (strengthAtt.equals("secondary")) {
                    collator.setStrength(1);
                } else if (strengthAtt.equals("tertiary")) {
                    collator.setStrength(2);
                } else if (strengthAtt.equals("identical")) {
                    collator.setStrength(3);
                } else {
                    throw new XPathException("strength must be primary, secondary, tertiary, or identical");
                }
            }
            if ((ignore = props.getProperty("ignore-width")) != null) {
                if (ignore.equals("yes") && strengthAtt == null && collator instanceof Collator) {
                    collator.setStrength(2);
                } else if (!ignore.equals("no")) {
                    throw new XPathException("ignore-width must be yes or no");
                }
            }
            if ((ignore = props.getProperty("ignore-case")) != null && strengthAtt == null && collator instanceof Collator) {
                if (ignore.equals("yes")) {
                    collator.setStrength(1);
                } else if (!ignore.equals("no")) {
                    throw new XPathException("ignore-case must be yes or no");
                }
            }
            if ((ignore = props.getProperty("ignore-modifiers")) != null) {
                if (ignore.equals("yes") && strengthAtt == null && collator instanceof Collator) {
                    collator.setStrength(0);
                } else if (!ignore.equals("no")) {
                    throw new XPathException("ignore-modifiers must be yes or no");
                }
            }
            if ((decompositionAtt = props.getProperty("decomposition")) != null && collator instanceof Collator) {
                if (decompositionAtt.equals("none")) {
                    collator.setDecomposition(0);
                } else if (decompositionAtt.equals("standard")) {
                    collator.setDecomposition(1);
                } else if (decompositionAtt.equals("full")) {
                    collator.setDecomposition(2);
                } else {
                    throw new XPathException("decomposition must be non, standard, or full");
                }
            }
        }
        if (stringCollator == null) {
            stringCollator = new NamedCollation(uri, collator);
        }
        if ((caseOrder = props.getProperty("case-order")) != null && !"#default".equals(caseOrder)) {
            collator.setStrength(1);
            if (caseOrder.equals("lower-first")) {
                stringCollator = new LowercaseFirstCollator(stringCollator);
            } else if (caseOrder.equals("upper-first")) {
                stringCollator = new UppercaseFirstCollator(stringCollator);
            } else {
                throw new XPathException("case-order must be lower-first, upper-first, or #default");
            }
        }
        if ((alphanumeric = props.getProperty("alphanumeric")) != null && !"no".equals(alphanumeric)) {
            if (alphanumeric.equals("yes")) {
                stringCollator = new AlphanumericCollator(stringCollator);
            } else {
                throw new XPathException("alphanumeric must be yes or no");
            }
        }
        return stringCollator;
    }

    private static Locale getLocale(String lang) {
        String country;
        String language;
        int hyphen = lang.indexOf("-");
        if (hyphen < 1) {
            language = lang;
            country = "";
        } else {
            language = lang.substring(1, hyphen);
            country = lang.substring(hyphen + 1);
        }
        return new Locale(language, country);
    }
}

