/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.cliparams;

import amazon.fws.clicommando.config.OptionConfig;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.processors.cliparams.CliParamProcessor;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class ArgumentCliParamProcessor
extends CliParamProcessor {
    private int index;

    public ArgumentCliParamProcessor(ParamConfig paramConfig, String[] commandLineArguments) {
        super(paramConfig, commandLineArguments);
    }

    public void loadOptions(Options options) throws CliCommandoException {
        List<OptionConfig> optionConfigList = this.paramConfig.getOptions();
        this.validateOptions(optionConfigList);
        OptionConfig optionConfig = optionConfigList.get(0);
        this.setIndex(optionConfig);
        if (optionConfig.getOptionalValue() == null) {
            OptionBuilder.withLongOpt((String)optionConfig.getLongOpt());
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.hasArg();
            options.addOption(OptionBuilder.create((String)optionConfig.getShortOpt()));
        } else {
            OptionBuilder.withLongOpt((String)optionConfig.getLongOpt());
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.hasOptionalArg();
            options.addOption(OptionBuilder.create((String)optionConfig.getShortOpt()));
        }
    }

    public void loadValuesFromCommandLine(CommandLine line) throws CliCommandoException {
        OptionConfig optionConfig = this.paramConfig.getFirstOption();
        String specifiedOptionName = this.getUsedOptionName(line, optionConfig);
        String paramValue = null;
        if (specifiedOptionName != null) {
            paramValue = line.getOptionValue(specifiedOptionName);
            if (paramValue == null) {
                paramValue = optionConfig.getOptionalValue();
            }
        } else {
            paramValue = this.getArgument();
        }
        if (paramValue != null) {
            this.paramConfig.setValue(paramValue);
        }
    }

    private void setIndex(OptionConfig optionConfig) {
        this.index = optionConfig.getIndex();
        if (this.index < 0) {
            throw new ConfigurationErrorException("Illegal index number: " + optionConfig.toString());
        }
    }

    private int getIndex() {
        return this.index;
    }

    private String getArgument() {
        String retArg = null;
        int argNum = this.getIndex() + 1;
        if (this.commandLineArgs.length > argNum) {
            for (int i = 1; i <= argNum; ++i) {
                String arg = this.commandLineArgs[i];
                if (!arg.startsWith("-")) continue;
                return null;
            }
            return this.commandLineArgs[argNum];
        }
        return retArg;
    }
}

