/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CancelSpotInstanceRequestsRequest
extends AmazonWebServiceRequest {
    private Boolean dryRun;
    private List<String> spotInstanceRequestIds;

    public CancelSpotInstanceRequestsRequest() {
    }

    public CancelSpotInstanceRequestsRequest(List<String> spotInstanceRequestIds) {
        this.spotInstanceRequestIds = spotInstanceRequestIds;
    }

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public CancelSpotInstanceRequestsRequest withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public List<String> getSpotInstanceRequestIds() {
        if (this.spotInstanceRequestIds == null) {
            this.spotInstanceRequestIds = new ArrayList<String>();
        }
        return this.spotInstanceRequestIds;
    }

    public void setSpotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
        if (spotInstanceRequestIds == null) {
            this.spotInstanceRequestIds = null;
            return;
        }
        ArrayList<String> spotInstanceRequestIdsCopy = new ArrayList<String>(spotInstanceRequestIds.size());
        spotInstanceRequestIdsCopy.addAll(spotInstanceRequestIds);
        this.spotInstanceRequestIds = spotInstanceRequestIdsCopy;
    }

    public CancelSpotInstanceRequestsRequest withSpotInstanceRequestIds(String ... spotInstanceRequestIds) {
        if (this.getSpotInstanceRequestIds() == null) {
            this.setSpotInstanceRequestIds(new ArrayList<String>(spotInstanceRequestIds.length));
        }
        for (String value : spotInstanceRequestIds) {
            this.getSpotInstanceRequestIds().add(value);
        }
        return this;
    }

    public CancelSpotInstanceRequestsRequest withSpotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
        if (spotInstanceRequestIds == null) {
            this.spotInstanceRequestIds = null;
        } else {
            ArrayList<String> spotInstanceRequestIdsCopy = new ArrayList<String>(spotInstanceRequestIds.size());
            spotInstanceRequestIdsCopy.addAll(spotInstanceRequestIds);
            this.spotInstanceRequestIds = spotInstanceRequestIdsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dryRun != null) {
            sb.append("DryRun: " + this.dryRun + ", ");
        }
        if (this.spotInstanceRequestIds != null) {
            sb.append("SpotInstanceRequestIds: " + this.spotInstanceRequestIds + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isDryRun() == null ? 0 : this.isDryRun().hashCode());
        hashCode = 31 * hashCode + (this.getSpotInstanceRequestIds() == null ? 0 : this.getSpotInstanceRequestIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotInstanceRequestsRequest)) {
            return false;
        }
        CancelSpotInstanceRequestsRequest other = (CancelSpotInstanceRequestsRequest)((Object)obj);
        if (other.isDryRun() == null ^ this.isDryRun() == null) {
            return false;
        }
        if (other.isDryRun() != null && !other.isDryRun().equals(this.isDryRun())) {
            return false;
        }
        if (other.getSpotInstanceRequestIds() == null ^ this.getSpotInstanceRequestIds() == null) {
            return false;
        }
        return other.getSpotInstanceRequestIds() == null || other.getSpotInstanceRequestIds().equals(this.getSpotInstanceRequestIds());
    }
}

