/* This file is part of KDevelop
    Copyright 2007 David Nolden <david.nolden.kdevelop@art-master.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "indexeddeclaration.h"

#include "declaration.h"
#include "duchain.h"
#include "topducontextdynamicdata.h"

using namespace KDevelop;

IndexedDeclaration::IndexedDeclaration(uint topContext, uint declarationIndex)
  : m_topContext(topContext)
  , m_declarationIndex(declarationIndex)
{
}

IndexedDeclaration::IndexedDeclaration(const Declaration* decl)
{
  if(decl) {
    m_topContext = decl->topContext()->ownIndex();
    m_declarationIndex = decl->m_indexInTopContext;
  }else{
    m_topContext = 0;
    m_declarationIndex = 0;
  }
}

Declaration* IndexedDeclaration::declaration() const
{
  if(isDummy())
    return nullptr;
//   ENSURE_CHAIN_READ_LOCKED
  if(!m_topContext || !m_declarationIndex)
    return nullptr;

  TopDUContext* ctx = DUChain::self()->chainForIndex(m_topContext);
  if(!ctx)
    return nullptr;

  return ctx->m_dynamicData->getDeclarationForIndex(m_declarationIndex);
}
