/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsr239;

import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Enumeration;
import java.util.Hashtable;

public class BufferManager {
    static Hashtable bufferStrongReferences = new Hashtable();
    static Hashtable bufferWeakReferences = new Hashtable();

    public static synchronized void newBuffer(Buffer buffer, int n) {
        bufferWeakReferences.put(new WeakReference(buffer), new Integer(n));
    }

    static synchronized void useBuffer(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        Object object = bufferStrongReferences.get(buffer);
        int n = object == null ? 0 : (Integer)object;
        bufferStrongReferences.put(buffer, new Integer(n + 1));
    }

    static synchronized void releaseBuffer(Buffer buffer) {
        int n;
        if (buffer == null) {
            return;
        }
        Object object = bufferStrongReferences.get(buffer);
        int n2 = n = object == null ? 0 : (Integer)object;
        if (n > 1) {
            bufferStrongReferences.put(buffer, new Integer(n - 1));
        } else {
            bufferStrongReferences.remove(buffer);
        }
    }

    static synchronized void gc() {
        Enumeration enumeration = bufferWeakReferences.keys();
        while (enumeration.hasMoreElements()) {
            WeakReference weakReference = (WeakReference)enumeration.nextElement();
            if (weakReference.get() != null) continue;
            Object object = bufferWeakReferences.get(weakReference);
            bufferWeakReferences.remove(weakReference);
            int n = (Integer)object;
            BufferManager._freeNative(n);
        }
    }

    static native void _freeNative(int var0);

    static void getBytes(Buffer buffer, int n, byte[] byArray, int n2, int n3) {
        int n4 = BufferManager._getNativeAddress(buffer, 0);
        int n5 = BufferManager.byteCapacity(buffer);
        if (n < 0 || n + n3 > n5) {
            throw new IllegalArgumentException("boffset out of bounds");
        }
        if (n2 < 0 || n2 + n3 > byArray.length) {
            throw new IllegalArgumentException("offset out of bounds");
        }
        BufferManager._getBytes(n4 + n, byArray, n2, n3);
    }

    private static int byteCapacity(Buffer buffer) {
        int n = buffer.capacity();
        if (buffer instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)buffer;
            if (!byteBuffer.isDirect()) {
                throw new IllegalArgumentException("!isDirect");
            }
            return n;
        }
        if (buffer instanceof ShortBuffer) {
            ShortBuffer shortBuffer = (ShortBuffer)buffer;
            if (!shortBuffer.isDirect()) {
                throw new IllegalArgumentException("!isDirect");
            }
            return n * 2;
        }
        if (buffer instanceof IntBuffer) {
            IntBuffer intBuffer = (IntBuffer)buffer;
            if (!intBuffer.isDirect()) {
                throw new IllegalArgumentException("!isDirect");
            }
            return n * 4;
        }
        if (buffer instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)buffer;
            if (!floatBuffer.isDirect()) {
                throw new IllegalArgumentException("!isDirect");
            }
            return n * 4;
        }
        throw new IllegalArgumentException("Unknown buffer type!");
    }

    static native void _getBytes(int var0, byte[] var1, int var2, int var3);

    static int pointer(Buffer buffer) {
        return BufferManager._getNativeAddress(buffer, buffer.position());
    }

    static native int _getNativeAddress(Buffer var0, int var1);
}

