/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;
import java.util.NoSuchElementException;

public class WrappedOperand
implements ADQLOperand {
    public static final LanguageFeature FEATURE = new LanguageFeature(null, "OPERAND_WRAP", false, "An operand wrapped between parenthesis.");
    private ADQLOperand operand;
    private TextPosition position = null;

    public WrappedOperand(ADQLOperand operand) throws NullPointerException {
        if (operand == null) {
            throw new NullPointerException("Impossible to wrap a NULL operand: (NULL) has no sense!");
        }
        this.operand = operand;
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    public final ADQLOperand getOperand() {
        return this.operand;
    }

    @Override
    public final boolean isNumeric() {
        return this.operand.isNumeric();
    }

    @Override
    public final boolean isString() {
        return this.operand.isString();
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    @Override
    public final boolean isGeometry() {
        return this.operand.isGeometry();
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new WrappedOperand((ADQLOperand)this.operand.getCopy());
    }

    @Override
    public String getName() {
        return this.operand.getName();
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean operandGot;
            {
                this.operandGot = WrappedOperand.this.operand == null;
            }

            @Override
            public ADQLObject next() {
                if (this.operandGot) {
                    throw new NoSuchElementException();
                }
                this.operandGot = true;
                return WrappedOperand.this.operand;
            }

            @Override
            public boolean hasNext() {
                return !this.operandGot;
            }

            @Override
            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (!this.operandGot) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called!");
                }
                if (replacer == null) {
                    this.remove();
                } else if (replacer instanceof ADQLOperand) {
                    WrappedOperand.this.operand = (ADQLOperand)replacer;
                    WrappedOperand.this.position = null;
                } else {
                    throw new UnsupportedOperationException("Impossible to replace an ADQLOperand (\"" + WrappedOperand.this.operand + "\") by a " + replacer.getClass().getName() + " (\"" + replacer.toADQL() + "\")!");
                }
            }

            @Override
            public void remove() {
                if (!this.operandGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called!");
                }
                throw new UnsupportedOperationException("Impossible to remove the only item of the WrappedOperand \"" + WrappedOperand.this.toADQL() + "\": the WrappedOperand would be empty!");
            }
        };
    }

    @Override
    public String toADQL() {
        return "(" + this.operand.toADQL() + ")";
    }
}

