/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.binary;

import info.aduna.io.IOUtil;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.ListBindingSet;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParserBase;
import org.openrdf.query.resultio.binary.BinaryQueryResultConstants;
import org.openrdf.query.resultio.binary.QueryErrorType;

public class BinaryQueryResultParser
extends TupleQueryResultParserBase {
    private DataInputStream in;
    private int formatVersion;
    private CharsetDecoder charsetDecoder = Charset.forName("UTF-8").newDecoder();
    private String[] namespaceArray = new String[32];

    public BinaryQueryResultParser() {
    }

    public BinaryQueryResultParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public final TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.BINARY;
    }

    public synchronized void parse(InputStream in) throws IOException, QueryResultParseException, TupleQueryResultHandlerException {
        int columnCount;
        if (in == null) {
            throw new IllegalArgumentException("Input stream can not be 'null'");
        }
        if (this.handler == null) {
            throw new IllegalArgumentException("listener can not be 'null'");
        }
        this.in = new DataInputStream(in);
        byte[] magicNumber = IOUtil.readBytes(in, BinaryQueryResultConstants.MAGIC_NUMBER.length);
        if (!Arrays.equals(magicNumber, BinaryQueryResultConstants.MAGIC_NUMBER)) {
            throw new QueryResultParseException("File does not contain a binary RDF table result");
        }
        this.formatVersion = this.in.readInt();
        if (this.formatVersion != 3 && this.formatVersion != 1 && this.formatVersion != 2) {
            throw new QueryResultParseException("Incompatible format version: " + this.formatVersion);
        }
        if (this.formatVersion == 2) {
            this.in.readByte();
        }
        if ((columnCount = this.in.readInt()) < 1) {
            throw new QueryResultParseException("Illegal column count specified: " + columnCount);
        }
        ArrayList<String> columnHeaders = new ArrayList<String>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            columnHeaders.add(this.readString());
        }
        columnHeaders = Collections.unmodifiableList(columnHeaders);
        this.handler.startQueryResult(columnHeaders);
        ArrayList<URI> currentTuple = new ArrayList<URI>(columnCount);
        List<Value> previousTuple = Collections.nCopies(columnCount, null);
        byte recordTypeMarker = this.in.readByte();
        while (recordTypeMarker != 127) {
            if (recordTypeMarker == 126) {
                this.processError();
            } else if (recordTypeMarker == 2) {
                this.processNamespace();
            } else {
                Value value = null;
                switch (recordTypeMarker) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        value = previousTuple.get(currentTuple.size());
                        break;
                    }
                    case 3: {
                        value = this.readQName();
                        break;
                    }
                    case 4: {
                        value = this.readURI();
                        break;
                    }
                    case 5: {
                        value = this.readBnode();
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        value = this.readLiteral(recordTypeMarker);
                        break;
                    }
                    default: {
                        throw new IOException("Unkown record type: " + recordTypeMarker);
                    }
                }
                currentTuple.add((URI)value);
                if (currentTuple.size() == columnCount) {
                    previousTuple = Collections.unmodifiableList(currentTuple);
                    currentTuple = new ArrayList(columnCount);
                    this.handler.handleSolution(new ListBindingSet(columnHeaders, previousTuple));
                }
            }
            recordTypeMarker = this.in.readByte();
        }
        this.handler.endQueryResult();
    }

    private void processError() throws IOException, QueryResultParseException {
        byte errTypeFlag = this.in.readByte();
        QueryErrorType errType = null;
        if (errTypeFlag == 1) {
            errType = QueryErrorType.MALFORMED_QUERY_ERROR;
        } else if (errTypeFlag == 2) {
            errType = QueryErrorType.QUERY_EVALUATION_ERROR;
        } else {
            throw new QueryResultParseException("Unkown error type: " + errTypeFlag);
        }
        String msg = this.readString();
        throw new QueryResultParseException((Object)((Object)errType) + ": " + msg);
    }

    private void processNamespace() throws IOException {
        int namespaceID = this.in.readInt();
        String namespace = this.readString();
        if (namespaceID >= this.namespaceArray.length) {
            int newSize = Math.max(namespaceID, this.namespaceArray.length * 2);
            String[] newArray = new String[newSize];
            System.arraycopy(this.namespaceArray, 0, newArray, 0, this.namespaceArray.length);
            this.namespaceArray = newArray;
        }
        this.namespaceArray[namespaceID] = namespace;
    }

    private URI readQName() throws IOException {
        int nsID = this.in.readInt();
        String localName = this.readString();
        return this.valueFactory.createURI(this.namespaceArray[nsID], localName);
    }

    private URI readURI() throws IOException {
        String uri = this.readString();
        return this.valueFactory.createURI(uri);
    }

    private BNode readBnode() throws IOException {
        String bnodeID = this.readString();
        return this.valueFactory.createBNode(bnodeID);
    }

    private Literal readLiteral(int recordTypeMarker) throws IOException, QueryResultParseException {
        String label = this.readString();
        if (recordTypeMarker == 8) {
            URI datatype = null;
            byte dtTypeMarker = this.in.readByte();
            switch (dtTypeMarker) {
                case 3: {
                    datatype = this.readQName();
                    break;
                }
                case 4: {
                    datatype = this.readURI();
                    break;
                }
                default: {
                    throw new QueryResultParseException("Illegal record type marker for literal's datatype");
                }
            }
            return this.valueFactory.createLiteral(label, datatype);
        }
        if (recordTypeMarker == 7) {
            String language = this.readString();
            return this.valueFactory.createLiteral(label, language);
        }
        return this.valueFactory.createLiteral(label);
    }

    private String readString() throws IOException {
        if (this.formatVersion == 1) {
            return this.readStringV1();
        }
        return this.readStringV2();
    }

    private String readStringV1() throws IOException {
        return this.in.readUTF();
    }

    private String readStringV2() throws IOException {
        int stringLength = this.in.readInt();
        byte[] encodedString = IOUtil.readBytes((InputStream)this.in, stringLength);
        if (encodedString.length != stringLength) {
            throw new EOFException("Attempted to read " + stringLength + " bytes but no more than " + encodedString.length + " were available");
        }
        ByteBuffer byteBuf = ByteBuffer.wrap(encodedString);
        CharBuffer charBuf = this.charsetDecoder.decode(byteBuf);
        return charBuf.toString();
    }
}

