;; anthy-unicode-azik.el

;; Copyright (C) 2004
;; Author: Yutaka Hara<yhara@kmc.gr.jp>

;; add following 2 lines to ~/.emacs
;; (load-library "anthy-unicode-azik")
;; (anthy-azik-mode)
;;

(defvar anthy-azik-mode-hiragana-map
  '(
    (";" . "っ")  ("x;" . ";")  ("b." . "ぶ")  ("bd" . "べん")  ("bh" . "ぶう")  
    ("bj" . "ぶん")  ("bk" . "びん")  ("bl" . "ぼん")  ("bn" . "ばん")  ("bp" . "ぼう")  
    ("bq" . "ばい")  ("br" . "ばら")  ("bt" . "びと")  ("bw" . "べい")  ("bx" . "べい")  
    ("byd" . "びぇん")  ("byh" . "びゅう")  ("byj" . "びゅん")  ("byl" . "びょん")  ("byn" . "びゃん")  
    ("byp" . "びょう")  ("byq" . "びゃい")  ("byw" . "びぇい")  ("byz" . "びゃん")  ("bz" . "ばん")  
    ("ca" . "ちゃ")  ("cc" . "ちゃ")  ("cd" . "ちぇん")  ("ce" . "ちぇ")  ("cf" . "ちぇ")  
    ("ch" . "ちゅう")  ("ci" . "ち")  ("cj" . "ちゅん")  ("ck" . "ちん")  ("cl" . "ちょん")  
    ("cn" . "ちゃん")  ("co" . "ちょ")  ("cp" . "ちょう")  ("cq" . "ちゃい")  ("cu" . "ちゅ")  
    ("cv" . "ちゃい")  ("cw" . "ちぇい")  ("cx" . "ちぇい")  ("cz" . "ちゃん")  ("dch" . "でゅー")  
    ("dci" . "でぃ")  ("dck" . "でぃん")  ("dcp" . "どぅー")  ("dcu" . "でゅ")  ("dd" . "でん")  
    ("df" . "で")  ("dg" . "だが")  ("dh" . "づう")  ("dj" . "づん")  ("dk" . "ぢん")  
    ("dl" . "どん")  ("dm" . "でも")  ("dn" . "だん")  ("dp" . "どう")  ("dq" . "だい")  
    ("dr" . "である")  ("ds" . "です")  ("dt" . "だち")  ("dv" . "でん")  ("dw" . "でい")  
    ("dy" . "でぃ")  ("dz" . "だん")  ("fd" . "ふぇん")  ("fh" . "ふう")  ("fj" . "ふん")  
    ("fk" . "ふぃん")  ("fl" . "ふぉん")  ("fm" . "ふむ")  ("fn" . "ふぁん")  ("fp" . "ふぉー")  
    ("fq" . "ふぁい")  ("fr" . "ふる")  ("fs" . "ふぁい")  ("fw" . "ふぇい")  ("fz" . "ふぁん")  
    ("gd" . "げん")  ("gh" . "ぐう")  ("gj" . "ぐん")  ("gk" . "ぎん")  ("gl" . "ごん")  
    ("gn" . "がん")  ("gp" . "ごう")  ("gq" . "がい")  ("gr" . "がら")  ("gt" . "ごと")  
    ("gw" . "げい")  ("gyd" . "ぎぇん")  ("gyh" . "ぎゅう")  ("gyj" . "ぎゅん")  ("gyl" . "ぎょん")  
    ("gyn" . "ぎゃん")  ("gyp" . "ぎょう")  ("gyq" . "ぎゃい")  ("gyw" . "ぎぇい")  ("gyz" . "ぎゃん")  
    ("gz" . "がん")  ("hd" . "へん")  ("hf" . "ふ")  ("hga" . "ひゃ")  ("hgd" . "ひぇん")  
    ("hge" . "ひぇ")  ("hgh" . "ひゅう")  ("hgj" . "ひゅん")  ("hgl" . "ひょん")  ("hgn" . "ひゃん")  
    ("hgo" . "ひょ")  ("hgp" . "ひょう")  ("hgq" . "ひゃい")  ("hgu" . "ひゅ")  ("hgw" . "ひぇい")  
    ("hgz" . "ひゃん")  ("hh" . "ふう")  ("hj" . "ふん")  ("hk" . "ひん")  ("hl" . "ほん")  
    ("hn" . "はん")  ("hp" . "ほう")  ("hq" . "はい")  ("ht" . "ひと")  ("hw" . "へい")  
    ("hyd" . "ひぇん")  ("hyh" . "ひゅう")  ("hyl" . "ひょん")  ("hyp" . "ひょう")  ("hyq" . "ひゃい")  
    ("hyw" . "ひぇい")  ("hyz" . "ひゃん")  ("hz" . "はん")  ("jd" . "じぇん")  ("jf" . "じゅ")  
    ("jh" . "じゅう")  ("jj" . "じゅん")  ("jk" . "じん")  ("jl" . "じょん")  ("jn" . "じゃん")  
    ("jp" . "じょう")  ("jq" . "じゃい")  ("jv" . "じゅう")  ("jw" . "じぇい")  ("jz" . "じゃん")  
    ("kA" . "ヵ")  ("kE" . "ヶ")  ("kd" . "けん")  ("kf" . "き")  ("kga" . "きゃ")  
    ("kgd" . "きぇん")  ("kge" . "きぇ")  ("kgh" . "きゅう")  ("kgl" . "きょん")  ("kgn" . "きゃん")  
    ("kgo" . "きょ")  ("kgp" . "きょう")  ("kgq" . "きゃい")  ("kgu" . "きゅ")  ("kgw" . "きぇい")  
    ("kgz" . "きゃん")  ("kh" . "くう")  ("kj" . "くん")  ("kk" . "きん")  ("kl" . "こん")  
    ("km" . "き")  ("kn" . "かん")  ("kp" . "こう")  ("kq" . "かい")  ("kr" . "から")  
    ("kt" . "こと")  ("kv" . "きん")  ("kw" . "けい")  ("kyd" . "きぇん")  ("kyh" . "きゅう")  
    ("kyj" . "きゅん")  ("kyl" . "きょん")  ("kyn" . "きゃん")  ("kyp" . "きょう")  ("kyq" . "きゃい")  
    ("kyw" . "きぇい")  ("kyz" . "きゃん")  ("kz" . "かん")  ("m." . "む")  ("md" . "めん")  
    ("mf" . "む")  ("mga" . "みゃ")  ("mgd" . "みぇん")  ("mge" . "みぇ")  ("mgh" . "みゅう")  
    ("mgj" . "みゅん")  ("mgl" . "みょん")  ("mgn" . "みゃん")  ("mgo" . "みょ")  ("mgp" . "みょう")  
    ("mgq" . "みゃい")  ("mgu" . "みゅ")  ("mgw" . "みぇい")  ("mgz" . "みゃん")  ("mh" . "むう")  
    ("mj" . "むん")  ("mk" . "みん")  ("ml" . "もん")  ("mn" . "もの")  ("mp" . "もう")  
    ("mq" . "まい")  ("mr" . "まる")  ("ms" . "ます")  ("mt" . "また")  ("mv" . "むん")  
    ("mw" . "めい")  ("myd" . "みぇん")  ("myh" . "みゅう")  ("myj" . "みゅん")  ("myl" . "みょん")  
    ("myn" . "みゃん")  ("myp" . "みょう")  ("myq" . "みゃい")  ("myw" . "みぇい")  ("myz" . "みゃん")  
    ("mz" . "まん")  ("n." . "ぬ")  ("nb" . "ねば")  ("nd" . "ねん")  ("nf" . "ぬ")  
    ("nga" . "にゃ")  ("ngd" . "にぇん")  ("nge" . "にぇ")  ("ngh" . "にゅう")  ("ngj" . "にゅん")  
    ("ngl" . "にょん")  ("ngn" . "にゃん")  ("ngo" . "にょ")  ("ngp" . "にょう")  ("ngq" . "にゃい")  
    ("ngu" . "にゅ")  ("ngw" . "にぇい")  ("ngz" . "にゃん")  ("nh" . "ぬう")  ("nj" . "ぬん")  
    ("nk" . "にん")  ("nl" . "のん")  ("np" . "のう")  ("nq" . "ない")  ("nr" . "なる")  
    ("nt" . "にち")  ("nv" . "ぬん")  ("nw" . "ねい")  ("nyd" . "にぇん")  ("nyh" . "にゅう")  
    ("nyj" . "にゅん")  ("nyl" . "にょん")  ("nyn" . "にゃん")  ("nyp" . "にょう")  ("nyq" . "にゃい")  
    ("nyw" . "にぇい")  ("nyz" . "にゃん")  ("nz" . "なん")  ("pd" . "ぺん")  ("pf" . "ぽん")  
    ("pga" . "ぴゃ")  ("pgd" . "ぴぇん")  ("pge" . "ぴぇ")  ("pgh" . "ぴゅう")  ("pgj" . "ぴゅん")  
    ("pgl" . "ぴょん")  ("pgn" . "ぴゃん")  ("pgo" . "ぴょ")  ("pgp" . "ぴょう")  ("pgq" . "ぴゃい")  
    ("pgu" . "ぴゅ")  ("pgw" . "ぴぇい")  ("pgz" . "ぴゃん")  ("ph" . "ぷう")  ("pj" . "ぷん")  
    ("pk" . "ぴん")  ("pl" . "ぽん")  ("pn" . "ぱん")  ("pp" . "ぽう")  ("pq" . "ぱい")  
    ("pv" . "ぽう")  ("pw" . "ぺい")  ("pyd" . "ぴぇん")  ("pyh" . "ぴゅう")  ("pyj" . "ぴゅん")  
    ("pyl" . "ぴょん")  ("pyn" . "ぴゃん")  ("pyp" . "ぴょう")  ("pyq" . "ぴゃい")  ("pyw" . "ぴぇい")  
    ("pyz" . "ぴゃん")  ("pz" . "ぱん")  ("q" . "ん")  ("rd" . "れん")  ("rh" . "るう")  
    ("rj" . "るん")  ("rk" . "りん")  ("rl" . "ろん")  ("rn" . "らん")  ("rp" . "ろう")  
    ("rq" . "らい")  ("rr" . "られ")  ("rw" . "れい")  ("ryd" . "りぇん")  ("ryh" . "りゅう")  
    ("ryj" . "りゅん")  ("ryk" . "りょく")  ("ryl" . "りょん")  ("ryn" . "りゃん")  ("ryp" . "りょう")  
    ("ryq" . "りゃい")  ("ryw" . "りぇい")  ("ryz" . "りゃん")  ("rz" . "らん")  ("sd" . "せん")  
    ("sf" . "さい")  ("sh" . "すう")  ("sj" . "すん")  ("sk" . "しん")  ("sl" . "そん")  
    ("sm" . "しも")  ("sn" . "さん")  ("sp" . "そう")  ("sq" . "さい")  ("sr" . "する")  
    ("ss" . "せい")  ("st" . "した")  ("sv" . "さい")  ("sw" . "せい")  ("syd" . "しぇん")  
    ("syh" . "しゅう")  ("syj" . "しゅん")  ("syl" . "しょん")  ("syp" . "しょう")  ("syq" . "しゃい")  
    ("syw" . "しぇい")  ("syz" . "しゃん")  ("sz" . "さん")  ("tU" . "っ")  ("tb" . "たび")  
    ("td" . "てん")  ("tgh" . "てゅー")  ("tgi" . "てぃ")  ("tgk" . "てぃん")  ("tgp" . "とぅー")  
    ("tgu" . "てゅ")  ("th" . "つう")  ("tj" . "つん")  ("tk" . "ちん")  ("tl" . "とん")  
    ("tm" . "ため")  ("tn" . "たん")  ("tp" . "とう")  ("tq" . "たい")  ("tr" . "たら")  
    ("tsU" . "っ")  ("tsa" . "つぁ")  ("tse" . "つぇ")  ("tsi" . "つぃ")  ("tso" . "つぉ")  
    ("tt" . "たち")  ("tw" . "てい")  ("tyd" . "ちぇん")  ("tyh" . "ちゅう")  ("tyj" . "ちゅん")  
    ("tyl" . "ちょん")  ("tyn" . "ちゃん")  ("typ" . "ちょう")  ("tyq" . "ちゃい")  ("tyw" . "ちぇい")  
    ("tyz" . "ちゃん")  ("tz" . "たん")  ("vd" . "う゛ぇん")  ("vk" . "う゛ぃん")  ("vl" . "う゛ぉん")  
    ("vn" . "う゛ぁん")  ("vp" . "う゛ぉー")  ("vq" . "う゛ぁい")  ("vw" . "う゛ぇい")  ("vya" . "う゛ゃ")  
    ("vye" . "う゛ぇ")  ("vyo" . "う゛ょ")  ("vyu" . "う゛ゅ")  ("vz" . "う゛ぁん")  ("wA" . "ゎ")  
    ("wd" . "うぇん")  ("wf" . "わ")  ("wha" . "うぁ")  ("whe" . "うぇ")  ("whi" . "うぃ")  
    ("who" . "うぉ")  ("whu" . "う")  ("wk" . "うぃん")  ("wl" . "うぉん")  ("wn" . "わん")  
    ("wp" . "うぉー")  ("wq" . "わい")  ("wr" . "われ")  ("wso" . "うぉ")  ("wt" . "わた")  
    ("wz" . "わん")  ("xa" . "しゃ")  ("xc" . "しゃ")  ("xd" . "しぇん")  ("xe" . "しぇ")  
    ("xf" . "しぇい")  ("xh" . "しゅう")  ("xi" . "し")  ("xj" . "しゅん")  ("xk" . "しん")  
    ("xl" . "しょん")  ("xn" . "しゃん")  ("xo" . "しょ")  ("xp" . "しょう")  ("xq" . "しゃい")  
    ("xt" . "しゅつ")  ("xu" . "しゅ")  ("xv" . "しゃい")  ("xw" . "しぇい")  ("xxa" . "ぁ")  
    ("xxe" . "ぇ")  ("xxi" . "ぃ")  ("xxo" . "ぉ")  ("xxu" . "ぅ")  ("xxh" . "←")  
    ("xxj" . "↓")  ("xxk" . "↑")  ("xxl" . "→")  ("xz" . "しゃん")  ("y<" . "←")  
    ("y>" . "→")  ("y^" . "↑")  ("yf" . "ゆ")  ("yh" . "ゆう")  ("yi" . "ゐ")  
    ("yj" . "ゆん")  ("yl" . "よん")  ("yn" . "やん")  ("yp" . "よう")  ("yq" . "やい")  
    ("yr" . "よる")  ("yv" . "ゆう")  ("yz" . "やん")  ("z." . "ず")  ("zc" . "ざ")  
    ("zd" . "ぜん")  ("zf" . "ぜ")  ("zh" . "ずう")  ("zj" . "ずん")  ("zk" . "じん")  
    ("zl" . "ぞん")  ("zn" . "ざん")  ("zp" . "ぞう")  ("zq" . "ざい")  ("zr" . "ざる")  
    ("zv" . "ざい")  ("zw" . "ぜい")  ("zx" . "ぜい")  ("zyd" . "じぇん")  ("zyh" . "じゅう")  
    ("zyj" . "じゅん")  ("zyl" . "じょん")  ("zyn" . "じゃん")  ("zyp" . "じょう")  ("zyq" . "じゃい")  
    ("zyw" . "じぇい")  ("zyz" . "じゃん")  ("zz" . "ざん")  ("bx" . "びょう")  ("bx" . "びょう")  
    ("dx" . "ぢょう")  ("gx" . "ぎょう")  ("hx" . "ひょう")  ("kx" . "きょう")  ("mx" . "みょう")  
    ("nx" . "にょう")  ("px" . "ぴょう")  ("rx" . "りょう")  ("sx" . "しょう")  ("bv" . "びゅう")  
    ("dv" . "ぢゅう")  ("fv" . "ふゅー")  ("gv" . "ぎゅう")  ("hv" . "ひゅう")  ("kv" . "きゅう")  
    ("mv" . "みゅう")  ("nv" . "にゅう")  ("pv" . "ぴゅう")  ("rv" . "りゅう")  ("sv" . "しゅう")  
    ("vv" . "う゛ゅー")      
    ))

; (defvar anthy-azik-mode-katakana-map
;   '(
;     (";" . "ッ")  ("x;" . ";")  ("b." . "ブ")  ("bd" . "ベン")  ("bh" . "ブウ")  
;     ("bj" . "ブン")  ("bk" . "ビン")  ("bl" . "ゥs")  ("bn" . "バン")  ("bp" . "ゥ&")  
;     ("bq" . "バイ")  ("br" . "バラ")  ("bt" . "ビト")  ("bw" . "ベイ")  ("bx" . "ベイ")  
;     ("byd" . "ビェン")  ("byh" . "ビュウ")  ("byj" . "ビュン")  ("byl" . "ビョン")  ("byn" . "ビャン")  
;     ("byp" . "ビョウ")  ("byq" . "ビャイ")  ("byw" . "ビェイ")  ("byz" . "ビャン")  ("bz" . "バン")  
;     ("ca" . "チャ")  ("cc" . "チャ")  ("cd" . "チェン")  ("ce" . "チェ")  ("cf" . "チェ")  
;     ("ch" . "チュウ")  ("ci" . "チ")  ("cj" . "チュン")  ("ck" . "チン")  ("cl" . "チョン")  
;     ("cn" . "チャン")  ("co" . "チョ")  ("cp" . "チョウ")  ("cq" . "チャイ")  ("cu" . "チュ")  
;     ("cv" . "チャイ")  ("cw" . "チェイ")  ("cx" . "チェイ")  ("cz" . "チャン")  ("dch" . "デュー")  
;     ("dci" . "ディ")  ("dck" . "ディン")  ("dcp" . "ドゥー")  ("dcu" . "デュ")  ("dd" . "デン")  
;     ("df" . "デ")  ("dg" . "ダガ")  ("dh" . "ヅウ")  ("dj" . "ヅン")  ("dk" . "ヂン")  
;     ("dl" . "ドン")  ("dm" . "デモ")  ("dn" . "ダン")  ("dp" . "ドウ")  ("dq" . "ダイ")  
;     ("dr" . "デアル")  ("ds" . "デス")  ("dt" . "ダチ")  ("dv" . "デン")  ("dw" . "デイ")  
;     ("dy" . "ディ")  ("dz" . "ダン")  ("fd" . "フェン")  ("fh" . "フウ")  ("fj" . "フン")  
;     ("fk" . "フィン")  ("fl" . "フォン")  ("fm" . "フム")  ("fn" . "ファン")  ("fp" . "フォー")  
;     ("fq" . "ファイ")  ("fr" . "フル")  ("fs" . "ファイ")  ("fw" . "フェイ")  ("fz" . "ファン")  
;     ("gd" . "ゲン")  ("gh" . "グウ")  ("gj" . "グン")  ("gk" . "ギン")  ("gl" . "ゴン")  
;     ("gn" . "ガン")  ("gp" . "ゴウ")  ("gq" . "ガイ")  ("gr" . "ガラ")  ("gt" . "ゴト")  
;     ("gw" . "ゲイ")  ("gyd" . "ギェン")  ("gyh" . "ギュウ")  ("gyj" . "ギュン")  ("gyl" . "ギョン")  
;     ("gyn" . "ギャン")  ("gyp" . "ギョウ")  ("gyq" . "ギャイ")  ("gyw" . "ギェイ")  ("gyz" . "ギャン")  
;     ("gz" . "ガン")  ("hd" . "ヘン")  ("hf" . "フ")  ("hga" . "ヒャ")  ("hgd" . "ヒェン")  
;     ("hge" . "ヒェ")  ("hgh" . "ヒュウ")  ("hgj" . "ヒュン")  ("hgl" . "ヒョン")  ("hgn" . "ヒャン")  
;     ("hgo" . "ヒョ")  ("hgp" . "ヒョウ")  ("hgq" . "ヒャイ")  ("hgu" . "ヒュ")  ("hgw" . "ヒェイ")  
;     ("hgz" . "ヒャン")  ("hh" . "フウ")  ("hj" . "フン")  ("hk" . "ヒン")  ("hl" . "ホン")  
;     ("hn" . "ハン")  ("hp" . "ホウ")  ("hq" . "ハイ")  ("ht" . "ヒト")  ("hw" . "ヘイ")  
;     ("hyd" . "ヒェン")  ("hyh" . "ヒュウ")  ("hyl" . "ヒョン")  ("hyp" . "ヒョウ")  ("hyq" . "ヒャイ")  
;     ("hyw" . "ヒェイ")  ("hyz" . "ヒャン")  ("hz" . "ハン")  ("jd" . "ジェン")  ("jf" . "ジュ")  
;     ("jh" . "ジュウ")  ("jj" . "ジュン")  ("jk" . "ジン")  ("jl" . "ジョン")  ("jn" . "ジャン")  
;     ("jp" . "ジョウ")  ("jq" . "ジャイ")  ("jv" . "ジュウ")  ("jw" . "ジェイ")  ("jz" . "ジャン")  
;     ("kA" . "ヵ")  ("kE" . "ヶ")  ("kd" . "ケン")  ("kf" . "キ")  ("kga" . "キャ")  
;     ("kgd" . "キェン")  ("kge" . "キェ")  ("kgh" . "キュウ")  ("kgl" . "キョン")  ("kgn" . "キャン")  
;     ("kgo" . "キョ")  ("kgp" . "キョウ")  ("kgq" . "キャイ")  ("kgu" . "キュ")  ("kgw" . "キェイ")  
;     ("kgz" . "キャン")  ("kh" . "クウ")  ("kj" . "クン")  ("kk" . "キン")  ("kl" . "コン")  
;     ("km" . "キ")  ("kn" . "カン")  ("kp" . "コウ")  ("kq" . "カイ")  ("kr" . "カラ")  
;     ("kt" . "コト")  ("kv" . "キン")  ("kw" . "ケイ")  ("kyd" . "キェン")  ("kyh" . "キュウ")  
;     ("kyj" . "キュン")  ("kyl" . "キョン")  ("kyn" . "キャン")  ("kyp" . "キョウ")  ("kyq" . "キャイ")  
;     ("kyw" . "キェイ")  ("kyz" . "キャン")  ("kz" . "カン")  ("m." . "ム")  ("md" . "メン")  
;     ("mf" . "ム")  ("mga" . "ミャ")  ("mgd" . "ミェン")  ("mge" . "ミェ")  ("mgh" . "ミュウ")  
;     ("mgj" . "ミュン")  ("mgl" . "ミョン")  ("mgn" . "ミャン")  ("mgo" . "ミョ")  ("mgp" . "ミョウ")  
;     ("mgq" . "ミャイ")  ("mgu" . "ミュ")  ("mgw" . "ミェイ")  ("mgz" . "ミャン")  ("mh" . "ムウ")  
;     ("mj" . "ムン")  ("mk" . "ミン")  ("ml" . "モン")  ("mn" . "モノ")  ("mp" . "モウ")  
;     ("mq" . "マイ")  ("mr" . "マル")  ("ms" . "マス")  ("mt" . "マタ")  ("mv" . "ムン")  
;     ("mw" . "メイ")  ("myd" . "ミェン")  ("myh" . "ミュウ")  ("myj" . "ミュン")  ("myl" . "ミョン")  
;     ("myn" . "ミャン")  ("myp" . "ミョウ")  ("myq" . "ミャイ")  ("myw" . "ミェイ")  ("myz" . "ミャン")  
;     ("mz" . "マン")  ("n." . "ヌ")  ("nb" . "ネバ")  ("nd" . "ネン")  ("nf" . "ヌ")  
;     ("nga" . "ニャ")  ("ngd" . "ニェン")  ("nge" . "ニェ")  ("ngh" . "ニュウ")  ("ngj" . "ニュン")  
;     ("ngl" . "ニョン")  ("ngn" . "ニャン")  ("ngo" . "ニョ")  ("ngp" . "ニョウ")  ("ngq" . "ニャイ")  
;     ("ngu" . "ニュ")  ("ngw" . "ニェイ")  ("ngz" . "ニャン")  ("nh" . "ヌウ")  ("nj" . "ヌン")  
;     ("nk" . "ニン")  ("nl" . "ノン")  ("np" . "ノウ")  ("nq" . "ナイ")  ("nr" . "ナル")  
;     ("nt" . "ニチ")  ("nv" . "ヌン")  ("nw" . "ネイ")  ("nyd" . "ニェン")  ("nyh" . "ニュウ")  
;     ("nyj" . "ニュン")  ("nyl" . "ニョン")  ("nyn" . "ニャン")  ("nyp" . "ニョウ")  ("nyq" . "ニャイ")  
;     ("nyw" . "ニェイ")  ("nyz" . "ニャン")  ("nz" . "ナン")  ("pd" . "ペン")  ("pf" . "ポン")  
;     ("pga" . "ピャ")  ("pgd" . "ピェン")  ("pge" . "ピェ")  ("pgh" . "ピュウ")  ("pgj" . "ピュン")  
;     ("pgl" . "ピョン")  ("pgn" . "ピャン")  ("pgo" . "ピョ")  ("pgp" . "ピョウ")  ("pgq" . "ピャイ")  
;     ("pgu" . "ピュ")  ("pgw" . "ピェイ")  ("pgz" . "ピャン")  ("ph" . "プウ")  ("pj" . "プン")  
;     ("pk" . "ピン")  ("pl" . "ポン")  ("pn" . "パン")  ("pp" . "ポウ")  ("pq" . "パイ")  
;     ("pv" . "ポウ")  ("pw" . "ペイ")  ("pyd" . "ピェン")  ("pyh" . "ピュウ")  ("pyj" . "ピュン")  
;     ("pyl" . "ピョン")  ("pyn" . "ピャン")  ("pyp" . "ピョウ")  ("pyq" . "ピャイ")  ("pyw" . "ピェイ")  
;     ("pyz" . "ピャン")  ("pz" . "パン")  ("q" . "ン")  ("rd" . "レン")  ("rh" . "ルウ")  
;     ("rj" . "ルン")  ("rk" . "リン")  ("rl" . "ロン")  ("rn" . "ラン")  ("rp" . "ロウ")  
;     ("rq" . "ライ")  ("rr" . "ラレ")  ("rw" . "レイ")  ("ryd" . "リェン")  ("ryh" . "リュウ")  
;     ("ryj" . "リュン")  ("ryk" . "リョク")  ("ryl" . "リョン")  ("ryn" . "リャン")  ("ryp" . "リョウ")  
;     ("ryq" . "リャイ")  ("ryw" . "リェイ")  ("ryz" . "リャン")  ("rz" . "ラン")  ("sd" . "セン")  
;     ("sf" . "サイ")  ("sh" . "スウ")  ("sj" . "スン")  ("sk" . "シン")  ("sl" . "ソン")  
;     ("sm" . "シモ")  ("sn" . "サン")  ("sp" . "ソウ")  ("sq" . "サイ")  ("sr" . "スル")  
;     ("ss" . "セイ")  ("st" . "シタ")  ("sv" . "サイ")  ("sw" . "セイ")  ("syd" . "シェン")  
;     ("syh" . "シュウ")  ("syj" . "シュン")  ("syl" . "ション")  ("syp" . "ショウ")  ("syq" . "シャイ")  
;     ("syw" . "シェイ")  ("syz" . "シャン")  ("sz" . "サン")  ("tU" . "ッ")  ("tb" . "タビ")  
;     ("td" . "テン")  ("tgh" . "テュー")  ("tgi" . "ティ")  ("tgk" . "ティン")  ("tgp" . "トゥー")  
;     ("tgu" . "テュ")  ("th" . "ツウ")  ("tj" . "ツン")  ("tk" . "チン")  ("tl" . "トン")  
;     ("tm" . "タメ")  ("tn" . "タン")  ("tp" . "トウ")  ("tq" . "タイ")  ("tr" . "タラ")  
;     ("tsU" . "ッ")  ("tsa" . "ツァ")  ("tse" . "ツェ")  ("tsi" . "ツィ")  ("tso" . "ツォ")  
;     ("tt" . "タチ")  ("tw" . "テイ")  ("tyd" . "チェン")  ("tyh" . "チュウ")  ("tyj" . "チュン")  
;     ("tyl" . "チョン")  ("tyn" . "チャン")  ("typ" . "チョウ")  ("tyq" . "チャイ")  ("tyw" . "チェイ")  
;     ("tyz" . "チャン")  ("tz" . "タン")  ("vd" . "ヴェン")  ("vk" . "ヴィン")  ("vl" . "ヴォン")  
;     ("vn" . "ヴァン")  ("vp" . "ヴォー")  ("vq" . "ヴァイ")  ("vw" . "ヴェイ")  ("vya" . "ヴャ")  
;     ("vye" . "ヴェ")  ("vyo" . "ヴョ")  ("vyu" . "ヴュ")  ("vz" . "ヴァン")  ("wA" . "ヮ")  
;     ("wd" . "ウェン")  ("wf" . "ワ")  ("wha" . "ウァ")  ("whe" . "ウェ")  ("whi" . "ウィ")  
;     ("who" . "ウォ")  ("whu" . "ウ")  ("wk" . "ウィン")  ("wl" . "ウォン")  ("wn" . "ワン")  
;     ("wp" . "ウォー")  ("wq" . "ワイ")  ("wr" . "ワレ")  ("wso" . "ウォ")  ("wt" . "ワタ")  
;     ("wz" . "ワン")  ("xa" . "シャ")  ("xc" . "シャ")  ("xd" . "シェン")  ("xe" . "シェ")  
;     ("xf" . "シェイ")  ("xh" . "シュウ")  ("xi" . "シ")  ("xj" . "シュン")  ("xk" . "シン")  
;     ("xl" . "ション")  ("xn" . "シャン")  ("xo" . "ショ")  ("xp" . "ショウ")  ("xq" . "シャイ")  
;     ("xt" . "シュツ")  ("xu" . "シュ")  ("xv" . "シャイ")  ("xw" . "シェイ")  ("xxa" . "ァ")  
;     ("xxe" . "ェ")  ("xxi" . "ィ")  ("xxo" . "ォ")  ("xxu" . "ゥ")  ("xxh" . "←")  
;     ("xxj" . "↓")  ("xxk" . "↑")  ("xxl" . "→")  ("xz" . "シャン")  ("y<" . "←")  
;     ("y>" . "→")  ("y^" . "↑")  ("yf" . "ユ")  ("yh" . "ユウ")  ("yi" . "ヰ")  
;     ("yj" . "ユン")  ("yl" . "ヨン")  ("yn" . "ヤン")  ("yp" . "ヨウ")  ("yq" . "ヤイ")  
;     ("yr" . "ヨル")  ("yv" . "ユウ")  ("yz" . "ヤン")  ("z." . "ズ")  ("zc" . "ザ")  
;     ("zd" . "ゼン")  ("zf" . "ゼ")  ("zh" . "ズウ")  ("zj" . "ズン")  ("zk" . "ジン")  
;     ("zl" . "ゾン")  ("zn" . "ザン")  ("zp" . "ゾウ")  ("zq" . "ザイ")  ("zr" . "ザル")  
;     ("zv" . "ザイ")  ("zw" . "ゼイ")  ("zx" . "ゼイ")  ("zyd" . "ジェン")  ("zyh" . "ジュウ")  
;     ("zyj" . "ジュン")  ("zyl" . "ジョン")  ("zyn" . "ジャン")  ("zyp" . "ジョウ")  ("zyq" . "ジャイ")  
;     ("zyw" . "ジェイ")  ("zyz" . "ジャン")  ("zz" . "ザン")  ("bx" . "ビョウ")  ("bx" . "ビョウ")  
;     ("dx" . "ヂョウ")  ("gx" . "ギョウ")  ("hx" . "ヒョウ")  ("kx" . "キョウ")  ("mx" . "ミョウ")  
;     ("nx" . "ニョウ")  ("px" . "ピョウ")  ("rx" . "リョウ")  ("sx" . "ショウ")  ("bv" . "ビュウ")  
;     ("dv" . "ヂュウ")  ("fv" . "フュー")  ("gv" . "ギュウ")  ("hv" . "ヒュウ")  ("kv" . "キュウ")  
;     ("mv" . "ミュウ")  ("nv" . "ニュウ")  ("pv" . "ピュウ")  ("rv" . "リュウ")  ("sv" . "シュウ")  
;     ("vv" . "ウ゛ュー")  
;     ))

(defun anthy-azik-mode ()
  (interactive)
  (setq anthy-rkmap-keybind
	'(
	  ;; \C-p
	  (("hiragana" . 16) . "katakana")
	  (("katakana" . 16) . "hiragana")))
; (define-key anthy-mode-map (char-to-string 16) 'anthy-insert)
  (anthy-send-change-toggle-command "!")
  (mapcar (lambda (x)
	    (anthy-change-hiragana-map (car x) (cdr x)))
	  anthy-azik-mode-hiragana-map)
  (anthy-hiragana-map))
;  (mapcar (lambda (x)
;	    (anthy-change-katakana-map (car x) (cdr x)))
;	  anthy-azik-mode-katakana-map)

