# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=armv7-unknown-unknown -mcpu=swift -iterations=300 -timeline -timeline-max-iterations=3 < %s | FileCheck %s

  ldm	r2!, {r3, r4, r5, r6, r12, lr}
  stm	r0!, {r3, r4, r5, r6, r12, lr}

# CHECK:      Iterations:        300
# CHECK-NEXT: Instructions:      600
# CHECK-NEXT: Total Cycles:      1295
# CHECK-NEXT: Total uOps:        2400

# CHECK:      Dispatch Width:    3
# CHECK-NEXT: uOps Per Cycle:    1.85
# CHECK-NEXT: IPC:               0.46
# CHECK-NEXT: Block RThroughput: 4.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  3      18    2.00    *                   ldm	r2!, {r3, r4, r5, r6, r12, lr}
# CHECK-NEXT:  5      1     2.00           *            stm	r0!, {r3, r4, r5, r6, r12, lr}

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SwiftUnitDiv
# CHECK-NEXT: [1]   - SwiftUnitP0
# CHECK-NEXT: [2]   - SwiftUnitP1
# CHECK-NEXT: [3]   - SwiftUnitP2
# CHECK-NEXT: [4.0] - SwiftUnitP01
# CHECK-NEXT: [4.1] - SwiftUnitP01

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4.0]  [4.1]
# CHECK-NEXT:  -      -      -     4.00   2.46   2.54

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4.0]  [4.1]  Instructions:
# CHECK-NEXT:  -      -      -     2.00   1.09   0.91   ldm	r2!, {r3, r4, r5, r6, r12, lr}
# CHECK-NEXT:  -      -      -     2.00   1.37   1.63   stm	r0!, {r3, r4, r5, r6, r12, lr}

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789
# CHECK-NEXT: Index     0123456789          012345678

# CHECK:      [0,0]     DeeeeeeeeeeeeeeeeeeER    .  .   ldm	r2!, {r3, r4, r5, r6, r12, lr}
# CHECK-NEXT: [0,1]     .D=================eER   .  .   stm	r0!, {r3, r4, r5, r6, r12, lr}
# CHECK-NEXT: [1,0]     .  DeeeeeeeeeeeeeeeeeeER .  .   ldm	r2!, {r3, r4, r5, r6, r12, lr}
# CHECK-NEXT: [1,1]     .   D=================eER.  .   stm	r0!, {r3, r4, r5, r6, r12, lr}
# CHECK-NEXT: [2,0]     .    .DeeeeeeeeeeeeeeeeeeER .   ldm	r2!, {r3, r4, r5, r6, r12, lr}
# CHECK-NEXT: [2,1]     .    . D==================eER   stm	r0!, {r3, r4, r5, r6, r12, lr}

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     3     1.0    1.0    0.0       ldm	r2!, {r3, r4, r5, r6, r12, lr}
# CHECK-NEXT: 1.     3     18.3   0.3    0.0       stm	r0!, {r3, r4, r5, r6, r12, lr}
# CHECK-NEXT:        3     9.7    0.7    0.0       <total>
