# Slang Core Module Documentation Generation Tool

Slang's core module reference (https://shader-slang.com/stdlib-reference) is generated by `slangc` from the source of the core module.
This page covers how `slangc` can be used to generate this documentation.

## Generating Documentation

Follow these steps to generate the core module reference documentation and view the generated markdown files locally:

```
# clone stdlib-reference repo
git clone https://github.com/shader-slang/stdlib-reference
cd stdlib-reference

# delete existing pages
rm -rf ./interfaces
rm -rf ./types
rm -rf ./global-decls
rm -rf ./attributes

# generate updated pages
slangc -compile-core-module -doc

# optional: move generated toc.html to `_includes`
mv toc.html ./_includes/stdlib-reference-toc.html
```

`slangc` will read the `config.txt` file in the stdlib-reference repository, and then generate all the markdown files
located in `types`, `attributes`, `interfaces` and `global-decls` directory.

Note that the `index.md` in root is not generated.

You should review the generated markdown file to make sure it is formatted correctly after making comment edits in the
`*.meta.slang` files.


## Writing and Updating Documentation

The core module documentation is done directly in comments inside `source/slang/*.meta.slang` files.
A documentation comment should be placed directly above the declaration, either inside a `/**   */` comment block, or
after `///`. The following directives are allowed in comments:

- `@param paramName description` documents a parameter or a generic parameter.
- `@remarks` starts the remarks section.
- `@see` starts the "See also" section.
- `@return` starts the `Return value" section.
- `@example` starts the "Example" section.
- `@category categoryID Category Name` marks the decl to be in a category. The category name is only required for the first time `categoryID` is used, and omitted for the remaining `@category` lines.
- `@internal` marks the declaration as internal.
- `@experimental` marks the declaration as experimental.
- `@deprecated` marks the declaration as deprecated.

You can use markdown syntax in any part of the comment.

For overloaded functions, only document the first overload. List all parameters from all overloads in the same comment block for the first overload. Documentation on the remaining overloads will be ignored by the tool. If an overloaded decl has differing documentation on different overload candidates, the `slangc` tool will emit a warning.

The following code is an example of how `_Texture.Sample` is documented. Notice that only the first overload is documented, and it also includes documentation for parameters which are only present in subsequent overloads, such as `offset`.

```csharp
    /// Samples the texture at the given location.
    ///
    ///@param s The `SamplerState` to use for the sampling operation. This parameter is omitted when `this` is a combined texture sampler type (`isCombined == 0`).
    ///@param location The location to sample the texture at.
    ///@param offset Texel offset to apply.
    ///@param clamp The max level of detail to use.
    ///@param[out] status The result status of the operation.
    ///                   This parameter is currently only used when targeting HLSL.
    ///                   For other targets, the result status is always 0.
    ///@return The sampled texture value.
    ///@see `SampleBias`, `SampleLevel`, `SampleGrad`, `SampleCmp`, `SampleCmpLevelZero`.
    ///@remarks
    /// The `Sample` function is defined for all read-only texture types, including
    /// `Texture1D`, `Texture2D`, `Texture3D`, `TextureCube`,
    /// `Texture1DArray`, `Texture2DArray` and `TextureCubeArray`.
    ///
    /// The function is not available for read-write texture types.
    ///
    /// For HLSL/D3D targets, the texture element type must be a scalar or vector of float or half types.
    ///
    [__readNone]
    [ForceInline]
    [require(cpp_cuda_glsl_hlsl_metal_spirv_wgsl, texture_sm_4_0_fragment)]
    T Sample(vector<float, Shape.dimensions+isArray> location)
    {
        ...
    }

    [__readNone]
    [ForceInline]
    [require(cpp_glsl_hlsl_metal_spirv_wgsl, texture_sm_4_0_fragment)]
    T Sample(vector<float, Shape.dimensions+isArray> location, constexpr vector<int, Shape.planeDimensions> offset)
    {
        ...
    }

```

Note that unlike doxygen, the directives marks the start of a new section, and applies to all following paragraphs. You don't need to repetitively mark new paragraphs
as with `@remarks`.

## What to document

- Provide a brief description of the declaration in under three sentenses.
- Document all nuances, including target specific behaviors in the remarks section.
- Include examples if needed in the examples section.
- Provide a see also section with links to related declarations.

After updating comments, build `slangc`, and run `slangc -compile-core-module -doc` in `stdlib-reference` directory to update the markdown files for preview.
Your PR only needs to include changes to *.meta.slang files. Once your PR is merged, slang CI will run `slangc` and push the updated markdown files to
the `stdlib-reference` repo.

## Hiding a declaration

Use `// @hidden:` to hide all declarations after the line for docgen purpose.
Use `// @public: ` to stop hiding all declarations after the line. These two special lines act like
C++'s visibility modifiers: they apply to everything after it.

## How to preview generated html page locally

To preview github pages locally, you need to follow instructions on setting up Jekyll: 
https://docs.github.com/en/pages/setting-up-a-github-pages-site-with-jekyll/testing-your-github-pages-site-locally-with-jekyll

You will need to use Jekyll to create a Gem file before serving it.
