#
#	MN_server.pl
#
#	Mail-Net server program.
#
#	Created: Sat Feb 29 01:23:27 1992
#	Last modified: Wed Dec 16 07:06:01 1992
#
#	@ arl // 1992
#

require		"$ARGV[0]/MN_config.pl";
require		"$ARGV[0]/MN_lib.pl";
require		"$ARGV[0]/MN_global.pl";
require		"$ARGV[0]/MN_digest.pl";

@TheMail	= ();

#
# main()
#

chdir( @ARGV[1] );

$GL_WhoAmI = @ARGV[2];

# If the file is digest.
if ( index( @ARGV[3], ".digest" ) > -1 )
{
	@parts = split( /[\/\.]/, @ARGV[3] );
	if ( pop( @parts ) eq "digest" )
	{
		$DoChannelName = pop( @parts );
		$DEBUG && print "Should digest = \"$DoChannelName\"\n";
		&OpenChannelFile( "<" );
		&ReadChannelFile();
		&CloseChannelFile();

		if ( &CheckIfChannelThere( $DoChannelName ) == 0 )
		{
#			How can we digest non-existent channel?
#			just ignore.
			exit( 0 );
		}
		$DEBUG && print "Sending digest to channel",
			$DoChannelName, "\n";
		&WriteLog( $LOG_FILENAME, $0, "sending digest",
			$DoChannelName, @ARGV[2] );
		&SendDigestToChannel( $DoChannelName, @ARGV[2] );
	}
	exit( 0 );
}

open( TEMPF, "<" . @ARGV[3] ) || do
{
#	Could not open the file given.
	&WriteLog( $LOG_FILENAME, $0, "could not open argument",
		@ARGV[3] );
	exit( 0 );
};

$header = 1;
$NoCommand = 1;

while ( <TEMPF> )
{
	if ( $header eq 1 )
	{
		if ( length($_) eq 1 )
		{
			$header = 0;
			push( @TheMail, $_ );
			next;
		}

#		Remove the eol new line.
		chop;

		if ( /^From:/ )
		{
			($dummy,$FromAddress) = split(/[:]/o);
			push( @TheMail, $_ );
			next;
		}
		if ( /^Reply-To:/ )
		{
			($dummy,$ReplyToAddress) = split(/[:]/o);
			push( @TheMail, $_ );
			next;
		}
		if ( /^Sender:/ )
		{
#			Sender fields are taken out of the mail
#			we'll keep it for possible errors.
			($dummy,$SenderAddress) = split(/[:]/o);
			next;
		}
		if ( /^To:/ )
		{
#			To: address is stripped away, and we
#			change with our own.
			push( @TheMail, "Sender: owner-" . $GL_WhoAmI .
				"@niksula.hut.fi" );
			push( @TheMail, "To: " . $GL_WhoAmI .
				"@niksula.hut.fi" );
			next;
		}
		if ( ( /^X-Mn/ || /^Mn/ ) && $NoCommand )
		{
			($dummy,$ServerCommand) = split(/[:]/o);
			$NoCommand = 0;
			$ServerCommand =~ y/[a-z]/[A-Z]/;
			$ServerCommand =~ s/[ \t\n]//;
			push( @TheMail, "X-Mn-Key: " . $ServerCommand );
			push( @TheMail, "X-Note1: Remember to put " .
				"\'X-Mn-Key: " . $ServerCommand .
				"\' to your mail body or header" );
			next;
		}
		push( @TheMail, $_ );
	}
	else
	{
#		Remove the eol new line.
		chop;
		push( @TheMail, $_ );
	}
}

close( TEMPF );

&do_from( $FromAddress );

&OpenChannelFile( "<" );

&ReadChannelFile();

if ( &CheckIfChannelThere( $ServerCommand ) == 0 )
{
#	Should send to the sender error message.

	chdir( @ARGV[1] );

	$Handle = &ReturnMailOpen( $Address'address,
		"No known channel given", @ARGV[2] );

	&ReturnMailWrite( $Handle, "You tried to send mail to" .
		" a non-existing channel.\n\n" );
	&ReturnMailWrite( $Handle, "By sending mail to:\n\t" );
	&ReturnMailWrite( $Handle, @ARGV[2] );
	&ReturnMailWrite( $Handle, "-request@niksula.hut.fi\n" .
		"it's possible to get " .
		"information how to use Mail-Net.\n\n" );

	&ReturnMailWrite( $Handle, "Your unsent article follows:\n" );
	&ReturnMailWrite( $Handle, "============================\n\n\n" );

	open( TEMPF, "<" . @ARGV[3] );
	while ( <TEMPF> )
	{
		&ReturnMailWrite( $Handle, $_ );
	}
	close( TEMPF );

	&ReturnMailClose( $Handle );

	&CloseChannelFile();

	&WriteLog( $LOG_FILENAME, $0, "tried to send, no such channel",
		$ServerCommand );

	link( @ARGV[3], &tmpfile( $DONE_TMPFILE ) );
	unlink( @ARGV[3] ) || do
	{
#		/* LOGGING? */
	};

	exit -1;
}	

&CloseChannelFile();

$outmail_filename = &tmpfile( $OUT_TMPFILE );

open( OUTMAIL, ">" . $outmail_filename ) || do
{
#	Could not open OUT mail file .. fatal.
	exit( -2 );
};

foreach (@TheMail)
{
	print OUTMAIL $_,"\n";	
}

close( OUTMAIL );

link( @ARGV[3], &tmpfile( $DONE_TMPFILE ) );
unlink( @ARGV[3] ) || do
{
#	/* LOGGING? */
};

chdir( @ARGV[1] );

if ( -f "LISTS/" . $ServerCommand . ".digest" )
{
	&WriteLog( $LOG_FILENAME, $0, "to digest", $ServerCommand );
	chdir $OUT_DIRECTORY;
	&SendFileToDigest( $ServerCommand, $outmail_filename, @ARGV[2] );
}
else
{
	&WriteLog( $LOG_FILENAME, $0, "to channel", $ServerCommand );
	&SendFileToChannel( $ServerCommand, $outmail_filename, @ARGV[2] );
}

# To get differing time stamp.
sleep( 2 );
link( $outmail_filename, &tmpfile( $DONE_TMPFILE ) );
unlink( $outmail_filename ) || do
{
#	/* LOGGING? */
};

exit 0;
