/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name */
#define CMDLINE_PARSER_PACKAGE "uvcdynctrl"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  const char *list_help; /**< @brief List available cameras help description.  */
  char * import_arg;	/**< @brief Import dynamic controls from an XML file.  */
  char * import_orig;	/**< @brief Import dynamic controls from an XML file original value given at command line.  */
  const char *import_help; /**< @brief Import dynamic controls from an XML file help description.  */
  char * addctrl_arg;	/**< @brief Import dynamic controls for vid from default location.  */
  char * addctrl_orig;	/**< @brief Import dynamic controls for vid given at command line from default location.  */
  const char *addctrl_help; /**< @brief Enable addctrl help description.  */
  int verbose_flag;	/**< @brief Enable verbose output (default=off).  */
  const char *verbose_help; /**< @brief Enable verbose output help description.  */
  char * device_arg;	/**< @brief Specify the device to use (default='video0').  */
  char * device_orig;	/**< @brief Specify the device to use original value given at command line.  */
  const char *device_help; /**< @brief Specify the device to use help description.  */
  const char *clist_help; /**< @brief List available controls help description.  */
  char * get_arg;	/**< @brief Retrieve the current control value.  */
  char * get_orig;	/**< @brief Retrieve the current control value original value given at command line.  */
  const char *get_help; /**< @brief Retrieve the current control value help description.  */
  char * get_raw_arg;	/**< @brief Retrieve the current raw control value.  */
  char * get_raw_orig;	/**< @brief Retrieve the current raw control value- original value given at command line.  */
  const char *get_raw_help; /**< @brief Retrieve the current raw control value- help description.  */
  char * set_arg;	/**< @brief Set a new control value\n(For negative values: -s 'My Control' -- -42).  */
  char * set_orig;	/**< @brief Set a new control value\n(For negative values: -s 'My Control' -- -42) original value given at command line.  */
  char * set_raw_arg;	/**< @brief Set the current raw control value.  */
  char * set_raw_orig;	/**< @brief Set the current raw control value- original value given at command line.  */
  const char *set_raw_help; /**< @brief Set the current raw control value- help description.  */
  const char *set_help; /**< @brief Set a new control value\n(For negative values: -s 'My Control' -- -42) help description.  */
  const char *formats_help; /**< @brief List available frame formats help description.  */
  char * save_ctrl_arg;	 /**< @brief save controls to a file.  */
  char * save_ctrl_orig;	/**< @brief save controls to file original value given at command line.  */
  const char *save_ctrl_help; /**< @brief save ctrl help description.  */
  char * load_ctrl_arg;	 /**< @brief load controls to a file.  */
  char * load_ctrl_orig;	/**< @brief load controls to file original value given at command line.  */
  const char *load_ctrl_help; /**< @brief load ctrl help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int list_given ;	/**< @brief Whether list was given.  */
  unsigned int import_given ;	/**< @brief Whether import was given.  */
  unsigned int addctrl_given ;	/**< @brief Whether addctrl was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int device_given ;	/**< @brief Whether device was given.  */
  unsigned int clist_given ;	/**< @brief Whether clist was given.  */
  unsigned int get_given ;	/**< @brief Whether get was given.  */
  unsigned int get_raw_given ;	/**< @brief Whether get_raw was given.  */
  unsigned int set_given ;	/**< @brief Whether set was given.  */
  unsigned int set_raw_given ;	/**< @brief Whether set_raw was given.  */
  unsigned int formats_given ;	/**< @brief Whether formats was given.  */
  unsigned int save_ctrl_given; /**< @brief Whether save ctrl was given.  */
  unsigned int load_ctrl_given; /**< @brief Whether load ctrl was given.  */

  char **inputs ; /**< @brief unamed options (options without names) */
  unsigned inputs_num ; /**< @brief unamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char * const *argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char * const *argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char * const *argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
