.\" mgdiff.man,v 2.0 1994/05/19 02:01:16 dan Exp
.\"
.\" Copyright (c) 1994    Daniel Williams
.\" 
.\" The X Consortium, and any party obtaining a copy of these files from
.\" the X Consortium, directly or indirectly, is granted, free of charge,
.\" a full and unrestricted irrevocable, world-wide, paid up,
.\" royalty-free, nonexclusive right and license to deal in this software
.\" and documentation files (the "Software"), including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute,
.\" sublicense, and/or sell copies of the Software, and to permit persons
.\" who receive copies from any such party to do so.  This license
.\" includes without limitation a license to do the foregoing actions
.\" under any patents of the party supplying this software to the X
.\" Consortium.  The following conditions apply:
.\" 
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL DANIEL WILLIAMS OR SYSTEMS & SCIENTIFIC SOFTWARE BE
.\" LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
.\" OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
.\" WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\"
.na
.TH MGDIFF 1
.SH NAME
mgdiff \- Motif-based graphical file difference browser
.SH SYNOPSIS
mgdiff [\-toolkitoption ...] [\-quit] [\-file \fIname\fP] [\-args \fIdiffargs\fP] [file1 file2]
.SH DESCRIPTION
.LP
.I Mgdiff
is a graphical front end to the
.I diff
command.  It permits the user to view the differences between two
ASCII files in context and, optionally, to write out a third file
which is the user-defined merging of those two files.  It is inspired
by a similar program, called
.I gdiff,
which runs only on Silicon Graphics workstations and for which source
code is not provided.
.LP
The program takes as arguments various flags (described in the next
section) and the names of two files to compare.  Either filename (but
not both) may be given as '-' to use standard input instead.
.LP
The resulting display consists mostly of two panes of text; the one on
the left is the first file specified and the one on the right is the
second file specified.  Between and below the text panes are
scrollbars that permit changing the visible portions of the two files
being compared.  In addition, the program implements the Scrolled
Region recommendations of Section 2.3.4 of the OSF/Motif Style Guide
(release 1.1), meaning that the arrow and paging keys will work to
scroll as well.  Above each text pane is the name of the file in that
text pane and the line number in the file which is being displayed.
.LP
The text in each of the text panes is divided into blocks of lines
which are color\-coded with one of five different colors.  This
indicates that the block:
.IP
differs between the two files
.IP
is identical between the two files
.IP
has been inserted in one file or the other
.IP
is for display purposes (to match an inserted block in the other file)
.IP
has been selected by the user (for writing to a merged file)
.LP
These colors can be modified by the user via X resources; see the
RESOURCES section of this manual page.  A legend display of the colors
and their meanings is available using the Help menu.
.LP
On the right\-hand side of the display is an overview area; this
shows the files in their entirety.  The sliders in the overview area
track the lines being displayed in the text panes.
.LP
At the top of the display is a Motif menu bar; those functions are
discussed in the MENUS section of this manual page.

.SH COMMAND LINE OPTIONS
.TP 8
.B \-toolkitoption
These are the standard options accepted by all applications that use
the X Toolkit Intrinsics.  See the OPTIONS section in the
.BR X (1)
manual page.
.TP 8
.B \-quit
This option sets the resource
.I Mgdiff.quitIfSame
to "true".  This will cause the program to exit immediately without
bringing up a window if the two files have no differences (as
determined by the
.I diff
command).
.TP 8
\fB\-args\fP \fIdiffargs\fP
This option sets the resource
.I Mgdiff.diffArgs
to the value of the
.IR diffargs
argument.  These flags are passed to the
.I diff
command that actually computes the differences between the two files.
Since any argument can be passed, it is possible to specify flags that
cause the
.I diff
command to fail or to generate output in a different format that will
cause
.I mgdiff
to fail.  For most versions of
.I diff,
only three flags make any sense.  The first is '\-b'; this
causes
.I diff
to ignore trailing blanks (spaces and tabs) and to treat all other
strings of blanks as equivalent.  The second flag is '\-w'; this
ignores blanks and treats strings of blanks as equivalent.  The last
flag is '\-i'; this ignores case when comparing letters.
.TP 8
\fB\-file\fP \fIname\fP
This command sets the resource
.I Mgdiff.filename
to the value of the
.IR name
argument.
.I mgdiff
uses this string to display over a file read from
standard input.
.nr XX 4
.nr XY 18
.SH MENUS
The menubar contains the following menu topics as CascadeButtons:
\fBFile\fP, \fBView\fP, \fBSelect\fP, \fBOptions\fP and \fBHelp\fP.
The rest of this section discusses each menu entry, showing it's name
and accelerator, if any.

.IP "\fBFile\fP"
.LP
This pulldown menu controls file access:
.RS \n(XXP
.IP "\fBOpen...\fP" \n(XYP
.B Ctrl+O
.LP
Brings up the "Open Files" FileSelectionDialog to allow the user to
open two files for comparison.
.IP "\fBOpen Left...\fP" \n(XYP
.B Ctrl+L
.LP
Brings up the "Open File" FileSelectionDialog to allow the user to
specify a file to open and compare with the already opened right\-hand
file.
.IP "\fBOpen Right...\fP" \n(XYP
.B Ctrl+R
.LP
Brings up the "Open File" FileSelectionDialog to allow the user to
specify a file to open and compare with the already opened left\-hand
file.
.IP "\fBSave As...\fP" \n(XYP
.B Ctrl+S
.LP
Brings up the "Save File" FileSelectionDialog to allow the user to
specify an output file for writing the merged file; this is an
application modal dialog.  The program will allow the user to
overwrite an existing file but pops up a QuestionDialog to allow the
user to cancel the operation if desired.  If there are any unselected
areas of difference between the two files the user is notified via an
ErrorDialog and the save operation is canceled.
.IP "\fBExit\fP" \n(XYP
.B Ctrl+C
.LP
Exits the program immediately.
.RE

.IP "\fBView\fP"
.LP
This pulldown menu contains commands for moving through the files.
.RS \n(XXP
.IP "\fBPrevious\fP" \n(XYP
.B Ctrl+P
.LP
Scrolls both file views so that the previous area of difference is 
.I Mgdiff.linesOfContext
lines from the top of the application window.
.IP "\fBNext\fP" \n(XYP
.B Ctrl+N
.LP
Scrolls both file views so that the next area of difference is 
.I Mgdiff.linesOfContext
lines from the top of the application window.
.IP "\fBNext Unselected\fP" \n(XYP
.B Ctrl+U
.LP
Scrolls both file views so that the next unselected area of difference is
.I Mgdiff.linesOfContext
lines from the top of the application window.
.RE

.IP "\fBSelect\fP"
.LP
The two files being compared can be optionally merged into one file.
To do this, the user must select for each area of difference between
the two files which version should be written to the merged file.  The
menu entries in this pulldown menu allow the user to select or
unselect differences in groups rather than individually.
.RS \n(XXP
.IP "\fBLeft All\fP" \n(XYP
.LP
For all areas of difference between the two files select the left\-hand file version.
.IP "\fBRight All\fP" \n(XYP
.LP
For all areas of difference between the two files select the right\-hand file version.
.IP "\fBUnselect All\fP" \n(XYP
.LP
Unselects all areas of difference in both files.
.RE

.IP "\fBOptions\fP"
.LP
This pulldown menu controls miscellaneous appearance and/or behavior
options.
.RS \n(XXP
.IP "\fBOverview\fP" \n(XYP
.B Ctrl+W
.LP
This menu entry toggles the presence of the overview area on the
right\-hand side of the application window.  The default value for
this toggle is controlled by a resource,
.IR Mgdiff.overview ,
which is described in the RESOURCES section.
.IP "\fBHorizontal Scrollbar\fP" \n(XYP
.B Ctrl+H
.LP
This menu entry toggles the presence of the horizontal scrollbar at
the bottom of the application window.  The default value for this
toggle is controlled by a resource,
.IR Mgdiff.horzScrollbar ,
which is described in the RESOURCES section.
.IP "\fBDrag Scroll\fP" \n(XYP
.B Ctrl+D
.LP
This menu entry toggles the behaviour of the scrollbars in the
application window.  When set, dragging the slider of a scrollbar
results in a immediate change in the view of the text being compared.
When unset, the view is only changed at the end of a slider drag (when
the mouse button is released.)  This setting might be preferred on a
slower X server.  The default value for this toggle is controlled by a
resource,
.IR Mgdiff.dragScroll ,
which is described in the RESOURCES section.
.RE

.IP "\fBHelp\fP"
.LP
This pulldown menu displays commands for obtaining help on or
information about
.IR mgdiff .
.RS \n(XXP
.IP "\fBVersion...\fP" \n(XYP
.B Ctrl+V
.LP
Brings up an InformationDialog with author and version information.
.IP "\fBManual Page...\fP" \n(XYP
.B Ctrl+M
.LP
Brings up a DialogShell with a ScrolledText widget containing this
manual page.  The command for generating this is customizable via a
resource,
.IR Mgdiff.manCommand ,
which is described in the RESOURCES section.
.IP "\fBColor Legend...\fP" \n(XYP
.B Ctrl+G
.LP
Brings up a DialogShell which summarizes the use of color in encoding
the types of differences between the two files being compared.
.RE

.SH OTHER DISPLAYS/CONTROLS
.LP
You can move directly to a particular spot in the two files by using
\fBBDrag\fP in the overview area.
.LP
The program uses what the OSF/Motif Style Guide calls "multiple
selection" to select individual blocks for writing to a merged file.
Clicking \fBBSelect\fP on an unselected block adds it to the list of
selected blocks.  Clicking \fBBSelect\fP on a selected block removes
it from the list of selected blocks.  In addition, Clicking
\fBBSelect\fP on an unselected block which is opposite a selected
block (in the other text panes) removes the selected block from the
list of selected blocks.
.LP
The numbers in the small boxes next to the file names are the line
numbers of the lines at the top of the text panes.

.SH WIDGETS
What follows is the hierarchy of Motif widgets, as generated by 
.BR editres (1).
The hierarchical structure of the widget tree is reflected in the
indentation.  Each line consists of the widget class name followed by
the widget instance name.  This information might be useful if you
wish to customize the appearance of the program via resource settings.

.nf
.DT
Mgdiff  mgdiff
	XmMainWindow  mainw
		XmSeparatorGadget  MainWinSep1
		XmSeparatorGadget  MainWinSep2
		XmSeparatorGadget  MainWinSep3
		XmRowColumn  menubar
			XmCascadeButtonGadget  button_0
			XmCascadeButtonGadget  button_1
			XmCascadeButtonGadget  button_2
			XmCascadeButtonGadget  button_3
			XmCascadeButtonGadget  button_4
			XmMenuShell  popup_file_menu
				XmRowColumn  select_menu
					XmPushButtonGadget  button_0
					XmPushButtonGadget  button_1
					XmSeparatorGadget  separator_0
					XmPushButtonGadget  button_2
				XmRowColumn  file_menu
					XmPushButtonGadget  button_0
					XmPushButtonGadget  button_1
					XmPushButtonGadget  button_2
					XmPushButtonGadget  button_3
					XmSeparatorGadget  separator_0
					XmPushButtonGadget  button_4
				XmRowColumn  options_menu
					XmToggleButtonGadget  button_0
					XmToggleButtonGadget  button_1
					XmToggleButtonGadget  button_2
				XmRowColumn  help_menu
					XmPushButtonGadget  button_0
					XmPushButtonGadget  button_1
					XmPushButtonGadget  button_2
				XmRowColumn  view_menu
					XmPushButtonGadget  button_0
					XmPushButtonGadget  button_1
					XmPushButtonGadget  button_2
		XmForm  form1
			XmFrame  frame1
				XmForm  form3
					XmScrollBar  sbl
					XmDrawingArea  dam
					XmScrollBar  sbr
			XmFrame  frame2
				XmForm  form4
					XmForm  form2
						XmScrollBar  sb
						XmForm  form21
							XmFrame  frame3
								XmLabel  fnamel
							XmFrame  frame31
								XmTextField  linenuml
						XmForm  form22
							XmFrame  frame4
								XmLabel  fnamer
							XmFrame  frame41
								XmTextField  linenumr
						XmDrawingArea  textl
						XmDrawingArea  textr
					XmScrollBar  sbh
	XmDialogShell  version_popup
		XmMessageBox  version
			XmLabelGadget  symbol
			XmLabelGadget  
			XmSeparatorGadget  separator
			XmPushButtonGadget  OK
			XmPushButtonGadget  Cancel
			XmPushButtonGadget  Help
	XmDialogShell  manualpage_popup
		XmForm  manualpage
			XmPanedWindow  pane
				XmScrolledWindow  help_textSW
					XmScrollBar  vbar
					XmText  help_text
				XmForm  form2a
					XmPushButton  OK
				XmSash  sash
				XmSeparatorGadget  separator
				XmSash  sash
				XmSeparatorGadget  separator
	XmDialogShell  legend_popup
		XmForm  legend
			XmPanedWindow  pane
				XmRowColumn  rc
					XmLabel  label1
					XmLabel  label2
					XmLabel  label3
					XmLabel  label4
					XmLabel  label5
				XmForm  form2a
					XmPushButton  OK
				XmSash  sash
				XmSeparatorGadget  separator
				XmSash  sash
				XmSeparatorGadget  separator
	XmDialogShell  werror_popup
		XmMessageBox  werror
			XmLabelGadget  symbol
			XmLabelGadget  
			XmSeparatorGadget  separator
			XmPushButtonGadget  OK
			XmPushButtonGadget  Cancel
			XmPushButtonGadget  Help
.fi

.nr XY 15
.SH X RESOURCES
.IP "\fBMgdiff.diffForeground:\fP" \n(XYP
.B black
.IP "\fBMgdiff.diffBackground:\fP" \n(XYP
.B yellow
.LP
These colors are for blocks which differ between files.

.IP "\fBMgdiff.sameForeground:\fP" \n(XYP
.B black
.IP "\fBMgdiff.sameBackground:\fP" \n(XYP
.B grey
.LP
These colors are for blocks which are identical between files.

.IP "\fBMgdiff.insertForeground:\fP" \n(XYP
.B black
.IP "\fBMgdiff.insertBackground:\fP" \n(XYP
.B orange
.LP
These colors are for blocks which have been inserted in one file.

.IP "\fBMgdiff.blankForeground:\fP" \n(XYP
.B black
.IP "\fBMgdiff.blankBackground:\fP" \n(XYP
.B grey66
.LP
These colors are for blocks which are for display purposes.

.IP "\fBMgdiff.selectForeground:\fP" \n(XYP
.B black
.IP "\fBMgdiff.selectBackground:\fP" \n(XYP
.B light slate blue
.LP
These colors are for blocks which have been selected by the user.

.IP "\fBMgdiff.font:\fP" \n(XYP
.B 7x13bold
.LP
Font for displaying text blocks.

.IP "\fBMgdiff.dragScroll:\fP" \n(XYP
.B true
.LP
Set to true if scrollbar dragging should cause immediate changes in
the viewed text, and false if the view should only change after the
scrollbar has been moved.

.IP "\fBMgdiff.overview:\fP" \n(XYP
.B true
.LP
Set to true if the file overview section should appear.

.IP "\fBMgdiff.horzScrollbar:\fP" \n(XYP
.B true
.LP
Set to true if the horizontal scrollbar should appear.

.IP "\fBMgdiff.linesOfContext:\fP" \n(XYP
.B 3
.LP
Number of lines that should appear above a difference block gotten to
using the Previous or Next commands.  Should be greater or equal to
zero.

.IP "\fBMgdiff.manCommand:\fP" \n(XYP
.B (man mgdiff | col -b) 2>&1
.LP
The command (or pipeline) used to produce a formatted manual page
without escape codes.

.IP "\fBMgdiff.diffCommand:\fP" \n(XYP
.B diff
.LP
The 
.BR diff (1)
compatible command to use for calculating differences between text files.

.IP "\fBMgdiff.diffArgs:\fP" \n(XYP
.B ""
.LP
The arguments to be provided to the
.I diff
command.  This resource can also be set via the
.I \-args
command line option.

.IP "\fBMgdiff.quitIfSame:\fP" \n(XYP
.B false
.LP
If the two files have no differences (as determined by the 
.I diff
command) then exit immediately without bringing up a window.  This
resource can also be set to "true" via the 
.I \-quit
command line option.

.IP "\fBMgdiff.filename:\fP" \n(XYP
.B (stdin)
.LP
.I mgdiff
uses this string to display over a file read from
standard input.  This resource can also be set via the
.I \-file
command line option.

.SH DIAGNOSTICS
Returns the exit status generated by the 
.I diff
command.  This is usually 0 for no differences, 1 for some differences
and 2 for errors.
.SH SEE ALSO
.BR diff (1),
.BR X (1)
.SH RESTRICTIONS
.LP
Using \fBBDrag\fP in the overview area doesn't work well when drag
scrolling is turned off.
.LP
Doesn't support monochrome displays.
.LP
Input lines longer than BUFSIZ (see /usr/include/stdio.h) are silently
truncated.
.LP
The code for parsing and passing arguments to the
.I diff
command assumes arguments are delimited by white space and does not do
any quote processing.
.SH COPYRIGHT
Copyright (c) 1994, Daniel Williams
.br
See
.B X (1)
for a full statement of rights and permissions.
.SH AUTHOR
Daniel Williams (dan@sass.com)
.SH ACKNOWLEDGEMENTS
To Andrew C. Myers for writing
.I gdiff.
