# unset-value [![NPM version](https://img.shields.io/npm/v/unset-value.svg?style=flat)](https://www.npmjs.com/package/unset-value) [![NPM monthly downloads](https://img.shields.io/npm/dm/unset-value.svg?style=flat)](https://npmjs.org/package/unset-value) [![NPM total downloads](https://img.shields.io/npm/dt/unset-value.svg?style=flat)](https://npmjs.org/package/unset-value) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/unset-value.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/unset-value) 

> Delete nested properties from an object using dot notation.

Please consider following this project's author, [Jon Schlinkert](https://github.com/jonschlinkert), and consider starring the project to show your :heart: and support.

## Install
Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save unset-value
```

## Usage

```js
var unset = require('unset-value');
unset(obj, prop);
```

### Params

* `obj` **{object}**: The object to unset `prop` on
* `prop` **{string | string[]}**: The property to unset. Dot-notation may be used or an array of nested properties.

## Examples

### Updates the object when a property is deleted

```js
var obj = {a: 'b'};
unset(obj, 'a');
console.log(obj);
//=> {}
```

### Returns true when a property is deleted

```js
unset({a: 'b'}, 'a') // true
```

### Returns `true` when a property does not exist

This is consistent with `delete` behavior in that it does not
throw when a property does not exist.

```js
unset({a: {b: {c: 'd'}}}, 'd') // true
```

### delete nested values

```js
var one = {a: {b: {c: 'd'}}};
unset(one, 'a.b');
console.log(one);
//=> {a: {}}

var two = {a: {b: {c: 'd'}}};
unset(two, ['a', 'b', 'c']);
console.log(two);
//=> {a: {b: {}}}

var three = {a: {b: {c: 'd', e: 'f'}}};
unset(three, 'a.b.c');
console.log(three);
//=> {a: {b: {e: 'f'}}}
```

### throws on invalid args

```js
unset();
// 'expected an object.'
```

## About
<details>
  <summary><strong>Contributing</strong></summary>

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

</details>

<details>
  <summary><strong>Running Tests</strong></summary>

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

</details>

<details>
  <summary><strong>Building docs</strong></summary>

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

</details>

### Related projects

You might also be interested in these projects: 

- [get-value](https://www.npmjs.com/package/get-value): Use property paths like 'a.b.c' to get a nested value from an object. Even works… [more](https://github.com/jonschlinkert/get-value) | [homepage](https://github.com/jonschlinkert/get-value "Use property paths like 'a.b.c' to get a nested value from an object. Even works when keys have dots in them (no other dot-prop library can do this!).")
- [get-values](https://www.npmjs.com/package/get-values): Return an array of all values from the given object. | [homepage](https://github.com/jonschlinkert/get-values "Return an array of all values from the given object.")
- [omit-value](https://www.npmjs.com/package/omit-value): Omit properties from an object or deeply nested property of an object using object path… [more](https://github.com/jonschlinkert/omit-value) | [homepage](https://github.com/jonschlinkert/omit-value "Omit properties from an object or deeply nested property of an object using object path notation.")
- [put-value](https://www.npmjs.com/package/put-value): Update only existing values from an object, works with dot notation paths like `a.b.c` and… [more](https://github.com/tunnckocore/put-value#readme) | [homepage](https://github.com/tunnckocore/put-value#readme "Update only existing values from an object, works with dot notation paths like `a.b.c` and support deep nesting.")
- [set-value](https://www.npmjs.com/package/set-value): Create nested values and any intermediaries using dot notation (`'a.b.c'`) paths. | [homepage](https://github.com/jonschlinkert/set-value "Create nested values and any intermediaries using dot notation (`'a.b.c'`) paths.")
- [union-value](https://www.npmjs.com/package/union-value): Set an array of unique values as the property of an object. Supports setting deeply… [more](https://github.com/jonschlinkert/union-value) | [homepage](https://github.com/jonschlinkert/union-value "Set an array of unique values as the property of an object. Supports setting deeply nested properties using using object-paths/dot notation.")
- [upsert-value](https://www.npmjs.com/package/upsert-value): Update or set nested values and any intermediaries with dot notation (`'a.b.c'`) paths. | [homepage](https://github.com/doowb/upsert-value "Update or set nested values and any intermediaries with dot notation (`'a.b.c'`) paths.")  

### Contributors
| **Commits** | **Contributor** |  
| --- | --- |  
| 11 | [jonschlinkert](https://github.com/jonschlinkert) |  
| 4  | [danez](https://github.com/danez) |  
| 2  | [wtgtybhertgeghgtwtg](https://github.com/wtgtybhertgeghgtwtg) |  
| 1  | [TrySound](https://github.com/TrySound) |  
| 1  | [bluelovers](https://github.com/bluelovers) |  

### Author
**Jon Schlinkert**
+ [GitHub Profile](https://github.com/jonschlinkert)
+ [Twitter Profile](https://twitter.com/jonschlinkert)
+ [LinkedIn Profile](https://linkedin.com/in/jonschlinkert)

### License
Copyright © 2021, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.8.0, on March 18, 2021._

